/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.injected.editor;

import com.intellij.injected.editor.DocumentWindow;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.injected.editor.FoldingRegionWindow;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingGroup;
import com.intellij.openapi.editor.ex.FoldingListener;
import com.intellij.openapi.editor.ex.FoldingModelEx;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.TextRange;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class FoldingModelWindow
implements FoldingModelEx,
ModificationTracker {
    private final FoldingModelEx myDelegate;
    private final DocumentWindow myDocumentWindow;
    private final EditorWindow myEditorWindow;
    private static final Key<FoldingRegionWindow> FOLD_REGION_WINDOW = Key.create((String)"FOLD_REGION_WINDOW");

    FoldingModelWindow(@NotNull FoldingModelEx delegate, @NotNull DocumentWindow documentWindow, @NotNull EditorWindow editorWindow) {
        if (delegate == null) {
            FoldingModelWindow.$$$reportNull$$$0(0);
        }
        if (documentWindow == null) {
            FoldingModelWindow.$$$reportNull$$$0(1);
        }
        if (editorWindow == null) {
            FoldingModelWindow.$$$reportNull$$$0(2);
        }
        this.myDelegate = delegate;
        this.myDocumentWindow = documentWindow;
        this.myEditorWindow = editorWindow;
    }

    @Override
    public void setFoldingEnabled(boolean isEnabled) {
        this.myDelegate.setFoldingEnabled(isEnabled);
    }

    @Override
    public boolean isFoldingEnabled() {
        return this.myDelegate.isFoldingEnabled();
    }

    @Override
    public FoldRegion getFoldingPlaceholderAt(@NotNull Point p) {
        if (p == null) {
            FoldingModelWindow.$$$reportNull$$$0(3);
        }
        return this.myDelegate.getFoldingPlaceholderAt(p);
    }

    @Override
    public boolean intersectsRegion(int startOffset, int endOffset) {
        int hostStart = this.myDocumentWindow.injectedToHost(startOffset);
        int hostEnd = this.myDocumentWindow.injectedToHost(endOffset);
        return this.myDelegate.intersectsRegion(hostStart, hostEnd);
    }

    public FoldRegion addFoldRegion(int startOffset, int endOffset, @NotNull String placeholderText) {
        if (placeholderText == null) {
            FoldingModelWindow.$$$reportNull$$$0(4);
        }
        return this.createFoldRegion(startOffset, endOffset, placeholderText, null, false);
    }

    public void removeFoldRegion(@NotNull FoldRegion region) {
        if (region == null) {
            FoldingModelWindow.$$$reportNull$$$0(5);
        }
        this.myDelegate.removeFoldRegion((FoldRegion)((FoldingRegionWindow)region).getDelegate());
    }

    @NotNull
    public FoldRegion[] getAllFoldRegions() {
        FoldRegion[] all = this.myDelegate.getAllFoldRegions();
        ArrayList<FoldingRegionWindow> result2 = new ArrayList<FoldingRegionWindow>();
        for (FoldRegion region : all) {
            FoldingRegionWindow window = this.getWindowRegion(region);
            if (window == null) continue;
            result2.add(window);
        }
        FoldRegion[] foldRegionArray = result2.toArray(new FoldRegion[result2.size()]);
        if (foldRegionArray == null) {
            FoldingModelWindow.$$$reportNull$$$0(6);
        }
        return foldRegionArray;
    }

    public boolean isOffsetCollapsed(int offset) {
        return this.myDelegate.isOffsetCollapsed(this.myDocumentWindow.injectedToHost(offset));
    }

    public FoldRegion getCollapsedRegionAtOffset(int offset) {
        FoldRegion host = this.myDelegate.getCollapsedRegionAtOffset(this.myDocumentWindow.injectedToHost(offset));
        return host;
    }

    @Nullable
    public FoldRegion getFoldRegion(int startOffset, int endOffset) {
        TextRange range = new TextRange(startOffset, endOffset);
        TextRange hostRange = this.myDocumentWindow.injectedToHost(range);
        FoldRegion hostRegion = this.myDelegate.getFoldRegion(hostRange.getStartOffset(), hostRange.getEndOffset());
        return hostRegion == null ? null : this.getWindowRegion(hostRegion);
    }

    @Nullable
    private FoldingRegionWindow getWindowRegion(@NotNull FoldRegion hostRegion) {
        FoldingRegionWindow window;
        if (hostRegion == null) {
            FoldingModelWindow.$$$reportNull$$$0(7);
        }
        return (window = (FoldingRegionWindow)hostRegion.getUserData(FOLD_REGION_WINDOW)) != null && window.getEditor() == this.myEditorWindow ? window : null;
    }

    public void runBatchFoldingOperation(@NotNull Runnable operation) {
        if (operation == null) {
            FoldingModelWindow.$$$reportNull$$$0(8);
        }
        this.myDelegate.runBatchFoldingOperation(operation);
    }

    public void runBatchFoldingOperation(@NotNull Runnable operation, boolean moveCaretFromCollapsedRegion) {
        if (operation == null) {
            FoldingModelWindow.$$$reportNull$$$0(9);
        }
        this.myDelegate.runBatchFoldingOperation(operation, moveCaretFromCollapsedRegion);
    }

    public void runBatchFoldingOperationDoNotCollapseCaret(@NotNull Runnable operation) {
        if (operation == null) {
            FoldingModelWindow.$$$reportNull$$$0(10);
        }
        this.myDelegate.runBatchFoldingOperationDoNotCollapseCaret(operation);
    }

    @Override
    public int getLastCollapsedRegionBefore(int offset) {
        return -1;
    }

    @Override
    public TextAttributes getPlaceholderAttributes() {
        return this.myDelegate.getPlaceholderAttributes();
    }

    @Override
    public FoldRegion[] fetchTopLevel() {
        return FoldRegion.EMPTY_ARRAY;
    }

    @Override
    public FoldRegion createFoldRegion(int startOffset, int endOffset, @NotNull String placeholder, FoldingGroup group, boolean neverExpands) {
        TextRange hostRange;
        if (placeholder == null) {
            FoldingModelWindow.$$$reportNull$$$0(11);
        }
        if ((hostRange = this.myDocumentWindow.injectedToHost(new TextRange(startOffset, endOffset))).getLength() < 2) {
            return null;
        }
        FoldRegion hostRegion = this.myDelegate.createFoldRegion(hostRange.getStartOffset(), hostRange.getEndOffset(), placeholder, group, neverExpands);
        if (hostRegion == null) {
            return null;
        }
        int startShift = Math.max(0, this.myDocumentWindow.hostToInjected(hostRange.getStartOffset()) - startOffset);
        int endShift = Math.max(0, endOffset - this.myDocumentWindow.hostToInjected(hostRange.getEndOffset()) - startShift);
        FoldingRegionWindow window = new FoldingRegionWindow(this.myDocumentWindow, this.myEditorWindow, hostRegion, startShift, endShift);
        hostRegion.putUserData(FOLD_REGION_WINDOW, (Object)window);
        return window;
    }

    @Override
    public void addListener(@NotNull FoldingListener listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            FoldingModelWindow.$$$reportNull$$$0(12);
        }
        if (parentDisposable == null) {
            FoldingModelWindow.$$$reportNull$$$0(13);
        }
        this.myDelegate.addListener(listener2, parentDisposable);
    }

    @Override
    public void rebuild() {
        this.myDelegate.rebuild();
    }

    @Override
    @NotNull
    public List<FoldRegion> getGroupedRegions(FoldingGroup group) {
        List<FoldRegion> hostRegions = this.myDelegate.getGroupedRegions(group);
        ArrayList<FoldRegion> result2 = new ArrayList<FoldRegion>();
        for (FoldRegion hostRegion : hostRegions) {
            FoldingRegionWindow window = this.getWindowRegion(hostRegion);
            if (window == null) continue;
            result2.add(window);
        }
        ArrayList<FoldRegion> arrayList = result2;
        if (arrayList == null) {
            FoldingModelWindow.$$$reportNull$$$0(14);
        }
        return arrayList;
    }

    @Override
    public void clearDocumentRangesModificationStatus() {
    }

    @Override
    public boolean hasDocumentRegionChangedFor(@NotNull FoldRegion region) {
        if (region == null) {
            FoldingModelWindow.$$$reportNull$$$0(15);
        }
        return false;
    }

    @Override
    public void clearFoldRegions() {
        this.myDelegate.clearFoldRegions();
    }

    public long getModificationCount() {
        return this.myDelegate instanceof ModificationTracker ? ((ModificationTracker)this.myDelegate).getModificationCount() : 0L;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "documentWindow";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorWindow";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placeholderText";
                break;
            }
            case 5: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "region";
                break;
            }
            case 6: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/injected/editor/FoldingModelWindow";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostRegion";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operation";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placeholder";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/injected/editor/FoldingModelWindow";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllFoldRegions";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupedRegions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getFoldingPlaceholderAt";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addFoldRegion";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "removeFoldRegion";
                break;
            }
            case 6: 
            case 14: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getWindowRegion";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "runBatchFoldingOperation";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "runBatchFoldingOperationDoNotCollapseCaret";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createFoldRegion";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "hasDocumentRegionChangedFor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

