/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.impl;

import com.intellij.openapi.actionSystem.ex.ActionButtonLook;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JComponent;

public class IdeaActionButtonLook
extends ActionButtonLook {
    private static final Color POPPED_BG = new JBColor((Color)Gray.xE8, new Color(4606541));
    private static final Color PRESSED_BG = new JBColor((Color)Gray.xDB, new Color(0x55595C));
    private static final Color POPPED_BORDER = new JBColor((Color)Gray.xCC, new Color(7699328));
    private static final Color PRESSED_BORDER = new JBColor((Color)Gray.xC4, new Color(8028292));

    @Override
    public void paintBackground(Graphics g, JComponent component, int state2) {
        if (state2 != 0) {
            IdeaActionButtonLook.paintBackground(g, component.getSize(), state2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void paintBackground(Graphics g, Dimension size, int state2) {
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        try {
            if (UIUtil.isUnderAquaLookAndFeel() || UIUtil.isUnderDefaultMacTheme()) {
                g2.setColor((Color)(state2 == -1 ? Gray.xD7 : Gray.xE0));
            } else {
                g2.setColor(state2 == -1 ? PRESSED_BG : POPPED_BG);
            }
            g2.fill(IdeaActionButtonLook.getShape(size));
        }
        finally {
            g2.dispose();
        }
    }

    @Override
    public void paintBorder(Graphics g, JComponent component, int state2) {
        if (state2 != 0) {
            IdeaActionButtonLook.paintBorder(g, component.getSize(), state2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void paintBorder(Graphics g, Dimension size, int state2) {
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        try {
            if (UIUtil.isUnderAquaLookAndFeel() || UIUtil.isUnderDefaultMacTheme()) {
                g2.setColor((Color)(state2 == -1 ? Gray.xB8 : Gray.xCA));
            } else {
                g2.setColor(state2 == -1 ? PRESSED_BORDER : POPPED_BORDER);
            }
            g2.draw(IdeaActionButtonLook.getShape(size));
        }
        finally {
            g2.dispose();
        }
    }

    private static Shape getShape(Dimension size) {
        return new RoundRectangle2D.Double(1.0, 1.0, size.width - 3, size.height - 3, 4.0, 4.0);
    }
}

