/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.openapi.application.PermanentInstallationID;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.UUID;
import java.util.prefs.Preferences;
import org.jetbrains.annotations.NotNull;

public class PermanentInstallationIDImpl
extends PermanentInstallationID {
    private static final String OLD_USER_ON_MACHINE_ID_KEY = "JetBrains.UserIdOnMachine";
    private static final String INSTALLATION_ID_KEY = "user_id_on_machine";
    public static final String INSTALLATION_ID = PermanentInstallationIDImpl.calculateInstallationId();

    protected String calculateId() {
        return INSTALLATION_ID;
    }

    private static String calculateInstallationId() {
        File dir;
        String appdata;
        ApplicationInfoEx appInfo = ApplicationInfoImpl.getShadowInstance();
        Preferences oldPrefs = Preferences.userRoot();
        String oldValue = appInfo.isVendorJetBrains() ? oldPrefs.get(OLD_USER_ON_MACHINE_ID_KEY, null) : null;
        String companyName = appInfo.getShortCompanyName();
        Preferences prefs = Preferences.userRoot().node(StringUtil.isEmptyOrSpaces((String)companyName) ? "jetbrains" : companyName.toLowerCase(Locale.US));
        String installationId = prefs.get(INSTALLATION_ID_KEY, null);
        if (StringUtil.isEmptyOrSpaces((String)installationId)) {
            installationId = !StringUtil.isEmptyOrSpaces((String)oldValue) ? oldValue : UUID.randomUUID().toString();
            prefs.put(INSTALLATION_ID_KEY, installationId);
        }
        if (!appInfo.isVendorJetBrains()) {
            return installationId;
        }
        if (SystemInfo.isWindows && (appdata = System.getenv("APPDATA")) != null && ((dir = new File(appdata, "JetBrains")).exists() || dir.mkdirs())) {
            File permanentIdFile = new File(dir, "PermanentUserId");
            try {
                String fromFile = "";
                if (permanentIdFile.exists()) {
                    fromFile = PermanentInstallationIDImpl.loadFromFile(permanentIdFile).trim();
                }
                if (!fromFile.isEmpty()) {
                    if (!fromFile.equals(installationId)) {
                        installationId = fromFile;
                        prefs.put(INSTALLATION_ID_KEY, installationId);
                    }
                } else {
                    PermanentInstallationIDImpl.writeToFile(permanentIdFile, installationId);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (!installationId.equals(oldValue)) {
            oldPrefs.put(OLD_USER_ON_MACHINE_ID_KEY, installationId);
        }
        return installationId;
    }

    @NotNull
    private static String loadFromFile(@NotNull File file2) throws IOException {
        String string;
        if (file2 == null) {
            PermanentInstallationIDImpl.$$$reportNull$$$0(0);
        }
        try (FileInputStream is = new FileInputStream(file2);){
            byte[] bytes = FileUtilRt.loadBytes((InputStream)is);
            int offset = CharsetToolkit.hasUTF8Bom((byte[])bytes) ? CharsetToolkit.UTF8_BOM.length : 0;
            String string2 = new String(bytes, offset, bytes.length - offset, CharsetToolkit.UTF8_CHARSET);
            string = string2;
        }
        if (string == null) {
            PermanentInstallationIDImpl.$$$reportNull$$$0(1);
        }
        return string;
    }

    private static void writeToFile(@NotNull File file2, @NotNull String text) throws IOException {
        if (file2 == null) {
            PermanentInstallationIDImpl.$$$reportNull$$$0(2);
        }
        if (text == null) {
            PermanentInstallationIDImpl.$$$reportNull$$$0(3);
        }
        try (DataOutputStream stream = new DataOutputStream(new FileOutputStream(file2));){
            stream.write(text.getBytes(CharsetToolkit.UTF8_CHARSET));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/application/PermanentInstallationIDImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/application/PermanentInstallationIDImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "loadFromFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadFromFile";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "writeToFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

