/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.patch.apply;

import com.intellij.openapi.diff.impl.patch.ApplyPatchStatus;
import com.intellij.openapi.diff.impl.patch.apply.ApplyFilePatch;
import com.intellij.openapi.diff.impl.patch.apply.ApplyFilePatchBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchForBaseRevisionTexts;
import com.intellij.openapi.vcs.changes.shelf.ShelvedBinaryContentRevision;
import com.intellij.openapi.vcs.changes.shelf.ShelvedBinaryFilePatch;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import java.io.IOException;

public class ApplyBinaryShelvedFilePatch
extends ApplyFilePatchBase<ShelvedBinaryFilePatch> {
    public ApplyBinaryShelvedFilePatch(ShelvedBinaryFilePatch patch) {
        super(patch);
    }

    @Override
    protected void applyCreate(Project project, VirtualFile newFile, CommitContext commitContext) throws IOException {
        this.applyChange(project, newFile, null, null);
    }

    @Override
    protected ApplyFilePatch.Result applyChange(Project project, VirtualFile fileToPatch, FilePath pathBeforeRename, Getter<CharSequence> baseContents) throws IOException {
        try {
            ContentRevision contentRevision = ((ShelvedBinaryFilePatch)this.myPatch).getShelvedBinaryFile().createChange(project).getAfterRevision();
            if (contentRevision != null) {
                assert (contentRevision instanceof ShelvedBinaryContentRevision);
                byte[] binaryContent = ((ShelvedBinaryContentRevision)contentRevision).getBinaryContent();
                fileToPatch.setBinaryContent(binaryContent != null ? binaryContent : ArrayUtil.EMPTY_BYTE_ARRAY);
            }
        }
        catch (VcsException e) {
            LOG.error("Couldn't apply shelved binary patch", (Throwable)e);
            return new ApplyFilePatch.Result(ApplyPatchStatus.FAILURE){

                @Override
                public ApplyPatchForBaseRevisionTexts getMergeData() {
                    return null;
                }
            };
        }
        return SUCCESS;
    }
}

