/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.binding;

import com.intellij.openapi.options.binding.ControlValueAccessor;
import com.intellij.ui.DocumentAdapter;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public abstract class ValueAccessor<V> {
    public abstract V getValue();

    public abstract void setValue(V var1);

    public abstract Class<V> getType();

    public static ControlValueAccessor textFieldAccessor(final JTextField from) {
        return new ControlValueAccessor<String>(){

            @Override
            public String getValue() {
                return from.getText();
            }

            @Override
            public void setValue(String value) {
                from.setText(value);
            }

            @Override
            public Class<String> getType() {
                return String.class;
            }

            @Override
            public boolean isEnabled() {
                return from.isEnabled();
            }

            @Override
            public void addChangeListener(final Runnable listener2) {
                from.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                    protected void textChanged(DocumentEvent e) {
                        listener2.run();
                    }
                });
            }
        };
    }

    public static ControlValueAccessor checkBoxAccessor(final JCheckBox from) {
        return new ControlValueAccessor<Boolean>(){

            @Override
            public Boolean getValue() {
                return from.isSelected();
            }

            @Override
            public void setValue(Boolean value) {
                from.setSelected(value);
            }

            @Override
            public Class<Boolean> getType() {
                return Boolean.class;
            }

            @Override
            public boolean isEnabled() {
                return from.isEnabled();
            }

            @Override
            public void addChangeListener(final Runnable listener2) {
                from.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        listener2.run();
                    }
                });
            }
        };
    }
}

