/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project;

import com.intellij.ide.caches.FileContent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.vfs.InvalidVirtualFileAccessException;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.Deque;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileContentQueue {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.startup.FileContentQueue");
    private static final long MAX_SIZE_OF_BYTES_IN_QUEUE = 0x100000L;
    private static final long PROCESSED_FILE_BYTES_THRESHOLD = 0x300000L;
    private static final long LARGE_SIZE_REQUEST_THRESHOLD = 2838528L;
    private static final ExecutorService ourExecutor = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"FileContentQueue pool", (int)1);
    private final LinkedBlockingDeque<FileContent> myLoadedContents;
    private final AtomicInteger myContentsToLoad;
    private final AtomicLong myLoadedBytesInQueue;
    private static final Object ourProceedWithLoadingLock = new Object();
    private volatile long myBytesBeingProcessed;
    private volatile boolean myLargeSizeRequested;
    private final Object myProceedWithProcessingLock;
    private final BlockingQueue<VirtualFile> myFilesQueue;
    private final ProgressIndicator myProgressIndicator;
    private static final Deque<FileContentQueue> ourContentLoadingQueues = new LinkedBlockingDeque<FileContentQueue>();

    public FileContentQueue(@NotNull Collection<VirtualFile> files, @NotNull ProgressIndicator indicator) {
        if (files == null) {
            FileContentQueue.$$$reportNull$$$0(0);
        }
        if (indicator == null) {
            FileContentQueue.$$$reportNull$$$0(1);
        }
        this.myLoadedContents = new LinkedBlockingDeque();
        this.myContentsToLoad = new AtomicInteger();
        this.myLoadedBytesInQueue = new AtomicLong();
        this.myProceedWithProcessingLock = new Object();
        int numberOfFiles = files.size();
        this.myContentsToLoad.set(numberOfFiles);
        this.myFilesQueue = numberOfFiles > 0 ? new ArrayBlockingQueue<VirtualFile>(numberOfFiles, false, files) : null;
        this.myProgressIndicator = indicator;
    }

    public void startLoading() {
        if (this.myContentsToLoad.get() == 0) {
            return;
        }
        ourContentLoadingQueues.addLast(this);
        Runnable task2 = () -> {
            FileContentQueue contentQueue = ourContentLoadingQueues.pollFirst();
            while (contentQueue != null) {
                PreloadState preloadState = contentQueue.preloadNextContent();
                if (preloadState == PreloadState.PRELOADED_SUCCESSFULLY || preloadState == PreloadState.TOO_MUCH_DATA_PRELOADED) {
                    ourContentLoadingQueues.addLast(contentQueue);
                }
                contentQueue = ourContentLoadingQueues.pollFirst();
            }
        };
        ourExecutor.submit(task2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PreloadState preloadNextContent() {
        block7: {
            try {
                if (this.myLoadedBytesInQueue.get() <= 0x100000L) break block7;
                Object object = ourProceedWithLoadingLock;
                synchronized (object) {
                    ourProceedWithLoadingLock.wait(300L);
                }
                this.myProgressIndicator.checkCanceled();
                return PreloadState.TOO_MUCH_DATA_PRELOADED;
            }
            catch (InterruptedException e) {
                LOG.error((Throwable)e);
            }
            catch (ProcessCanceledException pce) {
                return PreloadState.CANCELLED_OR_FINISHED;
            }
        }
        if (this.myProgressIndicator.isCanceled()) {
            return PreloadState.CANCELLED_OR_FINISHED;
        }
        return this.loadNextContent() ? PreloadState.PRELOADED_SUCCESSFULLY : PreloadState.CANCELLED_OR_FINISHED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadNextContent() {
        VirtualFile file2 = (VirtualFile)this.myFilesQueue.poll();
        if (file2 == null) {
            return false;
        }
        try {
            FileContent content = new FileContent(file2);
            if (!FileContentQueue.isValidFile(file2) || !this.doLoadContent(content)) {
                content.setEmptyContent();
            }
            this.myLoadedContents.offer(content);
            boolean bl = true;
            return bl;
        }
        finally {
            this.myContentsToLoad.addAndGet(-1);
        }
    }

    private static boolean isValidFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileContentQueue.$$$reportNull$$$0(2);
        }
        return file2.isValid() && !file2.isDirectory() && !file2.is(VFileProperty.SPECIAL) && !VfsUtilCore.isBrokenLink((VirtualFile)file2);
    }

    private boolean doLoadContent(@NotNull FileContent content) {
        if (content == null) {
            FileContentQueue.$$$reportNull$$$0(3);
        }
        long contentLength = content.getLength();
        try {
            this.myLoadedBytesInQueue.addAndGet(contentLength);
            content.getBytes();
            return true;
        }
        catch (Throwable e) {
            this.myLoadedBytesInQueue.addAndGet(-contentLength);
            if (e instanceof IOException || e instanceof InvalidVirtualFileAccessException) {
                if (e instanceof FileNotFoundException) {
                    LOG.debug(e);
                } else {
                    LOG.info(e);
                }
            } else {
                LOG.error(e);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public FileContent take(@NotNull ProgressIndicator indicator) throws ProcessCanceledException {
        FileContent content;
        if (indicator == null) {
            FileContentQueue.$$$reportNull$$$0(4);
        }
        if ((content = this.doTake(indicator)) == null) {
            return null;
        }
        long length = content.getLength();
        while (true) {
            try {
                indicator.checkCanceled();
            }
            catch (ProcessCanceledException e) {
                this.pushBack(content);
                throw e;
            }
            Object object = this.myProceedWithProcessingLock;
            synchronized (object) {
                boolean requestingLargeSize;
                boolean bl = requestingLargeSize = length > 2838528L;
                if (requestingLargeSize) {
                    this.myLargeSizeRequested = true;
                }
                try {
                    if ((!this.myLargeSizeRequested || requestingLargeSize) && this.myBytesBeingProcessed + length <= Math.max(0x300000L, length)) {
                        this.myBytesBeingProcessed += length;
                        if (requestingLargeSize) {
                            this.myLargeSizeRequested = false;
                        }
                        return content;
                    }
                    this.myProceedWithProcessingLock.wait(300L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private FileContent doTake(ProgressIndicator indicator) {
        FileContent result2 = null;
        while (result2 == null) {
            indicator.checkCanceled();
            int remainingContentsToLoad = this.myContentsToLoad.get();
            result2 = this.myLoadedContents.poll();
            if (result2 != null) continue;
            if (remainingContentsToLoad == 0) {
                return null;
            }
            if (this.loadNextContent()) continue;
            TimeoutUtil.sleep((long)50L);
        }
        long loadedBytesInQueueNow = this.myLoadedBytesInQueue.addAndGet(-result2.getLength());
        if (loadedBytesInQueueNow < 0x100000L) {
            Object object = ourProceedWithLoadingLock;
            synchronized (object) {
                ourProceedWithLoadingLock.notifyAll();
            }
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(@NotNull FileContent content) {
        if (content == null) {
            FileContentQueue.$$$reportNull$$$0(5);
        }
        Object object = this.myProceedWithProcessingLock;
        synchronized (object) {
            this.myBytesBeingProcessed -= content.getLength();
            this.myProceedWithProcessingLock.notifyAll();
        }
    }

    public void pushBack(@NotNull FileContent content) {
        if (content == null) {
            FileContentQueue.$$$reportNull$$$0(6);
        }
        this.myLoadedBytesInQueue.addAndGet(content.getLength());
        this.myLoadedContents.addFirst(content);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/project/FileContentQueue";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isValidFile";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "doLoadContent";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "take";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "release";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "pushBack";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static enum PreloadState {
        TOO_MUCH_DATA_PRELOADED,
        PRELOADED_SUCCESSFULLY,
        CANCELLED_OR_FINISHED;

    }
}

