/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.ui.configuration.ContentRootPanel;
import com.intellij.openapi.roots.ui.configuration.ModuleSourceRootEditHandler;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.roots.IconActionComponent;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;
import org.jetbrains.jps.model.java.JavaSourceRootProperties;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public abstract class JavaSourceRootEditHandlerBase
extends ModuleSourceRootEditHandler<JavaSourceRootProperties> {
    public JavaSourceRootEditHandlerBase(JpsModuleSourceRootType<JavaSourceRootProperties> rootType) {
        super(rootType);
    }

    @Override
    @NotNull
    public Icon getRootIcon(@NotNull JavaSourceRootProperties properties) {
        if (properties == null) {
            JavaSourceRootEditHandlerBase.$$$reportNull$$$0(0);
        }
        Icon icon = properties.isForGeneratedSources() ? this.getGeneratedRootIcon() : this.getRootIcon();
        if (icon == null) {
            JavaSourceRootEditHandlerBase.$$$reportNull$$$0(1);
        }
        return icon;
    }

    @NotNull
    protected abstract Icon getGeneratedRootIcon();

    @Override
    @Nullable
    public String getPropertiesString(@NotNull JavaSourceRootProperties properties) {
        String packagePrefix;
        if (properties == null) {
            JavaSourceRootEditHandlerBase.$$$reportNull$$$0(2);
        }
        StringBuilder buffer = new StringBuilder();
        if (properties.isForGeneratedSources()) {
            buffer.append(" [generated]");
        }
        if (!(packagePrefix = properties.getPackagePrefix()).isEmpty()) {
            buffer.append(" (").append(packagePrefix).append(")");
        }
        return buffer.length() > 0 ? buffer.toString() : null;
    }

    @Override
    @Nullable
    public JComponent createPropertiesEditor(@NotNull SourceFolder folder, @NotNull JComponent parentComponent, @NotNull ContentRootPanel.ActionCallback callback) {
        if (folder == null) {
            JavaSourceRootEditHandlerBase.$$$reportNull$$$0(3);
        }
        if (parentComponent == null) {
            JavaSourceRootEditHandlerBase.$$$reportNull$$$0(4);
        }
        if (callback == null) {
            JavaSourceRootEditHandlerBase.$$$reportNull$$$0(5);
        }
        IconActionComponent iconComponent = new IconActionComponent(AllIcons.Modules.SetPackagePrefix, AllIcons.Modules.SetPackagePrefixRollover, ProjectBundle.message((String)"module.paths.edit.properties.tooltip", (Object[])new Object[0]), () -> {
            if (folder == null) {
                JavaSourceRootEditHandlerBase.$$$reportNull$$$0(6);
            }
            if (parentComponent == null) {
                JavaSourceRootEditHandlerBase.$$$reportNull$$$0(7);
            }
            if (callback == null) {
                JavaSourceRootEditHandlerBase.$$$reportNull$$$0(8);
            }
            JavaSourceRootProperties properties = (JavaSourceRootProperties)folder.getJpsElement().getProperties(JavaModuleSourceRootTypes.SOURCES);
            assert (properties != null);
            SourceRootPropertiesDialog dialog2 = new SourceRootPropertiesDialog(parentComponent, properties);
            if (dialog2.showAndGet()) {
                callback.onSourceRootPropertiesChanged(folder);
            }
        });
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.setOpaque(false);
        panel2.add((Component)iconComponent, "Center");
        panel2.add(Box.createHorizontalStrut(3), "East");
        return panel2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/JavaSourceRootEditHandlerBase";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folder";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentComponent";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/JavaSourceRootEditHandlerBase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getRootIcon";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPropertiesString";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createPropertiesEditor";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createPropertiesEditor$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class SourceRootPropertiesDialog
    extends DialogWrapper {
        private final JTextField myPackagePrefixField;
        private final JCheckBox myIsGeneratedCheckBox;
        private final JPanel myMainPanel;
        @NotNull
        private final JavaSourceRootProperties myProperties;

        private SourceRootPropertiesDialog(@NotNull JComponent parentComponent, @NotNull JavaSourceRootProperties properties) {
            if (parentComponent == null) {
                SourceRootPropertiesDialog.$$$reportNull$$$0(0);
            }
            if (properties == null) {
                SourceRootPropertiesDialog.$$$reportNull$$$0(1);
            }
            super((Component)parentComponent, true);
            this.myProperties = properties;
            this.setTitle(ProjectBundle.message((String)"module.paths.edit.properties.title", (Object[])new Object[0]));
            this.myPackagePrefixField = new JTextField();
            this.myIsGeneratedCheckBox = new JCheckBox(UIUtil.replaceMnemonicAmpersand((String)"For &generated sources"));
            this.myMainPanel = FormBuilder.createFormBuilder().addLabeledComponent("Package &prefix:", (JComponent)this.myPackagePrefixField).addComponent((JComponent)this.myIsGeneratedCheckBox).getPanel();
            this.myPackagePrefixField.setText(this.myProperties.getPackagePrefix());
            this.myPackagePrefixField.setColumns(25);
            this.myIsGeneratedCheckBox.setSelected(this.myProperties.isForGeneratedSources());
            this.init();
        }

        @Nullable
        public JComponent getPreferredFocusedComponent() {
            return this.myPackagePrefixField;
        }

        protected void doOKAction() {
            this.myProperties.setPackagePrefix(this.myPackagePrefixField.getText().trim());
            this.myProperties.setForGeneratedSources(this.myIsGeneratedCheckBox.isSelected());
            super.doOKAction();
        }

        @Nullable
        protected JComponent createCenterPanel() {
            return this.myMainPanel;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parentComponent";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "properties";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/roots/ui/configuration/JavaSourceRootEditHandlerBase$SourceRootPropertiesDialog";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

