/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.InstalledPluginsState;
import com.intellij.ide.plugins.PluginInstaller;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.startup.StartupActionScriptManager;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.PermanentInstallationIDImpl;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.io.ZipUtil;
import com.intellij.util.text.VersionComparatorUtil;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.http.client.utils.URIBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PluginDownloader {
    private static final Logger LOG = Logger.getInstance(PluginDownloader.class);
    private static final String FILENAME = "filename=";
    private final String myPluginId;
    private final String myPluginUrl;
    private final String myPluginName;
    private String myPluginVersion;
    private BuildNumber myBuildNumber;
    private File myFile;
    private File myOldFile;
    private String myDescription;
    private List<PluginId> myDepends;
    private IdeaPluginDescriptor myDescriptor;
    private final boolean myForceHttps;

    private PluginDownloader(@NotNull String pluginId, @NotNull String pluginUrl, @Nullable String pluginName, @Nullable String pluginVersion, @Nullable BuildNumber buildNumber, boolean forceHttps) {
        if (pluginId == null) {
            PluginDownloader.$$$reportNull$$$0(0);
        }
        if (pluginUrl == null) {
            PluginDownloader.$$$reportNull$$$0(1);
        }
        this.myPluginId = pluginId;
        this.myPluginUrl = pluginUrl;
        this.myPluginVersion = pluginVersion;
        this.myPluginName = pluginName;
        this.myBuildNumber = buildNumber;
        this.myForceHttps = forceHttps;
    }

    public String getPluginId() {
        return this.myPluginId;
    }

    public String getPluginVersion() {
        return this.myPluginVersion;
    }

    public String getPluginName() {
        return this.myPluginName != null ? this.myPluginName : this.myPluginId;
    }

    public BuildNumber getBuildNumber() {
        return this.myBuildNumber;
    }

    public String getDescription() {
        return this.myDescription;
    }

    public void setDescription(String description) {
        this.myDescription = description;
    }

    public List<PluginId> getDepends() {
        return this.myDepends;
    }

    public void setDepends(List<PluginId> depends) {
        this.myDepends = depends;
    }

    public IdeaPluginDescriptor getDescriptor() {
        return this.myDescriptor;
    }

    public void setDescriptor(IdeaPluginDescriptor descriptor2) {
        this.myDescriptor = descriptor2;
    }

    public boolean prepareToInstall(@NotNull ProgressIndicator indicator) throws IOException {
        if (indicator == null) {
            PluginDownloader.$$$reportNull$$$0(2);
        }
        if (this.myFile != null) {
            return true;
        }
        IdeaPluginDescriptor descriptor2 = null;
        if (!Boolean.getBoolean("StartupWizardMode") && PluginManager.isPluginInstalled(PluginId.getId((String)this.myPluginId))) {
            descriptor2 = PluginManager.getPlugin(PluginId.getId((String)this.myPluginId));
            LOG.assertTrue(descriptor2 != null);
            if (this.myPluginVersion != null && PluginDownloader.compareVersionsSkipBrokenAndIncompatible(descriptor2, this.myPluginVersion) <= 0) {
                LOG.info("Plugin " + this.myPluginId + ": current version (max) " + this.myPluginVersion);
                return false;
            }
            this.myOldFile = descriptor2.isBundled() ? null : descriptor2.getPath();
        }
        String errorMessage = IdeBundle.message((String)"unknown.error", (Object[])new Object[0]);
        try {
            this.myFile = this.downloadPlugin(indicator);
        }
        catch (IOException ex) {
            this.myFile = null;
            LOG.warn((Throwable)ex);
            errorMessage = ex.getMessage();
        }
        if (this.myFile == null) {
            if (ApplicationManager.getApplication() != null) {
                String text = IdeBundle.message((String)"error.plugin.was.not.installed", (Object[])new Object[]{this.getPluginName(), errorMessage});
                String title = IdeBundle.message((String)"title.failed.to.download", (Object[])new Object[0]);
                ApplicationManager.getApplication().invokeLater(() -> Messages.showErrorDialog((String)text, (String)title));
            }
            return false;
        }
        IdeaPluginDescriptorImpl actualDescriptor = PluginDownloader.loadDescriptionFromJar(this.myFile);
        if (actualDescriptor != null) {
            InstalledPluginsState state2 = InstalledPluginsState.getInstanceIfLoaded();
            if (state2 != null && state2.wasUpdated(actualDescriptor.getPluginId())) {
                return false;
            }
            this.myPluginVersion = actualDescriptor.getVersion();
            if (descriptor2 != null && PluginDownloader.compareVersionsSkipBrokenAndIncompatible(descriptor2, this.myPluginVersion) <= 0) {
                LOG.info("Plugin " + this.myPluginId + ": current version (max) " + this.myPluginVersion);
                return false;
            }
            this.setDescriptor(actualDescriptor);
            if (PluginManagerCore.isIncompatible(actualDescriptor, this.myBuildNumber)) {
                LOG.info("Plugin " + this.myPluginId + " is incompatible with current installation (since:" + actualDescriptor.getSinceBuild() + " until:" + actualDescriptor.getUntilBuild() + ")");
                return false;
            }
        }
        return true;
    }

    public static int compareVersionsSkipBrokenAndIncompatible(@NotNull IdeaPluginDescriptor existingPlugin, String newPluginVersion) {
        int state2;
        if (existingPlugin == null) {
            PluginDownloader.$$$reportNull$$$0(3);
        }
        if ((state2 = PluginDownloader.comparePluginVersions(newPluginVersion, existingPlugin.getVersion())) < 0 && (PluginManagerCore.isBrokenPlugin(existingPlugin) || PluginManagerCore.isIncompatible(existingPlugin))) {
            state2 = 1;
        }
        return state2;
    }

    public static int comparePluginVersions(String newPluginVersion, String oldPluginVersion) {
        return VersionComparatorUtil.compare((String)newPluginVersion, (String)oldPluginVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static IdeaPluginDescriptorImpl loadDescriptionFromJar(File file2) throws IOException {
        IdeaPluginDescriptorImpl descriptor2 = PluginManagerCore.loadDescriptor(file2, "plugin.xml");
        if (descriptor2 == null && file2.getName().endsWith(".zip")) {
            File outputDir = FileUtil.createTempDirectory((String)"plugin", (String)"");
            try {
                ZipUtil.extract((File)file2, (File)outputDir, null);
                File[] files = outputDir.listFiles();
                if (files != null && files.length == 1) {
                    descriptor2 = PluginManagerCore.loadDescriptor(files[0], "plugin.xml");
                }
            }
            finally {
                FileUtil.delete((File)outputDir);
            }
        }
        return descriptor2;
    }

    public void install() throws IOException {
        LOG.assertTrue(this.myFile != null, (Object)("Cannot install plugin '" + this.getPluginName() + "'"));
        if (this.myFile == null) {
            throw new IOException("Cannot find file for plugin '" + this.getPluginName() + "'");
        }
        if (this.myOldFile != null) {
            StartupActionScriptManager.DeleteCommand deleteOld = new StartupActionScriptManager.DeleteCommand(this.myOldFile);
            StartupActionScriptManager.addActionCommand((StartupActionScriptManager.ActionCommand)deleteOld);
        }
        PluginInstaller.install(this.myFile, this.getPluginName(), true, this.myDescriptor);
        InstalledPluginsState state2 = InstalledPluginsState.getInstanceIfLoaded();
        if (state2 != null) {
            state2.onPluginInstall(this.myDescriptor);
        }
    }

    @NotNull
    private File downloadPlugin(final @NotNull ProgressIndicator indicator) throws IOException {
        File pluginsTemp;
        if (indicator == null) {
            PluginDownloader.$$$reportNull$$$0(4);
        }
        if (!(pluginsTemp = new File(PathManager.getPluginTempPath())).exists() && !pluginsTemp.mkdirs()) {
            throw new IOException(IdeBundle.message((String)"error.cannot.create.temp.dir", (Object[])new Object[]{pluginsTemp}));
        }
        final File file2 = FileUtil.createTempFile((File)pluginsTemp, (String)"plugin_", (String)"_download", (boolean)true, (boolean)false);
        indicator.checkCanceled();
        indicator.setText2(IdeBundle.message((String)"progress.downloading.plugin", (Object[])new Object[]{this.getPluginName()}));
        File file3 = (File)HttpRequests.request((String)this.myPluginUrl).gzip(false).forceHttps(this.myForceHttps).productNameAsUserAgent().connect((HttpRequests.RequestProcessor)new HttpRequests.RequestProcessor<File>(){

            public File process(@NotNull HttpRequests.Request request) throws IOException {
                if (request == null) {
                    1.$$$reportNull$$$0(0);
                }
                request.saveToFile(file2, indicator);
                String fileName = PluginDownloader.this.guessFileName(request.getConnection(), file2);
                File newFile = new File(file2.getParentFile(), fileName);
                FileUtil.rename((File)file2, (File)newFile);
                return newFile;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/openapi/updateSettings/impl/PluginDownloader$1", "process"));
            }
        });
        if (file3 == null) {
            PluginDownloader.$$$reportNull$$$0(5);
        }
        return file3;
    }

    @NotNull
    private String guessFileName(@NotNull URLConnection connection, @NotNull File file2) throws IOException {
        if (connection == null) {
            PluginDownloader.$$$reportNull$$$0(6);
        }
        if (file2 == null) {
            PluginDownloader.$$$reportNull$$$0(7);
        }
        String fileName = null;
        String contentDisposition = connection.getHeaderField("Content-Disposition");
        LOG.debug("header: " + contentDisposition);
        if (contentDisposition != null && contentDisposition.contains(FILENAME)) {
            int startIdx = contentDisposition.indexOf(FILENAME);
            int endIdx = contentDisposition.indexOf(59, startIdx);
            fileName = contentDisposition.substring(startIdx + FILENAME.length(), endIdx > 0 ? endIdx : contentDisposition.length());
            if (StringUtil.startsWithChar((CharSequence)fileName, (char)'\"') && StringUtil.endsWithChar((CharSequence)fileName, (char)'\"')) {
                fileName = fileName.substring(1, fileName.length() - 1);
            }
        }
        if (fileName == null) {
            String usedURL = connection.getURL().toString();
            LOG.debug("url: " + usedURL);
            fileName = usedURL.substring(usedURL.lastIndexOf(47) + 1);
            if (fileName.length() == 0 || fileName.contains("?")) {
                fileName = this.myPluginUrl.substring(this.myPluginUrl.lastIndexOf(47) + 1);
            }
        }
        if (!PathUtil.isValidFileName(fileName)) {
            LOG.debug("fileName: " + fileName);
            FileUtil.delete((File)file2);
            throw new IOException("Invalid filename returned by a server");
        }
        String string = fileName;
        if (string == null) {
            PluginDownloader.$$$reportNull$$$0(8);
        }
        return string;
    }

    public static PluginDownloader createDownloader(@NotNull IdeaPluginDescriptor descriptor2) throws IOException {
        if (descriptor2 == null) {
            PluginDownloader.$$$reportNull$$$0(9);
        }
        return PluginDownloader.createDownloader(descriptor2, null, null);
    }

    @NotNull
    public static PluginDownloader createDownloader(@NotNull IdeaPluginDescriptor descriptor2, @Nullable String host, @Nullable BuildNumber buildNumber) throws IOException {
        if (descriptor2 == null) {
            PluginDownloader.$$$reportNull$$$0(10);
        }
        boolean forceHttps = host == null && (ApplicationManager.getApplication() == null || UpdateSettings.getInstance().canUseSecureConnection());
        PluginDownloader pluginDownloader = PluginDownloader.createDownloader(descriptor2, host, buildNumber, forceHttps);
        if (pluginDownloader == null) {
            PluginDownloader.$$$reportNull$$$0(11);
        }
        return pluginDownloader;
    }

    @NotNull
    public static PluginDownloader createDownloader(@NotNull IdeaPluginDescriptor descriptor2, @Nullable String host, @Nullable BuildNumber buildNumber, boolean forceHttps) throws IOException {
        PluginDownloader pluginDownloader;
        if (descriptor2 == null) {
            PluginDownloader.$$$reportNull$$$0(12);
        }
        try {
            String url = PluginDownloader.getUrl(descriptor2, host, buildNumber);
            String id = descriptor2.getPluginId().getIdString();
            PluginDownloader downloader = new PluginDownloader(id, url, descriptor2.getName(), descriptor2.getVersion(), buildNumber, forceHttps);
            downloader.setDescriptor(descriptor2);
            downloader.setDescription(descriptor2.getDescription());
            List<PluginId> depends = descriptor2 instanceof PluginNode ? ((PluginNode)descriptor2).getDepends() : new ArrayList<PluginId>(Arrays.asList(descriptor2.getDependentPluginIds()));
            downloader.setDepends(depends);
            pluginDownloader = downloader;
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
        if (pluginDownloader == null) {
            PluginDownloader.$$$reportNull$$$0(13);
        }
        return pluginDownloader;
    }

    @NotNull
    private static String getUrl(@NotNull IdeaPluginDescriptor descriptor2, @Nullable String host, @Nullable BuildNumber buildNumber) throws URISyntaxException, MalformedURLException {
        if (descriptor2 == null) {
            PluginDownloader.$$$reportNull$$$0(14);
        }
        if (host != null && descriptor2 instanceof PluginNode) {
            String url = ((PluginNode)descriptor2).getDownloadUrl();
            String string = new URI(url).isAbsolute() ? url : new URL(new URL(host), url).toExternalForm();
            if (string == null) {
                PluginDownloader.$$$reportNull$$$0(15);
            }
            return string;
        }
        Application app = ApplicationManager.getApplication();
        ApplicationInfoEx appInfo = ApplicationInfoImpl.getShadowInstance();
        String buildNumberAsString = buildNumber != null ? buildNumber.asString() : (app != null ? ApplicationInfo.getInstance().getApiVersion() : appInfo.getBuild().asString());
        URIBuilder uriBuilder = new URIBuilder(appInfo.getPluginsDownloadUrl());
        uriBuilder.addParameter("action", "download");
        uriBuilder.addParameter("id", descriptor2.getPluginId().getIdString());
        uriBuilder.addParameter("build", buildNumberAsString);
        uriBuilder.addParameter("uuid", PermanentInstallationIDImpl.INSTALLATION_ID);
        String string = uriBuilder.build().toString();
        if (string == null) {
            PluginDownloader.$$$reportNull$$$0(16);
        }
        return string;
    }

    @Nullable
    public static PluginNode createPluginNode(@Nullable String host, @NotNull PluginDownloader downloader) {
        IdeaPluginDescriptor descriptor2;
        if (downloader == null) {
            PluginDownloader.$$$reportNull$$$0(17);
        }
        if ((descriptor2 = downloader.getDescriptor()) instanceof PluginNode) {
            return (PluginNode)descriptor2;
        }
        PluginNode node = new PluginNode(PluginId.getId((String)downloader.getPluginId()));
        node.setName(downloader.getPluginName());
        node.setVersion(downloader.getPluginVersion());
        node.setRepositoryName(host);
        node.setDownloadUrl(downloader.myPluginUrl);
        node.setDepends(downloader.getDepends(), null);
        node.setDescription(downloader.getDescription());
        return node;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 8: 
            case 11: 
            case 13: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 8: 
            case 11: 
            case 13: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginUrl";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existingPlugin";
                break;
            }
            case 5: 
            case 8: 
            case 11: 
            case 13: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/updateSettings/impl/PluginDownloader";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: 
            case 10: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "downloader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/updateSettings/impl/PluginDownloader";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "downloadPlugin";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "guessFileName";
                break;
            }
            case 11: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createDownloader";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "prepareToInstall";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "compareVersionsSkipBrokenAndIncompatible";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "downloadPlugin";
                break;
            }
            case 5: 
            case 8: 
            case 11: 
            case 13: 
            case 15: 
            case 16: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "guessFileName";
                break;
            }
            case 9: 
            case 10: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createDownloader";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getUrl";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createPluginNode";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 8: 
            case 11: 
            case 13: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

