/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.icons.AllIcons;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.TreeExpander;
import com.intellij.ide.util.treeView.TreeState;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.ChangeListAdapter;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesListView;
import com.intellij.openapi.vcs.changes.ui.TreeModelBuilder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.EditSourceOnEnterKeyHandler;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import java.util.stream.Stream;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;

abstract class SpecificFilesViewDialog
extends DialogWrapper {
    protected JPanel myPanel;
    protected final ChangesListView myView;
    protected final ChangeListManager myChangeListManager;
    protected final Project myProject;

    protected SpecificFilesViewDialog(@NotNull Project project, @NotNull String title, final @NotNull DataKey<Stream<VirtualFile>> shownDataKey, @NotNull List<VirtualFile> initDataFiles) {
        if (project == null) {
            SpecificFilesViewDialog.$$$reportNull$$$0(0);
        }
        if (title == null) {
            SpecificFilesViewDialog.$$$reportNull$$$0(1);
        }
        if (shownDataKey == null) {
            SpecificFilesViewDialog.$$$reportNull$$$0(2);
        }
        if (initDataFiles == null) {
            SpecificFilesViewDialog.$$$reportNull$$$0(3);
        }
        super(project, true);
        this.setTitle(title);
        this.myProject = project;
        final Runnable closer = () -> this.close(0);
        this.myView = new ChangesListView(project){

            @Override
            public void calcData(DataKey key, DataSink sink) {
                super.calcData(key, sink);
                if (shownDataKey.is(key.getName())) {
                    sink.put(shownDataKey, this.getSelectedFiles());
                }
            }

            @Override
            protected void editSourceRegistration() {
                EditSourceOnDoubleClickHandler.install((JTree)((Object)this), (Runnable)closer);
                EditSourceOnEnterKeyHandler.install((JComponent)((Object)this), (Runnable)closer);
            }
        };
        this.myChangeListManager = ChangeListManager.getInstance((Project)project);
        this.createPanel();
        this.setOKButtonText("Close");
        this.init();
        this.initData(initDataFiles);
        this.myView.setMinimumSize((Dimension)new JBDimension(100, 100));
        ChangeListAdapter changeListListener = new ChangeListAdapter(){

            public void changeListUpdateDone() {
                SpecificFilesViewDialog.this.refreshView();
            }
        };
        ChangeListManager.getInstance((Project)this.myProject).addChangeListListener((ChangeListListener)changeListListener);
        Disposer.register((Disposable)this.myDisposable, () -> ChangeListManager.getInstance((Project)this.myProject).removeChangeListListener((ChangeListListener)changeListListener));
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{this.getOKAction()};
        if (actionArray == null) {
            SpecificFilesViewDialog.$$$reportNull$$$0(4);
        }
        return actionArray;
    }

    private void initData(@NotNull List<VirtualFile> files) {
        if (files == null) {
            SpecificFilesViewDialog.$$$reportNull$$$0(5);
        }
        TreeState state2 = TreeState.createOn((JTree)((Object)this.myView), (DefaultMutableTreeNode)((ChangesBrowserNode)this.myView.getModel().getRoot()));
        DefaultTreeModel model = TreeModelBuilder.buildFromVirtualFiles(this.myProject, this.myView.isShowFlatten(), files);
        this.myView.setModel(model);
        this.myView.expandPath(new TreePath(((ChangesBrowserNode)model.getRoot()).getPath()));
        state2.applyTo((JTree)((Object)this.myView));
    }

    private void createPanel() {
        this.myPanel = new JPanel(new BorderLayout());
        DefaultActionGroup group = new DefaultActionGroup();
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("SPECIFIC_FILES_DIALOG", (ActionGroup)group, true);
        this.addCustomActions(group);
        CommonActionsManager cam = CommonActionsManager.getInstance();
        Expander expander = new Expander();
        group.addSeparator();
        group.add((AnAction)new ToggleShowFlattenAction());
        group.add(cam.createExpandAllAction((TreeExpander)expander, (JComponent)((Object)this.myView)));
        group.add(cam.createCollapseAllAction((TreeExpander)expander, (JComponent)((Object)this.myView)));
        this.myPanel.add((Component)actionToolbar.getComponent(), "North");
        this.myPanel.add((Component)ScrollPaneFactory.createScrollPane((Component)((Object)this.myView)), "Center");
        this.myView.setShowFlatten(false);
    }

    protected void addCustomActions(@NotNull DefaultActionGroup group) {
        if (group == null) {
            SpecificFilesViewDialog.$$$reportNull$$$0(6);
        }
    }

    protected String getDimensionServiceKey() {
        return "com.intellij.openapi.vcs.changes.SpecificFilesViewDialog";
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myView;
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    protected void refreshView() {
        GuiUtils.invokeLaterIfNeeded(() -> {
            if (this.isVisible()) {
                this.initData(this.getFiles());
            }
        }, (ModalityState)ModalityState.stateForComponent((Component)((Object)this.myView)));
    }

    @NotNull
    protected abstract List<VirtualFile> getFiles();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shownDataKey";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initDataFiles";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/SpecificFilesViewDialog";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/SpecificFilesViewDialog";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "initData";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addCustomActions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public class ToggleShowFlattenAction
    extends ToggleAction
    implements DumbAware {
        public ToggleShowFlattenAction() {
            super(VcsBundle.message((String)"changes.action.show.directories.text", (Object[])new Object[0]), VcsBundle.message((String)"changes.action.show.directories.description", (Object[])new Object[0]), AllIcons.Actions.GroupByPackage);
        }

        public boolean isSelected(AnActionEvent e) {
            return !SpecificFilesViewDialog.this.myView.isShowFlatten();
        }

        public void setSelected(AnActionEvent e, boolean state2) {
            SpecificFilesViewDialog.this.myView.setShowFlatten(!state2);
            SpecificFilesViewDialog.this.refreshView();
        }
    }

    private class Expander
    implements TreeExpander {
        private Expander() {
        }

        public void expandAll() {
            TreeUtil.expandAll((JTree)((Object)SpecificFilesViewDialog.this.myView));
        }

        public boolean canExpand() {
            return !SpecificFilesViewDialog.this.myView.isShowFlatten();
        }

        public void collapseAll() {
            TreeUtil.collapseAll((JTree)((Object)SpecificFilesViewDialog.this.myView), (int)1);
            TreeUtil.expand((JTree)((Object)SpecificFilesViewDialog.this.myView), (int)0);
        }

        public boolean canCollapse() {
            return !SpecificFilesViewDialog.this.myView.isShowFlatten();
        }
    }
}

