/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.ui.ChangeListChooserPanel;
import com.intellij.util.NullableConsumer;
import java.util.Collection;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeListChooser
extends DialogWrapper {
    private final Project myProject;
    private LocalChangeList mySelectedList;
    private final ChangeListChooserPanel myPanel;

    public ChangeListChooser(@NotNull Project project, @NotNull Collection<? extends ChangeList> changelists, @Nullable ChangeList defaultSelection, String title, @Nullable String suggestedName) {
        if (project == null) {
            ChangeListChooser.$$$reportNull$$$0(0);
        }
        if (changelists == null) {
            ChangeListChooser.$$$reportNull$$$0(1);
        }
        super(project, false);
        this.myProject = project;
        this.myPanel = new ChangeListChooserPanel(this.myProject, new NullableConsumer<String>(){

            public void consume(@Nullable String errorMessage) {
                ChangeListChooser.this.setOKActionEnabled(errorMessage == null);
                ChangeListChooser.this.setErrorText(errorMessage, ChangeListChooser.this.myPanel);
            }
        });
        this.myPanel.init();
        this.myPanel.setChangeLists(changelists);
        this.myPanel.setDefaultSelection(defaultSelection);
        this.setTitle(title);
        if (suggestedName != null) {
            this.myPanel.setSuggestedName(suggestedName);
        }
        this.init();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myPanel.getPreferredFocusedComponent();
    }

    @Nullable
    protected String getHelpId() {
        return "reference.dialogs.vcs.changelist.chooser";
    }

    protected String getDimensionServiceKey() {
        return "VCS.ChangelistChooser";
    }

    protected void doOKAction() {
        this.mySelectedList = this.myPanel.getSelectedList(this.myProject);
        if (this.mySelectedList != null) {
            super.doOKAction();
        }
    }

    @Nullable
    public LocalChangeList getSelectedList() {
        return this.mySelectedList;
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "changelists";
                break;
            }
        }
        objectArray[1] = "com/intellij/openapi/vcs/changes/ui/ChangeListChooser";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

