/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.content;

import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.impl.content.ComboIcon;
import com.intellij.openapi.wm.impl.content.ContentTabLabel;
import com.intellij.openapi.wm.impl.content.SelectContentTabStep;
import com.intellij.openapi.wm.impl.content.TabContentLayout;
import com.intellij.reference.SoftReference;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.TabbedContent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import org.jetbrains.annotations.NotNull;

public class TabbedContentTabLabel
extends ContentTabLabel {
    private final ComboIcon myComboIcon;
    private final TabbedContent myContent;
    private Reference<JBPopup> myPopupReference;

    public TabbedContentTabLabel(@NotNull TabbedContent content, @NotNull TabContentLayout layout) {
        if (content == null) {
            TabbedContentTabLabel.$$$reportNull$$$0(0);
        }
        if (layout == null) {
            TabbedContentTabLabel.$$$reportNull$$$0(1);
        }
        super((Content)content, layout);
        this.myComboIcon = new ComboIcon(){

            @Override
            public Rectangle getIconRec() {
                return new Rectangle(TabbedContentTabLabel.this.getWidth() - this.getIconWidth() - 3, 0, this.getIconWidth(), TabbedContentTabLabel.this.getHeight());
            }

            @Override
            public boolean isActive() {
                return true;
            }
        };
        this.myPopupReference = null;
        this.myContent = content;
    }

    @Override
    protected void selectContent() {
        IdeEventQueue.getInstance().getPopupManager().closeAllPopups();
        if (!this.hasMultipleTabs()) {
            super.selectContent();
            return;
        }
        SelectContentTabStep step = new SelectContentTabStep(this.getContent());
        ListPopup popup2 = JBPopupFactory.getInstance().createListPopup((ListPopupStep)step);
        this.myPopupReference = new WeakReference<ListPopup>(popup2);
        popup2.showUnderneathOf((Component)this);
    }

    @Override
    public void update() {
        super.update();
        if (this.myContent != null) {
            this.setText(this.myContent.getTabName());
        }
        if (this.hasMultipleTabs()) {
            this.setHorizontalAlignment(2);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        return this.hasMultipleTabs() ? new Dimension(size.width + 12, size.height) : size;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.hasMultipleTabs()) {
            this.myComboIcon.paintIcon(this, g);
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        JBPopup popup2 = (JBPopup)SoftReference.dereference(this.myPopupReference);
        if (popup2 != null) {
            Disposer.dispose((Disposable)popup2);
            this.myPopupReference = null;
        }
    }

    @NotNull
    public TabbedContent getContent() {
        TabbedContent tabbedContent = this.myContent;
        if (tabbedContent == null) {
            TabbedContentTabLabel.$$$reportNull$$$0(2);
        }
        return tabbedContent;
    }

    private boolean hasMultipleTabs() {
        return this.myContent != null && this.myContent.hasMultipleTabs();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layout";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/wm/impl/content/TabbedContentTabLabel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/wm/impl/content/TabbedContentTabLabel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getContent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

