/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.welcomeScreen;

import com.intellij.icons.AllIcons;
import com.intellij.ide.RecentProjectsManagerBase;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.labels.ActionLink;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class ChangeProjectIconForm {
    private final String myProjectPath;
    JBLabel myDefaultIcon;
    JBLabel myDarculaIcon;
    JPanel myRootPanel;
    ActionLink mySetIcon;
    ActionLink mySetIconDark;
    ActionLink myClear;
    ActionLink myClearDark;
    boolean resetIcon;
    boolean resetDarkIcon;
    VirtualFile pathToIcon;
    VirtualFile pathToDarkIcon;

    public ChangeProjectIconForm(String projectPath) {
        this.myProjectPath = projectPath;
        this.$$$setupUI$$$();
        this.myClear.setEnabled(this.getIcon() != null);
        this.myClearDark.setEnabled(this.getDarculaIcon() != null);
        Icon projectOrAppIcon = RecentProjectsManagerBase.getProjectOrAppIcon(this.myProjectPath);
        Icon defaultIcon = RecentProjectsManagerBase.getProjectIcon(this.myProjectPath, false);
        this.myDefaultIcon.setIcon(defaultIcon == null ? projectOrAppIcon : defaultIcon);
        Icon darculaIcon = RecentProjectsManagerBase.getProjectIcon(this.myProjectPath, true);
        this.myDarculaIcon.setIcon(darculaIcon == null ? this.myDefaultIcon.getIcon() : darculaIcon);
    }

    Icon getIcon() {
        return RecentProjectsManagerBase.getProjectIcon(this.myProjectPath, false);
    }

    Icon getDarculaIcon() {
        return RecentProjectsManagerBase.getProjectIcon(this.myProjectPath, true);
    }

    private void createUIComponents() {
        this.mySetIcon = new ActionLink("Change...", (AnAction)new ChangeProjectIcon(false));
        this.mySetIconDark = new ActionLink("Change...", (AnAction)new ChangeProjectIcon(true));
        this.myClear = new ActionLink("Reset", (AnAction)new ResetProjectIcon(false));
        this.myClearDark = new ActionLink("Reset", (AnAction)new ResetProjectIcon(true));
    }

    public void apply() throws IOException {
        File darkIcon = new File(this.myProjectPath + "/.idea/icon_dark.png");
        File icon = new File(this.myProjectPath + "/.idea/icon.png");
        if (this.pathToDarkIcon != null) {
            FileUtil.copy((File)new File(this.pathToDarkIcon.getPath()), (File)darkIcon);
        } else if (this.resetDarkIcon) {
            FileUtil.delete((File)darkIcon);
        }
        if (this.pathToIcon != null) {
            FileUtil.copy((File)new File(this.pathToIcon.getPath()), (File)icon);
        } else if (this.resetIcon) {
            FileUtil.delete((File)icon);
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JBLabel jBLabel2;
        JPanel jPanel;
        this.createUIComponents();
        this.myRootPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 5, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("Project icon for Default theme:");
        jPanel.add((Component)jBLabel3, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(0, 4, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JBLabel jBLabel4 = new JBLabel();
        jBLabel4.setText("Project icon for Darcula theme:");
        jPanel.add((Component)jBLabel4, new GridConstraints(1, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myDarculaIcon = jBLabel2 = new JBLabel();
        jPanel.add((Component)jBLabel2, new GridConstraints(1, 1, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myDefaultIcon = jBLabel = new JBLabel();
        jPanel.add((Component)jBLabel, new GridConstraints(0, 1, 1, 1, 0, 0, 0, 0, null, null, null));
        ActionLink actionLink = this.mySetIcon;
        actionLink.setText("Change...");
        jPanel.add((Component)actionLink, new GridConstraints(0, 2, 1, 1, 0, 0, 0, 0, null, null, null));
        ActionLink actionLink2 = this.mySetIconDark;
        actionLink2.setText("Change...");
        jPanel.add((Component)actionLink2, new GridConstraints(1, 2, 1, 1, 0, 0, 0, 0, null, null, null));
        ActionLink actionLink3 = this.myClear;
        actionLink3.setText("Reset");
        jPanel.add((Component)actionLink3, new GridConstraints(0, 3, 1, 1, 0, 0, 0, 0, null, null, null));
        ActionLink actionLink4 = this.myClearDark;
        actionLink4.setText("Reset");
        jPanel.add((Component)actionLink4, new GridConstraints(1, 3, 1, 1, 0, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }

    private class ResetProjectIcon
    extends AnAction {
        private final boolean myDarcula;

        public ResetProjectIcon(boolean darcula) {
            this.myDarcula = darcula;
        }

        public void actionPerformed(AnActionEvent e) {
            if (this.myDarcula) {
                ChangeProjectIconForm.this.myDarculaIcon.setIcon(AllIcons.Nodes.IdeaProject);
                ChangeProjectIconForm.this.resetDarkIcon = true;
            } else {
                ChangeProjectIconForm.this.myDefaultIcon.setIcon(AllIcons.Nodes.IdeaProject);
                ChangeProjectIconForm.this.resetIcon = true;
            }
        }
    }

    private class ChangeProjectIcon
    extends AnAction {
        private final boolean myDarcula;

        public ChangeProjectIcon(boolean darcula) {
            this.myDarcula = darcula;
        }

        public void actionPerformed(AnActionEvent e) {
            VirtualFile[] files = FileChooserFactory.getInstance().createFileChooser(new FileChooserDescriptor(true, false, false, false, false, false).withFileFilter(file2 -> "png".equalsIgnoreCase(file2.getExtension())), null, null).choose(null, new VirtualFile[0]);
            if (files.length == 1) {
                try {
                    Icon newIcon = RecentProjectsManagerBase.createIcon(new File(files[0].getPath()));
                    if (this.myDarcula) {
                        ChangeProjectIconForm.this.myDarculaIcon.setIcon(newIcon);
                        ChangeProjectIconForm.this.pathToDarkIcon = files[0];
                    } else {
                        ChangeProjectIconForm.this.myDefaultIcon.setIcon(newIcon);
                        ChangeProjectIconForm.this.pathToIcon = files[0];
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

