/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remote;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.PathMappingProvider;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.util.SmartList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class PathMappingValidator {
    public static String validatePathMappings(@NotNull Project project, @NotNull RemoteSdkAdditionalData data) {
        if (project == null) {
            PathMappingValidator.$$$reportNull$$$0(0);
        }
        if (data == null) {
            PathMappingValidator.$$$reportNull$$$0(1);
        }
        boolean found = false;
        SmartList locations = new SmartList();
        for (PathMappingProvider mappingProvider : PathMappingProvider.getSuitableMappingProviders(data)) {
            found = found || !mappingProvider.getPathMappingSettings(project, data).isEmpty();
            locations.add(mappingProvider.getProviderPresentableName(data));
        }
        if (!found) {
            StringBuilder builder = new StringBuilder();
            builder.append("No path mappings were found.");
            if (!locations.isEmpty()) {
                builder.append(" Please, configure them at ").append(StringUtil.join((Collection)locations, (String)" or "));
            }
            return builder.toString();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "data";
                break;
            }
        }
        objectArray[1] = "com/intellij/remote/PathMappingValidator";
        objectArray[2] = "validatePathMappings";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

