/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.slicer;

import com.intellij.ide.ExporterToTextFile;
import com.intellij.slicer.SliceNode;
import com.intellij.slicer.SliceTreeBuilder;
import com.intellij.usages.UsageViewSettings;
import com.intellij.util.SystemProperties;
import java.util.List;
import java.util.TooManyListenersException;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;

public class SliceToTextFileExporter
implements ExporterToTextFile {
    private final SliceTreeBuilder myBuilder;
    private String myLineSeparator = SystemProperties.getLineSeparator();

    public SliceToTextFileExporter(SliceTreeBuilder builder) {
        this.myBuilder = builder;
    }

    public JComponent getSettingsEditor() {
        return null;
    }

    public void addSettingsChangedListener(ChangeListener listener2) throws TooManyListenersException {
    }

    public void removeSettingsChangedListener(ChangeListener listener2) {
    }

    @NotNull
    public String getReportText() {
        StringBuilder buffer = new StringBuilder();
        this.appendChildren(buffer, this.myBuilder.getRootSliceNode(), "");
        String string = buffer.toString();
        if (string == null) {
            SliceToTextFileExporter.$$$reportNull$$$0(0);
        }
        return string;
    }

    private void appendNode(StringBuilder buffer, SliceNode node, String indent) {
        buffer.append(indent).append(node.getNodeText()).append(this.myLineSeparator);
        this.appendChildren(buffer, node, indent + "    ");
    }

    private void appendChildren(StringBuilder buffer, SliceNode node, String indent) {
        List<SliceNode> cachedChildren = node.getCachedChildren();
        if (cachedChildren != null) {
            for (SliceNode child : cachedChildren) {
                this.appendNode(buffer, child, indent);
            }
        } else {
            buffer.append(indent).append("...").append(this.myLineSeparator);
        }
    }

    @NotNull
    public String getDefaultFilePath() {
        String string = UsageViewSettings.getInstance().EXPORT_FILE_NAME;
        if (string == null) {
            SliceToTextFileExporter.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void exportedTo(String filePath) {
        UsageViewSettings.getInstance().EXPORT_FILE_NAME = filePath;
    }

    public boolean canExport() {
        return !this.myBuilder.analysisInProgress;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/slicer/SliceToTextFileExporter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getReportText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultFilePath";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

