/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.compress;

import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public final class Alphabet {
    private final char[] letters;
    private int lastIndexUsed;
    private static final int MAX_INDEX = 255;

    char getLetter(int position) {
        return this.letters[position];
    }

    public int getIndex(char letter, boolean forceAdd) {
        return this.getNextIndex(0, letter, forceAdd);
    }

    private int getNextIndex(int startFrom, char letter, boolean forceAdd) {
        for (int i = startFrom; i <= this.lastIndexUsed; ++i) {
            if (i == this.letters.length) {
                return -1;
            }
            if (this.letters[i] == '\u0000' || this.letters[i] != letter) continue;
            return i;
        }
        if (!forceAdd) {
            return -1;
        }
        return this.add(letter);
    }

    int getLastIndexUsed() {
        return this.lastIndexUsed;
    }

    private int add(char c) {
        if (this.lastIndexUsed >= this.letters.length - 1) {
            return -1;
        }
        ++this.lastIndexUsed;
        this.letters[this.lastIndexUsed] = c;
        return this.lastIndexUsed;
    }

    Alphabet() {
        this(255);
    }

    private Alphabet(int maxIndex) {
        assert (maxIndex <= 255) : "alphabet is too long";
        this.letters = new char[maxIndex];
    }

    Alphabet(@NotNull CharSequence alphabet) {
        if (alphabet == null) {
            Alphabet.$$$reportNull$$$0(0);
        }
        this(alphabet.length() + 1);
        assert (alphabet.length() != 0);
        for (int i = 0; i < alphabet.length(); ++i) {
            this.add(alphabet.charAt(i));
        }
    }

    public String toString() {
        return "Letters[" + this.lastIndexUsed + "]: '" + Arrays.toString(Arrays.copyOf(this.letters, this.lastIndexUsed)) + "'";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "alphabet", "com/intellij/spellchecker/compress/Alphabet", "<init>"));
    }
}

