/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.util.ExecUtil;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Bitness;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.Version;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.SystemProperties;
import com.intellij.util.VersionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JdkBundle {
    @NotNull
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.util.JdkBundle");
    @NotNull
    private static final Map<Pattern, Function<Matcher, Pair<Version, Integer>>> LINE_TO_VERSION_PATTERNS = ContainerUtil.newLinkedHashMap((Pair)Pair.create((Object)Pattern.compile("^java version \"1\\.([\\d]+)\\.([\\d]+)_([\\d]+).*\".*", 8), matcher -> Pair.create((Object)new Version(1, StringUtil.parseInt((String)matcher.group(1), (int)0), StringUtil.parseInt((String)matcher.group(2), (int)0)), (Object)StringUtil.parseInt((String)matcher.group(3), (int)0))), (Pair[])new Pair[]{Pair.create((Object)Pattern.compile("^java version \"9-ea.*\".*", 8), matcher -> Pair.create((Object)new Version(9, 0, 0), (Object)0)), Pair.create((Object)Pattern.compile("^openjdk version \"1\\.([\\d]+)\\.([\\d]+)_([\\d]+).*\".*", 8), matcher -> Pair.create((Object)new Version(1, StringUtil.parseInt((String)matcher.group(1), (int)0), StringUtil.parseInt((String)matcher.group(2), (int)0)), (Object)StringUtil.parseInt((String)matcher.group(3), (int)0))), Pair.create((Object)Pattern.compile("^openjdk version \"9-ea.*\".*", 8), matcher -> Pair.create((Object)new Version(9, 0, 0), (Object)0)), Pair.create((Object)Pattern.compile("^[a-zA-Z() \"\\d]*([\\d]+)\\.([\\d]+)\\.?([\\d]*).*", 8), matcher -> Pair.create((Object)new Version(StringUtil.parseInt((String)matcher.group(1), (int)0), StringUtil.parseInt((String)matcher.group(2), (int)0), StringUtil.parseInt((String)matcher.group(3), (int)0)), (Object)0))});
    @NotNull
    private static final Pattern ARCH_64_BIT_PATTERN = Pattern.compile(".*64-Bit.*", 8);
    @NotNull
    private static final Pattern BUILD_STR_PATTERN = Pattern.compile(".*\\([^-]*-(.*)\\).*", 8);
    @NotNull
    public static final Bitness runtimeBitness = JdkBundle.is64BitJVM(System.getProperty("java.vm.name")) ? Bitness.x64 : Bitness.x32;
    @NotNull
    private final File myBundleAsFile;
    @NotNull
    private final String myBundleName;
    @Nullable
    private final Pair<Version, Integer> myVersionUpdate;
    private boolean myBoot;
    private boolean myBundled;
    private volatile Bitness bitness;

    private static boolean is64BitRuntime() {
        return runtimeBitness == Bitness.x64;
    }

    JdkBundle(@NotNull File bundleAsFile, @NotNull String bundleName, @Nullable Pair<Version, Integer> versionUpdate, boolean boot, boolean bundled) {
        if (bundleAsFile == null) {
            JdkBundle.$$$reportNull$$$0(0);
        }
        if (bundleName == null) {
            JdkBundle.$$$reportNull$$$0(1);
        }
        this.myBundleAsFile = bundleAsFile;
        this.myBundleName = bundleName;
        this.myVersionUpdate = versionUpdate;
        this.myBoot = boot;
        this.myBundled = bundled;
    }

    @Nullable
    public static JdkBundle createBundle(@NotNull File jvm, boolean boot, boolean bundled) {
        if (jvm == null) {
            JdkBundle.$$$reportNull$$$0(2);
        }
        return JdkBundle.createBundle(jvm, boot, bundled, true);
    }

    @Nullable
    public static JdkBundle createBundle(@NotNull File jvm, boolean boot, boolean bundled, boolean matchArch) {
        if (jvm == null) {
            JdkBundle.$$$reportNull$$$0(3);
        }
        String homeSubPath = SystemInfo.isMac ? "Contents/Home" : "";
        return JdkBundle.createBundle(jvm, homeSubPath, boot, bundled, matchArch);
    }

    @Nullable
    static JdkBundle createBundle(@NotNull File jvm, @NotNull String homeSubPath, boolean boot, boolean bundled, boolean matchArch) {
        File javaHome;
        if (jvm == null) {
            JdkBundle.$$$reportNull$$$0(4);
        }
        if (homeSubPath == null) {
            JdkBundle.$$$reportNull$$$0(5);
        }
        File file2 = javaHome = SystemInfo.isMac ? new File(jvm, homeSubPath) : jvm;
        if (bundled) {
            javaHome = new File(PathManager.getHomePath(), javaHome.getPath());
        }
        boolean isValidBundle = true;
        if (SystemProperties.getBooleanProperty((String)"idea.jre.check", (boolean)false)) {
            isValidBundle = new File(javaHome, "lib" + File.separator + "tools.jar").exists();
        }
        if (!SystemInfo.isMac && !isValidBundle) {
            return null;
        }
        File absJvmLocation = bundled ? new File(PathManager.getHomePath(), jvm.getPath()) : jvm;
        Pair<Pair<String, Boolean>, Pair<Version, Integer>> nameArchVersionAndUpdate = JdkBundle.getJDKNameArchVersionAndUpdate(absJvmLocation, homeSubPath);
        if (((Pair)nameArchVersionAndUpdate.first).second == null) {
            return null;
        }
        if (matchArch && (Boolean)((Pair)nameArchVersionAndUpdate.first).second != JdkBundle.is64BitRuntime()) {
            return null;
        }
        if (SystemInfo.isMac && nameArchVersionAndUpdate.second != null && ((Version)((Pair)nameArchVersionAndUpdate.second).first).isOrGreaterThan(Integer.valueOf(1), Integer.valueOf(7)) && !isValidBundle) {
            return null;
        }
        JdkBundle bundle = new JdkBundle(absJvmLocation, (String)((Pair)nameArchVersionAndUpdate.first).first, (Pair<Version, Integer>)((Pair)nameArchVersionAndUpdate.second), boot, bundled);
        bundle.bitness = (Boolean)((Pair)nameArchVersionAndUpdate.first).second != false ? Bitness.x64 : Bitness.x32;
        return bundle;
    }

    @Nullable
    public static JdkBundle createBoot() {
        return JdkBundle.createBoot(true);
    }

    @Nullable
    static JdkBundle createBoot(boolean adjustToMacBundle) {
        JdkBundle bundle;
        File bootJDK;
        String javaHome = System.getProperty("java.home");
        File file2 = bootJDK = javaHome.endsWith("jre") ? new File(javaHome).getParentFile() : new File(javaHome);
        if (SystemInfo.isMac && adjustToMacBundle) {
            bootJDK = bootJDK.getParentFile().getParentFile();
            bundle = JdkBundle.createBundle(bootJDK, true, false);
        } else {
            bundle = JdkBundle.createBundle(bootJDK, "", true, false, true);
        }
        if (bundle != null && JdkBundle.isBundledJDK(bundle)) {
            bundle.setBundled(true);
        }
        return bundle;
    }

    @NotNull
    public static File getBundledJDKAbsoluteLocation() {
        File file2 = new File(PathManager.getHomePath(), SystemInfo.isMac ? "jdk" : "jre");
        if (file2 == null) {
            JdkBundle.$$$reportNull$$$0(6);
        }
        return file2;
    }

    private static boolean isBundledJDK(@NotNull JdkBundle bundle) {
        if (bundle == null) {
            JdkBundle.$$$reportNull$$$0(7);
        }
        return FileUtil.filesEqual((File)bundle.getLocation(), (File)JdkBundle.getBundledJDKAbsoluteLocation());
    }

    @NotNull
    public File getLocation() {
        File file2 = this.myBundleAsFile;
        if (file2 == null) {
            JdkBundle.$$$reportNull$$$0(8);
        }
        return file2;
    }

    public String getVisualRepresentation() {
        StringBuilder representation = new StringBuilder();
        if (this.myVersionUpdate != null) {
            representation.append(this.myVersionUpdate.first).append((Integer)this.myVersionUpdate.second > 0 ? "_" + this.myVersionUpdate.second : "").append(" ");
        }
        representation.append(this.myBundleName);
        if (this.myBoot || this.myBundled) {
            representation.append(" [");
            if (this.myBoot) {
                representation.append(this.myBundled ? "boot, " : "boot");
            }
            if (this.myBundled) {
                representation.append("bundled");
            }
            representation.append("]");
        }
        return representation.toString();
    }

    public void setBundled(boolean bundled) {
        this.myBundled = bundled;
    }

    public boolean isBoot() {
        return this.myBoot;
    }

    public Bitness getBitness() {
        if (this.bitness == null) {
            String homeSubPath = SystemInfo.isMac ? "Contents/Home" : "";
            Pair<Pair<String, Boolean>, Pair<Version, Integer>> nameArchVersionAndUpdate = JdkBundle.getJDKNameArchVersionAndUpdate(this.getLocation(), homeSubPath);
            assert (((Pair)nameArchVersionAndUpdate.first).second != null);
            this.bitness = (Boolean)((Pair)nameArchVersionAndUpdate.first).second != false ? Bitness.x64 : Bitness.x32;
        }
        return this.bitness;
    }

    @NotNull
    public String getBundleName() {
        String string = this.myBundleName;
        if (string == null) {
            JdkBundle.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Nullable
    Pair<Version, Integer> getVersionUpdate() {
        return this.myVersionUpdate;
    }

    @Nullable
    public Version getVersion() {
        return this.myVersionUpdate != null ? (Version)this.myVersionUpdate.first : null;
    }

    @Nullable
    public Integer getUpdateNumber() {
        return this.myVersionUpdate != null ? (Integer)this.myVersionUpdate.second : null;
    }

    @NotNull
    String getNameVersion() {
        String string = this.myBundleName.replaceFirst("\\(.*\\)", "") + (this.myVersionUpdate != null ? ((Version)this.myVersionUpdate.first).toString() : "");
        if (string == null) {
            JdkBundle.$$$reportNull$$$0(10);
        }
        return string;
    }

    private static Pair<Pair<String, Boolean>, Pair<Version, Integer>> getJDKNameArchVersionAndUpdate(File jvm, String homeSubPath) {
        String displayVersion;
        GeneralCommandLine commandLine = new GeneralCommandLine().withParentEnvironmentType(GeneralCommandLine.ParentEnvironmentType.NONE);
        String javaExecutable = "java" + (SystemInfo.isWindows ? ".exe" : "");
        File jvmPath = new File(jvm, homeSubPath + File.separator + "jre" + File.separator + "bin" + File.separator + javaExecutable);
        if (!jvmPath.exists()) {
            jvmPath = new File(jvm, homeSubPath + File.separator + "bin" + File.separator + javaExecutable);
        }
        commandLine.setExePath(jvmPath.getAbsolutePath());
        commandLine.addParameter("-version");
        List outputLines = null;
        try {
            outputLines = ExecUtil.execAndGetOutput((GeneralCommandLine)commandLine).getStderrLines();
        }
        catch (ExecutionException e) {
            if (SystemInfo.isMac) {
                commandLine.setExePath(new File(jvm, homeSubPath + File.separator + "bin" + File.separator + "java").getAbsolutePath());
                try {
                    outputLines = ExecUtil.execAndGetOutput((GeneralCommandLine)commandLine).getStderrLines();
                }
                catch (ExecutionException e1) {
                    LOG.debug((Throwable)e);
                }
            }
            LOG.debug((Throwable)e);
        }
        Boolean is64Bit = null;
        Pair versionAndUpdate = null;
        if (outputLines != null && outputLines.size() >= 1) {
            Matcher matcher;
            String versionLine = (String)outputLines.get(0);
            versionAndUpdate = VersionUtil.parseNewVersionAndUpdate((String)versionLine, LINE_TO_VERSION_PATTERNS);
            displayVersion = versionLine.replaceFirst("\".*\"", "");
            displayVersion = displayVersion.replaceFirst("version", "");
            if (outputLines.size() >= 2 && (matcher = BUILD_STR_PATTERN.matcher((CharSequence)outputLines.get(1))).find()) {
                displayVersion = displayVersion + "(" + matcher.group(1) + ")";
            }
            if (outputLines.size() >= 3) {
                is64Bit = JdkBundle.is64BitJVM((String)outputLines.get(2));
            }
        } else {
            displayVersion = jvm.getName();
        }
        return Pair.create((Object)Pair.create((Object)displayVersion, is64Bit), versionAndUpdate);
    }

    private static boolean is64BitJVM(String archLine) {
        return ARCH_64_BIT_PATTERN.matcher(archLine).find();
    }

    public boolean isBundled() {
        return this.myBundled;
    }

    public void setBoot(boolean boot) {
        this.myBoot = boot;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bundleAsFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bundleName";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jvm";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "homeSubPath";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/JdkBundle";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bundle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/JdkBundle";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getBundledJDKAbsoluteLocation";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocation";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getBundleName";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createBundle";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isBundledJDK";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

