/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.indexing.DeletedVirtualFileStub;
import com.intellij.util.indexing.FileBasedIndexImpl;

class ProjectFilesCondition
implements Condition<VirtualFile> {
    private static final int MAX_FILES_TO_UPDATE_FROM_OTHER_PROJECT = 2;
    private final VirtualFile myRestrictedTo;
    private final GlobalSearchScope myFilter;
    private int myFilesFromOtherProjects;
    private final FileBasedIndexImpl.ProjectIndexableFilesFilter myIndexableFilesFilter;

    public ProjectFilesCondition(FileBasedIndexImpl.ProjectIndexableFilesFilter indexableFilesFilter, GlobalSearchScope filter2, VirtualFile restrictedTo, boolean includeFilesFromOtherProjects) {
        this.myRestrictedTo = restrictedTo;
        this.myFilter = filter2;
        this.myIndexableFilesFilter = indexableFilesFilter;
        if (!includeFilesFromOtherProjects) {
            this.myFilesFromOtherProjects = 2;
        }
    }

    public boolean value(VirtualFile file2) {
        int fileId = ((VirtualFileWithId)file2).getId();
        if (this.myIndexableFilesFilter != null && fileId > 0 && !this.myIndexableFilesFilter.containsFileId(fileId)) {
            if (this.myFilesFromOtherProjects >= 2) {
                return false;
            }
            ++this.myFilesFromOtherProjects;
            return true;
        }
        if (fileId < 0 && file2 instanceof DeletedVirtualFileStub) {
            return true;
        }
        if (FileBasedIndexImpl.belongsToScope(file2, this.myRestrictedTo, this.myFilter)) {
            return true;
        }
        if (this.myFilesFromOtherProjects < 2) {
            ++this.myFilesFromOtherProjects;
            return true;
        }
        return false;
    }
}

