/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.textCompletion;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.openapi.editor.SpellCheckingEditorCustomizationProvider;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.ui.EditorCustomization;
import com.intellij.ui.LanguageTextField;
import com.intellij.util.textCompletion.TextCompletionProvider;
import com.intellij.util.textCompletion.TextCompletionUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextFieldWithCompletion
extends LanguageTextField {
    private final boolean myForceAutoPopup;
    private final boolean myShowHint;

    public TextFieldWithCompletion(@NotNull Project project, @NotNull TextCompletionProvider provider, @NotNull String value, boolean oneLineMode, boolean forceAutoPopup, boolean showHint2) {
        if (project == null) {
            TextFieldWithCompletion.$$$reportNull$$$0(0);
        }
        if (provider == null) {
            TextFieldWithCompletion.$$$reportNull$$$0(1);
        }
        if (value == null) {
            TextFieldWithCompletion.$$$reportNull$$$0(2);
        }
        this(project, provider, value, oneLineMode, true, forceAutoPopup, showHint2);
    }

    public TextFieldWithCompletion(@Nullable Project project, @NotNull TextCompletionProvider provider, @NotNull String value, boolean oneLineMode, boolean autoPopup, boolean forceAutoPopup, boolean showHint2) {
        if (provider == null) {
            TextFieldWithCompletion.$$$reportNull$$$0(3);
        }
        if (value == null) {
            TextFieldWithCompletion.$$$reportNull$$$0(4);
        }
        super(PlainTextLanguage.INSTANCE, project, value, new TextCompletionUtil.DocumentWithCompletionCreator(provider, autoPopup), oneLineMode);
        this.myForceAutoPopup = forceAutoPopup;
        this.myShowHint = showHint2;
    }

    @Override
    protected EditorEx createEditor() {
        EditorEx editor = super.createEditor();
        EditorCustomization disableSpellChecking = SpellCheckingEditorCustomizationProvider.getInstance().getDisabledCustomization();
        if (disableSpellChecking != null) {
            disableSpellChecking.customize(editor);
        }
        editor.putUserData(AutoPopupController.ALWAYS_AUTO_POPUP, this.myForceAutoPopup);
        if (this.myShowHint) {
            TextCompletionUtil.installCompletionHint(editor);
        }
        return editor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "provider";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "value";
                break;
            }
        }
        objectArray[1] = "com/intellij/util/textCompletion/TextFieldWithCompletion";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

