/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl;

import com.intellij.AppTopics;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.Executor;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.execution.ui.RunContentWithExecutorListener;
import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.NamedComponent;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.fileEditor.FileDocumentManagerAdapter;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugProcessStarter;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XDebuggerManagerListener;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointListener;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.impl.XDebugProcessConfiguratorStarter;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.XDebuggerWatchesManager;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointBase;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointManagerImpl;
import com.intellij.xdebugger.impl.evaluate.quick.common.ValueLookupManager;
import com.intellij.xdebugger.impl.settings.XDebuggerSettingManagerImpl;
import com.intellij.xdebugger.impl.ui.ExecutionPointHighlighter;
import com.intellij.xdebugger.impl.ui.XDebugSessionTab;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="XDebuggerManager", storages={@Storage(value="$WORKSPACE_FILE$")})
public class XDebuggerManagerImpl
extends XDebuggerManager
implements NamedComponent,
PersistentStateComponent<XDebuggerState> {
    @NonNls
    public static final String COMPONENT_NAME = "XDebuggerManager";
    public static final NotificationGroup NOTIFICATION_GROUP = NotificationGroup.toolWindowGroup((String)"Debugger messages", (String)ToolWindowId.DEBUG, (boolean)false);
    private final Project myProject;
    private final XBreakpointManagerImpl myBreakpointManager;
    private final XDebuggerWatchesManager myWatchesManager;
    private final Map<ProcessHandler, XDebugSessionImpl> mySessions;
    private final ExecutionPointHighlighter myExecutionPointHighlighter;
    private final AtomicReference<XDebugSessionImpl> myActiveSession = new AtomicReference();

    public XDebuggerManagerImpl(Project project, StartupManager startupManager, MessageBus messageBus) {
        this.myProject = project;
        this.myBreakpointManager = new XBreakpointManagerImpl(project, this, startupManager);
        this.myWatchesManager = new XDebuggerWatchesManager();
        this.mySessions = new LinkedHashMap<ProcessHandler, XDebugSessionImpl>();
        this.myExecutionPointHighlighter = new ExecutionPointHighlighter(project);
        MessageBusConnection messageBusConnection = messageBus.connect();
        messageBusConnection.subscribe(AppTopics.FILE_DOCUMENT_SYNC, (Object)new FileDocumentManagerAdapter(){

            public void fileContentLoaded(@NotNull VirtualFile file2, @NotNull Document document) {
                if (file2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (document == null) {
                    1.$$$reportNull$$$0(1);
                }
                XDebuggerManagerImpl.this.updateExecutionPoint(file2, true);
            }

            public void fileContentReloaded(@NotNull VirtualFile file2, @NotNull Document document) {
                if (file2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (document == null) {
                    1.$$$reportNull$$$0(3);
                }
                XDebuggerManagerImpl.this.updateExecutionPoint(file2, true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "document";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/xdebugger/impl/XDebuggerManagerImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileContentLoaded";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileContentReloaded";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        messageBusConnection.subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerListener(){

            public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
                if (source == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (file2 == null) {
                    2.$$$reportNull$$$0(1);
                }
                XDebuggerManagerImpl.this.updateExecutionPoint(file2, false);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "source";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "file";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/xdebugger/impl/XDebuggerManagerImpl$2";
                objectArray[2] = "fileOpened";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.myBreakpointManager.addBreakpointListener(new XBreakpointListener<XBreakpoint<?>>(){

            public void breakpointChanged(@NotNull XBreakpoint<?> breakpoint) {
                XDebugSessionImpl session2;
                if (breakpoint == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (!(breakpoint instanceof XLineBreakpoint) && (session2 = XDebuggerManagerImpl.this.getCurrentSession()) != null && breakpoint.equals(session2.getActiveNonLineBreakpoint())) {
                    XBreakpointBase breakpointBase = (XBreakpointBase)breakpoint;
                    breakpointBase.clearIcon();
                    XDebuggerManagerImpl.this.myExecutionPointHighlighter.updateGutterIcon(breakpointBase.createGutterIconRenderer());
                }
            }

            public void breakpointRemoved(@NotNull XBreakpoint<?> breakpoint) {
                XDebugSessionImpl session2;
                if (breakpoint == null) {
                    3.$$$reportNull$$$0(1);
                }
                if ((session2 = XDebuggerManagerImpl.this.getCurrentSession()) != null && breakpoint == session2.getActiveNonLineBreakpoint()) {
                    XDebuggerManagerImpl.this.myExecutionPointHighlighter.updateGutterIcon(null);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "breakpoint";
                objectArray2[1] = "com/intellij/xdebugger/impl/XDebuggerManagerImpl$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "breakpointChanged";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "breakpointRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        messageBusConnection.subscribe(RunContentManager.TOPIC, (Object)new RunContentWithExecutorListener(){

            public void contentSelected(@Nullable RunContentDescriptor descriptor2, @NotNull Executor executor) {
                if (executor == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (descriptor2 != null && executor.equals(DefaultDebugExecutor.getDebugExecutorInstance())) {
                    XDebugSessionImpl session2 = (XDebugSessionImpl)XDebuggerManagerImpl.this.mySessions.get(descriptor2.getProcessHandler());
                    if (session2 != null) {
                        session2.activateSession();
                    } else {
                        XDebuggerManagerImpl.this.setCurrentSession(null);
                    }
                }
            }

            public void contentRemoved(@Nullable RunContentDescriptor descriptor2, @NotNull Executor executor) {
                if (executor == null) {
                    4.$$$reportNull$$$0(1);
                }
                if (descriptor2 != null && executor.equals(DefaultDebugExecutor.getDebugExecutorInstance())) {
                    XDebuggerManagerImpl.this.mySessions.remove(descriptor2.getProcessHandler());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "executor";
                objectArray2[1] = "com/intellij/xdebugger/impl/XDebuggerManagerImpl$4";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "contentSelected";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "contentRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private void updateExecutionPoint(@NotNull VirtualFile file2, boolean navigate2) {
        if (file2 == null) {
            XDebuggerManagerImpl.$$$reportNull$$$0(0);
        }
        if (file2.equals(this.myExecutionPointHighlighter.getCurrentFile())) {
            this.myExecutionPointHighlighter.update(navigate2);
        }
    }

    @NotNull
    public XBreakpointManagerImpl getBreakpointManager() {
        XBreakpointManagerImpl xBreakpointManagerImpl = this.myBreakpointManager;
        if (xBreakpointManagerImpl == null) {
            XDebuggerManagerImpl.$$$reportNull$$$0(1);
        }
        return xBreakpointManagerImpl;
    }

    public XDebuggerWatchesManager getWatchesManager() {
        return this.myWatchesManager;
    }

    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public String getComponentName() {
        if (COMPONENT_NAME == null) {
            XDebuggerManagerImpl.$$$reportNull$$$0(2);
        }
        return COMPONENT_NAME;
    }

    @NotNull
    public XDebugSession startSession(@NotNull ExecutionEnvironment environment, @NotNull XDebugProcessStarter processStarter) throws ExecutionException {
        if (environment == null) {
            XDebuggerManagerImpl.$$$reportNull$$$0(3);
        }
        if (processStarter == null) {
            XDebuggerManagerImpl.$$$reportNull$$$0(4);
        }
        XDebugSessionImpl xDebugSessionImpl = this.startSession(environment.getContentToReuse(), processStarter, new XDebugSessionImpl(environment, this));
        if (xDebugSessionImpl == null) {
            XDebuggerManagerImpl.$$$reportNull$$$0(5);
        }
        return xDebugSessionImpl;
    }

    @NotNull
    public XDebugSession startSessionAndShowTab(@NotNull String sessionName, @Nullable RunContentDescriptor contentToReuse, @NotNull XDebugProcessStarter starter2) throws ExecutionException {
        if (sessionName == null) {
            XDebuggerManagerImpl.$$$reportNull$$$0(6);
        }
        if (starter2 == null) {
            XDebuggerManagerImpl.$$$reportNull$$$0(7);
        }
        XDebugSession xDebugSession = this.startSessionAndShowTab(sessionName, contentToReuse, false, starter2);
        if (xDebugSession == null) {
            XDebuggerManagerImpl.$$$reportNull$$$0(8);
        }
        return xDebugSession;
    }

    @NotNull
    public XDebugSession startSessionAndShowTab(@NotNull String sessionName, @Nullable RunContentDescriptor contentToReuse, boolean showToolWindowOnSuspendOnly, @NotNull XDebugProcessStarter starter2) throws ExecutionException {
        if (sessionName == null) {
            XDebuggerManagerImpl.$$$reportNull$$$0(9);
        }
        if (starter2 == null) {
            XDebuggerManagerImpl.$$$reportNull$$$0(10);
        }
        XDebugSession xDebugSession = this.startSessionAndShowTab(sessionName, null, contentToReuse, showToolWindowOnSuspendOnly, starter2);
        if (xDebugSession == null) {
            XDebuggerManagerImpl.$$$reportNull$$$0(11);
        }
        return xDebugSession;
    }

    @NotNull
    public XDebugSession startSessionAndShowTab(@NotNull String sessionName, Icon icon, @Nullable RunContentDescriptor contentToReuse, boolean showToolWindowOnSuspendOnly, @NotNull XDebugProcessStarter starter2) throws ExecutionException {
        if (sessionName == null) {
            XDebuggerManagerImpl.$$$reportNull$$$0(12);
        }
        if (starter2 == null) {
            XDebuggerManagerImpl.$$$reportNull$$$0(13);
        }
        XDebugSessionImpl session2 = this.startSession(contentToReuse, starter2, new XDebugSessionImpl(null, this, sessionName, icon, showToolWindowOnSuspendOnly, contentToReuse));
        if (!showToolWindowOnSuspendOnly) {
            session2.showSessionTab();
        }
        ProcessHandler handler2 = session2.getDebugProcess().getProcessHandler();
        handler2.startNotify();
        XDebugSessionImpl xDebugSessionImpl = session2;
        if (xDebugSessionImpl == null) {
            XDebuggerManagerImpl.$$$reportNull$$$0(14);
        }
        return xDebugSessionImpl;
    }

    private XDebugSessionImpl startSession(@Nullable RunContentDescriptor contentToReuse, @NotNull XDebugProcessStarter processStarter, @NotNull XDebugSessionImpl session2) throws ExecutionException {
        if (processStarter == null) {
            XDebuggerManagerImpl.$$$reportNull$$$0(15);
        }
        if (session2 == null) {
            XDebuggerManagerImpl.$$$reportNull$$$0(16);
        }
        XDebugProcess process2 = processStarter.start((XDebugSession)session2);
        ((XDebuggerManagerListener)this.myProject.getMessageBus().syncPublisher(TOPIC)).processStarted(process2);
        if (processStarter instanceof XDebugProcessConfiguratorStarter) {
            session2.activateSession();
            ((XDebugProcessConfiguratorStarter)processStarter).configure(session2.getSessionData());
        }
        session2.init(process2, contentToReuse);
        this.mySessions.put(session2.getDebugProcess().getProcessHandler(), session2);
        return session2;
    }

    public void removeSession(@NotNull XDebugSessionImpl session2) {
        if (session2 == null) {
            XDebuggerManagerImpl.$$$reportNull$$$0(17);
        }
        XDebugSessionTab sessionTab = session2.getSessionTab();
        this.mySessions.remove(session2.getDebugProcess().getProcessHandler());
        if (sessionTab != null && !this.myProject.isDisposed() && !ApplicationManager.getApplication().isUnitTestMode() && XDebuggerSettingManagerImpl.getInstanceImpl().getGeneralSettings().isHideDebuggerOnProcessTermination()) {
            ExecutionManager.getInstance((Project)this.myProject).getContentManager().hideRunContent(DefaultDebugExecutor.getDebugExecutorInstance(), sessionTab.getRunContentDescriptor());
        }
        if (this.myActiveSession.compareAndSet(session2, null)) {
            this.onActiveSessionChanged();
        }
    }

    void updateExecutionPoint(@Nullable XSourcePosition position, boolean nonTopFrame, @Nullable GutterIconRenderer gutterIconRenderer) {
        if (position != null) {
            this.myExecutionPointHighlighter.show(position, nonTopFrame, gutterIconRenderer);
        } else {
            this.myExecutionPointHighlighter.hide();
        }
    }

    private void onActiveSessionChanged() {
        this.myBreakpointManager.getLineBreakpointManager().queueAllBreakpointsUpdate();
        ApplicationManager.getApplication().invokeLater(() -> ValueLookupManager.getInstance(this.myProject).hideHint(), this.myProject.getDisposed());
    }

    @NotNull
    public XDebugSession[] getDebugSessions() {
        Collection<XDebugSessionImpl> sessions = this.mySessions.values();
        XDebugSession[] xDebugSessionArray = sessions.toArray(new XDebugSessionImpl[sessions.size()]);
        if (xDebugSessionArray == null) {
            XDebuggerManagerImpl.$$$reportNull$$$0(18);
        }
        return xDebugSessionArray;
    }

    @Nullable
    public XDebugSession getDebugSession(@NotNull ExecutionConsole executionConsole) {
        if (executionConsole == null) {
            XDebuggerManagerImpl.$$$reportNull$$$0(19);
        }
        for (XDebugSessionImpl debuggerSession : this.mySessions.values()) {
            RunContentDescriptor contentDescriptor;
            XDebugSessionTab sessionTab = debuggerSession.getSessionTab();
            if (sessionTab == null || (contentDescriptor = sessionTab.getRunContentDescriptor()) == null || executionConsole != contentDescriptor.getExecutionConsole()) continue;
            return debuggerSession;
        }
        return null;
    }

    @NotNull
    public <T extends XDebugProcess> List<? extends T> getDebugProcesses(Class<T> processClass) {
        SmartList list2 = null;
        for (XDebugSessionImpl session2 : this.mySessions.values()) {
            XDebugProcess process2 = session2.getDebugProcess();
            if (!processClass.isInstance(process2)) continue;
            if (list2 == null) {
                list2 = new SmartList();
            }
            list2.add(processClass.cast(process2));
        }
        List list3 = ContainerUtil.notNullize(list2);
        if (list3 == null) {
            XDebuggerManagerImpl.$$$reportNull$$$0(20);
        }
        return list3;
    }

    @Nullable
    public XDebugSessionImpl getCurrentSession() {
        return this.myActiveSession.get();
    }

    void setCurrentSession(@Nullable XDebugSessionImpl session2) {
        boolean sessionChanged;
        boolean bl = sessionChanged = this.myActiveSession.getAndSet(session2) != session2;
        if (sessionChanged) {
            if (session2 != null) {
                XDebugSessionTab tab = session2.getSessionTab();
                if (tab != null) {
                    tab.select();
                }
            } else {
                this.myExecutionPointHighlighter.hide();
            }
            this.onActiveSessionChanged();
        }
    }

    public XDebuggerState getState() {
        return new XDebuggerState(this.myBreakpointManager.getState(), this.myWatchesManager.getState());
    }

    public boolean isFullLineHighlighter() {
        return this.myExecutionPointHighlighter.isFullLineHighlighter();
    }

    public void loadState(@NotNull XDebuggerState state2) {
        if (state2 == null) {
            XDebuggerManagerImpl.$$$reportNull$$$0(21);
        }
        this.myBreakpointManager.loadState(state2.myBreakpointManagerState);
        this.myWatchesManager.loadState(state2.myWatchesManagerState);
    }

    public void showExecutionPosition() {
        this.myExecutionPointHighlighter.navigateTo();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 8: 
            case 11: 
            case 14: 
            case 18: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 8: 
            case 11: 
            case 14: 
            case 18: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 8: 
            case 11: 
            case 14: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xdebugger/impl/XDebuggerManagerImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 4: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processStarter";
                break;
            }
            case 6: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sessionName";
                break;
            }
            case 7: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "starter";
                break;
            }
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executionConsole";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xdebugger/impl/XDebuggerManagerImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getBreakpointManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "startSession";
                break;
            }
            case 8: 
            case 11: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "startSessionAndShowTab";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getDebugSessions";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getDebugProcesses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "updateExecutionPoint";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 8: 
            case 11: 
            case 14: 
            case 18: 
            case 20: {
                break;
            }
            case 3: 
            case 4: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "startSession";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "startSessionAndShowTab";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "removeSession";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getDebugSession";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 8: 
            case 11: 
            case 14: 
            case 18: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class XDebuggerState {
        @NotNull
        private XBreakpointManagerImpl.BreakpointManagerState myBreakpointManagerState;
        @NotNull
        private XDebuggerWatchesManager.WatchesManagerState myWatchesManagerState;

        public XDebuggerState() {
            this(new XBreakpointManagerImpl.BreakpointManagerState(), new XDebuggerWatchesManager.WatchesManagerState());
        }

        public XDebuggerState(@NotNull XBreakpointManagerImpl.BreakpointManagerState breakpointManagerState, @NotNull XDebuggerWatchesManager.WatchesManagerState watchesManagerState) {
            if (breakpointManagerState == null) {
                XDebuggerState.$$$reportNull$$$0(0);
            }
            if (watchesManagerState == null) {
                XDebuggerState.$$$reportNull$$$0(1);
            }
            this.myBreakpointManagerState = breakpointManagerState;
            this.myWatchesManagerState = watchesManagerState;
        }

        @Property(surroundWithTag=false)
        @NotNull
        public XBreakpointManagerImpl.BreakpointManagerState getBreakpointManagerState() {
            XBreakpointManagerImpl.BreakpointManagerState breakpointManagerState = this.myBreakpointManagerState;
            if (breakpointManagerState == null) {
                XDebuggerState.$$$reportNull$$$0(2);
            }
            return breakpointManagerState;
        }

        public void setBreakpointManagerState(@NotNull XBreakpointManagerImpl.BreakpointManagerState breakpointManagerState) {
            if (breakpointManagerState == null) {
                XDebuggerState.$$$reportNull$$$0(3);
            }
            this.myBreakpointManagerState = breakpointManagerState;
        }

        @Property(surroundWithTag=false)
        @NotNull
        public XDebuggerWatchesManager.WatchesManagerState getWatchesManagerState() {
            XDebuggerWatchesManager.WatchesManagerState watchesManagerState = this.myWatchesManagerState;
            if (watchesManagerState == null) {
                XDebuggerState.$$$reportNull$$$0(4);
            }
            return watchesManagerState;
        }

        public void setWatchesManagerState(@NotNull XDebuggerWatchesManager.WatchesManagerState watchesManagerState) {
            if (watchesManagerState == null) {
                XDebuggerState.$$$reportNull$$$0(5);
            }
            this.myWatchesManagerState = watchesManagerState;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "breakpointManagerState";
                    break;
                }
                case 1: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "watchesManagerState";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/xdebugger/impl/XDebuggerManagerImpl$XDebuggerState";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/xdebugger/impl/XDebuggerManagerImpl$XDebuggerState";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBreakpointManagerState";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getWatchesManagerState";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 4: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "setBreakpointManagerState";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "setWatchesManagerState";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

