/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.tree;

import com.intellij.codeInsight.hint.HintManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.ui.Messages;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.util.Consumer;
import com.intellij.util.ui.JBUI;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueModifier;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.impl.ui.XDebuggerUIConstants;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreeInplaceEditor;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValuePresentationUtil;
import java.awt.Component;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SetValueInplaceEditor
extends XDebuggerTreeInplaceEditor {
    private final JPanel myEditorPanel;
    private final XValueModifier myModifier;
    private final XValueNodeImpl myValueNode;
    private final int myNameOffset;

    private SetValueInplaceEditor(XValueNodeImpl node, @NotNull String nodeName) {
        if (nodeName == null) {
            SetValueInplaceEditor.$$$reportNull$$$0(0);
        }
        super(node, "setValue");
        this.myValueNode = node;
        this.myModifier = ((XValue)this.myValueNode.getValueContainer()).getModifier();
        SimpleColoredComponent nameLabel = new SimpleColoredComponent();
        nameLabel.getIpad().right = 0;
        nameLabel.getIpad().left = 0;
        nameLabel.setIcon(this.myNode.getIcon());
        nameLabel.append(nodeName, XDebuggerUIConstants.VALUE_NAME_ATTRIBUTES);
        XValuePresentation presentation = node.getValuePresentation();
        if (presentation != null) {
            XValuePresentationUtil.appendSeparator((ColoredTextContainer)nameLabel, presentation.getSeparator());
        }
        Border border = nameLabel.getMyBorder();
        this.myNameOffset = nameLabel.getPreferredSize().width - (border != null ? border.getBorderInsets((Component)nameLabel).right : 0);
        this.myEditorPanel = JBUI.Panels.simplePanel((Component)this.myExpressionEditor.getComponent());
    }

    @Override
    @Nullable
    protected Rectangle getEditorBounds() {
        Rectangle bounds = super.getEditorBounds();
        if (bounds == null) {
            return null;
        }
        bounds.x += this.myNameOffset;
        bounds.width -= this.myNameOffset;
        return bounds;
    }

    public static void show(XValueNodeImpl node, @NotNull String nodeName) {
        if (nodeName == null) {
            SetValueInplaceEditor.$$$reportNull$$$0(1);
        }
        SetValueInplaceEditor editor = new SetValueInplaceEditor(node, nodeName);
        if (editor.myModifier != null) {
            editor.myModifier.calculateInitialValueEditorText(initialValue -> AppUIUtil.invokeOnEdt(() -> {
                if (editor.getTree().isShowing()) {
                    editor.show(initialValue);
                }
            }));
        } else {
            editor.show(null);
        }
    }

    private void show(String initialValue) {
        this.myExpressionEditor.setExpression(XExpressionImpl.fromText(initialValue));
        this.myExpressionEditor.selectAll();
        this.show();
    }

    @Override
    protected JComponent createInplaceEditorComponent() {
        return this.myEditorPanel;
    }

    @Override
    public void doOKAction() {
        if (this.myModifier == null) {
            return;
        }
        DebuggerUIUtil.setTreeNodeValue(this.myValueNode, this.getExpression().getExpression(), (Consumer<String>)((Consumer)errorMessage -> {
            Editor editor = this.getEditor();
            if (editor != null) {
                HintManager.getInstance().showErrorHint(editor, errorMessage);
            } else {
                Messages.showErrorDialog((Component)((Object)this.myTree), (String)errorMessage);
            }
        }));
        super.doOKAction();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "nodeName";
        objectArray2[1] = "com/intellij/xdebugger/impl/ui/tree/SetValueInplaceEditor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "show";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

