/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.jetbrains.python.psi.PyStringLiteralUtil;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PythonStringUtil {
    private PythonStringUtil() {
    }

    @NotNull
    public static String removeFirstPrefix(@Nullable String s, String separator) {
        int pos;
        if (s != null && (pos = s.indexOf(separator)) != -1) {
            String string = s.substring(pos + separator.length());
            if (string == null) {
                PythonStringUtil.$$$reportNull$$$0(0);
            }
            return string;
        }
        if ("" == null) {
            PythonStringUtil.$$$reportNull$$$0(1);
        }
        return "";
    }

    @NotNull
    public static String removeLastSuffix(@Nullable String s, String separator) {
        int pos;
        if (s != null && (pos = s.lastIndexOf(separator)) != -1) {
            String string = s.substring(0, pos);
            if (string == null) {
                PythonStringUtil.$$$reportNull$$$0(2);
            }
            return string;
        }
        if ("" == null) {
            PythonStringUtil.$$$reportNull$$$0(3);
        }
        return "";
    }

    public static boolean isPath(@Nullable String s) {
        if (!StringUtil.isEmpty((String)s)) {
            s = (String)ObjectUtils.assertNotNull((Object)s);
            s = FileUtil.toSystemIndependentName((String)s);
            List components = StringUtil.split((String)s, (String)"/");
            for (String name : components) {
                if (name == components.get(0) && SystemInfo.isWindows && name.endsWith(":") || PathUtil.isValidFileName((String)name)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isEmail(String s) {
        if (!StringUtil.isEmpty((String)s)) {
            Pattern p = Pattern.compile("^[\\w\\.-]+@([\\w\\-]+\\.)+[a-z]{2,4}$");
            Matcher m = p.matcher(s);
            return m.matches();
        }
        return false;
    }

    @NotNull
    public static String getFirstPrefix(String s, String separator) {
        int pos;
        if (s != null && (pos = s.indexOf(separator)) != -1) {
            String string = s.substring(0, pos);
            if (string == null) {
                PythonStringUtil.$$$reportNull$$$0(4);
            }
            return string;
        }
        String string = s != null ? s : "";
        if (string == null) {
            PythonStringUtil.$$$reportNull$$$0(5);
        }
        return string;
    }

    public static String getLastSuffix(String s, String separator) {
        int pos;
        if (s != null && (pos = s.lastIndexOf(separator)) != -1) {
            return s.substring(pos + 1);
        }
        return "";
    }

    public static String replaceLastSuffix(String s, String separator, String newElementName) {
        Pair<String, String> quotes = null;
        if (PyStringLiteralUtil.isQuoted(s)) {
            quotes = PyStringLiteralUtil.getQuotes(s);
            s = PyStringLiteralUtil.stripQuotesAroundValue(s);
        }
        if ((s = PythonStringUtil.removeLastSuffix(s, separator)).length() > 0) {
            s = s + separator;
        }
        s = s + newElementName;
        if (quotes != null) {
            s = (String)quotes.first + s + (String)quotes.second;
        }
        return s;
    }

    public static TextRange lastSuffixTextRange(@NotNull String text, String separator) {
        if (text == null) {
            PythonStringUtil.$$$reportNull$$$0(6);
        }
        int offset = text.lastIndexOf(separator) + 1;
        int length = text.length() - offset;
        return TextRange.from((int)(offset + 1), (int)length);
    }

    @Nullable
    public static String intersect(String fullName, String elementStringValue) {
        QualifiedName fullQName = QualifiedName.fromDottedString((String)fullName);
        QualifiedName stringQName = QualifiedName.fromDottedString((String)elementStringValue);
        String[] s1 = stringQName.getComponents().toArray(new String[stringQName.getComponentCount()]);
        String[] s2 = fullQName.getComponents().toArray(new String[fullQName.getComponentCount()]);
        for (int i = s1.length - 1; i >= 0; --i) {
            boolean flag = true;
            if (i > s2.length - 1) continue;
            for (int j = 0; j <= i; ++j) {
                if (s1[i - j].equals(s2[s2.length - j - 1])) continue;
                flag = false;
                break;
            }
            if (!flag) continue;
            StringBuilder res = new StringBuilder("");
            for (int j = 0; j <= i; ++j) {
                if (j > 0) {
                    res.append(".");
                }
                res.append(s1[j]);
            }
            return res.toString();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/PythonStringUtil";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "removeFirstPrefix";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "removeLastSuffix";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFirstPrefix";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/PythonStringUtil";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "lastSuffixTextRange";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

