/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.fstrings;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.psi.impl.PyStringLiteralExpressionImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class FStringParser {
    private final String myNodeText;
    private final TextRange myNodeContentRange;
    private final List<Fragment> myFragments;
    private final List<Integer> mySingleRightBraces;

    @NotNull
    public static ParseResult parse(@NotNull String nodeText) {
        if (nodeText == null) {
            FStringParser.$$$reportNull$$$0(0);
        }
        FStringParser parser = new FStringParser(nodeText);
        parser.parseTopLevel();
        ParseResult parseResult = new ParseResult(parser.mySingleRightBraces, parser.myFragments);
        if (parseResult == null) {
            FStringParser.$$$reportNull$$$0(1);
        }
        return parseResult;
    }

    private FStringParser(@NotNull String nodeText) {
        if (nodeText == null) {
            FStringParser.$$$reportNull$$$0(2);
        }
        this.myFragments = new ArrayList<Fragment>();
        this.mySingleRightBraces = new ArrayList<Integer>();
        this.myNodeText = nodeText;
        this.myNodeContentRange = PyStringLiteralExpressionImpl.getNodeTextRange(this.myNodeText);
    }

    private void parseTopLevel() {
        int offset = this.myNodeContentRange.getStartOffset();
        while (offset < this.myNodeContentRange.getEndOffset()) {
            char c2;
            int nextOffset = this.skipNamedUnicodeEscape(offset);
            if (offset != nextOffset) {
                offset = nextOffset;
                continue;
            }
            char c1 = this.myNodeText.charAt(offset);
            char c = c2 = offset + 1 < this.myNodeContentRange.getEndOffset() ? this.myNodeText.charAt(offset + 1) : (char)'\u0000';
            if (c1 == '{' && c2 == '{' || c1 == '}' && c2 == '}') {
                offset += 2;
                continue;
            }
            if (c1 == '{') {
                offset = this.parseFragment(offset, 1);
                continue;
            }
            if (c1 == '}') {
                this.mySingleRightBraces.add(offset);
            }
            ++offset;
        }
    }

    private int parseFragment(int leftBraceOffset, int depth) {
        assert (this.myNodeText.charAt(leftBraceOffset) == '{');
        int contentEndOffset = -1;
        int rightBraceOffset = -1;
        int bracesBalance = 0;
        char stringLiteralQuote = '\u0000';
        int quotesNum = 0;
        boolean containsNamedUnicodeEscape = false;
        int firstHashOffset = -1;
        int offset = leftBraceOffset + 1;
        while (offset < this.myNodeContentRange.getEndOffset()) {
            block14: {
                char c1;
                block12: {
                    char c2;
                    block17: {
                        block16: {
                            block15: {
                                char c3;
                                block13: {
                                    int nextOffset = this.skipNamedUnicodeEscape(offset);
                                    if (offset != nextOffset) {
                                        containsNamedUnicodeEscape = true;
                                        offset = nextOffset;
                                        continue;
                                    }
                                    c1 = this.myNodeText.charAt(offset);
                                    c2 = offset + 1 < this.myNodeContentRange.getEndOffset() ? this.myNodeText.charAt(offset + 1) : (char)'\u0000';
                                    char c = c3 = offset + 2 < this.myNodeContentRange.getEndOffset() ? this.myNodeText.charAt(offset + 2) : (char)'\u0000';
                                    if (contentEndOffset != -1) break block12;
                                    if (stringLiteralQuote == '\u0000') break block13;
                                    if (c1 == '\'' || c1 == '\"') {
                                        int size;
                                        int n = size = c2 == c1 && c3 == c1 ? 3 : 1;
                                        if (stringLiteralQuote == c1 && size == quotesNum) {
                                            stringLiteralQuote = '\u0000';
                                            offset += size;
                                            continue;
                                        }
                                    } else if (c1 == '\\') {
                                        offset += 2;
                                        continue;
                                    }
                                    break block14;
                                }
                                if (c1 == '\'' || c1 == '\"') {
                                    quotesNum = c2 == c1 && c3 == c1 ? 3 : 1;
                                    stringLiteralQuote = c1;
                                    offset += quotesNum;
                                    continue;
                                }
                                if (c1 != '#' || firstHashOffset != -1) break block15;
                                firstHashOffset = offset;
                                break block14;
                            }
                            if (c1 != '{' && c1 != '[' && c1 != '(') break block16;
                            ++bracesBalance;
                            break block14;
                        }
                        if (bracesBalance <= 0 || c1 != '}' && c1 != ']' && c1 != ')') break block17;
                        --bracesBalance;
                        break block14;
                    }
                    if (bracesBalance != 0 || c1 != '}' && (c1 != '!' || c2 == '=') && c1 != ':') break block14;
                    contentEndOffset = offset;
                    if (c1 == '}') {
                        rightBraceOffset = offset++;
                        break;
                    }
                    break block14;
                }
                if (c1 == '{') {
                    offset = this.parseFragment(offset, depth + 1);
                    continue;
                }
                if (c1 == '}') {
                    rightBraceOffset = offset++;
                    break;
                }
            }
            ++offset;
        }
        if (contentEndOffset == -1) {
            contentEndOffset = offset;
        }
        this.myFragments.add(new Fragment(leftBraceOffset, contentEndOffset, rightBraceOffset, containsNamedUnicodeEscape, firstHashOffset, depth));
        return offset;
    }

    private int skipNamedUnicodeEscape(int offset) {
        if (StringUtil.startsWith((CharSequence)this.myNodeText, (int)offset, (CharSequence)"\\N{")) {
            int rightBraceOffset = this.myNodeText.indexOf(125, offset + 3);
            return rightBraceOffset < 0 ? this.myNodeContentRange.getEndOffset() : rightBraceOffset + 1;
        }
        return offset;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeText";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/codeInsight/fstrings/FStringParser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/codeInsight/fstrings/FStringParser";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "parse";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ParseResult {
        private final List<Integer> mySingleRightBraces;
        private final List<Fragment> myFragments;

        private ParseResult(@NotNull List<Integer> singleRightBraces, @NotNull List<Fragment> fragments) {
            if (singleRightBraces == null) {
                ParseResult.$$$reportNull$$$0(0);
            }
            if (fragments == null) {
                ParseResult.$$$reportNull$$$0(1);
            }
            this.mySingleRightBraces = singleRightBraces;
            this.myFragments = ContainerUtil.sorted(fragments, (f1, f2) -> f1.getLeftBraceOffset() - f2.getLeftBraceOffset());
        }

        @NotNull
        public List<Integer> getSingleRightBraces() {
            List<Integer> list2 = Collections.unmodifiableList(this.mySingleRightBraces);
            if (list2 == null) {
                ParseResult.$$$reportNull$$$0(2);
            }
            return list2;
        }

        @NotNull
        public List<Fragment> getFragments() {
            List<Fragment> list2 = Collections.unmodifiableList(this.myFragments);
            if (list2 == null) {
                ParseResult.$$$reportNull$$$0(3);
            }
            return list2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "singleRightBraces";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fragments";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/codeInsight/fstrings/FStringParser$ParseResult";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/codeInsight/fstrings/FStringParser$ParseResult";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSingleRightBraces";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFragments";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class Fragment {
        private final int myLeftBraceOffset;
        private final int myRightBraceOffset;
        private final int myContentEndOffset;
        private final boolean myContainsNamedUnicodeEscape;
        private final int myFirstHashOffset;
        private int myDepth;

        private Fragment(int leftBraceOffset, int contentEndOffset, int rightBraceOffset, boolean containsUnicodeEscape, int firstHashOffset, int depth) {
            assert (leftBraceOffset < contentEndOffset);
            assert (rightBraceOffset < 0 || contentEndOffset <= rightBraceOffset);
            assert (firstHashOffset < 0 || leftBraceOffset < firstHashOffset && firstHashOffset < contentEndOffset);
            this.myLeftBraceOffset = leftBraceOffset;
            this.myRightBraceOffset = rightBraceOffset;
            this.myContentEndOffset = contentEndOffset;
            this.myContainsNamedUnicodeEscape = containsUnicodeEscape;
            this.myFirstHashOffset = firstHashOffset;
            this.myDepth = depth;
        }

        public int getLeftBraceOffset() {
            return this.myLeftBraceOffset;
        }

        public int getRightBraceOffset() {
            return this.myRightBraceOffset;
        }

        public int getContentEndOffset() {
            return this.myContentEndOffset;
        }

        public boolean containsNamedUnicodeEscape() {
            return this.myContainsNamedUnicodeEscape;
        }

        public int getFirstHashOffset() {
            return this.myFirstHashOffset;
        }

        public int getDepth() {
            return this.myDepth;
        }

        @NotNull
        public TextRange getContentRange() {
            TextRange textRange = TextRange.create((int)(this.myLeftBraceOffset + 1), (int)this.myContentEndOffset);
            if (textRange == null) {
                Fragment.$$$reportNull$$$0(0);
            }
            return textRange;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/fstrings/FStringParser$Fragment", "getContentRange"));
        }
    }
}

