/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.codeInsight.intentions.PyBaseIntentionAction;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyIfPart;
import com.jetbrains.python.psi.PyIfStatement;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import org.jetbrains.annotations.NotNull;

public class PySplitIfIntention
extends PyBaseIntentionAction {
    @NotNull
    public String getFamilyName() {
        String string = PyBundle.message("INTN.split.if", new Object[0]);
        if (string == null) {
            PySplitIfIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
        if (project == null) {
            PySplitIfIntention.$$$reportNull$$$0(1);
        }
        if (!(file2 instanceof PyFile)) {
            return false;
        }
        PsiElement elementAtOffset = file2.findElementAt(editor.getCaretModel().getOffset());
        if (elementAtOffset == null || elementAtOffset.getNode() == null) {
            return false;
        }
        IElementType elementType = elementAtOffset.getNode().getElementType();
        if (elementType == PyTokenTypes.COLON) {
            elementAtOffset = elementAtOffset.getPrevSibling();
            elementAtOffset = PyPsiUtils.getPrevNonCommentSibling(elementAtOffset, false);
        } else if (elementType == PyTokenTypes.IF_KEYWORD) {
            elementAtOffset = elementAtOffset.getNextSibling();
            elementAtOffset = PyPsiUtils.getNextNonCommentSibling(elementAtOffset, false);
        }
        PsiElement element = PsiTreeUtil.getParentOfType((PsiElement)elementAtOffset, PyBinaryExpression.class, (boolean)false);
        if (element == null) {
            return false;
        }
        while (element.getParent() instanceof PyBinaryExpression) {
            element = element.getParent();
        }
        if (((PyBinaryExpression)element).getOperator() != PyTokenTypes.AND_KEYWORD || ((PyBinaryExpression)element).getRightExpression() == null) {
            return false;
        }
        PsiElement parent = element.getParent();
        if (!(parent instanceof PyIfPart)) {
            return false;
        }
        this.setText(PyBundle.message("INTN.split.if.text", new Object[0]));
        return true;
    }

    @Override
    public void doInvoke(@NotNull Project project, Editor editor, PsiFile file2) throws IncorrectOperationException {
        PsiElement elementAtOffset;
        IElementType elementType;
        if (project == null) {
            PySplitIfIntention.$$$reportNull$$$0(2);
        }
        if ((elementType = (elementAtOffset = file2.findElementAt(editor.getCaretModel().getOffset())).getNode().getElementType()) == PyTokenTypes.COLON) {
            elementAtOffset = elementAtOffset.getPrevSibling();
            elementAtOffset = PyPsiUtils.getPrevNonCommentSibling(elementAtOffset, false);
        } else if (elementType == PyTokenTypes.IF_KEYWORD) {
            elementAtOffset = elementAtOffset.getNextSibling();
            elementAtOffset = PyPsiUtils.getNextNonCommentSibling(elementAtOffset, false);
        }
        PyBinaryExpression element = (PyBinaryExpression)PsiTreeUtil.getParentOfType((PsiElement)elementAtOffset, PyBinaryExpression.class, (boolean)false);
        while (element.getParent() instanceof PyBinaryExpression) {
            element = (PyBinaryExpression)element.getParent();
        }
        PyIfStatement ifStatement = (PyIfStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PyIfStatement.class);
        PyElementGenerator elementGenerator = PyElementGenerator.getInstance(project);
        PyIfStatement subIf = (PyIfStatement)ifStatement.copy();
        subIf.getIfPart().getCondition().replace((PsiElement)element.getRightExpression());
        ifStatement.getIfPart().getCondition().replace((PsiElement)element.getLeftExpression());
        PyStatementList statementList = elementGenerator.createFromText(LanguageLevel.getDefault(), PyIfStatement.class, "if a:\n    a = 1").getIfPart().getStatementList();
        statementList.getStatements()[0].replace((PsiElement)subIf);
        PyIfStatement newIf = elementGenerator.createFromText(LanguageLevel.getDefault(), PyIfStatement.class, "if a:\n    a = 1");
        newIf.getIfPart().getCondition().replace((PsiElement)ifStatement.getIfPart().getCondition());
        newIf.getIfPart().getStatementList().replace((PsiElement)statementList);
        for (PyIfPart elif : ifStatement.getElifParts()) {
            newIf.add((PsiElement)elif);
        }
        if (ifStatement.getElsePart() != null) {
            newIf.add((PsiElement)ifStatement.getElsePart());
        }
        ifStatement.replace((PsiElement)newIf);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/codeInsight/intentions/PySplitIfIntention";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/codeInsight/intentions/PySplitIfIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "doInvoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

