/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.configuration;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectSdksModel;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.FixedSizeButton;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ComboboxSpeedSearch;
import com.intellij.util.NullableConsumer;
import com.intellij.util.ui.JBUI;
import com.intellij.webcore.packaging.PackagesNotificationPanel;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.configuration.PyConfigurableInterpreterList;
import com.jetbrains.python.configuration.PythonSdkDetailsDialog;
import com.jetbrains.python.configuration.VirtualEnvProjectFilter;
import com.jetbrains.python.packaging.PyPackageManagers;
import com.jetbrains.python.packaging.ui.PyInstalledPackagesPanel;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.sdk.PyCustomSdkUiProvider;
import com.jetbrains.python.sdk.PySdkListCellRenderer;
import com.jetbrains.python.sdk.PythonSdkDetailsStep;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.sdk.PythonSdkUpdater;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import icons.PythonIcons;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyActiveSdkConfigurable
implements UnnamedConfigurable {
    @NotNull
    private final Project myProject;
    @Nullable
    private final Module myModule;
    private MySdkModelListener mySdkModelListener;
    private PyConfigurableInterpreterList myInterpreterList;
    private ProjectSdksModel myProjectSdksModel;
    private NullableConsumer<Sdk> myAddSdkCallback;
    private boolean mySdkSettingsWereModified;
    private JPanel myMainPanel;
    private ComboBox<Object> mySdkCombo;
    private PyInstalledPackagesPanel myPackagesPanel;
    private JButton myDetailsButton;
    private static final String SHOW_ALL = PyBundle.message("active.sdk.dialog.show.all.item", new Object[0]);
    private Set<Sdk> myInitialSdkSet;
    private Disposable myDisposable;

    public PyActiveSdkConfigurable(@NotNull Project project) {
        if (project == null) {
            PyActiveSdkConfigurable.$$$reportNull$$$0(0);
        }
        this.mySdkModelListener = new MySdkModelListener();
        this.mySdkSettingsWereModified = false;
        this.myDisposable = null;
        this.myModule = null;
        this.myProject = project;
        this.layoutPanel();
        this.initContent();
    }

    public PyActiveSdkConfigurable(@NotNull Module module2) {
        if (module2 == null) {
            PyActiveSdkConfigurable.$$$reportNull$$$0(1);
        }
        this.mySdkModelListener = new MySdkModelListener();
        this.mySdkSettingsWereModified = false;
        this.myDisposable = null;
        this.myModule = module2;
        this.myProject = module2.getProject();
        this.layoutPanel();
        this.initContent();
    }

    private void layoutPanel() {
        GridBagLayout layout = new GridBagLayout();
        this.myMainPanel = new JPanel(layout);
        JLabel interpreterLabel = new JLabel(PyBundle.message("active.sdk.dialog.project.interpreter", new Object[0]));
        JLabel emptyLabel = new JLabel("  ");
        this.mySdkCombo = new ComboBox<Object>(){

            public void setSelectedItem(Object item) {
                if (SHOW_ALL.equals(item)) {
                    ApplicationManager.getApplication().invokeLater(() -> {
                        PythonSdkDetailsDialog allDialog = PyActiveSdkConfigurable.this.myModule == null ? new PythonSdkDetailsDialog(PyActiveSdkConfigurable.this.myProject, (NullableConsumer<Sdk>)PyActiveSdkConfigurable.this.myAddSdkCallback, PyActiveSdkConfigurable.this.getSettingsModifiedCallback()) : new PythonSdkDetailsDialog(PyActiveSdkConfigurable.this.myModule, (NullableConsumer<Sdk>)PyActiveSdkConfigurable.this.myAddSdkCallback, PyActiveSdkConfigurable.this.getSettingsModifiedCallback());
                        allDialog.show();
                    });
                    return;
                }
                if (!"separator".equals(item)) {
                    super.setSelectedItem(item);
                }
            }

            public void paint(Graphics g) {
                try {
                    this.putClientProperty("JComboBox.isTableCellEditor", Boolean.FALSE);
                    super.paint(g);
                }
                finally {
                    this.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
                }
            }
        };
        new ComboboxSpeedSearch((JComboBox)this.mySdkCombo);
        this.mySdkCombo.putClientProperty((Object)"JComboBox.isTableCellEditor", (Object)Boolean.TRUE);
        PackagesNotificationPanel notificationsArea = new PackagesNotificationPanel();
        JComponent notificationsComponent = notificationsArea.getComponent();
        Dimension preferredSize = this.mySdkCombo.getPreferredSize();
        this.mySdkCombo.setPreferredSize(preferredSize);
        notificationsArea.hide();
        this.myDetailsButton = new FixedSizeButton();
        this.myDetailsButton.setIcon(PythonIcons.Python.InterpreterGear);
        this.myDetailsButton.setPreferredSize(new Dimension(preferredSize.height, preferredSize.height));
        this.myPackagesPanel = new PyInstalledPackagesPanel(this.myProject, notificationsArea);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.insets = JBUI.insets((int)2);
        c.gridx = 0;
        c.gridy = 0;
        this.myMainPanel.add((Component)interpreterLabel, c);
        c.gridx = 1;
        c.gridy = 0;
        c.weightx = 0.1;
        this.myMainPanel.add((Component)this.mySdkCombo, c);
        c.insets = JBUI.insets((int)2, (int)0, (int)2, (int)2);
        c.gridx = 2;
        c.gridy = 0;
        c.weightx = 0.0;
        this.myMainPanel.add((Component)this.myDetailsButton, c);
        PyCustomSdkUiProvider customUiProvider = PyCustomSdkUiProvider.getInstance();
        if (customUiProvider != null) {
            this.myDisposable = Disposer.newDisposable();
            customUiProvider.customizeActiveSdkPanel(this.myProject, this.mySdkCombo, this.myMainPanel, c, this.myDisposable);
        }
        c.insets = JBUI.insets((int)2, (int)2, (int)0, (int)2);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 3;
        c.weightx = 0.0;
        this.myMainPanel.add((Component)emptyLabel, c);
        c.gridx = 0;
        ++c.gridy;
        c.weighty = 1.0;
        c.gridwidth = 3;
        c.gridheight = -1;
        c.fill = 1;
        this.myMainPanel.add((Component)this.myPackagesPanel, c);
        c.gridheight = 0;
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 3;
        c.weighty = 0.0;
        c.fill = 2;
        c.anchor = 15;
        this.myMainPanel.add((Component)notificationsComponent, c);
    }

    @NotNull
    private Runnable getSettingsModifiedCallback() {
        Runnable runnable2 = () -> {
            this.mySdkSettingsWereModified = true;
        };
        if (runnable2 == null) {
            PyActiveSdkConfigurable.$$$reportNull$$$0(2);
        }
        return runnable2;
    }

    private void initContent() {
        this.myInterpreterList = PyConfigurableInterpreterList.getInstance(this.myProject);
        this.myProjectSdksModel = this.myInterpreterList.getModel();
        this.myInitialSdkSet = this.myProjectSdksModel.getProjectSdks().keySet();
        this.myProjectSdksModel.addListener(this.mySdkModelListener);
        this.mySdkCombo.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                Sdk selectedSdk = (Sdk)this.mySdkCombo.getSelectedItem();
                PyPackageManagers packageManagers = PyPackageManagers.getInstance();
                this.myPackagesPanel.updatePackages(selectedSdk != null ? packageManagers.getManagementService(this.myProject, selectedSdk) : null);
                this.myPackagesPanel.updateNotifications(selectedSdk);
            }
        });
        this.myAddSdkCallback = new SdkAddedCallback();
        this.myDetailsButton.addActionListener(e -> this.showDetails());
    }

    private void showDetails() {
        PythonSdkDetailsDialog allDialog = this.myModule == null ? new PythonSdkDetailsDialog(this.myProject, this.myAddSdkCallback, this.getSettingsModifiedCallback()) : new PythonSdkDetailsDialog(this.myModule, this.myAddSdkCallback, this.getSettingsModifiedCallback());
        PythonSdkDetailsStep.show(this.myProject, this.myProjectSdksModel.getSdks(), allDialog, this.myMainPanel, this.myDetailsButton.getLocationOnScreen(), null, this.myAddSdkCallback);
    }

    public JComponent createComponent() {
        return this.myMainPanel;
    }

    public boolean isModified() {
        Sdk sdk = this.getSdk();
        Sdk selectedSdk = this.getSelectedSdk();
        return this.mySdkSettingsWereModified || !Comparing.equal((Object)sdk, (Object)selectedSdk);
    }

    @Nullable
    private Sdk getSelectedSdk() {
        Sdk selectedItem = (Sdk)this.mySdkCombo.getSelectedItem();
        return selectedItem == null ? null : this.myProjectSdksModel.findSdk(selectedItem);
    }

    @Nullable
    protected Sdk getSdk() {
        if (this.myModule == null) {
            return ProjectRootManager.getInstance((Project)this.myProject).getProjectSdk();
        }
        ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)this.myModule);
        return rootManager.getSdk();
    }

    public void apply() throws ConfigurationException {
        this.mySdkSettingsWereModified = false;
        Sdk selectedSdk = this.getSelectedSdk();
        if (this.myInitialSdkSet.contains(selectedSdk) && selectedSdk != null) {
            PythonSdkUpdater.updateOrShowError(selectedSdk, null, this.myProject, null);
        }
        if (selectedSdk != null) {
            this.updateSdkList(false);
            this.myProjectSdksModel.apply();
            this.setSelectedSdk(selectedSdk);
        }
        Sdk prevSdk = this.getSdk();
        this.setSdk(selectedSdk);
        this.rehighlightVersionSpecific(selectedSdk, prevSdk);
    }

    private void setSelectedSdk(@Nullable Sdk selectedSdk) {
        this.mySdkCombo.getModel().setSelectedItem(selectedSdk == null ? null : this.myProjectSdksModel.findSdk(selectedSdk.getName()));
    }

    private void rehighlightVersionSpecific(@Nullable Sdk newSdk, @Nullable Sdk prevSdk) {
        if (prevSdk != null && newSdk != null) {
            PythonSdkFlavor flavor1 = PythonSdkFlavor.getFlavor(newSdk);
            PythonSdkFlavor flavor2 = PythonSdkFlavor.getFlavor(prevSdk);
            if (flavor1 != null && flavor2 != null) {
                LanguageLevel languageLevel1 = flavor1.getLanguageLevel(newSdk);
                LanguageLevel languageLevel2 = flavor2.getLanguageLevel(prevSdk);
                if (languageLevel1.isPy3K() && languageLevel2.isPython2() || languageLevel1.isPython2() && languageLevel2.isPy3K()) {
                    PyUtil.rehighlightOpenEditors(this.myProject);
                }
            }
        }
    }

    protected void setSdk(Sdk item) {
        ApplicationManager.getApplication().runWriteAction(() -> ProjectRootManager.getInstance((Project)this.myProject).setProjectSdk(item));
        if (this.myModule != null) {
            ModuleRootModificationUtil.setModuleSdk((Module)this.myModule, (Sdk)item);
        }
    }

    public void reset() {
        this.updateSdkList(false);
        Sdk sdk = this.getSdk();
        this.setSelectedSdk(sdk);
    }

    private void updateSdkList(boolean preserveSelection) {
        Sdk selection;
        List<Sdk> sdkList = this.myInterpreterList.getAllPythonSdks(this.myProject);
        Sdk sdk = selection = preserveSelection ? (Sdk)this.mySdkCombo.getSelectedItem() : null;
        if (!sdkList.contains(selection)) {
            selection = null;
        }
        VirtualEnvProjectFilter.removeNotMatching(this.myProject, sdkList);
        if (selection != null && !sdkList.contains(selection)) {
            sdkList.add(0, selection);
        }
        ArrayList<String> items = new ArrayList<String>();
        items.add(null);
        boolean remoteSeparator = true;
        boolean separator = true;
        for (Sdk sdk2 : sdkList) {
            if (PythonSdkType.isInvalid(sdk2) && !sdk2.equals(selection)) continue;
            if (!PythonSdkType.isVirtualEnv(sdk2) && !PythonSdkType.isRemote(sdk2) && separator) {
                items.add("separator");
                separator = false;
            }
            if (PythonSdkType.isRemote(sdk2) && remoteSeparator) {
                items.add("separator");
                remoteSeparator = false;
            }
            items.add((String)sdk2);
        }
        items.add("separator");
        items.add(SHOW_ALL);
        this.mySdkCombo.setRenderer((ListCellRenderer)((Object)new PySdkListCellRenderer(null)));
        this.mySdkCombo.setModel((ComboBoxModel)new CollectionComboBoxModel(items, (Object)selection));
    }

    public void disposeUIResources() {
        this.myProjectSdksModel.removeListener(this.mySdkModelListener);
        this.myInterpreterList.disposeModel();
        if (this.myDisposable != null) {
            Disposer.dispose((Disposable)this.myDisposable);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/configuration/PyActiveSdkConfigurable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/configuration/PyActiveSdkConfigurable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettingsModifiedCallback";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class SdkAddedCallback
    implements NullableConsumer<Sdk> {
        private SdkAddedCallback() {
        }

        public void consume(Sdk sdk) {
            if (sdk == null) {
                return;
            }
            if (PyActiveSdkConfigurable.this.myProjectSdksModel.findSdk(sdk.getName()) == null) {
                PyActiveSdkConfigurable.this.myProjectSdksModel.addSdk(sdk);
            }
            PyActiveSdkConfigurable.this.updateSdkList(false);
            PyActiveSdkConfigurable.this.setSelectedSdk(sdk);
        }
    }

    private class MySdkModelListener
    implements SdkModel.Listener {
        public void sdkAdded(Sdk sdk) {
            PyActiveSdkConfigurable.this.updateSdkList(true);
        }

        public void beforeSdkRemove(Sdk sdk) {
            PyActiveSdkConfigurable.this.updateSdkList(true);
        }

        public void sdkChanged(Sdk sdk, String previousName) {
            PyActiveSdkConfigurable.this.updateSdkList(true);
        }

        public void sdkHomeSelected(Sdk sdk, String newSdkHome) {
        }
    }
}

