/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.console;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.python.console.PyConsoleUtil;
import com.jetbrains.python.console.PydevConsoleCommunication;
import com.jetbrains.python.console.PythonConsoleView;
import com.jetbrains.python.run.PythonProcessHandler;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;

public class PyConsoleProcessHandler
extends PythonProcessHandler {
    private final PythonConsoleView myConsoleView;
    private final PydevConsoleCommunication myPydevConsoleCommunication;

    public PyConsoleProcessHandler(Process process2, PythonConsoleView consoleView, PydevConsoleCommunication pydevConsoleCommunication, @NotNull String commandLine, Charset charset) {
        if (commandLine == null) {
            PyConsoleProcessHandler.$$$reportNull$$$0(0);
        }
        super(process2, commandLine, charset);
        this.myConsoleView = consoleView;
        this.myPydevConsoleCommunication = pydevConsoleCommunication;
        Disposer.register((Disposable)consoleView, (Disposable)new Disposable(){

            public void dispose() {
                if (!PyConsoleProcessHandler.this.isProcessTerminated()) {
                    PyConsoleProcessHandler.this.destroyProcess();
                }
            }
        });
    }

    @Override
    public void coloredTextAvailable(@NotNull String text, @NotNull Key attributes) {
        if (text == null) {
            PyConsoleProcessHandler.$$$reportNull$$$0(1);
        }
        if (attributes == null) {
            PyConsoleProcessHandler.$$$reportNull$$$0(2);
        }
        String string = PyConsoleUtil.processPrompts(this.myConsoleView, StringUtil.convertLineSeparators((String)text));
        this.myConsoleView.print(string, attributes);
        this.notifyColoredListeners(text, attributes);
    }

    protected void closeStreams() {
        this.doCloseCommunication();
        super.closeStreams();
    }

    public boolean isSilentlyDestroyOnClose() {
        return !this.myPydevConsoleCommunication.isExecuting();
    }

    @Override
    public boolean shouldKillProcessSoftly() {
        return false;
    }

    private void doCloseCommunication() {
        if (this.myPydevConsoleCommunication != null) {
            UIUtil.invokeAndWaitIfNeeded(() -> {
                try {
                    this.myPydevConsoleCommunication.close();
                    Thread.sleep(300L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }
    }

    public PydevConsoleCommunication getPydevConsoleCommunication() {
        return this.myPydevConsoleCommunication;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/console/PyConsoleProcessHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "coloredTextAvailable";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

