/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.google.common.collect.Iterables;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.python.inspections.PyDunderSlotsInspection$Visitor$visitPyClass$;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PySequenceExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyType;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lcom/jetbrains/python/inspections/PyDunderSlotsInspection;", "Lcom/jetbrains/python/inspections/PyInspection;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "Visitor", "python-community"})
public final class PyDunderSlotsInspection
extends PyInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session2) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        Intrinsics.checkParameterIsNotNull((Object)session2, (String)"session");
        return new Visitor(holder, session2);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\nH\u0002J\u0018\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0012\u0010\u0019\u001a\u00020\u00102\b\u0010\u001a\u001a\u0004\u0018\u00010\nH\u0016J\u0012\u0010\u001b\u001a\u00020\u00102\b\u0010\u001a\u001a\u0004\u0018\u00010\u0012H\u0016\u00a8\u0006\u001c"}, d2={"Lcom/jetbrains/python/inspections/PyDunderSlotsInspection$Visitor;", "Lcom/jetbrains/python/inspections/PyInspectionVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "(Lcom/intellij/codeInspection/ProblemsHolder;Lcom/intellij/codeInspection/LocalInspectionToolSession;)V", "attributeIsWritable", "", "cls", "Lcom/jetbrains/python/psi/PyClass;", "name", "", "attributeIsWritableInPy2", "attributeIsWritableInPy3", "checkAttributeExpression", "", "target", "Lcom/jetbrains/python/psi/PyTargetExpression;", "findSlotsValue", "Lcom/jetbrains/python/psi/PyExpression;", "pyClass", "processSlot", "slot", "Lcom/jetbrains/python/psi/PyStringLiteralExpression;", "visitPyClass", "node", "visitPyTargetExpression", "python-community"})
    private static final class Visitor
    extends PyInspectionVisitor {
        @Override
        public void visitPyClass(@Nullable PyClass node) {
            super.visitPyClass(node);
            if (node != null && LanguageLevel.forElement((PsiElement)node).isAtLeast(LanguageLevel.PYTHON30)) {
                PyExpression slots = this.findSlotsValue(node);
                PyExpression pyExpression = slots;
                if (pyExpression instanceof PySequenceExpression) {
                    Sequence $receiver$iv;
                    Sequence sequence = ArraysKt.asSequence((Object[])((PySequenceExpression)slots).getElements());
                    Sequence sequence2 = SequencesKt.filter((Sequence)$receiver$iv, (Function1)Visitor$visitPyClass$$inlined$filterIsInstance$1.INSTANCE);
                    if (sequence2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.sequences.Sequence<R>");
                    }
                    $receiver$iv = sequence2;
                    for (Object element$iv : $receiver$iv) {
                        PyStringLiteralExpression it = (PyStringLiteralExpression)element$iv;
                        this.processSlot(node, it);
                    }
                } else if (pyExpression instanceof PyStringLiteralExpression) {
                    this.processSlot(node, (PyStringLiteralExpression)slots);
                }
            }
        }

        @Override
        public void visitPyTargetExpression(@Nullable PyTargetExpression node) {
            super.visitPyTargetExpression(node);
            if (node != null) {
                this.checkAttributeExpression(node);
            }
        }

        private final PyExpression findSlotsValue(PyClass pyClass) {
            PyTargetExpression target2;
            PyTargetExpression pyTargetExpression = target2 = pyClass.findClassAttribute("__slots__", false, this.myTypeEvalContext);
            PyExpression value = pyTargetExpression != null ? pyTargetExpression.findAssignedValue() : null;
            return PyPsiUtils.flattenParens(value);
        }

        private final void processSlot(PyClass pyClass, PyStringLiteralExpression slot) {
            String name = slot.getStringValue();
            if (pyClass.findClassAttribute(name, false, this.myTypeEvalContext) != null) {
                this.registerProblem(slot, '\'' + name + "' in __slots__ conflicts with class variable");
            }
        }

        private final void checkAttributeExpression(PyTargetExpression target2) {
            String targetName = target2.getName();
            PyExpression qualifier = target2.getQualifier();
            if (targetName == null || qualifier == null) {
                return;
            }
            PyType qualifierType = this.myTypeEvalContext.getType(qualifier);
            if (qualifierType instanceof PyClassType && !((PyClassType)qualifierType).isDefinition()) {
                PyClass qualifierClass;
                PyClass pyClass = qualifierClass = ((PyClassType)qualifierType).getPyClass();
                Intrinsics.checkExpressionValueIsNotNull((Object)pyClass, (String)"qualifierClass");
                if (!this.attributeIsWritable(pyClass, targetName)) {
                    this.registerProblem(target2, '\'' + qualifierClass.getName() + "' object attribute '" + targetName + "' is read-only");
                }
            }
        }

        private final boolean attributeIsWritable(PyClass cls, String name) {
            if (LanguageLevel.forElement((PsiElement)cls).isOlderThan(LanguageLevel.PYTHON30)) {
                return this.attributeIsWritableInPy2(cls, name);
            }
            return this.attributeIsWritableInPy3(cls, name);
        }

        private final boolean attributeIsWritableInPy2(PyClass cls, String name) {
            List<String> slots = cls.getSlots(this.myTypeEvalContext);
            return slots == null || slots.contains("__dict__") || slots.contains(name) && cls.findClassAttribute(name, true, this.myTypeEvalContext) == null || cls.findProperty(name, true, this.myTypeEvalContext) != null;
        }

        private final boolean attributeIsWritableInPy3(PyClass cls, String name) {
            boolean classAttrIsFound = false;
            boolean slotIsFound = false;
            for (PyClass c : Iterables.concat((Iterable)CollectionsKt.listOf((Object)cls), (Iterable)cls.getAncestorClasses(this.myTypeEvalContext))) {
                if (PyUtil.isObjectClass(c)) continue;
                List<String> ownSlots = c.getOwnSlots();
                if (ownSlots == null || ownSlots.contains("__dict__") || c.findProperty(name, false, this.myTypeEvalContext) != null) {
                    return true;
                }
                if (classAttrIsFound) continue;
                boolean bl = classAttrIsFound = c.findClassAttribute(name, false, this.myTypeEvalContext) != null;
                if (!ownSlots.contains(name)) continue;
                if (classAttrIsFound) {
                    return true;
                }
                slotIsFound = true;
            }
            return slotIsFound && !classAttrIsFound;
        }

        public Visitor(@NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session2) {
            Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
            Intrinsics.checkParameterIsNotNull((Object)session2, (String)"session");
            super(holder, session2);
        }
    }
}

