/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.packaging.ui;

import com.google.common.collect.Lists;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.CatchingConsumer;
import com.intellij.webcore.packaging.PackageVersionComparator;
import com.intellij.webcore.packaging.RepoPackage;
import com.jetbrains.python.packaging.PyCondaPackageManagerImpl;
import com.jetbrains.python.packaging.PyCondaPackageService;
import com.jetbrains.python.packaging.PyPackageManager;
import com.jetbrains.python.packaging.ui.PyPackageManagementService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PyCondaManagementService
extends PyPackageManagementService {
    private static final Logger LOG = Logger.getInstance(PyCondaManagementService.class);

    public PyCondaManagementService(@NotNull Project project, @NotNull Sdk sdk) {
        if (project == null) {
            PyCondaManagementService.$$$reportNull$$$0(0);
        }
        if (sdk == null) {
            PyCondaManagementService.$$$reportNull$$$0(1);
        }
        super(project, sdk);
    }

    private boolean useConda() {
        return PyPackageManager.getInstance(this.mySdk) instanceof PyCondaPackageManagerImpl && ((PyCondaPackageManagerImpl)PyPackageManager.getInstance(this.mySdk)).useConda();
    }

    @Override
    @NotNull
    public List<RepoPackage> getAllPackagesCached() {
        List<RepoPackage> list2 = this.useConda() ? PyCondaManagementService.versionMapToPackageList(PyCondaPackageService.getInstance().getCondaPackages()) : super.getAllPackagesCached();
        if (list2 == null) {
            PyCondaManagementService.$$$reportNull$$$0(2);
        }
        return list2;
    }

    @Override
    @NotNull
    public List<RepoPackage> getAllPackages() throws IOException {
        List<RepoPackage> list2 = this.useConda() ? PyCondaManagementService.versionMapToPackageList(PyCondaPackageService.getInstance().loadAndGetPackages(false)) : super.getAllPackages();
        if (list2 == null) {
            PyCondaManagementService.$$$reportNull$$$0(3);
        }
        return list2;
    }

    @Override
    @NotNull
    public List<RepoPackage> reloadAllPackages() throws IOException {
        List<RepoPackage> list2 = this.useConda() ? PyCondaManagementService.versionMapToPackageList(PyCondaPackageService.getInstance().loadAndGetPackages(true)) : super.reloadAllPackages();
        if (list2 == null) {
            PyCondaManagementService.$$$reportNull$$$0(4);
        }
        return list2;
    }

    @Override
    public List<String> getAllRepositories() {
        return this.useConda() ? Lists.newArrayList(PyCondaPackageService.getInstance().loadAndGetChannels()) : super.getAllRepositories();
    }

    @Override
    public void addRepository(String repositoryUrl) {
        if (this.useConda()) {
            String conda = PyCondaPackageService.getCondaExecutable(this.mySdk.getHomeDirectory());
            ArrayList parameters = Lists.newArrayList((Object[])new String[]{conda, "config", "--add", "channels", repositoryUrl, "--force"});
            GeneralCommandLine commandLine = new GeneralCommandLine((List)parameters);
            try {
                CapturingProcessHandler handler2 = new CapturingProcessHandler(commandLine);
                ProcessOutput result2 = handler2.runProcess();
                int exitCode = result2.getExitCode();
                if (exitCode != 0) {
                    String message = StringUtil.isEmptyOrSpaces((String)result2.getStdout()) && StringUtil.isEmptyOrSpaces((String)result2.getStderr()) ? "Permission denied" : "Non-zero exit code";
                    LOG.warn("Failed to add repository " + message);
                }
                PyCondaPackageService.getInstance().addChannel(repositoryUrl);
            }
            catch (ExecutionException e) {
                LOG.warn("Failed to add repository");
            }
        } else {
            super.addRepository(repositoryUrl);
        }
    }

    @Override
    public void removeRepository(String repositoryUrl) {
        if (this.useConda()) {
            String conda = PyCondaPackageService.getCondaExecutable(this.mySdk.getHomeDirectory());
            ArrayList parameters = Lists.newArrayList((Object[])new String[]{conda, "config", "--remove", "channels", repositoryUrl, "--force"});
            GeneralCommandLine commandLine = new GeneralCommandLine((List)parameters);
            try {
                CapturingProcessHandler handler2 = new CapturingProcessHandler(commandLine);
                ProcessOutput result2 = handler2.runProcess();
                int exitCode = result2.getExitCode();
                if (exitCode != 0) {
                    String message = StringUtil.isEmptyOrSpaces((String)result2.getStdout()) && StringUtil.isEmptyOrSpaces((String)result2.getStderr()) ? "Permission denied" : "Non-zero exit code";
                    LOG.warn("Failed to remove repository " + message);
                }
                PyCondaPackageService.getInstance().removeChannel(repositoryUrl);
            }
            catch (ExecutionException e) {
                LOG.warn("Failed to remove repository");
            }
        } else {
            super.removeRepository(repositoryUrl);
        }
    }

    @Override
    public boolean canInstallToUser() {
        return !this.useConda() && super.canInstallToUser();
    }

    @Override
    public void fetchPackageVersions(String packageName, CatchingConsumer<List<String>, Exception> consumer) {
        if (this.useConda()) {
            List<String> versions = PyCondaPackageService.getInstance().getPackageVersions(packageName);
            Collections.sort(versions, Collections.reverseOrder(new PackageVersionComparator()));
            consumer.consume(versions);
        } else {
            super.fetchPackageVersions(packageName, consumer);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/packaging/ui/PyCondaManagementService";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/packaging/ui/PyCondaManagementService";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllPackagesCached";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllPackages";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "reloadAllPackages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

