/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.search;

import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.Property;
import com.jetbrains.python.psi.PyCallable;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.search.PyClassInheritorsSearch;
import com.jetbrains.python.psi.search.PyOverridingMethodsSearch;
import org.jetbrains.annotations.NotNull;

public class PyOverridingMethodsSearchExecutor
implements QueryExecutor<PyFunction, PyOverridingMethodsSearch.SearchParameters> {
    public boolean execute(@NotNull PyOverridingMethodsSearch.SearchParameters queryParameters, @NotNull Processor<PyFunction> consumer) {
        if (queryParameters == null) {
            PyOverridingMethodsSearchExecutor.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            PyOverridingMethodsSearchExecutor.$$$reportNull$$$0(1);
        }
        PyFunction baseMethod = queryParameters.getFunction();
        PyClass containingClass = (PyClass)ReadAction.compute(() -> baseMethod.getContainingClass());
        return PyClassInheritorsSearch.search(containingClass, queryParameters.isCheckDeep()).forEach(pyClass -> {
            PyFunction overridingMethod;
            if (consumer == null) {
                PyOverridingMethodsSearchExecutor.$$$reportNull$$$0(2);
            }
            AccessToken accessToken = ApplicationManager.getApplication().acquireReadActionLock();
            try {
                overridingMethod = pyClass.findMethodByName(baseMethod.getName(), false, null);
                if (overridingMethod != null) {
                    Property baseProperty = baseMethod.getProperty();
                    Property overridingProperty = overridingMethod.getProperty();
                    if (baseProperty != null && overridingProperty != null) {
                        AccessDirection direction = PyUtil.getPropertyAccessDirection(baseMethod);
                        PyCallable callable = overridingProperty.getByDirection(direction).valueOrNull();
                        overridingMethod = callable instanceof PyFunction ? (PyFunction)callable : null;
                    }
                }
            }
            finally {
                accessToken.finish();
            }
            if (overridingMethod != null) {
                return consumer.process((Object)overridingMethod);
            }
            return true;
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queryParameters";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/psi/search/PyOverridingMethodsSearchExecutor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "execute";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$execute$1";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

