/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.classes.membersManager;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.NotNullPredicate;
import com.jetbrains.python.codeInsight.imports.AddImportHelper;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyFunctionBuilder;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.refactoring.classes.PyClassRefactoringUtil;
import com.jetbrains.python.refactoring.classes.membersManager.MembersManager;
import com.jetbrains.python.refactoring.classes.membersManager.NamePredicate;
import com.jetbrains.python.refactoring.classes.membersManager.NamelessFilter;
import com.jetbrains.python.refactoring.classes.membersManager.PyMemberInfo;
import com.jetbrains.python.refactoring.classes.membersManager.PyRecursiveElementVisitorWithResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class MethodsManager
extends MembersManager<PyFunction> {
    private static final String[] DECORATORS_MAY_BE_COPIED_TO_ABSTRACT = new String[]{"property", "classmethod", "staticmethod"};
    public static final String ABC_META_PACKAGE = "abc";
    private static final NoPropertiesPredicate NO_PROPERTIES = new NoPropertiesPredicate();

    MethodsManager() {
        super(PyFunction.class);
    }

    @Override
    public boolean hasConflict(@NotNull PyFunction member, @NotNull PyClass aClass) {
        if (member == null) {
            MethodsManager.$$$reportNull$$$0(0);
        }
        if (aClass == null) {
            MethodsManager.$$$reportNull$$$0(1);
        }
        return NamePredicate.hasElementWithSameName((NavigationItem)member, Arrays.asList(aClass.getMethods()));
    }

    @Override
    @NotNull
    protected Collection<PyElement> getDependencies(@NotNull MultiMap<PyClass, PyElement> usedElements) {
        if (usedElements == null) {
            MethodsManager.$$$reportNull$$$0(2);
        }
        List<PyElement> list2 = Collections.emptyList();
        if (list2 == null) {
            MethodsManager.$$$reportNull$$$0(3);
        }
        return list2;
    }

    @Override
    @NotNull
    protected MultiMap<PyClass, PyElement> getDependencies(@NotNull PyElement member) {
        if (member == null) {
            MethodsManager.$$$reportNull$$$0(4);
        }
        MyPyRecursiveElementVisitor visitor2 = new MyPyRecursiveElementVisitor();
        member.accept(visitor2);
        MultiMap multiMap = visitor2.myResult;
        if (multiMap == null) {
            MethodsManager.$$$reportNull$$$0(5);
        }
        return multiMap;
    }

    @Override
    @NotNull
    protected List<? extends PyElement> getMembersCouldBeMoved(@NotNull PyClass pyClass) {
        if (pyClass == null) {
            MethodsManager.$$$reportNull$$$0(6);
        }
        ImmutableList immutableList = FluentIterable.from(Arrays.asList(pyClass.getMethods())).filter(new NamelessFilter()).filter((Predicate)NO_PROPERTIES).toList();
        if (immutableList == null) {
            MethodsManager.$$$reportNull$$$0(7);
        }
        return immutableList;
    }

    @Override
    protected Collection<PyElement> moveMembers(@NotNull PyClass from, @NotNull Collection<PyMemberInfo<PyFunction>> members, PyClass ... to) {
        if (from == null) {
            MethodsManager.$$$reportNull$$$0(8);
        }
        if (members == null) {
            MethodsManager.$$$reportNull$$$0(9);
        }
        if (to == null) {
            MethodsManager.$$$reportNull$$$0(10);
        }
        Collection<PyFunction> methodsToMove = MethodsManager.fetchElements(Collections2.filter(members, (Predicate)new AbstractFilter(false)));
        Collection<PyFunction> methodsToAbstract = MethodsManager.fetchElements(Collections2.filter(members, (Predicate)new AbstractFilter(true)));
        MethodsManager.makeMethodsAbstract(methodsToAbstract, to);
        return MethodsManager.moveMethods(from, methodsToMove, true, to);
    }

    private static void makeMethodsAbstract(Collection<PyFunction> currentFunctions, PyClass ... to) {
        HashSet<PsiFile> filesToCheckImport = new HashSet<PsiFile>();
        HashSet<PyClass> classesToAddMetaAbc = new HashSet<PyClass>();
        for (PyFunction function : currentFunctions) {
            for (PyClass destClass : to) {
                PyFunctionBuilder functionBuilder = PyFunctionBuilder.copySignature(function, DECORATORS_MAY_BE_COPIED_TO_ABSTRACT);
                functionBuilder.decorate("abstractmethod");
                LanguageLevel level = LanguageLevel.forElement((PsiElement)destClass);
                PyClassRefactoringUtil.addMethods(destClass, false, functionBuilder.buildFunction(destClass.getProject(), level));
                classesToAddMetaAbc.add(destClass);
            }
        }
        for (PyClass aClass : classesToAddMetaAbc) {
            if (!MethodsManager.addMetaAbcIfNeeded(aClass)) continue;
            filesToCheckImport.add(aClass.getContainingFile());
        }
        for (PsiFile file2 : filesToCheckImport) {
            MethodsManager.addImportFromAbc(file2, "abstractmethod");
            MethodsManager.addImportFromAbc(file2, "ABCMeta");
            PyClassRefactoringUtil.optimizeImports(file2);
        }
    }

    private static boolean addMetaAbcIfNeeded(@NotNull PyClass aClass) {
        if (aClass == null) {
            MethodsManager.$$$reportNull$$$0(11);
        }
        PsiFile file2 = aClass.getContainingFile();
        PyType type = aClass.getMetaClassType(TypeEvalContext.userInitiated(aClass.getProject(), file2));
        if (type != null) {
            return false;
        }
        LanguageLevel languageLevel = LanguageLevel.forElement((PsiElement)aClass);
        if (languageLevel.isPy3K()) {
            PyClassRefactoringUtil.addSuperClassExpressions(aClass.getProject(), aClass, null, Collections.singletonList(Pair.create((Object)"metaclass", (Object)"ABCMeta")));
        } else {
            PyClassRefactoringUtil.addClassAttributeIfNotExist(aClass, "__metaclass__", "ABCMeta");
        }
        return true;
    }

    private static void addImportFromAbc(@NotNull PsiFile file2, @NotNull String nameToImport) {
        if (file2 == null) {
            MethodsManager.$$$reportNull$$$0(12);
        }
        if (nameToImport == null) {
            MethodsManager.$$$reportNull$$$0(13);
        }
        AddImportHelper.addOrUpdateFromImportStatement(file2, ABC_META_PACKAGE, nameToImport, null, AddImportHelper.ImportPriority.BUILTIN, null);
    }

    static List<PyElement> moveMethods(PyClass from, Collection<PyFunction> methodsToMove, boolean skipIfExist, PyClass ... to) {
        ArrayList<PyElement> result2 = new ArrayList<PyElement>();
        for (PyClass destClass : to) {
            ArrayList<PyFunction> copies = new ArrayList<PyFunction>(methodsToMove.size());
            for (PyFunction element : methodsToMove) {
                PyFunction newMethod = (PyFunction)element.copy();
                copies.add(newMethod);
            }
            result2.addAll(PyClassRefactoringUtil.copyMethods(copies, destClass, skipIfExist));
        }
        MethodsManager.deleteElements(methodsToMove);
        return result2;
    }

    @Override
    @NotNull
    public PyMemberInfo<PyFunction> apply(@NotNull PyFunction pyFunction) {
        if (pyFunction == null) {
            MethodsManager.$$$reportNull$$$0(14);
        }
        PyUtil.MethodFlags flags = PyUtil.MethodFlags.of(pyFunction);
        assert (flags != null) : "No flags return while element is function " + pyFunction;
        boolean isStatic = flags.isStaticMethod() || flags.isClassMethod();
        PyMemberInfo<PyFunction> pyMemberInfo = new PyMemberInfo<PyFunction>(pyFunction, isStatic, MethodsManager.buildDisplayMethodName(pyFunction), MethodsManager.isOverrides(pyFunction), this, MethodsManager.couldBeAbstract(pyFunction));
        if (pyMemberInfo == null) {
            MethodsManager.$$$reportNull$$$0(15);
        }
        return pyMemberInfo;
    }

    private static boolean couldBeAbstract(@NotNull PyFunction function) {
        if (function == null) {
            MethodsManager.$$$reportNull$$$0(16);
        }
        if (PyUtil.isInit(function)) {
            return false;
        }
        PyUtil.MethodFlags flags = PyUtil.MethodFlags.of(function);
        assert (flags != null) : "Function should be called on method!";
        boolean py3K = LanguageLevel.forElement(function).isPy3K();
        return flags.isInstanceMethod() || py3K;
    }

    @Nullable
    private static Boolean isOverrides(PyFunction pyFunction) {
        PyClass clazz = PyUtil.getContainingClassOrSelf(pyFunction);
        assert (clazz != null) : "Refactoring called on function, not method: " + pyFunction;
        for (PyClass parentClass : clazz.getSuperClasses(null)) {
            PyFunction parentMethod = parentClass.findMethodByName(pyFunction.getName(), true, null);
            if (parentMethod == null) continue;
            return true;
        }
        return null;
    }

    @NotNull
    private static String buildDisplayMethodName(@NotNull PyFunction pyFunction) {
        PyParameter[] arguments;
        if (pyFunction == null) {
            MethodsManager.$$$reportNull$$$0(17);
        }
        StringBuilder builder = new StringBuilder(pyFunction.getName());
        builder.append('(');
        for (PyParameter parameter : arguments = pyFunction.getParameterList().getParameters()) {
            builder.append(parameter.getName());
            if (arguments.length <= 1 || parameter == arguments[arguments.length - 1]) continue;
            builder.append(", ");
        }
        builder.append(')');
        String string = builder.toString();
        if (string == null) {
            MethodsManager.$$$reportNull$$$0(18);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 15: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 15: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 1: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usedElements";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/refactoring/classes/membersManager/MethodsManager";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pyClass";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "members";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameToImport";
                break;
            }
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pyFunction";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/refactoring/classes/membersManager/MethodsManager";
                break;
            }
            case 3: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencies";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getMembersCouldBeMoved";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "apply";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "buildDisplayMethodName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "hasConflict";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getDependencies";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 15: 
            case 18: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getMembersCouldBeMoved";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "moveMembers";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addMetaAbcIfNeeded";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addImportFromAbc";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "couldBeAbstract";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "buildDisplayMethodName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 15: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class NoPropertiesPredicate
    implements Predicate<PyFunction> {
        private NoPropertiesPredicate() {
        }

        public boolean apply(@NotNull PyFunction input) {
            if (input == null) {
                NoPropertiesPredicate.$$$reportNull$$$0(0);
            }
            return input.getProperty() == null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/jetbrains/python/refactoring/classes/membersManager/MethodsManager$NoPropertiesPredicate", "apply"));
        }
    }

    private static class MyPyRecursiveElementVisitor
    extends PyRecursiveElementVisitorWithResult {
        private MyPyRecursiveElementVisitor() {
        }

        @Override
        public void visitPyCallExpression(PyCallExpression node) {
            PyFunction calleeFunction;
            PyClass clazz;
            PsiElement calleeDeclaration;
            PsiReference calleeRef;
            PyExpression callee = node.getCallee();
            if (callee != null && (calleeRef = callee.getReference()) != null && (calleeDeclaration = calleeRef.resolve()) instanceof PyFunction && (clazz = (calleeFunction = (PyFunction)calleeDeclaration).getContainingClass()) != null) {
                if (PyUtil.isInit(calleeFunction)) {
                    return;
                }
                this.myResult.putValue((Object)clazz, (Object)calleeFunction);
            }
        }
    }

    private static class AbstractFilter
    extends NotNullPredicate<PyMemberInfo<PyFunction>> {
        private final boolean myAllowAbstractOnly;

        private AbstractFilter(boolean allowAbstractOnly) {
            this.myAllowAbstractOnly = allowAbstractOnly;
        }

        @Override
        protected boolean applyNotNull(@NotNull PyMemberInfo<PyFunction> input) {
            if (input == null) {
                AbstractFilter.$$$reportNull$$$0(0);
            }
            return input.isToAbstract() == this.myAllowAbstractOnly;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/jetbrains/python/refactoring/classes/membersManager/MethodsManager$AbstractFilter", "applyNotNull"));
        }
    }
}

