/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.add;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.util.PathUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.ui.FormBuilder;
import com.jetbrains.python.packaging.PyPackageManager;
import com.jetbrains.python.sdk.PyDetectedSdk;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.PySdkSettings;
import com.jetbrains.python.sdk.add.PyAddNewEnvPanel;
import com.jetbrains.python.sdk.add.PyAddSdkPanel;
import com.jetbrains.python.sdk.add.PySdkPathChoosingComboBox;
import icons.PythonIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B'\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0016J\u001a\u0010)\u001a\u00020&2\u0006\u0010\u001c\u001a\u00020\b2\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0002J\n\u0010*\u001a\u0004\u0018\u00010\u0006H\u0016J\u000e\u0010+\u001a\b\u0012\u0004\u0012\u00020,0\u0005H\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\u0016\u001a\u0004\u0018\u00010\b@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u000e\"\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u000eR\u0011\u0010\u001c\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u000eR\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010 \u001a\u00070\b\u00a2\u0006\u0002\b!8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u000eR\u0019\u0010#\u001a\u00070\b\u00a2\u0006\u0002\b!8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u000e\u00a8\u0006-"}, d2={"Lcom/jetbrains/python/sdk/add/PyAddNewVirtualEnvPanel;", "Lcom/jetbrains/python/sdk/add/PyAddNewEnvPanel;", "project", "Lcom/intellij/openapi/project/Project;", "existingSdks", "", "Lcom/intellij/openapi/projectRoots/Sdk;", "newProjectPath", "", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;Ljava/lang/String;)V", "baseSdkField", "Lcom/jetbrains/python/sdk/add/PySdkPathChoosingComboBox;", "envName", "getEnvName", "()Ljava/lang/String;", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "inheritSitePackagesField", "Lcom/intellij/ui/components/JBCheckBox;", "makeSharedField", "value", "getNewProjectPath", "setNewProjectPath", "(Ljava/lang/String;)V", "panelName", "getPanelName", "path", "getPath", "pathField", "Lcom/intellij/openapi/ui/TextFieldWithBrowseButton;", "projectBasePath", "Lorg/jetbrains/annotations/SystemIndependent;", "getProjectBasePath", "userHome", "getUserHome", "addChangeListener", "", "listener", "Ljava/lang/Runnable;", "excludeDirectoryFromProject", "getOrCreateSdk", "validateAll", "Lcom/intellij/openapi/ui/ValidationInfo;", "python-community"})
public final class PyAddNewVirtualEnvPanel
extends PyAddNewEnvPanel {
    @NotNull
    private final String envName = "Virtualenv";
    @Nullable
    private String newProjectPath;
    @NotNull
    private final String panelName = "New environment";
    @NotNull
    private final Icon icon;
    private final PySdkPathChoosingComboBox baseSdkField;
    private final TextFieldWithBrowseButton pathField;
    private final JBCheckBox inheritSitePackagesField;
    private final JBCheckBox makeSharedField;
    private final Project project;
    private final List<Sdk> existingSdks;

    @Override
    @NotNull
    public String getEnvName() {
        return this.envName;
    }

    @Override
    @Nullable
    public String getNewProjectPath() {
        return this.newProjectPath;
    }

    @Override
    public void setNewProjectPath(@Nullable String value) {
        this.newProjectPath = value;
        this.pathField.setText(FileUtil.toSystemDependentName((String)PySdkSettings.Companion.getInstance().getPreferredVirtualEnvBasePath(this.getProjectBasePath())));
    }

    @NotNull
    public final String getPath() {
        String string;
        String string2 = string = this.pathField.getText();
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        return ((Object)StringsKt.trim((CharSequence)string2)).toString();
    }

    @Override
    @NotNull
    public String getPanelName() {
        return this.panelName;
    }

    @Override
    @NotNull
    public Icon getIcon() {
        return this.icon;
    }

    @Override
    @NotNull
    public List<ValidationInfo> validateAll() {
        return CollectionsKt.filterNotNull((Iterable)CollectionsKt.listOf((Object[])new ValidationInfo[]{PyAddSdkPanel.Companion.validateEmptyOrNonExistingDirectoryLocation(this.pathField), PyAddSdkPanel.Companion.validateSdkComboBox(this.baseSdkField)}));
    }

    @Override
    @Nullable
    public Sdk getOrCreateSdk() {
        PySdkSettings pySdkSettings;
        String string;
        String root = this.pathField.getText();
        Task.WithResult<String, ExecutionException> task2 = new Task.WithResult<String, ExecutionException>(this, root, this.project, "Creating Virtual Environment", false){
            final /* synthetic */ PyAddNewVirtualEnvPanel this$0;
            final /* synthetic */ String $root;

            @NotNull
            protected String compute(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
                indicator.setIndeterminate(true);
                Sdk sdk = PyAddNewVirtualEnvPanel.access$getBaseSdkField$p(this.this$0).getSelectedSdk();
                if (sdk == null) {
                    throw (Throwable)new ExecutionException("No base interpreter selected");
                }
                Sdk baseSdk = sdk;
                PyPackageManager packageManager = PyPackageManager.getInstance(baseSdk);
                String string = packageManager.createVirtualEnv(this.$root, PyAddNewVirtualEnvPanel.access$getInheritSitePackagesField$p(this.this$0).isSelected());
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"packageManager.createVir\u2026PackagesField.isSelected)");
                return string;
            }
            {
                this.this$0 = $outer;
                this.$root = $captured_local_variable$1;
                super($super_call_param$2, $super_call_param$3, $super_call_param$4);
            }
        };
        boolean shared = this.makeSharedField.isSelected();
        if (!shared) {
            string = this.getNewProjectPath();
            if (string == null) {
                Project project = this.project;
                string = project != null ? project.getBasePath() : null;
            }
        } else {
            string = null;
        }
        String associatedPath = string;
        Sdk sdk = PySdkExtKt.createSdkByGenerateTask((Task.WithResult<String, ExecutionException>)((Task.WithResult)task2), this.existingSdks, this.baseSdkField.getSelectedSdk(), associatedPath);
        if (sdk == null) {
            return null;
        }
        Sdk sdk2 = sdk;
        if (!shared) {
            PySdkExtKt.associateWithProject(sdk2, this.project, this.getNewProjectPath() != null);
        }
        String string2 = root;
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"root");
        this.excludeDirectoryFromProject(string2, this.project);
        PySdkSettings $receiver = pySdkSettings = PySdkSettings.Companion.getInstance();
        String string3 = FileUtil.toSystemIndependentName((String)this.pathField.getText());
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"FileUtil.toSystemIndependentName(pathField.text)");
        $receiver.setPreferredVirtualEnvBasePath(string3, this.getProjectBasePath());
        Sdk sdk3 = this.baseSdkField.getSelectedSdk();
        $receiver.setPreferredVirtualEnvBaseSdk(sdk3 != null ? sdk3.getHomePath() : null);
        return sdk2;
    }

    @Override
    public void addChangeListener(@NotNull Runnable listener2) {
        Intrinsics.checkParameterIsNotNull((Object)listener2, (String)"listener");
        this.pathField.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(listener2){
            final /* synthetic */ Runnable $listener;

            protected void textChanged(@Nullable DocumentEvent e) {
                this.$listener.run();
            }
            {
                this.$listener = $captured_local_variable$0;
            }
        });
        ((JComboBox)this.baseSdkField.getChildComponent()).addItemListener(new ItemListener(listener2){
            final /* synthetic */ Runnable $listener;

            public final void itemStateChanged(ItemEvent it) {
                this.$listener.run();
            }
            {
                this.$listener = runnable2;
            }
        });
    }

    private final void excludeDirectoryFromProject(String path, Project project) {
        Object object;
        ModifiableRootModel model;
        VirtualFile rootFile;
        block4: {
            List possibleProjects = project != null ? CollectionsKt.listOf((Object)project) : ArraysKt.asList((Object[])ProjectManager.getInstance().getOpenProjects());
            VirtualFile virtualFile = StandardFileSystems.local().refreshAndFindFileByPath(path);
            if (virtualFile == null) {
                return;
            }
            rootFile = virtualFile;
            Module module2 = (Module)SequencesKt.firstOrNull((Sequence)SequencesKt.filterNotNull((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)possibleProjects), (Function1)((Function1)new Function1<Project, Module>(rootFile){
                final /* synthetic */ VirtualFile $rootFile;

                @Nullable
                public final Module invoke(@NotNull Project it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return ModuleUtil.findModuleForFile((VirtualFile)this.$rootFile, (Project)it);
                }
                {
                    this.$rootFile = virtualFile;
                    super(1);
                }
            }))));
            if (module2 == null) {
                return;
            }
            Module module3 = module2;
            model = ModuleRootManager.getInstance((Module)module3).getModifiableModel();
            Object[] $receiver$iv = model.getContentEntries();
            for (int i = 0; i < $receiver$iv.length; ++i) {
                Object element$iv = $receiver$iv[i];
                ContentEntry it = (ContentEntry)element$iv;
                VirtualFile contentFile = it.getFile();
                boolean bl = contentFile != null && VfsUtil.isAncestor((VirtualFile)contentFile, (VirtualFile)rootFile, (boolean)true);
                if (!bl) continue;
                object = element$iv;
                break block4;
            }
            object = null;
        }
        ContentEntry contentEntry = (ContentEntry)object;
        if (contentEntry == null) {
            return;
        }
        ContentEntry contentEntry2 = contentEntry;
        contentEntry2.addExcludeFolder(rootFile);
        WriteAction.run((ThrowableRunnable)new ThrowableRunnable<E>(model){
            final /* synthetic */ ModifiableRootModel $model;

            public final void run() {
                this.$model.commit();
            }
            {
                this.$model = modifiableRootModel;
            }
        });
    }

    private final String getProjectBasePath() {
        String string;
        String string2 = this.getNewProjectPath();
        if (string2 == null) {
            Project project = this.project;
            string2 = string = project != null ? project.getBasePath() : null;
        }
        if (string2 == null) {
            string = this.getUserHome();
        }
        return string;
    }

    private final String getUserHome() {
        String string = FileUtil.toSystemIndependentName((String)SystemProperties.getUserHome());
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"FileUtil.toSystemIndepen\u2026Properties.getUserHome())");
        return string;
    }

    public PyAddNewVirtualEnvPanel(@Nullable Project project, @NotNull List<? extends Sdk> existingSdks, @Nullable String newProjectPath) {
        PySdkPathChoosingComboBox pySdkPathChoosingComboBox;
        Sdk sdk;
        Object v1;
        Object object;
        String preferredSdkPath;
        PySdkPathChoosingComboBox $receiver;
        PyAddNewVirtualEnvPanel pyAddNewVirtualEnvPanel;
        PySdkPathChoosingComboBox pySdkPathChoosingComboBox2;
        block5: {
            Intrinsics.checkParameterIsNotNull(existingSdks, (String)"existingSdks");
            this.project = project;
            this.existingSdks = existingSdks;
            this.envName = "Virtualenv";
            this.newProjectPath = newProjectPath;
            this.panelName = "New environment";
            Icon icon = PythonIcons.Python.Virtualenv;
            Intrinsics.checkExpressionValueIsNotNull((Object)icon, (String)"PythonIcons.Python.Virtualenv");
            this.icon = icon;
            pySdkPathChoosingComboBox2 = new PySdkPathChoosingComboBox(PySdkExtKt.findBaseSdks(this.existingSdks), null);
            pyAddNewVirtualEnvPanel = this;
            $receiver = pySdkPathChoosingComboBox2;
            preferredSdkPath = PySdkSettings.Companion.getInstance().getPreferredVirtualEnvBaseSdk();
            Iterable iterable = object = (Iterable)$receiver.getItems();
            for (Object t : iterable) {
                Sdk it = (Sdk)t;
                if (!Intrinsics.areEqual((Object)it.getHomePath(), (Object)preferredSdkPath)) continue;
                v1 = t;
                break block5;
            }
            v1 = null;
        }
        Sdk detectedPreferredSdk = v1;
        PySdkPathChoosingComboBox pySdkPathChoosingComboBox3 = $receiver;
        if (detectedPreferredSdk != null) {
            sdk = detectedPreferredSdk;
        } else if (preferredSdkPath != null) {
            object = new PyDetectedSdk(preferredSdkPath);
            PySdkPathChoosingComboBox pySdkPathChoosingComboBox4 = pySdkPathChoosingComboBox3;
            Object $receiver2 = object;
            ((JComboBox)$receiver.getChildComponent()).insertItemAt($receiver2, 0);
            Object object2 = object;
            pySdkPathChoosingComboBox3 = pySdkPathChoosingComboBox4;
            sdk = (Sdk)object2;
        } else {
            sdk = (Sdk)CollectionsKt.getOrNull($receiver.getItems(), (int)0);
        }
        pySdkPathChoosingComboBox3.setSelectedSdk(sdk);
        pyAddNewVirtualEnvPanel.baseSdkField = pySdkPathChoosingComboBox = pySdkPathChoosingComboBox2;
        pySdkPathChoosingComboBox2 = new TextFieldWithBrowseButton();
        pyAddNewVirtualEnvPanel = this;
        $receiver = pySdkPathChoosingComboBox2;
        String defaultBasePath = FileUtil.toSystemDependentName((String)PySdkSettings.Companion.getInstance().getPreferredVirtualEnvBasePath(this.getProjectBasePath()));
        String parentPath = PathUtil.getParentPath((String)defaultBasePath);
        String fileName = PathUtil.getFileName((String)defaultBasePath);
        $receiver.setText(FileUtil.findSequentNonexistentFile((File)new File(parentPath), (String)fileName, (String)"").getPath());
        $receiver.addBrowseFolderListener("Select Location for Virtual Environment", null, this.project, FileChooserDescriptorFactory.createSingleFolderDescriptor());
        pySdkPathChoosingComboBox = pySdkPathChoosingComboBox2;
        pyAddNewVirtualEnvPanel.pathField = pySdkPathChoosingComboBox;
        this.inheritSitePackagesField = new JBCheckBox("Inherit global site-packages");
        this.makeSharedField = new JBCheckBox("Make available to all projects");
        this.setLayout(new BorderLayout());
        JPanel formPanel = FormBuilder.createFormBuilder().addLabeledComponent("Location:", (JComponent)this.pathField).addLabeledComponent("Base interpreter:", (JComponent)((Object)this.baseSdkField)).addComponent((JComponent)this.inheritSitePackagesField).addComponent((JComponent)this.makeSharedField).getPanel();
        this.add((Component)formPanel, "North");
    }

    @NotNull
    public static final /* synthetic */ PySdkPathChoosingComboBox access$getBaseSdkField$p(PyAddNewVirtualEnvPanel $this) {
        return $this.baseSdkField;
    }

    @NotNull
    public static final /* synthetic */ JBCheckBox access$getInheritSitePackagesField$p(PyAddNewVirtualEnvPanel $this) {
        return $this.inheritSitePackagesField;
    }
}

