/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.thumbnail.actions;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.Project;
import org.intellij.images.thumbnail.ThumbnailView;
import org.intellij.images.thumbnail.actionSystem.ThumbnailViewActionUtil;

public final class ToggleTagsPanelAction
extends ToggleAction {
    public static final String TAGS_PANEL_VISIBLE = "tags.panel.visible";
    public static final String TAGS_PANEL_PROPORTION = "tags.panel.proportion";

    public boolean isSelected(AnActionEvent e) {
        Project project = e.getProject();
        return project != null && PropertiesComponent.getInstance((Project)project).getBoolean(TAGS_PANEL_VISIBLE, false);
    }

    public void setSelected(AnActionEvent e, boolean state2) {
        PropertiesComponent.getInstance((Project)e.getProject()).setValue(TAGS_PANEL_VISIBLE, state2);
        ThumbnailView view = ThumbnailViewActionUtil.getVisibleThumbnailView(e);
        assert (view != null);
        view.refresh();
    }

    public void update(AnActionEvent e) {
        ThumbnailView view = ThumbnailViewActionUtil.getVisibleThumbnailView(e);
        e.getPresentation().setEnabledAndVisible(view != null);
        e.getPresentation().setText(this.isSelected(e) ? "Hide Tags Panel" : "Show Tags Panel");
        super.update(e);
    }
}

