/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.convert;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.io.File;
import org.intellij.plugins.relaxNG.compact.RncFileType;
import org.intellij.plugins.relaxNG.convert.ConvertSchemaDialog;
import org.intellij.plugins.relaxNG.convert.ConvertSchemaSettings;
import org.intellij.plugins.relaxNG.convert.IdeaDriver;
import org.intellij.plugins.relaxNG.convert.IdeaErrorHandler;
import org.intellij.plugins.relaxNG.convert.SchemaType;
import org.intellij.plugins.relaxNG.validation.ValidateAction;

public class ConvertSchemaAction
extends AnAction {
    public void update(AnActionEvent e) {
        VirtualFile[] files = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (files != null && project != null) {
            SchemaType type = ConvertSchemaAction.getInputType(project, files);
            e.getPresentation().setEnabled(type != null);
            if (type == SchemaType.XML) {
                e.getPresentation().setText("Generate Schema from XML file" + (files.length > 1 ? "s" : "") + "...");
            } else {
                e.getPresentation().setText("Convert Schema...");
            }
        } else {
            e.getPresentation().setEnabled(false);
        }
    }

    private static SchemaType getInputType(Project project, VirtualFile ... files) {
        if (files.length == 0) {
            return null;
        }
        VirtualFile file2 = files[0];
        FileType type = file2.getFileType();
        if (type == StdFileTypes.XML) {
            XmlDocument document;
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file2);
            if (psiFile instanceof XmlFile && (document = ((XmlFile)psiFile).getDocument()) != null && document.getRootTag() != null) {
                XmlTag rootTag = document.getRootTag();
                assert (rootTag != null);
                String uri = rootTag.getNamespace();
                if ("http://relaxng.org/ns/structure/1.0".equals(uri) && files.length == 1) {
                    return SchemaType.RNG;
                }
            }
            if (files.length > 1) {
                for (VirtualFile virtualFile : files) {
                    if (virtualFile.getFileType() == StdFileTypes.XML && ConvertSchemaAction.getInputType(project, virtualFile) == null) continue;
                    return null;
                }
            }
            return SchemaType.XML;
        }
        if (type == StdFileTypes.DTD && files.length == 1) {
            return SchemaType.DTD;
        }
        if (type == RncFileType.getInstance() && files.length == 1) {
            return SchemaType.RNC;
        }
        return null;
    }

    public void actionPerformed(AnActionEvent e) {
        VirtualFile file2 = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (file2 != null && project != null) {
            VirtualFile[] files = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
            assert (files != null);
            SchemaType type = ConvertSchemaAction.getInputType(project, files);
            ConvertSchemaDialog dialog2 = new ConvertSchemaDialog(project, type, file2);
            if (!dialog2.showAndGet()) {
                return;
            }
            ValidateAction.saveFiles(files);
            ConvertSchemaSettings settings = dialog2.getSettings();
            IdeaErrorHandler errorHandler = new IdeaErrorHandler(project);
            new IdeaDriver(settings, project).convert(type, errorHandler, files);
            VirtualFile output = LocalFileSystem.getInstance().findFileByIoFile(new File(settings.getOutputDestination()));
            if (output != null) {
                output.refresh(false, true);
            }
        }
    }
}

