/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.add;

import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.containers.Convertor;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.add.AddClient;
import org.jetbrains.idea.svn.api.BaseSvnClient;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.api.FileStatusResultParser;
import org.jetbrains.idea.svn.api.ProgressEvent;
import org.jetbrains.idea.svn.api.ProgressTracker;
import org.jetbrains.idea.svn.commandLine.CommandExecutor;
import org.jetbrains.idea.svn.commandLine.CommandUtil;
import org.jetbrains.idea.svn.commandLine.SvnCommandName;
import org.jetbrains.idea.svn.status.StatusType;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class CmdAddClient
extends BaseSvnClient
implements AddClient {
    private static final String STATUS = "\\s*(\\w)\\s*";
    private static final String OPTIONAL_FILE_TYPE = "(\\(.*\\))?";
    private static final String PATH = "\\s*(.*?)\\s*";
    private static final Pattern CHANGED_PATH = Pattern.compile("\\s*(\\w)\\s*(\\(.*\\))?\\s*(.*?)\\s*");

    @Override
    public void add(@NotNull File file, @Nullable Depth depth, boolean makeParents, boolean includeIgnored, boolean force, @Nullable ProgressTracker handler) throws VcsException {
        if (file == null) {
            CmdAddClient.$$$reportNull$$$0(0);
        }
        List<String> parameters = CmdAddClient.prepareParameters(file, depth, makeParents, includeIgnored, force);
        CommandExecutor command = this.execute(this.myVcs, SvnTarget.fromFile((File)file), SvnCommandName.add, parameters, null);
        FileStatusResultParser parser = new FileStatusResultParser(CHANGED_PATH, handler, new AddStatusConvertor());
        parser.parse(command.getOutput());
    }

    private static List<String> prepareParameters(File file, Depth depth, boolean makeParents, boolean includeIgnored, boolean force) {
        ArrayList<String> parameters = new ArrayList<String>();
        CommandUtil.put(parameters, file);
        CommandUtil.put(parameters, depth);
        CommandUtil.put(parameters, makeParents, "--parents");
        CommandUtil.put(parameters, includeIgnored, "--no-ignore");
        CommandUtil.put(parameters, force, "--force");
        return parameters;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/svn/add/CmdAddClient", "add"));
    }

    private static class AddStatusConvertor
    implements Convertor<Matcher, ProgressEvent> {
        private AddStatusConvertor() {
        }

        public ProgressEvent convert(Matcher o) {
            StatusType contentStatus = CommandUtil.getStatusType(o.group(1));
            String path = o.group(3);
            return new ProgressEvent(new File(path), 0L, contentStatus, null, null, null, null);
        }
    }
}

