/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.checkin;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.api.BaseSvnClient;
import org.jetbrains.idea.svn.checkin.CheckinClient;
import org.jetbrains.idea.svn.checkin.CommitInfo;
import org.jetbrains.idea.svn.checkin.IdeaCommitHandler;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.wc.SVNCommitClient;
import org.tmatesoft.svn.core.wc.SVNCommitPacket;

public class SvnKitCheckinClient
extends BaseSvnClient
implements CheckinClient {
    private static final Logger LOG = Logger.getInstance(SvnKitCheckinClient.class);

    @Override
    @NotNull
    public CommitInfo[] commit(@NotNull List<File> paths, @NotNull String comment) throws VcsException {
        SVNCommitInfo[] results;
        if (paths == null) {
            SvnKitCheckinClient.$$$reportNull$$$0(0);
        }
        if (comment == null) {
            SvnKitCheckinClient.$$$reportNull$$$0(1);
        }
        File[] pathsToCommit = (File[])ArrayUtil.toObjectArray(paths, File.class);
        boolean keepLocks = this.myVcs.getSvnConfiguration().isKeepLocks();
        SVNCommitPacket[] commitPackets = null;
        SVNCommitClient committer = this.myVcs.getSvnKitManager().createCommitClient();
        IdeaCommitHandler handler = new IdeaCommitHandler(ProgressManager.getInstance().getProgressIndicator(), true, true);
        committer.setEventHandler(SvnKitCheckinClient.toEventHandler(handler));
        try {
            commitPackets = committer.doCollectCommitItems(pathsToCommit, keepLocks, true, SVNDepth.EMPTY, true, null);
            results = committer.doCommit(commitPackets, keepLocks, comment);
            commitPackets = null;
        }
        catch (SVNException e) {
            throw new SvnBindException(e);
        }
        finally {
            if (commitPackets != null) {
                for (SVNCommitPacket commitPacket : commitPackets) {
                    try {
                        commitPacket.dispose();
                    }
                    catch (SVNException e) {
                        LOG.info((Throwable)e);
                    }
                }
            }
        }
        for (VirtualFile f : handler.getDeletedFiles()) {
            f.putUserData(VirtualFile.REQUESTOR_MARKER, (Object)this);
        }
        CommitInfo[] commitInfoArray = SvnKitCheckinClient.convert(results);
        if (commitInfoArray == null) {
            SvnKitCheckinClient.$$$reportNull$$$0(2);
        }
        return commitInfoArray;
    }

    @NotNull
    private static CommitInfo[] convert(@NotNull SVNCommitInfo[] infos) {
        if (infos == null) {
            SvnKitCheckinClient.$$$reportNull$$$0(3);
        }
        CommitInfo[] commitInfoArray = (CommitInfo[])ContainerUtil.map((Object[])infos, info -> new CommitInfo.Builder(info.getNewRevision(), info.getDate(), info.getAuthor()).setError(info.getErrorMessage()).build(), (Object[])new CommitInfo[0]);
        if (commitInfoArray == null) {
            SvnKitCheckinClient.$$$reportNull$$$0(4);
        }
        return commitInfoArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/checkin/SvnKitCheckinClient";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/checkin/SvnKitCheckinClient";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "commit";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "convert";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "commit";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "convert";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

