/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.diff;

import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.actions.VcsContextFactory;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.util.containers.HashMap;
import java.io.File;
import java.io.OutputStream;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.diff.DiffContentRevision;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindow;

public class SvnDiffEditor
implements ISVNEditor {
    private File mySourceRoot;
    private SVNRepository mySource;
    private final SVNRepository myTarget;
    private final long myTargetRevision;
    private final boolean myReverse;
    private final Map<String, Change> myChanges;

    /*
     * WARNING - void declaration
     */
    public SvnDiffEditor(@NotNull SVNRepository source, SVNRepository target, long targetRevision, boolean bl) {
        void reverse;
        if (source == null) {
            SvnDiffEditor.$$$reportNull$$$0(0);
        }
        this.mySource = source;
        this.myTarget = target;
        this.myTargetRevision = targetRevision;
        this.myChanges = new HashMap();
        this.myReverse = reverse;
    }

    /*
     * WARNING - void declaration
     */
    public SvnDiffEditor(@NotNull File sourceRoot, SVNRepository target, long targetRevision, boolean bl) {
        void reverse;
        if (sourceRoot == null) {
            SvnDiffEditor.$$$reportNull$$$0(1);
        }
        this.mySourceRoot = sourceRoot;
        this.myTarget = target;
        this.myTargetRevision = targetRevision;
        this.myChanges = new HashMap();
        this.myReverse = reverse;
    }

    public Map<String, Change> getChangesMap() {
        return this.myChanges;
    }

    private ContentRevision createBeforeRevision(String path) {
        if (this.mySource != null) {
            return new DiffContentRevision(path, this.mySource, -1L);
        }
        File f = new File(this.mySourceRoot, path);
        FilePath filePath = VcsContextFactory.SERVICE.getInstance().createFilePathOn(f);
        return CurrentContentRevision.create((FilePath)filePath);
    }

    private DiffContentRevision createAfterRevision(String path) {
        if (this.mySourceRoot != null) {
            File f = new File(this.mySourceRoot, path);
            FilePath filePath = VcsContextFactory.SERVICE.getInstance().createFilePathOn(f);
            return new DiffContentRevision(path, this.myTarget, this.myTargetRevision, filePath);
        }
        return new DiffContentRevision(path, this.myTarget, this.myTargetRevision);
    }

    public void targetRevision(long revision) {
    }

    public void openRoot(long revision) {
    }

    public void deleteEntry(String path, long revision) {
        Change change = this.createChange(path, FileStatus.DELETED);
        this.myChanges.put(path, change);
    }

    public void absentDir(String path) {
    }

    public void absentFile(String path) {
    }

    public void addDir(String path, String copyFromPath, long copyFromRevision) {
        FileStatus status = FileStatus.ADDED;
        if (this.myChanges.containsKey(path) && this.myChanges.get(path).getFileStatus() == FileStatus.DELETED) {
            this.myChanges.remove(path);
            status = FileStatus.MODIFIED;
        }
        Change change = this.createChange(path, status);
        this.myChanges.put(path, change);
    }

    private Change createChange(String path, FileStatus status) {
        ContentRevision beforeRevision = this.createBeforeRevision(path);
        DiffContentRevision afterRevision = this.createAfterRevision(path);
        if (this.myReverse) {
            if (status == FileStatus.ADDED) {
                return new Change((ContentRevision)afterRevision, null);
            }
            if (status == FileStatus.DELETED) {
                return new Change(null, beforeRevision);
            }
            return new Change((ContentRevision)afterRevision, beforeRevision, status);
        }
        return new Change(status == FileStatus.ADDED ? null : beforeRevision, (ContentRevision)(status == FileStatus.DELETED ? null : afterRevision), status);
    }

    public void openDir(String path, long revision) {
    }

    public void changeDirProperty(String name, SVNPropertyValue value) {
    }

    public void closeDir() {
    }

    public void addFile(String path, String copyFromPath, long copyFromRevision) {
        FileStatus status = FileStatus.ADDED;
        if (this.myChanges.containsKey(path) && this.myChanges.get(path).getFileStatus() == FileStatus.DELETED) {
            this.myChanges.remove(path);
            status = FileStatus.MODIFIED;
        }
        Change change = this.createChange(path, status);
        this.myChanges.put(path, change);
    }

    public void openFile(String path, long revision) {
        Change change = this.createChange(path, FileStatus.MODIFIED);
        this.myChanges.put(path, change);
    }

    public void changeFileProperty(String path, String propertyName, SVNPropertyValue propertyValue) {
    }

    public void closeFile(String path, String textChecksum) {
    }

    public void abortEdit() {
    }

    public void applyTextDelta(String path, String baseChecksum) {
    }

    public OutputStream textDeltaChunk(String path, SVNDiffWindow diffWindow) {
        return null;
    }

    public void textDeltaEnd(String path) {
    }

    public SVNCommitInfo closeEdit() {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "source";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "sourceRoot";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/idea/svn/diff/SvnDiffEditor";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

