/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.mergeinfo;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.vcs.changes.committed.CommittedChangeListsListener;
import com.intellij.openapi.vcs.changes.committed.DecoratorManager;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.dialogs.WCInfoWithBranches;
import org.jetbrains.idea.svn.history.RootsAndBranches;
import org.jetbrains.idea.svn.history.SvnChangeList;
import org.jetbrains.idea.svn.history.SvnMergeInfoRootPanelManual;
import org.jetbrains.idea.svn.mergeinfo.ListMergeStatus;
import org.jetbrains.idea.svn.mergeinfo.MergeInfoCached;
import org.jetbrains.idea.svn.mergeinfo.SvnMergeInfoCache;

public class MergeInfoHolder {
    @NotNull
    private final DecoratorManager myManager;
    @NotNull
    private final SvnMergeInfoCache myMergeInfoCache;
    @NotNull
    private final RootsAndBranches myMainPanel;
    @NotNull
    private final SvnMergeInfoRootPanelManual myPanel;
    @NotNull
    private final Map<Couple<String>, MergeInfoCached> myCachedMap;

    public MergeInfoHolder(@NotNull Project project, @NotNull DecoratorManager manager, @NotNull RootsAndBranches mainPanel, @NotNull SvnMergeInfoRootPanelManual panel) {
        if (project == null) {
            MergeInfoHolder.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            MergeInfoHolder.$$$reportNull$$$0(1);
        }
        if (mainPanel == null) {
            MergeInfoHolder.$$$reportNull$$$0(2);
        }
        if (panel == null) {
            MergeInfoHolder.$$$reportNull$$$0(3);
        }
        this.myManager = manager;
        this.myMainPanel = mainPanel;
        this.myPanel = panel;
        this.myMergeInfoCache = SvnMergeInfoCache.getInstance(project);
        this.myCachedMap = ContainerUtil.newHashMap();
    }

    @Nullable
    private MergeInfoCached getCurrentCache() {
        return this.myCachedMap.get(MergeInfoHolder.createKey(this.myPanel.getWcInfo(), this.myPanel.getBranch()));
    }

    private boolean isEnabledAndConfigured(boolean ignoreEnabled) {
        return (ignoreEnabled || this.myMainPanel.isHighlightingOn() && this.myPanel.isEnabled()) && this.myPanel.getBranch() != null && this.myPanel.getLocalBranch() != null;
    }

    public boolean refreshEnabled(boolean ignoreEnabled) {
        return this.isEnabledAndConfigured(ignoreEnabled) && this.getCurrentCache() == null;
    }

    @NotNull
    private static Couple<String> createKey(@NotNull WCInfoWithBranches root, @NotNull WCInfoWithBranches.Branch branch) {
        if (root == null) {
            MergeInfoHolder.$$$reportNull$$$0(4);
        }
        if (branch == null) {
            MergeInfoHolder.$$$reportNull$$$0(5);
        }
        Couple couple = Couple.of((Object)root.getPath(), (Object)branch.getUrl());
        if (couple == null) {
            MergeInfoHolder.$$$reportNull$$$0(6);
        }
        return couple;
    }

    @NotNull
    public ListMergeStatus refresh(boolean ignoreEnabled) {
        CommittedChangeListsListener refresher = this.createRefresher(ignoreEnabled);
        if (refresher != null) {
            this.myManager.reportLoadedLists(refresher);
        }
        this.myManager.repaintTree();
        ListMergeStatus listMergeStatus = ListMergeStatus.REFRESHING;
        if (listMergeStatus == null) {
            MergeInfoHolder.$$$reportNull$$$0(7);
        }
        return listMergeStatus;
    }

    @Nullable
    public CommittedChangeListsListener createRefresher(boolean ignoreEnabled) {
        MyRefresher result = null;
        if (this.refreshEnabled(ignoreEnabled)) {
            MergeInfoCached state = this.myMergeInfoCache.getCachedState(this.myPanel.getWcInfo(), this.myPanel.getLocalBranch());
            this.myCachedMap.put(MergeInfoHolder.createKey(this.myPanel.getWcInfo(), this.myPanel.getBranch()), state != null ? state.copy() : new MergeInfoCached());
            this.myMergeInfoCache.clear(this.myPanel.getWcInfo(), this.myPanel.getLocalBranch());
            result = new MyRefresher();
        }
        return result;
    }

    @NotNull
    public ListMergeStatus check(CommittedChangeList list, boolean ignoreEnabled) {
        ListMergeStatus result;
        if (!this.isEnabledAndConfigured(ignoreEnabled) || !(list instanceof SvnChangeList)) {
            result = ListMergeStatus.ALIEN;
        } else {
            MergeInfoCached cachedState = this.getCurrentCache();
            MergeInfoCached state = this.myMergeInfoCache.getCachedState(this.myPanel.getWcInfo(), this.myPanel.getLocalBranch());
            result = cachedState != null ? this.check(list, cachedState, true) : (state != null ? this.check(list, state, false) : this.refresh(ignoreEnabled));
        }
        ListMergeStatus listMergeStatus = result;
        if (listMergeStatus == null) {
            MergeInfoHolder.$$$reportNull$$$0(8);
        }
        return listMergeStatus;
    }

    @NotNull
    public ListMergeStatus check(@NotNull CommittedChangeList list, @NotNull MergeInfoCached state, boolean isCached) {
        if (list == null) {
            MergeInfoHolder.$$$reportNull$$$0(9);
        }
        if (state == null) {
            MergeInfoHolder.$$$reportNull$$$0(10);
        }
        SvnMergeInfoCache.MergeCheckResult mergeCheckResult = state.getMap().get(list.getNumber());
        ListMergeStatus result = state.copiedAfter(list) ? ListMergeStatus.COMMON : ListMergeStatus.from(mergeCheckResult);
        ListMergeStatus listMergeStatus = (ListMergeStatus)((Object)ObjectUtils.notNull((Object)((Object)result), (Object)((Object)(isCached ? ListMergeStatus.REFRESHING : ListMergeStatus.ALIEN))));
        if (listMergeStatus == null) {
            MergeInfoHolder.$$$reportNull$$$0(11);
        }
        return listMergeStatus;
    }

    public void updateMixedRevisionsForPanel() {
        this.myPanel.setMixedRevisions(this.myMergeInfoCache.isMixedRevisions(this.myPanel.getWcInfo(), this.myPanel.getLocalBranch()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainPanel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branch";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/mergeinfo/MergeInfoHolder";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/mergeinfo/MergeInfoHolder";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createKey";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "refresh";
                break;
            }
            case 8: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "check";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createKey";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 11: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "check";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyRefresher
    implements CommittedChangeListsListener {
        @NotNull
        private final WCInfoWithBranches myRefreshedRoot;
        private final WCInfoWithBranches.Branch myRefreshedBranch;
        private final String myBranchPath;

        private MyRefresher() {
            this.myRefreshedRoot = MergeInfoHolder.this.myPanel.getWcInfo();
            this.myRefreshedBranch = MergeInfoHolder.this.myPanel.getBranch();
            this.myBranchPath = MergeInfoHolder.this.myPanel.getLocalBranch();
        }

        public void onBeforeStartReport() {
        }

        public boolean report(CommittedChangeList list) {
            if (list instanceof SvnChangeList) {
                SvnMergeInfoCache.MergeCheckResult checkState = MergeInfoHolder.this.myMergeInfoCache.getState(this.myRefreshedRoot, (SvnChangeList)list, this.myRefreshedBranch, this.myBranchPath);
                long number = list.getNumber();
                ApplicationManager.getApplication().invokeLater(() -> {
                    MergeInfoCached cachedState = (MergeInfoCached)MergeInfoHolder.this.myCachedMap.get(MergeInfoHolder.createKey(this.myRefreshedRoot, this.myRefreshedBranch));
                    if (cachedState != null) {
                        cachedState.getMap().put(number, checkState);
                    }
                    MergeInfoHolder.this.myManager.repaintTree();
                });
            }
            return true;
        }

        public void onAfterEndReport() {
            ApplicationManager.getApplication().invokeLater(() -> {
                MergeInfoHolder.this.myCachedMap.remove(MergeInfoHolder.createKey(this.myRefreshedRoot, this.myRefreshedBranch));
                MergeInfoHolder.this.updateMixedRevisionsForPanel();
                MergeInfoHolder.this.myManager.repaintTree();
            });
        }
    }
}

