/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.update;

import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.WorkingCopyFormat;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.api.EventAction;
import org.jetbrains.idea.svn.api.ProgressEvent;
import org.jetbrains.idea.svn.commandLine.BaseUpdateCommandListener;
import org.jetbrains.idea.svn.commandLine.CommandUtil;
import org.jetbrains.idea.svn.commandLine.LineCommandListener;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.commandLine.SvnCommandName;
import org.jetbrains.idea.svn.info.Info;
import org.jetbrains.idea.svn.update.SvnKitUpdateClient;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class CmdUpdateClient
extends SvnKitUpdateClient {
    private static final Pattern ourExceptionPattern = Pattern.compile("svn: E(\\d{6}): .+");
    private static final String ourAuthenticationRealm = "Authentication realm:";

    private void checkWorkingCopy(@NotNull File path) throws SvnBindException {
        Info info;
        if (path == null) {
            CmdUpdateClient.$$$reportNull$$$0(0);
        }
        if ((info = this.myFactory.createInfoClient().doInfo(path, SVNRevision.UNDEFINED)) == null || info.getURL() == null) {
            throw new SvnBindException(SVNErrorCode.WC_NOT_WORKING_COPY, path.getPath());
        }
    }

    private long[] run(@NotNull File path, @NotNull List<String> parameters, @NotNull SvnCommandName command) throws SvnBindException {
        if (path == null) {
            CmdUpdateClient.$$$reportNull$$$0(1);
        }
        if (parameters == null) {
            CmdUpdateClient.$$$reportNull$$$0(2);
        }
        if (command == null) {
            CmdUpdateClient.$$$reportNull$$$0(3);
        }
        File base = path.isDirectory() ? path : path.getParentFile();
        AtomicReference<long[]> updatedToRevision = new AtomicReference<long[]>();
        updatedToRevision.set(new long[0]);
        BaseUpdateCommandListener listener = this.createCommandListener(new File[]{path}, updatedToRevision, base);
        this.execute(this.myVcs, SvnTarget.fromFile((File)base), command, parameters, (LineCommandListener)listener);
        listener.throwWrappedIfException();
        return updatedToRevision.get();
    }

    private BaseUpdateCommandListener createCommandListener(final File[] paths, final AtomicReference<long[]> updatedToRevision, File base) {
        return new BaseUpdateCommandListener(base, this.myDispatcher){
            final long[] myRevisions;
            {
                super(base, handler);
                this.myRevisions = new long[paths.length];
            }

            @Override
            protected void beforeHandler(@NotNull ProgressEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (EventAction.UPDATE_COMPLETED.equals((Object)event.getAction())) {
                    long eventRevision = event.getRevision();
                    for (int i = 0; i < paths.length; ++i) {
                        File path = paths[i];
                        if (!FileUtil.filesEqual((File)path, (File)event.getFile())) continue;
                        this.myRevisions[i] = eventRevision;
                        break;
                    }
                }
            }

            @Override
            public void processTerminated(int exitCode) {
                super.processTerminated(exitCode);
                updatedToRevision.set(this.myRevisions);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/idea/svn/update/CmdUpdateClient$1", "beforeHandler"));
            }
        };
    }

    private static void fillParameters(@NotNull List<String> parameters, @Nullable SVNRevision revision, @Nullable Depth depth, boolean depthIsSticky, boolean allowUnversionedObstructions) {
        if (parameters == null) {
            CmdUpdateClient.$$$reportNull$$$0(4);
        }
        CommandUtil.put(parameters, revision);
        CommandUtil.put(parameters, depth, depthIsSticky);
        CommandUtil.put(parameters, allowUnversionedObstructions, "--force");
        parameters.add("--accept");
        parameters.add("postpone");
    }

    private void checkForException(StringBuffer sbError) throws SVNException {
        String group;
        if (sbError.length() == 0) {
            return;
        }
        String message = sbError.toString();
        Matcher matcher = ourExceptionPattern.matcher(message);
        if (matcher.matches() && (group = matcher.group(1)) != null) {
            try {
                int code = Integer.parseInt(group);
                throw new SVNException(SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.getErrorCode((int)code), (String)message));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (message.contains(ourAuthenticationRealm)) {
            throw new SVNException(SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.AUTHN_CREDS_UNAVAILABLE, (String)message));
        }
        throw new SVNException(SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.UNKNOWN, (String)message));
    }

    @Override
    public long doUpdate(File path, SVNRevision revision, Depth depth, boolean allowUnversionedObstructions, boolean depthIsSticky) throws SvnBindException {
        this.checkWorkingCopy(path);
        ArrayList<String> parameters = new ArrayList<String>();
        CmdUpdateClient.fillParameters(parameters, revision, depth, depthIsSticky, allowUnversionedObstructions);
        CommandUtil.put(parameters, this.myIgnoreExternals, "--ignore-externals");
        CommandUtil.put(parameters, path);
        long[] longs = this.run(path, parameters, SvnCommandName.up);
        return longs[0];
    }

    @Override
    public long doSwitch(File path, SVNURL url, SVNRevision pegRevision, SVNRevision revision, Depth depth, boolean allowUnversionedObstructions, boolean depthIsSticky) throws SvnBindException {
        long[] revisions;
        this.checkWorkingCopy(path);
        ArrayList<String> parameters = new ArrayList<String>();
        CommandUtil.put(parameters, SvnTarget.fromURL((SVNURL)url, (SVNRevision)pegRevision));
        CommandUtil.put(parameters, path, false);
        CmdUpdateClient.fillParameters(parameters, revision, depth, depthIsSticky, allowUnversionedObstructions);
        if (!this.myVcs.is16SupportedByCommandLine() || WorkingCopyFormat.from(this.myFactory.createVersionClient().getVersion()).isOrGreater(WorkingCopyFormat.ONE_DOT_SEVEN)) {
            parameters.add("--ignore-ancestry");
        }
        return (revisions = this.run(path, parameters, SvnCommandName.switchCopy)) != null && revisions.length > 0 ? revisions[0] : -1L;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/svn/update/CmdUpdateClient";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkWorkingCopy";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "run";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "fillParameters";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

