/*
 * Decompiled with CFR 0.152.
 */
package com.jediterm.terminal.model;

import com.google.common.collect.Lists;
import com.jediterm.terminal.StyledTextConsumer;
import com.jediterm.terminal.TextStyle;
import com.jediterm.terminal.model.CharBuffer;
import com.jediterm.terminal.model.TerminalLine;
import com.jediterm.terminal.model.hyperlinks.TextProcessing;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LinesBuffer {
    private static final Logger LOG = Logger.getLogger(LinesBuffer.class);
    public static final int DEFAULT_MAX_LINES_COUNT = 1000;
    private int myBufferMaxLinesCount = 1000;
    private ArrayList<TerminalLine> myLines = Lists.newArrayList();
    @Nullable
    private final TextProcessing myTextProcessing;

    public LinesBuffer(@Nullable TextProcessing textProcessing) {
        this.myTextProcessing = textProcessing;
    }

    public LinesBuffer(int bufferMaxLinesCount, @Nullable TextProcessing textProcessing) {
        this.myBufferMaxLinesCount = bufferMaxLinesCount;
        this.myTextProcessing = textProcessing;
    }

    public synchronized String getLines() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (TerminalLine line : this.myLines) {
            if (!first) {
                sb.append("\n");
            }
            sb.append(line.getText());
            first = false;
        }
        return sb.toString();
    }

    public synchronized void addNewLine(@NotNull TextStyle style, @NotNull CharBuffer characters) {
        this.addNewLine(new TerminalLine.TextEntry(style, characters));
    }

    private synchronized void addNewLine(@NotNull TerminalLine.TextEntry entry) {
        this.addLine(new TerminalLine(entry));
    }

    private synchronized void addLine(@NotNull TerminalLine line) {
        if (this.myBufferMaxLinesCount > 0 && this.myLines.size() >= this.myBufferMaxLinesCount) {
            this.removeTopLines(1);
        }
        this.myLines.add(line);
    }

    public synchronized int getLineCount() {
        return this.myLines.size();
    }

    public synchronized void removeTopLines(int count) {
        this.myLines = count >= this.myLines.size() ? Lists.newArrayList() : Lists.newArrayList(this.myLines.subList(count, this.myLines.size()));
    }

    public String getLineText(int row) {
        TerminalLine line = this.getLine(row);
        return line.getText();
    }

    public synchronized void insertLines(int y, int count, int lastLine, @NotNull TerminalLine.TextEntry filler) {
        LinesBuffer tail = new LinesBuffer(this.myTextProcessing);
        if (lastLine < this.getLineCount() - 1) {
            this.moveBottomLinesTo(this.getLineCount() - lastLine - 1, tail);
        }
        LinesBuffer head = new LinesBuffer(this.myTextProcessing);
        if (y > 0) {
            this.moveTopLinesTo(y, head);
        }
        for (int i = 0; i < count; ++i) {
            head.addNewLine(filler);
        }
        head.moveBottomLinesTo(head.getLineCount(), this);
        this.removeBottomLines(count);
        tail.moveTopLinesTo(tail.getLineCount(), this);
    }

    public synchronized LinesBuffer deleteLines(int y, int count, int lastLine, @NotNull TerminalLine.TextEntry filler) {
        LinesBuffer tail = new LinesBuffer(this.myTextProcessing);
        if (lastLine < this.getLineCount() - 1) {
            this.moveBottomLinesTo(this.getLineCount() - lastLine - 1, tail);
        }
        LinesBuffer head = new LinesBuffer(this.myTextProcessing);
        if (y > 0) {
            this.moveTopLinesTo(y, head);
        }
        int toRemove = Math.min(count, this.getLineCount());
        LinesBuffer removed = new LinesBuffer(this.myTextProcessing);
        this.moveTopLinesTo(toRemove, removed);
        head.moveBottomLinesTo(head.getLineCount(), this);
        for (int i = 0; i < toRemove; ++i) {
            this.addNewLine(filler);
        }
        tail.moveTopLinesTo(tail.getLineCount(), this);
        return removed;
    }

    public synchronized void writeString(int x, int y, CharBuffer str, @NotNull TextStyle style) {
        TerminalLine line = this.getLine(y);
        line.writeString(x, str, style);
        if (this.myTextProcessing != null) {
            this.myTextProcessing.processHyperlinks(line);
        }
    }

    public synchronized void clearLines(int startRow, int endRow, @NotNull TerminalLine.TextEntry filler) {
        for (int i = startRow; i <= endRow; ++i) {
            this.getLine(i).clear(filler);
        }
    }

    public synchronized void clearAll() {
        this.myLines.clear();
    }

    public synchronized void deleteCharacters(int x, int y, int count, @NotNull TextStyle style) {
        TerminalLine line = this.getLine(y);
        line.deleteCharacters(x, count, style);
    }

    public synchronized void insertBlankCharacters(int x, int y, int count, int maxLen, @NotNull TextStyle style) {
        TerminalLine line = this.getLine(y);
        line.insertBlankCharacters(x, count, maxLen, style);
    }

    public synchronized void clearArea(int leftX, int topY, int rightX, int bottomY, @NotNull TextStyle style) {
        for (int y = topY; y < bottomY; ++y) {
            TerminalLine line = this.getLine(y);
            line.clearArea(leftX, rightX, style);
        }
    }

    public synchronized void processLines(int yStart, int yCount, @NotNull StyledTextConsumer consumer) {
        this.processLines(yStart, yCount, consumer, -this.getLineCount());
    }

    public synchronized void processLines(int firstLine, int count, @NotNull StyledTextConsumer consumer, int startRow) {
        if (firstLine < 0) {
            throw new IllegalArgumentException("firstLine=" + firstLine + ", should be >0");
        }
        for (int y = firstLine; y < Math.min(firstLine + count, this.myLines.size()); ++y) {
            this.myLines.get(y).process(y, consumer, startRow);
        }
    }

    public synchronized void moveTopLinesTo(int count, @NotNull LinesBuffer buffer) {
        count = Math.min(count, this.getLineCount());
        buffer.addLines(this.myLines.subList(0, count));
        this.removeTopLines(count);
    }

    public synchronized void addLines(@NotNull List<TerminalLine> lines) {
        if (this.myBufferMaxLinesCount > 0) {
            if (lines.size() >= this.myBufferMaxLinesCount) {
                int index = lines.size() - this.myBufferMaxLinesCount;
                this.myLines = Lists.newArrayList(lines.subList(index, lines.size()));
                return;
            }
            int count = this.myLines.size() + lines.size();
            if (count >= this.myBufferMaxLinesCount) {
                this.removeTopLines(count - this.myBufferMaxLinesCount);
            }
        }
        this.myLines.addAll(lines);
    }

    @NotNull
    public synchronized TerminalLine getLine(int row) {
        if (row < 0) {
            LOG.error((Object)("Negative line number: " + row));
            return TerminalLine.createEmpty();
        }
        for (int i = this.getLineCount(); i <= row; ++i) {
            this.addLine(TerminalLine.createEmpty());
        }
        return this.myLines.get(row);
    }

    public synchronized void moveBottomLinesTo(int count, @NotNull LinesBuffer buffer) {
        count = Math.min(count, this.getLineCount());
        buffer.addLinesFirst(this.myLines.subList(this.getLineCount() - count, this.getLineCount()));
        this.removeBottomLines(count);
    }

    private synchronized void addLinesFirst(@NotNull List<TerminalLine> lines) {
        ArrayList list = Lists.newArrayList(lines);
        list.addAll(this.myLines);
        this.myLines = Lists.newArrayList((Iterable)list);
    }

    private synchronized void removeBottomLines(int count) {
        this.myLines = Lists.newArrayList(this.myLines.subList(0, this.getLineCount() - count));
    }

    public int removeBottomEmptyLines(int ind, int maxCount) {
        int i = 0;
        while (maxCount - i > 0 && (ind >= this.myLines.size() || this.myLines.get(ind).isNul())) {
            if (ind < this.myLines.size()) {
                this.myLines.remove(ind);
            }
            --ind;
            ++i;
        }
        return i;
    }
}

