/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ipnb.editor.actions;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ipnb.configuration.IpnbConnectionManager;
import org.jetbrains.plugins.ipnb.editor.IpnbFileEditor;

public class IpnbReloadKernelAction
extends AnAction {
    private final IpnbFileEditor myFileEditor;

    public IpnbReloadKernelAction(IpnbFileEditor fileEditor) {
        super("Restart Kernel", "Restart Kernel", AllIcons.Actions.Refresh);
        this.myFileEditor = fileEditor;
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        if (event == null) {
            IpnbReloadKernelAction.$$$reportNull$$$0(0);
        }
        IpnbReloadKernelAction.reloadKernel(this.myFileEditor);
    }

    private static void reloadKernel(@NotNull IpnbFileEditor editor) {
        if (editor == null) {
            IpnbReloadKernelAction.$$$reportNull$$$0(1);
        }
        Project project = editor.getIpnbFilePanel().getProject();
        int restart = Messages.showYesNoDialog((String)"Do you want to restart the current kernel? You will lose all variables defined in it.", (String)"Restart kernel or continue running?", (String)"Restart", (String)"Continue running", null);
        if (restart == 0) {
            IpnbConnectionManager.getInstance(project).reloadKernel(editor.getVirtualFile().getPath());
        }
    }

    public void update(AnActionEvent e) {
        Project project = this.myFileEditor.getIpnbFilePanel().getProject();
        boolean hasConnection = IpnbConnectionManager.getInstance(project).hasConnection(this.myFileEditor.getVirtualFile().getPath());
        e.getPresentation().setEnabled(hasConnection);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ipnb/editor/actions/IpnbReloadKernelAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "reloadKernel";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

