/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.osgi.obr.xml;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.ivy.osgi.core.BundleInfo;
import org.apache.ivy.osgi.core.ExecutionEnvironmentProfileProvider;
import org.apache.ivy.osgi.obr.filter.RequirementFilterParser;
import org.apache.ivy.osgi.obr.xml.Capability;
import org.apache.ivy.osgi.obr.xml.CapabilityAdapter;
import org.apache.ivy.osgi.obr.xml.Requirement;
import org.apache.ivy.osgi.obr.xml.RequirementAdapter;
import org.apache.ivy.osgi.obr.xml.RequirementFilter;
import org.apache.ivy.osgi.obr.xml.UnsupportedFilterException;
import org.apache.ivy.osgi.repo.BundleRepoDescriptor;
import org.apache.ivy.osgi.util.DelegetingHandler;
import org.apache.ivy.osgi.util.Version;
import org.apache.ivy.util.XMLHelper;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class OBRXMLParser {
    public static BundleRepoDescriptor parse(URI uRI, InputStream inputStream) throws ParseException, IOException, SAXException {
        RepositoryHandler repositoryHandler = new RepositoryHandler(uRI);
        try {
            XMLHelper.parse(inputStream, null, (DefaultHandler)repositoryHandler, null);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new SAXException(parserConfigurationException);
        }
        return repositoryHandler.repo;
    }

    static class RequireHandler
    extends DelegetingHandler {
        static final String REQUIRE = "require";
        static final String NAME = "name";
        static final String OPTIONAL = "optional";
        static final String MULTIPLE = "multiple";
        static final String EXTEND = "extend";
        static final String FILTER = "filter";
        private Requirement requirement;
        private RequirementFilter filter;

        public RequireHandler() {
            super(REQUIRE);
        }

        @Override
        protected void handleAttributes(Attributes attributes) throws SAXException {
            String string = this.getRequiredAttribute(attributes, NAME);
            String string2 = attributes.getValue(FILTER);
            this.filter = null;
            if (string2 != null) {
                try {
                    this.filter = RequirementFilterParser.parse(string2);
                }
                catch (ParseException parseException) {
                    throw new SAXParseException("Requirement with illformed filter: " + string2, this.getLocator());
                }
            }
            Boolean bl = this.getOptionalBooleanAttribute(attributes, OPTIONAL, null);
            Boolean bl2 = this.getOptionalBooleanAttribute(attributes, MULTIPLE, null);
            Boolean bl3 = this.getOptionalBooleanAttribute(attributes, EXTEND, null);
            this.requirement = new Requirement(string, this.filter);
            if (bl != null) {
                this.requirement.setOptional(bl);
            }
            if (bl2 != null) {
                this.requirement.setMultiple(bl2);
            }
            if (bl3 != null) {
                this.requirement.setExtend(bl3);
            }
        }
    }

    static class CapabilityPropertyHandler
    extends DelegetingHandler {
        static final String CAPABILITY_PROPERTY = "p";
        static final String NAME = "n";
        static final String VALUE = "v";
        static final String TYPE = "t";
        String name;
        String value;
        String type;

        public CapabilityPropertyHandler() {
            super(CAPABILITY_PROPERTY);
        }

        @Override
        protected void handleAttributes(Attributes attributes) throws SAXException {
            this.name = this.getRequiredAttribute(attributes, NAME);
            this.value = this.getRequiredAttribute(attributes, VALUE);
            this.type = attributes.getValue(TYPE);
        }
    }

    static class CapabilityHandler
    extends DelegetingHandler {
        static final String CAPABILITY = "capability";
        static final String NAME = "name";
        Capability capability;

        public CapabilityHandler() {
            super(CAPABILITY);
            this.addChild(new CapabilityPropertyHandler(), new DelegetingHandler.ChildElementHandler(){

                @Override
                public void childHanlded(DelegetingHandler delegetingHandler) {
                    String string = ((CapabilityPropertyHandler)delegetingHandler).name;
                    String string2 = ((CapabilityPropertyHandler)delegetingHandler).value;
                    String string3 = ((CapabilityPropertyHandler)delegetingHandler).type;
                    CapabilityHandler.this.capability.addProperty(string, string2, string3);
                }
            });
        }

        @Override
        protected void handleAttributes(Attributes attributes) throws SAXException {
            String string = this.getRequiredAttribute(attributes, NAME);
            this.capability = new Capability(string);
        }
    }

    static class ResourceSizeHandler
    extends DelegetingHandler {
        static final String SIZE = "size";

        public ResourceSizeHandler() {
            super(SIZE);
            this.setBufferingChar(true);
        }
    }

    static class ResourceLicenseHandler
    extends DelegetingHandler {
        static final String LICENSE = "license";

        public ResourceLicenseHandler() {
            super(LICENSE);
            this.setBufferingChar(true);
        }
    }

    static class ResourceDocumentationHandler
    extends DelegetingHandler {
        static final String DOCUMENTATION = "documentation";

        public ResourceDocumentationHandler() {
            super(DOCUMENTATION);
            this.setBufferingChar(true);
        }
    }

    static class ResourceDescriptionHandler
    extends DelegetingHandler {
        static final String DESCRIPTION = "description";

        public ResourceDescriptionHandler() {
            super(DESCRIPTION);
            this.setBufferingChar(true);
        }
    }

    static class ResourceHandler
    extends DelegetingHandler {
        private static final String DEFAULT_VERSION = "1.0.0";
        static final String RESOURCE = "resource";
        static final String ID = "id";
        static final String PRESENTATION_NAME = "presentationname";
        static final String SYMBOLIC_NAME = "symbolicname";
        static final String URI = "uri";
        static final String VERSION = "version";
        BundleInfo bundleInfo;

        public ResourceHandler() {
            super(RESOURCE);
            this.setSkipOnError(true);
            this.addChild(new ResourceDescriptionHandler(), new DelegetingHandler.ChildElementHandler(){

                @Override
                public void childHanlded(DelegetingHandler delegetingHandler) {
                    ResourceHandler.this.bundleInfo.setDescription(delegetingHandler.getBufferedChars().trim());
                }
            });
            this.addChild(new ResourceDocumentationHandler(), new DelegetingHandler.ChildElementHandler(){

                @Override
                public void childHanlded(DelegetingHandler delegetingHandler) {
                    ResourceHandler.this.bundleInfo.setDocumentation(delegetingHandler.getBufferedChars().trim());
                }
            });
            this.addChild(new ResourceLicenseHandler(), new DelegetingHandler.ChildElementHandler(){

                @Override
                public void childHanlded(DelegetingHandler delegetingHandler) {
                    ResourceHandler.this.bundleInfo.setLicense(delegetingHandler.getBufferedChars().trim());
                }
            });
            this.addChild(new ResourceSizeHandler(), new DelegetingHandler.ChildElementHandler(){

                @Override
                public void childHanlded(DelegetingHandler delegetingHandler) {
                    String string = delegetingHandler.getBufferedChars().trim();
                    try {
                        ResourceHandler.this.bundleInfo.setSize(Integer.valueOf(string));
                    }
                    catch (NumberFormatException numberFormatException) {
                        ResourceHandler.this.log(1, "Invalid size for the bundle " + ResourceHandler.this.bundleInfo.getSymbolicName() + ": " + string + ". This size is then ignored.");
                    }
                }
            });
            this.addChild(new CapabilityHandler(), new DelegetingHandler.ChildElementHandler(){

                @Override
                public void childHanlded(DelegetingHandler delegetingHandler) throws SAXParseException {
                    try {
                        CapabilityAdapter.adapt(ResourceHandler.this.bundleInfo, ((CapabilityHandler)delegetingHandler).capability);
                    }
                    catch (ParseException parseException) {
                        throw new SAXParseException("Invalid capability: " + parseException.getMessage(), delegetingHandler.getLocator());
                    }
                }
            });
            this.addChild(new RequireHandler(), new DelegetingHandler.ChildElementHandler(){

                @Override
                public void childHanlded(DelegetingHandler delegetingHandler) throws SAXParseException {
                    try {
                        RequirementAdapter.adapt(ResourceHandler.this.bundleInfo, ((RequireHandler)delegetingHandler).requirement);
                    }
                    catch (UnsupportedFilterException unsupportedFilterException) {
                        throw new SAXParseException("Unsupported requirement filter: " + ((RequireHandler)delegetingHandler).filter + " (" + unsupportedFilterException.getMessage() + ")", ResourceHandler.this.getLocator());
                    }
                    catch (ParseException parseException) {
                        throw new SAXParseException("Error in the requirement filter on the bundle: " + parseException.getMessage(), ResourceHandler.this.getLocator());
                    }
                }
            });
        }

        @Override
        protected void handleAttributes(Attributes attributes) throws SAXException {
            Version version;
            String string = attributes.getValue(SYMBOLIC_NAME);
            if (string == null) {
                this.log(0, "Resource with no symobilc name, skipping it.");
                this.skip();
                return;
            }
            String string2 = this.getOptionalAttribute(attributes, VERSION, DEFAULT_VERSION);
            try {
                version = new Version(string2);
            }
            catch (ParseException parseException) {
                this.log(0, "Incorrect resource version: " + string2 + ". The resource " + string + " is then ignored.");
                this.skip();
                return;
            }
            this.bundleInfo = new BundleInfo(string, version);
            this.bundleInfo.setPresentationName(attributes.getValue(PRESENTATION_NAME));
            String string3 = attributes.getValue(URI);
            if (string3 != null) {
                try {
                    this.bundleInfo.setUri(new URI(string3));
                }
                catch (URISyntaxException uRISyntaxException) {
                    this.log(0, "Incorrect uri " + string3 + ". The resource " + string + " is then ignored.");
                    this.skip();
                    return;
                }
            }
            this.bundleInfo.setId(attributes.getValue(ID));
        }

        @Override
        protected String getCurrentElementIdentifier() {
            return this.bundleInfo.getSymbolicName() + "/" + this.bundleInfo.getVersion();
        }
    }

    static class RepositoryHandler
    extends DelegetingHandler {
        static final String REPOSITORY = "repository";
        static final String LASTMODIFIED = "lastmodified";
        static final String NAME = "name";
        BundleRepoDescriptor repo;
        private final URI baseUri;

        public RepositoryHandler(URI uRI) {
            super(REPOSITORY);
            this.baseUri = uRI;
            this.addChild(new ResourceHandler(), new DelegetingHandler.ChildElementHandler(){

                @Override
                public void childHanlded(DelegetingHandler delegetingHandler) {
                    RepositoryHandler.this.repo.addBundle(((ResourceHandler)delegetingHandler).bundleInfo);
                }
            });
        }

        @Override
        protected void handleAttributes(Attributes attributes) {
            this.repo = new BundleRepoDescriptor(this.baseUri, ExecutionEnvironmentProfileProvider.getInstance());
            this.repo.setName(attributes.getValue(NAME));
            try {
                Long l = this.getOptionalLongAttribute(attributes, LASTMODIFIED, null);
                this.repo.setLastModified(l);
            }
            catch (SAXParseException sAXParseException) {
                this.log(1, sAXParseException.getMessage() + ". It will be ignored.");
            }
        }
    }
}

