/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.input;

import java.util.Collections;
import java.util.List;
import javafx.event.Event;
import javafx.event.EventTarget;
import javafx.event.EventType;
import javafx.scene.input.InputEvent;
import javafx.scene.input.TouchPoint;

public final class TouchEvent
extends InputEvent {
    public static final EventType<TouchEvent> ANY = new EventType<InputEvent>(InputEvent.ANY);
    public static final EventType<TouchEvent> TOUCH_PRESSED = new EventType<TouchEvent>(ANY, "TOUCH_PRESSED");
    public static final EventType<TouchEvent> TOUCH_MOVED = new EventType<TouchEvent>(ANY, "TOUCH_MOVED");
    public static final EventType<TouchEvent> TOUCH_RELEASED = new EventType<TouchEvent>(ANY, "TOUCH_RELEASED");
    public static final EventType<TouchEvent> TOUCH_STATIONARY = new EventType<TouchEvent>(ANY, "TOUCH_STATIONARY");
    private boolean isDirect;
    private int eventSetId;
    private boolean shiftDown;
    private boolean controlDown;
    private boolean altDown;
    private boolean metaDown;
    private TouchPoint touchPoint;
    private List<TouchPoint> touchPoints;

    private TouchEvent(EventType<? extends TouchEvent> eventType) {
        super((EventType<? extends InputEvent>)eventType);
    }

    private TouchEvent(EventType<? extends TouchEvent> eventType, TouchPoint touchPoint, List<TouchPoint> list, int n, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        super((EventType<? extends InputEvent>)eventType);
        if (list != null) {
            this.touchPoints = Collections.unmodifiableList(list);
        }
        this.eventSetId = n;
        this.shiftDown = bl;
        this.controlDown = bl2;
        this.altDown = bl3;
        this.metaDown = bl4;
        this.touchPoint = touchPoint;
    }

    public int getTouchCount() {
        return this.touchPoints.size();
    }

    private static void recomputeToSource(TouchEvent touchEvent, Object object, Object object2) {
        for (TouchPoint touchPoint : touchEvent.touchPoints) {
            touchPoint.recomputeToSource(object, object2);
        }
    }

    @Override
    public Event copyFor(Object object, EventTarget eventTarget) {
        TouchEvent touchEvent = (TouchEvent)super.copyFor(object, eventTarget);
        TouchEvent.recomputeToSource(touchEvent, this.getSource(), object);
        return touchEvent;
    }

    @Deprecated
    public boolean impl_isDirect() {
        return this.isDirect;
    }

    @Deprecated
    public void impl_setDirect(boolean bl) {
        this.isDirect = bl;
    }

    public final int getEventSetId() {
        return this.eventSetId;
    }

    public final boolean isShiftDown() {
        return this.shiftDown;
    }

    public final boolean isControlDown() {
        return this.controlDown;
    }

    public final boolean isAltDown() {
        return this.altDown;
    }

    public final boolean isMetaDown() {
        return this.metaDown;
    }

    public TouchPoint getTouchPoint() {
        return this.touchPoint;
    }

    public List<TouchPoint> getTouchPoints() {
        return this.touchPoints;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("TouchEvent [");
        stringBuilder.append("source = ").append(this.getSource());
        stringBuilder.append(", target = ").append(this.getTarget());
        stringBuilder.append(", eventType = ").append(this.getEventType());
        stringBuilder.append(", consumed = ").append(this.isConsumed());
        stringBuilder.append(", touchCount = ").append(this.getTouchCount());
        stringBuilder.append(", eventSetId = ").append(this.getEventSetId());
        stringBuilder.append(", touchPoint = ").append(this.getTouchPoint().toString());
        return stringBuilder.append("]").toString();
    }

    @Deprecated
    public static TouchEvent impl_touchEvent(EventType<? extends TouchEvent> eventType, TouchPoint touchPoint, List<TouchPoint> list, int n, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        return new TouchEvent(eventType, touchPoint, list, n, bl, bl2, bl3, bl4);
    }
}

