/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.bytes;

import java.io.EOFException;
import java.io.IOException;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefIterator;
import org.elasticsearch.common.io.stream.StreamInput;

final class BytesReferenceStreamInput
extends StreamInput {
    private final BytesRefIterator iterator;
    private int sliceIndex;
    private BytesRef slice;
    private final int length;
    private int offset;

    BytesReferenceStreamInput(BytesRefIterator iterator, int length) throws IOException {
        this.iterator = iterator;
        this.slice = iterator.next();
        this.length = length;
        this.offset = 0;
        this.sliceIndex = 0;
    }

    @Override
    public byte readByte() throws IOException {
        if (this.offset >= this.length) {
            throw new EOFException();
        }
        this.maybeNextSlice();
        byte b = this.slice.bytes[this.slice.offset + this.sliceIndex++];
        ++this.offset;
        return b;
    }

    private void maybeNextSlice() throws IOException {
        while (this.sliceIndex == this.slice.length) {
            this.slice = this.iterator.next();
            this.sliceIndex = 0;
            if (this.slice != null) continue;
            throw new EOFException();
        }
    }

    @Override
    public void readBytes(byte[] b, int bOffset, int len) throws IOException {
        if (this.offset + len > this.length) {
            throw new IndexOutOfBoundsException("Cannot read " + len + " bytes from stream with length " + this.length + " at offset " + this.offset);
        }
        this.read(b, bOffset, len);
    }

    @Override
    public int read() throws IOException {
        if (this.offset >= this.length) {
            return -1;
        }
        return Byte.toUnsignedInt(this.readByte());
    }

    @Override
    public int read(byte[] b, int bOffset, int len) throws IOException {
        int numBytesToCopy;
        if (this.offset >= this.length) {
            return -1;
        }
        int remaining = numBytesToCopy = Math.min(len, this.length - this.offset);
        int destOffset = bOffset;
        while (remaining > 0) {
            this.maybeNextSlice();
            int currentLen = Math.min(remaining, this.slice.length - this.sliceIndex);
            assert (currentLen > 0) : "length has to be > 0 to make progress but was: " + currentLen;
            System.arraycopy(this.slice.bytes, this.slice.offset + this.sliceIndex, b, destOffset, currentLen);
            destOffset += currentLen;
            this.sliceIndex += currentLen;
            this.offset += currentLen;
            assert ((remaining -= currentLen) >= 0) : "remaining: " + remaining;
        }
        return numBytesToCopy;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public int available() throws IOException {
        return this.length - this.offset;
    }

    @Override
    protected void ensureCanReadBytes(int bytesToRead) throws EOFException {
        int bytesAvailable = this.length - this.offset;
        if (bytesAvailable < bytesToRead) {
            throw new EOFException("tried to read: " + bytesToRead + " bytes but only " + bytesAvailable + " remaining");
        }
    }

    @Override
    public long skip(long n) throws IOException {
        int numBytesSkipped;
        int skip = (int)Math.min(Integer.MAX_VALUE, n);
        int remaining = numBytesSkipped = Math.min(skip, this.length - this.offset);
        while (remaining > 0) {
            this.maybeNextSlice();
            int currentLen = Math.min(remaining, this.slice.length - this.sliceIndex);
            this.sliceIndex += currentLen;
            this.offset += currentLen;
            assert ((remaining -= currentLen) >= 0) : "remaining: " + remaining;
        }
        return numBytesSkipped;
    }

    int getOffset() {
        return this.offset;
    }
}

