/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Font;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.JLabel;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.FontLibrary;
import net.sf.freecol.client.gui.panel.ReportPanel;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.common.model.Region;

public final class ReportExplorationPanel
extends ReportPanel {
    private static final Comparator<Region> regionComparator = new Comparator<Region>(){

        @Override
        public int compare(Region region1, Region region2) {
            int number2;
            int number1 = region1.getDiscoveredIn().getNumber();
            if (number1 == (number2 = region2.getDiscoveredIn().getNumber())) {
                return region2.getScoreValue() - region1.getScoreValue();
            }
            return number2 - number1;
        }
    };

    public ReportExplorationPanel(FreeColClient freeColClient) {
        super(freeColClient, "reportExplorationAction");
        this.reportPanel.removeAll();
        ArrayList<Region> regions = new ArrayList<Region>();
        for (Region region : this.getGame().getMap().getRegions()) {
            if (region.getDiscoveredIn() == null) continue;
            regions.add(region);
        }
        Collections.sort(regions, regionComparator);
        this.reportPanel.setLayout(new MigLayout("wrap 5, fillx", "", ""));
        Font font = FontLibrary.createFont(FontLibrary.FontType.NORMAL, FontLibrary.FontSize.TINY, 1, this.getImageLibrary().getScaleFactor());
        JLabel nameOfRegion = Utility.localizedLabel("report.exploration.nameOfRegion");
        nameOfRegion.setFont(font);
        this.reportPanel.add(nameOfRegion);
        JLabel typeOfRegion = Utility.localizedLabel("report.exploration.typeOfRegion");
        typeOfRegion.setFont(font);
        this.reportPanel.add(typeOfRegion);
        JLabel discoveredIn = Utility.localizedLabel("report.exploration.discoveredIn");
        discoveredIn.setFont(font);
        this.reportPanel.add(discoveredIn);
        JLabel discoveredBy = Utility.localizedLabel("report.exploration.discoveredBy");
        discoveredBy.setFont(font);
        this.reportPanel.add(discoveredBy);
        JLabel valueOfRegion = Utility.localizedLabel("report.exploration.valueOfRegion");
        valueOfRegion.setFont(font);
        this.reportPanel.add(valueOfRegion);
        for (Region region : regions) {
            this.reportPanel.add(new JLabel(region.getName()));
            this.reportPanel.add(Utility.localizedLabel(region.getType()));
            this.reportPanel.add(Utility.localizedLabel(region.getDiscoveredIn().getLabel()));
            this.reportPanel.add(Utility.localizedLabel(region.getDiscoveredBy().getCountryLabel()));
            this.reportPanel.add(new JLabel(String.valueOf(region.getScoreValue())));
        }
    }
}

