/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.mindmapmode.actions;

import freemind.controller.MenuItemSelectedListener;
import freemind.controller.actions.generated.instance.AddCloudXmlAction;
import freemind.controller.actions.generated.instance.XmlAction;
import freemind.main.Tools;
import freemind.modes.MindMap;
import freemind.modes.MindMapNode;
import freemind.modes.NodeAdapter;
import freemind.modes.mindmapmode.MindMapCloudModel;
import freemind.modes.mindmapmode.MindMapController;
import freemind.modes.mindmapmode.actions.NodeActorXml;
import freemind.modes.mindmapmode.actions.NodeGeneralAction;
import freemind.modes.mindmapmode.actions.xml.ActionPair;
import java.awt.Color;
import javax.swing.Action;
import javax.swing.JMenuItem;

public class CloudAction
extends NodeGeneralAction
implements NodeActorXml,
MenuItemSelectedListener {
    public CloudAction(MindMapController controller) {
        super(controller, "cloud", "images/Cloud24.gif");
        this.addActor(this);
    }

    @Override
    public Class getDoActionClass() {
        return AddCloudXmlAction.class;
    }

    @Override
    public ActionPair apply(MindMap model, MindMapNode selected) {
        ActionPair pair = this.getActionPair(selected, selected.getCloud() == null);
        return pair;
    }

    public void setCloud(MindMapNode node, boolean enable) {
        this.modeController.doTransaction((String)this.getValue("Name"), this.getActionPair(node, enable));
    }

    private ActionPair getActionPair(MindMapNode selected, boolean enable) {
        AddCloudXmlAction cloudAction = this.createAddCloudXmlAction(selected, enable, null);
        AddCloudXmlAction undocloudAction = null;
        undocloudAction = selected.getCloud() != null ? this.createAddCloudXmlAction(selected, true, selected.getCloud().getColor()) : this.createAddCloudXmlAction(selected, false, null);
        return new ActionPair((XmlAction)cloudAction, (XmlAction)undocloudAction);
    }

    private AddCloudXmlAction createAddCloudXmlAction(MindMapNode selected, boolean enable, Color color) {
        AddCloudXmlAction nodecloudAction = new AddCloudXmlAction();
        nodecloudAction.setNode(this.getNodeID(selected));
        nodecloudAction.setEnabled(enable);
        nodecloudAction.setColor(Tools.colorToXml(color));
        return nodecloudAction;
    }

    @Override
    public void act(XmlAction action) {
        AddCloudXmlAction nodecloudAction;
        NodeAdapter node;
        if (action instanceof AddCloudXmlAction && (node = this.getNodeFromID((nodecloudAction = (AddCloudXmlAction)action).getNode())).getCloud() == null == nodecloudAction.getEnabled()) {
            if (nodecloudAction.getEnabled()) {
                if (node.isRoot()) {
                    return;
                }
                node.setCloud(new MindMapCloudModel(node, this.getMindMapController().getFrame()));
                if (nodecloudAction.getColor() != null) {
                    Color color = Tools.xmlToColor(nodecloudAction.getColor());
                    ((MindMapCloudModel)node.getCloud()).setColor(color);
                }
            } else {
                node.setCloud(null);
            }
            this.modeController.nodeChanged(node);
        }
    }

    @Override
    public boolean isSelected(JMenuItem pCheckItem, Action pAction) {
        return this.modeController.getSelected().getCloud() != null;
    }
}

