/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.mindmapmode.attributeactors;

import freemind.controller.filter.util.SortedListModel;
import freemind.main.Resources;
import freemind.modes.mindmapmode.attributeactors.AttributeManagerDialog;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

class AttributeRegistryTable
extends JTable {
    private static final ButtonRenderer editButtonRenderer = new ButtonRenderer(AttributeManagerDialog.editButtonImage, Resources.getInstance().getResourceString("attributes_edit_tooltip"));
    private static final Icon checkBoxImage = new ImageIcon(Resources.getInstance().getResource("images/checkbox12.png"));
    private final ButtonRenderer selectAllButtonRenderer;
    private final ButtonEditor selectAllButtonEditor;
    private final AttributeManagerDialog.EditListAction editListAction;

    public AttributeRegistryTable(AttributeManagerDialog.EditListAction editListAction) {
        this.editListAction = editListAction;
        this.getTableHeader().setReorderingAllowed(false);
        this.selectAllButtonRenderer = new ButtonRenderer(checkBoxImage, Resources.getInstance().getResourceString("attributes_select_all_tooltip"));
        this.selectAllButtonEditor = new ButtonEditor(new ToggleAllAction());
        this.setDefaultEditor(SortedListModel.class, new ButtonEditor(editListAction));
        this.setDefaultRenderer(SortedListModel.class, editButtonRenderer);
        this.setRowHeight(20);
        this.setRowSelectionAllowed(false);
    }

    @Override
    public void setModel(TableModel dataModel) {
        super.setModel(dataModel);
        if (dataModel.getColumnCount() >= 1) {
            for (int i = 1; i < this.getColumnCount(); ++i) {
                this.getColumnModel().getColumn(i).setMinWidth(20);
                int prefWidth = this.getTableHeader().getDefaultRenderer().getTableCellRendererComponent((JTable)this, (Object)this.getColumnName((int)i), (boolean)false, (boolean)false, (int)-1, (int)i).getPreferredSize().width;
                this.getColumnModel().getColumn(i).setPreferredWidth(prefWidth);
            }
        }
    }

    @Override
    public TableCellEditor getCellEditor(int row, int column) {
        if (row == 0 && column == 1) {
            return this.selectAllButtonEditor;
        }
        return super.getCellEditor(row, column);
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        if (row == 0 && column == 1) {
            return this.selectAllButtonRenderer;
        }
        TableCellRenderer tableCellRenderer = super.getCellRenderer(row, column);
        if (tableCellRenderer instanceof JLabel) {
            JLabel label = (JLabel)((Object)tableCellRenderer);
            if (row == 0) {
                label.setHorizontalAlignment(0);
            } else {
                label.setHorizontalAlignment(2);
            }
        } else if (tableCellRenderer instanceof JComponent) {
            JComponent label = (JComponent)((Object)tableCellRenderer);
            switch (column) {
                case 1: {
                    label.setToolTipText(Resources.getInstance().getResourceString("attributes_visible_tooltip"));
                    break;
                }
                case 2: {
                    if (row == 0) {
                        label.setToolTipText(Resources.getInstance().getResourceString("attributes_restricted_attributes_tooltip"));
                        break;
                    }
                    label.setToolTipText(Resources.getInstance().getResourceString("attributes_restricted_values_tooltip"));
                }
            }
        }
        return tableCellRenderer;
    }

    @Override
    public Component prepareEditor(TableCellEditor editor, int row, int column) {
        if (column == 3) {
            SortedListModel list = (SortedListModel)this.getModel().getValueAt(row, column);
            String title = this.getModel().getValueAt(row, 0).toString();
            String labelText = Resources.getInstance().getResourceString("attribute_list_box_label_text");
            this.editListAction.setListBoxModel(title, labelText, list);
        }
        return super.prepareEditor(editor, row, column);
    }

    private class ToggleAllAction
    extends AbstractAction {
        public ToggleAllAction() {
            super("", checkBoxImage);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Boolean checked = (Boolean)AttributeRegistryTable.this.getValueAt(1, 1);
            checked = checked == false;
            for (int i = 1; i < AttributeRegistryTable.this.getRowCount(); ++i) {
                AttributeRegistryTable.this.setValueAt(checked, i, 1);
            }
        }
    }

    private static class ButtonRenderer
    implements TableCellRenderer {
        private final JButton renderingEditButton;

        public ButtonRenderer(Icon image, String toolTip) {
            this.renderingEditButton = new JButton(image);
            this.renderingEditButton.setFocusable(false);
            this.renderingEditButton.setToolTipText(toolTip);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            return this.renderingEditButton;
        }

        public void setEnabled(boolean b) {
            this.renderingEditButton.setEnabled(b);
        }
    }

    private static class ButtonEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private final JButton editButton;
        private Object value;

        public ButtonEditor(Icon image) {
            this.editButton = new JButton(image);
            this.editButton.setFocusable(false);
        }

        public ButtonEditor(Action action) {
            this.editButton = new JButton(action);
            this.editButton.setFocusable(false);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.value = value;
            return this.editButton;
        }

        @Override
        public Object getCellEditorValue() {
            return this.value;
        }

        public void setAction(Action a) {
            this.editButton.setAction(a);
        }
    }
}

