/*
 * Decompiled with CFR 0.152.
 */
package com.inet.jortho;

import com.inet.jortho.CustomUIProvider;
import com.inet.jortho.SpellChecker;
import java.awt.Dialog;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.lang.reflect.Method;
import java.util.ResourceBundle;
import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTextField;

public class Utils {
    static String getResource(String string) {
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle("com.inet.jortho.i18n.resource");
            return resourceBundle.getString(string);
        }
        catch (Exception exception) {
            if (!string.endsWith(".tooltip")) {
                SpellChecker.getMessageHandler().handleException(exception);
            }
            return string;
        }
    }

    static JButton getButton(String string) {
        JButton jButton;
        CustomUIProvider customUIProvider = SpellChecker.getCustomUIProvider();
        if (customUIProvider != null) {
            jButton = customUIProvider.getButton(string);
        } else {
            jButton = new JButton(Utils.getResource(string));
            String string2 = string + ".tooltip";
            String string3 = Utils.getResource(string2);
            if (string3 != string2) {
                jButton.setToolTipText(string3);
            }
        }
        return jButton;
    }

    static JTextField getTextField() {
        CustomUIProvider customUIProvider = SpellChecker.getCustomUIProvider();
        JTextField jTextField = customUIProvider != null ? customUIProvider.getTextField() : new JTextField();
        return jTextField;
    }

    static JLabel getLabel(String string) {
        CustomUIProvider customUIProvider = SpellChecker.getCustomUIProvider();
        JLabel jLabel = customUIProvider != null ? customUIProvider.getLabel(string) : new JLabel(string);
        return jLabel;
    }

    static JList getList() {
        CustomUIProvider customUIProvider = SpellChecker.getCustomUIProvider();
        if (customUIProvider != null) {
            return customUIProvider.getList();
        }
        return new JList();
    }

    static void setDialogIcon(JDialog jDialog) {
        try {
            BufferedImage bufferedImage = ImageIO.read(jDialog.getClass().getResourceAsStream("icon.png"));
            Class<Dialog> clazz = Dialog.class;
            Method method = clazz.getMethod("setIconImage", Image.class);
            method.invoke((Object)jDialog, bufferedImage);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static String getCapitalized(String string) {
        if (string.length() > 0 && Character.isLowerCase(string.charAt(0))) {
            return string.substring(0, 1).toUpperCase() + string.substring(1);
        }
        return string;
    }

    static String getInvertedCapitalizion(String string) {
        if (string.length() > 0) {
            if (Character.isLowerCase(string.charAt(0))) {
                return string.substring(0, 1).toUpperCase() + string.substring(1);
            }
            if (Character.isUpperCase(string.charAt(0))) {
                return string.substring(0, 1).toLowerCase() + string.substring(1);
            }
        }
        return string;
    }

    static boolean isFirstCapitalized(String string) {
        return string.length() > 0 && Character.isUpperCase(string.charAt(0));
    }

    static boolean isAllCapitalized(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (!Character.isLetter(c) || Character.isUpperCase(c)) continue;
            return false;
        }
        return true;
    }

    static boolean isIncludeNumbers(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (!Character.isDigit(c)) continue;
            return true;
        }
        return false;
    }

    public static String replaceUnicodeQuotation(String string) {
        char[] cArray = null;
        block4: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '`': 
                case '\u00b4': 
                case '\u2018': 
                case '\u2019': 
                case '\u201a': 
                case '\u201b': {
                    if (cArray == null) {
                        cArray = string.toCharArray();
                    }
                    cArray[i] = 39;
                    continue block4;
                }
                case '\u2011': 
                case '\u2012': 
                case '\u2013': 
                case '\u2014': 
                case '\u2015': {
                    if (cArray == null) {
                        cArray = string.toCharArray();
                    }
                    cArray[i] = 45;
                }
            }
        }
        return cArray == null ? string : new String(cArray);
    }
}

