/*
 * Decompiled with CFR 0.152.
 */
package com.inet.jortho;

import com.inet.jortho.SpellChecker;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.zip.InflaterInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WordIterator
implements Iterator<String> {
    private BufferedReader input;
    private String word;

    public WordIterator(URL uRL) throws IOException {
        this(WordIterator.createInflaterStream(uRL), "UTF8");
    }

    public WordIterator(InputStream inputStream, String string) throws IOException {
        this(new InputStreamReader(inputStream, string));
    }

    public WordIterator(Reader reader) throws IOException {
        this.input = new BufferedReader(reader);
        this.word = this.input.readLine();
    }

    private static InputStream createInflaterStream(URL uRL) throws IOException {
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.setReadTimeout(5000);
        InputStream inputStream = uRLConnection.getInputStream();
        inputStream = new InflaterInputStream(inputStream);
        return new BufferedInputStream(inputStream);
    }

    @Override
    public boolean hasNext() {
        return this.word != null;
    }

    @Override
    public String next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        String string = this.word;
        try {
            this.word = this.input.readLine();
            if (this.word == null) {
                this.input.close();
            }
        }
        catch (IOException iOException) {
            this.word = null;
            SpellChecker.getMessageHandler().handleException(iOException);
        }
        return string;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

