/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.fop.pdf.PDFObject;
import org.apache.fop.pdf.PDFStream;

public class PDFTTFStream
extends PDFStream {
    private int origLength;

    public PDFTTFStream(int len) {
        this.origLength = len;
    }

    protected int output(OutputStream stream) throws IOException {
        PDFObject.log.debug("Writing " + this.origLength + " bytes of TTF font data");
        int length = super.output(stream);
        PDFObject.log.debug("Embedded TrueType/OpenType font");
        return length;
    }

    protected String buildStreamDict(String lengthEntry) {
        String filterEntry = this.getFilterList().buildFilterDictEntries();
        return this.getObjectID() + "<< /Length " + lengthEntry + " /Length1 " + this.origLength + "\n" + filterEntry + "\n>>\n";
    }

    public void setData(byte[] data, int size) throws IOException {
        this.data.clear();
        this.data.getOutputStream().write(data, 0, size);
    }
}

