#############################################################################
##
#W  respectedpartitions.g           GAP4 Package `RCWA'           Stefan Kohl
##
##  Data library of groups generated by 3 class transpositions which inter-
##  change residue classes with moduli <= 6: part containing shortest
##  respected partitions of finite groups.
##
##  The list 'respectedpartitions' below satisfies
##
##     respectedpartitions[i] = List(RespectedPartition(grps[i]),
##                                   cl->[cl!.r[1],cl!.m])
##
##  for all i in [1..52394] such that grps[i] is finite.
##
#############################################################################

local  cls, partitionsset, partitionspos, result, i;

cls :=
[[1,12],[10,12],[9,12],[2,12],[0,12],[11,12],
 [8,12],[3,12],[6,12],[5,12],[4,12],[7,12],
 [27,30],[2,30],[28,30],[1,30],[7,30],[22,30],
 [19,30],[10,30],[26,30],[3,30],[24,30],[5,30],
 [29,30],[0,30],[11,30],[18,30],[4,30],[25,30],
 [13,30],[16,30],[6,30],[23,30],[17,30],[12,30],
 [9,30],[20,30],[8,30],[21,30],[15,30],[14,30],
 [4,6],[1,6],[0,6],[5,6],[3,6],[2,6],[56,60],
 [3,60],[1,60],[58,60],[21,60],[38,60],[23,60],
 [36,60],[59,60],[0,60],[18,60],[41,60],[4,60],
 [55,60],[33,60],[26,60],[43,60],[16,60],[2,60],
 [57,60],[11,60],[48,60],[22,60],[37,60],[31,60],
 [28,60],[42,60],[17,60],[20,60],[39,60],[8,60],
 [51,60],[53,60],[6,60],[25,60],[34,60],[12,60],
 [47,60],[44,60],[14,60],[15,60],[45,60],[46,60],
 [13,60],[50,60],[9,60],[19,60],[40,60],[5,60],
 [54,60],[52,60],[7,60],[29,60],[30,60],[35,60],
 [24,60],[10,60],[49,60],[32,60],[27,60],[4,20],
 [15,20],[0,20],[19,20],[9,20],[10,20],[8,20],
 [11,20],[1,15],[13,15],[12,20],[7,20],[14,20],
 [5,20],[17,20],[2,20],[16,20],[3,20],[18,20],
 [1,20],[6,20],[13,20],[9,15],[0,15],[5,15],
 [14,15],[10,15],[4,15],[16,24],[7,24],[2,18],
 [15,18],[17,18],[0,18],[19,24],[4,24],[20,24],
 [3,24],[12,18],[5,18],[6,15],[8,15],[5,24],
 [18,24],[3,15],[11,15],[3,18],[14,18],[17,24],
 [6,24],[8,18],[9,18],[15,24],[8,24],[11,18],
 [6,18],[7,15],[2,15],[12,15],[1,18],[16,18],
 [23,24],[0,24],[4,18],[13,18],[22,24],[1,24],
 [2,24],[21,24],[10,18],[7,18],[9,24],[14,24],
 [11,24],[12,24],[13,24],[10,24],[6,120],[113,120],
 [28,36],[7,36],[31,36],[4,36],[111,120],[8,120],
 [16,36],[19,36],[24,36],[3,36],[11,36],[32,36],
 [68,120],[51,120],[66,120],[53,120],[5,36],[30,36],
 [46,120],[73,120],[7,120],[112,120],[29,36],[6,36],
 [42,120],[77,120],[86,120],[33,120],[47,120],
 [72,120],[21,36],[14,36],[108,120],[48,120],
 [11,120],[71,120],[27,36],[8,36],[91,120],[28,120],
 [94,120],[25,120],[29,120],[90,120],[26,36],[9,36],
 [9,120],[110,120],[89,90],[0,90],[76,120],[106,120],
 [13,120],[18,36],[17,36],[43,120],[26,120],[93,120],
 [89,120],[30,120],[31,120],[87,90],[88,120],
 [50,120],[2,90],[69,120],[78,120],[41,120],[25,36],
 [10,36],[107,120],[12,120],[85,120],[34,120],
 [87,120],[33,36],[32,120],[2,36],[44,120],[75,120],
 [20,36],[74,120],[45,120],[15,36],[14,120],
 [105,120],[35,36],[0,36],[52,120],[67,120],
 [114,120],[5,120],[27,120],[92,120],[4,90],[85,90],
 [34,36],[1,36],[84,90],[70,120],[49,120],[5,90],
 [103,120],[16,120],[54,120],[38,120],[65,120],
 [81,120],[23,36],[12,36],[17,120],[102,120],
 [10,120],[109,120],[35,120],[84,120],[18,120],
 [101,120],[104,120],[15,120],[82,120],[37,120],
 [36,120],[83,120],[36,90],[53,90],[115,120],[4,120],
 [9,90],[80,90],[39,120],[80,120],[24,120],[95,120],
 [20,120],[99,120],[3,120],[116,120],[12,90],[77,90],
 [79,120],[40,120],[96,120],[23,120],[47,90],[42,90],
 [1,120],[118,120],[35,90],[54,90],[81,90],[8,90],
 [3,90],[86,90],[0,120],[119,120],[50,90],[39,90],
 [52,90],[37,90],[97,120],[100,120],[22,120],
 [19,120],[34,90],[6,90],[83,90],[55,90],[2,120],
 [117,120],[98,120],[21,120],[29,90],[60,90],[57,90],
 [59,90],[30,90],[32,90],[45,90],[44,90],[75,90],
 [14,90],[27,90],[82,90],[7,90],[62,90],[72,90],
 [17,90],[20,90],[69,90],[9,10],[0,10],[74,90],
 [15,90],[55,120],[64,120],[10,90],[79,90],[59,120],
 [68,90],[60,120],[21,90],[4,10],[5,10],[51,90],
 [78,90],[11,90],[38,90],[163,180],[16,180],[2,4],
 [56,90],[1,4],[0,4],[33,90],[3,4],[56,120],
 [66,90],[63,120],[23,90],[24,90],[65,90],[26,90],
 [63,90],[76,180],[103,180],[22,36],[13,36],[43,180],
 [136,180],[2,10],[71,90],[7,10],[18,90],[22,90],
 [67,90],[49,90],[40,90],[101,180],[78,180],[48,90],
 [41,90],[11,180],[168,180],[25,90],[64,90],[62,120],
 [58,120],[61,120],[57,120],[1,3],[2,3],[0,3],
 [21,180],[158,180],[19,90],[70,90],[1,10],[8,10],
 [81,180],[106,180],[98,180],[73,180],[13,180],
 [133,180],[46,180],[166,180],[18,180],[161,180],
 [6,10],[41,180],[138,180],[3,10],[42,180],[137,180],
 [173,180],[6,180],[108,180],[71,180],[8,180],
 [171,180],[38,180],[141,180],[1,90],[88,90],
 [83,180],[96,180],[31,90],[58,90],[48,180],
 [131,180],[68,180],[174,180],[16,90],[5,180],
 [111,180],[73,90],[77,180],[169,180],[104,180],
 [102,180],[75,180],[10,180],[76,90],[13,90],
 [47,180],[132,180],[9,180],[17,180],[170,180],
 [162,180],[164,180],[15,180],[14,180],[165,180],
 [69,180],[110,180],[105,180],[74,180],[100,180],
 [79,180],[51,180],[128,180],[66,180],[113,180],
 [44,180],[135,180],[12,180],[167,180],[134,180],
 [45,180],[126,180],[43,90],[46,90],[53,180],
 [143,180],[72,180],[107,180],[36,180],[84,180],
 [95,180],[160,180],[19,180],[50,180],[129,180],
 [70,180],[109,180],[156,180],[23,180],[20,180],
 [99,180],[159,180],[80,180],[28,90],[61,90],
 [52,180],[114,180],[65,180],[127,180],[39,180],
 [140,180],[54,180],[125,180],[7,180],[139,180],
 [172,180],[40,180],[155,180],[24,180],[112,180],
 [37,180],[142,180],[67,180],[82,180],[97,180],
 [130,180],[49,180],[4,180],[175,180],[35,180],
 [144,180],[157,180],[22,180],[115,180],[64,180],
 [124,180],[55,180],[3,180],[176,180],[178,180],
 [1,180],[86,180],[60,180],[119,180],[93,180],
 [56,180],[123,180],[63,180],[116,180],[179,180],
 [0,180],[61,180],[118,180],[154,180],[25,180],
 [153,180],[26,180],[146,180],[33,180],[32,180],
 [59,180],[120,180],[147,180],[145,180],[58,180],
 [121,180],[34,180],[152,180],[27,180],[91,180],
 [88,180],[57,180],[122,180],[94,180],[85,180],
 [151,180],[28,180],[177,180],[2,180],[92,180],
 [87,180],[62,180],[117,180],[148,180],[31,180],
 [150,180],[29,180],[89,180],[90,180],[37,40],
 [222,240],[2,40],[17,240],[7,40],[32,40],[25,40],
 [14,40],[102,240],[137,240],[30,180],[149,180],
 [2,5],[4,5],[1,5],[3,5],[0,5],[12,240],
 [227,240],[19,40],[29,40],[10,40],[20,40],[33,40],
 [6,40],[58,72],[34,40],[13,72],[5,40],[3,40],
 [27,40],[36,40],[9,40],[12,40],[30,40],[107,240],
 [15,240],[224,240],[132,240],[1,40],[38,40],
 [52,240],[187,240],[67,240],[172,240],[150,240],
 [31,40],[89,240],[8,40],[11,40],[28,40],[32,48],
 [15,48],[39,40],[13,40],[26,40],[0,40],[142,240],
 [97,240],[22,72],[49,72],[39,48],[8,48],[35,40],
 [4,40],[30,240],[209,240],[144,240],[95,240],
 [22,240],[104,240],[226,240],[217,240],[13,240],
 [135,240],[167,240],[72,240],[106,240],[133,240],
 [15,40],[92,240],[22,40],[147,240],[146,240],
 [17,40],[93,240],[24,40],[85,240],[154,240],
 [51,240],[212,240],[188,240],[27,240],[26,240],
 [205,240],[34,240],[213,240],[151,240],[192,240],
 [47,240],[88,240],[152,240],[36,48],[34,48],[11,48],
 [10,48],[87,240],[13,48],[37,48],[208,240],[53,240],
 [120,270],[31,240],[149,270],[186,240],[68,240],
 [16,40],[23,40],[171,240],[90,240],[149,240],
 [12,48],[35,48],[62,240],[177,240],[24,240],
 [215,240],[66,240],[173,240],[210,270],[155,240],
 [59,270],[84,240],[207,240],[29,240],[98,240],
 [210,240],[32,240],[141,240],[1,8],[5,8],[6,8],
 [182,240],[2,8],[7,8],[57,240],[4,8],[0,8],
 [3,8],[165,240],[23,270],[74,240],[246,270],[6,72],
 [63,72],[65,72],[8,72],[21,240],[218,240],[59,72],
 [221,240],[8,240],[205,270],[12,72],[64,270],
 [231,240],[18,240],[45,240],[194,240],[20,240],
 [18,40],[219,240],[216,240],[64,240],[175,240],
 [153,240],[86,240],[23,240],[21,40],[229,240],
 [101,240],[96,240],[73,240],[143,240],[155,270],
 [166,240],[114,270],[35,240],[10,240],[138,240],
 [204,240],[27,270],[19,240],[206,240],[242,270],
 [159,240],[80,240],[33,240],[150,270],[119,270],
 [107,270],[162,270],[220,240],[42,72],[117,270],
 [152,270],[240,270],[65,270],[204,270],[29,72],
 [29,270],[154,270],[115,270],[157,270],[239,270],
 [112,270],[145,240],[30,270],[94,240],[244,270],
 [91,240],[248,360],[4,48],[111,360],[25,270],[9,72],
 [148,240],[62,72],[43,48],[291,360],[8,360],[28,48],
 [75,240],[351,360],[164,240],[61,240],[139,240],
 [100,240],[19,48],[46,240],[68,360],[193,240],
 [178,240],[14,240],[140,240],[225,240],[99,240],
 [170,240],[230,240],[28,240],[9,240],[44,240],
 [69,240],[70,240],[99,360],[211,240],[195,240],
 [169,240],[260,360],[346,360],[50,240],[60,270],
 [136,240],[189,240],[209,270],[157,240],[82,240],
 [3,48],[130,240],[16,240],[223,240],[44,48],
 [13,360],[109,240],[103,240],[133,360],[184,240],
 [32,270],[20,360],[237,270],[23,360],[141,270],
 [218,270],[226,360],[339,360],[77,240],[51,270],
 [134,240],[55,240],[128,270],[336,360],[162,240],
 [105,240],[183,240],[110,240],[56,240],[200,240],
 [7,240],[39,240],[188,360],[62,270],[253,360],
 [122,270],[58,240],[263,360],[232,240],[96,360],
 [207,270],[25,240],[171,360],[106,360],[129,240],
 [181,240],[190,240],[214,240],[49,240],[147,270],
 [30,48],[128,360],[203,360],[202,240],[51,360],
 [308,360],[37,240],[156,360],[231,360],[17,48],
 [22,270],[27,72],[44,72],[111,240],[46,360],
 [11,240],[23,72],[228,240],[48,72],[128,240],
 [247,270],[313,360],[231,270],[219,360],[245,270],
 [140,360],[38,270],[17,270],[252,270],[110,270],
 [71,240],[113,270],[24,270],[156,270],[159,270],
 [168,240],[176,240],[83,360],[200,270],[63,240],
 [276,360],[69,270],[228,360],[17,80],[131,360],
 [66,270],[62,80],[203,270],[109,270],[81,360],
 [41,48],[26,360],[160,270],[27,48],[197,270],
 [330,360],[14,72],[6,48],[278,360],[29,360],[57,72],
 [333,360],[72,270],[20,48],[193,360],[286,360],
 [48,240],[39,360],[105,270],[164,270],[14,48],
 [127,240],[73,360],[200,360],[166,360],[320,360],
 [80,360],[191,240],[33,48],[112,240],[159,360],
 [149,360],[210,360],[279,360],[9,48],[108,240],
 [57,80],[138,360],[26,72],[67,270],[221,360],
 [11,360],[348,360],[22,80],[261,360],[98,360],
 [156,240],[38,48],[83,240],[47,48],[48,360],[45,72],
 [311,360],[202,270],[131,240],[0,48],[30,360],
 [329,360],[95,360],[160,240],[203,240],[36,360],
 [25,360],[334,360],[264,360],[93,360],[323,360],
 [266,360],[36,240],[79,240],[90,360],[275,360],
 [269,360],[227,360],[70,270],[199,270],[245,360],
 [206,360],[94,360],[47,360],[209,360],[174,240],
 [84,360],[132,360],[150,360],[6,360],[353,360],
 [114,360],[153,360],[265,360],[65,240],[312,360],
 [16,48],[225,360],[29,48],[158,360],[324,360],
 [35,360],[273,360],[12,360],[213,360],[173,360],
 [134,360],[31,48],[146,360],[18,48],[201,360],
 [185,240],[21,360],[338,360],[86,360],[205,360],
 [186,360],[54,240],[154,360],[347,360],[135,540],
 [31,360],[42,240],[43,72],[41,360],[187,270],
 [271,360],[315,540],[212,270],[143,360],[57,270],
 [168,360],[197,240],[42,48],[270,360],[144,360],
 [215,360],[208,360],[328,360],[82,270],[216,360],
 [88,360],[404,540],[28,72],[89,360],[5,48],
 [191,360],[151,360],[318,360],[33,360],[326,360],
 [224,540],[192,360],[45,360],[27,80],[85,360],
 [24,360],[314,360],[7,270],[52,80],[274,360],
 [233,240],[24,48],[23,48],[335,360],[167,360],
 [155,360],[262,270],[38,360],[321,360],[6,240],
 [204,360],[108,360],[314,540],[67,80],[56,72],
 [251,360],[138,540],[345,360],[229,360],[341,360],
 [135,360],[195,270],[101,360],[74,270],[139,360],
 [401,540],[18,360],[12,80],[258,360],[44,540],
 [15,72],[220,360],[14,360],[225,540],[495,540],
 [224,360],[130,360],[19,360],[259,360],[100,360],
 [7,48],[78,240],[325,360],[45,540],[221,540],
 [71,360],[34,360],[161,240],[318,540],[40,48],
 [288,360],[494,540],[294,360],[340,360],[65,360],
 [125,360],[78,360],[129,360],[281,360],[41,540],
 [55,270],[7,72],[254,360],[293,360],[354,360],
 [105,360],[230,360],[331,360],[50,360],[64,72],
 [148,360],[228,540],[234,360],[287,360],[72,360],
 [311,540],[211,360],[28,360],[5,360],[194,360],
 [165,360],[54,270],[498,540],[66,360],[309,360],
 [214,270],[215,270],[126,240],[145,360],[214,360],
 [198,360],[405,540],[268,360],[134,540],[91,360],
 [113,240],[45,48],[97,270],[218,360],[137,360],
 [141,360],[310,360],[74,360],[285,360],[222,360],
 [2,48],[161,360],[48,540],[491,540],[172,270],
 [315,360],[49,360],[44,360],[250,360],[180,240],
 [151,270],[69,360],[52,72],[290,360],[145,270],
 [28,270],[40,240],[249,360],[280,360],[349,360],
 [111,270],[9,360],[60,72],[11,72],[109,360],
 [118,270],[124,270],[131,540],[350,360],[42,360],
 [241,270],[10,360],[248,270],[199,240],[136,360],
 [59,240],[408,540],[21,270],[110,360],[317,360],
 [79,360],[158,270],[19,72],[223,360],[319,360],
 [144,270],[56,270],[125,270],[113,360],[40,360],
 [229,540],[310,540],[234,240],[50,72],[50,270],
 [53,72],[18,72],[21,72],[219,270],[213,270],
 [107,360],[246,360],[5,240],[252,360],[39,72],
 [34,270],[243,360],[254,270],[140,270],[186,270],
 [116,360],[83,270],[32,72],[235,270],[15,270],
 [129,270],[170,360],[60,240],[41,240],[53,360],
 [490,540],[496,540],[70,360],[68,270],[125,240],
 [263,270],[26,48],[22,360],[198,240],[174,360],
 [179,240],[114,240],[337,360],[305,360],[127,270],
 [21,48],[54,72],[201,270],[63,360],[185,360],
 [169,360],[6,270],[43,540],[49,540],[289,360],
 [189,360],[54,360],[306,360],[142,270],[17,72],
 [190,360],[296,360],[130,540],[316,360],[504,540],
 [39,270],[217,270],[103,540],[4,72],[67,72],[61,72],
 [160,360],[2,240],[237,240],[283,540],[10,72],
 [436,540],[199,360],[46,540],[230,270],[35,540],
 [256,540],[52,270],[493,540],[409,540],[43,360],
 [77,360],[344,360],[198,540],[234,270],[284,360],
 [313,540],[226,540],[75,360],[81,240],[222,270],
 [220,540],[15,360],[35,270],[233,360],[256,360],
 [47,270],[400,540],[18,540],[76,540],[341,540],
 [161,540],[319,540],[521,540],[257,360],[103,360],
 [463,540],[378,540],[126,360],[282,360],[158,240],
 [139,540],[102,360],[201,240],[316,540],[16,360],
 [173,270],[499,540],[17,540],[403,540],[522,540],
 [223,540],[20,270],[96,270],[108,540],[33,270],
 [40,540],[146,270],[236,270],[288,540],[431,540],
 [37,270],[196,360],[202,360],[283,360],[76,360],
 [251,540],[343,360],[38,240],[123,270],[249,270],
 [136,540],[232,270],[157,360],[163,360],[255,360],
 [104,360],[468,540],[16,72],[71,540],[55,72],
 [255,540],[192,270],[395,540],[406,540],[204,540],
 [133,540],[102,270],[284,540],[5,72],[167,270],
 [257,270],[23,540],[335,540],[12,270],[66,72],
 [144,540],[77,270],[516,540],[162,540],[195,540],
 [0,240],[49,270],[250,270],[344,540],[132,270],
 [40,72],[122,240],[324,540],[19,270],[45,80],
 [31,72],[377,540],[501,540],[14,540],[137,270],
 [525,540],[220,270],[34,80],[239,240],[215,540],
 [42,270],[38,540],[227,270],[117,240],[82,360],
 [4,240],[231,540],[383,540],[252,540],[217,360],
 [195,360],[166,540],[306,540],[287,540],[233,540],
 [3,72],[24,80],[130,270],[139,270],[142,360],
 [68,72],[55,80],[235,240],[373,540],[277,360],
 [203,540],[156,540],[308,540],[164,360],[336,540],
 [183,360],[51,72],[67,360],[473,540],[262,360],
 [229,270],[172,360],[3,360],[40,270],[322,360],
 [97,360],[524,540],[342,540],[293,540],[176,360],
 [41,72],[187,360],[15,540],[53,540],[526,540],
 [384,540],[246,540],[197,540],[37,360],[356,360],
 [486,540],[61,270],[30,72],[66,540],[346,540],
 [413,540],[155,540],[165,270],[20,72],[208,270],
 [126,540],[193,540],[104,270],[292,360],[13,540],
 [218,540],[113,540],[107,540],[432,540],[375,540],
 [56,360],[163,540],[16,540],[435,540],[36,540],
 [503,540],[165,540],[376,540],[104,540],[164,540],
 [523,540],[115,360],[426,540],[244,360],[236,360],
 [303,360],[321,540],[374,540],[123,360],[1,48],
 [124,240],[398,540],[24,540],[141,540],[7,360],
 [352,360],[115,240],[515,540],[243,270],[257,540],
 [40,80],[282,540],[38,72],[46,48],[437,540],
 [255,270],[26,270],[33,72],[5,80],[39,80],[396,540],
 [74,80],[102,540],[143,540],[14,270],[199,540],
 [51,540],[286,540],[72,540],[253,540],[128,540],
 [196,540],[32,80],[15,80],[488,540],[343,540],
 [234,540],[64,80],[76,240],[467,540],[305,540],
 [411,540],[163,240],[47,80],[340,540],[216,540],
 [49,80],[430,540],[206,270],[323,540],[474,540],
 [106,540],[247,360],[108,270],[25,48],[36,72],
 [75,540],[462,540],[21,80],[77,540],[61,80],
 [161,270],[425,540],[63,270],[120,240],[109,540],
 [64,360],[35,72],[307,360],[464,540],[52,360],
 [30,80],[22,48],[119,240],[112,360],[58,80],
 [414,540],[65,540],[433,540],[114,540],[125,540],
 [70,540],[295,360],[469,540],[18,80],[466,540],
 [129,540],[410,540],[140,540],[0,80],[219,540],
 [230,540],[44,80],[342,360],[500,540],[73,540],
 [320,540],[37,72],[34,72],[399,540],[39,540],
 [309,540],[17,360],[35,80],[29,80],[465,540],
 [50,540],[79,80],[46,72],[12,540],[25,72],[196,240],
 [50,80],[43,240],[489,540],[527,540],[74,540],
 [285,540],[475,540],[235,360],[294,540],[72,80],
 [254,540],[379,540],[245,540],[197,360],[372,540],
 [7,80],[24,72],[71,270],[167,540],[160,540],[47,72],
 [124,360],[162,360],[198,270],[64,540],[250,540],
 [434,540],[440,540],[18,270],[232,360],[338,540],
 [105,540],[127,360],[260,540],[194,540],[289,540],
 [345,540],[485,540],[279,540],[251,270],[54,540],
 [201,540],[99,540],[41,270],[347,540],[228,270],
 [221,270],[192,540],[45,270],[70,80],[133,270],
 [4,360],[9,80],[46,270],[224,270],[55,360],[98,540],
 [136,270],[223,270],[3,240],[48,270],[131,270],
 [236,240],[355,360],[304,360],[138,270],[441,540],
 [69,80],[80,540],[427,540],[261,540],[459,540],
 [123,240],[112,540],[339,540],[424,480],[55,480],
 [116,240],[200,540],[278,540],[10,80],[247,540],
 [292,540],[1,2],[184,480],[0,2],[23,80],[135,270],
 [75,270],[19,540],[56,80],[43,270],[295,480],
 [520,540],[226,270],[4,80],[134,270],[75,80],
 [194,270],[20,80],[63,80],[381,540],[20,810],
 [249,810],[59,80],[518,540],[184,360],[368,540],
 [16,80],[153,270],[267,360],[158,540],[21,540],
 [8,540],[171,540],[458,540],[244,540],[789,810],
 [259,540],[37,80],[92,360],[42,80],[295,540],
 [280,540],[116,270],[560,810],[225,270],[175,360],
 [115,540],[81,540],[531,540],[44,270],[424,540],
 [272,360],[369,540],[790,810],[519,810],[371,540],
 [53,270],[471,540],[100,540],[438,540],[170,540],
 [143,270],[11,540],[101,540],[69,72],[9,540],
 [70,72],[380,540],[461,540],[159,540],[87,360],
 [81,270],[281,540],[332,360],[168,540],[250,810],
 [290,810],[1,72],[78,540],[27,360],[126,270],
 [216,270],[2,72],[68,540],[559,810],[188,270],
 [530,540],[348,540],[528,540],[439,540],[19,810],
 [258,540],[191,540],[2,80],[20,540],[77,80],
 [152,360],[472,540],[107,480],[460,540],[261,270],
 [79,540],[8,270],[67,540],[372,480],[519,540],
 [207,360],[60,80],[291,540],[428,540],[248,540],
 [205,540],[19,80],[351,540],[334,540],[71,72],
 [98,270],[171,270],[188,540],[111,540],[0,72],
 [289,810],[133,480],[737,810],[342,810],[106,480],
 [520,810],[419,480],[197,810],[467,810],[612,810],
 [117,360],[346,480],[233,270],[373,480],[72,810],
 [242,360],[36,270],[60,480],[181,480],[297,360],
 [189,540],[62,360],[453,480],[302,540],[54,80],
 [327,360],[470,540],[85,108],[173,480],[69,540],
 [64,480],[239,810],[382,540],[212,360],[415,480],
 [22,108],[306,480],[509,810],[26,480],[300,810],
 [25,80],[350,540],[32,360],[147,360],[237,540],
 [298,480],[157,540],[570,810],[65,80],[442,540],
 [742,810],[121,240],[206,540],[252,810],[57,810],
 [367,540],[14,80],[450,480],[532,540],[472,810],
 [32,540],[17,810],[58,480],[118,240],[266,480],
 [390,540],[300,480],[28,540],[421,540],[22,540],
 [517,540],[120,360],[482,810],[597,810],[511,540],
 [7,540],[333,480],[213,480],[105,480],[146,480],
 [53,80],[307,480],[97,540],[29,480],[118,540],
 [30,810],[421,480],[333,540],[779,810],[752,810],
 [67,810],[212,810],[172,480],[239,360],[557,810],
 [466,480],[13,480],[172,540],[149,540],[607,810],
 [179,480],[202,810],[792,810],[507,540],[429,540],
 [110,540],[374,480],[26,80],[327,810],[337,810],
 [13,108],[135,480],[282,480],[383,810],[210,540],
 [473,810],[217,480],[132,480],[67,480],[197,480],
 [264,480],[140,480],[529,540],[329,540],[422,540],
 [522,810],[304,540],[121,360],[66,810],[347,480],
 [242,540],[440,720],[238,240],[1,240],[235,540],
 [297,540],[156,810],[743,810],[336,810],[279,720],
 [415,540],[117,540],[238,360],[388,540],[192,480],
 [344,480],[94,108],[653,810],[287,810],[432,480],
 [298,540],[287,480],[426,810],[47,480],[339,480],
 [241,540],[606,810],[412,480],[262,480],[176,480],
 [203,810],[66,80],[124,540],[215,480],[10,540],
 [151,540],[303,480],[13,80],[455,480],[122,540],
 [29,540],[26,540],[210,480],[349,540],[218,480],
 [187,480],[268,480],[300,360],[533,540],[269,480],
 [304,480],[186,480],[62,540],[513,540],[175,480],
 [366,540],[301,360],[457,480],[417,540],[84,108],
 [23,108],[57,360],[96,540],[200,720],[173,540],
 [261,480],[58,360],[24,480],[351,480],[22,480],
 [302,360],[59,360],[49,108],[80,720],[443,540],
 [27,540],[427,480],[293,480],[128,480],[370,540],
 [512,540],[301,480],[6,540],[58,108],[477,540],
 [211,270],[519,720],[214,480],[134,480],[639,720],
 [178,480],[292,480],[211,480],[190,540],[169,540],
 [265,480],[58,270],[345,480],[52,480],[510,540],
 [514,810],[245,810],[202,540],[31,270],[122,360],
 [285,810],[34,540],[159,720],[59,108],[101,108],
 [29,108],[238,270],[564,810],[482,540],[15,810],
 [254,810],[33,540],[342,480],[63,108],[458,480],
 [61,540],[290,540],[515,810],[749,810],[484,540],
 [21,480],[27,108],[256,270],[341,480],[57,540],
 [25,540],[476,540],[187,540],[416,480],[478,540],
 [437,480],[524,810],[560,720],[352,540],[244,810],
 [80,108],[65,108],[277,540],[12,108],[505,540],
 [509,540],[337,540],[44,108],[60,810],[492,540],
 [78,108],[138,480],[514,540],[8,108],[63,540],
 [121,270],[413,480],[794,810],[55,540],[148,270],
 [99,108],[237,360],[249,540],[262,540],[137,480],
 [294,810],[24,810],[13,270],[295,810],[565,810],
 [66,480],[555,810],[785,810],[63,480],[42,480],
 [47,540],[48,108],[42,108],[6,108],[392,540],
 [506,540],[30,540],[95,108],[147,540],[98,108],
 [300,540],[240,360],[462,480],[45,108],[784,810],
 [9,108],[444,720],[207,480],[113,810],[419,540],
 [787,810],[209,810],[454,480],[22,810],[14,480],
 [150,540],[387,540],[389,540],[39,720],[479,810],
 [93,480],[600,810],[696,810],[103,270],[418,480],
 [299,480],[152,540],[239,540],[62,108],[212,540],
 [61,480],[104,480],[180,480],[330,810],[247,810],
 [208,540],[312,540],[207,540],[146,540],[680,720],
 [119,360],[517,810],[465,480],[185,480],[25,480],
 [193,270],[457,540],[451,480],[25,810],[31,540],
 [275,720],[420,480],[154,540],[331,540],[120,540],
 [294,480],[82,540],[272,480],[102,480],[562,810],
 [227,540],[17,480],[386,480],[332,540],[28,480],
 [375,480],[59,480],[101,480],[393,540],[377,480],
 [292,810],[385,540],[76,270],[345,810],[327,540],
 [378,480],[464,810],[508,540],[166,270],[656,810],
 [497,540],[286,480],[402,720],[145,540],[222,540],
 [162,720],[75,810],[222,480],[84,720],[420,540],
 [119,540],[213,540],[423,810],[207,810],[267,480],
 [399,720],[332,810],[42,720],[174,480],[62,810],
 [305,480],[243,540],[317,720],[748,810],[677,720],
 [452,480],[194,810],[81,108],[182,360],[602,810],
 [61,810],[221,480],[320,720],[557,720],[307,540],
 [353,540],[747,810],[331,810],[226,480],[208,810],
 [312,480],[368,480],[26,108],[317,540],[212,480],
 [253,480],[177,360],[734,810],[65,480],[296,540],
 [33,480],[263,540],[111,480],[232,540],[326,540],
 [40,480],[193,480],[444,480],[257,480],[394,540],
 [414,480],[27,480],[386,810],[477,810],[35,480],
 [635,720],[2,360],[42,540],[332,480],[147,480],
 [439,480],[601,810],[478,810],[153,540],[186,540],
 [357,360],[446,480],[167,480],[615,810],[153,810],
 [276,540],[386,540],[258,480],[447,480],[449,480],
 [402,540],[106,270],[206,480],[60,360],[270,480],
 [435,480],[254,480],[456,540],[7,108],[407,480],
 [331,480],[299,360],[423,540],[199,720],[253,270],
 [108,480],[240,540],[520,720],[32,480],[274,480],
 [416,540],[455,720],[196,270],[90,480],[296,480],
 [522,720],[191,480],[154,810],[330,480],[68,480],
 [693,810],[183,480],[100,108],[264,720],[80,270],
 [182,480],[171,480],[299,540],[200,480],[438,480],
 [41,480],[391,540],[424,810],[411,480],[79,270],
 [83,540],[163,270],[190,270],[380,480],[348,480],
 [280,480],[131,480],[148,480],[445,480],[116,810],
 [197,720],[0,360],[16,270],[137,540],[73,270],
 [30,480],[189,270],[205,480],[34,480],[480,540],
 [389,480],[359,360],[72,480],[288,480],[279,480],
 [308,480],[123,540],[209,480],[385,810],[116,540],
 [273,480],[59,540],[149,480],[12,480],[148,540],
 [297,480],[99,480],[199,480],[371,480],[225,480],
 [655,810],[467,480],[44,480],[381,720],[51,80],
 [141,720],[219,480],[474,1080],[56,480],[28,80],
 [575,720],[95,720],[945,1080],[328,540],[132,540],
 [241,360],[694,810],[618,1080],[53,480],[502,540],
 [69,480],[561,720],[423,480],[127,540],[513,720],
 [206,720],[118,360],[379,480],[479,540],[471,1080],
 [410,480],[134,1080],[57,480],[698,720],[153,480],
 [215,720],[593,1080],[204,480],[180,360],[504,720],
 [169,270],[65,1080],[202,720],[608,1080],[319,720],
 [679,720],[461,480],[578,720],[100,270],[268,720],
 [400,720],[461,1080],[275,480],[18,480],[559,720],
 [37,540],[43,108],[412,540],[9,270],[127,480],
 [405,1080],[670,1080],[451,720],[40,720],[46,480],
 [158,720],[252,480],[486,1080],[846,1080],[91,720],
 [52,540],[326,480],[160,720],[164,480],[315,480],
 [211,540],[409,1080],[517,720],[1011,1080],[407,540],
 [338,720],[46,80],[431,480],[10,270],[605,1080],
 [433,480],[227,480],[98,480],[352,480],[48,480],
 [260,480],[624,720],[73,80],[487,540],[68,1080],
 [130,480],[439,720],[64,108],[126,1080],[209,540],
 [115,810],[1014,1080],[330,540],[236,540],[349,480],
 [381,480],[179,360],[674,1080],[422,480],[426,480],
 [6,80],[60,540],[303,540],[953,1080],[33,80],
 [100,480],[21,720],[628,720],[259,270],[260,270],
 [144,720],[280,720],[233,1080],[61,360],[159,1080],
 [195,480],[142,480],[516,1080],[563,1080],[201,720],
 [920,1080],[198,480],[1036,1080],[576,1080],[157,720],
 [358,360],[43,1080],[1043,1080],[216,1080],[254,720],
 [294,1080],[105,720],[214,540],[113,1620],[774,1080],
 [401,1080],[501,720],[582,720],[79,720],[678,1080],
 [208,480],[11,270],[8,80],[218,720],[695,720],
 [28,720],[1001,1080],[132,1080],[863,1080],[109,480],
 [24,720],[388,720],[141,480],[20,480],[978,1080],
 [85,720],[97,480],[36,1080],[425,480],[78,1080],
 [153,720],[518,720],[271,480],[54,480],[202,480],
 [263,480],[337,480],[177,480],[382,480],[258,270],
 [284,480],[170,270],[290,480],[302,480],[503,1080],
 [41,1080],[640,720],[132,720],[756,1080],[587,720],
 [137,720],[621,720],[417,480],[634,720],[305,1080],
 [79,108],[170,480],[614,720],[947,1080],[99,270],
 [216,480],[156,1080],[101,1080],[430,480],[130,144],
 [28,108],[438,1080],[399,1080],[798,1080],[331,720],
 [876,1080],[1038,1080],[785,1080],[459,480],[448,480],
 [309,480],[31,80],[49,480],[323,1080],[1009,1080],
 [680,1080],[465,720],[458,720],[562,720],[1506,1620],
 [13,144],[298,360],[261,720],[190,480],[641,1080],
 [325,540],[203,1080],[62,480],[281,1080],[48,80],
 [289,480],[31,480],[370,480],[277,480],[189,480],
 [1,360],[281,480],[566,720],[70,1080],[691,720],
 [923,1080],[71,80],[98,720],[338,480],[329,810],
 [671,1080],[1005,1080],[395,720],[428,1080],[221,1080],
 [83,1080],[996,1080],[380,1080],[397,540],[168,270],
 [234,1080],[936,1080],[27,96],[178,360],[367,480],
 [581,1080],[831,1080],[469,1080],[387,480],[515,720],
 [383,480],[591,720],[143,1080],[94,480],[788,1080],
 [526,720],[39,480],[142,540],[140,1080],[198,720],
 [335,720],[385,480],[114,1080],[238,540],[488,720],
 [191,270],[214,720],[334,480],[696,1620],[965,1080],
 [456,480],[384,720],[701,720],[325,480],[400,1080],
 [761,1080],[74,1080],[396,1080],[11,80],[393,480],
 [759,1080],[140,720],[145,720],[56,540],[574,720],
 [515,1080],[500,1080],[519,1080],[451,540],[18,720],
 [155,720],[858,1080],[606,1080],[112,480],[129,1080],
 [1034,1080],[579,720],[139,480],[268,540],[773,1080],
 [311,480],[210,810],[88,540],[498,1080],[86,480],
 [642,720],[860,1080],[803,1080],[443,1080],[45,1080],
 [78,270],[53,1080],[394,480],[684,720],[231,720],
 [413,1080],[1026,1080],[610,1080],[23,1080],[39,1080],
 [654,1080],[85,480],[20,96],[248,1080],[75,480],
 [403,1080],[599,810],[404,480],[59,810],[77,720],
 [181,360],[23,480],[564,1080],[341,720],[641,720],
 [939,1080],[579,1080],[968,1080],[101,270],[834,1080],
 [473,1080],[651,1080],[276,720],[193,720],[35,720],
 [1056,1080],[138,1080],[245,1080],[383,1080],[291,1080],
 [78,720],[301,540],[442,480],[219,1080],[845,1080],
 [271,540],[222,720],[443,720],[679,1080],[560,1080],
 [382,720],[480,810],[941,1080],[521,720],[683,1080],
 [154,480],[1040,1080],[145,480],[37,480],[168,480],
 [87,96],[440,480],[950,1080],[50,480],[227,720],
 [505,720],[96,480],[425,1080],[666,1080],[306,1080],
 [497,720],[699,1080],[340,480],[111,1080],[408,1080],
 [318,1080],[750,810],[92,480],[258,1080],[696,1080],
 [337,720],[128,720],[564,720],[676,1080],[492,720],
 [68,80],[1013,1080],[8,96],[68,96],[204,720],
 [636,1080],[429,480],[320,1080],[378,720],[483,540],
 [324,720],[66,1080],[75,96],[821,1080],[276,1080],
 [923,1620],[494,1080],[410,1080],[401,720],[121,540],
 [434,480],[398,1080],[285,480],[322,480],[336,1080],
 [45,480],[672,1080],[89,540],[71,1080],[194,1080],
 [131,1080],[252,720],[353,480],[654,720],[612,720],
 [734,1080],[73,720],[437,720],[54,1080],[646,720],
 [269,540],[737,1080],[266,720],[442,720],[697,720],
 [633,720],[101,720],[73,480],[1039,1080],[217,540],
 [608,720],[197,1080],[294,720],[26,720],[695,1080],
 [446,720],[248,720],[273,720],[253,960],[270,540],
 [70,480],[611,1080],[39,96],[669,1080],[165,480],
 [91,270],[622,720],[336,480],[282,720],[83,720],
 [830,1080],[471,720],[268,270],[281,720],[626,720],
 [95,1080],[763,1080],[22,720],[618,720],[1055,1080],
 [637,720],[90,540],[126,480],[314,480],[882,1080],
 [166,480],[467,720],[1,270],[342,720],[116,144],
 [706,960],[418,540],[82,480],[879,1080],[107,720],
 [137,160],[453,720],[876,1620],[74,480],[397,480],
 [56,96],[565,720],[27,144],[181,270],[345,1080],
 [193,1080],[40,1080],[219,720],[345,720],[450,540],
 [665,1080],[374,720],[449,540],[638,720],[111,720],
 [319,1080],[117,144],[141,1080],[407,1080],[42,144],
 [71,480],[681,1080],[408,480],[43,720],[290,1080],
 [636,720],[1025,1080],[318,720],[258,720],[461,720],
 [274,720],[97,720],[313,480],[26,144],[1008,1080],
 [346,1080],[686,720],[405,480],[230,1080],[1059,1080],
 [492,1080],[65,720],[194,480],[445,720],[277,720],
 [316,1080],[938,1080],[91,480],[438,720],[409,480],
 [948,1080],[468,1080],[310,480],[384,1080],[743,1080],
 [286,720],[616,1080],[20,1080],[113,480],[743,1620],
 [82,720],[154,720],[406,480],[24,1080],[448,540],
 [166,720],[388,480],[849,1080],[553,720],[333,720],
 [22,160],[463,1080],[789,1080],[676,720],[342,1080],
 [585,1080],[790,1080],[733,1080],[289,1080],[58,144],
 [587,1080],[693,720],[86,720],[143,480],[366,480],
 [91,540],[101,144],[33,720],[200,1080],[93,720],
 [336,1620],[88,270],[516,720],[178,270],[414,1080],
 [433,720],[203,720],[81,720],[386,720],[886,1080],
 [322,540],[85,144],[157,480],[760,1080],[76,1080],
 [169,480],[984,1080],[885,1080],[500,720],[705,720],
 [377,720],[14,720],[1283,1620],[425,720],[1003,1080],
 [249,1080],[694,720],[514,720],[770,1080],[205,720],
 [457,720],[114,144],[75,1080],[496,720],[615,1080],
 [20,720],[566,1080],[285,1080],[966,1620],[98,144],
 [381,1080],[444,540],[37,720],[146,720],[37,96],
 [102,160],[266,960],[280,1080],[54,720],[54,96],
 [859,1080],[95,540],[940,1080],[350,480],[285,720],
 [561,1080],[93,108],[619,1080],[466,1080],[758,1080],
 [29,144],[213,720],[799,1080],[794,1080],[45,144],
 [380,720],[17,720],[534,720],[224,720],[174,720],
 [465,1080],[262,720],[791,1080],[293,1080],[275,540],
 [854,1080],[1058,1080],[130,1080],[328,480],[1041,1080],
 [420,960],[148,720],[339,720],[563,720],[732,1080],
 [613,1080],[144,480],[14,108],[314,720],[314,1080],
 [45,720],[57,160],[1067,1080],[291,480],[672,720],
 [665,720],[225,1080],[263,1080],[10,96],[586,720],
 [74,720],[198,1080],[513,1080],[1099,1620],[614,1080],
 [15,480],[79,1080],[278,720],[398,720],[12,1080],
 [949,1080],[155,1080],[411,1080],[4,160],[397,720],
 [765,1080],[139,1080],[403,720],[545,720],[571,720],
 [578,1080],[142,720],[339,1080],[820,1080],[983,1080],
 [414,720],[48,720],[861,1080],[325,720],[259,1080],
 [673,720],[394,720],[144,160],[305,720],[481,540],
 [455,1080],[624,1080],[740,1080],[559,1080],[73,1080],
 [707,720],[655,720],[295,720],[671,720],[623,1080],
 [223,720],[434,720],[795,1080],[506,720],[347,960],
 [439,1080],[288,1080],[156,720],[46,720],[322,720],
 [693,960],[385,720],[69,1080],[698,1080],[1000,1080],
 [25,720],[335,480],[326,720],[260,720],[44,144],
 [456,1080],[674,720],[334,720],[407,720],[699,720],
 [259,720],[284,1080],[406,720],[313,720],[188,480],
 [100,1080],[129,480],[393,720],[816,1080],[64,720],
 [493,720],[441,720],[501,1080],[495,720],[518,1080],
 [620,720],[359,480],[558,720],[220,1080],[347,1080],
 [1004,1080],[267,270],[426,1620],[38,1080],[96,1080],
 [824,1080],[15,160],[218,1080],[125,1080],[645,720],
 [640,1080],[133,720],[99,144],[585,720],[464,720],
 [226,720],[309,1080],[979,1080],[577,720],[682,720],
 [85,96],[464,480],[161,720],[1006,1080],[94,720],
 [508,720],[259,480],[576,720],[264,540],[954,1080],
 [459,720],[625,720],[520,1080],[612,960],[520,1620],
 [881,1080],[702,720],[155,160],[134,720],[89,96],
 [58,540],[12,720],[276,480],[120,480],[485,1080],
 [573,720],[539,960],[372,1080],[312,720],[211,720],
 [405,720],[1193,1620],[924,1080],[668,1080],[203,480],
 [347,720],[424,720],[194,720],[151,480],[707,1080],
 [47,720],[41,720],[321,1080],[152,480],[460,720],
 [653,1620],[786,1080],[464,1080],[255,720],[525,720],
 [594,1080],[143,720],[327,480],[255,1080],[321,720],
 [220,480],[316,720],[99,720],[372,720],[678,720],
 [21,1080],[6,96],[1010,1080],[185,720],[460,1080],
 [41,96],[2,270],[386,960],[573,960],[58,96],
 [132,960],[228,1080],[365,480],[311,1080],[592,720],
 [769,1080],[590,1080],[375,960],[23,96],[972,1620],
 [377,1080],[554,720],[108,1080],[147,1080],[392,480],
 [165,720],[570,1080],[932,1080],[558,1080],[167,1080],
 [120,144],[51,480],[206,1080],[973,1080],[687,1080],
 [150,160],[300,720],[123,144],[839,1080],[216,720],
 [1187,1620],[343,480],[526,1080],[87,480],[213,960],
 [1053,1080],[470,1080],[351,720],[94,144],[584,720],
 [433,1080],[494,720],[57,108],[582,1080],[50,108],
 [103,480],[700,720],[649,1080],[72,108],[449,720],
 [22,144],[497,1080],[419,720],[591,960],[35,108],
 [89,480],[581,720],[2029,2160],[83,480],[110,1080],
 [225,720],[251,1080],[72,96],[23,144],[75,160],
 [644,1080],[308,1080],[156,1620],[435,1080],[521,1080],
 [227,1080],[49,144],[969,1080],[970,1080],[376,480],
 [264,1080],[373,1080],[764,1080],[1031,1080],[579,960],
 [454,720],[971,1080],[660,1620],[16,480],[117,480],
 [981,1080],[9,144],[509,1080],[177,270],[61,108],
 [395,480],[430,1080],[192,1080],[584,960],[270,720],
 [646,1080],[1210,2160],[240,1080],[253,1080],[645,1080],
 [113,1080],[609,1080],[826,1080],[392,1080],[128,1080],
 [102,720],[738,1080],[76,108],[670,720],[34,144],
 [428,480],[362,480],[917,1080],[368,720],[191,720],
 [136,720],[127,720],[685,720],[426,1080],[906,960],
 [299,960],[19,720],[3,270],[74,160],[675,720],
 [873,1080],[160,1080],[498,720],[203,1620],[38,720],
 [19,160],[135,720],[884,1080],[90,720],[377,1620],
 [138,720],[871,1080],[502,720],[455,540],[354,480],
 [95,160],[489,720],[80,160],[606,720],[162,1080],
 [92,270],[868,960],[162,1620],[434,1080],[11,480],
 [283,1080],[486,720],[866,960],[104,1080],[124,960],
 [134,144],[161,1080],[835,960],[432,1620],[556,720],
 [130,2160],[966,1080],[98,1080],[619,720],[396,480],
 [93,960],[250,1080],[19,480],[35,144],[1457,1620],
 [51,1080],[286,1080],[617,720],[10,480],[673,1080],
 [913,1080],[95,480],[388,960],[647,1620],[34,720],
 [995,1080],[1512,1620],[150,480],[113,720],[827,960],
 [158,1080],[815,1080],[567,720],[8,720],[84,1080],
 [880,1080],[643,1080],[1035,1080],[918,1080],[653,1080],
 [588,720],[91,960],[660,960],[201,1080],[793,1080],
 [136,480],[109,1080],[1242,1620],[675,1080],[852,1080],
 [106,1080],[390,480],[711,720],[639,1080],[383,1620],
 [103,1080],[1236,1620],[1028,1080],[93,270],[207,720],
 [912,1080],[196,720],[80,1080],[553,1080],[166,1080],
 [635,1080],[195,720],[107,1620],[36,720],[364,480],
 [921,1080],[473,480],[125,480],[473,720],[217,720],
 [221,720],[615,720],[487,720],[99,1080],[404,1080],
 [746,960],[512,720],[84,160],[702,1620],[580,1080],
 [44,720],[823,1080],[335,1080],[431,1080],[133,1080],
 [204,1080],[926,1080],[255,480],[744,1080],[980,1080],
 [999,1080],[851,1080],[503,720],[998,1080],[357,480],
 [226,960],[223,480],[406,1080],[528,720],[329,480],
 [279,1080],[828,1080],[183,270],[338,1080],[318,480],
 [31,108],[796,1080],[299,1080],[20,144],[387,960],
 [800,1080],[1030,1080],[89,720],[919,1080],[64,160],
 [84,540],[368,960],[81,1080],[121,144],[533,960],
 [176,270],[21,108],[650,1080],[266,270],[426,960],
 [524,720],[6,480],[629,720],[523,720],[310,1080],
 [310,720],[648,1080],[419,1620],[638,1080],[946,1080],
 [315,1080],[161,480],[230,720],[199,1080],[26,1080],
 [100,720],[122,480],[583,720],[85,160],[195,1080],
 [49,1080],[440,1080],[289,1620],[551,720],[53,960],
 [140,160],[444,1080],[84,480],[311,720],[408,720],
 [1200,1620],[878,1080],[256,1080],[887,1080],[224,480],
 [104,720],[208,1080],[153,1080],[246,720],[572,960],
 [168,720],[681,720],[468,480],[926,1620],[46,108],
 [463,480],[491,1080],[1463,1620],[384,480],[233,720],
 [917,1620],[13,1080],[693,1620],[571,960],[458,1080],
 [875,1080],[975,1080],[741,1080],[489,1080],[232,720],
 [959,1620],[108,144],[768,1080],[683,720],[1330,1620],
 [621,1080],[702,1080],[256,480],[380,960],[115,480],
 [460,480],[780,1080],[706,1080],[24,96],[499,1080],
 [48,1080],[152,720],[44,1080],[114,480],[86,270],
 [976,1080],[829,1080],[441,1080],[109,144],[1416,1620],
 [163,720],[436,1080],[429,1080],[49,720],[265,720],
 [341,1080],[409,720],[588,1080],[79,160],[71,96],
 [949,2160],[9,160],[131,720],[733,960],[771,1080],
 [469,480],[86,108],[1066,1080],[630,720],[951,1080],
 [212,1620],[825,1080],[383,720],[66,96],[150,810],
 [148,1620],[401,480],[43,96],[146,810],[391,1620],
 [150,720],[18,1080],[929,1080],[856,1080],[539,540],
 [327,1620],[76,96],[525,1080],[843,1080],[267,540],
 [669,720],[212,1080],[105,1080],[29,810],[88,96],
 [867,960],[352,720],[1137,1620],[251,480],[420,1080],
 [963,1080],[867,1080],[120,1620],[72,1080],[150,1080],
 [509,720],[147,160],[591,1080],[660,720],[32,1080],
 [119,144],[604,960],[506,960],[5,160],[664,720],
 [269,720],[393,810],[1552,1620],[165,1080],[1147,1620],
 [72,1620],[818,1080],[180,540],[1060,1080],[1228,1620],
 [531,720],[12,144],[177,540],[593,720],[24,960],
 [323,480],[833,1080],[269,270],[96,720],[1371,1620],
 [697,1620],[648,720],[229,480],[116,1080],[1146,1620],
 [0,160],[496,1080],[95,144],[137,1080],[87,270],
 [374,1080],[71,108],[149,160],[82,144],[589,960],
 [312,1620],[623,720],[695,960],[327,1080],[89,270],
 [70,160],[686,810],[548,720],[1227,1620],[323,720],
 [751,1620],[396,720],[524,1080],[416,810],[266,540],
 [52,96],[659,810],[367,720],[88,960],[63,144],
 [402,1080],[527,720],[960,1080],[248,1620],[250,480],
 [119,1080],[14,1080],[690,720],[192,720],[122,1620],
 [436,720],[36,480],[436,480],[662,1620],[932,1620],
 [262,1080],[554,1080],[1553,1620],[931,1620],
 [1022,1620],[687,1620],[767,1620],[135,144],[466,720],
 [5,96],[112,1620],[369,480],[453,540],[328,1620],
 [87,540],[189,1080],[27,160],[180,960],[603,1080],
 [32,96],[852,1620],[701,1080],[33,810],[457,1080],
 [1152,1620],[420,810],[110,480],[914,1080],[935,960],
 [389,720],[389,810],[1012,1620],[42,96],[315,720],
 [67,96],[119,480],[569,720],[688,1620],[97,1080],
 [974,1080],[324,1080],[933,960],[527,1080],[337,1620],
 [209,720],[159,160],[447,540],[472,1620],[590,720],
 [453,960],[278,1080],[643,720],[1061,1080],[60,160],
 [410,720],[35,1080],[19,1080],[42,1080],[511,1080],
 [359,540],[360,540],[1292,1620],[59,720],[130,960],
 [544,720],[340,720],[151,1080],[982,1080],[179,540],
 [482,1620],[67,160],[28,96],[7,720],[296,1080],
 [1562,1620],[153,1620],[13,96],[47,1080],[29,720],
 [10,108],[253,720],[801,1080],[606,1620],[173,720],
 [15,720],[80,96],[36,108],[156,480],[597,1620],
 [392,1620],[182,270],[890,1080],[677,1080],[596,1080],
 [1471,1620],[667,1080],[391,960],[63,1080],[247,720],
 [855,960],[1547,1620],[1328,1620],[123,1080],[76,720],
 [24,144],[106,720],[123,810],[16,720],[12,96],
 [530,720],[0,270],[291,1620],[664,1080],[443,480],
 [570,720],[40,96],[871,960],[83,96],[147,1620],
 [7,96],[488,1080],[43,480],[329,720],[80,144],
 [202,1620],[440,960],[472,720],[705,1080],[417,1620],
 [1202,1620],[446,540],[220,720],[736,1080],[534,960],
 [783,1080],[30,720],[112,720],[97,108],[67,1620],
 [89,160],[1044,1080],[546,720],[1466,1620],[415,720],
 [476,1080],[15,96],[666,720],[450,720],[510,720],
 [254,1080],[53,720],[742,1620],[246,480],[1497,1620],
 [788,1620],[236,1080],[167,720],[583,1080],[26,960],
 [656,720],[92,960],[943,1080],[663,810],[51,144],
 [36,144],[362,540],[607,720],[122,144],[848,1080],
 [4,96],[867,1620],[283,720],[459,1080],[243,1080],
 [8,144],[104,960],[317,480],[60,96],[755,1080],
 [928,1080],[360,480],[693,1080],[136,1080],[1032,1080],
 [379,720],[175,720],[390,720],[425,960],[483,1080],
 [831,1620],[491,720],[55,720],[804,1080],[1307,1620],
 [389,1080],[690,810],[656,1080],[900,960],[296,720],
 [413,720],[868,1620],[507,1080],[333,1080],[467,1620],
 [309,720],[412,1080],[231,1080],[893,960],[182,540],
 [132,160],[1037,1080],[273,540],[519,960],[29,96],
 [1047,1080],[776,810],[50,1080],[746,1080],[21,144],
 [499,720],[86,540],[336,720],[620,1080],[99,160],
 [415,1080],[57,1620],[12,160],[915,1080],[55,1080],
 [1499,1620],[91,96],[233,480],[1029,1080],[819,1080],
 [241,1080],[63,96],[690,1080],[752,1080],[223,1080],
 [188,720],[355,960],[957,1620],[343,1080],[66,960],
 [696,720],[706,720],[535,720],[423,1080],[228,480],
 [1049,1080],[404,720],[942,1080],[622,1080],[1407,1620],
 [1408,1620],[877,1620],[704,720],[836,1080],[612,1620],
 [452,540],[533,720],[63,720],[107,108],[0,540],
 [77,108],[131,144],[260,1080],[555,720],[154,1080],
 [378,1080],[431,720],[35,96],[126,720],[456,720],
 [61,144],[1417,1620],[838,1080],[107,144],[228,720],
 [860,960],[462,720],[568,960],[1024,1080],[370,960],
 [10,160],[53,96],[263,720],[90,96],[304,720],
 [572,1080],[13,720],[922,1620],[659,1080],[423,720],
 [257,720],[1007,1080],[386,1080],[1507,1620],[30,1080],
 [261,1080],[155,480],[612,1080],[171,720],[537,540],
 [82,96],[71,720],[59,960],[1291,1620],[712,720],
 [246,1080],[164,720],[357,540],[184,720],[925,1080],
 [1013,1620],[272,540],[346,720],[30,108],[1282,1620],
 [189,720],[19,96],[324,480],[92,540],[568,1080],
 [956,1080],[66,1620],[752,1620],[473,1620],[330,720],
 [164,1080],[154,160],[119,810],[386,1620],[1007,1620],
 [99,960],[703,720],[288,720],[1472,1620],[149,720],
 [610,960],[275,1080],[552,720],[48,144],[78,480],
 [467,1080],[180,270],[50,720],[23,720],[373,720],
 [779,960],[55,96],[306,720],[555,1080],[552,1080],
 [92,160],[349,960],[613,720],[186,720],[2,540],
 [211,1620],[607,1620],[817,1080],[0,108],[93,540],
 [1065,1080],[1016,1080],[264,960],[1233,1620],[129,720],
 [92,144],[689,720],[210,720],[162,480],[780,810],
 [829,960],[1392,3240],[122,810],[294,1620],[149,1080],
 [538,540],[855,1080],[853,1620],[632,720],[556,1620],
 [651,720],[543,720],[692,720],[90,270],[226,1080],
 [106,108],[69,720],[291,720],[353,720],[66,108],
 [38,480],[110,720],[56,720],[304,1080],[735,1080],
 [650,720],[146,1080],[510,1080],[737,1620],[390,1080],
 [571,1080],[133,2160],[21,96],[183,720],[840,1080],
 [675,960],[1139,1620],[972,1080],[314,2430],[850,1920],
 [343,1620],[32,720],[454,540],[557,1080],[2130,2430],
 [1060,1620],[1325,1620],[558,1440],[94,540],[472,480],
 [399,480],[1545,1620],[589,720],[574,810],[251,720],
 [427,1620],[340,1080],[50,144],[212,960],[86,960],
 [215,960],[764,960],[105,144],[475,480],[529,720],
 [850,1080],[853,1080],[237,810],[1109,2430],[74,96],
 [615,1620],[387,1080],[393,960],[375,720],[87,144],
 [698,1620],[62,160],[227,3240],[27,720],[417,810],
 [149,1620],[169,720],[97,160],[535,540],[662,810],
 [56,144],[331,1080],[335,810],[428,720],[452,720],
 [293,720],[1329,1620],[106,1620],[572,720],[702,810],
 [476,810],[190,720],[176,720],[210,1080],[62,1620],
 [1124,2430],[117,1620],[1148,1620],[657,810],
 [1012,1080],[25,144],[69,96],[29,1080],[132,810],
 [543,960],[196,1080],[75,720],[90,160],[249,480],
 [235,720],[694,1080],[1062,1080],[466,1620],[513,810],
 [1139,1920],[392,720],[392,810],[49,54],[248,480],
 [765,810],[1019,1620],[668,720],[1017,1620],[834,1620],
 [247,480],[19,1620],[74,810],[904,960],[379,1080],
 [204,810],[104,144],[130,720],[700,1080],[55,960],
 [1124,1620],[569,1080],[1925,2430],[522,960],[344,1080],
 [106,144],[73,1620],[33,108],[300,960],[646,1620],
 [299,2430],[68,720],[382,1620],[1141,1620],[47,216],
 [2117,2160],[605,810],[115,1620],[387,720],[1140,1620],
 [472,1080],[252,1080],[252,960],[433,1620],[34,108],
 [54,960],[1595,1620],[307,1080],[465,810],[504,1920],
 [586,1080],[1424,1620],[59,1620],[504,2430],[117,810],
 [37,108],[659,960],[925,1620],[297,1080],[772,1080],
 [490,2160],[93,144],[142,160],[7,480],[664,960],
 [296,810],[522,1080],[4,540],[599,1620],[881,1440],
 [1393,3240],[848,1920],[1142,1620],[655,960],[66,720],
 [507,720],[411,720],[827,1080],[284,720],[479,1080],
 [1551,1620],[87,160],[1021,1620],[235,480],[1138,1620],
 [783,810],[39,216],[107,160],[272,720],[67,1080],
 [781,1080],[52,160],[3013,3240],[546,960],[77,96],
 [1502,1620],[1503,1620],[152,160],[3012,3240],[74,108],
 [184,540],[1153,1620],[600,1080],[96,144],[883,1080],
 [1415,1920],[196,480],[160,480],[402,480],[51,720],
 [85,540],[343,720],[333,810],[672,810],[495,2430],
 [92,720],[447,720],[244,480],[353,1080],[868,1080],
 [2026,2160],[342,1620],[549,720],[566,960],[62,144],
 [566,810],[5,108],[493,1080],[283,480],[127,1080],
 [510,2430],[6,720],[905,960],[564,1620],[1031,1440],
 [157,1620],[611,720],[692,810],[692,1080],[46,144],
 [88,480],[437,960],[88,144],[657,1620],[241,480],
 [83,144],[179,270],[490,1080],[1847,3240],[663,1080],
 [474,810],[1011,1620],[435,720],[376,1080],[147,720],
 [170,720],[290,720],[295,960],[1603,1620],[119,216],
 [235,810],[1842,2160],[206,216],[52,1080],[1020,1620],
 [201,1620],[930,1080],[465,1620],[278,480],[930,1620],
 [1019,1080],[32,144],[54,144],[967,1620],[1546,1620],
 [445,540],[659,720],[18,96],[37,144],[179,1920],
 [744,960],[1309,2160],[111,1620],[25,216],[430,720],
 [1306,1620],[600,1620],[962,1620],[850,2160],[245,1620],
 [882,1620],[647,810],[319,480],[232,480],[1122,2160],
 [507,810],[1063,1620],[1281,1620],[73,108],[387,810],
 [748,1080],[2115,2430],[308,720],[56,1080],[317,2160],
 [1276,1620],[1508,1620],[1115,2430],[70,108],[243,810],
 [230,480],[63,960],[572,810],[385,1080],[774,810],
 [1192,1620],[302,810],[595,1080],[139,720],[176,216],
 [395,1080],[229,2160],[168,216],[901,960],[1930,2160],
 [1128,1440],[254,960],[762,2160],[1027,1080],[508,1080],
 [344,810],[119,960],[60,1080],[195,1620],[1320,2430],
 [514,1080],[1050,1080],[840,960],[17,160],[20,108],
 [239,1080],[613,1620],[535,960],[973,1620],[694,1620],
 [24,1620],[644,720],[766,1620],[44,1620],[565,1080],
 [39,144],[238,480],[327,720],[89,144],[15,144],
 [416,720],[471,480],[432,810],[9,216],[358,540],
 [226,3240],[96,216],[196,1620],[1186,1620],[402,810],
 [16,144],[609,720],[175,216],[490,1620],[407,810],
 [338,1620],[481,1080],[26,810],[376,720],[393,1080],
 [726,1080],[68,1620],[147,810],[507,960],[249,720],
 [103,108],[687,810],[857,1080],[369,720],[162,810],
 [687,720],[686,1080],[224,1080],[87,108],[60,144],
 [1275,1620],[173,216],[1423,1620],[190,216],[72,160],
 [580,720],[201,480],[390,1620],[470,720],[523,1620],
 [484,720],[710,720],[229,1080],[265,540],[1154,1620],
 [61,96],[42,216],[69,160],[601,1620],[608,1620],
 [116,1620],[490,720],[344,720],[481,1620],[17,1080],
 [707,960],[38,144],[598,1620],[187,1080],[441,480],
 [8,480],[550,720],[209,1080],[495,1620],[29,216],
 [77,480],[124,1080],[1004,1620],[478,480],[124,720],
 [181,540],[298,1080],[35,810],[1504,1620],[63,810],
 [746,810],[311,1440],[109,1920],[408,1440],[713,720],
 [391,480],[426,720],[927,1080],[1397,2160],[873,960],
 [627,720],[515,1620],[1561,1620],[617,1080],[1237,1620],
 [1069,1920],[1810,1920],[1560,1620],[178,540],
 [607,1080],[869,1080],[7,160],[206,810],[474,480],
 [1101,1620],[589,2160],[614,810],[284,960],[137,810],
 [5,480],[56,960],[1575,1620],[267,720],[1097,1620],
 [75,108],[332,720],[1598,1620],[452,960],[74,1620],
 [1570,2160],[61,1620],[65,810],[416,960],[9,720],
 [32,108],[212,720],[684,1080],[603,810],[1055,1620],
 [1071,1920],[1740,1920],[81,144],[305,2430],[344,1620],
 [884,1620],[127,144],[955,1080],[59,144],[188,1080],
 [222,1080],[933,1080],[1374,1620],[87,720],[60,720],
 [1,480],[1229,1620],[4,108],[891,1080],[47,144],
 [118,144],[303,1080],[21,1620],[747,960],[1,108],
 [152,810],[361,540],[1096,1620],[46,1080],[102,108],
 [1018,1620],[1058,1620],[84,144],[229,720],[1033,1080],
 [775,1080],[896,960],[780,1920],[631,1080],[16,1620],
 [211,1080],[1462,1620],[1213,2160],[649,720],
 [1129,1620],[40,216],[739,1080],[892,1080],[1023,1080],
 [536,720],[689,1080],[448,1080],[290,1620],[2124,2430],
 [304,960],[480,1620],[159,480],[614,1620],[921,1620],
 [1470,1620],[595,720],[128,144],[107,1080],[589,1080],
 [231,480],[736,1620],[478,1620],[422,810],[1314,2430],
 [186,216],[256,720],[172,1080],[744,810],[1919,2430],
 [70,720],[703,1080],[883,1620],[1305,2430],[462,1080],
 [602,1620],[330,1080],[463,720],[946,2160],[522,1620],
 [350,720],[1100,1620],[42,2160],[782,1080],[313,1620],
 [107,810],[705,960],[422,1620],[413,960],[870,1080],
 [75,1620],[55,144],[1557,1620],[355,540],[44,810],
 [350,1080],[313,1080],[677,810],[479,1620],[519,1620],
 [58,960],[878,1620],[1006,1620],[1934,2430],[197,1620],
 [766,1080],[735,810],[741,1620],[58,1620],[477,1620],
 [749,1080],[1037,2160],[195,960],[1544,1620],[561,1620],
 [377,810],[559,1620],[416,1080],[903,960],[366,720],
 [289,720],[1277,1620],[195,810],[303,720],[152,1080],
 [1513,1620],[1,540],[26,96],[776,1080],[320,480],
 [1558,1620],[1104,1620],[111,144],[1600,1620],[4,54],
 [41,108],[729,1080],[274,540],[689,1620],[484,1080],
 [907,1080],[652,1620],[429,720],[97,144],[785,1620],
 [735,1620],[108,720],[1005,1620],[424,960],[1422,1620],
 [471,1620],[34,96],[518,1620],[952,1080],[4,480],
 [663,720],[1418,1620],[598,1080],[653,720],[1669,2160],
 [1197,1620],[1846,3240],[468,720],[80,480],[57,144],
 [510,810],[691,1080],[1589,1620],[242,1080],[584,1620],
 [6,144],[184,1920],[287,1080],[675,810],[96,160],
 [593,960],[1362,2160],[770,810],[647,720],[57,960],
 [761,2160],[122,720],[322,1080],[137,144],[1412,1620],
 [183,540],[557,1620],[802,1080],[297,720],[431,960],
 [314,1620],[287,1620],[833,1620],[1326,1620],[498,1620],
 [505,810],[825,960],[639,2160],[6,216],[850,960],
 [540,960],[770,960],[943,2160],[17,1620],[98,216],
 [1258,1920],[135,810],[944,1080],[844,1080],[179,720],
 [1010,1620],[16,108],[569,810],[1379,1620],[1305,1620],
 [633,1440],[1326,2160],[1370,1620],[826,1620],[506,810],
 [181,960],[1717,2160],[86,1080],[287,720],[48,1440],
 [748,1620],[62,1080],[656,1620],[947,1620],[286,1620],
 [1111,1620],[1157,2160],[1398,2160],[421,960],
 [114,1620],[610,1620],[836,960],[395,810],[229,810],
 [114,216],[90,960],[1493,2160],[797,1080],[584,1080],
 [1455,1620],[898,960],[672,1620],[802,2160],[959,1080],
 [402,2160],[183,216],[182,810],[339,1620],[250,960],
 [330,1620],[1383,2430],[991,1080],[82,160],[381,1620],
 [1098,1620],[661,1620],[110,144],[1135,1620],[234,2430],
 [1549,1620],[575,1080],[213,1080],[371,720],[424,1620],
 [12,216],[864,1080],[271,720],[120,1080],[24,160],
 [733,1920],[1933,2160],[469,1620],[366,960],[450,1080],
 [250,1620],[202,1080],[856,2160],[569,2430],[442,960],
 [135,1080],[1345,2160],[245,720],[22,96],[1487,1620],
 [159,810],[163,1620],[1121,1620],[567,960],[1285,1620],
 [340,1620],[38,80],[1555,1620],[1576,2160],[931,1080],
 [27,810],[669,960],[48,1620],[767,960],[704,1080],
 [118,480],[2195,2430],[1280,1620],[1735,1920],
 [136,1620],[215,1440],[874,1620],[158,160],[504,1440],
 [437,2160],[579,810],[999,1920],[1187,2160],[789,1620],
 [999,2160],[872,1620],[722,810],[1461,1620],[33,144],
 [40,108],[133,144],[269,1920],[912,960],[697,960],
 [1211,2160],[1414,1620],[98,160],[144,810],[1282,1440],
 [325,1620],[879,1620],[337,960],[654,1620],[66,160],
 [1316,2430],[417,1080],[375,1080],[2395,3240],[37,960],
 [512,2430],[453,1080],[1224,1440],[13,54],[968,1620],
 [243,480],[452,810],[667,720],[208,720],[594,1620],
 [61,960],[185,540],[1692,2160],[340,960],[384,1620],
 [1565,1620],[1307,2430],[872,1080],[924,1620],
 [509,1620],[325,1080],[830,1620],[1149,1620],[664,810],
 [1377,2430],[25,108],[455,1920],[55,160],[615,960],
 [993,1080],[994,1440],[993,1440],[827,2160],[235,3240],
 [363,480],[605,720],[972,2160],[797,2160],[633,1080],
 [767,1080],[72,720],[580,2160],[906,1620],[445,1440],
 [40,810],[1160,2160],[1135,1920],[1017,1080],[24,216],
 [56,108],[821,2160],[985,1080],[1420,1620],[964,1620],
 [665,810],[964,1080],[1288,1620],[732,960],[103,720],
 [657,720],[48,54],[709,960],[442,1080],[275,960],
 [388,1080],[59,96],[750,1620],[1124,1440],[778,960],
 [575,2430],[958,1620],[5,540],[116,480],[244,1080],
 [73,96],[440,2160],[53,54],[446,1440],[227,2430],
 [446,1080],[847,1080],[1405,1620],[713,1620],[137,216],
 [1366,1620],[604,810],[134,216],[874,1080],[42,810],
 [84,96],[2464,3240],[367,960],[571,1620],[2077,2160],
 [745,810],[457,960],[91,160],[570,960],[570,1620],
 [872,960],[841,1080],[1322,2430],[40,160],[871,1620],
 [475,720],[3,108],[20,1620],[435,1620],[240,2430],
 [285,960],[1719,2160],[245,480],[567,1080],[141,160],
 [77,1080],[56,1620],[399,1440],[454,960],[661,1920],
 [312,2430],[205,1620],[68,160],[837,1080],[1059,1620],
 [1427,1620],[846,960],[765,1620],[121,216],[734,1620],
 [251,960],[89,108],[39,108],[492,960],[88,1080],
 [33,1080],[326,1080],[358,480],[104,108],[55,1620],
 [584,2430],[67,216],[414,810],[356,540],[935,1080],
 [19,144],[1379,2430],[1144,1920],[489,1620],[560,1620],
 [1666,2160],[727,1080],[739,1620],[1063,1080],
 [582,2430],[784,1920],[279,2160],[119,160],[558,1620],
 [299,810],[1061,1620],[487,1080],[392,960],[1369,1620],
 [767,810],[1162,2160],[380,810],[1019,1920],[1425,1620],
 [1650,1920],[42,960],[754,1080],[1359,1440],[754,1620],
 [391,720],[246,1620],[425,1620],[86,216],[86,96],
 [320,1440],[626,960],[1286,1620],[1054,1080],[13,160],
 [601,1080],[960,1620],[1522,2160],[1122,2430],
 [153,2160],[64,1620],[502,960],[817,960],[625,1080],
 [1517,2160],[64,810],[922,960],[957,1080],[1515,1620],
 [369,960],[18,1620],[2117,2430],[747,1620],[386,2160],
 [2106,2160],[37,1080],[352,1080],[632,1080],[230,810],
 [1113,2430],[2082,2160],[517,960],[70,96],[844,3240],
 [1191,1620],[367,1080],[242,2430],[806,1440],[52,108],
 [316,480],[366,1620],[914,960],[63,160],[171,1080],
 [540,720],[946,960],[2052,2160],[997,2160],[1394,2430],
 [105,1620],[474,720],[132,1620],[538,960],[62,720],
 [57,96],[869,960],[590,960],[769,810],[536,960],
 [1253,1620],[644,1620],[434,960],[589,1620],[15,1080],
 [1035,1440],[417,720],[1573,2160],[547,1080],[534,540],
 [493,960],[238,1080],[765,960],[432,720],[532,1080],
 [734,1920],[28,1080],[265,2160],[1465,1620],[531,1080],
 [148,1080],[1854,2430],[1564,1620],[139,160],[690,1920],
 [281,960],[111,960],[1456,1620],[899,960],[1235,1620],
 [394,1080],[583,2160],[786,1620],[429,960],[1232,1620],
 [1062,1620],[662,1080],[203,216],[49,216],[527,960],
 [137,1620],[27,1080],[262,960],[784,960],[155,1620],
 [32,810],[686,960],[2202,2430],[68,108],[43,80],
 [1550,1620],[60,108],[136,2160],[713,1080],[351,960],
 [712,1080],[822,1080],[234,480],[246,2160],[175,1920],
 [504,960],[175,960],[443,960],[31,1620],[627,810],
 [389,960],[2132,2430],[657,1080],[626,1080],[210,1620],
 [65,96],[145,160],[304,3240],[1924,3240],[47,960],
 [1010,1920],[348,720],[599,960],[77,2160],[405,810],
 [1410,1620],[332,1620],[36,96],[813,1080],[303,810],
 [1278,1440],[776,960],[422,960],[757,1080],[548,1080],
 [422,720],[810,960],[703,1620],[651,1620],[1044,2430],
 [808,1080],[115,144],[69,1620],[316,1440],[25,1080],
 [873,1620],[123,960],[142,960],[947,960],[1186,1920],
 [151,720],[1184,1620],[344,960],[16,160],[83,216],
 [1185,1620],[76,80],[183,960],[647,1080],[122,1080],
 [869,1620],[671,1440],[34,810],[645,1620],[2028,2160],
 [1578,1620],[768,1440],[992,1080],[1035,1920],
 [908,1080],[299,720],[121,1080],[1315,3240],[866,1080],
 [361,480],[1386,2160],[11,108],[1385,2430],[432,960],
 [511,720],[180,1920],[1466,2160],[81,432],[586,2160],
 [666,2160],[215,1080],[415,810],[790,1620],[88,720],
 [833,960],[111,1920],[902,960],[610,720],[203,3240],
 [96,108],[250,720],[119,1620],[508,960],[148,160],
 [761,960],[560,1440],[635,1440],[1064,1080],[129,216],
 [606,960],[506,2430],[337,1080],[1373,1620],[428,1620],
 [506,1080],[110,810],[2204,2430],[54,1620],[166,216],
 [604,1080],[32,216],[466,960],[1020,1080],[1136,1620],
 [505,960],[351,1080],[2187,2430],[9,480],[659,1620],
 [223,2160],[629,960],[1290,1620],[629,1080],[483,1620],
 [1289,1620],[1932,2430],[1287,1620],[126,960],[101,160],
 [117,216],[93,160],[577,960],[708,960],[1123,1440],
 [1212,1620],[461,960],[333,960],[210,960],[655,1620],
 [958,1080],[387,1620],[70,1620],[107,2160],[848,960],
 [209,1620],[244,720],[1119,1440],[747,1080],[775,3240],
 [1333,1620],[1332,2160],[288,1620],[1331,2160],
 [573,810],[331,1620],[208,1620],[403,1440],[403,1620],
 [915,1620],[948,2160],[2079,2160],[271,1080],[16,1080],
 [1500,1620],[1042,1080],[498,960],[91,108],[1107,2430],
 [497,2430],[1185,1920],[804,1440],[133,216],[997,1080],
 [742,1080],[45,960],[496,2160],[240,1620],[567,2430],
 [1392,2430],[253,1620],[170,1080],[2935,3240],
 [495,1080],[20,160],[454,1080],[1391,1440],[1477,2160],
 [2023,2160],[132,144],[170,216],[512,1080],[642,2160],
 [50,1620],[1571,1620],[865,1620],[282,2160],[432,1080],
 [251,2160],[1570,1620],[15,108],[2006,2160],[833,2160],
 [451,960],[297,2430],[1238,1620],[469,720],[192,1620],
 [639,1440],[1563,1620],[900,1920],[1306,2160],
 [637,2160],[236,2430],[1559,1620],[33,96],[730,960],
 [467,2160],[249,1620],[376,1620],[974,1620],[55,108],
 [975,1620],[412,720],[14,160],[354,540],[375,1620],
 [27,960],[428,960],[526,960],[604,1620],[94,1080],
 [191,216],[30,1620],[1046,2430],[525,960],[685,1080],
 [1547,2160],[685,810],[1293,1620],[484,1620],[5,54],
 [146,160],[753,1620],[965,1620],[93,1080],[1355,1440],
 [963,1620],[145,810],[53,2160],[334,1620],[9,96],
 [442,2160],[658,720],[126,144],[78,160],[2126,2430],
 [199,1620],[1520,2160],[708,720],[1923,2430],[163,480],
 [1050,2430],[135,160],[749,960],[920,1920],[814,2160],
 [134,960],[134,810],[273,1080],[36,80],[3036,3240],
 [369,432],[194,960],[612,2160],[1046,1080],[676,1620],
 [1505,1620],[161,1440],[745,1620],[302,720],[775,960],
 [21,160],[124,144],[773,2160],[1744,1920],[345,960],
 [366,1080],[30,96],[475,1620],[3004,3240],[1040,1440],
 [674,810],[699,810],[592,960],[419,960],[420,720],
 [616,720],[82,2160],[3,54],[537,960],[568,720],
 [800,1440],[800,2160],[418,960],[1482,1620],[90,108],
 [536,540],[39,960],[105,108],[1877,2160],[131,2160],
 [205,1080],[14,96],[404,1440],[793,1620],[398,480],
 [986,1080],[1243,1620],[906,1080],[1467,1620],[81,480],
 [61,720],[1855,3240],[204,960],[326,1620],[157,1440],
 [937,960],[491,1620],[1464,1920],[357,810],[732,1620],
 [609,1620],[192,960],[762,1080],[80,1440],[1233,2160],
 [1025,1620],[1234,1620],[528,960],[1663,2160],
 [728,1080],[138,160],[87,810],[447,1080],[447,960],
 [38,96],[1227,1920],[1140,1920],[353,960],[1,160],
 [128,960],[1021,1080],[877,1440],[866,1620],[1196,1620],
 [307,720],[79,480],[782,810],[293,1620],[854,1620],
 [1359,2160],[853,2160],[504,1080],[926,2160],[18,108],
 [927,960],[164,1620],[200,1620],[1130,1620],[350,432],
 [779,1920],[189,216],[1128,1620],[1416,3240],[31,720],
 [1413,1620],[407,432],[1808,1920],[521,1620],
 [1052,2430],[1009,1620],[125,810],[78,96],[0,54],
 [423,1620],[174,216],[879,1440],[678,960],[303,2430],
 [41,144],[1201,1620],[1602,1620],[11,160],[573,2430],
 [512,960],[404,810],[746,1620],[1757,2160],[1331,1620],
 [917,960],[1002,1080],[1194,1620],[916,1080],[143,160],
 [2,108],[619,960],[470,480],[420,1620],[516,960],
 [184,960],[1739,1920],[592,1080],[541,960],[674,960],
 [475,810],[913,960],[214,1620],[329,1620],[3,80],
 [206,1620],[455,960],[1722,2160],[40,54],[943,1620],
 [240,432],[11,720],[400,480],[434,1620],[132,216],
 [121,1620],[39,810],[328,720],[1841,2160],[194,1620],
 [1599,1620],[11,144],[493,2160],[1569,1620],[1384,3240],
 [397,2160],[39,160],[2,160],[692,1920],[282,1080],
 [1217,1620],[885,1620],[13,960],[226,2160],[531,960],
 [1030,1620],[321,480],[1464,1620],[935,1440],
 [1150,1620],[80,2160],[508,1620],[1498,1620],[394,810],
 [148,216],[236,810],[60,1620],[977,1080],[102,1080],
 [60,960],[1024,1620],[1229,1920],[1845,2430],[688,720],
 [932,960],[32,960],[173,1080],[332,1080],[549,1080],
 [198,960],[158,1620],[573,1080],[143,960],[58,160],
 [887,1620],[46,960],[336,960],[1294,1620],[18,160],
 [189,960],[916,1620],[792,1080],[109,960],[154,1620],
 [753,1080],[86,144],[330,960],[175,540],[682,2160],
 [101,216],[315,1440],[334,810],[731,960],[67,108],
 [78,216],[163,1080],[159,1440],[240,810],[333,1620],
 [144,1080],[290,960],[26,216],[318,2160],[1279,1620],
 [1338,2160],[273,1440],[1035,2430],[82,216],[1035,1620],
 [252,2160],[1907,2160],[205,810],[433,960],[62,96],
 [92,108],[835,1080],[775,810],[1002,2160],[24,432],
 [385,1620],[692,1620],[1357,2160],[631,720],[22,960],
 [104,160],[1110,1620],[684,810],[1588,1620],[207,1080],
 [207,1620],[50,54],[475,1080],[530,1080],[120,160],
 [829,1620],[637,1080],[225,2430],[10,144],[382,960],
 [113,960],[364,540],[62,432],[942,1620],[51,108],
 [418,1620],[614,960],[191,432],[17,144],[1048,1620],
 [597,720],[41,216],[478,1080],[317,1080],[775,1920],
 [11,96],[102,144],[158,480],[1860,2430],[94,216],
 [1244,1620],[927,1620],[470,1620],[608,960],[2189,2430],
 [1419,1620],[81,216],[806,1080],[1216,2160],[1216,1620],
 [81,96],[81,160],[562,1440],[831,960],[58,1080],
 [61,160],[257,1080],[157,160],[1847,2430],[236,480],
 [1144,1620],[448,720],[1051,1080],[893,1080],[695,1620],
 [880,1620],[1514,1620],[580,810],[1166,1440],[755,960],
 [623,960],[84,1440],[622,960],[82,108],[227,960],
 [877,1080],[1195,1620],[595,1620],[1045,1080],[209,216],
 [45,216],[77,160],[28,144],[1036,1440],[49,1620],
 [1936,2160],[407,1620],[1856,2430],[229,960],[476,480],
 [753,960],[884,1920],[530,960],[186,1080],[1037,2430],
 [235,1080],[2193,2430],[1773,2160],[1917,2430],
 [1913,2160],[232,1080],[816,960],[206,960],[1880,2160],
 [740,1620],[909,1080],[1894,2160],[41,80],[266,1080],
 [1280,1440],[12,960],[693,2160],[277,2160],[1199,1620],
 [677,1620],[34,1080],[312,1080],[360,960],[1762,2160],
 [909,1920],[1483,1620],[777,810],[277,1080],[1015,1620],
 [1823,3240],[684,960],[109,720],[650,810],[124,810],
 [152,1620],[114,720],[228,960],[82,1080],[1579,2160],
 [41,1620],[1049,1620],[1052,1080],[87,1080],[828,2160],
 [1411,1620],[47,108],[423,960],[1882,2160],[17,108],
 [422,1080],[1332,1620],[104,1620],[52,720],[17,96],
 [3,480],[273,960],[1908,2160],[3,540],[429,810],
 [59,1080],[87,960],[1862,2430],[1303,2160],[402,1620],
 [704,1620],[920,960],[304,810],[1409,1620],[121,480],
 [115,1080],[467,960],[25,96],[1601,1620],[149,960],
 [922,2160],[2122,2160],[1547,6480],[11598,15360],
 [1741,4320],[3122,6480],[4787,6480],[1741,6480],
 [2459,3240],[1945,2160],[1364,1920],[1486,1620],
 [999,1440],[12180,12960],[3215,3240],[2074,2160],
 [1343,1440],[2417,4320],[1616,3840],[2964,3240],
 [2422,4320],[1175,1440],[870,1620],[1674,1920],
 [3337,4320],[2128,2160],[969,3240],[1381,2160],
 [1295,1620],[3350,3840],[1000,1620],[1450,1920],
 [1412,2160],[3142,4320],[1272,2160],[996,1920],
 [4790,6480],[1592,2430],[1151,1620],[3678,4320],
 [4019,6480],[1325,2160],[3181,4320],[4821,7680],
 [1567,1620],[2418,4320],[1321,2880],[923,1920],
 [1582,2160],[5867,6480],[599,1440],[2597,2880],
 [9642,15360],[599,2160],[1621,3840],[2655,4860],
 [6025,6480],[1105,1620],[1927,2160],[1371,1440],
 [1654,2430],[1652,1920],[5870,6480],[632,960],
 [1136,4320],[1294,2160],[9639,15360],[762,3240],
 [1926,3240],[3012,3840],[1315,3840],[1826,1920],
 [650,960],[947,1440],[11441,30720],[5298,6480],
 [13397,15360],[862,1620],[2460,6480],[2281,3240],
 [1604,2160],[1372,1620],[3901,6480],[1746,2160],
 [1624,3840],[1490,2160],[3178,4320],[2978,3240],
 [2600,2880],[1725,2160],[1722,2430],[2418,2880],
 [2589,3240],[2284,3240],[3183,4320],[2371,3240],
 [818,3240],[719,810],[3413,4860],[2022,2160],
 [1704,3240],[1297,2160],[1574,1620],[929,2160],
 [6012,6480],[969,2160],[3536,3840],[1302,2160],
 [569,1620],[2209,3240],[1692,6480],[1401,1440],
 [1400,1440],[1897,1920],[1501,1620],[675,1440],
 [1744,6480],[1498,6480],[1682,2160],[1677,3240],
 [584,4860],[955,3240],[1220,3240],[1585,2430],
 [2049,2160],[787,1620],[383,1440],[2780,6480],
 [455,6480],[7075,7680],[1377,1620],[1668,2160],
 [2764,2880],[994,1080],[1679,3240],[2042,2160],
 [2747,3840],[1119,2160],[1442,1620],[1661,2160],
 [3415,4860],[2397,2430],[1652,2430],[1702,4320],
 [3780,3840],[1059,1920],[2194,2880],[671,960],
 [1962,3240],[1567,2160],[2658,3240],[3707,6480],
 [2374,3240],[26801,30720],[19278,30720],[3695,6480],
 [13400,15360],[1309,2430],[1354,2160],[1288,1440],
 [1527,1620],[823,1440],[1850,3240],[762,2880],
 [1286,2160],[1928,2160],[1632,1920],[1623,1920],
 [961,1080],[2125,2430],[4818,7680],[881,1620],
 [958,3240],[2122,2880],[3186,4320],[2576,4320],
 [2118,2160],[6064,6480],[3789,3840],[1605,1620],
 [1657,2430],[2204,4860],[1165,1440],[2198,3240],
 [1654,2160],[1548,1620],[3357,6480],[4687,4860],
 [5818,6480],[1944,2160],[3704,6480],[1827,1920],
 [1018,1080],[1501,2160],[403,960],[2651,3240],
 [1132,1620],[4057,4320],[947,2160],[437,1080],
 [999,1620],[1397,1440],[1534,3240],[924,2160],
 [1731,3240],[2999,3240],[3906,4320],[2997,3240],
 [1394,4860],[742,960],[840,1620],[1582,2430],
 [1581,1620],[1580,1620],[1719,2880],[2761,2880],
 [1555,1920],[3066,4860],[2754,3240],[2024,2160],
 [3797,3840],[1316,1920],[661,2160],[1705,3240],
 [677,2160],[2902,3840],[661,1080],[1826,2160],
 [2015,3240],[1694,3840],[755,1440],[3728,7680],
 [1113,1440],[1093,1620],[937,3840],[2463,4320],
 [1590,2160],[3699,4860],[2354,3240],[1689,6480],
 [1381,3240],[982,7680],[1308,2160],[3904,6480],
 [664,1920],[1674,2160],[1560,2160],[1235,1440],
 [1669,4860],[978,3240],[7080,7680],[7224,7680],
 [1971,3840],[1376,1620],[6701,7680],[1173,1920],
 [848,2160],[295,1440],[4684,4860],[6073,6480],
 [1962,15360],[6061,6480],[837,1620],[1297,1620],
 [2020,3240],[971,2160],[1704,1920],[713,1920],
 [1365,1620],[714,720],[1694,1920],[929,1620],
 [2375,3840],[234,810],[2147,4860],[1158,2160],
 [1465,2160],[1291,3240],[1538,1620],[820,1440],
 [1355,3240],[372,810],[1535,1620],[981,7680],
 [2617,4320],[1415,1620],[2614,3240],[275,1440],
 [1526,2880],[1053,1920],[442,810],[1284,1620],
 [4810,4860],[1518,1620],[816,1440],[1282,2160],
 [447,1620],[3118,3240],[1301,1620],[3100,3240],
 [1279,1440],[1336,1440],[3483,3840],[1706,1920],
 [2202,2880],[4439,7680],[1427,2160],[1652,7680],
 [1313,1620],[917,1440],[855,1440],[2080,4860],
 [3348,3840],[1274,1620],[2466,3240],[1749,2160],
 [2184,3240],[1272,4860],[476,1620],[1895,3240],
 [3011,3240],[287,960],[4013,4320],[233,960],[1587,1620],
 [3947,4320],[3918,30720],[1495,6480],[1729,2160],
 [1106,1620],[911,1920],[1259,1920],[1258,1440],
 [802,1440],[2961,3240],[2958,8640],[1319,1440],
 [1717,2430],[2578,4320],[1254,1620],[2400,2430],
 [1165,4320],[1099,3840],[1954,2160],[1405,3240],
 [907,2430],[3785,3840],[1945,3240],[1548,2160],
 [1700,3240],[3761,4860],[1570,4860],[3740,3840],
 [2014,2160],[1693,2160],[1693,1920],[2079,4860],
 [2369,3240],[2857,7680],[1565,2160],[2002,2160],
 [1381,3840],[3658,6480],[2821,6480],[3655,6480],
 [3646,6480],[2801,4320],[980,7680],[1068,1080],
 [637,1440],[529,960],[1558,2880],[934,1620],[1845,4860],
 [1845,3240],[2772,6480],[1555,2880],[3540,3840],
 [1965,3240],[1965,2160],[1964,2160],[1445,1620],
 [784,1620],[941,1440],[1099,1440],[1061,1440],[826,960],
 [940,2160],[283,960],[2682,2880],[888,960],[427,960],
 [2659,4320],[1827,2160],[781,2160],[2656,3240],
 [1311,1620],[1219,2160],[1421,1440],[5492,7680],
 [5517,6480],[3293,4320],[852,960],[627,1080],
 [3235,7680],[3190,4860],[925,1440],[4932,6480],
 [349,1080],[1212,2160],[778,3240],[3154,4320],
 [881,1920],[680,2160],[1211,1440],[1793,4860],
 [258,1440],[1340,2160],[2578,6480],[1205,2160],
 [1780,1920],[1408,3240],[4509,4860],[2744,3840],
 [1430,3840],[1768,2160],[1406,1620],[6015,6480],
 [2712,4860],[917,1920],[3025,3240],[3019,3840],
 [1596,1620],[1594,2430],[4263,4860],[949,960],
 [3014,4860],[874,2160],[1400,2160],[255,960],[873,2160],
 [1398,1440],[1743,4320],[1397,3240],[674,1620],
 [3007,3240],[1587,2430],[2434,4320],[2051,2160],
 [2049,3240],[1263,1920],[1730,3240],[870,3240],
 [1394,3240],[1177,1920],[995,1440],[769,1620],
 [1717,2880],[299,3840],[299,3240],[454,1440],[908,1920],
 [3820,4320],[1389,3240],[768,960],[1475,2160],
 [1389,1920],[1388,3240],[1474,1620],[1387,3240],
 [3761,15360],[2898,3840],[987,1620],[1859,3240],
 [986,1920],[2010,2160],[1568,2160],[1384,1440],
 [937,2160],[1383,3240],[14058,14580],[1383,2160],
 [1309,1620],[2833,6480],[862,2160],[862,1920],
 [1851,3240],[10241,14580],[1381,1440],[1380,3240],
 [1848,3240],[1672,2160],[1671,2160],[663,2160],
 [7259,12960],[859,2160],[663,960],[1843,3240],
 [662,1440],[1844,1920],[1023,4320],[6697,7680],
 [1662,2160],[1372,1920],[857,2160],[1371,1920],
 [6027,7680],[1657,2160],[1837,2160],[661,1440],
 [1368,1620],[1367,1620],[660,1920],[445,2160],
 [1650,2430],[968,3240],[1422,3240],[5717,15360],
 [1133,4320],[1646,2160],[1358,3240],[1289,2160],
 [1645,2160],[926,960],[578,1440],[1640,2880],
 [4984,6480],[5282,6480],[1929,2430],[1353,1440],
 [1352,2160],[4822,7680],[1349,2160],[850,1620],
 [1621,1920],[750,1080],[849,1620],[655,1920],
 [1121,2160],[4735,6480],[1341,1440],[1606,1620],
 [4686,4860],[1339,1440],[1118,1620],[847,2160],
 [4444,7680],[574,1080],[877,2160],[2505,3240],
 [1901,4320],[1597,1620],[621,960],[1506,1920],
 [3017,3240],[3015,3840],[1899,1920],[1753,3240],
 [2080,2160],[1594,1620],[4061,4320],[1593,1620],
 [1327,1620],[1111,1440],[4021,4320],[4016,4320],
 [2458,3840],[1396,3240],[649,810],[1396,1440],
 [1264,1920],[673,1620],[1322,3240],[141,1440],
 [496,3240],[383,960],[944,1620],[435,960],[2411,3840],
 [2031,2160],[1392,1440],[3824,4860],[2402,3240],
 [2402,2430],[838,1440],[1316,3240],[3800,3840],
 [1575,2160],[2021,2160],[989,1080],[1315,2430],
 [1315,1620],[1702,3840],[1313,3240],[1385,1440],
 [835,1620],[1313,1440],[1384,1620],[3710,6480],
 [985,1440],[640,2160],[168,1080],[3699,6480],
 [1382,1620],[1382,1440],[832,1620],[1563,3840],
 [1679,2160],[1562,3240],[1992,2160],[1983,2160],
 [1673,1920],[3635,6480],[1559,1920],[934,1920],
 [3613,3840],[934,1080],[3590,4860],[583,1440],
 [3541,3840],[6699,7680],[6698,7680],[932,1920],
 [428,3240],[827,1620],[487,2160],[3521,4320],
 [1300,1440],[1550,6480],[6024,6480],[825,1620],
 [1549,1920],[1948,3240],[427,1080],[1295,2160],
 [824,1440],[3349,3840],[1294,3240],[684,1620],
 [3325,4320],[3301,3840],[3301,4320],[2147,3840],
 [1935,2160],[1356,1440],[1642,2160],[819,2160],
 [276,432],[820,960],[2619,3240],[275,3240],[554,1620],
 [554,1440],[1286,1440],[1285,2160],[625,3240],
 [3128,3240],[1283,1440],[1923,3240],[624,1620],
 [1517,2430],[922,1440],[3115,3240],[1917,3240],
 [815,1440],[2573,4320],[2566,3240],[747,2160],
 [3045,3240],[2109,2160],[1334,1620],[1404,1620],
 [3026,4860],[1597,2160],[950,960],[652,810],[4275,4860],
 [438,1620],[1330,1920],[808,1440],[915,2160],[619,1620],
 [619,1440],[807,1080],[1499,3240],[914,1620],
 [3009,3240],[1268,1620],[1498,1920],[384,810],
 [3951,7680],[997,1440],[945,1620],[419,1080],
 [1260,1920],[419,810],[1884,3240],[2975,3240],
 [1486,3240],[910,1080],[2409,3840],[1579,1620],
 [1391,3240],[3825,4320],[1317,1620],[2922,3240],
 [1253,1440],[535,1440],[1869,1920],[2914,3240],
 [494,960],[2909,3240],[2901,3840],[3764,3840],
 [1471,2160],[835,2430],[2894,3240],[2892,4860],
 [938,3840],[359,960],[1311,2160],[1466,1920],[904,1620],
 [904,1440],[1310,1440],[1998,3840],[1853,3240],
 [1853,2160],[832,1080],[901,1440],[1028,1440],
 [2784,6480],[3641,4320],[264,2160],[788,960],
 [1234,2160],[1452,2160],[1451,1920],[2779,4860],
 [893,1440],[1230,1620],[1302,3240],[828,960],
 [1229,2160],[1446,1620],[2757,3240],[1444,4860],
 [411,1920],[1431,1620],[1430,1620],[3453,4860],
 [1429,3840],[1428,3840],[888,1080],[1224,2160],
 [1831,2160],[2677,2880],[887,960],[1018,1440],
 [524,2160],[1220,1440],[684,1440],[780,2430],
 [1218,1440],[1417,1920],[1539,3240],[372,4320],
 [1416,2160],[1931,2160],[601,1440],[135,2160],
 [1811,1920],[407,960],[1415,1440],[1414,2160],[349,720],
 [1804,1920],[1413,1920],[406,6480],[406,1620],[348,960],
 [2581,4320],[1206,1920],[777,1620],[1409,2160],
 [1204,3240],[654,1440],[4512,4860],[1202,1440],
 [1771,1920],[677,2880],[2524,3840],[4400,4860],
 [951,2160],[1046,1620],[1275,2160],[810,1080],
 [620,3240],[3016,3240],[1274,2160],[2466,4320],
 [1191,3240],[517,1440],[1190,3240],[2463,3240],
 [1398,1620],[873,1440],[1187,1920],[772,2430],
 [592,2160],[516,810],[1396,2160],[1323,1920],
 [1890,2160],[123,216],[1395,1440],[2424,2880],
 [1181,1440],[401,960],[514,2160],[590,3240],[1721,2160],
 [2410,3840],[1578,2160],[1482,2160],[1255,1440],
 [299,1620],[1390,1440],[589,1920],[513,960],[2399,2430],
 [2398,3240],[767,1440],[2396,3240],[988,1080],
 [865,3240],[2393,3240],[987,1080],[865,1080],
 [2382,3240],[1160,2880],[341,432],[1159,4860],
 [764,1440],[863,1620],[2357,3240],[763,3240],
 [2332,4320],[2332,2430],[2327,2430],[395,1440],
 [2299,3240],[339,1440],[214,3240],[9198,14580],
 [7601,7680],[7568,7680],[2261,3240],[2245,2880],
 [2238,4320],[859,1440],[2223,3840],[1664,2160],
 [1447,4860],[2218,3840],[2216,4860],[2215,3840],
 [2210,3240],[1141,1440],[2208,3240],[757,2880],
 [856,3240],[757,1620],[6020,6480],[2201,3240],
 [2199,2880],[756,1620],[855,1920],[580,1620],[580,1440],
 [5815,6480],[1647,2430],[659,1920],[754,2880],
 [1133,2160],[5700,12960],[5681,8640],[2146,3840],
 [390,810],[5381,14580],[246,810],[2135,3240],
 [4981,6480],[2133,2160],[1127,1440],[961,1620],
 [751,1080],[751,960],[4820,7680],[1344,2160],
 [1619,3840],[576,960],[1342,2160],[749,3240],
 [2120,2880],[575,1440],[2120,2160],[2119,2430],
 [1408,2160],[2117,2880],[954,2160],[500,1440],
 [1335,1440],[596,1920],[3028,3240],[847,960],[404,960],
 [652,1080],[4332,4860],[651,3240],[1402,1620],
 [2081,4320],[745,2160],[4147,4320],[1112,1620],
 [844,1920],[1111,1920],[2074,2880],[744,1440],
 [384,1440],[1324,1920],[842,1620],[2058,6480],
 [2438,3240],[515,1440],[1323,1620],[1106,1920],
 [329,2160],[3903,4320],[329,1080],[3901,4320],
 [3898,4320],[3862,4320],[3849,6480],[1174,1440],
 [769,960],[454,6480],[1318,1620],[2027,2160],
 [1100,1440],[737,3240],[837,2430],[566,1440],
 [1574,2160],[328,432],[2020,2160],[2019,3840],
 [2017,2160],[1096,1440],[1095,3840],[2015,2160],
 [1312,2160],[2011,2160],[327,432],[379,1440],
 [3700,4860],[2005,2160],[2004,2160],[563,1440],
 [1071,1080],[563,810],[1995,3840],[1308,1620],
 [562,1620],[430,960],[1987,4320],[731,1080],[1974,3840],
 [3614,3840],[1973,2160],[1972,2160],[1065,1620],
 [1557,2160],[3572,3840],[2219,3840],[1967,2160],
 [827,3840],[726,960],[1063,1440],[323,1620],[323,1440],
 [1959,15360],[3465,4860],[716,720],[558,960],[558,810],
 [1950,2160],[714,1620],[322,1620],[485,3240],
 [1059,1440],[1942,2160],[1938,2160],[1058,1440],
 [3303,3840],[1937,2160],[3289,4860],[3298,4320],
 [3296,4320],[1289,3240],[1535,3240],[3240,7680],
 [1055,1440],[1930,2430],[819,1440],[1054,1620],
 [709,720],[1053,2160],[708,1080],[818,960],[817,2160],
 [1518,4320],[923,960],[552,2160],[552,1620],[3119,3240],
 [815,3240],[815,2160],[706,810],[333,432],[550,1080],
 [1909,2160],[1048,1440],[1278,1620],[1117,1440],
 [2502,3240],[3030,3240],[2101,2160],[704,810],
 [1901,2880],[1275,1440],[1330,2160],[1899,2160],
 [1044,1440],[1274,1440],[3014,3240],[807,1920],
 [197,432],[1272,1620],[1269,4860],[618,1440],
 [1895,1920],[3008,3240],[1267,2160],[2053,2160],
 [1107,1920],[912,2160],[804,960],[803,1440],[539,720],
 [803,960],[1038,2160],[538,1440],[1257,1620],
 [1485,1620],[3852,6480],[839,1620],[3836,4860],
 [1878,2160],[799,2160],[1481,4320],[2923,3240],
 [908,960],[694,2160],[2911,3240],[1865,3840],
 [1251,1440],[1248,1620],[1860,3840],[1247,1920],
 [2897,3240],[1031,3240],[2861,7680],[1858,4320],
 [905,1440],[2859,7680],[1856,3240],[1241,1440],
 [1464,3840],[1853,4320],[1029,3240],[1238,1440],
 [1462,1920],[789,960],[1028,1620],[1235,2160],
 [1234,2880],[1849,3240],[309,2430],[225,4860],
 [787,1080],[2780,4860],[689,810],[1025,1440],[786,810],
 [1556,1920],[527,4860],[1023,4860],[2759,3240],
 [1843,2160],[1228,2160],[225,432],[784,1080],[890,1620],
 [890,1440],[2718,4860],[2718,2880],[1224,3240],
 [1833,4860],[2679,2880],[685,1620],[1830,2160],
 [603,1620],[307,320],[684,2160],[1219,3240],[464,1620],
 [1825,2160],[780,1620],[884,2160],[602,960],[1820,3840],
 [884,1440],[1215,2160],[2627,6480],[1214,1620],
 [1214,1440],[222,2160],[1809,1920],[1808,3840],
 [2605,2880],[1212,1440],[461,2880],[778,1080],[680,960],
 [1208,2160],[2588,3240],[1787,1920],[777,1440],
 [1205,1920],[597,3240],[460,960],[1773,1920],
 [1201,3240],[1406,4860],[459,6480],[4421,6480],
 [1198,1620],[811,1920],[1766,1920],[1404,1440],
 [1760,2160],[1274,3240],[1758,2160],[458,960],
 [1001,2160],[1001,1440],[1746,4320],[457,4320],
 [457,1920],[2461,3240],[301,1620],[301,1080],
 [2458,4320],[1740,3240],[2456,3840],[998,1440],
 [871,1440],[673,3240],[2424,3240],[455,7680],[300,1080],
 [672,1920],[1722,2880],[1175,1920],[514,1440],
 [994,2160],[97,2430],[2936,3240],[97,1920],[1170,2160],
 [1170,1440],[1714,4320],[1714,2880],[1714,2160],
 [989,2160],[989,1440],[669,2160],[988,1920],[2395,2430],
 [987,1920],[668,1440],[2387,2430],[668,960],[1693,3840],
 [985,2160],[985,1920],[180,720],[1158,1440],[984,2880],
 [1691,2160],[665,1440],[1689,2160],[450,1440],
 [982,4320],[664,6480],[297,432],[664,1440],[449,1080],
 [449,960],[2270,3240],[978,7680],[179,216],[978,2880],
 [978,1620],[448,960],[1375,1620],[295,3840],[1663,3240],
 [95,216],[1662,2430],[662,960],[973,2160],[1660,4320],
 [1660,2160],[95,96],[177,320],[1655,2160],[294,1440],
 [177,216],[661,810],[445,4320],[176,960],[118,216],
 [445,1080],[1649,2430],[5799,7680],[293,810],[967,1080],
 [335,1440],[1131,1620],[175,4860],[1642,2880],
 [658,2160],[2137,3840],[1637,2880],[1353,2880],
 [1634,2160],[1632,2160],[962,1080],[291,1440],
 [656,1920],[291,960],[174,1440],[1344,1440],[174,540],
 [1122,1440],[1615,3840],[1607,2160],[2120,2430],
 [957,1440],[1605,2160],[440,1440],[173,1440],
 [1337,2160],[654,810],[1117,2160],[459,4860],
 [1116,1620],[2105,3240],[2103,2160],[1115,1440],
 [2098,2160],[91,1080],[1113,1920],[288,960],[651,1440],
 [1112,1920],[948,1440],[1593,2160],[948,960],[650,3240],
 [1590,2430],[91,144],[1324,2880],[842,2430],[649,2160],
 [946,1620],[171,960],[1106,2160],[436,810],[1585,2160],
 [1584,2160],[1583,1620],[944,2160],[285,1620],[435,810],
 [1320,1620],[2031,3840],[97,2160],[942,2160],
 [1101,1440],[1577,2430],[1577,2160],[1576,3240],
 [434,810],[494,1440],[1098,4860],[940,3240],[643,810],
 [169,810],[1314,2160],[939,3840],[939,3240],[939,1440],
 [1095,1440],[641,1620],[938,1440],[2009,2160],[282,960],
 [88,1440],[937,1080],[1072,1920],[1564,1920],[732,2160],
 [936,960],[935,2160],[935,1920],[1069,1080],[167,2160],
 [1560,3240],[281,432],[731,810],[637,810],[429,3240],
 [636,1440],[1970,4860],[1970,3840],[1967,4860],
 [279,2880],[488,1620],[635,960],[279,960],[634,2880],
 [634,2160],[931,2160],[1957,2160],[428,810],[1550,2160],
 [931,960],[930,2160],[632,1620],[165,1440],[278,432],
 [427,810],[631,1440],[136,1440],[1546,2160],[928,960],
 [630,1080],[555,2160],[1056,1620],[1056,1440],
 [164,2160],[628,960],[425,1440],[1537,2160],[164,810],
 [627,960],[85,2160],[85,1440],[85,1080],[1525,2160],
 [1522,2430],[424,1080],[1924,2430],[1052,2160],
 [1052,1920],[274,2880],[624,1440],[423,1920],
 [1515,1920],[921,2160],[814,1080],[3067,4860],
 [369,1080],[3064,4860],[705,810],[1601,2880],
 [1508,1920],[621,1620],[918,1440],[1507,1920],
 [272,2160],[272,1080],[421,4320],[620,1620],[620,1440],
 [1898,3240],[1898,1920],[1897,4320],[421,720],
 [1042,2160],[915,960],[914,2160],[270,1080],[1498,2160],
 [1894,1920],[3006,3240],[3001,3240],[1496,2160],
 [1039,1920],[160,320],[616,1440],[1885,2160],
 [1490,1920],[911,1080],[911,960],[1256,2160],[910,960],
 [1102,1620],[2938,3240],[1482,4320],[418,810],
 [2933,3240],[1871,1920],[227,3840],[613,2160],[267,960],
 [1475,1620],[907,1620],[1861,4320],[907,960],[416,4320],
 [906,1440],[1245,1620],[1244,2160],[1467,2160],
 [227,320],[611,2160],[611,1620],[157,2160],[2844,6480],
 [903,2160],[265,1080],[1029,2160],[1237,2160],
 [1852,3240],[609,6480],[690,1620],[2785,6480],
 [264,3240],[157,192],[413,4320],[1454,1620],[895,960],
 [894,1440],[1451,1620],[156,960],[785,1440],[688,1080],
 [892,2160],[688,810],[892,960],[891,1620],[891,1440],
 [262,4320],[891,960],[155,2160],[604,7680],[307,1620],
 [889,1080],[410,2160],[262,320],[1425,3240],[604,720],
 [2661,3240],[409,1440],[886,1440],[464,6480],
 [1421,1620],[885,2160],[602,2160],[2649,3240],[780,960],
 [78,7680],[2640,3240],[1815,1920],[2630,6480],
 [1812,2160],[682,960],[154,320],[883,960],[882,3240],
 [1413,2160],[1807,1920],[882,960],[258,4320],[258,2160],
 [153,1440],[1787,4320],[1410,3240],[1784,1920],
 [1008,1620],[777,960],[153,432],[257,4320],[597,960],
 [1772,1920],[405,432],[596,4860],[404,1620],[596,720],
 [1405,1440],[2488,3240],[2485,3240],[1002,1620],
 [1402,2160],[875,1440],[1402,1440],[594,2160],[152,216],
 [152,192],[594,720],[593,1440],[403,480],[151,1440],
 [301,810],[402,1440],[592,1620],[402,960],[1738,4320],
 [592,810],[300,3240],[591,2160],[591,1620],[870,2160],
 [254,320],[672,1440],[253,2160],[1174,2160],[1392,1620],
 [868,3240],[150,432],[182,960],[97,960],[867,1920],
 [150,216],[1389,2160],[252,1620],[866,1920],[1388,1440],
 [588,3240],[298,4320],[588,1620],[1386,1620],[298,1440],
 [397,1440],[864,2160],[864,1620],[864,1440],[1383,3840],
 [864,960],[586,960],[863,1440],[585,2160],[863,960],
 [395,6480],[395,2160],[250,2160],[1381,1620],[862,960],
 [861,1440],[1380,1620],[449,810],[860,1440],[7278,8640],
 [1378,2160],[583,3240],[147,1920],[249,2160],[858,2160],
 [858,1620],[1374,1440],[1373,1920],[6084,6480],
 [857,3240],[582,810],[249,320],[857,960],[581,2160],
 [581,1620],[856,1620],[856,1440],[581,960],[6009,6480],
 [391,2160],[660,1080],[391,1440],[1361,8640],
 [2187,7680],[391,810],[5720,15360],[579,1440],[146,216],
 [1357,1440],[852,2430],[145,2160],[658,1620],[145,1080],
 [1354,1440],[851,1920],[851,1620],[577,1080],
 [4929,6480],[577,810],[245,1920],[1344,3240],[502,810],
 [849,1920],[441,1440],[849,1440],[4738,6480],[849,960],
 [387,2160],[1340,1440],[848,1620],[4646,4860],
 [4634,4860],[847,2430],[144,216],[847,1920],[847,1620],
 [1333,2160],[439,810],[4399,4860],[173,192],[846,1440],
 [438,2160],[572,1620],[845,2160],[1594,2160],
 [1329,2160],[4062,4320],[242,1620],[844,1620],
 [4045,4320],[843,3240],[4018,4320],[437,810],[384,960],
 [142,320],[1324,1620],[842,960],[841,3240],[841,1620],
 [69,108],[1322,1620],[240,3240],[1320,3840],[90,320],
 [170,1440],[839,3240],[645,2160],[240,480],[434,2160],
 [839,960],[567,810],[239,1620],[837,3240],[644,810],
 [239,720],[3788,3840],[837,960],[836,1620],[1571,2160],
 [565,2160],[565,1620],[238,1620],[835,1440],[238,810],
 [1312,1620],[834,2160],[139,960],[1310,2430],
 [1310,1620],[563,1620],[237,1440],[3694,6480],
 [378,1440],[237,720],[562,2160],[237,480],[3642,4320],
 [830,2160],[378,432],[3622,3840],[829,2160],[1304,2160],
 [3612,3840],[1303,3240],[933,1920],[1303,1620],
 [3544,3840],[376,1440],[559,1440],[3539,3840],[559,960],
 [3535,3840],[1300,2160],[826,2160],[1299,1440],
 [1298,1440],[375,810],[235,320],[3412,4860],[3384,7680],
 [824,3840],[557,960],[1295,1440],[824,960],[65,1440],
 [556,1080],[822,2160],[373,960],[373,810],[821,1440],
 [555,1620],[233,3240],[136,216],[555,960],[372,960],
 [65,216],[554,2160],[135,1620],[135,1440],[818,1440],
 [371,1080],[553,1620],[3138,3240],[1519,2160],
 [624,3240],[371,432],[370,1920],[370,1080],[552,960],
 [370,810],[551,1080],[1914,2160],[231,3240],[622,2160],
 [1510,2160],[549,1440],[3042,3240],[1277,3240],
 [812,1080],[548,1440],[810,2160],[368,1080],[547,1920],
 [809,1080],[808,1920],[546,1440],[546,1080],[421,810],
 [230,320],[545,1440],[806,1920],[544,960],[3010,3240],
 [805,2880],[618,810],[805,1080],[1496,1920],[1266,1440],
 [617,810],[366,432],[365,1620],[269,1080],[365,540],
 [538,3840],[364,1920],[418,6480],[801,3240],[2939,3240],
 [1255,1920],[1255,1620],[536,3840],[908,1620],
 [908,1440],[1479,2160],[62,216],[1252,2160],[1252,1620],
 [1251,1620],[1473,1620],[794,1620],[2900,3840],
 [360,1920],[1860,1920],[470,2160],[792,1620],[905,1620],
 [131,216],[1242,2880],[2858,7680],[611,960],[469,1920],
 [2838,4320],[2837,4320],[1029,1620],[2824,6480],
 [530,1920],[609,2160],[788,1440],[356,3840],[2793,2880],
 [529,1080],[129,1440],[356,480],[225,3240],[528,1080],
 [2775,6480],[1844,2160],[2769,6480],[355,480],
 [527,2160],[354,720],[784,2430],[129,144],[128,2160],
 [526,1620],[2743,3240],[2740,3840],[155,1440],
 [1225,1620],[783,960],[525,1620],[782,2430],[1223,1440],
 [2674,2880],[1221,1440],[351,1620],[524,1620],
 [780,3240],[524,960],[2654,4320],[885,1440],[1822,1920],
 [350,4860],[2643,4860],[2642,3240],[260,320],
 [1215,1620],[779,1620],[779,1080],[59,216],[2615,3240],
 [222,960],[599,7680],[778,1620],[2602,2880],[521,1440],
 [222,320],[778,810],[1207,2160],[221,2160],[880,1440],
 [777,1080],[347,4860],[2575,6480],[776,3240],[776,2160],
 [2532,4320],[347,810],[2519,3840],[1197,6480],
 [775,2430],[77,192],[876,1440],[775,1440],[2477,3240],
 [2476,3240],[517,2160],[774,1440],[345,3240],[345,1620],
 [1190,2160],[2461,4320],[773,1620],[516,1620],[219,320],
 [1186,2160],[123,480],[772,960],[771,1620],[2435,3240],
 [57,320],[1181,6480],[1181,1620],[770,1620],[2421,3240],
 [217,3840],[514,1620],[994,4320],[769,1440],[217,960],
 [217,810],[2404,2430],[1390,3240],[513,1620],
 [2400,3240],[217,320],[1165,2880],[1165,2160],
 [216,1620],[1164,1620],[1386,3240],[1162,2880],
 [512,810],[2392,2430],[1161,1440],[2383,3240],[511,960],
 [215,2160],[764,2160],[215,1620],[510,2160],[1157,2880],
 [510,960],[1157,1620],[1155,3240],[1155,1620],
 [2300,3240],[763,960],[120,216],[55,810],[2276,3840],
 [1379,3240],[762,960],[1148,1440],[761,1620],[761,1440],
 [2224,3840],[507,1620],[2220,3840],[1144,1440],
 [1143,1620],[759,2160],[1141,4320],[759,960],[758,1440],
 [506,1620],[118,2880],[757,2160],[118,1080],[1138,4320],
 [757,960],[757,810],[505,2160],[2197,2880],[247,1620],
 [54,320],[1134,3240],[5802,7680],[1134,1440],[504,2160],
 [335,1620],[117,1080],[754,810],[1131,1440],[2145,3840],
 [578,3240],[503,1620],[1129,1440],[2134,2160],
 [751,3240],[751,2160],[2132,2160],[502,2160],[502,1920],
 [750,2160],[576,1440],[333,2160],[388,810],[116,720],
 [501,1620],[749,1620],[1120,2430],[1120,1620],
 [1119,2430],[209,2160],[1119,1620],[500,1620],[209,960],
 [115,1920],[500,960],[500,810],[573,1620],[746,2160],
 [4338,14580],[1114,2430],[2084,3240],[499,1620],
 [1113,1620],[499,960],[499,810],[745,1080],[1111,2160],
 [744,1920],[744,1620],[498,1440],[242,480],[843,960],
 [2062,2160],[743,2160],[1107,2160],[497,2160],[330,432],
 [742,1920],[114,192],[2048,3240],[206,2160],[2038,3240],
 [1320,3240],[2034,2160],[2032,2160],[1319,1620],
 [495,2160],[1318,3240],[738,1620],[738,1440],[328,1080],
 [494,4320],[566,1620],[205,2880],[737,960],[113,144],
 [1098,1440],[112,1920],[2019,3240],[327,960],[735,960],
 [1095,1620],[734,3240],[1094,1620],[204,1620],
 [1092,4860],[1092,3840],[1075,1920],[1073,1080],
 [491,2160],[2001,2160],[491,1440],[1070,1920],
 [1995,2160],[1994,2160],[490,3840],[1068,1920],
 [325,810],[1979,3840],[111,432],[1066,1620],[489,3840],
 [729,1620],[324,1440],[1064,1920],[1064,1620],
 [1064,1440],[202,2880],[202,2160],[725,960],[49,160],
 [202,960],[717,1620],[716,1080],[487,810],[1953,2160],
 [1950,3240],[1060,1440],[322,2160],[202,216],[322,1440],
 [485,2160],[485,1620],[1939,2160],[712,2430],
 [1937,3240],[1057,1920],[1936,3240],[711,1620],
 [711,1080],[820,3840],[1055,3240],[710,810],[483,720],
 [709,1080],[1054,2160],[709,810],[482,1440],[708,1620],
 [482,720],[1053,1620],[553,1440],[1284,1440],[707,2160],
 [480,3240],[480,2160],[1921,3240],[1919,3240],
 [1050,1620],[480,720],[3099,3240],[705,1620],[231,2160],
 [1278,2880],[317,3240],[1048,1080],[1047,1620],
 [1906,2160],[1902,4320],[478,720],[1046,1440],
 [1901,2160],[1901,1920],[316,3240],[477,1080],
 [316,1620],[1273,1440],[1043,1440],[106,960],[701,1440],
 [1895,2880],[1895,2160],[1041,3240],[1268,1440],
 [1040,2160],[1266,2160],[1892,1920],[3003,3240],
 [45,1620],[1887,2160],[365,720],[1038,3240],[195,2160],
 [1883,1920],[364,1620],[1881,3240],[2940,3240],
 [314,320],[1880,1920],[695,1440],[363,1080],[1254,1440],
 [798,4320],[1869,3840],[194,3240],[1868,3840],
 [312,1440],[534,1440],[1034,1620],[104,810],[1860,3240],
 [1245,2160],[533,1080],[311,1620],[1031,1620],
 [1858,3240],[1856,4320],[1030,3240],[791,810],
 [1239,2880],[310,2430],[310,1620],[357,960],[691,810],
 [310,810],[192,2160],[468,2160],[1850,2160],[1027,1620],
 [192,810],[1026,4320],[1026,2160],[689,960],[467,6480],
 [309,810],[355,720],[1844,3840],[191,960],[688,960],
 [308,1620],[1023,1620],[1842,3240],[466,2160],
 [1841,3840],[1021,4320],[1840,1920],[1225,2160],
 [190,1080],[1834,3240],[307,810],[1831,3240],[465,960],
 [1018,4320],[1829,3240],[101,1620],[306,4320],
 [306,3240],[306,2160],[1016,1620],[223,1620],[602,1080],
 [1015,1440],[1015,1080],[1817,3240],[779,2430],
 [1814,3240],[682,1080],[462,1620],[188,1440],[681,1440],
 [1011,1920],[2605,4320],[1011,1440],[304,2430],
 [1795,4860],[41,2160],[1792,4860],[187,2160],[679,960],
 [221,1620],[678,4320],[1774,2160],[303,4320],[303,3840],
 [1772,2160],[677,4320],[186,2160],[186,1440],[220,2160],
 [1767,1920],[677,960],[775,1620],[1002,1920],[458,1620],
 [1002,1440],[99,320],[676,960],[40,1620],[675,1620],
 [302,320],[301,4320],[301,3240],[185,216],[98,1440],
 [184,1440],[301,720],[998,1620],[456,960],[98,432],
 [300,3840],[184,270],[300,1620],[184,216],[455,2880],
 [995,1620],[455,1620],[343,1440],[672,960],[39,3840],
 [39,2160],[39,1920],[768,1620],[39,1440],[182,720],
 [670,1440],[990,1080],[670,960],[97,320],[453,1920],
 [181,1440],[97,216],[298,3840],[298,1920],[39,192],
 [452,1080],[298,720],[96,1440],[667,960],[96,960],
 [1692,3840],[297,1620],[984,1920],[297,960],[297,810],
 [39,54],[179,960],[179,810],[38,1620],[38,1440],
 [296,1920],[296,1620],[95,1440],[296,960],[95,960],
 [663,1920],[178,720],[38,216],[1665,4320],[95,320],
 [295,1620],[38,108],[295,1080],[177,1620],[177,720],
 [662,720],[661,6480],[38,54],[94,2160],[446,960],
 [37,2430],[37,2160],[37,1440],[176,2160],[94,320],
 [94,270],[176,540],[660,810],[1649,2160],[94,160],
 [444,1440],[1645,2880],[1645,2430],[93,1920],[292,1620],
 [292,1080],[292,960],[658,810],[1635,2160],[962,6480],
 [175,270],[442,1440],[36,1920],[36,1620],[174,1620],
 [36,960],[1620,3840],[92,1920],[92,1620],[92,1080],
 [655,1080],[1607,1620],[36,216],[173,4860],[173,1620],
 [92,320],[1604,1620],[440,810],[92,216],[289,960],
 [952,2160],[1116,1440],[36,54],[746,1920],[92,96],
 [35,1440],[172,4860],[172,4320],[438,1440],[172,810],
 [651,960],[651,810],[287,1920],[172,320],[437,1440],
 [35,160],[1589,2430],[171,1620],[171,1440],[90,2160],
 [90,1080],[1586,1620],[90,810],[945,1440],[35,54],
 [945,960],[90,432],[171,216],[34,2430],[34,1440],
 [1103,1440],[170,960],[170,810],[90,144],[645,810],
 [941,3840],[941,2160],[89,1080],[34,192],[941,960],
 [34,160],[169,1080],[89,320],[940,960],[642,1080],
 [642,810],[283,432],[641,4320],[282,2880],[169,216],
 [1568,1620],[168,1620],[33,1620],[640,810],[33,960],
 [936,1440],[281,2160],[281,1440],[639,810],[430,2160],
 [935,1620],[88,216],[430,810],[167,810],[934,2160],
 [88,108],[280,960],[429,1920],[934,960],[636,960],
 [933,1620],[166,1440],[1556,1620],[166,810],[32,2430],
 [32,1620],[428,1440],[634,1080],[931,1920],[278,3240],
 [278,1440],[633,960],[165,2160],[165,1620],[86,2880],
 [86,1440],[165,810],[277,2880],[929,960],[631,960],
 [277,960],[165,320],[630,810],[1542,1620],[1540,1620],
 [32,54],[1539,1620],[164,1440],[925,2160],[31,2160],
 [425,810],[31,1080],[31,960],[31,810],[924,1440],
 [424,1440],[164,216],[707,2430],[85,270],[274,4320],
 [31,216],[274,2160],[274,1440],[274,1080],[623,1440],
 [1514,2160],[921,1440],[84,1620],[31,54],[920,1440],
 [1509,3240],[1508,3240],[30,2430],[621,1440],[84,320],
 [30,960],[84,216],[161,2880],[421,1920],[421,1620],
 [421,1440],[1043,1620],[271,960],[30,216],[83,1440],
 [30,160],[30,144],[160,1440],[270,960],[160,810],
 [1893,1920],[617,1620],[912,2430],[269,2160],[30,54],
 [269,1440],[83,108],[911,1620],[29,2430],[615,1440],
 [82,1440],[418,4320],[1484,1620],[418,1080],[909,960],
 [159,320],[418,720],[1035,4860],[267,1920],[267,1080],
 [158,2160],[907,2160],[613,960],[158,810],[612,6480],
 [267,320],[81,1620],[470,6480],[1469,1620],[905,1920],
 [158,216],[28,1920],[415,6480],[28,960],[1030,1440],
 [265,1440],[157,810],[310,1440],[902,1620],[414,1440],
 [28,216],[265,320],[265,270],[157,216],[80,1620],
 [264,1440],[413,2160],[413,1920],[156,1440],[893,2160],
 [28,54],[1449,1920],[1448,1620],[412,1920],[1446,4860],
 [27,2430],[27,2160],[27,1920],[156,216],[411,1440],
 [79,2160],[79,1920],[79,1620],[604,1440],[155,960],
 [155,810],[887,2160],[261,3240],[603,1920],[155,432],
 [79,216],[603,960],[885,3240],[603,720],[260,2160],
 [2650,3240],[408,960],[27,54],[78,4320],[1014,1440],
 [78,810],[407,1440],[26,2160],[26,1920],[26,1620],
 [600,960],[304,3840],[259,320],[599,3240],[153,1920],
 [78,144],[26,432],[599,1080],[880,1920],[1008,1920],
 [405,1620],[77,1620],[26,160],[77,960],[77,810],
 [257,960],[153,216],[404,1920],[152,1920],[596,1620],
 [257,320],[26,54],[595,1920],[1403,1620],[875,1620],
 [595,810],[25,2430],[25,2160],[25,1920],[25,1620],
 [76,960],[25,960],[151,1920],[76,480],[255,320],
 [151,810],[254,1620],[76,216],[1396,1620],[76,144],
 [1395,2160],[25,160],[401,2160],[150,2160],[150,1620],
 [75,3840],[75,1920],[590,1620],[590,1440],[400,960],
 [25,54],[39,1620],[589,3240],[399,2160],[75,320],
 [24,3240],[24,1920],[149,2160],[24,1440],[75,144],
 [588,2160],[149,810],[865,2160],[588,960],[252,320],
 [397,1080],[587,960],[251,1620],[149,216],[396,1440],
 [251,810],[148,2160],[148,1920],[585,1620],[24,108],
 [148,810],[74,144],[862,1080],[584,2160],[148,432],
 [584,1440],[860,1920],[394,1620],[584,810],[23,1620],
 [250,320],[23,960],[23,810],[393,1620],[393,1440],
 [858,1440],[582,2160],[858,960],[582,960],[147,320],
 [23,160],[581,3240],[147,216],[72,960],[581,1440],
 [146,1920],[146,1620],[855,2160],[146,960],[23,54],
 [247,1080],[391,1080],[1360,2160],[72,144],[579,1620],
 [22,1920],[22,1620],[853,960],[246,1920],[71,1620],
 [145,1620],[71,960],[851,2160],[389,1620],[577,2160],
 [22,216],[1351,1440],[245,2160],[71,216],[576,1620],
 [71,144],[144,2160],[144,1620],[144,1440],[1341,3240],
 [575,2160],[22,54],[244,1620],[575,960],[575,810],
 [1338,1440],[574,2160],[21,1920],[70,320],[244,320],
 [143,1440],[243,1620],[846,3240],[846,1620],[243,720],
 [4295,7680],[21,216],[385,2160],[4241,4320],[242,3240],
 [844,2430],[142,2160],[142,1080],[242,810],[571,810],
 [69,320],[242,432],[21,54],[69,216],[842,1080],
 [241,720],[69,144],[569,2160],[20,1920],[840,2430],
 [141,960],[840,1440],[568,1440],[3874,4320],[68,1440],
 [839,2430],[68,960],[382,810],[20,216],[140,3240],
 [140,1440],[566,2160],[381,1440],[68,216],[381,810],
 [239,480],[68,144],[3767,4860],[380,1440],[238,3240],
 [139,3240],[139,2160],[139,1920],[139,1440],[564,1440],
 [67,960],[19,960],[379,810],[237,1620],[67,432],
 [237,1080],[67,320],[139,216],[378,960],[19,216],
 [138,2160],[138,1440],[67,144],[236,3240],[19,108],
 [377,960],[1304,1440],[236,720],[3587,4860],[828,1620],
 [1303,1440],[138,144],[137,2160],[1301,2160],[235,1620],
 [1301,1440],[18,1920],[375,1440],[18,1440],[66,216],
 [18,960],[18,810],[1296,1620],[1296,1440],[374,1620],
 [234,2160],[374,810],[234,960],[18,192],[234,720],
 [556,960],[18,144],[234,432],[555,1920],[65,432],
 [555,1440],[65,320],[233,1620],[136,160],[18,54],
 [135,1920],[65,160],[65,144],[371,1620],[135,960],
 [371,960],[232,3240],[232,2160],[3129,3240],[232,810],
 [64,1080],[64,960],[135,192],[17,320],[370,720],
 [551,960],[134,1620],[64,320],[813,1920],[369,810],
 [813,960],[812,1920],[548,1920],[134,432],[368,1620],
 [230,3240],[17,54],[63,1620],[546,1920],[134,160],
 [367,1620],[807,2160],[133,1620],[367,810],[133,960],
 [229,3240],[1269,1440],[63,216],[805,2160],[542,720],
 [804,3240],[541,720],[1265,1440],[133,160],[229,320],
 [132,2160],[132,1920],[228,3240],[228,2160],[228,1440],
 [364,720],[1256,1920],[537,720],[364,432],[363,1920],
 [62,320],[267,3840],[363,540],[15,1620],[362,1620],
 [362,960],[227,1620],[227,1440],[131,960],[1247,2160],
 [227,810],[533,1440],[360,810],[61,2160],[2889,4860],
 [61,1080],[791,1620],[532,960],[415,960],[531,1440],
 [1238,2160],[226,1920],[15,54],[1237,2880],[61,192],
 [2811,3240],[2810,3240],[130,192],[356,960],[356,720],
 [14,1620],[225,3840],[14,960],[355,1920],[225,1920],
 [225,1440],[1230,2160],[225,960],[225,810],[14,216],
 [129,160],[60,432],[14,144],[60,320],[225,320],
 [1226,1620],[783,1620],[224,2160],[525,2160],[224,960],
 [14,54],[782,1620],[1222,2160],[127,2160],[224,320],
 [59,3840],[59,1920],[223,3240],[1218,2160],[154,2160],
 [1217,2160],[127,216],[523,1080],[779,12960],[126,1440],
 [59,320],[522,1440],[222,3240],[13,216],[1213,1620],
 [59,160],[778,2160],[521,14580],[778,1440],[348,1080],
 [125,2160],[348,810],[777,2430],[125,720],[58,2160],
 [221,1440],[58,1440],[347,2160],[347,1620],[519,1440],
 [125,160],[125,144],[124,3240],[12,1620],[58,216],
 [2490,3240],[518,1440],[346,960],[124,480],[220,320],
 [12,320],[517,1620],[219,1440],[124,160],[773,3240],
 [1188,2160],[57,1440],[57,1080],[123,720],[772,1620],
 [57,720],[218,1440],[344,1440],[771,1440],[12,54],
 [771,960],[770,2160],[57,216],[1177,4320],[122,960],
 [217,2160],[217,1620],[217,1080],[11,1080],[11,960],
 [1172,1620],[513,2160],[342,3240],[56,2160],[121,3240],
 [767,2430],[11,216],[121,810],[216,1440],[1164,1440],
 [341,1620],[341,1440],[1161,1620],[56,192],[1160,4860],
 [56,160],[120,3240],[215,1920],[120,1440],[340,1440],
 [120,960],[120,810],[763,2160],[763,1620],[763,1440],
 [55,1440],[10,1080],[10,960],[10,720],[214,2160],
 [2271,3240],[214,1080],[214,810],[508,810],[338,1440],
 [1145,1440],[338,960],[214,320],[760,960],[759,2880],
 [213,4860],[213,1920],[213,1620],[506,1920],[10,54],
 [54,3840],[118,1620],[54,1440],[118,810],[336,2160],
 [505,2430],[336,1440],[505,1080],[755,1620],[9,1080],
 [9,960],[1134,1620],[754,3240],[117,2160],[212,320],
 [54,108],[117,960],[211,3240],[1130,2160],[2141,4860],
 [117,432],[503,1440],[334,2160],[503,960],[334,1080],
 [1125,1620],[211,216],[53,432],[502,1080],[2125,2880],
 [116,960],[750,960],[53,160],[53,144],[501,1440],
 [53,108],[501,960],[209,3240],[8,1080],[500,2430],
 [332,2160],[115,2880],[52,1620],[332,960],[52,960],
 [52,810],[115,720],[499,4320],[499,2430],[499,2160],
 [52,320],[331,960],[208,960],[115,160],[8,54],
 [52,144],[498,2160],[330,3240],[114,810],[2069,2160],
 [2065,2160],[1108,1920],[114,432],[51,3840],[51,1620],
 [51,1440],[497,810],[51,960],[1105,2160],[114,160],
 [1104,3240],[2035,3240],[1104,1440],[1103,1620],
 [51,216],[328,3240],[328,2160],[206,432],[328,1440],
 [51,96],[328,960],[494,1620],[113,216],[205,2160],
 [51,54],[50,3840],[50,2160],[50,1920],[112,1080],
 [112,960],[50,960],[6,1080],[492,1440],[112,432],
 [204,1440],[734,960],[326,1440],[491,3840],[326,960],
 [111,7680],[111,3240],[732,1920],[1070,1080],[325,3240],
 [204,216],[732,810],[49,4860],[1067,1620],[49,1440],
 [730,1080],[49,960],[324,1620],[111,216],[728,1620],
 [324,960],[488,2160],[110,3240],[110,2160],[110,1920],
 [5,720],[110,960],[487,1620],[323,960],[5,320],
 [715,1620],[715,720],[714,1920],[5,144],[48,1920],
 [110,160],[201,1440],[322,810],[48,960],[485,720],
 [712,1620],[109,810],[1057,1620],[484,810],[201,216],
 [200,2880],[710,1080],[320,2160],[200,960],[48,96],
 [482,3240],[108,2160],[108,1920],[320,432],[4,720],
 [47,1440],[1925,2160],[199,960],[4,270],[319,432],
 [4,216],[319,320],[480,1080],[318,1620],[198,1620],
 [198,1440],[107,960],[1048,2160],[1910,2160],[47,96],
 [479,480],[317,1440],[107,320],[704,960],[197,3240],
 [197,2880],[317,432],[477,2160],[197,960],[316,2160],
 [106,2160],[702,960],[477,480],[46,216],[3,720],
 [1042,1440],[476,720],[315,2160],[700,810],[196,960],
 [1040,1620],[106,160],[1891,1920],[3,96],[1039,1620],
 [1885,4320],[196,216],[105,810],[1038,1920],[1038,1620],
 [314,432],[1880,7680],[105,320],[1037,1440],[45,160],
 [1877,7680],[363,720],[695,810],[195,216],[104,1920],
 [194,2160],[104,1440],[45,54],[312,810],[2,480],
 [44,1440],[1032,1440],[44,960],[104,432],[470,1920],
 [692,2160],[194,216],[104,216],[226,3840],[692,960],
 [44,216],[2,54],[44,160],[103,1440],[193,216],
 [103,810],[44,96],[468,1920],[468,1620],[103,432],
 [309,2160],[309,1620],[43,1440],[309,960],[103,160],
 [688,2160],[191,1080],[102,2430],[191,810],[102,960],
 [308,1440],[43,144],[308,960],[1022,1080],[102,320],
 [686,1620],[1839,2160],[102,216],[190,960],[43,54],
 [685,2880],[42,3840],[42,2430],[101,3240],[42,1440],
 [101,1440],[189,1620],[101,960],[306,1620],[13,1620],
 [1823,2160],[101,432],[189,432],[1014,1920],[682,2880],
 [305,1440],[0,480],[188,1620],[0,320],[462,810],
 [188,960],[100,1440],[680,2880],[100,810],[304,1620],
 [0,96],[461,810],[41,1440],[100,320],[187,960],
 [460,4860],[678,1440],[100,160],[100,144],[303,3240],
 [187,216],[99,3840],[99,1440],[1768,1920],[459,960],
 [99,810],[1764,2160],[302,1620],[302,1080],[676,1440],
 [41,54],[185,1440]];

partitionsset :=
[[1,3,146,138,162,185,182,161,143,145,174,170,275,265,191,
 204,211,297,219,194,242,241,196,232,188,210,205],
 [1,3,146,144,158,138,182,161,137,152,143,170,275,265,204,
 225,257,297,219,242,268,414,196,232,210,199,284],
 [1,3,171,176,146,144,158,138,162,183,181,161,137,152,143,
 145,204,257,198,242,414,296,210,284,274],
 [1,4,7,3,2,146,144,138,182,161,137,143,170,275,204,211,
 297,242,241,196,210,205],
 [1,4,7,146,138,180,185,182,161,143,177,174,170,275,191,204,
 211,297,194,242,241,196,188,210,205],
 [1,4,7,146,144,138,182,161,137,143,170,275,204,211,297,242,
 241,196,210,205,1351,1669,1247,1610,852,1381,1614,1695,
 1004,652],
 [1,4,7,171,146,138,182,161,143,170,191,233,257,194,218,414,
 188,263,284,748,729,1470,780,1365,1312,836,1559,1547,830,
 1311,1352,782,1476],
 [1,4,7,171,146,138,182,183,161,143,170,191,204,211,233,257,
 194,242,241,218,414,188,210,205,263,284],
 [1,4,7,171,146,151,158,138,182,183,161,157,152,143,170,191,
 233,257,194,218,414,188,263,284],
 [1,4,8,2,171,144,162,137,145,204,189,233,198,242,195,210,
 190,263,274,748,729,780,1312,1313,960,1559,1352,1004,786,
 1476,3011,3113],
 [1,4,8,2,171,144,162,137,152,145,204,189,233,198,242,195,
 210,190,263,274,1001,944,790,1652,1278,3643,2102,3404,2150,
 3138,2224],
 [1,4,8,3,2,6,171,144,151,137,157,152,143,145,1001,1191,
 689,944,1097,678,729,3975,4044],
 [1,4,8,3,2,6,171,144,151,158,137,157,152,143,145,1191,689,
 1097,678,729,3975,4044],
 [1,4,8,3,2,171,144,138,162,183,137,143,145,204,211,198,
 242,241,296,210,205,274],
 [1,4,8,3,171,144,158,138,162,183,137,152,143,145,204,257,
 198,242,414,296,210,284,274],
 [1,4,8,3,171,144,162,137,145,204,257,198,242,210,284,274,
 748,729,780,1212,1312,1298,686,960,1559,1492,1352,1461,652,
 786,1476,1375,3011,9376,3113,5424],
 [1,4,8,3,171,144,162,183,137,145,204,211,189,257,198,242,
 241,195,414,296,210,205,190,284,274],
 [1,4,8,9,2,171,144,162,183,137,145,204,189,233,198,242,
 195,218,296,210,190,263,274],
 [1,4,8,9,3,2,6,171,144,151,138,137,157,143,145,689,748,
 678,729],
 [1,4,8,9,12,3,2,6,171,144,151,183,137,157,145,689,678],
 [1,4,8,9,12,3,171,144,185,182,183,137,157,174,170,1135,
 1007,1088,678,898,2894,2992],
 [1,4,8,9,12,171,144,162,180,183,137,145,177,204,257,198,
 242,414,296,210,284,274],
 [1,4,8,9,171,144,162,183,145,204,189,233,198,242,195,218,
 296,263,274,1086,1200,1381,686,836,1492,1695,1705,782,1375,
 1857,3071,2681],
 [1,4,8,9,171,162,185,183,137,145,204,189,242,195,218,296,
 210,190,263,274,849,858,852,1279,1045,1705,1729,1857,3412,
 3400],[1,4,8,10,3,2,6,171,144,158,138,162,137,152,143,
 145,748,729],
 [1,4,8,10,3,2,6,171,144,162,137,152,143,145,1001,1191,944,
 1097,729,3975,4044],
 [1,4,8,10,7,3,171,158,138,185,182,183,174,170,849,1086,
 1099,865,858,1123,855,3982,3776],
 [1,4,8,10,9,3,2,6,171,144,138,162,137,143,145,748,729],
 [1,4,8,10,9,12,2,6,171,144,162,180,183,145,177,1086,1200],
 [1,4,8,10,9,12,3,2,6,171,144,162,183,137,145],
 [1,4,8,10,9,12,6,171,144,162,180,185,183,145,177,174,1086,
 1200],
 [1,4,8,10,12,3,2,6,171,144,162,183,137,152,145,1001,944],
 [1,4,8,10,12,7,3,6,142,164,147,144,185,137,174],
 [1,4,8,10,12,7,3,6,142,164,147,185,174,191,194,188],
 [1,4,8,10,12,7,3,6,142,164,147,191,257,194,414,188,284],
 [1,4,8,10,12,7,3,6,142,172,164,178,147,169],
 [1,4,8,10,12,7,3,6,172,178,169,171,158,183,152],
 [1,4,8,10,12,7,3,6,172,178,169,171,183,211,241,205],
 [1,4,8,10,12,7,3,6,172,178,169,275,211,297,241,196,205],
 [1,4,8,11,7,3,2,6,171,151,158,138,157,152,143,748,729],
 [1,4,8,11,7,3,171,158,138,185,182,174,170,1135,748,953,
 1099,865,1123,855,4080,5410,3357,5180,3311,7968,7726],
 [1,4,8,11,10,3,2,6,171,158,138,162,152,143,145,748,729],
 [1,4,8,11,10,7,2,6,171,158,138,180,152,143,177,748,729],
 [1,4,8,11,10,7,2,6,171,158,138,180,183,152,143,177],
 [1,4,8,11,10,7,3,2,6,171,158,138,152,143,748,729],
 [1,4,8,11,10,7,3,2,6,171,158,138,183,152,143],
 [1,4,8,11,10,12,7,3,2,6,142,164,147],
 [1,4,8,11,10,12,7,3,2,6,171,158,183,152],
 [1,4,8,11,10,12,7,3,2,6,275,211,297,241,196,205],
 [1,4,8,11,12,7,3,2,6,171,151,158,183,157,152],
 [1,4,8,11,12,7,3,2,6,275,204,211,242,241,196,210,205,
 2185,2218,2101],
 [1,4,8,11,12,7,3,2,171,151,158,182,183,157,152,170],
 [1,4,8,12,3,2,6,171,144,151,158,183,137,157,152,145,689,
 678],[1,4,8,12,3,2,6,171,144,183,137,157,152,145,1135,
 1001,1088,944,678,2894,2992],
 [1,4,8,12,3,2,171,144,151,158,182,183,137,157,152,170,689,
 1007,678,898],
 [1,4,8,12,3,2,171,144,151,158,183,137,157,152,170,689,731,
 678,749,898,2819,2895],
 [1,4,8,12,7,3,2,6,275,191,204,211,194,242,241,196,188,
 210,205,2185,2218,2101],
 [1,4,8,12,7,3,142,164,185,182,174,170,191,204,297,194,242,
 205,1133,836,1220,782],
 [1,4,8,12,7,6,144,137,177,174,275,204,211,242,241,210,205,
 852,1381,1614,1695,1004,652,1278,2185,2218,2101,5139,4621,
 4582],
 [1,4,8,12,171,144,162,180,185,183,137,145,177,174,204,211,
 198,242,241,296,210,205,274],
 [1,4,8,12,171,144,162,183,137,145,204,211,233,257,198,242,
 241,218,414,296,210,205,263,284,274],
 [1,4,8,12,171,144,162,183,145,204,211,198,242,241,296,274,
 1086,1200,852,1381,1313,686,836,1559,1614,1695,1045,1705,
 782,1476,1855,1857,4912,3071,7919,2681],
 [1,4,9,2,6,155,160,140,171,143,145,191,204,194,242,188,
 210,729,1212,783,1492,1328,1461,1165,3808,4649,3708],
 [1,4,10,7,3,2,6,171,146,144,158,138,183,161,137,152,143],
 [1,4,10,7,3,2,6,275,197,191,189,297,271,194,195,196,224,
 188,205,190,2220,5752,2219,9151,2192,5693],
 [1,4,10,7,3,6,144,138,185,137,143,174,275,197,297,271,196,
 224,205,1312,1352,2220,2219,2192],
 [1,4,10,7,3,6,171,146,144,138,185,137,143,174,1001,748,
 679,1099,944,729,688,1123],
 [1,4,10,7,3,6,171,146,144,158,138,185,183,161,137,152,143,
 174],
 [1,4,10,7,3,6,171,146,158,183,161,152,174,849,1191,732,
 1086,865,858,1097,730,1200,855],
 [1,4,10,7,3,6,171,146,158,183,161,152,191,189,194,195,188,
 190,284,1381,1705,1947,2125,2058],
 [1,4,10,7,3,6,171,146,191,189,194,195,188,190,284,780,
 1381,790,1181,1559,1652,1320,1352,1278,781,1476,1947,2125,
 2058,8907,4666,9313,4987,7323,4813,4653,8477,8908,7785],
 [1,4,10,9,6,171,144,138,162,183,137,143,145,197,233,257,
 271,218,414,224,263,284],
 [1,4,10,9,7,2,6,171,146,144,138,180,183,161,137,143,177],
 [1,4,10,9,7,6,171,146,144,138,180,185,183,161,137,143,177,
 174],
 [1,4,10,9,7,6,171,146,144,138,185,137,143,174,1028,748,
 679,1351,1022,729,688,1247],
 [1,4,10,9,7,6,171,146,180,183,161,137,143,177,849,1191,
 732,1669,858,1097,730,1610],
 [1,4,10,9,7,6,171,146,180,183,161,177,191,189,194,195,284,
 1381,1133,1492,1705,1220,1375,1947,2125,5950,8171],
 [1,4,10,9,12,3,2,6,171,146,162,183,161,137,145,849,858],
 [1,4,10,9,12,6,171,146,162,180,185,183,145,177,174,849,
 679,1086,688,1200,3938,3768],
 [1,4,10,9,12,171,144,162,182,183,137,145,170,197,233,257,
 271,218,414,224,263,284],
 [1,4,11,3,2,146,138,162,182,161,143,145,170,275,204,211,
 297,242,241,196,210,205],
 [1,4,11,7,3,2,171,151,158,138,182,157,152,143,170,894,748,
 679,729,688,2739,2904],
 [1,4,11,7,3,2,171,151,158,138,182,183,157,152,143,170,894,
 679,997,688],
 [1,4,11,7,146,138,180,185,182,161,143,177,174,170,275,204,
 211,297,242,241,196,210,205],
 [1,4,11,7,146,138,182,161,143,170,275,204,211,297,242,241,
 196,210,205,1351,1669,1247,1610,852,1381,1614,1695,1004,652 
  ],[1,4,11,9,12,2,171,146,151,162,180,182,183,161,157,
 145,177,170],
 [1,4,11,9,12,2,171,146,151,162,182,157,145,170,1028,748,
 679,1351,1022,729,688,1247],
 [1,4,11,9,12,2,171,146,180,183,161,157,177,1135,689,731,
 1007,1153,1088,678,749,898,1043],
 [1,4,11,9,12,2,171,146,180,183,161,177,225,198,242,268,
 296,199,274,1470,1547,2152,2183,2151],
 [1,4,11,9,12,2,171,146,225,198,242,268,296,199,274,1470,
 790,1181,1313,1614,1652,1320,1045,1278,781,1855,2152,2183,
 2151,3448,5942,9083,9218,5486,8344,9274,5465,7191,5659],
 [1,4,11,9,12,7,2,6,171,146,151,180,183,161,157,177],
 [1,4,11,9,12,7,2,6,171,146,151,183,161,157,177,1028,1022],
 [1,4,11,10,9,12,7,2,6,171,146,180,183,161,177],
 [1,4,11,10,9,12,7,6,171,146,180,185,183,161,177,174],
 [1,4,11,10,12,7,2,6,142,164,146,180,161,177,297,205],
 [1,4,11,10,12,7,2,6,155,140,171,158,183,152,233,224],
 [1,4,11,10,12,7,2,6,160,140,171,158,183,152,197,218],
 [1,4,11,10,12,7,2,6,164,147,146,180,161,177,275,241],
 [1,4,11,10,12,7,2,6,171,146,158,180,183,161,152,177],
 [1,4,11,10,12,7,3,2,6,171,146,158,183,161,152],
 [1,4,11,10,12,7,3,2,6,275,197,297,271,241,196,224,205,
 2220,2219,2192],
 [1,4,11,12,3,2,151,162,182,157,145,170,275,197,241,196,
 224,790,1181,1559,962,1533,1476,2220,2192,4666,7637],
 [1,4,11,12,3,2,171,146,151,158,162,182,183,161,157,152,
 145,170],
 [1,4,11,12,3,2,171,146,151,162,182,157,145,170,1001,748,
 679,1099,944,729,688,1123],
 [1,4,11,12,3,2,171,146,158,183,161,152,145,170,1135,689,
 731,953,1088,678,749,994],
 [1,4,11,12,3,2,171,146,158,183,161,152,225,198,242,199,
 274,1470,1565,960,1547,1165,786,2152,2151,7822,4651],
 [1,4,11,12,7,3,2,6,171,146,151,158,183,161,157,152],
 [1,4,11,12,7,3,2,6,171,146,151,183,161,157,152,1001,944],
 [1,4,11,12,7,6,146,161,177,174,275,242,241,210,205,1470,
 780,1614,1695,1547,830,1004,652,1278,2218,2101,3448,5929,
 4746,3830,5017,4621,8025,4582,5910,5812],
 [1,4,12,3,2,171,146,144,162,183,161,137,145,204,211,198,
 242,241,296,210,205,274],
 [1,4,12,6,171,144,162,183,137,145,197,204,211,233,257,271,
 242,241,218,414,224,210,205,263,284],
 [1,4,12,6,171,144,162,183,137,145,197,233,257,271,218,414,
 224,263,284,1135,1001,1088,944,1365,1312,1547,830,782,1476]
  ,[1,4,12,171,144,151,158,162,182,183,137,157,152,145,170,
 197,233,257,271,218,414,224,263,284],
 [1,4,12,171,144,151,158,162,183,137,157,152,145,197,233,
 257,198,271,218,414,296,224,263,284,274],
 [1,4,12,171,144,151,158,162,183,137,157,152,145,197,233,
 257,271,218,414,224,263,284,731,749,960,1729,1906],
 [1,4,12,171,146,144,162,183,137,145,204,211,198,242,241,
 296,210,205,274,679,688,852,1381,1313,686,1614,1695,1045,
 1705,1004,652,1855,1857],
 [1,4,12,171,146,144,162,183,161,137,145,204,211,233,257,
 198,242,241,218,414,296,210,205,263,284,274],
 [1,4,146,138,162,180,185,182,161,143,145,177,174,170,275,
 191,204,211,297,194,242,241,196,188,210,205],
 [1,4,171,144,151,158,138,162,183,137,157,152,143,145,197,
 233,257,198,271,218,414,296,224,263,284,274],
 [1,7,2,146,151,138,180,182,161,157,143,177,170,275,265,191,
 211,297,219,194,241,196,232,188,205],
 [1,7,3,2,146,138,161,143,170,275,265,191,211,194,241,196,
 232,188,205,731,749,1470,790,1000,1365,1547,962,1309,1311,
 782,3142,3078],
 [1,7,3,2,146,151,138,161,143,170,275,265,191,211,194,241,
 196,232,188,205,953,994,1279,1664,786,2185,3169,2218,3406,
 2101,3748],
 [1,8,2,171,176,144,158,162,183,181,137,152,145,204,189,233,
 198,242,195,218,296,210,190,263,274],
 [1,8,9,2,171,176,144,183,137,145,204,189,233,198,218,296,
 210,190,263,274,689,678,1000,1365,1298,1311,1461,854,4676,
 5009],
 [1,8,9,3,2,6,171,176,144,151,138,137,157,143,145,689,748,
 1014,678,729,1041],
 [1,8,9,171,176,144,162,185,183,181,137,145,174,204,189,233,
 198,242,195,218,296,210,190,263,274],
 [1,8,10,9,12,3,2,6,171,144,162,183,181,137,145,1256,1342],
 [1,8,10,9,12,3,6,171,176,144,162,185,183,181,137,145,174],
 [1,8,10,12,3,2,6,171,176,144,158,162,183,181,137,152,145],
 [1,8,10,12,3,6,139,159,156,158,152,275,191,257,297,194,
 414,196,188,284],
 [1,8,10,12,3,6,139,159,156,158,185,152,174,275,191,297,
 194,196,188],
 [1,8,10,12,3,6,139,159,156,158,185,152,174,275,297,196,
 1086,1200,1374,1133,1268],
 [1,8,10,12,3,6,139,159,156,171,183,191,257,194,414,188,
 284,780,1312,1559,830,1352,1476],
 [1,8,10,12,3,6,139,159,156,171,185,183,174,191,194,188,
 1099,1123,780,1559,1352],
 [1,8,10,12,3,6,139,159,156,185,174,275,191,211,297,194,
 241,196,188,205],
 [1,8,10,12,3,6,139,159,156,185,174,275,211,297,241,196,
 205,1374,1459,1133,1487,1268,1220],
 [1,8,10,12,3,6,139,172,159,178,156,169,158,152,275,297,196 
  ],[1,8,10,12,3,6,139,172,159,178,156,169,171,183,211,
 241,205],
 [1,8,10,12,3,6,142,139,164,159,147,156,185,174,191,194,188 
  ],[1,8,10,12,3,6,142,139,164,159,147,156,191,257,194,
 414,188,284],
 [1,8,10,12,3,6,142,139,172,164,159,178,147,156,169],
 [1,8,10,12,3,6,142,164,147,162,145,265,191,257,219,194,
 414,232,188,284],
 [1,8,10,12,3,6,142,164,147,162,185,145,174,265,191,219,
 194,232,188],
 [1,8,10,12,3,6,142,164,147,162,185,145,174,265,219,232,
 1086,1200,1374,1133,1268],
 [1,8,10,12,3,6,142,164,147,176,181,191,257,194,414,188,
 284,783,1565,1328,956,1165,1522],
 [1,8,10,12,3,6,142,164,147,176,185,181,174,191,194,188,
 1007,898,783,1328,1165],
 [1,8,10,12,3,6,142,164,147,185,174,265,191,225,219,194,
 268,232,188,199],
 [1,8,10,12,3,6,142,164,147,185,174,265,225,219,268,232,
 199,1374,1459,1133,1487,1268,1220],
 [1,8,10,12,3,6,142,172,164,178,147,169,162,145,265,219,232 
  ],[1,8,10,12,3,6,142,172,164,178,147,169,176,181,225,
 268,199],
 [1,8,10,12,3,6,172,178,169,158,152,265,225,219,268,232,
 199,1911,790,1725,1652,962,1278],
 [1,8,10,12,3,6,172,178,169,162,145,275,211,297,241,196,
 205,1873,1000,1032,1609,1309,854],
 [1,8,10,12,3,6,172,178,169,171,162,183,145,211,241,205,
 1256,1342,1000,1609,854],
 [1,8,10,12,3,6,172,178,169,171,176,183,181,211,225,241,
 268,205,199],
 [1,8,10,12,3,6,172,178,169,171,183,265,211,225,219,241,
 268,232,205,199],
 [1,8,10,12,3,6,172,178,169,176,158,181,152,225,268,199,
 1049,1152,790,1652,1278],
 [1,8,10,12,3,6,172,178,169,176,181,275,211,225,297,241,
 268,196,205,199],
 [1,8,10,12,3,6,172,178,169,275,265,211,225,297,219,241,
 268,196,232,205,199],
 [1,8,10,12,3,6,275,265,191,211,225,257,297,219,194,241,
 268,414,196,232,188,205,199,284],
 [1,8,10,12,7,3,2,6,275,265,191,211,297,219,194,241,196,
 232,188,205],
 [1,8,11,7,171,176,158,185,181,174,204,189,233,198,242,195,
 218,296,263,274,1099,1123,790,836,1492,1652,782,1375,4649,
 5576],[1,8,11,10,9,12,3,6,275,265,225,257,297,219,268,
 414,196,232,199,284],
 [1,8,11,10,9,12,6,275,265,225,233,257,297,219,268,218,414,
 199,263,284,8750,2349,5379,2255,5477,2226],
 [1,8,11,10,12,3,2,6,139,159,156,158,152,275,297,196],
 [1,8,11,10,12,3,2,6,139,159,156,171,158,183,152],
 [1,8,11,10,12,3,2,6,139,159,156,275,211,297,241,196,205],
 [1,8,11,10,12,3,2,6,142,139,164,159,147,156],
 [1,8,11,10,12,3,2,6,142,164,147,162,145,265,219,232],
 [1,8,11,10,12,3,2,6,142,164,147,176,162,181,145],
 [1,8,11,10,12,3,2,6,142,164,147,265,225,219,268,232,199],
 [1,8,11,10,12,3,6,171,176,158,162,185,183,181,152,145,174]
  ,[1,8,11,10,12,7,3,6,176,158,185,183,181,152,174,1049,
 1152],
 [1,8,11,171,176,158,162,185,183,181,152,145,174,204,189,
 233,198,242,195,218,296,210,190,263,274],
 [1,8,12,7,3,2,6,275,265,191,204,211,194,242,241,196,232,
 188,210,205,2185,3169,2218,3406,2101,3748],
 [1,9,12,2,6,171,144,151,162,183,137,157,145,265,197,233,
 219,271,218,232,224,263],
 [1,9,12,3,2,6,171,176,146,183,181,161,137,157,145,849,
 1135,858,1088,678,2894,2992],
 [1,9,12,3,2,6,171,183,181,161,137,157,145,1256,894,1135,
 1342,997,858,1088,678,4036,2894,3847,2992],
 [1,9,12,3,171,144,183,181,161,137,145,204,257,198,414,296,
 210,284,274,1256,894,1342,997,678,1311,2894,2992,5939,4613]
  ,[1,9,12,3,171,176,146,144,162,183,181,161,137,145,204,
 257,198,242,414,296,210,284,274],
 [1,9,12,171,144,162,183,137,157,145,265,197,233,219,271,
 218,232,224,263,1135,1088,1381,1279,686,960,1695,1664,1705,
 1729,652,786,1857,1906],
 [1,9,12,171,144,162,185,182,183,137,145,174,170,265,197,
 204,233,219,271,242,218,232,224,210,263],
 [1,9,12,171,162,137,265,197,204,233,219,271,242,232,224,
 210,263,849,748,1007,729,898,1381,1279,1313,686,960,1695,
 1664,1004,652,786,1857,1906,3938,3768,4499,4763,4764,3792],
 [1,9,12,171,176,146,144,162,183,181,161,137,145,204,233,
 257,198,242,218,414,296,210,263,284,274],
 [1,9,12,171,176,146,144,162,183,181,161,137,145,204,257,
 198,242,414,296,210,284,274,1028,1022,1313,1045,1855],
 [1,10,2,6,171,144,162,137,152,143,145,265,197,233,219,271,
 232,224,263,1001,1191,944,1097,729,1004,3975,4044,4085,4421 
  ],[1,10,3,2,6,171,176,146,158,138,162,137,152,143,145,
 849,748,1014,679,729,1041,688,3938,3768],
 [1,10,7,2,146,138,182,143,177,170,275,265,191,211,297,219,
 196,232,188,205,679,688,852,1459,1312,1268,1352,1004,5070,
 4303],
 [1,10,7,3,2,146,138,182,161,143,170,275,265,191,211,297,
 219,194,241,196,232,188,205],
 [1,10,7,6,176,158,185,181,137,152,143,174,275,197,233,297,
 271,218,196,224,263,849,1191,858,1097],
 [1,10,7,6,176,158,185,181,152,174,275,197,191,189,233,297,
 271,194,195,218,196,224,188,190,263],
 [1,10,9,12,2,6,171,144,162,183,137,145,265,197,233,219,
 271,218,232,224,263],
 [1,10,9,12,3,2,6,171,176,146,162,183,181,161,137,145,849,
 858],[1,10,9,12,3,171,176,146,162,183,181,161,137,174,
 170,849,732,731,858,730,749,898,2819,2895],
 [1,10,9,12,171,162,183,137,145,265,197,219,271,218,232,224,
 263,849,858,852,1381,1279,1695,1664,1045,1705,1729,652,786,
 1857,1906,3412,3425,3400,3824],
 [1,10,12,7,2,6,146,161,177,275,265,297,219,194,241,188,
 205,1374,780,1614,1487,830,1004,1278,854,3448,4746,4621,
 4952,4582,5577,5910,8682,5812,8832],
 [1,10,12,7,2,6,180,161,177,275,265,297,219,194,241,188,
 205,1517,1725,1032,955,1487,830,1278,854,4030,3389,9290,
 4946,8713,5886,8755,7633,8969,7866],
 [1,10,12,7,3,2,6,275,265,197,297,219,271,194,241,196,232,
 224,188,205,4761,2220,5071,2219,3469,2192],
 [1,10,146,144,158,138,182,161,137,152,143,170,275,265,225,
 233,257,297,219,268,218,414,196,232,199,263,284],
 [1,10,171,176,146,138,182,183,181,161,143,170,191,211,225,
 233,257,194,241,268,218,414,188,205,199,263,284],
 [1,10,176,144,158,138,162,185,182,181,137,152,143,145,174,
 170,275,197,233,297,271,218,196,224,263],
 [1,11,3,2,6,171,176,146,151,158,138,162,152,143,145,748,
 1014,679,953,729,1041,688,994],
 [1,11,9,3,146,138,161,157,143,170,275,265,225,257,268,414,
 196,232,199,284,731,749,1470,790,1000,962,1309,1311,3142,
 3078],
 [1,11,9,146,151,138,180,182,161,157,143,177,170,275,265,
 225,257,297,219,268,414,196,232,199,284],
 [1,11,10,3,2,6,158,138,152,143,265,197,219,271,232,224,
 199,1911,1565,1725,962,1165,1278,2195,2189,2182,4031,3708,
 5017,8577,8649],
 [1,11,10,3,2,6,171,158,138,152,143,145,1256,894,748,1014,
 679,729,1041,688,2894,4875,2739,3886,4310,2904,3952,9104,
 7612],
 [1,11,10,3,2,6,171,158,138,152,143,265,197,219,271,232,
 224,199,748,729,1565,1165,2195,2189,2182],
 [1,11,10,3,2,6,171,176,146,158,138,162,152,143,145,748,
 1014,679,729,1041,688],
 [1,11,10,3,2,6,176,146,158,138,162,152,143,145,1049,748,
 1014,679,729,1041,688,3720,3424],
 [1,11,10,7,2,6,171,158,138,152,143,219,271,232,224,263,
 748,729,1873,1517,1313,1004,2230,2334,4676,4610,5009,4880,
 4618,9156,7109],
 [1,11,10,7,2,6,171,176,146,158,138,180,152,143,177,748,
 1014,679,729,1041,688],
 [1,11,10,7,2,6,176,146,158,138,180,183,152,143,177,1049,
 1014,679,1041,688,3720,3424],
 [1,11,10,9,3,146,138,182,161,143,170,275,265,225,257,297,
 219,268,414,196,232,199,284],
 [1,11,10,9,12,2,171,146,180,183,181,161,177,1256,689,731,
 1007,1153,1342,678,749,898,1043],
 [1,11,10,9,12,2,171,176,146,162,180,182,183,181,161,145,
 177,170],
 [1,11,10,9,12,2,176,162,180,182,181,145,170,1049,894,748,
 679,1351,1152,997,729,688,1247],
 [1,11,10,9,12,3,2,6,171,176,146,162,183,181,161,145],
 [1,11,10,9,12,3,2,6,275,265,197,297,219,271,268,196,232,
 224,199,2195,2189,2182],
 [1,11,10,9,12,3,6,275,265,197,297,219,271,268,414,196,232,
 224,199,284,2195,3946,2189,3691,2182,5984],
 [1,11,10,9,12,6,146,180,161,275,265,297,219,268,414,199,
 284,783,1381,1725,1032,956,1045,1705,1855,4085,4421,5816,
 5177,9240,4522,9012,5933,6727,7443],
 [1,11,10,9,12,7,2,6,171,176,146,180,183,181,161,177],
 [1,11,10,9,146,138,180,182,143,170,275,265,225,257,297,219,
 196,232,199,284,679,688,1565,1313,686,1165,652,1855,3146,
 3008],
 [1,11,10,12,3,2,145,170,275,197,297,271,241,196,224,1873,
 783,1279,1032,1328,1664,1609,1309,1165,786,1476,2220,2219,
 2192,3517,9010,8584,5267,9382,8621,5773,5933,9213,5757],
 [1,11,10,12,3,2,171,146,158,183,161,152,145,170,1256,689,
 731,1014,1342,678,749,1041],
 [1,11,10,12,3,2,171,176,146,158,162,182,183,181,161,152,
 145,170],
 [1,11,10,12,3,2,176,158,162,182,181,145,170,1049,894,748,
 679,1099,1152,997,729,688,1123],
 [1,11,10,12,3,2,176,162,182,181,145,170,275,197,297,271,
 241,196,224,1559,1476,2220,2219,2192],
 [1,11,10,12,3,171,176,146,185,183,181,161,152,145,170,1001,
 689,731,944,678,749,1610,5035,5301],
 [1,11,10,12,7,3,2,6,171,176,146,158,183,181,161,152],
 [1,11,10,12,7,3,2,6,275,265,197,297,219,271,241,196,232,
 224,205,2220,2219,2192],
 [1,11,10,12,7,3,6,171,176,146,185,183,181,161,152,174,
 1001,944],
 [1,11,10,12,7,6,171,176,146,180,185,183,181,161,174,1001,
 1099,1351,944,1247,3899,4154],
 [1,11,10,12,7,6,176,180,185,183,181,161,177,174,1049,894,
 1099,1152,997,944,1123,3353,3131],
 [1,11,10,12,176,158,162,185,182,181,152,145,174,170,275,
 197,233,297,271,218,196,224,263],
 [1,11,10,12,176,158,162,185,182,181,152,174,275,197,233,
 297,271,218,196,224,263,1007,1153,898,1043],
 [1,11,12,2,171,176,146,151,158,162,180,182,183,181,161,157,
 152,145,177,170],
 [1,11,12,3,171,176,146,158,185,183,181,161,174,204,225,198,
 242,268,296,199,274,1099,1123,836,782],
 [1,11,12,7,3,6,176,183,181,161,157,152,174,1049,894,1135,
 1152,997,1088,944,730,3353,3180,3131,3361],
 [1,11,12,7,6,176,151,158,185,181,157,152,174,275,197,233,
 297,271,218,196,224,263],
 [1,11,12,171,176,146,158,180,185,183,181,161,152,174,204,
 225,198,242,268,296,210,199,274,1351,1247],
 [1,11,12,171,176,146,158,185,183,181,161,152,174,204,225,
 233,198,242,268,218,296,210,199,263,274],
 [1,11,12,176,151,158,162,185,182,181,157,152,174,275,197,
 233,297,271,218,196,224,263,1007,1153,898,1043],
 [1,11,12,176,158,162,185,182,181,152,145,174,170,275,197,
 204,233,297,271,242,218,196,224,210,263],
 [1,11,12,176,158,185,181,152,174,204,225,198,242,268,296,
 210,199,274,1049,894,1152,997,852,790,1181,1313,1614,1652,
 1320,1045,1004,1278,781,1855],
 [1,11,12,176,158,185,181,152,174,275,197,233,297,271,218,
 196,224,263,953,994,1470,783,1279,1565,960,836,1328,1664,
 956,1729,1311,1165,786,1522,1906],
 [1,11,12,185,152,275,197,297,271,242,218,196,224,210,263,
 1001,1669,944,1041,1610,1873,783,852,1279,1032,1328,1664,
 956,1045,1729,1309,1165,786,1522,1906,5700,5905,4486,4883,
 4131,3630,3425,4236,3824],
 [1,146,151,138,180,182,161,157,143,177,170,275,265,191,211,
 225,257,297,219,194,241,268,414,196,232,188,205,199,284],
 [2,6,171,144,151,158,138,162,183,137,157,152,143,145,285,
 265,197,233,415,219,271,218,256,232,224,263],
 [2,6,175,176,146,144,151,180,184,181,161,137,157,177,275,
 211,189,225,297,241,195,268,196,205,190,199],
 [2,171,176,144,158,162,183,181,137,152,145,285,197,204,189,
 233,198,415,271,242,195,218,296,256,224,210,190,263,274],
 [3,2,6,171,176,144,158,162,183,181,137,152,145,285,197,204,
 189,415,271,242,195,256,224,210,190],
 [3,2,146,144,151,158,138,182,161,137,157,152,143,170,275,
 285,265,225,297,415,219,268,196,256,232,199],
 [3,2,171,175,176,146,144,162,183,184,181,161,137,145,204,
 211,189,198,242,241,195,296,210,205,190,274],
 [3,146,138,162,185,182,161,143,145,174,170,275,285,265,191,
 204,211,297,415,219,194,242,241,196,256,232,188,210,205],
 [4,2,146,144,151,138,162,180,182,161,137,157,143,145,177,
 170,275,285,211,297,415,241,196,256,205],
 [4,2,171,144,151,138,162,183,137,157,143,145,285,197,211,
 233,198,415,271,241,218,296,256,224,205,263,274],
 [4,2,171,175,146,144,162,183,184,161,137,145,204,211,189,
 233,198,242,241,195,218,296,210,205,190,263,274],
 [4,3,2,6,171,144,162,137,152,145,285,197,204,189,415,271,
 256,224,210,190,748,729,780,1365,1298,1311,1352,1461,8587,
 5947],[4,7,2,6,175,144,151,138,180,184,137,157,143,177,
 275,197,211,297,271,241,196,224,205],
 [4,7,2,6,175,151,180,184,137,157,143,177,275,197,211,297,
 271,241,196,224,205,849,1191,858,1097],
 [4,7,3,2,146,138,161,143,170,275,285,211,241,196,256,205,
 731,749,1374,1470,790,654,1459,1365,1487,1547,962,687,1268,
 1311,1220,782,5993,3142,9418,3078],
 [4,7,3,2,146,138,182,161,143,170,275,285,191,204,211,297,
 415,194,242,241,196,256,188,210,205],
 [4,7,3,2,146,144,151,138,182,161,137,157,143,170,275,285,
 211,297,415,241,196,256,205],
 [4,7,3,138,161,170,275,285,257,297,415,241,414,196,256,205,
 284,894,865,997,749,855,1374,1470,780,1133,836,1487,1547,
 830,1268,1311,1220,782,5946,5156,4625,5939,4502,4613],
 [4,7,3,146,138,182,161,143,174,170,275,285,211,297,415,241,
 196,256,205,732,730,1374,1470,1459,1365,1133,836,1487,1547,
 1268,1311,1220,782],
 [4,7,3,146,138,185,182,161,143,174,170,275,285,191,204,211,
 297,415,194,242,241,196,256,188,210,205],
 [4,7,3,146,144,151,138,182,161,137,157,143,170,275,285,211,
 297,415,241,196,256,205,732,1669,730,1610],
 [4,7,3,146,158,138,182,161,152,143,170,275,285,191,204,257,
 297,415,194,242,414,196,256,188,210,284],
 [4,7,3,171,175,146,138,182,183,184,161,143,170,191,204,257,
 194,242,414,188,210,284,1099,1123,780,1559,1352],
 [4,7,6,171,175,146,151,180,183,184,161,157,152,177,191,189,
 257,194,195,414,188,190,284,1001,944],
 [4,7,6,171,175,146,151,180,183,184,161,157,177,191,211,189,
 257,194,241,195,414,188,205,190,284],
 [4,7,6,175,144,151,138,180,184,137,157,143,177,174,275,197,
 211,297,271,241,196,224,205,732,730],
 [4,7,6,175,144,151,138,180,185,184,137,157,143,177,174,275,
 197,211,297,271,241,196,224,205],
 [4,7,6,175,151,180,184,157,177,191,189,257,194,195,414,188,
 190,284,1049,894,1152,997,780,790,1181,1312,1559,1652,1320,
 830,1352,1278,781,1476],
 [4,7,6,175,151,180,184,157,177,275,197,211,297,271,241,196,
 224,205,1669,1610,1374,1212,1381,1459,1298,1133,1492,1695,
 1487,1113,1268,1461,652,1220,1375],
 [4,7,6,175,151,180,185,184,157,177,174,275,197,191,211,189,
 297,271,194,241,195,196,224,188,205,190],
 [4,8,3,2,6,171,144,151,162,183,137,157,145,285,211,189,
 415,241,195,256,205,190],
 [4,8,3,171,144,151,162,183,137,157,145,285,211,189,257,198,
 415,241,195,414,296,256,205,190,284,274],
 [4,8,3,171,144,158,138,162,183,137,152,143,145,204,257,198,
 242,414,296,210,284,274,1596,734,1651,735],
 [4,8,3,171,144,162,185,182,183,137,145,174,170,285,211,189,
 415,241,195,256,205,190,1135,1088,1365,1547,782],
 [4,8,3,171,162,137,285,204,257,198,415,242,414,296,256,284,
 274,849,748,1007,858,898,780,1212,1312,1298,836,1559,1492,
 830,1113,782,1476,1375,5410,5180,4532,4839,5641,4750],
 [4,8,3,171,175,144,162,183,137,145,204,257,198,242,414,296,
 210,284,274,734,735,780,1212,1312,1298,1559,1492,830,1113,
 1352,1461,1476,1375],
 [4,8,3,171,175,144,162,183,184,137,145,204,211,189,257,198,
 242,241,195,414,296,210,205,190,284,274],
 [4,8,7,2,6,175,144,151,180,184,137,157,177,275,211,189,
 297,241,195,196,205,190],
 [4,8,7,171,175,151,180,183,184,157,177,191,211,189,257,198,
 194,241,195,414,296,188,205,190,284,274],
 [4,8,7,171,175,151,180,183,184,157,177,191,257,198,194,414,
 296,188,284,274,1001,1191,944,1097,1312,1298,830,1113,1476,
 1375],
 [4,8,7,175,144,151,180,184,137,157,177,275,211,189,257,198,
 297,241,195,414,296,196,205,190,284,274],
 [4,8,7,175,151,180,184,157,177,191,257,198,194,414,296,188,
 284,274,1049,1152,780,1212,1312,1298,1559,1492,830,1113,
 1352,1461,1476,1375,3808,4031,4649,4776,3708,5576],
 [4,8,7,175,151,180,185,182,184,157,177,275,211,189,297,241,
 195,196,205,190,1669,1153,1610,1043,1374,1459,1133,1487,
 1268,1220],
 [4,8,9,7,3,2,6,171,175,144,151,183,184,137,157,143,1191,
 1097],
 [4,8,9,7,3,2,171,175,182,183,184,137,157,170,849,1135,865,
 858,1088,1097,855,3986,4217],
 [4,8,9,7,3,6,171,175,144,151,183,184,137,157,143,174,1191,
 732,1097,730],
 [4,8,9,7,3,6,171,175,185,183,184,137,157,143,174,849,1135,
 858,1088,1097,3986,4217],
 [4,8,9,12,3,171,175,144,162,183,184,137,145,204,257,198,
 242,414,296,210,284,274],
 [4,8,9,12,7,3,6,171,175,144,151,183,184,137,157,174,732,
 730],
 [4,8,9,12,7,171,175,151,180,183,184,157,177,191,257,198,
 194,414,296,188,284,274],
 [4,8,10,2,6,171,144,162,180,183,137,145,177,285,211,189,
 415,241,195,256,205,190],
 [4,8,10,3,2,6,175,144,158,138,162,137,152,143,145,1049,
 748,734,729,735,3720,3424],
 [4,8,10,3,171,144,162,183,137,145,285,211,189,257,198,415,
 241,195,414,296,256,205,190,284,274],
 [4,8,10,3,171,144,162,185,182,183,137,145,174,170,285,211,
 189,415,241,195,256,205,190],
 [4,8,10,3,171,162,185,182,183,145,174,170,285,415,241,195,
 205,190,849,858,780,1212,1487,830,1113,1220,3451,4004,4625,
 4502,4543,5559],
 [4,8,10,9,12,3,2,6,175,144,162,183,184,137,145,1049,1152],
 [4,8,11,2,6,175,151,162,180,184,157,145,177,275,211,189,
 297,241,195,196,205,190],
 [4,8,11,7,2,6,171,151,180,183,157,152,143,177,1596,1001,
 1191,1651,944,1097,735,3943,4665],
 [4,8,11,7,3,2,163,141,171,175,183,184,204,241,195,296,205,
 190,780,1212,830,1113],
 [4,8,11,7,175,151,180,184,157,177,275,211,189,257,198,297,
 241,195,414,296,196,205,190,284,274],
 [4,8,11,7,175,151,180,185,182,184,157,177,174,170,275,211,
 189,297,241,195,196,205,190],
 [4,8,11,9,12,7,2,6,171,151,180,183,184,157,177,1596,1651],
 [4,8,11,10,7,3,2,6,171,158,138,183,152,143,1596,734,1651,
 735],
 [4,8,11,10,7,3,2,6,171,175,158,138,183,184,152,143],
 [4,8,11,10,7,3,2,6,175,158,138,184,152,143,1049,748,1152,
 729],[4,8,11,10,9,7,3,2,6,171,175,138,183,184,143],
 [4,8,11,10,12,7,3,2,6,171,175,158,183,184,152],
 [4,8,12,7,3,2,6,171,175,144,151,183,184,137,157,152,1001,
 944],
 [4,8,12,7,3,2,171,175,183,184,137,157,170,849,1135,858,
 1088,944,749,1123,3353,5946,3131,5156,3755,8904,8110],
 [4,8,12,7,3,6,171,175,144,151,183,184,137,157,152,174,
 1001,732,944,730],
 [4,9,3,2,6,171,144,162,183,137,145,285,197,204,189,415,
 271,242,195,256,224,210,190],
 [4,9,3,6,171,144,162,183,145,174,285,197,204,189,415,271,
 242,195,210,190,1086,1200,1381,1707,955,1695,652,1376,781],
 [4,9,3,6,171,162,183,137,145,174,285,197,415,271,242,195,
 256,224,210,190,849,858,1470,1212,1381,1695,1547,1113,652],
 [4,9,7,2,6,171,146,144,151,138,183,184,161,137,157,143,
 177,1596,1028,1651,1022],
 [4,9,7,3,146,138,182,161,143,170,275,285,191,204,257,297,
 415,194,242,414,196,256,188,210,284],
 [4,9,7,3,171,175,146,138,182,183,184,161,143,170,191,204,
 257,194,242,414,188,210,284],
 [4,9,7,3,171,175,146,182,183,184,161,170,191,204,194,242,
 414,284,865,855,1212,1133,836,1492,1220,782,3946,3691,4839,
 4750,5899,4653],
 [4,9,7,6,171,175,146,151,180,183,184,161,157,177,191,189,
 257,194,195,414,188,190,284],
 [4,9,7,6,171,175,146,151,183,184,161,157,177,191,189,257,
 414,188,190,284,1028,1022,1459,1298,1268,1461],
 [4,9,171,144,151,138,162,183,137,157,143,145,285,197,233,
 257,198,415,271,218,414,296,256,224,263,284,274],
 [4,9,171,175,146,138,162,180,182,183,184,161,143,145,177,
 170,191,204,257,194,242,414,188,210,284],
 [4,9,171,175,146,144,162,183,184,161,137,145,204,189,233,
 257,198,242,195,218,414,296,210,190,263,284,274],
 [4,9,171,175,146,151,162,180,182,183,184,161,157,145,177,
 170,191,189,257,194,195,414,188,190,284],
 [4,10,7,3,2,6,171,146,158,183,161,137,152,143,1596,849,
 1191,734,1651,858,1097,735],
 [4,10,7,3,2,6,171,146,158,183,161,152,191,189,256,188,190,
 1868,1459,1298,1694,1268,1461,2022,1939,5366,8634],
 [4,10,7,3,2,6,171,175,146,144,158,138,183,184,161,137,152,
 143],
 [4,10,7,3,2,6,175,144,138,184,137,143,297,271,196,224,205,
 1911,1517,1312,1652,1320,1352,2219,2192,4946,4987],
 [4,10,7,3,2,6,175,144,138,184,137,152,143,1049,894,1001,
 748,679,1152,997,944,729,688],
 [4,10,7,6,171,175,146,144,158,138,180,185,183,184,161,137,
 152,143,177,174],
 [4,10,9,7,2,6,171,146,180,183,161,177,191,189,194,195,256,
 188,190,1868,1694,2022,2114,1939],
 [4,10,9,7,2,6,171,146,180,183,184,161,177,1596,849,1191,
 1086,865,1651,858,1097,1200,855],
 [4,10,9,7,2,6,171,175,146,144,138,180,183,184,161,137,143,
 177],
 [4,10,9,7,2,6,175,144,138,184,137,143,177,1049,894,1028,
 748,679,1152,997,1022,729,688],
 [4,10,9,7,3,2,6,171,175,146,144,138,183,184,161,137,143],
 [4,10,9,7,3,2,6,275,197,191,189,297,271,194,195,196,256,
 224,188,190,4768,2022,4415,2114,4558,1939],
 [4,10,9,12,2,171,144,162,183,137,145,285,197,233,198,415,
 271,218,296,256,224,263,274],
 [4,10,9,12,171,144,162,185,183,145,285,197,233,198,415,271,
 218,296,263,274,1086,1200,686,1707,955,1705,1376,781,1857],
 [4,10,9,12,171,162,183,137,145,285,197,415,271,218,296,256,
 224,263,274,849,858,852,1381,1279,1695,1045,1705,1729,652,
 1857,3412,3400],
 [4,10,12,2,171,144,158,162,137,145,285,197,233,198,415,271,
 256,224,263,274,748,729,1312,1313,960,1004,786,1476,3011,
 3113],[4,11,9,7,3,2,6,275,204,189,297,415,271,242,195,
 196,256,224,210,190,4768,5196,4415,5222,4558,4729],
 [4,11,9,12,2,171,146,151,162,180,182,184,145,177,170,1596,
 748,679,953,729,688,994,6077,5165],
 [4,11,9,12,7,2,6,171,146,151,180,183,184,161,157,177,1596,
 1651],
 [4,11,10,2,146,138,162,180,182,143,170,275,285,211,297,415,
 196,256,205,679,1007,1351,898,1247,1312,2954,2867,4532,5641 
  ],[4,11,10,2,146,138,162,180,182,161,143,145,177,170,
 275,285,211,297,415,241,196,256,205],
 [4,11,10,7,3,2,171,175,158,138,182,183,184,143,170,894,
 679,1099,997,1123,2954,2867],
 [4,11,10,7,3,146,138,185,182,161,143,174,170,275,285,211,
 297,415,241,196,256,205],
 [4,11,10,9,2,6,171,175,138,143,225,233,271,268,218,199,
 263,1517,790,654,1652,1694,1278,1376,2168,2160,2202,4446,
 9248,4998],
 [4,11,10,9,2,6,171,175,138,162,180,143,145,177,894,748,
 734,679,729,735,688,2739,2904],
 [4,11,10,9,2,6,171,175,146,138,162,180,143,145,177,748,
 734,679,729,735,688],
 [4,11,10,9,2,171,175,138,162,180,182,161,145,177,170,894,
 748,734,865,729,735,855,2739,2904],
 [4,11,10,9,7,3,2,6,171,175,146,138,183,184,161,143],
 [4,11,10,9,12,7,2,6,171,175,146,180,183,184,161,177],
 [4,11,10,12,2,6,171,175,146,158,162,180,152,145,177,748,
 734,679,729,735,688],
 [4,11,10,12,2,6,171,175,158,152,225,233,271,199,263,1517,
 790,654,1565,1313,1165,1004,1278,1376,2168,2202,4031,4538,
 3708,3730,4446,8953,8478,4998,8151,7043],
 [4,11,10,12,2,6,171,175,158,162,180,161,152,145,177,894,
 748,734,729,735,2739,2904],
 [4,11,10,12,7,3,2,6,171,175,146,158,183,184,161,152],
 [4,11,12,2,175,162,180,182,184,157,145,177,170,275,197,297,
 271,241,196,224,205,1135,1088,780,830],
 [4,11,12,7,2,6,171,146,151,180,183,161,157,152,177,1596,
 1001,1651,944,735,3943,4665],
 [4,11,12,7,2,6,175,151,180,184,157,177,275,197,211,297,
 271,241,196,224,205],
 [4,171,175,146,144,162,183,184,161,137,145,204,211,189,233,
 257,198,242,241,195,218,414,296,210,205,190,263,284,274],
 [5,1,4,3,146,151,138,161,143,170,191,211,225,257,268,414,
 188,205,199,284,731,749,1459,1365,1312,1268,1352,782,5777,
 8127],
 [5,1,4,7,3,2,146,144,151,158,138,152,143,170,731,679,1086,
 953,688,1200,994,4138,3984],
 [5,1,4,7,3,2,146,144,151,158,138,157,152,143,170,731,679,
 1086,688,1200,4138,3984],
 [5,1,4,7,3,146,158,138,182,161,152,143,170,191,204,257,
 194,242,414,188,210,284],
 [5,1,4,7,146,151,158,138,182,161,157,152,143,170,191,233,
 257,194,218,414,188,263,284],
 [5,1,4,8,9,3,2,144,151,138,162,182,137,157,143,145,170],
 [5,1,4,8,9,3,2,191,204,189,225,198,194,195,268,296,188,
 190,199,274,6054,2152,9171,2183,5221,2151],
 [5,1,4,8,9,3,144,138,185,137,143,174,204,225,198,268,296,
 1365,1328,1664,1311,1522,1906,2152,2183,5881,5990],
 [5,1,4,8,9,3,144,151,138,162,182,157,145,170,732,1086,865,
 1669,730,1200,855,1610],
 [5,1,4,8,9,3,144,151,138,162,185,182,137,157,143,145,174,
 170],[5,1,4,8,9,3,144,151,138,185,137,143,174,689,731,
 953,1007,1153,678,749,994,898,1043],
 [5,1,4,8,9,3,151,162,182,157,145,170,191,189,257,188,190,
 1459,1298,1695,1268,1461,1857,1947,2058,9060,5496],
 [5,1,4,8,9,7,3,6,144,151,138,137,157,143,174,732,730],
 [5,1,4,8,9,7,3,6,144,151,138,185,137,157,143,174],
 [5,1,4,8,9,12,7,3,2,144,151,137,157,170,731,749],
 [5,1,4,8,9,12,7,3,2,144,151,182,137,157,170],
 [5,1,4,8,9,12,7,3,6,144,151,137,157,174,732,730],
 [5,1,4,8,9,12,7,3,6,144,151,185,137,157,174],
 [5,1,4,8,9,12,7,3,144,151,182,137,157,170,732,1669,730,
 1610],
 [5,1,4,8,9,12,7,3,144,151,185,137,157,174,731,1153,749,
 1043],
 [5,1,4,8,9,12,7,3,144,151,185,182,137,157,174,170],
 [5,1,4,8,10,3,6,191,211,189,225,257,194,241,195,188,205,
 190,199,284,4599,1947,5140,2125,5906,2058],
 [5,1,4,8,10,7,3,6,144,158,138,185,137,152,143,174],
 [5,1,4,8,10,7,3,6,191,211,189,257,194,241,195,188,205,
 190,284,1947,2125,2058],
 [5,1,4,8,10,7,3,144,158,138,185,182,152,143,174,170,1086,
 1200],[5,1,4,8,10,9,3,144,138,162,185,182,137,143,145,
 174,170],
 [5,1,4,8,10,9,3,191,189,225,257,198,194,195,268,296,188,
 190,199,274,1947,4404,2125,4568,2058,4256],
 [5,1,4,8,10,9,7,3,6,144,138,185,137,143,174],
 [5,1,4,8,10,9,7,3,6,191,189,257,194,195,188,190,284,1947,
 2125,2058],
 [5,1,4,8,10,9,7,6,144,138,180,185,137,143,177,174],
 [5,1,4,8,10,9,7,6,144,138,180,185,137,143,177,1669,1610],
 [5,1,4,8,10,9,12,3,144,162,185,182,137,145,174,170],
 [5,1,4,8,10,9,12,6,144,162,180,185,145,177,174,1086,1200],
 [5,1,4,8,10,9,12,6,191,225,233,257,194,268,218,414,199,
 263,284,2682,2574,2424],
 [5,1,4,8,10,9,12,7,3,6,172,178,169],
 [5,1,4,8,10,9,12,7,3,144,185,182,137,174,170],
 [5,1,4,8,10,9,12,7,6,144,180,185,137,177,174],
 [5,1,4,8,10,9,12,7,6,191,233,257,194,218,414,263,284,
 2682,2574,2424],
 [5,1,4,8,10,12,3,6,144,158,162,185,145,174,1086,1099,1200,
 1123],
 [5,1,4,8,10,12,3,6,191,211,225,257,194,241,268,414,188,
 205,199,284],
 [5,1,4,8,10,12,3,191,211,225,257,198,194,241,268,414,296,
 188,205,274,4739,4404,5376,4568,5228,4256],
 [5,1,4,8,10,12,6,191,211,225,233,257,194,241,268,218,414,
 199,263,284,2682,4184,2574,4260,2424,4773],
 [5,1,4,8,11,7,2,204,211,189,233,198,242,241,195,210,205,
 190,263,274,3643,2102,3404,2150,3138,2224],
 [5,1,4,8,11,7,3,2,204,211,189,198,242,241,195,210,205,
 190,274,2102,2150,2224],
 [5,1,4,8,11,7,3,151,158,138,185,182,152,143,174,170,953,
 994],[5,1,4,8,11,9,2,204,189,225,233,198,242,195,268,
 218,296,199,263,274,2152,3627,2183,5885,2151,4640],
 [5,1,4,8,11,9,7,2,204,189,233,198,242,195,218,296,210,
 190,263,274],
 [5,1,4,8,11,9,7,204,189,233,257,198,242,195,218,414,296,
 210,190,284,4387,3416,7746,3828,5696,4129],
 [5,1,4,8,11,9,12,2,151,162,180,182,157,145,177,170],
 [5,1,4,8,11,9,12,2,204,225,233,198,242,268,218,296,199,
 263,274,2152,2183,2151],
 [5,1,4,8,11,9,12,3,2,151,162,182,157,145,170],
 [5,1,4,8,11,9,12,3,2,204,225,198,242,268,296,199,274,
 2152,2183,2151],
 [5,1,4,8,11,9,12,3,151,162,185,182,157,145,174,170],
 [5,1,4,8,11,9,12,7,3,2,148,163,141],
 [5,1,4,8,11,9,12,7,3,2,151,182,157,170],
 [5,1,4,8,11,9,12,7,3,2,204,198,242,296,210,274],
 [5,1,4,8,11,9,12,7,3,151,185,182,157,174,170],
 [5,1,4,8,11,10,9,12,7,3,2,6],
 [5,1,4,8,11,12,3,2,151,158,162,182,152,145,170,953,994],
 [5,1,4,8,11,12,3,2,151,158,162,182,157,152,145,170],
 [5,1,4,8,11,12,7,3,2,151,158,182,157,152,170],
 [5,1,4,8,11,12,7,3,2,204,211,198,242,241,210,205,274,
 2102,2150,2224],
 [5,1,4,8,11,12,7,151,158,180,185,182,157,152,177,174,1153,
 1043],
 [5,1,4,8,11,12,7,204,211,233,257,198,242,241,218,414,210,
 205,263,284,2102,3416,2150,3828,2224,4129],
 [5,1,4,8,12,7,3,2,144,151,158,137,157,152,170,731,749],
 [5,1,4,8,12,7,6,191,204,211,233,257,242,241,218,414,210,
 205,263,284,4959,2682,5307,2574,8516,2424],
 [5,1,4,9,2,146,144,151,138,161,137,157,145,177,170,689,
 1028,731,678,1022,749,855,4187,3901],
 [5,1,4,9,7,3,2,146,144,151,138,161,137,157,143,170,731,
 749],
 [5,1,4,9,7,3,2,146,144,151,138,161,143,170,731,1086,953,
 1200,994,4138,3984],
 [5,1,4,9,7,3,146,144,151,138,161,137,157,143,174,732,731,
 730,749,1043,3370,3741],
 [5,1,4,9,12,2,144,151,137,157,170,197,225,233,268,218,199,
 263,731,749,1181,1533,2168,2160,2202],
 [5,1,4,9,12,2,144,151,137,157,197,225,233,268,218,199,263,
 1279,1181,960,1729,1533,1906,2168,2160,2202,3530,4144,7946,
 7893,5365],
 [5,1,4,9,12,2,146,144,151,137,157,170,689,1028,731,678,
 1022,749,898,1247,4012,2819,4273,4102,2895,4347,2867,8375,
 8928],
 [5,1,4,9,12,2,146,144,151,161,137,157,145,177,170,689,
 1028,731,678,1022,749],
 [5,1,4,9,12,2,146,144,151,161,137,157,145,177,689,1028,
 731,678,1022,749,1043,3370,3741],
 [5,1,4,9,12,6,146,144,151,137,157,145,177,689,1028,732,
 678,1022,688,1610,4012,5035,4102,5301,4171,8489,8998],
 [5,1,4,9,12,7,3,2,146,144,151,161,137,157,170,731,749],
 [5,1,4,9,12,7,3,6,146,144,151,161,137,157,174,732,730],
 [5,1,4,9,12,7,148,141,146,144,161,137,233,257,198,210,263,
 284,1313,686,1004,652],
 [5,1,4,9,12,7,155,140,144,151,137,157,233,257,198,224,284,
 274,686,960,652,786],
 [5,1,4,9,146,138,162,180,182,161,143,145,177,170,191,204,
 257,194,242,414,188,210,284],
 [5,1,4,9,146,138,182,143,170,191,204,257,194,242,188,210,
 284,679,688,783,852,1565,1313,686,1328,1614,1165,1004,652,
 1522,1855,3246,3146,2981,3008],
 [5,1,4,9,146,138,182,143,170,191,204,257,194,242,188,210,
 284,1007,1351,898,1247,783,852,1328,1614,1165,1004,2954,
 2867,4614,3071,3851,4880,2681,8796,5950,5496],
 [5,1,4,10,3,146,138,182,161,143,170,191,211,225,257,194,
 241,268,414,188,205,199,284],
 [5,1,4,10,7,2,146,144,158,138,137,152,143,177,170,1028,
 731,679,1022,749,688],
 [5,1,4,10,7,3,2,146,144,158,138,137,152,143,170,731,679,
 749,688],
 [5,1,4,10,9,7,3,2,146,144,138,161,137,143,170,731,749],
 [5,1,4,10,9,7,146,138,182,161,143,170,191,233,257,194,218,
 414,188,263,284],
 [5,1,4,10,9,12,7,6,146,144,180,185,161,137,177,174],
 [5,1,4,10,9,146,138,162,182,161,143,145,170,191,233,257,
 194,218,414,188,263,284],
 [5,1,4,10,146,138,182,143,170,191,211,225,257,194,241,188,
 205,199,284,679,688,852,1565,1313,686,1614,1165,1004,652,
 1855,3146,3008],
 [5,1,4,11,7,3,2,146,151,158,138,182,143,170,679,953,1099,
 994,1123,2954,2867],
 [5,1,4,11,7,3,2,146,151,158,138,182,157,152,143,170,679,
 688],[5,1,4,11,9,7,2,146,151,138,180,182,161,157,143,
 177,170],
 [5,1,4,11,9,7,3,2,146,151,138,182,161,143,170,953,994],
 [5,1,4,11,9,12,7,2,148,163,141,146,161,233,218,263],
 [5,1,4,11,9,12,7,2,148,163,141,146,180,161,177],
 [5,1,4,11,9,12,7,2,148,163,141,197,233,271,218,224,263],
 [5,1,4,11,9,12,7,2,155,148,160,163,140,141],
 [5,1,4,11,9,12,7,2,155,160,140,151,157,198,296,274],
 [5,1,4,11,9,12,7,2,155,160,140,151,182,157,170],
 [5,1,4,11,9,12,7,2,155,160,140,204,198,242,296,210,274],
 [5,1,4,11,10,2,146,158,138,162,180,182,145,177,170,679,
 1099,865,1123,855,2954,2867],
 [5,1,4,11,10,2,146,158,138,162,180,182,170,679,1099,865,
 1007,1351,1123,898,1247,2954,3759,2867,4097],
 [5,1,4,11,10,7,3,2,146,158,138,182,152,143,170,679,688],
 [5,1,4,11,10,9,2,6,146,138,162,180,143,145,177,679,688],
 [5,1,4,11,10,9,2,6,197,189,225,233,271,195,268,218,190,
 199,263,2168,2160,2202],
 [5,1,4,11,10,9,2,146,138,162,180,182,161,145,177,170,865,
 855],
 [5,1,4,11,10,9,3,2,146,138,162,182,161,145,170,865,855],
 [5,1,4,11,10,9,7,2,146,138,180,182,161,143,170,1351,1247],
 [5,1,4,11,10,9,7,3,2,146,138,182,161,143,170],
 [5,1,4,11,10,9,7,3,146,138,185,182,161,143,174,1153,1043],
 [5,1,4,11,10,9,7,6,146,138,180,185,161,143,177,174],
 [5,1,4,11,10,9,7,146,138,180,185,182,161,143,177,174,1153,
 1043],
 [5,1,4,11,10,9,12,2,6,146,162,180,145,177,679,688],
 [5,1,4,11,10,9,12,2,6,146,162,180,161,145,177],
 [5,1,4,11,10,9,12,2,6,197,225,233,271,268,218,199,263,
 2168,2160,2202],
 [5,1,4,11,10,9,12,2,146,162,180,182,161,145,177,170],
 [5,1,4,11,10,9,12,2,197,225,233,198,271,268,218,296,199,
 263,274,2168,2160,2202],
 [5,1,4,11,10,9,12,6,146,162,180,185,145,177,174,679,688],
 [5,1,4,11,10,9,12,7,2,6,146,180,161,177],
 [5,1,4,11,10,9,12,7,2,6,155,160,140],
 [5,1,4,11,10,9,12,7,2,6,197,233,271,218,224,263],
 [5,1,4,11,10,9,12,7,6,146,180,185,161,177,174],
 [5,1,4,11,10,12,2,6,146,158,162,180,152,145,177,679,688],
 [5,1,4,11,10,12,2,6,146,158,162,180,161,152,145,177],
 [5,1,4,12,2,146,144,151,161,137,157,152,145,177,170,1001,
 689,1028,731,944,678,1022,749],
 [5,1,4,146,151,138,180,182,161,157,143,177,170,191,211,225,
 257,194,241,268,414,188,205,199,284],
 [5,1,8,3,176,144,158,138,185,181,137,152,143,174,204,225,
 198,242,268,296,210,199,274],
 [5,1,8,3,176,144,158,138,185,181,152,174,204,225,198,242,
 268,296,210,199,274,1086,865,1200,855],
 [5,1,8,7,3,176,158,138,185,181,152,143,174,191,204,198,
 194,242,296,188,210,274],
 [5,1,8,9,12,2,144,151,137,157,170,265,225,233,268,218,731,
 749,1000,1309,1522,1855,2349,2255,4531,5070,4376,4303,4522,
 8350,9330],
 [5,1,8,9,12,2,176,144,151,181,137,157,145,177,170,689,
 1028,731,678,1022,749],
 [5,1,8,9,12,2,176,144,151,182,181,137,157,145,177,689,
 1028,678,1022,1043,3370,3741],
 [5,1,8,9,12,6,144,151,185,137,157,265,225,233,268,218,199,
 263,1000,686,1705,1309,1857,2349,2255,2226],
 [5,1,8,9,12,7,3,2,176,144,151,181,137,157,170,731,749],
 [5,1,8,9,12,7,3,2,176,144,151,182,181,137,157,170],
 [5,1,8,9,12,7,3,6,176,144,151,185,181,137,157,174],
 [5,1,8,10,3,176,144,158,138,162,185,182,137,152,143,145,
 170,1014,1669,1041,1610],
 [5,1,8,10,7,3,6,176,144,158,138,185,137,152,143,174,1014,
 1041],
 [5,1,8,10,7,3,6,176,144,158,138,185,152,174,1014,1086,865,
 1200,855,5733,5268],
 [5,1,8,10,9,3,2,176,144,138,162,182,181,137,143,145,170],
 [5,1,8,10,9,3,176,144,138,162,185,182,181,137,143,145,174,
 170],
 [5,1,8,10,9,3,176,144,138,185,137,143,174,689,731,1014,
 1007,1153,678,749,1041,898,1043],
 [5,1,8,10,9,3,176,162,182,181,145,170,191,189,257,194,195,
 188,190,1695,1857,1947,2125,2058],
 [5,1,8,10,9,3,176,162,185,182,181,145,170,849,1191,1086,
 865,1669,858,1097,1200,855,1610],
 [5,1,8,10,9,12,3,6,139,159,156,144,185,137,174],
 [5,1,8,10,9,12,3,6,139,159,156,185,174,191,194,188],
 [5,1,8,10,9,12,3,6,139,159,156,191,257,194,414,188,284],
 [5,1,8,10,9,12,3,6,139,172,159,178,156,169],
 [5,1,8,10,9,12,3,6,172,178,169,176,162,181,145],
 [5,1,8,10,9,12,3,6,172,178,169,176,181,225,268,199],
 [5,1,8,10,9,12,3,6,172,178,169,265,225,219,268,232,199],
 [5,1,8,10,12,3,6,176,144,158,162,185,181,137,152,145,174],
 [5,1,8,10,12,7,3,6,176,144,158,185,181,152,174,1086,1200],
 [5,1,8,10,12,7,3,6,176,158,185,181,137,152,174,849,858],
 [5,1,8,11,3,6,176,151,158,138,162,157,152,143,145,174,732,
 1014,730,1041],
 [5,1,8,11,7,3,6,176,151,158,138,157,152,143,174,732,1014,
 730,1041],
 [5,1,8,11,7,148,163,141,176,158,138,233,257,218,414,263,
 284,1014,1312,1298,830,1113,1476,1375,4676,5877,3517],
 [5,1,8,11,7,176,158,185,181,152,174,204,189,233,198,242,
 195,218,296,210,190,263,274],
 [5,1,8,11,9,2,176,162,145,204,189,242,195,218,296,263,274,
 852,1279,1000,836,1492,1609,782,1375,4484,3517,5991,4394,
 5517,4519,9397,5938,7599,5764],
 [5,1,8,11,9,2,176,162,181,204,189,242,195,218,296,263,274,
 852,1279,836,1492,956,1045,1729,1522,3630,4236,5174,8873,
 5990,9162,8910,8870,7421,8497],
 [5,1,8,11,9,12,3,2,139,156,151,182,157,170,225,232],
 [5,1,8,11,9,12,3,2,139,159,151,182,157,170,219,199],
 [5,1,8,11,9,12,3,2,148,163,176,162,181,145,242,274],
 [5,1,8,11,9,12,3,2,163,141,176,162,181,145,204,296],
 [5,1,8,11,9,12,3,2,176,151,162,182,181,157,145,170],
 [5,1,8,11,10,6,176,158,138,162,180,185,145,177,174,1014,
 1099,865,1123,855,5733,5268],
 [5,1,8,11,10,7,3,6,176,158,138,185,152,143,174,1014,1041],
 [5,1,8,11,10,9,2,6,176,138,162,180,143,145,177,1014,1041],
 [5,1,8,11,10,9,12,2,6,176,162,180,181,145,177],
 [5,1,8,11,10,9,12,2,6,265,225,233,219,268,218,199,263,
 2349,2255,2226],
 [5,1,8,11,10,9,12,2,176,162,180,182,181,145,177,170],
 [5,1,8,11,10,9,12,3,2,6,139,159,156],
 [5,1,8,11,10,9,12,3,2,6,176,162,181,145],
 [5,1,8,11,10,9,12,3,2,6,265,225,219,268,232,199],
 [5,1,8,11,10,9,12,3,2,176,162,182,181,145,170],
 [5,1,8,11,10,9,12,3,176,162,185,182,181,145,174,170],
 [5,1,8,11,10,9,12,6,265,225,233,257,219,268,218,414,199,
 263,284,2349,2255,2226],
 [5,1,8,11,10,12,2,6,176,158,162,180,181,152,145,177],
 [5,1,8,11,10,12,2,6,265,211,225,233,219,241,268,218,205,
 199,263,2349,2255,2226],
 [5,1,8,11,10,12,3,2,176,158,162,182,152,145,170,1014,1041]
  ,[5,1,8,11,10,12,3,2,176,158,162,182,181,152,145,170],
 [5,1,8,11,10,12,3,6,176,158,162,185,181,152,174,1007,898],
 [5,1,8,11,10,12,3,176,158,162,185,182,181,152,145,170,
 1669,1610],
 [5,1,8,11,10,12,6,176,158,162,180,185,181,145,177,174,
 1099,1123],
 [5,1,8,11,10,12,6,176,158,162,180,185,181,174,1099,1007,
 1351,898,1247,3899,4154],
 [5,1,8,11,10,12,7,3,6,176,158,185,181,152,174],
 [5,1,8,11,10,12,7,3,176,158,185,182,181,152,170,1669,1610]
  ,[5,1,8,11,10,12,7,6,176,158,180,185,181,177,174,1099,
 1123],
 [5,1,8,11,12,3,176,151,158,162,182,181,152,145,170,732,
 953,1669,994,1610,4899,4171],
 [5,1,8,11,12,3,176,158,185,181,152,174,204,225,198,242,
 268,296,210,199,274],
 [5,1,8,11,12,7,3,6,176,151,158,181,157,152,174,732,730],
 [5,1,8,11,12,176,158,180,185,181,152,177,174,204,225,198,
 242,268,296,210,199,274],
 [5,1,8,11,176,158,162,185,152,174,204,189,233,198,242,195,
 210,190,263,274,1007,898,1000,1609,854,3643,2102,3404,2150,
 3138,2224],
 [5,1,8,11,176,158,162,185,152,174,204,189,233,198,242,195,
 210,190,263,274,1014,1041,1565,1313,960,1004,786,1522,3246,
 2981],
 [5,1,8,12,6,176,144,151,158,181,137,157,145,177,174,689,
 1028,732,678,1022,730,1123,4537,3755],
 [5,1,8,12,7,3,6,176,144,151,158,181,137,157,152,174,732,
 730],[5,1,8,12,7,3,6,176,158,181,137,157,152,174,849,
 1135,858,1088,730,3180,3361],
 [5,1,8,12,7,3,176,144,151,158,182,181,152,170,732,1086,
 953,1669,1200,994,1610,4899,4171],
 [5,1,8,12,176,158,162,180,185,181,152,145,177,174,191,204,
 198,194,242,296,188,210,274],
 [5,1,8,12,176,158,185,181,152,174,191,204,198,194,242,296,
 188,210,274,1007,1351,898,1247,783,852,1328,1614,1165,1004]
  ,[5,1,8,176,144,158,162,185,181,137,152,145,174,204,189,
 233,198,242,195,218,296,210,190,263,274],
 [5,1,9,2,146,144,151,138,161,143,170,265,225,233,268,218,
 232,199,263,731,1086,953,1200,994,1000,4138,3984,4298,4034]
  ,[5,1,9,7,3,176,146,138,182,181,161,143,170,191,204,257,
 194,242,414,188,210,284],
 [5,1,9,146,138,162,180,182,161,143,145,177,170,265,191,204,
 257,219,194,242,414,232,188,210,284],
 [5,1,9,146,138,182,143,170,265,191,204,257,194,242,188,210,
 284,679,688,783,852,1565,1313,686,1328,1614,1165,1004,652,
 1522,1855,3169,3406,3748,3246,3146,2981,3008,5893,7881,4952,
 5577,4522,8939,5757],
 [5,1,9,146,138,182,161,143,170,265,225,233,219,268,218,232,
 199,263,1669,1610,1374,1470,1459,1365,1133,836,1487,1547,
 1268,1311,1220,782,5929,3471,3071,3830,4385,2681],
 [5,1,9,146,144,151,138,182,161,137,157,143,170,265,225,233,
 219,268,218,232,199,263,732,730,686,1705,1857],
 [5,1,9,146,144,151,138,182,161,137,157,143,170,265,225,233,
 257,219,268,218,414,232,199,263,284],
 [5,1,9,146,182,143,265,191,204,219,194,242,414,232,188,210,
 284,1191,1153,1097,688,1043,783,852,1381,1328,1614,956,
 1045,1705,1165,1004,1522,1855,4012,4102,3630,4085,4236,4421]
  ,[5,1,9,176,146,138,182,161,143,170,191,204,257,194,242,
 414,188,210,284,1014,1041,783,852,1565,1313,1328,1614,956,
 1045,1165,1004,1522,1855],
 [5,1,10,3,2,139,159,156,146,144,170,211,189,241,195,205,
 190,731,1181,1459,1320,1487,781,1220,3530,4505,4132],
 [5,1,10,9,12,3,2,6,176,146,144,181,161,137,145,689,678],
 [5,1,10,9,12,3,2,6,265,197,191,219,271,194,268,232,224,
 188,199,2195,2189,2182],
 [5,1,10,9,12,3,144,137,174,170,265,197,219,271,268,232,
 224,1381,1279,1695,1664,652,786,1522,2195,2189,2182,5498,
 9352,4579],
 [5,1,10,9,12,3,176,146,144,181,161,137,145,174,170,689,
 732,731,678,730,749],
 [5,1,10,9,12,3,176,146,144,181,161,137,174,170,689,732,
 731,678,730,749,898,2819,2895],
 [5,1,10,9,12,6,139,159,180,185,177,174,197,191,219,271,
 194,199,955,1133,781,1220],
 [5,1,10,9,12,7,2,6,176,146,144,181,161,137,177,1028,1022],
 [5,1,11,9,12,3,2,6,176,146,151,162,181,161,157,145],
 [5,1,11,9,12,3,2,6,176,146,151,181,161,157,145,689,678],
 [5,1,11,9,12,3,151,157,174,170,265,197,268,232,224,1381,
 1279,1000,1181,1309,1533,652,786,1522,2195,2182,3471,3530,
 4385,4144,5498,9355,7611,4579,9348,9283],
 [5,1,11,9,12,3,176,146,151,162,181,161,157,174,170,732,
 731,730,749,898,2819,2895],
 [5,1,11,9,12,3,176,146,151,181,161,157,145,174,170,689,
 732,731,678,730,749],
 [5,1,11,9,12,7,2,6,176,146,151,180,181,161,157,177],
 [5,1,11,9,12,7,2,6,265,197,204,219,271,242,218,232,224,
 210,263,2232,2230,2334],
 [5,1,11,10,2,146,158,138,182,161,152,143,170,265,225,233,
 219,268,218,232,199,263],
 [5,1,11,10,6,176,158,138,185,181,152,143,174,197,225,233,
 271,268,218,224,199,263],
 [5,1,11,10,9,2,146,138,182,161,143,170,265,225,233,219,
 268,218,232,199,263],
 [5,1,11,10,9,7,3,2,176,146,182,181,161,143,170,1191,1097],
 [5,1,11,10,9,12,2,6,176,146,162,180,181,161,145,177],
 [5,1,11,10,9,12,2,6,176,146,180,181,161,177,689,1007,678,
 898],[5,1,11,10,9,12,2,6,176,162,180,181,145,177,894,
 679,997,688],
 [5,1,11,10,9,12,3,2,6,176,146,162,181,161,145],
 [5,1,11,10,9,12,3,2,6,176,146,181,161,145,689,678],
 [5,1,11,10,9,12,3,2,6,265,197,219,271,268,232,224,199,
 2195,2189,2182],
 [5,1,11,10,9,12,7,2,6,176,146,180,181,161,177],
 [5,1,11,10,9,12,7,2,6,265,197,219,271,218,232,224,263,
 2232,2230,2334],
 [5,1,11,10,9,146,138,185,182,161,143,174,170,265,225,233,
 219,268,218,232,199,263],
 [5,1,11,10,12,6,176,146,162,180,185,181,161,174,1001,1099,
 1007,1351,944,898,1247,3899,4154],
 [5,1,11,10,12,6,176,158,185,181,152,174,197,225,233,271,
 268,218,224,199,263],
 [5,1,11,10,12,6,176,162,180,185,181,145,177,174,894,679,
 1099,997,688,1123,3353,5675,3131,5770],
 [5,1,11,10,12,7,3,6,176,146,185,181,161,152,174,1001,944],
 [5,1,11,10,12,176,158,185,182,181,152,174,170,197,225,233,
 271,268,218,224,199,263],
 [5,1,12,6,176,158,181,152,174,197,225,233,268,218,224,199,
 263,849,1135,858,1088,1459,1365,1487,1547,1220,782,3180,
 3361,4614,3471,3830,4315,2681,9210,6894,9338],
 [5,1,12,7,3,176,146,158,185,181,161,152,174,191,204,198,
 194,242,296,188,210,274],
 [5,1,12,176,144,151,158,185,181,137,157,152,174,197,225,
 233,198,271,268,218,296,224,199,263,274],
 [5,1,12,176,144,151,158,185,181,137,157,152,174,197,225,
 233,271,268,218,224,199,263,731,1153,749,1043],
 [5,1,12,176,144,151,158,185,181,152,174,197,225,233,271,
 268,218,224,199,263,1086,953,1200,994,1279,960,1664,1729,
 786,1906],
 [5,1,12,176,146,158,185,181,161,152,174,191,204,198,194,
 242,296,188,210,274,1007,1351,898,1247,783,852,1328,1614,
 1165,1004],
 [5,1,12,176,158,162,180,185,181,152,145,177,174,197,191,
 204,198,271,194,242,296,224,188,210,274],
 [5,1,12,176,158,185,181,152,174,191,204,198,194,242,296,
 188,210,274,894,997,783,852,1565,1313,1328,1614,956,1045,
 1165,1004,1522,1855,4614,4610,3851,4315,4880,3874],
 [5,1,146,144,151,158,138,182,161,137,157,152,143,170,265,
 225,233,257,219,268,218,414,232,199,263,284],
 [5,1,176,158,138,162,180,185,181,152,143,145,177,174,197,
 191,204,198,271,194,242,296,224,188,210,274],
 [5,3,6,176,144,158,162,185,181,137,152,145,174,285,197,204,
 189,415,271,242,195,256,224,210,190],
 [5,4,6,175,146,151,138,180,184,161,157,143,177,191,211,225,
 257,194,241,268,414,188,205,199,284],
 [5,4,8,6,175,151,138,180,157,177,191,211,225,257,194,241,
 188,205,199,284,865,855,654,1694,1376,4599,1947,5140,2125,
 5906,2058],
 [5,4,8,7,6,175,151,158,180,184,157,152,177,191,189,257,
 194,195,414,188,190,284],
 [5,4,8,7,175,151,158,138,180,157,177,191,257,198,194,188,
 284,274,734,1099,865,1123,855,686,960,3126,3292,3071,4752,
 2681,4132],
 [5,4,8,7,175,151,158,138,180,184,157,152,143,177,191,257,
 198,194,414,296,188,284,274],
 [5,4,8,7,175,151,180,184,157,177,191,211,189,257,198,194,
 241,195,414,296,188,205,190,284,274],
 [5,4,8,7,175,151,180,184,157,177,191,257,198,194,414,296,
 188,284,274,1001,1191,944,1097,1312,1298,830,1113,1476,1375 
  ],[5,4,8,9,3,2,145,170,285,191,189,194,195,188,190,
 1470,783,1279,1365,1328,1664,1547,1165,786,1376,782,2022,
 2114,1939,9057,4543,4684,8372,5881,8500,4651,9163,7127,6921]
  ,[5,4,8,9,3,2,151,162,182,157,145,170,285,191,189,194,
 195,188,190,1707,1376,2022,2114,1939],
 [5,4,8,9,3,2,175,144,138,184,137,143,145,170,1135,689,731,
 953,1088,678,749,994],
 [5,4,8,9,3,2,175,144,138,184,137,143,204,225,198,268,296,
 199,274,1365,1311,2152,2183,2151],
 [5,4,8,9,3,2,175,144,151,138,162,182,184,137,157,143,145,
 170],
 [5,4,8,9,3,2,175,151,162,182,157,145,170,849,1191,734,
 1086,865,858,1097,735,1200,855],
 [5,4,8,9,7,2,6,175,144,151,138,184,137,157,143,177,1028,
 1022],
 [5,4,8,9,7,2,6,175,151,184,137,157,143,177,849,1191,858,
 1097,1022,5638,5323],
 [5,4,8,9,7,3,2,6,175,144,151,138,184,137,157,143],
 [5,4,8,9,7,3,2,6,285,191,204,189,194,242,195,256,188,210,
 190,2022,2114,1939],
 [5,4,8,9,7,6,175,144,151,138,184,137,157,143,174,1028,732,
 1022,730,1247,4273,4347],
 [5,4,8,9,7,6,175,144,151,138,185,184,137,157,143,174,1028,
 1351,1022,1247],
 [5,4,8,9,12,7,2,6,175,144,151,184,137,157,177,1028,1022],
 [5,4,8,9,12,175,151,162,180,184,157,145,177,191,257,198,
 194,414,296,188,284,274],
 [5,4,8,9,175,151,162,180,182,184,157,145,177,170,191,189,
 257,194,195,414,188,190,284],
 [5,4,8,9,175,151,162,180,182,184,157,177,191,189,257,194,
 195,414,188,190,284,1007,1153,898,1043],
 [5,4,8,9,175,151,180,184,157,177,191,189,225,257,198,194,
 195,268,414,296,188,190,199,284,274],
 [5,4,8,10,3,6,175,138,143,225,257,194,241,188,205,199,284,
 1374,780,654,1565,686,1165,652,1376,4538,3730,4789,4666,
 8354,4813,9229,9198,7034,8108],
 [5,4,8,10,7,3,2,6,175,144,158,138,137,152,143,734,735],
 [5,4,8,10,7,3,2,6,175,144,158,138,184,137,152,143],
 [5,4,8,10,7,3,175,144,158,138,185,182,152,143,174,170,734,
 1086,735,1200],
 [5,4,8,10,7,3,175,144,158,138,185,182,184,174,170,1086,
 1099,865,1123,855,3982,3776],
 [5,4,8,10,9,7,3,2,6,175,144,138,184,137,143],
 [5,4,8,10,9,7,3,2,6,285,191,189,194,195,256,188,190,2022,
 2114,1939],
 [5,4,8,10,9,7,3,6,175,144,138,185,184,137,143,174],
 [5,4,8,11,7,2,6,175,151,158,138,180,157,152,143,177,734,
 735],[5,4,8,11,7,2,6,175,151,158,138,180,157,177,734,
 1099,865,1123,855,3126,3292],
 [5,4,8,11,7,3,175,151,158,138,185,182,152,143,174,170,734,
 953,735,994],
 [5,4,8,11,9,7,2,6,175,151,138,180,184,157,177,865,855],
 [5,4,8,11,9,7,2,6,175,151,180,184,157,143,177,1191,1097],
 [5,4,8,11,9,7,3,2,148,163,141,175,138,184,143],
 [5,4,8,11,9,7,3,2,148,163,141,175,184,189,195,190],
 [5,4,8,11,9,7,3,2,148,163,141,285,189,415,195,256,190],
 [5,4,8,11,9,7,3,2,168,148,179,163,173,141],
 [5,4,8,11,9,7,3,2,168,179,173,151,182,157,170],
 [5,4,8,11,9,7,3,2,168,179,173,182,170,204,242,210],
 [5,4,8,11,9,7,3,2,168,179,173,204,198,242,296,210,274],
 [5,4,8,11,9,12,2,6,175,151,162,180,184,145,177,953,994],
 [5,4,8,11,9,12,2,175,151,162,180,182,184,145,177,170,953,
 994],[5,4,8,11,9,12,7,2,6,175,151,180,184,157,177],
 [5,4,8,11,9,12,7,2,175,151,180,182,184,157,177,1153,1043],
 [5,4,8,11,10,3,2,6,175,158,138,162,152,143,145,734,735],
 [5,4,8,11,10,7,2,6,175,158,138,180,184,152,143,177],
 [5,4,8,11,10,7,3,2,6,175,158,138,152,143,734,735],
 [5,4,8,11,10,7,3,2,6,175,158,138,184,152,143],
 [5,4,8,11,10,7,3,175,158,138,185,182,152,143,174,170,734,
 735],[5,4,8,11,10,9,7,3,2,6,168,179,173],
 [5,4,8,11,12,2,175,151,158,162,180,182,177,734,953,1099,
 1007,1153,1123,898,1043,3126,3357,3292,3311],
 [5,4,8,11,12,7,2,6,175,151,158,180,157,152,177,734,735],
 [5,4,8,12,6,175,151,180,184,157,177,191,211,225,257,194,
 241,268,414,188,205,199,284],
 [5,4,8,12,7,2,6,175,144,151,158,137,157,152,177,1028,734,
 1022,735],
 [5,4,8,12,175,180,184,157,177,191,211,194,241,268,414,188,
 205,199,284,1135,1088,783,1381,1279,1664,956,1705,1729,786,
 1906,3425,3824],
 [5,4,9,7,3,2,6,285,197,191,204,189,194,242,195,256,224,
 188,210,190,2022,5587,2114,5935,1939,4648],
 [5,4,9,7,3,6,144,137,174,285,197,204,189,242,195,256,224,
 1381,654,1181,687,1533,652,782,1375,3471,4385,4684,8561,
 4651,4627,9396,9364,9306,9289],
 [5,4,10,3,175,146,138,182,161,170,191,211,225,257,194,241,
 268,414,199,284,865,855,654,1133,1559,1694,1376,1220,1476],
 [5,4,10,3,175,146,182,161,143,170,191,211,194,241,268,414,
 188,205,199,284,1191,1097,783,1381,654,1694,956,1705,1376],
 [5,4,10,175,146,138,180,182,184,161,143,177,170,191,211,
 225,257,194,241,268,414,188,205,199,284],
 [5,4,11,9,7,2,6,175,146,151,138,180,184,161,157,143,177],
 [5,4,11,9,7,2,148,163,141,146,161,285,189,233,415,195,218,
 256,190,263],
 [5,4,11,9,7,2,148,163,141,175,146,184,161,189,233,195,218,
 190,263],
 [5,4,11,9,7,2,148,163,141,175,146,184,161,233,218,263,
 1191,1097,1298,1113,1375],
 [5,4,11,9,7,2,148,163,141,175,180,184,177,189,195,190,894,
 997,1181,1320,781],
 [5,4,11,9,7,2,148,163,141,175,184,197,189,233,271,195,218,
 224,190,263],
 [5,4,11,9,7,2,148,163,141,175,184,197,233,271,218,224,263,
 1212,1298,1492,1113,1461,1375],
 [5,4,11,9,7,2,148,163,141,180,177,285,189,415,195,256,190,
 1517,1181,955,1320,1533,781],
 [5,4,11,9,7,2,155,148,160,163,140,141,175,184,189,195,190]
  ,[5,4,11,9,7,2,155,148,160,163,140,141,285,189,415,195,
 256,190],
 [5,4,11,9,7,2,155,160,140,151,157,285,189,198,415,195,296,
 256,190,274],
 [5,4,11,9,7,2,155,160,140,175,151,184,157,189,198,195,296,
 190,274],
 [5,4,11,9,7,2,155,160,140,175,151,184,157,198,296,274,
 1191,1097,1298,1113,1375],
 [5,4,11,9,7,2,155,160,140,175,182,184,170,189,195,190,
 1135,1088,1365,1547,782],
 [5,4,11,9,7,2,155,160,140,175,184,204,189,198,242,195,296,
 210,190,274],
 [5,4,11,9,7,2,155,160,140,175,184,204,198,242,296,210,274,
 1212,1298,1492,1113,1461,1375],
 [5,4,11,9,7,2,155,160,140,182,170,285,189,415,195,256,190,
 1470,1365,836,1547,1311,782],
 [5,4,11,9,7,2,168,148,179,163,173,141,146,161,233,218,263]
  ,[5,4,11,9,7,2,168,148,179,163,173,141,180,177,197,271,
 224],[5,4,11,9,7,2,168,155,148,179,160,163,173,140,141 
  ],[5,4,11,9,7,2,168,155,179,160,173,140,151,157,198,
 296,274],
 [5,4,11,9,7,2,168,155,179,160,173,140,182,170,204,242,210]
  ,[5,4,11,9,7,2,168,179,173,146,161,204,198,242,296,210,
 274,852,1313,1614,1045,1004,1855],
 [5,4,11,9,7,2,168,179,173,146,182,161,170,204,242,210,
 1351,1247,852,1614,1004],
 [5,4,11,9,7,2,168,179,173,151,157,197,233,271,218,224,263,
 1279,960,1664,1729,786,1906],
 [5,4,11,9,7,2,168,179,173,151,180,157,177,197,271,224,
 1153,1043,1279,1664,786],
 [5,4,11,9,7,2,168,179,173,180,177,197,204,198,271,242,296,
 224,210,274],
 [5,4,11,9,7,2,168,179,173,180,182,177,170,197,204,271,242,
 224,210],
 [5,4,11,9,7,2,168,179,173,182,170,197,204,233,271,242,218,
 224,210,263],
 [5,4,11,9,7,2,168,179,173,197,204,233,198,271,242,218,296,
 224,210,263,274],
 [5,4,11,9,7,2,285,197,204,189,233,198,415,271,242,195,218,
 296,256,224,210,190,263,274],
 [5,4,11,9,7,3,2,6,175,146,184,161,157,143,1135,1191,1088,
 1097],
 [5,4,11,9,7,3,2,6,285,197,204,189,415,271,242,195,256,
 224,210,190],
 [5,4,11,9,12,7,2,6,175,151,180,184,161,157,177,894,997],
 [5,4,11,9,12,7,2,175,146,151,180,182,184,161,157,177,170],
 [5,4,11,10,9,7,2,6,155,160,140,175,138,184,143],
 [5,4,11,10,9,7,2,6,155,160,140,175,184,189,195,190],
 [5,4,11,10,9,7,2,6,155,160,140,285,189,415,195,256,190],
 [5,4,11,10,9,7,2,6,168,155,179,160,173,140],
 [5,4,11,10,9,7,2,6,168,179,173,146,180,161,177],
 [5,4,11,10,9,7,2,6,168,179,173,180,177,197,271,224],
 [5,4,11,10,9,7,2,6,168,179,173,197,233,271,218,224,263],
 [5,4,11,10,9,7,2,175,146,138,180,182,184,161,143,177,170],
 [5,4,11,10,9,12,2,285,197,225,233,198,415,271,268,218,296,
 199,263,274,5116,2168,3451,2160,4004,2202],
 [5,4,11,10,9,12,7,2,285,197,233,198,415,271,218,296,256,
 224,263,274],
 [5,4,12,6,175,146,151,184,157,177,191,211,225,257,268,414,
 188,205,199,284,1028,1022,1181,1459,1312,1320,1268,1352,781 
  ],[5,4,12,7,2,6,175,146,144,151,158,161,137,157,152,
 177,1028,734,1022,735],
 [5,4,12,175,146,151,180,182,184,161,157,177,170,191,211,
 225,257,194,241,268,414,188,205,199,284],
 [5,7,3,6,176,158,181,137,152,174,285,197,204,189,242,195,
 256,224,210,190,849,858,1381,1695,652,2022,5587,2114,5935,
 1939,4648],
 [5,7,175,176,146,151,158,138,180,184,181,161,157,152,143,
 177,191,257,198,194,414,296,188,284,274],
 [5,7,176,151,158,138,185,181,157,152,143,174,285,197,191,
 233,198,415,271,194,218,296,256,224,188,263,274],
 [5,7,176,158,180,185,182,181,152,177,174,170,285,197,191,
 204,189,415,271,194,242,195,256,224,188,210,190],
 [5,8,3,175,176,144,158,138,185,181,137,152,143,174,204,225,
 198,242,268,296,210,199,274,734,735],
 [5,8,3,175,176,144,158,138,185,184,181,137,152,143,174,204,
 225,198,242,268,296,210,199,274],
 [5,8,3,175,176,158,185,184,181,152,174,191,204,189,225,198,
 194,242,195,268,296,188,210,190,199,274],
 [5,8,3,176,151,158,162,185,182,181,152,145,174,170,285,191,
 189,415,194,195,256,188,190,953,994],
 [5,8,3,176,158,162,185,182,181,152,145,174,170,285,191,204,
 189,415,194,242,195,256,188,210,190],
 [5,8,3,176,158,185,181,152,174,204,225,198,242,268,296,210,
 199,274,1596,1651,1374,1212,654,1459,1298,1133,1492,1694,
 1487,1113,1268,1461,1376,1220,1375],
 [5,8,3,176,158,185,181,152,174,285,191,189,415,194,195,256,
 188,190,1007,1153,898,1043,1470,783,1279,1365,836,1328,
 1664,1547,1311,1165,786,782],
 [5,8,7,3,6,176,151,158,185,181,157,152,174,285,191,189,
 415,194,195,256,188,190],
 [5,8,9,2,175,144,151,138,180,184,157,177,265,225,198,219,
 268,296,232,199,274,1086,865,1200,855],
 [5,8,9,2,175,151,180,184,157,177,265,191,189,225,198,219,
 194,195,268,296,232,188,190,199,274],
 [5,8,9,3,175,176,144,151,138,162,185,182,184,181,137,157,
 143,145,174,170],
 [5,8,9,7,6,175,176,151,180,184,181,157,177,191,189,257,
 194,195,414,188,190,284],
 [5,8,9,175,144,151,138,180,184,137,157,143,177,265,225,257,
 198,219,268,414,296,232,199,284,274],
 [5,8,9,175,144,151,138,180,185,184,137,157,143,177,174,265,
 225,198,219,268,296,232,199,274],
 [5,8,9,175,144,151,138,180,185,184,137,157,143,177,265,225,
 198,219,268,296,232,199,274,1669,1610],
 [5,8,9,175,151,180,184,157,177,191,189,257,194,195,414,188,
 190,284,1256,1342,783,1279,1000,1565,960,1328,1664,1609,
 956,1729,1165,786,854,1522,1906],
 [5,8,9,175,151,180,184,157,177,265,225,198,219,268,296,232,
 199,274,732,730,1374,1212,1459,1298,686,1133,1492,1487,
 1113,1705,1268,1461,1220,1375,1857],
 [5,8,9,175,176,151,162,180,182,184,181,157,177,191,189,257,
 194,195,414,188,190,284,1007,1153,898,1043],
 [5,8,9,175,176,151,180,184,181,157,177,191,189,225,257,198,
 194,195,268,414,296,188,190,199,284,274],
 [5,8,9,175,180,265,191,189,257,219,194,195,188,190,284,
 1135,734,1351,735,1247,783,1279,1365,1565,686,960,1328,
 1664,1547,1165,652,786,782,1522,1906,4080,4454,2349,2255,
 2226,3246,4763,2981,3792],
 [5,8,10,3,176,158,162,185,182,152,145,174,170,285,191,189,
 415,256,188,190,1014,1041,1459,1298,1268,1461],
 [5,8,10,3,176,158,162,185,182,181,152,145,174,170,285,191,
 189,415,194,195,256,188,190],
 [5,8,10,7,3,6,175,144,158,138,185,137,152,143,174,1256,
 734,1014,735,1041,4875,4310],
 [5,8,10,7,3,6,175,144,158,138,185,184,137,152,143,174,
 1256,1014,1342,1041],
 [5,8,10,7,6,176,158,180,185,181,152,177,174,285,191,189,
 415,194,195,256,188,190],
 [5,8,10,9,3,2,175,144,138,184,137,143,145,170,1256,689,
 731,1014,1342,678,749,1041],
 [5,8,10,9,3,2,175,176,144,138,162,182,184,181,137,143,145,
 170],
 [5,8,10,9,3,2,176,144,138,162,182,181,145,170,1596,734,
 1086,865,1651,735,1200,855],
 [5,8,10,9,3,2,176,162,182,181,145,170,285,194,195,188,190,
 1374,1212,1707,1487,1113,1376,2114,1939,9039,5218],
 [5,8,10,9,7,3,2,6,175,176,144,138,184,181,137,143],
 [5,8,10,9,7,3,2,6,176,144,138,184,181,137,143,1596,1651],
 [5,8,10,9,7,6,175,176,138,180,185,184,181,137,177,174,849,
 865,858,855],
 [5,8,10,9,12,3,2,6,175,176,144,162,184,181,137,145],
 [5,8,10,9,12,6,175,176,162,180,185,184,181,177,174,849,
 1086,1007,858,898,3982,3776],
 [5,8,10,9,12,6,175,176,162,184,181,233,257,194,218,414,
 263,284,1374,1565,1487,956,1522,2682,2574,2424],
 [5,8,11,7,3,2,6,285,265,204,211,415,219,242,241,256,232,
 210,205,190,2400,8880,2533,5608,2672,5554],
 [5,8,11,7,3,2,175,176,138,143,204,211,242,241,210,205,274,
 1279,654,1000,1694,1609,1376,854,2102,2150,2224,4394,4519,
 5619],
 [5,8,11,9,12,2,175,162,180,182,184,181,145,177,170,1256,
 953,1342,1088,994,3876,4152],
 [5,8,11,9,12,2,175,176,162,180,182,184,181,177,1135,953,
 1007,1153,1088,898,1043,3357,3311],
 [5,8,11,9,12,7,2,6,175,176,180,184,181,157,177,1135,1088],
 [5,8,11,9,12,175,151,180,185,184,157,177,174,265,225,198,
 219,268,296,232,199,274],
 [5,8,11,10,9,3,2,6,175,176,138,162,184,181,143,145],
 [5,8,11,10,9,7,3,2,6,175,176,138,184,181,143],
 [5,8,11,10,9,7,3,2,6,285,265,415,219,195,256,232,190,
 2400,2533,2672],
 [5,8,11,10,9,12,3,2,6,175,176,162,184,181,145],
 [5,8,11,10,9,12,3,2,175,176,162,182,184,181,145,170],
 [5,8,11,12,2,175,151,158,180,184,157,152,177,265,225,198,
 219,268,296,232,199,274],
 [5,8,11,12,3,2,175,176,162,145,204,211,242,241,274,1279,
 654,1000,836,1559,1694,1609,782,1476,2102,2150,4141,4484,
 5072,3517,4394,7309,4519,5365,5938,5764],
 [5,9,12,2,6,175,144,151,180,184,137,157,177,265,197,225,
 219,271,268,232,224,199],
 [5,9,12,7,2,6,175,176,146,184,181,161,137,157,177,849,
 1135,858,1088,1022,5638,5323],
 [5,9,12,7,175,176,146,151,180,184,181,161,157,177,191,257,
 198,194,414,296,188,284,274],
 [5,9,12,175,144,151,180,184,137,157,177,265,197,225,219,
 271,268,232,224,199,1669,1153,1610,1043,1381,1279,1695,
 1664,652,786],
 [5,9,12,175,151,180,184,181,161,157,177,191,257,198,194,
 414,296,188,284,274,1256,894,1342,997,783,1565,1328,956,
 1165,1522],
 [5,9,12,175,151,180,185,182,184,157,177,174,170,265,197,
 191,225,219,271,194,268,232,224,188,199],
 [5,9,12,175,176,146,151,180,184,181,161,157,177,191,225,
 257,198,194,268,414,296,188,199,284,274],
 [5,9,12,175,176,146,151,180,184,181,161,157,177,191,257,
 198,194,414,296,188,284,274,689,1007,678,898],
 [5,10,9,3,2,146,144,138,182,161,137,143,170,285,265,225,
 415,219,268,256,232,199],
 [5,10,9,7,175,176,146,182,184,181,161,170,191,194,218,414,
 263,284,1191,1097,852,1381,1113,1045,1705,1375,2574,2424,
 5235,7373,8631,7819],
 [5,10,9,146,138,180,185,182,161,143,170,285,265,225,415,
 219,268,256,232,199,1351,1669,1247,1610,1374,1459,1133,
 1487,1268,1220],
 [5,10,9,146,138,180,185,182,161,143,177,174,170,285,265,
 191,225,415,219,194,268,256,232,188,199],
 [5,10,9,175,176,146,138,182,184,181,161,143,170,191,225,
 233,257,194,268,218,414,188,199,263,284],
 [5,10,9,175,176,146,138,182,184,181,161,143,170,191,233,
 257,194,218,414,188,263,284,689,678,1565,956,1522],
 [5,10,12,176,144,158,162,185,181,137,152,145,174,285,197,
 233,198,415,271,218,296,256,224,263,274],
 [5,11,2,6,175,151,180,157,177,265,197,225,219,271,232,224,
 199,1099,865,1123,855,780,1212,1559,1492,1352,1461,3126,
 3292,2702,4326,4141,3730,4805,8849,8449,8557],
 [5,11,3,2,146,138,182,161,143,170,285,265,204,211,225,415,
 219,242,241,268,256,232,210,205,199],
 [5,11,3,2,146,138,182,161,143,170,285,265,225,415,219,268,
 256,232,199,953,1099,994,1123,1470,780,836,1559,1311,1352],
 [5,11,3,6,176,158,185,152,145,174,285,197,204,189,415,271,
 256,224,210,190,1014,1041,783,1365,1298,1328,1311,1461,1165 
  ],[5,11,7,2,6,175,176,146,158,138,180,157,152,143,177,
 1135,734,1014,679,735,1041,688,4080,4454],
 [5,11,7,3,6,176,158,185,181,152,174,285,197,204,189,415,
 271,242,195,256,224,210,190],
 [5,11,9,7,3,2,6,285,265,197,415,219,271,242,195,256,232,
 224,210,190,4486,2400,4883,2533,4131,2672],
 [5,11,9,12,2,6,175,151,180,184,157,177,265,197,225,219,
 271,268,232,224,199],
 [5,11,9,12,2,6,175,162,180,184,181,161,145,177,1256,894,
 953,1342,997,1088,994,3876,4152],
 [5,11,9,12,2,6,175,176,146,180,184,181,161,177,1135,689,
 1007,1088,678,898,6059,3357,5398,3311],
 [5,11,9,12,7,2,6,175,176,146,180,184,181,161,157,177,1135,
 1088],
 [5,11,9,12,7,2,6,175,180,184,181,161,157,177,1256,894,
 1342,997,1088,3876,4152],
 [5,11,9,12,175,151,180,184,157,177,265,197,225,219,271,268,
 232,224,199,1669,1153,1610,1043,1381,1279,1695,1664,652,786 
  ],[5,11,10,3,2,6,176,146,158,138,152,143,145,1596,689,
 1014,679,735,1041,688,3943,6077,3886,5165,3952,8995,7542],
 [5,11,10,7,2,6,158,138,184,152,143,265,197,219,271,232,
 224,263,1868,1313,1707,687,1004,2232,2230,2334],
 [5,11,10,9,2,6,160,140,175,176,184,181,197,195,268,218,
 190,199,1212,783,1113,956],
 [5,11,10,9,3,2,175,176,146,182,184,181,161,145,170,1191,
 689,1097,678,855,4187,3901],
 [5,11,10,9,7,3,2,6,175,176,146,184,181,161,143,1191,1097],
 [5,11,10,9,7,3,2,6,285,265,197,415,219,271,195,256,232,
 224,190,2400,2533,2672],
 [5,11,10,9,7,3,2,175,176,146,182,184,181,161,143,170,1191,
 1097],
 [5,11,10,9,7,6,175,176,180,185,184,181,161,177,174,894,
 865,997,1097,855,3986,4217],
 [5,11,10,9,7,6,180,185,161,177,174,285,265,415,219,195,
 256,232,1517,955,1492,1533,1375,2400,2533,2672],
 [5,11,10,9,7,175,176,146,182,184,181,161,143,177,174,1191,
 1028,732,1097,1022,730,1043,3370,3741],
 [5,11,10,9,12,2,162,181,145,285,197,415,271,218,296,263,
 274,1873,1707,1032,955,1045,1729,1376,781,4298,4034,4618,
 9097,5957,5437,7595,8660,5659,7832],
 [5,11,10,9,12,3,2,6,175,176,146,184,181,161,145,689,678],
 [5,11,10,9,12,7,2,6,285,265,197,415,219,271,218,256,232,
 224,263,2232,2230,2334],
 [5,11,10,9,12,7,2,285,265,197,415,219,271,218,296,256,232,
 224,263,274,2232,5459,2230,6051,2334,8597],
 [5,11,10,9,146,138,180,185,182,161,143,177,174,170,285,265,
 225,415,219,268,256,232,199],
 [5,11,10,12,7,176,158,185,181,152,174,285,197,233,198,415,
 271,218,296,256,224,263,274],
 [5,11,10,12,176,158,185,152,174,285,197,233,198,415,271,
 256,224,263,274,1014,1041,783,1565,1313,960,1328,1165,1004,
 786,1522,3246,2981],
 [5,11,146,151,158,138,180,185,182,161,157,152,143,177,174,
 170,285,265,225,415,219,268,256,232,199],
 [5,11,175,176,146,158,185,184,181,161,152,174,204,189,225,
 233,198,242,195,268,218,296,210,190,199,263,274],
 [5,11,176,151,158,138,185,181,157,152,143,174,285,197,225,
 233,198,415,271,268,218,296,256,224,199,263,274],
 [7,2,6,175,146,151,138,180,184,161,157,143,177,275,265,191,
 211,297,219,194,241,196,232,188,205],
 [8,3,2,6,171,144,151,158,162,183,137,157,152,145,285,265,
 189,415,219,195,256,232,190],
 [8,3,2,171,144,138,162,183,137,143,145,204,211,198,242,241,
 296,210,205,274,1596,1256,1651,1342,654,1000,1694,1609,
 1376,854],
 [8,3,2,171,144,151,158,162,182,183,137,157,152,145,170,285,
 265,189,415,219,195,256,232,190],
 [8,3,2,171,144,162,182,183,137,145,170,285,265,204,211,189,
 415,219,242,241,195,256,232,210,205,190],
 [8,3,2,171,144,162,183,137,145,170,285,265,189,415,219,195,
 256,232,190,731,749,1470,780,1365,1312,836,1559,1547,830,
 1311,1352,782,1476],
 [8,3,2,171,175,176,144,162,183,184,181,137,145,204,211,189,
 198,242,241,195,296,210,205,190,274],
 [8,6,171,175,176,151,180,183,184,181,157,177,191,211,189,
 225,257,194,241,195,268,414,188,205,190,199,284],
 [8,6,175,144,151,158,180,184,137,157,152,177,275,265,189,
 225,257,297,219,195,268,414,196,232,190,199,284],
 [8,6,176,144,151,158,162,180,185,181,137,157,152,145,177,
 174,275,285,189,297,415,195,196,256,190],
 [8,7,3,6,176,144,151,158,185,181,137,157,152,174,275,285,
 189,297,415,195,196,256,190],
 [8,7,3,6,176,158,181,137,157,152,174,275,285,189,195,196,
 256,190,849,1135,858,1088,730,962,687,3180,3361,3808,2702,
 4776,3093],
 [8,7,3,6,176,158,185,181,152,174,275,285,189,297,415,195,
 196,256,190,1086,953,1200,994,1374,1470,1133,836,1268,1311]
  ,[8,7,3,6,176,158,185,181,152,174,275,285,191,204,189,
 297,415,194,242,195,196,256,188,210,190],
 [8,7,3,176,158,138,185,181,152,143,174,275,285,191,204,198,
 297,415,194,242,296,196,256,188,210,274],
 [8,7,3,176,158,185,181,152,174,275,285,189,297,415,195,196,
 256,190,1153,1043,1374,1470,1459,1365,1133,836,1487,1547,
 1268,1311,1220,782,5823,3530,4752,4505,4144,4132],
 [8,7,3,176,158,185,182,181,152,174,170,275,285,189,297,415,
 195,196,256,190,1086,953,1200,994,1374,1470,1133,836,1268,
 1311],
 [8,7,3,176,158,185,182,181,152,174,170,275,285,191,204,189,
 297,415,194,242,195,196,256,188,210,190],
 [8,7,3,176,158,185,183,184,181,152,174,191,204,198,194,242,
 296,188,210,274,1049,1596,1152,1651,1212,1298,1492,1113,
 1461,1375],
 [8,10,9,3,2,6,171,144,162,183,137,145,285,265,189,415,219,
 195,256,232,190],
 [8,10,9,6,171,162,180,185,183,145,177,174,285,265,415,219,
 195,190,1086,1200,1374,1707,1032,1133,1376,854,2400,2533,
 9191,5670,8661,9420],
 [8,10,9,12,3,2,6,175,176,144,162,183,184,181,137,145,1049,
 1152],[8,10,9,12,6,175,176,144,162,180,185,183,145,177,
 174,1049,734,1014,1086,735,1041,1200,3720,3424],
 [8,10,12,7,3,2,6,285,191,211,297,415,219,194,241,196,256,
 232,188,205,4229,5792,3953,8402,3410,4459],
 [8,11,9,12,6,175,151,180,184,157,177,275,265,225,257,297,
 219,268,414,196,232,199,284],
 [8,11,9,12,175,180,182,184,157,177,275,265,297,219,268,414,
 196,232,199,284,1135,1088,783,1381,956,1705,1729,1906,3425,
 3824],
 [8,11,9,12,175,180,182,184,157,177,275,265,297,219,268,414,
 196,232,199,284,1153,1043,1470,836,1311,2195,3946,2189,
 3691,2182,5984],
 [8,11,10,3,2,6,139,156,158,138,152,143,275,285,225,196,
 256,232,790,654,962,687],
 [8,11,10,3,2,6,142,147,138,162,143,145,285,265,211,196,
 256,232,654,1000,687,1309],
 [8,11,10,6,176,158,162,180,185,181,152,145,177,174,275,285,
 189,297,415,195,196,256,190],
 [8,11,10,7,3,176,158,185,182,181,152,174,170,275,285,189,
 297,415,195,196,256,190],
 [8,11,12,7,3,2,6,175,176,151,158,183,184,181,157,152,1049,
 1152],
 [8,11,12,7,3,2,6,285,265,204,211,415,219,242,241,196,256,
 232,210,205,4229,2185,3953,2218,3410,2101],
 [8,12,3,2,171,144,162,183,137,145,204,211,198,242,241,296,
 210,205,274,1596,1256,1651,1342,654,1000,1694,1609,1376,854 
  ],[8,12,3,2,171,175,176,144,162,183,184,181,137,145,204,
 211,198,242,241,296,210,205,274],
 [8,12,7,2,6,142,164,147,137,157,177,285,265,415,219,256,
 232,1022,1374,1470,1133,836,1268,1311,3448,4912,4303],
 [8,12,7,2,6,175,151,180,184,157,177,275,265,191,211,297,
 219,194,241,196,232,188,205],
 [8,12,7,2,175,180,184,157,177,170,275,265,297,219,194,241,
 196,232,188,205,1135,1088,1374,780,1664,1487,830,786,5823,
 4505],
 [8,12,7,3,171,175,176,158,185,183,184,181,152,174,191,204,
 198,194,242,296,188,210,274],
 [8,12,7,3,176,158,185,181,152,174,275,285,191,204,198,297,
 415,194,242,296,196,256,188,210,274],
 [8,12,171,175,176,144,162,180,185,183,184,181,137,145,177,
 174,204,211,198,242,241,296,210,205,274],
 [8,12,171,175,176,151,180,183,184,181,157,177,191,211,225,
 257,198,194,241,268,414,296,188,205,199,284,274],
 [8,12,171,175,176,158,162,180,185,183,184,181,152,145,177,
 174,191,204,198,194,242,296,188,210,274],
 [8,12,175,144,151,158,180,184,137,157,152,177,275,265,225,
 257,198,297,219,268,414,296,196,232,199,284,274],
 [9,2,171,144,151,138,162,183,137,157,143,145,285,265,197,
 233,198,415,219,271,218,296,256,232,224,263,274],
 [9,2,171,144,162,180,182,183,137,145,177,170,285,265,197,
 204,189,415,219,271,242,195,256,232,224,210,190],
 [9,2,171,175,146,144,151,138,180,183,184,161,137,157,143,
 177,265,225,198,219,268,296,232,199,274],
 [9,3,2,6,171,144,183,137,145,285,197,204,189,242,195,256,
 224,210,190,689,678,1873,654,1000,1181,1609,687,1309,1533,
 854,3025,3121],
 [9,3,6,171,176,144,162,185,183,181,137,145,174,285,197,204,
 189,415,271,242,195,256,224,210,190],
 [9,12,171,175,151,180,185,182,183,184,157,177,174,170,265,
 197,191,225,219,271,194,268,232,224,188,199],
 [9,12,171,175,176,146,144,162,183,184,181,161,137,145,204,
 233,257,198,242,218,414,296,210,263,284,274],
 [9,171,144,151,138,162,183,137,157,143,145,285,265,197,233,
 257,198,415,219,271,218,414,296,256,232,224,263,284,274],
 [10,2,6,144,183,145,285,211,189,233,415,241,195,218,205,
 190,263,1049,689,1086,1152,1200,1873,1517,1000,1181,1707,
 1032,955,1609,1320,1376,854,781,3886,3952,4298,4030,4034,
 3389],
 [10,2,6,171,144,158,138,162,183,137,152,143,145,265,197,
 233,219,271,218,232,224,263,734,735,1868,1707,687],
 [10,2,6,171,144,158,138,162,183,137,152,143,145,285,265,
 197,233,415,219,271,218,256,232,224,263],
 [10,2,6,171,144,162,183,137,145,177,285,211,189,415,241,
 195,256,205,190,1028,1022,1873,1517,1000,1181,1032,955,
 1609,1320,1309,1533,854,781],
 [10,2,6,171,144,162,183,137,145,265,197,233,219,271,218,
 232,224,263,1596,1651,780,1212,1312,1298,1559,1492,830,
 1113,1352,1461,1476,1375,2702,4538,4141,3093,3730,5072],
 [10,2,6,171,144,183,137,145,285,211,189,241,195,256,205,
 190,263,689,678,1873,1517,654,1000,1181,1609,1320,687,1309,
 1533,854,781,3643,3404,3138,3025,2994,3121,3284,4618,5991,
 5517,8692,5759,5465,7296],
 [10,2,6,171,176,146,144,162,183,181,161,137,145,285,211,
 189,233,415,241,195,218,256,205,190,263],
 [10,3,2,6,171,144,183,137,145,285,211,189,241,195,256,205,
 190,689,678,1873,1517,654,1000,1181,1609,1320,687,1309,
 1533,854,781,3025,2994,3121,3284],
 [10,3,2,6,171,144,183,137,145,285,211,189,241,195,256,205,
 190,1256,894,1342,997,1000,1181,1609,1320,854,781,2894,
 2992,2702,4531,3990,3093,4805,5366,5218,9359],
 [10,3,2,6,171,176,146,144,162,183,181,161,137,145,285,211,
 189,415,241,195,256,205,190],
 [10,3,146,138,162,185,182,161,143,145,174,170,275,285,265,
 191,211,297,415,219,194,241,196,256,232,188,205],
 [10,3,146,144,158,138,182,161,137,152,143,170,275,285,265,
 225,257,297,415,219,268,414,196,256,232,199,284],
 [10,3,171,176,146,144,162,185,182,183,181,161,137,145,174,
 170,285,211,189,415,241,195,256,205,190],
 [10,3,171,176,146,158,162,185,182,183,181,161,152,145,174,
 170,285,191,189,415,194,195,256,188,190],
 [10,7,2,175,146,138,180,182,184,161,143,177,170,275,265,
 191,211,297,219,194,241,196,232,188,205],
 [10,7,3,2,146,138,182,184,161,170,275,265,191,211,297,219,
 194,241,188,205,865,855,1868,1725,1707,1032,1278,854,3433,
 3640],
 [10,7,3,2,146,182,161,143,170,275,265,297,219,194,241,196,
 232,188,205,1191,1097,1868,1374,780,1707,1694,1487,830,687,
 1376,2702,3093],
 [10,7,3,6,171,176,146,158,185,183,181,161,152,174,285,191,
 189,415,194,195,256,188,190],
 [10,7,3,6,176,158,185,181,152,174,275,285,197,191,189,297,
 415,271,194,195,196,256,224,188,190],
 [10,7,3,6,176,158,185,183,181,161,152,174,285,191,189,415,
 194,195,256,188,190,1049,894,1152,997],
 [10,7,6,175,176,144,158,138,185,184,181,137,152,143,174,
 275,197,233,297,271,218,196,224,263],
 [10,7,6,176,144,158,138,185,181,137,152,143,174,275,285,
 197,233,297,415,271,218,196,256,224,263],
 [10,7,6,176,144,158,138,185,184,181,137,152,143,174,275,
 197,233,297,271,218,196,224,263,1596,1651],
 [10,7,6,176,158,180,185,181,152,177,174,275,285,197,191,
 189,297,415,271,194,195,196,256,224,188,190],
 [10,7,6,176,158,180,185,183,181,161,152,177,174,285,191,
 189,415,194,195,256,188,190,1049,894,1152,997],
 [10,7,6,176,158,185,181,152,174,275,197,233,297,271,218,
 196,224,263,734,735,1868,1374,1212,1459,1298,1707,1133,
 1492,1487,1113,687,1268,1461,1220,1375],
 [10,7,6,176,158,185,181,152,174,285,191,189,415,194,195,
 256,188,190,1351,1247,1911,1517,852,790,1181,1725,955,1614,
 1652,1320,962,1533,1004,1278,781],
 [10,7,6,181,174,285,191,189,194,195,218,256,188,190,263,
 1256,732,1342,730,1123,1911,1517,780,790,654,1181,1559,
 1652,1320,962,687,1533,1352,1278,781,4537,3755,2232,2230,
 2334,3971,2994,4463,3284],
 [10,9,3,2,6,171,146,144,162,183,161,137,145,285,265,189,
 415,219,195,256,232,190],
 [10,9,6,171,144,162,180,185,183,137,145,177,174,285,265,
 189,415,219,195,256,232,190,679,688,1517,955,1533],
 [10,9,6,171,144,162,180,185,183,137,145,177,174,285,265,
 197,189,415,219,271,195,256,232,224,190],
 [10,9,6,171,144,162,183,184,181,137,145,197,233,257,271,
 218,414,224,263,284,1596,1256,1651,1342,1212,1298,1492,
 1113,1461,1375],
 [10,9,6,171,175,176,144,162,183,184,181,137,145,197,189,
 233,257,271,195,218,414,224,190,263,284],
 [10,9,12,2,6,171,175,144,162,183,184,137,145,265,197,233,
 219,271,218,232,224,263],
 [10,9,12,2,171,144,183,181,137,145,285,197,233,198,218,296,
 256,224,263,274,689,678,1873,654,1181,687,1309,1533,3025,
 3121],
 [10,9,12,6,171,175,176,144,162,183,184,181,137,145,197,233,
 257,271,218,414,224,263,284],
 [10,9,12,171,176,144,162,185,183,181,137,145,174,285,197,
 233,198,415,271,218,296,256,224,263,274],
 [10,12,2,171,176,144,158,162,183,181,137,152,145,285,197,
 233,198,415,271,218,296,256,224,263,274],
 [10,146,144,158,138,182,161,137,152,143,170,275,285,265,225,
 233,257,297,415,219,268,218,414,196,256,232,199,263,284],
 [11,2,6,175,151,158,138,180,184,157,152,143,177,265,197,
 225,219,271,268,232,224,199,1049,748,1152,729],
 [11,2,6,175,151,158,138,180,184,157,152,143,177,275,265,
 197,225,297,219,271,268,196,232,224,199],
 [11,2,6,175,151,162,180,184,157,145,177,275,211,189,297,
 241,195,196,205,190,1256,894,1342,997,1000,1181,1609,1320,
 854,781],
 [11,2,6,175,151,180,184,157,152,143,177,265,197,225,219,
 271,268,232,224,199,1001,1191,944,1097,1911,790,1725,1652,
 962,1278],
 [11,2,6,175,151,180,184,157,177,275,211,189,297,241,195,
 196,205,190,1007,898,1873,1517,1000,1181,1032,955,1609,
 1320,1309,1533,854,781,4041,4531,4326,3990,4376,4805],
 [11,2,6,175,176,146,151,180,184,181,161,157,177,275,211,
 189,225,297,241,195,268,196,205,190,199],
 [11,3,2,146,138,162,182,161,143,145,170,275,285,265,204,
 211,297,415,219,242,241,196,256,232,210,205],
 [11,3,2,146,138,182,161,143,145,170,275,204,211,297,242,
 241,196,210,205,689,678,1868,1873,654,1000,1707,1032,1694,
 1609,687,1309,1376,854],
 [11,3,2,146,151,158,138,182,161,157,152,143,170,275,285,
 265,225,297,415,219,268,196,256,232,199],
 [11,3,2,146,151,158,138,182,161,157,152,143,170,285,265,
 225,415,219,268,256,232,199,748,729,1911,1725,962],
 [11,3,2,171,146,151,158,138,182,183,161,157,152,143,170,
 285,265,225,415,219,268,256,232,199],
 [11,3,6,171,176,158,162,185,183,181,152,145,174,285,197,
 204,189,415,271,242,195,256,224,210,190],
 [11,7,2,6,175,151,180,184,157,177,275,211,189,297,241,195,
 196,205,190,1256,894,1342,997,1000,1181,1609,1320,854,781],
 [11,7,2,6,175,176,146,151,180,184,181,161,157,177,275,211,
 189,297,241,195,196,205,190],
 [11,7,3,2,146,138,182,161,143,170,275,285,265,204,211,297,
 415,219,242,241,196,256,232,210,205],
 [11,7,3,2,146,182,161,143,170,275,297,242,241,196,210,205,
 1191,1097,1868,1873,1470,780,1707,1032,1694,1609,1547,830,
 687,1309,1376,854,2702,9013,3093,5877],
 [11,7,3,2,175,176,146,138,182,184,181,161,143,170,275,204,
 211,297,242,241,196,210,205],
 [11,7,3,6,176,158,185,181,174,285,197,204,189,415,271,242,
 195,210,190,1099,1123,1911,790,1725,1707,955,1652,1278,
 1376,781,4209,3382],
 [11,7,175,176,146,138,180,185,182,184,181,161,143,177,174,
 170,275,204,211,297,242,241,196,210,205],
 [11,7,175,176,146,151,180,185,182,184,181,161,157,177,174,
 170,275,211,189,297,241,195,196,205,190],
 [11,7,176,151,158,138,185,181,157,152,143,174,275,285,197,
 233,198,297,415,271,218,296,196,256,224,263,274],
 [11,7,176,158,180,185,182,181,152,177,174,170,275,285,197,
 204,189,297,415,271,242,195,196,256,224,210,190],
 [11,9,6,175,146,151,138,180,184,161,157,143,177,275,265,
 225,257,297,219,268,414,196,232,199,284],
 [11,9,12,2,6,171,175,151,180,183,184,157,177,265,197,225,
 219,271,268,232,224,199],
 [11,9,12,2,171,175,146,151,180,183,184,161,157,177,265,225,
 198,219,268,296,232,199,274],
 [11,9,12,2,175,151,180,183,184,161,157,177,265,225,198,219,
 268,296,232,199,274,1049,894,1152,997],
 [11,9,12,6,175,151,184,157,177,275,265,225,257,268,414,196,
 232,199,284,1028,1022,1517,790,1000,1181,1320,962,1309,
 1533,781,2994,3284],
 [11,9,12,175,146,151,180,182,184,161,157,177,170,275,265,
 225,257,297,219,268,414,196,232,199,284],
 [11,10,2,138,161,170,265,211,225,233,241,268,218,232,205,
 199,263,894,731,997,749,855,1911,1868,790,654,1000,1652,
 1694,962,687,1309,1278,1376,4187,3901,3971,4346,4463,4891],
 [11,10,2,146,138,162,180,182,161,143,145,177,170,275,285,
 211,297,415,241,196,256,205,1014,1041,1873,1032,1309],
 [11,10,2,146,138,162,180,182,161,143,145,177,170,275,285,
 265,211,297,415,219,241,196,256,232,205],
 [11,10,2,146,158,138,182,161,143,170,265,225,233,219,268,
 218,232,199,263,1099,1123,1911,1868,790,654,1725,1707,1652,
 1694,962,687,1278,1376],
 [11,10,2,171,175,146,138,182,183,184,161,143,170,265,211,
 225,233,219,241,268,218,232,205,199,263],
 [11,10,6,171,175,176,158,185,183,184,181,152,174,197,189,
 225,233,271,195,268,218,224,190,199,263],
 [11,10,6,176,158,138,185,181,152,143,174,197,225,233,271,
 268,218,224,199,263,1049,1596,1152,1651,790,654,1652,1694,
 1278,1376],
 [11,10,6,176,158,162,180,185,181,152,145,177,174,275,285,
 189,297,415,195,196,256,190,894,679,997,688],
 [11,10,6,176,158,162,180,185,181,152,145,177,174,275,285,
 197,189,297,415,271,195,196,256,224,190],
 [11,10,6,176,158,162,180,185,181,152,174,275,285,189,297,
 415,195,196,256,190,1007,1351,898,1247,1517,1181,955,1320,
 1533,781],
 [11,10,7,3,2,176,146,138,182,181,161,143,170,275,285,211,
 297,415,241,196,256,205],
 [11,10,7,3,6,176,146,158,185,181,161,152,174,275,285,189,
 297,415,195,196,256,190],
 [11,10,9,2,146,138,182,161,170,265,225,233,219,268,218,199,
 263,865,855,1911,1868,790,654,1725,1707,1032,1652,1694,
 1278,1376,854,4209,3433,3382,3640],
 [11,10,9,3,2,171,146,138,182,183,161,143,170,285,265,225,
 415,219,268,256,232,199],
 [11,10,9,3,146,138,182,161,170,275,265,225,257,297,219,268,
 414,199,284,865,855,1868,654,1725,1707,1032,1694,1278,1376,
 854,3433,3640],
 [11,10,9,3,146,182,184,161,143,170,275,265,297,219,268,414,
 196,232,199,284,1191,1097,1868,783,1381,1707,956,1705,687],
 [11,10,9,175,146,138,180,182,184,161,143,177,170,275,265,
 225,257,297,219,268,414,196,232,199,284],
 [11,10,12,6,176,158,185,181,152,174,197,225,233,271,268,
 218,224,199,263,1049,1596,1152,1651,790,654,1652,1694,1278,
 1376],
 [11,10,12,7,6,175,176,158,185,184,181,152,174,275,197,233,
 297,271,218,196,224,263],
 [11,10,12,7,176,158,185,183,181,174,285,197,233,198,415,
 271,218,296,263,274,1049,1152,1312,830,1476,5116,2168,3451,
 2160,4004,2202],
 [11,10,12,7,176,158,185,183,181,174,285,197,233,198,415,
 271,218,296,263,274,1099,1123,1911,1725,1707,955,1376,781,
 4209,3382],
 [11,10,12,171,176,158,162,185,183,181,152,145,174,285,197,
 233,198,415,271,218,296,256,224,263,274],
 [11,10,146,138,162,180,185,182,161,143,145,177,174,170,275,
 285,265,211,297,415,219,241,196,256,232,205],
 [11,10,171,175,176,158,185,182,183,184,181,152,174,170,197,
 189,225,233,271,195,268,218,224,190,199,263],
 [11,12,2,151,184,265,211,225,198,219,241,268,296,199,274,
 1596,1028,953,1651,994,1911,1517,790,1181,1313,1725,1032,
 955,1652,1320,1045,1278,854,781,1855,5602,5961,4184,4260,
 4773,4209,4030,3382,3389],
 [11,12,2,171,175,146,151,180,183,184,161,157,177,265,211,
 225,198,219,241,268,296,232,205,199,274],
 [11,12,2,175,151,158,180,183,184,161,157,152,177,265,225,
 198,219,268,296,232,199,274,1049,894,1152,997],
 [11,12,2,175,151,162,180,182,184,157,145,177,170,275,265,
 197,211,297,219,271,241,196,232,224,205],
 [11,12,2,175,151,162,180,182,184,181,157,145,177,170,275,
 197,211,297,271,241,196,224,205,1256,1342],
 [11,12,2,175,151,180,184,157,177,265,225,198,219,268,296,
 232,199,274,1001,944,1911,1517,790,1181,1312,1725,955,1652,
 1320,830,962,1533,1278,781,1476],
 [11,12,2,175,151,180,184,157,177,275,197,211,297,271,241,
 196,224,205,1007,1153,898,1043,1873,783,1279,1000,1032,
 1328,1664,1609,1309,1165,786,854],
 [11,12,7,2,6,175,176,151,180,184,181,157,177,275,197,211,
 297,271,241,196,224,205],
 [11,171,176,158,162,185,183,181,152,145,174,285,197,204,189,
 233,198,415,271,242,195,218,296,256,224,210,190,263,274],
 [11,180,185,161,177,174,170,275,204,211,297,242,241,268,196,
 210,205,199,894,731,865,997,1097,749,855,1868,1873,654,
 1000,1707,1032,1694,1609,956,687,1309,1376,854,3986,4217,
 4041,3990],
 [12,6,171,175,176,144,151,158,162,183,184,181,137,157,152,
 145,197,233,257,271,218,414,224,263,284],
 [12,6,175,144,151,158,180,184,137,157,152,177,275,265,197,
 225,257,297,219,271,268,414,196,232,224,199,284],
 [12,6,175,151,162,180,185,184,157,145,177,174,275,265,197,
 191,211,297,219,271,194,241,196,232,224,188,205],
 [12,7,2,6,175,151,184,161,157,177,275,265,191,211,194,241,
 196,232,188,205,894,997,852,1614,1004,2185,3169,2218,3406,
 2101,3748],
 [12,7,2,6,175,151,184,161,157,177,275,265,191,211,194,241,
 196,232,188,205,1028,1022,1517,790,1000,962,1309,1533,2994,
 3284],
 [12,7,2,175,146,151,180,182,184,161,157,177,170,275,265,
 191,211,297,219,194,241,196,232,188,205],
 [12,171,175,176,162,184,181,197,204,211,198,271,242,241,296,
 210,205,274,849,748,1086,1007,858,729,898,852,1381,1313,
 686,955,1614,1695,1045,1705,1004,652,1855,1857,3982,3776,
 3851,3874],
 [12,175,146,151,180,182,184,161,157,177,170,275,265,191,211,
 225,257,297,219,194,241,268,414,196,232,188,205,199,284],
 [14,20,32,18,21,51,50,61,97,100,69,92,88,76,77,83,74,101,
 73,72,60,65,87,86,93,80,237,353,326,333,361,405,374,193,
 234,359,280,215,261,302,293,318,437,435,386,295,262,245,
 228,358,323,314,335,343,526,477,564,522,549,473,527,519,
 523,568,431,486,463,480,663,915,742,879,859,695,1505,801,
 883,753,1379,738,756,1177,1188,1207,1296,1216,1162,1280,
 1031,1175,1231,1179,1189,1254,1201,1360,1138,1300,1168,2023,
 3256,2716,3472,2898,1473,1599,1573,1676,1527,1466,1509,1552,
 1535,1647,2756,2405,1997,1951,1959,3369,3966,2806,3178,3155,
 2617,2537,3197,2489,4288,7795,5413,6380,7655,5589,7772,6010,
 7838,8399,6783],
 [14,20,32,18,51,50,61,97,89,53,108,74,101,103,54,78,90,
 86,93,80,52,57,237,353,410,364,333,399,405,208,193,234,
 298,215,261,382,437,277,200,253,207,269,319,226,348,314,
 430,515,536,556,477,564,466,473,527,426,488,465,534,523,
 568,456,700,870,796,739,912,712,845,705,914,871,843,892,
 723,941,1379,1006,3726,825,828,3642,833,3645,1177,1188,
 1391,1263,1304,1081,1031,1175,1455,1530,1241,1383,1130,1405,
 1223,1445,1396,1138,1300,1080,1215,2271,2865,3446,3330,2031,
 2137,2715,3616,2177,1210,1283,1865,2136,1195,1226,1878,2085,
 1176,1259,1879,2034,3585,4017,3130,2642,3950,3151,3227,3150,
 4331,2944,3210,3843,4066,3207,4825,3286,4127,3149,2993,4906,
 2925,4202,4123,2190,1965,2260,2037,2248,2014,3963,3983,2646,
 3188,2575,2885,3211,2683,3232,2544,2494,3139,2685,3144,2545,
 2641,3289,9358,9341,8358,9078,5134,6698,8756,6241,6715,6486,
 7068,8158,8886,8882,7603,5467,5458,5293,8125,9385,8003,8422,
 9165,7220,8297,8272,7247,6880,6254,6286],
 [14,20,32,38,18,21,50,61,97,69,76,53,74,101,63,84,60,90,
 86,80,237,326,405,374,208,243,266,437,435,386,277,262,
 226,290,306,357,335,343,578,464,467,495,592,580,479,503,
 473,527,474,519,510,532,494,452,517,601,623,463,480,663,
 719,695,1603,709,801,1524,738,899,1183,1177,1188,1055,1158,
 1011,1039,881,2039,1031,1175,1089,1024,1121,1356,1008,1230,
 1130,1249,967,928,1213,1179,1189,1083,1002,1027,2098,1103,
 911,1036,1275,2713,1785,2023,2075,1801,2292,2080,1473,1599,
 1550,1749,1620,1477,1527,1466,1516,1633,2067,1646,1489,1509,
 1552,1562,1673,1582,1370,2841,3124,2324,2928,3182,4352,2847,
 2625,3583,2756,2405,2277,3036,3900,3019,2521,2887,3087,3228,
 4512,3040,2573,2746,2554,4134,3269,2531,3486,3351,2522,2936,
 1997,2798,1951,2858,1959,2883,8583,6977,3722,3667,3374,3563,
 3462,2759,3233,3070,3155,2617,2881,2553,3043,2744,2837,2484,
 3653,3409,3556,2817,3709,3367,3623,3728,3813,2836,3026,2696,
 2893,2578,7460,7616,7924,5713,7688,6930,7647,7618,7445,5484,
 6449,7257,7608,5740,6643,7361,7114,7346,8797,5633,7695,4735,
 8580,4668,6975,4393,6194,7389,9086,7217,8964,4581,8795,8767,
 8736,4720,7100,6558,7390,5547,3742,6181,6187,6322,4541,7456,
 6587,6582,6211,4907,7037,6179,5447,3419,7860,6938,7321,7248,
 6421,9084,9325,7490,8313,6364,6719,6104,7736,6277],
 [14,20,32,38,18,21,51,50,61,97,100,69,83,74,101,73,103,
 54,78,60,65,87,86,80,62,237,353,312,333,361,193,234,240,
 272,298,359,437,435,386,200,253,207,269,267,295,262,245,
 228,348,335,343,515,455,530,536,556,637,473,527,488,465,
 534,599,459,552,523,568,663,719,824,722,950,912,1505,701,
 709,892,1122,1379,828,1143,1044,1262,1335,1362,1304,1081,
 1231,1095,1345,1405,1223,1254,1214,1203,1080,1215,2511,2862,
 2776,2809,1560,1625,1869,1892,1865,2136,1553,1882,1827,1878,
 2085,1589,1850,1880,1879,2034,2618,3422,4145,4777,3000,2698,
 3285,3557,4293,3101,1965,2037,2014,2678,2916,3066,2604,2886,
 2687,2976,2842],
 [14,20,32,38,18,21,51,50,61,97,100,79,94,69,76,83,108,74,
 101,73,63,84,60,65,87,90,86,237,353,326,312,333,361,405,
 302,309,293,318,435,386,207,269,267,348,358,323,314,357,
 335,343,477,564,509,522,549,473,527,465,534,483,523,568,
 431,486,468,463,480,700,870,663,915,772,695,705,914,701,
 801,751,753,1006,738,828,756,972,1177,1188,1102,1207,1296,
 993,1031,1175,1251,1241,1383,1100,1179,1189,1038,1138,1300,
 1159,1473,1599,1573,1676,1527,1466,1545,1717,1509,1552,1535,
 1647,1997,1951,1959],
 [14,20,32,38,18,21,51,50,61,97,100,79,94,69,83,108,74,
 101,73,54,78,60,65,87,90,86,62,237,353,326,312,333,361,
 405,240,272,307,298,215,261,302,437,435,386,207,269,245,
 228,321,348,455,530,441,536,556,477,564,447,473,527,465,
 534,459,552,470,523,568,950,859,912,1505,1975,1670,892,
 883,1122,1379,2044,1500,844,1006,738,828,756,948,1335,1362,
 850,1304,1081,936,1095,1345,952,1405,1223,856,1214,1203,
 860,1080,1215,1869,1892,1865,2136,1882,1827,1878,2085,1850,
 1880,1879,2034,1965,2037,2014],
 [14,20,32,38,18,21,51,50,61,97,100,79,94,69,83,108,74,
 101,103,60,65,87,90,86,52,57,237,353,326,312,333,361,
 405,240,272,307,298,248,215,261,382,437,207,269,267,226,
 245,228,348,358,323,455,530,441,536,556,477,564,509,473,
 527,465,534,483,459,552,470,523,568,950,1449,925,912,1603,
 1505,892,1421,822,1122,1524,1379,844,1006,828,756,1335,
 1362,1304,1081,1095,1345,1405,1223,1214,1203,1080,1215,1869,
 1892,1838,1865,2136,1823,1882,1827,1779,1878,2085,1904,1850,
 1880,1775,1879,2034,1839,9112,1965,6968,2037,8418,2014],
 [14,20,32,38,18,21,51,50,61,97,100,79,94,69,92,88,83,108,
 74,101,73,72,65,87,90,86,237,353,326,312,333,361,405,
 215,261,302,293,318,255,437,435,386,267,213,358,323,305,
 314,357,335,343,477,564,509,522,549,447,473,527,465,534,
 470,523,568,431,486,468,463,480,663,630,915,712,845,695,
 701,636,801,723,941,753,1006,738,756,972,1177,1188,1207,
 1296,1031,1175,1241,1383,1179,1189,1138,1300,1821,1473,1599,
 1910,1573,1676,1750,1527,1466,1899,1545,1717,1810,1509,1552,
 1848,1535,1647,1997,4644,1951,4617,1959,4335],
 [14,20,32,38,18,21,51,50,61,97,100,79,94,69,92,88,89,76,
 59,95,83,108,74,101,102,73,63,84,103,72,54,78,60,75,65,
 87,90,86,68,52,57,342,186,259,359,331,320,310,221,288,
 201,203,292,382,388,202,217,295,311,303,187,278,314,808,
 1029,900,957,961,806,792,2677,2767],
 [14,20,32,38,18,21,51,97,69,92,88,76,53,83,74,101,73,63,
 84,72,60,65,87,90,86,326,333,361,405,324,315,208,280,
 302,201,437,435,386,406,383,277,200,253,267,262,314,335,
 343,588,464,526,477,564,524,473,527,626,474,465,534,519,
 431,486,463,480,788,877,663,915,695,1505,963,938,701,801,
 753,792,1379,738,1177,1188,1207,1296,1039,881,1031,1175,
 1241,1383,1249,967,1179,1189,1138,1300,1103,911,1690,2359,
 2110,1473,1599,1573,1676,1620,1477,1527,1466,1545,1717,1646,
 1489,1509,1552,1535,1647,1582,1370,3491,2245,2542,2149,2312,
 3189,2051,3190,2322,2648,2128,2417,3005,2131,1997,2798,1951,
 2858,1959,2883,2808,2930,2599,2737,2812,3086,2513,3342,2796,
 2621,2590,3301],
 [14,20,32,38,18,21,58,51,50,61,97,82,100,79,94,69,85,92,
 88,89,76,59,95,53,55,104,83,108,74,101,102,73,63,84,
 103,56,72,54,78,60,75,65,87,90,86,70,106,80,81,98,62,
 68,52,57],
 [14,20,32,38,18,21,58,51,50,61,97,100,79,94,69,92,88,89,
 83,108,74,101,73,63,84,103,56,72,54,78,60,65,87,90,86,
 70,106,80,68,52,57,186,259,298,304,351,359,331,320,203,
 292,382,202,217,213,254,328,295,311,303,231,187,278,314,
 692,1112,635,672,918,628],
 [14,20,32,38,18,51,50,61,97,79,94,76,53,108,63,84,72,90,
 86,80,68,237,410,312,399,405,374,208,240,272,227,230,248,
 302,293,318,435,386,267,250,246,226,358,323,335,343,464,
 430,458,461,477,564,522,549,466,473,527,579,426,465,534,
 478,494,523,568,456,463,480,576,663,935,915,670,809,778,
 695,1603,701,801,868,795,753,1524,1475,1468,738,1463,756,
 1177,1188,1207,1296,933,1416,1457,1031,1175,1455,1530,1121,
 1356,1241,1383,1179,1189,1445,1396,1138,1300,1448,1393,1036,
 1275,2864,2087,2758,2118,1473,1599,1573,1676,2242,1527,1466,
 2408,1545,1717,1509,1552,2316,1535,1647,2141,3111,2839,3210,
 2993,3017,3479,1997,1951,1959,2613,3724,4105,4647,2822,3596,
 4024,4991,2968,3439,4028,4955,5848,5002,4546,6102,4399,5408,
 7459,6593,8954,8004,7462,7504],
 [14,20,32,38,18,58,50,61,97,100,69,85,89,59,95,53,55,104,
 108,102,73,63,84,103,56,54,78,60,75,65,87,90,86,62,49,
 52,57,334,186,193,234,229,309,221,288,201,436,202,200,
 253,207,269,213,260,214,250,246,187,278,357,700,870,630,
 685,705,914,636,710,853,747,755,1075,751,961,806,792,1950,
 2291,1995,1976,2088,2091,2119,2282,2472,2441,2581,2110,2099,
 3671,4405,4927,3641,4000,5687,8739,3831,3415,5075,9282,4697,
 5473,8148,4710,4744,6534,7992,7334],
 [14,20,38,18,21,51,97,100,69,66,53,83,74,101,73,103,60,
 65,87,90,91,86,62,237,353,364,312,333,361,405,324,315,
 240,272,307,298,215,261,201,437,435,386,406,383,207,269,
 262,245,228,348,192,335,343,455,530,536,556,477,564,473,
 527,465,534,459,552,523,568,788,877,719,950,742,879,912,
 1505,963,938,709,892,718,890,883,1122,1379,1006,828,1093,
 1158,1011,1335,1362,1039,881,1423,1304,1081,1095,1345,1142,
 1249,967,1405,1223,1002,1027,1420,1214,1203,1080,1215,2821,
 2551,1869,1892,1865,2136,1882,1827,1878,2085,1850,1880,1879,
 2034,1965,2037,2014,3547,2601,3625,3204,3266,2784,3240,2878,
 3678,2985,3158,3031],
 [14,20,42,18,21,15,58,51,61,82,100,79,85,92,76,77,53,55,
 104,83,101,102,73,84,56,72,54,60,90,91,86,70,106,93,81,
 98,62,68,57,324,279,234,222,307,291,304,351,280,212,243,
 201,406,294,253,223,267,238,254,328,245,321,323,299,290,
 192,824,814,925,733,802,757,822,760],
 [14,20,42,18,21,15,58,51,61,97,82,100,79,94,85,92,76,77,
 53,55,104,83,101,102,73,63,84,56,72,54,60,90,91,86,70,
 106,93,81,98,62,68,57,324,222,307,291,304,351,280,212,
 243,201,406,223,267,238,254,328,321,323,299,290,192,814,
 925,733,757,822,760],
 [14,20,42,18,21,15,58,51,61,97,100,94,85,92,66,76,59,77,
 53,55,104,83,101,73,63,56,72,54,60,75,90,91,86,70,106,
 93,81,98,62,68,57,324,186,193,222,280,247,261,302,318,
 243,201,267,328,262,231,228,321,323,290,192,663,819,983,
 754,742,974,920,741,718,1021,2023,2794,2292,2504],
 [14,20,42,18,21,15,58,51,61,97,100,94,92,76,77,53,55,104,
 83,101,73,63,72,60,90,91,86,70,106,81,62,68,57,324,186,
 193,222,247,261,310,293,212,243,251,201,292,238,254,231,
 228,321,323,299,235,278,644,663,896,793,819,983,974,703,
 859,1063,733,808,762,901,957,757,822,920,741,718,1021,760,
 799,785,897,792,2368,2371,2753,3562,2193,2376,2056,2602,
 2474,1948,2462,1895,2292,3436,2302,2504,2061,2397,2377,4110,
 8847,5154,7432,3631,3305,5119,5793,4767,5980,8040,3777,8962,
 8916,8863,8944,8938,5734,6633,7479,8972,8138,7039,6422,6149,
 6635,6511,7690,6586],
 [14,22,17,39,37,36,31,42,35,28,19,38,40,34,23,30,21,13,
 25,58,51,97,82,105,69,71,74,102,73,103,56,96,60,90,91,
 99,52,315,307,291,383,267,238,228,722,715],
 [14,22,20,27,42,41,18,34,21,13,15,25,58,51,61,97,66,76,
 59,95,77,53,104,83,75,65,91,86,70,106,93,80,98,62,186,
 208,193,234,247,248,261,302,310,309,293,318,231,226,228,
 321,330,348,358,323,644,700,754,670,742,879,703,809,741,
 669,718,890,725,868,2029,1913,1895,1925],
 [14,22,24,17,39,27,31,42,41,35,38,34,30,21,13,25,51,61,
 105,66,95,71,74,73,84,96,91,106,99,52,353,316,326,421,
 364,312,345,333,428,405,377,374,393,338,286,588,509,549,
 626,470,568,1293,976,1276,813,1353,835,833,2242,2316,2190,
 2260,2248],
 [14,22,24,39,20,27,42,41,35,38,18,34,21,13,15,25,51,61,
 100,92,66,95,83,73,84,72,65,91,106,62,353,316,326,364,
 333,428,405,377,393,338,286,588,455,526,547,509,549,524,
 626,465,519,532,470,568,498,1293,976,1353,835,833,1910,
 1676,2242,1810,1552,2316,2190,2248,5002,4399],
 [14,22,24,39,37,20,27,42,32,35,40,18,34,21,13,15,58,61,
 82,85,59,77,104,102,84,75,70,372,432,360,475,520,366,
 424,423,368,385,283,236,310,578,451,500,530,558,531,549,
 574,598,589,450,607,413,546,601,638,497,480,933,1216,1280,
 1294,1081,1269,1203,917,2077,1578,1986,1587,3391,3299,3119,
 3070,4327,4109,3498,4464,2728,2696,7753,7376,6169,6408],
 [14,22,29,24,20,27,42,41,38,40,18,34,21,13,15,25,58,51,
 82,100,79,94,66,76,59,95,104,83,56,72,54,78,75,65,91,
 86,70,106,98,62,259,240,247,248,217,207,231,226],
 [14,22,29,24,33,39,37,20,27,36,42,41,32,35,28,38,40,18,
 34,23,13,15,25,58,51,100,92,95,83,64,102,73,72,65,62,
 49,288,301],
 [14,22,29,24,33,39,37,20,27,36,42,41,32,35,28,38,40,18,
 34,23,15,25,58,51,100,92,95,83,64,108,102,73,72,65,62,
 49,68,288,301],
 [14,22,29,24,39,20,27,41,32,38,40,34,21,13,15,25,58,82,
 85,88,59,56,75,87,70,99,98,372,316,492,432,475,332,424,
 542,327,385,283,350,320,308,303,578,496,530,558,547,416,
 574,626,525,534,546,532,452,601,623,569,539,396,1050,1534,
 1267,1016,1026,1649,1273,928,2852,2785,7363,4782],
 [14,22,29,24,39,37,20,41,32,38,40,18,15,25,51,100,92,88,
 76,108,72,86,62,68,353,394,326,407,408,410,429,333,399,
 361,419,354,286,341,229,248,226,588,455,530,526,416,513,
 477,564,427,508,465,534,459,552,498,396,499,431,486,844,
 989,738,756,779,1225,1145,1064,1124,1193,1550,1749,1567,
 1620,1477,1516,1633,1646,1489,1562,1673,1557,1582,1370,3572,
 3515,4401,3512,3253,3063,3339,3553,3427,3603,3277,4278,3106,
 3272,3429,3274,2765,3120,3573,2701,9219,7766,8549,6734,6602,
 7046,8298,8818,8007,6148,6394,7498,8615,6190,6455,7145,6487,
 6184],
 [14,22,29,39,37,36,42,41,32,28,38,40,18,23,13,15,58,51,
 92,83,64,72,384,394,375,360,425,429,332,313,363,409,405,
 444,419,327,236,288,482,464,530,637,622,574,583,508,473,
 626,607,413,571,586,546,552,623,613,566,576,1404,1928,
 1303,1871,991,1237,1872,1601,1280,1455,1169,1275,1473,1894,
 3133,2104,2106,1790,3156,2387,2342,1430,1778,3500,2399,2090,
 2235,2025,2059,2613,4678,4109,5336,4819,4888,5243,8301,5746,
 9114,4940,7792,5490,7668,7308,7922],
 [14,22,29,39,37,36,42,41,32,35,28,38,40,18,34,23,13,15,
 25,58,51,97,82,105,69,92,83,64,102,73,103,56,72,96,60,
 65,62,49,208,351,288,277,328,301],
 [14,29,20,42,38,18,21,15,51,50,97,82,100,79,94,69,92,89,
 66,76,59,95,53,55,83,108,101,73,63,103,72,78,60,75,65,
 90,86,106,80,81,98,62,68,57,342,259,320,247,310,293,206,
 221,388,217,303,330,358,239,220,746,763],
 [14,29,20,42,38,18,21,15,51,50,97,94,89,76,53,55,83,108,
 101,103,72,78,90,86,106,80,81,68,57,237,353,339,326,408,
 364,312,395,333,337,405,387,374,491,393,286,208,248,215,
 255,243,382,277,226,245,305,290,314,430,451,453,477,580,
 466,450,478,452,417,459,623,1063,1289,2449,1737,2393,1650,
 2414,1732,1188,1175,1189],
 [14,29,20,42,38,18,21,15,51,50,97,94,89,76,53,55,83,108,
 101,103,72,78,90,86,106,80,81,68,57,237,481,421,364,312,
 395,521,428,337,405,387,374,286,208,248,215,255,243,382,
 277,226,245,305,290,314,464,467,461,580,466,450,412,427,
 474,449,478,494,452,623,454,431,1063,1289,1468,1463,1035,
 899,1081,1175,1136,1008,1189,1203,1706,1466,1608,1552,3483,
 4051,3055,2829],
 [14,29,20,42,38,18,21,15,51,50,97,100,69,92,76,95,83,108,
 101,103,72,78,60,65,86,106,80,81,62,57,237,353,339,326,
 408,312,395,521,428,337,361,405,387,374,491,393,286,234,
 359,331,248,215,437,253,295,311,226,245,273,357,500,637,
 461,489,599,494,514,794,776,2449,1737,2393,1650,2414,1732],
 [14,29,20,42,38,18,21,15,51,50,97,100,69,92,76,95,83,108,
 101,103,72,78,60,65,86,106,80,81,62,57,237,353,339,481,
 421,408,312,395,333,337,361,374,491,393,234,359,331,248,
 215,437,253,295,311,226,245,273,357,515,500,637,453,477,
 489,527,488,599,417,459,535,442,480,794,776,1234,867,1317,
 848,1261,3493,3265],
 [14,29,20,42,38,18,21,15,51,50,97,100,94,69,92,89,76,95,
 53,55,83,108,101,73,63,103,72,78,60,65,90,86,106,80,81,
 62,68,57,237,353,339,326,481,421,408,364,312,395,333,521,
 428,337,361,405,387,374,491,393,286],
 [14,29,20,42,38,18,21,15,51,50,100,94,69,92,89,95,53,55,
 83,108,73,63,72,78,90,86,106,62,68,57,237,326,481,421,
 364,312,395,521,428,337,405,387,374,286,279,298,230,255,
 243,201,203,294,213,305,290,192,187,464,467,556,567,461,
 580,412,427,528,474,449,544,623,454,431,674,693,1077,1156,
 1085,1154],
 [14,29,20,42,38,18,21,15,51,50,100,94,89,95,83,108,73,63,
 72,78,90,106,62,68,237,353,339,481,421,408,312,395,333,
 337,491,393,222,240,359,331,302,386,223,207,295,311,321,
 343,482,515,496,637,458,416,453,477,509,522,485,527,625,
 488,483,512,599,417,459,456,396,480,726,702,888,1006,828,
 833,1003,1205,1234,867,1173,1416,1316,936,1095,1074,1067,
 1070,1317,848,1209,1445,860,1080,1677,2010,2242,1528,1820,
 1510,2035,1531,1739,2316,1746,1431,2667,3327,2877,3222,2671,
 5944,3449,2604,3266,3959,2851,4116,2842,3158,4859,4395],
 [14,29,20,42,38,18,21,15,58,51,50,97,82,100,79,94,69,85,
 92,89,66,76,59,95,53,55,104,83,108,101,102,73,63,103,
 56,72,54,78,60,75,65,90,91,86,70,106,80,81,98,62,68,57 
  ],[14,29,20,42,38,18,21,15,58,51,50,97,100,94,69,92,
 89,76,95,53,55,104,83,108,101,73,63,103,56,72,54,78,60,
 65,90,91,86,70,106,80,81,62,68,57,186,193,291,304,247,
 212,292,202,200,217,238,254,231,299,278,644,665],
 [14,29,20,42,38,18,21,15,58,97,82,100,79,94,69,85,92,66,
 76,59,53,55,104,83,101,73,63,56,72,54,60,75,65,90,86,
 106,98,62,68,57,334,324,307,351,280,247,302,318,206,221,
 201,203,267,328,262,239,220,192,187,862,983,746,695,873,
 763,753,798,1930,2423,1998,2499],
 [14,29,20,42,38,18,21,15,58,97,100,94,69,92,76,53,55,104,
 83,101,73,63,56,72,54,60,65,90,91,86,70,106,62,68,57,
 334,324,186,193,291,304,247,212,201,203,292,217,267,238,
 254,328,231,321,323,278,644,663,819,814,925,862,983,733,
 635,957,1246,709,757,822,939,920,741,718,792,1151,2368,
 2212,2421,2234,2314,1948,2462,1895,2292,2504,2229,3362,8920,
 7773,5732,3305,5119,5793,4767,5753,8609,5734],
 [14,29,20,42,38,18,21,15,58,97,100,94,89,95,53,55,104,
 108,101,103,56,54,78,60,65,90,91,86,70,80,81,62,68,57,
 334,324,186,193,212,288,292,202,200,223,217,207,238,213,
 254,231,226,245,348,299,278,959,644,700,630,714,900,1048,
 665,705,889,636,816,843,672,724,802,892,939,920,721,806,
 3445,2530,2271,2452,3714,2389,2137,2396,2649,2467,2715,2123,
 2078,8553,8505,5090,5101,4571,8013,6909,5300,5800,4350],
 [14,29,24,17,20,27,31,42,35,19,38,18,30,21,15,25,51,50,
 94,53,55,108,73,63,78,80,81,68,326,481,421,364,312,395,
 521,428,337,374,286,270,273,588,464,467,556,580,511,479,
 489,412,427,626,474,449,544,623,535,442,454,431,1403,1077,
 1171,1512,1085,1261,2311,3924,3852,3405,4118],
 [14,29,24,17,20,27,31,42,35,19,38,18,30,21,15,25,58,82,
 79,66,59,104,102,56,54,91,70,98,316,381,475,402,366,542,
 411,377,338,354,249,259,217,578,575,441,536,606,509,522,
 609,489,607,582,483,512,620,470,523,600,498,502,1011,1285,
 1423,967,1255,1420,1711,2791,3288,2955,3059],
 [14,29,24,33,39,20,27,36,42,35,28,18,34,23,15,25,58,51,
 100,92,95,83,64,102,73,65,62,49,316,381,481,376,389,370,
 402,345,366,521,362,377,368,491,249,288,301,575,558,540,
 447,582,497,468,1310,913,1660,1324,908,1385,966,1454,1348,
 1994,2328,2184,2273,2095,2386,2319,2422],
 [14,29,24,37,20,42,41,35,38,40,18,34,21,13,15,25,58,82,
 79,104,102,56,54,75,91,70,98,372,394,492,475,402,429,
 520,542,411,423,385,283,259,217,578,575,397,455,530,592,
 466,450,412,427,607,582,534,571,546,552,601,456,396,1555,
 1290,1031,1511,1369,1138,1359,2200,1306,2046,2553,4091,3192,
 4751],
 [14,29,24,39,37,27,42,32,35,38,40,18,34,21,13,25,51,100,
 105,92,95,83,74,73,72,96,65,106,62,52,326,408,364,402,
 366,428,361,411,405,368,393,286,588,575,500,455,526,549,
 524,626,582,505,465,519,568,498,1434,1486,1325,1401,2124,
 2374,2387,2263],
 [14,29,33,36,42,32,18,23,21,58,50,97,100,79,94,105,69,92,
 95,83,108,74,101,102,73,63,103,54,96,65,90,86,70,106,
 93,80,81,62,52,334,307,298,304,322,359,331,437,386,436,
 267,213,254,319,295,311,348,323,305,357,343,950,925,1334,
 892,822,1198],
 [14,29,39,20,32,38,21,15,50,97,69,89,53,55,108,101,63,
 103,60,90,80,81,68,57,237,326,369,421,364,312,428,374,
 380,371,286,208,234,248,243,382,277,253,226,290,314,578,
 464,592,558,547,461,513,580,589,450,427,474,562,538,494,
 517,601,623,516,431,486,630,819,636,863,1388,1232,1364,
 1301,779,899,1343,1146,1392,1296,1145,2039,1454,1024,1008,
 1722,1383,1444,1161,1083,2098,1348,911,1574,1662,1782,1676,
 2360,1633,1515,1744,1791,1717,1389,2496,1370,3332,3735,2329,
 2521,3250,3738,2331,2522,2048,2064,2903,3432,4662,4211,2744,
 4400,2484,3072,4807,2789,4162,2696,4345,2578,4832,3082,2765,
 4248,2989,2701,4272,6278,3742,4786,7028,3419,7258,4430,5761,
 6637,4452,5658,6563,6339],
 [14,29,39,20,32,38,21,15,51,50,97,69,92,89,53,55,108,101,
 63,103,72,78,60,90,86,106,80,81,68,57,237,326,369,421,
 364,312,428,346,337,405,374,380,371,286,208,234,298,351,
 243,382,277,253,213,328,226,290,314,464,570,556,592,580,
 427,474,557,544,494,517,601,623,431,739,724,1285,1263,
 1255,1186,1083,2642,3035],
 [14,29,39,20,32,38,21,15,51,50,97,69,92,89,53,55,108,101,
 63,103,72,78,60,90,86,106,80,81,68,57,237,353,421,364,
 333,367,428,346,337,361,405,374,380,393,371,286,208,234,
 298,351,243,382,277,253,213,328,226,290,314,515,501,570,
 556,612,488,487,557,544,601,739,724,1871,1872,1056,1105,
 1581,1514],
 [14,29,39,20,32,38,21,15,51,50,97,82,100,94,69,92,89,76,
 59,95,53,55,83,108,101,102,73,63,103,72,78,60,65,90,86,
 106,80,99,81,98,62,68,57,342,259,272,350,320,310,221,
 388,217,269,308,303,330,299,306,220,1112,878,918,861],
 [14,29,39,20,32,38,21,15,51,50,97,100,94,69,92,89,76,95,
 53,55,83,108,101,73,63,103,72,78,60,65,90,86,106,80,81,
 62,68,57,237,353,326,369,421,422,408,364,312,333,367,428,
 346,337,361,405,374,380,393,371,286],
 [14,29,39,20,32,38,21,15,51,50,100,94,69,92,89,53,55,83,
 73,63,103,72,78,65,90,80,62,68,57,237,326,369,421,364,
 312,428,346,337,405,371,286,279,298,351,280,230,203,294,
 213,328,262,246,187,464,570,556,461,513,427,474,525,534,
 557,544,494,517,516,431,486,1334,1198,828,1013,972,1323,
 1073,1262,2395,1034,1067,1169,2228,1170,1625,1713,2579,1544,
 1485,2141,2938,3021,3786,4103],
 [14,29,39,20,32,38,21,15,51,50,100,94,69,92,89,53,55,83,
 73,63,103,72,78,65,90,80,62,68,57,237,353,326,369,421,
 364,333,367,428,346,337,361,374,380,393,371,286,279,298,
 351,280,230,203,294,213,328,262,246,187,570,556,526,525,
 534,557,544,519,516,486,1334,1198,977,779,1073,1262,1034,
 1067,1169,1170,1560,1531,2938,3021],
 [14,29,39,20,32,38,21,15,51,97,82,100,94,69,92,76,59,95,
 53,55,83,102,63,103,60,65,90,99,81,98,62,68,57,342,259,
 272,307,350,320,310,309,318,221,406,308,303,299,306,258,
 220,301,192,1768,719,761,739,1112,878,726,942,716,703,778,
 859,685,873,918,861,702,884,745,760,693,882,799,699,798,
 1929,3395,3417,3039,2873,2376,2469,3330,2056,3034,3344,3621,
 2402,2959,2278,2061,2912,2397,5429,3884,4860,4388,3631,5393,
 3963,3559,4276,8103,3777,5324,3983,8970,8659,4781,6892,4745,
 6686,6382],
 [14,29,39,20,32,38,21,15,51,97,100,94,69,92,76,95,53,55,
 83,73,63,103,60,65,86,106,81,62,68,57,237,353,326,369,
 421,422,408,364,312,428,361,374,380,393,371,286,324,307,
 280,230,309,318,201,406,262,246,348,323,192,461,513,518,
 543,549,494,517,559,568,502,859,883,989,779,1216,1254,
 1528,1589],
 [14,29,39,20,32,38,21,15,51,97,100,94,69,92,76,95,53,55,
 83,73,63,103,60,65,86,106,81,62,68,57,353,326,369,422,
 408,364,333,367,428,361,405,393,371,286,324,307,280,230,
 309,318,201,406,262,246,348,323,192,588,455,526,518,543,
 549,524,506,626,519,559,568,498,499,502,859,883,1216,1162,
 1254,1201],
 [14,29,39,20,32,38,21,15,58,50,97,100,94,69,85,88,89,76,
 95,53,55,73,63,103,56,60,65,70,80,81,62,68,57,334,186,
 304,350,320,229,280,230,247,212,266,202,207,254,348,323,
 299,306,209,278,700,950,925,794,726,942,668,1107,862,893,
 759,714,733,674,705,892,822,947,817,721,760,693,872,645,
 806,2415,1990,1889,2636,2956,2384,3097,2004,2325,3029,2401,
 3041,2069,2367,1969,4968,5525,5878,5673,3231,4222,5419,4944,
 3546,4241,4583,8579,5209,5352,6614,5259,6441,6720],
 [14,29,39,20,32,38,21,15,58,51,50,97,82,100,94,69,85,92,
 88,89,76,59,95,53,71,55,104,83,108,101,102,73,63,103,
 56,72,78,60,75,65,87,90,86,70,106,80,99,81,98,62,68,57 
  ],[14,29,39,20,32,38,21,15,58,51,50,97,100,94,69,85,
 92,88,89,76,95,53,55,83,108,101,73,63,103,56,72,78,60,
 65,90,86,70,106,80,81,62,68,57,186,304,350,320,247,212,
 266,276,292,202,254,231,299,306,209,278,893,759,947,817],
 [14,29,39,20,32,38,21,15,58,51,97,82,100,94,69,85,92,88,
 76,59,95,53,71,55,104,83,63,103,60,75,65,87,90,99,81,
 98,62,68,57,324,307,280,230,247,248,310,309,318,216,221,
 288,201,262,246,231,226,258,220,301,192,983,859,808,685,
 873,920,799,699,798,2602,2397],
 [14,29,39,20,32,38,21,15,58,51,97,82,100,94,69,85,92,88,
 76,59,95,53,71,55,104,83,63,103,60,75,65,87,99,81,98,
 62,68,57,324,307,280,230,247,248,310,309,318,270,216,221,
 288,201,262,246,231,226,273,258,220,301,192,983,859,808,
 685,873,920,799,699,798,2602,2397],
 [14,29,39,20,32,38,21,15,58,51,97,100,94,69,85,92,88,76,
 95,53,55,83,63,103,56,60,65,90,70,81,62,68,57,324,186,
 304,350,320,280,230,247,248,212,266,202,267,254,348,323,
 299,306,209,278,663,950,925,726,942,716,668,1107,983,893,
 759,733,674,847,701,892,822,947,817,760,693,882,645,806,
 792,2415,1889,2636,2359,2384,3097,2428,2004,2325,2401,3041,
 2435,2069,2367,1969,5440,5525,5878,3231,4222,5382,5419,3546,
 4241,5964,4866,7470,8396,5352,6247,5259,7651,7084],
 [14,29,39,42,15,94,105,69,92,95,77,53,83,64,63,72,78,106,
 93,80,62,49,68,57,326,408,337,374,393,286,324,350,331,
 230,329,255,243,276,203,406,213,349,305,290,209,187,588,
 578,500,397,637,622,518,453,580,589,489,412,626,607,505,
 448,514,417,623,613,502,454,924,719,726,670,893,1042,733,
 674,662,1015,709,669,947,1054,760,693,645,1737,1502,1650,
 1486,1732,1401,1229,1079,1091,1055,1205,1234,1052,933,1983,
 2039,1206,1419,1156,951,1355,1106,1126,1130,1065,984,2089,
 2098,1349,1363,1154,917,2288,2206,2384,2365,2296,2401,1258,
 1167,1222,1199,1292,1233,5034,3685,5126,3505],
 [14,29,39,42,18,15,58,51,50,97,82,100,94,105,69,85,92,89,
 66,76,59,95,77,53,55,104,83,64,108,101,102,73,63,103,
 56,72,78,96,60,75,65,90,91,86,70,106,93,80,81,98,62,
 49,68,57],
 [14,29,39,42,18,15,94,92,89,66,76,77,53,83,64,101,63,72,
 78,96,60,90,91,106,93,80,81,62,49,68,57,421,337,374,
 393,286,324,208,300,222,351,331,280,243,216,406,277,287,
 223,328,311,262,290,258,588,578,482,464,515,556,637,622,
 567,526,580,589,545,511,626,607,528,474,488,544,599,603,
 550,519,623,613,555,535,1502,1769,1486,1774,1401,1754],
 [14,29,39,42,18,15,94,92,95,83,64,63,72,78,106,62,49,68,
 408,337,393,324,322,359,331,243,251,201,406,287,223,319,
 295,311,290,235,192,343,588,578,500,397,637,622,518,453,
 522,580,589,524,489,412,626,607,488,505,448,512,599,603,
 514,417,623,613,529,456,498,502,454,480,924,815,959,719,
 726,670,733,662,1015,895,1048,709,702,669,760,645,1737,
 1502,1650,1486,1732,1401,1229,1079,1093,1091,1055,1205,1234,
 1052,933,1206,1419,1025,1156,951,1355,1106,1142,1074,1126,
 1130,1070,1317,1065,984,1349,1363,1051,1154,917,1080,2293,
 2012,2252,1918,1437,1210,1258,2919,1167,1402,1195,1222,2932,
 1199,1408,1176,1292,3004,1233,3148,3945,2826,2315,2667,2447,
 4161,2425,2329,3102,3896,2929,2233,2877,2340,3534,2568,2331,
 3257,2679,3129,2710,3356,2528,3282,2706,3205,2905,3241,2633,
 7353,8982,6819,6786],
 [14,29,39,42,18,15,94,105,69,92,89,66,76,95,83,64,72,78,
 96,60,106,93,80,81,62,49,68,57,326,421,408,337,374,393,
 286,322,359,331,280,230,243,277,319,295,311,290,273,239,
 258,637,622,596,567,526,580,589,582,528,474,599,603,623,
 613,593,555,535,924,794,866,726,733,674,1015,776,812,702,
 760,693,1502,1769,1774,1401,1754,1539,1229,1079,1354,1205,
 1234,1595,1206,1419,1532,1355,1106,1322,1070,1317,1592,1349,
 1363,4130,4874,2973,3077,3804,4690,2951,2852,3927,4770,3001,
 2785,4349,4624,4473],
 [14,29,42,18,21,58,50,97,100,79,94,69,95,77,55,104,108,
 101,73,103,54,78,96,65,90,91,86,70,93,80,81,62,52,57,
 334,186,259,307,291,298,304,310,255,212,288,292,202,217,
 238,213,295,231,245,330,348,305,299,278,357,815,700,935,
 876,692,824,950,880,809,859,1192,714,727,900,895,705,843,
 853,672,802,939,940,868,883,1344,721,736,806,2167,2509,
 2257,2639,3094,2654,2107,2472,2123,2582,2991,2669],
 [14,29,42,32,18,21,58,50,97,82,100,79,94,69,89,59,95,77,
 55,104,108,101,102,73,63,103,54,78,96,75,65,90,86,70,
 93,80,81,98,62,52,57,334,300,259,240,298,310,309,255,
 288,436,217,213,295,260,250,330,348,305,301,357,784,935,
 876,880,809,843,853,751,940,868,2509,2639,2472,2582],
 [14,29,42,32,18,21,58,50,97,82,100,79,94,69,95,77,55,104,
 108,101,102,73,63,103,56,54,78,96,75,65,90,86,70,93,80,
 81,62,52,57,334,300,240,298,255,288,436,287,217,207,267,
 213,254,295,260,250,348,305,278,357,644,663,793,784,665,
 701,816,765,843,853,892,1075,751,806,2271,2291,2865,2137,
 2088,2715,2282,2472,2581,4405,4927,4000,5687,3831,4697,4710]
  ,[14,29,42,32,18,21,58,51,50,97,82,100,79,94,105,69,85,
 92,89,76,59,95,77,53,55,104,83,108,74,101,102,73,63,
 103,56,72,54,78,96,60,75,65,90,86,70,106,93,80,81,98,
 62,68,52,57],
 [14,29,42,32,18,21,58,51,50,97,100,79,94,69,76,95,77,53,
 55,104,83,108,74,101,73,72,78,96,60,65,90,86,70,106,93,
 80,81,62,68,52,57,186,300,259,240,307,304,247,215,302,
 310,293,212,292,287,207,267,254,231,245,321,330,358,299,
 278,754,703,741,725],
 [14,29,42,32,18,21,100,94,69,95,77,55,83,108,74,101,73,
 103,54,78,96,65,86,80,62,68,52,57,326,312,333,286,334,
 279,193,300,240,298,309,255,288,251,203,287,207,213,295,
 301,235,187,588,575,464,500,455,556,549,580,585,524,489,
 427,505,465,544,599,584,498,502,431,784,862,1084,742,685,
 807,765,939,1101,718,699,787,977,779,1050,1139,1064,1059,
 933,1125,1078,1082,1026,1094,1124,1092,984,1090,999,1005,
 1194,1258,1110,1167,1184,1222,1117,1199,1242,1292,1185,1233,
 2040,2050,2068],
 [14,29,42,32,18,21,100,94,69,95,83,108,74,73,103,72,54,
 78,96,65,86,80,62,68,52,326,312,337,286,334,300,240,298,
 255,288,251,203,386,294,200,287,207,213,319,295,311,246,
 301,235,187,343,588,575,500,455,556,580,585,524,489,427,
 474,505,465,544,599,584,494,498,502,431,1318,788,796,784,
 804,761,862,807,871,765,810,747,939,787,977,779,1079,1050,
 1139,1285,1064,1059,1078,1082,1026,1094,1255,1124,1092,999,
 1005,3589,2120,3364,2348,1194,1258,1110,1167,1184,1222,1117,
 1199,1242,1292,1185,1233,4224,4008,2040,2050,2068],
 [14,29,42,32,18,21,100,94,69,95,83,108,74,101,73,72,96,
 65,106,62,68,52,57,326,312,333,337,374,286,334,300,240,
 318,255,251,201,203,287,207,319,295,311,235,192,187,588,
 575,482,467,500,496,455,580,585,545,479,489,485,427,505,
 525,465,599,584,550,510,502,516,431,796,784,804,862,873,
 807,871,765,810,939,798,787,1357,976,1434,813,977,1325,
 779,1050,1139,1091,1158,1064,1059,1052,1039,1078,1082,1156,
 1089,1026,1094,1126,1249,1124,1092,1065,1002,999,1005,1154,
 1103,1194,2217,1258,1110,2450,1167,1184,2287,1222,1117,2350,
 1199,1242,2556,1292,1185,2307,1233,2040,4375,2050,4510,2068,
 4816],
 [14,33,36,23,21,58,51,50,97,79,69,88,76,77,55,101,73,103,
 72,54,60,87,106,93,80,81,282,481,352,521,346,491,208,
 234,307,304,351,359,280,247,215,318,270,216,221,437,386,
 277,253,267,254,328,295,262,323,273,258,220,343,490,451,
 570,592,614,554,416,574,602,533,450,612,608,507,413,557,
 571,590,563,452,601,621,529,396,566,577,746,712,1505,763,
 723,1379,791,1129,838,1260,846,1157],
 [14,33,36,38,21,58,97,79,94,69,92,88,89,55,104,83,108,
 102,103,54,78,90,86,80,81,98,384,481,422,425,444,371,
 334,298,304,351,359,248,255,221,288,382,437,436,213,254,
 328,295,226,305,290,306,220,301,357,575,565,614,624,596,
 604,585,572,412,608,625,582,611,590,581,584,573,593,591,
 454,577,587,950,1710,878,685,1603,892,1639,861,699,1524,
 1762,1388,1766,1364,1453,1601,2108,2113,1534,1741,1221,1025,
 1548,2054,2005,1649,1665,1128,1051,1398,1337],
 [14,33,36,42,23,21,51,100,94,69,95,77,53,55,108,101,102,
 73,63,103,54,78,60,106,93,80,81,282,481,352,521,346,433,
 491,371,342,324,279,193,309,270,216,221,388,406,294,200,
 267,213,254,273,258,220,357,343,490,451,574,602,533,450,
 507,413,571,590,529,396,566,577,663,630,793,772,1291,685,
 701,636,816,751,1346,699,954,842,1056,1228,1145,1131,1239,
 1221,1105,1127,1083,1243,1193,1128,1437,1358,1368,1467,1402,
 1432,1307,1397,1408,1430,1336,1389,2013,1971,1962],
 [14,33,36,42,23,21,58,50,61,97,100,79,105,69,92,89,59,95,
 77,71,55,83,108,74,101,73,84,103,54,78,91,86,106,93,80,
 99,81,62,52,57,334,234,291,298,359,309,329,255,243,270,
 221,437,253,238,213,231,245,349,305,290,273,220,357,692,
 824,1400,685,672,802,939,1424,699,2257,2123],
 [14,33,36,42,23,21,58,50,61,97,100,79,105,69,92,95,77,71,
 55,83,108,74,101,73,84,103,54,91,86,106,93,80,99,81,62,
 52,57,334,234,307,291,298,304,359,318,329,255,243,270,
 221,437,253,267,238,213,254,231,245,323,349,305,290,273,
 220,357,692,824,950,1400,685,672,802,892,939,1424,699,
 2257,2123],
 [14,33,36,42,23,21,58,50,97,100,79,105,69,92,89,66,59,95,
 77,71,55,83,108,74,101,73,84,103,54,78,86,106,93,80,99,
 81,62,52,57,334,315,298,359,247,215,309,329,255,243,270,
 206,221,437,253,213,305,273,220,357,877,862,800,1400,746,
 712,685,864,901,704,699,829,897,698,3258,1930,1793,4656,
 2084,1989,4679,1969,1934,5288,4981,4896,4583,4373,7709,7218]
  ,[14,33,36,42,23,21,58,51,50,61,97,100,79,94,69,76,95,
 77,53,55,83,108,74,101,102,73,63,103,72,54,78,90,86,70,
 106,80,99,68,57,300,240,307,291,304,350,261,329,255,243,
 206,251,203,382,435,287,207,267,238,254,228,235,187,314,
 335,893,864,807,901,704,829,787,897,698,2651,2849],
 [14,33,36,42,23,21,58,51,50,61,97,100,79,94,105,69,92,89,
 66,76,59,95,77,53,71,55,83,108,74,101,102,73,63,84,103,
 72,54,78,96,60,65,90,91,86,70,106,93,80,99,81,62,68,
 52,57],
 [14,33,36,42,23,21,58,51,50,94,89,59,95,53,108,102,73,63,
 78,106,80,282,481,352,346,491,279,208,193,309,255,270,
 221,294,277,200,305,273,220,357,490,430,451,567,469,574,
 602,572,533,466,450,507,413,525,591,555,442,529,396,566,
 577,630,772,912,685,636,751,699,954,842,905,907,1056,1228,
 1003,1145,1131,1294,1304,1588,2503,2267,988,969,1119,1239,
 1221,1025,1017,946,1105,1127,1074,1083,1243,1046,1019,1060,
 1193,1128,1051,1284,1080,2458,2031,2177,1437,1358,1384,2217,
 1368,1467,2009,1402,1432,1398,2287,1307,1397,1425,1408,1430,
 1336,1389,1337,1970,4213,4017,3929,4515,3950,4957,3659,3696,
 7761,4516,4331,3224,8377,5453,3921,4066,3414,3976,4127,7139,
 4266,4906,3223,5640,4536,2013,1971,1962,3579,6043,2732,8488,
 2967,3524,4133,3867,3179,7868,3271,5295,3668,5153,2805,7298,
 3217,3701,4089,4119,3226,5510,3582,3655,3632,4935,2804,7850,
 3611,3934,3206,6669,3542,3615,3174,8724,7614,6130,6804,6676,
 6416,5056,6859,5997,5663,7377,4976,5960,6091,5036,7419,7916,
 8195,8657,7551,8980,7348,7065,7060,6730,8530,7106,6176,6360,
 6600,6399,7488,7986,7013,6777,6167,7590,6405],
 [14,33,36,42,23,21,58,51,50,94,89,76,59,53,101,102,73,63,
 72,90,70,106,93,80,81,68,282,422,521,491,279,208,193,
 222,351,322,331,280,302,293,318,255,216,294,277,200,223,
 328,262,321,358,323,305,258,343,490,451,397,592,614,604,
 554,416,543,574,602,533,450,507,413,448,571,590,563,452,
 559,601,621,529,396,566,577,1291,823,1042,1346,923,1054,
 791,1129,838,1260,846,1157,1145,1131,1730,1083,1243,1773],
 [14,33,36,42,23,21,58,51,50,97,79,69,76,77,55,101,102,73,
 63,103,54,60,106,93,80,81,282,481,352,521,346,491,208,
 234,309,318,216,277,253,328,295,258,343,490,451,500,455,
 574,609,602,533,450,489,427,507,413,505,465,571,620,590,
 529,396,502,431,566,615,577,819,784,1291,685,873,863,765,
 1346,699,798,954,1129,842,838,1260,846,1157,1056,1870,1228,
 1145,1861,1131,1239,1955,1221,1105,1897,1127,1083,1819,1243,
 1193,1937,1128,1437,1358,1194,1258,1368,1467,1110,1167,1402,
 1432,1184,1222,1307,1397,1117,1199,1408,1430,1242,1292,1336,
 1389,1185,1233,5284,2013,5883,1971,5176,1962],
 [14,33,36,42,23,21,58,51,50,97,79,94,69,89,76,59,77,53,
 55,102,73,63,103,72,54,106,93,80,81,282,481,422,352,521,
 346,491,208,351,280,230,318,255,270,216,221,437,386,277,
 328,262,246,323,305,273,258,220,357,343,490,451,592,614,
 554,416,574,602,533,450,612,608,507,413,571,590,563,452,
 601,621,529,396,566,577,791,1129,838,1260,846,1157],
 [14,33,36,42,23,21,58,51,50,97,100,79,94,69,66,76,95,77,
 53,55,83,108,74,101,102,73,63,103,72,54,78,90,86,70,
 106,80,99,68,57,315,300,240,307,304,350,206,251,203,382,
 435,383,287,207,267,254,308,228,349,305,290,239,235,187,
 314,335,722,1272,1334,1710,715,1053,1198,1639],
 [14,33,36,42,23,21,58,51,50,100,69,95,77,55,108,73,103,
 54,60,86,106,93,80,81,57,282,433,491,371,279,193,359,
 230,309,318,270,221,294,200,253,267,213,254,295,246,231,
 245,323,273,220,357,490,451,604,453,574,602,533,450,507,
 413,448,571,590,573,417,559,529,396,566,577,877,663,630,
 793,772,685,938,701,636,816,672,802,751,699,954,842,1426,
 1056,1228,1145,1131,1239,1221,1443,1105,1127,1738,1083,1243,
 1193,1128,2452,2357,2396,2467,1437,1358,1368,1467,1402,1432,
 1307,1397,1408,1430,1336,1389,6058,5610,2013,1971,1962],
 [14,33,39,36,28,38,23,21,50,97,94,69,92,76,53,55,83,108,
 101,63,103,72,78,60,90,86,106,80,81,68,237,282,481,364,
 352,425,367,346,476,444,380,491,208,307,351,243,382,386,
 277,267,328,226,290,314,343,578,490,501,570,614,580,589,
 572,561,608,507,487,557,590,417,623,591,553,577,739,724,
 958,2039,910,2098],
 [14,33,39,36,28,38,23,21,51,50,97,100,94,69,92,89,76,95,
 53,55,83,108,101,73,63,103,72,78,60,65,90,86,106,80,81,
 62,68,57,237,282,384,369,481,422,541,364,352,425,367,521,
 346,476,361,433,444,380,491,371,472],
 [14,33,39,36,28,38,23,21,51,50,100,92,89,76,95,53,83,108,
 101,73,63,72,60,65,90,106,80,81,68,237,282,422,541,364,
 352,425,367,521,346,476,361,433,444,380,491,371,472,222,
 302,318,216,382,386,223,321,323,258,314,343,482,495,545,
 503,550,532,1042,1054,2560,1621,2449,2525,1569,2393,2439,
 1807,2414,907,1119,931],
 [14,33,39,36,28,38,23,21,51,50,100,92,89,95,53,108,73,63,
 72,65,90,106,80,68,237,282,422,364,352,346,476,444,380,
 491,472,279,234,298,229,230,255,294,253,213,260,246,305,
 490,430,501,397,614,554,513,453,493,580,572,466,507,487,
 448,525,571,590,581,563,517,417,523,623,591,555,539,566,
 587,737,755,907,1091,1011,1764,2113,1506,981,1052,881,988,
 946,1126,967,1405,1716,2005,1536,931,1065,1027,1046,1080,
 2180,1970,3545,4023,3590,3853,4815,3331,5383,3174,9053,6386]
  ,[14,33,39,36,28,38,23,21,58,51,50,61,97,100,94,69,92,
 89,66,76,95,53,55,83,108,101,73,63,103,72,78,96,60,65,
 87,90,86,106,80,99,81,62,68,57,300,272,350,247,261,206,
 435,287,269,308,250,231,228,239,335,876,853],
 [14,33,39,36,28,38,23,21,58,51,50,61,97,100,94,105,69,92,
 88,89,66,76,95,53,71,55,83,108,74,101,102,73,63,84,103,
 72,78,96,60,65,87,90,91,86,106,80,99,81,62,68,52,57],
 [14,36,28,23,58,51,50,97,82,92,88,76,95,83,64,101,103,56,
 72,65,106,57,282,541,395,346,433,387,472,234,280,215,266,
 251,201,382,404,437,277,253,231,226,258,314,325,357,536,
 554,458,489,412,561,473,507,426,512,514,417,529,456,553,
 463,924,692,739,733,873,697,921,957,672,724,702,723,664,
 875,792,1893,1321,1907,842,1282,1876,1047,1287,1035,1143,
 958,1020,993,1187,988,1221,1231,1018,1017,1100,1087,910,
 1264,1166,1019,1159,1168,886,2065,2536,2234,2483,2063,1988,
 2741,2390,2690,1549,1579,1550,1620,1481,1628,1516,1646,1576,
 1584,1562,1582,3117,2593,4818,4172,2149,4337,3476,3245,2704,
 3652,3675,5819,2322,4544,4137,3100,2623,4681,3670,2131,3470,
 3225,5855,2240,9123,2297,9273,2286,8059,3527,3360,3774,3567,
 5339,3119,3533,3152,3140,4905,3461,3457,3753,3464,5527,2728,
 3295,8364,8851,6653,8859,8853,9055,7487,8574,7665,7662,6092,
 7029,7391,7715,6620,9050,9042,7496,7429,9130,8261,6294,6955,
 7199,8602,8046,7163,6418,7087,7738],
 [14,36,42,23,21,58,50,61,97,82,100,79,69,89,59,95,77,55,
 83,108,74,101,73,103,56,54,78,86,106,93,80,99,81,57,
 334,234,300,240,291,298,350,309,329,255,243,206,382,437,
 435,287,207,238,213,228,349,305,290,273,239,220,314,335,
 784,692,824,722,794,1010,1400,893,746,712,1505,765,672,
 802,715,890,1424,947,763,723,699,1379,2257,2497,2643,2956,
 2866,1930,2123,2692,3029,3014,1998,5083,5281],
 [14,36,42,23,21,58,51,50,100,94,89,59,95,53,108,101,102,
 73,63,56,78,106,93,80,81,282,481,352,521,346,491,371,
 279,186,193,222,322,331,302,309,293,255,270,216,221,386,
 294,202,200,223,213,319,311,273,258,220,357,490,451,574,
 602,572,533,450,507,413,571,590,529,396,566,577,630,772,
 695,685,762,807,636,751,753,699,785,787,1500,954,842,1056,
 1228,1145,1131,1239,1221,1108,1105,1127,1083,1243,1193,1128,
 1057,3902,3268,1437,1358,1368,1467,1402,1432,1307,1397,1408,
 1430,1336,1389,2013,1971,1962],
 [14,36,42,28,23,58,51,50,100,92,76,95,108,102,73,72,65,
 86,62,49,57,282,422,541,395,476,387,279,186,229,244,215,
 302,310,288,294,202,260,214,246,245,321,330,235,192,357,
 467,490,430,536,554,458,543,522,489,412,473,449,507,426,
 512,563,478,514,417,559,523,463,577,877,761,887,716,879,
 900,938,747,874,745,751,890,798,806,791,1129,838,1260,
 1157,1403,1426,905,1102,1143,958,1020,993,1216,937,1231,
 1018,1512,1443,1017,1100,1087,910,885,1038,1243,1254,1009,
 1168,886,2509,2473,2472,2066,2148,1678,1460,2074,1728,1412,
 1734,1447,2038,1641,1411,2366,1644,1441,1802,1414,2245,5471,
 2149,2322,5972,2128,2181,2142,2231,2755,3009,2899,3334,2783,
 3264,2697,3013,2803,3209,2863,3161,5804,5627,5263,5852,5869,
 5350,5246,4945,5066,5748,5201,5548],
 [14,38,21,51,50,61,97,100,79,94,105,69,89,53,83,108,74,
 101,73,54,78,96,60,65,87,90,91,86,80,62,52,57,237,353,
 326,364,312,333,361,405,240,272,291,298,215,261,302,437,
 207,269,245,228,321,348,455,530,570,536,556,477,564,561,
 473,527,465,534,459,552,559,523,568,950,1635,912,1505,892,
 1708,1122,1379,1006,828,1667,1335,1362,1671,1304,1081,1538,
 1095,1345,1738,1405,1223,1570,1214,1203,1602,1080,1215,1869,
 1892,1865,2136,1882,1827,1878,2085,1850,1880,1879,2034,1965,
 2037,2014],
 [14,38,21,51,50,61,97,100,79,94,105,69,89,53,83,108,74,
 101,103,54,78,60,65,87,90,91,86,80,62,52,57,237,353,
 326,364,312,333,361,405,240,272,291,298,248,215,261,437,
 207,269,238,226,245,228,348,349,455,530,570,536,556,477,
 564,543,473,527,465,534,557,459,552,559,523,568,950,1272,
 912,1505,892,1053,1122,1379,1006,828,1335,1362,1304,1081,
 1095,1345,1405,1223,1214,1203,1080,1215,1869,1892,2283,1865,
 2136,2009,1882,1827,2205,1878,2085,2180,1850,1880,1961,1879,
 2034,1970,1965,2037,2014],
 [14,38,21,51,50,61,97,100,79,94,105,69,89,66,53,71,83,
 108,74,101,73,103,54,78,96,60,65,87,90,91,86,80,99,62,
 237,353,326,364,312,333,361,405,240,272,298,215,261,437,
 435,386,207,269,245,228,348,455,530,536,556,477,564,473,
 527,465,534,459,552,523,568,950,912,1505,1975,1670,892,
 1122,1379,2044,1500,1006,828,1335,1362,1304,1081,1095,1345,
 1405,1223,1214,1203,1080,1215,1869,1892,1865,2136,1882,1827,
 1878,2085,1850,1880,1879,2034,1965,2037,2014],
 [14,38,21,51,50,61,97,100,79,94,105,69,92,88,66,76,53,83,
 108,74,101,73,63,84,72,96,60,65,87,90,91,86,80,68,237,
 353,326,312,333,361,405,374,302,293,318,267,358,323,314,
 335,343,477,564,543,522,549,465,534,557,523,568,431,486,
 553,463,480,663,915,930,1291,695,701,801,869,1346,753,756,
 1177,1188,1343,1207,1296,1506,981,1076,1031,1175,1521,1241,
 1383,1444,1179,1189,1536,931,1058,1138,1300,1541,1473,1599,
 1573,1676,2281,1527,1466,1545,1717,1509,1552,1977,1535,1647,
 1997,1951,1959],
 [14,38,21,51,50,61,97,100,79,94,105,69,92,88,66,76,53,83,
 108,74,101,73,72,96,60,65,87,90,91,86,80,68,237,353,
 326,312,333,361,405,374,215,261,302,293,318,435,386,267,
 358,323,314,335,343,477,564,543,522,549,561,473,527,465,
 534,559,523,568,431,486,553,463,480,663,915,712,845,695,
 701,801,723,941,753,738,756,1177,1188,1207,1296,1031,1175,
 1241,1383,1179,1189,1138,1300,1981,1473,1599,1782,1573,1676,
 2144,1527,1466,1791,1545,1717,1944,1509,1552,1888,1535,1647,
 1997,1951,1959],
 [14,38,21,51,50,61,97,100,79,94,105,69,92,88,76,53,71,83,
 108,74,101,73,63,84,72,60,65,87,90,91,86,80,99,237,353,
 326,312,333,361,405,374,302,293,318,329,437,435,386,267,
 238,358,323,349,314,357,335,343,477,564,522,549,473,527,
 465,534,523,568,431,486,463,480,663,896,915,695,701,889,
 801,753,738,756,1177,1188,1207,1296,1031,1175,1241,1383,
 1179,1189,1138,1300,1473,1599,1573,1676,1527,1466,1545,1717,
 1509,1552,1535,1647,1997,1951,1959],
 [14,38,21,58,51,50,61,97,82,100,79,94,105,69,85,92,88,89,
 66,76,59,95,53,71,55,104,83,108,74,101,102,73,63,84,
 103,56,72,54,78,96,60,75,65,87,90,91,86,70,106,80,99,
 81,98,62,68,52,57],
 [14,38,21,58,97,82,100,79,94,69,92,88,89,83,108,102,73,
 103,54,78,75,65,87,90,86,80,62,384,481,422,425,444,334,
 259,298,359,310,309,255,437,436,217,213,295,330,348,305,
 357,575,565,455,530,536,556,614,624,596,604,477,564,522,
 549,602,598,585,572,427,508,473,527,608,625,582,611,465,
 534,512,544,590,581,584,573,459,552,523,568,621,638,593,
 591,431,486,463,480,577,587,1762,1388,2299,1129,1766,1364,
 2305,1260,1803,1453,2169,1157],
 [14,38,21,58,97,100,79,94,69,92,88,89,83,108,73,103,56,
 54,78,65,87,90,86,70,106,80,62,384,481,422,425,444,491,
 334,186,259,298,304,351,359,331,320,309,255,437,436,202,
 217,213,295,311,303,231,348,305,357,575,565,614,624,596,
 604,602,598,585,572,608,625,582,611,590,581,584,573,621,
 638,593,591,577,587,692,1112,1192,1063,672,918,1344,1289,
 1762,1388,1766,1364,1803,1453,1335,1362,1304,1081,1095,1345,
 1405,1223,1214,1203,1080,1215,2283,2009,2205,2180,1961,1970,
 3467,2853,2980,4147,2624,3308],
 [14,38,21,97,82,100,79,94,69,85,92,88,89,55,104,83,108,
 73,103,56,54,78,75,65,87,90,86,70,106,80,62,384,481,
 422,425,444,491,334,298,304,351,359,309,255,203,292,437,
 436,213,254,328,295,348,305,187,278,357,588,575,565,614,
 624,637,596,604,602,598,580,585,572,561,608,625,626,582,
 611,590,581,599,584,573,621,638,623,593,591,553,577,587,
 1762,1388,1766,1364,1803,1453],
 [14,38,21,97,82,100,79,94,69,85,92,88,89,59,95,55,104,83,
 108,102,73,103,54,78,75,65,87,90,86,70,106,80,81,98,62,
 384,481,422,425,444,491,371,342,334,298,359,310,309,255,
 437,388,436,213,295,330,348,305,357,575,565,614,624,596,
 604,602,598,585,572,608,625,582,611,590,581,584,573,621,
 638,593,591,577,587,1762,1388,1766,1364,1803,1453],
 [14,38,21,97,100,79,94,69,92,88,89,83,108,73,103,54,78,
 65,87,90,86,80,62,384,481,422,425,444,334,259,298,359,
 331,320,309,255,221,288,437,388,436,213,295,311,303,348,
 305,220,301,357,575,565,455,530,614,624,637,596,604,461,
 602,598,585,572,412,427,508,608,625,582,611,590,581,584,
 573,459,552,621,638,593,591,454,577,587,1482,703,808,1661,
 725,799,1762,1388,1766,1364,1803,1453,1079,1055,1335,1362,
 1234,1304,1081,1419,1078,951,1095,1345,1106,1405,1223,1317,
 984,1214,1203,1363,999,1080,1215,2283,2973,1619,2009,2205,
 2951,1608,2180,1961,3001,1654,1970,3506,3066,4426,3713,2976,
 4357],
 [14,38,51,50,61,97,79,69,92,88,89,76,55,83,64,101,63,103,
 72,54,96,60,65,87,90,81,62,68,237,326,421,364,428,361,
 393,208,300,291,351,350,227,248,261,206,216,288,276,404,
 435,386,287,238,328,308,262,250,239,301,325,343,464,495,
 441,556,461,511,503,447,527,483,544,519,532,468,480,719,
 670,847,845,662,1023,1975,709,669,645,932,2044,828,972,
 1055,1011,933,881,1077,951,1024,1130,967,984,1027,917,911,
 2134,2129,2274,2239,1623,1749,1600,1477,1508,1633,1593,1489,
 1638,1673,1494,1370,3320,3176,1926,1915,1921],
 [14,39,20,18,15,51,50,61,69,92,88,89,77,55,64,108,101,63,
 103,60,87,86,93,81,49,57,237,421,333,428,361,393,279,
 291,298,351,229,309,243,270,206,288,382,437,294,277,238,
 213,328,260,226,228,348,290,273,239,301,314,357,464,495,
 441,556,526,547,509,549,511,503,524,447,527,474,538,483,
 544,519,532,470,568,535,539,498,468,480,924,739,722,1015,
 724,715,1475,844,1468,738,1463,756],
 [14,39,20,38,18,15,50,97,69,88,89,76,55,64,101,103,60,87,
 90,81,68,237,326,421,364,428,208,248,215,261,216,404,386,
 262,226,245,228,314,325,343,578,565,464,495,592,558,461,
 589,572,511,503,447,527,562,519,532,494,431,468,480,719,
 670,662,709,801,669,645,972,899,1426,1188,1055,1011,1145,
 933,881,902,1290,1175,951,1024,1455,1018,1356,1130,967,928,
 1406,1179,1189,1083,984,1027,917,1348,911,1448,886,1275,
 1785,1801,1821,1599,1623,1749,1600,1477,1750,1466,1508,1633,
 2408,1593,1489,1810,1552,1638,1673,1494,1370,2186,2141,2928,
 3970,2847,2625,2840,3578,2405,3255,3348,2521,3087,3862,3040,
 2573,2554,3060,3521,2531,3212,3065,2522,1926,1915,1921,2613,
 4772,3667,3572,3567,3563,2880,2759,3512,3533,3070,2846,2617,
 2822,3619,2553,3063,3140,2744,2506,2484,4631,4887,3553,3457,
 3409,2838,2817,2968,4853,3367,3603,3464,3728,2743,2836,3106,
 3295,2696,2555,2578,5739,4149,5713,5740,5848,8791,8720,3509,
 5795,3520,4546,7200,7539,3600,5275,3371,4399,7925,6820,3564,
 5551,3543,5507,5835,4581,5359,5466,4720,4950,4826,3742,6068,
 5598,4541,5727,5240,4907,5575,4480,3419,9095,9058,8343,5400,
 9239,9193,7744,5302,6915,6532,7233,6865,6320,5826,6424,7591,
 8198,5401,6427,8168,6159,6173,7250,5181,7605,9061,7499,5677,
 6510,7116,8407,7295,6087,6196,6443,7901,6162,6323,6972,6606,
 6341,6257],
 [14,39,20,38,18,15,50,100,69,88,89,66,95,55,108,73,63,84,
 103,65,91,86,106,81,62,49,57,428,374,393,334,315,279,
 240,298,229,244,230,309,255,266,270,437,436,383,294,207,
 213,260,214,246,348,305,306,273,357,588,464,495,455,441,
 556,526,547,461,509,549,580,511,503,447,527,626,474,538,
 465,483,544,519,532,494,470,568,623,535,539,468,480,1475,
 844,1468,738,1463,756],
 [14,39,20,38,18,15,51,50,61,69,92,88,89,55,64,101,73,63,
 84,103,60,87,86,81,49,57,237,421,333,428,361,393,279,
 298,243,270,382,437,213,260,262,314,357,464,551,495,397,
 530,441,556,511,560,503,412,508,447,527,448,534,483,544,
 519,546,532,454,486,468,480,935,719,1084,901,919,843,709,
 1101,897,872,1475,844,1468,738,828,1463,972,1055,1555,1011,
 933,1542,881,951,1454,1024,1130,1511,967,984,1526,1027,917,
 1348,911,1384,1359,1623,1749,1452,1422,1600,1477,1398,1306,
 1508,1633,1425,1413,1593,1489,1465,1390,1638,1673,1337,1428,
 1494,1370,1926,2798,1915,2858,1921,2883],
 [14,39,20,38,18,15,51,50,61,97,69,92,88,89,76,55,64,101,
 63,72,60,87,90,81,68,237,326,421,364,208,291,351,229,
 248,261,302,243,206,216,288,382,404,386,238,328,260,262,
 321,290,325,343,464,495,441,556,461,477,580,511,503,427,
 447,527,483,544,519,532,459,623,468,480,719,670,847,845,
 704,662,900,1603,709,669,698,645,806,1524,828,972,1055,
 1011,933,881,1077,951,1024,1121,1130,967,984,1027,917,911,
 1036,2134,2129,2274,2239,1623,1749,1600,1477,1508,1633,1593,
 1489,1638,1673,1494,1370,3320,3176,1926,1915,1921],
 [14,39,20,38,18,15,51,50,61,97,92,89,76,83,64,101,73,63,
 84,103,72,60,87,90,91,106,81,68,237,421,333,428,208,222,
 272,291,351,331,243,216,382,404,386,238,328,311,262,314,
 325,343,464,495,515,441,556,637,580,511,503,427,447,527,
 483,544,599,519,532,431,468,480,719,670,974,778,901,662,
 709,669,1021,795,897,645,828,972,1055,1011,933,881,1423,
 1078,951,1024,1130,967,984,1027,1420,999,917,911,1623,1749,
 1600,1477,1508,1633,1593,1489,1638,1673,1494,1370,1926,1915,
 1921],
 [14,39,20,38,18,15,51,50,61,97,92,89,76,83,73,63,84,103,
 72,65,91,106,62,237,421,333,428,361,393,208,291,351,270,
 216,404,437,386,238,328,214,262,246,325,357,343,464,495,
 430,501,441,536,556,511,503,466,506,447,473,527,483,512,
 544,519,532,478,517,468,463,480,720,719,761,670,919,662,
 710,709,747,669,872,645,1475,844,1468,738,828,1463,972,
 1055,1011,1114,1263,933,881,1173,1457,951,1024,1257,1530,
 1130,967,1034,1186,984,1027,1209,1396,917,911,1170,1393,
 1623,1550,1749,1600,1620,1477,1508,1516,1633,1593,1646,1489,
 1638,1562,1673,1494,1582,1370,1926,2798,1915,2858,1921,2883]
  ,[14,39,20,38,18,15,51,50,61,97,100,92,89,66,76,59,95,
 83,64,108,101,73,63,84,103,60,75,65,87,90,91,86,106,80,
 81,98,62,49,68,57,342,186,234,222,259,272,359,331,320,
 247,310,309,318,221,388,202,253,223,269,295,311,303,231,
 330,348,323,220,703,725],
 [14,39,20,38,18,15,51,50,61,100,92,89,66,95,55,108,73,63,
 84,65,91,86,106,62,49,57,237,421,428,374,279,222,272,
 298,229,244,230,302,309,255,266,270,437,294,223,269,260,
 214,246,321,348,305,306,273,187,357,464,495,441,556,526,
 547,461,509,549,580,511,503,447,527,474,538,519,532,494,
 470,568,623,535,539,431,468,480,737,912,755,1122,1475,844,
 1468,738,1463,756,1207,850,1081,1179,856,1203],
 [14,39,20,38,18,15,51,61,100,92,66,95,64,108,101,73,63,
 84,103,65,91,106,62,237,421,333,428,374,324,279,307,298,
 229,309,270,216,404,437,386,406,294,267,213,260,348,273,
 258,325,357,343,464,495,430,501,441,536,556,526,547,458,
 513,509,522,549,511,503,466,506,447,473,527,474,538,426,
 487,483,512,544,519,532,478,517,470,523,568,535,539,456,
 499,468,463,480,1475,844,888,2807,1468,738,825,2736,1463,
 756,833,2656],
 [14,39,20,38,18,15,58,50,97,100,69,85,88,89,66,76,59,95,
 53,55,104,108,73,84,103,56,78,60,75,65,87,90,86,70,80,
 98,62,49,68,57,334,315,229,244,230,247,215,309,206,288,
 202,253,207,260,214,246,348,239,301,187,1160,877,737,862,
 800,746,712,705,755,763,723,2008,2974,3258,1930,1793,1998,
 1784,2950,5025,5288,5216,7713,5022,6435],
 [14,39,20,38,18,15,58,51,50,61,97,82,100,94,69,85,92,88,
 89,66,76,59,95,53,55,104,83,64,108,101,102,73,63,84,
 103,56,72,78,60,75,65,87,90,91,86,70,106,80,81,98,62,
 49,68,57],
 [14,39,20,38,18,15,58,51,50,61,97,100,85,92,89,66,76,95,
 83,64,108,101,73,63,84,103,56,72,78,60,65,87,90,86,81,
 62,49,68,57,186,234,222,272,247,206,221,288,201,292,202,
 253,223,269,254,295,311,303,231,299,239,220,301,192,278,
 793,784,804,752,816,765,810,694,918,2216,2024],
 [14,39,20,38,51,50,61,92,89,71,55,83,74,73,63,84,72,65,
 90,91,106,62,68,52,237,421,364,333,361,393,279,208,222,
 272,291,351,244,230,216,276,203,404,386,294,223,269,238,
 213,328,214,262,246,321,305,306,209,187,325,343,464,495,
 515,441,556,511,503,447,527,488,483,544,519,532,459,468,
 480,630,719,814,1334,878,670,662,709,757,1198,861,669,645,
 828,972,1055,1011,1044,933,881,951,1024,1130,967,986,984,
 1027,917,911,2206,2296,1623,1749,1600,1477,1508,1633,1593,
 1489,1638,1673,1494,1370,1926,1915,1921],
 [14,39,20,42,32,18,21,15,50,97,94,69,76,53,55,108,63,103,
 78,60,86,80,81,68,237,282,326,364,352,312,428,344,337,
 405,374,208,307,351,243,382,386,277,267,328,290,314,343,
 578,464,455,537,556,592,624,580,589,572,450,427,540,527,
 474,562,505,465,534,504,544,452,601,638,623,591,431,497,
 480,739,724,899,1555,1285,1143,1262,2039,1454,1231,1356,
 1008,1227,1511,1255,1087,1169,2098,1348,1168,1275,2263,2642,
 3634,2546,2686,3035,3411,2539,2721,2634,3032,5282,5510,2918,
 4050,5345,8594,7285,7275,5033,6612,9196,9195],
 [14,39,20,42,32,18,21,15,51,50,97,100,94,69,92,89,76,59,
 95,53,55,83,108,101,102,73,63,84,103,72,78,60,75,65,90,
 86,106,93,80,81,98,62,68,57,342,315,259,322,320,310,221,
 388,383,202,217,319,303,330,220,1160,1238],
 [14,39,20,42,32,18,21,15,51,50,97,100,94,69,92,89,76,95,
 53,55,83,108,101,73,63,103,72,78,60,65,90,86,106,80,81,
 62,68,57,237,282,353,326,421,376,408,364,352,312,333,428,
 344,337,361,433,405,374,393,317,286],
 [14,39,20,42,32,18,21,15,51,50,100,92,89,95,53,55,108,73,
 63,103,72,78,65,90,86,106,80,62,68,57,237,282,353,421,
 376,408,364,352,312,333,428,344,337,361,433,405,374,393,
 317,286,279,234,298,229,230,255,294,253,213,260,246,305,
 187,430,466,478,737,755,1475,1468,1463],
 [14,39,20,42,32,18,21,15,51,50,100,92,89,95,53,55,108,73,
 63,103,72,78,65,90,86,106,80,62,68,57,237,282,421,364,
 352,428,344,337,405,374,317,286,279,234,298,229,230,255,
 294,253,213,260,246,305,187,464,430,515,537,556,526,461,
 580,572,466,474,488,504,544,519,494,623,591,431,737,755,
 1207,988,1179,1046],
 [14,39,20,42,32,18,21,15,51,100,69,92,76,53,55,83,101,73,
 63,72,60,65,90,86,106,81,62,68,57,237,282,421,376,408,
 364,352,312,333,428,344,337,361,433,405,374,393,317,286,
 324,307,351,280,201,406,267,328,262,321,323,192,482,495,
 545,503,550,532,814,925,757,822,1357,1475,1434,1468,1325,
 1463],
 [14,39,20,42,32,18,21,15,51,100,69,92,76,53,55,83,101,73,
 63,72,60,65,90,86,106,81,62,68,57,353,326,364,352,333,
 361,433,405,393,317,286,324,307,351,280,201,406,267,328,
 262,321,323,192,588,565,455,537,556,526,545,503,524,626,
 611,465,504,544,550,519,532,459,548,568,498,814,925,757,
 822,1229,1277,1044,1219,1362,1355,1361,986,1217,1223],
 [14,39,20,42,32,18,21,15,58,51,50,61,97,82,100,94,69,85,
 92,89,76,59,95,77,53,55,104,83,108,101,102,73,63,84,
 103,56,72,78,60,75,65,90,86,70,106,93,80,81,98,62,68,
 57],
 [14,39,20,42,32,18,21,15,58,51,50,61,97,100,94,69,85,92,
 89,76,95,77,53,55,104,83,108,101,73,63,103,72,78,60,65,
 90,86,70,106,80,81,62,68,57,186,304,247,261,310,212,251,
 292,202,254,231,228,299,235,278,808,799],
 [14,39,21,50,82,100,69,85,92,89,76,59,95,77,55,104,83,
 108,101,73,63,72,75,65,90,86,70,106,93,80,81,98,62,68,
 57,422,541,425,367,521,346,476,444,380,491,371,472,334,
 359,310,255,436,295,330,305,588,565,482,495,637,604,567,
 547,580,572,545,503,626,611,528,538,599,573,550,532,623,
 591,555,539,2560,1621,2449,2525,1569,2393,2439,1807,2414],
 [14,39,21,50,100,105,69,92,88,89,66,76,95,71,55,83,108,
 74,101,73,63,72,65,90,91,86,106,80,99,81,62,68,52,57,
 421,376,408,312,333,428,344,337,405,374,393,317,286,334,
 359,329,255,266,436,295,349,305,306,588,565,482,495,637,
 604,567,547,580,572,545,503,626,611,528,538,599,573,550,
 532,623,591,555,539,1357,1475,1434,1468,1325,1463],
 [14,39,21,51,82,100,69,85,92,89,76,95,77,53,104,83,108,
 101,73,63,56,72,60,75,90,86,70,106,93,80,81,98,62,68,
 57,384,369,481,422,541,425,367,521,444,380,491,371,472,
 324,304,331,243,406,254,311,290,588,565,482,495,637,604,
 567,547,580,572,545,503,626,611,528,538,599,573,550,532,
 623,591,555,539,1388,2138,1364,2201,1453,2153],
 [14,39,21,51,100,105,69,92,88,89,66,76,95,53,83,108,74,
 101,73,63,72,96,60,87,90,91,86,106,80,99,81,62,68,52,
 57,353,326,421,376,408,312,333,405,374,393,317,286,324,
 350,331,243,406,308,311,290,588,565,482,495,637,604,567,
 547,580,572,545,503,626,611,528,538,599,573,550,532,623,
 591,555,539,1769,1310,1232,1774,1324,1301,1754,1385,1395],
 [14,39,21,58,51,50,61,97,82,100,94,105,69,85,92,88,89,66,
 76,59,95,77,53,71,55,104,83,108,74,101,102,73,63,84,
 103,56,72,78,96,60,75,65,87,90,91,86,70,106,93,80,99,
 81,98,62,68,52,57],
 [14,39,21,97,82,100,94,69,85,92,89,76,59,95,77,53,104,83,
 108,101,63,103,56,72,78,60,90,86,70,106,93,80,81,98,62,
 68,57,384,369,481,422,541,425,367,346,476,444,380,491,
 371,472,324,331,212,243,406,311,299,290,588,578,565,637,
 622,604,580,589,572,626,607,611,599,603,573,623,613,591,
 1762,1766,1803],
 [14,39,21,97,82,100,94,69,85,92,89,76,95,77,55,104,83,
 108,101,73,103,56,72,78,75,65,90,86,70,106,93,80,81,98,
 62,68,57,384,369,481,422,541,425,367,521,476,444,380,491,
 371,472,334,304,359,255,436,254,295,305,588,575,565,637,
 596,604,580,585,572,626,582,611,599,584,573,623,593,591,
 1388,1364,1453],
 [14,39,21,97,100,94,69,92,89,76,95,53,83,108,101,63,103,
 72,78,60,90,86,106,80,81,62,68,57,384,369,481,422,541,
 425,367,346,476,444,380,491,371,472,259,322,331,320,310,
 221,217,330,290,220,578,455,637,622,604,461,531,549,589,
 427,607,488,504,544,603,459,623,613,591,498,497,480,1768,
 1710,1042,1781,1639,923,1054,817,1762,1766,1803,2448,1760,
 2395,1354,1663,1234,1983,1730,2515,1532,1815,2228,1590,2089,
 1592,1773,1363,4911,3674,4877,4188,2973,4289,2951,4885,3001,
 4283,4491,4139,3685,4867,3513,3505,6004,7853,5706],
 [14,39,21,97,100,94,105,69,92,88,89,66,76,95,53,71,83,
 108,74,101,63,103,72,78,96,60,87,90,86,106,80,99,81,62,
 68,52,57,353,326,421,376,408,312,428,344,337,405,374,393,
 317,286,324,331,243,206,406,311,290,239,588,578,565,637,
 622,604,580,589,572,626,607,611,599,603,573,623,613,591,
 1502,1486,1401],
 [14,39,21,97,100,94,105,69,92,88,89,66,76,95,55,83,108,
 74,101,73,103,72,78,96,65,87,90,91,86,106,80,99,81,62,
 68,52,57,353,326,421,376,408,312,333,344,337,405,374,393,
 317,286,334,359,350,255,436,295,308,305,588,575,565,637,
 596,604,580,585,572,626,582,611,599,584,573,623,593,591,
 1769,1774,1754],
 [14,39,36,28,23,58,51,50,92,88,76,77,53,55,108,63,103,56,
 78,87,86,93,80,81,68,57,282,422,541,352,346,371,472,279,
 186,234,229,244,247,248,309,243,294,202,277,260,214,246,
 231,226,348,290,314,325,490,430,500,397,554,458,602,507,
 426,563,478,514,417,621,924,761,942,879,1015,747,884,801,
 980,890,806,791,838,1188,1143,958,1399,1446,1296,1216,937,
 1383,1087,910,1456,1406,1189,1254,1009,1168,886,1785,2485,
 1801,2416,2581,1678,1460,1728,1412,1641,1411,1644,1441,1802,
 1414,3341,2752,2181,2142,2231,5874,3831,3198,3007,2855,3068,
 3154,3132,2940,7442,8522,7937,7568,7659,5585,7121,5540,6044,
 9183,6472],
 [14,39,36,42,23,58,51,94,92,95,83,64,101,72,78,65,106,81,
 62,49,68,421,541,428,476,433,371,279,186,322,359,331,280,
 247,248,251,201,277,319,295,311,231,226,235,192,343,575,
 596,604,554,458,518,453,585,489,412,427,582,507,426,584,
 573,514,417,593,502,454,431,577,924,630,726,1291,1084,754,
 733,662,1015,702,1101,741,760,645,9288,8416,842,8352,1047,
 1287,1035,1338,1196,1131,1052,933,1187,988,1156,951,1377,
 1257,1366,1136,1264,1166,1065,984,1252,1046,1154,917,1204,
 1170,2206,2012,2296,1918,1549,1579,1740,1648,2754,1481,1628,
 2360,1714,1624,1576,1584,2534,1702,1682,2496,2447,2526,2329,
 2340,2594,2331,2240,2297,2286,3922,2644,5468,2615,4580,2774,
 5013,2610,4045,2665,5234,2738,9178,7078,7619,6157,6276,7000,
 5406,5061,5128,4979,5283,5697],
 [14,39,36,42,28,23,50,92,76,95,77,53,55,108,102,73,63,
 103,56,78,65,86,93,80,62,49,68,57,422,541,352,346,472,
 342,334,279,186,234,288,203,388,436,294,202,260,214,246,
 565,551,490,430,500,397,489,412,561,611,562,507,426,546,
 563,478,514,417,935,720,761,879,900,1246,843,710,747,890,
 806,1151,2201,838,1555,1305,1114,1143,958,1216,937,1231,
 1018,1538,1511,1182,1034,1087,910,1254,1009,1168,886,1602,
 3312,1733,1894,1678,1460,1958,1728,1412,1790,1734,1447,2490,
 1905,2188,1641,1411,1778,1644,1441,1982,1802,1414,7770,2181,
 9124,2142,7954,2231],
 [14,39,36,42,28,23,58,51,50,61,97,82,100,92,89,66,76,95,
 77,53,55,83,64,108,74,101,102,73,63,103,56,72,78,106,
 93,80,81,62,49,68,57,234,300,222,261,329,255,243,270,
 206,216,276,435,253,287,223,349,305,290,273,239,258,209,
 335,696,893,845,684,947,941],
 [14,39,36,42,28,23,58,51,50,61,97,82,100,94,105,69,92,89,
 66,76,95,77,53,71,55,83,64,108,74,101,102,73,63,84,103,
 56,72,78,96,60,65,90,91,86,106,93,80,99,81,62,49,68,
 52,57],
 [14,39,36,42,28,23,58,51,50,76,95,77,53,55,102,73,63,103,
 56,72,78,86,81,62,49,68,57,282,541,352,346,476,371,472,
 279,186,208,234,229,244,280,288,251,201,294,202,260,214,
 262,246,490,430,451,500,397,554,458,450,489,412,507,426,
 563,478,452,514,417,761,670,879,900,921,957,747,669,890,
 806,875,792,954,791,842,838,1047,1391,1143,958,1416,1216,
 937,1455,1231,1018,1299,1087,910,1445,1254,1009,1448,1168,
 886,1678,1460,1728,1412,1734,1447,1641,1411,1644,1441,1802,
 1414,2181,2142,2231],
 [14,39,36,42,28,23,58,51,50,94,92,76,77,53,55,83,64,101,
 63,103,56,78,81,68,57,282,352,346,476,472,279,186,280,
 247,248,309,243,288,251,201,382,404,294,202,277,290,258,
 235,192,314,325,554,458,518,453,572,489,412,561,507,426,
 591,529,456,502,454,553,924,726,733,685,900,1015,702,760,
 763,882,699,806,842,1287,1035,1338,1196,1296,1187,988,1366,
 1136,1383,1264,1166,1252,1046,1261,1369,1300,2415,3039,2420,
 2402,1549,1579,1740,1648,1996,1481,1628,1714,1624,2062,1576,
 1584,1702,1682,1888,2176,3483,3493,3477,4578,3252,4051,3265,
 3115,4086,3525,2240,2297,2286,5344,5028,3683,5155,4190,5561,
 4560,4046],
 [14,39,36,42,28,23,58,51,50,97,82,76,95,77,53,55,101,103,
 56,72,78,81,62,49,68,57,282,541,352,346,476,371,472,229,
 244,280,247,248,215,288,251,201,277,253,231,226,245,258,
 301,235,192,554,458,416,518,453,450,489,412,507,426,452,
 514,417,529,456,396,502,454,924,877,726,714,803,733,1015,
 938,702,721,820,760,791,842,1047,846,1287,1035,1338,1196,
 1187,988,1366,1136,1264,1166,1252,1046,1571,1549,1579,1373,
 1740,1648,1568,1481,1628,1380,1714,1624,1525,1576,1584,1417,
 1702,1682,2240,2419,2297,2434,2286,2493],
 [14,39,36,42,28,23,58,51,50,97,82,100,76,95,77,53,55,83,
 64,108,74,101,102,73,63,103,56,72,78,96,60,65,106,93,
 80,99,81,62,49,68,57,315,234,300,222,240,307,291,270,
 206,216,435,383,253,287,223,207,267,238,308,273,239,258,
 335,696,722,845,684,715,941],
 [14,39,38,18,15,58,50,97,100,85,89,66,76,59,95,55,108,
 102,73,84,103,56,78,96,60,75,65,87,90,86,80,98,62,49,
 68,57,334,315,229,215,309,436,383,202,253,287,223,207,
 269,295,303,260,214,246,239,220,301,187,1160,877,815,959,
 870,1238,938,895,1048,705,914,765,694,710,747,812,979,884,
 755,723,699,2008,2167,2109,1950,1995,2352,2107,2032,1976,
 2091,2308,2460,2712,2119,1988,2653,5867,9268,9246,3671,5616,
 5726,6450,3641,3360,5519,8424,7269,6369,8178],
 [14,39,38,18,15,97,69,88,76,55,64,101,103,72,60,87,90,81,
 68,326,364,425,428,243,404,386,207,267,290,578,565,622,
 604,453,564,580,589,572,447,527,612,607,611,448,465,534,
 603,573,623,613,591,454,486,566,924,700,726,670,733,1786,
 1670,1015,709,702,760,645,1771,1500,2560,1502,1068,2525,
 1486,996,2439,1401,1484,2656,1539,1079,1277,1426,1188,1354,
 1234,1267,1059,933,881,1595,1419,1208,1290,1175,936,1345,
 1532,1106,1361,1094,1130,967,1322,1317,1273,1406,1189,1592,
 1363,1235,1005,917,911,860,1215,3187,2368,1913,2023,2087,
 3609,2041,1925,4130,1821,1599,2172,2200,2973,1600,1477,2310,
 3804,1750,1466,1902,2046,1510,2951,1593,1489,2707,3927,1810,
 1552,2298,2052,3001,1494,1370,2186,1431,2786,3079,3585,2245,
 3970,2625,3578,2756,2405,2949,2839,2051,3348,2521,2900,3862,
 2573,2501,3084,2128,3521,2531,3065,2522,8671,9047,7861,9296,
 7518,3369,6471,8742,4767,7522,3532,2930,2880,2759,6075,2846,
 2617,8403,3194,3086,2506,2484,5923,2838,2817,8441,3746,2621,
 2743,2836,5907,2555,2578,8304,7589,8639,5888,8765,8745,5207,
 4288,4963,7425,5595,6886,7969,5774,6312,8452,5534,6609,6724,
 5262,3802,3509,8502,3520,6757,4125,3600,8190,3371,7304,3891,
 3564,7157,3543,6373,6957,7577,8204,8901,7624,7610,6873,6990,
 6800,7401,6572,6325,6659,8115,8205,7196,9093,7583,6596,6228,
 7115,7843],
 [14,39,38,50,97,69,92,88,89,76,55,83,64,101,63,103,72,60,
 65,87,90,81,62,68,237,326,421,364,428,361,393,208,300,
 248,261,216,404,386,287,262,226,228,325,335,343,578,565,
 464,495,614,554,461,589,572,511,503,447,527,507,603,573,
 519,532,494,529,468,480,719,670,662,709,869,669,645,972,
 1426,1188,1343,1055,1011,1131,933,881,1290,1175,1521,951,
 1024,1018,1356,1538,1130,967,1406,1189,1536,1243,984,1027,
 917,911,886,1275,1602,1974,1957,1821,1599,1623,1749,1600,
 1477,1750,1466,1508,1633,1593,1489,1810,1552,1638,1673,1494,
 1370,2304,3970,2625,3052,3578,2405,2519,3348,2521,3236,3862,
 2573,2935,3521,2531,2700,3065,2522,3291,1926,1915,1921,4772,
 3667,4523,3567,3563,2880,9224,2759,3533,3070,2846,8426,2617,
 3619,2553,4072,3140,2744,2506,4400,2484,3457,3409,2838,6997,
 2817,4853,3367,4419,3464,3728,2743,6808,2836,3295,2696,2555,
 4345,2578,3757,3509,3520,3904,3600,3371,3806,3564,3543,5835,
 4581,8923,5466,4720,6889,4826,3742,8451,5598,4541,7041,5240,
 4907,6571,4480,3419,8116,9211,7632,6501,6712,7604,6994],
 [14,39,38,50,100,105,69,92,88,89,71,55,64,108,74,101,73,
 63,84,103,96,60,65,87,91,86,106,99,81,62,49,52,57,421,
 333,428,361,374,393,334,315,279,291,298,351,229,309,270,
 437,436,383,294,238,213,328,260,348,273,357,588,464,495,
 441,556,526,547,509,549,511,503,447,527,626,474,538,483,
 544,519,532,470,568,535,539,468,480,1475,844,1468,738,
 1463,756],
 [14,39,38,51,50,61,97,69,88,89,76,55,83,64,74,101,73,63,
 84,103,72,96,60,65,87,90,91,106,99,81,62,68,52,237,326,
 421,364,333,428,361,393,208,300,240,291,351,350,216,404,
 386,207,238,328,308,262,325,343,464,495,441,556,511,503,
 447,527,483,544,519,532,468,480,719,670,880,662,709,669,
 940,645,828,972,1055,1011,933,881,951,1024,1130,967,984,
 1027,917,911,1623,1749,1600,1477,1508,1633,1593,1489,1638,
 1673,1494,1370,1926,1915,1921],
 [14,39,38,51,50,61,97,69,92,88,76,55,83,64,101,73,63,84,
 103,72,60,65,87,90,91,106,81,62,68,52,237,326,364,333,
 428,361,393,208,307,291,351,216,404,386,267,238,328,262,
 250,325,343,464,495,490,455,441,570,556,511,503,533,447,
 561,527,465,483,557,544,519,532,563,468,553,480,719,876,
 670,662,709,853,669,645,828,972,1055,1011,1305,933,881,
 1190,951,1024,1377,1130,967,1182,984,1027,1274,917,911,
 1204,1623,2547,1749,1600,2754,1477,1508,2360,1633,1593,3092,
 1489,1638,2534,1673,1494,2496,1370,1926,1915,1921],
 [14,39,38,51,50,61,97,105,69,92,88,89,71,55,83,64,74,101,
 73,63,84,103,72,96,60,65,87,90,99,81,62,68,237,326,421,
 364,333,428,361,393,208,291,298,351,206,216,288,404,435,
 386,238,213,328,262,325,335,343,464,495,441,556,511,503,
 447,527,483,544,519,532,468,480,719,670,704,662,900,709,
 669,698,645,806,828,972,1055,1011,933,881,951,1024,1130,
 967,984,1027,917,911,1623,1749,1600,1477,1508,1633,1593,
 1489,1638,1673,1494,1370,1926,1915,1921],
 [14,39,38,51,50,61,100,69,92,88,89,66,95,55,64,108,74,
 101,73,63,84,103,60,65,87,86,81,62,49,57,237,421,333,
 428,361,393,279,298,229,309,270,206,288,437,435,294,213,
 260,348,273,239,301,357,335,464,495,490,441,570,556,526,
 547,554,509,543,549,511,503,533,524,447,561,527,474,538,
 507,483,557,544,519,532,563,470,559,568,535,539,529,498,
 468,553,480,1475,844,1468,738,1463,756],
 [14,39,38,51,50,61,100,69,92,88,89,66,95,55,64,108,101,
 63,103,96,60,65,87,86,81,62,49,57,237,421,333,428,361,
 393,279,298,350,229,227,309,270,206,288,276,437,435,294,
 287,213,308,260,250,226,228,348,273,239,301,209,357,335,
 464,495,441,556,526,547,509,549,511,503,524,447,527,474,
 538,483,544,519,532,470,568,535,539,498,468,480,815,739,
 722,895,724,715,1475,844,1468,738,1463,756],
 [14,39,38,51,50,61,100,105,69,92,88,89,66,95,71,55,64,
 108,101,73,63,84,103,60,65,87,91,86,106,99,81,62,49,52,
 57,237,421,333,428,361,374,393,279,298,229,227,309,329,
 270,437,294,213,260,250,348,349,273,357,464,495,441,556,
 526,547,509,549,511,503,447,527,474,538,483,544,519,532,
 470,568,535,539,468,480,1475,844,1468,738,1463,756],
 [14,39,38,58,51,50,61,97,82,100,94,105,69,85,92,88,89,66,
 76,59,95,53,71,55,104,83,64,108,74,101,102,73,63,84,
 103,56,72,78,96,60,75,65,87,90,91,86,70,106,80,99,81,
 98,62,49,68,52,57],
 [14,39,38,58,97,100,85,92,89,76,53,104,83,64,108,101,102,
 63,103,56,72,78,60,75,87,90,86,70,81,62,68,384,422,425,
 346,476,444,371,324,186,234,222,272,243,201,292,404,386,
 202,253,223,269,254,311,192,278,325,343,578,565,397,530,
 589,572,412,508,608,448,534,603,573,454,486,577,793,804,
 983,901,816,810,920,897,1271,1281,1111,1197,1245,1072,1137,
 1108,1227,1240,1116,1150,1218,1057,1384,1359,1452,1422,1398,
 1306,1425,1413,1465,1390,1337,1428,2346,2379,2330],
 [14,39,38,58,97,100,85,92,89,76,83,64,108,101,63,103,56,
 72,78,60,87,90,86,81,62,49,68,57,384,422,425,346,476,
 444,371,472,324,186,234,222,272,247,243,221,201,292,202,
 253,223,269,254,295,311,303,231,299,220,192,278,578,565,
 397,530,589,572,412,508,448,534,603,573,454,486,793,784,
 804,752,983,901,816,765,810,694,918,920,897,1271,1281,
 1111,1197,1245,1072,1137,1108,1227,1240,1116,1150,1218,1057,
 2216,2024,1384,1359,1452,1422,1398,1306,1425,1413,1465,1390,
 1337,1428,2346,2379,2330],
 [14,39,38,97,82,100,94,85,92,89,76,53,104,83,64,108,101,
 63,103,56,72,78,60,87,90,86,81,49,68,57,384,422,425,
 346,476,444,472,324,222,272,212,243,201,292,382,223,269,
 311,192,278,314,588,578,565,397,455,530,580,589,572,412,
 427,508,561,448,465,534,599,603,573,454,431,486,553,804,
 983,635,901,810,920,628,897,1271,1281,1050,1111,1197,1064,
 1245,1072,1078,1137,1108,1026,1227,1240,1124,1116,1150,999,
 1218,1057,1384,1258,1359,1452,1167,1422,1398,1222,1306,1425,
 1199,1413,1465,1292,1390,1337,1233,1428,2346,2379,2330],
 [14,39,38,97,82,100,94,85,92,89,76,59,53,104,83,64,108,
 101,102,63,103,56,72,78,60,75,87,90,86,81,62,49,57,384,
 422,425,346,476,444,371,472,342,324,222,272,243,221,201,
 292,437,223,269,311,220,192,278,357,578,565,397,530,589,
 572,412,508,448,534,603,573,454,486,804,1333,983,901,810,
 1265,920,897,1271,1281,1111,1197,1245,1072,1137,1108,1227,
 1240,1116,1150,1218,1057,1384,1359,1452,1422,1398,1306,1425,
 1413,1465,1390,1337,1428,2346,2379,2330],
 [14,39,38,100,69,92,88,55,64,74,101,103,60,65,87,86,81,
 49,57,384,421,425,333,361,444,393,307,298,350,280,276,
 437,308,262,348,209,335,578,565,441,556,622,604,453,564,
 574,412,508,447,527,607,611,571,603,573,417,552,470,568,
 454,486,566,1318,794,1084,912,919,1340,892,776,1101,883,
 872,1379,3977,844,1006,738,4212,756,972,1539,1079,1277,
 1354,1234,1267,1059,933,881,850,1081,1082,951,1024,1532,
 1106,1361,952,1223,1322,1317,1273,1092,984,1027,1005,917,
 911,860,1215,1974,2132,1957,2551,2251,1706,1579,1798,2162,
 1733,1619,1648,1662,1167,2077,2279,1628,1622,1222,2067,1825,
 1608,1624,1744,2280,1905,1723,1584,1720,1292,1980,1841,1682,
 1680,1233,1986,2194,3242,2642,2779,3111,3736,3210,3238,3035,
 2872,2993,3303,3479,8473,4644,8983,4617,8543,4335,5090,9152,
 9308,8541,8264,4501,5300,7597,8332,8047,7763,5787,5225,2644,
 2816,3969,2575,2791,5014,2615,2850,4765,2876,3288,4634,2774,
 2684,4055,2544,3705,5863,2610,2833,4509,2875,2955,5876,2665,
 2777,3770,2545,3059,4755,2738,2832,4792,2813,4099,9201,9138,
 8469,7343,7340,7318,8650,8630,8990,8249,7366,6866,9079,7974,
 7555,7546,8314,8670,8060,8055,7156,8243,6139,7673,5049,5594,
 9293,8309,7644,5718,7672,7606,5760,7128,6885,8544,8722,8909,
 5451,7471],
 [14,39,42,23,100,92,95,77,53,108,102,73,72,78,75,65,93,
 80,81,62,49,68,421,422,352,428,476,371,472,342,334,234,
 229,244,216,288,386,388,436,294,202,217,311,246,258,343,
 575,565,500,397,554,458,585,489,412,582,611,507,426,514,
 417,593,1318,1160,644,804,879,714,803,1340,1238,665,636,
 747,721,820,806,791,2807,1364,838,2736,1453,2656,1287,1035,
 1091,1055,1216,937,1187,988,1156,951,1366,1136,1127,1087,
 910,1065,984,1252,1046,1168,886,2288,1995,2636,3075,2716,
 2365,2091,2581,2898,2158,2463,1728,1412,2318,2589,1641,1411,
 2295,2901,1802,1414,2632,3172,3235,2826,3377,3057,2512,3391,
 3136,3047,2329,2638,3322,3254,2413,4140,3341,2752,2340,3281,
 2931,2631,4111,9181,2181,9267,2142,7622,2231,6655,7656,2720,
 2920,8045,3528,3423,3453,3605,5943,2814,2953,3068,3154,4143,
 3435,3443,8393,8378,7329,9142,8465,6985,8072,6744,6374,6389,
 7092,7452,7809,8899,6281,7333,7667,7362,9305,6870,8018,7335,
 6989,6131,7643,8294,7621,7253,6166,7021],
 [14,39,42,50,94,85,92,76,59,95,77,53,55,104,83,64,101,63,
 72,78,65,70,106,81,98,62,49,68,57,282,541,352,476,433,
 371,472,251,201,235,192,489,412,502,454,924,719,1112,726,
 670,733,635,662,1015,709,918,702,669,760,628,645,842,2448,
 2717,1229,1079,1287,1035,1050,1111,1091,1055,1305,1114,2395,
 2600,1205,1234,1338,1196,1064,1245,1052,933,1190,1173,1983,
 2039,1206,1419,1187,988,1078,1137,1156,951,1377,1257,2515,
 2827,1355,1106,1366,1136,1026,1227,1126,1130,1182,1034,2228,
 2492,1070,1317,1264,1166,1124,1116,1065,984,1274,1209,2089,
 2098,1349,1363,1252,1046,999,1218,1154,917,1204,1170,1549,
 1579,1194,1384,2547,1740,1648,1110,1452,2754,1481,1628,1184,
 1398,2360,1714,1624,1117,1425,3092,1576,1584,1242,1465,2534,
 1702,1682,1185,1337,2496,2240,2013,2297,1971,2286,1962],
 [14,39,42,58,51,50,61,97,82,100,94,105,69,85,92,89,66,76,
 59,95,77,53,71,55,104,83,64,108,74,101,102,73,63,84,
 103,56,72,78,96,60,75,65,90,91,86,70,106,93,80,99,81,
 98,62,49,68,52,57],
 [14,39,42,58,51,50,85,92,76,59,95,77,53,55,108,102,73,63,
 103,56,72,78,75,65,86,93,80,81,98,62,49,68,57,282,422,
 541,352,346,476,371,472,279,186,208,234,320,229,244,221,
 288,294,202,277,303,260,214,246,490,430,500,397,554,458,
 489,412,507,426,563,478,514,417,761,879,1029,900,747,890,
 961,806,791,838,1143,958,1216,937,1231,1018,1087,910,1254,
 1009,1168,886,1678,1460,1728,1412,1734,1447,1641,1411,1644,
 1441,1802,1414,2181,2142,2231],
 [14,39,42,58,51,50,94,85,92,76,59,95,77,53,55,104,83,64,
 101,63,103,56,72,78,75,65,70,106,81,98,62,49,68,57,282,
 541,352,346,476,433,371,472,280,247,248,251,201,294,202,
 277,231,226,258,235,192,554,458,518,453,489,412,507,426,
 514,417,529,456,502,454,1318,1160,924,726,733,1340,1238,
 1015,702,760,842,1047,1287,1035,1338,1196,1187,988,1366,
 1136,1264,1166,1252,1046,1549,1579,1740,1648,1481,1628,1714,
 1624,1576,1584,1702,1682,2240,2297,2286],
 [14,39,42,58,51,50,97,82,94,92,76,59,95,77,53,55,83,64,
 101,103,56,72,78,65,106,81,98,62,49,68,57,282,541,352,
 346,476,433,371,472,320,280,247,248,215,221,251,201,277,
 231,226,245,258,220,235,192,554,458,461,518,453,524,489,
 412,507,426,494,514,417,529,456,498,502,454,924,726,759,
 733,1015,702,817,760,842,1047,1287,1035,1338,1196,1187,988,
 1366,1136,1264,1166,1252,1046,1706,1549,1579,1619,1740,1648,
 1756,1481,1628,1608,1714,1624,1723,1576,1584,1654,1702,1682,
 2240,2297,2286],
 [14,39,42,58,51,50,100,92,76,59,95,77,53,55,104,108,102,
 73,63,103,56,72,78,65,86,70,93,80,81,98,62,49,68,57,
 282,422,541,352,346,476,371,472,279,186,234,229,244,288,
 260,214,246,490,430,515,500,397,554,458,524,489,412,563,
 478,494,514,417,761,1084,754,879,900,747,1101,741,890,806,
 791,1285,1143,958,1190,1173,1423,1216,937,1731,1231,1018,
 1255,1087,910,1274,1209,1420,1254,1009,1690,1168,886,1678,
 1460,2279,1728,1412,1734,1447,1641,1411,1841,1644,1441,1802,
 1414,2181,2142,2231],
 [14,39,42,61,94,92,89,66,76,95,77,53,83,64,74,101,63,72,
 78,106,93,80,81,62,49,68,57,421,408,337,374,393,286,324,
 208,331,280,261,329,255,243,216,276,435,406,277,311,262,
 349,305,290,273,239,258,209,335,588,578,482,464,637,622,
 567,526,580,589,545,511,626,607,528,474,599,603,550,519,
 623,613,555,535,794,866,893,845,776,812,947,941,1502,1769,
 1486,1774,1401,1754,1287,1035,1338,1196,1187,988,1366,1136,
 1264,1166,1252,1046,1706,1619,1756,1608,1723,1654,2969,3203,
 3153,2857,3499,2958],
 [14,39,42,94,92,76,95,77,53,83,64,101,63,72,78,106,93,80,
 81,62,49,68,57,408,337,374,393,286,324,208,350,331,280,
 243,270,206,216,406,277,287,223,308,311,262,290,273,239,
 258,335,588,578,482,464,637,622,567,526,543,580,589,545,
 511,626,607,528,474,488,557,599,603,550,519,621,623,613,
 555,535,529,456,553,815,959,930,845,895,1048,869,941,1502,
 1769,1486,1774,1401,1754,1760,1093,1403,1426,1663,1399,1446,
 1730,1171,1290,1815,1142,1512,1443,1127,1590,1456,1406,1773,
 1261,1369,1409,2799,1849,1854,1435,1394,2795,1832,1863,1440,
 1418,3056,1890,1859,1458,2632,3541,3053,3022,2638,3213,3109,
 2670,2998,2662,3270,2731,2771,2622,3601,2742,3095,2772,3134,
 2859],
 [14,39,42,94,92,89,66,76,95,77,53,71,83,64,74,101,63,72,
 78,96,60,106,93,80,99,81,62,49,68,52,57,421,408,337,
 374,393,286,324,208,300,222,331,280,243,270,206,216,406,
 277,287,223,311,262,290,273,239,258,588,578,565,482,464,
 515,637,622,604,567,526,580,589,572,545,511,626,607,611,
 528,474,488,599,603,573,550,519,623,613,591,555,535,1502,
 1769,1486,1774,1401,1754],
 [14,39,42,94,105,69,92,89,66,76,95,77,53,71,83,64,101,63,
 84,72,78,96,60,90,91,106,93,80,99,81,62,49,68,52,57,
 326,421,408,337,374,393,286,324,315,208,331,280,227,243,
 216,406,383,277,311,262,250,290,258,588,578,482,464,637,
 622,567,526,580,589,545,511,626,607,528,474,599,603,550,
 519,623,613,555,535,1502,1769,1486,1774,1401,1754],
 [14,39,42,94,105,69,92,89,66,76,95,77,53,83,64,74,101,63,
 72,78,96,60,106,93,80,99,81,62,49,68,52,57,326,421,408,
 337,374,393,286,324,208,350,331,280,243,270,206,216,406,
 277,308,311,262,290,273,239,258,588,578,565,482,464,637,
 622,604,567,526,580,589,572,545,511,626,607,611,528,474,
 599,603,573,550,519,623,613,591,555,535,1502,1769,1486,
 1774,1401,1754],
 [14,42,21,51,82,100,94,69,89,59,95,77,53,55,104,108,101,
 102,73,63,103,56,54,78,60,75,86,106,80,98,57,282,481,
 352,521,346,433,491,342,324,279,193,309,270,221,251,203,
 388,406,294,200,217,213,273,220,235,187,357,490,451,574,
 602,533,450,561,507,413,571,590,529,396,553,566,577,644,
 630,772,685,665,636,751,699,954,842,1056,1228,1145,1131,
 1239,1221,1105,1127,1083,1243,1193,1128,1437,1358,1368,1467,
 1402,1432,1307,1397,1408,1430,1336,1389,2013,1971,1962],
 [14,42,21,51,97,79,94,69,76,77,53,55,101,73,103,72,54,60,
 106,93,80,81,68,481,352,521,346,491,342,324,208,351,280,
 318,216,386,388,406,277,217,328,262,330,323,258,343,565,
 490,451,592,614,637,596,554,416,574,602,511,533,450,612,
 608,626,582,611,507,488,413,571,590,563,452,601,621,623,
 593,529,396,566,577,644,1062,665,1040,791,1129,838,1260,
 846,1157,1079,1403,1177,1146,1143,1044,1362,1399,1207,1076,
 1216,1162,1081,1171,1031,1125,1231,1121,1345,1106,1512,1241,
 1161,1087,986,1223,1456,1179,1058,1254,1201,1203,1261,1138,
 1090,1168,1036,1215,1981,1782,1567,1480,2144,1791,1514,1544,
 1944,1888,1557,1431,3924,4754,3852,3405,5721,4118],
 [14,42,21,51,100,94,69,95,77,53,55,108,101,73,103,54,78,
 60,86,106,93,80,81,57,282,481,352,521,433,491,371,342,
 324,279,193,259,310,309,388,406,294,200,213,330,357,464,
 490,451,637,596,574,602,511,626,582,507,413,571,590,519,
 623,593,498,566,577,630,772,703,685,636,751,699,954,1388,
 1364,1453,1403,1177,1146,1056,1228,1145,1131,1216,1162,1081,
 1239,1221,1512,1241,1161,1105,1127,1087,986,1223,1083,1243,
 1193,1128,1168,1036,1215,2056,2061,1437,2374,1358,1619,1368,
 1467,1728,1578,1402,1432,1608,1307,1397,1641,1632,1408,1430,
 1654,1336,1389,1802,1587,3172,3208,3130,3377,3687,3151,3136,
 4203,2944,3322,3676,3207,3341,3620,3149,3281,3818,2925,2013,
 1971,1962,2720,3221,3114,2646,3551,3528,3460,3345,2885,3437,
 3657,2882,3907,3453,3402,3430,2683,3673,2814,3167,3116,2494,
 3218,3565,2626,4741,3068,3561,3229,2685,4059,3435,3385,3703,
 2641,3098,3554,2688,4007,3877,4392,6069,4889,4158,5934,4575,
 4785,5692,6850,8876,8802,8118,9192,8056,8778,7671,7648,7213,
 9029,6834,6667,6903,7382,6723,7082,6269,9038,6147,6821,8283,
 6919,6785],
 [14,42,21,58,51,50,61,97,82,100,79,94,105,69,85,92,89,66,
 76,59,95,77,53,71,55,104,83,108,74,101,102,73,63,84,
 103,56,72,54,78,96,60,75,65,90,91,86,70,106,93,80,99,
 81,98,62,68,52,57],
 [14,42,21,58,51,50,82,100,94,69,85,89,59,95,77,53,55,104,
 108,101,102,73,63,103,56,54,78,60,86,106,93,81,57,282,
 481,352,521,346,433,491,371,279,193,309,212,270,221,201,
 294,200,213,299,273,220,192,278,357,490,451,574,602,533,
 450,507,413,571,590,529,396,566,577,630,1107,772,685,636,
 1075,751,699,954,842,1056,1228,1145,1131,1239,1221,1105,
 1127,1083,1243,1193,1128,1437,1358,1368,1467,1402,1432,1307,
 1397,1408,1430,1336,1389,2013,1971,1962],
 [14,42,21,58,51,50,82,100,94,69,89,59,95,77,53,55,108,
 101,102,73,63,103,54,78,60,86,93,80,81,57,282,481,352,
 521,346,433,371,279,193,310,309,270,221,288,294,200,213,
 273,220,301,357,490,515,451,549,574,602,533,524,450,412,
 507,488,413,544,571,590,529,498,396,454,480,566,577,630,
 772,808,685,636,751,799,699,954,842,1146,1056,1228,1076,
 1145,1131,1125,1239,1221,1161,1105,1127,1058,1083,1243,1090,
 1193,1128,1437,2374,1358,1368,2491,1467,1402,2311,1432,1307,
 2263,1397,1408,2392,1430,1336,2191,1389,2013,1971,1962],
 [14,42,21,58,51,50,97,79,94,69,76,77,53,55,101,102,73,63,
 103,56,72,54,60,90,70,106,93,80,81,68,282,481,352,521,
 346,491,186,208,307,304,351,280,318,216,386,202,277,267,
 254,328,262,323,258,343,490,515,451,570,556,592,614,554,
 461,416,549,574,602,533,524,450,527,612,608,507,488,413,
 557,544,571,590,563,494,452,568,601,621,529,498,396,480,
 566,577,791,1129,838,1260,846,1157],
 [14,42,21,58,51,50,97,79,94,69,76,77,53,55,104,101,73,
 103,72,54,60,90,70,106,93,80,81,68,282,481,352,521,346,
 491,186,208,259,307,304,351,280,247,215,310,318,212,216,
 292,386,202,277,217,267,254,328,262,330,323,299,258,343,
 490,451,570,592,614,554,416,574,602,533,450,612,608,507,
 413,557,571,590,563,452,601,621,529,396,566,577,746,712,
 1347,763,723,1308,791,1129,838,1260,846,1157],
 [14,42,21,58,51,50,97,82,79,94,69,85,89,76,59,77,53,55,
 101,102,73,63,103,72,54,60,75,90,70,106,93,80,81,98,68,
 282,481,422,352,521,346,491,208,351,320,280,310,318,216,
 386,277,328,303,262,330,323,258,343,490,451,592,614,554,
 416,574,602,533,450,612,608,507,413,571,590,563,452,601,
 621,529,396,566,577,791,1129,838,1260,846,1157],
 [14,42,21,58,51,50,97,82,79,94,69,85,89,76,59,77,53,55,
 104,101,102,73,63,103,56,72,54,60,90,70,106,93,80,81,
 68,282,481,422,352,521,346,491,208,351,280,318,212,216,
 292,386,277,328,262,323,299,258,278,343,490,451,592,614,
 554,416,574,602,533,450,612,608,507,413,571,590,563,452,
 601,621,529,396,566,577,791,1129,838,1260,846,1157],
 [14,42,21,61,97,100,79,94,66,76,95,77,71,55,83,108,74,
 101,73,84,103,72,54,78,91,86,106,80,62,68,52,57,353,
 326,408,312,333,337,374,286,334,300,222,240,329,255,243,
 251,276,203,287,223,207,295,235,209,187,588,575,500,455,
 580,585,489,427,505,465,599,584,502,431,784,862,864,807,
 901,765,939,829,787,897,977,779,1050,1139,1064,1059,1078,
 1082,1026,1094,1124,1092,999,1005,1194,1258,1110,1167,1184,
 1222,1117,1199,1242,1292,1185,1233,2040,2050,2068],
 [14,42,21,61,97,100,79,94,69,76,95,77,55,83,108,74,101,
 73,103,72,54,78,86,106,80,99,68,57,353,326,408,312,333,
 337,374,286,334,300,240,291,350,261,329,255,243,206,251,
 203,382,435,287,207,238,295,228,235,187,314,335,588,575,
 500,455,580,585,489,427,505,465,599,584,502,431,784,862,
 893,864,807,901,704,765,939,829,787,897,698,977,779,1050,
 1139,1064,1059,1078,1082,1026,1094,1124,1092,999,1005,2651,
 2849,1194,1258,1110,1167,1184,1222,1117,1199,1242,1292,1185,
 1233,2040,2050,2068],
 [14,42,21,97,79,94,69,76,95,77,71,55,83,108,74,101,73,84,
 103,72,54,78,96,65,91,86,106,80,99,62,68,52,57,353,326,
 408,312,333,337,374,286,334,315,208,300,240,291,255,251,
 203,277,287,207,238,295,235,187,588,575,500,455,580,585,
 489,427,505,465,599,584,502,431,784,862,800,807,765,939,
 903,787,977,779,1050,1139,1064,1059,1078,1082,1026,1094,
 1124,1092,999,1005,1194,1258,1110,1167,1184,1222,1117,1199,
 1242,1292,1185,1233,2040,2050,2068],
 [14,42,21,97,100,79,69,76,95,77,55,83,108,74,101,73,103,
 72,54,78,96,65,86,106,80,99,62,68,52,57,353,408,312,
 333,337,374,286,334,234,300,240,255,251,203,253,287,207,
 295,308,235,187,588,575,565,515,500,397,455,580,585,572,
 489,412,427,488,505,448,465,599,584,573,502,454,431,784,
 696,862,807,765,684,939,787,977,779,1050,1139,1197,1064,
 1059,1072,1078,1082,1108,1026,1094,1240,1124,1092,1150,999,
 1005,1057,1194,1384,1258,1110,1452,1167,1184,1398,1222,1117,
 1425,1199,1242,1465,1292,1185,1337,1233,2040,2050,2068],
 [14,42,21,97,100,79,94,69,76,95,77,55,108,101,73,103,72,
 54,78,86,106,80,68,57,353,326,408,333,337,374,286,334,
 350,255,251,203,382,435,295,308,239,235,187,314,335,588,
 575,397,592,614,543,580,585,489,427,612,608,557,599,584,
 601,621,502,431,553,784,862,807,765,812,939,787,1928,1871,
 1872,779,1760,1287,899,1050,1139,1064,1059,1730,1187,902,
 1078,1082,1108,1377,1455,1026,1094,1590,1264,928,1124,1092,
 999,1005,1057,1204,1448,2541,2308,1549,1409,1194,1258,1410,
 1110,1167,1481,1394,1184,1222,1387,1117,1199,1576,1418,1242,
 1292,1382,1185,1337,1233,3261,4818,2928,4179,4337,2840,4155,
 3652,3255,3328,4544,3087,3931,4681,3060,3796,3470,3212,2040,
 2050,2068,6026,2998,2613,5618,3257,3572,3774,3374,8564,3129,
 3512,3119,3233,5358,2771,2822,5572,3356,3063,3152,3043,8528,
 3282,3553,3461,3653,5261,3095,2968,7473,3205,3603,3753,3623,
 6213,3241,3106,2728,3026,5056,3429,3274,5663,2765,3120,5960,
 3573,2701,9120,8330,5507,8812,5132,5359,8515,6467,4950,6145,
 7799,6068,6264,7314,5727,6433,7035,5575,8215,6951,6647,8179,
 7972,6878],
 [14,42,23,21,58,50,97,79,94,69,89,76,59,77,55,101,103,54,
 60,90,70,106,93,81,282,353,326,481,422,352,312,333,346,
 334,208,351,247,248,215,309,216,386,231,226,245,348,490,
 451,592,614,453,509,533,450,447,612,608,620,417,470,498,
 468,615,862,670,662,822,939,669,798,645,1500,989,2299,977,
 779,2169,1225,1861,1190,1416,1377,1455,1897,1716,2203,2054,
 1319,1274,1445,1193,1937,1128,1204,1448,1772,2612,2473,3902,
 2461,4552,2066,2377,1821,1910,1368,1467,2279,1750,1825,1899,
 1307,1397,2180,1810,1841,1848,1336,1389,2194,1970,4319,2779,
 4514,3163,4052,8397,4727,4398,4010,5334,8607,5195,8211,2872,
 4435,3297,4705,3223,5640,8524,7380,7108,5695,9287,6799,4079,
 7797,8320,7756,2998,2613,3270,4105,3867,2771,2822,3601,4024,
 4119,5383,3095,2968,3134,4028,3934,9116,9072,9052,6337,7646,
 6787,7142,7970,7228,9044,7769,6664,8303,6838,6905,6412,5279,
 5637,5617,5058,5971,5077,8652,7501,5685,5639,4995,5255,7882,
 5276,6053,9177,8043,6456,6451,8458,6927],
 [14,42,38,51,50,61,97,100,94,69,92,76,95,83,64,108,74,
 101,73,63,72,78,96,60,65,90,86,106,68,57,237,353,339,
 326,408,312,395,333,337,361,405,387,286,300,307,350,261,
 276,382,404,435,308,228,321,325,335,397,455,441,536,509,
 522,412,427,447,473,483,512,417,459,470,523,468,463,814,
 859,1023,1603,757,940,883,932,1524,844,1006,738,828,756,
 972,958,1044,937,1162,1018,1121,910,986,1009,1201,886,1036,
 2952,3044],
 [14,42,38,51,50,61,97,100,94,89,95,53,71,55,83,64,108,74,
 101,84,103,72,78,96,60,65,90,106,62,49,68,52,57,237,
 353,339,326,364,312,395,333,337,361,405,387,374,286,300,
 222,240,248,215,201,276,203,287,223,207,226,245,192,209,
 187,397,496,455,453,493,477,412,485,427,448,525,465,417,
 462,459,454,516,431,976,813,835],
 [14,42,38,51,50,61,97,100,94,105,69,92,95,53,71,55,83,64,
 108,74,101,73,63,72,78,96,60,65,90,106,80,99,81,49,68,
 52,57,237,353,339,326,408,364,312,395,333,337,361,374,
 286,307,261,302,382,267,228,321,314,397,496,455,453,493,
 477,412,485,427,448,525,465,417,462,459,454,516,431,989,
 1339,977,1297,779,1288],
 [14,42,38,51,50,61,97,100,94,105,76,95,53,71,55,83,64,
 108,74,101,73,63,84,72,78,96,90,86,106,80,99,81,68,57,
 237,353,339,408,364,312,395,333,337,405,387,374,286,307,
 302,382,404,435,267,321,314,325,335,430,451,397,455,458,
 416,453,477,466,450,412,427,426,413,448,465,478,452,417,
 459,456,396,454,431,1475,888,1468,825,1463,833],
 [14,42,38,51,50,61,97,100,94,105,76,95,53,71,55,83,64,
 108,74,101,103,72,78,96,60,65,86,106,62,49,68,52,57,
 237,353,339,326,408,364,312,395,333,337,361,374,286,222,
 240,248,215,261,201,276,203,223,207,226,245,228,192,209,
 187,500,397,455,518,453,477,489,412,427,505,448,465,514,
 417,459,502,454,431,989,1339,977,1297,779,1288],
 [14,42,38,51,50,97,100,69,92,89,76,95,53,55,108,73,63,
 103,72,78,60,65,90,86,80,81,68,57,282,384,422,410,541,
 352,346,399,476,433,444,371,341,472,342,234,259,320,310,
 293,388,217,303,246,464,467,397,455,592,461,549,574,511,
 479,612,488,544,571,519,510,417,459,601,498,480,566,761,
 879,900,747,890,806,1540,1519,1498,1050,958,1044,1262,937,
 1162,1018,1121,1356,910,986,1124,1009,1201,1360,886,1036,
 2677,2086,2767,2161,1410,1869,1387,1882,1382,1850,3495,3815,
 2724,4238,4195,4088,2557,4014,3981,3299,2524,3859,3786,4268,
 4837],
 [14,42,38,51,50,97,100,94,69,92,76,95,83,108,101,73,63,
 72,78,60,65,90,86,106,68,57,237,353,339,326,408,312,395,
 333,337,361,405,387,286,300,307,350,382,404,435,287,308,
 228,321,325,335,565,397,455,441,536,594,614,509,543,522,
 412,427,447,473,579,608,483,557,512,573,417,459,470,523,
 468,553,463,722,814,859,1603,757,883,1524,844,1006,738,
 828,756,972,1305,958,1044,937,1162,1377,1018,1121,910,986,
 1274,1009,1201,886,1036,2862,2809,1733,2265,2471,1825,2361,
 2490,1841,2222,2304,3662,3998,3932,3336,4655,3408],
 [14,42,38,51,50,97,100,94,89,76,95,53,55,108,101,103,72,
 78,60,65,90,86,106,68,57,282,384,422,410,541,352,425,
 346,399,476,433,444,341,472,342,222,259,240,310,293,201,
 203,217,303,226,245,330,358,464,467,397,455,592,461,549,
 574,511,479,412,427,612,488,544,571,519,510,417,459,601,
 480,566,752,739,824,974,809,957,1246,724,802,1265,1021,
 868,792,1151,1129,1260,1157,1050,958,1044,937,1162,1078,
 1018,1121,910,986,1124,1009,1201,886,1036,1929,3168,1978,
 3695,1480,1544,1431,3495,4238,4195,4014,3981,3859],
 [14,42,38,58,51,50,61,97,82,100,79,94,105,69,85,92,89,66,
 76,59,95,53,71,55,104,83,64,108,74,101,102,73,63,84,
 103,56,72,54,78,96,60,75,65,90,91,86,70,106,80,99,81,
 98,62,49,68,52,57],
 [14,42,38,58,51,50,97,82,100,79,69,85,92,89,76,95,83,108,
 102,73,63,103,56,72,54,78,60,75,65,90,86,98,62,68,57,
 282,384,422,410,541,425,346,399,476,433,444,341,472,234,
 320,230,288,253,303,246,301,397,455,441,536,453,477,509,
 522,412,427,447,473,448,465,483,512,417,459,470,523,454,
 431,468,463,1321,1129,1282,1260,1236,1157],
 [14,42,38,58,51,50,97,82,100,79,94,89,76,53,55,104,83,
 108,101,103,56,72,54,78,60,75,65,90,86,98,62,68,57,282,
 384,422,352,425,346,399,476,433,444,371,341,472,222,259,
 240,247,248,215,201,203,223,217,207,231,226,245,192,187,
 397,455,530,453,477,564,412,427,508,448,465,534,417,459,
 552,454,431,486,1613,1271,1833,1281,1645,1566],
 [14,42,38,58,51,50,97,100,69,85,92,89,76,95,104,83,108,
 102,73,63,103,56,72,54,78,60,75,65,90,86,98,62,68,57,
 282,384,422,410,541,425,346,399,476,433,444,341,472,186,
 193,234,230,288,202,200,253,246,301,397,455,441,536,453,
 477,509,522,412,427,447,473,448,465,483,512,417,459,470,
 523,454,431,468,463,1321,1129,1282,1260,1236,1157],
 [14,42,38,58,51,50,97,100,89,76,95,53,55,104,83,108,73,
 63,103,56,72,54,78,90,86,80,81,62,68,57,282,384,410,
 541,352,425,346,399,476,444,371,341,472,186,193,230,247,
 212,202,200,253,217,231,299,301,278,430,451,458,416,453,
 477,466,450,426,413,448,465,478,452,456,396,454,431,877,
 644,942,1107,674,938,665,884,693,954,791,842,838,1047,846,
 1426,1177,1446,1207,1290,1031,1443,1241,1406,1179,1369,1138,
 2325,2367],
 [14,42,58,51,50,100,94,69,95,77,53,55,104,64,108,101,73,
 103,54,78,60,86,106,93,80,81,49,57,282,481,352,521,433,
 491,371,279,193,307,304,310,309,212,270,221,292,294,202,
 200,217,267,213,254,231,245,330,299,273,220,278,357,490,
 451,574,602,533,450,507,413,571,590,559,529,396,566,577,
 1160,644,630,772,685,1238,665,636,672,802,751,699,954,842,
 1056,1228,1145,1131,1239,1221,1105,1127,1738,1083,1243,1193,
 1128,2452,2357,2396,2467,1437,1358,1368,1467,1402,1432,1307,
 1397,1408,1430,1336,1389,6058,5610,2013,1971,1962],
 [16,14,17,39,20,27,31,42,32,35,18,34,30,21,15,25,50,89,
 95,53,108,63,90,106,80,68,237,282,421,364,352,312,428,
 405,374,317,286,302,318,321,323,482,464,495,461,531,549,
 580,572,545,503,427,474,494,548,568,623,591,431,1423,1294,
 1081,1206,1208,1420,1269,1203,1349,1235,1706,1885,1599,1756,
 1787,1466,3319,2734,3045,3577,2607,3324],
 [16,14,17,39,20,27,31,42,32,35,18,34,30,21,15,25,58,61,
 85,59,77,104,102,84,75,70,93,98,289,316,370,402,366,424,
 392,409,377,338,249,186,202,575,500,530,567,547,609,585,
 489,508,582,474,505,534,550,532,600,593,502,486,1102,1055,
 951,1100,1130,917,1899,2880,2506,2838,2555],
 [16,14,17,39,20,27,31,42,32,35,18,34,30,21,15,25,58,61,
 85,59,77,104,102,84,75,70,93,98,289,316,370,402,366,424,
 392,409,377,338,249,310,330,575,464,500,530,567,547,609,
 585,489,508,582,505,534,550,519,532,600,593,502,486,1234,
 850,1317,856,1821,1810,3560,3704],
 [16,14,22,17,37,42,35,19,38,40,34,13,25,58,97,89,104,83,
 102,103,56,54,75,90,98,62,282,384,394,492,422,410,541,
 429,520,346,399,476,433,444,419,484,371,341,472,186,193,
 202,200,217,397,455,453,477,412,427,448,465,417,459,454,
 431,644,665,1321,1540,1282,1519,1236,1498],
 [16,14,22,17,39,20,27,31,42,41,32,35,19,40,18,34,30,21,
 13,15,25,58,61,97,94,85,59,77,104,102,84,103,56,78,75,
 70,93,98,186,202],
 [16,14,22,17,39,20,27,31,42,41,32,35,19,40,18,34,30,21,
 13,15,25,58,61,97,94,85,59,77,104,102,84,103,78,75,70,
 93,98,186,310,202,330],
 [16,14,22,17,39,20,27,31,42,41,32,35,19,40,18,34,30,21,
 13,15,25,237,282,289,353,316,421,364,352,336,312,345,333,
 428,344,337,361,433,409,405,377,374,393,317,286,1475,1433,
 976,1468,973,813,1463,982,835],
 [16,14,22,17,39,37,41,32,19,38,40,21,13,15,58,61,85,92,
 88,102,84,56,87,98,384,394,432,360,346,313,355,409,444,
 371,354,283,236,186,320,202,482,496,455,554,458,493,477,
 528,488,413,525,465,557,512,462,459,498,396,516,431,1404,
 1658,1237,1748,1343,907,1392,1207,1444,946,1161,1255,1299,
 1090,2468,1677,2010,1307,1226,2035,1411,2236,1336,1259,2187,
 2324,3015,2309,3199,2233,2920,4600,2953,4708,2494,2538,2727,
 5849,2641,5982,5558,8511,7519,3522,5698,3458,5076,7354,5896,
 6553,6308,7874,7596,7587,6097,6125,7657,6692,6120,9034,6574]
  ,[16,14,22,24,17,39,37,20,27,31,42,32,35,40,18,34,30,
 21,13,15,25,58,61,82,85,89,59,95,77,104,102,84,75,90,
 70,106,93,98,310,330],
 [16,14,22,24,17,39,37,20,27,31,42,32,35,40,18,34,30,21,
 13,15,25,58,61,85,89,59,95,77,104,102,84,75,90,70,106,
 93,98,186,310,202,330],
 [16,14,22,24,17,39,37,20,27,31,42,41,32,35,19,18,34,30,
 21,13,15,25,237,282,353,326,421,376,389,408,364,352,312,
 333,428,344,392,337,405,374,393,317,338,286,888,791,825,
 838,833,846],
 [16,14,22,24,17,39,37,20,27,31,42,41,32,35,19,40,18,30,
 21,13,15,25,237,282,353,326,421,376,407,408,364,352,312,
 333,428,344,313,337,361,433,374,393,317,354,286,989,977,
 779],
 [16,14,22,24,17,39,37,20,27,31,42,41,32,35,19,40,18,34,
 30,21,13,15,25,58,61,82,85,59,77,104,102,84,75,70,93,
 98,310,330],
 [16,14,22,24,17,39,37,20,27,31,42,41,32,35,19,40,18,34,
 30,21,13,15,25,58,61,85,59,77,104,102,84,56,75,70,93,
 98,186,202],
 [16,14,22,24,17,39,37,20,27,31,42,41,32,35,19,40,18,34,
 30,21,13,15,25,237,282,353,326,421,376,408,364,352,312,
 333,428,344,337,361,433,405,374,393,317,286],
 [16,14,22,24,17,39,37,27,42,41,19,38,40,30,21,25,58,82,
 85,92,76,59,104,56,86,70,98,282,384,481,422,407,370,541,
 352,521,362,476,433,491,249,472,247,231,554,461,416,543,
 522,559,523,1068,1129,1327,1260,1427,1157,1341,1423,1416,
 1420,1445,1368,1728,1480,1578,1544,1632,1644,1431,1587,1866,
 1917,1844,3651,4306,4628,5837,5586],
 [16,14,22,24,33,17,39,37,27,36,31,35,28,38,40,34,23,30,
 21,13,25,58,61,105,88,89,66,95,71,102,84,96,87,90,91,
 106,99,52,227,250],
 [16,14,22,24,33,17,39,37,27,36,31,35,28,38,40,34,23,30,
 21,13,25,237,282,384,369,381,481,443,422,541,364,352,425,
 367,366,424,346,361,433,444,380,368,491,385,371,472,1762,
 2138,1766,2201,1803,2153],
 [16,14,22,24,33,17,39,37,27,36,31,41,28,19,38,40,34,23,
 30,21,13,25,237,282,384,369,481,375,422,541,364,352,425,
 367,521,332,476,361,433,444,380,491,327,371,472,1388,1364,
 1453],
 [16,14,22,24,33,17,39,37,27,36,31,41,35,28,19,38,40,34,
 23,30,21,13,25,58,61,105,88,66,71,102,84,96,87,91,99,
 52,227,250],
 [16,14,22,24,33,17,39,37,27,36,31,41,35,28,19,38,40,34,
 23,30,21,13,25,237,282,384,369,481,422,541,364,352,425,
 367,521,346,476,361,433,444,380,491,371,472],
 [16,14,22,24,37,27,31,42,41,19,38,30,25,61,100,105,76,71,
 64,108,74,72,96,49,68,52,237,353,339,326,389,407,408,
 364,312,395,333,392,313,337,374,338,354,286,261,276,209,
 397,455,453,493,477,412,427,448,525,465,454,516,431,888,
 989,1339,825,977,1297,833,779,1288,1072,1240,1057,1452,
 1167,1425,1199,1337,1233],
 [16,14,22,24,37,27,31,42,41,19,38,30,25,100,105,76,71,
 108,84,72,68,237,353,339,326,389,407,408,364,312,395,333,
 392,313,337,374,338,354,286,404,435,325,335,565,397,455,
 594,614,453,493,477,543,572,412,427,579,608,448,525,465,
 557,595,621,454,516,431,553,888,989,1339,825,977,1297,833,
 779,1288,1305,1190,1377,1182,1204,2074,1452,1167,2038,1425,
 1199,2166,1337,1233,3129,3282,3241],
 [16,14,22,24,39,37,31,42,41,19,38,34,30,21,13,25,58,82,
 100,69,85,104,56,72,60,75,70,98,282,384,481,375,541,425,
 521,332,476,444,491,327,338,371,472,304,254,441,570,637,
 604,626,483,557,573,623,913,1388,908,1364,966,1453,846,
 1733,1905,2419,2434,2493],
 [16,14,22,24,39,37,31,42,41,19,38,34,30,21,13,25,61,105,
 66,76,74,96,91,86,80,99,52,237,353,372,394,326,408,312,
 347,429,333,337,405,423,419,374,393,286,261,228,441,570,
 477,447,561,459,470,559,623,1737,844,1650,738,1732,756,
 2588,2408,2316],
 [16,14,22,24,39,37,31,42,41,19,38,34,30,21,13,25,105,53,
 71,84,52,237,353,372,394,326,408,312,347,429,333,337,405,
 423,419,374,393,286,206,216,565,397,496,614,509,543,580,
 412,485,608,483,557,417,462,621,529,468,553,1737,844,1650,
 738,1732,756,937,1316,1730,1031,910,1067,886,1109,1437,
 1258,1733,2242,1402,1222,1825,2579,1408,1292,1841,2141,2598,
 3257,4264,2882,3356,3979,2626,3205,4149,2688,6680,8783,6638]
  ,[16,14,22,29,17,37,20,42,41,19,38,18,30,21,13,15,58,
 82,79,85,66,59,56,54,75,91,70,98,394,492,375,336,332,
 409,419,484,338,354,236,247,231,482,441,536,556,624,458,
 416,509,522,598,483,512,581,478,452,470,523,568,638,516,
 1076,1052,1058,1065,1656,1611,5967,4990],
 [16,14,22,29,17,37,20,42,41,19,38,18,30,21,13,15,97,69,
 92,76,53,55,60,65,86,80,81,57,237,353,339,481,421,408,
 333,337,374,491,393,230,246,515,637,567,526,469,453,477,
 580,511,479,599,519,510,417,459,623,555,535,442,480,1076,
 1052,1058,1065,1619,1654,5831,5384],
 [16,14,22,29,17,39,20,31,41,32,19,38,18,30,13,15,58,82,
 94,85,59,53,104,102,56,78,75,70,80,98,394,369,375,410,
 360,336,313,409,419,380,341,236,482,536,458,513,583,598,
 485,528,512,478,517,595,638,516,1407,1327,1504,1341,2450,
 2106,2556,2116],
 [16,14,22,29,17,39,20,31,41,32,19,38,18,30,13,15,97,69,
 88,76,55,64,101,103,60,87,86,81,49,57,237,353,316,421,
 312,345,333,392,337,374,393,515,637,477,511,503,447,527,
 488,599,459,535,539,468,480,1293,976,1276,813,825,1750,
 1466,2408,1848,1647,2141,2190,2260,4546,5408],
 [16,14,22,29,17,39,37,20,31,41,32,38,40,30,21,15,58,82,
 85,88,59,71,104,102,70,99,98,394,375,443,370,360,336,
 313,409,354,249,236,212,266,299,306,482,536,526,458,493,
 564,609,598,466,485,508,528,600,638,456,516,486,933,988,
 1250,1175,951,1046,1295,1300,917,1573,2839,3017,3155,2837,
 2893,5589,6010],
 [16,14,22,29,24,17,20,27,31,42,41,32,35,19,18,34,30,21,
 13,15,25,237,353,339,316,326,421,364,312,395,345,333,428,
 344,392,337,405,387,377,374,393,317,338,286,1433,1293,976,
 973,1276,813,825,982,1353,835,833,2190,2260,2248],
 [16,14,22,29,24,17,20,27,31,42,41,35,19,38,40,18,34,30,
 21,13,15,25,237,353,339,316,326,481,421,364,312,395,345,
 333,521,428,337,361,405,387,377,374,491,393,286,976,813,
 835],
 [16,14,22,29,24,17,37,20,27,31,42,35,19,38,40,18,34,30,
 21,13,15,25,237,353,339,326,381,481,421,408,364,312,395,
 366,521,428,337,361,405,387,374,368,491,393,286,1502,1486,
 1401],
 [16,14,22,29,24,17,37,20,27,31,42,41,19,38,40,18,34,30,
 21,13,15,25,58,82,79,66,76,59,104,56,54,75,91,86,70,
 98,259,247,217,231],
 [16,14,22,29,24,17,37,20,27,31,42,41,19,38,40,18,34,30,
 21,13,15,25,58,82,79,85,66,76,59,104,56,54,75,91,86,
 70,98,247,231],
 [16,14,22,29,24,17,37,20,27,31,42,41,35,19,38,40,18,34,
 30,21,13,15,25,58,82,79,66,59,104,102,56,54,75,91,70,
 98,259,217],
 [16,14,22,29,24,17,37,20,27,31,42,41,35,19,38,40,18,34,
 30,21,13,15,25,58,82,79,85,66,59,104,56,54,75,91,70,
 98,247,231],
 [16,14,22,29,24,17,37,20,27,31,42,41,35,19,38,40,18,34,
 30,21,13,15,25,237,353,339,326,481,421,408,364,312,395,
 333,521,428,337,361,405,387,374,491,393,286],
 [16,14,22,29,24,17,37,20,42,41,35,19,38,40,18,34,30,21,
 13,15,25,237,353,339,394,326,492,481,421,408,429,333,520,
 521,428,337,361,405,387,419,374,484,491,393,286,844,1928,
 970,738,1871,916,756,1872,909],
 [16,14,22,29,24,17,37,27,31,41,35,19,38,40,18,34,30,21,
 13,15,25,58,82,79,105,85,104,56,54,96,75,87,91,70,98,
 272,291,304,269,238,254,231,692,672],
 [16,14,22,29,24,17,37,27,31,41,35,19,38,40,18,34,30,21,
 13,15,25,58,82,79,105,88,66,59,102,56,54,96,75,87,91,
 70,98,259,320,217,303],
 [16,14,22,29,24,17,39,20,27,31,42,41,32,35,19,38,18,34,
 30,21,13,15,25,58,82,94,85,59,53,104,102,56,78,75,70,
 80,98],
 [16,14,22,29,24,17,39,20,27,31,42,41,32,35,19,38,18,34,
 30,21,13,15,25,237,353,316,326,421,364,312,345,333,428,
 392,337,405,377,374,393,338,286,1293,976,1276,813,825,
 1353,835,833,2190,2260,2248],
 [16,14,22,29,24,17,39,27,31,42,41,32,35,19,38,34,30,21,
 13,15,25,237,353,316,384,326,421,364,312,345,425,333,428,
 392,346,337,405,377,444,374,393,338,371,286,1293,954,976,
 1276,842,813,825,1353,1047,835,833,2190,2260,2248],
 [16,14,22,29,24,17,39,37,20,27,31,41,32,35,19,38,34,30,
 21,13,15,25,237,353,326,369,421,389,422,408,364,312,333,
 367,428,392,346,337,405,374,380,393,338,371,286,888,825,
 833],
 [16,14,22,29,24,17,39,37,20,27,31,41,32,35,19,38,40,30,
 21,13,15,25,58,82,85,88,59,71,55,104,102,56,70,99,81,
 98,212,266,299,306],
 [16,14,22,29,24,17,39,37,20,27,31,41,32,35,19,38,40,30,
 21,13,15,25,237,353,326,369,421,422,407,408,364,312,333,
 367,428,346,313,337,361,374,380,393,371,354,286,989,977,
 779],
 [16,14,22,29,24,17,39,37,20,27,31,41,32,35,19,38,40,34,
 30,21,13,15,25,58,82,85,88,59,71,104,102,56,70,99,98,
 212,266,299,306],
 [16,14,22,29,24,17,39,37,20,27,31,41,32,35,19,38,40,34,
 30,21,13,15,25,58,82,85,88,59,102,56,75,87,70,99,98,
 350,320,308,303],
 [16,14,22,29,24,17,39,37,20,27,31,41,32,35,19,38,40,34,
 30,21,13,15,25,237,353,326,369,421,422,408,364,312,333,
 367,428,346,337,361,405,374,380,393,371,286],
 [16,14,22,29,24,17,39,37,20,27,31,41,32,38,40,34,30,21,
 13,15,25,237,353,326,369,375,421,443,422,408,364,312,333,
 367,332,424,361,405,374,380,327,393,385,371,286,1769,1388,
 1232,1774,1364,1301,1754,1453,1395],
 [16,14,22,29,24,17,39,37,20,27,31,41,35,19,40,34,30,21,
 13,15,25,58,82,85,88,66,59,77,71,104,56,70,93,99,98,
 247,212,266,206,299,306,239,746,763],
 [16,14,22,29,24,17,39,37,20,27,31,41,35,19,40,34,30,21,
 13,15,25,58,82,85,88,66,59,102,75,87,91,70,93,99,98,
 322,350,320,319,308,303,330,1062,1040],
 [16,14,22,29,24,17,39,37,20,27,31,42,41,32,35,38,18,30,
 21,13,15,25,237,353,326,421,443,389,407,408,364,312,333,
 428,424,374,393,385,338,354,286,913,1847,1232,888,989,908,
 1852,1301,966,1924,1395,833,779,3756,2048,3892,2064,4062,
 2249],
 [16,14,22,29,24,17,39,37,20,27,31,42,41,32,35,38,18,30,
 21,13,15,25,237,353,326,421,443,389,407,408,364,312,333,
 428,424,392,374,393,385,338,354,286,1847,1232,888,989,
 1852,1301,825,1924,1395,833,779,2048,2064,2249],
 [16,14,22,29,24,17,39,37,20,27,31,42,41,32,35,38,40,18,
 30,21,13,15,25,58,82,85,59,95,55,104,102,56,70,106,81,
 98,212,299],
 [16,14,22,29,24,17,39,37,20,27,31,42,41,32,35,38,40,18,
 30,21,13,15,25,58,82,85,59,95,55,104,102,75,70,106,81,
 98,310,330],
 [16,14,22,29,24,17,39,37,20,27,31,42,41,32,35,38,40,18,
 30,21,13,15,25,237,353,326,421,443,407,408,364,312,333,
 428,424,361,374,393,385,354,286,1847,1232,989,1852,1301,
 1924,1395,779,2048,2064,2249],
 [16,14,22,29,24,17,39,37,20,27,31,42,41,32,35,38,40,30,
 21,13,15,25,58,82,85,59,95,71,55,104,102,56,70,106,99,
 81,98,212,299],
 [16,14,22,29,24,17,39,37,20,27,31,42,41,32,35,38,40,30,
 21,13,15,25,58,82,85,59,95,71,55,104,102,70,106,99,81,
 98,310,212,330,299],
 [16,14,22,29,24,17,39,37,20,27,31,42,41,32,35,38,40,30,
 21,13,15,25,237,353,326,421,443,422,407,408,364,312,333,
 428,424,346,361,374,393,385,371,354,286,1847,1232,989,
 1852,1301,1924,1395,779,2048,2064,2249],
 [16,14,22,29,24,17,39,37,20,27,31,42,41,32,35,38,40,30,
 21,13,15,25,237,353,326,421,443,422,407,408,364,312,333,
 428,424,361,374,393,385,371,354,286,1388,1847,1232,989,
 1364,1852,1301,1453,1924,1395,779,2048,2064,2249],
 [16,14,22,29,24,17,39,37,20,27,31,42,41,32,35,40,18,30,
 21,13,15,25,58,82,85,59,95,77,55,104,102,70,106,93,81,
 98,310,212,330,299],
 [16,14,22,29,24,17,39,37,20,27,31,42,41,32,35,40,18,30,
 21,13,15,25,58,82,85,59,95,77,55,104,102,75,70,106,93,
 81,98,310,330],
 [16,14,22,29,24,17,39,37,20,27,31,42,41,32,35,40,18,30,
 21,13,15,25,237,353,326,421,443,376,407,408,364,312,333,
 428,424,344,361,374,393,385,317,354,286,1847,1232,989,
 1852,1301,1924,1395,779,2048,2064,2249],
 [16,14,22,29,24,17,39,37,20,27,31,42,41,32,35,40,18,30,
 21,13,15,25,237,353,326,421,443,376,407,408,364,312,333,
 428,424,361,374,393,385,317,354,286,1310,1847,1232,989,
 1324,1852,1301,1385,1924,1395,779,2048,2064,2249],
 [16,14,22,29,24,17,39,37,20,27,31,42,41,32,35,40,30,21,
 13,15,25,237,353,326,421,443,376,422,407,408,364,312,333,
 428,424,344,361,374,393,385,317,371,354,286,1388,1847,
 1232,989,1364,1852,1301,1453,1924,1395,779,2048,2064,2249],
 [16,14,22,29,24,17,39,37,20,27,41,32,19,38,40,18,34,30,
 21,13,15,25,58,82,85,92,88,76,59,56,75,65,87,86,70,98,
 320,247,303,231],
 [16,14,22,29,24,17,39,37,20,27,41,32,19,38,40,18,34,30,
 21,13,15,25,58,82,85,92,88,76,59,102,56,75,65,87,86,
 70,98,320,303],
 [16,14,22,29,24,17,39,37,20,27,41,32,35,19,38,40,30,21,
 13,15,25,237,353,326,492,369,421,422,407,408,364,333,520,
 367,428,346,313,337,361,374,484,380,393,371,354,286,1928,
 989,1871,977,1872,779],
 [16,14,22,29,24,17,39,37,20,27,41,32,35,19,38,40,34,30,
 21,13,15,25,58,82,85,92,88,59,102,56,75,65,87,70,99,
 98,350,320,308,303],
 [16,14,22,29,24,17,39,37,20,27,41,32,35,19,38,40,34,30,
 21,13,15,25,237,353,326,492,369,421,422,408,364,333,520,
 367,428,346,337,361,405,374,484,380,393,371,286,1928,1871,
 1872],
 [16,14,22,29,24,17,39,37,20,27,42,41,19,38,40,18,34,30,
 21,13,15,25,58,82,85,92,66,76,59,56,75,65,91,86,70,98,
 320,247,303,231],
 [16,14,22,29,24,17,39,37,20,27,42,41,19,38,40,18,34,30,
 21,13,15,25,58,82,85,92,66,76,59,104,56,75,65,91,86,
 70,98,247,231],
 [16,14,22,29,24,17,39,37,20,27,42,41,32,19,38,40,18,34,
 30,21,13,15,25,58,82,85,92,76,59,102,56,75,65,86,70,
 98,320,303],
 [16,14,22,29,24,17,39,37,20,27,42,41,32,19,38,40,18,34,
 30,21,13,15,25,58,82,85,92,76,59,104,56,75,65,86,70,
 98,247,231],
 [16,14,22,29,24,37,20,27,31,42,41,35,19,38,40,18,34,30,
 21,13,15,25,58,82,100,79,66,59,104,56,72,54,75,91,70,
 98,259,247,217,231],
 [16,14,22,29,24,37,20,27,31,42,41,35,19,38,40,18,34,30,
 21,13,15,25,58,82,100,79,66,59,104,102,56,72,54,75,91,
 70,98,259,217],
 [16,14,22,29,24,37,20,27,31,42,41,35,19,38,40,18,34,30,
 21,13,15,25,237,353,372,339,326,408,364,312,347,395,333,
 521,428,337,361,405,423,387,374,491,393,286,2449,1737,
 2393,1650,2414,1732],
 [16,14,22,29,24,37,20,31,42,41,32,35,19,38,40,18,34,30,
 21,13,15,25,58,82,100,79,59,104,102,56,72,54,60,75,70,
 98,222,259,223,217],
 [16,14,22,29,24,37,20,31,42,41,32,35,19,38,40,18,34,30,
 21,13,15,25,58,82,100,79,104,102,56,72,54,60,75,70,98,
 222,259,223,217,254,793,816],
 [16,14,22,29,24,37,20,31,42,41,32,35,19,38,40,18,34,30,
 21,13,15,25,237,353,372,339,394,326,408,312,347,395,429,
 333,428,337,361,405,423,387,419,374,393,286,1737,844,1650,
 738,1732,756],
 [16,14,22,29,24,37,31,42,41,32,35,19,38,40,18,34,30,21,
 13,15,25,237,353,372,339,384,394,326,408,312,347,395,425,
 429,333,428,337,361,405,423,387,444,419,374,393,286,1737,
 844,1650,738,1732,756],
 [16,14,22,29,24,39,20,31,42,41,32,35,19,38,40,18,34,30,
 21,13,15,25,237,353,372,316,394,326,312,347,345,429,333,
 428,337,361,405,423,377,419,374,393,286,1737,976,844,1650,
 813,738,1732,835,756],
 [16,14,22,29,24,39,37,20,31,42,41,32,35,19,38,40,18,34,
 30,21,13,15,25,58,82,100,59,104,102,56,72,60,75,70,98,
 222,259,223,217],
 [16,14,22,29,24,39,37,20,31,42,41,32,35,19,38,40,18,34,
 30,21,13,15,25,58,82,100,69,85,104,102,56,72,60,75,70,
 98,304,254],
 [16,14,22,29,24,39,37,20,31,42,41,32,35,19,38,40,18,34,
 30,21,13,15,25,237,353,372,394,326,408,312,347,429,333,
 428,337,361,405,423,419,374,393,286,1737,844,1650,738,
 1732,756],
 [16,14,22,29,24,39,37,31,42,41,32,35,19,38,40,18,34,30,
 21,13,15,25,58,82,100,104,102,56,72,96,60,75,70,98,300,
 222,259,287,223,217,254,793,816],
 [16,14,22,29,24,39,37,31,42,41,32,35,19,38,40,18,34,30,
 21,13,15,25,58,82,100,105,69,85,104,102,56,72,96,60,75,
 70,98,304,254],
 [16,14,22,29,24,39,37,31,42,41,32,35,19,38,40,18,34,30,
 21,13,15,25,237,353,372,384,394,326,408,312,347,425,429,
 333,428,337,361,405,423,444,419,374,393,286,1737,844,1650,
 738,1732,756],
 [16,14,22,33,17,39,27,36,31,41,35,28,19,38,40,34,23,30,
 21,13,25,58,61,97,94,66,71,102,84,103,78,96,87,91,99,
 52,300,272,287,269,250,876,853],
 [16,14,22,33,17,39,27,36,31,41,35,28,19,38,40,34,23,30,
 21,13,25,237,282,289,316,384,369,422,364,352,336,345,425,
 367,521,346,476,361,433,409,377,444,380,491,371,472,2449,
 1271,2393,1281,2414,1566],
 [16,14,22,33,17,39,36,31,41,28,19,38,40,23,21,13,69,76,
 83,101,103,78,60,86,81,62,57,237,282,384,369,422,425,
 367,521,476,361,433,371,311,482,495,637,604,543,412,608,
 448,590,599,573,550,532,559,529,499,454,577,907,1205,1267,
 1070,1273,1264,1213,931,1579,1979,1584,2055,3343,3614,2720,
 2773,4351,3683,3999,4560,3068,3145,8510,7755,7841,8566],
 [16,14,22,39,37,20,31,42,38,40,18,21,13,15,97,89,55,83,
 101,90,91,86,62,57,237,282,353,372,443,408,352,312,347,
 361,433,393,385,203,321,187,430,515,397,496,458,461,511,
 560,466,524,412,485,527,478,494,459,552,456,498,480,1737,
 1232,1650,1395,1091,1290,1250,1156,951,1454,1209,1420,917,
 1348,2223,1258,1359,2281,1394,2026,1222,1306,1977,1673,2456,
 2277,3348,2329,3065,2331,2679,5850,2881,2553,2528,4822,3043,
 4275,3026,5484,5633,8803,6718,5141,7813,5547,3742,5447,3419,
 7623,7197,6569,6630,8210,6640,7733,6158,7532,7675,6965,6093]
  ,[16,14,24,17,20,27,31,42,32,35,38,18,30,21,15,25,50,
 61,79,94,53,108,63,84,54,78,80,68,237,326,421,443,364,
 312,428,424,374,354,286,307,267,464,536,556,580,427,508,
 474,512,544,623,502,431,486,1847,1232,1852,1301,779,1285,
 1143,1255,1087,1560,1740,1516,1633,1714,1531,2191,1582,1370,
 2048,2064,2634,3152,2918,2728,3832,2765,3887,2701,4242,4458]
  ,[16,14,24,17,20,27,31,42,32,35,38,18,30,21,15,25,50,
 61,89,53,108,63,84,90,80,68,237,326,421,443,364,312,428,
 424,374,354,286,193,234,200,253,464,469,547,461,580,427,
 508,474,449,538,494,623,431,486,1847,1232,1852,1301,779,
 907,1146,1089,1024,946,1161,1103,911,1573,1676,1516,1633,
 1545,1717,1582,1370,2048,2064,2903,2837,2484,2789,2893,2578,
 3082,2765,2989,2701,5761,5658],
 [16,14,24,17,20,27,31,42,32,35,38,18,30,21,15,25,58,85,
 59,95,55,104,102,75,70,106,81,98,339,316,402,352,366,
 392,411,433,387,377,338,249,310,330,575,565,469,547,609,
 511,489,582,611,519,510,532,600,502,818,1012,1172,934,
 1079,850,1106,856,1549,2053,1750,1714,1810,2243,3352,3137],
 [16,14,24,17,39,37,20,27,31,42,35,19,38,40,18,34,30,21,
 13,15,25,237,340,282,326,381,481,421,408,364,402,352,312,
 366,521,428,337,361,411,433,405,374,368,491,393,286,1357,
 1502,1434,1486,1325,1401],
 [16,14,24,17,39,37,20,27,31,42,41,32,35,19,40,18,34,30,
 21,13,15,25,237,340,282,326,421,376,408,364,402,352,312,
 333,428,344,337,361,411,433,405,374,393,317,286,1357,1434,
 1325],
 [16,14,24,17,39,37,27,31,42,41,35,38,40,30,21,13,71,63,
 84,91,52,57,237,326,421,443,407,408,364,312,333,428,424,
 361,374,393,385,287,575,565,614,624,554,543,585,572,412,
 608,625,474,507,584,573,621,638,529,463,480,1847,1232,989,
 1852,1301,1924,1395,1287,1187,1443,1264,1602,2124,2437,3637,
 1782,1452,2381,2358,3300,1791,2097,2116,3123,1888,1479,2048,
 2064,2249,5550,4815,4513,5342,3999,4791,2609,5265,8217,5360,
 7682,4941,8714,6654,7394,6475],
 [16,14,24,17,39,37,27,42,35,19,38,40,34,21,13,25,61,105,
 92,66,71,83,74,84,96,65,91,99,62,52,237,340,326,381,
 421,408,364,402,366,428,337,361,411,405,368,393,286,526,
 524,519,498,1357,1502,1434,1486,1325,1401],
 [16,14,24,33,17,39,37,27,36,31,41,35,28,19,38,40,34,23,
 30,21,13,25,237,340,282,481,422,541,364,402,352,425,367,
 521,346,476,361,411,433,444,380,491,371,472,2560,1621,
 2525,1569,2439,1807],
 [16,14,29,17,37,20,31,42,32,19,40,18,30,21,13,15,58,50,
 82,85,89,59,104,102,63,56,75,90,70,98,394,375,336,395,
 332,344,313,419,317,354,236,482,467,537,536,458,598,485,
 528,449,504,512,478,638,516,826,811,1297,968,1288,2082,
 1674,1874,2429,1474,1739,2246,2165,5532,4366],
 [16,14,29,17,37,20,31,42,32,19,40,18,30,21,13,15,97,79,
 69,76,77,55,101,103,54,60,86,93,81,57,237,340,381,421,
 408,312,337,361,411,374,368,393,515,637,596,518,477,511,
 527,488,599,584,514,459,535,480,1357,1502,1325,1401,2104,
 2491,2097,2392],
 [16,14,29,24,17,39,37,20,27,31,42,32,35,19,38,40,18,34,
 30,21,13,15,25,58,50,82,85,89,59,104,102,63,56,75,90,
 70,98],
 [16,14,29,24,17,39,37,20,27,31,42,32,35,19,38,40,18,34,
 30,21,13,15,25,237,340,326,381,421,408,364,402,312,366,
 428,337,361,411,405,374,368,393,286,1357,1502,1434,1486,
 1325,1401],
 [16,14,29,24,33,17,39,20,27,36,31,42,32,35,19,38,18,34,
 23,30,21,15,25,58,50,94,89,59,53,108,102,63,78,90,70,
 80,68],
 [16,14,29,24,39,20,27,31,32,35,19,38,34,30,21,15,50,100,
 94,53,108,101,63,72,78,80,68,57,237,326,369,364,312,428,
 346,337,405,374,380,307,267,464,455,570,556,580,427,561,
 527,474,505,465,557,544,623,431,553,480,1285,1263,1143,
 1231,1255,1186,1087,1168,2263,1163,2634,2508,3032,2908,2918,
 2584,4050,2792],
 [16,14,29,24,39,20,27,31,32,35,19,38,34,30,21,15,58,82,
 85,88,59,102,56,75,87,70,372,316,381,370,360,402,392,
 411,338,249,236,350,320,308,303,575,441,558,547,518,543,
 549,609,598,582,483,546,532,514,600,638,553,480,1534,1267,
 1399,1671,1081,1649,1273,1456,1570,1203,1958,1860,1583,1982,
 1896,1497,5489,3204,2996,5986,2985,3099],
 [16,14,29,24,39,20,31,42,32,35,19,38,34,30,15,25,50,94,
 53,71,64,108,63,78,80,99,49,68,237,394,326,312,347,428,
 337,405,423,419,374,286,270,273,464,551,556,580,489,427,
 474,562,544,514,623,431,844,1650,1732,756,1403,988,1077,
 1512,1046,1085,1409,1195,2311,1440,1176,2392,2662,3924,4270,
 2742,3405,4526,3444,3677,9107,7254],
 [16,14,29,24,39,20,31,42,32,35,19,38,34,30,15,25,50,94,
 89,64,108,63,78,90,49,68,237,394,326,312,347,428,337,
 405,423,419,374,286,201,276,192,209,464,551,441,570,556,
 458,461,427,474,562,544,478,494,470,559,431,844,1650,1732,
 756,993,1506,1078,1038,1536,999,1409,2588,2281,1440,1977,
 2316,3459,3718],
 [16,14,29,24,39,20,31,42,32,35,19,38,34,30,15,25,58,82,
 100,59,104,102,56,72,70,98,316,381,410,370,402,366,392,
 346,411,341,249,222,259,223,217,575,441,570,583,609,489,
 582,426,488,483,557,595,600,502,1862,1129,978,1891,1157,
 1011,1114,1285,967,1034,1255,1941,1412,1480,1823,2009,1698,
 1783,1775,1961,1414,1431,1812,1826,2791,3737,3066,2955,3307,
 2976,5238,4847,4332,5825,7170,7573],
 [16,14,29,33,17,20,36,31,42,32,19,18,23,30,21,15,58,50,
 94,89,59,53,108,102,63,78,90,70,80,68,394,375,376,407,
 336,395,429,332,344,313,419,327,317,354,236,482,467,598,
 528,449,638,834,1339,826,811,1297,968,1288,2082,2429,2238,
 2246,2165],
 [16,14,29,33,17,20,36,31,42,32,19,18,23,30,21,15,58,50,
 108,80,394,375,376,407,336,395,429,332,344,313,419,327,
 317,354,236,482,467,441,637,596,547,518,477,503,489,427,
 447,626,582,538,505,465,470,623,593,539,502,431,615,834,
 1339,826,811,1297,968,1288,1277,1403,1177,2082,3133,1765,
 1683,1110,1167,2010,1956,2254,3156,1788,1698,1117,1199,2035,
 3500,1824,1711,1185,1233,2187,2238,2246,2165,9073,6065,3882,
 3666,3183,4418,8216,5860,4219,3380,5395,6016,4094,3555,5138,
 6906,3995,3654,7146,4108,3707,4961,4020,4096,9149,7230,8679,
 7759,6199,6214,6743,6825,7188,6287,7966,6266,6480],
 [16,14,33,17,39,20,27,36,31,42,32,35,28,38,18,34,23,30,
 21,15,25,237,282,289,316,389,370,364,402,352,336,345,366,
 424,392,362,361,411,433,409,377,368,385,338,249,3484,1330,
 1490,3575,1012,992,3624,1172,1069],
 [16,14,33,17,39,27,36,31,35,28,38,34,23,30,21,25,58,61,
 66,71,102,84,96,87,91,99,52,289,316,389,370,336,345,362,
 411,368,385,338,250,575,490,501,500,530,509,545,503,533,
 506,582,505,534,584,514,552,470,555,539,615,1228,1187,
 1096,1221,1819,1252,1147,2158,1194,1359,2318,1184,1306,2526,
 2594,6048,4634,2537,2553,5731,4755,2489,3192,8947,8231],
 [16,17,19,40,13,58,50,82,94,85,89,59,104,64,102,107,63,
 56,78,87,90,91,70,62,49,52,394,360,429,332,419,236,356,
 315,300,240,272,291,350,229,227,261,329,212,243,276,292,
 434,383,287,207,269,238,308,228,349,299,290,278,482,467,
 496,537,536,567,469,531,522,545,479,540,473,528,449,525,
 504,512,550,510,548,523,555,442,497,463,714,727,1023,721,
 736,932,758,1478,740,1471,841,1472],
 [16,17,19,58,50,61,82,94,105,85,92,89,66,59,53,104,83,64,
 108,74,102,107,63,56,78,96,65,87,91,99,62,49,52,394,
 375,360,429,332,419,236,356,272,350,261,212,270,221,201,
 292,437,434,269,308,228,299,273,220,192,278,357,482,467,
 537,536,567,469,531,522,545,479,540,473,528,449,504,512,
 550,510,548,523,555,442,497,463,758,1478,740,1471,841,1472 
  ],[16,17,19,58,50,61,82,94,105,85,92,89,66,59,104,83,
 64,108,74,107,56,78,96,65,87,90,91,70,80,99,62,49,68,
 52,394,375,360,429,419,236,356,272,359,350,247,215,261,
 212,292,434,269,295,308,231,245,228,299,278,482,467,537,
 536,567,469,493,531,522,545,479,540,473,528,449,504,512,
 550,510,462,548,523,555,442,497,463,758,1478,740,1471,841,
 1472],[16,17,19,58,50,61,82,105,85,92,89,66,59,104,83,
 64,74,107,56,78,96,65,87,91,99,62,49,52,394,375,360,
 429,419,236,356,234,272,359,350,280,247,215,261,212,201,
 292,437,434,269,295,308,262,231,245,228,299,273,220,192,
 278,357,482,467,537,536,567,469,493,531,522,545,479,540,
 473,528,449,504,512,550,510,462,548,523,555,442,497,463,
 794,1010,879,776,979,890,758,1478,740,1471,841,1472],
 [16,17,19,61,82,85,88,66,76,77,55,104,83,64,74,101,107,
 84,103,56,54,96,60,65,87,91,86,99,98,62,49,52,57,316,
 389,345,392,362,377,338,249,356,279,193,300,222,240,212,
 251,203,287,207,308,235,187,588,575,500,455,580,585,489,
 427,505,465,599,584,502,431,696,750,1084,742,974,635,684,
 769,1101,718,1021,628,818,831,1050,1139,1064,1059,1078,
 1082,1026,1094,1124,1092,999,1005,1194,1258,1110,1167,1184,
 1222,1117,1199,1242,1292,1185,1233,2320,2370,2343],
 [16,17,19,61,82,85,88,66,104,83,64,74,107,84,56,96,65,87,
 91,99,98,62,49,52,316,389,345,392,377,338,249,356,300,
 240,298,230,212,251,203,287,207,213,308,235,187,588,575,
 500,455,537,536,493,580,585,489,427,540,473,505,525,465,
 599,584,548,523,502,516,431,587,696,750,674,635,684,769,
 628,818,831,1229,857,1035,1050,1139,1091,1158,1114,1064,
 1059,1206,945,988,1078,1082,1156,1089,1257,1026,1094,1126,
 1249,1034,1070,848,1166,1124,1092,999,1005,1154,1103,1170,
 2464,2391,1194,1258,2171,2468,1110,1167,1184,1222,1956,2254,
 1117,1199,2301,1242,1292,1185,1233,2015,3033,4391,4172,3355,
 4106,3476,3215,4562,3675,3105,4329,4137,3200,3839,3670,3177,
 4367,3225,2320,2370,2343,2967,3524,2679,3857,4207,3917,2710,
 3217,3701,2528,4439,3582,3655,2706,4159,3548,3803,2905,3542,
 3615,2633,4530,3985,3995,3654,3872,4108,3707,3840,4020,4096,
 6539,7752,8028,8199,6088,6285],
 [16,17,19,61,82,105,85,92,66,104,83,64,108,74,102,107,63,
 56,96,65,87,90,91,70,99,62,49,68,52,394,375,429,332,
 419,236,342,356,324,272,307,304,350,261,212,292,388,434,
 406,269,267,254,308,228,299,278,482,467,495,537,441,536,
 624,567,469,547,531,509,522,545,479,503,540,447,473,528,
 449,538,504,483,512,581,550,510,532,548,470,523,555,442,
 539,497,468,463,758,1478,740,1471,841,1472],
 [16,17,19,61,82,105,92,88,89,66,59,71,104,83,64,108,74,
 84,56,75,87,90,91,70,98,62,49,68,52,394,360,429,332,
 363,419,327,236,342,356,324,247,264,215,329,243,388,434,
 406,217,349,290,209,482,467,495,531,509,522,545,479,503,
 528,449,538,504,483,512,555,442,539,497,468,463,644,668,
 746,707,712,665,671,763,717,723,971,827,905,1102,907,1020,
 993,981,969,1251,1119,1017,1100,946,885,1038,931,1019,1159,
 1060,1386,1503,1697,1677,1627,1683,1501,1572,1687,1637,1529,
 1698,1464,1598,1696,1746,1631,1711,1919,1920,1914],
 [16,17,19,61,97,82,79,85,88,66,76,104,83,64,74,101,107,
 84,103,56,54,96,60,65,87,91,86,98,62,49,52,57,316,389,
 345,392,362,377,338,249,356,300,222,240,212,251,276,203,
 287,223,207,319,308,311,235,209,187,588,575,500,455,580,
 585,489,427,505,465,599,584,502,431,796,696,804,750,635,
 871,684,810,769,628,818,831,1050,1139,1064,1059,1078,1082,
 1026,1094,1124,1092,999,1005,1194,1258,1110,1167,1184,1222,
 1117,1199,1242,1292,1185,1233,2320,2370,2343],
 [16,17,19,61,97,82,79,85,88,66,76,104,83,64,74,107,84,56,
 96,60,65,87,91,99,98,62,49,52,316,389,345,392,377,338,
 249,356,300,222,240,302,293,212,251,203,386,287,223,207,
 319,308,311,246,321,358,258,235,187,343,588,575,500,455,
 609,580,585,489,427,505,465,599,584,600,502,431,796,696,
 804,761,750,635,871,684,810,747,702,769,628,818,831,1050,
 1139,1064,1059,1078,1082,1026,1094,1124,1092,999,1005,2065,
 2063,1194,1258,1110,1167,1184,1222,1117,1199,1242,1292,1185,
 1233,2320,2370,2343],
 [16,17,19,67,61,82,94,105,92,88,66,71,104,83,64,108,74,
 102,63,84,56,78,75,87,90,91,70,80,98,62,49,68,52,394,
 360,429,332,363,419,327,236,342,324,264,329,243,388,406,
 217,267,254,295,349,290,209,482,467,531,522,545,479,528,
 449,504,512,555,442,497,463,644,663,793,784,668,707,665,
 701,816,765,671,717,971,827,905,907,1020,981,969,1119,
 1017,946,885,931,1019,1060,1386,1503,1677,1627,1501,1572,
 1637,1529,1464,1598,1746,1631,1919,1920,1914],
 [16,17,19,67,61,82,105,92,88,66,71,104,83,64,74,84,56,75,
 87,91,98,62,49,52,394,360,429,332,363,419,236,342,324,
 280,264,329,243,201,217,262,349,290,192,209,482,467,441,
 531,522,609,545,479,447,626,582,504,512,620,470,555,442,
 497,463,615,644,668,1333,983,707,665,671,717,971,827,1277,
 1403,1177,905,907,1020,981,1052,1039,881,1216,1162,1208,
 1171,1031,969,1119,1017,946,967,1087,986,885,931,1235,1261,
 1138,1019,1060,911,1168,1036,2259,2423,2278,2499,2223,2158,
 1386,1503,1677,1627,1727,2026,2318,1501,1572,1637,1529,1753,
 1464,1598,1746,1631,1712,2245,3172,3208,2149,3377,3687,4186,
 3583,2756,2277,3189,2051,3136,4203,2322,3322,3676,2128,3341,
 3620,2372,3005,2131,3281,3818,1919,1920,1914,3239,3114,5205,
 2646,3107,3345,5967,2885,4824,4069,3734,3430,6279,2683,3463,
 3116,4708,2494,4103,4048,3064,3229,4990,2685,3434,3703,5849,
 2641,4596,3397,7842,8911,4288,8952,7120,5413,4657,8764,4529,
 8521,4803,7885,8719,5278,8017,9092,7626,6520,9007,5723,6316,
 7369,7076,8167],
 [16,17,19,67,82,94,105,92,88,89,66,59,53,71,104,83,64,
 108,74,102,63,84,56,75,87,90,91,70,98,62,49,68,52,360,
 429,332,363,419,327,236,342,324,315,264,318,329,243,388,
 406,383,217,323,349,290,192,209,482,467,430,531,522,545,
 479,528,449,426,504,512,555,442,497,463,644,716,668,707,
 665,745,671,717,971,827,905,907,1020,981,969,1119,1017,
 946,885,931,1019,1060,1386,1503,1677,1627,1501,1572,1637,
 1529,1464,1598,1746,1631,1919,1920,1914],
 [16,17,27,19,25,58,67,50,61,97,79,85,88,77,53,71,55,104,
 83,108,74,107,103,56,54,78,96,65,87,80,99,62,49,68,52,
 186,234,300,240,212,270,206,216,221,251,203,292,253,287,
 207,267,238,213,254,214,299,235,187,278,663,896,630,793,
 720,746,712,845,919,704,662,1029,701,889,636,816,710,672,
 802,715,872,698,645,961,2452,2357,2455,2093,2084,1989,2129,
 2396,2467,2411,1948,1969,1934,2239,4110,3646,4453,3481],
 [16,17,27,31,35,34,30,25,58,67,50,61,82,79,105,85,88,89,
 66,59,95,77,71,104,64,108,74,102,107,84,56,54,96,75,87,
 91,70,93,80,99,98,49,52,279,234,359,215,302,318,270,288,
 437,294,253,295,245,273,301,357,695,873,753,798],
 [16,17,27,31,35,34,30,25,58,67,50,61,97,82,79,94,105,85,
 88,89,66,59,95,77,53,71,104,64,108,74,102,107,63,84,
 103,56,54,78,96,75,87,90,91,70,106,93,80,99,98,49,68,
 52],
 [16,17,27,31,35,34,30,25,58,67,61,79,105,85,88,66,77,71,
 104,64,74,107,54,96,87,91,70,99,49,52,340,289,316,381,
 443,389,370,402,336,345,366,424,392,411,409,377,368,385,
 338,249,186,304,247,261,212,251,292,254,231,228,299,235,
 278,526,474,535,754,741,1120,943,906],
 [16,17,27,31,35,34,30,25,58,67,61,79,105,85,88,66,77,71,
 104,64,74,107,54,96,87,91,70,99,49,52,340,381,443,389,
 402,336,345,362,409,377,249,186,304,247,261,212,251,292,
 254,231,228,299,235,278,482,495,606,526,518,564,509,585,
 489,508,447,620,514,552,470,593,502,486,468,754,741,1052,
 933,881,951,1065,984,1027,917],
 [16,17,27,31,35,34,30,25,58,67,61,82,79,105,85,88,66,59,
 77,71,104,64,74,102,107,84,56,54,96,75,87,91,70,93,99,
 98,49,52,340,289,316,381,443,389,370,402,336,345,366,424,
 392,362,411,409,377,368,385,338,249],
 [16,17,27,31,35,34,30,25,58,67,61,82,105,85,88,66,59,71,
 64,74,102,84,56,75,91,70,93,99,98,52,340,289,316,381,
 443,389,370,402,336,345,366,424,392,411,409,377,368,385,
 338,249,193,322,320,264,329,266,404,200,281,349,306,325,
 469,449,442,823,759,923,817,1120,943,906],
 [16,17,27,31,35,34,30,25,58,67,61,82,105,85,88,66,59,71,
 64,74,102,84,56,75,91,70,93,99,98,52,340,289,316,389,
 370,366,424,362,368,385,338,193,322,320,264,329,266,404,
 200,281,349,306,325,500,530,596,567,547,509,585,545,503,
 618,449,505,534,470,593,555,442,539,615,823,759,923,817,
 1158,1595,1206,1208,1249,1592,1349,1235],
 [16,17,27,31,35,34,30,25,67,79,105,88,66,59,71,64,74,102,
 107,84,54,96,75,87,91,93,99,98,49,52,381,443,370,366,
 424,392,411,409,377,338,249,342,315,259,322,320,221,388,
 383,217,319,303,330,220,575,482,495,441,596,567,547,489,
 508,582,528,538,483,584,550,519,532,600,502,486,1062,1040,
 1079,2103,1234,1106,2203,1317],
 [16,17,27,31,35,34,30,25,67,82,79,85,59,77,71,104,64,102,
 107,84,56,54,75,91,70,93,98,49,52,340,289,316,370,402,
 336,345,366,424,392,362,411,409,377,368,385,338,249,342,
 315,291,329,266,276,388,383,238,349,306,209,490,501,533,
 506,563,517,727,736,1330,1490,1293,1012,992,1276,1172,1069,
 1353,1228,1221,1243],
 [16,17,27,31,35,34,30,25,67,82,79,85,59,77,71,104,64,102,
 107,84,56,54,75,91,70,93,98,49,52,381,443,389,402,336,
 345,392,362,368,385,249,342,315,291,329,266,276,388,383,
 238,349,306,209,575,482,495,606,585,545,503,533,506,447,
 582,528,538,620,593,555,539,468,727,736,1287,1183,1187,
 1096,1171,1175,1221,1366,1230,1252,1147,1261,1300,1184,1306,
 2632,2526,2638,2594,2806,3667,2537,2553,3067,4807,2489,3192]
  ,[16,17,27,35,19,25,58,67,50,61,97,82,79,94,105,85,92,
 88,89,66,59,77,53,71,55,104,83,64,108,74,102,107,63,84,
 103,56,54,78,96,75,65,87,90,91,70,93,80,99,81,98,62,
 49,68,52],
 [16,17,27,35,19,25,58,67,50,61,97,82,79,105,85,92,88,89,
 66,59,77,71,55,104,64,107,84,103,56,54,78,96,75,65,87,
 91,99,98,62,49,52,234,359,229,280,227,247,215,270,221,
 251,203,253,295,260,262,250,231,245,273,220,235,192,187,
 357,716,772,745,751],
 [16,17,27,35,19,25,82,85,88,66,104,83,64,74,107,84,103,
 56,54,96,65,87,91,98,62,49,52,316,389,345,392,362,377,
 338,249,356,315,279,193,300,240,212,251,276,203,294,200,
 287,207,319,308,311,235,209,187,588,575,500,455,580,585,
 489,427,505,465,599,584,502,431,796,696,804,750,800,635,
 871,684,810,769,903,628,818,831,1050,1139,1064,1059,1078,
 1082,1026,1094,1124,1092,999,1005,1194,1258,1110,1167,1184,
 1222,1117,1199,1242,1292,1185,1233,2320,2370,2343],
 [16,17,27,35,30,97,105,92,88,66,59,95,77,74,101,102,107,
 103,96,65,87,93,99,49,52,57,381,389,370,366,368,249,356,
 186,350,331,320,244,310,206,203,292,388,434,202,308,311,
 303,214,330,239,220,301,187,278,575,565,467,495,596,604,
 469,547,479,503,447,582,611,449,538,584,573,510,532,442,
 539,468,1482,1112,1010,942,635,1661,918,979,884,628,913,
 1120,908,943,906,1093,1354,1663,1225,1077,1082,1108,1142,
 1322,1590,1319,1085,1005,1057,1508,1494],
 [16,17,30,58,67,50,61,82,79,94,105,92,88,59,95,77,53,71,
 64,102,63,84,54,78,96,75,65,87,90,91,70,106,93,289,394,
 375,336,409,419,327,259,307,291,264,310,201,276,404,217,
 267,238,281,330,192,209,325,536,556,606,614,624,522,549,
 609,602,598,473,527,618,608,625,512,544,620,590,581,523,
 568,600,621,638,463,480,615,577,587,1752,1407,1770,1496,
 1755,1504],
 [16,17,30,58,67,50,61,82,79,94,105,92,88,59,95,77,53,71,
 64,102,63,84,96,75,65,87,90,91,70,106,93,80,289,394,
 375,336,409,419,327,259,307,291,264,310,293,318,276,404,
 217,267,238,281,330,358,323,209,325,536,556,606,614,624,
 522,549,609,602,598,473,527,618,608,625,512,544,620,590,
 581,523,568,600,621,638,463,480,615,577,587,1752,1407,
 1770,1496,1755,1504],
 [16,17,30,58,67,50,61,82,79,94,105,92,88,89,59,95,77,53,
 71,64,108,102,54,78,96,75,65,87,90,91,70,106,93,80,289,
 394,375,336,409,419,327,259,291,264,215,261,310,276,404,
 437,217,238,281,245,228,330,209,325,357,536,556,614,624,
 522,549,602,598,473,527,608,625,512,544,590,581,523,568,
 621,638,463,480,577,587,1752,1407,1770,1496,1755,1504],
 [16,17,30,58,67,50,61,82,105,92,88,89,59,95,77,71,64,102,
 96,75,65,87,91,70,106,93,80,289,394,336,409,419,327,193,
 234,259,291,359,280,264,310,293,318,270,276,404,217,238,
 295,262,281,245,228,330,358,323,209,325,496,536,556,614,
 624,522,549,602,598,473,527,608,625,512,544,590,581,523,
 568,621,638,463,480,577,587,824,722,919,802,715,718,890,
 872,1752,1407,1770,1496,1755,1504,2103,1922,2353,2203,1224,
 1931,2382,2421,2497,2462,2692,2986,2978],
 [16,17,30,58,67,82,105,92,88,59,95,77,71,64,102,96,75,65,
 87,91,70,106,93,289,336,409,419,327,324,315,259,291,280,
 264,310,293,318,201,276,404,217,238,262,281,330,358,323,
 209,325,467,495,430,536,556,614,624,522,549,602,598,479,
 503,473,527,608,625,512,544,590,581,510,532,470,523,568,
 621,638,593,591,463,480,577,587,983,800,859,957,920,903,
 883,792,971,1752,1407,827,1770,1496,998,1755,1504,1403,
 1102,1143,2103,1173,1216,1922,1171,1231,2353,1087,2203,1456,
 1209,1254,1931,1168,2382,2158,2148,1838,4230,4289,2318,2619,
 1779,4078,4885,2295,2366,1775,3879,4283,2606,2498],
 [16,17,30,58,97,105,85,92,88,66,76,59,95,77,55,104,74,
 101,102,107,103,56,96,60,65,87,70,106,93,99,81,98,49,
 52,57,381,389,370,366,368,338,249,356,186,222,350,244,
 212,206,216,434,202,223,308,214,299,239,258,575,565,467,
 495,596,604,469,547,585,572,479,503,582,611,449,538,584,
 573,510,532,593,591,442,539,913,1120,908,943,966,906],
 [16,17,30,58,105,69,85,92,88,66,76,59,95,77,74,101,102,
 107,56,96,60,65,87,70,106,93,99,81,98,49,52,57,381,389,
 370,366,368,338,249,356,186,350,331,320,244,212,206,216,
 434,202,308,311,303,214,299,239,258,575,565,482,467,495,
 596,604,567,469,547,585,572,545,479,503,582,611,528,449,
 538,584,573,550,510,532,593,591,555,442,539,913,1120,908,
 943,966,906],
 [16,17,30,58,105,85,92,88,66,76,59,95,77,55,104,102,107,
 103,56,96,65,87,86,70,106,93,99,81,98,49,52,57,381,389,
 370,366,368,338,249,356,279,186,350,244,227,230,212,206,
 434,294,202,308,214,250,246,299,239,575,565,467,495,430,
 596,604,469,547,458,585,572,479,503,466,582,611,449,538,
 426,584,573,510,532,478,593,591,442,539,456,913,1120,908,
 943,966,906],
 [16,17,30,67,82,105,69,85,92,88,66,76,59,95,64,74,101,
 102,107,56,75,91,86,70,106,93,99,81,98,49,52,57,389,
 370,366,392,362,368,338,249,322,350,331,320,243,266,388,
 308,311,303,349,305,290,306,596,604,567,469,547,479,503,
 582,611,528,510,532,593,591,555,442,539,1482,1272,1334,
 823,1661,1053,1198,923,1012,1172,1539,1760,1229,1354,1663,
 1205,1595,1730,1206,1532,1815,1355,1322,1590,1070,1592,1773,
 1349,1822,1856,1765,1751,1909,1932,1788,1747,1816,1843,1824,
 1780,2156,2147,2213],
 [16,17,30,67,82,105,69,85,92,88,66,76,71,64,102,107,103,
 56,60,75,91,86,70,106,93,99,81,98,49,52,57,389,370,392,
 362,368,338,249,304,351,322,331,320,227,230,243,266,388,
 294,254,328,311,303,250,246,349,290,306,596,604,469,547,
 518,479,503,582,611,510,532,514,593,591,442,539,1482,1318,
 1272,823,1661,1340,1053,923,1012,1172,1539,1760,1354,1663,
 1595,1730,1532,1815,1322,1590,1592,1773,1822,1856,1765,1751,
 1909,1932,1788,1747,1816,1843,1824,1780,2156,2147,2213],
 [16,17,30,67,97,82,105,85,92,88,66,76,59,95,71,64,74,101,
 102,107,103,56,75,91,70,106,93,99,81,98,49,52,57,389,
 370,366,392,362,368,338,249,322,331,320,243,266,216,388,
 349,290,306,258,596,604,469,547,458,479,503,466,582,611,
 593,591,442,539,456,1482,1272,823,1042,759,1661,1053,923,
 1054,817,1012,1539,1760,1354,1663,1595,1730,945,1208,988,
 1532,1815,1322,1590,1592,1773,949,1235,1046,1822,1856,1853,
 1765,1751,1854,1909,1932,1883,1481,1788,1747,1863,1816,1843,
 1846,1824,1780,1859,1702,2156,2147,2213],
 [16,17,30,105,71,91,70,106,93,368,327,291,304,351,322,212,
 243,266,388,434,238,349,606,614,624,596,604,567,511,479,
 503,466,582,611,528,620,590,581,593,591,555,1482,1378,692,
 764,668,703,809,778,1192,1063,823,635,901,697,1023,665,
 705,914,672,728,1053,725,868,795,763,717,628,897,664,932,
 1757,1407,1012,827,1539,1760,1229,948,1335,1362,1577,993,
 981,1076,1104,850,1304,1081,1326,1595,1730,1206,951,1089,
 1024,1257,936,1095,1345,1546,1100,946,1161,1071,952,1405,
 1223,1591,1322,1590,1070,856,1214,1203,1367,1159,1060,1090,
 1140,917,1103,911,1170,860,1080,1215,1556,2470,2008,2241,
 2362,2415,2884,3315,3663,2004,2608,2474,2430,2543,2352,2398,
 2442,2420,2375,4047,3473,2069,2431,2377,2868,2124,1822,1856,
 1853,3881,2799,2919,1567,1627,1683,1283,3809,4713,3935,2381,
 1909,1932,1883,1956,2760,2254,3771,2795,2932,1514,1529,1698,
 1226,4178,4619,3926,2097,1816,1843,1846,3913,3056,3004,1557,
 1631,1711,1259,2015,2304,2187,4170,4246,3766,2593,4214,2637,
 2945,4128,3261,3033,2482,3343,2597,3125,4274,4179,3355,2704,
 4153,2425,2934,4871,4155,3215,2480,3754,2768,3090,4160,3328,
 3105,2623,3614,2516,3230,4252,3931,3200,2668,3833,2568,2966,
 4903,3796,3177,2156,1973,4954,4723,4870,1919,2147,2060,5407,
 4629,4408,1920,2213,2006,4921,4845,4854,1914,4365,5254,2644,
 3275,2816,2662,3276,3524,3595,2679,2615,3279,2850,2731,2906,
 3917,3622,2710,2774,2913,2684,2622,3247,3701,4039,2528,2610,
 3202,2833,2742,2897,3655,3570,2706,2665,3141,2777,2772,3260,
 3803,4100,2905,2738,3038,2832,2859,2733,3615,3612,2633,4092,
 4856,4412,3985,3757,4321,3767,3880,5805,3995,5936,3654,3955,
 4677,4428,3872,3904,4886,4037,4067,5443,4108,5161,3707,3779,
 4444,4277,3840,3806,4760,4120,4121,6073,4020,5844,4096,5928,
 5169,4474,5556,5898,6005,4821,5107,5854,5969,4561,5290],
 [16,17,31,58,50,61,79,105,85,88,89,66,59,95,77,53,104,64,
 108,74,102,107,63,84,54,96,87,91,70,93,80,99,98,49,68,
 52,375,407,432,360,429,332,313,355,363,419,327,354,283,
 236,356,350,212,270,288,434,308,299,273,301,482,464,495,
 567,526,547,545,511,503,528,474,538,550,519,532,555,535,
 539,2628,2835,2762],
 [16,17,31,58,50,61,82,79,85,89,66,59,95,77,104,64,108,74,
 102,107,63,84,56,54,90,91,70,106,93,80,99,98,49,68,52,
 394,432,360,429,332,313,355,363,419,327,354,283,236,356,
 359,350,212,434,295,308,299,482,495,490,501,567,547,554,
 513,545,503,533,506,528,538,507,487,550,532,563,517,555,
 539,529,499,971,777,827,975,998,991],
 [16,17,31,58,61,79,105,69,85,88,66,76,59,77,71,55,104,74,
 102,84,56,54,96,60,75,87,86,70,93,99,81,98,62,49,52,
 57,381,443,389,370,402,366,424,392,362,411,368,385,338,
 249,186,229,244,230,206,202,260,214,246,239,616,482,495,
 597,567,547,619,545,503,617,528,538,610,550,532,605,555,
 539,3484,3575,3624],
 [16,17,31,58,61,82,105,85,88,89,66,59,95,77,53,104,64,
 108,74,102,107,63,84,56,96,87,90,91,70,106,93,80,99,98,
 49,68,52,394,375,407,432,360,429,332,313,419,327,354,283,
 236,356,324,350,212,434,406,308,299,482,467,495,567,469,
 547,545,479,503,528,449,538,550,510,532,555,442,539,1211,
 758,1270,740,1329,841],
 [16,17,31,58,67,61,82,79,105,85,88,66,59,77,71,104,64,74,
 102,107,84,56,54,96,75,87,91,70,93,99,98,49,52,340,289,
 316,394,381,375,443,389,407,432,370,360,402,336,345,429,
 366,332,424,392,313,355,362,363,411,409,377,419,368,327,
 385,338,354,283,249,236],
 [16,17,31,67,50,82,105,85,88,89,66,59,95,71,64,108,74,
 102,107,63,84,56,75,91,70,93,80,99,98,49,68,52,407,432,
 360,332,313,355,363,327,354,283,236,342,315,322,359,320,
 329,266,270,288,388,383,319,295,303,349,306,273,301,482,
 467,495,430,567,469,547,458,545,479,503,466,528,449,538,
 426,550,510,532,478,555,442,539,456,971,827,998],
 [16,17,31,67,79,105,69,85,88,66,76,59,77,71,55,104,83,74,
 101,107,56,54,96,60,75,87,70,93,99,81,98,62,49,52,57,
 340,381,443,389,370,402,362,411,368,385,338,249,186,244,
 206,216,202,214,239,258,588,565,482,495,637,604,567,547,
 580,572,545,503,626,611,528,538,599,573,550,532,623,591,
 555,539,1757,1483,913,1796,1520,908,1835,1537,966],
 [16,17,31,67,79,105,85,88,66,59,77,71,104,74,107,56,54,
 96,75,87,70,93,99,98,49,52,340,381,443,389,370,402,362,
 411,368,385,338,249,229,244,230,255,203,213,260,246,305,
 239,187,588,565,430,637,604,567,547,493,574,598,580,572,
 466,626,611,571,581,599,573,478,623,591,555,539,516,566,
 587,1160,866,803,1238,812,820,1757,1483,913,1796,1520,908,
 1835,1537,966,1229,1277,1205,1234,1267,981,1206,1208,1355,
 1106,1361,1070,1273,1349,1363,1235,1060,2288,2365,3133,1751,
 1574,3156,1747,1515,3500,1780,1636,4214,2667,3343,4153,3102,
 3754,3614,3534,3833,2708,2605,2722],
 [16,17,31,67,79,105,85,88,66,76,59,77,71,55,104,83,74,
 101,107,56,54,96,60,75,87,86,70,93,99,81,98,62,49,52,
 57,340,381,443,389,370,402,362,411,368,385,338,249,186,
 222,244,206,202,223,214,239,588,565,482,495,637,604,567,
 547,580,572,545,503,626,611,528,538,599,573,550,532,623,
 591,555,539,1757,1483,913,1796,1520,908,1835,1537,966],
 [16,17,31,67,79,105,85,88,89,66,59,95,53,71,64,74,102,
 107,63,84,54,75,90,91,70,106,93,80,99,98,49,68,52,375,
 407,432,360,332,313,327,354,283,236,342,324,315,322,320,
 280,329,266,388,406,383,319,303,262,349,306,482,464,495,
 430,567,526,547,458,545,511,503,466,528,474,538,426,550,
 519,532,478,555,535,539,456,1211,758,1270,740,1329,841],
 [16,17,31,82,79,105,69,85,88,66,76,59,71,83,64,74,101,
 102,84,56,54,60,75,91,70,93,99,81,98,62,49,52,57,381,
 443,389,370,366,424,362,368,385,338,249,342,315,322,331,
 320,329,266,216,388,383,319,311,303,349,306,258,616,575,
 482,495,597,596,567,547,619,585,545,503,617,582,528,538,
 610,584,550,532,605,593,555,539,913,908,966],
 [16,17,35,19,25,97,82,79,85,88,77,55,104,64,107,84,103,
 56,54,60,87,98,62,49,52,316,389,345,392,362,338,249,356,
 300,222,240,291,229,227,329,212,243,206,251,276,203,383,
 287,223,207,238,308,260,250,235,209,187,588,575,500,455,
 580,585,503,489,427,505,465,599,584,502,431,1507,696,750,
 864,635,901,704,684,769,829,628,897,698,818,831,1050,1139,
 1064,1059,1078,1082,1024,1026,1094,1124,1092,999,1005,911,
 9064,3586,1194,1258,1110,1167,1184,1222,1117,1199,1242,1292,
 1185,1233,2320,2370,2343],
 [16,17,37,19,40,13,58,50,61,82,105,85,92,66,104,83,64,74,
 107,56,96,65,87,90,70,99,49,394,375,429,356,272,307,304,
 350,247,215,261,212,206,292,382,435,434,269,267,254,308,
 231,245,228,299,239,278,314,335,482,467,537,536,624,567,
 469,493,531,522,545,479,466,540,473,625,528,449,504,512,
 581,550,510,462,548,523,555,442,456,497,463,587,758,1478,
 740,1471,841,1472],
 [16,17,37,19,40,13,58,50,61,105,85,92,66,83,64,74,107,56,
 96,65,87,91,99,62,49,52,375,429,419,236,356,186,272,307,
 304,350,320,247,215,261,270,221,292,434,269,267,254,308,
 303,231,245,228,299,273,220,278,482,467,430,537,536,624,
 567,469,493,531,522,540,473,528,449,504,512,581,550,510,
 462,548,523,555,442,497,463,1112,754,918,741,758,1478,740,
 1471,841,1472,1205,867,1173,1070,848,1209],
 [16,17,37,19,40,13,58,50,82,85,89,59,104,83,64,74,102,63,
 56,87,90,91,70,62,49,52,394,360,429,332,419,236,356,315,
 264,261,212,434,383,269,238,299,278,482,467,490,451,531,
 543,522,545,479,533,450,528,449,507,413,504,557,512,555,
 442,529,396,497,553,463,870,896,1107,707,845,914,889,1075,
 717,941,971,1478,827,740,1471,841,1472,905,1343,907,1020,
 1506,981,969,1521,1119,1017,1444,946,885,1536,931,1019,
 1541,1060,1386,1503,1437,1358,1677,1627,1368,1467,1501,1572,
 1402,1432,1637,1529,1307,1397,1464,1598,1408,1430,1746,1631,
 1336,1389,2825,1919,2726,1920,2823,1914],
 [16,17,37,19,40,13,58,67,50,61,82,85,88,89,66,59,77,71,
 55,104,83,64,74,102,107,63,84,96,75,65,87,91,86,99,98,
 62,49,52,57,279,193,300,222,240,298,230,302,310,293,255,
 270,221,251,203,294,200,287,223,207,246,273,220,235,187,
 912,695,808,762,807,753,799,785,787,2031,2177],
 [16,17,37,19,40,13,58,67,50,61,97,79,69,85,88,89,66,76,
 59,77,55,104,83,74,107,103,56,54,96,60,75,65,87,90,86,
 70,99,98,49,57,186,300,240,350,247,215,261,206,251,203,
 287,207,308,214,246,231,245,228,314,335,720,761,754,704,
 710,747,801,869,741,875,1151,1785,1974,1801,1957,3135,2924,
 2007,9256,5931,5325,4923,2982,8992,5432],
 [16,17,37,19,40,13,58,67,50,61,97,82,79,105,69,85,92,88,
 89,66,76,59,77,71,55,104,83,64,74,101,102,107,63,84,
 103,56,54,96,60,75,65,87,90,91,86,70,93,99,81,98,62,
 49,52,57],
 [16,17,37,19,40,13,58,67,50,61,97,82,79,105,85,92,88,89,
 66,76,59,104,83,64,74,102,107,63,84,96,60,75,65,87,91,
 99,98,62,49,52,222,322,350,331,230,302,310,293,270,221,
 251,203,386,223,319,308,311,246,321,330,358,273,258,220,
 235,187,343,726,702],
 [16,17,37,19,40,13,61,105,92,66,71,104,83,64,74,84,75,87,
 91,98,62,49,52,394,360,429,332,419,236,342,356,324,247,
 264,215,329,243,388,434,406,217,269,349,290,209,482,464,
 467,518,477,531,522,545,511,479,528,474,449,505,465,504,
 512,555,535,442,502,431,497,463,644,870,668,746,707,712,
 665,914,671,763,717,723,971,1478,827,740,1471,841,1472,
 1403,1177,905,907,1399,1207,1020,981,1171,1031,969,1119,
 1512,1241,1017,946,1456,1179,885,931,1261,1138,1019,1060,
 1386,1581,1503,1677,1567,1627,1501,1642,1572,1637,1514,1529,
 1464,1617,1598,1746,1557,1631,2825,1919,2726,1920,2823,1914]
  ,[16,17,37,19,40,13,61,105,92,66,104,83,64,74,102,107,
 63,96,65,91,99,62,52,375,429,332,419,236,342,356,324,
 259,272,350,261,212,266,292,404,388,434,406,217,269,308,
 228,299,306,278,325,482,464,467,500,455,537,536,567,526,
 469,518,477,531,522,545,511,479,489,427,540,473,528,474,
 449,505,465,504,512,550,519,510,514,459,548,523,555,535,
 442,502,431,497,463,2628,837,758,1478,2835,826,740,1471,
 2762,891,841,1472],
 [16,17,37,19,40,13,67,82,88,89,59,71,64,102,63,56,75,87,
 90,91,70,98,62,49,52,363,419,327,236,342,324,291,320,
 264,261,329,243,388,406,383,287,217,207,238,303,260,250,
 228,349,290,209,482,467,624,458,531,522,545,479,528,449,
 426,504,512,581,478,462,555,442,497,463,1507,815,644,700,
 668,707,1597,895,665,705,843,853,671,717,971,827,1035,905,
 907,1020,981,969,1119,1136,1017,946,1067,885,931,1019,1060,
 2271,2291,2137,2088,1386,1503,1677,1627,1501,1572,1637,1529,
 1464,1598,1746,1631,3332,3250,1919,1920,1914],
 [16,17,37,19,40,13,67,82,88,89,59,104,102,63,56,75,87,90,
 70,98,49,429,363,419,327,236,342,324,315,229,244,227,264,
 388,406,217,260,214,250,209,482,467,430,493,531,522,561,
 528,449,504,512,571,590,462,559,591,497,463,566,577,644,
 668,800,707,665,671,717,971,1287,899,1426,905,1343,907,
 1020,981,1072,1190,1173,1416,937,969,1119,1366,1008,1443,
 1017,946,1182,1299,910,885,931,1150,1019,1060,1204,1448,
 886,1793,1784,2082,2148,1386,1503,1677,1627,1563,1820,1501,
 1572,2429,1637,1529,1474,1739,1464,1598,1746,1631,1604,1814,
 2540,3015,3235,2549,3732,3057,2519,2598,2965,4038,3047,2527,
 3199,3254,2409,3650,2752,2663,2831,3918,2931,1919,1920,1914,
 4095,5965,2518,2571,2720,3221,3096,2844,2820,3528,3460,3679,
 3651,4844,3037,2874,2730,3453,3402,3733,4577,4905,2561,2520,
 2814,3167,3048,2538,3536,2890,2689,2751,3068,3561,3628,2766,
 2834,3435,3385,3727,3633,4778,2609,5963,5080,3584,5479,3496,
 8794,8758,4846,3540,5506,3697,6351,6452,4366,3392,6024,3531,
 8619,6548,5601,3522,4272,5380,4420,5824,5563,4548,5749,5029,
 3458,4786,5959,4734,5335,5045,4584,5023,5996,9173,6933,5124,
 8860,6983,9148,5536,6490,6201,6252,7089,6717,5455,8119,8295,
 8290,5710,8257,9207,8113,6437,6232,5089,6911,6791,6789,5569,
 7511,6742,6377,8623,7872,6407,6197,7960,6498,6444,6442,6619,
 7712,6960,6268],
 [16,17,37,19,40,13,67,82,105,92,88,89,59,71,104,83,64,74,
 102,63,84,75,87,91,98,62,49,52,429,332,419,236,342,324,
 315,264,310,329,243,388,406,383,217,238,330,349,290,273,
 220,209,482,467,430,531,522,598,545,479,528,449,426,504,
 512,581,638,555,442,516,497,463,644,896,794,1010,668,707,
 665,889,776,979,671,717,971,827,905,907,1003,1392,1020,
 981,969,1119,1017,946,1074,1415,885,931,1019,1060,1386,
 1503,1677,1627,1501,1572,1637,1529,1464,1598,1746,1631,1919,
 1920,1914],
 [16,17,37,27,13,25,58,67,50,61,97,79,85,88,89,66,76,59,
 95,77,53,71,55,104,83,74,107,56,96,65,87,90,86,70,106,
 99,98,62,49,52,186,300,240,247,215,261,302,293,212,206,
 251,201,203,214,231,245,228,321,358,235,192,187,720,754,
 880,809,635,704,741,940,868,628,698,1991,2289],
 [16,17,37,27,19,13,25,58,67,50,61,97,82,79,105,85,92,88,
 89,66,76,59,77,53,71,55,104,83,64,74,102,107,63,84,103,
 56,54,96,75,65,87,90,91,86,70,93,80,99,81,98,62,49,52]
  ,[16,17,37,27,35,19,40,13,25,58,67,50,61,85,88,89,66,
 59,71,104,83,74,84,103,56,54,96,75,65,90,70,99,98,62,
 52,279,186,193,247,264,215,266,251,203,404,294,200,287,
 207,319,311,214,231,245,306,235,187,325,815,700,754,704,
 895,705,871,810,710,812,741,698,2640,2828,1950,2351,2567,
 2652,1976,2308,2375,2332,5867,5616,3686,8438,7467],
 [16,17,37,27,35,19,40,13,25,58,67,50,61,85,88,89,66,59,
 77,71,55,83,74,84,103,56,54,96,75,65,87,99,98,62,49,
 52,279,186,193,247,264,215,270,206,221,251,203,287,207,
 303,214,273,220,235,187,815,700,1084,754,742,746,707,712,
 704,694,710,763,717,723,698,2109,1950,2572,1913,2270,2093,
 3256,2645,2586,3472,4233,3128,4150,7814,4947,8788,8099,8454,
 6346,6383],
 [16,17,37,27,35,19,40,13,25,58,67,50,97,79,85,88,89,59,
 77,71,55,104,107,84,103,56,54,75,87,90,70,98,62,49,52,
 315,186,300,240,291,229,227,247,215,329,243,206,383,287,
 207,238,260,250,231,245,235,209,187,720,887,737,754,803,
 710,874,755,741,829,897,698,2140,2592,3407,1916,2004,2133,
 2879,3393,1923,2383,6013,5374,7553,8644,6583],
 [16,17,37,40,13,58,67,50,61,97,79,85,88,89,66,76,59,95,
 77,55,104,83,74,101,107,56,96,60,75,65,87,86,99,98,49,
 57,186,300,222,240,247,215,261,302,293,270,206,221,288,
 251,203,382,435,308,214,228,314,335,696,720,754,880,974,
 809,746,712,695,762,919,704,1029,900,921,1246,872,961,806,
 875,1151,2603,1991,2093,2705,2418,2363,2084,1989,2075,2086,
 2345,1969,1934,2080,2161,2007,5930,3359,3646,7054,4937,5904,
 3481,7509,7507,5803,6565,7640,7938,6151],
 [16,17,37,40,13,67,82,88,89,59,71,104,102,63,56,75,90,70,
 98,429,424,363,327,291,266,206,388,406,238,565,490,451,
 592,614,624,574,602,533,466,450,612,608,611,528,449,571,
 590,581,563,452,601,621,566,577,1482,1768,644,764,703,707,
 1023,1661,1781,728,671,725,698,932,2628,1490,1407,2436,992,
 1496,2517,1069,1504,2595,1229,857,905,907,995,1219,1335,
 1577,1190,1416,1294,1304,1326,969,1119,1098,1332,1095,1546,
 1355,926,1182,1299,1217,1405,1591,885,931,1061,1269,1214,
 1367,1204,1448,1284,1080,1556,1916,2029,3681,2133,2057,1923,
 2332,3293,1429,2148,1386,1503,2919,2074,2279,1563,1820,3935,
 2619,1501,1572,2932,1515,2038,1905,1474,1739,3926,2366,1464,
 1598,3004,2166,2194,1604,1814,3766,2540,3015,2549,3732,2105,
 3088,2502,2598,4038,2830,2527,3199,2043,2854,2947,2409,2860,
 3650,2663,3918,2266,3710,3028,2769,9373,9411,7422,9180,4299,
 7821,8988,3455,9354,6482,8926,2518,2571,5164,2844,2820,2671,
 3428,7464,2874,2730,5497,2561,2520,3002,3325,7192,2689,2751,
 5146,2766,2834,3018,3574,5722,8585,8536,5269,7070,9232,5483,
 7048,7032,5689,7138,5306,4429,5678,8219,8212,6020,6737,6733,
 8296,3584,8919,3496,4070,7406,3540,8598,3697,4200,7989,3392,
 7547,3531,3967,9339,8156,9046,7920,8173,9251,7730,6336,6499,
 7225,6439,6556,9286,6245,8578,7478,9304,7030,7844,8305,6925,
 7160],
 [16,17,40,30,58,50,61,82,105,89,59,95,71,108,102,63,84,
 96,75,65,87,90,91,70,106,68,289,394,409,419,327,356,193,
 234,259,240,272,291,264,310,293,318,276,404,434,200,253,
 217,238,214,281,330,358,323,209,325,496,536,556,614,624,
 522,549,602,598,473,527,608,625,525,512,544,590,581,523,
 568,621,638,463,480,577,587,796,720,809,778,823,871,710,
 868,795,923,1752,1407,1770,1496,1755,1504,1091,1219,1294,
 1206,1332,1126,1217,1269,1349,1284],
 [16,17,41,35,30,58,67,50,61,97,82,79,94,105,69,85,92,88,
 66,59,95,77,53,71,55,104,64,108,74,101,102,107,63,84,
 103,56,54,78,96,60,75,65,87,91,70,106,93,80,99,81,98,
 49,68,52,57],
 [16,17,41,40,30,13,58,67,50,61,82,79,94,105,59,95,77,71,
 63,84,96,75,65,87,91,70,106,93,289,394,375,336,409,419,
 327,259,240,272,291,310,293,318,276,238,231,281,330,358,
 323,536,556,594,614,624,602,598,473,527,579,590,581,523,
 568,595,621,638,692,764,703,809,778,1023,672,728,725,868,
 795,932,1752,1407,1770,1755,1504,1335,1362,1577,1304,1081,
 1326,1095,1345,1546,1405,1223,1591,1214,1203,1367,1080,1215,
 1556,2799,2919,4713,3935,2795,2932,4619,3926,3056,3004,4246,
 3766,4723,4629,4845],
 [16,17,41,40,30,13,58,67,50,61,82,79,94,105,92,88,59,95,
 77,71,64,102,63,84,54,78,75,65,87,91,93,289,394,375,
 336,419,259,291,264,310,329,221,288,276,404,217,238,281,
 330,349,220,301,209,325,536,556,614,624,522,549,602,598,
 545,485,473,527,608,625,512,544,590,581,523,568,621,638,
 555,516,463,480,577,587,1752,1407,1770,1496,1755,1504],
 [16,17,41,40,30,13,58,67,50,61,97,82,79,94,105,69,85,92,
 88,66,76,59,95,77,71,55,104,64,74,101,102,107,63,84,
 103,56,54,78,96,60,75,65,87,91,86,70,106,93,99,81,98,
 49,52,57],
 [16,17,41,40,30,13,67,50,61,105,77,71,64,63,84,96,91,93,
 394,336,409,342,193,234,291,310,293,318,221,288,404,200,
 253,238,330,358,323,325,482,451,501,496,455,530,614,624,
 416,513,602,598,511,450,506,485,608,625,413,487,525,590,
 581,519,452,517,621,638,396,499,577,587,644,764,668,703,
 707,1029,900,1023,665,728,671,725,717,961,806,932,1407,
 1726,1496,1658,1504,1748,1079,907,1146,1050,1335,1362,981,
 1076,1304,1081,1119,1125,1078,1155,1095,1345,946,1161,1026,
 1405,1223,931,1058,1214,1203,1060,1090,1109,1080,1215,1929,
 2259,1978,2278,1210,2973,1283,1167,1422,1195,2951,1226,1199,
 1413,1176,3001,1259,1233,1428,2324,2488,3467,2312,2853,2277,
 2960,4195,2980,2309,2413,4147,2417,2624,2372,2802,3859,3308,
 2646,3188,2885,3211,2683,3232,2494,3139,2685,3144,2641,3289,
 8329,7852,7524,7864],
 [16,19,30,58,67,50,61,82,100,79,85,92,89,66,77,104,64,
 108,74,56,72,54,78,96,75,65,87,90,91,49,68,52,289,394,
 429,363,409,419,236,234,300,272,247,264,215,261,251,292,
 253,287,269,231,281,245,228,235,278,496,455,441,570,536,
 493,477,509,543,522,485,427,447,561,473,525,465,483,557,
 512,462,459,470,559,523,516,431,468,553,463,837,1404,826,
 1303,891,1237],
 [16,19,30,58,67,50,61,82,100,79,94,85,92,66,77,53,104,64,
 108,74,107,63,56,72,54,78,96,75,65,87,90,91,49,68,52,
 289,394,429,363,409,419,236,300,272,307,247,261,251,201,
 292,287,269,267,231,228,235,192,278,496,455,570,536,493,
 477,543,522,485,427,561,473,525,465,557,512,462,459,559,
 523,516,431,553,463,837,1404,826,1303,891,1237],
 [16,19,30,58,67,50,61,82,100,79,94,85,92,89,66,77,104,64,
 108,74,56,72,54,78,96,75,65,87,90,91,49,289,394,429,
 363,409,419,300,272,247,264,215,261,251,292,437,435,287,
 269,231,281,245,228,235,278,357,335,496,455,441,570,536,
 493,477,509,543,522,485,427,447,561,473,625,525,465,483,
 557,512,462,459,470,559,523,516,431,468,553,463,587,837,
 1404,826,1303,891,1237],
 [16,19,30,61,82,100,79,105,69,85,92,88,76,59,71,55,104,
 64,101,102,84,103,72,54,75,65,87,91,86,70,93,99,81,98,
 57,316,381,389,345,377,368,338,342,279,291,322,310,329,
 255,404,388,294,238,319,330,349,305,325,616,575,606,614,
 597,596,609,602,619,585,618,608,617,582,620,590,610,584,
 600,621,605,593,615,577,1757,913,1796,908,1835,966],
 [16,19,30,61,82,100,79,105,69,85,92,88,76,59,104,64,101,
 102,84,72,54,60,75,65,87,91,86,70,93,99,81,98,316,381,
 389,345,377,368,338,342,291,322,350,331,310,329,404,386,
 388,238,319,308,311,330,349,325,343,616,575,482,606,614,
 597,596,567,609,602,619,585,545,618,608,617,582,528,620,
 590,610,584,550,600,621,605,593,555,615,577,1757,913,1796,
 908,1835,966],
 [16,19,30,61,82,100,79,105,85,92,88,104,64,102,84,72,54,
 75,65,87,91,93,98,316,381,389,345,377,342,291,298,304,
 322,230,310,329,276,203,404,388,294,238,319,246,330,349,
 209,187,325,616,575,570,536,606,614,597,596,567,493,477,
 609,602,619,585,447,561,473,618,608,617,582,620,590,610,
 584,559,523,600,621,605,593,468,615,577,1318,1334,912,
 1192,1340,1122,1344,1757,913,1797,1796,908,1835,966,1035,
 2113,1196,1173,2267,988,1155,1121,2583,1136,2005,1166,2403,
 1046,1109,1036,2458,3658,3758,3133,1574,1435,1563,1462,3156,
 1515,1440,3500,1636,1458,1497,2830,2769,8537,7386,7477,2731,
 2782,2742,2859,2971,8057,8700,6365],
 [16,19,30,61,97,82,100,79,105,69,85,92,88,71,55,104,64,
 102,84,103,72,54,75,65,87,91,86,70,93,99,81,98,316,381,
 389,345,377,368,338,342,291,298,304,322,310,329,255,404,
 388,238,213,254,319,330,349,305,325,616,575,606,614,624,
 597,596,609,602,598,619,585,618,608,625,617,582,620,590,
 581,610,584,600,621,638,605,593,615,577,587,1757,913,1796,
 908,1835,966],
 [16,19,30,61,97,82,100,79,105,85,92,88,104,64,102,84,72,
 54,60,75,65,87,91,93,99,81,98,316,381,389,345,377,338,
 342,222,291,298,304,322,350,331,230,310,329,404,388,223,
 238,213,254,319,246,321,330,349,258,220,325,616,575,606,
 614,597,596,609,602,619,585,618,608,617,582,620,590,610,
 584,600,621,605,593,502,615,577,814,726,1010,893,1042,757,
 947,1054,1757,913,1796,908,1835,966,2113,1399,2267,2583,
 2005,2403,2458,2384,2866,2401,3014,3340,3593],
 [16,22,17,27,31,41,35,19,40,34,30,13,25,58,67,61,97,94,
 105,85,88,77,71,104,64,74,107,84,103,56,54,78,96,87,91,
 70,93,99,49,52,186,193,291,304,212,292,202,200,238,254,
 231,299,278,692,672],
 [16,22,17,31,41,19,40,13,58,67,61,79,105,85,88,66,77,71,
 104,64,74,107,56,54,96,87,91,99,49,52,289,316,375,407,
 336,345,429,355,363,419,283,236,186,304,247,261,212,251,
 292,254,231,228,299,235,278,430,592,624,493,522,545,503,
 485,473,465,571,581,462,523,555,539,516,431,463,754,741,
 1044,1173,986,1209],
 [16,22,17,31,41,19,40,13,58,67,61,79,105,85,88,66,77,71,
 104,64,74,107,56,54,96,87,91,99,49,52,289,316,394,375,
 407,432,360,336,345,429,332,313,355,363,409,377,419,354,
 283,236,186,304,247,261,212,251,292,254,231,228,299,235,
 278,477,465,431,754,741,1478,1471,1472],
 [16,22,17,31,41,19,40,13,58,67,61,82,79,105,69,85,88,66,
 59,77,71,104,64,74,102,107,84,103,56,54,78,96,75,87,91,
 86,70,93,99,98,62,49,52,57,279,234,298,229,230,255,203,
 294,253,213,311,260,246,305,187,804,810],
 [16,22,17,31,41,19,40,13,58,67,61,82,79,105,85,88,66,59,
 77,71,104,64,74,102,107,84,56,54,96,75,87,91,70,93,99,
 98,49,52,289,316,394,375,407,432,360,336,345,429,332,313,
 355,363,409,377,419,327,354,283,236],
 [16,22,17,31,41,19,40,13,58,67,61,82,105,85,88,66,59,71,
 64,74,102,84,56,54,75,91,70,99,52,289,316,394,375,407,
 432,360,336,345,429,332,313,355,363,409,377,419,283,236,
 193,322,320,264,329,266,404,200,281,349,306,325,531,549,
 504,544,497,480,823,759,923,817,1478,1327,1471,1427,1472,
 1341],
 [16,22,17,31,41,19,40,13,58,67,61,82,105,85,88,66,59,71,
 64,74,102,84,56,54,75,91,70,99,52,289,316,394,407,432,
 360,332,355,363,327,354,193,322,320,264,329,266,404,200,
 281,349,306,325,496,567,547,458,531,522,549,545,503,466,
 612,625,525,504,544,523,555,539,456,566,587,823,759,923,
 817,1206,1208,988,1332,1345,1349,1235,1046,1284,1215],
 [16,22,17,31,41,19,40,13,58,67,61,97,82,79,94,105,69,85,
 88,66,76,59,77,71,55,104,83,64,74,101,102,107,84,103,
 56,54,78,96,60,75,87,91,86,70,93,99,81,98,62,49,52,57]
  ,[16,22,17,31,41,19,40,13,58,67,61,97,82,79,94,105,85,
 88,66,76,59,77,71,104,83,64,74,101,102,107,84,56,54,96,
 60,75,87,91,70,93,99,98,49,52,222,331,302,318,216,203,
 382,386,223,311,321,323,258,314,343,1246,1151],
 [16,22,17,31,41,19,40,13,67,82,79,85,59,77,104,64,107,56,
 54,75,70,93,98,49,375,407,336,345,429,313,355,363,327,
 283,236,342,315,291,329,266,276,388,383,238,349,306,209,
 482,495,430,592,624,637,604,453,545,503,533,466,506,561,
 473,528,538,426,448,571,590,581,623,591,555,539,456,463,
 577,727,736,1287,1183,1343,2108,1187,1096,1250,1521,1221,
 1018,1366,1230,1444,2054,1252,1147,1295,1541,886,2287,2632,
 2526,3456,3022,2638,2594,3750,2670,3944,3010,5026,5572,3072,
 2675,8470,8409,7847,5653,7270,7630,6893,6017],
 [16,22,17,37,20,27,31,32,35,19,34,13,15,25,97,79,89,77,
 83,103,90,62,49,237,353,421,389,422,408,364,312,428,392,
 346,337,405,393,338,371,286,264,261,281,228,616,565,515,
 501,469,461,513,531,619,572,524,506,449,488,487,504,494,
 517,442,498,499,497,888,825,833,995,1104,1098,1071,1061,
 1140,2081,2074,1935,2038,2155,2166],
 [16,22,17,37,20,27,31,32,35,19,40,13,15,25,97,89,59,83,
 102,103,99,98,62,252,282,339,376,407,410,365,352,395,344,
 313,399,373,433,317,354,341,186,202,588,515,501,526,461,
 513,518,477,580,524,506,474,488,487,505,465,599,535,498,
 499,502,431,1339,1297,1288,1343,1146,1506,1076,1521,1125,
 1444,1161,1541,1090,2491,1244,2263,1163,2191,1202,3867,3437,
 4119,3218,3934,3098],
 [16,22,17,37,27,31,41,35,19,40,34,30,13,25,58,67,97,85,
 88,77,71,107,84,103,56,54,87,91,70,93,49,52,315,186,
 193,300,320,244,227,247,329,212,383,202,200,287,238,254,
 303,214,250,231,349,299,209,278,896,793,668,1107,889,816,
 671,1075],
 [16,22,17,37,31,41,40,30,58,67,61,79,105,85,88,66,77,71,
 104,64,74,107,84,54,96,91,70,93,49,52,289,375,443,407,
 336,429,313,362,363,419,327,385,249,236,186,304,247,212,
 266,276,292,202,254,231,209,278,430,606,624,526,493,564,
 545,473,426,620,581,462,552,535,463,635,697,628,664,933,
 1156,984,1154],
 [16,22,17,37,31,41,40,30,58,67,61,79,105,85,88,66,77,71,
 104,64,74,107,84,54,96,91,70,93,49,52,289,394,375,443,
 407,370,360,336,429,332,424,313,409,327,385,249,236,186,
 304,247,212,266,276,292,202,254,231,209,278,526,466,473,
 474,535,463,635,697,628,664,1120,758,943,740,906,841,1257,
 1170],
 [16,22,17,37,31,41,40,30,58,67,61,82,79,105,85,88,66,59,
 77,71,104,64,74,102,107,84,56,54,96,75,87,91,70,93,99,
 98,49,52,289,394,375,443,407,370,360,336,429,332,424,313,
 362,363,409,419,327,385,354,249,236],
 [16,22,17,37,31,41,40,30,58,67,61,82,105,85,88,66,59,71,
 104,64,74,102,56,96,91,70,93,99,98,52,289,394,375,443,
 407,370,360,336,429,332,424,419,327,385,354,249,236,193,
 322,264,261,212,266,404,319,281,228,299,306,325,469,522,
 545,449,523,555,442,742,718,1120,758,943,740,906,841],
 [16,22,17,37,31,41,40,30,58,67,61,82,105,85,88,66,59,71,
 104,64,74,102,56,96,91,70,93,99,98,52,289,394,407,370,
 360,429,332,424,362,363,409,327,385,354,193,322,264,261,
 212,266,404,319,281,228,299,306,325,496,530,567,522,466,
 618,625,449,550,523,442,456,615,587,742,718,1158,1316,
 1280,1224,1360,2630,2524],
 [16,22,17,37,31,41,40,30,58,67,61,97,82,79,69,85,88,66,
 76,59,95,77,55,64,108,74,101,102,56,96,75,87,86,70,106,
 93,81,49,68,57,300,350,320,264,261,302,293,255,206,276,
 292,435,281,228,321,358,305,239,209,278,335,880,893,759,
 940,947,817],
 [16,22,17,37,31,41,40,30,58,67,61,97,82,79,105,69,85,88,
 66,76,59,95,77,71,55,104,64,108,74,101,102,107,84,103,
 56,54,96,60,75,87,91,86,70,106,93,99,81,98,49,68,52,57 
  ],[16,22,17,37,31,41,40,30,58,67,61,97,82,79,105,85,
 88,66,76,59,95,77,71,104,64,108,74,101,102,107,84,56,
 54,96,75,87,91,70,93,99,81,98,49,52,222,331,302,255,
 216,288,437,386,223,311,321,258,301,357,343,807,787],
 [16,22,17,37,31,41,40,30,58,67,61,97,82,105,69,85,88,66,
 76,59,95,71,55,104,64,108,74,101,102,54,96,60,91,86,70,
 106,93,68,52,57,193,322,264,261,302,310,212,266,276,203,
 292,404,319,281,228,321,330,209,187,278,325,742,635,697,
 718,628,664],
 [16,22,17,37,31,41,40,30,58,67,61,97,82,105,69,85,88,66,
 76,59,95,71,55,104,64,108,74,101,102,96,60,91,86,70,
 106,93,68,52,57,193,322,264,261,302,310,293,212,266,276,
 203,292,404,319,281,228,321,330,358,209,187,278,325,742,
 635,697,718,628,664],
 [16,22,17,37,31,41,40,30,58,67,61,97,82,105,85,88,66,76,
 59,95,71,104,64,108,74,101,102,54,96,91,70,93,81,52,
 193,222,331,264,261,302,310,255,216,288,276,292,404,437,
 386,311,321,299,306,357,343,796,1112,878,742,974,823,707,
 845,808,807,662,900,1023,1347,1786,918,861,718,932,1308,
 1771,2033,2418,2430,2351,2129,2677,2338,2563,3819,2478,3747,
 3715,4937,3992,4732,5208,8349,5523,5856,8519,7415,8490,8757,
 6410,5652,7515,8240,7211,6432],
 [16,22,17,37,31,41,40,30,58,82,79,105,66,59,77,71,104,74,
 102,107,84,56,96,75,87,91,70,99,98,52,394,375,443,370,
 360,336,332,424,313,409,419,354,249,236,356,315,259,272,
 293,251,434,383,217,269,214,358,235,482,536,583,609,598,
 485,508,528,512,478,600,638,516,486,576,720,710,1114,1326,
 1034,1367],
 [16,22,17,37,31,41,40,30,67,61,79,105,66,77,64,74,107,84,
 54,96,91,93,49,52,394,375,443,370,360,336,332,424,313,
 409,249,236,342,259,272,310,221,388,217,269,330,220,482,
 455,536,637,543,549,609,598,511,485,508,626,528,488,487,
 512,519,600,638,516,486,553,480,696,752,684,694,1327,1658,
 1341,1079,1114,1285,1263,1671,1081,1078,1106,1444,1161,1034,
 1255,1186,1570,1203,999,1460,1480,1586,2106,1226,1199,1411,
 2116,1431,1543,2847,3052,2315,3040,2935,2233,8746,8260,2922,
 2843,4930,3907,3066,4384,2494,2727,2626,2976,3494,5552,4007,
 5715,4942,5766,5786,5581,5448,7588,5880,7204,5896,6029,9426,
 6329,7161,8233,6275,6230,7829,7012,6155],
 [16,22,17,37,41,19,30,13,58,61,82,79,105,85,66,59,77,71,
 104,102,107,84,96,75,91,70,99,98,49,52,289,394,492,375,
 389,407,360,336,429,520,392,313,409,327,338,354,236,356,
 272,244,227,310,293,251,434,214,250,330,358,235,513,493,
 598,487,462,638,499,778,795,1726,2451,1658,2438,1748,2406],
 [16,22,17,37,41,19,30,13,58,61,82,79,105,85,66,59,77,71,
 104,102,107,84,96,75,91,70,99,98,49,52,394,492,375,360,
 336,332,392,313,409,419,484,338,354,236,356,272,244,227,
 310,293,251,434,214,250,330,358,235,482,441,536,458,416,
 598,485,528,487,478,452,638,499,516,778,795,1263,850,1304,
 856,1214,3150,3401],
 [16,22,17,37,41,19,30,13,58,67,61,82,79,69,85,92,88,66,
 59,77,53,55,104,102,107,103,56,54,96,87,93,99,98,57,
 279,298,350,244,227,230,255,212,243,206,216,221,201,203,
 294,287,213,192,187,325,335,815,722,922,930,893,803,727,
 674,845,807,635,901,704,662,1029,895,715,628,698,645,961,
 2071,2132,2651,2394,2627,2464,2129,2338,3618,2391,2239,2523,
 3692,4737,5691,5031,8410,7305,4780,4993,5285,6603,7448],
 [16,22,17,37,41,19,30,13,58,67,61,82,79,105,69,85,92,88,
 66,59,77,53,71,55,104,64,74,102,107,84,103,56,54,96,75,
 87,91,70,93,99,98,49,52,57,279,298,230,255,243,216,201,
 203,294,213,246,305,290,192,187,662,645],
 [16,22,17,37,41,19,30,13,58,67,61,82,79,105,85,88,66,59,
 77,71,104,64,74,102,107,84,56,54,96,75,87,91,70,93,99,
 98,49,52,289,394,492,375,389,407,360,336,429,520,332,392,
 313,363,409,419,484,327,338,354,236],
 [16,22,17,37,41,19,30,13,58,67,61,97,82,79,105,69,85,92,
 88,66,76,59,77,53,71,55,104,64,74,101,102,107,84,103,
 56,54,96,60,75,65,87,91,86,70,93,80,99,81,98,49,52,57]
  ,[16,22,17,37,41,19,30,13,58,67,61,97,82,79,105,85,88,
 66,76,59,77,71,104,64,74,102,107,84,56,54,96,60,75,65,
 87,91,70,93,80,99,81,98,49,52,222,240,359,331,302,216,
 386,223,207,295,311,246,321,258,343,761,747],
 [16,22,17,37,41,19,30,13,58,67,61,97,105,85,88,66,76,59,
 53,71,55,64,74,102,84,103,56,54,60,75,65,91,86,70,93,
 80,99,81,98,57,186,193,222,240,264,329,266,202,200,223,
 207,319,303,246,281,349,306,325,335,796,752,761,871,694,
 747,980,869,2485,1974,2416,1957],
 [16,22,17,37,41,19,30,13,58,67,61,105,69,85,92,88,66,59,
 53,71,55,64,74,102,84,103,56,54,75,91,70,93,99,98,57,
 279,322,320,230,329,255,243,266,216,294,202,200,213,246,
 305,290,192,187,325,335,1160,788,716,737,922,930,823,759,
 707,1238,963,636,728,980,869,923,817,829,664,645,2288,
 2592,2258,1889,2428,1940,2365,2284,2435,2198,2332,5857,4299,
 5104,5435,3231,5782,6728,7810,3546,5830,6141],
 [16,22,17,37,41,19,30,13,58,67,61,105,85,88,77,71,64,74,
 107,84,56,54,96,87,91,70,93,99,49,52,289,375,389,407,
 336,429,520,392,313,363,419,484,327,236,186,193,291,304,
 212,292,202,200,238,254,231,299,278,430,451,624,545,447,
 473,527,426,413,581,462,568,555,468,463,692,672,1146,1073,
 1161,1067],
 [16,22,17,37,41,19,30,13,58,67,82,79,105,85,88,77,71,104,
 102,107,84,56,54,75,87,93,98,49,52,289,375,389,407,336,
 429,520,392,313,363,419,484,236,315,291,304,244,227,276,
 383,238,254,214,250,209,430,451,624,453,493,477,447,473,
 426,413,448,465,581,462,468,463,1272,1053,1478,1471,1205,
 1190,1018,1121,1182,1070,886,1036,1563,1606,1474,1712,3932,
 3408,2782,2971],
 [16,22,17,37,41,19,30,13,58,67,82,79,105,85,88,77,71,104,
 102,107,84,56,54,75,87,93,98,49,52,289,394,492,375,389,
 407,336,332,392,313,363,409,327,338,354,236,315,291,304,
 244,227,276,383,238,254,214,250,209,624,458,416,453,477,
 448,465,581,478,452,454,431,1272,1053,1726,2451,1658,2438,
 1748,2406,1190,1182,1204],
 [16,22,17,37,41,19,30,13,67,61,105,88,77,71,64,74,107,84,
 96,87,93,99,49,52,394,492,336,332,392,313,409,419,484,
 338,354,236,342,320,310,293,206,221,388,303,330,358,239,
 220,482,397,455,458,416,598,511,479,485,626,528,488,519,
 510,478,452,417,459,638,498,516,480,703,725,837,827,998,
 891,1079,857,1446,1207,850,1304,1081,1077,1078,1106,926,
 1319,1406,1179,856,1214,1203,999,1429,1749,2317,1750,1527,
 2026,1515,1810,1509,2244,1977,1673,3313,2853,3350,2624,3352,
 2815,4165,2737,3852,3137,2605,3378,5721,2621,4830,4554],
 [16,22,17,41,19,13,58,67,61,82,105,69,85,92,88,59,71,64,
 74,102,84,103,56,54,78,75,91,93,99,98,62,52,57,279,234,
 298,322,320,229,230,255,243,294,200,253,238,213,295,311,
 260,246,220,192,187,325,788,896,784,804,764,1010,716,737,
 922,823,759,963,889,765,810,728,1053,861,702,979,980,829,
 787,897,664,645,2362,2479,2065,2592,2294,3407,2258,1889,
 2428,1940,2442,2657,2063,2375,2170,3393,2868,2364,2332,4027,
 9278,5711,4299,5104,5435,3231,3686,7224,6036,7557,4074,6827,
 8638,5830,6585,7674,6500,7592,7227,8182,7807,7066,7923,6503,
 6216,7063,6387,6479],
 [16,22,17,41,19,13,58,67,61,97,82,94,105,69,85,92,88,59,
 53,71,55,83,64,74,101,102,84,103,56,54,78,75,91,86,93,
 80,99,81,98,62,52,57,193,291,298,322,320,329,255,243,
 266,221,404,200,238,213,281,349,305,290,306,220,325,764,
 823,759,728,923,817],
 [16,22,17,41,19,13,58,67,61,97,82,94,105,69,85,92,88,59,
 53,71,55,83,74,101,102,84,103,56,54,78,75,91,86,80,99,
 81,62,52,57,193,291,298,322,320,244,329,255,243,266,221,
 251,292,404,200,238,213,281,349,305,290,306,220,235,278,
 325,764,823,759,803,728,923,817,820],
 [16,22,17,41,19,13,58,67,61,97,82,94,105,69,85,92,88,76,
 59,53,71,55,64,74,102,84,103,56,54,78,60,75,65,91,86,
 93,99,98,62,52,57,193,291,322,320,229,230,264,329,266,
 200,238,319,303,260,246,281,220,192,187,325,1010,716,737,
 922,979,745,755,980,829,664,2592,2258,2879,2057],
 [16,22,20,27,31,32,35,19,40,34,13,15,25,67,61,97,77,83,
 64,107,84,103,54,90,62,49,237,353,372,316,364,312,347,
 345,428,346,337,361,405,423,377,393,371,286,193,251,200,
 235,515,501,500,524,506,489,488,487,494,517,514,498,499,
 1737,954,976,1650,842,813,1732,1047,835,2374,1180,2311,
 1141,2392,1132],
 [16,22,20,27,32,35,19,40,34,13,25,58,97,59,83,102,56,90,
 252,282,372,339,316,492,541,365,352,347,345,520,344,399,
 476,373,433,423,387,377,484,317,341,472,307,302,221,382,
 267,321,314,464,515,501,570,556,543,549,511,524,506,561,
 527,557,544,519,494,517,559,568,553,480,1029,961,1433,
 1613,970,973,1833,916,982,1645,909,1285,1263,1423,1457,
 1731,1530,1255,1186,1420,1396,1690,1393],
 [16,22,24,17,37,20,27,31,41,32,35,19,40,34,30,13,15,25,
 237,252,282,353,339,326,369,421,376,422,408,410,364,365,
 352,312,395,333,367,428,344,346,337,399,361,373,433,405,
 387,374,380,393,317,371,286,341],
 [16,22,24,17,37,27,31,19,34,30,13,25,58,67,61,79,105,85,
 88,89,66,76,77,53,71,104,64,84,56,54,87,90,91,86,70,
 93,80,99,49,52,186,304,227,247,264,329,212,202,250,231,
 281,349,299,278,1107,1192,1075,1344],
 [16,22,24,17,37,27,31,19,40,34,30,13,25,58,67,79,105,85,
 88,89,76,77,71,104,64,56,54,87,90,91,86,49,52,315,186,
 291,304,227,247,264,261,329,212,221,251,276,292,238,254,
 250,231,281,228,220,235,209,278,800,754,864,635,903,741,
 829,628],
 [16,22,24,17,37,27,31,40,34,30,13,25,58,61,82,79,105,85,
 89,66,76,59,95,77,71,104,102,84,96,75,87,90,91,86,70,
 106,99,98,49,52,356,272,244,227,264,310,293,251,434,214,
 250,281,330,358,235,778,795],
 [16,22,24,17,37,27,31,41,32,35,19,40,18,34,30,13,15,25,
 237,252,282,353,339,384,326,369,421,376,408,410,364,365,
 352,312,395,425,333,367,428,344,337,399,361,373,433,405,
 387,444,374,380,393,317,286,341],
 [16,22,24,17,37,27,31,41,34,30,13,25,58,67,61,82,105,85,
 88,66,76,59,95,53,71,104,64,74,102,56,96,91,86,70,106,
 93,80,99,98,52,193,322,264,261,293,212,266,404,319,281,
 228,358,299,306,325,742,718],
 [16,22,24,17,37,27,31,41,35,19,34,25,58,67,82,79,105,85,
 88,59,77,53,71,104,83,64,108,102,107,84,56,54,87,91,70,
 62,49,68,52,315,291,227,329,212,251,201,276,292,383,238,
 250,235,192,209,278,864,635,829,628],
 [16,22,24,17,37,27,31,41,35,19,40,30,58,67,61,79,105,85,
 88,66,77,71,55,104,64,108,74,101,107,84,56,54,96,91,70,
 93,68,52,57,186,304,247,212,266,276,203,292,404,202,254,
 231,209,187,278,325,635,697,628,664],
 [16,22,24,17,37,27,31,41,35,19,40,34,30,13,25,58,67,61,
 79,105,85,88,66,77,71,104,64,74,107,56,54,96,87,91,70,
 99,49,52,186,304,247,261,212,251,292,254,231,228,299,235,
 278,754,741],
 [16,22,24,17,37,27,31,41,35,19,40,34,30,13,25,58,67,61,
 82,79,105,85,88,66,59,77,71,104,64,74,102,107,84,56,54,
 96,75,87,91,70,93,99,98,49,52],
 [16,22,24,17,37,27,31,41,35,19,40,34,30,13,25,58,67,61,
 82,105,85,88,66,59,71,64,74,102,84,56,54,75,91,70,93,
 99,98,52,193,322,320,264,329,266,404,200,281,349,306,325,
 823,759,923,817],
 [16,22,24,17,37,27,31,41,35,19,40,34,30,13,25,67,82,79,
 105,85,88,59,77,71,104,64,102,107,84,56,54,75,91,70,93,
 98,49,52,342,315,291,227,329,266,276,388,383,238,349,306,
 209,727,736],
 [16,22,24,17,37,27,31,41,35,19,40,34,30,13,25,67,82,79,
 105,88,66,59,71,64,74,102,107,84,54,96,75,87,91,93,99,
 98,49,52,342,315,259,322,320,221,388,383,217,319,303,330,
 220,1062,1040],
 [16,22,24,17,37,27,31,41,35,30,13,25,67,61,82,79,105,88,
 66,59,95,77,53,71,55,64,74,102,107,84,96,87,106,93,80,
 99,81,98,49,52,342,259,320,310,293,212,206,221,388,303,
 330,358,299,239,220,703,725],
 [16,22,24,17,37,27,31,42,41,32,35,19,38,40,18,34,30,21,
 13,15,25,58,67,61,79,105,85,104,102,107,84,56,54,96,75,
 70,98,186,304,202,254],
 [16,22,24,17,37,31,19,40,34,30,13,25,58,67,61,82,105,69,
 85,88,89,66,76,59,104,64,74,56,54,96,60,75,90,91,86,
 70,93,99,98,52,193,322,350,247,264,261,404,319,308,231,
 281,228,306,325,878,742,861,718],
 [16,22,24,17,39,37,20,27,31,42,41,32,35,19,40,34,30,21,
 13,15,25,58,67,61,85,59,77,71,104,102,107,84,56,70,93,
 99,98,186,212,202,299],
 [16,22,24,17,41,35,19,40,34,30,13,25,58,67,82,79,94,105,
 69,85,92,88,77,104,102,107,84,56,54,78,60,75,65,87,91,
 70,93,98,49,52,315,291,304,350,244,227,276,383,238,254,
 308,214,250,349,209,1272,1053],
 [16,22,24,17,41,35,19,40,34,30,13,25,58,67,82,79,94,105,
 69,85,92,88,77,104,102,107,84,56,54,78,60,75,65,87,91,
 70,93,98,49,52,315,291,304,350,244,227,329,383,238,254,
 308,214,250,349,209,668,671],
 [16,22,24,33,17,37,20,27,31,41,35,28,19,40,18,34,23,30,
 13,15,25,58,67,61,85,88,66,77,64,54,75,87,91,93,49,
 193,247,264,261,231,281,228,742,718],
 [16,22,24,33,17,37,20,27,36,31,41,32,35,19,40,34,23,30,
 13,15,25,58,67,61,88,59,77,71,64,102,107,84,54,70,93,
 99,49,193,266,200,306],
 [16,22,24,33,17,39,37,27,31,41,35,28,19,38,40,34,23,30,
 21,13,25,237,252,282,384,326,369,481,422,541,364,365,352,
 425,333,367,521,346,476,361,373,433,444,374,380,491,371,
 472],
 [16,22,24,33,17,39,37,27,36,31,42,41,35,28,19,38,40,34,
 30,13,25,237,252,282,384,481,422,408,410,541,364,365,352,
 425,521,346,337,399,476,361,373,433,444,491,371,286,341,
 472],
 [16,22,24,37,27,31,41,32,19,40,18,34,15,82,100,76,59,108,
 72,75,68,252,339,384,369,432,410,360,365,395,425,367,355,
 399,363,373,387,283,236,247,261,588,565,515,537,556,493,
 477,531,549,580,572,524,540,527,525,465,504,544,599,573,
 494,516,497,480,1068,1174,3726,996,1013,3642,1484,1323,
 3645,1055,1064,1072,933,951,1026,1240,1130,999,1057,917,
 1685,1477,1865,1693,1489,1878,1691,1370,1879,2906,2897,2733]
  ,[16,22,24,37,27,41,32,19,40,18,34,30,25,58,61,100,76,
 108,102,84,56,72,75,86,70,68,252,339,384,492,369,410,
 541,365,425,520,367,399,476,373,387,444,484,380,341,472,
 186,259,202,217,455,537,556,531,549,427,540,527,504,544,
 459,548,568,497,480,970,916,909],
 [16,22,29,24,17,20,27,41,32,35,40,18,30,13,15,25,58,82,
 85,59,95,102,75,70,106,81,98,252,339,316,492,369,376,
 365,520,367,344,373,484,380,317,341,310,330,536,556,583,
 473,527,523,568,595,442,539,1613,970,1371,916,1331,909,
 1314,1874,1941,1901,2204,1900,2016,2173,2446,2369,2306,5807,
 5784,5271],
 [16,22,29,24,17,20,27,41,32,35,40,18,30,13,15,25,67,79,
 94,92,88,77,107,65,87,93,49,237,353,326,421,443,364,333,
 428,424,361,374,393,385,354,286,244,214,536,556,526,469,
 547,449,538,519,442,539,1847,1232,1852,1301,1924,1395,779,
 1560,1573,1676,1545,1717,1535,1647,2048,2064,2249,3082,2989,
 3731],
 [16,22,29,24,17,20,31,41,32,35,19,18,34,30,13,15,67,79,
 69,88,77,64,101,107,54,60,87,93,49,57,237,353,316,326,
 421,312,345,333,428,392,337,405,377,374,393,637,447,527,
 599,468,480,1293,976,1276,813,825,1353,835,2408,2141,2190,
 2260,2248],
 [16,22,29,24,17,20,31,41,32,35,19,18,34,30,13,15,79,107,
 49,57,237,353,316,326,421,312,345,333,428,392,337,405,
 377,374,393,616,430,501,537,594,624,469,466,506,540,579,
 625,449,426,487,504,478,517,548,595,638,442,468,480,1293,
 976,1276,813,825,1353,835,1170,1393,1284,2223,1210,1180,
 1703,1838,3637,2026,1195,1141,1688,1779,3300,2227,1935,1977,
 1176,1132,1684,1775,3123,2141,2190,2260,2248,4974,3518,4196,
 5568,6055,3431,3844,5924,8302,4831,3307,3494,3958,5500,9378,
 3784,3861,5564,3444,3865,7208,3677,3996,7387,6215,8825,8196,
 9280,6652,7420,6688,6662,7576,7941,8430,6085,6607],
 [16,22,29,24,17,37,20,27,31,41,35,19,40,18,34,30,13,25,
 237,252,353,339,326,369,481,421,376,408,410,541,364,365,
 312,395,333,367,521,428,344,337,399,476,361,373,405,387,
 374,380,491,393,317,286,341,472],
 [16,22,29,24,17,37,27,31,41,32,35,19,40,34,30,13,15,25,
 237,252,353,339,384,326,369,421,376,422,408,410,364,365,
 312,395,425,333,367,428,344,346,337,399,361,373,405,387,
 444,374,380,393,317,371,286,341],
 [16,22,29,24,17,39,27,31,42,41,32,35,19,38,40,18,34,30,
 21,13,15,25,237,252,353,316,384,326,421,364,365,312,345,
 425,333,428,337,361,373,405,377,444,374,393,286,976,813,
 835],
 [16,22,29,24,17,39,37,27,31,42,41,32,35,19,38,40,18,34,
 30,21,13,15,25,58,67,82,105,85,104,102,107,56,96,75,70,
 98,304,254],
 [16,22,29,24,17,39,37,27,31,42,41,32,35,19,38,40,18,34,
 30,21,13,15,25,237,252,353,384,326,421,408,364,365,312,
 425,333,428,337,361,373,405,444,374,393,286],
 [16,22,29,24,17,39,37,31,42,41,32,35,19,38,40,18,34,30,
 21,13,15,25,58,67,82,105,69,85,104,102,107,56,96,60,75,
 70,98,304,254],
 [16,22,29,24,17,39,37,31,42,41,32,35,19,38,40,18,34,30,
 21,13,15,25,237,252,353,384,394,326,421,408,312,425,429,
 333,428,337,361,373,405,444,419,374,393,286,844,904,738,
 929,756,1118],
 [16,22,29,24,33,17,37,20,27,36,31,41,32,35,28,19,34,23,
 30,13,15,25,58,67,79,88,77,53,71,64,102,107,54,93,80,
 99,49,266,306],
 [16,22,29,24,33,17,37,20,27,36,31,41,32,35,28,19,34,23,
 30,13,15,25,237,252,339,369,376,389,422,410,364,365,395,
 367,344,392,346,399,387,380,317,338,371,341,888,927,825,
 832,833,821],
 [16,22,29,24,33,17,37,20,27,36,31,41,32,35,28,19,40,23,
 30,13,15,25,237,252,339,369,376,422,407,410,364,365,395,
 367,344,346,313,399,361,373,380,317,371,354,341,1339,1297,
 1288],
 [16,22,29,24,33,17,37,20,27,36,31,41,32,35,28,19,40,34,
 23,30,13,15,25,58,67,79,88,77,71,64,102,107,54,93,99,
 49,266,306],
 [16,22,29,24,33,17,37,20,27,36,31,41,32,35,28,19,40,34,
 23,30,13,15,25,237,252,339,369,376,422,410,364,365,395,
 367,344,346,399,361,373,387,380,317,371,341],
 [16,22,29,24,33,17,37,20,27,36,31,41,32,35,28,40,34,23,
 30,13,15,25,237,252,339,369,443,376,422,410,364,365,395,
 367,424,344,346,361,373,387,380,385,317,371,341,1302,1438,
 1439],
 [16,22,29,33,37,20,27,36,31,41,32,35,28,19,40,34,23,30,
 13,15,25,237,252,289,372,339,410,364,365,336,347,395,367,
 344,346,399,361,373,409,423,387,380,317,371,341,1621,1433,
 954,1569,973,842,1807,982,1047],
 [16,22,29,33,37,20,36,31,32,28,19,40,23,30,13,15,58,67,
 79,77,71,64,102,107,54,93,99,49,381,375,407,336,347,429,
 313,363,368,327,236,266,306,482,551,430,624,545,560,466,
 506,473,528,562,426,581,555,569,456,463,1183,1096,1171,
 1250,1230,1147,1261,1295,1184,2287,2806,3944,2537,3010,3067,
 3072,2489,2675],
 [16,22,29,33,37,20,36,31,32,28,19,40,23,30,13,15,69,89,
 76,55,101,60,90,86,81,57,237,252,339,410,395,399,361,
 373,380,317,371,302,309,321,348,482,551,637,597,513,531,
 543,479,579,599,610,550,546,517,548,559,442,576,1205,1534,
 1457,1294,1671,1070,1649,1396,1269,1570,1495,1885,1981,1594,
 1858,1944,2921,3080,5028,2927,3219,5561],
 [16,22,29,39,37,27,31,42,41,32,35,19,38,40,18,34,30,21,
 13,15,25,237,252,289,353,372,408,364,365,336,312,347,425,
 333,428,337,361,373,409,405,423,444,374,393,286,2560,1475,
 1737,2525,1468,1650,2439,1463,1732],
 [16,22,29,39,37,31,42,32,19,38,40,18,30,21,13,15,97,100,
 69,101,103,72,60,90,86,81,57,237,252,353,408,312,337,
 361,373,444,374,393,307,298,267,213,490,515,455,637,597,
 527,507,488,465,599,610,563,494,459,523,535,480,907,1305,
 1285,1044,946,1182,1255,986,931,1589,2961,2854,2903,2789,
 3338,5386,4964],
 [16,22,31,40,58,67,61,97,82,100,79,94,69,85,66,77,55,104,
 83,64,108,74,101,107,103,56,72,78,96,75,87,90,86,70,
 106,99,62,49,68,57,300,272,307,298,304,351,350,206,251,
 203,292,435,287,269,267,213,254,328,231,228,358,305,235,
 187,278,335,692,722,1449,1334,704,672,715,1421,1198,947,
 698,2984,2915],
 [16,22,33,27,31,28,19,40,34,25,97,100,105,85,89,66,76,83,
 108,103,72,96,75,90,91,86,62,68,237,252,339,316,408,364,
 365,395,345,337,399,361,373,387,377,286,341,227,261,435,
 250,228,335,565,501,537,570,513,531,543,572,506,540,561,
 487,504,557,573,517,548,559,499,497,553,1613,1833,1645],
 [16,22,33,37,31,28,19,40,34,23,25,97,100,89,76,83,108,
 103,72,90,91,86,62,68,52,237,252,339,394,410,395,429,
 399,361,373,387,419,341,300,259,261,287,217,228,565,501,
 397,537,570,513,531,543,506,412,540,561,487,504,557,573,
 517,417,548,559,499,497,553,844,904,738,929,756,1118,1228,
 1305,1285,1131,1190,1423,1221,1377,1731,1127,1182,1255,1243,
 1274,1420,1128,1204,1690,1733,1825,1841],
 [16,22,37,31,19,40,30,13,58,67,61,79,88,66,77,71,104,64,
 74,84,56,54,87,91,70,93,99,49,52,289,372,394,381,375,
 360,336,347,429,366,332,363,419,368,327,354,236,186,247,
 264,329,212,292,202,231,281,349,299,278,490,515,522,545,
 560,533,524,523,555,569,1192,1344,777,975,1177,1187,1077,
 1031,1252,1085,1527,1535,3020,2970],
 [16,22,37,31,19,40,30,13,58,67,61,79,88,66,77,71,104,64,
 74,84,56,54,87,91,70,93,99,49,52,289,372,407,336,347,
 429,313,363,419,368,327,236,186,247,264,329,212,292,202,
 231,281,349,299,278,490,430,515,518,493,545,560,533,524,
 473,426,514,462,555,569,463,1192,1344,1330,971,1012,827,
 1177,2267,1187,1077,1031,2403,1252,1085,2082,1481,1554,2576,
 1702,1636,3020,2970,4061,3764],
 [16,22,37,31,19,40,30,13,58,67,61,82,69,88,66,59,55,104,
 64,84,56,54,96,75,90,91,86,70,93,99,98,52,57,279,208,
 307,298,322,350,255,266,203,267,213,250,246,231,281,321,
 348,305,187,325,788,815,644,876,692,764,814,950,823,893,
 697,853,672,728,757,892,980,1101,669,718,940,725,923,947,
 664,1995,2355,2030,2421,2952,2459,2327,1993,2462,3044,2347,
 2348,2714,1895,2457,4725,5738,3930,3362,6079,5954,4206,3305,
 5508,5651,5414,5073,8391,5853,8967,7863,7877,7255],
 [16,22,37,31,19,40,30,13,58,67,61,82,79,69,66,59,55,104,
 64,74,56,54,96,75,87,90,86,70,93,99,98,49,57,279,208,
 307,298,322,350,255,206,203,267,213,246,231,281,228,321,
 348,305,187,335,815,644,870,692,764,722,814,950,823,893,
 704,672,728,715,757,892,869,1101,669,940,725,795,923,947,
 698,1995,2355,2030,2952,2459,2990,2327,1993,3044,2347,2975,
 2714,1895,2018,2457,4848,3930,3362,5654,6079,4206,3305,5937,
 5508,5651,5159,5073,8374,5853,4953,6768,7870,6646],
 [16,22,37,31,19,40,30,13,58,67,61,82,79,105,69,85,88,66,
 59,77,71,55,104,64,74,102,107,84,56,54,96,75,87,90,91,
 86,70,93,99,98,49,52,57,279,208,307,298,230,255,203,294,
 277,267,213,246,321,348,305,187,814,950,757,892],
 [16,22,37,31,19,40,30,13,58,67,61,82,79,105,85,88,66,59,
 77,71,104,64,74,102,107,84,56,54,96,75,87,91,70,93,99,
 98,49,52,289,372,394,381,375,407,360,336,347,429,366,332,
 313,363,409,423,419,368,327,354,236],
 [16,22,37,31,19,40,30,13,58,67,61,82,105,85,66,59,104,64,
 74,84,56,54,96,75,91,70,93,99,98,52,289,372,394,381,
 375,360,429,313,363,409,423,419,368,327,354,236,193,322,
 350,247,264,404,200,319,308,231,281,306,325,501,567,558,
 518,493,550,546,517,514,462,878,861,777,991,1253,1213,
 1573,1509],
 [16,22,37,31,19,40,30,13,58,67,61,82,105,85,66,59,104,64,
 74,84,56,54,96,75,91,70,93,99,98,52,289,372,394,407,
 360,429,366,332,363,409,423,368,327,354,193,322,350,247,
 264,404,200,319,308,231,281,306,325,501,500,496,567,558,
 522,625,505,525,550,546,517,523,456,587,878,861,1196,1253,
 1166,1213],
 [16,22,37,31,19,40,30,13,58,67,61,97,82,100,79,105,69,85,
 88,89,66,76,59,77,71,55,104,64,74,101,102,107,84,103,
 56,72,54,96,60,75,87,90,91,86,70,93,99,81,98,49,52,57]
  ,[16,22,37,31,19,40,30,13,58,67,61,97,82,100,79,105,85,
 88,66,59,77,71,104,64,74,101,102,107,84,56,54,96,60,75,
 87,91,70,93,99,81,98,49,52,222,307,298,331,302,309,270,
 216,386,223,311,321,348,273,258,343,859,912,883,1122],
 [16,22,37,31,19,40,30,13,58,67,61,97,82,100,88,66,59,104,
 64,101,84,56,54,96,60,75,91,70,93,99,81,98,52,193,300,
 222,259,307,298,302,309,404,223,319,308,311,321,348,306,
 273,258,343,796,696,804,876,692,764,742,880,703,859,912,
 871,684,861,776,702,718,940,725,883,1122,736,763,717,1771,
 2479,2917,2065,2293,3075,2444,3544,3335,2914,2063,3160,2420,
 2375,2747,3058,3568,3376,1918,3850,4988,4027,9166,4722,3482,
 4148,5188,3686,4416,4302,4216,4984,4539,6993,4360,6301,7185,
 7905,8027],
 [16,22,37,31,19,40,30,13,58,67,61,97,82,100,88,89,66,76,
 59,104,64,84,103,56,72,54,96,60,75,90,91,86,70,93,99,
 81,98,52,57,193,300,222,259,227,230,247,264,200,287,223,
 217,319,308,311,250,246,231,281,306,325,796,696,804,922,
 871,684,810,861,980,2479,2657],
 [16,22,37,31,19,40,30,13,58,67,61,97,82,100,89,66,76,59,
 104,64,84,103,56,72,54,96,60,75,90,91,86,70,93,99,81,
 98,52,57,193,300,222,259,272,227,230,247,264,200,287,223,
 217,269,319,308,311,250,246,231,281,306,325,796,696,804,
 922,871,684,810,861,980,2479,2657],
 [16,22,37,31,19,40,30,13,58,67,82,79,88,59,104,64,102,
 107,56,54,87,70,98,49,289,372,381,375,429,313,363,419,
 368,327,236,315,291,227,251,276,383,238,250,235,209,490,
 430,515,624,604,518,493,540,561,473,426,448,590,581,514,
 462,548,559,591,463,577,864,635,829,628,777,1303,1350,
 1237,1372,905,1343,2108,1072,1156,1454,1377,1731,1018,1017,
 1444,2054,1150,1274,1420,1154,1348,886,1386,2532,1384,1721,
 1790,1734,1510,1637,2341,1659,1778,1644,1575,2540,2324,3652,
 3320,2527,2309,3470,3176,2025,2059,2518,4449,2720,3785,2837,
 4507,3032,2561,4714,2814,4168,4306,3566,2893,2620,3051,4607,
 2907,3104,4545,3522,8961,4826,3458,6489,4480,5476,4620,6778,
 6035,4909,6746,6858,6445],
 [16,22,37,31,19,40,30,13,58,67,82,79,105,85,88,59,77,71,
 104,64,102,107,56,54,87,91,70,98,49,52,289,372,381,375,
 407,336,347,429,313,363,419,368,327,236,315,291,227,329,
 212,251,276,383,238,349,299,235,209,430,624,604,518,493,
 545,560,473,426,581,591,555,569,463,727,736,1072,1171,
 1250,1261,1295,3022,2670],
 [16,22,37,31,19,40,30,13,58,67,82,79,105,85,88,59,77,71,
 104,64,102,107,56,54,87,91,70,98,49,52,289,372,394,381,
 375,407,360,336,347,429,366,332,363,419,354,236,315,291,
 227,329,212,251,276,383,238,349,299,235,209,604,545,560,
 489,485,611,555,569,502,516,727,736,1847,1852,1108,1057,
 1516,1582],
 [16,24,17,27,31,19,34,25,58,67,50,61,79,94,105,85,88,89,
 66,76,77,53,71,104,83,64,108,74,56,54,78,87,90,91,86,
 70,62,49,68,52,186,304,247,264,215,261,329,212,251,201,
 276,292,254,231,281,245,228,235,192,209,278,754,864,635,
 741,829,628],
 [16,24,17,27,31,19,34,25,58,67,50,61,79,94,105,85,88,89,
 66,76,77,53,71,104,83,64,108,74,56,54,87,90,91,86,62,
 49,68,52,186,304,247,264,215,261,318,329,212,221,251,201,
 276,292,231,281,245,228,220,235,192,209,278,754,1192,873,
 864,635,741,798,829,628,2608,2431],
 [16,24,17,27,31,19,34,25,58,67,50,61,79,94,105,85,88,89,
 66,76,77,53,71,104,83,64,108,74,56,54,87,90,91,86,70,
 62,49,68,52,186,304,247,264,215,261,318,329,212,251,201,
 276,292,231,281,245,228,235,192,209,278,754,1192,873,864,
 635,741,798,829,628,2608,2431],
 [16,24,17,27,31,19,34,25,58,67,50,61,82,79,94,105,85,88,
 89,66,76,59,77,53,71,104,83,64,108,74,102,107,63,84,56,
 54,78,96,75,87,90,91,86,70,93,80,99,98,62,49,68,52],
 [16,24,17,27,31,19,34,25,58,67,50,61,82,79,105,85,88,89,
 66,76,59,77,71,104,83,64,108,74,102,107,84,56,54,78,96,
 75,87,91,70,93,99,98,49,52,234,359,215,270,216,201,382,
 437,253,295,245,273,258,314,357,957,792],
 [16,24,17,27,31,19,34,25,58,67,50,82,79,94,105,85,88,89,
 76,59,77,53,71,104,83,64,108,56,54,78,87,90,91,86,98,
 62,49,68,52,315,291,227,247,264,215,261,329,212,221,251,
 201,276,238,250,231,281,245,228,220,235,192,209,800,864,
 635,903,829,628],
 [16,24,17,27,31,19,34,25,58,67,50,82,79,94,105,85,88,89,
 76,59,77,53,71,104,83,64,108,84,56,54,78,87,90,91,86,
 98,62,49,68,52,315,291,227,247,264,215,329,212,221,251,
 201,276,238,250,231,281,245,220,235,192,209,800,864,635,
 903,829,628],
 [16,24,17,27,31,19,34,25,58,67,50,82,79,94,105,85,88,89,
 76,59,77,53,71,104,83,64,108,84,56,54,78,87,91,98,62,
 49,68,52,315,291,227,247,264,215,329,212,270,216,221,251,
 201,276,238,220,235,192,209,800,727,746,707,712,864,635,
 919,662,829,628,872,645,1793,2627,2084,2351,1989,2691,1969,
 2332,1934,4896,4373],
 [16,24,17,27,31,19,34,25,58,67,61,79,94,105,85,88,66,77,
 53,71,104,64,74,56,54,87,90,91,86,70,62,49,68,52,324,
 307,298,304,229,280,318,329,212,201,267,213,260,262,231,
 281,245,228,235,192,209,278,1160,692,764,824,722,887,668,
 1107,1192,864,635,672,728,802,715,874,671,1075,920,741,
 798,829,628,2215,2212,2473,2078,1948,2066,3076,2431,5515,
 5861,5487,5775],
 [16,24,17,27,31,19,34,25,58,67,61,79,105,85,88,66,77,71,
 104,64,74,84,56,54,87,91,93,99,49,52,340,316,381,375,
 389,432,370,402,345,366,332,355,362,377,338,283,249,186,
 304,247,264,329,212,292,202,231,281,349,299,278,477,509,
 585,465,470,593,431,1192,1344,1797,1478,1564,1471,1612,1472 
  ],[16,24,17,27,31,19,34,25,58,67,61,79,105,85,88,66,
 77,71,104,64,74,84,56,54,87,91,93,99,49,52,340,381,375,
 389,402,345,392,355,362,377,368,327,283,249,186,304,247,
 264,329,212,292,202,231,281,349,299,278,495,592,606,518,
 493,585,447,538,465,514,462,593,431,468,1192,1344,1044,
 1588,1922,1679,1931,4145,3557],
 [16,24,17,27,31,19,34,25,58,67,61,82,79,94,105,85,88,66,
 59,77,53,71,104,64,74,102,107,84,56,54,96,75,87,90,91,
 86,70,93,99,98,62,49,68,52,324,307,298,229,280,318,201,
 406,267,213,260,262,245,323,192,824,802],
 [16,24,17,27,31,19,34,25,58,67,61,82,79,105,85,88,66,59,
 77,71,104,64,74,102,107,84,56,54,96,75,87,91,70,93,99,
 98,49,52,340,316,381,375,389,432,370,402,345,366,332,392,
 355,362,411,377,368,327,338,283,249],
 [16,24,17,27,31,19,34,25,58,67,61,82,105,85,88,66,59,104,
 64,74,84,56,54,96,75,91,70,98,52,340,316,381,375,389,
 432,370,345,392,355,362,411,377,338,283,249,193,322,350,
 247,264,404,200,319,308,231,281,325,596,518,493,531,543,
 504,557,584,514,462,497,553,878,861,1797,1478,1564,1471,
 1612,1472,1457,1186,1393],
 [16,24,17,27,31,19,34,25,58,67,61,82,105,85,88,66,59,104,
 64,74,84,56,54,96,75,91,70,98,52,340,316,389,432,370,
 345,366,332,355,362,411,368,327,193,322,350,247,264,404,
 200,319,308,231,281,325,500,496,596,531,509,543,612,618,
 505,525,504,557,584,470,566,615,878,861,1862,1908,1267,
 1457,1332,1538,1186,1273,1284,1602,1860,1779,1783,1839,4672,
 4123,2784,3031],
 [16,24,17,27,31,19,34,25,58,67,82,79,88,59,104,64,102,
 107,56,54,87,70,98,49,340,381,375,345,392,355,362,377,
 368,327,283,249,315,291,329,212,251,276,383,238,349,299,
 235,209,495,490,515,592,606,604,585,540,447,561,538,448,
 571,620,590,548,559,593,591,468,577,727,736,1293,1450,
 1315,905,1343,1228,2108,1187,1077,1171,1250,1018,1017,1444,
 2054,1252,1085,1261,1295,886,2158,1194,1384,2217,1750,1734,
 1510,2589,1644,1575,1848,2526,3022,2594,2670,8855,8462,2720,
 3785,5618,2537,3619,3010,4589,2814,4168,4479,2489,3656,2675,
 4542,5217,4607,3873,4802,4962,4545,4060,8747,5653,7190,6017,
 7910,4620,4318,6282,6454,4909,4508,6366,7026,7778],
 [16,24,17,27,31,19,34,25,58,67,82,79,94,105,85,88,59,77,
 53,71,104,64,84,56,54,87,90,91,86,98,62,49,68,52,324,
 307,291,298,229,280,318,329,212,201,267,213,260,262,250,
 231,281,245,220,235,192,209,1507,876,692,764,824,1010,887,
 668,1635,864,635,853,672,728,802,979,874,671,920,903,798,
 829,628,2215,1942,2473,2078,2092,2066,3586,3864,3516,9319,
 3793,8338],
 [16,24,17,27,31,19,34,25,58,67,82,79,105,85,88,59,77,71,
 104,64,102,107,56,54,87,91,70,98,49,52,340,316,381,375,
 389,432,370,402,345,366,332,355,362,377,338,283,249,315,
 291,227,329,212,251,276,383,238,250,235,209,604,585,489,
 485,611,502,516,864,635,829,628,913,908,1082,1108,1005,
 1057,1508,1494],
 [16,24,17,27,31,19,34,25,58,67,82,79,105,85,88,59,77,71,
 104,64,102,107,56,54,87,91,70,98,49,52,340,381,375,389,
 402,345,392,355,362,377,368,327,283,249,315,291,227,329,
 212,251,276,383,238,250,235,209,495,592,606,604,518,493,
 585,447,538,571,620,514,462,591,468,864,635,829,628,1072,
 1082,1150,1005],
 [16,24,17,27,35,30,58,67,50,61,82,79,94,105,85,92,88,89,
 66,59,95,77,53,71,55,104,64,108,74,101,102,107,63,84,
 56,54,78,96,75,65,87,90,91,70,106,93,80,99,81,98,49,
 68,52,57],
 [16,24,17,27,35,30,58,67,50,61,82,85,92,88,89,66,59,95,
 77,71,55,104,64,74,101,102,96,75,65,87,91,70,106,93,80,
 99,81,98,49,52,57,193,234,300,280,264,215,261,310,293,
 318,270,437,295,262,281,245,228,330,358,323,273,357,784,
 742,879,880,718,890,940,2639,2582],
 [16,24,17,27,35,30,58,67,79,94,105,85,92,88,66,59,95,77,
 53,71,55,104,64,74,101,102,107,63,84,96,75,65,87,91,70,
 106,93,99,81,98,49,52,57,324,315,186,307,280,310,293,
 318,270,201,437,406,383,202,262,330,358,323,273,192,357,
 859,883],
 [16,24,17,27,35,30,58,105,66,55,104,74,101,102,56,96,99,
 81,98,52,57,381,366,338,249,356,259,350,212,251,434,217,
 207,269,308,299,235,575,565,455,530,597,596,604,477,564,
 585,572,489,427,508,617,582,611,465,534,483,584,573,459,
 552,593,591,396,499,502,431,486,576,1160,720,866,754,803,
 704,1238,710,812,741,820,698,818,913,831,908,934,966,857,
 1277,1158,1011,867,1267,1039,881,945,1208,1887,1089,1024,
 926,1361,1249,967,1299,1186,848,1273,1002,1027,949,1235,
 1864,1103,911,2008,2241,1913,2130,2352,2398,1925,2018,2780,
 2171,1373,1585,2225,2580,1956,1380,1469,2301,2412,2100,1417,
 1666,2015,3117,2593,2115,2778,2105,2606,3245,2339,3147,2480,
 2043,3100,2179,2498,3267,2266,3820,3940,4011,4063,4124,4232,
 9367,9345,5544,5701,9115,6923,5521,5158],
 [16,24,17,27,35,30,58,105,85,92,88,66,77,74,101,107,96,
 65,87,70,106,93,99,49,52,57,381,389,368,249,356,304,351,
 350,331,320,244,247,206,203,292,434,254,328,308,311,303,
 214,330,299,239,187,278,575,565,606,596,604,469,547,518,
 479,503,447,582,611,620,584,573,510,532,593,591,442,539,
 468,1062,1112,746,1040,918,763,913,1120,908,966,906,1079,
 1354,1663,1234,1171,1106,1322,1590,1317,1363,1261,1822,1856,
 1765,1751,1788,1747,1816,1843,1824,1780,4139,3513,4637,4320,
 4641,4753,3882,5728,4884],
 [16,24,17,27,35,30,82,105,92,88,66,59,95,71,64,74,101,
 102,107,91,93,99,49,52,57,370,366,392,338,249,356,322,
 331,320,243,266,221,288,203,292,388,434,330,349,290,306,
 220,301,187,278,596,604,469,547,479,503,489,582,611,600,
 593,591,442,539,502,1482,1062,1272,1112,823,1042,759,635,
 1661,1053,923,1054,817,628,1012,1539,1760,2103,1354,1663,
 1225,1595,1730,945,1208,1077,1532,1815,1322,1590,1592,1773,
 949,1235,1085,3954,4239,3526,4468,1822,1856,1765,1751,1910,
 1909,1932,1481,1750,1788,1747,1816,1843,1824,1780,1702,1848,
 7780,2923,5941,2926,2156,2147,2213,3191,3454,3319,3122,4220,
 3166,3577,3587,4766,3978,4862,4056,4719,3816],
 [16,24,17,27,35,30,85,92,88,66,77,55,104,74,101,107,56,
 96,65,87,70,106,93,99,81,98,49,52,57,389,368,338,249,
 356,186,300,304,351,350,244,212,206,434,202,287,254,328,
 308,214,299,239,588,575,565,467,495,500,606,637,596,604,
 469,547,580,585,572,479,503,626,582,611,449,538,505,620,
 599,584,573,510,532,623,593,591,442,539,1757,913,1120,
 1796,908,943,1835,966,906],
 [16,24,17,27,35,30,105,85,92,88,66,71,74,101,102,107,91,
 70,106,93,99,81,98,49,52,57,389,370,366,392,368,338,249,
 304,351,322,331,320,244,212,243,266,388,434,311,303,214,
 349,299,290,306,596,604,526,469,547,511,479,503,582,611,
 519,510,532,593,591,535,442,539,1482,1378,1272,1192,1063,
 823,1661,1488,1053,1344,1289,923,1120,1012,1172,906,1539,
 1760,1354,1663,1595,1730,1532,1815,1322,1590,1592,1773,2124,
 1822,1856,2104,1765,1751,2381,1909,1932,2387,1788,1747,2097,
 1816,1843,2399,1824,1780,2156,4637,2147,4320,2213,4641],
 [16,24,17,27,35,30,649,708,85,92,88,66,59,95,74,101,102,
 107,63,84,70,106,93,99,81,98,49,52,57,1686,1884,1607,
 1830,389,370,366,392,368,338,249,324,315,186,331,320,244,
 243,266,206,406,383,202,311,303,214,290,306,239,467,495,
 490,526,469,547,479,503,533,474,449,538,510,532,563,535,
 442,539,1330,1120,1012,943,1172,906],
 [16,24,27,19,30,25,58,67,50,61,82,100,79,94,105,85,92,88,
 89,66,76,59,77,53,71,55,104,64,108,74,102,107,63,84,56,
 72,54,78,96,75,65,87,90,91,86,70,93,80,99,81,98,49,68,
 52],[16,24,27,19,30,25,58,67,50,61,100,79,94,105,85,
 92,66,77,53,71,55,104,107,63,56,72,54,78,96,87,90,86,
 70,93,80,99,81,49,68,52,186,272,307,298,304,244,280,227,
 212,243,206,202,269,267,213,254,231,228,299,290,239,278,
 692,722,1107,803,733,727,672,715,820,760,736,2325,2367],
 [16,24,27,19,30,25,58,67,50,61,100,79,94,105,85,92,89,66,
 77,53,71,55,104,108,74,56,72,54,78,96,87,86,70,93,80,
 99,81,49,68,52,186,272,298,304,244,247,212,243,270,206,
 292,269,213,254,281,245,228,299,290,273,239,278,764,824,
 722,803,746,728,802,715,741,820,763,2212,1948],
 [16,24,27,19,30,25,58,67,50,61,100,79,94,105,89,66,77,53,
 71,55,108,74,56,72,54,78,96,87,86,70,93,80,99,81,49,
 68,52,186,259,240,272,298,304,247,212,243,270,206,292,
 217,207,269,213,254,281,245,228,299,290,273,239,278,752,
 720,764,824,722,759,803,746,694,710,728,802,715,741,817,
 820,763,2212,1948],
 [16,24,27,19,30,25,58,67,50,82,100,79,94,105,88,76,59,77,
 53,71,55,64,84,56,72,54,78,75,65,90,91,86,70,93,80,98,
 49,68,52,315,259,240,307,291,247,264,215,329,266,217,207,
 267,238,303,262,250,231,281,245,349,209,187,752,719,876,
 800,694,709,853,671,755,903,664,2140,2495,2133,2119,2057,
 4042,3455],
 [16,24,27,19,30,25,82,100,79,105,88,76,59,71,55,64,102,
 84,72,54,75,65,87,91,86,70,93,99,81,381,377,368,338,
 342,315,259,240,291,322,310,329,404,388,383,217,207,238,
 319,330,349,325,616,575,495,441,556,606,614,597,596,549,
 609,602,619,585,527,618,608,617,582,538,483,544,620,590,
 610,584,568,600,621,605,593,480,615,577,1371,1757,913,
 1331,1796,908,1314,1835,966],
 [16,24,27,19,30,82,105,85,92,76,59,71,55,104,64,102,72,
 54,75,65,86,70,93,98,389,360,345,363,368,236,342,208,
 193,322,261,310,206,276,203,388,277,200,238,319,228,349,
 325,616,575,501,500,597,596,513,609,602,506,447,617,582,
 487,505,620,590,610,584,517,605,593,499,615,577,896,1272,
 922,808,704,889,1053,980,799,932,1151,913,985,908,978,966,
 1451,1760,1870,1228,1933,1354,1663,1861,1131,1955,1221,1815,
 1897,1127,1927,1322,1590,1819,1243,1773,1937,1128,860,2790,
 3050,2565,2924,2007,1856,1194,1751,1110,1184,1747,1117,1843,
 1242,1780,1185,4689,4169,4660,3807,3617,2982,3882,4884],
 [16,24,27,31,35,19,34,30,58,67,50,61,82,79,105,85,88,66,
 59,77,71,104,64,108,74,101,102,107,84,56,72,54,78,96,
 75,87,91,70,93,80,99,98,49,52,208,234,359,215,270,437,
 386,277,253,267,295,245,273,357,343,663,701],
 [16,24,27,31,35,19,34,30,58,67,50,61,82,100,79,94,105,85,
 88,89,66,59,77,53,71,104,64,108,74,101,102,107,63,84,
 56,72,54,78,96,75,87,90,91,70,93,80,99,98,49,68,52,57]
  ,[16,24,27,31,35,19,34,30,58,67,50,61,100,79,94,105,66,
 77,53,71,104,64,108,74,101,107,63,84,56,72,54,78,96,91,
 70,93,80,49,68,57,186,259,272,307,304,212,266,270,276,
 292,435,202,217,269,267,254,299,306,273,209,278,335,692,
 746,672,763],
 [16,24,27,31,35,19,34,30,58,67,61,79,105,66,77,71,104,64,
 74,107,84,56,54,96,91,70,93,49,52,340,372,316,381,370,
 360,402,347,345,366,392,362,363,411,368,249,236,186,304,
 247,212,266,276,292,202,254,231,209,278,515,501,560,503,
 524,506,447,468,635,697,628,664,1293,1276,1077,1096,1454,
 1024,1348,911,1750,3320,3170,3176,3248,2506,2555],
 [16,24,27,31,35,19,34,30,58,67,61,79,105,66,77,71,104,64,
 74,107,84,56,54,96,91,70,93,49,52,340,381,402,347,345,
 392,362,363,423,377,368,249,236,186,304,247,212,266,276,
 292,202,254,231,209,278,551,495,606,624,518,585,524,506,
 447,562,538,620,581,494,517,514,468,635,697,628,664,1276,
 1353,1093,1183,1082,1142,1230,1005,1821,1899],
 [16,24,27,31,35,19,34,30,58,67,61,82,79,105,85,88,66,59,
 77,71,104,64,74,102,107,84,56,54,96,75,87,91,70,93,99,
 98,49,52,340,372,316,381,389,370,360,402,347,345,366,392,
 362,363,411,423,377,368,338,249,236],
 [16,24,27,31,35,19,34,30,58,67,61,82,105,66,59,71,104,64,
 74,102,56,54,96,91,70,93,99,98,52,340,372,316,370,360,
 347,345,366,362,363,411,368,338,193,322,264,261,212,266,
 404,319,281,228,299,306,325,515,501,500,596,509,560,503,
 524,506,618,625,584,470,569,539,615,587,742,718,1293,1276,
 1216,1077,1096,1254,1085,1147,1750,1848],
 [16,24,27,31,35,19,34,30,58,67,61,82,105,66,59,71,104,64,
 74,102,56,54,96,91,70,93,99,98,52,340,372,316,381,370,
 360,402,347,345,366,362,363,423,377,368,338,249,236,193,
 322,264,261,212,266,404,319,281,228,299,306,325,515,501,
 509,585,524,506,494,517,470,593,742,718,1293,1276,1353],
 [16,24,27,31,35,19,34,30,58,82,105,66,59,71,104,74,102,
 56,96,91,70,99,98,52,372,316,381,370,360,402,366,423,
 377,338,249,236,356,315,259,272,293,251,434,383,217,269,
 358,235,575,537,441,597,604,583,609,598,479,489,617,582,
 611,483,548,600,638,498,499,502,576,720,710,913,908,1605,
 857,1555,1011,1285,1263,1326,1887,1108,926,1511,967,1255,
 1186,1367,1140,1864,1057,2196,1619,1585,1508,1608,1469,1999,
 2570,1631,1711,1494,2115,3074,2043,2947,2386,2319,4489,3466,
 2791,3384,4822,3339,3118,3962,3325,2955,3611,5788,3272,7560,
 8281,9366,3699,7722,7716,6616,4456,8665,5751,6497,5588,6877,
 6549,6547,6543,6429,6525,7132,6766,6207,6953],
 [16,24,27,31,35,19,34,30,67,61,82,79,105,66,59,77,64,74,
 102,107,84,54,96,75,87,91,93,49,52,340,372,316,381,370,
 360,347,345,366,392,362,363,411,423,377,368,249,236,342,
 259,272,310,221,388,217,269,308,303,330,220,441,543,549,
 483,557,544,584,553,480,696,752,684,694,1862,1908,1891,
 1139,1094],
 [16,24,27,31,35,19,34,30,67,61,82,79,105,66,59,77,64,74,
 102,107,84,54,96,75,87,91,93,49,52,372,316,381,370,360,
 402,366,392,411,423,377,249,236,342,259,272,310,221,388,
 217,269,308,303,330,220,575,441,543,549,609,598,489,582,
 483,546,532,600,638,502,553,480,696,752,684,694,1862,1891,
 1555,1011,1671,1081,1511,967,1570,1203,1823,1775],
 [16,24,33,37,27,36,41,35,28,19,40,30,13,25,67,50,55,63,
 54,65,93,81,98,237,282,372,481,541,364,352,347,521,346,
 476,361,433,423,491,371,472,214,467,490,451,501,597,583,
 479,533,450,506,617,507,487,586,510,563,452,517,605,529,
 499,576,954,842,1047,905,1146,995,969,1125,1098,1017,1161,
 885,1058,1061,1019,1090,1437,1180,1402,1141,1408,1132,3579,
 3551,3668,3673,3632,4059],
 [16,24,37,27,41,19,40,30,25,58,67,50,61,100,79,105,85,92,
 76,59,77,71,55,104,102,56,72,54,96,75,65,86,70,93,99,
 81,49,68,52,186,272,291,244,280,227,264,215,261,266,206,
 269,238,214,262,250,281,245,228,306,239,278,1107,754,1075,
 741],
 [16,24,37,27,41,19,40,30,25,58,67,50,61,105,66,76,59,77,
 71,55,108,74,102,107,63,56,72,54,96,75,65,87,86,70,93,
 99,81,68,52,186,208,193,261,206,292,404,202,277,200,217,
 207,269,303,214,228,239,278,325,644,700,870,665,705,914,
 694,710,2109,1950,2032,1976],
 [16,24,37,27,41,19,40,30,25,58,67,50,61,105,85,92,66,76,
 59,71,55,104,108,74,102,56,72,54,96,75,65,86,70,93,99,
 81,68,52,186,208,193,322,244,264,215,261,266,206,292,404,
 269,319,214,228,306,239,278,325,870,754,670,742,707,712,
 669,718,717,723,2130,2093,2018,2586],
 [16,24,37,27,41,19,40,30,25,58,67,50,82,100,79,105,66,76,
 59,77,71,55,108,74,84,56,72,54,96,91,86,70,93,98,49,
 68,52,315,259,240,272,247,264,215,212,243,266,276,203,
 217,207,269,231,281,245,209,187,752,720,800,759,803,635,
 901,697,694,710,903,628,897,664,2514,2394,2364,2383],
 [16,24,37,27,41,19,40,30,25,58,67,50,100,79,105,85,92,76,
 59,77,71,55,104,102,107,63,56,72,54,75,65,87,86,70,93,
 49,68,52,315,186,272,291,244,261,329,206,383,202,269,238,
 214,262,250,228,349,209,187,278,719,876,668,737,709,853,
 671,755,1075,698,2650,1916,2282,1923],
 [16,24,37,27,41,19,40,30,25,58,67,50,100,79,105,85,92,88,
 77,71,55,104,64,56,72,54,86,70,93,49,68,52,315,186,291,
 298,304,280,227,247,329,212,243,266,206,276,203,292,238,
 213,254,281,245,228,349,299,290,209,187,278,764,824,722,
 733,727,746,697,704,728,802,715,903,741,664,698,1942,2212,
 2234,2627,2084,2092,1948,2390,2691,1969],
 [16,24,37,27,41,19,40,30,25,58,67,50,100,79,105,88,66,77,
 71,55,64,108,74,84,56,72,54,96,91,86,70,93,49,68,52,
 315,259,240,298,304,247,212,243,266,276,203,292,202,217,
 207,213,254,231,281,245,209,187,278,1160,752,764,824,759,
 635,901,697,694,728,802,903,628,897,664,1942,2514,2092,
 3076,2364,5515,5487],
 [16,27,35,19,25,58,67,50,61,97,79,85,77,71,55,104,83,74,
 107,84,103,56,72,54,78,96,65,87,62,49,52,186,208,234,
 300,240,270,206,221,251,201,276,203,437,277,253,287,207,
 269,267,238,254,295,214,262,235,192,209,187,357,870,663,
 896,793,784,720,719,746,712,635,919,704,1029,1347,914,701,
 889,816,765,710,709,672,802,918,1075,628,872,698,961,1308,
 2452,2357,2216,2650,2093,2084,1989,2396,2467,2024,2282,1948,
 1969,1934,4110,3646,4453,3481],
 [16,27,35,19,25,58,67,50,61,97,100,79,94,85,66,77,53,71,
 55,104,83,74,84,103,56,72,54,78,96,65,87,90,70,99,62,
 49,68,52,186,300,240,272,307,304,212,206,251,201,203,287,
 207,269,267,254,214,262,231,281,245,235,192,187,278,720,
 719,692,764,824,635,704,710,709,672,728,802,1075,741,628,
 698,2650,2212,2282,1948],
 [16,29,17,37,20,27,31,32,35,19,40,18,30,13,15,25,58,50,
 82,85,89,59,104,102,63,56,75,90,70,98,252,376,407,410,
 365,336,395,344,313,399,373,380,317,354,341,482,467,513,
 528,449,517,834,1339,1569,811,1297,968,1288,1495,1469,2333,
 2303,2354],
 [16,29,17,37,20,27,31,32,35,19,40,18,30,13,15,25,67,97,
 79,88,77,55,64,107,103,54,87,93,81,49,237,340,381,421,
 408,364,402,312,366,428,337,361,411,374,368,393,286,515,
 511,488,535,1357,1502,1434,1486,1325,1401],
 [16,29,17,37,20,27,31,32,35,19,40,18,30,13,15,25,77,55,
 87,49,237,340,381,421,408,364,402,312,366,428,337,361,
 411,374,368,393,286,616,482,467,597,567,469,531,522,619,
 545,511,479,506,617,528,449,504,512,610,550,510,595,605,
 555,442,497,463,1357,1502,1434,1486,1325,1401,1096,1706,
 1495,4087,1619,1528,1756,1743,3846,1608,1531,1723,1594,3997,
 1654,1479,3661,3384,3171,4163,3118,2584,4084,3608,2792],
 [16,29,17,37,20,27,31,32,35,19,40,18,30,13,15,25,89,59,
 102,63,98,252,376,407,410,365,336,395,344,313,399,373,
 380,317,354,341,588,575,526,461,513,518,477,580,585,511,
 524,528,474,449,488,505,465,599,584,568,535,498,502,431,
 834,1339,1569,811,1297,968,1288,1076,1106,1142,5162,1822,
 1567,2491,1244,5102,1909,1466,1469,1514,2263,1163,7869,1816,
 1557,2191,1202,2333,2303,2354,9227,3191,3437,5674,3319,2829,
 3218,4635,3166,3098,9001,5105,6731,5109,8135,5839,8731,9206,
 6396],
 [16,29,24,17,39,27,31,42,32,19,38,18,34,21,15,25,50,94,
 89,76,83,108,63,78,90,86,62,68,237,252,384,326,421,364,
 365,312,337,405,286,201,192,464,441,556,554,461,477,533,
 524,427,474,544,563,494,459,529,498,431,993,1251,1078,
 1887,1038,1159,999,1864,2588,2094,3459,4916,3781,6055,3718,
 4831,3854,7339],
 [16,29,24,17,39,27,31,42,32,19,38,18,34,21,15,25,94,89,
 76,53,83,108,78,90,86,80,62,68,237,252,384,326,421,364,
 365,312,337,405,286,215,245,575,556,554,461,477,580,619,
 585,533,524,427,544,563,494,459,623,605,529,498,431,933,
 1595,984,1592,2124,2381,5674,5706],
 [16,29,24,17,39,37,20,27,31,32,35,19,38,40,18,34,30,21,
 13,15,25,237,252,340,326,369,381,421,408,364,365,402,312,
 367,366,428,337,361,373,411,405,374,380,368,393,286,1357,
 1502,1434,1486,1325,1401],
 [16,29,24,17,39,37,27,31,42,41,32,35,19,38,40,18,34,30,
 21,13,15,25,237,252,340,384,326,421,408,364,365,402,312,
 425,333,428,337,361,373,411,405,444,374,393,286,1357,1434,
 1325],
 [16,29,24,33,17,20,27,36,31,32,28,19,34,23,15,25,58,67,
 79,88,77,71,64,102,107,54,49,381,375,389,402,345,392,
 355,362,368,327,283,249,266,575,495,592,606,518,493,585,
 503,447,582,538,504,557,571,620,497,468,553,1219,1667,
 1171,1250,1186,1217,1738,1393,1999,1783,2095,1896,3682,3286,
 3684,2601,3565,3959,4048,2878,3554,4077,9317,4564,8716,4703]
  ,[16,29,24,33,17,37,20,27,36,31,41,32,35,28,19,40,34,
 23,30,13,15,25,237,252,340,369,376,422,410,364,365,402,
 395,367,344,346,399,361,373,411,387,380,317,371,341,1893,
 1907,1876],
 [16,29,24,33,37,20,27,36,31,41,32,35,28,19,40,18,34,23,
 30,13,15,25,237,252,340,369,410,364,365,402,347,395,367,
 344,399,361,373,411,423,387,380,317,341,1148,1893,1248,
 1907,973,1115,1876,982,1811,1867,1834],
 [16,29,33,17,20,27,36,31,32,35,19,18,23,30,15,25,58,50,
 94,89,59,53,108,102,63,78,90,70,80,68,252,376,407,365,
 336,395,344,313,399,380,341,482,467,594,513,619,540,473,
 528,449,586,517,605,497,463,834,1339,1569,811,1297,1495,
 1721,1901,1469,1604,1814,2333,2303,5219,4861],
 [16,30,58,67,50,61,82,79,105,85,88,59,77,71,104,64,102,
 107,84,54,96,75,87,91,70,93,80,99,98,289,394,492,375,
 443,407,336,429,520,313,409,419,484,327,385,354,208,234,
 291,359,270,404,277,253,295,245,330,273,606,614,624,558,
 547,602,618,608,625,590,600,621,638,569,539,577,663,824,
 1062,1635,1786,701,1040,1708,1771,1407,1483,1496,1520,1504,
 1537,2103,2113,1399,1922,2267,2353,2583,2203,2005,1931,2403,
 1261,2382,2458,2511,2776,1994,1751,2184,1747,2273,1780,3666,
 4219,4094],
 [16,30,58,67,61,97,82,79,105,85,88,59,77,71,104,64,102,
 107,84,54,96,75,87,91,70,93,99,81,98,340,372,316,492,
 381,389,402,347,345,520,392,411,423,377,484,368,338,222,
 291,331,216,288,404,223,311,321,330,258,301,496,530,606,
 614,624,602,485,508,618,608,625,590,462,552,600,621,638,
 577,814,1062,1635,807,1786,1040,1708,787,1771,1757,1796,
 1835,1114,2103,2113,1922,2267,1257,2353,2583,2203,2005,1209,
 1931,2403,2382,2458,4167,3452],
 [16,31,19,58,67,50,61,82,79,88,59,77,53,71,104,83,64,108,
 74,63,84,56,54,78,96,75,87,70,98,62,49,68,52,289,372,
 394,407,360,336,347,429,313,363,409,423,354,236,234,300,
 259,247,264,251,201,276,253,287,217,231,281,235,192,209,
 500,397,496,518,453,493,489,412,485,505,448,525,514,417,
 462,502,454,516,1726,1658,1748],
 [16,31,19,58,67,50,61,82,79,94,66,59,77,53,71,104,83,64,
 108,74,84,56,54,78,96,75,91,70,98,62,49,68,52,289,372,
 394,360,336,347,429,313,363,409,423,419,354,236,300,259,
 247,264,215,251,201,276,287,217,231,281,245,235,192,209,
 501,500,496,513,518,493,506,489,485,487,505,525,517,514,
 462,499,502,516,777,975,991],
 [16,31,19,58,67,50,61,82,94,88,66,59,77,53,71,104,83,64,
 108,102,107,63,84,56,54,78,87,91,93,99,98,62,49,68,52,
 289,372,394,360,336,347,429,313,363,419,354,236,193,227,
 221,201,200,250,220,192,490,515,500,496,554,461,518,493,
 533,524,489,485,507,488,505,525,563,494,514,462,529,498,
 502,516,777,834,1033,975,811,840,991,968,964],
 [16,31,19,58,67,50,61,82,94,105,85,88,59,77,53,71,104,64,
 102,107,63,84,56,54,78,96,75,87,93,80,99,98,62,49,68,
 52,289,372,394,407,336,347,429,313,363,409,423,419,354,
 236,193,229,280,227,221,200,260,262,250,220,500,397,496,
 518,453,493,489,412,485,505,448,525,514,417,462,502,454,
 516,837,826,891],
 [16,31,19,58,67,50,61,82,105,85,66,59,77,53,71,104,83,64,
 108,102,107,63,84,56,54,78,96,75,91,93,80,99,98,62,49,
 68,52,289,372,394,407,360,336,347,429,313,363,409,423,
 354,236,193,234,227,221,200,253,250,220,501,500,496,513,
 518,493,506,489,485,487,505,525,517,514,462,499,502,516,
 1726,1658,1748],
 [16,31,19,58,67,50,61,82,105,85,88,66,59,104,83,64,108,
 102,107,84,56,54,78,96,75,87,91,98,49,52,289,372,394,
 407,360,429,313,363,409,423,419,236,193,234,359,215,201,
 253,295,250,245,314,357,500,496,537,570,531,543,540,561,
 504,557,514,462,548,559,497,553,876,742,1029,853,801,751,
 718,961,792,1404,1442,1327,1303,1350,1427,1237,1372,1341,
 1143,1073,1044,1216,1316,1231,1155,1121,1087,1067,1254,1224,
 1201,1168,1109,1785,2509,1801,2472,2110,1653,1656,1462,1606,
 1580,1611,5354,3415],
 [16,31,19,58,67,61,79,88,66,59,77,71,104,64,74,84,54,96,
 75,87,91,70,98,49,52,340,389,432,370,402,345,392,355,
 362,411,377,338,283,249,279,208,247,264,255,203,287,217,
 246,305,235,209,187,464,430,526,518,493,598,511,466,473,
 474,505,525,581,519,478,523,535,502,516,587,815,644,887,
 668,1084,670,746,707,895,665,747,874,671,763,717,2535,
 2676,2453,1403,1699,1399,1392,1052,1542,1171,1250,1512,1722,
 1126,1511,1456,1415,1261,1295,1154,1348,1995,2270,2087,2091,
 2645,2118,1473,1527,1509,2841,3124,2787,2611,2277,3036,2729,
 3196,2746,2554,2372,2972],
 [16,31,19,58,67,61,82,79,105,85,88,66,59,77,71,104,64,74,
 102,107,84,56,54,96,75,87,91,70,93,99,98,49,52,340,289,
 372,316,394,381,375,389,407,432,370,360,402,336,347,345,
 429,366,332,392,313,355,362,363,411,409,423,377,419,368,
 327,338,354,283,249,236],
 [16,31,19,58,67,61,82,88,66,59,77,71,104,64,74,84,56,96,
 75,87,91,70,98,49,52,289,372,394,407,360,336,347,429,
 313,409,423,419,354,236,324,229,280,247,264,318,201,287,
 217,260,262,235,192,209,467,495,441,469,518,493,574,609,
 479,503,447,449,505,525,510,532,470,442,502,516,566,615,
 815,644,887,668,983,746,707,895,665,874,671,763,717,798,
 758,740,841,1403,1699,1399,1392,1059,1171,1250,1512,1722,
 1094,1456,1415,1261,1295,1005,2473,2423,2066,2499,1837,2053,
 1831,2047,1715,2126,3079,2647,2949,3259,2501,2937],
 [16,31,19,58,67,61,97,82,100,69,88,66,59,77,71,55,104,64,
 101,102,107,84,103,56,72,54,60,87,91,93,99,98,49,52,57,
 340,316,432,370,402,345,392,355,362,377,338,283,249,193,
 227,221,203,200,250,220,187,490,515,500,496,554,461,518,
 493,533,524,489,485,507,488,505,525,563,494,514,462,529,
 498,502,516,1293,1660,1276,1818,1353,1605],
 [16,31,19,58,67,61,97,82,100,79,69,66,59,77,71,55,104,64,
 74,101,84,56,54,96,60,75,91,70,98,49,52,57,340,316,432,
 370,402,345,392,355,362,411,377,338,283,249,300,259,247,
 264,302,309,251,276,203,287,217,231,281,321,348,235,209,
 187,501,500,496,513,518,493,506,489,485,487,505,525,517,
 514,462,499,502,516,1293,1276,1353],
 [16,31,19,58,67,61,97,82,100,79,88,59,77,71,55,104,64,74,
 101,84,103,56,72,54,96,60,75,87,70,98,49,52,57,340,316,
 389,432,370,402,345,392,355,362,411,338,283,249,300,222,
 259,247,264,251,276,203,287,223,217,231,281,235,209,187,
 500,397,496,518,453,493,489,412,485,505,448,525,514,417,
 462,502,454,516,985,978,1451],
 [16,31,19,58,67,61,97,82,100,105,69,85,88,59,77,71,55,
 104,64,102,107,84,103,56,72,54,96,60,75,87,93,99,81,98,
 49,52,57,340,316,389,402,345,392,355,362,411,377,338,283,
 249,193,227,230,221,200,250,246,220,500,397,496,518,453,
 493,489,412,485,505,448,525,514,417,462,502,454,516,851,
 818,839,831,789,934],
 [16,31,19,58,67,61,97,82,100,105,85,66,59,77,71,55,104,
 64,101,102,107,84,103,56,72,54,96,60,75,91,93,99,81,98,
 49,52,57,340,316,389,432,370,402,345,392,355,362,411,338,
 283,249,193,222,227,221,200,223,250,220,501,500,496,513,
 518,493,506,489,485,487,505,525,517,514,462,499,502,516,
 985,978,1451],
 [16,31,19,58,67,61,105,85,88,66,59,77,71,104,64,102,107,
 84,54,96,75,87,91,93,99,98,49,52,340,316,389,432,370,
 402,345,392,411,377,338,283,249,279,208,227,230,255,203,
 294,277,200,246,220,187,464,430,536,526,518,493,598,511,
 466,473,474,505,525,519,478,523,535,502,516,587,788,1010,
 727,963,979,736,787,1211,1120,1270,943,1329,906,1403,1699,
 1399,1392,1052,1542,1171,1250,1512,1722,1126,1511,1456,1415,
 1261,1295,1154,1348,2294,2170,2317,2429,2505,2841,3124,2787,
 2611,2277,3036,2729,3196,2746,2554,2372,2972],
 [16,31,30,58,67,50,61,82,100,79,94,105,85,88,59,77,53,71,
 104,64,102,107,63,84,72,54,78,96,75,87,90,91,70,93,80,
 99,98,289,394,375,443,407,336,429,313,409,419,327,385,
 354,307,291,310,404,267,238,330,325,606,614,624,609,602,
 598,618,608,625,620,590,581,600,621,638,615,577,587,1407,
 1483,1496,1520,1504,1537],
 [16,31,30,58,67,50,61,82,100,79,94,105,85,88,89,59,77,53,
 64,74,102,107,63,84,54,96,75,87,90,91,70,93,80,52,289,
 394,375,443,407,336,332,424,313,409,419,327,385,291,310,
 309,318,404,238,330,348,323,325,570,556,606,624,543,549,
 609,598,561,527,618,625,557,544,620,581,559,568,600,638,
 553,480,615,587,1752,1327,1770,1427,1755,1341],
 [16,31,30,58,67,50,61,82,100,79,94,105,85,88,89,66,77,53,
 71,104,74,102,107,63,84,56,96,75,87,90,91,70,93,80,99,
 98,289,394,375,443,407,336,332,424,313,409,419,327,385,
 354,304,309,293,318,435,254,348,358,323,335,594,606,624,
 583,609,598,579,618,625,586,620,581,595,600,638,576,615,
 587,1752,1770,1755],
 [16,31,30,58,67,50,61,82,100,79,94,105,85,88,89,66,77,64,
 74,102,107,63,84,56,72,78,96,75,87,90,91,70,93,80,49,
 289,394,375,443,407,429,332,424,313,409,419,327,385,304,
 359,293,435,254,295,358,335,570,556,606,624,543,549,609,
 598,561,527,618,625,557,544,620,581,559,568,600,638,553,
 480,615,587,1404,1327,1303,1427,1237,1341],
 [16,31,30,58,67,61,82,79,105,85,88,66,59,77,71,104,64,74,
 102,107,84,56,54,96,75,87,91,70,93,99,98,49,52,340,289,
 372,316,394,381,375,443,389,407,370,360,402,336,347,345,
 429,366,332,424,392,313,362,363,411,409,423,377,419,368,
 327,385,338,354,249,236],
 [16,31,30,58,67,61,97,82,79,105,69,85,88,59,77,71,55,104,
 64,102,107,84,103,54,96,60,75,87,91,86,70,106,93,99,81,
 98,340,372,316,381,389,402,347,345,392,411,423,377,368,
 338,291,298,351,310,404,238,213,328,330,325,606,614,624,
 609,602,598,618,608,625,620,590,581,600,621,638,615,577,
 587,1757,1796,1835],
 [16,31,30,58,67,61,97,82,79,105,69,85,88,66,76,95,77,64,
 74,102,107,84,103,56,96,60,75,87,91,86,70,106,93,81,49,
 340,372,316,381,389,347,345,366,392,411,423,377,368,304,
 331,293,435,254,311,358,335,570,556,606,624,543,549,609,
 598,561,527,618,625,557,544,620,581,559,568,600,638,553,
 480,615,587,1436,1862,1450,1908,1315,1891],
 [16,31,30,58,67,61,97,82,79,105,69,85,88,66,76,95,77,71,
 55,104,74,102,107,84,103,56,96,75,87,91,86,70,106,93,
 99,81,98,340,372,316,381,389,402,366,392,411,423,377,368,
 338,304,293,255,435,254,358,305,335,594,606,624,583,609,
 598,579,618,625,586,620,581,595,600,638,576,615,587,1442,
 1371,1350,1331,1372,1314],
 [16,31,30,58,67,61,97,82,79,105,69,85,88,76,59,95,77,55,
 64,74,102,107,84,103,54,96,75,87,91,86,70,106,93,81,52,
 340,372,316,381,389,402,366,392,411,423,377,368,291,310,
 255,404,238,330,305,325,570,556,606,624,543,549,609,598,
 561,527,618,625,557,544,620,581,559,568,600,638,553,480,
 615,587,1442,1371,1862,1350,1331,1908,1372,1314,1891],
 [16,31,41,35,19,40,34,30,13,25,58,50,97,82,100,94,105,69,
 59,71,104,74,102,107,63,84,103,56,72,78,96,60,75,87,91,
 70,99,98,49,52,356,315,193,259,272,291,322,293,251,434,
 383,200,217,269,238,319,214,358,235,720,710],
 [16,33,17,39,20,31,42,32,28,38,23,21,15,67,76,71,107,60,
 75,99,81,237,282,389,370,364,402,352,366,424,392,362,361,
 411,433,368,385,338,249,260,246,482,495,515,493,574,598,
 545,503,466,524,528,538,525,571,581,550,532,478,494,555,
 539,516,566,587,3484,1330,1490,3575,1012,992,3624,1172,
 1069,907,1056,1003,1119,1239,1025,946,931,1083,1066,1060,
 1853,1386,1697,1883,1501,1687,1846,1464,1696,2732,2805,2804]
  ,[16,37,27,19,30,58,67,50,61,97,82,100,79,105,85,92,88,
 89,66,76,59,77,53,71,55,104,64,108,74,101,102,107,63,
 84,103,56,72,54,96,75,65,87,90,91,86,70,93,80,99,81,
 98,49,68,52,57],
 [16,37,27,19,30,58,67,50,97,105,89,66,76,59,77,53,71,55,
 84,56,72,54,90,91,86,70,93,68,52,57,315,186,208,193,
 280,227,230,247,264,215,302,329,212,243,266,217,207,269,
 262,250,246,231,281,245,321,192,209,187,278,325,644,700,
 870,716,668,737,1107,922,800,754,670,742,759,803,694,710,
 745,671,755,1075,980,903,741,669,718,829,628,897,664,2109,
 1950,2592,2285,3407,2258,2029,1913,2130,2879,2159,3393,2057,
 1895,1925,2018,2364,2383,5711,6013,4233,3128,6036,5374,4540,
 3597],
 [16,37,27,19,30,58,82,105,89,66,76,59,77,53,71,55,102,84,
 56,75,65,90,91,86,70,98,68,52,57,356,324,279,272,280,
 227,230,264,215,302,309,293,329,266,434,406,294,269,303,
 214,262,250,246,281,245,321,348,358,235,192,209,187,325,
 1507,924,788,716,668,737,922,800,670,742,703,809,1597,
 1015,963,874,745,671,755,980,903,669,718,725,868,829,664,
 2470,2008,2592,2258,2029,1913,3168,1991,2543,2352,2879,2057,
 1895,1925,3695,2289,3811,4025,4233,3128,5892,5388,3794,4540,
 3597,4949,9223,7902,5403,7505],
 [16,37,41,19,40,30,58,61,82,85,92,66,77,104,108,74,107,
 63,56,96,75,65,87,91,68,52,394,409,419,236,356,324,300,
 272,244,247,261,251,292,404,277,200,287,269,214,231,228,
 278,325,482,496,455,570,536,458,493,477,543,522,485,427,
 561,473,525,465,557,512,478,462,459,559,523,553,463,924,
 788,750,983,921,769,920,875,837,1404,826,1303,891,1237,
 1555,1158,1052,1542,1039,1454,1089,1155,1121,1511,1249,1065,
 1526,1002,1109,1036,2536,2120,2741,2348,2468,2010,2254,2035,
 2236,2887,2557,2936,2510,3449,4116],
 [16,37,41,19,40,30,58,67,50,61,82,85,92,104,64,108,74,56,
 72,54,96,75,65,87,91,49,68,52,289,394,429,363,409,419,
 236,208,193,300,272,291,247,292,277,200,287,231,281,245,
 228,496,455,537,570,536,493,477,540,561,473,525,465,462,
 459,548,559,523,764,824,722,778,1635,1347,728,802,715,795,
 1708,1308,837,1404,1303,891,1237,1219,1667,1335,1294,1671,
 1304,1332,1538,1095,1217,1738,1405,1269,1570,1214,1284,1602,
 1080,1656,1869,1727,1865,1606,1882,1753,1878,1611,1850,1712,
 1879,4198,3897,3848],
 [16,37,41,19,40,30,58,67,50,61,97,82,100,79,105,69,85,92,
 88,66,76,59,77,71,55,104,64,108,74,101,102,107,63,84,
 103,56,72,54,96,60,75,65,87,91,86,70,93,99,81,98,49,
 68,52,57],
 [16,37,41,19,40,30,58,67,50,61,97,82,100,79,105,85,92,88,
 104,64,108,74,102,107,63,84,56,72,54,96,60,75,65,87,91,
 99,81,98,49,68,52,222,291,298,304,322,350,331,230,386,
 223,238,213,254,319,308,311,246,321,258,220,235,343,814,
 726,1010,887,757,702,979,874],
 [16,37,41,19,40,30,58,67,50,61,100,79,85,92,66,77,104,64,
 108,74,107,63,56,72,54,96,75,65,87,91,49,289,429,363,
 409,419,186,300,272,247,261,251,292,437,435,202,287,269,
 231,228,235,278,357,335,430,496,455,570,536,493,477,543,
 522,485,427,561,473,625,426,525,465,557,512,462,459,559,
 523,516,431,553,463,587,837,1404,826,1303,891,1237],
 [16,37,41,19,40,30,58,67,50,82,105,69,66,76,59,71,55,108,
 74,101,102,84,103,56,72,54,96,60,75,65,91,86,70,93,98,
 68,52,57,315,279,322,264,215,266,276,203,404,277,200,217,
 207,269,319,303,214,281,245,209,187,325,924,788,800,1084,
 697,665,705,914,694,710,903,1101,664,2470,2008,2241,2536,
 2120,2032,1976,2741,2348,3811,4025,4402,2950,4586,5148,3745,
 9231,4409,9134,5716,6801],
 [16,37,41,19,40,30,58,67,50,82,105,69,88,66,76,59,71,55,
 64,108,74,101,102,84,103,56,72,54,96,60,75,65,91,86,70,
 93,98,68,52,57,315,279,322,264,215,266,276,203,404,277,
 200,217,207,319,303,281,245,209,187,325,924,788,800,1084,
 697,665,705,694,903,1101,664,2470,2008,2536,2120,2032,2741,
 2348,3811,4402,2950,5148,3745,4409,5716],
 [16,37,41,19,40,58,67,50,61,82,85,92,66,104,83,108,74,56,
 72,54,96,75,65,91,62,68,52,289,394,363,409,419,236,208,
 193,300,244,247,264,215,261,251,292,404,287,269,319,214,
 231,281,245,228,235,278,325,496,455,458,493,477,543,522,
 485,427,561,473,525,465,557,512,478,462,459,559,523,516,
 431,553,463,870,796,670,742,871,669,718,837,826,1303,891,
 1237,1343,907,1457,1530,1186,1396,1393,2130,2018,1386,3602,
 2519,3088,2700,3165,2671,2851,5701,5158],
 [16,37,41,19,40,58,67,50,97,82,105,69,88,66,83,64,108,74,
 102,84,103,56,72,54,96,60,91,93,98,62,68,52,57,315,208,
 193,322,212,243,216,221,276,203,277,200,217,207,213,254,
 319,308,311,299,290,258,220,209,187,325,644,700,630,793,
 696,804,759,674,707,712,697,665,705,636,816,684,810,694,
 747,728,802,861,817,693,717,723,664,2109,1995,2410,2357,
 2479,2071,1793,2032,2091,2284,2467,2657,2416,2092,2175,1784,
 4725,8927,5327,7858],
 [16,39,37,27,42,41,35,19,40,30,21,13,25,58,67,50,55,63,
 56,65,70,81,282,289,372,541,352,336,347,521,344,346,476,
 433,409,423,491,317,371,472,303,464,490,515,451,549,511,
 533,524,450,626,617,507,488,544,519,563,494,452,623,605,
 529,498,480,2449,1433,954,2393,973,842,2414,982,1047,1177,
 1146,1031,1125,1241,1179,1058,1138,2223,1972,1437,2374,2026,
 2256,1402,2311,1977,2221,1408,2392,2646,2683,2685],
 [16,41,19,40,30,58,67,50,61,97,100,79,94,69,85,92,66,104,
 108,74,102,107,63,103,56,72,54,78,96,60,75,65,87,86,70,
 93,99,81,49,57,186,300,272,298,304,322,350,331,244,230,
 292,202,287,269,213,254,319,308,311,214,246,228,239,357,
 335,722,866,772,930,715,812,751,869,1308,3725,3501],
 [16,41,40,30,13,58,67,50,61,79,94,105,77,71,64,63,84,54,
 78,96,91,70,106,93,289,394,375,336,409,327,186,208,291,
 304,351,212,404,202,277,238,254,328,231,330,348,325,451,
 501,614,624,416,513,450,506,608,625,413,487,590,581,452,
 517,621,638,396,499,577,587,644,692,764,1062,950,668,707,
 1023,665,672,728,1040,892,671,725,717,932,1407,1726,1496,
 1658,1504,1748,907,1146,1335,1362,2108,2113,981,1076,1119,
 1125,1095,1345,946,1161,1405,1223,2054,2005,931,1058,1214,
 1203,1060,1090,1080,1215,2459,2285,2314,2347,2159,2229,1210,
 1283,1195,1226,1176,1259,3545,6041,3590,5319],
 [17,19,30,58,51,67,50,61,82,79,94,105,85,66,59,71,104,64,
 108,74,102,73,107,63,56,54,78,96,75,87,90,91,70,99,49,
 68,52,289,394,492,375,360,336,429,520,332,363,409,419,
 484,236,272,307,261,292,269,267,228,278,537,441,536,531,
 509,522,540,447,473,504,483,512,548,470,523,497,468,463,
 1478,1471,1472],
 [17,19,30,58,51,67,50,61,82,79,94,105,85,89,66,59,77,104,
 64,108,74,102,107,56,54,78,96,75,87,90,91,70,93,49,68,
 52,289,394,492,375,360,429,520,332,363,409,419,484,327,
 236,272,248,215,261,292,269,226,245,228,278,441,570,536,
 509,543,522,447,561,473,483,557,512,470,559,523,468,553,
 463,1404,1303,1237],
 [17,19,30,58,51,67,50,61,82,79,94,105,85,89,77,71,104,64,
 108,74,102,73,107,63,56,54,78,96,75,87,90,93,99,49,52,
 289,394,492,375,336,429,520,332,363,409,327,236,272,261,
 292,437,269,228,278,357,397,455,441,536,453,477,509,522,
 412,427,447,473,448,465,483,512,417,459,470,523,454,431,
 468,463,837,1726,2451,826,1658,2438,891,1748,2406],
 [17,19,30,58,51,67,50,61,82,79,94,105,88,77,71,104,64,
 108,74,102,73,63,84,56,54,78,96,75,87,90,93,98,49,68,
 52,289,394,492,375,336,429,520,332,363,409,419,484,236,
 259,307,264,276,217,267,281,209,397,455,441,536,453,477,
 509,522,412,427,447,473,448,465,483,512,417,459,470,523,
 454,431,468,463,837,1478,826,1471,891,1472],
 [17,19,30,58,51,67,50,61,82,79,94,105,88,89,66,59,71,104,
 64,108,74,102,84,56,54,78,96,75,87,90,91,70,98,49,68,
 52,289,394,492,375,360,429,520,332,363,409,419,484,327,
 236,259,248,264,215,276,217,226,281,245,209,537,441,536,
 531,509,522,540,447,473,504,483,512,548,470,523,497,468,
 463,1404,1303,1237],
 [17,19,30,58,67,61,82,79,105,85,66,59,77,71,104,102,107,
 56,54,96,75,87,91,70,93,99,289,394,492,375,360,336,332,
 363,409,419,484,327,334,324,272,307,318,436,406,267,262,
 228,323,495,441,536,594,614,622,596,583,609,602,503,579,
 608,607,582,586,620,590,532,470,523,595,621,613,593,576,
 577,719,722,778,1347,715,795,1308,1752,1800,3836,1770,1759,
 4506,1755,1767,3814,1143,948,1335,1362,850,1304,936,1095,
 1345,952,1405,1254,856,1214,1203,860,1080,2376,2745,1838,
 2437,3809,1779,2358,4178,1775,2116,4170,2618,3422,3000,2698,
 3285,3101,3800,3769,3099],
 [17,19,30,58,67,61,82,79,105,85,88,66,59,77,71,104,64,74,
 102,107,84,56,54,96,75,87,91,70,93,99,98,49,52,471,340,
 289,316,394,492,381,375,389,407,370,360,475,402,336,345,
 429,520,366,332,392,313,362,363,542,411,409,377,419,484,
 368,327,338,354,249,236],
 [17,19,30,58,67,61,82,79,105,88,66,59,77,71,64,74,102,84,
 56,54,96,75,87,91,70,93,49,52,471,340,316,381,370,475,
 402,366,362,542,411,377,368,249,279,259,298,255,243,294,
 213,246,281,305,290,430,451,441,536,556,567,549,598,466,
 450,527,528,544,581,478,452,470,523,568,555,480,587,761,
 764,703,1023,728,725,932,1371,1331,1314,1073,948,1667,1335,
 850,1304,936,1538,1095,952,1405,1224,856,1570,1214,860,
 1080,2469,2457,1838,2437,1779,2358,1775,2116,2986,2871,3327,
 2978,2666,3222,3381,3909,3680],
 [17,19,30,58,67,61,82,79,105,88,66,59,77,71,104,102,84,
 56,54,96,75,87,91,70,93,98,289,394,492,375,360,336,429,
 520,363,409,419,484,327,334,324,259,307,280,318,276,267,
 262,281,323,495,441,536,594,614,622,596,583,609,602,503,
 447,473,579,608,586,620,590,532,470,523,595,621,613,593,
 576,577,764,703,1023,728,939,920,725,932,1407,3836,1496,
 4506,1504,3814,1143,948,1335,850,1304,1231,936,1095,952,
 1405,1254,856,1214,860,1080,2257,2215,2123,2078,3077,4230,
 3809,2852,4078,4178,2785,3879,4170,2618,3422,3000,2698,3285,
 3101],
 [17,19,30,58,67,61,97,82,79,105,69,85,92,66,59,71,104,64,
 74,101,102,107,103,56,54,96,60,75,65,87,91,86,70,99,49,
 52,57,471,340,316,381,370,475,402,345,366,362,542,411,
 377,249,272,298,261,292,269,213,228,278,537,441,536,531,
 509,522,540,447,473,504,483,512,548,470,523,497,468,463,
 1797,1564,1612],
 [17,19,30,58,67,61,97,82,79,105,69,85,92,66,76,59,77,104,
 64,74,101,102,107,56,54,96,60,75,65,87,91,86,70,93,49,
 52,57,471,340,316,381,370,345,366,362,542,411,377,368,
 249,272,261,302,292,269,228,321,278,441,570,536,509,543,
 522,447,561,473,483,557,512,470,559,523,468,553,463,2145,
 1436,2197,1450,2127,1315],
 [17,19,30,58,67,61,97,82,79,105,69,85,92,76,77,71,104,64,
 74,101,102,107,103,56,54,96,60,75,65,87,86,93,99,49,52,
 471,340,316,381,475,402,345,366,362,542,411,368,249,272,
 261,292,386,269,228,278,343,397,455,441,536,453,477,509,
 522,412,427,447,473,448,465,483,512,417,459,470,523,454,
 431,468,463,818,985,831,978,934,1451],
 [17,19,30,58,67,61,97,82,79,105,69,92,88,66,76,59,71,104,
 64,74,101,102,84,56,54,96,60,75,65,87,91,86,70,98,49,
 52,57,471,340,316,381,370,345,366,362,542,411,377,368,
 249,259,264,302,276,217,281,321,209,537,441,536,531,509,
 522,540,447,473,504,483,512,548,470,523,497,468,463,2145,
 1436,2197,1450,2127,1315],
 [17,19,30,58,67,61,97,82,79,105,69,92,88,77,71,104,64,74,
 101,102,84,103,56,54,96,60,75,65,87,86,93,98,49,52,57,
 471,340,316,381,475,402,345,366,362,542,411,377,249,259,
 298,264,276,217,213,281,209,397,455,441,536,453,477,509,
 522,412,427,447,473,448,465,483,512,417,459,470,523,454,
 431,468,463,818,1797,831,1564,934,1612],
 [17,19,51,67,61,82,105,92,88,89,66,59,71,104,83,64,74,73,
 84,56,78,75,87,91,98,62,49,52,394,360,429,332,363,419,
 236,342,324,234,359,280,247,264,215,329,243,270,221,201,
 437,388,406,253,217,231,245,349,290,192,209,357,482,467,
 531,522,545,479,485,528,449,504,512,555,442,497,463,644,
 668,1400,733,707,665,671,1424,760,717,872,961,971,827,905,
 907,1020,981,969,1119,1017,946,885,931,1019,1060,1109,1990,
 2407,2139,2441,1386,1503,1677,1627,1501,1572,1637,1529,1464,
 1598,1746,1631,4023,3853,1919,1920,1914],
 [17,19,58,67,61,82,79,85,66,76,59,77,71,104,64,74,102,
 107,56,54,60,75,65,87,91,70,93,99,49,52,471,340,316,
 432,370,475,402,345,366,355,362,542,411,377,368,283,249,
 222,240,261,302,216,386,269,246,321,258,278,343,482,490,
 554,509,522,545,533,507,483,512,550,563,529,468,463,870,
 761,1107,974,809,845,914,1075,941,1330,1012,1172,1102,907,
 993,981,1251,1119,1100,946,1038,931,1159,1060,2469,2418,
 2363,2559,2562,5393,5324],
 [17,19,58,67,61,82,79,88,66,76,59,77,71,104,64,74,102,84,
 56,54,60,75,65,87,91,70,93,98,49,52,471,340,316,381,
 432,370,475,402,345,366,355,362,377,368,283,249,222,240,
 264,302,216,386,223,217,207,246,321,209,343,482,490,554,
 509,522,545,533,507,483,512,563,529,468,463,644,761,668,
 707,665,747,671,717,645,1558,1660,1266,1818,1286,1605,1102,
 907,993,981,1251,1119,1100,946,1038,931,1159,1060,1889,
 2041,1677,1637,1746],
 [17,27,35,19,25,51,61,82,85,88,66,104,83,74,84,103,56,54,
 96,65,91,99,98,62,52,316,389,392,362,377,338,249,356,
 279,193,300,240,248,264,212,251,203,404,294,200,287,207,
 319,308,311,214,226,281,306,235,187,325,588,575,500,455,
 580,585,489,427,505,465,599,584,532,502,431,796,696,804,
 720,750,635,871,684,810,710,861,769,628,818,831,1050,1139,
 1011,1064,1059,1078,1082,1026,1094,967,1124,1092,999,1005,
 2479,2657,1194,1258,1110,1167,1184,1222,1117,1199,1242,1292,
 1185,1233,2320,2370,2343],
 [17,31,19,13,25,58,51,67,50,61,97,82,79,94,105,69,85,88,
 89,66,76,59,77,53,71,55,104,83,64,74,102,73,107,63,84,
 103,56,54,78,96,60,75,87,90,91,86,70,93,80,99,81,98,
 62,49,52],
 [17,31,19,13,58,51,79,94,85,88,77,53,104,102,73,107,54,
 87,98,62,49,52,407,402,332,363,411,354,236,315,350,227,
 318,270,206,251,201,276,434,383,260,214,299,235,192,209,
 455,567,526,533,466,485,427,528,474,465,563,478,555,535,
 516,431,1378,935,720,893,845,873,919,704,843,710,918,736,
 798,872,698,3484,837,3575,827,826,3624,998,1229,1079,1305,
 1114,1399,1446,1206,1419,1119,1377,1257,1512,1443,1182,1034,
 1070,1317,1261,1369,1204,1170,2216,3663,2651,2129,2024,3160,
 3473,2849,2239,2076,1853,1258,1167,2135,1883,1222,1199,2121,
 1846,1292,1233,3951,3974,3033,4434,3053,3355,4224,3340,4814,
 3215,4218,3841,3213,3105,4701,3265,3115,3200,4008,2670,3177,
 4013,3710,1973,2238,2060,2246,2006,2165,3850,4148,3257,2679,
 2599,3129,2710,3356,2528,2513,3282,2706,3205,2905,2590,3241,
 2633,8480,7825,7446,8893,7794,7265,8600,7503,6390,7683,5121,
 7405,7038,6992,6381,5636,5671,4989,7468,6963,7176,7273,6226,
 7930,7543,6598,7169,6745,6481,6402],
 [17,31,19,25,58,51,67,85,59,104,83,64,107,103,56,75,87,
 86,70,62,49,52,340,407,370,345,313,411,249,315,279,186,
 272,247,248,276,292,383,294,202,287,223,213,250,228,209,
 467,495,537,441,518,453,479,540,447,449,538,505,448,548,
 470,442,815,959,630,876,778,746,847,895,1048,636,684,715,
 763,882,1308,985,1327,943,978,1427,906,1341,1403,1426,1305,
 1114,1294,850,1171,1290,1377,1257,1512,1443,1094,1217,952,
 1274,1209,1261,1369,1284,860,2111,2455,3725,2444,3034,2070,
 2411,3501,2912,1503,1627,1583,1513,1572,1529,1745,1561,1598,
 1631,1497,1551,3079,4213,4469,3052,4515,4169,3998,3592,4516,
 4258,3236,3259,3921,4436,3336,3021,3976,3807,2700,4266,4251,
 3408,2769,1966,1812,2020,1845,1985,1826,3539,3508,3114,3096,
 3969,3345,3679,3430,3733,4055,3116,3048,3229,3628,3770,3703,
 3727,9406,9390,9110,9102,8432,6959,8775,6359,7816,6741,8169,
 6465,6707,8891,7609,6573,6561,7360,8159,9399,8008,7332,6253,
 7951,8324,6580,6522,6315,6174,7018],
 [17,31,19,58,51,50,61,79,85,88,89,66,59,77,53,104,108,74,
 102,73,107,63,84,54,87,70,93,80,99,98,62,49,68,52,407,
 360,332,313,363,327,354,236,350,229,244,434,260,214,299,
 273,239,567,526,547,554,458,528,474,538,563,478,555,535,
 539,529,456,1378,1112,794,866,893,1488,918,776,812,947,
 998,1229,1079,1277,1205,1234,1267,1338,1196,1206,1419,1208,
 1355,1106,1361,1070,1317,1273,1264,1166,1349,1363,1235,2076,
 1853,1849,1854,1574,2135,1883,1832,1863,2121,1846,1493,1890,
 1859,1973,2060,2006],
 [17,31,19,58,51,50,61,79,85,88,89,66,59,104,108,74,102,
 73,107,63,84,54,87,70,93,80,99,98,62,49,68,52,407,360,
 332,313,363,327,354,236,322,359,350,229,244,270,206,434,
 260,214,299,273,239,567,526,547,554,458,503,533,466,528,
 474,532,563,478,555,535,539,529,456,1378,1112,823,1400,
 893,1488,918,923,1424,947,827,998,1229,1079,1205,1234,1206,
 1419,1355,1106,1070,1317,1349,1363,1856,2076,1853,1751,1849,
 1854,1932,2135,1883,1747,1832,1863,1843,2121,1846,1780,1890,
 1859,1973,2060,2006],
 [17,31,19,58,51,61,79,85,59,104,74,102,73,107,54,87,70,
 99,62,49,52,360,332,363,236,272,307,291,350,229,244,261,
 292,434,406,269,267,238,260,214,262,228,299,235,192,278,
 536,567,526,554,458,522,609,473,582,528,474,512,620,563,
 478,523,555,535,516,463,615,1378,719,1112,887,716,893,
 1488,1781,709,918,874,745,947,798,998,1229,1079,1143,958,
 1205,1234,1267,1392,1020,993,1216,937,1206,1419,1231,1018,
 1355,1106,1361,1087,910,1070,1317,1415,885,1038,1254,1009,
 1349,1363,1235,1005,1168,886,6060,2473,5096,2066,2076,1853,
 1678,1460,1849,1854,1728,1412,2135,1883,1734,1447,1832,1863,
 1641,1411,2121,1846,2295,1644,1441,1890,1859,1802,1414,4738,
 4235,2647,2149,4639,4643,3503,2501,2128,4626,1973,4833,2060,
 4863,2006,4551,3049,3352,2755,3009,3080,3560,2899,3334,2734,
 3122,2783,3264,2856,3137,2697,3013,3219,3704,2803,3209,2607,
 3587,2863,3161,8503,9133,8088,5630,8094,5626,8361,5246,8729,
 4945,8038,5066,6217,5748,7880,5201,9381,5548],
 [17,31,19,58,51,61,79,85,59,104,83,64,74,107,54,87,70,99,
 62,49,52,370,345,362,249,356,279,186,272,350,230,247,248,
 329,255,212,203,292,434,308,231,226,228,349,305,299,575,
 495,537,441,596,518,453,598,585,540,447,473,582,581,584,
 514,417,548,470,593,587,630,722,1084,754,778,674,1246,
 1347,715,1101,741,795,693,1308,985,1287,1035,907,1073,1219,
 948,1338,1196,1052,933,881,1294,850,1187,988,1155,1332,936,
 1366,1136,1217,952,1264,1166,1065,984,1027,1224,1269,856,
 1252,1046,1284,860,2206,4098,2296,3588,1549,1579,1653,1410,
 1740,1648,1620,1583,1513,1481,1628,1462,1387,1714,1624,1745,
 1561,1576,1584,1580,1382,1702,1682,1497,1551,2986,2447,3088,
 2871,3327,2978,2340,3165,2666,3222,5037,1812,6064,1845,5680,
 1826,3922,2644,3193,2678,5468,2615,3604,2916,4580,2774,2782,
 2604,5013,2610,2946,2886,4045,2665,3702,2687,5234,2738,2971,
 2842,7069,8063,6924,8582,8699,7383,5406,4564,5061,6304,5128,
 4859,4979,4703,5283,5785,5697,4395],
 [17,31,19,58,51,61,79,85,88,89,66,59,104,108,74,102,73,
 107,84,54,78,87,70,99,98,62,49,52,407,360,332,313,363,
 354,236,324,234,350,229,244,215,437,434,406,253,260,214,
 299,273,239,235,192,357,567,526,554,458,528,474,563,478,
 555,535,529,456,516,1378,1112,794,866,887,716,893,1488,
 918,874,745,947,723,998,1229,1079,1205,1234,1338,1196,1392,
 1020,993,1206,1419,1355,1106,1070,1317,1415,885,1038,1349,
 1363,1019,1159,2247,2956,2977,3029,3054,2076,1853,1849,1854,
 1574,2135,1883,1832,1863,2121,1846,1890,1859,2778,2482,5478,
 4295,5475,4496,1973,2060,2006,5524,8936,3049,3352,3080,3560,
 3372,2734,3122,2856,3137,3219,3704,3474,2607,3587,6991,9170,
 6840,7931],
 [17,31,19,58,51,61,79,94,85,88,89,66,59,77,53,104,74,102,
 73,107,63,84,54,78,70,93,80,99,98,62,49,68,52,407,360,
 332,313,363,327,354,236,350,229,244,280,266,270,206,434,
 406,260,214,262,299,306,273,239,567,526,554,458,533,466,
 528,474,563,478,555,535,529,456,1378,1768,1112,893,1488,
 1781,918,947,827,998,1229,1079,1205,1234,1206,1419,1355,
 1106,1070,1317,1349,1363,2076,1853,1849,1854,2135,1883,1832,
 1863,2121,1846,1890,1859,1973,2060,2006],
 [17,31,19,58,51,67,61,79,85,76,59,71,104,83,64,74,101,
 107,54,96,60,75,87,70,99,62,49,52,340,370,402,345,362,
 411,249,279,186,300,222,272,247,248,216,203,292,386,311,
 231,226,228,258,187,343,495,500,397,537,441,518,453,540,
 447,514,417,548,470,804,722,1084,754,778,1347,715,1101,
 741,940,1021,795,1308,985,1091,1055,1219,948,1052,933,881,
 1294,850,1332,936,1217,952,1065,984,1027,1254,1009,1269,
 856,1284,860,2952,3012,3044,2797,2747,1653,1410,1583,1513,
 1462,1387,1745,1561,2016,1580,1382,1497,1551,2618,3972,2698,
 3875,2487,3299,1812,1845,1826,5864,5981,3193,2678,2601,3604,
 2916,2782,2604,2946,2886,2878,3702,2687,2971,2842,5057,9099,
 5840,8506],
 [17,31,19,58,51,67,61,88,59,71,104,83,64,102,73,84,54,75,
 87,98,62,49,52,340,316,345,377,249,279,186,193,259,227,
 264,329,255,221,276,203,294,202,200,217,250,246,281,220,
 209,187,490,430,500,397,537,441,536,518,453,531,509,585,
 489,412,540,447,473,505,448,504,483,514,417,548,470,523,
 502,454,497,468,587,630,761,864,807,636,747,829,787,818,
 1436,831,1450,934,1315,1091,1055,1073,1052,933,1316,1187,
 988,1082,1156,951,1155,1126,1130,1067,1065,984,1224,1005,
 1154,917,1109,2171,2468,1678,1460,2225,1956,2254,1734,1447,
 2301,2100,2236,1644,1441,2015,2826,2447,3652,3675,2329,2929,
 2340,3470,3225,2331,3857,3629,4439,4159,3390,4530],
 [17,31,19,58,51,67,61,88,76,59,71,104,83,64,101,102,73,
 84,54,96,60,75,87,98,62,49,52,340,316,345,411,377,249,
 279,186,193,300,222,259,227,264,216,221,276,203,294,202,
 200,287,223,217,311,250,281,220,209,187,343,500,397,537,
 441,518,453,531,509,489,412,540,447,505,448,504,483,514,
 417,548,470,502,454,497,468,804,1291,662,810,1346,645,818,
 1436,831,1450,934,1315,1091,1055,1052,933,1156,951,1126,
 1130,1065,984,1154,917,2171,2225,1956,2301,2100,2015],
 [17,31,19,58,51,67,61,97,82,79,85,59,71,55,104,83,64,74,
 101,107,54,96,60,75,87,70,99,81,62,49,52,57,340,316,
 370,402,345,362,411,249,300,222,272,247,248,292,287,223,
 231,226,228,321,330,500,397,496,537,441,518,453,493,540,
 447,505,448,525,514,417,462,548,470,722,814,1062,778,1347,
 715,757,1040,795,1308,985,978,1219,948,1294,850,1332,936,
 1217,952,1269,856,1284,860,1653,1410,1656,1583,1513,1727,
 1462,1387,1606,1745,1561,1753,1580,1382,1611,1497,1551,1712,
 1812,1845,1826],
 [17,31,19,58,51,67,61,97,82,85,59,71,104,83,64,74,101,
 107,103,56,54,96,60,75,87,86,70,99,62,49,52,57,340,316,
 370,402,345,362,411,249,193,300,222,272,298,247,248,292,
 200,287,223,231,226,228,500,397,537,441,536,518,453,540,
 447,473,505,448,514,417,548,470,523,722,778,912,1347,715,
 795,1122,1308,985,978,1219,948,1335,1294,850,1304,1332,936,
 1095,1217,952,1405,1269,856,1214,1284,860,1080,1653,1410,
 1583,1513,1462,1387,1745,1561,1580,1382,1497,1551,1812,1845,
 1826],
 [17,31,19,58,51,67,61,97,82,88,76,59,71,104,83,64,101,
 102,73,84,54,96,60,75,87,86,98,62,49,52,57,340,316,345,
 411,377,249,193,300,222,259,227,264,302,310,221,276,200,
 287,223,217,250,281,321,330,220,209,500,397,537,441,536,
 518,453,531,509,522,609,489,412,540,447,473,505,448,504,
 483,512,514,417,548,470,523,600,502,454,497,468,463,818,
 1436,831,1450,934,1315],
 [17,31,19,58,51,67,61,97,82,105,69,88,59,71,55,104,83,64,
 101,102,73,84,103,56,54,96,60,75,87,86,98,62,49,52,57,
 340,316,345,362,411,377,249,193,259,298,227,264,221,276,
 203,200,217,213,250,281,220,209,187,500,397,537,441,518,
 453,531,509,489,412,540,447,505,448,504,483,514,417,548,
 470,502,454,497,468,818,1436,831,1450,934,1315],
 [17,31,19,58,51,67,61,97,82,105,69,88,59,71,55,104,83,64,
 102,73,84,103,56,54,96,60,75,87,98,62,49,52,57,340,316,
 345,362,411,377,249,193,259,227,230,264,221,276,203,200,
 217,250,246,281,220,209,187,500,397,496,537,441,518,453,
 493,531,509,489,412,485,540,447,505,448,525,504,483,514,
 417,462,548,470,502,454,516,497,468,818,1436,831,1450,934,
 1315],
 [17,31,19,67,50,79,94,85,88,89,66,59,71,83,64,108,74,102,
 73,107,63,84,54,78,75,70,93,80,99,98,62,49,68,52,375,
 407,360,332,313,327,354,236,342,334,315,322,359,266,270,
 206,388,436,319,295,303,482,464,490,430,567,526,533,466,
 528,474,550,519,563,478,752,800,697,919,704,694,903,664,
 872,698,758,740,1305,1114,1190,1173,1377,1257,1182,1034,
 1274,1209,1204,1170,1674,1560,1563,1528,1721,1553,1474,1531,
 1659,1589,1604,1479,1943,1949,2000],
 [17,31,19,67,61,79,85,76,59,71,55,104,83,64,74,101,107,
 54,75,87,86,70,99,81,62,49,52,340,370,402,345,362,411,
 249,342,334,279,186,300,222,272,247,248,302,310,329,255,
 292,386,388,436,294,202,287,223,231,226,228,321,330,349,
 305,495,500,397,537,441,518,453,540,447,538,505,448,514,
 417,548,470,722,778,1347,1670,715,795,1308,1500,985,978,
 1219,948,1294,850,1332,936,1217,952,1269,856,1284,860,1653,
 1410,1583,1513,1462,1387,1745,1561,1580,1382,1497,1551,1812,
 1845,1826],
 [17,31,19,67,79,85,88,59,71,83,64,74,102,73,107,84,54,75,
 70,99,98,62,49,52,375,407,332,313,327,354,236,342,334,
 324,315,307,291,280,266,251,201,388,436,406,267,238,303,
 235,192,482,464,490,430,624,596,518,453,533,466,582,528,
 474,505,448,581,563,478,593,502,454,615,752,800,733,873,
 697,694,903,798,664,740,1277,905,1102,1305,1114,2103,1190,
 1173,969,1251,1377,1257,1361,1182,1034,2203,885,1038,1274,
 1209,1204,1170,2234,2390,1386,1581,1674,1560,1563,1528,1501,
 1642,1721,1553,2047,1474,1531,1464,1617,1659,1589,1604,1479,
 2245,2115,3089,2105,2606,2051,2339,3346,2043,3263,2128,2179,
 2498,2266,3688,2825,1943,2726,1949,2823,2000,3239,3280,2575,
 2791,2671,2876,3288,3734,3316,2544,3705,3002,2875,2955,3064,
 2851,2545,3059,3018,2813,4099,5888,5207,5595,5774,5534,5262,
 4342,4857,4503,4368,4908,4840,7670,7903,6185,7732,7292,6204]
  ,[17,31,19,67,79,85,88,89,66,59,71,83,64,108,74,102,73,
 107,84,54,78,75,70,99,98,62,49,52,375,407,360,332,313,
 327,354,236,342,334,315,215,266,270,206,251,201,437,388,
 436,406,253,303,273,239,235,192,357,482,464,490,430,533,
 466,528,474,563,478,1768,877,752,800,712,697,1781,694,903,
 723,664,740,905,1102,1305,1114,1190,1173,969,1251,1377,
 1257,1182,1034,885,1038,1274,1209,1204,1170,3258,3878,1386,
 1581,1674,1560,1563,1528,1501,1642,1721,1553,1474,1531,1464,
 1617,1659,1589,1604,1479,2115,3089,2105,2606,2339,3346,2043,
 3263,2179,2498,2266,3688,2825,1943,2726,1949,2823,2000,3280,
 2575,2671,2876,3316,2544,3002,2875,2851,2545,3018,2813],
 [17,31,19,67,79,85,88,89,66,59,83,64,108,74,102,73,107,
 63,84,54,75,90,91,70,93,80,99,98,62,49,68,52,375,407,
 360,332,313,327,354,236,342,334,324,315,322,359,350,266,
 388,436,319,295,308,303,482,464,495,490,430,567,526,503,
 533,466,528,474,550,519,532,563,478,752,983,800,697,694,
 920,903,664,758,740,1011,1305,1114,881,1190,1173,1024,1377,
 1257,967,1182,1034,1027,1274,1209,911,1204,1170,1674,1560,
 1563,1528,1721,1553,1474,1531,1659,1589,1604,1479,1943,1949,
 2000],
 [17,31,19,67,79,85,88,89,66,71,83,64,74,102,73,107,63,84,
 54,75,90,91,70,93,80,99,98,62,49,68,52,375,407,360,332,
 313,327,354,236,342,334,324,315,304,322,359,266,388,436,
 406,254,319,295,303,262,482,464,495,490,430,567,526,547,
 533,466,528,474,538,550,519,532,563,478,752,719,800,697,
 694,709,903,664,758,740,1305,1114,1190,1173,1377,1257,1182,
 1034,1274,1209,1204,1170,1674,1560,1941,1563,1528,1860,1721,
 1553,2204,1474,1531,1783,1659,1589,2016,1604,1479,1896,1943,
 1949,2000],
 [17,31,19,71,84,98,62,49,52,249,236,315,227,212,266,388,
 436,434,303,260,214,250,495,490,430,518,453,493,503,533,
 466,582,528,474,449,532,563,478,514,417,462,1482,2045,
 1378,644,870,692,739,764,800,703,778,746,847,707,1023,
 1661,1963,1488,694,843,710,672,724,728,671,725,795,628,
 664,932,943,740,934,891,1539,1229,1079,857,1177,905,1102,
 907,1044,1219,948,1335,881,1190,1173,1162,1294,850,1304,
 1031,969,1251,1119,1121,1332,936,1095,1532,1355,1106,926,
 967,1182,1034,986,1217,952,1405,1179,885,1038,931,1201,
 1269,856,1214,911,1204,1170,1036,1284,860,1080,2109,2271,
 1950,2140,2285,2258,2029,2130,1793,2084,2134,2351,2032,2137,
 1976,2133,2159,2057,1895,2018,1784,1969,2274,2332,1549,1579,
 1429,2158,1386,1581,1503,1653,1410,1656,2380,1563,1528,1820,
 1583,1513,1727,2318,1501,1642,1572,1462,1387,1606,1714,1624,
 1515,1999,1474,1531,1739,1745,1561,1753,2295,1464,1617,1598,
 1580,1382,1611,2095,1604,1479,1814,1497,1551,1712,2245,2540,
 3333,2847,2115,3089,2961,2149,2549,3294,2756,2105,2606,3088,
 2051,2598,2965,3019,2339,3346,3841,2322,2527,2910,3040,2043,
 3263,2854,2128,2409,2860,3269,2179,2498,3165,2131,2663,2831,
 3351,2266,3688,3710,5047,3775,1966,2825,4414,4198,4308,1943,
 2020,2726,4559,3897,4555,1949,1985,2823,4344,3848,6032,2000,
 3964,2518,2903,2571,3969,3280,2575,3466,4040,2844,4176,2820,
 4765,2671,2876,3428,4114,2874,3480,2730,4055,3316,2544,3987,
 3885,2561,2789,2520,4509,3002,2875,3325,4001,2689,3338,2751,
 3770,2851,2545,4035,3782,2766,3523,2834,4792,3018,2813,3574,
 5318,4333,3584,4593,4622,4852,5613,5606,3496,4527,4358,4070,
 5446,4389,3540,4893,4809,4269,5546,5872,3697,4895,4850,4200,
 5438,4623,3392,4650,4565,4869,4992,5355,3531,4292,4534,3967,
 5591,4390,5565,5030,5555,4309,5115,5236,6009,4817,5504,5955]
  ,[17,31,30,58,51,61,79,105,85,66,95,77,74,102,73,107,
 84,96,70,93,99,375,332,313,327,356,307,350,310,293,318,
 212,206,288,434,406,254,308,330,323,299,239,301,335,482,
 596,567,583,598,545,466,506,582,528,505,586,581,550,593,
 555,456,499,576,587,1768,793,930,859,762,1781,816,869,785,
 975,1079,1277,995,1003,1234,1267,1104,1134,850,1081,1922,
 1419,1208,1251,1125,1098,1955,1025,1106,1361,1071,1074,952,
 1223,2203,1317,1273,1061,1066,1363,1235,1159,1090,1140,1937,
 1051,860,1215,2382,2602,2397,1853,1495,1210,1180,1854,1585,
 1283,1244,2106,1883,1743,1195,1141,1184,1863,1469,1226,1163,
 2342,1846,1594,1176,1132,1859,1666,1259,1202,2090,4469,3130,
 9076,4169,3151,8405,4258,2944,4936,4436,3207,5334,3807,3149,
 8968,4251,2925,5150,8763,2072,7327,2027,7050,2049,3352,3055,
 5369,3639,2732,3551,6048,3560,3607,5920,4166,3179,3437,8610,
 2996,3122,3045,4312,3729,2805,3673,5731,3137,2829,5203,3712,
 3226,3218,6483,3994,3704,3610,5535,3948,2804,4059,6763,3587,
 3324,4702,3447,3206,3098,6917,4231,8230,8686,8749,6772,9161,
 7144,8533,9019,7571,8253,7351,6459],
 [17,31,30,58,51,67,50,61,79,85,89,66,95,77,53,71,104,108,
 74,102,73,107,63,84,56,78,96,75,70,93,80,99,98,289,336,
 332,313,409,327,354,186,234,300,293,270,206,288,202,253,
 287,254,273,239,301,357,335,430,501,496,583,598,466,506,
 426,487,525,586,581,456,499,576,587,793,772,930,762,816,
 751,869,785,777,975,995,1003,1104,1134,1098,1025,1071,1074,
 1061,1066,1140,1051,1210,1180,1283,1244,1195,1141,1226,1163,
 1176,1132,1259,1202,2072,2027,2049],
 [17,31,30,58,51,67,50,61,79,105,85,89,66,95,77,71,74,102,
 73,107,63,84,56,78,96,75,90,70,93,80,99,98,68,289,375,
 336,332,313,409,327,354,186,234,293,206,288,202,253,254,
 295,303,262,239,301,335,430,501,583,598,466,506,426,487,
 586,581,456,499,576,587,793,784,752,719,930,762,816,765,
 694,709,869,785,777,975,995,1003,1104,1134,1098,1025,1071,
 1074,1061,1066,1140,1051,1210,1180,1283,1244,1195,1141,1226,
 1163,1176,1132,1259,1202,2072,2027,2049],
 [17,31,30,58,51,67,50,61,105,85,66,95,77,53,71,104,74,
 102,73,107,63,84,96,75,70,93,80,99,98,289,375,336,332,
 313,409,327,354,186,193,234,310,293,318,206,288,202,200,
 253,254,239,301,335,430,501,500,583,609,598,466,506,489,
 426,487,505,586,620,581,456,499,502,576,615,587,793,930,
 808,762,873,816,869,799,785,798,777,975,995,1870,1003,
 1104,1861,1134,1098,1955,1025,1071,1897,1074,1061,1819,1066,
 1140,1937,1051,1210,1180,1194,1283,1244,1110,1195,1141,1184,
 1226,1163,1117,1176,1132,1242,1259,1202,1185,2072,2027,2049]
  ,[17,31,30,58,51,67,61,79,105,85,89,66,95,77,71,108,74,
 102,73,107,84,96,75,70,93,80,99,98,289,375,336,332,313,
 409,327,354,324,186,234,359,320,215,310,293,318,270,206,
 288,437,406,202,253,254,295,303,273,239,301,335,430,501,
 583,598,466,506,426,487,586,581,456,499,576,587,793,930,
 712,808,762,873,816,869,723,799,785,798,1379,777,975,995,
 1003,1104,1134,1098,1025,1071,1074,1061,1066,1140,1051,3446,
 3616,1210,1180,1283,1244,1195,1141,1226,1163,1176,1132,1259,
 1202,2072,2027,2049],
 [17,31,30,58,67,79,105,66,76,59,95,77,71,64,74,101,102,
 73,84,54,96,75,91,70,106,93,81,52,340,381,370,402,366,
 411,368,334,315,331,264,302,255,266,216,404,386,436,383,
 294,223,217,269,311,321,305,306,209,325,343,464,495,509,
 549,511,503,618,474,538,483,544,535,539,468,480,615,1318,
 959,644,870,668,707,1340,1048,665,914,671,717,645,943,906,
 1102,1146,993,1076,1251,1125,1100,1161,1038,1058,1159,1090,
 1889,2041,1581,1697,1567,1683,1642,1687,1514,1698,1617,1696,
 1557,1711,1966,2020,1985],
 [17,31,30,58,67,79,105,69,88,66,76,59,95,77,71,55,64,74,
 101,102,73,84,103,54,75,91,86,70,106,93,49,52,57,340,
 381,370,402,366,368,249,334,315,279,264,329,255,266,436,
 383,294,217,349,305,306,209,187,464,495,509,549,585,511,
 503,474,538,483,544,593,535,539,468,480,644,668,737,707,
 665,671,755,717,943,906,1102,1146,993,1076,1251,1125,1100,
 1161,1038,1058,1159,1090,1581,1697,1567,1683,1642,1687,1514,
 1698,1617,1696,1557,1711,1966,2020,1985],
 [17,31,30,58,67,97,79,105,69,88,66,76,59,95,77,71,55,64,
 74,101,102,73,84,96,75,91,70,106,93,81,49,52,57,340,
 381,370,402,366,411,368,249,334,315,264,302,293,255,266,
 216,436,383,217,358,305,306,258,209,464,495,509,549,511,
 503,474,538,483,544,535,539,468,480,644,668,707,695,665,
 671,717,753,943,906,1102,1146,993,1076,1251,1125,1100,1161,
 1038,1058,1159,1090,1581,1697,1567,1683,1642,1687,1514,1698,
 1617,1696,1557,1711,1966,2020,1985],
 [17,31,35,19,34,25,58,51,50,61,79,85,88,89,66,104,83,64,
 108,74,107,63,84,103,56,54,78,96,60,87,90,91,70,62,49,
 68,52,356,279,186,247,248,251,201,276,292,294,202,253,
 287,223,254,319,295,308,231,226,235,192,209,278,877,815,
 959,750,635,938,895,1048,816,871,765,684,918,769,628,2530,
 2640,2167,2111,2389,2567,2107,2070,2024,5260,4383],
 [17,31,35,19,34,25,58,51,61,79,85,88,104,83,64,74,107,63,
 84,103,56,54,96,60,87,90,91,70,99,62,49,68,52,356,307,
 291,280,251,201,406,294,202,253,287,223,267,238,319,295,
 308,262,231,226,235,192,278,1768,692,739,1107,873,635,
 1340,1238,938,895,1048,816,871,765,684,672,724,822,918,
 1075,769,798,628,4724,3648,2709,2608,4354,3856,3780,2389,
 2567,2107,2070,2461,2024,2660,3626,5125,2431,9146,9118,9090,
 5429,5553,8086,9172,5280,4079,4383,7074,8662,8161,7067,8892,
 8839,8813,8786,7706,8789,5063,8334,9328,7229,6862,8642,6111,
 6817,8360,9386,8153,8147,9233,6805,6780,6902,6658,6551,7887,
 6792,6305,7575,7301,6447,6363,6321,6250,6978,6123,6611,7326,
 8054,7071,6340,6146,6132,6083,6406,6234],
 [17,31,35,19,34,25,58,51,61,79,94,85,88,89,66,77,53,104,
 83,64,108,74,107,63,84,103,56,54,78,96,60,87,90,91,70,
 99,62,49,68,52,356,324,304,247,248,212,251,201,292,294,
 202,287,223,254,308,231,226,235,192,278,1318,1160,750,983,
 635,895,1048,684,769,920,628,3535,3511,3589,2974,2070,3364,
 3076,5915,5001,5220,5603,5884,8070,7172],
 [17,31,35,19,34,25,58,51,67,50,61,97,82,79,94,105,69,85,
 88,89,66,59,77,53,71,104,83,64,108,74,102,73,107,63,84,
 103,56,54,78,96,60,75,87,90,91,70,93,80,99,98,62,49,
 68,52],
 [17,31,35,19,34,25,58,51,67,61,79,59,71,104,83,64,74,107,
 103,56,54,96,60,87,70,99,62,49,340,370,402,345,362,279,
 186,300,222,272,292,435,294,202,287,223,231,226,228,495,
 515,500,397,537,441,540,447,618,538,488,505,448,494,514,
 417,548,470,692,739,722,778,1347,1975,672,724,715,795,
 1308,2044,1818,978,1285,1143,958,1219,948,1294,850,1332,
 936,2353,1255,1087,910,1217,952,1269,856,1284,860,2382,
 2196,1941,1625,1653,1410,1480,1583,1513,1510,1462,1387,1999,
 1783,1544,1745,1561,1575,1580,1382,1431,1497,1551,4569,1812,
 4359,1845,4445,1826],
 [17,31,35,19,34,25,58,51,67,61,97,82,79,71,104,83,64,74,
 103,56,54,96,60,75,87,99,52,340,316,402,345,362,411,249,
 300,222,259,272,247,248,264,292,382,404,287,223,231,226,
 281,228,500,397,455,537,441,518,453,427,540,447,505,448,
 514,417,459,548,470,722,703,778,1347,1603,1786,715,725,
 795,1308,1524,1771,818,985,831,978,934,1044,1219,948,1162,
 1294,850,1121,1332,936,986,1217,952,1201,1269,856,1036,
 1284,860,1653,1410,1583,1513,1462,1387,1745,1561,1580,1382,
 1497,1551,1812,1845,1826],
 [17,31,35,19,34,25,58,51,67,61,97,82,79,105,69,85,88,89,
 66,59,104,83,64,108,74,102,73,107,84,103,56,54,78,96,
 60,75,99,98,62,49,52,324,234,322,359,350,215,221,251,
 201,437,406,253,319,295,308,306,273,239,220,235,192,357,
 878,794,866,861,776,812,723,2247,1988],
 [17,31,35,19,34,25,58,51,67,61,97,82,79,105,69,85,88,104,
 83,64,74,102,73,107,63,84,103,56,54,96,60,75,87,90,91,
 99,98,62,49,68,52,324,234,307,291,304,322,359,350,280,
 221,251,201,406,253,267,238,254,319,295,308,262,220,235,
 192,925,873,822,798],
 [17,31,35,19,34,25,58,51,67,61,97,82,105,69,88,59,71,83,
 64,102,73,84,103,56,54,96,60,87,98,62,49,52,340,316,
 362,411,377,249,320,227,264,200,281,220,209,547,461,518,
 453,531,509,488,505,448,548,470,498,502,454,497,468,788,
 1010,668,759,727,963,979,671,817,736,1315,1093,1403,1426,
 1225,1399,1446,1020,993,1208,1077,1171,1290,1142,1512,1443,
 1319,1456,1406,885,1038,1235,1085,1261,1369,1885,1821,2117,
 2017,1910,2053,2463,1787,1750,2264,2163,1899,2047,1858,1810,
 2243,2295,1938,1848,2126,3889,5412,5541],
 [17,31,35,19,34,25,58,51,67,61,105,69,71,104,83,64,84,
 103,56,54,96,60,75,87,98,62,49,52,340,316,345,362,411,
 377,249,279,186,193,259,272,227,276,294,202,200,250,231,
 226,281,500,397,455,537,441,518,453,427,540,447,505,448,
 514,417,459,548,470,692,739,764,703,778,1023,672,724,728,
 725,795,932,818,1436,1450,934,1315,1044,1219,948,1162,1294,
 850,1121,1332,936,986,1217,952,1201,1269,856,1036,1284,860,
 1653,1410,1583,1513,1462,1387,1745,1561,1580,1382,1497,1551,
 4414,4559,4344],
 [17,31,35,19,34,25,58,51,67,88,59,104,83,64,102,73,54,87,
 98,62,49,340,345,377,249,315,259,264,329,255,212,276,383,
 217,281,299,209,482,464,495,490,430,537,441,567,526,531,
 509,585,545,511,540,447,561,528,474,538,504,483,550,519,
 548,470,559,555,535,497,468,577,788,876,1010,742,727,1029,
 963,853,979,718,736,961,1436,1120,1450,943,1315,906,1403,
 1426,1343,1143,958,1399,1446,1216,937,1187,988,1171,1290,
 1231,1018,1512,1443,1444,1087,910,1456,1406,1254,1009,1261,
 1369,1168,886,2592,2294,3347,2338,2879,2170,3717,2523,2117,
 1678,1460,2053,1996,2264,1734,1447,2047,2062,2243,1644,1441,
 2126,2176,3541,3296,2647,3053,2763,3022,3061,3249,3213,3442,
 2501,3109,2781,2670,3073,3108,5965,5339,8604,4905,7223,5527,
 8628,4696,8366,5444,8625,4494,6907,5573],
 [17,31,35,19,34,25,660,634,58,51,67,61,97,82,77,53,71,
 104,83,64,103,56,54,96,60,75,62,49,52,1629,1499,1718,
 1618,340,316,402,345,362,411,249,193,300,222,227,247,248,
 221,251,201,200,287,223,250,231,226,220,235,192,500,397,
 455,513,518,453,489,412,427,487,505,448,514,417,459,499,
 502,454,818,985,831,978,934,1451],
 [17,31,35,34,30,58,51,50,61,97,79,69,85,88,89,66,95,77,
 64,108,74,101,73,107,63,84,103,56,78,96,60,87,90,91,70,
 106,93,49,57,356,186,234,300,359,350,320,247,293,201,276,
 292,437,435,434,202,253,287,254,295,308,303,231,358,357,
 335,793,1112,635,957,1023,1347,816,918,792,932,1308,2314,
 2229],[17,31,35,34,30,67,105,66,95,71,74,102,73,84,96,
 75,91,106,52,289,370,366,411,342,334,315,293,358,575,464,
 495,594,624,531,583,598,579,625,586,581,548,595,638,576,
 587,788,764,862,800,703,1023,963,728,939,903,718,725,932,
 1404,3826,1303,3450,1315,1237,3273,1035,1183,1403,1114,1263,
 1044,948,1362,1196,1253,933,881,1162,850,1081,988,1096,
 1257,1530,1121,936,1345,1136,1230,1512,986,952,1223,1166,
 1213,984,1027,1209,1396,1254,1201,856,1203,1046,1147,1036,
 860,1215,2470,2140,1929,2421,2884,2004,2351,2543,1978,2462,
 2375,1895,2069,1885,1674,1560,1941,1653,1777,2017,2225,1583,
 1851,1787,1721,1553,2204,1462,1742,2163,1745,1953,1858,2100,
 1659,1589,2016,1580,1736,1938,1497,1877,2786,2593,2637,2847,
 3089,2315,3081,2938,3682,2618,3497,2482,2597,3592,3150,3020,
 2704,2425,3019,3346,2902,2830,4672,2900,2480,2768,2988,3021,
 3286,2698,3489,2623,2516,3269,2498,2889,3418,3401,2970,2668,
 2568,2769,4123,3889,3973,5412,3798,5541,4029,3362,3884,8427,
 3162,4732,3305,3559,7984,5856,2644,2816,2575,2791,3193,2678,
 2601,2615,2850,3604,2916,3204,2774,2684,2544,3705,2782,2604,
 2784,2610,2833,2946,2886,2878,2665,2777,2545,3059,3702,2687,
 2985,2738,2832,2971,2842,3031,9295,9266,9230,5897,8459,7710,
 8421,4963,9416,8311,6841,7481,8567,8555,5122,7288,8011,9100,
 6521,6191,7240,4092,8869,3767,8034,3955,6863,4037,8208,3779,
 6784,4120,6404,5597,7889,8299,9365,5467,7277,8273,7535,5458,
 7638,6163,6395,5293,6749,7336,7906],
 [17,31,67,82,79,105,85,88,76,59,71,83,64,74,101,102,107,
 84,56,54,75,70,93,99,98,49,52,471,381,443,389,475,366,
 424,392,362,542,368,385,338,249,342,315,331,329,266,216,
 203,382,386,223,319,303,258,314,343,575,482,495,397,458,
 453,585,545,503,412,426,448,584,550,532,417,456,454,959,
 796,752,1333,800,1042,864,697,1246,871,694,1265,903,829,
 664,1151,818,831,934,1139,1091,1011,1059,1052,881,1082,
 1156,1024,1094,1126,967,1092,1065,1027,1005,1154,911,2443,
 3326,2475,3980],
 [17,35,34,30,51,50,61,97,79,69,85,92,88,89,66,95,77,108,
 74,73,107,63,84,103,60,65,87,90,91,70,106,93,49,57,342,
 356,186,234,300,359,350,320,244,230,247,310,293,318,329,
 201,276,292,388,434,202,253,287,295,308,303,214,246,231,
 330,358,323,349,357,335,793,1112,772,930,1192,635,816,918,
 751,869,1344,792,932,1308,2359,2790,3725,2110,2565,3501,
 2229,7948,9311],
 [17,37,31,19,13,58,51,50,61,85,88,89,66,76,59,77,53,55,
 104,83,64,74,101,107,103,56,54,96,60,87,86,70,99,98,62,
 49,57,356,279,186,247,248,215,261,212,270,206,251,201,
 203,435,200,287,223,308,228,235,192,187,335,788,815,959,
 750,1084,754,746,847,712,635,919,704,684,628,872,698,2111,
 2120,2572,2443,2427,2270,2093,2084,2134,1989,1969,2274,1934,
 5370,3638,4150,8921,5415,4054,3646,5474,4492,3481,8109,4431,
 4280,7701,5765,4711,6851,6672,7786],
 [17,37,31,19,13,67,79,85,88,71,83,64,107,54,75,93,80,98,
 62,49,52,375,407,402,313,411,236,342,334,322,359,227,247,
 248,266,388,436,319,295,303,250,231,226,273,239,209,575,
 482,464,455,567,526,493,477,533,466,427,582,528,474,465,
 550,519,563,478,462,459,431,463,1507,752,794,866,800,697,
 1597,694,776,812,671,903,941,664,758,1478,740,1471,1472,
 1287,1035,1403,1426,1305,1114,1399,1446,1190,1173,1377,1257,
 1366,1136,1512,1443,1182,1034,1456,1406,931,1274,1209,1204,
 1170,2140,2750,2133,2764,2082,1674,1560,2317,1563,1528,1721,
 1553,2429,1474,1531,2244,1659,1589,1604,1479,3541,2961,3053,
 3213,2854,3109,1943,1949,2000,5032,4049,3657,3037,5570,3823,
 3565,2890,4247,3765,3554,2609,5532,4846,8077,4366,5512,5601,
 8562,7434,7266,6238,7274,6095],
 [19,30,58,51,67,61,79,92,88,59,77,104,74,73,107,84,56,72,
 54,78,96,65,87,70,80,99,98,52,289,407,360,313,363,354,
 236,324,186,208,234,300,244,280,251,404,437,406,202,277,
 253,267,295,308,214,262,231,273,325,357,430,515,397,496,
 458,461,412,485,426,488,550,478,494,417,462,663,784,696,
 692,880,921,701,672,776,940,875,834,811,1139,1091,958,
 1073,937,1316,1082,1018,1155,910,1067,1092,1009,1224,886,
 1109,2917,2639,2603,2582,2655,1460,1625,1412,1480,1447,1510,
 1411,1544,1441,1575,1414,1431,3081,3143,2512,3061,2988,3317,
 2487,3073,2143,2164,2214,5200,5340],
 [20,18,15,51,50,61,97,92,89,76,55,83,73,63,84,103,72,65,
 90,91,106,81,62,68,237,421,364,333,428,361,393,208,193,
 291,351,264,216,200,238,328,262,281,325,343,616,464,495,
 441,556,469,619,511,503,579,625,449,483,544,610,519,532,
 442,468,480,719,670,662,709,980,1346,669,645,828,972,1035,
 1183,905,1055,1011,1114,1263,1219,933,881,988,1096,969,951,
 1024,1130,967,1034,1186,1217,1166,1213,885,1038,1058,984,
 1027,917,911,1170,1393,1284,2485,2293,2416,2252,1706,1623,
 1749,1600,1477,1756,1508,1633,1593,1489,2361,2035,1723,1638,
 1673,1494,1370,2222,2187,4172,3182,2115,3089,2315,3476,3329,
 2105,3675,3170,2339,4137,3228,2043,3263,2233,2860,3647,3976,
 3670,3373,2179,3225,3248,2266,1926,1915,1921,3661,4348,2679,
 5850,3515,3421,2710,5831,3253,3016,4163,4061,2528,4822,3339,
 3398,2706,8495,3427,3644,4084,4858,2905,5384,3277,2962,2633,
 5788,3272,3354,5665,8548,7751,4429,7212,7194,8777,4321,9380,
 4886,9016,4760,8112,8081,8852,8838,5751,6183,6244,6601,6599,
 8419,5588,7408],
 [20,18,15,51,50,61,97,100,92,89,66,59,95,55,83,108,73,63,
 84,103,75,65,90,86,80,81,98,62,252,339,376,395,344,387,
 317,342,186,234,259,359,320,247,310,309,318,206,221,288,
 388,202,253,213,295,303,239,220,301,357,430,501,597,583,
 598,466,506,426,487,586,581,610,456,499,576,587,630,772,
 703,746,808,685,873,636,751,763,799,699,798,832,821,995,
 1003,1104,1134,1098,1025,1071,1074,1061,1066,1140,1051,2056,
 2061,1210,1180,1283,1244,1195,1141,1226,1163,1176,1132,1259,
 1202,2326,2323,2336],
 [20,18,15,51,50,61,97,100,92,89,66,95,55,83,108,73,63,84,
 103,65,90,86,81,62,252,339,376,395,344,387,317,186,234,
 309,212,206,288,202,253,213,231,299,239,301,357,588,430,
 515,501,526,547,583,598,466,524,506,474,538,426,487,586,
 581,494,535,539,456,499,576,587,630,772,685,636,672,751,
 699,832,821,1177,1102,1146,995,1003,1104,1134,1162,850,
 1081,1031,1251,1125,1098,1025,1241,1100,1161,1071,1074,986,
 952,1223,1061,1066,1138,1159,1090,1140,1051,1036,860,1215,
 2452,2396,1972,1210,1180,1283,1244,2256,1195,1141,2227,1935,
 1226,1163,1176,1132,2456,2155,1259,1202,3208,4469,3130,3687,
 4169,3151,4203,4258,2944,3676,4436,3207,3620,3807,3149,3818,
 4251,2925,2326,2323,2336,4592,2646,3639,3551,2885,4166,3437,
 3781,2683,3729,3673,4462,2494,3712,3218,2685,3948,4059,3854,
 2641,3447,3098,3784,3861,3956,3444,3865,3866,3677,3996,4204,
 7748,7934,8114,8252,8001,8238],
 [20,18,15,51,50,61,100,92,89,66,95,77,55,64,108,101,73,
 107,63,84,103,54,60,65,87,91,86,106,93,81,62,49,57,237,
 421,333,428,361,374,393,356,279,193,222,272,298,229,309,
 270,437,434,294,200,223,269,213,260,348,273,357,464,495,
 441,556,526,547,509,549,511,503,447,527,474,538,483,544,
 519,532,470,568,535,539,468,480,1475,844,1468,738,1463,756 
  ],[20,18,15,51,50,61,100,92,89,66,95,77,55,108,73,63,
 84,103,60,65,87,91,86,106,81,62,49,57,237,421,428,361,
 374,393,356,279,193,222,272,298,229,244,230,264,309,293,
 270,437,434,294,200,213,260,214,246,281,348,358,273,235,
 357,464,495,441,556,526,547,461,509,549,511,503,447,527,
 474,538,483,544,519,532,494,470,568,535,539,468,480,887,
 974,778,874,1021,795,1475,844,1468,738,1463,756],
 [20,18,15,51,67,50,61,97,69,92,88,89,76,55,83,64,101,73,
 107,63,84,103,72,54,60,65,87,90,91,106,93,81,68,237,
 326,421,364,333,428,361,208,193,291,351,322,216,382,404,
 386,238,328,319,262,314,325,343,464,495,441,556,511,503,
 427,447,527,483,544,519,532,431,468,480,719,670,742,662,
 709,669,718,645,828,972,1055,1011,933,881,951,1024,1130,
 967,984,1027,917,911,1623,1749,1600,1477,1508,1633,1593,
 1489,1638,1673,1494,1370,1926,1915,1921],
 [20,18,15,51,67,50,61,97,69,92,88,89,76,55,83,73,107,63,
 84,103,72,60,65,87,90,91,106,81,62,237,326,421,364,333,
 428,361,393,208,291,351,216,404,437,386,238,328,214,262,
 246,325,357,343,464,467,495,537,441,556,511,479,503,540,
 447,527,504,483,544,519,510,532,497,468,480,720,719,761,
 670,662,710,709,747,669,645,828,972,1055,1158,1011,933,
 1039,881,951,1089,1024,1130,1249,967,984,1002,1027,917,
 1103,911,1703,1623,1749,1685,1600,1477,1688,1508,1633,1693,
 1593,1489,1684,1638,1673,1691,1494,1370,1926,1915,1921],
 [20,18,15,51,67,50,61,97,79,69,92,88,89,76,77,55,83,64,
 101,73,107,63,84,103,72,65,90,91,106,93,81,62,68,237,
 326,421,364,333,428,361,393,208,291,351,293,255,266,216,
 404,386,238,328,262,325,343,464,495,441,556,511,503,447,
 527,483,544,519,532,468,480,719,670,762,807,697,662,709,
 669,785,787,664,645,828,972,1055,1011,933,881,951,1024,
 1130,967,984,1027,917,911,1623,1749,1600,1477,1508,1633,
 1593,1489,1638,1673,1494,1370,1926,1915,1921],
 [20,18,15,51,67,50,61,100,69,92,88,89,66,95,55,64,108,
 101,73,107,63,84,103,65,91,86,106,81,62,237,421,333,428,
 374,393,279,298,229,309,255,266,270,404,437,386,294,213,
 260,348,305,306,273,325,357,343,464,467,495,537,441,556,
 526,469,547,531,509,549,580,511,479,503,540,447,527,474,
 449,538,504,483,544,519,510,532,548,470,568,623,535,442,
 539,497,468,480,1475,844,1468,738,1463,756],
 [20,18,15,51,67,50,61,100,79,69,92,88,89,66,95,77,55,108,
 73,107,63,84,103,60,65,87,91,86,106,93,81,62,49,57,237,
 421,428,361,374,393,279,298,229,244,230,309,293,270,437,
 294,213,260,214,246,348,358,273,357,464,495,441,556,526,
 547,461,509,549,511,503,447,527,474,538,483,544,519,532,
 494,470,568,535,539,468,480,1475,844,1468,738,1463,756],
 [20,18,15,58,51,50,61,97,85,92,89,66,59,95,53,55,104,83,
 108,102,73,63,84,103,75,65,90,86,80,81,98,62,252,339,
 376,365,395,344,387,317,186,208,234,310,309,318,206,221,
 288,202,277,253,213,239,220,301,357,430,501,583,598,466,
 506,426,487,586,581,456,499,576,587,630,772,808,685,873,
 636,751,799,699,798,832,821,995,1003,1104,1134,1098,1025,
 1071,1074,1061,1066,1140,1051,1210,1180,1283,1244,1195,1141,
 1226,1163,1176,1132,1259,1202,2326,2323,2336],
 [20,18,15,58,51,50,61,97,100,85,92,89,66,59,95,53,55,104,
 83,108,102,73,63,84,103,56,78,75,65,90,86,81,62,252,
 339,376,365,395,344,387,317,186,234,309,206,288,202,253,
 213,239,220,301,192,278,357,430,501,583,598,466,506,426,
 487,586,581,456,499,576,587,630,1010,716,1107,772,685,636,
 979,745,1075,751,699,832,821,995,1003,1104,1134,1098,1025,
 1071,1074,1061,1066,1140,1051,1210,1180,1283,1244,1195,1141,
 1226,1163,1176,1132,1259,1202,2326,2323,2336],
 [20,18,51,50,61,97,92,89,76,77,55,83,74,73,63,84,103,72,
 60,65,87,90,91,106,81,62,68,52,237,421,364,333,428,361,
 393,356,208,193,291,351,244,230,216,251,404,386,434,200,
 223,269,238,328,214,262,246,281,358,235,325,343,464,495,
 441,556,511,503,447,527,488,483,544,519,532,468,480,959,
 870,719,764,1449,670,662,709,728,1421,669,645,828,972,
 1093,1055,1011,933,881,951,1024,1130,967,984,1027,917,911,
 2443,2130,2475,2018,1623,1749,1600,1477,1508,1633,1593,1489,
 1638,1673,1494,1370,3860,4208,1926,1915,1921],
 [20,18,51,50,97,94,69,92,89,66,76,59,53,55,83,101,73,63,
 103,72,78,60,75,65,90,80,81,62,68,57,252,282,369,376,
 365,352,367,344,399,476,373,433,380,317,341,472,342,208,
 320,247,206,216,221,388,217,303,262,239,220,464,467,530,
 564,511,479,508,534,544,519,510,552,486,480,644,719,670,
 746,662,709,669,763,645,1613,1271,1833,1281,1645,1566,1055,
 1158,933,1039,951,1089,1130,1249,984,1002,917,1103,2029,
 1895,1749,1633,1673],
 [20,18,51,50,100,94,69,92,89,66,76,59,53,55,108,101,73,
 63,103,72,78,60,75,65,86,80,81,62,68,57,252,282,369,
 376,410,541,365,352,367,344,399,476,373,433,317,341,472,
 342,279,259,320,247,270,388,217,303,260,239,220,464,467,
 530,564,549,511,479,508,534,544,519,510,552,486,480,935,
 1084,919,843,812,979,1101,763,872,1174,1013,1323,1055,1158,
 933,1039,951,1089,1130,1249,984,1002,917,1103,2541,2566,
 2308,2460,2420,4988,5188],
 [20,32,15,51,50,97,69,92,89,76,95,53,83,73,63,103,72,78,
 60,65,90,80,62,68,57,252,282,339,376,410,365,352,395,
 344,399,373,433,387,341,186,208,234,304,247,216,288,202,
 254,262,246,209,278,588,515,501,536,526,477,522,580,524,
 506,473,474,465,512,599,494,517,523,431,463,719,761,670,
 879,746,662,900,709,747,671,1075,669,890,645,806,2426,
 2658,2596,1343,1146,1285,1263,1423,1457,1521,1125,1731,1530,
 1255,1186,1536,1058,1420,1396,1690,1393,2140,2650,2084,2133,
 2282,1969,1528,1531,1479,3052,2315,2519,2896,3236,2902,2935,
 2233,2700,2889,3291,2810],
 [20,32,15,51,50,97,69,92,89,76,95,55,83,73,63,103,72,78,
 60,65,90,81,62,68,57,237,353,421,422,408,312,428,346,
 337,361,405,393,371,286,208,193,234,264,261,216,288,200,
 319,262,246,281,228,325,616,565,515,501,441,469,531,509,
 524,506,447,449,504,483,610,573,494,517,470,442,497,468,
 796,719,761,670,879,662,900,709,747,980,669,890,645,806,
 844,738,756,995,1285,1263,1423,1457,1098,1731,1530,1255,
 1186,1061,1420,1396,1690,1393,2485,2033,2416,2440,2094,1733,
 2042,1825,2036,1841,3074,2502,3244,2947,2719,3028],
 [20,32,15,51,50,97,92,89,76,95,77,53,55,83,108,101,107,
 63,84,103,60,65,90,86,106,81,62,49,68,57,237,421,422,
 408,364,312,428,361,405,393,371,286,356,315,244,248,293,
 251,200,214,358,235,192,551,495,558,547,461,513,560,503,
 562,538,546,532,569,539,498,499,788,959,716,750,800,847,
 1048,745,882,1357,1388,1232,1434,1364,1301,1325,1453,1395,
 1093,1183,1196,1225,1253,1077,1096,1136,1142,1230,1319,1213,
 1046,1085,1147,2120,2427,1793,2585,1784,1619,1585,1608,1469,
 1654,1666,3638,5531],
 [20,32,15,51,50,97,100,94,69,92,89,76,95,53,55,83,108,
 101,73,63,103,72,78,60,65,90,86,106,80,81,62,68,57,237,
 252,282,353,339,326,369,421,376,422,408,410,364,365,352,
 312,395,333,367,428,344,346,337,399,361,373,433,405,387,
 374,380,393,317,371,286,341],
 [20,32,15,51,50,97,100,94,92,89,76,95,53,83,108,101,63,
 103,72,78,60,65,90,86,106,62,68,57,252,282,339,376,410,
 395,344,399,373,433,387,317,341,186,222,247,201,276,292,
 202,254,231,226,209,278,588,515,501,536,526,477,522,524,
 506,473,474,465,512,599,494,517,523,535,431,463,793,739,
 974,957,724,1021,792,904,1321,929,1282,1118,1236,1343,1146,
 1285,1263,1423,1457,1521,1125,1731,1530,1255,1186,1536,1058,
 1420,1396,1690,1393,2193,2302,2588,2408,2316,3052,2315,2519,
 2896,3236,2902,2935,2233,2700,2889,3291,2810],
 [20,32,15,51,67,50,61,97,69,89,76,95,77,53,55,83,64,73,
 107,63,84,103,72,54,78,60,90,80,81,62,49,68,57,237,353,
 422,408,364,312,428,346,337,361,405,393,371,286,208,193,
 234,280,230,216,288,251,277,200,253,262,246,258,301,235,
 515,451,501,461,416,513,524,450,506,488,413,487,494,452,
 517,498,396,499,1737,1650,1732],
 [20,32,15,51,67,50,61,97,69,92,76,95,77,53,55,83,73,107,
 63,84,103,72,54,78,60,65,93,80,81,62,49,68,57,237,353,
 421,422,408,364,312,428,346,337,361,393,371,286,208,193,
 234,244,280,230,216,288,277,200,253,214,262,246,258,301,
 515,501,500,461,513,518,524,506,489,488,487,505,494,517,
 514,498,499,502,989,977,779],
 [20,32,15,51,67,50,61,97,100,79,94,89,76,95,77,53,55,83,
 64,108,101,63,103,72,54,78,60,90,86,106,93,81,62,49,68,
 57,237,353,421,422,408,364,312,428,346,337,405,393,371,
 286,222,248,264,261,201,223,226,281,228,192,515,451,501,
 461,416,513,524,450,506,488,413,487,494,452,517,498,396,
 499,888,825,833],
 [20,32,15,51,67,50,61,97,100,79,94,92,76,95,77,53,55,83,
 64,108,101,107,63,84,103,72,54,78,60,65,86,106,81,62,
 49,68,57,237,353,422,408,364,312,428,346,337,361,405,393,
 371,286,222,248,251,201,223,226,235,192,515,501,500,461,
 513,518,524,506,489,488,487,505,494,517,514,498,499,502,
 1737,1650,1732],
 [20,32,15,51,67,50,61,97,100,94,92,89,77,53,55,83,64,108,
 101,107,63,84,103,72,54,78,60,65,90,93,81,62,49,68,57,
 237,353,421,364,312,428,346,337,361,393,371,286,193,222,
 248,201,200,223,226,192,515,501,496,530,461,513,493,564,
 524,506,485,508,488,487,525,534,494,517,462,552,498,499,
 516,486,954,976,989,842,813,977,1047,835,779],
 [20,32,15,58,51,50,97,69,89,76,59,95,53,71,55,104,83,102,
 73,63,103,56,72,78,60,90,80,99,81,98,62,68,57,252,282,
 339,410,365,352,395,344,399,373,433,387,317,341,186,208,
 234,280,230,216,221,288,202,277,253,262,246,258,220,301,
 515,451,501,461,416,513,524,450,506,488,413,487,494,452,
 517,498,396,499,1433,973,982],
 [20,32,15,58,51,50,97,69,92,76,59,95,53,55,83,102,73,63,
 103,56,72,78,60,65,70,80,99,81,98,62,68,57,252,282,339,
 376,410,365,352,395,344,399,373,433,317,341,186,208,234,
 350,320,280,230,216,288,202,277,253,308,303,262,246,258,
 301,515,501,500,461,513,518,524,506,489,488,487,505,494,
 517,514,498,499,502,1339,1297,1288],
 [20,32,15,58,51,50,97,82,100,94,89,76,59,95,53,71,55,104,
 83,108,101,63,103,56,72,78,60,90,86,70,106,99,81,98,62,
 68,57,252,282,339,376,410,365,352,395,344,399,387,317,
 341,222,247,248,201,223,231,226,192,515,451,501,461,416,
 513,524,450,506,488,413,487,494,452,517,498,396,499,927,
 791,832,838,821,846],
 [20,32,15,58,51,50,97,82,100,94,92,76,59,95,53,71,55,104,
 83,108,101,102,63,103,56,72,78,60,65,86,106,99,81,98,
 62,68,57,252,282,339,410,365,352,395,344,399,373,433,387,
 317,341,222,248,221,201,223,226,220,192,515,501,500,461,
 513,518,524,506,489,488,487,505,494,517,514,498,499,502,
 1433,973,982],
 [20,32,15,58,51,50,97,100,94,92,89,59,53,71,55,104,83,
 108,101,102,63,103,56,72,78,60,65,90,70,99,81,98,62,68,
 57,252,282,339,376,365,352,395,344,399,373,433,317,341,
 186,222,248,201,202,223,226,192,515,501,496,530,461,513,
 493,564,524,506,485,508,488,487,525,534,494,517,462,552,
 498,499,516,486,1613,1339,1833,1297,1645,1288],
 [20,32,18,51,50,61,82,100,69,85,89,76,53,108,102,73,63,
 84,103,56,72,60,75,86,80,62,68,252,410,365,344,399,373,
 341,304,351,331,320,229,227,230,221,288,203,292,435,386,
 388,294,254,328,311,303,250,246,273,220,301,187,278,335,
 343,469,547,416,513,450,506,540,449,538,452,517,442,539,
 396,499,497,1482,1318,794,714,1661,1340,776,721,973,982,
 857,1277,867,1267,945,1208,926,1361,848,1273,949,1235,1571,
 1495,1373,1585,1568,1743,1380,1469,1525,1594,1417,1666,1811,
 1867,1834],
 [20,32,18,51,50,61,97,83,72,237,252,248,215,261,302,437,
 435,386,267,213,226,314,461,416,513,477,564,531,447,473,
 527,579,465,534,504,494,452,517,431,486,497,924,663,630,
 794,726,670,733,727,674,712,845,695,1505,1975,1670,1015,
 709,853,747,776,702,801,760,736,693,872,645,1379,2044,
 1500,888,927,738,929,1079,857,1277,1035,1177,1188,905,1234,
 867,1267,1196,933,1039,881,1173,1419,945,1208,988,1031,
 1175,969,936,1095,1345,1546,1106,926,1361,1136,1130,1249,
 967,1034,1317,848,1273,1166,1179,1189,885,1363,949,1235,
 1046,917,1103,911,1170,860,1080,1215,1556,2368,2291,1995,
 1785,1990,1889,2023,2206,2087,1989,2129,2075,2321,2088,2091,
 1801,2139,2041,2292,2296,2118,1934,2239,2080,1706,1571,1495,
 1821,1473,1599,2083,1619,1373,1585,1600,1620,1477,2265,1756,
 1568,1743,1750,1527,1466,1964,1510,1626,1719,1608,1380,1469,
 1593,1646,1489,2361,1723,1525,1594,1810,1509,1552,2388,1654,
 1417,1666,1494,1582,1370,2222,1431,1587,1543,3585,3491,2245,
 3333,2847,2625,2115,3234,2542,2149,3294,2756,2405,2105,2839,
 3189,2051,2965,3019,2521,2339,3843,3190,2322,2910,3040,2573,
 2043,3084,2648,2128,2860,3269,2531,2179,3017,3005,2131,2831,
 3351,2522,2266,1997,5373,3756,4769,2798,2003,1951,4576,3892,
 4811,2858,1984,1959,4572,4062,4497,2883,2001,4240,5745,3532,
 2808,2930,4563,2880,3462,2759,3820,4073,2599,2737,4022,2846,
 3155,2617,3940,3194,2812,3086,4865,2506,2837,2484,4011,3789,
 2513,3342,3960,2838,3556,2817,4063,3746,2796,2621,4876,2743,
 3813,2836,4124,3751,2590,3301,4191,2555,2893,2578,4232,3802,
 4386,4733,3509,5038,5754,4481,4281,4748,3520,4403,5815,4125,
 4601,4801,3600,5420,6070,4550,4820,4749,3371,4603,5607,3891,
 4461,4664,3564,5705,5951,4897,4652,4411,3543,4873,5977,5199,
 5305,4490,5091,5649,5767,4594,5192,5949,6067,4285,5394],
 [20,32,18,51,50,61,97,89,76,53,83,74,101,63,84,103,72,60,
 90,62,68,52,57,252,376,344,317,341,186,208,222,280,247,
 248,216,201,203,292,202,277,223,254,328,262,226,258,192,
 187,278,588,467,495,451,501,526,469,547,416,513,479,503,
 450,506,474,449,538,413,487,586,510,532,452,517,535,442,
 539,396,499,431,486,793,819,746,635,816,863,763,628,1302,
 927,1438,832,1439,821,1093,907,1146,995,1225,981,1076,1077,
 1119,1125,1142,946,1161,1071,986,1169,1319,931,1058,1085,
 1060,1090,1972,1435,1662,2281,2081,2256,1440,1744,2227,1935,
 2221,1458,1680,2456,2155,2324,3208,3735,2312,2960,2309,3676,
 3738,2417,2802,4592,3459,3781,4462,3718,3854],
 [20,32,18,51,50,61,97,89,76,59,95,53,83,74,101,102,63,84,
 103,72,60,75,90,62,68,52,57,252,376,410,344,317,341,342,
 186,208,222,280,248,310,216,221,288,201,203,292,202,277,
 223,217,262,226,258,220,301,192,187,278,467,495,451,501,
 469,547,416,513,479,503,450,506,449,538,413,487,510,532,
 452,517,442,539,396,499,644,1333,808,665,1265,799,1302,
 927,1438,832,1439,821,907,1146,981,1076,1119,1125,946,1161,
 931,1058,1060,1090,1972,2081,2256,1935,2221,2155],
 [20,32,18,51,50,61,97,100,69,76,53,83,108,74,101,73,63,
 84,72,60,90,86,80,68,237,353,326,312,333,405,374,193,
 234,302,243,266,404,435,386,200,253,267,281,290,306,314,
 325,335,343,616,451,501,594,477,564,580,450,506,473,527,
 579,465,534,452,517,595,623,431,486,463,480,663,796,915,
 695,701,871,728,801,753,738,1177,1188,1207,1296,1039,881,
 2146,1031,1175,1332,1241,1383,1249,967,1179,1189,2112,1138,
 1300,1103,911,1284,2410,2284,1473,1599,1573,1676,1620,1477,
 1527,1466,2042,1545,1717,1646,1489,1509,1552,1535,1647,1582,
 1370,3491,2245,2542,2149,2105,3189,2051,3190,2322,2043,2648,
 2128,3005,2131,2266,1997,2798,1951,2858,1959,2883,4083,2808,
 2930,3030,2599,2737,3016,2909,2812,3086,3368,2513,3342,3644,
 3110,2796,2621,2869,2590,3301,3354,5722,5269,5483,5689,5678,
 6020,4340,4835,4823,4547,4432,4455,9253,7890,7784,7977,7438,
 9298],[20,32,18,51,50,61,97,100,69,76,77,53,83,108,74,
 101,73,107,63,84,72,60,65,87,90,86,80,68,237,353,326,
 312,333,361,405,374,356,193,234,240,272,302,251,404,435,
 386,434,200,253,207,269,267,214,314,335,343,477,564,473,
 527,465,534,431,486,463,480,663,720,915,695,1786,701,710,
 801,753,875,1771,738,1177,1188,1207,1296,1039,881,1031,
 1175,1241,1383,1249,967,1179,1189,1138,1300,1103,911,3893,
 3135,1473,1599,1573,1676,1620,1477,1527,1466,1545,1717,1646,
 1489,1509,1552,1535,1647,1582,1370,3491,2245,2542,2149,3189,
 2051,3190,2322,2648,2128,3005,2131,1997,2798,1951,2858,1959,
 2883,2808,2930,2599,2737,2812,3086,2513,3342,2796,2621,2590,
 3301],[20,32,18,51,50,61,97,100,69,89,77,53,83,108,74,
 101,73,107,103,60,65,87,90,86,80,62,52,57,237,353,364,
 312,333,361,405,356,193,234,240,272,298,215,261,251,404,
 437,434,214,245,228,348,235,325,515,455,530,536,556,477,
 564,473,527,459,552,523,568,720,950,742,879,912,1505,892,
 718,890,868,795,1122,1379,1006,1158,1011,1335,1362,1039,
 881,1423,1304,1081,1095,1345,1405,1223,1002,1027,1420,1201,
 1360,1214,1203,1080,1215,2939,2990,3024,2975,2289,1869,1892,
 1865,2136,1882,1827,1878,2085,1575,1850,1880,1879,2034,4894,
 6037,4910,5593,2524,2793,1965,2037,2014,8779,5270,3547,2601,
 3506,3625,3204,3266,2784,3240,2878,3713,3678,2985,3158,3031,
 9077,9068,7407,7404],
 [20,32,18,51,50,61,100,69,89,53,108,73,63,84,103,60,86,
 80,62,52,57,252,365,344,373,298,304,351,229,227,230,309,
 437,294,202,213,254,328,250,246,231,348,273,187,278,357,
 588,594,469,547,416,513,583,580,579,474,449,538,586,599,
 452,517,595,442,539,497,576,1318,692,794,737,1107,714,
 1340,1238,672,776,755,1075,721,628,982,857,1277,1044,1262,
 867,1267,1225,1020,981,1076,1162,1280,945,1208,1121,1356,
 926,1361,1142,986,1169,848,1273,885,931,1058,1201,1360,949,
 1235,1085,917,1036,1275,3648,2285,4019,2159,1571,1495,1692,
 1713,1373,1585,1578,1586,1568,1743,1626,1719,1380,1469,1632,
 1485,1525,1594,1617,1675,1735,1417,1666,1587,1543,3313,2664,
 3234,2312,2923,3350,2891,3084,2417,2926,1811,5493,1867,5256,
 1834,6038,2815,3055,2749,5891,2708,3607,2695,3907,2845,3045,
 2661,5750,2605,2829,2861,4741,3046,3610,2635,5018,2722,3324,
 2614,4007,8434,8005,8800,6956,7358,8898,4830,5583,4997,5579,
 4587,5909,4554,4924,6904,5809,4521,5299],
 [20,32,18,51,50,61,100,69,89,53,108,74,101,73,103,60,86,
 80,62,52,57,237,364,333,361,279,193,234,298,229,264,215,
 261,243,266,270,404,437,294,260,245,228,348,290,306,273,
 616,464,515,536,556,526,477,564,619,511,473,527,579,474,
 610,519,459,552,523,568,535,796,950,742,879,912,707,1786,
 1505,892,718,890,1122,717,1379,1006,899,1183,995,1219,1335,
 1362,1016,1253,1039,881,1423,1304,1081,902,1096,1332,1095,
 1345,1008,1230,1405,1223,928,1213,1002,1027,1420,1269,1214,
 1203,965,1147,1080,1215,2033,5970,2440,6000,1409,1798,1869,
 1892,1435,1662,2265,1865,2136,1394,1622,1882,1827,1440,1744,
 1878,2085,1418,1720,1850,1880,1458,1680,1879,2034,4262,2105,
 2502,3659,4828,4658,2179,2719,3915,4661,4644,1965,4617,2037,
 4335,2014,3275,2816,3547,2601,3279,2850,3625,3204,2913,2684,
 3266,2784,3202,2833,3240,2878,3141,2777,3678,2985,3038,2832,
 3158,3031,5712,8042,5741,6874,6506,8472,5842,9277,5166,6493,
 5690,8226,5136,6518,5645,7241,6014,6986],
 [20,32,18,51,50,61,100,69,89,76,59,95,53,108,102,73,63,
 84,103,72,60,75,86,80,62,68,52,57,252,410,365,344,399,
 373,341,342,186,259,229,227,230,310,388,294,202,217,250,
 246,273,220,301,187,278,469,547,416,513,449,538,452,517,
 442,539,396,499,497,1318,794,1010,942,737,1107,714,1340,
 776,755,1075,721,799,982,857,1277,867,1267,1016,1253,1020,
 981,1076,945,1208,926,1361,848,1273,885,931,1058,949,1235,
 1060,1090,2873,2866,3097,3014,3041,1571,1495,1373,1585,2017,
 1568,1743,1380,1469,1525,1594,1417,1666,3343,2597,3947,2616,
 4223,2674,1811,1867,1834,5868,6012,2815,3055,2708,3607,2734,
 2845,3045,2605,2829,3046,3610,2607,2722,3324,9157,5060,7929,
 5093],
 [20,32,18,51,67,50,61,97,100,79,94,69,76,77,53,83,64,108,
 74,101,73,107,63,84,72,60,65,87,90,86,93,80,49,68,237,
 353,326,312,333,361,405,374,302,293,318,435,386,207,269,
 267,358,323,314,335,343,477,564,522,549,473,527,465,534,
 523,568,431,486,463,480,700,870,663,915,695,705,914,701,
 801,753,738,756,1177,1188,1207,1296,1031,1175,1241,1383,
 1179,1189,1138,1300,1473,1599,1573,1676,1527,1466,1545,1717,
 1509,1552,1535,1647,1997,1951,1959],
 [20,32,18,51,67,50,61,97,100,79,94,69,77,53,83,64,108,74,
 101,73,103,54,78,60,65,87,90,86,93,80,62,52,57,237,353,
 326,364,312,333,361,405,240,272,307,298,264,215,261,404,
 437,207,269,267,281,245,228,348,455,530,536,556,477,564,
 473,527,465,534,459,552,523,568,950,912,1786,1505,892,
 1122,1771,1379,1006,828,1335,1362,1304,1081,1095,1345,1405,
 1223,1214,1203,1080,1215,1869,1892,1865,2136,1882,1827,1878,
 2085,1850,1880,1879,2034,1965,2037,2014],
 [20,32,18,51,67,50,61,97,100,79,94,69,89,53,83,64,108,74,
 101,73,107,103,54,78,60,65,87,90,86,80,62,49,52,57,237,
 353,326,364,312,333,361,405,240,272,298,215,261,437,245,
 228,348,455,530,537,536,556,477,564,540,473,527,459,552,
 548,523,568,950,809,778,912,1505,892,868,795,1122,1379,
 1006,1219,1335,1362,1162,1280,1294,1304,1081,1332,1095,1345,
 1217,1405,1223,1201,1360,1269,1214,1203,1284,1080,1215,1869,
 1892,1480,1865,2136,1882,1827,1878,2085,1575,1850,1880,1879,
 2034,1965,2037,2014],
 [20,32,18,51,67,50,61,97,100,79,94,69,89,53,83,64,108,74,
 101,73,107,103,60,65,87,90,86,80,62,49,52,57,237,353,
 326,364,312,333,361,405,240,272,298,215,261,437,207,269,
 245,228,348,358,323,455,530,537,536,556,477,564,531,473,
 527,465,534,504,459,552,548,523,568,950,1449,925,912,1505,
 892,1421,822,1122,1379,1006,828,1335,1362,1304,1081,1095,
 1345,1405,1223,1214,1203,1080,1215,1869,1892,1777,1865,2136,
 1851,1882,1827,1742,1878,2085,1953,1850,1880,1736,1879,2034,
 1877,1965,2037,2014],
 [20,32,18,51,67,50,61,97,100,79,94,69,92,88,76,53,83,64,
 108,74,101,73,63,84,72,65,87,90,86,80,68,237,353,326,
 312,333,361,405,374,264,302,293,318,255,404,435,386,267,
 358,323,305,314,325,335,343,477,564,531,522,549,540,473,
 527,465,534,548,523,568,431,486,497,463,480,663,915,707,
 695,701,801,717,753,738,756,1177,1188,1207,1296,1031,1175,
 1241,1383,1179,1189,1138,1300,1885,1473,1599,2017,1573,1676,
 1787,1527,1466,2163,1545,1717,1858,1509,1552,1938,1535,1647,
 1997,1951,1959],
 [20,32,18,51,67,50,61,97,100,79,94,69,92,88,76,53,83,64,
 108,74,101,73,107,63,84,60,65,87,90,86,80,68,237,353,
 326,312,333,361,405,374,302,309,293,318,435,386,267,348,
 358,323,314,325,335,343,477,564,531,522,549,473,527,465,
 534,504,523,568,431,486,497,463,480,663,915,922,695,701,
 801,980,753,738,756,1177,1188,905,1207,1296,1020,1031,1175,
 969,1241,1383,1017,1179,1189,885,1138,1300,1019,1473,1599,
 1573,1676,1527,1466,1545,1717,1509,1552,1535,1647,1997,1951,
 1959],
 [20,32,18,58,51,50,61,82,100,69,89,76,59,95,53,108,102,
 73,63,84,103,56,72,60,86,80,81,98,62,68,52,57,252,410,
 365,344,399,373,317,341,331,320,229,227,230,221,288,294,
 250,246,273,220,301,469,547,461,416,513,524,450,506,449,
 538,494,452,517,442,539,498,396,499,1318,794,1042,759,714,
 1340,776,1054,817,721,973,982,857,1277,867,1267,945,1208,
 926,1361,848,1273,949,1235,1706,1571,1495,1619,1373,1585,
 1756,1568,1743,1608,1380,1469,1723,1525,1594,1654,1417,1666,
 1811,1867,1834],
 [20,32,18,58,51,50,61,97,85,89,76,59,95,53,55,104,83,74,
 101,102,63,84,103,56,72,60,90,70,106,81,98,62,68,52,57,
 252,376,410,365,344,317,341,186,208,222,280,248,212,216,
 201,202,277,223,262,226,299,258,192,467,495,451,501,469,
 547,416,513,479,503,450,506,449,538,413,487,510,532,452,
 517,442,539,396,499,1302,927,1438,832,1439,821],
 [20,32,18,58,51,50,61,97,85,89,76,59,95,53,83,74,101,102,
 63,84,103,72,60,75,90,81,98,62,68,52,57,252,376,410,
 344,317,341,208,222,331,320,280,248,216,221,288,201,277,
 223,311,303,262,226,258,220,301,192,464,467,495,451,501,
 597,526,469,547,416,513,511,479,503,450,506,474,449,538,
 413,487,610,519,510,532,452,517,535,442,539,396,499,1302,
 927,1438,832,1439,821],
 [20,32,18,58,51,50,61,97,89,76,59,95,53,55,104,83,74,101,
 63,84,103,56,72,60,90,70,106,81,98,62,68,52,57,252,376,
 410,365,344,317,341,186,208,222,280,247,248,216,201,202,
 277,223,262,231,226,258,192,467,495,515,451,501,469,547,
 461,416,513,479,503,524,450,506,449,538,488,413,487,510,
 532,494,452,517,442,539,498,396,499,1302,927,1438,832,
 1439,821],
 [20,32,18,58,51,50,61,100,69,85,89,76,59,95,53,55,104,
 108,102,73,63,84,103,72,60,86,81,98,62,68,52,57,252,
 410,365,344,399,373,317,341,229,227,230,221,288,201,294,
 250,246,299,273,220,301,192,526,469,547,416,513,450,506,
 474,449,538,452,517,535,442,539,396,499,1318,1112,794,714,
 1340,918,776,721,973,982,1079,857,1277,1234,867,1267,1419,
 945,1208,1106,926,1361,1317,848,1273,1363,949,1235,1571,
 1495,1373,1585,1568,1743,1380,1469,1525,1594,1417,1666,1811,
 1867,1834],
 [20,32,51,50,97,89,76,59,95,53,55,83,108,101,102,63,103,
 60,90,86,106,81,62,68,57,252,282,376,410,541,365,352,
 395,344,476,387,317,341,472,342,310,221,330,220,464,551,
 495,451,558,547,416,543,549,511,560,503,450,562,538,413,
 557,544,546,532,452,569,539,396,553,480,959,716,974,847,
 1048,724,745,882,792,1893,1302,927,791,1907,1438,832,838,
 1876,1439,821,846,1093,1183,1343,1146,1225,1253,1506,1076,
 1423,1457,1077,1096,1521,1125,1142,1230,1444,1161,1255,1186,
 1319,1213,1536,1058,1085,1147,1541,1090,1690,1393,2713,2359,
 2259,2418,2649,1978,2110,2278,2559,1567,1514,1557,2324,3602,
 2312,4177,2960,4438,2309,4117,2417,3647,2802,4606,5851,4948]
  ,[22,17,31,19,13,79,94,85,89,66,59,71,74,102,73,84,78,
 75,90,91,70,99,98,62,49,52,375,407,360,332,327,354,236,
 342,334,315,322,359,229,244,264,293,388,436,434,319,295,
 303,260,214,281,358,235,192,482,464,490,430,567,526,522,
 528,474,550,519,563,478,523,1378,752,878,800,1488,694,861,
 874,745,903,664,758,740,1183,1305,1114,1338,1196,1253,1190,
 1173,1230,1182,1034,1264,1166,1213,1274,1209,1204,1170,2870,
 3383,2659,3175,2057,1674,1560,1563,1528,1474,1531,1659,1589,
 1604,1479,2409,2860,1943,1949,2000,4042,3455,2508,3171,2584,
 2689,3338,3157,2792,8588,5665,7957,4429,8798,5386,6121,4964,
 7033,8123,7936],
 [22,17,31,41,30,13,51,67,61,79,85,66,95,77,53,71,104,74,
 73,107,84,96,70,93,99,289,336,313,327,342,186,234,300,
 247,310,293,318,212,206,288,201,292,388,202,253,287,254,
 299,239,301,335,430,501,496,493,583,598,545,466,506,473,
 426,487,525,586,581,555,456,499,576,587,793,930,746,808,
 762,873,816,869,763,799,785,798,792,1308,777,975,995,1003,
 1104,1134,1250,1098,1025,1071,1074,1061,1066,1295,1140,1051,
 1080,2359,3725,2110,3501,1210,1180,1283,1244,1195,1141,1226,
 1163,1176,1132,1259,1202,3950,4127,2072,2027,2049],
 [22,17,31,41,30,13,58,51,61,82,79,94,69,85,88,66,76,95,
 77,53,55,104,64,74,101,102,107,103,56,78,96,70,93,80,
 99,81,98,49,57,356,279,304,350,248,261,293,255,212,266,
 206,216,288,435,287,254,299,239,301,335,815,750,1084,893,
 847,845,762,807,697,662,785,787,664,645,2572,2427,2270,
 2651,2134,2129,2849,2274,2239,4150,5415,4054,5474,4492,4280,
 4711],
 [22,17,31,41,30,13,58,51,61,97,82,79,94,69,85,88,66,76,
 95,77,53,104,64,74,101,102,107,103,56,78,96,60,87,70,
 93,80,99,81,98,49,57,356,300,304,350,331,248,261,293,
 212,216,435,287,254,308,311,299,239,258,301,335,866,942,
 750,847,845,812,884,882,941,785,2564,2427,2725,2585],
 [22,17,31,41,30,13,58,51,67,61,79,85,66,95,77,53,104,74,
 102,73,107,84,56,78,96,70,93,99,289,332,313,327,186,234,
 300,293,212,206,288,202,253,287,254,308,299,239,301,192,
 278,335,430,501,496,583,598,545,466,506,426,487,525,586,
 581,550,555,456,499,463,576,587,793,696,716,1107,930,762,
 816,684,745,1075,869,785,777,975,995,1003,1091,981,1104,
 1134,1098,1025,1071,1074,1126,931,1061,1066,1140,1051,1210,
 1180,1283,1244,1195,1141,1226,1163,1176,1132,1259,1202,2072,
 2027,2049],
 [22,17,31,41,30,13,58,51,67,61,82,79,94,105,69,85,88,66,
 59,95,77,71,74,102,73,107,84,103,56,54,78,96,75,70,93,
 80,99,98,49,52,57,279,298,359,331,320,244,230,255,266,
 206,288,294,213,295,311,303,214,246,305,306,239,258,301,
 187,726,737,702,755],
 [22,17,31,41,30,13,58,51,67,61,97,82,79,94,105,69,85,88,
 66,76,59,95,77,53,71,55,104,64,74,101,102,73,107,84,
 103,56,54,78,96,60,75,87,91,86,70,106,93,80,99,81,98,
 49,52,57],
 [22,17,31,41,30,13,58,51,67,61,105,66,95,71,74,102,73,
 107,84,96,70,93,99,289,375,336,332,313,327,186,193,234,
 310,293,318,206,288,202,200,253,254,319,239,301,335,430,
 515,501,509,549,583,598,466,524,506,426,488,487,483,544,
 586,581,456,498,499,468,480,576,587,793,796,930,808,762,
 873,816,871,869,799,785,798,777,1327,975,811,1427,968,
 1341,1102,1146,995,1003,993,1076,1104,1134,1251,1125,1098,
 1025,1100,1161,1071,1074,1038,1058,1061,1066,1159,1090,1140,
 1051,1210,2374,1180,1283,2491,1244,1195,2311,1141,1226,2263,
 1163,1176,2392,1132,1259,2191,1202,4736,2072,4328,2027,4396,
 2049],
 [22,17,31,41,30,58,67,79,105,85,77,53,104,102,73,107,84,
 56,78,75,70,93,80,98,68,289,375,332,313,409,327,354,334,
 315,186,234,280,227,293,206,288,276,436,383,202,253,238,
 254,328,308,262,250,349,239,301,209,335,430,501,583,598,
 466,506,426,487,586,581,550,456,499,576,587,896,793,819,
 696,930,762,889,816,863,684,1053,869,785,777,975,995,1003,
 1091,1104,1134,1098,1025,1071,1074,1126,1061,1066,1140,1051,
 2362,2442,1210,1180,1283,1244,1195,1141,1226,1163,1176,1132,
 1259,1202,2072,2027,2049],
 [22,17,37,19,13,61,85,92,88,89,66,59,104,74,102,73,84,54,
 65,70,99,98,52,407,360,332,313,363,354,236,342,334,193,
 350,229,244,264,270,206,382,404,388,436,434,200,260,214,
 299,306,273,239,314,325,567,526,554,458,533,466,528,474,
 563,478,555,535,529,456,1378,1112,878,887,716,893,707,921,
 957,1488,918,874,745,947,717,875,792,827,998,1229,1079,
 1205,1234,1392,1020,993,1206,1419,969,1251,1155,1355,1106,
 1070,1317,1415,885,1038,1349,1363,1019,1159,1109,2550,2824,
 2076,1853,1849,1854,2135,1883,1832,1863,2121,1846,1890,1859,
 1973,2060,2006,3049,3352,3080,3560,2734,3122,2856,3137,3219,
 3704,2607,3587],
 [22,17,37,31,19,13,58,51,67,61,97,82,79,105,69,85,88,89,
 66,76,59,77,53,71,55,104,83,64,74,101,102,73,107,84,
 103,56,54,96,60,75,87,90,91,86,70,93,80,99,81,98,62,
 49,52,57],
 [22,17,37,31,19,13,58,51,67,79,105,69,85,88,89,66,59,77,
 53,71,55,104,83,64,74,102,73,107,84,87,90,91,70,93,80,
 99,98,62,49,52,57,315,279,186,230,302,310,293,329,255,
 212,216,203,383,294,202,321,330,358,349,305,299,258,187,
 630,912,674,636,1122,693],
 [22,17,37,31,19,13,58,51,67,85,88,89,66,76,59,77,53,71,
 104,83,64,74,101,102,73,107,84,96,60,75,87,90,91,70,93,
 80,99,98,62,49,52,315,279,186,302,310,293,216,203,386,
 383,294,202,200,287,223,311,321,330,358,258,187,343,788,
 815,959,963,895,1048,810,2828,2652],
 [22,17,37,31,19,13,58,51,85,88,89,66,59,104,102,73,107,
 84,70,93,80,99,98,62,49,52,407,360,332,313,327,354,236,
 322,359,350,229,244,227,266,270,206,434,383,260,214,250,
 299,306,273,239,567,526,469,554,458,479,533,466,528,474,
 510,563,478,555,535,442,529,456,1378,1507,1112,823,1400,
 893,1488,1597,918,923,1424,947,758,827,998,841,1229,1079,
 1205,1234,1206,1419,1355,1106,1070,1317,1349,1363,1822,2076,
 1853,1765,1849,1854,1909,2135,1883,1788,1832,1863,1816,2121,
 1846,1824,1890,1859,1973,8737,2060,6775,2006,7182],
 [22,17,37,31,19,13,61,79,85,89,66,59,77,53,104,74,102,73,
 84,70,99,98,62,49,52,360,332,313,354,236,342,334,350,
 229,244,264,293,266,270,206,251,201,388,436,434,358,299,
 273,239,235,192,567,526,554,458,598,533,466,485,528,474,
 638,555,535,529,456,516,1378,1112,893,707,697,1488,918,
 947,721,820,717,664,827,1229,1079,1205,1234,1253,1206,1419,
 1355,1106,1230,1070,1317,1349,1363,1252,1046,1147,2818,2801,
 2770,2548,2076,1853,1849,1854,1573,2135,1883,1832,1863,1545,
 2121,1846,1890,1859,1636,1535,3103,4377,3744,3310,2616,3003,
 4671,4057,3403,2674,1973,2060,2006,2815,2943,2708,2845,2605,
 2933,3046,2722],
 [22,17,37,31,19,13,61,85,88,89,66,59,77,53,74,102,73,107,
 84,70,93,80,99,98,62,49,52,407,360,332,313,327,354,236,
 350,320,229,244,270,206,388,436,434,303,260,214,299,306,
 273,239,567,526,469,554,458,533,466,528,474,449,563,478,
 555,535,442,529,456,1482,2045,1378,1112,878,893,1661,1963,
 1488,918,861,947,758,827,740,998,841,1229,1079,857,1205,
 1234,867,1206,1419,945,1355,1106,926,1070,1317,848,1349,
 1363,949,2076,1853,1849,1854,2135,1883,1832,1863,2121,1846,
 1890,1859,1973,2060,2006],
 [22,17,37,31,19,13,79,85,88,59,83,64,102,73,54,75,70,98,
 62,49,375,407,327,236,342,334,356,307,291,227,264,276,
 388,436,434,267,238,209,482,464,624,604,518,453,493,531,
 509,522,473,528,474,504,483,581,591,497,468,463,577,1507,
 800,707,1597,694,717,664,740,1287,1035,905,1102,2108,1020,
 993,1072,1190,1173,1216,937,969,1251,1119,1231,1018,1366,
 1136,1017,1100,1182,1034,2054,885,1038,1019,1159,1060,1204,
 1170,1168,886,2109,2258,1793,2032,2057,1784,2691,1386,1581,
 1677,1567,1563,1528,1501,1642,2062,1637,1514,1474,1531,1464,
 1617,1746,1557,1604,1479,2969,2540,3333,3602,2549,3294,4177,
 2519,2896,2598,2965,4438,3136,3047,2857,2527,2910,4117,2935,
 2233,2409,2860,3647,2663,2831,4606,3281,2931,2331,3291,2810,
 2825,1943,2726,1949,2823,2000,9188,8280,2518,2903,2720,2920,
 2844,4176,3528,3423,3651,3365,2874,3480,3453,3605,2561,2789,
 2814,2953,2538,2727,2689,3338,3068,3154,2766,3523,3435,3443,
 3633,3440,8601,5982,7410,9301,8172,8155,9214,5963,8865,8843,
 6413,5558,6759,9333,9315,7123,7112,5080,8194,6239,7700,9137,
 4810,7698,4774,7237,4878,3522,5698,8888,8827,4420,8141,8107,
 8069,7840,4548,8793,6584,6564,3458,5076,9031,9023,6982,4734,
 7765,7393,6128,4584,6848,7085,7081,8104,7433,7007,7556,8560,
 7294,7994,6223,7272,6100,6527,6113,6491,7022,8844],
 [22,17,37,31,19,13,85,88,89,66,59,71,83,64,74,102,73,84,
 54,75,90,91,70,98,52,407,360,332,327,342,334,315,264,
 266,251,201,276,382,404,388,436,434,200,303,281,209,314,
 325,482,464,490,430,522,533,466,473,625,528,474,525,563,
 478,523,463,587,1378,788,752,800,697,921,957,1488,694,903,
 664,875,792,740,1699,905,1102,1305,1114,1190,1173,969,1251,
 1377,1257,1182,1034,885,1038,1274,1209,1204,1170,2120,2348,
 1386,1581,1674,1560,1563,1528,1501,1642,1721,1553,1474,1531,
 1464,1617,1659,1589,1604,1479,2115,3089,2447,2105,2606,2339,
 3346,2043,3263,2340,2179,2498,2266,3688,2825,1943,2726,1949,
 2823,2000,3280,2575,2671,2876,3316,2544,3002,2875,2851,2545,
 3018,2813],
 [22,17,37,31,19,13,85,88,89,66,59,83,64,74,102,73,107,84,
 75,70,93,80,99,98,62,49,52,407,360,332,313,327,354,236,
 342,334,356,315,322,359,350,266,270,206,388,436,319,295,
 308,303,482,464,467,490,430,567,526,479,533,466,528,474,
 550,519,510,563,478,752,750,800,697,919,704,694,769,903,
 664,872,698,971,758,827,740,998,1158,1305,1114,1039,1190,
 1173,1089,1377,1257,1249,1182,1034,1002,1274,1209,1103,1204,
 1170,1674,1560,1563,1528,1721,1553,1474,1531,1659,1589,1604,
 1479,1943,1949,2000],
 [22,17,37,31,19,13,85,88,89,66,71,74,102,73,107,84,90,91,
 70,93,80,99,98,62,49,52,407,360,332,313,327,354,236,342,
 334,356,315,304,322,359,212,266,388,436,434,254,319,295,
 303,260,214,482,464,467,490,430,567,526,469,533,466,528,
 474,449,550,519,510,563,478,752,935,720,800,635,697,694,
 843,710,903,628,664,971,758,740,998,1305,1114,1190,1173,
 1377,1257,1182,1034,1274,1209,1204,1170,1674,1560,1874,1563,
 1528,1820,1721,1553,1901,1474,1531,1739,1659,1589,1900,1604,
 1479,1814,4833,1943,4863,1949,4551,2000],
 [22,17,37,31,35,19,34,13,25,58,51,61,97,82,85,88,89,66,
 59,104,83,64,74,84,103,56,54,96,60,90,91,70,99,98,52,
 356,193,300,222,247,248,264,251,201,382,404,200,287,223,
 319,295,308,231,226,281,306,314,325,796,784,696,750,635,
 921,957,871,765,684,918,861,769,875,792,2216,2479,2314,
 2024,2657,2229],
 [22,17,37,31,35,19,34,13,25,58,51,97,82,79,85,88,59,77,
 53,104,83,64,107,84,103,56,54,87,90,91,70,98,62,49,52,
 356,300,222,307,291,227,329,255,212,251,201,276,383,287,
 223,267,238,250,231,226,235,192,209,1507,696,692,739,893,
 864,807,635,684,672,724,769,829,787,628,2709,2651,2660,
 3586,2849,3516,3793],
 [22,17,37,31,35,19,34,13,25,58,51,97,82,85,88,89,66,59,
 104,83,64,74,107,84,103,56,54,96,60,87,90,91,70,98,62,
 49,52,356,315,193,300,222,247,248,251,201,276,200,287,
 223,319,295,308,231,226,235,192,209,796,784,696,750,800,
 635,871,765,684,918,769,903,628,2216,2024],
 [22,17,41,30,13,58,51,61,82,79,94,69,85,92,88,66,95,77,
 53,104,74,102,107,103,56,78,96,70,93,80,99,98,49,57,
 356,279,298,304,350,331,244,230,293,212,243,216,203,294,
 287,213,254,311,305,299,290,306,258,187,335,815,739,722,
 1334,878,866,942,930,803,674,847,845,704,900,895,724,715,
 1198,861,812,884,947,820,693,882,941,698,806,2709,2984,
 2564,2132,2427,2086,2660,2915,2725,2251,2585,2161],
 [22,24,17,31,41,35,30,51,61,82,79,94,105,69,88,66,95,77,
 64,108,74,101,102,73,107,84,96,93,99,49,68,57,356,259,
 304,359,350,331,320,310,293,318,255,266,221,201,203,292,
 435,388,434,330,323,305,306,220,192,187,278,335,1482,1112,
 866,942,703,1192,1400,893,1042,759,635,704,900,1661,1344,
 1424,947,1054,817,628,698,806,2564,4239,2977,3097,2086,
 4468,3054,3041,2161,5720,9127,5461,7099,5074,7262,6246],
 [22,24,17,31,41,35,30,58,51,61,82,79,94,105,69,85,88,66,
 95,77,53,55,104,64,108,74,101,102,73,107,84,56,78,96,
 60,87,70,93,99,49,68,57,356,304,350,293,212,206,288,201,
 203,292,435,434,254,308,192,187,278,335,762,635,704,900,
 628,698,806,2086,2161],
 [22,24,17,31,41,35,30,58,51,67,61,82,79,94,105,69,85,88,
 66,59,95,77,53,71,55,104,64,108,74,101,102,73,107,84,
 56,54,78,96,60,75,87,91,70,106,93,80,99,81,98,49,68,
 52,57],
 [22,24,17,31,41,35,30,58,82,79,94,105,69,85,88,77,53,55,
 104,64,108,101,102,73,107,84,56,78,60,87,70,93,49,68,
 57,334,315,291,304,351,350,227,212,206,288,201,276,203,
 292,435,436,434,383,238,254,328,308,349,192,187,278,335,
 1378,1449,1272,727,762,635,704,900,1023,1488,1421,1053,628,
 698,806,932,2627,2086,2691,2161],
 [22,24,17,31,41,35,34,30,13,51,61,82,79,94,105,69,85,88,
 66,95,53,104,64,74,101,102,73,107,84,96,91,70,106,93,
 80,99,98,49,57,342,356,304,322,350,310,293,318,255,212,
 266,435,388,434,330,358,323,305,299,306,335,1192,823,893,
 1344,923,947],
 [22,24,17,39,37,31,41,19,34,30,21,13,25,51,82,69,85,53,
 73,60,75,70,93,80,98,252,384,369,481,375,422,541,365,
 425,367,521,332,476,373,444,380,491,327,371,472,304,254,
 330,588,565,537,556,637,604,580,572,540,527,626,611,599,
 573,548,568,623,591,1388,1364,1453,1055,951,984],
 [22,24,17,39,37,31,41,19,34,30,21,13,25,51,105,69,88,66,
 53,73,60,91,80,99,52,252,353,326,375,421,376,408,365,
 312,333,332,344,337,373,405,374,327,393,317,286,350,227,
 308,588,565,637,604,554,513,580,572,626,611,507,487,599,
 573,623,591,529,499,1769,1774,1754,1131,1127,1128],
 [22,24,27,40,34,13,25,58,51,82,100,79,94,105,66,71,104,
 83,74,56,72,78,96,75,65,87,90,91,86,70,106,99,98,62,
 49,52,356,315,259,240,272,307,298,304,351,322,251,217,
 207,269,267,213,254,328,319,214,231,226,281,228,358,235,
 720,692,739,764,722,1449,710,672,724,728,715,1421,769,903,
 2709,1942,2660,2092],
 [22,24,27,41,40,34,13,25,51,67,61,82,100,79,94,105,59,77,
 83,64,74,102,72,54,78,96,75,65,87,91,86,106,93,99,98,
 62,49,52,342,259,240,272,291,221,217,207,269,238,213,328,
 308,303,226,281,228,330,220,630,819,696,752,636,863,684,
 694,724,728,715,1040,1265,2713,2410,2455,3863,2649,2284,
 2411,3314,1978,5851,4948],
 [22,24,27,41,40,34,13,25,51,67,61,82,100,79,94,105,76,59,
 95,77,83,64,74,72,54,78,96,75,65,87,91,86,106,93,99,
 98,62,49,52,342,259,240,272,291,247,248,264,261,310,221,
 217,207,269,238,308,303,231,226,281,228,330,220,696,752,
 1333,684,694,1265],
 [22,24,27,41,40,34,13,25,51,67,61,82,100,79,94,105,76,59,
 95,77,83,64,74,102,72,54,78,96,75,65,87,91,86,106,93,
 99,98,62,49,52,342,259,240,272,291,248,264,261,310,221,
 217,207,269,238,308,303,226,281,228,330,220,696,752,1333,
 684,694,1265],
 [22,24,27,41,40,34,13,25,58,51,67,61,82,100,79,94,105,85,
 92,88,66,76,59,95,77,71,104,83,64,74,102,73,107,84,56,
 72,54,78,96,75,65,87,91,86,70,106,93,99,98,62,49,52],
 [22,24,27,41,40,34,13,25,58,51,82,100,79,94,105,66,77,71,
 104,83,74,102,73,56,72,78,96,75,65,87,91,86,70,106,99,
 98,62,49,52,356,315,259,240,272,298,304,351,251,434,383,
 217,207,269,213,254,328,214,281,228,358,235,720,764,722,
 1449,710,728,715,1421],
 [22,24,27,41,40,34,13,25,58,67,61,82,79,105,85,88,66,59,
 77,71,104,64,74,102,107,84,56,54,96,75,87,91,70,93,99,
 98,49,52,471,372,316,492,375,443,432,475,347,345,520,332,
 424,355,542,423,377,484,327,385,283],
 [22,24,27,41,40,34,13,25,58,67,61,82,100,79,94,105,85,88,
 66,59,77,71,104,64,74,102,73,107,84,56,54,96,75,65,87,
 91,70,93,99,98,62,49,52,334,240,298,351,229,309,318,216,
 288,436,207,260,348,323,258,301,912,1063,1122,1289],
 [22,24,27,41,40,34,13,25,58,67,61,82,100,79,94,105,85,88,
 66,76,59,95,77,71,104,64,74,102,107,84,56,54,96,75,65,
 87,91,70,93,99,98,62,49,52,334,240,229,248,309,318,216,
 288,436,207,260,348,323,258,301,847,882],
 [22,24,27,41,40,34,13,25,58,82,79,105,66,59,71,104,74,
 102,107,84,56,96,75,87,91,70,99,98,49,52,372,316,492,
 432,475,520,332,424,542,423,377,327,385,283,356,315,259,
 272,293,251,434,383,217,269,214,358,235,578,496,530,537,
 574,450,607,525,534,546,532,548,601,396,720,710,1555,1011,
 1511,967,885,2115,2043],
 [22,24,27,41,40,34,13,25,58,82,79,105,66,59,71,104,74,
 102,107,84,56,96,75,87,91,70,99,98,49,52,471,492,432,
 347,345,520,332,424,355,542,423,377,484,327,385,283,356,
 315,259,272,293,251,434,383,217,269,214,358,235,551,495,
 496,530,540,562,538,525,534,548,720,710,2197,2127,905,
 1017,2276,2848],
 [22,24,27,41,40,34,13,25,58,82,105,66,59,71,104,74,102,
 56,96,91,70,99,98,52,471,432,347,345,520,355,542,484,
 327,385,322,264,261,212,266,404,319,281,228,299,306,325,
 616,565,622,493,564,531,560,503,524,506,612,579,504,603,
 610,573,462,552,595,569,442,539,566,742,718,1148,2535,827,
 992,1115,2453,857,1933,1663,1039,1416,1077,1096,1332,1927,
 1590,848,1002,1445,1085,1147,1284,1706,1571,1495,1994,1751,
 1554,1622,1572,1967,1843,1723,1525,1594,1636,1680,2888,2502,
 2761,2719,1973,1881,2006,1875,3661,3454,2997,2921,2913,3166,
 3069,2927,4084,3038,8389,4939,3669,4728,3185,6624,5292,5464,
 8062,6263],
 [22,24,27,41,40,34,13,25,67,61,79,105,66,77,64,74,107,84,
 54,96,91,93,49,52,471,492,347,345,332,424,355,423,377,
 484,283,186,304,247,276,292,202,254,231,209,278,588,551,
 495,570,556,592,416,524,506,485,508,474,562,538,465,571,
 494,452,517,559,568,516,431,486,635,697,628,664,2145,827,
 992,998,1069,2127,1093,1183,1285,1263,1044,1506,1076,1137,
 951,1142,1230,986,1536,1058,1420,1396,1218,917,1429,1798,
 2588,2162,2911,1642,1515,1744,2433,1617,2316,1980,2312,4177,
 3388,2417,3647,3790,2644,5020,3459,4101,2610,3718,4450,4275,
 8197,6326],
 [22,24,27,41,40,34,13,25,67,61,82,79,105,66,59,77,64,74,
 107,84,54,96,75,87,91,93,99,98,49,52,372,316,492,432,
 475,520,332,424,542,423,377,327,385,283,342,259,272,310,
 221,388,217,269,308,303,330,220,578,496,530,574,450,626,
 607,525,534,546,532,601,623,396,696,752,684,694,1050,1555,
 1011,1026,1511,967],
 [22,24,27,41,40,34,13,25,67,61,82,79,105,66,59,77,64,74,
 107,84,54,96,75,87,91,93,99,98,49,52,471,372,316,492,
 432,347,345,332,424,355,542,423,377,484,327,385,283,342,
 259,272,310,221,388,217,269,308,303,330,220,496,530,626,
 525,534,603,623,696,752,684,694,1759,1767,1050,1111,1026,
 1227,1358,1397],
 [22,24,27,41,40,34,13,25,67,61,82,100,79,94,105,76,59,95,
 77,64,74,102,54,96,75,65,87,91,93,99,98,62,49,52,334,
 259,240,272,291,248,264,261,310,309,318,216,288,207,308,
 303,260,348,323,258,220,301,1482,696,752,935,1333,862,703,
 778,1635,847,707,845,808,684,694,979,725,795,1708,882,717,
 941,799,2566,3315,2864,2259,1930,2758,2278,1998,7365,6028,
 6544,4597],
 [22,24,31,19,30,58,51,67,61,82,100,79,94,105,69,85,88,89,
 66,76,59,77,53,71,55,104,64,108,74,101,102,73,107,84,
 56,72,54,78,96,60,75,87,90,91,86,70,93,80,99,81,98,49,
 68,52,57],
 [22,24,33,17,37,31,35,28,19,34,30,13,25,51,79,69,85,88,
 77,53,73,54,60,80,49,237,384,381,481,422,408,541,364,
 425,366,346,337,476,361,444,368,491,371,286,472,244,212,
 266,299,306,616,565,597,604,531,619,572,617,611,504,610,
 573,605,591,497,803,820,1762,1766,1803],
 [22,24,35,34,13,82,79,94,105,89,59,53,71,104,74,102,56,
 78,75,90,70,80,98,49,52,57,492,347,520,355,484,283,342,
 222,259,272,322,264,293,329,255,266,251,276,388,434,223,
 217,269,319,214,246,281,358,349,305,306,235,209,578,565,
 397,530,622,604,453,564,589,572,560,412,508,607,611,448,
 534,603,573,417,552,613,591,569,454,486,1378,720,761,1488,
 710,747,1148,851,1248,839,1115,789],
 [22,24,37,27,35,40,34,13,58,51,67,61,82,100,79,105,85,92,
 88,89,66,59,95,77,71,104,83,64,74,101,102,73,107,84,56,
 72,54,96,75,65,87,90,91,70,106,93,99,98,62,49,52,57],
 [22,24,37,27,35,40,34,13,58,67,61,82,79,105,85,88,66,59,
 77,71,104,64,74,102,107,84,56,54,96,75,87,91,70,93,99,
 98,49,52,471,372,492,381,443,432,360,475,347,520,366,424,
 355,363,542,423,484,368,385,283,236],
 [22,24,37,27,35,40,34,13,58,67,61,82,100,79,105,85,88,89,
 66,59,95,77,71,104,64,74,102,107,84,56,54,96,75,65,87,
 91,70,93,99,98,62,49,52,57,334,240,229,230,248,309,270,
 288,436,207,260,246,348,273,301,847,882],
 [22,24,37,27,35,40,34,13,67,79,105,88,66,71,64,74,107,54,
 96,87,91,99,49,52,471,492,381,443,475,347,355,363,423,
 283,236,304,247,261,212,251,292,254,231,228,299,235,278,
 588,565,537,556,592,624,526,416,518,564,580,589,572,524,
 450,489,508,465,571,581,494,452,514,552,613,396,502,431,
 486,754,741,1079,1044,1020,1076,933,1542,1983,1730,1419,
 969,1125,951,986,885,1058,984,1526,2089,1773,1019,1090,917,
 1987,2174,3860,3685,4208,3505,3191,5304,3319,4888,7414,7579]
  ,[22,24,37,27,35,40,34,13,67,82,79,105,85,88,59,77,71,
 104,64,102,107,84,56,54,75,91,70,93,98,49,492,381,443,
 475,347,366,424,355,363,484,283,236,342,315,291,227,329,
 266,276,388,383,238,349,306,209,578,551,592,624,416,589,
 560,489,508,607,562,571,590,581,613,569,502,486,577,727,
 736,2108,902,2054,965],
 [22,24,37,27,35,40,34,13,67,82,79,105,88,66,59,71,64,74,
 102,107,84,54,96,75,87,91,99,49,52,471,372,492,381,443,
 432,360,475,347,520,366,424,355,363,542,423,283,236,342,
 315,259,322,320,221,388,383,217,319,303,220,531,549,504,
 544,497,480,1062,1040,2451,1797,2436,2438,1564,2517,2406,
 1612,2595,933,1130,917],
 [22,24,37,27,40,34,58,67,61,82,79,105,85,88,66,59,77,71,
 104,64,74,102,107,84,56,54,96,75,87,91,70,93,99,98,49,
 52,471,372,492,381,375,443,432,370,360,475,347,520,366,
 332,424,355,362,363,542,423,484,368,327,385,283,249,236],
 [22,24,37,31,41,19,34,30,25,51,67,61,79,105,88,66,76,53,
 71,104,64,108,74,84,56,72,54,87,91,86,70,93,49,68,52,
 342,186,208,304,247,248,264,329,255,212,201,276,292,202,
 277,223,217,231,226,281,192,209,278,959,644,1333,1192,823,
 864,807,635,1048,665,871,1265,829,787,628,2640,2608,2430,
 2567,2431,2868],
 [22,24,37,31,41,19,34,30,25,51,67,61,82,100,79,105,88,66,
 76,59,104,64,108,74,102,56,72,60,75,87,91,86,70,98,49,
 68,52,342,222,259,248,264,261,251,201,276,223,217,319,
 295,308,226,281,228,235,192,209,796,784,696,1333,762,864,
 871,765,684,1421,1053,1265,785,829,4261,2362,4528,2442],
 [22,24,37,41,34,25,51,67,61,82,100,79,105,92,88,66,76,59,
 95,53,71,83,64,108,74,102,54,60,75,65,87,91,86,93,98,
 62,49,68,52,342,222,259,320,248,264,261,310,309,329,221,
 288,201,276,319,303,226,281,228,220,301,192,209,796,1333,
 974,703,808,685,864,1265,799,699,829,2033,2418,2056,2559,
 2061,3715,4146],
 [22,24,37,41,34,25,58,51,67,61,82,100,79,105,69,85,92,88,
 66,76,59,95,77,53,71,104,83,64,108,74,102,73,107,84,56,
 72,54,96,60,75,65,87,91,86,70,106,93,80,99,98,62,49,
 68,52],
 [22,24,37,41,34,25,79,69,85,88,66,76,59,53,71,64,108,102,
 84,54,60,75,91,86,70,93,80,99,98,49,68,52,492,443,432,
 484,385,283,342,315,322,266,319,303,250,578,616,464,551,
 490,622,597,511,560,533,603,610,519,546,563,452,752,876,
 1333,800,697,694,853,1265,903,664,1483,1055,1555,1305,1391,
 1245,1829,933,1542,1190,951,1454,1377,1130,1511,1182,1299,
 1116,1842,984,1526,1274,917,1348,1204,2200,2162,2094,1422,
 2310,2077,2253,2046,2067,2042,2707,2280,2290,1390,2052,1980,
 2036,2186,1986,2122,4986,8096,5326],
 [22,24,37,41,34,25,79,105,69,85,88,59,53,71,64,108,102,
 84,54,60,75,70,93,98,49,68,492,443,484,283,342,322,320,
 227,329,266,206,216,435,388,383,319,303,250,349,306,192,
 209,335,578,616,622,597,526,558,416,589,619,511,560,607,
 617,474,562,603,610,519,546,452,613,605,535,569,486,1507,
 716,668,1597,745,671,698,645,1483,1211,1520,1270,1537,1329,
 1079,1601,1446,1392,1296,1290,1250,1106,1548,1443,1722,1406,
 1415,1189,1369,1295,1916,1889,1923,2041,1837,1902,1831,2298,
 1715,3974,3148,4633,3102,5427,4609],
 [22,24,37,41,34,25,79,105,69,85,88,59,64,108,102,54,60,
 75,91,86,70,93,98,49,68,52,492,443,484,283,342,291,298,
 322,359,350,320,227,266,201,276,388,238,213,319,295,308,
 303,228,349,306,192,209,578,616,592,622,597,526,558,416,
 511,560,508,607,617,571,603,610,519,546,613,605,535,569,
 486,722,1272,727,715,1053,736,1483,1211,1520,1537,1329,
 1760,2600,1933,1663,902,1815,2492,1927,1590,1773,965,2124,
 1987,2104,1994,2387,2184,2097,1967,2399,2273,4689,4660,5635,
 5469,5625,6004,4678,4635,5241],
 [22,24,37,41,34,25,79,105,69,85,88,66,76,59,64,108,74,
 102,60,75,70,93,80,99,98,49,68,52,492,443,432,520,484,
 385,283,322,359,350,320,266,206,216,388,303,358,349,306,
 239,258,622,597,604,526,558,511,560,607,617,611,519,546,
 613,605,591,535,569,1482,1449,1272,823,1400,893,1661,1421,
 1053,923,1424,947,1483,1211,1520,1537,1329,2717,2373,1760,
 2600,1933,1663,2039,2146,1730,2827,2335,1815,2492,1927,1590,
 2098,2112,1773,2124,1987,2104,1994,2381,2174,2387,2184,2097,
 1967,2399,2273,5635,5469,5625],
 [22,24,40,34,13,25,58,67,61,82,79,105,85,88,66,59,77,71,
 104,64,74,102,107,84,56,54,96,75,87,91,70,93,99,98,49,
 52,471,372,316,394,492,381,375,443,432,475,347,345,429,
 520,366,332,424,355,542,423,377,419,484,368,327,385,283],
 [22,24,41,13,82,94,105,69,88,59,53,104,102,56,78,60,75,
 87,70,93,80,98,49,57,347,332,313,355,423,484,327,354,
 283,350,244,227,230,388,217,308,214,250,246,349,209,335,
 616,467,496,469,416,619,607,611,449,448,534,510,452,613,
 591,454,486,1482,644,796,668,930,823,665,671,869,2209,777,
 975,2272,991,2717,1760,1426,1188,1111,1954,1197,1446,1296,
 1316,2039,2146,1730,1887,1443,1383,1406,1189,1842,1224,2362,
 2033,4467,2430,4047,2440,1987,2172,1384,1359,1874,1837,1820,
 2174,1398,1306,1901,1831,1739,2298,1465,1390,1900,1814,5709,
 3261,4475,3321,4740,2763,8836,5533,8347,5667,4155,4730,4330,
 8957,3931,3201,4334,2781,4253,9360,7815,7399,9111,8517,8725,
 3992,8676,9129,6071,3905,4049,3198,3037,3007,5304,3890,3823,
 3721,2890,2855,4228,3765,3132,2609,2940,8371,8346,8581,8556,
 6849,8654,6589,6578,7297,6809,6803,6948,8036,6568,6684,6557,
 5211,5676,5666,6034,5041,5044,8684,8287,6023,5599,8612,5316,
 5913,4969,5184,6126,7374,6295,6212,7055,7003],
 [22,24,41,35,13,58,82,100,79,94,105,85,77,53,55,104,74,
 102,73,107,84,56,78,96,60,87,70,80,99,81,98,62,49,57,
 334,315,222,240,272,291,304,351,229,212,243,206,288,436,
 434,383,207,238,254,328,308,348,299,290,239,301,235,335,
 1378,696,720,761,950,1449,887,714,803,674,762,1488,710,
 747,892,1421,1021,795,721,820,693,785,1974,3012,2990,2673,
 2132,1957,2797,2975,2655,2507,2251,5430,5983],
 [22,24,41,35,13,82,79,94,105,77,55,64,74,101,102,107,54,
 96,60,87,93,99,49,52,57,372,492,347,520,355,484,283,356,
 222,259,272,310,318,212,221,201,203,292,388,223,217,269,
 254,295,308,303,330,323,220,192,187,278,578,565,397,530,
 589,572,412,508,448,534,571,603,573,454,486,1482,793,784,
 696,752,750,635,816,765,684,694,769,628,840,964,1056,1111,
 1197,1245,1072,1137,1108,1105,1227,1240,1116,1150,1218,1057,
 3315,4047,1384,1359,1452,1422,1398,1306,1425,1413,1465,1390,
 1337,1428,2002,2021,2011],
 [22,24,41,35,34,13,58,51,61,82,100,79,94,105,85,77,53,
 104,83,74,102,73,107,84,56,72,78,96,60,65,87,91,70,106,
 80,99,98,49,57,356,222,272,304,212,251,434,223,207,269,
 238,254,328,308,214,246,358,299,314,335,700,896,819,696,
 705,889,863,684,710,747,1421,801,869,875,1950,1995,4261,
 1976,2091,4528,1801,1957,3135,4379,4848,4602,5321,5325,9254,
 8144],[22,24,41,35,34,13,58,51,61,82,100,79,94,105,85,
 92,53,104,83,74,102,73,107,84,56,72,78,96,91,70,106,80,
 99,98,62,49,57,356,222,272,291,304,351,322,244,230,255,
 212,243,266,251,434,223,269,238,254,328,319,358,305,299,
 290,306,235,335,696,1449,930,893,803,674,684,1421,947,820,
 693,2132,2251],
 [22,24,41,35,34,13,58,51,61,82,100,79,94,105,85,92,77,53,
 104,83,74,102,73,107,84,56,72,78,96,60,87,91,70,106,80,
 99,98,62,49,57,356,222,272,291,304,351,244,230,212,243,
 251,434,223,269,238,254,328,308,358,299,290,235,335,696,
 1449,930,803,674,684,1421,820,693,2132,2251],
 [22,24,41,35,34,13,58,51,67,61,82,100,79,94,105,69,85,92,
 88,66,59,95,77,53,71,104,83,64,74,101,102,73,107,84,56,
 72,54,78,96,60,75,65,87,91,70,106,93,80,99,98,62,49,
 52,57],
 [22,24,41,35,34,13,58,67,100,79,105,69,85,88,77,53,71,
 104,64,74,101,102,73,107,84,56,54,78,96,75,65,70,93,80,
 99,98,49,52,57,334,315,186,234,240,291,304,351,229,309,
 255,266,206,288,382,436,383,202,253,207,348,305,306,239,
 301,314,1635,1192,1063,714,1708,1344,1289,721],
 [22,24,41,35,34,13,58,67,100,79,105,69,85,88,77,53,71,
 104,64,74,101,102,73,107,84,56,54,78,96,75,70,93,80,99,
 98,62,49,52,57,334,315,186,234,229,255,243,266,206,288,
 436,383,202,253,207,238,254,328,260,348,305,290,306,239,
 301,700,896,793,819,705,889,816,863,892,2865,2715],
 [22,24,41,35,34,13,58,82,79,94,105,85,59,53,104,74,107,
 56,78,96,70,99,49,52,57,372,492,432,283,356,222,272,322,
 244,230,247,293,255,212,266,251,201,292,223,269,319,308,
 231,358,192,278,578,565,397,530,558,416,574,589,572,450,
 412,508,448,534,603,573,452,601,454,486,696,750,803,674,
 807,635,697,921,684,769,787,628,664,875,840,964,1111,1197,
 1245,1072,1741,1137,1108,1455,1227,1240,1116,1150,1218,1057,
 1448,2394,2464,2383,2391,1384,1359,1452,1422,1398,1306,1425,
 1413,1465,1390,1337,1428,5743,5098,2002,2021,2011],
 [22,24,41,35,34,13,67,82,79,94,105,69,88,71,64,74,101,
 102,54,60,75,87,93,49,52,57,492,520,423,283,342,259,304,
 322,359,320,264,329,221,201,276,292,217,254,319,295,303,
 281,330,323,349,220,192,209,278,578,565,397,530,622,604,
 558,453,564,589,572,450,412,508,448,534,603,573,546,417,
 552,601,613,591,396,454,486,1062,925,1333,1040,822,1265,
 1148,851,1248,839,1115,789,1764,1245,1072,1716,1116,1150],
 [22,24,41,35,34,13,79,105,77,64,74,101,107,54,96,60,87,
 93,49,52,57,492,347,355,484,283,356,222,272,304,201,276,
 292,223,269,254,308,192,209,278,578,565,397,530,441,556,
 592,524,412,508,448,465,534,571,603,573,470,568,454,431,
 486,696,750,635,684,918,769,628,840,964,2448,1079,1277,
 1050,1111,1197,1055,1011,1044,1245,1072,1078,1137,1108,951,
 1024,1026,1227,1240,1130,967,986,2228,2492,1590,1317,1273,
 1116,1150,999,1218,1057,917,911,2216,2024,1987,1358,1384,
 1359,1452,1422,1432,1398,1306,2263,1397,1425,1413,1967,1465,
 1390,2191,1389,1337,1428,4758,5709,3261,4434,4257,7287,4224,
 4186,3388,4218,4071,5683,7491,3328,4701,4890,8201,3513,3503,
 5313,4008,4482,3790,4013,3772,2002,2021,2011,3191,3639,3551,
 8471,3276,3905,3595,7495,2906,6033,3622,3729,3673,5026,3247,
 3890,4039,3712,3218,7449,2897,5927,3570,5241,3166,6876,3260,
 4228,4100,3447,3098,8367,2733,5560,3612,9109,9035,7908,8842,
 7727,7711,5320,8948,5545,4994,6651,5811,5522,9040,6031,8319,
 8267,7103,7136,7133,6114,6816,7338,6689,8658,7541,7873,8956,
 8805,7707,8237,6776,7991,7259,6414,6099,6846,7963],
 [22,24,41,35,34,13,82,79,94,105,53,71,104,64,74,101,56,
 54,78,60,75,87,70,93,80,98,49,52,57,492,347,520,355,
 423,484,283,342,356,222,259,272,304,322,247,264,329,276,
 388,434,223,217,269,254,319,231,281,349,209,578,565,397,
 530,622,604,453,564,589,572,412,508,607,611,448,534,603,
 573,417,552,613,591,454,486,1148,851,1248,839,1115,789],
 [22,24,41,35,34,13,82,79,94,105,59,53,104,64,74,101,102,
 56,78,75,70,80,98,49,52,57,492,347,520,355,484,283,342,
 259,293,329,251,276,217,319,308,235,209,578,616,565,430,
 501,397,530,589,619,572,466,506,412,508,426,487,448,534,
 603,610,573,456,499,454,486,796,696,1333,762,864,871,684,
 1265,785,829,1148,851,1248,839,840,1115,964,1111,1954,1197,
 1245,1829,1072,1137,1887,1108,1227,1945,1240,1116,1842,1150,
 1218,1864,1057,1210,1180,1384,1359,1283,1244,1452,1422,1195,
 1141,1398,1306,1226,1163,1425,1413,1176,1132,1465,1390,1259,
 1202,1337,1428,2002,5903,2021,5802,2011,5185],
 [22,24,41,35,34,13,82,79,94,105,59,77,53,104,64,74,101,
 102,107,56,54,78,96,70,93,99,52,372,492,432,347,520,355,
 484,283,342,356,222,259,272,255,212,266,201,292,404,386,
 223,217,269,308,192,278,325,343,578,565,397,530,589,572,
 412,508,448,534,603,573,454,486,696,1333,750,807,635,697,
 684,1265,769,787,628,664,840,964,1111,1197,1245,1072,1137,
 1108,1227,1240,1116,1150,1218,1057,1384,1359,1452,1422,1398,
 1306,1425,1413,1465,1390,1337,1428,2002,2021,2011],
 [22,24,41,35,105,53,71,55,104,64,108,74,101,56,54,78,60,
 75,87,70,93,80,81,98,49,68,52,57,347,520,355,423,484,
 283,342,356,186,193,234,222,259,272,304,322,247,264,329,
 276,388,434,202,200,253,223,217,269,254,319,231,281,349,
 209,578,565,451,397,530,622,604,453,564,589,572,412,508,
 607,611,413,448,534,603,573,417,552,613,591,454,486,1148,
 851,1248,839,1115,789],
 [22,24,41,35,105,59,77,53,55,104,64,108,74,101,102,107,96,
 70,93,99,52,492,432,347,520,484,283,342,356,186,193,234,
 222,259,272,310,293,318,255,212,266,201,203,292,404,437,
 386,202,200,253,223,217,269,308,192,187,278,325,357,343,
 578,565,551,397,530,574,589,572,412,508,562,448,534,603,
 573,454,486,696,1333,750,808,762,873,807,635,697,684,1265,
 769,799,785,798,787,628,664,840,964,1111,1197,1245,1072,
 1239,1137,1108,1227,1240,1116,1150,1193,1218,1057,1384,1359,
 1452,1422,1398,1306,1425,1413,1465,1390,1337,1428,2002,2021,
 2011],[22,31,41,19,30,51,67,61,82,100,94,105,88,59,53,
 71,104,64,108,74,101,102,84,56,72,54,78,60,75,70,93,81,
 98,52,342,279,222,259,291,298,331,329,206,216,201,276,
 404,437,386,223,217,238,213,319,306,343,788,796,739,764,
 814,878,1042,847,707,695,864,704,662,957,1023,1786,1505,
 871,724,728,757,1771,1379,1929,2355,2421,2550,2259,2270,
 3256,3326,2134,2351,2075,3347,2345,2563,4808,4553,1978,2327,
 2462,4616,4290,5738,3638,6996,3162,4054,5615,5390,5590,4732,
 5808,7231,5499,6076,5954,8494,5314,5431,4431,6002,5597,8620,
 6541,6127,8529,6702,7417,8235,9322,8228,7131,7219,8278,7158,
 7155,8247,6793,6224,6426,7762,6311,6936],
 [22,35,34,25,97,82,79,94,105,69,85,88,77,53,104,108,107,
 103,56,78,87,70,93,80,98,68,372,492,443,484,385,356,307,
 291,304,350,227,293,212,270,206,276,435,434,267,238,254,
 308,358,349,305,299,273,239,209,335,588,578,592,594,637,
 622,574,583,580,589,560,612,579,626,607,571,586,599,603,
 601,595,623,613,569,566,576,722,1272,1334,727,845,715,
 1053,1198,736,941,1442,1800,1350,1759,1372,1767,1760,1262,
 1663,1730,1175,1815,1169,1590,1773,1300],
 [22,37,13,58,51,61,79,85,92,88,89,66,59,77,53,104,102,73,
 107,84,54,87,70,106,93,80,99,98,62,49,52,407,360,332,
 313,363,327,354,236,351,350,229,244,227,243,270,206,434,
 260,214,250,299,290,273,239,567,526,558,554,458,560,533,
 466,528,474,546,563,478,555,535,569,529,456,1378,1112,
 1063,893,1488,918,1289,947,827,998,1229,1079,1205,1234,
 1206,1419,1355,1106,1070,1317,1349,1363,1987,2076,1853,1994,
 1849,1854,2174,2135,1883,2184,1832,1863,1967,2121,1846,2273,
 1890,1859,1973,2060,2006],
 [22,37,13,58,51,61,79,85,92,88,89,66,59,95,77,53,74,102,
 73,107,84,54,87,70,106,93,80,99,98,62,49,52,407,360,
 332,313,363,327,354,236,350,320,229,244,270,206,434,303,
 260,214,299,290,273,239,567,526,558,554,458,533,466,528,
 474,562,563,478,555,535,569,529,456,1378,1112,1710,893,
 1488,918,1639,947,827,998,1229,1079,1601,1205,1234,1534,
 1206,1419,1741,1355,1106,1548,1070,1317,1649,1349,1363,1665,
 2076,1853,1849,1854,2135,1883,1832,1863,2121,1846,1890,1859,
 1973,2060,2006],
 [22,37,13,58,51,67,61,97,82,100,79,105,69,85,92,88,89,66,
 76,59,95,77,53,71,55,104,83,64,74,101,102,73,107,84,
 103,56,72,54,96,60,75,65,87,90,91,86,70,106,93,80,99,
 81,98,62,49,52,57],
 [22,37,13,61,79,85,88,89,66,76,77,53,104,74,101,107,84,
 87,90,91,70,93,80,99,81,98,57,443,424,423,484,385,356,
 304,350,331,293,212,216,435,434,254,308,311,358,299,258,
 335,588,578,482,464,490,430,592,594,637,622,567,526,554,
 458,574,583,580,589,545,511,533,466,612,579,626,607,528,
 474,507,426,571,586,599,603,550,519,563,478,601,595,623,
 613,555,535,529,456,566,576,1148,2209,1442,1800,1248,2250,
 1350,1759,1115,2272,1372,1767],
 [22,37,13,61,79,85,88,89,66,77,53,104,74,107,84,87,90,91,
 70,93,80,99,98,443,424,423,484,385,356,300,222,304,350,
 302,310,293,212,435,386,434,287,223,254,308,321,330,358,
 299,258,335,588,578,451,592,594,637,622,554,458,574,583,
 580,589,612,579,626,607,507,426,413,571,586,599,603,462,
 601,595,638,623,613,529,456,566,576,804,726,1670,810,702,
 1500,1442,1800,1350,1759,1372,1767,1229,1079,1003,1335,1205,
 1234,981,1304,1206,1419,1095,1355,1106,946,1074,1405,1070,
 1317,1214,1349,1363,1060,1080,1987,1656,2919,1994,2174,1606,
 2932,2184,1967,1611,3004,2273,4674,2943,3372,4284,2933,3474]
  ,[22,37,13,61,79,105,69,85,88,89,66,76,77,53,55,104,74,
 107,84,103,56,87,90,91,86,70,93,80,99,81,98,492,443,
 424,423,484,385,356,279,186,304,350,293,329,255,212,435,
 434,294,202,254,308,358,349,305,299,335,588,578,551,592,
 594,624,637,622,574,583,598,580,589,612,579,625,626,607,
 562,571,586,581,599,603,601,595,638,623,613,566,576,587,
 1442,1800,1350,1759,1372,1767],
 [22,37,13,61,79,105,69,85,88,89,66,77,53,55,104,74,107,
 84,87,90,91,70,93,80,99,98,57,492,443,424,423,484,385,
 356,304,350,230,302,310,293,212,216,203,435,434,254,308,
 321,330,358,349,305,299,258,187,335,588,578,592,594,637,
 622,574,583,580,589,612,579,626,607,571,586,599,603,601,
 595,623,613,566,576,1272,1334,912,674,1053,1198,1122,693,
 1442,1800,1350,1759,1372,1767,1229,1079,1205,1234,1206,1419,
 1355,1106,1070,1317,1349,1363,1987,1994,2174,2184,1967,2273,
 3148,2667,4161,3102,2877,3534],
 [22,37,13,61,97,82,79,105,69,85,88,89,66,76,77,53,104,74,
 101,107,84,103,56,96,60,87,90,91,86,70,93,80,99,81,98,
 372,492,443,424,423,484,385,356,304,350,331,293,212,435,
 386,434,254,308,311,358,299,335,343,588,578,592,594,637,
 622,574,583,580,589,612,579,626,607,571,586,599,603,601,
 595,623,613,566,576,1442,1800,1350,1759,1372,1767],
 [22,37,13,61,100,79,85,92,88,89,66,59,95,77,53,104,74,
 102,73,107,84,72,54,65,87,70,106,93,80,99,98,62,49,52,
 407,360,332,313,363,327,354,236,350,229,244,270,206,388,
 436,434,260,214,299,273,239,567,526,554,458,533,466,528,
 474,563,478,555,535,529,456,1482,2045,1378,1112,893,1661,
 1963,1488,918,947,827,998,1229,1079,1205,1234,1206,1419,
 1355,1106,1070,1317,1349,1363,2076,1853,1849,1854,2135,1883,
 1832,1863,2121,1846,1890,1859,1973,2060,2006],
 [22,37,13,67,79,85,92,88,89,66,59,95,71,74,102,73,107,84,
 54,75,65,90,91,70,106,93,80,99,98,62,49,52,375,407,360,
 332,313,327,354,236,342,334,315,322,359,266,388,436,319,
 295,303,260,214,482,464,551,490,430,567,526,558,533,466,
 528,474,562,550,519,546,563,478,752,935,720,800,697,694,
 843,710,903,664,758,740,1305,1114,1190,1173,1377,1257,1182,
 1034,1274,1209,1204,1170,1674,1560,1894,1563,1528,1958,1721,
 1553,1790,1474,1531,2188,1659,1589,1778,1604,1479,1982,1943,
 1949,2000],
 [22,37,13,67,79,85,92,88,89,66,59,95,71,83,64,74,102,73,
 107,84,54,75,65,90,91,70,106,93,80,99,98,62,49,52,375,
 407,360,332,313,327,354,236,342,334,315,322,359,266,319,
 295,303,482,464,551,490,430,567,526,560,533,466,550,519,
 546,563,478,752,1333,862,800,697,694,1265,939,903,664,758,
 1555,1305,1114,1052,933,1542,1190,1173,1454,1377,1257,1511,
 1182,1034,1065,984,1526,1274,1209,1348,1204,1170,1674,1560,
 2010,1563,1528,1721,1553,1474,1531,2236,1659,1589,1604,1479,
 1943,1949,2000],
 [22,37,13,100,79,85,92,88,89,66,59,71,83,64,74,102,73,
 107,84,72,54,75,90,91,70,106,93,80,99,98,62,49,52,375,
 407,360,332,313,327,354,236,342,334,356,315,351,322,359,
 243,266,388,436,434,328,319,295,303,482,464,490,430,567,
 526,533,466,528,474,550,519,563,478,752,800,901,697,694,
 903,897,664,758,740,1305,1114,1190,1173,1377,1257,1182,
 1034,1274,1209,1204,1170,1674,1560,1563,1528,1721,1553,1474,
 1531,1659,1589,1604,1479,1943,1949,2000],
 [22,37,27,41,35,40,34,25,58,51,67,61,97,82,100,79,105,85,
 92,88,66,59,95,77,71,104,83,64,108,74,102,73,107,84,
 103,56,72,54,96,75,65,87,91,70,106,93,99,98,62,49,68,
 52],
 [22,37,27,41,35,40,34,25,58,67,61,82,79,105,85,88,66,59,
 77,71,104,64,74,102,107,84,56,54,96,75,87,91,70,93,99,
 98,49,52,471,289,372,492,443,432,370,475,336,347,520,424,
 355,362,542,409,423,484,385,283,249],
 [22,37,27,41,35,40,34,25,58,67,82,79,88,59,77,71,104,64,
 102,107,84,56,54,87,91,70,98,49,52,471,289,372,443,432,
 370,475,336,347,520,424,355,362,409,423,385,283,249,315,
 291,227,329,212,251,276,383,238,250,235,209,490,515,589,
 533,524,450,563,494,396,864,635,829,628,2209,2250,2272,
 1137,1218],
 [22,37,27,41,35,40,34,25,58,67,82,79,88,59,77,71,104,64,
 102,107,84,56,54,87,91,70,98,49,52,471,492,475,336,347,
 424,355,362,409,423,484,283,249,315,291,227,329,212,251,
 276,383,238,250,235,209,482,551,592,606,416,589,533,524,
 508,528,562,571,620,563,494,452,486,864,635,829,628,992,
 1069,1287,1093,1137,1366,1142,1218,1798,1744],
 [22,37,27,41,35,40,34,25,58,67,82,79,105,85,88,59,77,71,
 104,64,102,107,84,56,54,87,91,70,98,49,471,492,443,475,
 336,347,424,355,362,409,423,484,283,249,315,291,227,329,
 212,251,276,383,238,349,299,235,209,482,551,592,606,416,
 589,508,528,562,571,620,590,613,486,577,727,736,2108,902,
 2054,965],
 [22,37,31,41,19,30,51,67,61,97,82,100,88,66,76,59,53,71,
 55,104,64,108,74,101,102,84,103,56,72,54,91,86,70,93,
 98,52,57,342,193,300,222,259,248,264,329,255,212,266,201,
 276,203,404,437,200,287,223,217,226,281,325,357,796,1333,
 823,864,807,635,697,957,1023,1246,871,1265,792,932,1151,
 2430,3347,2338,2314,3681,3717,2523,2229,3293,3992,6071],
 [22,37,31,41,19,30,51,67,82,100,105,88,59,77,53,71,64,
 108,102,73,107,84,56,72,54,96,93,98,49,68,52,336,313,
 363,409,236,342,315,193,320,227,266,221,201,276,388,383,
 200,303,250,306,220,192,209,482,430,515,397,496,458,461,
 453,493,466,524,412,485,473,528,426,488,448,525,478,494,
 417,462,456,498,454,516,463,777,837,975,826,991,891],
 [22,37,31,41,19,30,51,67,105,77,53,71,64,108,73,107,84,
 96,93,80,99,49,68,52,336,313,409,354,236,342,227,310,
 309,221,388,383,250,330,348,306,220,482,469,453,493,598,
 511,560,412,485,528,449,426,488,519,546,417,462,638,442,
 456,498,454,516,480,878,1597,817,826,891,1079,1601,857,
 867,1196,1225,1253,1064,1081,945,1078,1106,1548,926,1136,
 1142,1230,1241,1124,1203,949,1046,1085,1147,1138,999,4902,
 3674,2550,4477,2824,1579,1429,1648,1574,1573,1628,1554,1633,
 1624,1515,1545,1673,1682,1636,1535,5813,3313,3103,3744,2664,
 3310,3497,2597,2948,4295,2923,2616,5015,3350,3003,2900,2768,
 2942,4496,2926,2674,2970,2568,3775,5249,9250,7137,2815,4165,
 2708,4339,2731,4754,4513,3372,2845,4270,2605,3378,2742,3405,
 5790,3474,2722,4526,2859,4118,8894,8734,6496,8636,8143,9228,
 7396,8101,5060,8121,7008,6494,7221,7216,6843,5093,5495,6188,
 5100,4961,8317,4830,8718,4997,7728,8105,8071,4928,4587,6618,
 4554,6355,9395,7201,5820,4521,7148,7303,7289,6171,6896,8053,
 6298,8669,8244,7150,7512,7101,6939,6812,7783,6119,6415,7666]
  ,[22,37,31,41,19,30,58,51,67,61,59,77,53,71,74,84,56,
 72,54,96,80,99,98,49,68,52,289,360,336,313,363,354,236,
 186,208,193,300,320,244,280,221,251,202,277,200,303,214,
 262,231,226,281,430,515,501,397,496,458,461,513,412,485,
 426,488,487,478,494,517,417,462,692,739,764,880,1029,921,
 672,724,728,940,961,875,777,834,811,991,958,1073,937,1316,
 1018,1155,910,1067,1009,1224,886,1109,1460,1625,1713,1412,
 1480,1586,1447,1510,1719,1411,1544,1485,1441,1575,1735,1414,
 1431,1543,2235,2143,2025,2164,2059,2214],
 [22,37,31,41,19,30,58,51,67,61,59,77,53,71,104,73,107,84,
 56,72,54,96,70,98,49,68,52,289,360,336,313,363,354,236,
 186,208,193,300,244,280,227,251,201,276,202,277,214,262,
 250,231,430,515,501,397,496,458,461,506,412,485,426,488,
 478,494,517,417,462,692,742,880,921,957,1023,672,718,940,
 875,792,932,777,834,975,811,991,1263,958,1073,1457,937,
 1316,1530,1018,1155,1186,910,1067,1396,1009,1224,1393,886,
 1109,1460,1625,1412,1480,1447,1510,1411,1544,1441,1575,1414,
 1431,2143,2164,2214],
 [22,37,31,41,19,30,58,51,67,61,82,100,79,105,69,85,88,77,
 53,71,55,104,64,108,74,102,73,107,84,103,56,72,54,70,
 93,80,99,98,49,68,52,279,291,298,304,230,266,206,216,
 203,386,294,238,213,254,349,305,299,306,239,258,187,343,
 1272,1334,1112,1053,1198,918,693,3417,3621],
 [22,37,31,41,19,30,58,51,67,61,82,100,79,105,77,53,71,
 104,64,108,74,101,102,73,107,84,56,72,54,96,60,75,70,
 93,80,99,81,98,49,68,52,279,222,259,272,291,298,304,331,
 266,206,216,386,294,223,217,269,238,213,254,311,306,239,
 258,343,814,695,757,753],
 [22,37,31,41,19,30,58,51,67,61,97,82,100,79,105,69,85,88,
 66,76,59,77,53,71,55,104,64,108,74,101,102,73,107,84,
 103,56,72,54,96,60,75,87,91,86,70,93,80,99,81,98,49,
 68,52,57],
 [22,37,31,41,19,30,58,82,100,59,77,53,71,102,73,107,84,
 56,72,54,96,93,80,99,98,49,68,52,289,336,313,363,409,
 354,236,334,356,315,193,300,320,221,436,434,383,303,214,
 262,250,430,515,501,397,496,458,461,506,412,485,426,488,
 478,494,517,417,462,720,719,876,742,880,1029,710,709,853,
 718,940,961,777,837,826,991,891,1263,958,1073,1457,937,
 1316,1530,1018,1155,1186,910,1067,1396,1009,1224,1393,886,
 1109,1460,1625,1412,1480,1447,1510,1411,1544,1441,1575,1414,
 1431,2235,2025,2059],
 [22,37,31,41,19,30,675,648,58,51,67,66,76,59,77,53,71,73,
 107,84,56,72,54,80,99,98,49,68,52,2486,1668,2892,1758,
 289,360,336,313,363,354,236,315,186,208,320,244,280,266,
 206,216,383,202,277,303,214,262,306,239,258,430,515,501,
 554,458,461,466,524,506,507,426,488,478,494,517,529,456,
 498,777,834,975,811,991,968],
 [22,37,34,13,25,58,51,61,97,82,79,85,92,89,66,76,59,77,
 53,104,107,103,56,72,96,60,65,87,90,91,86,70,106,99,98,
 62,49,52,356,208,300,222,229,244,227,247,248,261,212,277,
 287,223,269,328,308,260,214,250,231,226,228,358,235,192,
 870,819,696,887,716,750,914,863,684,1421,874,745,769,628,
 4261,2285,4528,2159],
 [22,37,35,34,13,25,58,51,67,61,97,82,100,79,105,69,85,92,
 88,89,66,59,95,77,53,71,104,83,64,74,102,73,107,84,103,
 56,72,54,96,60,75,65,87,90,91,70,106,93,80,99,98,62,
 49,52],
 [22,37,35,34,13,25,97,82,79,105,69,85,88,89,66,77,53,104,
 74,107,103,56,96,60,87,70,93,80,99,372,492,443,484,356,
 304,350,293,212,270,206,292,435,434,254,308,358,299,273,
 239,278,335,588,578,565,592,594,637,622,604,574,583,580,
 589,572,560,508,612,579,626,607,611,571,586,599,603,573,
 601,595,623,613,591,569,486,566,576,1442,1800,1483,1350,
 1759,1520,1372,1767,1537],
 [22,37,35,34,13,97,82,79,85,88,77,53,104,101,107,84,103,
 56,87,90,91,70,93,80,98,57,372,443,424,423,484,385,356,
 300,222,307,291,304,227,293,329,255,212,435,434,383,287,
 223,254,250,358,349,305,299,335,588,578,451,592,594,574,
 583,580,589,612,579,626,607,413,571,586,601,595,623,613,
 566,576,1507,696,859,1635,893,1597,684,883,1708,947,1442,
 1350,1759,1372,1767,1050,1111,1667,1671,1983,2039,1538,1026,
 1227,1738,1570,2089,2098,1602,1358,1397],
 [22,37,40,58,51,67,61,97,82,100,79,105,69,85,92,88,89,66,
 76,59,95,77,71,55,104,83,64,108,74,101,102,73,107,84,
 103,56,72,54,96,60,75,65,87,90,91,86,70,106,93,99,81,
 98,62,49,68,52,57],
 [22,37,40,58,67,79,105,69,85,88,89,66,76,59,77,71,55,104,
 74,101,102,107,56,54,96,60,75,87,70,93,99,81,98,49,52,
 57,471,492,443,432,370,475,520,355,362,542,484,385,283,
 249,186,244,270,206,216,202,214,273,239,258,565,482,551,
 604,567,558,572,545,560,611,528,562,573,550,546,591,555,
 569,1483,1520,1537],
 [22,37,40,58,67,82,79,105,85,88,59,77,71,64,74,102,107,
 84,56,54,96,75,70,93,99,98,49,52,471,492,443,475,520,
 424,355,362,542,484,385,283,249,315,331,266,270,216,386,
 223,311,303,273,258,343,482,551,397,624,458,453,545,560,
 412,625,426,448,512,550,546,417,638,456,454,463,959,752,
 800,697,694,903,664,851,818,839,831,789,934,1403,1699,
 1091,1555,1052,1542,1171,1250,1156,1454,1126,1511,1456,1415,
 1065,1526,1154,1348,2443,2475,1550,1516,1562,4352,2826,3583,
 2447,3900,2329,4512,2929,4134,2340,3486,2331],
 [22,37,40,61,79,105,69,85,88,89,66,76,59,77,71,55,104,74,
 84,56,54,96,60,75,87,90,86,70,93,99,81,98,49,52,57,
 492,443,432,370,475,424,355,362,542,484,385,283,249,186,
 244,230,206,202,214,246,239,588,616,482,551,637,597,567,
 558,580,619,545,560,626,617,528,562,599,610,550,546,623,
 605,555,569,2979,1800,2957,1759,2995,1767],
 [22,37,40,61,79,105,85,88,89,66,76,59,77,71,55,104,74,
 101,84,56,54,96,60,75,87,90,86,70,93,99,81,98,49,52,
 57,492,443,432,370,475,424,355,362,542,484,385,283,249,
 186,222,244,206,202,223,214,239,588,616,482,551,637,597,
 567,558,580,619,545,560,626,617,528,562,599,610,550,546,
 623,605,555,569,2979,1800,2957,1759,2995,1767],
 [22,37,40,61,79,105,85,92,88,66,59,95,104,83,64,108,74,
 102,73,107,84,54,87,91,70,106,93,99,98,62,49,68,52,381,
 375,407,360,429,366,332,313,363,419,368,327,354,236,342,
 334,356,322,350,329,212,243,388,436,434,319,308,349,299,
 290,482,464,551,567,526,558,545,511,560,528,474,562,550,
 519,546,555,535,569,2628,2835,2762],
 [22,37,40,61,79,105,85,92,88,66,59,95,104,83,64,108,74,
 102,73,107,84,54,87,91,70,106,93,99,98,62,49,68,52,394,
 381,375,407,360,429,366,332,313,419,368,327,354,236,342,
 334,356,322,350,329,212,243,388,436,434,319,308,349,299,
 290,482,464,551,567,526,558,545,511,560,528,474,562,550,
 519,546,555,535,569,758,740,841],
 [22,37,40,61,82,105,85,92,88,66,59,104,83,64,108,74,102,
 73,107,84,56,65,87,91,70,106,93,99,98,62,49,68,52,394,
 381,375,407,360,429,366,332,313,419,368,327,354,236,342,
 334,356,351,322,350,329,212,388,436,434,328,319,308,349,
 299,482,551,467,567,558,469,545,560,479,528,562,449,550,
 546,510,555,569,442,758,740,841],
 [22,37,40,61,82,105,85,92,88,66,59,104,83,64,108,74,102,
 73,107,84,56,65,87,91,70,106,93,99,98,62,49,68,52,394,
 407,360,429,366,332,313,363,419,368,327,354,236,342,334,
 356,351,322,350,329,212,388,436,434,328,319,308,349,299,
 482,551,467,567,558,469,545,560,479,528,562,449,550,546,
 510,555,569,442,1330,971,1012,827,1172,998],
 [22,37,40,82,79,105,69,85,88,89,66,76,59,77,71,55,64,74,
 84,56,54,96,60,75,90,91,86,70,93,99,81,98,49,52,57,
 492,443,432,370,475,520,355,362,542,484,385,283,249,315,
 320,230,266,383,303,246,306,588,616,482,551,637,597,567,
 558,580,619,545,560,626,617,528,562,599,610,550,546,623,
 605,555,569,2979,1483,2957,1520,2995,1537],
 [22,37,40,82,79,105,69,85,88,89,66,76,59,77,71,55,64,74,
 101,84,56,54,96,60,75,91,70,93,99,81,98,49,52,57,492,
 443,432,370,475,520,355,362,542,484,385,283,249,315,320,
 266,270,216,383,303,306,273,258,588,616,482,551,637,597,
 567,558,580,619,545,560,626,617,528,562,599,610,550,546,
 623,605,555,569,2979,1483,2957,1520,2995,1537],
 [22,37,41,58,51,67,61,79,88,59,95,77,53,71,104,83,74,73,
 107,84,56,72,54,96,87,70,106,80,99,98,62,49,68,52,289,
 407,360,336,313,363,354,236,186,208,300,244,280,251,214,
 262,231,430,515,451,397,496,458,461,450,412,485,478,494,
 452,417,462,692,754,670,880,921,672,741,669,940,875,834,
 1391,958,1073,1173,1423,1416,937,1316,1455,1018,1155,1299,
 910,1067,1209,1420,1445,1009,1224,1448,886,1109,1460,1625,
 1563,1412,1480,1447,1510,1411,1544,1659,1441,1575,1414,1431,
 2143,2164,2214],
 [22,37,41,58,51,67,61,79,88,59,95,77,53,71,104,83,74,84,
 56,72,54,96,87,70,106,80,99,98,62,49,68,52,289,407,360,
 336,313,363,354,236,186,208,300,244,280,251,202,277,214,
 262,231,226,281,430,515,451,397,496,458,461,416,412,485,
 426,488,413,478,494,452,417,462,692,739,764,880,921,672,
 724,728,940,875,834,811,958,1073,937,1316,1018,1155,910,
 1067,1009,1224,886,1109,1460,1625,1692,1412,1480,1578,1447,
 1510,1626,1411,1544,1632,1441,1575,1675,1414,1431,1587,2143,
 2164,2214],
 [22,37,41,58,51,67,61,92,88,59,95,77,53,71,104,74,73,107,
 84,56,72,54,96,65,87,70,80,99,98,62,49,68,52,289,407,
 360,336,313,363,354,236,186,208,193,300,229,244,280,288,
 251,202,277,200,260,214,262,231,430,515,397,496,458,461,
 412,485,426,488,478,494,417,462,692,880,900,921,672,940,
 806,875,834,811,958,1073,937,1316,1018,1155,910,1067,1009,
 1224,886,1109,1460,1625,1412,1480,1447,1510,1411,1544,1441,
 1575,1414,1431,2143,2164,2214],
 [22,37,41,58,51,67,61,97,82,100,79,105,69,85,92,88,66,76,
 59,95,77,53,71,55,104,83,64,108,74,101,102,73,107,84,
 103,56,72,54,96,60,75,65,87,91,86,70,106,93,80,99,81,
 98,62,49,68,52,57],
 [22,37,41,58,51,67,82,100,105,88,59,95,77,53,71,64,108,
 102,73,107,84,56,72,54,96,93,80,99,98,62,49,68,52,289,
 336,313,363,409,354,236,315,193,320,229,227,266,221,288,
 383,200,303,260,250,306,220,301,430,515,451,397,496,458,
 461,416,453,493,466,524,450,412,485,426,488,413,448,525,
 478,494,452,417,462,456,498,396,454,516,777,837,975,826,
 991,891],
 [22,37,41,58,51,67,105,92,88,59,95,77,53,71,83,64,108,
 102,73,107,84,56,72,54,96,106,93,80,99,98,62,49,68,52,
 289,336,313,363,409,354,236,315,186,208,193,320,227,243,
 266,221,383,202,277,200,303,250,290,306,220,430,515,397,
 496,458,461,453,493,466,524,412,485,426,488,448,525,478,
 494,417,462,456,498,454,516,777,837,975,826,991,891],
 [22,37,41,58,82,100,105,88,59,95,77,53,71,64,108,102,73,
 107,84,54,96,93,80,99,98,49,68,52,289,336,313,409,354,
 236,334,356,315,193,240,320,227,310,309,243,266,221,382,
 436,434,383,200,303,250,290,306,220,301,314,430,515,397,
 496,458,461,453,493,598,466,524,412,485,426,488,448,525,
 478,494,417,462,456,498,454,516,942,809,808,685,884,799,
 699,777,837,975,826,991,891,1056,1145,1239,1025,1105,1083,
 1193,1051,2363,2562],
 [22,37,41,58,82,100,105,88,59,95,77,53,71,64,108,102,73,
 107,84,56,72,54,96,106,93,80,99,98,62,49,68,52,289,336,
 313,363,409,354,236,334,356,315,193,320,229,227,266,221,
 436,434,383,200,303,260,250,306,220,430,515,451,397,496,
 458,461,416,453,493,466,524,450,412,485,426,488,413,448,
 525,478,494,452,417,462,456,498,396,454,516,777,837,975,
 826,991,891],
 [22,37,41,79,105,69,85,88,59,53,71,55,64,108,74,102,84,
 103,54,70,93,80,99,98,49,68,52,492,443,520,484,385,283,
 342,315,322,320,230,329,255,212,266,206,216,386,388,383,
 294,319,303,349,305,299,306,239,258,187,343,578,616,464,
 551,622,597,526,558,589,619,511,560,607,617,474,562,603,
 610,519,546,613,605,535,569,1318,737,674,1340,755,693,
 1483,1211,1520,1270,1537,1329,1426,1699,1446,1392,1290,1250,
 1443,1722,1406,1415,1369,1295,2172,1837,1902,1831,2298,1715]
  ,[22,37,41,79,105,69,85,88,66,76,59,53,71,55,64,108,74,
 101,102,84,103,54,91,86,70,93,80,99,81,98,49,68,52,57,
 492,443,432,520,484,385,283,342,315,279,322,320,329,255,
 212,266,388,383,294,319,303,349,305,299,306,578,616,464,
 551,622,597,526,558,589,619,511,560,607,617,474,562,603,
 610,519,546,613,605,535,569,1483,1211,1520,1270,1537,1329],
 [22,37,41,79,105,69,85,88,66,76,59,53,71,64,108,74,101,
 102,84,54,60,75,70,93,80,99,81,98,49,68,52,57,492,443,
 432,520,484,385,283,342,315,322,331,320,329,266,206,216,
 388,383,319,311,303,349,306,239,258,578,616,482,464,551,
 622,597,567,526,558,589,619,545,511,560,607,617,528,474,
 562,603,610,550,519,546,613,605,555,535,569,1483,1211,
 1520,1270,1537,1329],
 [22,37,41,79,105,88,59,53,71,55,64,108,74,102,84,103,54,
 70,93,80,99,81,98,49,68,52,57,492,520,484,385,283,342,
 315,279,322,320,230,329,266,388,383,294,319,303,246,349,
 306,578,616,464,551,430,515,397,496,622,597,526,558,458,
 461,453,493,589,619,511,560,466,524,412,485,607,617,474,
 562,426,488,448,525,603,610,519,546,478,494,417,462,613,
 605,535,569,456,498,454,516,1490,851,1483,1211,992,839,
 1520,1270,1069,789,1537,1329],
 [22,37,41,79,105,88,59,53,71,64,108,74,102,84,54,70,93,
 80,99,98,49,68,52,492,520,484,385,283,342,315,322,331,
 320,329,266,206,216,386,388,383,223,217,319,303,349,306,
 239,258,343,578,616,464,551,624,622,597,526,558,589,619,
 511,560,625,607,617,474,562,534,603,610,519,546,638,613,
 605,535,569,456,498,463,959,644,1042,695,1048,665,1054,
 753,1483,1211,1520,1270,1537,1329,1229,1426,1699,1188,1205,
 1446,1392,1206,1290,1250,1355,1443,1722,1383,1034,1255,1070,
 1406,1415,1349,1369,1295,2172,1854,1619,1573,1837,1902,1863,
 1608,1545,1831,2298,1859,1654,1535,1715,2841,3333,2324,2787,
 2277,2729,2910,2309,2746,2372,2808,2599,2812,2513,2796,2590]
  ,[22,37,79,105,69,85,88,66,59,77,71,55,64,74,84,54,96,
 75,91,70,93,99,98,49,52,492,443,389,432,370,475,520,392,
 542,484,385,338,283,249,230,255,246,305,187,588,616,464,
 637,597,526,518,493,598,580,619,511,626,617,474,505,525,
 599,610,519,623,605,535,502,516,587,1507,878,800,759,1597,
 694,861,817,664,2979,1483,1211,1120,2957,1520,1270,943,
 2995,1537,1329,906,1229,1601,1403,1699,1205,1534,1399,1392,
 1052,1542,1206,1741,1171,1250,1355,1548,1512,1722,1126,1511,
 1070,1649,1456,1415,1349,1665,1261,1295,1154,1348,2109,2258,
 1940,1793,2032,2119,2057,2198,1784,2317,2429,2505,2841,3124,
 2787,2611,2277,3036,2729,3196,2746,2554,2372,2972,3671,3641]
  ,[22,40,13,58,51,67,61,82,100,79,105,85,88,89,59,95,77,
 71,104,64,102,73,107,84,72,54,96,75,65,87,90,91,70,106,
 93,99,98,289,316,394,375,407,336,345,429,313,409,377,419,
 327,354,240,291,310,404,207,238,330,325,592,614,624,574,
 602,598,612,608,625,571,590,581,601,621,638,566,577,587,
 1407,1496,1504],
 [22,40,13,58,51,67,61,82,100,79,105,85,92,88,66,71,64,74,
 102,73,107,84,56,72,96,75,65,87,90,91,70,106,99,49,289,
 316,394,375,407,336,345,429,332,313,409,377,419,307,304,
 351,293,435,267,254,328,358,335,537,556,592,624,531,549,
 574,598,540,527,612,625,504,544,571,581,548,568,601,638,
 497,480,566,587,1478,1327,1471,1427,1472,1341],
 [22,40,13,58,51,67,61,82,100,79,105,85,92,88,89,59,95,71,
 64,74,102,73,107,84,54,96,75,65,87,90,91,70,106,99,52,
 289,316,394,375,407,332,313,409,377,419,327,354,291,310,
 309,404,238,330,348,325,537,556,592,624,531,549,574,598,
 540,527,612,625,504,544,571,581,548,568,601,638,497,480,
 566,587,1404,1371,1752,1303,1331,1770,1237,1314,1755],
 [22,40,13,58,51,67,61,82,100,79,105,85,92,88,89,66,95,77,
 71,104,74,102,73,107,84,56,96,75,65,87,90,91,70,106,93,
 99,98,289,316,394,375,407,336,345,332,313,409,377,419,
 327,354,304,309,293,435,254,348,358,335,592,594,624,574,
 583,598,612,579,625,571,586,581,601,595,638,566,576,587,
 1752,1770,1755],
 [22,40,13,58,51,67,61,97,82,100,79,94,105,69,85,92,88,89,
 66,76,59,95,77,71,55,104,83,64,74,101,102,73,107,84,
 103,56,72,54,78,96,60,75,65,87,90,91,86,70,106,93,99,
 81,98,62,49,52,57],
 [22,40,13,58,67,61,82,79,105,85,88,59,77,71,104,64,102,
 107,84,54,96,75,87,91,70,93,99,98,471,372,492,381,443,
 475,347,366,424,542,423,484,368,385,222,291,331,216,223,
 311,321,330,323,258,482,495,496,592,614,624,458,602,545,
 503,485,608,426,590,550,532,462,601,621,638,456,577,814,
 1062,925,1635,1786,1040,1708,1771,1800,1759,1767,1335,1764,
 1577,2113,1588,2267,1836,1546,2583,1716,2005,1214,1679,1367,
 2403,1772,2458,4167,4800,3452,4291,4470,2919,4663,2932,4535,
 3004,3545,3696,4259,3590,3810,4699,5858,8254,5974],
 [22,40,13,58,67,61,97,82,79,94,105,69,85,88,59,77,71,55,
 104,64,102,107,84,103,54,78,96,60,75,87,91,86,70,93,99,
 81,98,471,372,492,381,443,475,347,366,424,542,423,484,
 368,385,291,298,310,404,238,213,330,325,592,614,624,574,
 602,598,612,608,625,571,590,581,601,621,638,566,577,587,
 1800,1759,1767],
 [22,40,13,58,67,61,97,82,79,94,105,69,85,88,66,76,71,64,
 74,102,107,84,103,56,78,96,60,75,87,91,86,70,99,81,49,
 471,372,492,381,443,475,347,520,366,424,542,423,304,331,
 293,435,254,311,358,335,537,556,592,624,531,549,574,598,
 540,527,612,625,504,544,571,581,548,568,601,638,497,480,
 566,587,2451,1797,2436,2438,1564,2517,2406,1612,2595],
 [22,40,13,58,67,61,97,82,79,94,105,69,85,88,66,76,77,71,
 55,104,74,102,107,84,103,56,78,96,75,87,91,86,70,93,99,
 81,98,471,372,492,381,443,475,520,366,424,542,423,484,
 368,385,304,293,255,435,254,358,305,335,592,594,624,574,
 583,598,612,579,625,571,586,581,601,595,638,566,576,587,
 1442,1350,1372],
 [22,40,13,58,67,61,97,82,79,94,105,69,85,88,76,59,71,55,
 64,74,102,107,84,103,54,78,96,75,87,91,86,70,99,81,52,
 471,372,492,381,443,520,366,424,542,423,484,368,385,291,
 310,255,404,238,330,305,325,537,556,592,624,531,549,574,
 598,540,527,612,625,504,544,571,581,548,568,601,638,497,
 480,566,587,2145,1442,2197,1350,2127,1372],
 [22,40,58,67,61,82,79,105,69,88,59,77,71,104,64,74,102,
 107,84,54,96,87,91,86,70,93,99,98,52,471,372,492,370,
 475,347,520,366,424,362,542,423,484,368,385,249,279,234,
 298,310,255,203,294,253,238,305,187,325,515,461,574,598,
 524,528,538,488,571,581,494,555,539,498,566,587,896,804,
 922,912,808,889,810,980,799,1330,1490,1012,992,1172,1069,
 1056,1003,1145,1134,1239,1025,946,1105,1074,1083,1066,1060,
 1193,1051,2031,2177,1386,1697,1501,1687,1464,1696,2732,2805,
 2804],[22,40,58,67,61,82,79,105,69,88,66,77,71,104,64,
 74,102,107,84,56,96,87,91,86,70,93,99,98,49,471,372,
 492,381,443,370,475,347,520,366,424,362,423,484,368,385,
 249,279,234,298,293,203,294,253,213,254,305,187,335,515,
 567,547,461,574,598,524,528,538,488,571,581,494,555,539,
 498,566,587,793,804,930,762,816,810,1198,869,785,1558,
 1266,1286,1056,1003,981,1145,1134,1239,1025,946,1105,1074,
 1083,1066,1060,1193,1051,2432,2718],
 [22,40,58,67,61,82,100,79,105,88,59,77,71,104,64,74,102,
 107,84,54,96,65,87,91,70,93,99,98,52,289,316,394,375,
 370,336,345,429,332,313,362,409,377,419,327,354,249,334,
 240,310,309,270,288,436,238,348,273,301,325,515,500,530,
 461,574,598,524,489,508,488,571,581,494,514,552,498,566,
 587,896,922,809,847,808,889,980,882,799,777,975,991,1056,
 1003,1111,1145,1134,1239,1025,1137,1105,1074,1083,1066,1116,
 1193,1051,2363,2562],
 [22,40,58,67,61,82,100,79,105,88,66,77,71,104,64,74,102,
 107,84,56,96,65,87,91,70,93,99,98,49,289,316,394,375,
 407,370,336,345,429,332,313,362,419,327,354,249,334,240,
 293,270,288,436,207,254,348,273,301,335,515,500,530,461,
 574,598,524,489,508,488,571,581,494,498,566,587,793,930,
 847,762,816,892,869,882,785,834,985,811,978,968,1451,1056,
 1003,1111,1145,1134,1239,1025,1137,1105,1074,1083,1066,1193,
 1051,2865,2715,1110,1422,1117,1413,1185,1428,5549,4782,5004]
  ,[22,41,13,58,51,67,61,79,105,85,92,77,53,71,104,83,74,
 102,73,107,84,56,72,78,96,75,65,93,80,99,98,62,289,375,
 336,332,313,409,327,354,186,208,234,293,206,221,288,202,
 277,253,238,254,328,239,220,301,335,430,501,583,598,466,
 506,426,487,586,581,456,499,576,587,896,793,819,930,762,
 889,816,863,869,785,777,975,995,1003,1104,1134,1098,1025,
 1071,1074,1061,1066,1140,1051,1210,1180,1283,1244,1195,1141,
 1226,1163,1176,1132,1259,1202,2072,2027,2049],
 [22,41,13,58,51,67,61,97,82,100,79,94,105,69,85,92,88,66,
 76,59,95,77,53,71,55,104,83,64,74,101,102,73,107,84,
 103,56,72,54,78,96,60,75,65,87,91,86,70,106,93,80,99,
 81,98,62,49,52,57],
 [22,41,13,58,51,67,61,100,79,105,85,66,95,77,53,71,104,
 74,102,73,107,84,56,78,96,75,70,80,99,98,289,375,336,
 332,313,409,354,186,234,309,293,206,288,251,202,253,254,
 239,301,235,335,430,451,501,574,583,598,466,450,506,485,
 426,413,487,571,586,581,456,396,499,516,566,576,587,793,
 930,685,762,816,869,699,785,777,975,1056,995,1003,1145,
 1104,1134,1239,1098,1025,1105,1071,1074,1083,1061,1066,1193,
 1140,1051,1210,1358,1180,1283,1467,1244,1195,1432,1141,1226,
 1397,1163,1176,1430,1132,1259,1389,1202,2072,2027,2049],
 [22,41,13,58,51,67,61,100,79,105,85,92,66,95,77,53,71,
 104,83,74,102,73,107,84,56,72,78,96,75,70,93,80,98,289,
 375,336,332,313,409,327,354,186,234,293,243,206,288,276,
 202,253,254,290,239,301,209,314,335,430,501,583,598,466,
 506,426,487,586,581,456,499,576,587,793,915,930,762,816,
 801,869,785,777,975,995,1003,1104,1134,1098,1025,1071,1074,
 1061,1066,1140,1051,1210,1180,1283,1244,1195,1141,1226,1163,
 1176,1132,1259,1202,2072,2027,2049],
 [22,41,13,58,67,79,105,85,77,53,71,104,74,102,107,56,78,
 96,75,70,93,80,99,98,289,375,336,332,409,327,354,334,
 315,186,234,240,309,293,436,383,202,253,254,348,335,551,
 430,501,622,604,583,598,560,607,611,426,487,586,581,546,
 613,591,396,576,587,793,930,809,762,816,869,785,777,1847,
 1852,1924,1426,1188,1056,995,1003,1104,1134,937,1280,1588,
 1098,1025,1443,1383,1105,1071,1074,910,1169,1716,1061,1066,
 1140,1051,886,1275,1772,2363,2562,1210,1358,1180,1373,1283,
 1244,1412,1586,1195,1141,1380,1226,1163,1411,1485,1176,1132,
 1417,1259,1202,1414,1543,3235,3735,4058,3057,4322,4052,3047,
 4868,3224,3254,3738,4010,2752,4305,4113,2931,4787,3223,2072,
 2027,2049,2920,2773,3096,3188,7461,3423,4016,3679,3211,7534,
 3037,3007,5111,3605,3510,3733,3232,7324,2953,3186,3048,3139,
 5282,2890,2855,5623,3154,3145,3628,3144,7862,3443,3906,3727,
 3289,5142,2609,2940,5989,2620,3571,5545,3337,2907,5811,3323,
 3694,6031,5380,8862,7697,5563,9185,8049,5029,6575,8738,5959,
 6477,8288,5045,6044,7381,5996,8175,6089,9028,6926,7790,6577,
 8012,7151],
 [22,41,13,58,67,100,79,105,85,77,53,71,104,74,102,73,107,
 84,56,78,96,75,70,93,80,99,98,62,289,375,336,332,313,
 409,327,354,334,315,186,234,229,293,243,206,288,436,383,
 202,253,207,238,254,328,260,348,290,239,301,335,430,501,
 583,598,466,506,426,487,586,581,456,499,576,587,700,896,
 793,819,930,762,705,889,816,863,892,869,785,777,975,995,
 1003,1104,1134,1098,1025,1071,1074,1061,1066,1140,1051,2865,
 2715,1210,1180,1283,1244,1195,1141,1226,1163,1176,1132,1259,
 1202,2072,2027,2049],
 [22,41,13,58,82,79,94,85,59,77,53,104,64,74,101,102,107,
 56,54,78,96,60,87,70,93,99,81,49,52,57,372,432,347,520,
 355,484,283,356,300,222,272,212,201,292,287,223,269,308,
 311,192,278,578,565,482,451,397,496,530,589,572,545,412,
 485,508,413,448,525,534,603,573,550,454,516,486,696,804,
 750,635,684,810,769,628,840,964,1111,1197,1091,1245,1072,
 1052,1137,1108,1156,1227,1240,1126,1116,1150,1065,1218,1057,
 1154,1384,2217,1359,1452,2450,1422,1398,2287,1306,1425,2350,
 1413,1465,2556,1390,1337,2307,1428,2002,2021,2011],
 [22,41,13,58,82,79,94,105,85,59,77,53,104,74,102,107,56,
 54,78,96,70,93,99,52,372,492,432,520,355,484,283,356,
 331,212,201,292,404,386,308,311,258,192,278,325,343,578,
 565,496,594,624,522,589,572,412,508,579,625,512,603,573,
 595,638,454,486,463,696,750,635,684,702,769,628,1442,1350,
 1372,964,1229,1035,1183,1111,1197,1245,1072,1206,988,1096,
 1137,1108,1156,1257,1530,1227,1240,1070,1166,1213,1116,1150,
 1218,1057,1154,1170,1393,2065,2063,1579,1798,1384,1359,1656,
 1452,1422,1628,1622,1398,1306,1606,1425,1413,1584,1720,1465,
 1390,1611,1337,2307,1428,3033,4172,3182,3355,3476,3329,3215,
 3675,3170,3105,4137,3228,3200,3670,3373,3177,3225,3248,2002,
 2021,2011,3922,2662,3724,2967,2679,3515,3567,3563,4207,2710,
 3253,3533,3070,4580,2622,3596,3217,2528,3339,3140,2744,3582,
 2706,3427,3457,3409,4045,2772,3439,3548,2905,3277,3464,3728,
 3542,2633,3272,3295,2696,5368,4495,4296,6025,3817,4533,5832,
 4709,4164,8014,7956,9018,8806,7680,8754,7416,8487,7384,6714,
 8889,7788,7317,6219,6942,7040,6668,6299,8206,7676,6523,8177,
 7971,6634],
 [22,41,13,58,82,94,105,85,59,77,53,55,104,64,74,101,102,
 107,103,56,54,78,96,60,87,86,70,93,99,81,49,52,57,372,
 492,432,347,520,355,484,283,356,279,193,222,272,298,212,
 201,292,200,223,269,213,308,192,278,578,565,397,530,589,
 572,412,508,448,534,603,573,454,486,696,750,1084,635,684,
 769,1101,628,840,964,1111,1197,1245,1072,1137,1108,1227,
 1240,1116,1150,1218,1057,1384,1359,1452,1422,1398,1306,1425,
 1413,1465,1390,1337,1428,2002,2021,2011],
 [22,41,13,58,97,79,105,85,76,59,77,53,55,104,64,74,101,
 102,107,103,56,54,78,96,60,87,70,93,99,81,52,492,432,
 347,520,355,484,283,356,186,234,222,272,212,216,201,292,
 404,386,202,253,223,269,308,192,278,325,343,578,565,551,
 397,530,589,572,412,508,562,448,534,603,573,454,486,696,
 750,635,662,684,769,628,645,840,964,1111,1197,1245,1072,
 1137,1108,1227,1240,1116,1150,1218,1057,1384,1359,1452,1422,
 1398,1306,1425,1413,1465,1390,1337,1428,2002,2021,2011],
 [22,41,13,67,82,79,94,105,59,53,71,104,74,102,56,54,78,
 75,70,93,80,98,52,492,347,520,355,484,342,259,322,331,
 264,329,216,276,404,386,388,217,319,281,349,209,325,343,
 578,565,397,530,594,624,622,604,453,564,589,572,412,485,
 508,612,579,625,607,611,448,534,512,603,573,417,552,595,
 638,613,591,454,486,566,1042,662,1054,645,1148,851,1248,
 839,1115,789,1229,1035,1183,1091,1114,1263,1205,1196,1253,
 1052,1173,1457,1206,988,1096,1156,1257,1530,1095,1355,1136,
 1230,1126,1034,1186,1070,1166,1213,1065,1209,1396,1349,1046,
 1147,1154,1170,1393,1080,1429,1550,1894,1958,1554,1516,1790,
 2188,1493,1562,1778,1982,3825,5944,3413,3959,4642,4077],
 [22,41,13,67,82,79,94,105,69,88,59,53,71,55,104,64,74,
 101,102,56,54,78,75,70,93,80,98,49,52,57,492,347,520,
 355,484,283,342,259,322,264,329,255,266,276,203,388,217,
 319,281,349,305,306,209,187,578,565,482,397,496,530,622,
 604,567,453,493,564,589,572,545,560,412,485,508,607,611,
 528,448,525,534,603,573,550,417,462,552,613,591,555,569,
 454,516,486,1148,851,1248,839,1115,789],
 [22,41,13,67,82,79,94,105,69,88,59,53,71,55,104,64,74,
 101,102,103,56,54,78,60,75,87,86,70,93,80,81,98,49,52,
 57,492,347,520,355,423,484,283,342,279,259,298,322,264,
 329,276,388,294,217,213,319,281,349,209,578,565,397,530,
 622,604,453,564,589,572,412,508,607,611,448,534,603,573,
 417,552,613,591,454,486,1148,851,1248,839,1115,789],
 [22,41,13,67,82,79,94,105,69,88,59,53,71,104,74,102,103,
 56,54,78,75,70,93,80,98,49,52,57,492,347,520,355,484,
 283,342,259,298,322,331,264,329,255,266,216,276,203,388,
 294,217,213,319,311,214,246,281,349,305,306,258,209,187,
 578,565,397,530,622,604,453,564,589,572,560,412,508,607,
 611,448,534,603,573,417,552,613,591,569,454,486,1318,720,
 761,1340,710,747,1148,851,1248,839,1115,789],
 [22,41,13,67,97,82,79,94,105,69,88,76,59,53,71,104,64,74,
 101,102,56,54,78,60,75,87,86,70,93,80,81,98,49,52,57,
 492,347,520,355,423,484,283,342,259,322,331,264,302,329,
 276,388,217,319,311,281,321,349,209,578,565,397,530,622,
 604,453,564,589,572,412,508,607,611,448,534,603,573,417,
 552,613,591,454,486,1148,851,1248,839,1115,789],
 [22,41,40,58,51,67,61,82,79,85,92,88,66,59,77,83,64,74,
 73,107,84,56,72,54,78,96,75,65,87,91,70,62,49,52,289,
 394,407,370,360,429,313,362,363,409,419,249,236,208,234,
 300,247,251,277,253,287,231,235,496,530,570,556,493,564,
 543,549,485,508,561,527,525,534,557,544,462,552,559,568,
 516,486,553,480,1404,1327,1303,1427,1237,1341],
 [22,41,40,58,51,67,61,82,100,79,94,85,92,88,66,77,71,104,
 83,64,74,107,84,56,72,54,78,96,75,65,87,91,99,98,62,
 49,52,289,394,407,336,429,313,362,363,409,419,354,249,
 236,300,247,248,251,287,231,226,235,496,455,530,493,477,
 564,485,427,508,525,465,534,462,459,552,516,431,486,818,
 837,831,826,934,891],
 [22,41,40,58,51,67,61,82,100,94,105,85,92,88,66,59,77,64,
 102,73,107,84,56,72,54,78,96,75,65,87,91,93,62,49,52,
 289,394,407,370,360,336,313,362,363,409,419,249,236,193,
 229,227,221,200,260,250,220,496,530,570,556,493,564,543,
 549,485,508,561,527,525,534,557,544,462,552,559,568,516,
 486,553,480,1752,1327,1770,1427,1755,1341],
 [22,41,40,58,51,67,61,82,105,85,92,88,66,59,71,104,83,64,
 102,73,107,84,56,72,54,78,96,75,65,87,91,99,98,62,49,
 52,289,394,407,370,360,429,313,362,363,409,419,354,249,
 236,208,193,234,227,221,277,200,253,250,220,496,530,537,
 493,564,531,485,508,540,525,534,504,462,552,548,516,486,
 497,1404,1303,1237],
 [22,41,40,58,51,67,61,97,82,100,79,94,105,69,85,92,88,66,
 76,59,95,77,71,55,104,83,64,108,74,101,102,73,107,84,
 103,56,72,54,78,96,60,75,65,87,91,86,70,106,93,99,81,
 98,62,49,68,52,57],
 [22,41,40,58,67,61,82,79,85,88,66,59,77,71,104,74,107,84,
 56,54,96,75,87,91,70,99,98,52,289,394,407,370,360,336,
 313,362,363,409,419,354,249,236,334,300,240,229,309,318,
 436,207,260,231,551,495,496,530,594,416,574,583,560,503,
 579,413,571,586,546,532,462,552,595,396,566,576,692,880,
 921,672,940,875,1752,1770,1755,1111,1073,1262,1219,1316,
 1280,1155,1356,1332,1067,1169,1116,1224,1360,1269,1109,1275,
 2028,2483,2099,2690,1656,1892,1606,1827,1611,1880,2546,3023,
 3349,3321,2686,2887,3164,2539,3201,3290,2793,2721,3933,3925,
 3498],[22,41,40,58,67,61,82,105,85,88,66,59,77,71,104,
 102,107,84,56,54,96,75,87,91,93,99,98,52,289,394,407,
 370,360,336,429,313,362,363,409,419,354,334,193,229,309,
 318,221,436,207,260,250,348,323,551,495,496,530,594,416,
 574,583,560,503,485,508,579,413,571,586,546,532,462,552,
 595,396,576,700,876,742,1029,853,718,961,3826,3836,3450,
 4506,3273,3814,1111,1073,1262,1316,1280,1137,1155,1356,1067,
 1169,1116,1224,1360,1109,1275,1913,1925,5879,4841,4324,2546,
 3321,2686,2539,3201,2721],
 [22,41,40,58,67,61,97,82,79,105,69,59,77,71,55,104,64,
 108,74,101,102,56,54,96,60,75,87,70,93,49,68,52,57,471,
 372,316,492,432,475,347,345,520,355,542,484,283,259,272,
 264,261,302,276,203,292,217,269,281,228,321,209,187,278,
 397,496,530,453,493,564,412,485,508,448,525,534,417,462,
 552,454,516,486,1033,985,840,978,964,1451],
 [22,41,40,58,67,61,97,82,79,105,69,59,77,71,55,104,64,
 108,74,101,102,56,54,96,60,75,87,70,93,49,68,52,57,471,
 372,316,492,475,347,345,520,355,542,423,377,484,283,259,
 272,264,261,302,276,203,292,217,269,281,228,321,209,187,
 278,397,496,530,453,493,564,412,485,508,448,525,534,417,
 462,552,454,516,486,851,839,789],
 [24,17,27,31,35,19,25,51,50,61,94,105,85,88,77,53,71,55,
 104,83,64,108,74,73,107,63,84,56,54,78,96,87,80,99,81,
 62,49,68,52,342,356,186,193,307,291,304,212,270,206,221,
 251,292,388,434,202,200,267,238,254,299,273,239,220,235,
 278,692,746,672,763],
 [24,17,27,31,35,19,25,51,67,50,82,79,94,105,85,88,89,77,
 53,71,55,104,83,102,73,107,63,84,56,54,78,75,93,80,81,
 98,62,49,68,52,342,315,291,304,244,280,227,329,266,270,
 206,221,388,383,238,254,349,306,273,239,220,209,668,803,
 733,727,820,760,736,2004,2069],
 [24,17,27,31,35,19,30,25,51,67,50,82,79,94,105,85,88,89,
 77,53,71,55,104,102,73,107,63,84,56,54,78,75,91,70,93,
 80,81,98,49,68,52,342,315,291,304,244,280,227,329,266,
 270,388,383,238,254,349,306,273,209,668,803,733,727,820,
 760,736,2004,2069],
 [24,17,27,31,35,19,30,25,58,51,50,61,94,105,85,88,77,53,
 71,55,104,64,108,74,73,107,63,84,56,54,78,96,87,93,80,
 99,81,49,68,52,356,186,193,307,291,304,212,270,206,221,
 292,434,202,200,267,238,254,299,273,239,220,278,692,746,
 672,763],
 [24,17,27,31,35,19,30,25,58,51,67,50,61,82,79,94,105,85,
 88,89,66,59,77,53,71,55,104,64,108,74,102,73,107,63,84,
 56,54,78,96,75,87,90,91,70,93,80,99,81,98,49,68,52],
 [24,17,27,31,35,19,30,25,58,67,61,82,79,94,105,85,88,66,
 59,77,53,71,55,104,64,74,102,73,107,63,84,56,54,96,75,
 87,91,70,93,99,98,49,68,52,334,324,307,280,318,270,201,
 203,436,406,267,262,323,192,187,919,872],
 [24,17,27,31,35,19,30,25,58,67,61,82,79,105,85,88,66,59,
 77,71,104,64,74,102,107,84,56,54,96,75,87,91,70,93,99,
 98,49,52,471,340,316,381,389,407,370,475,402,345,366,392,
 313,362,542,411,377,368,338,354,249],
 [24,17,27,31,35,19,30,25,58,67,82,79,105,85,88,77,71,104,
 102,107,84,56,54,75,87,93,98,49,52,471,340,316,381,389,
 407,475,402,366,392,313,362,542,411,368,338,354,249,315,
 291,304,244,227,329,383,238,254,214,250,349,209,606,547,
 453,477,448,465,620,532,454,431,668,671,985,978,1451],
 [24,17,27,31,35,19,30,25,58,67,82,79,105,85,88,77,71,104,
 102,107,84,56,54,75,87,93,98,49,52,471,340,381,389,407,
 475,402,345,392,313,362,377,249,315,291,304,244,227,329,
 383,238,254,214,250,349,209,495,606,518,453,477,589,585,
 538,448,465,620,514,613,593,468,463,668,671,1797,1564,993,
 981,1038,931,886,1036,1497,3057,3687,2752,3620,3345,3229],
 [24,17,27,31,35,19,30,25,67,61,82,79,105,88,66,59,77,71,
 64,74,102,107,84,96,87,93,99,98,49,52,316,381,370,475,
 402,366,392,313,542,411,377,338,354,249,342,259,320,310,
 293,206,221,388,303,330,358,239,220,578,575,441,536,547,
 609,489,607,582,488,532,600,498,502,703,725,1285,850,1304,
 856,1214,2853,2624],
 [24,17,27,31,35,19,30,25,67,61,82,79,105,88,66,59,77,71,
 64,74,102,107,84,96,87,93,99,98,49,52,471,340,316,381,
 389,407,370,475,402,345,366,392,313,368,338,354,249,342,
 259,320,310,293,206,221,388,303,330,358,239,220,461,609,
 503,488,600,539,498,703,725,1558,1660,1266,1818,1286,1605],
 [24,17,27,31,35,19,30,25,67,61,105,85,88,77,71,104,64,74,
 107,84,56,54,96,87,91,70,93,99,49,52,471,340,381,389,
 407,475,402,345,392,313,362,377,368,249,186,193,291,304,
 212,292,202,200,238,254,231,299,278,588,495,606,580,589,
 585,447,473,538,620,514,613,593,468,463,692,672,1143,1983,
 1087,2089],
 [24,17,27,35,30,67,105,85,92,88,66,71,64,74,101,73,107,
 91,70,106,93,99,49,52,57,389,370,366,392,368,338,249,
 334,304,351,322,331,320,247,212,243,266,203,292,388,436,
 231,330,349,299,290,306,187,278,596,604,469,547,479,503,
 582,611,600,593,591,442,539,1482,1062,1272,823,1042,759,
 1661,1053,1344,1289,923,1054,817,1012,1539,1760,2103,1354,
 1663,1234,1595,1730,945,1208,1532,1815,1106,1322,1590,1592,
 1773,1363,949,1235,4210,5744,3626,4552,3526,1822,1856,1765,
 1751,1909,1932,1481,1788,1747,1816,1843,1824,1780,1702,4491,
 4139,3685,4867,3513,5941,3505,2156,2147,2213,7548,8520,7777,
 7350],
 [24,17,31,35,34,30,58,51,67,50,61,82,79,94,105,69,85,88,
 89,66,59,95,77,53,71,104,64,108,74,101,102,73,107,63,
 84,56,54,78,96,60,75,87,90,91,70,106,93,80,99,98,49,
 68,52,57],
 [24,17,31,35,34,30,58,51,67,61,82,79,94,105,69,85,88,66,
 59,95,77,71,74,102,73,107,63,84,96,60,75,87,90,91,70,
 106,93,49,52,57,324,307,359,320,244,280,230,310,293,318,
 406,295,303,214,262,246,330,358,323,192,209,278,357,716,
 668,1107,772,859,745,671,1075,751,883],
 [24,17,31,35,34,30,58,67,79,105,69,88,59,77,102,73,84,54,
 75,91,70,106,93,49,57,340,381,402,368,249,334,315,291,
 351,350,244,227,230,264,329,255,266,217,238,328,214,246,
 349,305,306,209,335,464,495,606,518,509,549,585,511,503,
 483,544,620,593,535,539,468,480,644,668,930,862,800,893,
 727,707,665,671,869,947,736,717,906,1102,1146,993,1076,
 933,881,1171,1251,1125,1100,1161,1038,1058,1261,1159,1090,
 1930,1793,1998,1784,1581,1697,1567,1683,2225,1642,1687,1514,
 1698,1617,1696,1557,1711,2839,2051,3017,2131,1966,2020,1985,
 5087,5286],
 [24,17,31,35,34,30,58,67,105,66,59,95,77,71,74,73,84,96,
 91,70,106,93,52,340,370,402,366,411,368,334,315,247,264,
 255,212,266,436,383,223,217,269,305,299,306,209,464,467,
 495,509,549,583,598,511,479,503,474,449,538,483,544,586,
 581,535,442,539,468,480,576,587,959,644,870,668,746,707,
 1048,665,914,671,763,717,1330,3826,1012,943,3450,906,3273,
 1102,1146,995,1003,993,1076,1104,1134,1251,1125,1098,1025,
 1100,1161,1071,1074,1038,1058,1061,1066,1159,1090,1140,1051,
 1581,1503,1697,1567,1627,1683,1642,1572,1687,1514,1529,1698,
 1617,1598,1696,1557,1631,1711,1966,4870,2020,4408,1985,4854]
  ,[24,17,31,35,34,30,58,79,105,69,88,66,59,95,77,71,64,
 74,101,102,54,96,75,70,49,52,57,340,381,370,402,366,411,
 368,249,334,356,315,248,264,261,255,266,206,288,436,434,
 383,217,305,306,239,301,235,209,464,495,509,549,511,503,
 474,538,483,544,535,539,468,480,644,887,668,847,707,845,
 665,874,671,882,717,941,943,906,1102,1146,993,1076,1251,
 1125,1100,1161,1038,1058,1159,1090,1581,1697,1567,1683,1642,
 1687,1514,1698,1617,1696,1557,1711,1966,2020,1985],
 [24,17,31,35,34,30,58,105,69,88,66,59,95,71,64,74,101,
 102,73,84,96,75,70,93,52,340,370,366,411,368,334,315,
 322,264,293,255,266,206,288,404,386,436,434,383,200,217,
 319,239,301,209,325,343,464,495,596,509,549,511,503,618,
 474,538,505,483,544,584,468,480,615,1378,788,644,668,707,
 762,1488,963,665,671,717,785,787,664,943,1403,1102,1146,
 993,1076,1251,1125,1512,1100,1161,1038,1058,1159,1090,917,
 911,2294,2258,2170,2057,1581,1697,1567,1683,1642,1687,1514,
 1698,1617,1696,1557,1711,2015,3234,2149,3084,2128,1966,2020,
 1985,8871,7958],
 [24,17,31,35,34,30,67,79,69,88,59,77,71,64,101,102,73,84,
 54,75,91,106,93,49,57,381,402,249,342,334,315,264,255,
 266,388,436,383,217,238,328,305,306,220,209,575,464,495,
 490,509,549,602,511,503,533,582,474,538,507,483,544,620,
 590,535,539,529,502,468,480,577,644,896,819,1010,668,707,
 665,889,863,979,671,717,943,1818,906,1605,1102,1146,1870,
 1228,1399,993,1076,1131,1251,1125,1221,1100,1161,1897,1127,
 1456,1038,1058,1243,1159,1090,1128,1581,1697,1437,1194,1567,
 1683,1368,1110,1642,1687,1402,1184,1514,1698,1307,1117,1617,
 1696,1408,1242,1557,1711,1336,1185,1966,4694,2020,4472,1985,
 4742],
 [24,17,31,35,34,58,51,61,105,69,85,88,89,66,95,77,53,104,
 83,64,108,74,101,73,107,63,84,96,60,87,90,91,70,106,99,
 62,49,68,57,356,324,350,247,310,293,318,212,251,201,292,
 435,434,406,202,200,253,308,231,330,358,323,235,192,278,
 335,1160,788,877,1192,635,1238,963,938,816,1344,628,2530,
 2389],
 [24,17,37,20,41,35,18,30,13,25,51,50,69,85,92,66,59,53,
 55,73,63,60,75,65,91,70,80,81,282,369,443,376,410,541,
 352,367,424,344,433,380,385,317,341,472,342,320,247,388,
 303,231,616,464,467,597,526,469,549,619,511,479,617,474,
 449,610,519,510,605,535,442,480,1302,2138,1438,2201,1439,
 2153,1676,1717,1647],
 [24,25,61,82,79,94,105,85,88,66,59,71,104,64,74,102,84,
 56,54,75,87,91,70,93,99,98,49,68,52,372,394,492,375,
 443,432,347,429,520,332,355,423,419,484,327,385,283,307,
 322,280,201,203,388,267,262,323,349,192,187,616,441,536,
 622,597,596,619,447,473,607,617,582,610,470,523,613,605,
 593,1482,925,1272,823,919,1661,1053,923,872,1483,1520,1537,
 2717,1539,1143,2600,1354,2039,1595,1231,2827,1532,2492,1322,
 1254,2098,1592,4800,4291],
 [24,25,61,82,100,79,105,85,88,66,59,71,104,64,74,102,84,
 56,54,75,87,91,70,93,99,98,62,49,52,316,381,375,389,
 407,370,345,366,332,362,377,368,327,338,354,249,222,240,
 322,229,288,388,223,207,260,348,349,301,616,622,597,596,
 458,416,619,607,617,582,610,613,605,593,456,396,1482,819,
 950,1272,823,1661,863,1053,923,913,1847,908,1852,966,1924,
 2717,1539,2600,1354,1296,2039,1595,2827,1532,2492,1322,2098,
 1592,1300,3094,2991,1854,1373,1863,1380,1859,1417,3660,3220,
 3635],[24,27,19,40,25,51,67,50,82,100,79,94,105,88,76,
 59,77,71,55,64,102,84,56,72,54,78,96,75,65,90,91,93,
 98,62,49,68,52,342,315,259,240,307,291,248,264,215,266,
 217,207,267,238,303,260,262,250,258,220,209,187,752,935,
 719,876,1333,800,694,843,709,853,702,979,671,755,882,717,
 723,664,2065,2566,2140,2495,2063,2460,2133,2119,2402,2375,
 1988,2057,2278,1784,3558,4027,3527,4042,3700,3686,3360,3455,
 3559,4424,5463,4919,5735,5237],
 [24,27,25,51,61,82,100,79,105,88,76,59,95,71,55,104,64,
 102,73,84,75,65,87,91,86,70,106,93,99,81,98,316,381,
 345,377,368,338,342,259,240,291,322,310,309,293,329,404,
 388,217,207,238,319,330,348,358,349,325,616,575,441,592,
 606,614,597,596,574,609,602,619,585,612,618,608,617,582,
 483,571,620,590,610,584,601,600,621,605,593,566,615,577,
 1757,913,1796,908,1835,966],
 [24,27,25,58,51,67,50,61,82,100,79,94,105,85,92,88,89,66,
 76,59,95,77,53,71,55,104,83,64,108,74,102,73,107,63,84,
 56,72,54,78,96,75,65,87,90,91,86,70,106,93,80,99,81,
 98,62,49,68,52],
 [24,27,25,58,51,94,105,85,92,89,66,77,53,71,55,104,83,
 108,74,78,96,87,86,70,106,80,99,81,49,68,52,356,324,
 315,298,304,351,244,247,248,212,243,270,206,251,292,382,
 213,254,328,281,245,228,330,348,358,299,290,273,239,278,
 314,1160,924,788,764,824,722,1062,950,1449,750,983,800,
 803,746,847,921,728,802,715,1040,892,1421,741,669,718,795,
 820,763,882,875,2241,2212,2030,2421,2990,2974,2536,2120,
 2427,2423,1793,1948,1993,2462,2975,2018,2585,2499,1784,5654,
 4586,5025,5182,3638,5937,5216,6995,5531,5343,6350],
 [24,27,25,58,67,50,61,88,66,76,59,77,53,71,55,104,108,74,
 84,56,78,96,87,86,70,80,99,81,98,49,68,52,471,443,432,
 475,424,385,283,186,234,300,244,247,264,215,206,251,202,
 253,287,214,231,281,245,239,235,551,467,515,451,500,558,
 469,461,416,518,560,479,524,450,489,562,449,488,413,505,
 546,510,494,452,514,569,442,498,396,502,1211,1558,1270,
 1266,1329,1286],
 [24,27,25,58,67,50,61,88,89,66,76,59,77,53,71,55,104,107,
 63,84,56,96,87,90,86,70,99,81,98,49,68,52,471,443,432,
 475,424,385,283,186,300,244,280,227,247,206,251,201,202,
 287,214,262,250,231,239,235,192,551,467,495,515,451,558,
 469,547,461,416,560,479,503,524,450,562,449,538,488,413,
 546,510,532,494,452,569,442,539,498,396,1211,1558,1270,
 1266,1329,1286],
 [24,27,25,58,67,50,61,88,89,66,76,59,77,53,71,55,104,108,
 74,107,63,84,56,78,96,87,86,70,80,99,81,98,49,68,52,
 471,443,432,475,424,385,283,186,234,300,244,247,270,206,
 251,202,253,287,214,231,273,239,235,551,467,515,451,558,
 469,461,416,560,479,524,450,562,449,488,413,546,510,494,
 452,569,442,498,396,1211,1558,1270,1266,1329,1286],
 [24,27,25,58,67,50,82,94,105,88,66,76,59,77,53,71,55,64,
 102,107,63,84,56,78,96,91,93,99,81,98,49,68,52,471,432,
 475,424,355,542,385,283,320,280,227,216,221,201,383,306,
 258,220,192,558,469,461,416,518,524,450,489,562,449,569,
 442,498,396,502,1507,878,759,733,727,1597,861,817,760,736,
 992,1601,857,1534,867,1741,945,1077,902,1171,1548,926,1649,
 848,1665,949,1085,965,1261,1706,1571,1549,1619,1373,1740,
 1756,1568,1481,1622,1608,1380,1714,1723,1525,1576,1654,1417,
 1702,1680,1881,1912,1875],
 [24,27,25,58,67,50,82,105,88,89,66,76,59,77,53,71,55,102,
 107,63,84,56,96,91,93,80,99,81,98,49,68,52,471,432,475,
 424,355,542,385,283,320,244,280,227,216,221,383,214,262,
 250,306,273,258,220,558,469,547,461,416,524,450,562,449,
 538,494,452,569,442,539,498,396,1507,878,794,759,1597,861,
 776,817,992,1069,1601,857,1277,1534,867,1267,1741,945,1208,
 1548,926,1361,1649,848,1273,1665,949,1235,1706,1571,1619,
 1373,1756,1568,1608,1380,1723,1525,1654,1417,1881,1912,1875]
  ,[24,27,25,58,82,94,105,88,89,66,76,59,77,53,71,55,64,
 102,107,63,84,56,78,96,90,91,93,80,99,81,98,49,68,52,
 471,432,475,424,355,542,385,283,320,280,227,216,221,434,
 406,383,262,250,306,258,220,558,469,461,416,524,450,562,
 449,494,452,569,442,498,396,1378,1768,1507,878,759,1488,
 1781,1597,861,817,992,1069,1601,857,1534,867,1741,945,1548,
 926,1649,848,1665,949,1706,1571,1619,1373,1756,1568,1608,
 1380,1723,1525,1654,1417,1881,1912,1875],
 [24,27,25,61,82,100,79,105,85,92,88,76,59,71,55,104,83,
 64,102,84,72,54,75,65,87,91,86,70,106,93,99,81,98,316,
 381,389,345,377,368,338,342,291,351,322,310,329,382,404,
 388,238,328,319,330,349,314,325,578,616,575,606,614,622,
 597,596,609,602,589,619,585,618,608,607,617,582,620,590,
 603,610,584,600,621,613,605,593,615,577,1757,913,1796,908,
 1835,966],
 [24,27,25,61,82,100,79,105,85,92,88,76,59,95,71,55,104,
 83,64,102,73,84,75,65,87,91,86,70,106,93,99,81,98,62,
 316,381,389,345,377,368,338,342,334,291,322,310,309,293,
 329,404,388,436,238,319,330,348,358,349,325,616,575,606,
 614,597,596,609,602,619,585,618,608,617,582,620,590,610,
 584,600,621,605,593,615,577,1757,913,1796,908,1835,966],
 [24,27,25,61,82,100,79,105,88,76,59,95,71,55,104,64,102,
 84,87,91,86,70,93,99,81,98,62,316,381,345,377,368,338,
 342,259,240,291,322,229,248,310,329,212,243,288,404,388,
 238,319,260,226,330,348,358,349,299,290,325,616,575,441,
 606,614,597,596,609,602,619,585,618,608,617,582,620,590,
 610,584,600,621,605,593,615,577,950,1449,900,892,1421,725,
 868,806,1757,913,1796,908,1835,966,2717,2600,2039,2827,
 2492,856,2098,2459,2939,2347,3024,3006,2963],
 [24,27,25,61,82,105,88,76,59,71,55,104,64,102,84,87,91,
 86,70,93,99,81,98,316,345,377,368,338,342,259,240,291,
 322,310,309,293,329,288,404,388,436,238,319,330,348,358,
 349,301,325,616,575,530,441,606,614,597,596,609,602,619,
 585,508,618,608,617,582,620,590,610,584,552,600,621,613,
 605,593,498,396,615,577,2045,935,703,809,1963,725,868,
 1757,913,1796,908,1835,966,1601,857,1285,1391,1764,1534,
 867,850,1588,1741,945,1836,1548,926,1716,1649,848,856,1679,
 1665,949,1193,1772,2864,2758,1549,3077,1619,1373,1740,1481,
 2852,1608,1380,1714,1576,2785,1654,1417,1702,2642,2853,3227,
 2624,3664,8552,5699,4784,8782,4609,4271,6976,4180,5046,5134,
 6262],[24,27,30,25,51,61,100,79,105,88,95,71,55,64,73,
 84,72,54,87,91,86,70,106,93,99,81,316,381,377,368,338,
 342,186,259,240,291,298,304,322,310,329,212,243,404,388,
 202,217,207,238,319,231,330,349,299,290,325,616,575,441,
 606,614,597,596,609,602,619,585,618,608,617,582,483,620,
 590,610,584,600,621,605,593,615,577,752,692,912,1192,759,
 694,672,1122,1344,817,1757,913,1796,908,1835,966,1011,1362,
 1081,1208,1345,967,1223,1203,1235,1215],
 [24,27,34,58,50,79,105,85,88,89,66,59,77,53,64,74,102,
 107,63,84,54,96,91,70,93,80,99,98,49,68,52,57,471,492,
 375,443,432,475,520,332,424,542,484,327,385,283,356,315,
 350,320,280,230,212,266,270,434,383,308,303,262,246,299,
 306,273,464,551,495,526,558,547,511,560,503,474,562,538,
 519,546,532,535,569,539,1211,1270,1329],
 [24,27,34,58,51,67,50,61,82,100,79,94,105,85,92,88,89,66,
 76,59,95,77,53,71,104,83,64,108,74,101,102,73,107,63,
 84,56,72,54,78,96,75,65,87,90,91,86,70,106,93,80,99,
 98,62,49,68,52,57],
 [24,27,34,58,51,67,61,79,85,92,88,66,76,59,95,77,71,104,
 83,74,102,73,107,84,56,54,75,87,86,70,106,93,99,98,62,
 49,52,340,389,370,360,402,366,392,362,363,411,368,338,
 249,236,186,244,243,206,202,214,290,239,551,495,490,558,
 547,554,560,503,533,562,538,507,546,532,563,569,539,529,
 1330,1012,1172],
 [24,27,34,58,51,67,61,105,85,92,88,66,76,59,95,77,71,104,
 74,102,73,107,84,56,96,75,65,87,86,70,106,93,99,98,62,
 49,52,340,381,389,370,360,402,366,392,411,368,338,249,
 236,186,229,244,206,202,260,214,239,551,467,495,558,469,
 547,560,479,503,562,449,538,546,510,532,569,442,539,1120,
 758,943,740,906,841],
 [24,27,34,58,51,79,105,85,92,88,66,76,59,95,77,64,74,102,
 73,107,84,54,96,91,86,70,106,93,99,98,62,49,52,340,381,
 389,370,360,402,366,392,411,368,338,249,236,356,315,350,
 320,229,212,243,266,434,383,308,303,260,299,290,306,464,
 551,495,526,558,547,511,560,503,474,562,538,519,546,532,
 535,569,539,1120,758,943,740,906,841],
 [24,27,34,58,67,50,61,79,85,88,89,66,59,77,53,71,104,108,
 74,101,102,107,63,84,56,54,75,87,70,93,80,99,98,49,68,
 52,57,471,375,443,432,475,520,332,424,355,542,484,327,
 385,283,186,244,270,206,202,214,273,239,551,495,490,558,
 547,554,560,503,533,562,538,507,546,532,563,569,539,529,
 2209,2250,2272],
 [24,27,34,58,67,50,61,105,85,88,89,66,59,77,53,71,104,74,
 102,107,63,84,56,96,75,87,90,70,93,80,99,98,49,68,52,
 57,471,492,375,443,432,475,520,332,424,542,484,327,385,
 283,186,244,280,230,206,202,214,262,246,239,551,467,495,
 558,469,547,560,479,503,562,449,538,546,510,532,569,442,
 539,1211,1270,1329],
 [24,27,34,58,67,61,79,105,85,88,66,77,71,104,74,102,107,
 84,56,54,96,75,87,93,99,98,49,52,340,381,389,402,366,
 392,362,363,411,368,338,249,236,334,186,229,206,216,288,
 436,207,260,214,258,301,551,495,455,622,416,477,560,503,
 427,607,413,465,571,546,532,459,613,396,431,566,700,720,
 754,704,710,741,698,818,837,831,826,934,891,1699,1188,
 1555,1011,1542,881,1250,1175,1454,1024,1511,967,1415,1189,
 1526,1027,1348,911,1913,1925,2200,2046,2052,2826,2625,2447,
 2405,2329,2521,2929,2573,2340,2531,2331,2522],
 [24,27,34,58,79,105,85,88,66,59,77,71,104,74,102,56,54,
 96,75,87,70,93,99,98,49,52,492,375,443,432,475,520,355,
 542,484,327,385,283,359,244,215,270,437,386,295,273,239,
 357,343,616,565,606,624,597,604,558,547,509,619,585,572,
 618,625,617,611,483,610,584,573,600,638,605,591,569,539,
 468,1160,866,803,1238,812,820,723,2979,1407,1483,2957,1496,
 1520,2995,1504,1537,1601,1277,1234,1534,1267,1399,1741,1208,
 1106,1548,1361,1649,1273,1363,1665,1235,1261,2247,1988,6063,
 1994,1751,4933,2184,1747,8973,2273,1780,3951,3493,3340,4314,
 3265,3593,3666,4219,4094],
 [24,27,34,58,82,79,85,88,89,66,59,77,64,108,74,101,102,
 107,63,84,56,54,90,91,70,93,80,99,98,49,68,52,57,471,
 492,375,443,432,475,520,332,424,355,484,327,385,283,356,
 324,315,359,350,320,212,266,434,406,383,295,308,303,299,
 306,551,495,490,558,547,554,560,503,533,562,538,507,546,
 532,563,569,539,529,1558,1266,1286],
 [24,27,34,58,82,79,85,92,88,66,59,77,83,64,74,102,73,107,
 84,56,54,65,91,86,70,106,93,99,98,62,49,52,340,381,389,
 370,360,402,366,392,362,363,368,338,249,236,334,356,315,
 298,351,350,320,212,266,436,434,383,213,328,308,303,299,
 306,551,495,490,558,547,554,560,503,533,562,538,507,546,
 532,563,569,539,529,1660,1818,1605],
 [24,27,34,58,82,79,105,85,88,66,77,64,74,102,107,84,56,
 54,96,91,93,99,98,49,52,340,381,389,370,360,402,366,392,
 362,363,411,338,249,236,334,356,315,240,229,212,266,436,
 207,308,303,258,301,551,495,455,622,416,477,574,560,503,
 427,607,413,465,571,546,532,459,396,431,566,696,752,750,
 800,714,635,697,684,694,702,884,769,903,628,664,1797,1564,
 1612,1699,1188,1555,1011,1542,881,1250,1175,1454,1024,1511,
 967,1415,1189,1526,1027,1348,911,2065,2694,2454,2063,2712,
 2445,2077,2280,1986,2826,2625,2447,2405,2329,2521,2929,2573,
 2340,2531,2331,2522],
 [24,27,34,58,82,105,85,88,89,66,59,77,53,64,108,74,101,
 102,107,63,84,56,96,91,70,93,80,99,98,49,68,52,57,471,
 375,443,432,475,520,332,424,355,542,484,327,385,283,356,
 324,315,350,320,212,266,270,434,406,383,308,303,299,306,
 273,551,467,495,558,469,547,560,479,503,562,449,538,546,
 510,532,569,442,539,2209,2250,2272],
 [24,27,34,58,82,105,85,92,88,66,76,59,95,77,83,64,74,102,
 73,107,84,56,96,91,86,70,106,93,99,98,62,49,52,340,389,
 370,360,402,366,392,362,363,411,368,338,249,236,334,356,
 315,350,320,212,243,266,436,434,383,308,303,299,290,306,
 551,467,495,558,469,547,560,479,503,562,449,538,546,510,
 532,569,442,539,1330,1012,1172],
 [24,27,35,13,58,105,66,71,55,104,102,63,84,96,75,90,91,
 81,98,49,52,57,471,389,432,347,392,542,283,356,324,315,
 259,227,230,251,276,434,406,383,200,253,267,214,281,235,
 464,551,455,530,416,513,511,427,508,474,562,413,487,459,
 552,535,788,877,663,720,703,727,674,963,938,701,871,728,
 736,693,932,1033,1862,1270,840,1908,1329,1891,899,1183,
 1158,1011,1162,1280,902,1096,1089,1024,1008,1230,1227,986,
 1169,1002,1027,965,1147,1036,1275,2640,2410,2790,1991,2056,
 2567,2284,2565,2061,1581,1567,1578,1586,1642,1514,1632,1485,
 1617,1557,1587,1543,5762,3208,3735,2115,3687,4322,2630,2999,
 4203,4868,2339,5264,3676,3738,2699,3302,3620,4305,2179,3818,
 4787,2510,3251,8026,2261,8149,2268,8701,2237,3359,3514,3221,
 2773,5454,3460,4016,3402,3510,4631,3167,3186,3561,3145,5191,
 3385,3906,8345,9422,9125,6932,7352,6604,7693,7826,7094,8570,
 7083,7080,7802,7801,6192,6302,6107,7117,9275,9407,6920,6605,
 6984,6168,8342,8286,6084,7978,6122,7020],
 [24,27,35,30,58,51,100,105,85,66,55,104,74,101,102,73,56,
 72,96,93,99,81,98,52,57,381,366,368,338,249,356,240,272,
 322,350,264,404,434,207,269,319,308,299,290,306,325,575,
 565,455,530,441,596,604,477,564,427,508,582,611,465,534,
 483,584,573,459,552,593,591,431,486,1160,720,1112,1710,
 878,866,754,704,1238,710,918,1639,861,812,741,820,698,818,
 913,831,908,934,966,857,1277,1158,1011,1354,1663,867,1267,
 1039,881,1089,1024,926,1361,1249,967,1322,1590,848,1273,
 1002,1027,949,1235,1103,911,2801,2884,2351,2548,2375,2332,
 2171,2225,1956,2301,2100,2015,2888,4235,2761,3503],
 [24,27,35,40,13,58,67,82,79,94,85,89,77,55,104,64,107,56,
 54,78,75,90,91,49,52,57,471,372,347,355,542,423,283,324,
 315,291,350,227,230,247,215,261,276,203,292,238,308,250,
 246,245,228,235,187,278,622,416,513,477,564,427,508,603,
 459,552,396,499,431,486,815,887,983,800,880,746,1023,874,
 940,763,932,839,789,899,1183,1016,1253,1190,1416,1457,902,
 1096,1377,928,1213,1274,1445,1396,965,1147,1204,2572,2423,
 1793,2499,1784,1409,1798,1435,1662,1394,1622,1418,1720,1458,
 1680,2840,3329,2275,2210,2211,4150,4947,2998,3270,3233,3070,
 2771,3095,3134,8193,6732,8218,7124,5132,6049,7787,6062,7111,
 7313,6542],
 [24,27,35,51,67,82,105,85,92,88,66,71,83,64,74,101,102,
 73,107,56,75,91,70,106,93,99,81,98,62,49,52,57,389,370,
 366,392,362,368,338,249,304,351,322,331,320,243,266,388,
 311,303,349,290,306,596,604,558,469,547,560,479,503,582,
 611,546,510,532,593,591,569,442,539,1482,1272,1192,1063,
 823,1661,1053,1344,1289,923,1012,1172,1539,1760,1354,1663,
 1595,1730,1532,1815,1322,1590,1592,1773,1987,1822,1856,1994,
 1765,1751,2174,1909,1932,2184,1788,1747,1967,1816,1843,2273,
 1824,1780,2156,2147,2213],
 [24,27,35,58,51,67,50,61,82,100,79,94,105,85,92,88,89,66,
 59,95,77,53,71,55,104,83,64,108,74,101,102,73,107,63,
 84,56,72,54,78,96,75,65,87,90,91,70,106,93,80,99,81,
 98,62,49,68,52,57],
 [24,27,35,58,51,105,85,92,88,66,59,95,77,55,104,83,74,
 101,102,73,107,56,72,96,70,106,93,99,81,98,62,49,52,57,
 381,389,370,366,368,338,249,356,186,208,350,244,212,243,
 266,206,434,202,277,308,214,299,290,306,239,575,565,467,
 495,596,604,469,547,585,572,479,503,582,611,449,538,584,
 573,510,532,593,591,442,539,913,1120,908,943,966,906],
 [24,27,35,58,67,50,61,82,79,94,85,66,77,53,71,55,104,64,
 108,74,101,56,54,78,96,75,91,99,49,68,52,57,471,372,
 475,347,355,542,423,283,247,264,215,261,203,292,287,281,
 245,228,235,192,187,278,416,513,518,477,564,427,508,413,
 487,505,459,552,396,499,502,431,486,815,887,716,746,895,
 874,745,763,839,789,899,1183,1403,1016,1253,1399,902,1096,
 1171,1008,1230,1512,928,1213,1456,965,1147,1261,1409,1798,
 1435,1662,1394,1622,1440,1744,1418,1720,1458,1680,2275,2210,
 2211],
 [24,27,35,58,67,50,61,82,79,94,85,89,66,77,71,55,104,64,
 108,74,101,107,56,54,78,96,75,90,91,99,49,52,57,471,
 372,475,347,355,542,423,283,247,215,261,203,292,437,287,
 235,187,278,357,416,513,477,564,509,427,508,447,413,487,
 396,499,431,486,468,815,887,746,712,845,895,874,763,723,
 941,839,899,1183,1016,1253,902,1096,1031,1175,1251,1008,
 1230,928,1213,965,1147,1138,1300,1159,1409,1798,1821,1435,
 1662,1910,1394,1622,1750,1902,1440,1744,1899,1418,1720,1810,
 1458,1680,1848,1715,2275,2210,2211],
 [24,27,35,58,67,50,61,82,85,89,66,77,53,71,55,104,64,108,
 74,101,107,56,54,78,96,75,90,91,80,99,49,68,52,57,471,
 372,475,347,355,542,423,283,247,215,261,203,292,200,253,
 287,245,228,235,187,278,416,513,477,564,427,508,413,487,
 459,552,396,499,431,486,788,877,815,887,746,963,938,895,
 874,763,839,789,899,1183,1016,1253,902,1096,1008,1230,928,
 1213,965,1147,1409,1798,1435,1662,1394,1622,1440,1744,1418,
 1720,1458,1680,2275,2210,2211],
 [24,27,35,58,67,50,61,82,89,66,77,53,71,55,104,64,102,63,
 84,56,54,78,96,75,90,91,93,81,98,49,68,52,57,471,372,
 432,475,347,355,542,283,193,234,300,259,280,227,230,201,
 276,200,253,287,262,250,246,281,451,501,455,530,416,513,
 427,508,413,487,452,517,459,552,764,703,957,1023,728,725,
 792,932,1033,840,1044,1262,1162,1280,1121,1356,986,1169,
 1201,1360,1036,1275,1692,1713,1578,1586,1626,1719,1632,1485,
 1675,1735,1587,1543,2261,2268,2237],
 [24,27,35,58,67,50,61,82,105,66,77,53,71,55,104,64,108,
 102,56,54,78,96,75,91,93,80,81,98,49,68,52,57,471,372,
 432,475,347,355,542,283,193,234,259,227,230,276,200,253,
 250,246,281,245,228,451,501,500,455,530,416,513,518,427,
 508,413,487,505,452,517,514,459,552,764,824,722,703,1023,
 728,802,715,725,932,1033,840,1044,1262,1162,1280,1121,1356,
 986,1169,1201,1360,1036,1275,1692,1713,1653,1578,1586,1583,
 1626,1719,1462,1632,1485,1745,1675,1735,1580,1587,1543,1497,
 2261,2268,2237],
 [24,27,35,58,67,50,61,105,66,77,71,55,104,64,108,102,63,
 84,56,54,78,96,75,90,91,93,81,98,49,68,52,57,471,372,
 432,475,347,355,542,283,186,193,234,259,307,227,230,276,
 202,200,253,250,246,281,451,501,455,530,441,416,513,427,
 508,447,413,487,452,517,459,552,470,764,703,859,1023,728,
 725,883,932,1033,840,1044,1262,948,1162,1280,850,1121,1356,
 936,986,1169,952,1201,1360,856,1036,1275,860,1692,1713,
 1578,1586,1626,1719,1632,1485,1675,1735,1587,1543,2261,2268,
 2237],[24,27,35,58,67,82,85,66,77,71,55,104,64,74,101,
 107,56,96,75,91,99,49,52,57,471,372,475,347,542,423,283,
 247,215,261,270,203,292,437,287,295,245,228,273,235,187,
 278,357,575,565,500,416,513,477,564,585,572,489,427,508,
 413,487,584,573,514,459,552,396,499,431,486,468,815,887,
 742,879,746,895,765,874,718,890,763,839,789,857,1277,899,
 1183,1016,1253,1861,1039,881,945,1208,902,1096,1089,1024,
 1008,1230,1897,848,1273,928,1213,1002,1027,965,1147,1937,
 1103,911,2167,2107,1409,1798,1435,1662,2310,1394,1622,1508,
 2046,1440,1744,1418,1720,1638,2052,1458,1680,2186,4319,4514,
 4727,4398,4435,4705,2275,2210,2211,3275,2816,3279,2850,2846,
 2913,2684,2506,3202,2833,3141,2777,2743,3038,2832,2555,9200,
 5229,5081,7625,5988,5582,7330,5010,5172,9236,6999,6881,6284,
 9121,8996],
 [24,27,35,58,67,82,105,66,77,71,55,104,64,102,56,96,75,
 91,93,81,98,49,52,57,471,432,475,347,355,542,283,259,
 359,227,230,215,261,270,276,295,250,246,281,245,228,357,
 575,565,455,530,416,513,509,585,572,489,427,508,483,584,
 573,452,517,459,552,468,764,772,742,879,703,919,1023,728,
 751,718,890,725,932,1148,1033,1248,1115,857,1277,1158,1011,
 1044,1262,1861,1416,1457,1162,1280,945,1208,1089,1024,1121,
 1356,986,1169,848,1273,1819,1002,1027,1445,1396,1201,1360,
 1036,1275,2476,2269,1571,1495,1549,1692,1713,1110,1958,1578,
 1586,1568,1743,1481,1626,1719,1632,1485,1525,1594,1576,1778,
 1675,1735,1587,1543,2724,3349,3576,2630,2999,2557,3164,2699,
 3302,3549,2524,2793,2510,3251,2261,2268,2237,5369,3375,3657,
 3835,4312,4068,3386,5535,4247,3783,4081,4683,5900,4726],
 [24,27,35,58,100,105,85,66,59,95,77,55,104,74,101,102,73,
 107,56,96,93,99,81,98,49,52,57,381,370,366,368,338,249,
 356,186,350,244,309,212,243,266,206,382,436,434,202,308,
 214,348,299,290,306,239,220,301,314,575,565,467,495,596,
 604,469,547,585,572,479,503,582,611,449,538,584,573,510,
 532,593,591,442,539,2045,1010,942,714,1963,979,884,721,
 913,1120,908,943,966,906,899,1183,1016,1253,902,1096,1008,
 1230,928,1213,965,1147,1821,1910,1750,1899,1810,1848,3242,
 2779,3736,3238,2872,3303],
 [24,27,35,58,100,105,85,92,88,66,77,55,104,83,74,101,102,
 107,56,72,96,70,106,93,99,81,98,62,49,52,57,381,389,
 366,368,338,249,356,186,304,351,350,244,212,243,266,206,
 434,202,254,328,308,214,299,290,306,239,578,575,565,467,
 495,606,622,596,604,469,547,589,585,572,479,503,607,582,
 611,449,538,620,603,584,573,510,532,613,593,591,442,539,
 913,1120,908,943,966,906],
 [24,27,35,58,105,85,66,77,55,104,74,101,102,107,56,96,93,
 99,81,98,49,52,57,381,366,368,338,249,334,356,186,350,
 229,244,212,206,221,288,436,434,202,207,269,308,214,299,
 239,220,301,575,565,467,495,622,596,604,469,547,585,572,
 479,503,607,582,611,449,538,483,584,573,510,532,613,593,
 591,442,539,396,499,566,700,870,714,685,705,914,721,699,
 913,1120,908,943,966,906,1601,1177,1188,1102,1534,1207,
 1296,1741,1031,1175,1548,1241,1383,1100,1299,1186,1649,1179,
 1189,1665,1138,1300,2117,1373,1585,1837,2053,2264,1380,1469,
 1831,2047,2243,1417,1666,1715,2126,3124,3015,3602,2611,3036,
 3196,3199,4117,2554,2972,4095,6006,4091,4577,4779,4751],
 [24,27,35,58,105,85,92,88,66,59,95,77,55,104,74,101,102,
 73,107,56,96,65,87,70,106,93,99,81,98,62,49,52,57,381,
 389,370,366,368,338,249,334,356,186,350,229,244,212,206,
 436,434,202,308,260,214,299,239,575,565,551,467,495,596,
 604,558,469,547,585,572,560,479,503,582,611,562,449,538,
 584,573,546,510,532,593,591,569,442,539,913,1120,908,943,
 966,906],
 [24,27,35,67,82,100,105,85,66,59,95,71,64,74,101,102,73,
 107,56,75,91,93,99,81,98,49,52,57,389,370,366,392,362,
 338,249,334,322,331,320,221,288,382,388,436,311,303,348,
 349,290,306,220,301,314,596,604,469,547,489,582,611,510,
 532,593,591,442,539,502,1482,950,1272,1710,878,823,1661,
 1053,1639,861,923,721,1172,1539,1760,1354,1663,867,1267,
 1016,1253,1595,1730,1532,1815,1322,1590,848,1273,928,1213,
 1592,1773,965,1147,2818,3094,2770,2991,1822,1856,1765,1751,
 1740,1909,1932,1788,1747,1816,1843,1576,1824,1780,3283,3310,
 2779,3262,3403,2872,3303,2156,2147,2213,3698,3858,2997,2921,
 3438,3827,3580,3868,3069,2927,3537,3894,8626,6679,8703,8823,
 7002,9204,6356,7207],
 [24,27,35,67,82,100,105,85,92,88,66,59,95,71,64,74,101,
 102,73,107,56,72,91,70,106,93,99,81,98,62,49,52,57,389,
 370,366,392,362,368,338,249,322,331,320,229,212,243,266,
 388,436,311,303,260,349,299,290,306,596,604,469,547,479,
 503,582,611,510,532,593,591,442,539,1482,2045,1272,823,
 1661,1963,1053,923,1012,1172,1539,1760,1354,1663,1595,1730,
 1532,1815,1322,1590,1592,1773,1822,1856,1765,1751,1909,1932,
 1788,1747,1816,1843,1824,1780,2156,2147,2213],
 [24,27,35,67,82,100,105,85,92,88,66,59,95,71,83,64,74,
 101,102,107,56,75,70,106,93,99,81,98,62,49,52,57,389,
 370,366,392,362,368,338,249,322,331,320,243,266,206,388,
 311,303,348,349,290,306,239,622,596,604,469,547,479,503,
 607,582,611,510,532,613,593,591,442,539,1482,950,1272,823,
 1661,892,1053,923,1012,1172,2717,1539,1760,2600,1354,1663,
 2039,1595,1730,2827,1532,1815,2492,1322,1590,2098,1592,1773,
 1822,1856,1765,1751,1909,1932,1788,1747,1816,1843,1824,1780,
 2156,2147,2213],
 [24,27,35,67,82,105,66,71,64,74,101,102,56,75,91,93,81,
 98,49,52,57,370,366,362,249,259,240,272,322,331,320,264,
 276,388,436,217,207,269,311,303,260,281,349,220,301,209,
 441,596,604,469,547,509,574,447,607,582,611,483,571,510,
 532,470,593,591,502,468,566,1482,935,1272,1010,942,823,
 1661,1963,843,1053,979,884,923,699,1172,1539,1760,1391,
 1263,1354,1663,1534,1399,1207,1296,1416,1457,1595,1730,1455,
 1530,1532,1815,1548,1299,1186,1322,1590,1456,1179,1189,1445,
 1396,1592,1773,1665,1218,1448,1393,4759,2643,4504,2653,1822,
 1856,1874,1941,1765,1751,1820,1860,1909,1932,1901,2204,1788,
 1747,1739,1783,1816,1843,2433,1900,2016,1824,1780,1814,1896,
 3939,3478,5433,2611,3965,3849,3594,5462,2554,4033,2156,9327,
 2147,7803,2213,8485,3763,3923,2843,3198,3183,3660,2882,3007,
 4136,4374,2800,3721,3380,3220,2626,2855,3468,4790,2788,3132,
 3555,3635,2688,2940,5391,4226,5183,3842,4978,4174,8412,6023,
 5827,5599,8044,5316,7356,5913,5574,4969,6588,5184],
 [24,27,41,35,13,58,50,61,85,66,71,74,101,107,96,75,91,99,
 49,52,57,389,475,392,542,423,283,356,193,234,331,320,244,
 247,215,261,203,292,287,311,303,214,245,228,187,278,578,
 464,526,558,416,513,477,564,511,427,508,447,474,413,487,
 519,546,459,552,535,431,486,468,815,796,887,750,742,879,
 746,921,895,874,718,890,763,875,1148,1248,839,1115,789,
 899,1183,1016,1253,1245,1039,881,902,1096,1089,1024,1455,
 1530,1008,1230,928,1213,1002,1027,965,1147,1103,911,1448,
 1393,2033,2427,2440,2585,1409,1798,1435,1662,2310,1394,1622,
 2046,1440,1744,1418,1720,2052,1458,1680,2186,2105,5019,2339,
 2179,5914,2266,2275,2210,2211,3275,2816,3279,2850,2913,2684,
 3202,2833,3141,2777,3038,2832,5229,5081,5988,5582,5010,5172,
 5842,5166,5690,5136,5645,6014],
 [24,27,41,35,40,13,58,51,67,50,61,82,100,79,94,105,85,92,
 88,66,59,95,77,71,55,104,83,64,74,101,102,73,107,63,84,
 56,72,54,78,96,75,65,87,91,70,106,93,99,81,98,62,49,
 52,57],
 [24,27,41,35,40,13,58,67,50,61,79,94,85,66,77,55,104,64,
 74,101,107,56,54,78,96,75,91,49,471,347,355,542,423,247,
 215,261,203,292,435,386,202,287,235,187,278,335,343,416,
 513,477,564,543,427,508,561,612,562,413,487,396,499,431,
 486,553,566,1160,815,887,746,712,845,1238,895,874,763,723,
 941,839,2197,1601,899,1183,1016,1253,902,1096,1031,1175,
 1521,1548,1008,1230,928,1213,965,1147,1138,1300,1541,1409,
 1798,1981,1435,1662,1782,1394,1622,2144,1902,2552,1440,1744,
 1791,1418,1720,1944,1458,1680,1888,1715,3216,2275,8554,2210,
 7617,2211,8830],
 [24,27,41,35,40,13,58,67,50,61,82,77,71,55,104,102,56,54,
 78,96,75,81,98,49,52,57,471,372,475,347,355,542,283,193,
 234,300,259,244,227,230,251,276,200,253,287,214,250,246,
 281,245,228,451,501,397,455,530,416,513,453,427,508,413,
 487,448,452,517,417,459,552,764,824,722,703,921,1023,728,
 802,715,725,875,932,851,1033,840,789,1044,1262,1162,1280,
 1121,1356,986,1169,1201,1360,1036,1275,1692,1713,1410,1578,
 1586,1513,1626,1719,1387,1632,1485,1561,1675,1735,1382,1587,
 1543,1551,2577,2261,2465,2268,2477,2237],
 [24,27,41,35,40,13,58,67,50,61,82,79,94,105,77,71,55,104,
 64,74,101,102,73,107,63,84,56,54,78,96,75,65,87,91,99,
 81,98,62,49,52,57,334,208,259,240,272,291,304,351,221,
 288,251,436,277,217,207,269,238,254,328,260,220,301,235,
 935,950,685,843,892,699],
 [24,27,41,35,40,13,58,67,50,61,82,85,77,71,55,104,64,74,
 101,56,54,78,96,75,49,52,57,471,372,475,347,355,542,283,
 247,264,215,261,203,292,200,253,287,281,245,228,235,209,
 187,278,416,513,453,477,564,427,508,413,487,448,459,552,
 396,499,454,431,486,788,877,815,887,668,746,963,938,895,
 874,671,763,1033,839,840,789,964,899,1183,1426,1016,1253,
 1446,902,1096,1290,1008,1230,1443,928,1213,1406,965,1147,
 1369,1409,1798,1435,1662,1394,1622,1440,1744,1418,1720,1458,
 1680,2275,2210,2211],
 [24,27,41,35,40,13,58,67,50,61,82,100,79,94,105,66,59,95,
 77,71,55,104,64,74,101,102,73,107,63,84,56,54,78,96,75,
 99,81,98,49,52,57,334,259,240,272,309,243,266,206,221,
 288,251,382,436,217,207,269,290,306,239,220,301,235,314,
 935,714,685,843,721,699],
 [24,27,41,35,40,13,58,67,82,77,55,104,64,102,63,84,56,54,
 78,75,91,93,49,52,57,471,475,347,355,283,324,315,193,
 234,259,291,276,203,292,406,383,200,253,287,238,308,250,
 246,281,187,278,551,451,501,455,530,592,427,508,562,413,
 487,571,452,517,459,552,815,696,876,761,764,703,1023,895,
 684,728,725,932,840,1305,1391,1263,1044,1262,1162,1280,
 1377,1121,1356,986,1169,1274,1201,1360,1036,1275,2444,2469,
 3058,2457,2162,1894,1692,1713,1578,1586,2067,1626,1719,1632,
 1485,1980,1675,1735,1587,1543,3662,3998,3227,3150,3932,3336,
 4655,3664,3401,3408,2261,2268,2237,3933,4327,5489,3925,4914,
 3498,5986,5973],
 [24,27,41,40,25,67,50,82,100,79,94,105,88,76,59,95,77,71,
 55,83,64,108,74,102,73,84,72,54,78,96,75,65,91,93,98,
 62,49,68,52,334,315,259,240,291,264,215,310,266,216,221,
 288,276,203,388,217,207,238,303,258,220,301,209,187,1482,
 752,862,800,707,712,808,697,694,717,723,799,664,3315,1930,
 1793,1998,1784,6028,4597],
 [24,27,58,67,82,79,94,85,66,76,77,53,71,55,104,64,74,101,
 107,56,96,75,91,86,99,49,52,57,471,372,475,347,542,423,
 283,324,315,307,247,215,261,293,318,270,201,203,292,437,
 406,383,287,245,228,235,192,187,278,357,416,513,477,564,
 574,427,508,413,487,459,552,396,499,431,486,815,887,859,
 746,919,895,874,763,785,798,872,839,789,899,1183,1016,
 1253,1861,902,1096,1008,1230,1897,928,1213,965,1147,1193,
 1937,2564,2473,2725,2066,2397,1409,1798,1435,1662,1394,1622,
 1440,1744,1418,1720,1458,1680,4319,2779,4514,4727,4398,2872,
 4435,4705,2275,2210,2211,4860,4276],
 [24,31,19,30,58,51,67,82,100,79,105,77,55,104,101,102,73,
 107,56,72,87,70,93,81,57,340,316,381,366,368,315,291,
 298,304,293,329,206,216,435,383,250,358,349,239,258,335,
 430,515,594,606,458,461,583,609,503,466,524,579,618,426,
 488,478,494,595,600,539,456,498,576,615,870,722,1107,778,
 1635,912,1192,845,1347,914,1075,795,1708,1122,1344,941,
 1308,1371,1660,1331,1818,1314,1605,1102,1343,948,1667,993,
 1506,850,1671,1326,1922,1251,1521,936,1538,1100,1444,1038,
 1536,856,1570,1367,1931,1159,1541,860,1602,2291,2444,2862,
 2088,3058,2809,2158,2463,2318,2589,2295,2901,2811,3706,2748,
 3366],[24,31,19,34,25,51,67,82,100,79,94,88,104,83,64,
 108,102,63,56,72,54,78,60,75,87,90,93,98,62,49,68,342,
 324,222,259,307,291,298,304,359,350,221,201,276,435,383,
 287,223,217,267,238,213,254,319,295,308,250,228,220,192,
 209,335,1507,815,796,876,739,764,722,1272,866,726,864,704,
 662,871,853,724,728,715,1053,812,702,829,698,645,1929,
 2215,3039,2884,2134,2351,1978,2078,2402,2375,2274,2332,3516,
 3930,3884,5440,3162,6052,3793,4206,3559,6576,4064,4866,7871,
 7833,7005,4280,7010,6758,6856,4711],
 [24,31,19,34,25,51,67,82,100,79,94,105,88,59,53,71,104,
 83,64,108,102,63,84,56,72,54,78,60,75,87,90,91,86,93,
 98,62,49,68,52,342,324,222,259,307,291,298,329,221,201,
 276,383,223,217,267,238,213,319,250,226,281,220,192,209,
 1507,796,876,739,764,864,871,853,724,728,1265,920,829,
 1929,2215,1978,2078,3586,3516,3793],
 [24,31,19,34,30,25,51,67,50,82,100,79,94,105,88,89,59,
 104,64,108,102,56,72,54,78,60,75,87,90,91,86,70,98,49,
 68,52,342,315,222,259,291,298,227,251,201,276,223,217,
 238,213,319,295,308,250,226,281,245,228,235,192,209,796,
 784,696,739,764,824,722,864,871,765,684,724,728,802,715,
 1053,1265,903,829,2362,1929,1942,2442,1978,2092],
 [24,31,19,34,30,25,51,67,50,82,100,79,94,105,88,89,59,
 104,64,108,102,84,56,72,54,78,60,75,87,90,91,86,70,98,
 49,68,52,342,315,222,259,291,298,227,251,201,276,223,217,
 238,213,319,295,308,250,226,281,245,235,192,209,796,784,
 696,739,764,824,864,871,765,684,724,728,802,1053,1265,903,
 829,2362,1929,1942,2442,1978,2092],
 [24,31,19,34,30,25,51,67,61,79,105,66,76,77,104,74,73,
 107,56,72,96,87,91,86,70,93,340,381,377,368,342,186,208,
 272,304,247,261,293,292,435,388,223,217,269,254,231,228,
 358,335,495,441,570,594,606,518,509,543,583,609,447,561,
 579,618,483,557,586,620,514,470,559,595,600,576,615,959,
 644,754,670,1347,741,669,1308,1436,1371,1450,1331,1315,
 1314,1114,1285,881,1173,1423,1257,1731,936,1538,1034,1255,
 1027,1209,1420,860,1602,2443,2029,2475,1895,2196,2380,2328,
 1999,2404,2830,2980,2769,3308,3184,3397],
 [24,31,19,34,30,25,51,67,82,100,79,94,105,88,59,104,102,
 84,56,72,54,60,75,87,90,91,86,70,93,98,49,68,52,342,
 324,222,259,307,291,298,244,280,223,217,267,319,295,308,
 214,262,250,226,281,245,323,192,209,1507,796,784,696,876,
 739,764,824,716,668,871,765,684,853,822,1053,745,671,1265,
 920,903,1708,1122,829,2753,2362,1929,2215,1942,2592,2461,
 2442,5308,4043,2879,3586,4700,3376,2776,8706,8689,3516,8906,
 7808,8540,6143,8532,7574,7926,5371,8708,8694,8680,7006,7367,
 7364,6774,6530,6650,7413,8351,8325,8677,8035,6941,8033,6871,
 7559,6626],
 [24,31,19,34,30,25,58,51,67,50,61,82,100,79,94,105,69,85,
 88,89,66,76,59,77,53,71,104,64,108,74,102,73,107,63,84,
 56,72,54,78,96,60,75,87,90,91,86,70,93,80,99,98,49,68,
 52],[24,31,19,34,30,25,58,51,67,61,82,100,79,94,105,
 69,85,88,66,76,59,74,102,73,107,84,56,72,54,96,60,75,
 87,90,91,86,70,93,49,68,52,324,307,322,359,350,320,244,
 280,215,406,267,319,295,308,303,214,262,245,323,192,209,
 278,925,716,668,1107,822,745,671,1075],
 [24,31,19,34,30,25,58,51,67,61,82,100,79,105,66,76,74,
 102,73,107,96,60,75,87,91,86,70,93,340,316,381,366,411,
 377,368,222,259,272,304,322,261,435,223,217,269,228,330,
 348,358,441,570,556,594,606,509,543,527,579,618,483,557,
 470,559,568,595,600,1062,950,1449,1192,823,1975,1040,892,
 1421,1344,923,2044,1436,1371,1331,1315,1314,1362,1577,2103,
 1081,1326,1922,1345,1546,2353,1223,1591,2203,1203,1367,1931,
 1215,1556,2382,1838,2283,1823,2009,1779,2205,1904,2180,1775,
 1961,1839,1970,3973,3798,4029],
 [24,31,19,34,30,25,58,51,67,61,82,100,79,105,69,85,66,76,
 77,104,74,73,107,56,72,96,60,75,87,91,86,93,340,316,
 381,411,377,368,247,261,293,269,358,278,335,518,477,509,
 543,583,609,465,483,557,595,600,431,468,553,576,615,870,
 1107,930,746,845,914,1075,869,763,941,1314,1177,1102,1343,
 1207,993,1506,1104,1861,1171,1031,1251,1521,1241,1100,1444,
 1179,1038,1536,1061,1819,1261,1138,1159,1541,2083,2117,2158,
 2466,2053,2463,1683,1964,2264,2318,2356,2047,2589,2388,2243,
 2295,1696,2173,2126,2901,5818,8276,5062],
 [24,31,19,34,30,51,67,61,82,100,79,105,66,76,77,74,101,
 73,107,96,60,75,87,91,86,93,57,340,316,381,411,377,368,
 342,222,259,272,247,261,310,309,293,292,435,388,269,254,
 303,231,228,330,348,358,278,335,441,570,518,509,543,583,
 609,447,561,579,618,483,557,586,620,514,470,559,595,600,
 468,553,576,615,793,752,974,703,694,1021,725,1436,1450,
 1331,1315,1314,995,1870,1162,1121,986,1201,1036,2193,2302,
 1697,3208,2502,3576,2719,3549,3288,3059,4698,4585],
 [24,31,41,34,25,51,67,50,82,100,79,94,105,88,59,95,53,71,
 104,83,64,108,74,102,84,54,60,75,87,91,86,93,98,62,49,
 68,52,342,315,222,259,291,298,310,309,318,329,221,288,
 201,276,319,226,281,245,220,301,192,209,796,739,764,824,
 974,703,1635,912,808,685,873,864,1265,903,799,699,798,829,
 1929,1942,2033,3330,3335,2511,2418,2056,4466,2031,2559,2061,
 3864,2177,4388,4798,3715,3963,5252,4313,4146,3983,5190,4704,
 4781,5245,4745,5672],
 [24,34,25,58,51,67,50,61,82,100,79,94,105,69,85,92,88,89,
 66,76,59,95,77,53,71,104,83,64,108,74,102,73,107,63,84,
 56,72,54,78,96,60,75,65,87,90,91,86,70,106,93,80,99,
 98,62,49,68,52],
 [24,34,25,58,51,67,61,82,100,79,105,69,85,66,76,95,77,
 104,74,102,73,107,96,60,75,65,87,91,86,70,106,93,340,
 316,381,366,411,377,368,240,272,304,261,310,309,293,292,
 435,207,269,254,228,330,348,358,278,335,441,570,592,594,
 606,509,543,574,583,609,447,561,612,579,618,483,557,571,
 586,620,470,559,601,595,600,468,553,566,576,615,1436,1371,
 1450,1331,1315,1314],
 [24,34,25,58,51,67,61,82,100,79,105,69,85,92,66,76,77,
 104,83,74,102,56,72,96,60,75,65,87,91,86,70,93,340,316,
 381,366,411,377,368,272,304,248,264,261,293,292,382,435,
 269,254,226,281,228,358,278,314,335,530,441,570,594,606,
 564,509,543,583,609,508,447,561,579,618,534,483,557,586,
 620,552,470,559,595,600,486,468,553,576,615,1436,1371,
 1450,1331,1315,1314],
 [24,34,25,58,51,67,61,82,100,79,105,69,85,92,66,76,77,
 104,83,74,102,73,107,56,72,96,60,75,65,87,91,86,70,106,
 93,340,316,381,366,411,377,368,272,304,351,261,293,292,
 382,435,269,254,328,228,358,278,314,335,441,570,594,606,
 509,543,583,609,447,561,579,618,483,557,586,620,470,559,
 595,600,468,553,576,615,1436,1371,1450,1331,1315,1314],
 [24,34,25,58,61,79,105,69,85,66,76,77,104,74,102,96,60,
 75,87,91,86,70,93,381,366,411,377,368,334,356,272,304,
 229,261,293,288,292,435,436,434,269,254,260,228,330,348,
 358,278,335,575,441,570,594,606,622,597,509,543,583,609,
 447,561,579,618,607,617,582,483,557,586,620,519,546,552,
 470,559,595,600,613,605,468,553,576,615,1062,950,900,1040,
 892,868,806,1436,1371,1450,1331,2453,1315,1314,1079,1601,
 1391,1764,1416,1588,1455,1836,1106,1548,1299,1716,928,1445,
 1679,1448,1772,2939,3024,1856,1560,1894,1892,1553,1790,1827,
 1747,1720,1589,1778,1880,4157,4215,9425,8935,8509,3923,3606,
 4487,3220,4307,5644,5242,5895],
 [24,34,25,79,94,105,69,85,88,66,76,59,74,102,84,54,60,75,
 90,91,86,70,93,98,49,68,52,492,443,432,520,484,283,342,
 315,307,322,359,350,320,244,280,215,329,266,388,383,267,
 319,295,308,303,245,323,349,306,192,209,578,616,464,551,
 622,597,526,558,589,619,511,560,607,617,474,562,603,610,
 519,546,613,605,535,569,486,925,716,668,803,733,822,820,
 760,1483,1211,1520,1270,1537,1329,1539,1354,1296,1595,1532,
 1322,1592,2428,2004,2435,2069,3252,3525],
 [24,34,25,79,94,105,69,85,88,89,66,76,59,53,71,64,108,74,
 102,63,84,54,60,75,90,91,86,70,93,80,99,98,49,68,52,
 492,443,432,520,484,385,283,342,324,315,322,320,318,329,
 266,388,406,383,319,303,323,349,306,578,616,464,551,622,
 597,526,558,589,619,511,560,607,617,474,562,603,610,519,
 546,613,605,535,569,1483,1211,1520,1270,1537,1329],
 [24,34,25,79,94,105,69,85,88,89,66,76,59,64,108,74,102,
 84,54,78,60,75,91,86,70,93,80,99,98,49,68,52,492,443,
 432,520,484,385,283,342,315,322,359,350,320,329,266,270,
 388,383,319,295,308,303,349,306,273,578,616,575,464,551,
 622,597,596,526,558,589,619,585,511,560,607,617,582,474,
 562,603,610,584,519,546,613,605,593,535,569,1483,1211,
 1520,1270,1537,1329],
 [24,34,25,79,105,69,85,88,66,76,59,74,102,84,54,60,75,91,
 86,70,93,98,52,492,443,432,520,484,342,315,322,359,350,
 320,215,329,266,404,437,388,383,253,319,303,245,349,306,
 325,357,578,616,464,551,594,606,622,597,526,558,547,509,
 543,589,619,511,560,612,579,618,607,617,474,562,603,610,
 519,546,595,600,613,605,535,569,566,877,794,1400,893,938,
 1424,947,1483,1211,2436,1520,1270,1537,1329,1539,1403,1354,
 1399,1216,1595,1171,936,1538,1532,1512,1322,1456,1592,1261,
 860,1602,2956,3029,1751,1910,1782,1860,1827,1747,1899,1791,
 1780,1848,1888,2034,3000,3101,7400,7724,8188,3178,2784,3067,
 2489,3031,5000,5082,5956],
 [24,34,25,79,105,69,85,88,89,66,76,59,53,71,74,102,63,84,
 54,60,75,90,91,86,70,93,80,99,98,49,68,52,492,443,432,
 520,484,385,283,342,324,315,322,320,244,280,329,266,388,
 406,383,319,303,214,262,349,306,578,616,464,551,495,622,
 597,526,558,547,589,619,511,560,503,607,617,474,562,538,
 603,610,519,546,532,613,605,535,569,539,1483,1211,1520,
 1270,1537,1329],
 [24,35,25,58,51,67,50,61,82,100,79,94,105,69,85,92,88,89,
 66,59,95,77,53,71,55,104,83,64,108,74,102,73,107,63,84,
 56,72,54,78,96,60,75,65,87,90,91,70,106,93,80,99,81,
 98,62,49,68,52],
 [24,35,25,58,82,79,94,105,85,88,89,66,59,77,104,64,108,
 74,102,107,56,54,78,96,87,90,91,70,93,80,99,81,98,49,
 68,52,372,394,492,443,432,347,429,520,355,423,419,484,
 385,283,356,359,350,331,212,434,295,308,311,299,578,575,
 565,622,596,604,589,585,572,607,582,611,603,584,573,613,
 593,591,1483,1520,1537],
 [24,35,25,58,82,100,79,105,69,85,92,88,66,59,77,104,83,
 64,74,102,107,56,72,54,96,60,65,87,91,70,106,93,99,98,
 62,49,52,316,381,389,407,370,345,366,362,377,368,338,354,
 249,356,351,350,212,434,328,308,299,578,575,565,622,596,
 604,589,585,572,607,582,611,603,584,573,613,593,591,913,
 1847,908,1852,966,1924],
 [24,35,25,61,82,79,94,105,85,88,89,66,59,71,104,64,108,
 74,102,84,56,54,78,75,87,90,91,70,93,80,99,81,98,49,
 68,52,372,394,492,443,432,347,429,520,355,423,419,484,
 385,283,342,322,359,331,329,388,319,295,311,349,578,616,
 575,622,597,596,589,619,585,607,617,582,603,610,584,613,
 605,593,1483,1520,1537],
 [24,35,25,61,82,79,94,105,85,88,89,66,59,77,53,55,104,64,
 108,74,107,84,56,54,78,96,87,91,70,93,80,99,81,98,49,
 68,52,372,394,492,443,432,347,424,355,423,419,484,385,
 283,356,350,212,270,434,308,299,273,588,578,575,637,622,
 596,580,589,585,626,607,582,599,603,584,623,613,593,1752,
 1800,1770,1759,1755,1767],
 [24,35,25,61,82,79,105,85,88,66,59,77,104,64,74,107,84,
 56,54,96,87,91,70,93,99,98,49,52,316,381,389,407,370,
 345,392,313,362,377,368,338,354,249,222,240,350,229,309,
 288,223,207,348,299,301,588,530,637,622,596,458,416,574,
 580,508,626,426,413,571,599,552,623,613,593,456,396,566,
 1378,1112,893,1488,918,947,721,1757,1796,1835,2717,1539,
 2600,1933,1354,1534,2039,1595,2827,2335,1532,2492,1322,2098,
 2112,1592,1665,2818,2770,3077,4230,2852,4078,2785,3879,3939,
 3478,3965,3849,3594,4033,4678,5336,4888],
 [24,35,25,61,82,100,79,105,69,85,92,88,66,59,71,104,83,
 64,74,102,84,56,72,54,60,75,65,87,91,70,106,93,99,98,
 62,49,52,316,381,389,407,370,345,366,362,377,368,338,354,
 249,342,351,322,329,388,328,319,349,578,616,575,622,597,
 596,589,619,585,607,617,582,603,610,584,613,605,593,913,
 1847,908,1852,966,1924],
 [24,35,25,61,82,100,79,105,69,85,92,88,66,59,95,77,104,
 83,64,74,107,84,56,72,54,96,87,91,70,106,93,99,98,62,
 49,52,316,381,389,407,370,345,392,313,362,377,368,338,
 354,249,356,350,255,212,243,434,308,305,299,290,588,578,
 575,637,622,596,580,589,585,626,607,582,599,603,584,623,
 613,593,1757,1796,1835],
 [24,35,25,67,82,79,94,105,85,88,89,66,59,53,71,55,104,64,
 108,74,102,107,56,54,75,87,90,91,70,93,80,99,81,98,49,
 68,52,394,492,443,432,347,429,520,424,355,423,419,484,
 385,283,342,322,318,329,388,319,323,349,578,575,565,622,
 596,604,589,585,572,607,582,611,603,584,573,613,593,591,
 1148,1248,1115],
 [24,35,25,67,82,100,79,105,69,85,92,88,66,59,95,71,104,
 83,64,74,102,107,56,54,60,75,65,87,91,70,106,93,99,98,
 62,49,52,381,389,407,370,345,366,392,313,362,377,368,338,
 354,249,342,322,309,329,388,319,348,349,578,575,565,622,
 596,604,589,585,572,607,582,611,603,584,573,613,593,591,
 2535,2676,2453],
 [24,35,34,58,50,82,79,94,105,85,89,59,77,53,104,64,108,
 74,101,102,107,63,56,54,78,96,60,87,93,99,49,52,57,372,
 492,432,347,520,355,484,283,356,222,272,212,270,221,201,
 292,437,223,269,308,220,192,278,357,578,565,397,530,589,
 572,412,508,448,534,603,573,454,486,696,750,635,919,684,
 769,628,872,840,964,1111,1197,1245,1072,1137,1108,1227,
 1240,1116,1150,1218,1057,1384,1359,1452,1422,1398,1306,1425,
 1413,1465,1390,1337,1428,2002,2021,2011],
 [24,35,34,58,51,67,50,61,82,100,79,94,105,69,85,92,88,89,
 66,59,95,77,53,71,104,83,64,108,74,101,102,73,107,63,
 84,56,72,54,78,96,60,75,65,87,90,91,70,106,93,80,99,
 98,62,49,68,52,57],
 [24,35,34,58,67,79,105,69,88,59,77,71,64,74,101,102,54,
 96,75,70,93,49,52,57,340,381,402,366,411,368,249,334,
 315,264,309,255,266,436,383,217,260,348,305,306,209,464,
 551,495,622,604,509,549,511,560,503,607,611,474,538,483,
 544,546,613,591,535,539,468,480,566,644,668,707,665,843,
 671,717,943,906,899,1426,1188,1102,1146,993,1076,1416,937,
 1280,902,1290,1175,1251,1125,1008,1443,1383,1100,1161,1299,
 910,1169,1038,1058,965,1369,1300,1159,1090,1448,886,1275,
 2271,2137,2117,1581,1697,1567,1683,2264,1642,1687,1831,2047,
 1514,1698,1617,1696,1715,2126,1557,1711,3015,3235,3735,3732,
 3057,4322,4038,3047,4868,3199,3254,3738,3650,2752,4305,3918,
 2931,4787,1966,2020,1985,4095,3221,3096,3188,3460,3679,3211,
 4091,3402,3733,3232,4577,3167,3048,3139,3561,3628,3144,4751,
 3385,3727,3289,4397,4342,5528,5526,4503,5952,5987,4908,5707,
 5124,5536,5455,5710,5089,5569],
 [24,35,34,58,67,100,79,105,69,88,59,77,71,64,74,101,102,
 73,84,54,96,75,65,70,93,49,52,57,340,381,402,366,411,
 368,249,334,315,240,291,351,229,264,309,255,266,206,288,
 382,217,207,348,305,306,239,301,209,314,464,495,606,509,
 549,511,503,483,544,535,539,468,480,644,668,862,800,1635,
 1063,714,707,665,671,1708,1289,721,717,906,1102,1146,993,
 1076,933,881,1922,1251,1125,1100,1161,1038,1058,1931,1159,
 1090,1930,1793,1998,1784,1581,1697,1567,1683,2225,1642,1687,
 1514,1698,1617,1696,1557,1711,2839,2051,3017,2131,1966,2020,
 1985,5087,5286],
 [24,35,34,58,67,100,79,105,69,92,88,66,59,95,77,71,83,64,
 74,101,102,73,84,72,54,96,75,70,93,62,49,52,57,340,381,
 370,402,366,411,368,249,334,315,264,255,266,436,383,217,
 305,290,306,239,301,209,464,495,509,549,511,503,474,538,
 483,544,535,539,468,480,644,1710,866,942,668,707,665,1639,
 812,884,671,717,943,906,1102,1146,993,1076,1251,1125,1100,
 1161,1038,1058,1159,1090,1581,1697,1567,1683,1642,1687,1514,
 1698,1617,1696,1557,1711,1966,2020,1985],
 [24,35,34,58,79,105,85,77,64,74,101,102,107,96,60,87,70,
 93,99,49,57,492,347,520,484,356,222,272,304,359,320,293,
 212,437,435,223,269,254,295,308,303,358,273,335,578,565,
 397,530,592,606,574,589,572,489,612,618,448,534,571,603,
 573,601,600,566,696,750,635,1505,684,776,769,628,1379,840,
 1539,1079,1277,1111,1139,1197,1055,1011,948,1362,1245,1072,
 850,1081,1595,1419,1208,1137,1108,936,1345,1227,1094,1240,
 1130,967,952,1223,1322,1317,1273,1116,1150,856,1203,1218,
 1057,860,1215,2917,2914,1987,1384,1359,1410,1892,1452,1422,
 1513,2136,2174,1398,1306,1387,1827,1117,1425,1413,1561,2085,
 1967,1465,1390,1382,1880,1337,1428,1551,2034,4128,4434,4257,
 4274,4224,4186,4871,4218,4071,4160,4701,4890,4252,4008,4482,
 4903,4013,3772,2002,2261,2021,2268,2011,2237,5332,5632,3276,
 3905,3595,3684,2678,2601,5656,2906,6033,3622,4069,2916,3204,
 5088,5092,3247,3890,4039,3184,2604,2784,5129,2897,5927,3570,
 4048,2886,2878,4265,5411,3260,4228,4100,3487,2687,2985,5120,
 2733,5560,3612,3397,2842,3031,7824,4683,8340,5900,7943,4726,
 8234,7450,6760,6875,8429,8145],
 [24,35,34,58,82,79,94,105,85,59,77,53,104,64,108,74,101,
 102,107,63,56,54,78,96,60,87,90,70,99,49,68,52,57,372,
 492,432,347,520,355,283,356,324,222,272,307,212,251,201,
 292,223,269,267,308,235,192,278,578,565,397,530,589,572,
 450,412,508,448,534,603,573,396,454,486,696,750,983,635,
 684,769,920,628,840,964,1111,1197,1245,1072,1137,1108,1227,
 1240,1116,1150,1218,1057,1384,1359,1452,1422,1398,1306,1425,
 1413,1465,1390,1337,1428,2002,2021,2011],
 [24,35,34,58,82,79,94,105,85,59,77,64,74,101,102,107,63,
 54,96,60,87,90,70,93,99,49,52,57,372,492,432,347,520,
 355,484,283,356,222,272,307,310,318,212,201,292,437,406,
 223,269,267,295,308,303,262,330,323,192,278,357,578,565,
 397,530,589,572,412,508,448,534,603,573,454,486,1768,784,
 696,752,719,750,635,765,684,694,709,769,628,840,964,1111,
 1197,1245,1072,1137,1108,1227,1240,1116,1150,1218,1057,7983,
 5125,1384,1359,1452,1422,1398,1306,1425,1413,1465,1390,1337,
 1428,2002,2021,2011],
 [24,35,34,58,82,79,94,105,85,59,77,64,108,74,101,102,107,
 56,54,78,96,60,87,70,93,49,68,52,57,372,492,432,347,
 520,355,484,283,356,222,272,212,201,276,292,223,269,295,
 308,303,192,209,278,578,575,565,500,397,530,589,585,572,
 489,412,508,505,448,534,603,584,573,502,454,486,784,696,
 752,750,635,765,684,694,769,628,840,964,1111,1139,1197,
 1245,1059,1072,1137,1082,1108,1227,1094,1240,1116,1092,1150,
 1218,1005,1057,1194,1384,1359,1110,1452,1422,1184,1398,1306,
 1117,1425,1413,1242,1465,1390,1185,1337,1428,2002,2021,2011]
  ,[24,35,34,58,100,79,105,69,92,88,66,59,95,77,71,83,64,
 74,101,102,72,54,96,75,91,70,106,93,62,49,52,57,340,
 381,370,402,366,411,368,249,334,356,315,248,264,261,255,
 243,266,436,434,383,217,305,290,306,209,464,495,509,549,
 511,503,474,538,483,544,535,539,468,480,644,668,847,707,
 845,665,671,882,717,941,943,906,1102,1146,993,1076,1251,
 1125,1100,1161,1038,1058,1159,1090,1581,1697,1567,1683,1642,
 1687,1514,1698,1617,1696,1557,1711,1966,2020,1985],
 [24,35,34,67,50,82,79,94,105,69,88,89,59,71,64,108,74,
 101,102,56,54,78,60,75,87,90,70,93,80,98,49,68,52,57,
 492,520,355,423,484,283,342,259,322,359,320,264,215,329,
 276,388,217,319,295,303,281,245,349,209,578,565,397,530,
 622,604,558,453,564,589,572,412,508,607,611,448,534,603,
 573,546,417,552,613,591,454,486,1148,851,1248,839,1115,789 
  ],[24,35,34,67,79,105,69,88,59,71,64,74,101,102,54,60,
 75,87,70,93,49,52,57,492,520,423,484,283,342,259,322,
 359,320,264,329,270,276,437,388,217,319,281,349,209,357,
 578,565,397,530,606,622,604,558,453,564,589,572,412,508,
 618,607,611,448,534,603,573,514,417,552,600,613,591,454,
 486,468,480,1400,759,919,1424,817,872,1148,851,1248,839,
 1115,789,1539,1079,1277,1139,1055,1011,1354,1234,1267,1399,
 1059,933,881,1595,1419,1741,1208,1082,951,1024,1532,1106,
 1361,1094,1130,967,1322,1317,1273,1092,984,1027,1592,1363,
 1665,1235,1005,917,911,1549,1623,1749,2200,2310,1481,1508,
 1633,2046,2707,1576,1638,1673,2052,2186,3340,3593,2880,2759,
 2846,2617,2506,2484,2838,2817,2743,2836,2555,2578],
 [24,35,34,67,79,105,69,88,66,59,95,77,71,64,74,101,102,
 73,84,54,96,75,65,91,70,106,93,49,52,57,381,370,402,
 366,411,368,249,342,334,315,264,255,266,388,436,383,217,
 207,305,306,209,575,464,551,495,509,549,574,511,560,503,
 582,474,562,538,483,544,571,535,569,539,468,480,566,644,
 700,668,707,665,705,671,717,943,906,1102,1146,1056,993,
 1076,1145,1251,1125,1239,1100,1161,1105,1038,1058,1083,1159,
 1090,1193,1581,2532,1697,1567,2500,1683,1642,2941,1687,1514,
 2341,1698,1617,2735,1696,1557,2570,1711,1966,2020,1985],
 [24,35,34,67,82,79,94,105,69,88,59,53,71,104,64,108,74,
 101,102,54,60,75,87,70,93,49,68,52,57,492,347,520,423,
 484,283,342,259,322,264,310,318,329,201,276,292,388,217,
 319,281,330,323,349,192,209,278,578,575,565,500,397,530,
 622,596,604,518,453,564,574,589,585,572,489,412,508,607,
 582,611,505,448,534,603,584,573,514,417,552,601,613,593,
 591,502,454,486,1148,851,1248,839,1115,789],
 [24,35,34,67,82,79,94,105,69,88,59,53,71,104,64,108,74,
 101,102,63,56,54,78,60,75,87,90,70,93,80,98,49,68,52,
 57,492,347,520,355,423,484,283,342,324,259,307,322,264,
 329,276,388,406,217,267,319,281,349,209,578,565,397,530,
 622,604,453,564,589,572,412,508,607,611,448,534,603,573,
 417,552,613,591,454,486,1148,851,1248,839,1115,789],
 [24,35,34,67,82,79,94,105,69,88,59,71,64,74,101,102,63,
 54,60,75,87,90,70,93,49,52,57,492,520,423,484,283,342,
 324,259,307,322,359,320,280,264,329,201,276,292,437,388,
 217,267,319,295,303,262,281,330,323,349,192,209,278,357,
 578,565,397,530,622,604,558,453,564,589,572,412,508,607,
 611,448,534,603,573,546,417,552,601,613,591,454,486,1062,
 925,983,1040,822,920,1148,851,1248,839,1115,789,1764,1716],
 [24,37,27,25,82,105,66,77,71,55,84,56,96,91,99,81,98,68,
 52,381,432,475,366,355,542,368,385,272,359,280,227,201,
 269,262,250,235,325,588,496,455,637,597,596,461,416,580,
 485,427,626,617,582,599,494,452,462,459,623,605,593,566,
 752,878,922,1400,697,957,1597,980,903,1424,817,792,2979,
 1483,2957,1520,2995,1069,1537,2373,1539,1555,1158,1073,1044,
 1933,1354,1534,867,1145,1104,1316,1162,2146,1595,1454,1089,
 1155,1121,2335,1532,1548,926,1067,986,1927,1322,1083,1061,
 1526,1002,1224,1201,2112,1592,1665,949,1109,1036,4902,2870,
 1942,3674,3168,2550,3681,4477,2092,4188,3695,2824,2507,3293,
 1625,1692,1619,1373,1480,1578,1510,1626,1608,1380,1544,1632,
 1575,1675,1654,1417,1431,1587,3939,3550,3023,2724,3478,2888,
 3591,2630,3965,2948,2887,2557,3849,3475,3112,2699,3594,2761,
 3290,2524,4033,2942,2936,2510,9271,8868,6648,8482,5892,6152,
 4949,3191,3698,4267,3454,2997,3384,5226,3319,3438,5492,4220,
 3580,3118,4646,3166,3069,5456,3577,3537,3608,5662,4371,3669,
 4864,5926,3185,5253,8673,5292,8089,7379,5464,6307],
 [24,37,27,41,25,58,51,61,100,79,105,85,92,66,76,59,95,77,
 53,71,55,104,83,108,74,102,107,63,56,87,86,70,106,80,
 99,81,62,49,68,52,356,324,272,244,248,261,309,293,329,
 212,243,206,251,292,202,226,228,348,358,349,299,290,239,
 235,278,1160,750,983,778,803,769,920,795,820,2974,3076],
 [24,37,27,41,40,25,51,67,50,82,100,79,105,66,76,59,95,77,
 71,55,83,64,108,74,84,72,54,96,91,106,93,98,62,49,68,
 52,342,315,259,240,272,247,248,264,215,310,212,243,266,
 216,221,276,203,217,207,269,330,258,220,209,187,752,1333,
 800,759,746,847,707,712,635,901,697,694,763,882,717,723,
 628,897,664,2259,1793,2514,2278,1784,2364],
 [24,37,27,41,40,25,51,67,50,82,100,79,105,66,76,59,95,77,
 71,55,83,64,108,74,102,84,72,54,96,91,106,93,98,62,49,
 68,52,342,315,259,240,272,248,264,215,310,212,243,266,
 216,221,276,203,217,207,269,330,258,220,209,187,752,1333,
 800,759,847,707,712,635,901,697,694,882,717,723,628,897,
 664,2259,1793,2514,2278,1784,2364],
 [24,37,27,41,40,25,58,51,61,105,85,92,66,76,59,95,77,71,
 55,104,83,108,74,102,73,107,63,96,75,65,87,86,70,106,
 99,81,49,68,52,356,324,244,261,310,309,293,206,251,292,
 382,434,406,202,277,200,214,228,330,348,358,239,278,314,
 1160,924,788,778,921,1238,1015,963,914,795,875,2241,2398],
 [24,37,27,41,40,25,58,51,61,105,85,92,66,76,59,95,77,71,
 55,104,83,108,74,102,73,107,63,96,75,65,87,86,70,106,
 99,81,68,52,356,324,244,261,310,309,293,206,251,292,382,
 404,434,406,202,277,200,214,228,330,348,358,239,278,314,
 325,1160,924,788,778,921,1238,1015,963,914,795,875,2241,
 2398],[24,37,27,41,40,25,58,51,67,50,61,82,100,79,105,
 85,92,88,66,76,59,95,77,71,55,104,83,64,108,74,102,73,
 107,63,84,56,72,54,96,75,65,87,91,86,70,106,93,99,81,
 98,62,49,68,52],
 [24,37,27,41,40,25,58,61,105,66,76,59,95,77,71,55,104,
 108,74,102,73,107,63,56,96,75,65,87,99,81,49,68,52,334,
 261,309,293,206,216,221,288,292,382,436,434,406,202,277,
 200,217,207,260,214,239,278,314,1378,1768,778,845,685,762,
 662,1029,900,921,1488,1781,1238,1015,963,665,705,914,843,
 710,874,645,961,806,875,3648,4423,4680,3034,2129,2028,2086,
 4019,4370,4364,2543,2352,2398,2137,1976,2659,2239,2099,2161,
 6021,5834,9003,5330,5223,5338,6790,5502,3794,6003,5310,8704,
 8674,7286,6554,5403,9221,7427],
 [24,37,27,41,40,25,58,67,50,61,82,66,76,59,95,77,71,55,
 104,64,108,74,102,73,107,63,84,96,75,65,87,91,86,70,93,
 99,81,98,49,68,52,334,208,193,300,259,240,272,310,309,
 293,288,382,436,277,200,287,260,330,348,358,301,314,935,
 703,809,778,725,868,795,2864,2758],
 [24,37,27,41,40,25,58,67,50,61,82,100,79,105,66,76,59,95,
 77,71,55,104,64,108,74,102,107,63,84,87,91,86,70,93,99,
 81,98,62,49,68,52,334,259,240,272,248,310,309,293,329,
 212,243,288,436,260,226,330,348,358,349,299,290,301,935,
 703,809,778,725,868,795,2864,2758],
 [24,37,27,41,40,25,58,67,50,61,88,66,76,59,77,71,55,104,
 107,63,84,56,86,70,98,49,68,52,471,443,432,475,424,385,
 283,244,280,227,247,251,276,203,202,231,306,239,235,209,
 187,558,469,554,461,416,524,450,562,449,507,494,452,569,
 442,529,498,396,1160,878,866,803,733,727,1238,861,812,820,
 760,736,1211,1558,1270,1329,1286,1601,857,1287,1534,867,
 1338,1741,945,1187,1548,926,1366,1649,848,1264,1665,949,
 1252,1706,1571,1619,1373,1756,1568,1608,1380,1723,1525,1654,
 1417,8711,7854,8265],
 [24,37,27,41,40,25,58,67,50,61,88,76,59,77,71,55,104,108,
 74,107,63,56,96,87,86,70,99,81,98,49,68,52,471,443,432,
 475,385,283,186,300,244,251,214,231,228,551,467,515,451,
 397,558,469,524,450,412,546,510,494,452,417,552,692,722,
 754,880,921,672,715,741,940,875,1211,1285,1391,958,1262,
 1542,1039,1423,1416,937,1731,1455,1018,1255,1299,910,1169,
 1526,1002,1420,1445,1009,1690,1448,886,2162,1894,1874,2310,
 2077,1958,1820,2067,1790,1901,2280,2188,1739,2052,1980,1778,
 1900,1986,1982,1814,4520,4943,5908],
 [24,37,27,41,40,25,58,82,88,66,76,59,77,71,55,102,107,63,
 84,56,93,99,81,98,49,68,52,471,432,475,424,355,385,283,
 320,244,280,227,216,221,434,406,383,214,262,250,306,239,
 258,220,558,469,554,461,416,524,450,562,449,507,494,452,
 569,442,529,498,396,1378,1768,1507,878,866,759,1488,1781,
 1597,861,812,817,1558,992,1266,1069,1286,1601,857,1287,
 1534,867,1338,1741,945,1187,1548,926,1366,1649,848,1264,
 1665,949,1252,1706,1571,1619,1373,1756,1568,1608,1380,1723,
 1525,1654,1417,1881,1912,1875],
 [24,37,27,41,40,25,58,82,105,88,76,59,77,71,55,64,102,
 107,63,56,93,98,49,68,52,471,475,424,355,283,356,324,
 320,280,227,261,329,206,216,221,276,203,434,406,383,349,
 306,258,220,209,187,558,469,461,416,589,524,450,508,562,
 449,613,569,442,498,396,486,1507,878,759,845,704,1597,861,
 817,760,736,941,698,992,1601,857,1534,867,1446,1741,945,
 1548,926,1443,1649,848,1665,949,1085,965,1369,3395,4500,
 3344,3160,1706,1571,1619,1373,1837,1756,1568,1608,1380,1831,
 1723,1525,1654,1417,1680,1715,3974,2664,3283,3477,4814,4633,
 2891,3262,3115,5684,1881,1912,1875,5427,3660,5699,4573,4609,
 4790,8097,4180],
 [24,37,27,41,40,25,67,50,61,88,77,108,74,107,63,84,96,87,
 49,68,52,471,443,424,283,186,291,244,206,292,202,238,213,
 254,214,239,278,588,551,467,570,536,526,558,469,543,522,
 560,479,508,561,473,474,562,449,557,512,571,546,510,559,
 523,569,442,516,431,486,553,463,815,692,887,880,746,921,
 895,672,874,940,763,875,2145,1211,2197,1270,2127,1329,1093,
 899,1285,1391,1225,1016,1423,1416,1077,902,951,1731,1455,
 1142,1008,1255,1299,1067,986,1319,928,1420,1445,1085,965,
 917,1690,1448,2288,2530,2206,2193,2365,2389,2296,2302,2588,
 2162,1574,1435,2077,2408,2067,1515,1440,2280,2316,1980,1636,
 1458,1986,2637,3242,2315,2597,2896,3111,2425,2902,2768,3238,
 2233,2516,2889,2993,2568,2810,5020,7261,9292,7687,4275,5500,
 9285,4972,8672,4698,6912,5449,6974,4585],
 [24,37,27,41,40,25,67,50,82,100,79,105,88,66,76,59,95,77,
 71,55,64,108,74,102,84,96,91,93,98,62,49,68,52,334,315,
 259,240,229,248,264,215,310,309,293,212,243,266,288,276,
 203,348,358,258,220,301,209,187,1482,752,726,1010,1333,
 862,800,703,809,759,714,808,635,901,697,725,868,882,717,
 723,799,628,897,664,3039,2884,2247,3315,3168,2384,2866,
 2514,2454,3695,2278,1998,1784,2364,2445,3884,4968,5797,9187,
 9179,5524,6852,8667,4597,6837,6470,7888,6592,5209,6324,7238,
 8937,8934,6869,7598,7232,7749,8437,6134,6164,6457,6699,7793,
 7091,6330],
 [24,37,27,41,40,25,67,50,82,105,88,76,59,77,71,55,64,102,
 107,63,84,56,96,93,98,49,68,52,475,424,355,542,283,320,
 280,227,216,221,276,203,388,383,306,258,220,209,187,558,
 469,461,416,453,524,450,412,508,607,562,449,569,442,498,
 396,454,486,1482,1507,878,759,733,727,1661,1597,861,817,
 760,736,992,839,2717,1601,857,1534,867,1741,945,1077,902,
 1290,2827,1548,926,1649,848,1665,949,1085,965,1369,1706,
 1571,1579,1619,1373,1648,1756,1568,1628,1622,1902,1608,1380,
 1624,1723,1525,1584,1654,1417,1682,1680,1715,1881,2275,1912,
 2210,1875,2211],
 [24,37,27,41,40,25,713,682,58,67,50,66,76,59,77,71,55,
 107,63,84,56,72,54,99,81,98,49,68,52,1804,2587,1689,
 2558,471,432,475,424,355,385,283,208,193,300,280,227,247,
 216,221,251,277,200,287,262,250,231,258,220,235,515,451,
 501,554,461,416,524,450,506,507,488,413,494,452,517,529,
 498,396,1490,1558,992,1266,1069,1286],
 [24,37,41,35,40,34,13,25,51,67,50,82,100,79,105,69,92,88,
 66,59,71,83,64,74,102,73,107,63,84,96,60,75,65,87,106,
 93,99,98,62,49,52,342,315,259,351,322,320,206,221,388,
 383,328,319,303,330,348,358,239,220,1062,950,1449,1040,
 892,1421,725,2459,2347],
 [24,37,41,35,40,34,13,25,58,51,50,61,100,105,69,85,92,66,
 59,77,104,102,73,107,63,84,72,96,60,75,65,87,91,70,106,
 99,98,62,49,52,356,186,193,272,351,350,229,244,227,434,
 202,200,269,328,308,260,214,250,330,358,235,1062,1449,887,
 1040,1421,874],
 [24,37,41,35,40,34,13,25,58,51,50,61,105,69,85,92,66,59,
 95,77,104,83,102,73,107,63,84,96,60,75,65,87,91,70,106,
 99,98,62,49,52,356,186,208,193,350,244,227,310,309,293,
 251,434,202,277,200,308,214,250,330,348,358,235,870,778,
 914,795],
 [24,37,41,35,40,34,13,25,58,51,67,50,61,82,100,79,105,69,
 85,92,88,66,59,95,77,71,104,83,64,74,102,73,107,63,84,
 56,72,54,96,60,75,65,87,91,70,106,93,99,98,62,49,52],
 [24,37,41,35,40,34,13,25,58,61,105,85,66,59,77,71,104,
 102,107,84,96,75,87,91,70,99,98,49,52,394,492,432,475,
 402,429,520,424,542,411,423,385,283,356,244,227,310,293,
 251,434,214,250,330,358,235,578,575,558,574,511,479,466,
 450,607,582,519,546,510,601,456,396,778,795,1248,1115,
 1079,857,1280,1096,1106,926,1213,1360,1987,1622,2184,1720,
 3103,3003,3923,3220],
 [24,37,41,35,40,34,13,25,58,61,105,85,66,59,77,71,104,
 102,107,84,96,75,87,91,70,99,98,49,52,471,340,372,443,
 432,475,402,347,424,542,411,423,419,484,385,283,356,244,
 227,310,293,251,434,214,250,330,358,235,464,467,458,416,
 574,511,479,519,510,478,452,601,778,795,2628,2209,2835,
 2250,2762,2272,1183,1096,1213],
 [24,37,41,35,40,34,13,25,58,61,105,85,66,59,95,77,104,
 102,73,107,63,84,96,60,75,65,87,91,70,99,98,62,49,52,
 334,324,229,310,309,293,288,436,434,406,202,277,200,308,
 260,214,250,348,301,235,1378,1160,924,788,887,974,809,778,
 808,762,1488,1238,1015,963,1048,705,914,874,795,799,785,
 3511,2008,2241,2603,1991,2444,2418,2363,3780,2352,2398,2070,
 1976,2088,2559,2562,5915,4025,8624,5930,3359,3539,5280,3794,
 5480,7661,3514,3508],
 [24,37,41,35,40,34,13,25,58,67,61,82,79,105,85,88,66,59,
 77,71,104,64,74,102,107,84,56,54,96,75,87,91,70,93,99,
 98,49,52,471,340,372,394,492,443,432,475,402,347,429,520,
 424,355,542,411,423,419,484,385,283],
 [24,37,41,35,40,34,13,25,58,67,61,82,79,105,85,88,66,59,
 95,77,71,104,64,74,102,73,107,63,84,56,54,96,60,75,65,
 87,91,70,93,99,98,62,49,52,334,324,222,240,229,309,288,
 436,406,277,223,207,260,348,301,924,1015],
 [24,37,41,35,40,34,13,25,58,67,61,82,100,79,105,85,88,66,
 59,77,71,104,64,74,102,73,107,63,84,56,54,96,60,75,65,
 87,91,70,93,99,98,62,49,52,334,324,222,240,229,309,288,
 436,406,223,207,328,260,348,301,819,863],
 [24,37,41,35,40,34,13,25,58,67,82,79,85,88,77,71,104,102,
 107,84,56,54,75,87,91,70,93,98,49,52,471,340,372,443,
 475,402,429,520,424,355,542,411,423,419,484,385,283,315,
 291,304,244,227,276,383,238,254,214,250,349,209,490,592,
 558,533,571,546,563,1272,1053,2628,2209,2835,2250,2762,2272 
  ],[24,37,41,35,40,34,13,25,58,67,82,79,85,88,77,71,
 104,102,107,84,56,54,75,87,91,70,93,98,49,52,471,340,
 394,492,443,475,402,347,424,355,423,419,484,283,315,291,
 304,244,227,276,383,238,254,214,250,349,209,551,490,592,
 458,416,533,508,562,571,478,452,613,593,486,1272,1053,
 2600,1354,2492,1322,1252,4377,4671],
 [24,37,41,35,40,34,13,25,58,67,82,79,105,85,88,77,104,
 102,107,84,56,54,75,87,91,70,93,98,49,52,471,340,372,
 394,492,443,429,520,424,355,542,411,423,419,484,385,283,
 315,291,304,244,227,329,383,238,254,214,250,349,209,570,
 592,558,561,571,546,559,668,671,2145,1436,2197,1450,2127,
 1315],
 [24,37,41,35,40,34,13,25,58,67,82,79,105,85,88,77,104,
 102,107,84,56,54,75,87,91,70,93,98,49,52,471,340,394,
 492,443,475,402,347,424,355,423,419,484,283,315,291,304,
 244,227,329,383,238,254,214,250,349,209,551,570,592,458,
 416,589,585,562,571,478,452,559,613,593,486,668,671,1296,
 1506,1189,1536],
 [24,37,41,35,40,34,13,25,67,61,82,79,105,88,77,71,64,74,
 102,107,84,96,75,87,93,99,98,49,52,372,394,492,475,402,
 429,520,424,542,411,423,385,283,342,259,320,310,293,206,
 221,388,303,330,358,239,220,578,575,397,455,530,558,574,
 466,450,412,427,607,582,546,601,456,396,703,725,851,839,
 1280,1290,1031,1360,1369,1138,1902,1715],
 [24,37,41,35,40,34,13,25,67,61,82,79,105,88,77,71,64,74,
 102,107,84,96,75,87,93,99,98,49,52,471,340,372,394,492,
 443,475,402,347,429,520,424,542,411,419,484,385,283,342,
 259,320,310,293,206,221,388,303,330,358,239,220,397,455,
 574,560,412,427,417,459,601,569,703,725,851,839,789],
 [24,37,41,35,40,34,13,25,67,61,105,88,77,71,64,74,107,84,
 96,87,93,99,49,52,471,340,394,492,443,475,402,347,424,
 419,484,283,186,193,291,304,212,292,202,200,238,254,299,
 278,588,551,556,592,526,469,580,589,585,524,508,474,562,
 449,571,568,613,593,454,431,486,692,672,1211,1270,964,
 1093,1114,1391,958,1044,1983,951,1089,1142,1034,1299,910,
 986,2089,999,917,1103,1894,1648,1435,2046,1624,1440,2188,
 1259,2191,1389,2186,2315,3495,2233,4014,8627,7444,2922,2634,
 3606,4339,3140,3043,3378,2727,2918,3536,3098,3295,3026,8255,
 3832,4832,3817,7702,3887,4248,4164,6813,7440,6979,6555,7831,
 6782,4242,4430,6180,6400,4458,4452,6811,6709],
 [24,39,20,27,42,35,38,34,30,67,100,59,71,64,101,72,70,49,
 57,471,282,370,475,402,352,520,366,411,472,259,264,212,
 276,217,281,209,588,464,495,397,530,453,564,609,580,589,
 572,511,503,412,508,447,527,448,534,417,552,600,454,486,
 468,480,635,628,2209,1330,1271,2451,2250,1012,1281,2438,
 1566,2406,3273,1050,1055,1011,1064,933,881,1983,1419,1208,
 1078,1137,1108,951,1024,1026,1130,967,1124,984,1027,999,
 1218,1057,917,911,6063,1821,1599,1623,1749,3312,1600,1477,
 2471,4933,1568,1481,1750,1466,1508,1633,2760,1462,1593,1489,
 2490,1638,1673,2983,1494,1370,2304,1497,3388,4218,4071,3790,
 4013,3772,5730,5717,5392,5632,2880,2759,5656,2846,2617,8242,
 3122,3045,5092,3063,3152,2506,2484,5129,2838,2817,5411,2743,
 2836,5120,3106,2728,2555,2578,4838,8534,8404,5198,6376,4311,
 8203,8164,5609,6552,7525,7143,5287,6240,7533,7472,6283,6690,
 8142,7047,7975,8663,8021,7564,6458,6629,6748,7912,6507],
 [24,41,35,40,13,67,50,61,82,105,66,77,71,102,63,84,96,91,
 93,52,57,372,432,475,429,542,419,342,193,234,227,230,310,
 293,318,276,200,253,250,246,281,330,358,323,187,278,578,
 430,451,501,594,416,513,574,583,427,508,579,426,413,487,
 586,452,517,459,552,601,595,576,644,764,737,1107,703,1023,
 665,728,755,1075,1265,725,628,932,1033,8559,840,8431,8633,
 1177,1188,907,1146,1044,1262,981,1076,1162,1280,1121,1356,
 1241,1383,946,1161,986,1169,931,1058,1116,1201,1360,1036,
 1275,1929,2285,1978,2159,2532,1692,1713,2500,1578,1586,1626,
 1719,2341,1632,1485,2735,1675,1735,1587,1543,2324,2546,2312,
 2309,2539,2417,2261,2268,2237,2749,5891,2695,3907,2661,5750,
 2861,4741,2635,5018,2614,4007,9087,9257,6952,8270,6343,6124,
 5583,5579,5909,4924,5809,5299],
 [24,41,35,40,34,13,25,51,67,50,82,100,79,94,105,69,92,88,
 71,83,64,74,102,73,107,63,84,78,96,60,75,65,87,106,93,
 99,98,62,49,52,342,315,259,291,304,351,322,320,206,221,
 388,383,238,254,328,319,303,330,348,358,239,220,1062,950,
 1449,1040,892,1421,725,2459,2347],
 [24,41,40,13,67,50,61,82,79,94,66,76,77,71,74,101,107,54,
 78,96,91,99,471,372,475,429,355,423,419,342,259,247,310,
 216,203,292,435,386,388,287,217,245,228,235,335,343,594,
 416,513,427,508,612,579,413,487,586,459,552,396,499,566,
 576,815,824,722,746,635,662,1246,1347,802,715,874,799,645,
 1151,1308,2628,1442,2835,839,1350,2762,789,899,1183,1044,
 1262,981,1076,902,1096,1137,1121,1356,946,1161,986,1169,
 928,1213,1060,1090,1036,1275,2870,2572,2084,2314,2659,2959,
 2714,1969,2229,1409,1798,2780,2265,1394,1622,2580,2361,1418,
 1720,2412,2222,4214,2637,2928,3182,2312,2840,3329,4153,2425,
 3255,3170,2686,2309,3087,3228,3614,2516,3060,3373,2802,3212,
 3248,2721,2275,7997,2210,8166,2211,8048,8380,6981,3374,3563,
 4101,3233,3070,3043,2744,5274,3653,3409,3623,3728,6248,3026,
 2696,9389,8816,8804,6206,7009,9037,8565,7469,7654,7650,8336,
 8481,9208,6096,7344,8984,6474,6273,8499,6243,7894,7263,6384,
 6469,7485,8039,7521,6861,6721,6644],
 [26,14,20,28,38,18,15,51,50,61,97,82,100,79,94,69,85,92,
 88,89,66,76,95,53,55,104,83,64,108,101,73,63,84,103,56,
 72,54,78,60,75,65,87,90,91,86,106,80,81,98,62,49,68,57 
  ],[26,14,20,32,18,51,50,61,97,82,100,79,94,69,85,92,
 88,89,76,59,95,77,53,55,104,83,64,108,74,101,73,63,84,
 103,56,72,54,78,60,75,65,87,90,86,70,106,93,80,81,98,
 62,49,68,52,57],
 [26,14,22,24,33,17,39,37,27,36,31,42,41,35,28,38,40,34,
 23,30,21,13,25,51,61,105,66,95,71,74,73,84,96,91,106,
 99,52],
 [26,14,22,24,33,37,27,42,41,35,28,38,40,23,21,25,51,100,
 79,85,92,95,73,72,54,75,65,106,384,481,370,541,352,521,
 346,313,433,249,472,229,260,565,570,536,554,574,609,602,
 611,557,512,563,600,621,566,1129,1327,996,1157,1341,1446,
 1588,1406,1679,1678,1513,2009,2106,1641,1961,2116,1551,1866,
 1844,3027,3091,3306,3711],
 [26,14,22,24,33,37,27,42,41,35,28,38,40,23,21,25,51,100,
 79,95,83,73,72,54,106,62,384,481,370,541,352,521,346,
 313,433,249,472,259,240,217,207,565,570,536,609,602,412,
 611,488,413,557,512,600,621,454,1129,1327,996,1157,1341,
 1305,1285,1391,1182,1255,1299,1678,1480,1578,2009,2106,1307,
 1641,1961,2116,1431,1587,1866,1844,3159,3066,4109,2538,2976,
 4464,4628,3306,3711,5586,8259,8666],
 [26,14,22,24,33,37,27,42,41,35,28,38,40,23,21,25,61,105,
 71,55,108,74,84,96,99,81,68,52,471,372,339,443,333,520,
 355,542,374,484,385,206,239,515,451,397,622,560,479,612,
 488,413,603,569,442,566,851,1350,916,1372,909,1290,1175,
 1369,1300,2532,1503,1359,1902,1387,2341,1529,1382,1715,2465,
 2477,3096,2553,3048,3192,4397,6536,4417,6562,8951,7177],
 [26,14,22,24,33,39,37,20,27,36,42,41,35,28,38,40,18,34,
 23,21,13,15,25,51,61,100,92,66,95,83,73,84,72,65,91,
 106,62],
 [26,14,22,29,24,33,20,27,36,42,41,32,28,38,40,18,34,23,
 21,13,15,25,51,100,79,94,76,95,83,72,54,78,65,86,106,
 62,240,248,207,226],
 [26,14,22,29,24,33,20,27,36,42,41,32,28,38,40,18,34,23,
 21,13,15,25,51,100,79,94,92,83,73,72,54,78,65,86,106,
 62,298,351,213,328],
 [26,14,22,29,24,33,20,27,36,42,41,32,28,38,40,18,34,23,
 21,13,15,25,471,372,339,316,492,375,443,475,347,395,345,
 520,332,424,355,542,423,387,377,484,327,385,283,851,839,
 789],
 [26,14,22,29,24,33,20,27,42,41,32,35,28,38,40,18,34,23,
 21,13,15,25,51,100,79,94,85,92,73,72,54,78,75,65,106,
 62,351,229,328,260],
 [26,14,22,29,24,33,20,27,42,41,32,35,28,38,40,18,34,23,
 21,13,15,25,51,100,79,94,95,83,73,72,54,78,75,65,106,
 62,259,240,217,207],
 [26,14,22,29,24,33,20,27,42,41,32,35,28,38,40,18,34,23,
 21,13,15,25,471,372,339,316,326,492,443,475,333,520,424,
 355,542,423,387,377,374,484,385,283,851,1442,970,1371,
 1350,916,1331,789,1372,909,1314,2577,2465,2477],
 [26,14,22,29,24,33,37,20,27,42,32,35,28,38,40,18,34,23,
 21,13,15,25,471,372,339,326,492,381,443,475,333,520,366,
 424,355,542,423,387,374,484,368,385,283,851,1442,970,1350,
 916,789,1372,909,2577,2465,2477],
 [26,14,22,29,24,33,37,20,27,42,41,32,35,28,38,40,18,34,
 23,21,13,15,25,51,100,79,85,92,95,73,72,54,75,65,106,
 62,229,260],
 [26,14,22,29,24,33,37,20,27,42,41,32,35,28,38,40,18,34,
 23,21,13,15,25,51,100,79,95,83,73,72,54,75,65,106,62,
 259,240,217,207],
 [26,14,22,29,24,33,37,20,27,42,41,32,35,28,38,40,18,34,
 23,21,13,15,25,471,372,339,326,492,443,475,333,520,424,
 355,542,423,387,374,484,385,283,851,1442,970,1350,916,789,
 1372,909,2577,2465,2477],
 [26,14,22,29,24,33,37,20,27,42,41,32,38,40,23,21,13,15,
 25,51,100,79,85,92,76,59,95,71,55,73,75,65,86,70,106,
 99,81,62,229,309,293,260,348,358],
 [26,14,22,29,24,33,37,20,27,42,41,32,38,40,23,21,13,15,
 25,471,372,339,326,492,375,421,443,422,407,475,333,520,
 332,428,424,346,313,542,374,484,327,393,385,371,354,283,
 851,1442,970,1211,1033,1339,1350,916,1270,840,1297,1372,
 909,1329,964,1288,2577,5903,2465,5802,2477,5185],
 [26,14,22,29,24,33,37,20,27,42,41,35,28,38,40,18,34,23,
 21,13,15,25,471,372,339,326,492,481,443,475,333,520,521,
 355,542,423,387,374,484,491,385,283,851,1442,970,1483,
 1350,916,1520,789,1372,909,1537,2577,2465,2477],
 [26,14,22,29,24,33,37,20,42,41,32,35,28,38,40,18,34,23,
 21,13,15,25,471,372,339,394,326,492,443,475,333,520,424,
 355,542,423,387,419,374,484,385,283,851,1442,970,1752,
 1350,916,1770,789,1372,909,1755,2577,2465,2477],
 [26,14,22,29,24,33,37,27,42,41,32,35,28,38,40,18,34,23,
 21,13,15,25,471,372,339,384,326,492,443,333,520,424,355,
 542,423,387,444,374,484,385,283,851,2145,1442,970,1540,
 1350,916,1519,789,2127,1372,909,1498,2577,9098,2465,7691,
 2477,7320],
 [26,14,22,29,24,33,39,20,27,36,42,41,32,28,38,40,18,34,
 23,21,13,15,25,51,100,94,92,76,95,83,72,78,65,86,106,
 62,248,226],
 [26,14,22,29,24,33,39,20,27,36,42,41,32,28,38,40,18,34,
 23,21,13,15,25,51,100,94,92,83,73,72,78,65,86,106,62,
 298,351,213,328],
 [26,14,22,29,24,33,39,20,27,36,42,41,32,28,38,40,18,34,
 23,21,13,15,25,471,372,316,492,375,443,432,475,347,345,
 520,332,424,355,542,423,377,484,327,385,283],
 [26,14,22,29,24,33,39,20,27,41,32,28,38,40,18,34,23,21,
 13,15,25,51,100,94,85,92,88,76,95,72,78,75,65,87,86,
 106,62,229,248,260,226],
 [26,14,22,29,24,33,39,20,27,41,32,28,38,40,18,34,23,21,
 13,15,25,51,100,94,92,73,72,78,75,65,87,86,106,62,259,
 272,298,351,217,269,213,328,260,935,843],
 [26,14,22,29,24,33,39,20,27,41,32,28,38,40,18,34,23,21,
 13,15,25,471,372,316,326,492,369,375,443,432,475,333,367,
 332,424,355,542,423,377,374,484,380,327,385,283,1442,1371,
 1800,1350,1331,1759,1372,1314,1767],
 [26,14,22,29,24,33,39,20,36,42,32,28,38,40,18,34,23,21,
 13,15,25,51,100,94,69,92,83,72,78,60,65,90,86,106,62,
 307,298,351,267,213,328,226,739,724],
 [26,14,22,29,24,33,39,20,36,42,32,28,38,40,18,34,23,21,
 13,15,25,471,372,316,394,492,381,375,443,432,475,347,345,
 429,520,366,332,424,355,542,423,377,419,484,368,327,385,
 283],
 [26,14,22,29,24,33,39,27,36,42,41,32,28,38,40,18,34,23,
 21,13,15,25,471,372,316,384,492,375,443,432,347,345,425,
 520,332,424,355,542,423,377,444,484,327,385,283,2145,2197,
 2127],
 [26,14,22,29,24,33,39,37,20,27,36,32,35,38,40,18,34,23,
 21,13,15,25,51,100,92,88,89,59,95,73,72,65,87,90,70,
 106,62,229,260],
 [26,14,22,29,24,33,39,37,20,27,36,32,35,38,40,18,34,23,
 21,13,15,25,51,100,92,88,89,59,95,83,65,87,90,70,106,
 62,248,309,226,348],
 [26,14,22,29,24,33,39,37,20,27,36,41,32,35,38,40,18,21,
 13,51,100,92,88,59,95,55,104,74,101,73,72,70,106,81,98,
 52,57,229,243,266,382,290,306,314,714,721],
 [26,14,22,29,24,33,39,37,20,27,36,41,32,35,38,40,18,34,
 23,21,13,15,25,51,100,92,88,59,95,73,72,65,87,70,106,
 62,229,260],
 [26,14,22,29,24,33,39,37,20,27,36,41,32,35,38,40,18,34,
 23,21,13,15,25,51,100,92,88,59,95,83,73,65,87,70,106,
 62,309,348],
 [26,14,22,29,24,33,39,37,20,27,36,42,32,28,38,40,18,34,
 23,21,15,471,372,492,381,375,443,432,370,360,475,347,520,
 366,332,424,355,362,363,542,423,484,368,327,385,283,249,
 236],
 [26,14,22,29,24,33,39,37,20,27,36,42,32,35,28,38,40,18,
 34,23,13,15,471,372,492,381,443,432,410,360,475,347,520,
 366,424,355,399,363,542,423,484,283,341,236,1797,2436,
 1564,2517,1612,2595],
 [26,14,22,29,24,33,39,37,20,27,36,42,32,35,28,38,40,18,
 34,23,21,13,15,51,100,92,89,95,83,101,72,65,90,106,62,
 57,248,226],
 [26,14,22,29,24,33,39,37,20,27,36,42,32,35,28,38,40,18,
 34,23,21,13,15,471,372,492,381,443,432,360,475,347,520,
 366,424,355,363,542,423,484,368,385,283,236],
 [26,14,22,29,24,33,39,37,20,27,36,42,32,35,28,40,18,34,
 21,13,15,51,100,92,89,95,77,104,83,101,72,65,93,98,62,
 57,248,270,288,273,301,847,882],
 [26,14,22,29,24,33,39,37,20,27,36,42,32,35,28,40,18,34,
 21,13,15,471,372,492,381,443,376,408,432,360,475,347,520,
 366,424,344,337,355,363,423,368,385,317,286,283,236,1558,
 2451,1266,2438,1286,2406],
 [26,14,22,29,24,33,39,37,20,27,41,32,35,40,18,34,23,21,
 13,15,25,51,100,85,92,88,59,95,77,73,75,65,87,70,106,
 93,62,229,309,260,348],
 [26,14,22,29,24,33,39,37,20,27,42,32,35,28,38,40,18,34,
 23,21,13,15,471,372,326,492,381,443,432,360,475,333,520,
 366,424,355,363,542,423,374,484,368,385,283,236,1442,1350,
 1372],
 [26,14,22,29,24,33,39,37,27,36,32,35,28,38,40,18,34,23,
 21,13,15,51,100,105,92,88,89,95,83,101,72,96,65,87,90,
 106,62,57,248,226],
 [26,14,22,29,24,33,39,37,27,36,32,35,28,38,40,18,34,23,
 21,13,15,471,372,384,492,369,381,443,432,360,347,425,367,
 366,424,355,363,542,423,444,484,380,368,385,283,236,2145,
 1800,2197,1759,2127,1767],
 [26,14,22,29,24,33,39,37,27,36,42,41,32,35,28,38,40,18,
 34,23,21,13,25,51,100,105,92,95,83,74,73,72,96,65,106,
 62,52],
 [26,14,22,29,24,37,20,27,41,32,35,28,38,40,18,34,23,21,
 13,15,25,51,82,100,79,95,73,56,72,54,75,65,87,106,62,
 259,240,272,217,207,269,260,935,843],
 [26,14,22,29,24,39,20,27,36,42,41,32,28,38,40,18,34,23,
 21,13,15,25,471,353,372,316,492,432,475,312,347,345,520,
 332,424,355,542,405,423,377,484,327,385,283,971,1490,827,
 992,998,1069],
 [26,14,22,29,33,20,42,32,38,40,18,23,21,51,100,79,92,59,
 74,54,65,90,70,106,52,289,316,394,326,375,407,370,336,
 345,333,332,313,362,409,377,419,374,327,354,249,309,226,
 348,500,530,592,624,574,598,489,508,612,625,571,581,514,
 552,601,638,566,587,1752,1770,1755,1111,1137,1116],
 [26,14,22,29,33,20,42,32,38,40,18,23,21,97,79,94,69,76,
 59,74,54,86,70,81,52,471,372,326,492,381,443,370,475,
 333,520,366,424,362,542,423,374,484,368,385,249,331,255,
 305,592,624,567,547,574,598,612,625,528,538,571,581,601,
 638,555,539,566,587,1442,1350,1372,981,946,1060],
 [26,14,22,29,33,37,20,42,41,32,38,40,23,21,13,15,51,83,
 72,54,106,289,394,375,421,422,407,336,332,428,346,313,
 409,327,393,371,354,236,217,207,551,467,530,622,461,416,
 560,479,607,488,413,581,546,510,613,498,396,566,758,1726,
 740,1658,841,1748,1093,899,1077,902,1034,1716,1319,928,
 2082,1837,1283,1422,2576,1831,1226,1413,2244,1715,1259,1428,
 2573,2662,4095,3211,2622,4091,3139,2772,4779,3289,8651,7149,
 7830],
 [26,14,22,29,33,37,20,42,41,32,38,40,23,21,13,15,51,100,
 79,85,92,95,73,75,65,106,62,289,394,375,421,422,407,336,
 332,428,346,313,409,327,393,371,354,236,229,260,624,558,
 469,458,562,449,478,569,442,758,1726,740,1658,841,1748,
 2317,2429,2505],
 [26,14,22,29,33,37,20,42,41,32,38,40,23,21,13,15,97,69,
 76,59,71,55,103,86,70,99,81,57,471,372,339,326,492,443,
 475,333,520,424,542,374,484,385,283,255,305,624,574,560,
 479,625,601,638,569,442,851,1442,970,1350,916,1372,909,
 1902,1715,2577,2465,2477],
 [26,14,22,29,33,37,36,42,41,32,28,40,18,23,21,13,51,100,
 105,92,95,83,74,73,72,96,65,106,62,52,289,339,394,375,
 376,407,429,332,344,313,363,419,327,317,354,567,469,625,
 550,510,587,837,834,1339,811,1297,968,1288,2317,2244,2238,
 2246,2165],
 [26,14,22,29,33,39,37,20,27,36,42,41,32,35,28,38,40,18,
 34,21,15,25,471,289,372,492,443,408,432,370,475,336,347,
 520,424,337,355,362,542,409,423,385,286,283,249,2451,2438,
 2406],
 [26,14,22,29,33,39,37,20,27,36,42,41,32,35,28,38,40,18,
 34,23,15,25,471,289,372,492,443,432,410,370,475,336,347,
 520,424,355,399,362,542,409,423,484,283,341,249,2436,2517,
 2595],
 [26,14,22,29,33,39,37,20,27,36,42,41,32,35,28,38,40,18,
 34,23,21,15,25,471,289,372,492,443,432,370,475,336,347,
 520,424,355,362,542,409,423,484,385,283,249],
 [26,14,22,29,39,20,36,42,41,28,38,40,15,82,69,66,55,64,
 56,49,68,57,471,372,316,492,422,408,432,475,347,345,520,
 346,337,355,542,371,286,283,302,482,496,530,606,624,453,
 493,564,522,545,485,508,618,625,448,525,534,512,550,454,
 516,486,463,1033,985,2451,840,978,2438,964,1451,2406,1114,
 1052,1173,1257,1126,1034,1154,1170,2450,1422,2225,2010,2350,
 1413,2301,2035,2307,1428,2015,2187,2710,2706,2633],
 [26,14,22,33,17,39,37,36,31,41,28,38,40,23,30,13,51,61,
 105,66,95,71,74,73,84,96,91,106,99,52,289,394,369,407,
 410,360,429,367,399,363,409,327,496,567,522,466,506,579,
 625,525,550,523,456,499,576,587,1407,1327,1496,1427,2287,
 2358,2307,2090],
 [26,14,22,33,39,37,20,27,36,42,41,32,35,28,38,40,18,34,
 23,21,15,25,471,282,289,372,443,432,370,475,352,336,347,
 520,424,355,362,542,433,409,423,484,385,283,249,2209,2250,
 2272],
 [26,14,22,33,39,37,20,36,41,28,38,40,18,23,13,15,51,61,
 100,92,66,95,83,73,84,72,65,91,106,62,289,394,369,407,
 410,360,336,429,367,399,363,409,419,380,327,341,236,496,
 522,525,523,1407,1327,1496,1427,1504,1341],
 [26,14,24,17,39,27,36,31,42,35,28,38,34,30,21,25,51,61,
 105,66,95,71,74,73,84,96,91,106,99,52,340,353,316,370,
 312,345,366,362,411,338,286,500,596,509,549,511,503,618,
 505,584,470,568,535,539,615,1293,976,1276,813,1612,1583,
 1750,1466,1580,1848,1647,2313,2300,4311,5258],
 [26,14,24,33,17,20,27,36,31,42,32,35,28,19,38,18,34,23,
 30,21,15,25,471,340,282,339,316,389,475,402,352,395,345,
 366,392,362,542,411,433,387,377,368,338,249,1330,818,1012,
 831,1172,934],
 [26,14,24,33,17,39,20,27,36,31,42,32,35,28,19,38,18,23,
 30,21,15,25,471,340,282,316,389,407,370,475,402,352,345,
 366,392,313,362,542,411,433,377,368,338,354,249,1330,1012,
 1172],
 [26,14,24,33,17,39,27,36,31,42,35,19,38,23,30,25,51,50,
 94,89,53,55,108,73,63,78,68,481,421,422,352,425,346,399,
 476,491,393,341,472,270,565,490,594,614,453,477,572,533,
 561,611,507,483,512,586,590,468,553,463,948,1335,1290,
 1031,1087,952,1405,1168,1905,1641,2194,1802,2618,2698,4135,
 3488,2890,2626,4356,4378,2609,2688,9309,5894,6891,4980],
 [26,14,24,33,20,27,36,32,35,38,18,34,23,21,15,25,51,92,
 88,83,70,106,340,282,339,316,389,402,352,395,345,392,411,
 433,387,377,368,338,249,348,551,455,530,416,513,518,560,
 427,508,413,487,546,459,552,600,613,396,499,566,1330,818,
 1012,831,1172,934,1555,1245,1454,1526,1679,2276,2200,2171,
 1110,2552,2046,1956,1117,2433,2052,2100,1185,6075,5549,5923,
 4782,5907,5004],
 [26,14,24,33,20,27,36,32,35,38,18,34,23,21,15,25,51,100,
 59,95,73,72,65,87,70,106,62,340,282,339,316,389,402,352,
 395,345,392,411,433,387,377,368,338,249,260,451,501,609,
 450,506,452,517,514,600,1330,818,1012,831,1172,934,1056,
 1239,1083,1194,1184,1242],
 [26,14,24,33,39,37,20,36,42,41,32,35,28,38,40,18,34,23,
 21,13,15,25,471,340,282,372,443,432,475,402,352,347,429,
 520,424,355,542,411,433,423,419,484,385,283,2628,2209,
 2835,2250,2762,2272],
 [26,14,24,33,39,37,36,42,41,35,38,40,34,23,13,25,51,50,
 69,92,95,83,73,63,60,65,106,62,481,421,410,541,521,428,
 346,433,444,371,341,472,208,277,565,490,604,558,554,583,
 602,412,427,611,562,507,573,563,595,621,454,431,1343,1454,
 1444,1348,1782,1791,4400,4345],
 [26,14,24,33,39,37,36,42,41,35,38,40,34,23,13,25,61,105,
 66,59,64,74,84,96,91,70,49,52,471,340,372,443,432,347,
 429,520,542,411,419,484,276,209,430,451,622,596,564,574,
 508,561,612,426,413,603,584,552,559,601,486,566,1343,1454,
 1444,1348,1790,1778,4449,4714],
 [26,14,24,39,20,27,36,42,35,28,38,18,34,21,15,25,51,61,
 100,92,66,95,83,73,84,72,65,91,106,62,340,353,316,370,
 402,312,345,366,362,411,405,377,338,286,249,500,509,549,
 505,470,568,1293,976,1276,813,1353,835,1612,1583,1580,2313,
 2300,2385],
 [26,14,28,38,18,15,51,50,61,97,100,105,69,85,88,89,66,95,
 55,108,73,84,103,56,72,54,78,96,60,75,65,87,90,86,80,
 98,62,49,68,57,186,193,234,359,320,229,244,230,215,202,
 200,253,207,213,295,303,260,214,246,239,301,187,700,630,
 866,942,737,705,636,812,884,755,723,2247,1988],
 [26,14,28,38,100,92,89,76,83,63,103,56,72,54,78,60,75,87,
 90,86,62,384,422,346,476,444,371,324,279,186,193,234,222,
 259,272,243,201,203,292,404,437,386,202,200,253,223,217,
 269,295,311,303,214,262,246,192,187,278,325,357,343,578,
 565,397,530,589,572,412,508,608,448,534,603,573,563,454,
 486,577,784,804,752,720,719,761,983,1084,901,765,810,694,
 710,709,747,920,1101,897,1271,1281,1111,1197,1305,1245,
 1072,1137,1108,1227,1240,1182,1116,1150,1218,1057,1384,1359,
 1452,1422,1398,1306,1425,1413,1465,1390,1337,1428,2346,2379,
 2330],
 [26,14,29,17,20,36,42,19,38,18,30,97,82,79,66,59,64,74,
 101,56,54,91,70,49,52,471,340,316,381,408,475,402,345,
 366,337,542,411,377,286,298,255,243,213,305,290,430,451,
 441,536,606,567,509,522,609,466,450,447,473,618,528,483,
 512,620,478,452,470,523,600,468,463,615,1797,1564,1612,
 1073,2113,1316,2267,1155,2583,1067,2005,1224,2403,1109,2458,
 1563,1474,1604],
 [26,14,29,17,36,42,19,38,18,23,82,79,69,92,66,76,59,64,
 74,56,54,60,65,91,86,70,49,52,471,340,316,384,381,432,
 345,425,366,355,542,411,377,444,368,283,230,302,386,246,
 321,343,482,441,536,606,509,522,609,447,473,618,483,512,
 620,550,470,523,600,468,463,615,2145,1436,2197,1450,2127,
 1315,1674,1721,1659],
 [26,14,29,24,33,17,39,20,27,36,31,42,32,35,28,19,18,23,
 30,21,15,25,471,340,316,381,376,389,407,370,475,402,345,
 366,344,392,313,362,377,368,317,338,354,249,1558,1660,
 1266,1818,1286,1605],
 [26,14,29,24,33,17,39,20,27,36,31,42,32,35,28,19,38,18,
 23,30,21,15,25,51,50,94,89,53,55,108,73,63,78,80,81,
 68,270,273],
 [26,14,29,24,33,17,39,20,27,36,31,42,32,35,28,19,38,18,
 23,30,21,15,25,471,340,316,381,389,407,370,475,402,345,
 366,392,313,362,542,411,377,368,338,354,249],
 [26,14,29,24,33,17,39,20,27,36,31,42,32,35,28,19,38,23,
 30,21,15,25,51,50,94,89,53,71,55,108,73,63,78,80,99,
 81,68,270,273],
 [26,14,29,24,33,17,39,20,27,36,31,42,32,35,28,19,38,23,
 30,21,15,25,471,340,316,381,389,422,407,370,475,402,345,
 366,392,346,313,362,542,411,368,338,371,354,249,985,978,
 1451],
 [26,14,29,24,33,39,37,20,36,42,41,32,35,28,38,40,18,34,
 23,21,13,15,25,51,50,69,92,95,83,73,63,72,60,65,106,
 62,208,277],
 [26,14,29,24,33,39,37,20,36,42,41,32,35,28,38,40,18,34,
 23,21,13,15,25,51,50,100,69,92,83,73,63,72,60,65,106,
 62,351,328],
 [26,14,29,24,33,39,37,20,36,42,41,32,35,28,38,40,18,34,
 23,21,13,15,25,471,340,372,394,492,443,432,475,402,347,
 429,520,424,355,542,411,423,419,484,385,283],
 [26,14,29,24,33,39,37,36,42,41,32,35,28,38,40,18,34,23,
 21,13,15,25,471,340,372,384,394,492,443,432,347,425,429,
 520,424,355,542,411,423,444,419,484,385,283,2145,1436,
 2197,1450,2127,1315],
 [26,14,29,24,37,20,36,42,41,32,35,28,38,40,18,34,23,21,
 13,15,25,471,340,353,372,339,394,492,475,402,312,347,395,
 429,520,424,355,542,411,405,423,387,419,484,385,283,1490,
 851,992,839,1069,789],
 [26,14,29,33,17,39,20,27,36,31,42,32,35,28,38,18,23,30,
 21,15,25,51,50,97,89,95,53,55,108,73,63,103,78,106,80,
 81,68,234,270,253,273],
 [26,14,29,33,17,39,20,27,36,31,42,32,35,28,38,18,23,30,
 21,15,25,51,97,94,89,95,53,55,108,63,90,106,80,81,68,
 324,248,302,318,226,321,323,983,920],
 [26,14,29,33,17,39,20,36,42,32,28,19,38,18,23,30,21,15,
 471,340,289,316,394,492,381,375,389,407,370,360,475,402,
 336,345,429,520,366,332,392,313,362,363,542,411,409,377,
 419,484,368,327,338,354,249,236],
 [26,14,29,33,20,27,36,32,38,18,34,23,21,50,79,59,53,74,
 54,78,90,86,70,80,52,471,289,372,492,369,443,360,475,
 336,347,367,424,363,542,409,423,484,380,385,236,307,298,
 267,213,245,495,592,606,574,609,503,612,618,571,620,532,
 601,600,566,615,824,802,1800,1759,1767],
 [26,14,29,33,20,32,28,38,18,23,21,15,51,50,100,79,94,69,
 85,92,88,89,53,55,83,63,103,72,54,78,75,65,87,90,86,
 106,80,62,68,57,279,298,351,280,230,248,203,213,328,262,
 246,226,305,187,1334,1084,1198,1101],
 [26,14,29,33,39,20,32,28,38,18,23,21,15,51,50,85,92,88,
 89,53,55,63,103,72,78,75,87,90,86,106,80,68,57,279,208,
 234,222,229,280,230,248,255,243,294,277,253,223,213,328,
 260,262,246,226,305,290,187,314,630,819,737,915,636,863,
 755,801],
 [26,14,29,33,39,20,32,38,18,23,21,15,51,97,100,94,69,85,
 92,88,76,59,95,53,55,73,63,103,60,75,65,87,90,86,70,
 106,81,62,68,57,324,307,229,280,230,309,318,406,260,262,
 246,348,323,192,716,859,745,883],
 [26,14,29,33,39,20,36,42,18,23,21,15,51,50,97,94,69,92,
 89,66,76,59,77,53,55,83,108,101,103,78,90,91,86,70,106,
 93,80,81,68,57,208,351,248,215,309,255,243,382,277,226,
 245,348,305,290,314,1063,1289],
 [26,14,29,33,39,20,36,42,18,23,21,15,51,50,97,94,69,92,
 89,66,76,59,77,53,55,83,108,101,103,78,90,91,86,70,106,
 93,80,81,68,57,208,351,248,215,309,255,243,382,328,226,
 245,348,305,290,314,670,669],
 [26,14,29,33,39,20,36,42,32,15,51,50,97,100,69,92,89,76,
 59,95,77,71,55,104,83,64,108,101,73,103,72,60,70,106,
 93,99,81,98,49,57,234,359,215,318,243,270,216,201,382,
 437,253,295,323,290,273,258,192,314,357,712,723],
 [26,14,29,33,39,20,36,42,32,28,18,21,15,51,50,100,94,69,
 92,89,95,77,53,55,104,83,108,73,63,103,72,78,90,86,106,
 93,98,62,68,57,279,298,230,255,243,201,203,294,213,305,
 290,192,187,674,693],
 [26,14,29,33,39,20,36,42,32,28,38,18,21,15,51,50,94,69,
 92,89,53,55,104,83,108,72,78,90,86,98,68,57,279,208,
 298,351,230,248,215,302,255,243,288,201,203,382,213,328,
 246,226,245,321,301,192,187,314,1084,670,807,901,1101,669,
 787,897],
 [26,14,29,33,39,20,36,42,32,28,38,18,23,21,15,51,50,97,
 94,69,92,76,53,55,83,108,101,63,103,72,78,60,90,86,106,
 80,81,68,208,307,351,243,382,386,277,267,328,226,290,314,
 343,739,724],
 [26,14,29,33,39,20,36,42,32,28,38,18,23,21,15,51,50,97,
 100,94,69,92,89,76,95,53,55,83,108,101,73,63,103,72,78,
 60,65,90,86,106,80,81,62,68,57],
 [26,14,29,33,39,20,36,42,32,28,38,18,23,21,15,51,50,97,
 100,94,92,89,76,95,53,83,108,101,73,63,72,60,65,90,106,
 80,81,68,222,331,302,318,216,382,386,223,321,323,258,314,
 343,1042,1054],
 [26,14,29,33,39,20,36,42,32,28,38,18,23,21,15,51,50,100,
 69,92,89,95,53,55,108,73,63,103,72,78,65,90,86,106,80,
 62,68,57,279,234,298,229,230,255,294,253,213,260,246,305,
 187,737,755],
 [26,14,29,33,39,20,36,42,32,28,38,18,23,21,15,51,97,100,
 94,69,92,76,53,55,83,101,73,63,72,60,65,90,86,106,81,
 62,68,57,324,307,351,280,201,406,267,328,262,321,323,192,
 814,925,757,822],
 [26,14,29,33,39,20,36,42,41,32,35,28,38,40,18,34,23,21,
 13,15,25,51,50,97,94,69,92,83,73,63,103,72,78,60,65,
 106,62,208,351,277,328],
 [26,14,29,33,39,20,36,42,41,32,35,28,38,40,18,34,23,21,
 13,15,25,471,340,289,372,316,394,492,443,432,475,402,336,
 347,345,429,520,424,355,542,411,409,423,377,419,484,385,
 283],
 [26,14,29,33,39,32,28,38,18,23,21,15,51,50,97,100,105,69,
 85,92,88,89,76,95,83,101,103,72,78,96,60,75,65,87,86,
 106,80,81,62,57,234,359,331,280,248,215,437,253,295,311,
 262,226,245,273,357,794,776],
 [26,14,29,33,39,37,20,27,36,42,41,32,35,28,38,40,18,34,
 23,21,15,471,340,289,372,492,443,432,370,360,475,402,336,
 347,520,424,355,362,363,542,411,409,423,484,385,283,249,
 236],
 [26,14,29,33,42,32,28,38,18,23,21,15,51,97,100,79,94,105,
 69,85,92,95,55,101,73,63,103,72,54,96,60,75,65,90,86,
 106,81,62,68,57,324,307,298,359,229,280,318,406,267,213,
 295,260,262,323,192,716,745],
 [26,14,29,36,42,32,28,38,18,23,21,15,51,50,97,82,100,79,
 94,105,89,95,83,108,101,73,63,56,72,54,78,96,60,65,90,
 106,80,81,62,68,222,240,298,359,331,302,386,223,207,213,
 295,311,321,258,343,726,702],
 [26,14,29,39,20,27,36,42,35,28,38,34,23,15,97,82,94,66,
 53,64,56,49,68,471,372,492,422,432,360,475,347,520,346,
 355,363,542,484,371,283,236,215,575,500,530,606,518,453,
 564,509,585,489,508,618,505,448,534,483,584,600,502,454,
 486,468,1033,840,964,1091,1011,1059,1052,881,1156,1024,
 1094,1126,967,1005,1154,911,1110,1422,1117,1413,1185,1428,
 4207,3622,3582,3570,3542,3612],
 [26,14,33,20,36,32,38,18,21,51,50,61,97,69,92,88,89,53,
 55,104,83,108,63,84,103,54,78,60,90,86,80,81,98,52,57,
 208,193,234,227,230,248,243,266,221,288,382,277,200,253,
 213,254,328,226,290,306,220,301,357,630,793,819,772,727,
 674,685,636,816,863,892,736,693,699,1524,2865,3716,2654,
 2715,2669,4107,3519],
 [26,14,33,20,36,32,38,18,21,51,50,61,97,69,92,88,89,59,
 95,53,55,104,83,108,73,63,84,103,60,65,87,90,86,81,98,
 52,57,208,193,234,227,230,309,293,318,221,288,201,277,
 200,253,250,246,220,301,192,314,357,630,915,772,912,685,
 762,873,636,801,751,699,785,798,2031,2177],
 [26,14,33,20,36,32,38,18,21,51,97,100,69,92,88,59,95,53,
 55,104,83,73,63,84,103,60,65,87,90,86,81,98,62,52,57,
 324,315,307,280,227,230,309,293,318,221,288,201,406,383,
 200,253,262,250,246,220,301,192,357,788,877,772,859,912,
 685,762,873,963,938,636,751,699,785,798,2288,2602,2031,
 2365,2397,2177],
 [26,14,33,36,38,21,51,50,61,97,100,79,94,105,69,92,88,89,
 66,76,59,95,53,71,55,104,83,108,74,101,73,63,84,103,72,
 54,78,96,60,65,87,90,91,86,70,106,80,99,81,98,62,68,
 52,57],
 [26,14,33,36,38,21,100,79,94,69,89,59,95,55,104,108,73,
 103,54,78,65,87,90,86,70,106,80,81,98,481,444,491,371,
 334,279,240,272,298,359,309,255,437,436,294,207,269,213,
 295,348,305,357,575,565,490,570,592,614,624,596,604,574,
 602,598,585,572,612,608,625,582,611,507,557,571,590,581,
 584,573,601,621,638,593,591,566,577,587,1540,1762,1388,
 1519,1766,1364,1498,1803,1453],
 [26,14,33,38,21,51,50,61,97,100,105,69,85,92,88,89,66,59,
 95,71,55,104,108,103,54,78,60,75,65,87,91,86,80,81,98,
 62,52,57,193,234,359,229,227,230,248,215,261,309,329,270,
 221,288,276,213,260,250,246,226,245,228,220,301,209,357,
 630,772,742,879,1400,685,864,919,751,718,890,699,829,872,
 2206,4656,2296,4679],
 [26,14,33,39,20,36,31,28,19,21,15,88,55,101,84,60,98,57,
 471,340,316,481,376,389,422,432,370,475,402,345,521,344,
 346,355,362,542,491,317,338,371,283,249,315,320,266,383,
 223,303,306,482,551,567,558,518,493,522,545,560,528,562,
 505,525,512,550,546,555,569,502,516,463,959,1048,913,1660,
 985,908,1818,978,966,1605,1451,1403,1699,1399,1392,1171,
 1250,1512,1722,1456,1415,1261,1295],
 [26,14,33,39,23,21,51,50,97,100,94,69,92,89,76,95,53,55,
 83,108,101,73,63,103,72,78,60,65,90,86,106,80,81,62,68,
 57,282,384,326,369,481,421,376,422,541,352,425,333,367,
 521,428,344,346,476,433,444,374,380,491,393,317,371,472],
 [26,14,33,39,28,23,21,51,50,61,97,100,105,69,85,92,88,89,
 66,76,95,77,71,55,73,84,103,72,65,106,93,80,99,81,52,
 57,234,359,229,280,227,230,215,318,329,255,212,266,270,
 206,216,253,323,349,305,299,306,273,239,258,314,357,915,
 772,1400,714,733,727,674,712,1424,721,760,736,693,723,
 2096,2654,1946,2669],
 [26,14,33,39,36,42,23,51,50,61,97,100,94,105,89,66,76,59,
 95,77,83,64,108,74,101,73,63,84,72,90,91,70,106,93,80,
 99,81,49,68,52,222,240,359,350,331,302,318,329,255,243,
 382,386,223,207,321,323,349,305,290,258,314,343,726,1400,
 893,1042,1424,947,1054,2384,2401],
 [26,14,33,39,36,42,38,23,51,50,61,97,100,69,92,89,66,76,
 59,95,83,64,108,74,101,103,78,96,60,65,86,106,62,57,
 234,300,350,248,215,261,309,201,276,203,404,437,435,287,
 295,308,311,228,325,335,784,804,794,879,919,704,1029,957,
 1023,1246,1505,765,810,776,812,979,890,792,932,1151,1379,
 2541,2566,2134,1989,2028,2476,2345,4115,2308,2460,2402,1988,
 2653,2269,2007,3689,3558,3527,7635,5590,3916,5186,3700,3360,
 5519,7439,3908,5714],
 [26,14,33,39,36,42,38,23,51,50,61,97,100,94,69,92,89,66,
 76,59,95,53,55,83,64,108,74,101,73,63,103,72,78,60,65,
 90,86,106,80,99,81,62,68,57,300,350,261,329,206,221,404,
 435,287,308,228,239,220,325,335,864,829],
 [26,14,33,39,36,42,38,23,51,50,61,97,100,94,69,92,89,66,
 76,59,95,53,55,83,64,108,74,101,73,63,103,72,78,96,60,
 65,90,86,106,80,81,62,68,57,300,350,261,206,221,276,404,
 435,287,308,228,239,220,325,335,1023,932],
 [26,14,33,39,36,42,38,23,51,50,61,97,100,94,105,69,92,89,
 66,76,59,95,53,71,55,83,64,108,74,101,73,63,84,103,72,
 78,96,60,65,90,91,86,70,106,80,99,81,62,49,68,52,57],
 [26,14,33,39,36,42,38,23,51,50,61,97,100,94,105,89,66,76,
 59,95,83,64,108,74,101,73,63,84,72,60,65,90,91,70,106,
 80,99,81,49,68,52,222,240,359,350,331,302,318,329,382,
 386,223,207,321,323,349,258,314,343,726,1400,893,1042,
 1424,947,1054,2384,2401],
 [26,14,33,39,36,42,38,23,51,50,61,97,100,105,69,92,89,66,
 76,59,95,71,83,64,108,74,101,103,78,60,65,91,86,70,106,
 99,62,49,52,57,234,359,331,248,215,261,309,329,270,201,
 203,437,226,245,228,348,349,273,192,187,357,879,1400,1042,
 890,1424,1054],
 [26,14,33,39,36,42,38,23,51,50,61,97,100,105,69,92,89,66,
 76,59,95,83,64,108,74,101,84,103,78,96,60,65,91,86,70,
 106,62,49,52,57,234,359,350,331,248,215,309,201,276,203,
 437,253,295,308,311,226,245,348,192,209,187,357,794,919,
 776,872],
 [26,14,33,39,36,42,38,23,51,50,97,94,69,92,89,76,53,55,
 83,108,101,103,72,78,90,86,80,81,68,57,282,384,481,421,
 422,410,541,352,425,521,428,399,476,444,371,341,472,208,
 351,248,215,255,243,382,277,226,245,305,290,314,564,543,
 572,534,559,591,486,1063,1289,2299,2807,2305,2736,2169,2656 
  ],[26,14,33,39,36,42,38,23,51,50,97,94,69,92,89,76,53,
 55,83,108,101,103,72,78,90,86,80,81,68,57,282,481,421,
 422,352,425,346,399,476,444,491,393,341,472,208,351,248,
 215,255,243,382,277,226,245,305,290,314,490,594,614,453,
 477,572,561,507,534,417,459,591,486,553,1063,1289,1262,
 1326,2503,1367,2703,4777,4293],
 [26,14,33,39,36,42,38,23,51,50,97,94,69,92,89,76,53,55,
 83,108,101,103,78,90,86,106,80,81,68,57,282,384,481,421,
 422,410,541,352,425,521,428,444,491,393,371,341,472,208,
 351,248,215,255,243,382,328,226,245,305,290,314,558,543,
 572,562,559,591,569,670,669,1302,2138,1438,2201,1439,2153],
 [26,14,33,39,36,42,38,23,51,50,97,94,69,92,89,76,53,55,
 83,108,101,103,78,90,86,106,80,81,68,57,282,481,421,422,
 352,425,346,399,476,444,491,393,341,472,208,351,248,215,
 255,243,382,328,226,245,305,290,314,490,594,614,558,453,
 477,572,561,586,590,417,459,591,569,553,670,669,1542,1190,
 1526,1274],
 [26,14,33,39,36,42,38,23,51,50,97,100,69,92,89,76,95,83,
 108,101,103,72,78,60,65,86,106,62,57,282,384,422,410,
 541,425,521,428,399,476,433,491,393,234,359,331,248,215,
 437,253,295,311,226,245,357,397,455,604,509,543,522,579,
 608,448,465,483,512,573,559,576,577,794,776,1129,1260,
 1338,1216,936,1095,1087,1264,860,1080,1728,2205,1641,1970,
 3000,3101,3304,3805],
 [26,14,33,39,36,42,38,23,51,50,97,100,69,92,89,76,95,83,
 108,101,103,72,78,60,65,86,106,62,57,282,384,481,421,
 422,410,541,425,346,399,476,433,444,371,341,472,234,359,
 331,248,215,437,253,295,311,226,245,357,604,453,477,509,
 522,483,512,573,417,459,468,463,794,776,2299,2807,2305,
 2736,2169,2656,1216,1087,1168],
 [26,14,33,39,36,42,38,23,51,50,97,100,94,69,92,89,76,95,
 53,55,83,108,101,73,63,103,72,78,60,65,90,86,106,80,81,
 62,68,57,282,384,481,421,422,410,541,352,425,521,428,346,
 399,476,433,444,491,393,371,341,472],
 [26,14,33,39,36,42,38,23,51,50,97,100,94,89,76,95,83,108,
 101,73,63,72,78,90,106,80,81,62,68,282,384,422,410,541,
 425,521,428,399,476,491,393,371,222,240,359,331,302,386,
 223,207,295,311,321,258,343,397,455,604,543,579,608,426,
 413,448,465,573,559,529,456,396,576,577,726,702,838,846,
 1114,1391,1338,1034,1299,1264,1733,1905],
 [26,14,33,39,36,42,38,23,51,50,97,100,94,89,76,95,83,108,
 101,73,63,72,78,90,106,80,81,62,68,282,384,481,421,410,
 541,425,521,428,346,399,476,444,491,393,371,341,472,222,
 240,359,331,302,386,223,207,295,311,321,258,343,570,604,
 458,416,426,413,557,573,456,396,726,702,791,838,846],
 [26,14,33,39,36,42,38,23,51,50,100,94,89,95,83,108,73,63,
 72,78,90,106,62,68,282,481,421,425,346,399,476,444,491,
 393,341,472,279,298,255,243,201,203,294,213,305,290,192,
 187,490,430,451,594,614,567,572,447,561,473,507,525,586,
 590,581,470,523,591,555,553,587,674,693,954,1282,1236,
 1102,907,1003,2113,988,902,1290,1031,1155,1100,946,2005,
 1046,965,1369,1138,1109,2148,1384,2217,1258,2144,1447,1626,
 2038,1441,1675,1888,3797,2277,3649,2372,8848,6755,2920,3221,
 2967,3619,3010,2881,3449,2953,3167,4715,3656,2675,3042,3877,
 4607,3873,8363,4158,4545,4060,7052,8733,7107,6823,8223,4620,
 4318,8963,7090,4909,4508,6570,7947,6208,6235],
 [26,14,33,39,36,42,51,50,97,100,94,69,92,89,76,95,53,55,
 83,108,101,73,63,103,72,78,60,65,90,86,106,80,81,62,68,
 57,282,384,481,421,376,422,408,410,541,352,425,521,428,
 344,346,337,399,476,433,444,491,393,317,371,286,341,472],
 [26,14,33,39,37,20,36,41,38,18,21,13,15,61,97,88,76,53,
 55,104,101,84,103,87,98,57,471,340,372,481,421,443,432,
 475,402,347,521,428,542,411,423,491,393,385,283,216,201,
 203,192,187,430,451,458,416,466,450,426,413,478,452,456,
 396,662,645,1483,1211,1520,1270,1537,1329],
 [26,14,33,39,42,28,23,21,51,50,61,97,100,94,69,92,89,66,
 76,95,53,55,83,108,74,101,73,63,103,72,78,60,65,90,86,
 106,93,80,99,81,62,68,57,300,259,322,350,261,206,435,
 287,217,319,308,228,349,299,239,335,1272,1112,1053,918],
 [26,14,33,39,42,28,23,21,51,50,61,97,100,94,69,92,89,66,
 76,95,53,55,83,108,101,73,63,103,72,78,96,60,75,65,90,
 86,106,93,80,99,81,62,68,57,300,259,322,350,261,206,435,
 287,217,319,308,250,228,239,335,876,853],
 [26,14,33,39,42,28,23,21,51,50,61,97,100,94,92,89,66,76,
 95,53,101,73,63,78,96,60,75,106,93,80,99,81,62,68,300,
 222,259,322,350,261,302,309,206,287,217,319,308,311,260,
 262,250,290,273,239,258,335,804,935,719,876,1710,794,726,
 974,695,685,810,843,709,853,1639,776,702,869,1346,941,753,
 699,1500,1974,2293,2750,1957,2252,2764,3268,2559,4591,8279,
 5405,6227],
 [26,14,33,39,42,28,23,21,51,50,61,97,100,94,105,69,85,92,
 89,66,76,95,77,53,71,55,83,108,74,101,73,63,84,103,72,
 78,96,60,75,65,90,91,86,106,93,80,99,81,62,68,52,57],
 [26,14,33,39,42,28,23,21,51,50,61,97,100,94,105,85,92,89,
 66,76,95,77,53,71,73,63,84,78,96,60,75,106,93,80,99,
 81,62,68,52,222,331,229,280,227,230,302,309,243,270,206,
 216,223,311,260,262,250,246,290,273,239,258,343,1291,695,
 685,1346,753,699],
 [26,14,33,39,42,28,23,21,51,50,61,97,100,94,105,85,92,89,
 66,76,95,77,53,71,101,73,63,84,78,60,106,93,80,99,81,
 62,68,52,222,331,229,280,227,302,309,329,212,243,270,206,
 216,223,290,273,239,258,343,1291,1042,714,733,727,695,685,
 864,635,753,699,829,628,2012,3326,2454,2234,2627,3980,2445,
 2390,2691,5682,5356],
 [26,14,33,39,42,28,23,21,51,50,61,97,100,94,105,85,92,89,
 66,76,95,77,53,71,101,73,63,84,78,96,60,75,106,93,80,
 99,81,62,68,52,222,331,229,280,227,302,309,243,270,206,
 216,223,311,260,262,250,290,273,239,258,343,1291,695,685,
 1346,753,699],
 [26,14,33,39,42,28,23,21,51,50,61,97,100,105,69,85,92,89,
 66,76,95,77,71,55,74,101,73,84,103,72,78,65,106,93,80,
 99,81,52,57,234,359,229,280,215,329,255,212,270,206,216,
 382,437,253,349,305,299,273,239,258,314,357,1400,714,733,
 712,1424,721,760,723],
 [26,14,33,39,42,28,23,21,51,50,94,92,95,53,83,108,73,63,
 78,65,106,80,62,68,282,481,376,422,352,425,333,344,346,
 491,472,279,208,230,255,203,294,277,246,305,187,490,430,
 515,567,558,518,453,493,572,466,540,561,473,507,488,505,
 525,417,591,555,569,497,553,587,663,630,701,636,2138,1068,
 1006,996,828,2153,907,1228,1399,1392,1052,1542,988,1231,
 1155,946,1127,1065,1526,1046,1261,1295,1168,1109,1996,2317,
 1620,2471,1734,1510,1646,2983,2176,2505,1802,1431,3929,3583,
 2447,3414,4134,2340,4600,4691,3629,2661,4143,3390,4996,2614,
 6133,6687],
 [26,14,33,39,42,28,23,21,51,50,97,100,69,92,89,76,95,55,
 83,108,101,73,103,72,60,65,106,80,81,57,282,384,326,376,
 422,541,425,333,521,476,433,491,317,371,234,359,215,270,
 216,382,437,253,295,273,258,314,357,397,604,547,531,543,
 533,524,608,448,573,539,529,498,577,712,723,881,969,1521,
 1019,1541,2051,2131],
 [26,14,33,39,42,28,23,21,51,50,97,100,69,92,89,76,95,55,
 83,108,101,73,103,72,60,65,106,80,81,57,282,384,326,481,
 376,422,541,352,425,333,521,344,346,433,491,472,234,359,
 215,270,216,382,437,253,295,273,258,314,357,547,533,524,
 540,561,538,529,498,497,553,712,723,2138,2201,1024,911,
 2760,2304],
 [26,14,33,39,42,28,23,21,51,50,97,100,94,69,92,89,76,95,
 53,55,83,108,101,73,63,103,72,78,60,65,90,86,106,80,81,
 62,68,57,282,384,326,481,376,422,541,352,425,333,521,344,
 346,476,433,444,374,491,317,371,472],
 [26,14,33,39,42,28,23,21,51,50,97,100,94,92,89,76,95,53,
 83,108,73,63,78,60,65,106,80,81,62,68,282,384,326,376,
 422,541,425,333,521,476,433,491,317,371,222,331,302,309,
 270,216,386,223,311,273,258,343,397,624,604,531,543,533,
 524,608,625,448,573,529,498,577,695,685,753,699,969,1521,
 1025,1019,1541,1051],
 [26,14,33,39,42,28,23,21,51,50,97,100,94,92,89,76,95,53,
 83,108,73,63,78,60,65,106,80,81,62,68,282,384,326,481,
 376,422,541,352,425,333,344,346,433,491,317,371,472,222,
 331,302,309,270,216,386,223,311,273,258,343,624,602,533,
 524,625,529,498,695,685,753,699,1762,1766,1221,1025,1128,
 1051,1398,1337],
 [26,14,33,39,42,28,23,21,51,97,100,69,92,95,55,101,73,
 103,72,60,65,106,81,57,384,326,481,541,352,521,344,346,
 433,472,324,307,298,229,280,318,406,267,213,260,262,323,
 565,537,441,570,596,554,461,574,609,602,503,582,611,505,
 525,504,557,532,563,494,621,566,615,716,745,2426,1129,996,
 828,2596,1157,1277,1143,1073,1446,993,850,1588,1922,1361,
 1087,1067,1406,1038,1679,1931,860,1678,1625,1583,1513,1727,
 1851,2009,1593,1641,1544,1736,1961,1497,1551,1712,2647,2811,
 2501,2748,1866,1965,1844,2014,3009,4069,2996,3027,3271,3013,
 3099,3091,3680,3397,8076,3306,4827,3711,6056,6292,6022,6008,
 8224,7566],
 [26,14,39,20,36,28,38,18,15,51,50,61,97,69,88,89,76,53,
 55,104,83,108,103,56,72,78,60,87,90,86,80,98,49,68,57,
 186,208,234,244,230,248,261,243,206,288,382,207,238,328,
 214,246,226,228,290,239,301,187,314,700,896,819,737,754,
 879,712,802,755,741,890,723,2357,1913,3562,2794,2087,1993,
 1925,3436,2504,2118,8866,6061,6001,7849,7482],
 [26,14,39,20,36,28,38,18,15,51,50,61,97,100,89,66,76,95,
 53,55,104,83,73,84,56,72,78,60,65,87,90,86,62,49,68,
 57,186,234,222,272,215,302,206,288,202,253,223,207,269,
 214,262,246,192,187,278,700,720,719,761,712,695,705,710,
 709,747,745,755,1075,698,806,3383,2495,2650,3175,2119,2282,
 1923,2581,1934,2080,8220,5874,7653,3831,3237,3834,9132,9108,
 6335,7264],
 [26,14,39,20,36,28,38,18,15,51,61,97,100,69,88,66,76,95,
 53,55,104,83,73,84,103,72,60,65,87,90,86,62,49,68,57,
 324,186,234,307,244,230,215,310,318,206,288,201,292,406,
 202,253,267,214,262,246,192,187,278,700,737,809,712,808,
 873,704,900,705,755,698,806,2368,2376,2363,1989,2677,2483,
 2321,1934,2767,2690,3631,5904,5803,7636,6271],
 [26,14,39,36,28,38,51,50,61,97,82,100,94,69,92,88,89,66,
 76,95,53,55,104,83,108,63,103,56,72,78,96,60,65,87,90,
 86,81,62,49,68,57,300,350,244,227,230,248,261,206,288,
 201,292,287,308,214,250,246,226,228,239,301,192,209,278,
 335,668,930,671,869],
 [26,14,39,36,28,38,51,50,61,97,82,100,94,105,69,92,88,89,
 66,76,95,53,71,55,104,83,64,108,74,101,73,63,84,103,56,
 72,78,96,60,65,87,90,91,86,106,80,99,81,98,62,49,68,
 52,57],
 [26,14,39,36,28,38,51,50,61,97,100,69,88,89,66,76,95,83,
 108,103,56,72,78,96,60,65,87,86,62,49,57,186,234,300,
 350,244,227,230,248,215,261,287,207,295,308,311,303,214,
 250,246,226,228,192,209,187,278,335,700,784,804,752,794,
 716,668,737,1107,772,930,754,879,765,810,694,776,812,884,
 745,671,755,1075,751,869,741,890,872,698,806,1379,2541,
 2694,1990,1916,2636,3446,1913,2308,2712,1988,2139,1923,2581,
 3616,1925,1934,3527,3396,3360,3237],
 [26,14,39,36,28,38,51,50,61,97,100,105,69,88,89,66,76,95,
 71,55,83,73,84,103,56,72,78,96,60,65,87,62,49,52,57,
 186,234,359,320,244,280,227,230,215,270,202,253,207,295,
 303,214,262,250,246,192,209,187,278,357,700,866,726,942,
 716,668,737,1107,772,705,812,702,884,745,671,755,1075,751,
 872,698,645,806,2247,1990,1916,1889,2636,1988,2139,1923,
 2041,2581,1934,3396,3237],
 [26,14,39,36,28,38,51,50,61,97,100,105,69,88,89,66,76,95,
 71,55,83,108,73,84,103,56,72,78,96,60,65,87,80,98,62,
 49,52,57,186,234,359,320,244,227,230,215,270,202,253,207,
 295,303,214,250,246,239,258,301,209,187,357,700,866,726,
 942,668,737,772,705,812,702,884,671,755,751,723,872,2247,
 1990,1988,2139],
 [26,14,39,36,28,38,51,50,61,97,100,105,69,88,89,76,55,83,
 108,74,73,84,103,56,72,78,96,60,87,86,80,98,62,49,52,
 57,186,234,359,320,244,230,437,202,253,207,238,328,295,
 308,303,214,246,290,239,301,209,187,357,700,896,819,696,
 1710,866,942,668,737,705,889,863,684,802,1639,776,812,884,
 671,755,723,872,2357,2917,2247,1990,2467,2914,1988,2139],
 [26,14,39,36,28,38,97,100,92,89,53,104,83,64,108,101,63,
 56,72,78,60,87,90,62,68,384,422,425,476,371,324,186,234,
 302,243,216,201,203,292,404,386,202,253,223,269,213,311,
 321,192,278,325,343,578,565,543,589,572,533,412,508,608,
 448,534,603,573,559,454,486,577,959,870,630,804,983,901,
 662,1246,636,810,920,897,645,1151,1281,1426,1188,1111,1197,
 1245,1072,1137,1108,1377,1227,1240,1116,1150,1218,1057,1204,
 2443,2130,2475,2018,1979,1384,1359,1452,1422,1398,1306,1425,
 1413,1465,1390,1337,1428,3578,2405,3521,2531,2346,2379,2330,
 4691,4143],
 [26,14,39,36,28,38,100,92,89,76,83,64,108,101,63,103,56,
 72,78,60,87,90,86,62,49,68,57,384,422,425,346,476,444,
 371,472,324,279,186,234,222,272,243,201,203,292,202,253,
 223,269,295,311,303,192,187,278,578,565,397,530,589,572,
 412,508,448,534,603,573,454,486,784,804,752,983,1084,901,
 765,810,694,920,1101,897,1271,1281,1111,1197,1245,1072,
 1137,1108,1227,1240,1116,1150,1218,1057,1384,1359,1452,1422,
 1398,1306,1425,1413,1465,1390,1337,1428,2346,2379,2330],
 [26,16,14,22,24,33,17,39,36,31,42,28,19,38,40,34,23,30,
 21,13,25,61,94,105,69,89,66,76,74,78,96,60,90,91,86,
 99,52,350,261,308,228],
 [26,16,14,22,24,33,17,39,37,27,31,41,35,19,40,34,23,30,
 21,13,25,61,105,85,88,66,59,77,71,84,91,70,93,99,52,
 227,329,212,266,349,299,306,727,736],
 [26,16,14,22,24,33,17,39,37,27,31,41,35,19,40,34,23,30,
 21,13,25,282,384,326,369,481,421,376,422,541,352,425,333,
 367,521,428,344,346,476,433,444,374,380,491,393,317,371,
 472],
 [26,16,14,22,24,33,17,39,37,27,31,42,28,19,40,34,23,30,
 21,13,25,61,105,85,89,66,76,77,71,74,91,93,99,52,261,
 329,212,270,216,349,299,273,258,845,941],
 [26,16,14,22,24,33,17,39,37,27,31,42,28,19,40,34,23,30,
 21,13,25,61,105,85,89,66,76,77,71,96,75,90,91,86,93,
 99,52,227,261,250,228],
 [26,16,14,22,24,33,17,39,37,27,31,42,28,19,40,34,23,30,
 21,13,25,282,384,326,381,481,375,376,422,541,352,425,333,
 366,332,476,433,444,374,368,491,327,317,371,472,1762,1310,
 1388,1766,1324,1364,1803,1385,1453],
 [26,16,14,22,24,33,17,39,37,27,31,42,41,35,28,19,34,23,
 30,21,13,25,61,105,85,66,77,53,71,74,84,91,93,80,99,
 52,329,212,349,299],
 [26,16,14,22,24,33,17,39,37,27,31,42,41,35,28,19,34,23,
 30,21,13,25,61,105,85,66,77,53,71,84,96,75,93,80,99,
 52,227,206,250,239],
 [26,16,14,22,24,33,17,39,37,27,31,42,41,35,28,19,34,23,
 30,21,13,25,282,384,326,481,376,389,422,541,352,425,333,
 521,344,392,346,476,444,374,491,317,338,371,472,791,838,
 846],
 [26,16,14,22,24,33,17,39,37,27,31,42,41,35,28,19,40,23,
 30,21,13,25,282,384,326,481,376,422,407,541,352,425,333,
 521,344,346,313,476,433,491,317,371,354,472,1068,1006,996,
 828,1484,972],
 [26,16,14,22,24,33,17,39,37,27,31,42,41,35,28,19,40,34,
 23,30,21,13,25,61,105,85,66,77,71,74,84,91,93,99,52,
 329,212,349,299],
 [26,16,14,22,24,33,17,39,37,27,31,42,41,35,28,19,40,34,
 23,30,21,13,25,61,105,85,66,77,71,84,96,75,91,93,99,
 52,227,250],
 [26,16,14,22,24,33,17,39,37,27,31,42,41,35,28,19,40,34,
 23,30,21,13,25,282,384,326,481,376,422,541,352,425,333,
 521,344,346,476,433,444,374,491,317,371,472],
 [26,16,14,22,24,33,17,39,37,27,31,42,41,35,28,40,34,23,
 30,21,13,25,282,384,326,481,443,376,422,541,352,425,333,
 521,424,344,346,433,444,374,491,385,317,371,472,2138,2201,
 2153],
 [26,16,14,22,24,33,17,39,37,27,36,31,41,28,19,38,34,23,
 30,21,13,25,282,384,369,481,375,389,422,541,352,425,367,
 521,332,476,444,380,491,327,338,371,472,913,1388,791,908,
 1364,966,1453,846,2419,2434,2493],
 [26,16,14,22,24,33,17,39,37,27,36,31,42,28,19,38,23,30,
 21,13,25,61,105,89,66,76,53,71,55,74,96,80,99,81,52,
 261,270,206,216,273,239,258,845,941],
 [26,16,14,22,24,33,17,39,37,27,36,31,42,41,19,38,34,23,
 30,21,13,25,282,384,481,375,421,389,422,541,352,425,521,
 332,476,444,491,327,393,338,371,472,1769,913,1388,791,
 1774,908,1364,1754,966,1453,846,2419,2434,2493],
 [26,16,14,22,24,33,17,39,37,27,36,31,42,41,28,19,34,23,
 30,21,13,25,61,105,66,76,77,53,71,74,84,96,93,80,99,
 52,206,216,239,258],
 [26,16,14,22,24,33,17,39,37,27,36,31,42,41,28,19,34,23,
 30,21,13,25,61,105,66,76,77,53,71,74,91,86,93,80,99,
 52,261,329,228,349],
 [26,16,14,22,24,33,17,39,37,27,36,31,42,41,28,19,34,23,
 30,21,13,25,282,384,481,375,376,389,422,541,352,425,521,
 332,476,444,491,327,317,338,371,472,1310,913,1388,791,
 1324,908,1364,1385,966,1453,846,2419,2434,2493],
 [26,16,14,22,24,33,17,39,37,27,36,31,42,41,28,19,38,34,
 23,30,21,13,25,61,105,66,76,53,71,74,84,96,80,99,52,
 206,216,239,258],
 [26,16,14,22,24,33,17,39,37,27,36,31,42,41,28,19,38,34,
 23,30,21,13,25,61,105,66,76,53,71,74,96,91,86,80,99,
 52,261,228],
 [26,16,14,22,24,33,17,39,37,27,36,31,42,41,28,19,38,34,
 23,30,21,13,25,282,384,481,375,389,422,541,352,425,521,
 332,476,444,491,327,338,371,472,913,1388,791,908,1364,966,
 1453,846,2419,2434,2493],
 [26,16,14,22,24,33,17,39,37,27,36,31,42,41,28,38,34,23,
 30,21,13,25,282,384,481,375,443,389,422,541,352,425,521,
 332,444,491,327,385,338,371,472,1483,913,1388,2138,791,
 1520,908,1364,1537,966,1453,2153,846,8751,2419,7513,2434,
 7552,2493],
 [26,16,14,22,24,33,17,39,37,27,36,31,42,41,35,19,38,23,
 30,13,25,282,384,481,421,389,422,407,410,541,352,425,521,
 428,392,346,313,399,476,491,393,338,371,354,341,472,791,
 1068,838,996,846,1484],
 [26,16,14,22,24,33,17,39,37,27,36,31,42,41,35,19,38,40,
 34,23,13,25,282,384,481,421,422,432,410,541,352,425,521,
 428,346,355,399,476,433,444,371,283,341,472,2299,2807,
 2305,2736,2169,2656],
 [26,16,14,22,24,33,17,39,37,27,36,31,42,41,35,19,38,40,
 34,23,30,13,25,61,105,66,59,71,64,74,84,91,70,99,49,
 52,329,349],
 [26,16,14,22,24,33,17,39,37,27,36,31,42,41,35,19,38,40,
 34,23,30,13,25,61,105,66,59,71,64,74,84,96,91,70,49,
 52,276,209],
 [26,16,14,22,24,33,17,39,37,27,36,31,42,41,35,19,38,40,
 34,23,30,13,25,282,384,481,421,422,410,541,352,425,521,
 428,346,399,476,433,444,491,393,371,341,472],
 [26,16,14,22,24,33,17,39,37,27,36,31,42,41,35,19,38,40,
 34,23,30,25,61,105,66,59,71,64,108,74,84,96,91,70,49,
 68,52,276,209],
 [26,16,14,22,24,33,17,39,37,27,36,31,42,41,35,19,38,40,
 34,23,30,25,282,384,481,421,422,410,370,541,352,425,521,
 428,346,399,362,476,433,444,491,393,341,249,472,1129,1260,
 1157],
 [26,16,14,22,24,33,17,39,37,27,36,31,42,41,35,19,40,34,
 30,13,25,61,105,66,59,77,71,104,64,74,84,91,70,93,98,
 49,52,329,276,349,209],
 [26,16,14,22,24,33,17,39,37,27,36,31,42,41,35,19,40,34,
 30,13,25,282,384,481,421,376,422,408,410,541,352,425,521,
 428,344,346,337,399,476,433,444,491,393,317,371,286,341,
 472],
 [26,16,14,22,24,33,17,39,37,27,36,31,42,41,35,28,19,38,
 40,23,21,25,282,384,481,422,407,432,370,541,352,425,521,
 346,313,355,362,476,433,283,249,472,1068,2299,1129,1327,
 996,2305,1260,1427,2169,1157,1341,1866,1917,1844],
 [26,16,14,22,24,33,17,39,37,27,36,31,42,41,35,28,19,38,
 40,23,30,21,25,61,105,66,71,55,108,74,84,96,99,81,68,
 52,206,239],
 [26,16,14,22,24,33,17,39,37,27,36,31,42,41,35,28,19,38,
 40,23,30,21,25,282,384,481,422,407,370,541,352,425,521,
 346,313,362,476,433,491,249,472,1068,1129,1327,996,1260,
 1427,1157,1341,1866,1917,1844],
 [26,16,14,22,24,33,17,39,37,27,36,31,42,41,35,28,19,38,
 40,23,30,25,61,105,66,71,55,64,108,74,84,96,49,68,52,
 206,276,203,209,187,704,698],
 [26,16,14,22,24,33,17,39,37,27,36,31,42,41,35,28,19,38,
 40,23,30,25,282,384,481,422,407,410,370,541,352,425,521,
 346,313,399,362,476,433,491,341,249,472,1068,1129,1327,
 996,1260,1427,1157,1341,1866,1917,1844],
 [26,16,14,22,24,33,17,39,37,27,36,31,42,41,35,28,19,38,
 40,30,21,25,282,384,481,422,407,408,370,541,352,425,521,
 346,313,337,362,476,433,491,286,249,472,1068,1129,1327,
 996,1260,1427,1157,1341,1866,1917,1844],
 [26,16,14,22,24,33,17,39,37,27,36,31,42,41,35,28,19,40,
 23,30,21,25,282,384,481,376,422,407,370,541,352,425,521,
 344,346,313,362,476,433,491,249,472,1068,2426,1129,1327,
 996,2658,1260,1427,2596,1157,1341,1866,1917,1844],
 [26,16,14,22,24,33,17,39,37,27,36,31,42,41,35,38,40,34,
 23,30,13,25,282,384,481,421,443,422,410,541,352,425,521,
 428,424,346,433,444,491,393,385,371,341,472,1302,2138,
 1438,2201,1439,2153],
 [26,16,14,22,24,33,17,39,37,27,36,42,41,28,19,38,34,23,
 30,21,13,25,282,384,492,481,375,389,422,541,352,520,521,
 332,476,444,484,491,327,338,371,472,1540,913,1388,791,
 1519,908,1364,1498,966,1453,846,2419,2434,2493],
 [26,16,14,22,24,33,17,39,37,27,36,42,41,35,28,19,38,40,
 34,23,21,13,25,61,105,92,66,71,83,74,84,96,65,91,99,
 62,52],
 [26,16,14,22,24,33,17,39,37,27,42,41,19,38,40,23,30,21,
 25,61,105,85,92,66,76,59,71,55,108,74,96,75,65,86,70,
 99,81,68,52,261,206,228,239],
 [26,16,14,22,24,33,17,39,37,36,31,35,28,19,38,40,34,23,
 30,21,13,25,61,105,69,88,89,66,71,74,96,60,87,90,91,
 99,52,261,228],
 [26,16,14,22,24,33,17,39,37,36,31,35,28,19,38,40,34,23,
 30,21,13,25,61,105,69,88,89,66,84,96,60,87,90,91,99,
 52,350,227,308,250],
 [26,16,14,22,24,33,17,39,37,36,31,42,35,28,19,38,40,34,
 23,30,21,13,25,61,105,69,89,66,71,74,96,60,90,91,99,
 52,261,228],
 [26,16,14,22,24,33,17,39,37,36,31,42,35,28,19,38,40,34,
 23,30,21,13,25,61,105,69,89,66,74,84,96,60,90,91,99,
 52,350,308],
 [26,16,14,22,24,39,37,31,42,41,28,19,38,34,23,30,21,13,
 25,61,82,100,105,69,85,66,76,74,56,72,96,60,75,91,86,
 80,99,52,359,350,261,295,308,228],
 [26,16,14,22,24,39,37,31,42,41,28,19,38,34,23,30,21,13,
 25,282,353,372,384,394,326,481,375,541,312,347,425,429,
 333,521,332,476,405,423,444,419,374,491,327,338,371,472,
 1293,954,1321,913,1388,1276,842,1282,908,1364,1353,1047,
 1236,966,1453,846,5284,2419,5883,2434,5176,2493],
 [26,16,14,22,29,17,37,36,31,42,41,32,28,19,38,40,18,23,
 30,21,13,15,289,353,339,384,394,375,395,425,429,332,313,
 363,409,405,387,444,419,327,354,236,777,837,1404,1928,826,
 1303,1871,991,891,1237,1872,2235,2025,2059],
 [26,16,14,22,29,17,37,36,31,42,41,32,28,19,38,40,18,23,
 30,21,13,15,289,353,339,384,394,375,425,429,332,313,363,
 409,405,387,444,419,327,354,236,777,837,1404,1928,970,
 1303,1871,916,991,891,1237,1872,909,2235,4198,2025,3897,
 2059,3848],
 [26,16,14,22,29,17,39,20,36,31,42,41,32,28,19,38,40,18,
 23,21,13,15,289,353,316,394,375,432,360,336,312,345,429,
 332,313,355,363,409,405,377,419,327,354,283,236,777,975,
 991],
 [26,16,14,22,29,17,39,36,31,42,41,32,28,19,38,40,18,23,
 30,21,13,15,97,82,94,105,69,76,101,103,56,78,96,60,86,
 81,57,331,311],
 [26,16,14,22,29,17,39,36,31,42,41,32,28,19,38,40,18,23,
 30,21,13,15,97,82,94,105,69,101,103,56,78,96,60,86,81,
 57,298,331,213,311],
 [26,16,14,22,29,17,39,36,31,42,41,32,28,19,38,40,18,23,
 30,21,13,15,289,353,316,384,394,375,360,345,425,429,332,
 313,363,409,405,377,444,419,327,354,236,777,1404,1928,
 1303,1871,991,1237,1872,2235,2025,2059],
 [26,16,14,22,29,17,39,36,31,42,41,32,28,19,38,40,18,23,
 30,21,13,15,289,353,316,384,394,375,360,425,429,332,313,
 363,409,405,377,444,419,327,354,236,777,1404,1928,1371,
 1303,1871,1331,991,1237,1872,1314,2235,2025,2059],
 [26,16,14,22,29,17,39,37,36,31,42,41,32,28,19,38,40,18,
 23,30,21,13,15,97,82,105,69,55,101,103,56,96,60,86,81,
 57,298,213],
 [26,16,14,22,29,17,39,37,36,31,42,41,32,28,19,38,40,18,
 23,30,21,13,15,97,82,105,69,76,101,103,56,96,60,86,81,
 57,331,311],
 [26,16,14,22,29,17,39,37,36,31,42,41,32,28,19,38,40,18,
 23,30,21,13,15,289,353,384,394,375,360,425,429,332,313,
 363,409,405,444,419,327,354,236,777,1404,1928,1303,1871,
 991,1237,1872,2235,2025,2059],
 [26,16,14,22,29,24,33,17,39,37,20,27,36,31,42,41,32,35,
 28,19,38,40,18,34,23,30,21,13,15,25],
 [26,16,14,22,29,33,17,20,36,31,42,41,32,28,19,18,23,30,
 21,13,15,289,339,316,394,375,376,389,407,336,395,345,429,
 332,344,392,313,363,419,327,317,338,354,236,837,834,1339,
 985,826,811,1297,978,968,1288,1451,2238,2246,2165],
 [26,16,14,22,29,33,17,20,36,31,42,41,32,28,19,38,40,18,
 23,21,13,15,289,339,316,394,375,407,336,395,345,429,332,
 313,355,363,409,387,377,419,327,354,283,236,851,837,839,
 826,789,891],
 [26,16,14,22,29,33,17,37,20,36,31,42,41,32,28,19,40,18,
 23,30,21,13,15,97,79,69,76,77,55,101,103,54,60,86,93,
 81,57],
 [26,16,14,22,29,33,17,37,20,36,31,42,41,32,28,19,40,18,
 23,30,21,13,15,289,339,394,375,376,407,336,395,429,332,
 344,313,363,419,327,317,354,236,837,834,1339,826,811,1297,
 968,1288,2238,2246,2165],
 [26,16,14,22,29,33,17,39,20,36,31,42,41,32,28,19,38,40,
 18,23,13,15,289,316,394,375,407,432,410,360,336,345,429,
 332,313,355,399,363,409,377,419,327,283,341,236,1327,1427,
 1341],
 [26,16,14,22,29,33,17,39,20,36,31,42,41,32,28,19,38,40,
 18,23,21,13,15,97,94,69,76,55,83,101,103,78,60,86,62,
 57,203,187],
 [26,16,14,22,29,33,17,39,20,36,31,42,41,32,28,19,38,40,
 18,23,21,13,15,97,94,69,76,83,101,103,78,60,86,81,62,
 57,331,311],
 [26,16,14,22,29,33,17,39,20,36,31,42,41,32,28,19,38,40,
 18,23,21,13,15,289,316,394,375,407,432,360,336,345,429,
 332,313,355,363,409,377,419,327,354,283,236],
 [26,16,14,22,29,33,17,39,20,36,31,42,41,32,28,19,40,18,
 21,13,15,97,94,69,76,77,55,104,83,101,103,78,60,86,93,
 98,62,57,203,187],
 [26,16,14,22,29,33,17,39,20,36,31,42,41,32,28,19,40,18,
 21,13,15,97,94,69,76,77,104,83,101,103,78,60,86,93,98,
 62,57,331,203,311,187],
 [26,16,14,22,29,33,17,39,20,36,31,42,41,32,28,19,40,18,
 21,13,15,289,316,394,375,376,407,408,432,360,336,345,429,
 332,344,313,337,355,363,419,317,354,286,283,236,834,985,
 1478,811,978,1471,968,1451,1472],
 [26,16,14,22,29,33,17,39,36,31,41,32,28,19,38,40,18,23,
 21,13,15,97,94,105,69,88,76,83,101,103,78,96,60,87,86,
 62,57,331,203,311,187],
 [26,16,14,22,29,33,17,39,36,31,41,32,28,19,38,40,18,23,
 21,13,15,97,94,105,69,88,76,83,101,103,78,96,60,87,86,
 81,62,57,331,311],
 [26,16,14,22,29,33,17,39,37,20,31,42,28,19,38,40,18,23,
 30,21,13,15,97,69,85,89,66,76,55,60,75,90,91,86,81,57,
 230,302,246,321],
 [26,16,14,22,29,33,17,39,37,20,31,42,28,19,38,40,18,23,
 30,21,13,15,97,69,85,89,66,76,55,101,60,75,90,91,86,
 81,57,302,321],
 [26,16,14,22,29,33,17,39,37,20,31,42,41,28,19,38,40,18,
 23,30,21,13,15,97,69,85,66,76,55,101,60,75,91,86,81,
 57,302,321],
 [26,16,14,22,29,33,17,39,37,20,31,42,41,28,19,38,40,18,
 23,30,21,13,15,97,69,85,66,76,55,103,60,75,91,86,81,
 57,230,246],
 [26,16,14,22,29,33,17,39,37,20,36,31,32,28,19,38,40,18,
 23,30,15,289,394,369,381,375,407,410,370,360,336,429,367,
 366,313,399,362,363,409,419,380,368,327,341,249,236,1407,
 1327,1496,1427,1504,1341],
 [26,16,14,22,29,33,17,39,37,20,36,31,41,32,28,19,38,40,
 18,23,30,13,15,97,69,88,76,55,64,101,103,60,87,86,81,
 49,57],
 [26,16,14,22,29,33,17,39,37,20,36,31,41,32,28,19,38,40,
 18,23,30,13,15,289,394,369,375,407,410,360,336,429,367,
 313,399,363,409,419,380,327,341,236,1407,1327,1496,1427,
 1504,1341],
 [26,16,14,22,29,33,17,39,37,20,36,31,42,41,32,19,38,23,
 30,21,13,15,97,69,76,59,53,71,55,101,103,60,80,99,81,
 57,216,221,258,220],
 [26,16,14,22,29,33,17,39,37,20,36,31,42,41,32,19,38,23,
 30,21,13,15,97,69,76,59,53,71,55,101,103,80,99,81,57,
 255,216,221,258,220,807,787],
 [26,16,14,22,29,33,17,39,37,20,36,31,42,41,32,19,38,23,
 30,21,13,15,289,394,375,421,389,422,407,360,336,429,332,
 428,392,346,313,409,327,393,338,371,354,236,758,1726,740,
 1658,841,1748],
 [26,16,14,22,29,33,17,39,37,20,36,31,42,41,32,19,38,40,
 23,30,21,13,15,97,69,76,59,71,55,101,103,60,99,81,57,
 216,221,258,220],
 [26,16,14,22,29,33,17,39,37,20,36,31,42,41,32,19,38,40,
 23,30,21,13,15,97,69,76,59,71,55,101,103,86,70,99,81,
 57,255,305],
 [26,16,14,22,29,33,17,39,37,20,36,31,42,41,32,19,38,40,
 23,30,21,13,15,289,394,375,421,422,407,360,336,429,332,
 428,346,313,409,327,393,371,354,236,758,1726,740,1658,841,
 1748],
 [26,16,14,22,29,33,17,39,37,20,36,31,42,41,32,19,40,23,
 30,21,13,15,289,394,375,421,376,422,407,360,336,429,332,
 428,344,346,313,327,393,317,371,354,236,758,834,1726,740,
 811,1658,841,968,1748],
 [26,16,14,22,29,33,17,39,37,20,36,31,42,41,32,28,38,18,
 23,21,15,97,69,76,95,53,55,83,108,101,103,86,106,80,62,
 68,57,255,203,305,187],
 [26,16,14,22,29,33,17,39,37,20,36,31,42,41,32,28,38,40,
 18,23,30,15,289,394,375,443,407,410,370,360,336,429,332,
 424,313,399,362,363,409,419,327,385,341,249,236,1327,1427,
 1341],
 [26,16,14,22,29,33,17,39,37,20,36,31,42,41,32,28,38,40,
 18,23,30,21,15,97,69,76,95,55,108,101,103,86,106,81,68,
 57,255,305],
 [26,16,14,22,29,33,17,39,37,20,36,31,42,41,32,28,38,40,
 18,23,30,21,15,289,394,375,443,407,370,360,336,429,332,
 424,313,362,363,409,419,327,385,354,249,236],
 [26,16,14,22,29,33,17,39,37,20,36,31,42,41,32,28,38,40,
 30,21,15,289,394,375,443,422,407,408,370,360,336,429,332,
 424,346,313,337,362,363,409,371,354,286,249,236,1726,1478,
 2436,1658,1471,2517,1748,1472,2595],
 [26,16,14,22,29,33,17,39,37,20,36,31,42,41,32,28,40,18,
 23,30,21,15,289,394,375,443,376,407,370,360,336,429,332,
 424,344,313,362,363,419,327,385,317,354,249,236,834,811,
 968],
 [26,16,14,22,29,33,17,39,37,20,36,31,42,41,32,38,23,30,
 21,13,15,289,394,375,421,443,389,422,407,360,336,429,332,
 428,424,392,346,313,409,327,393,385,338,371,354,236,758,
 1726,740,1658,841,1748],
 [26,16,14,22,29,33,17,39,37,20,36,31,42,41,32,38,40,18,
 23,30,21,15,97,69,76,59,95,55,108,101,103,86,70,106,81,
 68,57,255,305],
 [26,16,14,22,29,33,17,39,37,20,36,31,42,41,32,38,40,18,
 23,30,21,15,289,394,375,421,443,407,370,360,336,429,332,
 428,424,313,409,419,327,393,385,354,249,236,1120,758,943,
 740,906,841],
 [26,16,14,22,29,33,17,39,37,20,36,31,42,41,32,38,40,23,
 30,21,13,15,97,69,76,59,95,71,55,101,103,86,70,106,99,
 81,57,255,305],
 [26,16,14,22,29,33,17,39,37,20,36,31,42,41,32,38,40,23,
 30,21,13,15,97,69,76,59,95,71,55,101,103,99,81,57,255,
 216,221,288,258,220,301,807,787],
 [26,16,14,22,29,33,17,39,37,20,36,31,42,41,32,38,40,23,
 30,21,13,15,289,394,375,421,443,422,407,360,336,429,332,
 428,424,346,313,409,327,393,385,371,354,236,758,1726,740,
 1658,841,1748],
 [26,16,14,22,29,33,17,39,37,20,36,41,32,28,19,38,18,23,
 30,21,13,15,289,394,492,369,375,389,407,360,336,429,520,
 367,392,313,363,409,419,484,380,327,338,354,236,1407,1496,
 1504],
 [26,16,14,22,29,33,17,39,37,20,36,41,32,28,19,38,40,18,
 23,13,15,289,394,492,369,375,407,432,410,360,336,429,520,
 367,313,355,399,363,409,419,484,380,327,283,341,236,1407,
 1327,1496,1427,1504,1341],
 [26,16,14,22,29,33,17,39,37,20,36,42,32,28,38,18,23,30,
 21,13,15,97,69,92,89,76,95,53,55,101,60,65,90,106,80,
 81,57,302,216,321,258],
 [26,16,14,22,29,33,17,39,37,20,36,42,32,28,38,18,23,30,
 21,13,15,97,69,92,89,76,95,53,55,103,86,106,80,81,57,
 230,255,243,270,305,290,273,674,693],
 [26,16,14,22,29,33,17,39,37,20,36,42,41,19,38,18,23,30,
 21,13,15,289,394,492,481,375,421,389,407,360,336,429,520,
 521,332,428,409,419,484,491,327,393,338,354,236,913,1847,
 758,908,1852,740,966,1924,841],
 [26,16,14,22,29,33,17,39,37,20,36,42,41,32,28,19,18,23,
 30,21,13,15,289,394,492,375,376,389,407,360,336,429,520,
 332,344,392,313,363,419,484,327,317,338,354,236,834,811,
 968],
 [26,16,14,22,29,33,17,39,37,20,36,42,41,32,28,19,38,18,
 23,30,21,13,15,97,69,92,76,53,55,101,103,60,65,80,81,
 57,216,258],
 [26,16,14,22,29,33,17,39,37,20,36,42,41,32,28,19,38,18,
 23,30,21,13,15,97,69,92,76,53,55,103,60,65,86,80,81,
 57,230,246],
 [26,16,14,22,29,33,17,39,37,20,36,42,41,32,28,19,38,18,
 23,30,21,13,15,289,394,492,375,389,407,360,336,429,520,
 332,392,313,363,409,419,484,327,338,354,236],
 [26,16,14,22,29,33,17,39,37,20,36,42,41,32,28,19,38,23,
 30,21,13,15,97,69,92,76,53,71,55,101,103,60,65,80,99,
 81,57,216,258],
 [26,16,14,22,29,33,17,39,37,20,36,42,41,32,28,19,38,23,
 30,21,13,15,97,69,92,76,53,71,55,103,60,65,80,99,81,
 57,230,216,246,258],
 [26,16,14,22,29,33,17,39,37,20,36,42,41,32,28,19,38,23,
 30,21,13,15,289,394,492,375,389,422,407,360,336,429,520,
 332,392,346,313,363,409,327,338,371,354,236,1726,2451,
 1658,2438,1748,2406],
 [26,16,14,22,29,33,17,39,37,20,42,41,28,19,38,40,18,23,
 30,21,13,15,97,69,85,92,66,76,55,60,75,65,91,86,81,57,
 230,302,246,321],
 [26,16,14,22,29,33,17,39,37,20,42,41,28,19,38,40,18,23,
 30,21,13,15,97,69,85,92,66,76,55,103,60,75,65,91,86,
 81,57,230,246],
 [26,16,14,22,29,33,17,39,37,20,42,41,32,28,19,38,18,23,
 30,21,13,15,97,69,85,92,76,53,55,103,60,75,65,80,81,
 57,230,216,246,258],
 [26,16,14,22,29,33,17,39,37,20,42,41,32,28,19,38,18,23,
 30,21,13,15,97,69,85,92,76,53,55,103,60,75,65,86,80,
 81,57,230,246],
 [26,16,14,22,29,33,37,20,36,31,42,32,28,19,38,40,18,23,
 30,21,13,15,289,372,339,394,381,375,407,336,347,395,429,
 366,332,313,363,409,423,387,419,368,327,354,236,837,826,
 891],
 [26,16,14,22,29,33,37,20,36,31,42,41,32,28,40,18,23,30,
 21,13,15,289,372,339,394,375,443,376,407,336,347,395,429,
 332,424,344,313,363,419,327,385,317,354,236,837,834,1033,
 1339,826,811,840,1297,968,964,1288,2238,2246,2165],
 [26,16,14,22,29,33,39,20,36,31,42,41,32,28,19,38,40,18,
 23,21,15,97,100,94,69,55,83,108,101,103,72,78,60,86,62,
 68,57,298,203,213,187],
 [26,16,14,22,29,33,39,20,36,42,32,28,19,38,40,18,23,30,
 21,13,15,97,100,94,69,55,103,72,78,60,65,90,86,81,57,
 240,307,298,207,267,213,246,761,747],
 [26,16,14,22,29,33,39,20,36,42,32,28,19,38,40,18,23,30,
 21,13,15,97,100,94,69,92,89,76,101,60,65,90,86,81,57,
 331,302,309,318,321,348,323,1042,1054],
 [26,16,14,22,29,33,39,37,20,36,31,42,28,19,38,40,18,23,
 30,21,13,15,97,100,69,89,66,76,55,101,60,90,91,86,81,
 57,302,309,321,348],
 [26,16,14,22,29,33,39,37,20,36,31,42,28,19,38,40,18,23,
 30,21,13,15,289,372,394,381,481,375,407,360,336,347,429,
 366,521,332,363,409,423,419,368,491,327,354,236,1847,1852,
 1924],
 [26,16,14,22,29,33,39,37,20,36,31,42,32,28,19,38,40,18,
 23,30,21,13,15,97,100,69,55,101,103,72,60,90,86,81,57,
 307,298,267,213],
 [26,16,14,22,29,33,39,37,20,36,31,42,32,28,19,38,40,18,
 23,30,21,13,15,97,100,69,89,76,55,101,60,90,86,81,57,
 302,309,321,348],
 [26,16,14,22,29,33,39,37,20,36,31,42,32,28,19,38,40,18,
 23,30,21,13,15,289,372,394,381,375,407,360,336,347,429,
 366,332,313,363,409,423,419,368,327,354,236],
 [26,16,14,22,29,33,39,37,31,42,32,28,19,38,40,18,23,30,
 21,13,15,289,372,384,394,326,381,375,407,360,425,333,366,
 332,313,363,409,423,444,419,374,368,327,354,236,1404,1442,
 1752,1303,1350,1770,1237,1372,1755],
 [26,16,14,22,29,39,36,31,42,41,32,28,19,38,40,18,23,30,
 21,13,15,289,353,372,316,384,394,375,360,345,425,429,332,
 313,363,409,405,423,377,444,419,327,354,236,777,1404,1928,
 1442,1303,1871,1350,991,1237,1872,1372,2235,2025,2059],
 [26,16,14,22,29,39,37,20,36,31,42,28,19,38,40,18,23,30,
 21,13,15,289,353,372,394,381,481,375,360,336,312,347,429,
 366,521,332,363,409,405,423,419,368,491,327,354,236,777,
 1847,975,1852,991,1924],
 [26,16,14,22,29,39,37,20,36,31,42,32,28,19,38,40,18,23,
 30,21,13,15,97,82,100,69,55,101,103,56,72,60,90,86,81,
 57,307,298,267,213],
 [26,16,14,22,29,39,37,20,36,31,42,32,28,19,38,40,18,23,
 30,21,13,15,289,353,372,394,381,375,360,336,312,347,429,
 366,332,313,363,409,405,423,419,368,327,354,236,777,975,
 991],
 [26,16,14,22,29,39,37,36,31,42,41,32,28,19,38,40,18,23,
 30,21,13,15,97,82,100,105,69,55,101,103,56,72,96,60,86,
 81,57,298,213],
 [26,16,14,22,29,39,37,36,31,42,41,32,28,19,38,40,18,23,
 30,21,13,15,97,82,100,105,69,101,103,56,72,96,60,86,81,
 57,298,331,213,311],
 [26,16,14,22,29,39,37,36,31,42,41,32,28,19,38,40,18,23,
 30,21,13,15,289,353,372,384,394,375,360,347,425,429,332,
 313,363,409,405,423,444,419,327,354,236,777,1404,1928,
 1303,1871,991,1237,1872,2235,2025,2059],
 [26,16,14,22,29,39,37,36,31,42,41,32,28,19,38,40,18,23,
 30,21,13,15,289,353,372,384,394,375,360,425,429,332,313,
 363,409,405,423,444,419,327,354,236,777,1404,1928,1442,
 1303,1871,1350,991,1237,1872,1372,2235,2025,2059],
 [26,16,14,22,33,17,37,36,42,41,28,19,40,23,21,13,61,105,
 92,66,71,83,74,84,96,65,91,99,62,52,289,339,394,376,
 407,429,332,363,327,317,354,496,567,469,531,522,466,625,
 525,550,510,548,523,456,587,837,834,1339,968,1288,2317,
 1563,1820,2244,1659,1900,2238,2165,4846,5512],
 [26,16,14,22,33,17,39,37,36,42,41,19,38,23,30,13,97,69,
 92,76,53,55,101,103,80,81,57,282,384,422,410,541,521,
 428,399,476,491,393,371,216,258,397,455,604,554,543,572,
 533,579,608,426,413,448,465,591,529,456,396,576,577,1114,
 1391,1521,1034,1299,1541,2038,1307,2166,1336,4686,3159,3979,
 2538],
 [26,16,14,22,33,17,39,37,42,41,28,19,23,30,21,13,61,97,
 105,69,85,92,66,76,77,53,71,55,84,103,96,60,75,65,93,
 80,99,81,52,57,227,230,206,216,250,246,239,258],
 [26,16,14,22,33,17,42,41,28,19,21,13,61,97,79,94,105,69,
 85,92,66,76,84,103,54,78,96,60,75,65,98,62,52,57,322,
 359,350,331,320,229,227,230,319,295,308,311,303,260,250,
 246,235,192,209,187,866,726,887,716,668,737,812,702,874,
 745,671,755,698,645,1916,1889,1923,2041],
 [26,16,14,22,33,39,37,31,42,28,19,40,23,30,21,13,97,100,
 69,89,76,55,60,90,86,81,57,282,384,326,541,425,333,476,
 433,491,317,371,302,309,321,348,397,537,570,624,604,453,
 531,543,533,524,625,573,417,548,559,529,498,577,937,1294,
 1671,1025,1009,1269,1570,1051,2799,2795,4795,6914],
 [26,16,14,24,17,20,27,36,31,42,32,35,28,19,38,18,34,23,
 30,21,15,25,340,282,353,339,316,402,352,312,395,345,366,
 392,362,411,433,405,387,377,368,338,249,1330,1293,818,
 1012,1276,831,1172,1353,934],
 [26,16,14,24,33,17,20,27,36,31,42,32,35,28,19,38,18,34,
 23,30,21,15,25,50,61,79,94,53,108,63,84,54,78,90,80,
 68,307,267],
 [26,16,14,24,33,17,20,27,36,31,42,32,35,28,19,38,18,34,
 23,30,21,15,25,50,61,89,53,108,63,84,54,78,90,80,68,
 193,234,200,253],
 [26,16,14,24,33,17,20,27,36,31,42,32,35,28,19,38,18,34,
 23,30,21,15,25,340,282,339,316,389,402,352,395,345,366,
 392,362,411,433,387,377,368,338,249,1330,818,1012,831,
 1172,934],
 [26,16,14,24,33,17,20,36,31,42,32,35,28,19,38,18,34,23,
 30,21,15,25,340,282,339,316,394,389,402,352,395,345,429,
 366,392,362,411,433,387,377,419,368,338,249,1330,818,1012,
 831,1172,934],
 [26,16,14,24,33,17,36,31,35,28,19,30,21,25,61,105,69,88,
 104,84,87,99,98,52,340,339,316,376,389,407,395,345,313,
 362,387,317,338,354,350,227,250,500,397,596,554,458,518,
 453,489,412,505,448,514,417,539,529,456,502,454,615,818,
 1660,831,934,1605,1267,1506,1861,1819,1541,1703,1623,2463,
 1685,1600,1688,1508,1693,1593,1684,1638,2901,1691,1494,3257,
 2679,3107,3129,2710,3356,2528,3282,2706,3205,2905,3434,3241,
 2633,3942,5772,3699,5634,4234,4456,8160,7781,6080,6375,6725,
 6440,9419,7737,6559,6738,6884,8229,7538,6319,7914,7023,7704,
 7685],
 [26,16,14,24,33,17,39,27,31,42,28,19,34,23,21,25,50,94,
 89,76,53,83,108,90,86,80,62,68,282,481,376,422,352,425,
 333,476,444,374,472,215,245,490,515,614,547,453,531,543,
 572,412,540,561,417,548,559,591,454,497,553,881,1190,1423,
 1024,1027,1274,1420,911,1996,4691,5943,4143,6272],
 [26,16,14,24,33,17,39,37,27,36,31,42,41,35,28,19,38,40,
 34,23,30,21,13,50,61,66,71,74,101,63,84,96,91,99,52,
 57,300,287],
 [26,16,14,24,33,17,39,37,27,36,31,42,41,35,38,40,30,21,
 13,50,61,66,59,95,71,55,104,74,101,63,84,91,70,106,81,
 98,52,57,300,329,276,287,349,209],
 [26,16,14,24,33,20,27,36,31,42,32,35,28,19,38,18,34,23,
 30,21,15,25,50,61,53,108,63,84,72,54,78,90,80,68,208,
 193,234,277,200,253,267,663,701],
 [26,16,14,24,33,20,27,36,31,42,32,35,28,19,38,18,34,23,
 30,21,15,25,50,61,100,79,94,53,108,63,84,72,54,78,90,
 80,68,307,267],
 [26,16,14,24,33,20,27,36,31,42,32,35,28,19,38,18,34,23,
 30,21,15,25,340,282,372,339,316,389,402,352,347,395,345,
 366,392,362,411,433,423,387,377,368,338,249,1330,818,1012,
 831,1172,934],
 [26,16,14,29,17,39,20,36,31,32,28,19,38,18,30,15,50,82,
 94,89,53,104,108,63,56,78,90,80,98,68,289,394,369,375,
 410,360,336,429,367,313,399,363,409,419,380,341,236,536,
 485,512,516,1407,1327,1496,1427,1504,1341],
 [26,16,14,29,17,39,20,36,31,32,28,19,38,18,30,15,50,89,
 56,78,289,394,369,375,410,360,336,429,367,313,399,363,
 409,419,380,341,236,464,495,441,556,606,596,509,549,609,
 511,503,447,527,618,505,483,512,544,620,519,532,470,568,
 600,468,480,615,1407,1327,1496,1427,1504,1341,1087,1473,
 1656,4230,1583,1727,1527,1606,4078,1745,1753,1509,1611,3879,
 1497,1712,2806,3684,4069,2537,3184,4048,3197,3487,3397],
 [26,16,14,29,17,39,20,36,31,32,28,19,38,18,30,15,97,64,
 101,60,87,340,353,316,381,370,402,312,345,392,337,362,
 411,405,377,249,430,501,496,536,567,583,598,466,506,485,
 447,473,527,525,512,586,581,478,517,514,462,523,576,587,
 1293,976,1276,813,1564,1353,835,1155,1095,1065,1194,2217,
 1550,1823,7345,1184,2287,1516,1462,1474,1904,5612,1242,2556,
 1562,1839,5337,2313,2300,2385,2967,3271,4478,3217,2782,3331,
 5381,3548,3174,8140,5372,7927,5975,7061,5357,6259,8183,6971,
 6094],
 [26,16,14,29,17,39,20,36,31,32,28,19,38,18,30,15,97,69,
 88,76,55,64,101,103,60,87,86,81,49,57,340,353,316,381,
 370,402,312,345,392,337,362,411,405,377,249,518,447,527,
 514,468,480,1293,976,1276,813,1564,1353,835,1462,1497,2313,
 2300,2385],
 [26,16,14,29,17,39,36,31,42,28,19,18,23,30,21,15,50,94,
 89,66,108,78,90,91,93,80,68,289,353,384,394,375,360,425,
 429,332,363,444,419,327,354,236,215,245,537,441,522,540,
 447,548,470,523,555,535,777,1404,1928,1303,1871,1237,1872,
 1674,1560,1721,1553,1659,1589,1535,2235,2025,2059,3490,3051,
 3104],
 [26,16,14,29,17,39,36,31,42,28,19,18,23,30,21,15,97,82,
 105,69,76,101,96,60,86,81,57,340,316,381,481,370,345,
 366,521,362,377,368,491,317,338,249,331,311,537,441,596,
 567,526,528,474,584,555,535,1310,913,1324,908,1385,966,
 1605,2196,2017,1910,2163,1899,1938,1848,2386,2319,2422,5890,
 5428,5763],
 [26,16,14,29,24,17,39,20,27,36,31,42,32,35,28,19,38,18,
 34,30,21,15,25,50,82,94,89,53,104,108,63,56,78,90,80,
 98,68],
 [26,16,14,29,24,17,39,20,27,36,31,42,32,35,28,19,38,18,
 34,30,21,15,25,340,353,316,381,370,402,312,345,366,392,
 337,362,411,405,377,338,286,249,1293,976,1276,813,1564,
 1353,835,1612,2313,2300,2385],
 [26,16,14,29,24,17,39,27,36,31,42,32,35,28,19,38,18,34,
 30,21,25,340,353,316,384,381,370,312,345,425,366,392,337,
 362,476,411,405,377,444,338,286,472,1293,976,1271,1436,
 1276,813,1281,1450,1564,3450,1353,835,1566,1315,1612,3273,
 2313,5730,2300,5717,2385,5392],
 [26,16,14,29,24,33,17,39,20,27,31,42,35,28,19,18,34,23,
 30,21,15,25,340,316,326,381,481,376,389,370,402,333,366,
 521,362,377,374,368,491,317,338,249,1371,1310,913,1660,
 1331,1324,908,1314,1385,966,1605,2386,2319,2422],
 [26,16,14,29,24,33,17,39,20,27,36,31,35,28,19,34,23,30,
 21,15,25,50,94,88,89,66,77,53,71,63,87,90,91,93,80,99,
 68,280,318,262,323],
 [26,16,14,29,24,33,17,39,20,27,36,31,35,28,19,34,23,30,
 21,15,25,50,94,88,89,66,77,53,71,108,78,93,80,99,68,
 215,266,270,206,306,273,239,712,723],
 [26,16,14,29,24,33,17,39,20,27,36,31,42,28,18,34,23,30,
 21,15,25,340,316,381,481,375,443,376,389,370,402,345,366,
 521,332,362,377,368,491,327,385,317,338,249,1483,1310,913,
 1660,1520,1324,908,1537,1385,966,1605,2386,2319,2422],
 [26,16,14,29,24,33,17,39,20,27,36,31,42,28,19,18,34,23,
 30,21,15,25,50,94,89,66,76,77,53,108,78,90,91,86,93,
 80,68,215,245],
 [26,16,14,29,24,33,17,39,20,27,36,31,42,28,19,18,34,23,
 30,21,15,25,50,94,89,66,76,77,53,108,90,91,86,93,80,
 68,215,318,245,323],
 [26,16,14,29,24,33,17,39,20,27,36,31,42,28,19,18,34,23,
 30,21,15,25,340,316,381,481,375,376,389,370,402,345,366,
 521,332,362,377,368,491,327,317,338,249,1310,913,1660,
 1324,908,1385,966,1605,2386,2319,2422],
 [26,16,14,29,24,33,17,39,20,27,36,31,42,28,19,38,18,34,
 23,15,25,340,316,381,481,375,389,432,410,370,402,345,366,
 521,332,355,399,362,411,377,368,491,327,283,341,249,913,
 1862,908,1908,966,1891],
 [26,16,14,29,24,33,17,39,20,27,36,31,42,28,19,38,18,34,
 23,21,15,25,50,94,89,66,76,53,83,108,78,90,91,86,62,
 68,215,201,245,192],
 [26,16,14,29,24,33,17,39,20,27,36,31,42,28,19,38,18,34,
 23,21,15,25,50,94,89,66,76,53,83,108,78,90,91,86,80,
 62,68,215,245],
 [26,16,14,29,24,33,17,39,20,27,36,31,42,28,19,38,18,34,
 23,21,15,25,340,316,381,481,375,389,432,370,402,345,366,
 521,332,355,362,411,377,368,491,327,338,283,249,913,908,
 966],
 [26,16,14,29,24,33,17,39,20,27,36,31,42,32,28,19,38,18,
 34,21,15,25,340,316,381,375,389,408,432,370,402,345,366,
 332,392,337,355,362,411,377,338,286,283,249,1797,1478,
 1564,1471,1612,1472],
 [26,16,14,29,24,33,17,39,20,27,36,31,42,32,28,19,38,18,
 34,23,15,25,50,94,89,76,53,83,64,108,63,78,90,86,62,
 49,68,201,192],
 [26,16,14,29,24,33,17,39,20,27,36,31,42,32,28,19,38,18,
 34,23,15,25,50,94,89,76,53,83,64,108,78,90,86,62,49,
 68,215,201,245,192],
 [26,16,14,29,24,33,17,39,20,27,36,31,42,32,28,19,38,18,
 34,23,15,25,340,316,381,375,389,432,410,370,402,345,366,
 332,392,355,399,362,411,377,368,327,283,341,249,1862,1908,
 1891],
 [26,16,14,29,24,33,17,39,20,27,36,31,42,32,28,19,38,18,
 34,23,21,15,25,50,94,89,76,53,83,108,63,78,90,86,62,
 68,201,192],
 [26,16,14,29,24,33,17,39,20,27,36,31,42,32,28,19,38,18,
 34,23,21,15,25,50,94,89,76,53,83,108,78,90,86,80,62,
 68,215,245],
 [26,16,14,29,24,33,17,39,20,27,36,31,42,32,28,19,38,18,
 34,23,21,15,25,340,316,381,375,389,432,370,402,345,366,
 332,392,355,362,411,377,368,327,338,283,249],
 [26,16,14,29,24,33,17,39,20,27,36,31,42,32,35,28,19,34,
 23,30,25,50,94,89,77,53,71,64,108,74,63,90,49,68,52,
 318,251,201,276,235,192,209,873,798],
 [26,16,14,29,24,33,17,39,20,27,36,31,42,32,35,28,19,38,
 23,15,25,340,316,381,389,422,407,432,410,370,402,345,366,
 392,346,313,355,399,362,411,368,283,341,249,985,1862,1129,
 1327,978,1908,1260,1427,1891,1157,1341,1812,1845,1826],
 [26,16,14,29,24,33,17,39,20,27,36,31,42,32,35,28,19,38,
 23,30,15,25,50,94,89,53,71,55,64,108,63,78,49,68,270,
 201,276,203,192,209,187,919,872],
 [26,16,14,29,24,33,17,39,20,27,36,31,42,32,35,28,19,38,
 23,30,15,25,50,94,89,53,71,55,64,108,63,78,80,99,81,
 49,68,270,273],
 [26,16,14,29,24,33,17,39,20,27,36,31,42,32,35,28,19,38,
 23,30,15,25,340,316,381,389,422,407,410,370,402,345,366,
 392,346,313,399,362,411,368,341,249,985,1862,1129,1327,
 978,1908,1260,1427,1891,1157,1341,1812,1845,1826],
 [26,16,14,29,24,33,17,39,20,27,36,31,42,32,35,28,19,38,
 34,23,15,25,50,94,89,53,71,83,64,108,63,78,62,49,68,
 270,201,276,192,209,919,872],
 [26,16,14,29,24,33,17,39,20,27,36,31,42,32,35,28,19,38,
 34,23,15,25,50,94,89,53,71,83,64,108,63,78,90,62,49,
 68,201,276,192,209],
 [26,16,14,29,24,33,17,39,20,27,36,31,42,32,35,28,19,38,
 34,23,15,25,340,316,381,389,422,432,410,370,402,345,366,
 392,346,355,399,362,411,368,283,341,249,985,1862,1129,978,
 1908,1260,1891,1157,1812,1845,1826],
 [26,16,14,29,24,33,17,39,20,27,36,31,42,32,35,28,19,38,
 34,23,30,15,25,50,94,89,53,71,64,108,63,78,80,99,49,
 68,270,273],
 [26,16,14,29,24,33,17,39,20,27,36,31,42,32,35,28,19,38,
 34,23,30,15,25,50,94,89,53,71,64,108,63,78,90,49,68,
 201,276,192,209],
 [26,16,14,29,24,33,17,39,20,27,36,31,42,32,35,28,19,38,
 34,23,30,15,25,340,316,381,389,422,410,370,402,345,366,
 392,346,399,362,411,368,341,249,985,1862,1129,978,1908,
 1260,1891,1157,1812,1845,1826],
 [26,16,14,29,24,33,17,39,20,27,36,31,42,32,35,28,19,38,
 34,23,30,15,340,316,381,389,422,410,370,360,402,345,366,
 392,346,399,362,363,411,368,341,249,236,985,1862,1129,978,
 1908,1260,1891,1157,1812,1845,1826],
 [26,16,14,29,24,33,17,39,20,27,36,31,42,32,35,28,19,38,
 34,30,15,25,340,316,381,389,422,408,410,370,402,345,366,
 392,346,337,399,362,411,286,341,249,985,1797,1862,1129,
 978,1564,1908,1260,1612,1891,1157,1812,1845,1826],
 [26,16,14,29,24,33,17,39,20,27,36,31,42,32,35,28,38,34,
 23,30,15,25,340,316,381,443,389,422,410,370,402,345,366,
 424,392,346,399,362,411,368,341,249,985,2436,1862,1129,
 978,2517,1908,1260,2595,1891,1157,1812,1845,1826],
 [26,16,14,29,24,33,17,39,20,27,36,31,42,35,19,18,34,23,
 30,21,15,25,340,316,381,481,421,376,389,370,402,345,366,
 521,377,368,491,393,317,338,249,1769,1310,913,1120,1660,
 1774,1324,908,1754,1385,966,906,1605,4637,2386,4320,2319,
 4641,2422],
 [26,16,14,29,24,33,17,39,20,27,36,31,42,35,28,18,34,23,
 30,21,15,25,50,94,89,66,95,77,53,108,63,90,91,106,93,
 80,68,318,323],
 [26,16,14,29,24,33,17,39,20,27,36,31,42,35,28,18,34,23,
 30,21,15,25,50,94,89,66,95,77,53,108,90,91,106,93,80,
 68,215,318,245,323],
 [26,16,14,29,24,33,17,39,20,27,36,31,42,35,28,18,34,23,
 30,21,15,25,340,316,381,481,443,376,389,370,402,345,366,
 521,362,377,368,491,385,317,338,249,1483,1310,913,1660,
 1520,1324,908,1537,1385,966,1605,2386,2319,2422],
 [26,16,14,29,24,33,17,39,20,27,36,31,42,35,28,19,18,23,
 30,21,15,25,340,316,381,481,376,389,407,370,402,345,366,
 521,362,377,368,491,317,338,354,249,1310,913,1847,1660,
 1324,908,1852,1385,966,1924,1605,2386,2319,2422],
 [26,16,14,29,24,33,17,39,20,27,36,31,42,35,28,19,18,34,
 23,30,21,15,25,50,94,89,66,77,53,108,63,90,91,93,80,
 68,318,323],
 [26,16,14,29,24,33,17,39,20,27,36,31,42,35,28,19,18,34,
 23,30,21,15,25,50,94,89,66,77,53,108,78,90,91,93,80,
 68,215,245],
 [26,16,14,29,24,33,17,39,20,27,36,31,42,35,28,19,18,34,
 23,30,21,15,25,340,316,381,481,376,389,370,402,345,366,
 521,362,377,368,491,317,338,249,1310,913,1660,1324,908,
 1385,966,1605,2386,2319,2422],
 [26,16,14,29,24,33,17,39,20,27,36,42,32,28,19,38,18,34,
 23,21,15,50,94,92,89,76,53,63,78,65,90,86,62,68,57,
 229,280,230,260,262,246,192,716,745],
 [26,16,14,29,24,33,17,39,20,27,36,42,35,28,19,18,34,23,
 30,21,15,25,340,316,492,381,481,376,389,370,402,345,520,
 366,521,362,377,484,368,491,317,338,249,1310,913,1660,
 1324,908,1385,966,1605,2386,2319,2422],
 [26,16,14,29,24,33,17,39,27,31,42,32,28,19,38,18,34,23,
 21,15,25,340,316,384,326,381,375,389,432,370,425,333,366,
 332,392,355,362,411,377,444,374,368,327,338,283,249,1436,
 1371,1450,1331,1315,1314],
 [26,16,14,29,24,33,20,27,36,31,42,32,35,28,19,38,18,34,
 23,30,21,15,50,100,79,94,53,108,101,63,72,54,78,90,80,
 68,57,307,267],
 [26,16,14,29,24,33,20,27,36,31,42,32,35,28,19,38,18,34,
 23,30,21,15,340,372,339,316,381,389,402,347,395,345,366,
 392,362,363,411,423,387,377,368,338,249,236,818,837,831,
 826,934,891],
 [26,16,14,29,24,33,39,20,27,36,31,42,32,35,28,19,38,18,
 34,23,30,15,340,372,316,381,389,410,370,360,402,347,345,
 366,392,399,362,363,411,423,377,368,341,249,236,1862,1908,
 1891],
 [26,16,14,29,24,33,39,20,27,36,31,42,32,35,28,19,38,18,
 34,23,30,21,15,50,100,94,53,108,101,63,72,78,90,80,68,
 57,307,267],
 [26,16,14,29,24,33,39,20,27,36,31,42,32,35,28,19,38,18,
 34,23,30,21,15,340,372,316,381,389,370,360,402,347,345,
 366,392,362,363,411,423,377,368,338,249,236],
 [26,16,14,29,24,33,39,20,27,36,31,42,32,35,28,19,38,34,
 30,21,15,340,372,316,381,389,422,408,370,360,402,347,345,
 366,392,346,337,362,363,411,338,371,286,249,236,1033,985,
 1797,840,978,1564,964,1451,1612],
 [26,16,14,29,24,33,39,20,36,31,42,32,35,28,19,38,18,34,
 23,21,15,50,100,94,69,53,83,108,101,63,72,78,60,90,62,
 68,57,307,201,267,192],
 [26,16,14,29,24,33,39,27,36,31,42,32,35,28,19,38,18,34,
 23,30,21,15,340,372,316,384,381,389,370,360,347,345,425,
 366,392,362,363,411,423,377,444,368,338,249,236,1436,1450,
 1315],
 [26,16,14,29,24,39,20,27,36,31,42,32,35,28,19,38,18,34,
 21,15,25,340,353,372,316,381,370,402,312,347,345,366,392,
 337,355,362,411,405,423,377,338,286,283,249,1293,976,851,
 1276,813,839,1564,1353,835,789,1612,2313,2300,2385],
 [26,16,14,29,24,39,20,27,36,31,42,32,35,28,19,38,18,34,
 23,30,21,15,340,353,372,316,381,370,360,402,312,347,345,
 366,392,362,363,411,405,423,377,368,338,249,236,1293,1276,
 1353],
 [26,16,14,29,33,17,39,20,27,36,31,42,32,35,28,18,34,30,
 21,15,25,50,97,94,89,95,77,53,104,108,63,90,106,93,80,
 98,68,302,318,321,323],
 [26,16,14,29,33,17,39,20,27,36,31,42,32,35,28,38,18,34,
 23,30,21,15,25,50,97,94,89,95,53,108,63,90,106,80,68,
 302,318,321,323],
 [26,16,14,29,33,17,39,20,27,36,31,42,32,35,28,38,18,34,
 23,30,21,15,25,340,289,316,381,443,389,370,402,336,345,
 366,424,392,362,411,409,377,368,385,338,249],
 [26,16,14,29,33,17,39,20,27,36,31,42,32,35,28,38,34,23,
 30,21,15,25,340,289,316,381,443,389,422,370,402,336,345,
 366,424,392,346,362,411,368,385,338,371,249,834,985,811,
 978,968,1451],
 [26,16,14,29,33,17,39,20,27,36,31,42,32,35,38,18,34,23,
 30,21,15,25,340,289,316,381,421,443,389,370,402,336,345,
 366,428,424,392,411,409,377,368,393,385,338,249,1120,943,
 906],
 [26,16,14,29,33,17,39,20,36,31,42,32,28,38,18,23,21,15,
 340,289,316,394,381,375,443,389,407,432,370,360,402,336,
 345,429,366,332,424,392,313,355,362,363,411,409,377,419,
 368,327,385,338,354,283,249,236],
 [26,16,14,29,33,39,20,36,31,42,32,28,19,38,18,23,21,15,
 340,289,372,316,394,381,375,389,407,432,370,360,402,336,
 347,345,429,366,332,392,313,355,362,363,411,409,423,377,
 419,368,327,338,354,283,249,236],
 [26,16,14,29,33,39,20,36,31,42,32,28,38,18,23,30,21,15,
 340,289,372,316,394,381,375,443,389,407,370,360,402,336,
 347,345,429,366,332,424,392,313,362,363,411,409,423,377,
 419,368,327,385,338,354,249,236],
 [26,16,14,33,17,20,27,36,31,42,32,35,28,19,38,18,34,23,
 30,21,15,25,50,61,97,53,108,63,84,103,54,78,90,80,68,
 193,234,200,253,267,663,701],
 [26,16,14,33,17,20,27,36,31,42,32,35,28,19,38,18,34,23,
 30,21,15,25,50,61,97,89,53,108,63,84,103,54,78,90,80,
 68,193,234,200,253],
 [26,16,14,33,17,20,27,36,31,42,32,35,28,19,38,18,34,23,
 30,21,15,25,340,282,289,339,316,389,402,352,336,395,345,
 366,392,362,411,433,409,387,377,368,338,249,1330,818,1012,
 831,1172,934],
 [26,16,14,33,20,27,36,31,42,32,35,28,19,38,18,34,23,30,
 21,15,25,340,282,289,372,339,316,389,402,352,336,347,395,
 345,366,392,362,411,433,409,423,387,377,368,338,249,1330,
 818,1012,831,1172,934],
 [26,16,14,33,20,36,31,32,28,19,38,18,21,15,50,61,88,104,
 84,78,87,80,98,289,372,339,394,407,336,347,395,429,313,
 363,409,423,387,419,354,236,229,280,260,262,495,500,496,
 441,518,493,503,489,485,447,505,525,571,620,532,514,462,
 470,502,516,566,615,837,826,891,1139,1059,1082,1094,1092,
 1005,2200,2171,2046,1956,2052,2100],
 [26,16,14,33,39,20,36,31,32,28,19,21,15,50,61,88,53,104,
 83,108,63,84,78,98,62,68,289,372,394,376,422,407,360,
 336,347,429,344,346,313,363,317,371,354,236,234,201,253,
 192,500,496,513,518,493,489,485,487,505,525,499,502,516,
 834,1033,1726,811,840,1658,968,964,1748,1110,2450,1117,
 2350,1185,2307],
 [26,16,14,39,20,36,31,32,28,19,38,18,21,15,61,97,100,104,
 101,84,60,87,98,340,353,316,432,370,402,312,345,392,355,
 362,411,405,377,338,283,249,203,187,430,501,500,496,536,
 598,466,506,489,485,473,505,525,581,478,517,514,462,523,
 502,516,587,1293,1276,1353,1091,1555,1156,1454,1126,1511,
 1065,1526,1154,1348,1194,2217,1184,2287,1242,2556,2967,3905,
 3217,3890,3548,4228],
 [26,16,17,39,37,31,42,19,38,40,23,30,21,13,67,61,85,71,
 107,75,90,91,99,52,340,289,353,421,360,402,332,428,411,
 409,405,327,393,354,227,250,228,490,430,500,397,496,554,
 458,533,466,507,426,563,478,514,417,523,529,456,587,777,
 758,740,991,841,1197,1134,1066,1150,1224,1386,1581,1550,
 1677,1567,1501,1642,1637,1514,1464,1617,1562,1746,1557,3114,
 3096,4806,3345,3679,3430,3733,3116,3048,3229,3628,4437,3703,
 3727,2620,3571,3337,2907,3323,3694,9030,6899,6517,6815,7731,
 6423,7818,9070,6673,6806,6916,7514,8275,6082,7214,6231,6086,
 6129],
 [26,16,22,24,17,27,31,41,35,40,34,23,30,61,94,105,95,101,
 84,78,91,70,106,99,57,252,353,339,326,369,376,370,365,
 312,395,333,367,344,362,373,405,387,374,380,249,350,308,
 349,397,455,594,614,583,602,412,427,579,608,586,590,417,
 459,595,621,576,577,2426,2658,2596,1305,1377,1274],
 [26,16,22,24,17,27,31,41,35,40,34,23,30,67,82,79,94,95,
 101,107,78,87,106,93,57,282,384,326,481,421,422,370,352,
 425,333,521,428,346,362,433,444,374,491,393,249,272,322,
 319,594,614,526,469,583,602,579,608,474,449,586,590,595,
 621,535,442,576,577,1129,1260,1157,1253,1230,1147],
 [26,16,22,24,33,17,37,20,27,31,41,32,28,40,18,34,23,30,
 13,15,25,252,282,339,326,369,375,443,376,410,365,352,395,
 333,367,332,424,373,433,387,374,380,327,385,317,341,1310,
 1302,1324,1438,1385,1439],
 [26,16,22,24,33,17,37,20,27,31,41,32,35,28,19,40,18,34,
 23,30,13,15,25,67,61,79,85,88,77,107,84,54,75,87,93,
 49,244,214],
 [26,16,22,24,33,17,37,20,27,31,41,32,35,28,19,40,18,34,
 23,30,13,15,25,67,61,85,88,77,64,107,84,54,75,87,93,
 49,193,200],
 [26,16,22,24,33,17,37,20,27,31,41,32,35,28,19,40,18,34,
 23,30,13,15,25,252,282,339,326,369,376,410,365,352,395,
 333,367,344,399,373,433,387,374,380,317,341],
 [26,16,22,24,33,17,37,20,27,41,32,35,28,19,40,18,34,23,
 30,13,15,25,67,61,79,85,92,88,77,107,84,54,75,65,87,
 93,49,244,214],
 [26,16,22,24,33,17,37,20,27,41,32,35,28,19,40,18,34,23,
 30,13,15,25,67,61,85,92,88,77,107,84,54,75,65,87,93,
 49,193,244,200,214],
 [26,16,22,24,33,17,37,20,27,41,32,35,28,19,40,18,34,23,
 30,13,15,25,252,282,339,326,492,369,376,410,365,352,333,
 520,367,344,399,373,433,387,374,484,380,317,341,970,916,
 909],
 [26,16,22,24,33,17,37,36,31,35,28,19,34,23,13,25,61,105,
 69,89,66,71,74,96,60,99,52,252,339,369,376,389,432,410,
 395,344,392,355,399,387,317,338,283,341,261,597,513,518,
 453,505,448,610,502,454,927,1174,832,1013,821,1323,1072,
 1240,1057,1244,1163,1202],
 [26,16,22,24,33,17,37,36,31,35,28,19,34,23,13,25,105,69,
 84,90,91,52,252,339,369,376,389,432,410,395,344,392,355,
 399,387,317,338,283,341,350,565,500,397,614,597,554,458,
 543,489,412,507,426,557,517,514,417,529,456,553,927,1174,
 832,1013,821,1323,1663,1506,1444,1243,1541,1180,2081,2074,
 2471,1141,1935,2038,2490,1132,2155,2166,2304,5224,5164,4795,
 5497,5423,5146],
 [26,16,22,24,33,17,39,37,27,36,31,42,41,35,28,19,38,40,
 34,21,13,25,252,282,384,481,422,408,432,541,365,352,425,
 521,346,337,355,476,373,433,444,371,286,283,472,2299,2305,
 2169],
 [26,16,22,24,33,17,39,37,27,36,31,42,41,35,28,19,38,40,
 34,30,21,13,25,252,282,384,481,422,408,541,365,352,425,
 521,346,337,476,373,433,444,491,371,286,472],
 [26,16,22,29,17,37,20,36,41,32,28,19,18,23,30,13,67,82,
 79,77,64,74,107,56,54,93,49,52,289,375,336,429,520,392,
 313,363,419,484,327,272,269,430,451,441,536,624,545,447,
 473,625,426,413,487,483,512,581,555,468,463,587,1263,1073,
 1530,1186,1067,1393,2350,3825,3413,3959,4077],
 [26,16,22,29,17,37,20,36,41,32,28,19,18,23,30,13,97,69,
 92,53,55,101,103,60,65,80,81,57,252,353,339,376,410,541,
 367,399,476,380,317,216,258,501,496,597,526,469,619,511,
 479,579,608,487,610,519,510,605,535,442,576,577,1392,1250,
 969,1415,1295,1019,1703,3030,2909,3110,2869],
 [26,16,22,29,17,37,36,31,41,32,28,19,18,23,13,15,67,79,
 77,53,83,64,107,54,93,80,62,49,289,353,375,425,429,313,
 363,444,419,327,236,266,306,490,430,501,624,545,511,473,
 507,426,581,555,535,463,777,1303,1871,1237,1872,1096,1250,
 1147,1295,1386,1581,2217,1527,1719,1637,1514,1735,1535,2025,
 2059,2773,3010,3186,2675,2620,3873,2907,4060,4318,4508],
 [26,16,22,29,17,37,36,31,41,32,28,19,18,23,13,15,67,79,
 88,83,64,107,54,87,62,49,289,353,375,425,429,313,363,
 444,419,327,236,251,201,235,192,490,430,624,493,540,447,
 473,507,426,581,462,548,470,463,777,1303,1871,1237,1872,
 905,1102,1156,951,1017,1100,1154,917,1386,1581,1721,1553,
 1637,1514,1659,1589,2025,2059,2518,2903,2837,2561,2789,2893,
 2620,3051,2907,3104,5476,6035],
 [26,16,22,29,17,37,36,31,41,32,28,19,18,23,13,15,97,82,
 105,69,76,101,103,56,96,60,86,57,252,339,376,389,432,
 410,395,367,355,399,317,338,331,311,501,597,531,509,522,
 612,579,487,512,610,548,470,566,576,927,1174,1013,821,867,
 1095,848,1080,2253,1820,1719,1739,2036,1543,3266,3158],
 [26,16,22,29,24,17,20,27,36,31,41,32,35,28,19,40,18,34,
 23,30,13,25,252,353,339,316,369,376,365,312,395,345,367,
 344,399,476,373,405,387,377,380,317,341,472,1613,1271,
 1833,1281,1645,1566],
 [26,16,22,29,24,17,20,27,36,41,32,35,28,19,40,18,34,23,
 30,13,15,25,252,353,339,316,492,369,376,365,520,367,344,
 399,373,405,387,377,484,380,317,341,1613,1928,970,1371,
 1871,916,1331,1645,1872,909,1314,2446,2369,2306],
 [26,16,22,29,24,17,37,20,27,36,31,41,32,35,28,19,40,18,
 34,23,13,25,252,353,339,369,376,432,410,541,365,312,395,
 367,344,355,399,476,373,405,387,317,283,341,472,1174,1013,
 1323],
 [26,16,22,29,24,17,37,20,27,36,31,41,32,35,28,19,40,18,
 34,23,30,13,25,67,82,79,77,64,74,107,56,54,87,93,49,
 52,272,269],
 [26,16,22,29,24,17,37,20,27,36,31,41,32,35,28,19,40,18,
 34,23,30,13,25,252,353,339,369,376,410,541,365,312,395,
 367,344,399,476,373,405,387,380,317,341,472],
 [26,16,22,29,24,17,37,20,27,36,31,41,32,35,28,19,40,18,
 34,23,30,25,252,353,339,369,376,410,370,541,365,312,395,
 367,344,399,362,476,373,405,387,380,341,249,472,2426,2658,
 2596],
 [26,16,22,29,24,17,37,27,36,31,41,32,35,28,19,40,18,34,
 30,13,25,67,82,79,105,77,104,64,74,107,56,54,96,87,98,
 49,52,272,251,269,235],
 [26,16,22,29,24,17,37,27,36,31,41,32,35,28,19,40,18,34,
 30,13,25,67,82,79,105,88,64,107,56,54,96,87,93,98,52,
 322,320,227,319,303,250,325,922,980],
 [26,16,22,29,24,33,17,20,27,36,41,32,28,19,40,18,34,23,
 30,13,15,25,252,339,316,492,369,375,376,365,520,367,332,
 399,373,387,377,484,380,327,317,341,1613,970,1371,1310,
 916,1331,1324,1645,909,1314,1385,2446,2369,2306],
 [26,16,22,29,24,33,17,20,27,36,41,32,35,28,19,40,18,34,
 23,30,13,15,25,67,79,94,92,88,64,107,54,78,65,87,93,
 49,322,319],
 [26,16,22,29,24,33,17,20,27,36,41,32,35,28,19,40,18,34,
 23,30,13,15,25,67,79,94,92,88,77,107,54,78,65,87,93,
 49,244,214],
 [26,16,22,29,24,33,17,20,27,36,41,32,35,28,19,40,18,34,
 23,30,13,15,25,252,339,316,492,369,376,365,520,367,344,
 399,373,387,377,484,380,317,341,1613,970,1371,916,1331,
 1645,909,1314,2446,2369,2306],
 [26,16,22,29,24,33,17,20,27,36,41,35,28,19,40,18,34,23,
 30,13,15,25,252,339,316,492,369,481,376,365,520,367,521,
 344,399,373,387,377,484,380,491,317,341,1613,970,1371,916,
 1331,1645,909,1314,2446,2369,2306],
 [26,16,22,29,24,33,17,20,27,41,32,35,28,19,40,18,34,23,
 30,13,15,25,67,79,94,85,92,88,77,107,54,78,75,65,87,
 93,49,244,214],
 [26,16,22,29,24,33,17,20,27,41,32,35,28,19,40,18,34,23,
 30,13,15,25,67,79,94,85,92,88,107,54,78,75,65,87,93,
 49,322,244,319,214],
 [26,16,22,29,24,33,17,20,27,41,32,35,28,19,40,18,34,23,
 30,13,15,25,252,339,316,326,492,369,376,365,333,520,367,
 344,399,373,387,377,374,484,380,317,341,1613,970,1371,916,
 1331,1645,909,1314,2446,2369,2306],
 [26,16,22,29,24,33,17,20,36,41,32,35,28,19,40,18,34,23,
 30,13,15,25,252,339,316,394,492,369,376,520,367,344,399,
 373,387,377,419,484,380,317,341,1613,904,970,1371,1752,
 916,1331,1770,1645,1118,909,1314,1755,2446,4243,2369,4362,
 2306,4325],
 [26,16,22,29,24,33,17,27,36,41,32,35,28,19,40,18,34,23,
 30,13,15,25,67,79,94,105,92,88,64,107,54,78,96,65,87,
 93,49,322,319],
 [26,16,22,29,24,33,17,27,36,41,32,35,28,19,40,18,34,23,
 30,13,15,25,67,79,94,105,92,88,107,54,78,96,65,87,93,
 49,322,244,319,214],
 [26,16,22,29,24,33,17,27,36,41,32,35,28,19,40,18,34,23,
 30,13,15,25,252,339,316,384,492,369,376,365,520,367,344,
 399,373,387,377,444,484,380,317,341,1613,970,1371,1540,
 916,1331,1519,1645,909,1314,1498,2446,2369,2306],
 [26,16,22,29,24,33,17,27,41,32,35,28,19,40,18,34,23,30,
 13,15,25,252,339,316,384,326,492,369,376,365,333,520,367,
 344,399,373,387,377,444,374,484,380,317,341,1613,970,1371,
 1540,916,1331,1519,1645,909,1314,1498,2446,2369,2306],
 [26,16,22,29,24,33,17,37,20,27,36,31,41,32,35,19,18,34,
 23,13,15,25,252,339,369,421,376,389,432,410,365,395,367,
 428,344,392,355,399,387,393,317,338,283,341,927,1174,832,
 1013,821,1323],
 [26,16,22,29,24,33,17,37,20,27,36,31,41,32,35,28,18,34,
 23,15,25,67,79,88,95,77,53,83,64,108,107,87,62,49,68,
 293,288,251,201,301,235,192,762,785],
 [26,16,22,29,24,33,17,37,20,27,36,31,41,32,35,28,19,18,
 23,13,15,25,252,339,369,376,389,407,432,410,365,395,367,
 344,392,313,355,399,317,338,354,283,341,927,1339,1174,832,
 1297,1013,821,1288,1323],
 [26,16,22,29,24,33,17,37,20,27,36,31,41,32,35,28,19,18,
 34,13,15,25,67,79,88,77,53,104,83,64,107,54,87,98,62,
 49,251,201,235,192],
 [26,16,22,29,24,33,17,37,20,27,36,31,41,32,35,28,19,18,
 34,13,15,25,67,79,88,77,53,104,83,64,107,54,98,62,49,
 266,251,201,235,192,697,664],
 [26,16,22,29,24,33,17,37,20,27,36,31,41,32,35,28,19,18,
 34,13,15,25,252,339,369,376,389,408,432,410,365,395,367,
 344,392,337,355,399,387,317,338,286,283,341,927,1174,832,
 1013,821,1323],
 [26,16,22,29,24,33,17,37,20,27,36,31,41,32,35,28,19,18,
 34,23,13,15,25,67,79,88,77,53,83,64,107,54,87,62,49,
 251,201,235,192],
 [26,16,22,29,24,33,17,37,20,27,36,31,41,32,35,28,19,18,
 34,23,13,15,25,67,79,88,77,53,83,64,107,54,93,80,62,
 49,266,306],
 [26,16,22,29,24,33,17,37,20,27,36,31,41,32,35,28,19,18,
 34,23,13,15,25,252,339,369,376,389,432,410,365,395,367,
 344,392,355,399,387,317,338,283,341,927,1174,832,1013,821,
 1323],
 [26,16,22,29,24,33,17,37,20,27,36,31,41,32,35,28,19,18,
 34,23,13,25,252,339,369,376,389,432,410,541,365,395,367,
 344,392,355,399,476,387,317,338,283,341,472,927,1174,832,
 1013,821,1323],
 [26,16,22,29,24,33,17,37,20,27,36,31,41,32,35,28,19,34,
 13,15,25,252,339,369,376,389,422,408,432,410,365,395,367,
 344,392,346,337,355,399,387,317,338,371,286,283,341,927,
 1174,832,1013,821,1323],
 [26,16,22,29,24,33,17,37,20,27,36,31,41,32,35,28,19,34,
 23,13,15,25,67,79,88,77,53,71,83,64,107,54,62,49,266,
 251,201,276,235,192,209,697,664],
 [26,16,22,29,24,33,17,37,20,27,36,31,41,32,35,28,19,34,
 23,13,15,25,67,79,88,77,53,71,83,64,107,54,93,80,99,
 62,49,266,306],
 [26,16,22,29,24,33,17,37,20,27,36,31,41,32,35,28,19,34,
 23,13,15,25,252,339,369,376,389,422,432,410,365,395,367,
 344,392,346,355,399,387,317,338,371,283,341,927,1174,832,
 1013,821,1323],
 [26,16,22,29,24,33,17,37,20,36,31,41,32,35,28,19,40,18,
 34,23,30,13,15,67,79,69,88,77,64,101,107,54,60,87,93,
 49,57],
 [26,16,22,29,24,33,17,37,27,36,31,41,32,35,28,19,40,18,
 34,13,15,252,339,384,369,376,408,432,410,360,365,395,425,
 367,344,337,355,399,363,373,387,317,286,283,236,1068,1174,
 3726,996,1013,3642,1484,1323,3645],
 [26,16,22,29,24,33,17,37,27,36,31,41,32,35,28,19,40,18,
 34,30,13,15,25,67,79,105,88,64,107,54,96,87,93,98,49,
 322,320,319,303],
 [26,16,22,29,24,33,17,37,27,36,31,41,32,35,28,19,40,18,
 34,30,13,15,25,252,339,384,369,376,408,410,365,395,425,
 367,344,337,399,373,387,444,380,317,286,341],
 [26,16,22,29,24,33,17,37,36,31,41,32,35,28,19,40,18,34,
 30,13,15,25,252,339,384,394,369,376,408,410,395,425,429,
 367,344,337,399,373,387,444,419,380,317,286,341,904,929,
 1118],
 [26,16,22,29,24,33,20,27,36,32,35,28,19,40,18,34,23,30,
 13,15,25,67,100,79,94,77,107,72,54,78,65,87,90,93,49,
 240,272,307,207,269,267,214,720,710],
 [26,16,22,29,24,33,20,27,36,32,35,28,19,40,18,34,23,30,
 13,15,25,67,100,79,94,92,88,89,64,72,54,78,65,87,90,
 93,49,322,264,319,281],
 [26,16,22,29,24,33,37,27,36,31,41,32,35,28,19,40,18,34,
 30,13,15,25,252,372,339,384,369,410,365,347,395,425,367,
 344,337,399,373,423,387,444,380,317,286,341,1433,976,973,
 813,982,835],
 [26,16,22,29,24,37,20,27,36,31,41,32,35,28,19,40,18,34,
 23,30,13,25,67,82,100,79,77,64,74,107,56,72,54,87,93,
 49,52,272,269],
 [26,16,22,29,24,37,20,27,36,31,41,32,35,28,19,40,18,34,
 23,30,13,25,252,353,372,339,369,410,541,365,312,347,395,
 367,344,399,476,373,405,423,387,380,317,341,472,1433,973,
 982],
 [26,16,22,29,24,37,20,27,36,31,41,32,35,28,19,40,18,34,
 23,30,25,252,353,372,339,369,410,370,541,365,312,347,395,
 367,344,399,362,476,373,405,423,387,380,341,249,472,1433,
 2426,973,2658,982,2596],
 [26,16,22,29,33,17,27,36,31,41,32,35,28,19,40,18,34,30,
 13,15,25,67,97,79,94,105,88,64,107,103,54,78,96,87,93,
 98,49,322,320,319,303],
 [26,16,22,29,33,17,36,31,41,32,28,19,40,18,13,15,67,79,
 105,88,64,107,54,96,87,49,289,316,375,407,429,313,355,
 363,419,283,236,322,320,319,303,430,592,624,567,547,493,
 473,426,504,544,571,581,550,532,462,497,463,480,1219,1362,
 1205,1267,1392,1217,1223,1070,1273,1415,1474,1783,1753,1604,
 1896,1712,3193,2601,3381,2946,2878,3331],
 [26,16,22,29,33,17,36,31,41,32,28,19,40,18,13,15,97,94,
 69,76,83,101,103,78,60,86,62,57,252,339,376,408,395,425,
 367,399,373,317,286,203,187,490,501,594,597,531,549,533,
 506,473,579,507,487,586,610,548,568,529,499,576,907,1119,
 1089,946,1060,1103,1901,2571,2730,2520,2834],
 [26,16,22,29,33,17,36,31,41,32,28,19,40,18,13,15,97,94,
 69,76,83,101,103,78,60,86,62,57,252,339,376,408,395,425,
 367,399,373,317,286,331,311,490,501,594,597,531,522,549,
 533,506,579,507,487,586,610,548,568,529,499,463,576,867,
 1304,848,1214,1820,1814,3625,3678],
 [26,16,22,29,33,17,37,20,27,36,31,41,32,35,28,19,40,18,
 23,30,13,15,25,67,97,79,88,77,55,64,107,103,54,87,93,
 81,49],
 [26,16,22,29,33,17,37,20,27,36,31,41,32,35,28,19,40,18,
 23,30,13,15,25,252,289,339,376,407,410,365,336,395,367,
 344,313,399,373,380,317,354,341,1621,834,1339,1569,811,
 1297,968,1288,2333,2303,2354],
 [26,16,22,33,17,37,20,27,31,41,32,35,28,19,40,18,34,23,
 30,13,15,25,252,282,289,339,376,410,365,352,336,395,333,
 367,344,399,373,433,409,387,374,380,317,341,1475,1621,
 1468,1569,1463,1807],
 [26,16,22,33,17,37,20,27,36,31,41,32,35,28,19,40,23,30,
 13,15,25,252,282,289,339,376,422,407,410,365,352,336,395,
 367,344,346,313,399,373,380,317,371,354,341,1621,791,834,
 1339,1569,838,811,1297,846,968,1288,2333,2303,2354],
 [26,16,22,33,17,37,20,31,41,32,28,40,18,23,30,15,67,61,
 79,85,88,77,107,84,54,75,87,93,289,407,336,313,362,363,
 419,327,385,249,236,244,214,430,496,530,606,624,458,493,
 564,545,426,525,534,586,620,581,478,462,552,555,576,1577,
 981,1591,931,2342,2090,5858,5381],
 [26,16,22,33,17,37,20,31,41,32,28,40,18,23,30,15,67,61,
 85,88,77,64,107,84,75,87,93,49,289,407,336,313,362,363,
 419,327,385,249,236,193,200,430,496,530,458,493,564,545,
 473,426,525,534,478,462,552,555,442,463,1870,1003,1158,
 1039,1897,1074,1249,1002,2126,2505,8058,3857,4418,3629,5395,
 4159,5213,3390],
 [26,16,22,33,17,37,27,36,41,35,28,19,40,23,13,25,61,105,
 92,66,71,83,74,84,96,65,91,99,62,52,252,289,339,376,
 407,410,365,367,344,313,399,373,317,354,341,567,469,506,
 550,510,499,1621,834,1339,811,1297,968,1288,1585,1594,2333,
 2303,2354],
 [26,16,22,33,17,39,37,27,36,31,42,41,35,28,19,38,40,34,
 30,21,13,25,252,282,289,384,422,408,541,365,352,336,425,
 521,346,337,476,373,433,409,444,491,371,286,472,2449,2393,
 2414],
 [26,16,24,33,17,20,27,32,35,34,23,30,15,25,67,85,92,88,
 77,71,107,93,99,49,340,282,421,443,389,402,352,428,424,
 392,368,393,385,249,244,212,243,266,299,290,306,467,495,
 469,547,518,585,572,479,503,449,538,593,591,442,539,468,
 803,820,1330,1120,1012,943,906,993,945,1208,1171,949,1235,
 1261,2117,2053,1481,2264,2047,1702,2126,2704,2668,4312,4702]
  ,[26,16,24,33,17,27,36,31,42,32,35,28,19,38,18,34,23,
 30,21,15,25,67,50,61,89,108,107,63,84,54,78,96,90,80,
 68,193,234,300,200,253,287,295,784,765],
 [26,16,24,33,17,27,36,41,35,28,19,40,34,23,30,13,50,61,
 66,74,101,63,84,96,91,99,52,57,252,492,369,376,365,520,
 367,344,399,373,387,377,484,380,317,300,287,467,495,579,
 449,538,559,576,970,1371,916,1331,1645,909,1314,1343,1444,
 2083,2283,2205,2356,1961,2446,2369,2306],
 [26,16,24,33,17,37,20,27,31,41,32,35,28,19,40,18,34,23,
 30,13,15,25,67,50,61,85,88,77,64,107,63,84,54,75,87,
 93,49,193,200],
 [26,16,24,33,17,37,20,27,31,41,32,35,28,19,40,18,34,23,
 30,13,15,25,67,50,61,85,88,77,107,63,84,54,75,87,93,
 49,193,244,200,214],
 [26,16,24,33,17,37,20,27,31,41,32,35,28,19,40,18,34,23,
 30,13,15,25,252,340,282,326,369,376,410,365,402,352,395,
 333,367,344,399,373,411,433,387,374,380,317,341,1893,1907,
 1876],
 [26,16,24,33,17,37,20,27,41,32,35,28,19,40,18,34,23,30,
 13,15,25,252,340,282,326,492,369,376,410,365,402,352,333,
 520,367,344,399,373,411,433,387,374,484,380,317,341,1893,
 970,1907,916,1876,909],
 [26,16,24,33,17,39,37,27,36,31,42,41,35,28,19,38,40,34,
 23,30,21,13,67,50,61,66,71,74,101,107,63,84,96,91,99,
 52,57,300,287],
 [26,16,24,33,17,39,37,27,36,31,42,41,35,28,19,38,40,34,
 30,21,13,25,252,340,282,481,422,408,541,365,402,352,425,
 521,346,337,476,373,411,433,444,491,371,286,472,2560,2525,
 2439],
 [26,16,24,33,20,27,31,32,35,28,19,18,34,23,30,15,50,53,
 108,101,63,72,78,90,80,68,57,252,282,326,369,365,352,
 395,344,399,387,374,380,267,551,467,495,619,572,560,503,
 540,579,449,504,586,494,517,605,591,497,576,1403,1741,
 1208,1171,1255,1186,1665,1235,1885,2083,1787,1964,3340,3593,
 3924,3724,2734,4163,3852,3596,2607,3608,4587,8015,4521,7913]
  ,[26,16,24,33,37,20,27,36,31,41,32,35,28,19,40,18,34,
 23,30,13,15,25,67,50,61,77,64,107,63,84,72,54,87,93,
 49,208,193,277,200,269,870,914],
 [26,16,24,33,37,20,27,36,31,41,32,35,28,19,40,18,34,23,
 30,13,15,25,67,50,61,88,77,64,107,63,84,72,54,87,93,
 49,208,193,277,200],
 [26,16,24,33,37,20,27,36,31,41,32,35,28,19,40,18,34,23,
 30,13,15,25,252,340,282,369,410,365,402,352,347,395,367,
 344,399,373,411,433,423,387,380,317,341,1148,1893,1248,
 1907,973,1115,1876,982,1811,1867,1834],
 [26,16,24,33,37,27,36,31,41,35,28,19,40,23,30,25,67,50,
 64,72,54,93,282,481,370,541,352,425,521,346,313,362,476,
 433,491,249,472,269,551,467,490,597,596,583,560,479,540,
 617,582,487,557,512,586,546,510,605,593,576,1129,1327,996,
 1260,1427,1157,1341,1183,905,1096,1186,1213,1981,1473,1849,
 1586,2144,1527,1832,1693,1641,1485,1944,1509,1890,1543,1866,
 1917,1844,3724,3080,3596,2856,2697,3439,2607,5529,8083,4983,
 9320,5841,6293,8850,6202,8023],
 [26,16,24,33,37,27,36,31,41,35,28,19,40,23,30,25,67,50,
 88,77,64,107,63,72,54,87,93,282,481,370,541,352,425,521,
 346,313,362,476,433,491,249,472,208,193,277,200,490,583,
 507,557,512,586,576,1129,1327,996,1260,1427,1157,1341,1343,
 907,1444,946,1641,1866,1917,1844,2720,2814],
 [26,16,24,33,37,27,36,31,41,35,28,19,40,23,30,25,105,71,
 55,84,68,52,252,340,369,410,365,402,347,395,367,344,399,
 373,411,380,341,206,565,606,614,543,522,572,560,479,412,
 618,608,507,557,512,573,600,621,497,553,463,1148,1893,
 1248,1907,973,1115,1876,937,1290,910,1204,886,1579,1777,
 1958,1820,1628,1787,1402,1742,2188,1739,1584,1736,1982,1814,
 1811,1867,1834,3488,3037,2771,3304,2890,3552,2609,8339,5953,
 6958,4958,8079,5378,7398,6344,6379],
 [26,16,24,37,20,27,36,31,41,32,35,28,19,40,18,34,23,30,
 13,15,25,252,340,282,369,410,365,402,352,312,347,395,367,
 344,399,373,411,433,405,423,387,380,317,341,1357,1148,
 1893,1434,1248,1907,973,1325,1115,1876,982,1811,1867,1834],
 [26,16,29,17,20,31,41,32,19,30,67,50,59,71,107,63,99,52,
 289,353,316,375,370,336,312,345,392,313,337,338,286,249,
 193,227,293,221,200,250,220,430,515,501,537,461,583,609,
 598,466,524,506,540,426,488,487,504,494,456,498,499,497,
 576,587,762,785,1293,777,976,989,985,1276,975,813,977,978,
 1471,1353,835,779,1451,1472,995,1003,1104,1134,1326,2267,
 1098,1955,1025,1071,1074,1061,1066,1140,1937,1051,1210,1180,
 2217,1703,1674,1283,1244,1685,2106,1195,1141,2287,1688,1721,
 1226,1163,2350,1693,1474,1176,1132,1684,1259,1202,2307,1691,
 1604,2090,4065,5453,4026,4536,8690,2072,7964,2027,7865,2049,
 2732,3179,4478,2805,3226,2804,3206,5368,5372,5997,5266,6025,
 5975,4976,5631,5832,5357,5036,5664,8640,7059],
 [26,16,29,24,17,20,36,31,32,35,28,19,18,34,30,15,67,79,
 69,88,77,64,101,107,54,60,87,93,49,57,340,381,402,312,
 345,392,337,362,405,377,249,464,495,606,518,585,447,527,
 474,538,620,514,593,468,480,1276,813,1564,1353,835,1821,
 1599,1462,1899,1717,1497,2300,2385,4838,5833],
 [26,16,29,24,33,17,20,27,36,31,28,19,18,34,15,25,67,50,
 79,94,88,89,66,76,77,53,104,83,64,108,54,78,87,90,91,
 86,98,62,49,68,264,215,251,201,281,245,235,192],
 [26,16,29,24,33,36,31,28,19,18,34,23,15,25,50,100,94,108,
 72,78,90,91,86,68,252,384,394,369,395,425,429,355,399,
 387,444,419,283,341,307,291,298,267,238,213,245,467,537,
 441,592,594,540,447,504,483,571,586,517,548,470,497,468,
 824,802,904,929,1013,1118,1323,1263,1219,948,1186,1217,952,
 1002,2094,1713,2042,2290,1485,2036,2122,2724,2699,4872,4498]
  ,[26,16,29,24,33,37,20,27,36,31,41,32,35,28,19,40,18,
 34,23,30,13,15,25,67,50,88,77,64,107,63,72,54,87,93,
 49,208,193,277,200],
 [26,16,29,24,33,37,20,27,36,31,41,32,35,28,19,40,18,34,
 23,30,13,15,25,67,50,100,79,77,64,107,63,72,54,87,93,
 49,272,269],
 [26,16,29,24,33,37,20,27,36,31,41,32,35,28,19,40,18,34,
 23,30,13,15,25,252,340,369,410,365,402,347,395,367,344,
 399,373,411,423,387,380,317,341,1148,1893,1248,1907,973,
 1115,1876,982,1811,1867,1834],
 [26,16,29,24,33,37,27,36,31,41,32,35,28,19,40,18,34,23,
 30,13,15,25,252,340,369,410,365,402,347,395,425,367,344,
 399,373,411,423,387,444,380,317,341,1148,1893,2560,1248,
 1907,2525,973,1115,1876,2439,982,1811,1867,1834],
 [26,16,29,24,37,20,27,36,31,41,32,35,28,19,40,18,34,23,
 30,13,15,25,67,50,77,64,107,63,56,72,54,87,93,49,186,
 208,193,202,277,200,269,870,914],
 [26,16,29,24,37,20,27,36,31,41,32,35,28,19,40,18,34,23,
 30,13,15,25,67,50,82,100,79,77,64,107,63,56,72,54,87,
 93,49,272,269],
 [26,16,29,24,37,20,27,36,31,41,32,35,28,19,40,18,34,23,
 30,13,15,25,252,340,369,410,365,402,312,347,395,367,344,
 399,373,411,405,423,387,380,317,341,1357,1148,1893,1434,
 1248,1907,973,1325,1115,1876,982,1811,1867,1834],
 [26,16,29,33,17,27,36,31,32,35,28,18,34,30,15,25,50,97,
 94,89,95,108,63,90,106,80,68,252,376,408,365,395,344,
 337,387,444,380,341,302,318,321,323,467,490,501,594,554,
 513,583,540,527,449,563,517,470,595,605,497,480,1102,993,
 1190,1457,1326,1038,1274,1396,1367,2036,2606,2498,4974,4916,
 4831,7572,6198],
 [26,16,29,33,17,27,36,31,32,35,28,18,34,30,15,25,67,79,
 105,88,64,107,96,87,93,98,49,340,381,443,389,336,345,
 392,362,409,377,249,322,320,319,303,482,495,606,596,469,
 518,564,447,528,538,584,514,552,593,502,486,468,1354,1399,
 1296,1039,1322,1456,1189,1002,1103,2053,2542,2648,4418,5213,
 5138,9307,7062],
 [26,16,29,33,37,20,27,36,31,41,32,35,28,19,40,18,34,23,
 30,13,15,25,252,340,289,410,365,402,336,347,395,367,344,
 399,373,411,409,423,387,380,317,341,1148,1893,1621,1248,
 1907,1569,973,1115,1876,1807,982,1811,1867,1834],
 [26,16,29,33,37,20,36,31,41,32,19,40,23,30,13,15,67,50,
 88,77,64,107,63,87,93,49,289,375,421,422,407,336,429,
 346,313,327,393,236,208,193,277,200,430,558,469,493,477,
 545,561,473,426,462,459,555,569,442,553,463,758,1726,1658,
 841,1003,1542,1039,1074,1526,1002,2317,2010,1447,2236,2505,
 1414,3629,3390],
 [26,16,29,33,37,20,36,31,41,32,19,40,23,30,13,15,67,50,
 100,79,77,64,107,63,72,54,93,49,289,375,421,422,407,336,
 429,346,313,327,393,236,272,269,430,624,513,545,561,473,
 426,487,581,555,553,463,758,1726,1658,841,1073,1044,1530,
 1067,986,1393,2450,1167,1447,2350,1199,1414,4245,3413,2800,
 4794,4077,2688,3654,3707,6764,7105],
 [26,16,29,33,37,20,36,31,41,32,19,40,23,30,13,15,97,69,
 71,55,101,103,60,99,81,57,252,340,410,347,395,367,399,
 373,411,380,317,216,221,258,220,501,597,596,560,479,485,
 427,579,487,610,584,569,442,576,1148,1893,973,1115,1876,
 1250,1031,969,1295,1138,1019,1429,1409,1994,1765,1787,1688,
 1967,1816,1493,1418,1938,1811,1834,2943,3183,2909,2933,3468,
 2869,5580,4796,4829,5756,6900,6947],
 [26,16,33,17,20,27,32,35,28,19,18,34,23,30,15,25,67,50,
 61,97,85,92,88,89,77,53,107,63,84,103,54,78,75,65,87,
 90,93,80,49,68,193,234,244,280,200,253,214,262],
 [26,20,28,18,15,51,67,50,61,100,79,89,66,95,77,53,55,104,
 108,73,107,84,103,56,72,54,78,90,86,80,98,62,49,68,57,
 279,186,234,298,215,255,212,243,266,206,288,251,294,202,
 253,223,217,207,269,213,239,301,235,187,959,644,700,870,
 714,803,674,712,807,635,901,697,1048,665,705,914,843,710,
 747,723,787,628,897,664,2271,1950,1995,1940,2454,2394,2464,
 2137,1976,2091,2119,2445,2383,2391,3671,4836,3641,4074],
 [26,20,32,18,51,50,61,69,85,89,76,55,104,108,63,84,103,
 60,86,68,52,57,252,410,312,344,373,405,341,208,229,248,
 212,221,288,203,292,382,294,277,250,246,273,187,278,314,
 441,469,547,450,506,540,447,449,538,483,452,517,442,539,
 497,468,1318,876,761,714,685,635,1029,900,853,747,776,882,
 628,961,806,1357,904,1434,973,929,1325,982,857,1277,1391,
 1263,1207,1296,945,1208,1098,1455,1530,1241,1383,1299,1186,
 848,1273,1138,1300,1448,1393,2917,3589,2454,2028,2914,2402,
 3364,2445,2099,1571,1495,1623,1600,1568,1743,1508,1593,1525,
 1594,1638,1494,2786,3483,4391,4257,2611,4106,4186,3020,3252,
 4562,4071,3244,3196,4329,4890,3489,4086,3839,4482,2972,4367,
 3772,3028,1811,2003,1867,1984,1834,2001,3558,3700,3572,3515,
 4022,3512,3253,3063,3339,3960,3553,3427,3603,3277,4191,3106,
 3272,8413,8877,8864,7779,7044,6882,7130,6762,8766,6940,6771,
 8128,6464,8811,6623,9094,7962,7500,8538,6950,8994,6537,8050,
 6836,7523,6144,8258,6255,7088,6645],
 [26,20,36,18,15,51,50,61,97,89,59,53,55,104,83,108,63,
 103,56,78,90,86,80,81,98,252,339,365,395,344,387,317,
 186,208,234,248,261,309,243,206,221,288,382,202,277,253,
 207,238,213,328,226,228,290,239,220,301,357,430,501,583,
 598,466,506,426,487,504,586,581,456,499,576,587,700,896,
 630,819,772,685,705,889,636,863,751,699,1524,832,821,905,
 995,1003,1104,1134,1098,1025,1017,1071,1074,1061,1066,1140,
 1051,3716,7915,1210,1180,1283,1244,1195,1141,1226,1163,1176,
 1132,1259,1202,2326,2323,2336],
 [26,20,36,28,15,51,50,61,89,66,95,77,53,71,55,104,83,108,
 73,84,103,56,72,78,86,80,98,62,49,68,57,356,186,208,
 193,234,264,215,293,255,243,266,270,206,288,251,276,434,
 202,277,200,253,223,207,269,239,301,235,209,187,1318,959,
 700,870,630,1084,912,803,674,707,712,762,807,901,697,919,
 1340,1048,705,914,636,710,747,717,723,785,787,897,664,872,
 1950,1995,1940,2270,2031,2394,2464,1976,2091,2119,2645,2177,
 2383,2391,3671,4836,3641,4074],
 [26,20,36,28,15,51,67,50,61,100,69,88,89,66,95,77,53,71,
 55,104,83,73,84,103,56,72,54,78,65,86,93,80,99,98,62,
 49,68,57,279,186,193,234,244,280,230,264,215,255,266,270,
 206,288,202,200,253,207,213,305,306,273,239,301,187,700,
 630,737,1084,803,733,674,707,712,705,636,820,760,693,717,
 723,1940,2270,2198,2645],
 [26,20,36,28,18,15,51,50,61,97,92,89,66,95,53,55,104,83,
 108,73,63,84,103,65,90,86,81,252,339,376,365,395,344,
 387,317,186,208,234,310,309,318,206,288,201,292,202,277,
 253,213,239,301,192,278,314,357,430,501,583,598,466,506,
 426,487,586,581,456,499,576,587,630,915,772,808,685,873,
 636,801,751,799,699,798,832,821,995,1003,1104,1134,1098,
 1025,1071,1074,1061,1066,1140,1051,1210,1180,1283,1244,1195,
 1141,1226,1163,1176,1132,1259,1202,2326,2323,2336],
 [26,20,36,28,18,15,51,50,61,97,100,92,89,66,76,95,77,53,
 55,104,83,108,63,103,56,72,78,60,65,87,90,91,86,106,80,
 81,98,62,49,68,57,356,186,193,234,222,272,244,230,248,
 264,261,293,251,202,253,223,269,214,246,226,281,228,358,
 235,750,742,769,718],
 [26,20,36,28,18,15,51,67,50,61,97,82,100,79,94,69,92,88,
 89,66,76,95,77,53,55,104,83,64,108,101,73,107,63,84,
 103,56,72,54,78,60,65,87,90,91,86,106,93,80,81,98,62,
 49,68,57],
 [26,20,36,28,18,51,61,97,100,92,66,95,53,55,104,83,73,84,
 103,65,90,86,81,62,52,252,339,376,365,395,387,317,324,
 186,234,307,280,227,215,310,309,318,206,288,201,292,406,
 202,253,213,262,250,239,301,192,278,357,430,501,531,583,
 598,466,506,426,487,586,581,456,499,576,587,630,772,859,
 712,808,685,873,636,751,723,799,699,798,832,821,995,1003,
 1104,1134,969,1098,1025,1071,1074,1061,1066,1019,1140,1051,
 2602,2397,1210,1180,1283,1244,1195,1141,1226,1163,1176,1132,
 1259,1202,2326,2323,2336],
 [26,20,36,32,28,18,23,51,67,50,61,82,100,79,89,95,77,53,
 55,83,64,108,74,73,107,63,84,103,56,72,54,78,90,86,106,
 93,62,49,52,279,234,222,240,272,298,255,243,266,201,203,
 437,386,294,253,223,207,269,213,305,290,306,192,187,357,
 343,761,674,747,693],
 [26,20,36,32,28,18,23,51,67,50,61,97,82,79,94,76,77,53,
 55,83,64,108,74,101,84,103,56,72,54,78,87,90,86,106,93,
 80,81,49,68,52,208,222,240,272,307,351,255,243,382,386,
 223,207,269,267,328,226,281,245,305,290,314,343,739,764,
 824,724,728,802,669,2030,1993],
 [26,22,24,33,20,27,41,32,28,40,18,34,23,13,15,25,67,61,
 79,85,88,107,84,54,75,87,93,49,471,375,443,475,332,424,
 355,423,377,484,283,244,214,551,495,451,592,558,547,416,
 562,538,413,571,546,532,452,548,613,516,486,905,1392,1296,
 1020,1017,1415,1189,885,1980,8986,4101,5274,4450],
 [26,22,24,39,37,20,27,36,42,41,32,35,28,38,40,18,34,23,
 21,13,15,25,471,252,282,432,475,365,352,312,347,520,424,
 355,542,373,433,405,423,484,385,283,1357,1148,2209,1434,
 1248,2250,992,1325,1115,2272,1069,1881,1912,1875],
 [26,22,24,39,37,27,36,42,41,28,38,34,23,21,13,25,51,67,
 82,100,95,83,73,107,56,72,106,62,384,481,375,541,352,
 521,332,444,338,371,472,240,207,565,441,570,602,412,485,
 611,483,557,621,396,454,516,913,1388,908,1364,846,1305,
 1391,1182,1299,1733,1373,1508,2360,1380,1905,1336,1494,2496,
 2419,2434,3159,3063,2538,3106,8263,4604,6613,4693,7999,7859]
  ,[26,22,24,39,37,27,36,42,41,28,38,34,23,21,13,25,61,
 105,53,71,74,84,96,80,99,52,471,252,432,312,347,520,355,
 542,373,484,385,206,216,239,258,451,622,597,511,560,412,
 485,612,413,603,610,535,569,566,1357,1148,992,1325,1115,
 1290,1250,1175,1369,1295,1300,1579,1429,2104,1994,1622,1306,
 2097,1967,1584,1493,1680,1881,1875,4351,2943,2553,3999,2933,
 3192,5995,3669,3185,4788,8728,6189],
 [26,22,24,39,37,27,36,42,41,28,38,34,23,21,13,25,105,66,
 76,53,71,74,96,91,86,80,99,52,471,252,432,312,347,520,
 355,542,373,484,385,261,228,565,622,597,564,511,560,612,
 603,610,573,552,535,569,566,1357,1148,992,1325,1115,1663,
 1416,1590,1445,1571,2104,1994,1622,2097,1967,1525,1680,1881,
 1875,2997,3069,3669,3185],
 [26,22,29,20,27,36,32,35,18,34,23,13,15,25,51,97,100,89,
 83,103,90,70,106,62,353,339,316,389,365,312,344,392,405,
 387,377,317,338,341,248,226,348,616,451,501,455,530,537,
 416,513,450,506,413,487,452,517,459,552,595,396,499,1613,
 927,832,1645,821,1555,1829,1842,1526,1269,1503,1697,2780,
 1627,1683,1572,1687,1529,1698,1598,1696,2412,1631,1711,2646,
 3188,3421,2885,3211,2683,3232,2494,3139,2685,3144,2962,2641,
 3289,4670,4199,4975,3690,5742,4009,7531,7973,6628,7536,6753,
 7436,8879,7961,6665,7166,6913,7268,8618,6708,7578,6678,6116,
 6142],
 [26,22,29,24,33,37,27,36,32,35,28,40,18,34,13,15,51,100,
 92,89,95,83,101,72,65,62,57,339,384,369,410,365,344,337,
 373,387,317,286,248,616,537,556,469,554,513,583,533,506,
 579,505,534,504,544,510,529,499,502,486,576,1143,1262,
 1829,1227,1087,1169,1218,1307,1163,2361,1336,1202,2222,2546,
 2539,3159,2508,4267,5296,2538,2584,4646,5450,7483,6610],
 [26,22,29,24,39,20,27,36,42,41,32,35,28,38,40,18,34,23,
 21,13,15,25,471,252,492,432,475,365,312,347,345,520,424,
 355,542,373,405,423,377,484,385,283,1357,1148,2535,1434,
 1248,2676,992,1325,1115,2453,1069,1881,1912,1875],
 [26,22,29,24,39,37,20,27,36,42,41,32,35,28,38,40,18,34,
 23,21,13,15,25,51,67,82,100,95,83,73,107,56,72,65,106,
 62,240,207],
 [26,22,29,24,39,37,20,27,36,42,41,32,35,28,38,40,18,34,
 23,21,13,15,25,471,252,492,432,475,365,312,347,520,424,
 355,542,373,405,423,484,385,283,1357,1148,1434,1248,992,
 1325,1115,1069,1881,1912,1875],
 [26,22,29,24,39,37,20,42,41,28,38,40,18,34,23,21,13,15,
 25,51,67,82,100,69,85,66,76,95,73,107,56,72,60,75,65,
 91,86,106,62,240,229,207,260],
 [26,22,29,33,17,37,20,27,36,31,41,32,35,28,40,18,23,30,
 13,15,25,471,289,339,443,376,407,410,475,365,336,395,367,
 424,344,313,373,380,385,317,354,341,3358,1621,1302,1558,
 834,1339,3507,1569,1438,1266,811,1297,1439,1286,968,1288,
 4999,2333,5097,2303,5068,2354],
 [26,22,29,33,37,27,36,41,32,35,28,40,18,23,13,25,51,100,
 105,92,95,83,74,73,72,96,65,106,62,52,289,339,410,365,
 367,344,313,373,317,354,341,616,537,536,567,469,583,506,
 617,504,512,550,510,595,499,1621,811,1297,968,1288,1674,
 1874,1585,1474,1739,1594,2303,2354,5821,4687],
 [26,22,29,39,37,20,27,36,42,41,32,35,28,38,40,18,34,23,
 21,13,15,25,471,252,289,492,432,475,365,336,312,347,520,
 424,355,542,373,409,405,423,484,385,283,1357,1148,1434,
 1248,992,1325,1115,1069,1881,1912,1875],
 [26,22,29,39,37,20,42,41,28,38,40,18,23,21,13,15,97,69,
 85,55,103,60,75,91,86,81,57,471,252,492,432,475,365,520,
 355,542,373,405,423,484,385,283,230,246,526,558,519,546,
 417,462,552,1357,1148,1434,1248,1325,1115,1069,1446,1392,
 1406,1415,1579,1429,1662,1628,1554,1584,1493,1720,1390,1881,
 1912,1875,4662,3367,5995,5331,4788],
 [26,23,51,50,61,97,100,94,69,92,89,76,53,55,83,101,73,63,
 103,72,60,65,90,86,106,80,99,81,62,252,353,339,326,369,
 376,365,333,367,344,373,405,387,374,380,317,300,351,350,
 261,206,221,386,287,228,323,239,220,397,455,594,606,614,
 609,579,618,608,620,417,459,595,600,621,615,925,1063,864,
 1670,822,1289,947,829,1500,1928,970,1871,916,1872,909,1305,
 1577,2108,1326,2503,1546,2740,1591,2054,1274,1367,2703,1556,
 2612,2984,2915,1410,1869,1387,1882,1382,1850,3488,3304,3552]
  ,[26,23,51,67,50,97,100,94,69,92,89,76,53,55,83,101,73,
 63,103,72,60,65,90,86,106,93,80,81,62,282,384,326,481,
 421,422,352,333,521,428,346,433,444,374,491,393,371,186,
 193,351,322,264,266,386,202,200,281,323,306,594,606,614,
 526,469,609,579,618,608,474,449,620,595,600,621,535,442,
 615,870,925,1063,1670,914,822,1289,923,1500,1540,1519,1498,
 1577,2108,1253,1326,2503,1546,2740,1230,1591,2054,1367,2703,
 1147,1556,2612,4911,4877],
 [26,24,33,39,20,27,32,38,34,21,15,51,67,61,85,92,88,71,
 104,107,84,75,87,99,98,340,421,389,370,360,402,428,392,
 411,393,338,249,236,229,216,288,260,258,301,551,495,500,
 558,547,416,518,574,560,503,489,562,538,413,505,546,532,
 514,569,539,396,502,566,1120,758,943,740,906,841,1699,
 1188,1111,1392,1296,1245,1250,1175,1137,1722,1383,1227,1415,
 1189,1116,1295,1300,1218,1837,1831,1715],
 [26,28,23,51,67,50,61,97,82,100,79,94,105,69,85,92,88,89,
 66,76,95,77,53,71,55,83,64,108,74,101,73,107,63,84,103,
 56,72,54,78,96,60,75,65,87,90,91,86,106,93,80,99,81,
 62,49,68,52,57],
 [26,28,23,51,67,50,82,100,79,105,69,85,89,95,77,73,107,
 84,103,56,72,54,78,65,87,91,86,106,93,52,57,315,279,
 240,272,291,298,359,350,331,229,244,280,329,255,212,383,
 294,253,207,269,238,213,250,246,245,349,305,299,314,325,
 357,877,876,761,824,794,716,668,737,1400,893,1042,714,803,
 733,938,853,747,802,801,980,751,1424,947,1054,721,820,760,
 792,932,1151,1785,2485,2509,1990,2956,2428,2004,1940,1801,
 2416,2472,2110,2565,2924,3029,2435,2069,2198,2269,5354,9225,
 5931,5673,3415,5681,4923,4834,4944,9005,5557],
 [26,28,23,51,67,50,97,82,100,69,85,88,89,95,55,83,64,108,
 103,56,72,54,78,60,75,65,87,90,62,49,68,57,282,384,425,
 476,433,444,472,193,234,240,230,248,264,215,288,203,200,
 253,207,246,226,281,245,301,187,397,496,537,441,570,453,
 493,531,509,543,412,485,540,447,561,448,525,504,483,557,
 417,462,548,470,559,454,516,497,468,553,1271,1321,1281,
 1282,1566,1236],
 [26,28,23,51,67,50,97,82,100,79,69,85,89,95,77,55,83,64,
 108,73,107,103,56,72,54,78,60,75,65,87,90,62,49,68,57,
 282,384,425,476,433,444,472,234,240,272,230,215,288,251,
 203,253,207,269,246,245,301,235,187,397,496,441,570,453,
 493,509,543,412,485,447,561,448,525,483,557,417,462,470,
 559,454,516,468,553,1271,1321,1281,1282,1566,1236],
 [26,28,23,51,67,50,97,82,100,79,69,85,89,95,77,55,83,73,
 107,103,56,72,54,78,60,75,65,90,62,49,68,57,282,384,
 425,476,433,444,472,234,240,244,280,230,215,288,251,203,
 253,207,214,262,246,245,301,235,187,501,397,496,441,570,
 513,453,493,509,543,506,412,485,447,561,487,448,525,483,
 557,517,417,462,470,559,499,454,516,468,553,1271,1321,
 1281,1282,1566,1236],
 [26,28,23,51,67,50,97,82,100,79,94,92,88,95,77,55,83,64,
 108,101,63,56,72,54,78,60,75,65,87,90,106,93,81,57,282,
 384,541,352,425,476,433,472,222,259,307,248,264,382,404,
 437,223,217,226,281,321,397,496,441,570,453,493,447,561,
 448,525,417,462,470,559,814,859,1603,1786,1505,757,883,
 1524,1771,1379,1068,996,948,1667,850,1671,936,1538,952,
 1738,856,1570,860,1602,1410,1656,1513,1727,1387,1606,1561,
 1753,1382,1611,1551,1712,1866,1917,1844],
 [26,28,23,51,67,50,97,82,100,79,94,92,95,55,83,64,108,
 101,56,72,54,78,60,75,65,87,90,106,81,49,68,57,282,384,
 541,352,425,476,433,472,222,259,272,307,248,264,215,382,
 223,217,226,281,245,321,397,496,537,441,570,453,493,540,
 447,561,448,525,417,462,548,470,559,814,778,859,1603,757,
 795,883,1524,1068,996,1219,948,1667,1294,850,1671,1332,936,
 1538,1217,952,1738,1269,856,1570,1284,860,1602,1410,1656,
 1513,1727,1387,1606,1561,1753,1382,1611,1551,1712,1866,1917,
 1844],
 [26,28,23,51,67,50,97,82,100,94,92,95,77,55,83,64,108,
 101,63,56,72,54,78,60,75,65,90,106,93,81,49,68,57,282,
 384,541,352,425,476,433,472,193,222,259,307,382,200,223,
 217,226,281,321,501,397,496,441,570,447,561,487,448,525,
 517,417,462,470,559,739,764,814,859,1603,724,728,757,883,
 1524,996,1263,958,1073,948,1667,850,1671,936,1538,1186,910,
 1067,952,1738,856,1570,860,1602,1678,1713,1410,1656,1586,
 1513,1727,1719,1387,1606,1641,1485,1561,1753,1735,1382,1611,
 1543,1551,1712,1866,1917,1844],
 [26,28,23,61,97,82,100,94,69,85,92,89,83,101,63,103,56,
 72,96,60,75,90,106,80,99,81,62,339,369,376,344,380,317,
 324,291,298,351,359,350,331,227,261,318,243,386,406,287,
 238,213,328,311,250,228,323,290,239,258,343,578,616,594,
 606,622,597,583,609,589,619,579,618,607,617,586,620,603,
 610,595,600,613,605,442,576,615,815,866,726,1400,893,895,
 1424,947,970,1840,916,1805,909,1763,2108,867,2503,2740,
 2054,2703,2612,2977,2384,3054,2401,2948,2942],
 [26,28,23,61,97,82,100,94,105,69,85,92,89,66,76,83,74,
 101,63,84,103,56,72,96,60,75,90,91,86,106,80,99,81,62,
 339,369,376,344,387,380,317,324,351,359,350,331,318,243,
 435,386,406,328,295,308,311,323,290,335,343,578,616,594,
 606,622,597,583,609,589,619,579,618,607,617,586,620,603,
 610,595,600,613,605,576,615,970,1840,916,1805,909,1763],
 [26,28,23,97,82,100,94,69,85,92,89,83,101,63,103,56,72,
 60,75,90,106,81,62,339,369,376,344,317,324,300,351,359,
 350,331,318,243,435,386,406,287,328,295,308,311,323,290,
 239,258,343,578,616,397,496,594,606,614,622,597,554,583,
 609,589,619,579,618,607,617,507,586,620,603,610,595,600,
 613,605,442,529,576,615,866,726,1975,812,702,941,2044,970,
 1840,916,1805,909,1763,1760,1197,948,1667,1663,867,850,
 1671,1730,936,1538,1815,952,1738,1590,848,856,1570,1773,
 1369,1295,860,1602,2750,2764,1713,1410,1656,2799,1586,1719,
 1387,1606,2795,1485,1735,1382,1611,3056,1543,3477,2667,3115,
 2877,2670,5348,4135,8122,4589,4595,7550,4479,5178,8207,8563,
 5121],[26,28,23,97,82,100,94,105,69,85,92,89,66,76,53,
 71,83,101,63,84,103,56,72,60,75,90,91,86,106,80,99,81,
 62,339,369,376,344,387,380,317,324,315,351,331,318,329,
 243,386,406,383,328,311,323,349,290,343,578,616,594,606,
 614,622,597,583,609,602,589,619,579,618,608,607,617,586,
 620,590,603,610,595,600,621,613,605,576,615,577,970,1840,
 916,1805,909,1763],
 [26,28,23,97,82,100,94,105,69,85,92,89,66,76,83,74,101,
 63,103,56,72,96,60,75,90,106,80,99,81,62,52,339,369,
 376,344,380,317,324,351,359,350,331,318,243,206,216,386,
 406,328,295,308,311,323,290,239,258,343,578,616,565,594,
 606,622,597,604,583,609,589,619,572,479,579,618,607,617,
 611,586,620,603,610,573,595,600,613,605,591,442,576,615,
 970,1840,916,1805,909,1763],
 [26,28,38,23,51,67,97,82,100,92,95,55,83,56,72,78,65,106,
 81,384,369,541,352,367,476,433,380,324,234,248,264,270,
 200,226,281,358,273,565,594,606,624,458,461,453,493,598,
 579,618,625,426,488,581,417,462,595,600,638,456,498,587,
 788,814,1449,915,983,1603,963,701,1421,920,883,753,1540,
 1068,3083,1519,3085,1498,2964,1035,1093,948,1667,1577,2103,
 1196,1225,993,1506,1059,1072,1326,1922,988,1077,936,1538,
 1546,2353,1136,1142,1100,1444,1591,2203,1166,1319,1092,1150,
 856,1570,1367,1931,1046,1085,1159,1541,1556,2382,3187,2497,
 2821,3538,4167,2096,4443,3609,2551,3243,3452,1946,2898,4304,
 1579,1429,1410,1656,1648,1574,1628,1554,1387,1606,1624,1515,
 1584,1493,1382,1611,1682,1636,2593,2969,3006,4003,2482,3203,
 2811,3706,2704,3153,3399,3778,2480,2857,2963,3993,2623,3499,
 2748,3366,2668,2958,3569,4175,8590,8513,9318,5871,9368,5048,
 7173,5225,3684,3581,3381,5014,3027,3271,4634,3184,3394,3909,
 5863,3719,3331,5876,3487,3091,3680,4755,3749,3174,5027,3306,
 5470,4286,3711,4881,8073,6022,7097,7584,6008,6973],
 [26,29,20,28,23,15,51,67,50,82,100,79,94,69,85,88,89,95,
 77,53,71,55,64,108,103,56,72,54,78,65,91,86,106,93,80,
 99,62,49,68,57,279,240,291,298,229,230,255,212,266,270,
 203,207,238,213,226,281,245,305,299,306,273,187,739,764,
 824,714,674,724,728,802,1101,721,693,2355,2327],
 [26,29,20,28,23,15,51,67,50,82,100,79,94,69,85,89,95,77,
 53,71,55,73,107,56,72,54,78,65,87,106,93,80,99,62,49,
 68,57,279,240,272,291,298,229,244,280,255,212,270,206,
 216,294,207,269,238,213,246,305,299,273,239,258,187,761,
 824,814,737,714,803,733,712,695,747,802,757,721,820,760,
 723,753,1940,2198],
 [26,29,20,28,23,15,51,67,50,82,100,79,94,69,85,89,95,77,
 53,71,55,73,107,103,56,72,54,78,65,87,91,86,106,93,80,
 99,62,49,68,57,279,240,272,291,298,229,244,280,255,212,
 270,294,207,269,238,213,246,245,305,299,273,187,761,824,
 737,714,803,733,747,802,721,820,760,1940,2198],
 [26,29,20,28,23,15,51,67,50,97,79,94,69,85,92,88,66,76,
 77,53,71,55,83,63,56,72,54,78,60,75,90,106,93,80,99,
 81,49,68,57,186,208,351,244,280,230,248,264,302,243,266,
 206,216,267,328,214,262,246,290,306,239,258,314,663,915,
 754,670,847,707,695,801,882,717,753,2023,2093,2087,2586,
 2118,3369,3966],
 [26,29,20,28,23,15,51,67,50,97,82,100,79,94,69,85,92,88,
 89,66,76,95,77,53,71,55,83,64,108,101,73,107,63,103,56,
 72,54,78,60,75,65,87,90,91,86,106,93,80,99,81,62,49,
 68,57],
 [26,29,20,28,23,15,82,100,94,69,85,92,89,66,76,53,71,83,
 101,63,56,72,60,75,90,106,80,99,81,339,369,376,380,324,
 351,331,318,243,206,216,382,386,406,328,311,323,290,239,
 258,314,343,578,616,482,594,606,622,597,567,583,609,589,
 619,545,479,540,579,618,607,617,528,586,620,603,610,550,
 595,600,613,605,555,442,497,576,615,970,1840,1310,916,
 1805,1324,909,1763,1385],
 [26,29,20,36,32,28,18,23,51,50,97,94,89,76,53,55,83,108,
 101,103,72,78,90,86,106,80,81,68,57,252,353,339,369,410,
 541,365,312,395,367,399,476,405,387,380,317,341,472,208,
 351,248,215,255,243,382,328,226,245,305,290,314,430,451,
 531,619,466,450,478,452,548,605,670,669,1433,973,982],
 [26,29,20,36,32,28,18,23,51,50,97,94,89,76,53,55,83,108,
 101,103,72,78,90,86,106,80,81,68,57,252,376,365,312,395,
 344,399,476,405,387,380,341,472,208,351,248,215,255,243,
 382,328,226,245,305,290,314,464,467,594,614,513,619,466,
 450,540,586,590,478,452,517,605,497,670,669,1569,1807,
 1035,899,933,1039,984,1002,1495,3476,2840,3670,3060,3253,
 3277],
 [26,29,20,36,32,28,18,23,51,50,97,100,94,69,92,89,76,95,
 53,55,83,108,101,73,63,103,72,78,60,65,90,86,106,80,81,
 62,68,57,252,353,339,369,376,410,541,365,312,395,367,344,
 399,476,373,405,387,380,317,341,472],
 [26,29,20,36,32,28,18,23,51,50,97,100,94,89,95,83,108,
 101,73,63,72,78,60,65,90,106,80,81,62,68,252,353,339,
 369,312,395,367,344,399,476,373,405,387,380,317,341,472,
 222,240,359,331,302,386,223,207,295,311,321,258,343,496,
 537,597,485,504,610,462,726,702,1613,1271,1833,1281,1645,
 1566],
 [26,29,20,36,32,28,18,23,51,50,97,100,94,89,95,83,108,
 101,73,63,72,78,60,65,90,106,80,81,62,68,252,353,339,
 376,410,541,312,395,367,399,476,373,380,317,222,240,359,
 331,302,386,223,207,295,311,321,258,343,501,496,597,531,
 485,579,608,487,610,548,535,442,576,577,726,702,1234,867,
 1317,848,1295,2667,2877],
 [26,29,20,36,32,28,18,23,51,50,100,94,69,92,89,95,53,55,
 83,108,73,63,103,72,78,90,86,106,62,68,252,369,376,365,
 312,395,344,399,476,405,387,380,341,472,279,298,230,255,
 243,201,203,294,213,305,290,192,187,464,467,594,614,513,
 619,540,474,449,586,590,581,605,497,587,674,693,2113,1096,
 2005,1147],
 [26,29,20,36,32,28,18,23,51,67,50,82,100,79,94,89,95,77,
 53,55,83,64,108,74,73,107,63,103,56,72,54,78,90,86,106,
 93,62,49,52,57,279,222,240,272,298,255,243,266,201,203,
 437,294,223,207,269,213,305,290,306,192,187,357,761,674,
 747,693],
 [26,29,20,36,32,28,18,23,51,67,50,97,82,79,94,69,92,76,
 77,53,55,83,64,108,74,101,103,56,72,54,78,87,90,86,106,
 93,80,81,49,68,52,208,272,307,351,255,243,382,386,269,
 267,328,226,281,245,305,290,314,343,739,764,824,724,728,
 802,669,2030,1993],
 [26,29,20,36,32,28,18,23,51,67,50,97,82,100,79,94,69,92,
 88,89,76,95,77,53,55,83,64,108,74,101,73,107,63,103,56,
 72,54,78,60,65,87,90,86,106,93,80,81,62,49,68,52,57],
 [26,29,20,36,32,28,18,23,51,67,50,97,100,94,69,92,89,76,
 95,53,55,83,64,108,74,101,73,63,103,56,72,54,78,60,65,
 90,86,106,93,80,81,62,68,57,186,193,322,264,266,404,435,
 202,200,269,319,281,306,325,335,870,914],
 [26,29,24,33,17,39,20,27,36,31,42,32,35,28,19,38,18,23,
 30,21,15,25,471,252,340,381,389,407,370,475,365,402,345,
 366,392,313,362,542,373,411,377,368,338,354,249,2535,2676,
 2453],
 [26,29,24,33,17,39,20,27,36,31,42,32,35,28,19,38,23,30,
 21,15,25,471,252,340,381,389,422,407,370,475,365,402,345,
 366,392,346,313,362,542,373,411,368,338,371,354,249,2535,
 985,2676,978,2453,1451],
 [26,29,24,33,20,27,36,31,41,32,35,28,19,40,18,34,23,30,
 13,15,25,51,67,50,88,64,73,107,63,72,54,78,87,93,49,
 208,193,234,277,200,253,319,796,871],
 [26,29,24,33,39,37,20,36,42,41,32,35,28,38,40,18,34,23,
 21,13,15,25,51,67,50,69,92,95,83,73,107,63,72,60,65,
 106,62,208,277],
 [26,29,24,33,39,37,20,36,42,41,32,35,28,38,40,18,34,23,
 21,13,15,25,471,252,340,394,492,443,432,475,365,402,347,
 429,520,424,355,542,373,411,423,419,484,385,283,1148,1248,
 1115],
 [26,29,24,37,20,36,41,32,35,28,40,18,34,23,13,25,67,77,
 64,74,107,56,54,87,93,49,52,471,340,394,492,475,402,347,
 424,355,423,419,484,269,464,551,467,589,585,511,479,508,
 612,562,534,571,478,452,613,593,486,566,1183,1419,945,
 1096,1034,1299,1363,949,1798,2172,1622,1902,2616,2674,2662,
 2613,4374,4573,2622,2822,3635,4180,4928,9113,5820,7189],
 [26,29,24,39,20,27,36,42,32,35,28,38,34,23,15,25,51,67,
 83,56,72,106,340,381,410,370,402,345,366,392,346,399,362,
 411,368,341,249,207,464,551,495,622,597,574,511,560,508,
 607,617,413,483,557,571,519,546,613,605,566,1862,1129,978,
 1908,1260,1891,1157,899,1188,902,1299,928,1821,1981,1751,
 1578,1750,2144,1747,1413,1783,1632,1810,1944,1780,1587,1812,
 1845,1826,2613,3660,2822,3220,2855,2968,3635,5425,8093,5719,
 9324,5113,6781,8861,7205,6931],
 [26,29,24,39,20,27,36,42,32,35,28,38,34,23,15,25,94,53,
 71,63,49,68,471,252,492,432,475,365,312,347,520,424,355,
 542,373,484,283,270,575,594,606,509,543,585,511,560,489,
 579,618,538,483,557,584,595,600,486,468,553,1357,1148,
 1434,1248,992,1325,1115,1216,1171,1087,911,1168,1549,1892,
 1528,1958,1481,1622,1687,1827,1531,2188,1576,1880,1479,1982,
 1881,1912,1875,2601,3657,2684,2784,3565,2985,3554,8727,5024,
 8785,5768,8082,5012,7403,8130,8202],
 [26,29,24,39,20,27,36,42,32,35,28,38,34,23,15,25,94,89,
 53,71,64,108,63,78,90,49,68,471,252,492,432,475,365,312,
 347,520,424,355,542,373,484,283,201,276,192,209,575,585,
 511,560,508,584,486,1357,1148,1434,1248,992,1325,1115,951,
 1454,917,1348,1622,1881,1912,1875,2744,2696],
 [26,29,24,39,37,20,27,36,42,41,32,35,28,38,40,18,34,23,
 21,13,15,25,51,67,50,95,83,73,107,63,56,72,65,106,62,
 186,208,202,277,207,700,705],
 [26,29,24,39,37,20,27,36,42,41,32,35,28,38,40,18,34,23,
 21,13,15,25,471,252,340,492,432,475,365,402,312,347,520,
 424,355,542,373,411,405,423,484,385,283,1357,1148,1434,
 1248,992,1325,1115,1069,1881,1912,1875],
 [26,29,28,23,82,100,94,105,69,85,92,89,53,71,83,74,63,56,
 72,96,90,106,80,99,62,52,339,369,376,380,317,324,291,
 298,351,331,230,318,243,206,216,203,386,406,238,213,328,
 311,323,305,299,290,239,258,187,343,578,616,594,606,622,
 597,583,609,589,619,479,579,618,607,617,586,620,603,610,
 595,600,613,605,442,576,615,814,1334,1112,674,695,757,
 1198,918,693,753,970,1840,916,1805,909,1763,1229,1219,1205,
 1206,969,1355,1217,1070,1349,1019],
 [26,29,33,17,39,20,31,42,28,38,23,21,15,67,69,85,76,71,
 55,83,101,107,75,99,62,57,471,340,381,481,443,389,370,
 475,402,366,521,424,362,542,411,368,491,385,338,249,216,
 203,258,187,482,495,567,547,458,545,503,528,538,426,550,
 532,555,539,456,913,908,966],
 [26,29,33,20,32,23,51,67,50,94,69,85,92,88,89,76,59,95,
 53,71,55,83,108,74,101,73,60,75,65,90,86,70,106,93,80,
 99,81,62,68,52,57,279,208,193,322,244,264,215,302,309,
 293,318,266,404,214,281,245,321,348,358,323,306,325,1084,
 670,742,823,1101,669,718,923],
 [26,29,33,20,32,23,51,67,50,97,69,85,92,88,89,76,59,77,
 53,71,55,83,101,107,63,103,60,87,90,106,93,80,99,81,49,
 68,52,208,193,234,244,280,227,248,309,293,318,212,243,
 216,221,277,200,253,226,299,290,258,220,314,343,819,915,
 1291,1063,803,733,727,685,762,873,863,820,760,736,699,785,
 798,2096,2012,2474,1946,1918,2377],
 [26,29,33,20,32,23,51,67,50,97,69,85,92,88,89,76,59,77,
 53,71,55,101,107,63,103,60,87,90,106,93,80,99,81,49,68,
 52,208,193,234,229,244,280,227,248,309,293,318,212,243,
 216,221,277,200,253,226,299,290,258,220,314,343,819,915,
 1291,1063,714,803,733,727,685,762,873,863,721,820,760,736,
 699,785,798,2096,2012,2474,1946,1918,2377],
 [26,29,33,20,32,23,51,67,50,97,94,69,85,92,88,89,76,59,
 53,71,55,83,101,103,60,90,106,93,80,99,81,68,52,208,
 193,322,244,280,227,248,264,215,309,293,318,266,216,221,
 281,245,299,290,306,258,220,325,343,819,1112,1710,915,922,
 1291,670,742,1063,823,847,685,762,873,669,718,820,760,736,
 882,699,785,798,1524,2801,3395,4500,3716,2794,4239,5648,
 2474,2430,2504,1946,2175,1918,2377,2868,5389,7322,8387,9234,
 8131,9216,7620,6274,3519,7586,7582,9004,6617,7341,6962,7857,
 7126,7851,7239,8331,9423,6150,7347,6098,6980,7798,6186,7796,
 6484,6209],
 [26,29,33,20,32,23,51,67,50,97,100,79,94,69,85,92,88,89,
 76,59,95,77,53,71,55,83,64,108,74,101,73,107,63,103,72,
 54,78,60,75,65,87,90,86,70,106,93,80,99,81,62,49,68,
 52,57],
 [26,29,33,20,32,23,94,69,85,92,89,76,59,95,108,74,101,73,
 75,65,106,80,99,81,62,68,52,57,369,376,410,367,380,317,
 341,359,350,331,229,270,216,221,436,260,323,305,273,258,
 220,597,596,567,558,469,560,479,617,582,528,546,510,605,
 593,555,569,442,2045,925,1334,1400,893,1042,1963,822,1198,
 1424,947,1054,1310,1302,1324,1385,1439,2373,1539,1229,1933,
 1354,1205,2146,1595,1206,2335,1532,1355,1927,1322,1070,2112,
 1592,1349,1987,1822,1994,1765,2174,1909,2184,1788,1967,1816,
 2273,1824,3760,3845,3838],
 [26,29,33,20,32,23,94,69,85,92,89,95,71,55,108,74,73,103,
 78,75,65,106,80,62,68,52,369,376,380,341,334,359,229,
 230,255,270,216,221,386,436,294,295,260,246,305,273,209,
 187,343,616,575,597,596,558,469,513,619,585,560,479,617,
 582,562,449,610,584,546,510,517,605,593,569,442,497,1318,
 668,737,1340,671,755,645,961,1310,1302,1324,1438,1385,1439,
 1601,857,1392,1207,1020,1250,1031,1548,926,1722,1241,1415,
 1179,885,1295,1138,1889,2407,2041,2441,2466,1964,2356,2388,
 2173,3148,2786,3102,2900,3661,3118],
 [26,29,33,20,32,23,94,85,92,89,76,59,95,71,55,108,74,73,
 103,78,75,65,86,70,106,80,99,81,62,68,52,57,369,376,
 410,380,317,341,334,279,359,270,295,260,246,616,575,551,
 467,430,597,596,560,479,466,610,584,546,510,478,517,935,
 761,862,1084,919,843,747,939,1101,872,1310,1555,1158,1114,
 1263,1829,1059,1542,1039,1173,1454,1089,1257,1511,1249,1034,
 1186,1842,1092,1526,1002,1209,1348,1103,1170,2780,2094,2196,
 1685,2265,2253,2380,2580,2042,2328,2361,2290,1999,1684,2412,
 2036,2404,2222,2122,2095,5297,8087,4925],
 [26,29,33,20,42,32,38,23,21,51,67,50,94,69,85,92,89,53,
 71,55,83,73,107,63,103,72,54,75,65,90,106,80,62,68,52,
 279,208,193,280,227,230,216,221,276,203,294,277,200,213,
 254,328,262,250,246,305,209,187,343,630,793,819,1291,873,
 662,1029,636,816,863,822,1198,1346,645,961,2753,2432,2483,
 2461,2718,2690],
 [26,29,33,20,42,32,38,23,21,51,67,50,97,69,85,92,89,76,
 59,71,55,101,73,107,63,103,60,75,65,90,106,80,99,81,62,
 68,52,208,193,234,229,280,227,309,293,318,216,221,277,
 200,253,260,262,250,258,220,343,819,784,1291,1063,1400,
 685,762,873,863,765,1346,699,785,798,2474,4656,2377,4679],
 [26,29,33,36,32,28,18,15,51,50,97,94,69,92,76,53,55,83,
 108,101,63,103,72,78,60,86,80,81,68,252,339,384,369,376,
 408,410,365,395,425,367,344,337,399,373,317,286,341,208,
 307,351,243,382,386,277,267,328,290,314,343,518,564,505,
 534,502,486,739,724,1339,1068,1174,1297,996,1013,1288,1484,
 1323,1245,1227,1218],
 [26,29,33,36,32,28,18,15,51,50,97,94,69,92,76,53,55,83,
 108,101,63,103,72,78,60,86,80,81,68,252,384,369,365,395,
 344,337,399,387,444,380,208,307,351,243,382,386,277,267,
 328,290,314,343,467,537,556,594,619,540,527,579,449,505,
 534,504,544,586,605,497,480,576,739,724,1305,1263,1143,
 1262,1231,1356,1227,1182,1186,1087,1169,1168,1275,1307,1163,
 2546,2686,2539,2721,3159,2508,4507,2908,2538,2584,3633,2792]
  ,[26,29,33,36,32,28,18,15,51,50,97,100,79,94,69,92,89,
 76,95,53,55,83,108,101,73,107,63,103,72,78,96,60,65,87,
 90,86,106,80,81,62,49,68,57,356,300,272,244,293,251,292,
 434,287,269,319,303,214,358,235,278,796,752,871,694],
 [26,29,33,36,32,28,18,15,51,50,97,100,94,69,92,89,76,95,
 53,55,83,108,101,73,63,103,72,78,60,65,90,86,106,80,81,
 62,68,57,252,339,384,369,376,408,410,365,395,425,367,344,
 337,399,373,387,444,380,317,286,341],
 [26,29,33,36,32,28,18,15,51,50,97,100,94,92,89,76,95,53,
 83,108,101,73,63,72,60,65,90,106,80,68,252,339,376,408,
 410,395,425,367,373,444,380,222,331,302,318,216,382,386,
 223,321,323,258,314,343,490,501,597,531,522,549,583,479,
 540,527,579,507,487,548,568,595,442,497,480,576,1042,1054,
 1304,2146,1095,1214,2112,1080],
 [26,29,33,36,32,28,18,15,51,50,100,69,92,89,95,53,108,73,
 63,103,72,78,65,90,86,106,80,62,68,57,252,339,384,369,
 376,408,410,395,425,367,344,337,399,373,387,444,380,317,
 286,341,279,234,298,229,230,255,294,253,213,260,246,305,
 187,536,473,523,737,755,904,929,1118],
 [26,29,33,36,32,28,18,15,51,50,100,69,92,89,95,53,108,73,
 63,103,72,78,65,90,86,106,80,62,68,57,252,376,408,365,
 344,337,399,387,444,380,341,279,234,298,229,230,255,294,
 253,213,260,246,305,187,467,490,501,594,469,554,513,619,
 449,507,487,586,510,563,517,523,605,497,480,737,755,907,
 1020,981,1076,946,885,931,1058],
 [26,29,33,36,32,28,18,15,51,67,50,97,100,79,94,105,69,92,
 88,89,76,95,77,53,55,104,83,64,108,101,73,107,63,103,
 72,54,78,96,60,65,87,90,86,106,93,80,81,98,62,49,68,57 
  ],[26,29,33,36,32,28,18,15,51,97,100,94,69,92,76,55,
 83,101,73,63,72,60,65,90,86,106,81,62,68,57,252,339,
 384,369,376,408,410,395,425,367,344,337,399,373,387,444,
 380,317,286,341,324,307,351,280,201,406,267,328,262,321,
 323,192,441,447,470,814,925,757,822,904,929,1118],
 [26,29,33,36,32,28,18,15,51,97,100,94,69,92,76,55,83,101,
 73,63,72,60,65,90,86,106,81,62,68,57,339,384,369,365,
 425,367,373,387,317,286,341,324,307,351,280,201,406,267,
 328,262,321,323,192,616,537,441,556,594,469,533,506,447,
 617,504,544,586,510,548,568,595,529,499,814,925,757,822,
 1219,1362,1577,1251,1217,1223,1591,1159],
 [26,29,37,20,42,41,32,28,38,23,21,13,15,51,67,50,95,71,
 73,107,63,72,75,106,99,62,289,353,339,375,336,312,395,
 332,392,313,363,409,405,387,327,338,354,236,208,277,260,
 430,515,451,466,524,450,426,413,478,494,452,456,396,1293,
 777,837,1276,975,826,1353,991,891,1056,1239,1083,1210,1358,
 1195,1432,1176,1430],
 [26,29,37,20,42,41,32,28,38,23,21,13,15,67,71,83,107,72,
 75,106,99,289,353,339,375,336,312,395,332,392,313,363,
 409,405,387,327,338,354,236,334,324,436,406,551,430,515,
 451,622,596,560,466,524,450,607,582,426,413,571,546,478,
 494,452,613,593,456,396,566,1293,777,837,1276,975,826,
 1353,991,891,1188,1175,1383,1189,1300,1210,1358,2200,1195,
 1432,2046,1176,1430,2052,3188,3232,3144],
 [26,29,39,20,42,28,38,23,15,51,67,50,82,100,94,69,85,66,
 76,95,53,71,55,101,103,56,72,78,60,75,91,86,106,80,99,
 62,49,68,57,279,240,307,229,244,280,248,264,215,243,270,
 207,267,260,214,262,226,281,245,290,273,187,737,1084,755,
 1101],
 [26,29,39,20,42,28,38,23,15,51,67,50,94,69,85,53,71,55,
 63,103,56,72,78,90,91,86,106,80,99,49,68,57,279,186,
 208,291,298,351,229,244,280,255,212,243,294,202,277,207,
 267,238,213,328,246,226,281,305,299,290,187,314,700,663,
 737,915,714,803,733,705,701,747,724,728,721,820,760,1995,
 2713,2410,1940,2096,2091,2649,2284,2198,1946],
 [26,29,39,20,42,28,38,23,15,51,67,50,94,69,85,89,66,76,
 53,71,55,64,108,101,103,56,72,78,60,75,91,86,106,80,99,
 49,68,57,279,186,208,351,229,248,264,215,243,270,203,382,
 207,328,260,245,290,273,187,314,700,1084,754,670,847,707,
 741,669,882,717,1913,2270,1925,2645],
 [26,29,39,20,42,28,38,23,15,51,67,50,94,69,85,92,95,53,
 71,55,83,73,107,63,56,72,78,65,90,106,80,99,49,68,57,
 279,186,208,244,280,230,255,212,206,216,203,294,202,277,
 267,238,213,246,305,299,239,258,314,663,896,630,915,803,
 733,695,701,889,636,757,820,760,753,1151,2371,3050,2096,
 2529,1946,5736,5472],
 [26,29,39,20,42,28,38,23,15,51,67,50,97,94,69,85,92,95,
 53,71,55,83,73,107,56,72,78,60,75,65,106,80,99,81,49,
 68,57,186,208,244,280,230,270,206,216,202,277,267,238,
 213,214,262,246,273,239,258,314,663,896,630,915,712,695,
 701,889,636,802,757,801,723,753,2357,2371,2467,2529],
 [26,29,39,20,42,28,38,23,15,51,67,82,100,94,69,85,66,76,
 95,53,71,55,101,73,107,103,56,72,60,75,65,91,86,106,62,
 49,68,57,324,279,240,307,229,215,318,270,406,294,207,267,
 260,214,262,245,323,192,209,187,720,719,716,668,710,709,
 745,671,755,872,2495,1990,2119,2139],
 [26,29,39,20,42,28,38,23,15,51,67,82,100,94,69,85,89,66,
 76,95,53,71,55,64,108,101,73,107,56,72,78,60,75,65,106,
 62,49,68,57,324,279,240,229,215,302,270,206,216,201,276,
 203,406,294,207,260,192,209,187,712,695,919,704,662,872,
 698,645,1989,2075,1934,2080],
 [26,33,20,32,23,51,67,50,61,97,94,85,92,88,89,76,59,77,
 53,71,55,83,64,101,107,63,84,103,72,54,60,90,106,93,80,
 99,81,68,52,208,193,222,280,227,248,318,212,243,266,216,
 221,382,277,200,223,328,299,290,306,258,220,325,343,819,
 922,1291,733,727,847,873,863,760,736,882,798,1524,3716,
 2071,2012,2175,1918,4107,3519],
 [26,33,20,32,23,67,50,61,97,94,88,89,76,59,77,53,71,55,
 64,101,107,63,84,103,90,93,80,99,81,68,52,334,208,193,
 222,229,248,309,293,318,255,212,243,266,216,221,288,382,
 436,277,200,223,348,358,305,299,290,306,258,220,325,343,
 644,700,819,703,809,1063,714,733,727,847,873,665,705,863,
 725,868,1289,721,760,736,882,798,806,1524,2368,2291,2376,
 2444,2071,2012,2321,2088,2745,3058,2175,1918,4725,4173,8394,
 3482,4222,4107,5327,3318,5414,4216,4241,3519,4697,8085,6908,
 8698,4710,8139,6711,6296],
 [26,33,20,32,28,18,23,15,50,97,69,89,53,55,108,101,63,
 103,60,90,80,81,68,57,252,282,326,369,376,365,352,395,
 344,374,380,341,208,234,298,351,243,382,277,253,213,328,
 290,314,578,467,592,594,558,547,589,619,572,450,540,562,
 449,538,586,601,605,591,516,486,497,739,724,1302,1438,
 1288,899,1285,1263,1073,1262,2039,1454,1024,1008,1255,1186,
 1067,1169,2098,1218,1348,911,1874,1574,1662,2580,1515,1744,
 1739,2191,1389,1202,2222,2642,2546,3035,2539,8614,7437,2634,
 3606,2508,4784,4211,2744,4271,2918,3536,2584,5142,4162,2696,
 3832,4832,4938,4316,3887,4248,5747,4566,5345,7435,5033,7042,
 6735,4242,4430,6533,6303,4458,4452,7125,7540,6136],
 [26,33,20,32,28,18,23,15,51,50,97,69,92,89,53,55,108,101,
 63,103,72,78,60,90,86,106,80,81,68,57,252,282,326,369,
 376,365,352,395,344,399,387,374,380,341,208,234,248,243,
 382,277,253,213,328,226,290,314,467,592,461,513,619,572,
 540,449,586,494,517,601,605,591,497,630,819,636,863,995,
 1145,1071,1083],
 [26,33,20,32,28,18,23,15,51,50,97,69,92,89,53,55,108,101,
 63,103,72,78,60,90,86,106,80,81,68,57,252,282,339,376,
 365,352,333,367,344,399,373,433,387,374,380,317,341,208,
 234,248,243,382,277,253,213,328,226,290,314,515,501,612,
 488,487,586,601,630,819,636,863,916,909,1056,995,1105,
 1071,1503,1529],
 [26,33,20,32,28,18,23,15,51,50,97,100,94,69,92,89,76,95,
 53,55,83,108,101,73,63,103,72,78,60,65,90,86,106,80,81,
 62,68,57,252,282,339,326,369,376,410,365,352,395,333,367,
 344,399,373,433,387,374,380,317,341],
 [26,33,20,32,28,18,23,15,51,50,97,100,94,69,92,89,76,95,
 77,53,55,83,108,101,73,107,63,84,103,72,78,60,75,65,87,
 90,86,106,80,81,62,49,68,57,356,315,259,272,244,293,251,
 434,383,200,217,269,214,358,235,788,963],
 [26,33,20,32,28,18,23,15,51,50,100,94,92,89,53,55,83,73,
 63,103,72,78,65,90,86,106,80,62,68,57,252,282,326,369,
 376,365,352,395,344,399,387,374,380,341,279,298,351,280,
 230,203,294,213,328,262,246,305,187,467,430,594,461,513,
 466,540,449,586,494,517,605,591,497,1334,1198,1933,1663,
 1927,1590,1046,3744,4057],
 [26,33,20,32,28,18,23,15,51,50,100,94,92,89,53,55,83,73,
 63,103,72,78,65,90,86,106,80,62,68,57,252,282,339,376,
 365,352,333,367,344,399,373,433,387,374,380,317,341,279,
 298,351,280,230,203,294,213,328,262,246,305,187,430,594,
 469,466,586,510,478,1334,1198,1475,1621,1468,1569,1463,1807 
  ],[26,33,20,32,28,18,23,15,51,67,50,61,69,85,92,88,89,
 53,55,73,63,103,72,54,78,65,90,86,106,93,80,62,68,57,
 279,208,193,234,229,244,280,230,264,261,212,266,200,213,
 328,319,281,228,305,299,306,325,630,819,796,737,922,1084,
 670,879,714,803,733,674,636,863,1198,1101,669,890,721,820,
 760,693,1151,2432,3050,2033,1940,2071,2440,2198,2175,5353,
 5736,5482,5472],
 [26,33,20,32,28,18,23,15,51,67,50,61,69,85,92,88,89,53,
 55,73,107,63,84,103,72,54,78,75,65,87,90,86,106,93,80,
 62,49,68,57,279,208,193,234,229,244,280,230,294,277,200,
 253,213,328,319,260,214,262,246,305,187,630,819,796,737,
 636,863,871,1198,755,2432,2718],
 [26,33,20,32,28,18,23,15,51,67,50,61,69,85,92,88,89,77,
 53,55,73,107,63,84,103,72,54,78,75,65,87,90,86,106,93,
 80,62,49,68,57,279,208,193,234,229,244,280,230,255,294,
 277,200,253,213,328,260,214,262,246,305,187,630,819,737,
 636,863,755],
 [26,33,20,32,28,18,23,15,51,67,50,61,85,92,88,89,53,55,
 73,107,63,84,103,72,54,78,75,65,87,90,86,106,93,80,62,
 49,68,57,279,208,193,234,222,229,244,280,230,294,277,200,
 253,223,213,328,319,260,214,262,246,305,187,630,819,796,
 737,636,863,871,1198,755,2432,2718],
 [26,33,20,32,28,18,23,15,51,67,50,61,97,85,92,88,89,53,
 55,83,63,103,72,54,78,60,90,86,106,93,80,81,68,57,208,
 193,234,222,244,280,230,248,264,261,212,266,200,213,328,
 319,281,228,299,290,306,325,630,819,796,915,922,670,879,
 974,803,733,674,847,636,863,1639,669,890,1021,820,760,693,
 882,1524,3988,3716,2033,2096,2071,2440,1946,2175,6468,4107,
 8024,3519],
 [26,33,20,32,28,18,23,15,51,67,50,61,97,85,92,88,89,77,
 53,55,83,107,63,84,103,72,54,78,60,75,87,90,86,106,93,
 80,81,49,68,57,208,193,234,222,244,280,230,248,243,277,
 200,253,223,213,328,214,262,246,226,290,314,630,819,915,
 636,863,801],
 [26,33,20,32,28,18,23,15,51,67,50,61,97,85,92,88,89,77,
 53,55,107,63,84,103,72,54,78,60,75,87,90,86,106,93,80,
 81,49,68,57,208,193,234,222,229,244,280,230,248,243,277,
 200,253,223,213,328,260,214,262,246,226,290,314,630,819,
 915,636,863,801],
 [26,33,20,32,28,18,23,15,51,67,50,61,97,92,89,77,53,55,
 83,107,63,84,103,72,54,78,60,75,87,90,86,106,93,80,81,
 49,68,57,208,193,234,222,243,277,200,253,223,217,269,213,
 328,214,262,246,226,290,314,644,870,630,819,665,914,636,
 863,710,709,747,724,801,1950,2368,1995,2713,1976,2321,2091,
 2649,1801,4379,4602],
 [26,33,20,32,28,18,23,15,51,67,50,61,97,100,79,94,69,85,
 92,88,89,76,95,77,53,55,83,64,108,101,73,107,63,84,103,
 72,54,78,60,75,65,87,90,86,106,93,80,81,62,49,68,57],
 [26,33,20,32,28,18,23,15,51,67,50,61,97,100,94,69,85,92,
 88,89,76,95,53,55,83,108,101,73,63,103,72,54,78,60,65,
 90,86,106,93,80,81,62,68,57,193,322,244,264,261,212,266,
 404,200,319,281,228,299,306,325,803,820],
 [26,33,20,32,28,18,23,15,51,97,69,92,76,95,53,55,83,73,
 63,103,60,65,90,86,106,81,62,68,57,252,282,339,376,410,
 365,352,395,344,373,433,387,374,380,317,341,324,280,230,
 309,318,201,406,262,246,348,323,192,551,495,461,513,583,
 560,503,546,532,494,517,595,859,883,1475,1621,1468,1569,
 1463,1807,1403,1171,1456],
 [26,33,20,32,28,18,23,15,51,97,69,92,76,95,53,55,83,73,
 63,103,60,65,90,86,106,81,62,68,57,326,369,410,365,352,
 333,367,344,373,433,387,317,341,324,280,230,309,318,201,
 406,262,246,348,323,192,616,565,469,583,560,503,524,506,
 617,611,546,510,532,595,498,499,859,883,1907,1876,1601,
 1277,1294,1171,1548,1361,1456,1269,1822,1787,1788,1858,3951,
 4314,3049,2856],
 [26,33,20,36,32,18,50,61,97,89,53,74,101,63,84,103,60,90,
 68,52,57,252,376,344,341,208,298,280,216,382,277,213,254,
 328,262,258,314,578,467,495,536,556,558,469,547,522,549,
 479,503,540,473,527,562,449,538,512,544,586,510,532,523,
 568,442,539,431,486,497,463,480,959,739,716,974,847,957,
 1048,724,745,1021,882,792,904,1302,929,1438,1118,1439,899,
 1183,1391,1263,1016,1253,1416,1457,902,1096,1454,1455,1530,
 1008,1230,1299,1186,986,1169,928,1213,1445,1396,965,1147,
 1348,1448,1393,2530,3529,2193,2794,2389,3298,2302,2504,2162,
 2094,1435,1662,2253,2067,2042,1440,1744,2290,1980,2036,1458,
 1680,2122,3242,2945,2642,2779,3111,2502,3736,3210,3238,3090,
 3035,2872,2993,2719,3303,3479,5454,7252,4631,6306,5191,5739,
 4972,9244,4698,7567,5449,7995,4585,8064],
 [26,33,20,36,32,18,50,61,100,69,89,59,95,53,55,104,108,
 73,63,84,103,72,60,80,62,68,52,57,365,344,399,373,341,
 229,227,230,221,288,203,292,436,294,273,220,301,187,278,
 469,547,416,513,493,450,506,485,540,617,449,538,442,539,
 396,499,516,497,2045,1318,794,714,727,674,1963,1340,776,
 721,736,693,973,1833,2373,857,1277,867,1267,945,1208,902,
 1096,1250,2335,926,1361,848,1273,949,1235,965,1147,1295,
 1571,1495,1429,1373,1585,1574,1568,1743,1554,1787,1964,1380,
 1469,1515,1525,1594,1493,1417,1666,1636,1938,2173,1811,4632,
 1867,4425,1834,4485],
 [26,33,20,36,32,18,51,50,61,97,89,59,95,53,55,104,83,74,
 101,63,84,72,60,90,70,106,81,98,62,68,52,57,252,376,
 410,365,317,341,208,222,280,201,262,226,321,467,495,451,
 501,496,469,547,450,506,485,510,532,452,517,462,548,739,
 814,670,974,957,724,757,669,1021,792,1302,1391,1263,1073,
 1219,1039,881,1416,1457,1316,1455,1530,1155,1299,1186,1067,
 1217,1002,1027,1445,1396,1224,1448,1393,1109,2094,1874,1941,
 2265,2253,1820,1860,2042,1901,2204,2290,1739,1783,2412,2036,
 1900,2016,2122,1814,1896,5847,4967,4082],
 [26,33,20,36,32,18,51,50,61,97,89,76,59,95,53,55,104,83,
 63,84,103,72,70,106,62,68,52,57,252,376,410,365,344,317,
 341,280,227,230,248,201,203,292,277,226,273,258,192,187,
 278,469,547,458,416,513,450,506,449,538,426,452,517,442,
 539,456,396,499,924,794,726,733,727,674,1015,776,702,760,
 736,693,1302,927,1438,1439,821,857,1277,1035,867,1267,1196,
 945,1208,988,926,1361,1136,848,1273,1166,949,1235,1046,
 1571,1495,1373,1585,1568,1743,1380,1469,1525,1594,1417,1666,
 4769,4811,4497],
 [26,33,20,36,32,18,51,50,61,97,100,76,59,95,77,53,55,104,
 83,108,74,101,73,107,63,84,103,60,65,87,90,86,70,106,
 80,81,98,62,68,52,57,356,193,234,222,240,272,307,309,
 293,318,251,404,434,200,253,223,214,348,358,323,235,325,
 720,809,778,859,868,795,883,1991,2289],
 [26,33,20,36,32,18,51,67,50,61,69,92,88,89,59,95,77,53,
 55,104,83,64,108,73,107,63,84,103,65,87,90,86,80,62,49,
 52,57,279,208,193,234,227,230,309,293,318,255,221,288,
 251,203,292,294,277,200,253,250,246,187,278,357,630,772,
 912,685,762,873,807,1029,900,921,636,751,961,806,875,2031,
 2028,2086,2483,2338,2099,2161,2690,2523,4501,5787],
 [26,33,20,36,32,18,51,67,50,61,97,100,79,94,69,92,88,89,
 76,59,95,77,53,55,104,83,64,108,74,101,73,107,63,84,
 103,72,54,78,60,65,87,90,86,70,106,93,80,81,98,62,49,
 68,52,57],
 [26,33,20,36,32,18,51,67,50,61,97,100,92,88,89,76,59,95,
 53,55,104,83,64,108,74,101,73,63,84,103,90,86,70,106,
 80,81,98,62,68,52,57,193,234,222,264,309,293,318,255,
 243,266,251,404,200,253,223,281,348,358,323,305,290,306,
 235,325,796,823,871,923],
 [26,33,20,36,32,18,51,67,50,61,100,69,92,88,89,59,95,53,
 55,104,83,64,108,73,63,84,103,90,86,80,62,52,57,279,
 193,234,227,230,264,309,293,318,243,266,221,288,251,203,
 292,404,200,253,281,290,306,357,630,796,772,1084,912,823,
 727,674,685,762,873,807,1029,900,921,1246,1347,636,871,
 1101,736,693,1771,2432,5163,3658,2654,2031,2430,2028,2086,
 2483,2338,4115,3819,4570,2718,2669,3588,4718,6403,8903,8999,
 6898,4501,3992,5186,7244,9424,5523,4984,7370,6515,6754,9362,
 7897,9349,6347,9262,6492,6509,5652,6691,6103,6193,7489,6636,
 8214,6314,6798,7402,8486,6832,6831,6504,8285,6392,6716,6109,
 6300,6666,9335,9331,6438,7895,7165,7162,6581,6701,6700,6334,
 6935,6550,6597,7692,6156,6236,6154,6233],
 [26,33,20,36,32,18,51,67,50,61,100,69,92,88,89,59,95,77,
 53,55,104,83,64,108,73,107,63,84,103,54,78,65,87,90,86,
 93,80,62,52,57,279,193,234,227,230,309,255,221,288,203,
 292,294,200,253,213,250,246,305,325,357,630,922,772,685,
 1029,900,636,980,751,1151,1308,3050,3725,2028,2924,3501,
 3689,3747,6042,5999,5520,5152,5714,7249,6844],
 [26,33,20,36,32,18,51,100,89,76,59,95,53,55,104,73,63,84,
 103,72,80,81,98,62,68,52,57,252,410,365,344,399,317,341,
 229,280,227,230,221,288,406,383,294,262,250,246,273,258,
 220,301,469,547,458,416,513,450,506,449,538,426,452,517,
 442,539,456,396,499,1768,1507,1318,794,726,714,1781,1597,
 1340,776,702,721,927,973,832,982,821,857,1277,1035,867,
 1267,1196,945,1208,988,926,1361,1136,848,1273,1166,949,
 1235,1046,1571,1495,1373,1585,1568,1743,1380,1469,1525,1594,
 1417,1666,1811,1867,1834],
 [26,33,20,36,32,18,633,657,51,50,61,76,59,95,53,55,104,
 63,84,103,72,54,78,81,98,62,68,52,57,1615,1724,1491,
 1640,252,410,365,344,399,317,341,193,234,222,227,230,248,
 221,288,201,200,253,223,250,246,226,220,301,192,451,501,
 500,458,416,513,450,506,489,426,413,487,452,517,514,456,
 396,499,1433,927,973,832,982,821],
 [26,33,20,36,42,32,28,38,18,23,21,15,51,67,50,61,69,92,
 89,53,55,83,108,101,107,63,84,103,72,54,78,60,90,86,
 106,80,81,68,57,279,208,193,234,248,243,382,294,277,200,
 253,213,328,226,290,314,630,819,636,863],
 [26,33,20,36,100,69,76,53,55,104,103,72,60,86,81,98,62,
 52,57,481,410,365,521,399,373,491,317,307,350,227,230,
 276,267,250,246,192,357,578,455,530,622,596,604,416,513,
 589,427,508,607,582,611,603,452,517,459,552,613,593,591,
 576,935,794,772,893,919,1023,1340,751,1101,947,721,932,
 3358,1310,3507,1324,3957,982,1385,1539,1760,1158,1011,1044,
 1262,1354,1663,867,1267,1104,1861,1162,1280,1595,1730,1089,
 1024,1121,1356,1532,1815,926,1361,986,1169,1322,1590,1061,
 1819,1002,1027,1201,1360,1592,1773,949,1235,1036,1275,4724,
 3383,2355,2818,2864,2956,2476,5202,2327,2770,2758,3029,2435,
 2269,1692,1713,1373,1585,1578,1586,1626,1719,1380,1469,1632,
 1485,1675,1735,1417,1666,1587,1543,3550,4738,2724,3349,2888,
 4235,2630,2999,2948,4639,2557,3164,3475,4643,2699,3302,2761,
 3503,2524,2793,2942,4626,2510,3251,5493,5256,6038,7378,7342,
 8461,9081,3698,3858,3375,2997,2921,5920,3835,3438,3827,4068,
 3580,3868,5203,3386,3069,2927,3783,3537,3894,4702,4081,5197,
 4796,5239,5112,4829,4965,8647,7714,6747,8106,7527,6473],
 [26,33,23,51,67,50,61,97,100,79,94,105,69,85,92,88,89,66,
 76,59,95,77,53,71,55,83,64,108,74,101,73,107,63,84,103,
 72,54,78,96,60,75,65,87,90,91,86,70,106,93,80,99,81,
 62,49,68,52,57],
 [26,33,23,51,67,50,97,94,69,85,92,88,76,59,53,83,101,73,
 60,75,65,90,86,70,106,93,80,282,481,521,433,444,491,208,
 193,307,351,322,244,302,309,293,318,266,382,386,267,328,
 214,281,245,321,348,358,323,306,314,343,490,570,536,606,
 614,543,522,609,602,561,473,618,608,557,512,620,590,559,
 523,600,621,553,463,615,577,764,824,823,728,802,669,718,
 923,1321,1540,1282,1519,1236,1498,1577,1326,1546,1591,1274,
 1367,1556,2030,2421,1993,2462,3662,3336],
 [26,33,23,51,67,50,97,100,79,94,69,85,92,76,59,77,53,83,
 101,73,107,63,60,75,65,87,90,86,70,106,93,80,282,384,
 481,521,433,444,491,272,307,351,302,309,293,318,382,386,
 269,267,328,321,348,358,323,314,343,570,536,594,606,614,
 543,522,583,609,602,561,473,579,618,608,557,512,586,620,
 590,559,523,595,600,621,553,463,576,615,577,1321,1540,
 1282,1519,1236,1498],
 [26,33,23,51,67,50,97,100,79,94,69,85,92,88,76,59,53,83,
 64,101,73,72,54,60,75,65,87,90,86,70,106,80,282,384,
 481,521,433,444,491,307,351,264,215,302,318,382,404,386,
 267,328,281,245,321,323,314,325,343,537,570,536,606,614,
 531,543,522,609,602,540,561,473,618,608,504,557,512,620,
 590,548,559,523,600,621,497,553,463,615,577,1321,1540,
 1282,1519,1236,1498],
 [26,33,23,51,67,50,97,100,79,94,69,85,92,88,76,59,53,83,
 64,101,73,107,63,72,54,60,75,65,87,90,86,70,106,93,80,
 282,384,481,521,433,444,491,307,351,322,302,318,382,404,
 386,267,328,319,321,323,314,325,343,570,536,606,614,543,
 522,609,602,561,473,618,608,557,512,620,590,559,523,600,
 621,553,463,615,577,1321,1540,1282,1519,1236,1498],
 [26,33,23,51,97,94,69,85,92,76,59,53,83,101,73,60,75,65,
 90,86,70,106,80,481,521,433,444,491,356,324,307,351,244,
 302,318,251,382,386,434,406,267,328,214,321,348,358,323,
 314,343,565,570,536,606,614,597,596,543,522,609,602,561,
 473,618,608,617,582,611,557,512,620,590,546,510,548,559,
 523,600,621,605,593,553,463,615,577,950,1449,921,892,1421,
 795,875,1321,1540,1282,1519,2439,1236,1498,1601,857,1263,
 1577,1457,1326,1530,1546,1548,926,1186,1591,1213,1396,1367,
 1393,1556,2990,2975,2076,1894,1874,1777,1790,1901,1742,1832,
 1858,1778,1900,1736,3103,3003,9408,7836,8504,3049,2508,2908,
 2856,3157,5755,6015,5054],
 [26,33,23,94,69,85,92,89,66,76,59,95,71,55,101,73,84,103,
 78,75,65,91,86,70,106,80,99,81,62,68,52,57,369,376,410,
 367,380,317,341,334,315,279,359,229,280,227,255,270,436,
 383,294,295,260,262,250,305,273,616,575,551,467,490,597,
 596,558,469,554,619,585,560,479,533,617,582,562,449,507,
 610,584,546,510,563,605,593,569,442,529,1310,1302,1324,
 1438,1385,1439],
 [26,33,23,94,69,85,92,89,76,59,95,101,73,103,78,75,65,86,
 70,106,80,62,57,369,376,410,367,380,334,279,359,350,331,
 229,261,255,270,437,435,436,294,287,295,260,228,305,273,
 357,335,616,575,551,467,606,614,597,596,558,469,554,543,
 522,619,585,560,479,579,618,608,617,582,562,449,610,584,
 546,510,600,621,605,593,569,442,576,815,866,893,1042,895,
 947,1054,1310,1302,2426,1324,1438,1385,1439,1760,1426,1663,
 1446,937,1730,1290,1538,1095,1815,1443,1590,1406,1773,1369,
 1602,1080,2977,3054,1849,1782,1573,1728,1742,1832,1791,1545,
 1890,1888,1535,1877,4183,4112,8483,8448,8184,4255,3304,4410,
 3656,3805,5042,5976,5143],
 [26,33,23,94,105,69,85,92,89,66,76,59,95,71,55,108,74,
 101,73,84,103,78,75,65,91,86,70,106,80,99,81,62,68,52,
 57,369,376,410,367,380,317,341,334,315,279,359,229,329,
 255,270,436,383,294,295,260,349,305,273,616,575,551,467,
 597,596,558,469,619,585,560,479,617,582,562,449,610,584,
 546,510,605,593,569,442,1310,1302,1324,1438,1385,1439],
 [26,33,23,94,105,69,85,92,89,66,76,59,95,108,74,101,73,
 103,78,96,75,65,86,70,106,80,99,81,62,68,52,57,369,376,
 410,367,380,317,341,334,279,359,350,331,229,255,270,206,
 436,294,295,308,311,260,305,273,239,616,575,565,551,467,
 597,596,604,558,469,619,585,572,560,479,617,582,611,562,
 449,610,584,573,546,510,605,593,591,569,442,1310,1302,
 1324,1438,1385,1439],
 [26,33,28,50,100,79,94,69,85,92,88,89,76,95,77,55,83,64,
 108,101,73,63,72,78,75,65,87,90,86,106,93,80,81,62,49,
 68,57,481,422,408,541,425,521,346,337,476,444,491,371,
 286,472,334,359,293,255,436,295,358,305,616,565,482,597,
 604,567,619,572,545,617,611,528,610,573,550,605,591,555,
 2560,2525,2439],
 [26,33,28,50,100,94,105,69,92,89,66,76,95,71,55,104,83,
 108,74,101,73,63,72,78,65,90,91,86,106,80,99,81,98,62,
 68,52,57,326,369,376,410,395,333,367,344,399,387,374,380,
 317,341,334,359,329,255,436,295,349,305,616,565,482,597,
 604,567,619,572,545,617,611,528,610,573,550,605,591,555,
 1893,1907,1876],
 [26,33,28,51,67,50,61,97,100,79,94,105,69,85,92,88,89,66,
 76,95,77,53,71,55,104,83,64,108,74,101,73,107,63,84,
 103,72,54,78,96,60,75,65,87,90,91,86,106,93,80,99,81,
 98,62,49,68,52,57],
 [26,33,28,51,100,79,94,69,85,92,88,89,76,95,53,83,64,108,
 101,73,63,72,54,78,60,75,87,90,86,106,93,80,81,62,49,
 68,57,384,481,422,408,541,425,521,476,444,491,371,286,
 472,324,322,331,243,406,319,311,290,616,565,482,597,604,
 567,619,572,545,617,611,528,610,573,550,605,591,555,1388,
 1232,1364,1301,1453,1395],
 [26,33,28,51,100,94,105,69,92,89,66,76,95,53,83,108,74,
 101,73,63,72,78,96,60,90,91,86,106,80,99,81,98,62,68,
 52,57,339,326,369,376,410,395,333,367,399,387,374,380,
 317,341,324,350,331,320,243,406,308,311,303,290,616,565,
 482,597,604,567,619,572,545,617,611,528,610,573,550,605,
 591,555,1310,1324,1385],
 [26,33,28,97,100,79,94,69,85,92,88,89,76,95,55,83,64,108,
 101,73,103,72,54,78,75,65,87,90,86,106,93,80,81,62,49,
 68,57,384,481,422,408,541,425,521,476,444,491,371,286,
 472,334,322,359,255,436,319,295,305,616,575,565,597,596,
 604,619,585,572,617,582,611,610,584,573,605,593,591,1388,
 1232,1364,1301,1453,1395],
 [26,33,28,97,100,79,94,69,85,92,88,89,76,95,77,53,83,64,
 108,101,63,103,72,54,78,60,90,86,106,93,80,81,62,49,68,
 57,384,481,422,408,541,425,346,337,476,444,491,371,286,
 472,324,331,212,243,266,406,311,299,290,306,578,616,565,
 622,597,604,589,619,572,607,617,611,603,610,573,613,605,
 591,1762,1766,1803],
 [26,33,28,97,100,94,69,92,89,76,95,53,83,108,101,63,103,
 72,78,60,90,86,106,80,81,62,68,57,384,481,422,408,541,
 425,346,337,476,444,491,371,286,472,259,272,331,244,293,
 251,217,269,358,290,235,578,537,622,597,604,461,513,583,
 589,540,607,488,487,586,603,548,613,605,591,498,499,576,
 1768,1710,1042,1781,1639,1054,820,1762,1766,1803,2373,1760,
 1933,1354,1663,867,2146,1730,2335,1532,1815,1927,1590,2112,
 1592,1773,949,2801,2548,4189,4289,4182,4885,4126,4283,3550,
 2888,2948,3475,2761,2942,4753,5417,5452],
 [26,33,28,97,100,94,105,69,92,89,66,76,95,53,71,104,83,
 108,74,101,63,103,72,78,96,60,90,86,106,80,99,81,98,62,
 68,52,57,339,326,369,376,410,395,344,399,387,374,380,317,
 341,324,331,243,206,406,311,290,239,578,616,565,622,597,
 604,589,619,572,607,617,611,603,610,573,613,605,591,1502,
 1840,1486,1805,1401,1763],
 [26,33,28,97,100,94,105,69,92,89,66,76,95,55,83,108,74,
 101,73,103,72,78,96,65,90,91,86,106,80,99,81,98,62,68,
 52,57,339,326,369,376,410,395,333,367,399,387,374,380,
 317,341,334,359,350,320,255,436,295,308,303,305,616,575,
 565,597,596,604,619,585,572,617,582,611,610,584,573,605,
 593,591,1310,1324,1385],
 [26,33,36,21,67,97,79,94,69,89,77,55,104,108,107,103,54,
 78,90,86,70,106,93,80,81,98,384,481,444,491,371,334,208,
 240,272,298,304,351,359,309,255,243,266,437,436,277,207,
 269,213,295,226,348,305,290,306,357,575,565,570,614,624,
 596,604,602,598,585,572,608,625,582,611,557,590,581,584,
 573,621,638,593,591,577,587,935,739,1192,1063,714,843,724,
 1344,1289,721,1762,1388,1766,1364,1803,1453,1305,1764,1588,
 1187,1836,1182,1716,1679,1252,1772],
 [26,33,36,51,50,61,97,89,66,76,59,95,53,55,104,83,74,101,
 103,72,60,90,70,106,81,98,62,68,252,376,410,365,344,317,
 208,300,222,280,248,215,261,329,206,216,201,276,277,223,
 262,226,245,228,349,258,192,209,335,343,467,495,451,501,
 469,547,416,513,479,503,450,506,449,538,413,487,510,532,
 452,517,442,539,396,499,576,930,1291,880,704,869,1346,940,
 698,1302,927,1438,832,1439,821,1343,1506,1104,1521,1444,
 1536,1061,1541],
 [26,33,36,51,50,61,97,89,66,76,59,95,53,71,55,104,83,63,
 84,103,72,60,90,91,70,106,81,98,62,68,52,57,252,376,
 410,365,344,317,341,208,222,280,227,230,248,216,201,276,
 277,223,262,250,246,226,258,192,209,467,495,490,451,501,
 469,547,554,416,513,479,503,533,450,506,449,538,507,413,
 487,510,532,563,452,517,442,539,529,396,499,1302,927,1438,
 832,1439,821],
 [26,33,36,51,50,61,97,89,66,76,59,95,53,71,55,104,83,74,
 101,63,84,103,72,96,60,90,70,106,99,81,98,62,68,52,57,
 252,376,410,365,344,317,341,208,300,222,280,248,206,216,
 201,277,287,223,262,226,239,258,192,467,495,451,501,469,
 547,416,513,479,503,450,506,449,538,413,487,510,532,452,
 517,442,539,396,499,1302,927,1438,832,1439,821],
 [26,33,36,51,50,61,97,89,76,59,95,53,71,55,104,83,74,101,
 103,72,96,60,90,70,106,99,81,98,62,68,52,57,252,376,
 410,365,344,317,341,208,300,222,280,248,215,261,216,201,
 277,287,223,262,226,245,228,258,192,467,495,451,501,397,
 469,547,416,513,453,479,503,450,506,412,449,538,413,487,
 448,510,532,452,517,417,442,539,396,499,454,1302,927,1438,
 832,1439,821],
 [26,33,36,51,50,61,100,69,89,66,76,59,95,53,71,55,104,73,
 63,84,103,72,60,86,80,99,81,98,62,68,52,57,252,410,365,
 344,399,373,317,341,229,280,227,230,221,288,294,262,250,
 246,273,239,220,301,469,547,554,416,513,450,506,449,538,
 507,452,517,442,539,529,396,499,1318,794,866,714,1340,776,
 812,721,973,982,857,1277,1287,867,1267,1338,945,1208,1187,
 926,1361,1366,848,1273,1264,949,1235,1252,1571,1495,1373,
 1585,1568,1743,1380,1469,1525,1594,1417,1666,1811,1867,1834]
  ,[26,33,36,51,50,61,100,105,69,89,76,59,95,53,71,55,
 104,108,73,63,84,103,72,96,60,86,80,81,98,62,68,52,57,
 252,410,365,344,399,373,317,341,229,227,230,221,288,276,
 294,273,220,301,209,469,547,416,513,453,450,506,412,449,
 538,442,539,396,499,454,1318,794,714,727,674,1340,776,721,
 736,693,973,857,1277,867,1267,945,1208,902,1096,1290,926,
 1361,848,1273,949,1235,965,1147,1369,1571,1495,1579,1373,
 1585,1648,1568,1743,1628,1787,1380,1469,1624,1525,1594,1584,
 1417,1666,1682,1938,1811,1867,1834],
 [26,33,36,51,67,50,61,97,100,79,94,105,69,92,88,89,66,76,
 59,95,77,53,71,55,104,83,64,108,74,101,73,107,63,84,
 103,72,54,78,96,60,65,87,90,91,86,70,106,93,80,99,81,
 98,62,49,68,52,57],
 [26,33,36,51,100,105,69,89,66,76,59,95,53,71,55,104,108,
 73,63,84,103,72,96,60,91,86,80,99,81,98,62,68,52,57,
 252,410,365,344,399,373,317,341,229,227,230,221,288,406,
 383,294,250,246,273,220,301,469,547,416,513,450,506,449,
 538,452,517,442,539,396,499,1768,1507,1318,794,714,1781,
 1597,1340,776,721,973,982,857,1277,867,1267,945,1208,926,
 1361,848,1273,949,1235,1571,1495,1373,1585,1568,1743,1380,
 1469,1525,1594,1417,1666,1811,1867,1834],
 [26,33,36,67,97,100,69,92,88,89,59,95,55,104,83,64,108,
 73,103,90,86,70,106,80,81,98,62,384,422,425,444,491,371,
 334,298,359,264,309,293,318,255,251,404,437,436,213,295,
 281,348,358,323,305,290,306,235,357,575,565,614,624,596,
 604,602,598,585,572,608,625,582,611,590,581,584,573,621,
 638,593,591,577,587,1710,878,823,1786,1639,861,923,1771,
 1762,1388,1766,1364,1803,1453,857,1277,867,1267,945,1208,
 926,1361,848,1273,949,1235,1579,1648,1628,1624,1584,1682,
 3117,2778,3245,3147,3100,3267],
 [26,33,36,67,97,100,79,94,69,89,59,95,77,55,104,83,108,
 73,107,103,65,87,90,86,70,106,93,80,81,98,62,384,481,
 425,444,491,371,334,240,272,298,359,309,293,318,255,437,
 436,207,269,213,295,348,358,323,305,357,575,565,570,594,
 614,624,596,604,583,602,598,585,572,579,608,625,582,611,
 557,586,590,581,584,573,595,621,638,593,591,576,577,587,
 1762,1388,1766,1364,1803,1453],
 [26,33,36,97,100,69,89,59,95,55,104,83,108,73,103,90,86,
 70,106,80,81,98,62,384,425,444,491,371,334,240,272,298,
 359,309,293,318,255,251,437,436,434,213,295,348,358,323,
 305,235,357,575,565,537,570,614,624,596,604,602,598,585,
 572,540,608,625,582,611,590,581,584,573,548,621,638,605,
 593,591,396,499,577,587,1378,720,809,778,1488,868,795,
 1762,1388,1766,1364,1803,1453,857,1277,1391,1263,1577,867,
 1267,1671,1326,945,1208,1546,926,1361,1591,848,1273,1570,
 1367,949,1235,1140,1556,1991,2289,1579,4189,1373,1585,1648,
 1628,4182,1380,1469,1624,1584,4126,1417,1666,1682,3074,3227,
 3150,3664,3401,3791,3384,3773,3465,3118,4156,4104,3608,3379,
 5168,5979],
 [26,33,36,97,100,79,94,69,92,88,89,59,95,55,104,83,64,
 108,73,103,54,78,65,87,90,86,70,106,93,80,81,98,62,384,
 481,422,425,444,491,371,334,298,322,359,309,255,404,437,
 436,213,319,295,348,305,325,357,616,575,565,614,624,597,
 596,604,602,598,619,585,572,608,625,617,582,611,590,581,
 610,584,573,621,638,605,593,591,577,587,1762,1388,1766,
 1364,1803,1453],
 [26,33,36,97,100,79,94,69,92,88,89,59,95,77,55,104,83,64,
 108,73,107,103,65,87,90,86,70,106,93,80,81,98,62,49,
 384,481,422,425,444,491,371,334,356,298,359,309,293,318,
 255,437,436,434,213,295,348,358,323,305,357,575,565,614,
 624,596,604,602,598,585,572,608,625,582,611,590,581,584,
 573,621,638,593,591,577,587,1762,1388,1766,1364,1803,1453],
 [26,33,39,20,27,32,28,34,21,15,67,61,85,92,88,76,95,71,
 104,107,84,75,65,87,86,106,99,98,340,289,376,389,370,
 360,402,336,344,392,362,363,409,317,338,249,236,334,229,
 248,436,260,226,551,495,500,558,547,518,574,560,503,489,
 562,538,505,571,546,532,514,569,539,502,566,1660,1818,1605 
  ],[26,33,39,36,42,28,38,21,50,97,69,92,89,53,55,83,
 108,101,63,103,72,78,60,90,86,106,80,81,68,57,252,282,
 481,422,408,365,352,425,346,337,476,444,491,472,208,234,
 298,351,243,382,277,253,213,328,226,290,314,578,490,614,
 589,619,572,561,527,507,590,417,605,591,553,480,739,724,
 958,2039,910,2098],
 [26,33,39,36,42,28,38,21,51,50,97,69,92,89,53,55,83,108,
 101,63,103,72,78,60,90,80,81,68,57,252,282,384,422,408,
 365,352,425,521,346,337,476,373,433,444,371,286,472,208,
 234,248,243,382,277,253,213,328,226,290,314,397,493,564,
 448,525,534,590,516,486,630,819,636,863,2299,2305,2169,
 1228,1127],
 [26,33,39,36,42,28,38,21,51,50,97,69,92,89,53,55,83,108,
 101,63,103,72,78,60,90,80,81,68,57,252,282,481,422,408,
 365,352,425,346,337,476,491,472,208,234,248,243,382,277,
 253,213,328,226,290,314,490,453,493,564,619,572,561,527,
 507,525,534,590,417,605,591,553,480,630,819,636,863,1068,
 996,1228,1155,1356,1127,1109,1275,1734,1802],
 [26,33,39,36,42,28,38,21,51,50,97,100,94,69,92,89,76,95,
 53,55,83,108,101,73,63,103,72,78,60,65,90,86,106,80,81,
 62,68,57,252,282,384,481,422,408,541,365,352,425,521,346,
 337,476,373,433,444,491,371,286,472],
 [26,33,39,36,42,28,38,21,51,67,50,61,97,100,94,105,69,92,
 89,66,76,95,53,71,55,104,83,108,74,101,73,107,63,84,
 103,72,78,96,60,65,90,91,86,106,80,99,81,98,62,68,52,
 57],[26,33,42,32,23,51,67,50,61,97,94,85,92,89,76,59,
 53,83,101,73,107,63,84,103,72,54,96,60,90,106,93,80,99,
 81,49,68,52,208,193,300,222,244,280,227,318,277,200,287,
 223,328,319,308,311,299,290,258,220,314,343,819,796,696,
 804,915,1291,863,871,684,810,918,1639,702,979,820,760,736,
 798,2216,3988,2065,2566,2024,4488,2063,2460,2548,3344,3160,
 2066,1946,1918,4300,6066,3850,4201,4483,5040,4148,3441,4433,
 4416,5387,4539,5137,4360],
 [26,33,42,38,23,21,51,67,50,61,97,94,85,92,89,66,76,59,
 53,101,73,107,63,84,72,54,96,60,75,65,90,91,106,80,99,
 81,62,68,52,208,193,300,222,229,280,227,302,318,277,200,
 287,223,328,308,311,260,262,250,321,258,220,343,819,696,
 804,1291,863,684,810,702,979,1346,798,2065,2566,2063,2460,
 2066,4201,3441],
 [26,33,42,38,23,21,51,67,50,61,97,100,79,94,105,69,85,92,
 89,66,76,59,95,53,71,55,83,108,74,101,73,107,63,84,103,
 72,54,78,96,60,75,65,90,91,86,70,106,80,99,81,62,68,
 52,57],
 [26,33,42,38,23,21,51,67,50,97,94,69,85,92,76,59,53,101,
 107,63,60,90,86,70,106,80,282,481,444,491,208,193,307,
 351,229,302,309,293,318,212,243,386,277,200,267,226,321,
 348,358,323,299,290,343,490,570,536,606,614,543,522,609,
 602,572,618,608,507,557,512,417,559,523,600,621,591,615,
 577,739,1063,714,724,1289,721,1321,1540,1519,1236,1498,958,
 1764,1588,1922,2503,1836,910,1679,1931,2703,1772,2283,2437,
 2009,2106,2205,2358,1961,2116,1970,2090,4355,4804,6039,5845,
 5114,5295,4478,4791,5974],
 [26,33,42,38,23,21,51,67,50,97,100,79,94,69,76,59,101,73,
 107,63,60,75,65,90,86,70,106,80,282,384,481,521,433,444,
 491,259,240,307,351,359,302,386,217,207,267,321,348,358,
 323,570,536,592,606,614,543,522,612,618,608,557,512,559,
 523,601,600,621,950,1449,925,1063,1400,1670,892,1421,822,
 1289,1424,1500,1321,1540,1519,1236,1498,1764,2103,2108,1588,
 1922,2503,1836,2353,2740,1716,2203,2054,1679,1931,2703,1772,
 2382,2612,2283,2437,2009,2106,2205,2358,2180,2342,1961,2116,
 1970,2090,6039,5845,5114],
 [26,33,42,38,23,21,51,67,50,97,100,79,94,69,85,92,76,59,
 53,83,101,107,63,72,54,60,75,65,90,86,70,80,282,384,
 481,433,444,491,248,302,318,267,323,314,343,453,564,543,
 522,609,602,534,557,512,600,621,486,553,463,615,577,663,
 915,1291,847,695,701,801,1346,882,753,1498,1188,1343,907,
 1296,1506,981,1861,1131,1290,1175,1521,1119,1383,1444,946,
 1189,1536,931,1819,1243,1369,1300,1541,1060,2117,1979,2148,
 2053,1996,2074,1368,2264,2262,2619,2047,2062,2038,2243,2055,
 2366,1408,2126,2176,2166,5135,8266,5978],
 [26,33,42,38,23,21,67,50,97,94,69,76,59,53,83,101,107,63,
 72,54,60,90,86,70,106,80,282,481,444,491,334,208,193,
 307,351,248,302,318,382,386,436,217,207,267,328,226,321,
 323,343,490,570,536,606,614,453,543,522,609,602,561,473,
 618,608,557,512,620,590,417,559,523,600,621,615,577,644,
 700,670,742,1603,669,718,1524,1321,1540,1282,1519,1236,
 1498,1285,1391,1190,1423,1416,1731,1455,1538,1095,1255,1299,
 1274,1420,1445,1602,1080,2029,1913,1895,1925,1733,2279,1825,
 1905,1841,2980,4471,3308,4202,4595,5272],
 [26,33,51,50,61,100,69,85,89,66,76,59,95,53,55,104,108,
 73,103,72,60,75,86,80,81,98,62,68,252,410,365,399,373,
 317,341,300,229,227,230,215,261,329,206,221,288,276,435,
 386,294,250,246,273,239,220,301,209,335,343,469,547,416,
 513,531,450,506,449,538,452,517,442,539,396,499,1318,794,
 880,714,864,1340,776,721,723,941,829,973,982,857,1277,867,
 1267,1506,945,1208,926,1361,1444,848,1273,949,1235,1019,
 1541,2247,2750,1988,2764,2680,1571,1495,1373,1585,1568,1743,
 1380,1469,1525,1594,1417,1666,2969,2778,3203,3153,2857,3100,
 3499,2958,1811,1867,1834,9383,8368],
 [26,36,23,51,50,61,97,100,94,105,69,92,89,66,59,95,53,71,
 55,108,101,73,63,84,103,78,60,65,90,91,86,70,106,80,99,
 81,57,252,353,339,369,376,365,367,344,373,405,387,380,
 317,298,309,329,437,213,348,349,357,592,594,614,574,583,
 602,612,579,608,571,586,590,601,595,621,566,576,577,1928,
 970,1871,916,1872,909],
 [26,36,23,51,50,61,97,100,94,105,69,92,89,66,76,59,53,55,
 108,101,73,63,84,103,72,96,60,65,90,91,86,70,106,80,99,
 81,68,252,353,339,369,376,365,312,395,367,344,373,405,
 387,380,351,350,318,386,328,308,323,343,592,594,614,574,
 583,602,612,579,608,571,586,590,601,595,621,566,576,577,
 2426,2658,2596],
 [26,36,23,51,50,61,97,100,94,105,69,92,89,66,76,59,53,71,
 55,83,101,73,63,84,103,72,60,65,90,91,86,70,106,80,99,
 81,62,252,353,339,369,376,365,367,344,373,405,387,380,
 317,351,318,329,386,328,323,349,343,594,606,614,583,609,
 602,579,618,608,586,620,590,595,600,621,576,615,577,1928,
 970,1871,916,1872,909],
 [26,36,23,51,50,61,97,100,94,105,69,92,89,95,53,71,55,83,
 108,73,63,84,103,78,96,60,65,90,91,86,70,106,80,99,81,
 62,252,353,339,369,376,365,312,395,344,373,405,387,380,
 317,291,298,304,309,437,238,213,254,348,357,594,614,624,
 583,602,598,579,608,625,586,590,581,595,621,638,576,577,
 587,1840,1805,1763],
 [26,36,23,51,50,97,100,94,69,92,89,95,53,55,83,108,73,63,
 103,78,60,65,90,86,106,80,81,62,252,353,339,369,376,365,
 312,395,344,373,405,387,380,317,300,298,350,206,221,287,
 308,228,348,239,220,565,397,455,594,614,624,554,598,572,
 412,427,625,507,581,573,417,459,595,621,638,529,587,722,
 950,912,1505,892,1122,1379,1840,1805,1763,1667,1577,2103,
 2108,1326,2503,1546,2353,2740,1591,2054,1570,1367,1931,2703,
 1556,2612,2862,2809,4087,2799,3846,2795,3997,3056,4003,3706,
 3778,3993,3366,4175,4815,5342,4791],
 [26,36,23,51,67,50,61,97,82,100,79,94,105,69,92,88,89,66,
 76,59,95,77,53,71,55,83,64,108,74,101,73,107,63,84,103,
 56,72,54,78,96,60,65,87,90,91,86,70,106,93,80,99,81,
 62,49,68,52,57],
 [26,36,23,51,67,50,97,82,100,79,94,69,92,88,89,76,53,55,
 108,101,73,107,63,103,56,72,54,60,65,87,90,86,106,93,
 80,81,68,282,384,481,421,422,352,425,521,428,346,433,444,
 491,393,351,322,318,386,328,319,323,343,592,594,614,574,
 583,602,612,579,608,571,586,590,601,595,621,566,576,577,
 1129,1260,1157],
 [26,36,23,51,67,50,97,82,100,79,94,69,92,88,89,76,77,53,
 55,83,101,73,107,63,103,72,60,65,87,90,86,106,93,80,81,
 62,282,384,481,421,422,352,521,428,346,433,444,491,393,
 371,351,310,293,318,386,328,330,358,323,343,594,606,614,
 583,609,602,579,618,608,586,620,590,595,600,621,576,615,
 577,1540,1519,1498],
 [26,36,23,51,67,50,97,82,100,79,94,69,92,88,89,95,77,53,
 55,108,101,73,107,63,103,78,60,65,87,90,86,106,93,80,
 81,57,282,384,481,421,422,352,521,428,346,433,444,491,
 393,371,298,310,309,293,437,213,330,348,358,357,592,594,
 614,574,583,602,612,579,608,571,586,590,601,595,621,566,
 576,577,1540,1519,1498],
 [26,36,23,51,67,50,97,82,100,79,94,69,92,89,95,77,53,55,
 83,108,73,107,63,103,56,54,78,60,65,87,90,86,106,93,80,
 81,62,282,384,481,421,422,352,425,346,433,444,491,393,
 371,272,298,309,437,269,213,348,357,594,614,624,583,602,
 598,579,608,625,586,590,581,595,621,638,576,577,587,1762,
 1769,1766,1774,1803,1754],
 [26,36,28,51,50,61,97,100,92,89,53,55,104,83,108,74,63,
 103,56,78,96,65,90,86,80,81,98,62,252,339,376,365,395,
 344,387,317,186,234,300,248,261,309,206,288,276,435,202,
 253,287,238,213,328,308,226,228,239,301,209,357,430,501,
 583,598,466,506,426,487,586,581,456,499,576,587,896,630,
 819,696,772,685,889,636,863,684,751,699,2044,832,821,995,
 1003,1104,1134,1098,1025,1071,1074,1061,1066,1140,1051,5052,
 5227,1210,1180,1283,1244,1195,1141,1226,1163,1176,1132,1259,
 1202,2326,2323,2336],
 [26,36,28,51,50,61,97,100,92,89,53,71,55,104,83,108,73,
 63,84,103,56,78,65,90,80,99,81,98,62,252,339,376,365,
 395,344,387,317,186,234,309,206,216,288,202,253,238,213,
 328,239,258,301,357,490,430,501,583,602,598,533,466,506,
 507,426,487,586,590,581,529,456,499,576,577,587,896,630,
 819,772,685,889,636,863,751,699,832,821,995,1228,1003,
 1104,1131,1134,1098,1221,1025,1071,1127,1074,1061,1243,1066,
 1140,1128,1051,1437,1210,1180,1368,1283,1244,1402,1195,1141,
 1307,1226,1163,1408,1176,1132,1336,1259,1202,2326,2323,2336]
  ,[26,36,28,51,50,61,97,100,92,89,66,95,53,71,55,104,83,
 108,74,73,63,84,103,56,78,96,65,86,80,99,81,98,62,252,
 339,376,365,395,344,317,186,234,300,309,270,206,288,202,
 253,287,213,273,239,301,357,335,430,501,583,598,479,466,
 506,426,487,586,581,442,456,499,576,587,630,772,930,685,
 636,751,869,699,832,821,995,1003,1104,1134,1098,1025,1071,
 1074,1061,1066,1140,1051,1210,1180,1283,1244,1195,1141,1226,
 1163,1176,1132,1259,1202,2326,2323,2336],
 [26,36,28,51,50,61,97,100,105,92,89,66,95,53,71,55,104,
 83,108,74,73,63,84,103,56,78,90,86,80,81,98,62,52,252,
 339,376,365,395,344,387,317,186,234,309,329,243,206,288,
 276,202,253,213,290,239,301,209,357,430,501,583,598,466,
 506,426,487,586,581,456,499,576,587,630,772,685,864,636,
 751,699,829,832,821,995,1003,1104,1134,1098,1025,1071,1074,
 1061,1066,1140,1051,1210,1180,1283,1244,1195,1141,1226,1163,
 1176,1132,1259,1202,2326,2323,2336],
 [26,36,28,51,67,50,61,97,82,100,79,94,105,69,92,88,89,66,
 76,95,77,53,71,55,104,83,64,108,74,101,73,107,63,84,
 103,56,72,54,78,96,60,65,87,90,91,86,106,93,80,99,81,
 98,62,49,68,52,57],
 [26,36,28,67,97,82,100,94,92,89,53,104,83,64,108,101,107,
 63,103,56,72,54,78,60,87,90,86,93,81,62,49,68,57,384,
 422,425,346,476,444,371,472,324,193,222,272,298,243,201,
 292,200,223,269,213,319,311,192,278,578,565,397,530,589,
 572,412,508,448,534,603,573,454,486,796,804,983,901,871,
 810,920,897,1271,1281,1111,1197,1245,1072,1137,1108,1227,
 1240,1116,1150,1218,1057,1384,1359,1452,1422,1398,1306,1425,
 1413,1465,1390,1337,1428,2346,2379,2330],
 [26,36,28,67,97,82,100,94,92,89,76,53,104,83,64,108,101,
 63,103,56,72,54,78,90,86,81,62,68,384,422,425,346,476,
 444,371,324,222,272,322,264,255,243,266,251,201,292,404,
 386,200,223,269,319,311,281,192,278,325,343,578,565,397,
 530,589,572,412,508,608,448,534,603,573,454,486,577,788,
 804,983,807,901,697,921,810,920,787,897,664,875,1271,1281,
 1111,1197,1245,1072,1137,1108,1227,1240,1116,1150,1218,1057,
 2120,2348,1384,1359,1452,1422,1398,1306,1425,1413,1465,1390,
 1337,1428,2346,2379,2330],
 [26,36,28,97,82,100,79,94,89,76,53,104,83,64,108,101,63,
 103,56,72,54,78,90,86,81,62,49,68,57,384,422,425,346,
 476,444,371,472,324,222,240,272,255,243,266,201,292,223,
 207,269,311,192,278,578,616,565,397,530,537,589,619,572,
 412,508,540,448,534,504,603,610,573,454,486,497,804,983,
 807,901,697,810,920,787,897,664,1271,1281,1111,1954,1197,
 1245,1829,1072,1137,1887,1108,1227,1945,1240,1116,1842,1150,
 1218,1864,1057,1384,1359,1703,1452,1422,1685,1398,1306,1688,
 1425,1413,1693,1465,1390,1684,1337,1428,1691,2346,2379,2330]
  ,[26,36,28,97,82,100,79,94,92,76,77,53,104,83,64,108,
 101,107,63,103,56,72,54,78,60,87,90,86,81,62,49,68,57,
 384,425,346,476,444,371,472,356,324,222,272,307,243,251,
 201,292,223,269,267,311,235,192,278,578,565,397,530,570,
 589,572,412,508,448,534,557,603,573,454,486,804,750,983,
 901,810,769,920,897,1271,1281,1111,1197,1245,1072,1137,
 1108,1227,1240,1116,1150,1218,1057,1384,1359,1452,1422,1398,
 1306,1425,1413,1465,1390,1337,1428,2346,2379,2330],
 [26,39,20,28,23,51,67,50,61,97,94,92,88,66,76,95,77,53,
 71,55,83,101,63,56,72,78,60,75,90,106,93,80,99,81,49,
 68,52,186,208,222,259,248,264,261,302,243,266,206,216,
 267,214,262,250,290,306,239,258,314,343,663,720,719,876,
 754,670,974,703,847,707,845,695,801,1346,882,717,941,753,
 1785,2293,2023,1991,2376,2444,2093,2087,2418,2056,2586,2118,
 2559,2061,4517,3482,3369,3359,3631,3539,3966,3514,3777,3508,
 5945,5758,5055,5798],
 [26,39,36,28,38,67,97,100,92,89,76,83,64,101,103,56,72,
 78,60,87,86,81,62,49,57,384,422,346,476,444,371,472,324,
 186,234,222,272,264,215,243,201,292,437,202,253,223,269,
 295,311,303,262,281,245,273,192,278,357,578,565,397,530,
 589,572,412,508,448,534,603,573,563,454,486,784,804,752,
 719,983,901,765,810,694,709,776,920,897,1271,1281,1111,
 1197,1305,1245,1072,1137,1108,1227,1240,1182,1116,1150,1218,
 1057,2917,2914,1384,1359,1452,1422,1398,1306,1425,1413,1465,
 1390,1337,1428,2346,2379,2330],
 [26,39,42,28,23,51,67,50,61,97,94,92,66,76,95,77,53,71,
 83,74,101,73,107,63,84,56,72,78,96,60,75,90,106,93,80,
 99,81,49,68,186,208,300,222,259,302,243,206,216,386,202,
 277,287,223,217,267,311,214,262,290,239,258,314,335,663,
 804,720,719,695,701,810,710,709,801,869,753,1500,1785,
 1974,1801,1957,3268,4591,5405],
 [26,39,42,28,38,23,51,67,50,61,97,82,100,94,69,85,92,89,
 83,64,108,101,73,107,63,103,56,72,78,96,60,75,65,106,
 80,99,81,62,49,68,57,300,291,298,351,359,350,331,227,
 261,435,287,238,213,328,295,308,311,250,273,239,258,335,
 794,866,726,776,812,702,941,2750,2764],
 [26,39,42,28,38,23,51,67,50,61,97,82,100,94,105,69,85,92,
 89,66,76,95,53,71,55,83,64,108,74,101,73,107,63,84,103,
 56,72,78,96,60,75,65,90,91,86,106,80,99,81,62,49,68,
 52,57],
 [26,39,42,28,38,23,51,67,50,61,97,94,92,95,83,101,73,107,
 63,56,72,78,96,60,75,65,90,106,80,99,81,49,68,186,208,
 300,222,259,359,350,202,277,287,267,238,213,295,308,311,
 214,262,250,228,239,258,314,335,663,896,630,804,720,719,
 876,866,726,701,889,636,810,715,757,812,702,801,869,1346,
 1021,725,753,1500,2455,2371,1785,1974,2293,3538,2411,2529,
 2797,2347,3243,3268,2289,2745,3058,8792,8774,4591,8931,7835,
 5270,7458,7454,5668,5159,4216,8776,7669,8748,7016,7135,9197,
 7875,4953,6411,6693,7307,8373,6538,6946,6944,7064,7965,7949,
 6385],
 [26,39,42,28,38,23,51,67,50,61,97,94,105,92,95,53,71,83,
 73,107,63,84,56,72,78,96,60,75,65,106,80,99,81,49,68,
 52,186,208,222,259,331,270,206,216,202,277,223,217,267,
 238,213,311,214,262,250,246,273,239,258,314,343,663,896,
 630,720,719,876,761,695,701,889,636,710,709,853,747,757,
 801,1346,753,2371,1785,2293,2529,1801,2252],
 [26,39,42,28,38,23,51,67,50,61,97,94,105,92,95,53,71,83,
 101,73,107,63,84,56,72,78,96,60,75,65,106,80,99,81,49,
 68,52,186,208,222,259,331,270,206,216,202,277,223,217,
 267,238,213,311,214,262,250,273,239,258,314,343,663,896,
 630,720,719,876,695,701,889,636,710,709,853,757,801,1346,
 753,2371,1785,2293,2529,1801,2252],
 [26,39,42,28,38,23,51,67,50,82,100,89,66,76,95,55,64,108,
 74,101,73,107,103,56,72,78,96,60,75,65,106,62,57,315,
 279,240,215,261,206,216,201,276,203,404,437,435,383,294,
 287,223,217,207,295,308,260,335,877,815,959,644,879,712,
 845,919,704,662,957,1023,1246,1786,1505,938,895,1048,665,
 765,684,843,776,1771,1379,2167,2111,2271,2716,1989,2129,
 2476,2345,2563,4808,4553,4098,2107,2070,2137,2914,4616,4290,
 3588,5562,5361,3916,5208,8293,5499,6076,5622,8476,5314,5431,
 6030,7791,6694,8591,7497,8245,6258],
 [26,39,42,28,38,23,51,67,50,82,100,105,69,85,89,66,76,95,
 64,108,74,101,73,107,84,103,56,72,78,96,60,75,65,91,86,
 106,62,52,57,315,279,240,359,350,331,229,215,201,276,203,
 404,437,383,294,253,207,295,308,311,260,245,325,357,877,
 794,919,957,1023,1246,938,776,792,932,1151,2476,2269],
 [26,39,42,28,38,23,51,67,50,89,95,83,64,108,73,107,78,90,
 62,49,68,282,425,444,472,279,240,215,255,212,243,203,294,
 207,245,290,187,464,551,490,430,515,441,570,526,558,509,
 543,572,511,560,447,561,473,474,562,507,483,557,519,546,
 470,559,523,535,569,468,553,587,877,761,942,879,674,900,
 938,747,884,890,693,806,1321,2138,1282,2201,1236,2153,1426,
 1699,907,958,1073,1446,1392,937,1316,988,1077,1290,1250,
 1018,1155,1443,1722,946,910,1067,1406,1415,1009,1224,1369,
 1295,886,1109,2294,2285,2338,2314,2170,2159,2523,2229,1979,
 1460,1625,1996,2317,2262,1447,1510,2062,2429,2055,1441,1575,
 2176,2505,2841,2488,3053,2787,2512,2277,3249,2757,2729,2413,
 3109,2746,2487,2372,3108,2631,6065,4600,6773,8683,7945,4996,
 4696,8248,5444,7628,4494,9346,5573,6660],
 [26,39,42,28,38,23,51,67,50,97,69,85,55,83,64,108,103,56,
 72,78,60,75,65,90,62,49,68,57,282,384,425,476,433,444,
 472,186,208,234,240,307,230,203,202,277,253,246,226,281,
 245,397,496,530,441,570,453,493,508,447,561,448,525,417,
 462,552,470,559,739,764,824,809,859,1246,724,728,802,868,
 883,1151,1271,1321,1282,1566,1236,1262,948,1667,1280,850,
 1671,1356,936,1538,1169,952,1738,1360,856,1570,1275,860,
 1602,1410,1656,1513,1727,1387,1606,1561,1753,1382,1611,1551,
 1712,9139,8074,8428],
 [26,39,42,28,38,23,51,67,50,97,82,100,69,85,89,95,55,64,
 108,73,107,103,56,72,78,60,75,90,62,49,68,57,282,384,
 476,433,444,472,229,230,215,253,245,301,187,554,416,453,
 493,509,543,413,448,525,470,559,396,454,516,468,553,877,
 942,737,714,674,938,884,755,721,693,1236,899,1426,1699,
 1016,1446,1392,993,1506,1187,902,1290,1250,1008,1443,1722,
 928,1406,1415,1038,1536,1252,965,1369,1295,1821,1981,1979,
 1910,1782,1996,2074,1750,2144,2262,1899,1791,2062,1810,1944,
 2055,2366,1848,1888,2176,5445,6072,4294],
 [26,39,42,28,38,23,51,67,50,97,82,100,94,55,83,64,108,
 101,56,72,78,60,75,65,90,81,57,282,384,352,425,476,433,
 472,222,259,240,307,248,264,215,382,404,437,223,217,226,
 281,245,321,397,496,530,441,570,453,493,508,447,561,448,
 525,417,462,552,470,559,814,809,859,1603,1786,1505,757,
 868,883,1524,1771,1379,1271,1068,1281,996,1566,1262,948,
 1667,1280,850,1671,1356,936,1538,1169,952,1738,1360,856,
 1570,1275,860,1602,1410,1656,1513,1727,1387,1606,1561,1753,
 1382,1611,1551,1712,1866,1917,1844],
 [26,39,42,28,38,23,51,67,50,97,82,100,94,69,85,92,89,66,
 76,95,83,64,108,74,101,73,107,63,103,56,72,78,96,60,75,
 65,81,62,49,68,57,315,300,359,350,331,261,288,201,276,
 435,383,287,295,308,311,273,239,258,301,192,209,335,794,
 866,726,776,812,702,941,2750,2764],
 [26,39,42,28,38,23,51,67,50,97,94,55,64,108,101,63,56,72,
 78,60,75,90,106,81,57,282,352,425,476,472,186,208,222,
 259,307,351,382,404,437,202,277,223,217,207,328,260,226,
 281,321,325,357,490,397,496,441,570,614,447,561,507,448,
 525,590,417,462,470,559,700,935,739,764,814,859,1603,705,
 843,757,883,1524,996,1391,958,1073,948,1667,850,1671,1455,
 936,1538,952,1738,1445,856,1570,860,1602,3330,3335,4700,
 3376,1733,1678,1410,1656,1513,1727,1825,1387,1606,1561,1753,
 1841,1382,1611,1551,1712,5149,3227,3287,2871,4471,4825,3664,
 3181,2666,4202,1866,1917,1844,4135,9160,4297,4595,4356,5178,
 3552,5272],
 [26,39,42,28,38,23,51,67,50,97,94,95,55,83,64,108,101,63,
 56,72,78,60,75,90,106,81,49,68,282,541,352,425,476,186,
 208,222,259,307,382,386,202,277,223,217,226,281,321,490,
 451,397,496,441,570,447,561,608,507,413,448,525,452,417,
 462,470,559,739,764,814,859,1603,1670,724,728,757,883,
 1524,1500,838,996,1391,958,1073,948,1667,850,1671,936,1538,
 2740,1299,910,1067,952,1738,856,1570,860,1602,2612,1733,
 1678,1692,1410,1656,1578,1513,1727,1626,1387,1606,1905,1641,
 1632,1561,1753,1675,1382,1611,1587,1551,1712,2181,1866,2142,
 1917,2231,1844],
 [26,39,42,28,38,23,51,67,82,100,105,69,85,89,66,76,95,64,
 108,74,101,73,107,84,103,56,72,78,96,60,75,65,91,86,
 106,62,52,57,324,315,279,240,359,350,331,229,215,201,276,
 203,404,437,406,383,294,253,207,295,308,311,260,245,325,
 357,877,794,919,957,1023,1246,938,776,792,932,1151,2476,
 2269],
 [26,39,42,28,38,23,681,706,51,67,50,97,82,100,53,71,55,
 83,64,108,56,72,78,60,75,65,49,68,57,2591,1700,2569,
 1806,282,384,352,425,476,433,472,234,222,259,230,248,264,
 288,201,276,253,223,217,246,226,281,301,192,209,397,496,
 530,518,453,493,412,485,508,505,448,525,417,462,552,502,
 454,516,1271,1068,1281,996,1566,1484],
 [26,39,42,28,38,51,67,50,97,69,85,89,55,104,64,108,103,
 56,72,78,60,75,90,98,49,68,57,282,384,476,433,444,472,
 186,208,234,229,230,248,264,215,288,203,382,253,207,328,
 260,246,226,281,245,301,187,314,397,496,554,453,493,509,
 543,412,485,447,561,448,525,483,557,563,417,462,470,559,
 454,516,468,553,700,819,754,670,863,741,669,1271,1281,
 1282,1566,1236,1102,1343,1416,1455,1299,1445,1448,1913,1925,
 2148,3015,2606,2519,2498,2700,4264,4956,5544,5521],
 [26,39,42,38,51,67,50,97,89,59,95,104,83,64,108,73,107,
 78,65,90,70,98,62,49,68,282,384,425,444,472,222,259,240,
 215,302,255,212,203,386,311,245,321,305,299,187,343,464,
 551,441,570,526,558,509,543,572,511,560,447,561,474,562,
 519,546,470,559,591,535,569,468,553,877,761,942,879,974,
 703,809,674,900,938,884,890,1021,725,868,693,806,1321,
 2138,1282,2201,1236,2153,1426,1699,958,1073,1446,1392,937,
 1316,850,1671,1290,1250,1018,1155,1443,1722,1406,1415,1009,
 1224,856,1570,1369,1295,886,1109,2828,3075,2469,2652,2747,
 2457,1979,1996,2262,2062,2055,2176,3287,2871,3181,2666],
 [26,42,28,38,23,51,67,50,61,82,100,79,105,69,85,89,55,64,
 108,101,73,107,84,103,56,72,54,78,96,60,75,65,91,86,
 106,80,99,62,52,57,279,234,240,291,298,351,359,350,229,
 227,203,294,253,207,238,213,328,295,308,260,250,245,273,
 325,357,824,794,922,772,802,776,980,751,1151,3050,2924],
 [27,34,25,58,51,67,50,61,97,82,100,79,94,105,85,92,88,89,
 66,76,59,95,77,53,71,104,83,64,108,74,102,73,107,63,84,
 103,56,72,54,78,96,75,65,87,90,91,86,70,106,93,80,99,
 98,62,49,68,52],
 [27,34,25,58,51,67,61,97,82,100,79,105,85,88,59,95,77,71,
 104,64,102,73,107,84,103,72,54,96,75,65,87,91,70,106,
 93,99,98,340,316,381,375,389,402,345,392,411,377,368,327,
 338,240,291,310,404,207,238,330,325,592,606,614,574,609,
 602,612,618,608,571,620,590,601,600,621,566,615,577,1757,
 1407,1796,1496,1835,1504],
 [27,34,25,58,51,67,61,97,82,100,79,105,85,92,88,59,95,77,
 71,64,74,102,73,107,84,54,96,75,65,87,91,70,106,93,99,
 52,340,316,381,375,389,402,366,332,392,411,377,368,327,
 338,291,302,310,309,404,238,321,330,348,325,556,592,606,
 549,574,609,527,612,618,544,571,620,568,601,600,480,566,
 615,1371,1331,1314],
 [27,34,25,58,51,67,61,97,82,100,79,105,85,92,88,66,77,71,
 64,74,102,73,107,84,103,56,72,96,75,65,87,91,70,106,93,
 99,49,340,316,381,375,389,402,345,366,332,392,411,377,
 368,327,304,351,293,435,254,328,358,335,556,592,606,549,
 574,609,527,612,618,544,571,620,568,601,600,480,566,615,
 1862,1908,1891],
 [27,34,25,58,51,67,61,97,82,100,79,105,85,92,88,66,95,77,
 71,104,74,102,73,107,84,56,96,75,65,87,91,70,106,93,99,
 98,340,316,381,375,389,402,366,332,392,411,377,368,327,
 338,304,302,309,293,435,254,321,348,358,335,592,594,606,
 574,583,609,612,579,618,571,586,620,601,595,600,566,576,
 615,1371,1331,1314],
 [27,34,25,58,67,50,61,82,79,94,105,85,88,59,77,53,71,104,
 64,102,107,63,84,54,78,96,75,87,90,91,86,70,93,80,99,
 98,471,289,372,492,443,475,336,347,424,542,409,423,484,
 385,307,291,298,310,404,267,238,213,330,325,592,606,614,
 574,609,602,612,618,608,571,620,590,601,600,621,566,615,
 577,1800,1759,1767],
 [27,34,25,58,67,50,61,82,79,94,105,85,88,89,66,76,77,53,
 71,104,74,102,107,63,84,56,96,75,87,90,91,86,70,93,80,
 99,98,471,289,372,492,443,475,520,424,542,409,423,484,
 385,304,293,318,435,254,358,323,335,592,594,606,574,583,
 609,612,579,618,571,586,620,601,595,600,566,576,615,1404,
 1442,1303,1350,1237,1372],
 [27,34,25,58,67,50,61,82,79,94,105,85,88,89,66,76,77,71,
 64,74,102,107,63,84,56,78,96,75,87,90,91,86,70,93,80,
 99,49,471,289,372,492,443,475,336,347,520,424,542,409,
 423,484,304,359,293,435,254,295,358,335,556,592,606,549,
 574,609,527,612,618,544,571,620,568,601,600,480,566,615,
 2436,2517,2595],
 [27,34,25,58,67,50,61,82,79,94,105,85,88,89,76,59,77,53,
 71,64,74,102,107,63,84,54,96,75,87,90,91,86,70,93,80,
 99,52,471,289,372,492,443,475,520,424,542,409,423,484,
 385,291,310,318,404,238,330,323,325,556,592,606,549,574,
 609,527,612,618,544,571,620,568,601,600,480,566,615,1404,
 1442,1303,1350,1237,1372],
 [27,34,25,58,67,61,82,79,105,85,88,59,77,71,104,64,102,
 107,84,54,96,75,87,91,70,93,99,98,471,289,372,492,443,
 475,336,347,424,542,409,423,484,385,234,291,359,270,216,
 253,295,245,330,273,258,575,500,496,592,606,614,547,602,
 585,489,485,608,538,590,584,514,462,601,600,621,539,577,
 824,1062,1635,1786,1040,1708,1771,1800,1759,1767,948,1764,
 1577,2103,1588,1922,1836,1546,2353,1716,2203,856,1679,1367,
 1931,1772,2382,2511,2776,4470,3881,4663,3771,4535,3913,3006,
 2811,3399,2963,2748,3569,5312,5347,4762],
 [27,34,58,67,61,79,105,85,88,66,76,59,95,71,104,74,102,
 107,84,56,54,96,75,65,87,70,99,98,49,52,340,289,381,
 389,370,360,402,336,366,392,362,363,411,409,338,249,236,
 334,186,240,229,248,206,436,207,260,214,258,301,551,495,
 537,531,574,560,503,540,504,571,546,532,548,497,566,720,
 754,704,710,702,884,741,882,698,1797,1564,1612,1555,1011,
 1542,881,1454,1024,1511,967,1526,1027,1348,911,2065,2694,
 2063,2712,2402,3558,3700],
 [27,34,58,67,61,82,79,105,85,59,77,53,71,104,64,74,102,
 107,84,54,96,75,90,91,86,70,93,99,98,52,471,289,372,
 492,443,360,475,336,347,520,424,363,542,484,385,236,324,
 307,298,310,318,201,406,267,238,213,245,323,325,495,501,
 513,574,609,503,506,487,571,620,517,499,566,615,896,824,
 922,808,889,802,980,799,792,834,1033,811,840,968,964,1056,
 1870,1145,1861,1239,1955,1105,1897,1083,1819,1193,1937,2359,
 2110,1683,1698,1711],
 [27,34,58,67,61,82,79,105,85,66,77,53,71,104,64,74,102,
 107,84,56,96,75,90,91,86,70,93,99,98,49,471,289,372,
 492,360,475,336,347,520,424,363,542,409,423,484,385,236,
 324,307,298,293,318,201,406,254,245,323,192,335,495,501,
 513,574,609,503,506,487,571,620,532,517,499,566,615,793,
 824,930,859,912,762,816,869,785,1490,992,1069,1056,1870,
 1145,1861,1239,1955,1105,1897,1083,1819,1193,1937,2511,2602,
 2031,2397,2177,4313,4704],
 [27,34,58,82,79,105,85,88,66,76,59,95,64,74,102,107,84,
 56,54,96,65,91,70,99,98,49,52,340,289,381,389,370,360,
 336,366,392,362,363,411,409,368,338,249,236,356,315,240,
 229,248,212,266,216,288,436,207,308,303,258,301,551,495,
 537,531,574,560,503,540,504,571,546,532,548,497,566,2045,
 696,752,750,800,714,847,635,697,684,694,769,903,882,628,
 664,1436,1450,1315,1555,1011,1542,881,1454,1024,1511,967,
 1526,1027,1348,911,6074,2454,5457,2445],
 [27,35,25,51,61,97,82,79,85,88,77,55,104,83,64,74,73,107,
 84,103,56,72,54,96,65,87,91,106,99,98,62,49,52,316,389,
 345,392,362,377,338,249,356,208,300,240,291,212,251,203,
 277,287,207,238,328,308,235,187,588,575,500,455,580,585,
 489,427,505,465,599,584,502,431,819,696,750,635,863,684,
 769,628,818,831,1050,1139,1064,1059,1078,1082,1026,1094,
 1124,1092,999,1005,1194,1258,1110,1167,1184,1222,1117,1199,
 1242,1292,1185,1233,2320,2370,2343],
 [27,35,25,58,51,67,50,61,97,82,100,79,94,105,85,92,88,89,
 66,59,95,77,53,71,55,104,83,64,108,74,102,73,107,63,84,
 103,56,72,54,78,96,75,65,87,90,91,70,106,93,80,99,81,
 98,62,49,68,52],
 [27,35,25,58,67,50,61,82,85,88,77,53,71,55,104,64,102,
 107,63,84,103,54,75,87,93,80,99,81,98,471,372,443,475,
 347,424,423,385,279,193,310,270,206,221,294,200,267,238,
 254,273,239,220,325,495,490,451,574,609,602,503,533,450,
 538,507,413,571,620,590,539,529,396,566,615,577,663,896,
 793,922,808,701,889,816,980,799,1266,1286,1056,1870,1228,
 1145,1861,1131,1239,1955,1221,1105,1897,1127,1083,1819,1243,
 1193,1937,1128,1697,1437,1358,1683,1368,1467,1687,1402,1432,
 1698,1307,1397,1696,1408,1430,1711,1336,1389,2337,2344,2378]
  ,[27,35,25,58,67,50,61,82,85,88,89,59,77,53,71,55,104,
 64,108,102,107,63,84,103,54,78,75,91,93,80,99,81,98,
 471,372,443,475,347,424,385,279,193,234,310,266,270,221,
 294,200,253,238,306,273,220,325,357,490,451,574,602,560,
 533,450,507,413,571,590,569,529,396,566,577,896,922,772,
 808,889,980,751,799,1266,1286,1056,1228,1145,1131,1239,
 1221,1105,1127,1083,1243,1193,1128,1437,1358,1368,1467,1402,
 1432,1307,1397,1408,1430,1336,1389,2337,2344,2378],
 [27,35,25,58,67,50,61,82,94,85,88,89,59,77,53,71,55,104,
 64,108,102,107,63,84,103,54,87,91,93,99,81,98,68,471,
 372,443,475,347,424,423,385,279,193,310,318,212,270,221,
 201,294,200,238,299,273,220,192,325,490,451,574,602,533,
 450,507,413,571,590,529,396,566,577,896,922,808,873,889,
 980,799,798,1266,1286,1056,1228,1145,1131,1239,1221,1105,
 1127,1083,1243,1193,1128,1437,1358,1368,1467,1402,1432,1307,
 1397,1408,1430,1336,1389,2337,2344,2378],
 [27,35,25,61,97,82,79,85,88,66,95,77,55,104,64,73,107,84,
 103,56,54,87,91,99,98,62,49,52,316,389,345,392,362,377,
 338,249,356,208,300,240,229,227,309,329,212,243,288,251,
 203,436,277,287,207,308,260,250,301,235,187,588,575,500,
 455,580,585,489,427,505,465,599,584,502,431,2045,696,750,
 685,864,635,901,684,769,699,829,628,897,818,831,1050,1139,
 1064,1059,1078,1082,1026,1094,1124,1092,999,1005,6074,5457,
 1194,1258,1110,1167,1184,1222,1117,1199,1242,1292,1185,1233,
 2320,2370,2343],
 [27,35,25,61,97,82,100,79,85,66,95,77,55,104,83,64,74,73,
 107,84,103,56,72,54,96,65,87,91,99,98,62,49,52,316,345,
 392,362,377,338,249,334,356,300,240,272,212,288,251,203,
 287,207,269,308,301,235,187,588,575,500,455,441,580,585,
 489,427,505,465,483,599,584,502,431,696,862,750,635,684,
 939,769,628,818,831,1050,1139,1064,1059,1078,1082,1026,
 1094,1124,1092,999,1005,1194,1258,1110,1167,1184,1222,1117,
 1199,1242,1292,1185,1233,2320,2370,2343],
 [27,35,25,61,97,82,100,79,88,66,77,55,104,83,64,74,107,
 84,103,56,72,54,87,91,99,98,62,49,52,316,389,345,392,
 362,377,338,249,356,300,259,240,329,212,243,251,203,287,
 217,207,308,235,187,588,578,575,500,455,530,580,589,585,
 489,427,508,505,465,534,599,603,584,502,431,486,696,750,
 864,635,901,684,769,829,628,897,818,831,1050,1111,1139,
 1064,1245,1059,1078,1137,1082,1026,1227,1094,1124,1116,1092,
 999,1218,1005,1194,1258,1359,1110,1167,1422,1184,1222,1306,
 1117,1199,1413,1242,1292,1390,1185,1233,1428,2320,2370,2343]
  ,[27,35,25,67,61,82,85,88,77,53,71,55,104,64,102,107,
 63,84,103,54,75,87,91,93,99,81,98,68,372,443,475,347,
 424,423,385,342,324,279,193,280,310,318,270,221,201,388,
 406,294,200,253,267,238,254,262,323,273,220,325,578,490,
 451,574,602,533,450,607,507,413,571,590,529,396,566,577,
 877,663,896,793,922,808,938,701,889,816,980,799,792,1266,
 1286,1056,1228,1145,1131,1239,1221,1105,1127,1083,1243,1193,
 1128,2359,2110,1437,1358,1368,1467,1402,1432,1307,1397,1408,
 1430,1336,1389,2337,2344,2378],
 [27,35,34,58,51,67,50,61,97,82,100,79,94,105,85,92,88,89,
 66,59,95,77,53,71,104,83,64,108,74,101,102,73,107,63,
 84,103,56,72,54,78,96,75,65,87,90,91,70,106,93,80,99,
 98,62,49,68,52,57],
 [27,35,34,58,51,67,61,82,79,85,92,66,59,77,104,83,64,74,
 101,107,56,72,54,96,75,65,87,91,70,62,49,52,57,340,289,
 316,370,336,345,362,411,409,377,249,208,300,272,247,248,
 261,251,292,277,287,269,231,226,228,235,278,500,530,441,
 570,518,564,509,543,489,508,447,561,505,534,483,557,514,
 552,470,559,502,486,468,553,1436,1450,1315],
 [27,35,34,58,51,67,61,82,100,79,85,92,66,77,71,104,83,64,
 74,101,107,56,72,54,96,75,65,87,91,99,49,52,340,289,
 316,402,336,345,362,411,409,377,249,300,272,247,248,261,
 251,292,382,386,287,269,231,226,228,235,278,314,343,500,
 455,530,441,518,477,564,509,489,427,508,447,505,465,534,
 483,514,459,552,470,502,431,486,468,818,831,934],
 [27,35,34,58,51,67,61,82,100,105,85,92,88,66,59,77,104,
 64,102,73,107,84,56,72,54,96,75,65,87,91,93,98,62,49,
 52,57,340,289,316,389,370,402,336,345,392,362,411,409,
 377,249,193,229,227,230,221,200,260,250,246,220,500,530,
 570,518,564,543,489,508,561,505,534,557,514,552,559,502,
 486,553,1862,1908,1891],
 [27,35,34,58,51,67,61,82,105,85,92,88,66,59,71,83,64,101,
 102,73,107,84,56,72,54,96,75,65,87,91,99,62,49,52,57,
 340,289,316,389,370,392,362,411,409,377,338,249,208,193,
 227,221,277,200,250,220,500,530,537,556,518,564,531,549,
 489,508,540,527,505,534,504,544,514,552,548,568,502,486,
 497,480,1436,1404,1371,1450,1303,1331,1315,1237,1314],
 [27,35,34,58,67,50,61,82,79,85,59,77,53,71,104,64,108,74,
 107,103,56,54,78,96,75,87,70,80,99,49,68,52,471,372,
 432,360,475,347,355,363,542,283,236,279,234,300,272,247,
 215,261,251,292,294,253,287,269,231,245,228,235,278,451,
 500,397,530,416,518,453,564,450,489,412,508,413,505,448,
 534,452,514,417,552,396,502,454,486,1033,840,964],
 [27,35,34,58,67,50,61,97,82,79,94,66,59,77,53,71,104,64,
 108,74,102,84,103,56,54,78,75,91,70,93,80,98,49,68,52,
 471,372,492,432,360,475,347,520,355,363,484,283,236,259,
 264,215,276,217,281,245,209,490,501,500,530,554,513,518,
 564,533,506,489,508,507,487,505,534,563,517,514,552,529,
 499,502,486,1558,1033,1266,840,1286,964],
 [27,35,34,58,67,50,61,97,82,79,94,66,59,77,53,71,104,64,
 108,74,107,103,56,54,78,96,87,91,70,80,99,49,52,471,
 372,432,360,475,347,355,363,423,283,236,300,272,247,215,
 261,251,292,437,287,269,231,245,228,235,278,357,515,451,
 500,530,461,416,518,564,524,450,489,508,488,413,505,534,
 494,452,514,552,498,396,502,486,1558,1266,1286],
 [27,35,34,58,67,50,61,97,82,79,94,105,88,59,77,53,71,104,
 64,108,74,102,63,84,103,56,54,78,96,75,87,70,93,98,49,
 68,52,471,372,492,475,347,520,355,363,542,423,484,283,
 236,259,264,201,276,217,281,192,209,500,397,530,518,453,
 564,489,412,508,505,448,534,514,417,552,502,454,486,851,
 837,839,826,789,891],
 [27,35,34,58,67,61,82,79,85,66,59,77,104,64,74,107,56,54,
 96,75,87,91,70,49,52,471,372,432,360,347,355,363,542,
 423,283,236,279,234,300,272,215,251,292,437,295,231,245,
 228,357,575,451,500,530,570,509,543,450,489,508,561,483,
 557,584,452,514,552,559,468,553,784,692,722,880,778,921,
 1347,672,715,1101,890,940,795,875,1308,2145,2197,2127,1870,
 1091,1011,1391,1143,1262,1416,1216,1280,1955,1156,1024,1455,
 1231,1356,1299,1087,1169,1819,1065,1027,1445,1254,1360,1448,
 1168,1275,2355,2497,2639,2327,2692,2582,2196,2328,2404,4757,
 2488,3349,3576,2512,2999,4612,2757,3164,4476,2413,3302,3549,
 2487,2793,4645,2631,3251],
 [27,35,34,58,67,61,82,105,85,88,66,59,71,64,102,107,84,
 56,54,96,75,87,91,99,49,52,340,289,316,389,370,392,362,
 411,409,377,338,249,334,193,240,229,230,309,436,207,260,
 250,246,551,500,530,537,556,416,531,549,574,598,540,527,
 413,504,544,571,581,546,514,552,548,568,396,497,480,566,
 587,876,742,1029,853,718,961,1436,1404,1371,1450,1303,1331,
 1315,1237,1314,1111,1143,1044,1262,1216,1280,1231,1121,1356,
 1087,1169,1116,1254,1201,1360,1168,1275,2028,2099,1894,1653,
 1892,1790,1462,1827,1778,1580,1880,2546,3023,3321,2686,2887,
 2539,3201,3290,2721,3933,3925,3498],
 [27,35,58,67,97,82,105,66,77,53,71,55,104,64,102,63,84,
 103,56,96,75,91,93,81,98,49,52,57,471,432,475,347,355,
 542,283,324,315,193,234,259,227,230,293,318,270,201,276,
 200,253,250,246,281,358,323,273,192,357,551,451,501,455,
 530,416,513,427,508,413,487,452,517,459,552,663,764,772,
 703,859,1023,701,728,751,920,903,725,883,932,1033,840,
 1870,1044,1262,1861,1162,1280,1121,1356,1897,986,1169,1819,
 1526,1201,1360,1036,1275,2215,1942,2078,2092,1692,1713,1578,
 1586,1626,1719,1632,1485,1675,1735,1587,1543,3023,3112,2261,
 2268,2237,3375,3835,4068,3386,3783,4081],
 [28,23,58,51,50,100,85,92,76,95,55,108,102,73,63,103,56,
 72,54,78,75,65,86,93,80,81,68,57,282,422,541,346,476,
 371,472,356,279,186,193,234,229,244,288,382,404,434,294,
 202,200,269,319,295,260,214,246,306,314,325,490,430,500,
 397,554,458,489,412,507,426,573,563,478,514,417,870,796,
 784,761,879,900,914,747,861,890,806,791,838,1954,1197,
 1143,958,1216,937,1887,1231,1018,1087,910,1842,1254,1009,
 1168,886,2479,2033,2639,2440,2582,1678,1460,1728,1412,1734,
 1447,1641,1411,1644,1441,1802,1414,4475,4740,2763,4730,4330,
 4334,2781,4253,2181,2142,2231,4722,4302],
 [29,15,97,82,100,94,69,92,89,76,95,53,83,108,101,63,103,
 72,78,60,90,86,106,80,81,98,62,68,57,339,369,481,376,
 422,410,395,521,344,346,399,387,380,491,317,371,341,300,
 259,331,320,310,221,406,287,217,330,290,220,578,637,622,
 597,554,461,589,626,607,617,507,488,603,623,613,605,529,
 498,1768,793,1710,1042,1781,816,1639,1054,817,1840,1805,
 1763,2448,2373,2395,1933,1207,1983,2146,2515,2335,1241,2228,
 1927,2089,2112,1138,3674,4188],
 [29,15,97,100,79,94,69,92,89,76,95,53,83,108,101,63,103,
 72,78,60,90,86,106,80,81,62,49,68,57,353,384,326,481,
 421,408,312,521,428,337,405,444,374,491,393,286,272,331,
 244,293,251,276,406,269,358,290,235,209,578,537,570,637,
 622,597,589,626,607,617,603,548,559,623,613,605,1768,1710,
 1042,697,1781,1639,1054,820,664,1540,1502,1519,1486,1498,
 1401,2448,2373,1263,2395,1933,1983,2146,2515,2335,2228,1927,
 1396,2089,2112,2801,2548,1777,2283,1742,2205,1736,1961,4196,
 3844,3494],
 [29,17,37,20,41,35,19,18,30,13,25,51,50,69,92,53,55,102,
 73,63,60,65,80,81,98,289,376,410,541,336,367,344,399,
 476,409,380,317,341,472,291,304,212,238,254,299,616,464,
 467,597,526,469,453,477,619,511,479,527,617,474,449,448,
 465,610,519,510,568,605,535,442,454,431,1621,1569,1807,
 2448,1093,2395,1225,1983,1077,2515,1142,2228,1319,2089,1085,
 1599,1466,1552],
 [29,18,15,58,51,50,97,82,100,94,105,69,85,89,66,95,55,
 104,108,101,103,56,78,96,60,75,65,90,91,86,106,57,252,
 339,369,367,373,387,380,240,298,247,248,215,309,203,292,
 437,207,213,231,226,245,348,187,278,357,455,537,441,592,
 594,477,531,509,574,583,427,540,447,612,579,465,504,483,
 571,586,459,548,470,601,595,431,497,468,566,576,904,970,
 929,916,1118,909],
 [29,18,15,58,51,50,97,82,100,94,105,69,85,92,76,55,108,
 101,102,73,63,96,60,75,65,90,91,86,70,106,81,68,252,
 339,369,365,395,367,373,387,307,291,304,351,302,310,309,
 386,267,238,321,330,348,323,537,441,556,592,594,531,509,
 527,612,579,504,483,548,470,568,601,595,925,1192,1063,
 1670,822,1344,1289,1500,1174,1013,1362,1764,1577,1081,1588,
 1326,1345,1836,1546,1223,1716,1591,1203,1679,1367,1215,1772,
 1556,1777,1838,1851,1823,1742,1779,1953,1904,1736,1775,1877,
 1839,2157,2178,2199],
 [29,18,15,58,51,50,97,82,100,94,105,69,85,92,76,59,55,
 104,108,101,63,72,75,65,90,91,86,70,106,81,68,252,339,
 369,365,395,373,387,307,291,351,247,248,302,310,329,255,
 292,386,267,238,231,226,321,330,323,349,305,537,441,592,
 594,513,531,509,612,579,504,483,517,548,470,601,595,925,
 1063,1347,1670,822,1289,1308,1500,1174,1013,1764,1577,1588,
 1326,1836,1546,1716,1591,1679,1367,1772,1556,1777,1838,1851,
 1823,1742,1779,1953,1904,1736,1775,1877,1839,2157,2178,2199]
  ,[29,18,15,58,51,50,97,82,100,94,105,69,89,66,59,95,55,
 104,108,101,102,73,103,56,78,96,60,75,65,90,91,86,106,
 98,57,252,339,369,367,373,387,380,259,240,298,215,309,
 221,203,437,217,207,213,245,348,220,187,357,537,441,592,
 594,531,509,574,583,540,447,612,579,504,483,571,586,548,
 470,601,595,497,468,566,576,904,970,929,916,1118,909],
 [29,18,15,58,51,50,97,82,100,94,105,69,89,66,59,95,55,
 108,101,102,73,78,96,60,75,65,90,91,86,70,106,57,252,
 339,369,367,373,387,380,259,240,298,215,302,310,309,203,
 437,217,207,213,245,321,330,348,187,357,537,441,556,592,
 594,531,509,549,574,583,540,447,527,612,579,504,483,544,
 571,586,548,470,568,601,595,497,468,480,566,576,904,970,
 929,916,1118,909],
 [29,18,15,58,51,50,97,82,100,94,105,69,92,76,55,104,108,
 101,102,73,63,72,96,60,75,65,90,91,86,106,81,98,68,252,
 339,369,365,395,367,373,387,259,307,291,351,386,217,267,
 238,321,330,323,455,537,441,592,594,612,579,465,504,483,
 459,548,470,601,595,814,1062,925,1063,1670,757,1040,822,
 1289,1500,1013,1044,1219,948,1764,1577,1588,1326,1836,1546,
 986,1217,952,1716,1591,1679,1367,1772,1556,1713,1869,1777,
 1838,1865,1851,1823,1882,1742,1779,1485,1878,1953,1904,1850,
 1736,1775,1879,1877,1839,2157,2178,2199],
 [29,18,15,79,94,105,69,92,88,89,66,76,95,77,53,101,107,
 63,72,54,78,96,60,87,90,91,106,93,80,81,62,49,68,57,
 326,421,408,337,374,393,286,356,324,208,331,229,244,280,
 243,216,434,406,277,311,260,214,262,290,258,588,578,482,
 464,637,622,567,526,580,589,545,511,626,607,528,474,599,
 603,550,519,623,613,555,535,1502,1769,1486,1774,1401,1754],
 [29,18,15,79,94,105,69,92,88,89,66,76,95,83,64,101,63,72,
 54,78,96,60,90,91,106,93,80,81,62,49,68,57,326,421,408,
 337,374,393,286,324,208,322,359,331,280,243,266,216,406,
 277,319,295,311,262,290,306,258,588,578,616,482,464,637,
 622,597,567,526,580,589,619,545,511,626,607,617,528,474,
 599,603,610,550,519,623,613,605,555,535,1502,1769,1486,
 1774,1401,1754],
 [29,18,15,79,94,105,69,92,89,66,76,95,101,63,72,78,96,60,
 87,90,91,106,81,62,49,68,57,326,421,408,337,393,286,324,
 208,322,359,331,229,244,280,264,293,243,216,406,277,269,
 319,295,311,262,281,358,290,258,235,192,588,578,482,464,
 637,622,567,526,580,589,545,511,626,607,528,474,599,603,
 550,519,623,613,555,535,498,870,887,716,714,803,914,721,
 820,1502,1769,1486,1774,1401,1754,2373,1933,1225,2146,2335,
 1927,2112,2673,2428,2507,2435,2923,2926],
 [29,18,15,94,105,69,92,72,106,326,369,351,243,437,386,267,
 238,213,323,349,305,290,556,592,594,580,589,619,527,612,
 579,465,504,483,512,568,601,595,623,613,605,924,663,896,
 630,719,761,794,866,726,1063,733,674,919,704,662,1015,701,
 889,636,822,1053,1198,776,812,702,669,760,693,1379,1500,
 828,1013,1401,1763,1539,1229,1079,857,1177,905,1102,907,
 1139,1091,1055,1158,1354,1205,1234,867,1081,1588,1326,1595,
 1206,1419,945,1082,1156,951,1089,1532,1355,1106,926,1241,
 1017,1100,946,1223,1716,1591,1322,1070,1317,848,1092,1065,
 984,1002,1592,1349,1363,949,1215,1772,1556,2753,2362,2432,
 2030,3446,3902,2376,2469,2474,2476,2345,2563,2461,2442,2718,
 1993,3616,3268,2745,2457,2377,2269,2007,2478,4130,4874,4225,
 2223,2276,1972,1258,1703,1623,1550,2973,3077,4189,1865,1851,
 1823,2106,3804,4690,4075,1222,1688,1508,1516,2951,2852,4182,
 2227,2848,1935,1878,1953,1904,2342,3927,4770,4032,1292,1684,
 1638,1562,3001,2785,4126,1879,1877,1839,2090,3130,4058,4263,
 3081,2488,3815,2724,3151,4052,4338,3143,2512,3391,2630,2944,
 3224,4065,3061,2757,4088,2557,3207,4010,4615,2988,2413,4140,
 2699,3149,4113,4793,3317,2487,3299,2524,2925,3223,4026,3073,
 2631,4111,2510,5179,4842,1926,4372,4349,5655,1965,2157,1915,
 4590,4624,5783,2037,2178,1921,4721,4473,5679,2014,2199,2646,
 3579,3639,2732,2843,2755,3009,2749,2885,4133,4166,3179,2882,
 2899,3334,2695,2683,3668,3729,2805,2800,2783,3264,2661,2494,
 4089,3712,3226,2626,2697,3013,2861,2685,3632,3948,2804,2788,
 2803,3209,2635,2641,3611,3447,3206,2688,2863,3161,2614,3784,
 5817,3861,5397,4226,3752,4657,3761,3956,4799,4673,3936,3444,
 5008,3865,5157,3842,4193,4529,3870,3866,4524,4442,3871,3677,
 5778,3996,5509,4174,3928,4803,3961,4204,4712,4707,3941,5210,
 4279,5244,5230,5277,4341,5566,5317,5513,4851,5375,5494],
 [29,18,15,94,105,69,92,88,89,66,76,95,77,53,83,64,101,63,
 72,54,78,96,60,90,91,106,93,80,81,62,49,68,57,326,421,
 408,337,374,393,286,324,208,193,331,280,243,266,216,406,
 277,200,311,262,290,306,258,588,578,616,482,464,637,622,
 597,567,526,580,589,619,545,511,626,607,617,528,474,599,
 603,610,550,519,623,613,605,555,535,1502,1769,1486,1774,
 1401,1754],
 [29,18,15,94,105,69,92,89,66,76,95,101,63,72,78,96,60,90,
 91,106,81,68,57,326,421,408,337,286,324,208,322,359,331,
 280,264,243,216,406,277,200,319,295,311,262,281,290,258,
 314,325,588,578,482,464,592,594,637,622,567,526,469,531,
 509,580,589,545,511,626,607,528,474,504,483,599,603,550,
 519,623,613,555,535,431,497,468,788,878,915,922,963,861,
 801,980,1502,1769,1006,1486,1774,828,1401,1754,972,2373,
 1183,1933,1253,1207,1457,2146,1096,2335,1230,1186,1927,1213,
 1179,2112,1147,1103,1393,4470,4087,1765,2310,2265,4663,3846,
 1788,2707,2361,4535,3997,1824,2186,2222,2542,2648],
 [29,20,15,50,92,88,89,66,76,95,77,53,71,55,73,107,63,103,
 78,65,87,91,86,93,80,99,81,62,49,68,57,421,408,364,428,
 393,286,334,356,279,234,229,244,280,230,270,288,436,434,
 294,253,260,214,262,246,273,301,588,464,551,467,430,515,
 526,558,469,458,461,511,560,479,466,524,626,474,562,449,
 426,488,519,546,510,478,494,535,569,442,456,498,1232,888,
 1301,825,1395,833],
 [29,20,15,51,67,50,92,88,89,66,76,95,77,53,71,55,64,108,
 73,107,63,103,54,78,65,91,86,93,80,99,81,62,49,68,57,
 237,421,408,364,428,393,286,279,193,234,229,230,266,270,
 288,294,200,253,260,246,306,273,301,464,551,430,515,526,
 558,458,461,511,560,466,524,474,562,426,488,519,546,478,
 494,535,569,456,498,1232,888,1301,825,1395,833],
 [29,20,15,51,67,50,92,88,89,66,76,95,77,53,71,55,73,107,
 63,103,78,65,87,91,86,80,99,81,62,49,68,57,237,421,408,
 364,428,393,286,279,234,229,244,280,230,270,288,251,294,
 253,260,214,262,246,273,301,235,464,551,467,430,515,526,
 558,469,458,461,511,560,479,466,524,474,562,449,426,488,
 519,546,510,478,494,535,569,442,456,498,1232,888,1301,825,
 1395,833],
 [29,20,15,58,97,82,100,94,69,85,92,89,66,76,53,71,104,83,
 101,102,63,103,56,72,60,75,90,91,86,70,106,80,99,81,62,
 339,369,376,344,387,380,317,324,304,351,331,318,243,292,
 386,406,254,328,311,323,290,278,343,578,616,594,606,622,
 597,583,609,589,619,579,618,607,617,586,620,603,610,595,
 600,613,605,576,615,970,1840,916,1805,909,1763],
 [29,20,15,97,82,100,94,69,85,92,89,66,76,53,71,104,83,
 101,63,103,56,72,90,91,86,70,106,80,99,81,98,62,339,
 369,376,344,387,380,317,324,304,351,331,318,255,212,243,
 386,406,254,328,311,323,305,299,290,343,588,578,616,594,
 606,637,622,597,583,609,580,589,619,579,618,626,607,617,
 586,620,599,603,610,595,600,623,613,605,576,615,970,1840,
 916,1805,909,1763],
 [29,20,15,97,82,100,94,69,85,92,89,66,76,59,53,71,83,101,
 102,63,103,60,75,90,91,86,70,106,80,99,81,62,339,369,
 376,344,387,380,317,342,324,351,331,310,309,318,243,386,
 388,406,328,311,330,348,323,290,343,578,616,556,594,606,
 622,597,549,583,609,589,619,527,579,618,607,617,544,586,
 620,603,610,568,595,600,613,605,480,576,615,970,1840,916,
 1805,909,1763],
 [29,20,15,97,82,100,94,92,89,66,76,59,53,71,83,101,63,
 103,90,91,86,106,80,99,81,98,62,339,376,344,387,380,317,
 324,222,259,351,331,320,247,318,255,212,243,221,386,406,
 328,311,231,330,348,323,305,299,290,220,343,578,616,501,
 594,606,622,597,583,609,589,619,579,618,607,617,586,620,
 603,610,595,600,613,605,576,615,1062,950,759,1040,892,
 1021,725,817,970,1840,916,1805,909,1763,2448,2395,1983,
 2515,2228,1396,2089,3012,2459,2797,2347,3682,3286],
 [29,20,15,97,94,92,89,66,76,53,71,83,101,63,103,90,91,86,
 106,80,99,81,62,376,344,387,380,317,324,186,208,351,331,
 247,318,243,292,386,406,202,277,328,311,231,323,305,299,
 290,343,578,616,467,594,606,622,597,526,558,583,609,589,
 619,579,618,607,617,474,562,449,586,620,603,610,478,494,
 568,595,600,613,605,535,569,576,615,1334,1112,1347,1198,
 918,1344,1308,970,1840,916,1805,1807,909,1763,2448,1035,
 1093,1044,2395,1162,1983,1121,2515,1136,1142,986,2228,1179,
 1201,2089,1036,4210,3626,1495,1460,1625,3637,1447,1510,3300,
 1469,1552,1441,1575,3123,2786,2900,8251,8902,7760,3055,2843,
 2800,2829,2788,8136,8100,6371],
 [29,20,18,51,50,94,69,92,89,76,95,53,55,83,101,73,63,72,
 78,60,65,90,106,80,81,62,68,57,252,369,376,410,541,365,
 367,399,476,373,380,317,341,472,291,304,280,247,212,292,
 238,254,299,258,278,588,482,556,567,526,469,453,477,580,
 545,527,528,448,465,599,550,568,555,535,442,454,431,924,
 726,733,1015,702,760,763,1310,1324,1385,1079,857,1234,1534,
 867,1225,1419,945,1106,1548,926,1317,848,1363,1665,949,
 1085,2415,2420,2104,1765,2387,1788,2399,1824,3313,2664,2923,
 3350,2891,2926,3454,4220,3577],
 [29,20,18,51,50,97,100,94,69,92,89,76,95,53,55,83,108,
 101,73,63,103,72,78,60,65,90,86,106,80,81,62,68,57,237,
 252,353,339,326,369,481,421,376,408,410,541,364,365,312,
 395,333,367,521,428,344,337,399,476,361,373,405,387,374,
 380,491,393,317,286,341,472],
 [29,20,18,51,50,100,94,85,89,66,76,59,95,53,55,104,108,
 101,102,73,63,103,72,78,75,91,86,70,106,80,81,98,62,68,
 57,252,369,410,541,365,367,344,399,476,380,317,341,472,
 342,279,229,270,388,294,260,273,464,467,430,451,526,469,
 458,416,511,479,466,450,474,449,426,413,519,510,478,452,
 535,442,456,396,1433,927,973,832,982,821],
 [29,20,18,51,50,100,94,88,89,76,95,77,53,55,64,108,74,
 101,73,107,63,103,72,78,87,86,106,93,80,81,62,49,68,52,
 57,237,326,408,364,333,521,428,337,374,491,393,286,356,
 279,229,270,434,294,260,273,464,467,430,451,526,469,458,
 416,511,479,466,450,474,449,426,413,519,510,478,452,535,
 442,456,396,2449,1737,888,2393,1650,825,2414,1732,833],
 [29,20,18,51,67,50,94,69,92,88,89,76,95,77,53,55,108,101,
 73,107,63,103,78,60,65,87,86,106,93,80,81,62,49,68,52,
 57,237,326,481,421,408,364,333,521,428,361,374,491,393,
 286,279,229,244,227,270,294,260,214,250,273,464,551,467,
 526,558,469,511,560,479,474,562,449,519,546,510,535,569,
 442,1232,1301,1395],
 [29,20,18,51,67,50,97,69,92,88,89,76,95,77,53,55,83,101,
 73,107,63,103,72,60,65,87,90,106,93,80,81,62,49,68,52,
 57,237,326,481,421,408,364,333,521,428,361,374,491,393,
 286,208,244,280,227,216,277,214,262,250,258,464,467,495,
 526,469,547,511,479,503,474,449,538,519,510,532,535,442,
 539,1232,1301,1395],
 [29,20,18,51,67,50,97,94,88,89,76,95,77,53,55,83,64,74,
 101,73,107,63,103,72,78,90,106,93,80,81,62,49,68,52,57,
 237,481,421,408,364,333,521,428,337,374,491,393,286,208,
 280,266,216,277,262,306,258,464,467,430,451,526,469,458,
 416,511,479,466,450,474,449,426,413,519,510,478,452,535,
 442,456,396,1475,888,1468,825,1463,833],
 [29,20,18,51,67,50,100,69,92,88,89,76,95,77,53,55,64,108,
 74,101,73,107,63,103,72,60,65,86,106,93,80,81,62,49,68,
 52,57,237,481,421,408,364,333,521,428,337,361,374,491,
 393,286,279,229,266,270,294,260,306,273,464,467,495,526,
 469,547,511,479,503,474,449,538,519,510,532,535,442,539,
 1475,1468,1463],
 [29,20,18,58,51,50,94,69,85,92,89,66,76,59,95,53,55,108,
 101,102,73,63,103,78,60,75,65,91,86,70,106,80,81,98,62,
 68,57,252,369,376,410,541,365,367,344,373,380,317,341,
 472,279,320,229,270,294,303,260,273,464,551,467,526,558,
 469,511,560,479,474,562,449,519,546,510,535,569,442,1302,
 2138,1438,2201,1439,2153],
 [29,20,18,58,51,50,97,69,85,92,89,66,76,59,95,53,55,83,
 101,102,73,63,103,72,60,75,65,90,91,70,106,80,81,98,62,
 68,57,252,369,376,410,541,365,367,344,373,380,317,341,
 472,208,320,280,216,277,303,262,258,464,467,495,526,469,
 547,511,479,503,474,449,538,519,510,532,535,442,539,1302,
 2138,1438,2201,1439,2153],
 [29,20,18,58,51,50,97,94,85,89,66,76,59,95,53,55,104,83,
 101,102,73,63,103,72,78,90,91,70,106,80,81,98,62,68,57,
 252,376,410,541,365,367,344,399,476,380,317,341,472,208,
 280,212,216,277,262,299,258,464,467,430,451,526,469,458,
 416,511,479,466,450,474,449,426,413,519,510,478,452,535,
 442,456,396,1621,927,1569,832,1807,821],
 [29,20,18,58,51,50,100,69,85,92,89,66,76,59,95,53,55,104,
 108,101,102,73,63,103,72,60,65,91,86,70,106,80,81,98,
 62,68,57,252,376,410,541,365,367,344,399,476,373,380,317,
 341,472,279,229,212,270,294,260,299,273,464,467,495,526,
 469,547,511,479,503,474,449,538,519,510,532,535,442,539,
 1621,1569,1807],
 [29,20,18,97,94,69,92,89,76,95,53,55,83,101,103,72,78,60,
 65,90,106,80,81,62,68,57,326,481,421,408,364,521,428,
 337,361,374,491,393,286,322,280,264,266,277,319,281,306,
 258,325,335,578,575,594,614,622,596,526,469,531,589,619,
 585,607,582,474,449,504,603,610,584,595,621,613,593,535,
 442,497,924,726,922,930,733,1015,702,760,3977,1502,4254,
 1486,4212,1401,1079,857,1234,867,1253,1419,945,1106,926,
 1230,1317,848,1363,949,1147,2071,2132,2175,2251,4225,4087,
 2799,4075,3846,2795,4032,3997,3056,3103,3310,2616,3003,3403,
 2674],
 [29,20,18,100,94,69,92,89,76,95,53,55,108,101,103,72,78,
 60,65,86,106,80,81,62,68,57,326,481,421,408,364,333,337,
 361,374,491,393,286,322,229,264,266,404,435,319,306,273,
 325,335,578,575,594,614,622,596,526,469,531,589,619,585,
 579,608,607,582,504,603,610,584,595,621,613,593,535,442,
 497,1318,794,714,1340,776,721,717,3977,1762,1769,4254,1766,
 1774,4212,1803,1754,1079,857,1205,1234,867,1253,1419,945,
 1355,1106,926,1317,848,1349,1363,949,1147,2884,2375,4225,
 2104,1765,4075,2387,1788,4032,2399,1824,3103,3310,2616,3003,
 3403,2674,2921,3868,3894],
 [29,20,28,23,15,97,94,69,85,66,76,53,71,101,63,103,56,72,
 60,75,91,86,106,81,237,369,364,344,361,387,324,351,229,
 318,243,201,276,386,202,277,207,311,260,323,192,209,343,
 578,616,500,594,606,518,583,609,589,619,506,489,579,618,
 449,505,603,610,514,595,600,499,502,576,615,1160,924,804,
 983,1063,901,705,810,920,1289,897,1433,970,973,916,982,
 909,857,1111,1954,1764,1245,1829,1588,1326,1922,1137,1887,
 1836,1227,1945,1116,1842,1679,1367,1931,1218,1864,1772,2008,
 2974,2536,3076,2741,1180,1777,1244,1851,1141,1742,1163,1132,
 1736,1202,1877,4106,4355,3839,4804,2950,3745,4843,3958],
 [29,20,28,38,15,58,51,67,50,97,82,100,79,94,69,85,92,88,
 89,66,76,95,53,71,55,104,83,64,108,101,102,73,107,63,
 103,56,72,54,78,60,75,65,87,90,91,86,106,80,99,81,98,
 62,49,68,57],
 [29,20,28,38,15,58,51,67,94,69,85,92,88,53,71,55,83,56,
 72,54,78,60,75,65,87,106,98,49,68,57,324,279,186,208,
 193,320,244,280,230,247,248,264,270,206,216,267,238,213,
 328,303,214,262,246,231,226,281,192,209,187,314,663,896,
 630,819,716,668,737,915,983,1084,754,670,742,712,695,802,
 757,745,671,755,801,920,1101,741,669,718,872,698,645,2357,
 2371,1990,1916,1889,2023,3562,2206,2794,2139,1923,2041,2292,
 3436,2296,2504,1934,2080,3396,4301,6061,5154,3237,3834,6001,
 5980],
 [29,20,28,38,15,58,51,67,97,69,85,92,88,66,76,55,83,101,
 56,72,54,78,60,75,65,87,106,81,57,324,186,208,193,234,
 359,350,320,244,280,247,248,264,215,302,270,292,404,437,
 267,328,295,308,303,214,262,231,226,281,273,278,325,357,
 663,819,866,726,716,668,915,983,754,670,742,879,957,1023,
 1603,812,702,745,671,801,920,741,669,718,792,932,1524,
 2247,3538,1916,1889,2023,2794,2345,2563,1988,3243,1923,2041,
 2292,2504,2007,2478,5871,3396,4301,3916,5808,5048,3237,3834,
 3908,3895,8518,6030,6546,6788],
 [29,20,31,42,32,19,18,30,15,25,51,100,64,108,72,60,49,68,
 252,289,339,336,312,395,344,313,337,373,374,317,354,286,
 222,248,201,223,295,226,192,588,575,495,500,496,455,493,
 503,489,485,427,538,505,525,465,599,610,584,462,539,502,
 516,431,784,765,1475,1433,777,834,1339,1468,973,975,811,
 977,1297,982,991,968,779,1288,1050,1954,1139,1064,1059,
 1078,1082,1026,1945,1094,2228,1322,1124,1092,999,1005,2124,
 1599,1697,2374,1194,1258,1683,1110,1167,1466,1687,2311,1184,
 1222,1717,1698,2263,1117,1199,2097,1696,1242,1292,1647,1711,
 2191,1185,1233,4758,4128,5683,4160,2040,8271,2050,9404,2068,
 9241,3276,2906,3247,2897,4635,3260,2733,4982,5320,5105,6069,
 5084,4994,5109,5934,5789,5522,5839,5692,8328,8227],
 [29,20,32,23,21,58,51,67,50,97,82,100,79,94,69,85,92,88,
 89,76,59,95,77,53,71,55,83,108,74,101,102,73,107,63,
 103,56,72,54,78,60,75,65,87,90,86,70,106,93,80,99,81,
 62,68,52,57],
 [29,20,32,23,58,82,94,69,89,71,55,108,74,101,102,103,56,
 78,106,80,99,81,68,52,57,369,367,380,317,341,334,259,
 240,351,359,248,382,436,217,207,328,295,305,299,290,314,
 616,575,496,455,537,597,596,493,477,485,427,617,582,525,
 465,504,610,584,462,459,605,593,516,431,1318,935,1334,
 1112,1710,794,1084,919,1340,843,1198,918,1639,776,1101,721,
 872,1613,1310,1833,1324,1645,1385,1601,857,1555,1158,1933,
 1354,1534,867,1542,1039,1454,1089,1548,926,1511,1249,1927,
 1322,1649,848,1526,1002,1665,949,1348,1103,2818,3039,2134,
 2770,2402,2274,2780,2265,2580,2361,2412,2222,3478,2888,3594,
 2761],
 [29,20,32,51,67,50,97,69,88,89,95,77,53,71,55,83,64,108,
 74,73,103,72,54,78,60,87,90,93,80,62,49,68,52,57,237,
 353,364,312,337,361,405,286,230,264,215,276,203,277,200,
 253,281,245,301,209,187,461,416,493,477,485,427,488,413,
 462,459,498,396,516,431,924,788,877,942,674,1015,963,938,
 884,693,813,835,1093,899,1225,1016,1077,902,1142,1008,1319,
 928,1085,965,1429,1409,1574,1435,1554,1394,1515,1440,1493,
 1418,1636,1458,2208,2207,2154],
 [29,20,32,51,67,50,97,94,95,77,53,71,55,83,64,108,74,101,
 72,54,78,60,90,106,93,99,81,49,68,52,57,237,408,364,
 312,337,286,208,193,222,307,248,264,215,302,201,382,277,
 200,223,267,226,281,245,321,192,314,464,515,451,501,496,
 455,461,416,513,493,477,524,450,506,485,427,474,488,413,
 487,525,465,494,452,517,462,459,498,396,499,516,431,888,
 989,825,977,833,779],
 [29,20,32,51,67,50,97,100,79,69,89,95,77,53,71,55,83,64,
 108,74,103,72,54,78,60,90,80,62,49,68,52,57,237,353,
 364,312,337,361,405,286,230,248,264,215,276,203,253,226,
 281,245,301,235,209,187,461,416,513,493,477,485,427,488,
 413,487,462,459,498,396,499,516,431,877,942,887,674,938,
 884,874,693,813,835,1093,899,1183,1225,1016,1253,1077,902,
 1096,1142,1008,1230,1319,928,1213,1085,965,1147,1429,1409,
 1574,1435,1554,1394,1515,1440,1493,1418,1636,1458,2208,2207,
 2154],
 [29,20,32,51,67,50,97,100,79,69,89,95,77,53,71,55,83,108,
 74,73,72,54,78,60,90,80,62,49,68,52,57,237,353,364,312,
 337,361,405,286,244,230,264,215,302,251,276,203,253,281,
 245,321,301,235,209,187,461,416,513,493,477,506,485,427,
 488,413,517,462,459,498,396,499,516,431,877,942,803,674,
 938,884,820,693,813,835,1093,899,1225,1016,1077,902,1142,
 1008,1319,928,1085,965,1495,1429,1409,1585,1574,1435,1743,
 1554,1394,1469,1515,1440,1594,1493,1418,1666,1636,1458,2208,
 2207,2154],
 [29,20,32,51,67,50,97,100,79,94,95,77,53,71,55,83,64,108,
 74,101,72,54,78,60,90,106,93,99,81,68,52,57,237,353,
 408,364,312,337,286,222,307,248,264,215,302,201,382,404,
 223,267,226,281,245,321,192,314,325,515,451,501,496,455,
 461,416,513,493,477,524,450,506,485,427,488,413,487,525,
 465,494,452,517,462,459,498,396,499,516,431,888,989,825,
 977,833,779],
 [29,20,32,51,67,50,97,100,79,94,95,77,53,71,55,83,64,108,
 74,101,107,63,72,54,78,60,87,90,106,99,81,49,68,52,57,
 237,353,408,364,312,337,286,222,272,307,248,302,251,201,
 382,223,269,267,226,321,235,192,314,515,451,496,455,461,
 416,493,477,524,450,485,427,488,413,525,465,494,452,462,
 459,498,396,516,431,888,989,825,977,833,779],
 [29,20,32,51,97,69,89,95,53,71,55,83,108,74,73,103,78,60,
 90,80,62,68,52,57,237,353,364,312,361,405,286,230,264,
 215,266,276,203,404,253,319,281,245,306,301,209,187,325,
 616,575,501,461,416,493,477,619,585,506,485,427,488,413,
 610,584,517,462,459,498,396,516,431,497,877,942,670,742,
 674,938,871,884,669,718,693,813,835,1601,857,1093,899,
 1225,1016,1104,1542,1039,1741,945,1077,902,1454,1089,1142,
 1008,1071,1649,848,1319,928,1526,1002,1085,965,1140,1348,
 1103,2640,2567,1429,1409,1574,1435,1477,1554,1394,1688,1633,
 1515,1440,1493,1418,1684,1673,1636,1458,1370,2945,3125,2934,
 3090,3230,2966,2208,2207,2154,5294,3275,9088,3279,3016,8741,
 2913,3398,7703,3202,5416,3141,2962,7411,3038,3354,5580,5495,
 9247,8723,5100,7649,5756,9147,6751,9252,7371,6883,6531,7300,
 8997],[29,20,32,51,97,100,79,94,95,77,53,71,55,83,108,
 74,101,107,63,78,60,90,106,99,81,68,52,57,353,408,364,
 312,337,286,356,324,222,272,307,248,302,309,293,266,251,
 201,382,404,223,267,226,321,348,358,306,192,314,325,588,
 515,451,496,455,461,416,493,477,524,450,485,427,488,413,
 525,465,494,452,462,459,498,396,516,431,750,983,778,921,
 769,920,795,875,888,989,825,977,833,779,995,1104,1064,
 1098,1071,1061,1124,1140],
 [29,20,32,82,94,69,85,92,89,76,59,95,71,55,104,108,74,
 101,102,73,103,78,75,65,86,70,106,80,99,81,98,62,68,52,
 57,369,376,410,367,380,317,341,342,334,279,359,229,310,
 255,270,388,436,294,295,260,330,305,273,616,575,551,467,
 597,596,558,469,619,585,560,479,617,582,562,449,610,584,
 546,510,605,593,569,442,1310,1302,1324,1438,1385,1439],
 [29,20,32,82,94,69,85,92,89,95,71,55,104,108,74,101,73,
 103,56,78,86,70,106,80,99,81,98,62,68,52,57,369,376,
 367,380,317,341,334,279,298,304,359,229,255,212,243,270,
 436,294,213,254,295,260,305,299,290,273,588,616,575,551,
 467,594,637,597,596,558,469,580,619,585,560,479,626,617,
 582,562,449,586,599,610,584,546,510,623,605,593,569,442,
 1310,1302,1324,1438,1385,1439],
 [29,20,32,82,94,69,89,76,59,95,71,55,108,74,101,102,73,
 103,78,106,80,99,81,62,68,52,57,369,410,367,380,317,341,
 334,279,359,229,310,255,212,243,270,292,388,436,294,295,
 260,330,305,299,290,273,258,220,278,616,575,551,467,597,
 596,558,469,619,585,560,479,617,582,562,449,610,584,546,
 510,605,593,569,442,1482,726,1010,759,1661,702,979,817,
 1310,1302,1324,1438,1385,1439,1093,899,1225,1016,1077,902,
 1142,1008,1319,928,1085,965,1885,2017,1787,2163,1858,1938,
 2637,2597,2425,2768,2516,2568],
 [29,20,32,94,69,85,92,89,76,59,95,71,55,108,74,101,102,
 73,103,78,75,65,86,70,106,80,99,81,98,62,68,52,57,369,
 376,410,367,380,317,341,342,334,279,359,320,229,255,270,
 388,436,294,295,303,260,305,273,616,575,464,551,467,597,
 596,526,558,469,619,585,511,560,479,617,582,474,562,449,
 610,584,519,546,510,605,593,535,569,442,1310,1302,1324,
 1438,1385,1439],
 [29,20,32,94,69,89,95,71,55,108,74,101,73,103,78,106,80,
 99,81,62,68,52,57,369,367,380,317,341,334,279,298,304,
 359,229,255,212,243,270,292,436,294,202,295,260,305,299,
 290,273,278,616,575,551,467,556,594,597,596,558,469,619,
 585,560,479,527,617,582,562,449,610,584,546,510,568,605,
 593,535,569,442,516,431,1160,692,912,1192,1238,1122,1344,
 1310,1302,1324,1438,1385,1439,2448,1093,899,1073,1044,2395,
 1225,1016,1326,1983,1077,902,2515,1142,1008,2228,1319,928,
 1367,2089,1085,965,999,3544,3568,1885,2104,1574,1435,2017,
 1787,2387,1515,1440,2163,1858,2399,1636,1458,1938,3495,2871,
 4145,2666,3557,2644,4339,2615,2774,3378,2610,2665,4526,2738,
 7293,7271],
 [29,20,32,95,73,62,68,52,57,286,341,229,280,227,230,201,
 276,203,253,223,260,301,526,558,469,461,416,513,489,485,
 427,540,488,413,487,519,546,510,498,396,499,2045,877,959,
 925,1334,862,1400,893,1042,733,727,674,957,1023,1246,1963,
 765,684,810,822,1198,884,1424,947,1054,798,787,792,932,
 1151,1232,1302,813,1833,2448,2373,1539,1229,1093,899,1183,
 2395,1933,1354,1205,1064,1829,1059,1052,1983,2146,1595,1206,
 1077,902,1096,1231,1155,1121,1332,2515,2335,1532,1355,1026,
 1945,1094,1126,2228,1927,1322,1070,1319,928,1213,2089,2112,
 1592,1349,999,1864,1005,1154,1168,1109,1036,1284,2167,2111,
 2828,2694,2473,2294,3258,2443,1930,2234,2627,2464,2107,2070,
 2652,2712,2066,2170,3878,2475,1998,2390,2691,2391,2124,1987,
 1822,1549,1429,1409,1885,2104,1994,1765,1110,2450,1167,1685,
 2381,2174,1909,1481,1554,1394,1787,1553,1790,1901,2387,2184,
 1788,1117,2350,1199,1693,2097,1967,1816,1576,1493,1418,1858,
 2399,2273,1824,1185,2307,1233,1691,1479,1982,1814,4002,4282,
 3079,2841,5131,2928,3182,3762,3723,2647,2787,3860,2840,3329,
 3456,4448,2949,2277,3320,3255,3170,4053,4361,3259,2729,5341,
 3087,3228,4015,3598,2501,2746,4208,3060,3373,3750,4249,2937,
 2372,3176,3212,3248,2208,4632,5079,3760,4375,4717,2207,4425,
 5232,3845,4510,4336,2154,4485,5918,3838,4816,4695,4574,4082,
 2806,3944,3722,4083,3774,4806,3374,3421,3178,3432,3363,3030,
 3119,4920,3233,3016,2537,3010,2881,2909,3152,4211,3043,3398,
 3067,3072,3739,3368,3461,5441,3653,3644,3197,5130,3709,3110,
 3753,4437,3623,2962,2489,2675,3042,2869,2728,4162,3026,3354,
 4192,4005,4636,3429,4495,5862,3082,3910,4630,3274,4296,5491,
 3949,4227,4669,2765,3817,4316,2989,4122,4849,3120,4533,5095,
 3821,3801,4343,3573,4709,5592,3731,4142,4904,2701,4164,4566,
 5011,5600,4413,5488,5422,5621,4812,5086,5349,5998,4797,5643]
  ,[29,20,42,32,21,51,97,82,94,69,76,59,77,53,71,55,83,
 101,102,73,107,63,103,72,54,60,90,106,93,99,81,62,68,
 52,342,307,318,212,243,216,221,388,434,406,277,200,217,
 207,328,330,299,290,258,220,278,343,1378,1768,759,733,727,
 873,1488,1781,1015,963,665,705,863,694,709,853,1040,883,
 817,760,736,798,792,4423,4680,2428,2325,2012,4370,4364,
 2543,2352,3298,2032,2321,2088,3314,3175,2282,2252,2551,2435,
 2367,1918,6021,5834,8867,5382,5223,5338,8095,5388,4638,5480,
 5796,5836,4000,3318,7820,3415,5964,8732,8648,8622,8433,8383,
 7280,7278,6115,8312,9398,5257,5451,4744,9199,9136,9026,8721,
 6332,7057,8150,7051,7388,9235,6770],
 [29,20,42,32,38,21,51,67,50,97,69,95,53,71,55,83,108,74,
 103,72,54,78,60,62,68,52,57,237,353,364,312,337,361,286,
 230,248,264,215,276,203,277,200,253,226,281,245,301,192,
 209,187,461,416,518,493,477,485,427,488,413,505,462,459,
 498,396,502,516,431,924,788,877,942,716,674,1015,963,938,
 884,745,693,989,813,977,835,779,1093,899,1403,1225,1016,
 1399,1077,902,1171,1142,1008,1512,1319,928,1456,1085,965,
 1261,1429,1409,1574,1435,1554,1394,1515,1440,1493,1418,1636,
 1458,2208,2207,2154],
 [29,20,42,32,38,21,51,67,50,97,82,100,79,94,69,76,59,95,
 53,71,55,83,108,74,101,102,73,107,63,103,72,54,78,106,
 80,99,81,62,68,52,57,342,259,240,307,310,255,212,243,
 270,216,221,292,388,217,207,267,330,305,299,290,273,258,
 220,278,752,759,694,817],
 [29,20,42,32,38,21,51,67,50,97,94,95,53,71,55,83,108,74,
 101,107,63,72,54,78,60,90,106,99,81,68,52,237,408,364,
 312,337,208,193,222,307,248,302,201,382,386,277,200,223,
 267,226,321,192,314,343,464,515,451,496,455,461,416,493,
 477,524,450,485,427,527,474,488,413,525,465,494,452,462,
 459,498,396,516,431,480,888,989,825,977,833,779],
 [29,20,42,32,38,21,51,67,50,97,100,79,94,69,53,71,55,104,
 83,108,74,101,73,107,63,103,56,72,54,78,90,86,70,106,
 80,99,81,62,68,52,57,342,186,259,240,307,298,304,351,
 255,212,243,292,388,202,217,207,267,231,305,299,290,278,
 692,912,1192,1063,1122,1344,1289,3544,3568],
 [29,20,42,32,38,21,51,67,50,97,100,79,94,95,53,71,55,83,
 108,74,101,72,54,78,60,99,81,57,237,353,408,364,312,337,
 286,248,264,215,302,382,437,435,223,321,301,192,314,357,
 335,461,416,518,493,477,485,427,488,413,505,462,459,498,
 396,502,516,431,959,942,716,847,707,712,1048,884,745,882,
 717,723,888,989,825,833,779,1093,899,1403,1225,1016,1399,
 1077,902,1171,1142,1008,1512,1319,928,1456,1085,965,1261,
 1429,1409,1574,1435,1554,1394,1515,1440,1493,1418,1636,1458,
 2048,2064,2249],
 [29,20,42,32,38,21,51,67,50,97,100,79,95,53,71,55,83,73,
 72,54,78,60,62,68,52,57,237,353,364,312,337,361,286,280,
 227,230,264,215,302,201,276,203,253,223,281,245,321,301,
 192,209,187,461,416,518,493,477,489,485,427,488,413,514,
 462,459,498,396,502,516,431,877,959,942,733,727,674,938,
 1048,884,760,736,693,989,813,835,779,1093,899,1225,1016,
 1077,902,1142,1008,1319,928,1085,965,1549,1429,1409,1740,
 1574,1435,1481,1554,1394,1714,1515,1440,1576,1493,1418,1702,
 1636,1458,2208,2048,2207,2064,2154,2249],
 [29,20,42,32,38,21,51,67,50,100,79,94,95,83,108,74,107,
 63,72,54,78,106,68,52,237,353,408,312,337,222,307,350,
 331,248,382,386,223,308,311,226,343,482,515,451,496,455,
 441,637,461,416,543,522,485,427,447,527,488,413,557,512,
 599,494,452,470,480,814,1603,883,888,825,1003,1114,1143,
 1073,1044,948,1205,1134,1257,1231,1155,1121,936,1538,1095,
 1074,952,1070,1066,1254,1224,1201,856,860,1602,1080,2821,
 4443,2551,3452,4304,1560,1625,1692,1677,1553,1510,1626,1637,
 1544,1632,1589,1575,1675,1431,1587,2488,2938,2618,2986,4894,
 3006,2757,2830,3000,3327,5404,2698,2978,4910,2963,2487,3418,
 3285,2666,3557,3101,3222,5646,4913,4240,8655,7431,3825,2843,
 4245,2678,3506,5887,3413,2800,3449,2604,4794,2886,3713,4819,
 4642,2788,4715,2687,4116,2842,5057,9051,9006,8978,8965,8241,
 8221,5840,6463,8474,6153,7368,6101,6897,6853,6478,5564,5724,
 8200,5106,8507,4564,5894,7017,9140,7245,4859,7141,4703,4980,
 6864,6847,6901,5785,7243,4395,6256,8355,7222,8222,7119,7079,
 7359,8498,8327,8322,7001,6446,7899,7898,6706,8824,7689,6966]
  ,[29,20,42,32,38,21,58,51,67,50,97,82,100,79,94,69,85,
 92,89,76,59,95,53,71,55,104,83,108,74,101,102,73,107,
 63,103,56,72,54,78,60,75,65,90,86,70,106,80,99,81,98,
 62,68,52,57],
 [29,20,42,32,38,21,58,51,97,94,69,85,92,53,71,55,104,83,
 101,102,73,107,63,103,56,72,54,60,75,65,90,99,81,98,62,
 68,52,356,324,280,227,216,221,288,201,434,406,202,277,
 200,267,213,254,328,262,250,258,220,301,192,343,1160,924,
 788,1291,873,1238,1015,963,701,636,816,863,822,1346,798,
 3187,2288,2530,3529,3609,2365,2389,3298,2461,5695,4079],
 [29,20,42,32,38,21,647,673,51,67,50,97,100,79,53,71,55,
 83,108,74,72,54,78,60,75,65,68,52,57,1761,2775,1643,
 2481,237,353,364,312,337,361,286,259,240,307,264,215,302,
 276,203,382,217,207,267,281,245,321,209,187,314,496,455,
 530,518,493,477,485,427,508,505,525,465,462,459,552,502,
 516,431,976,989,813,977,835,779],
 [29,20,42,32,67,50,69,89,53,83,108,74,78,60,90,80,68,52,
 57,376,364,312,344,361,405,317,286,334,351,244,264,215,
 404,328,281,245,314,588,482,570,536,567,558,469,493,477,
 545,561,473,528,562,449,550,462,459,559,523,555,569,442,
 761,942,862,803,900,1786,938,939,890,820,693,1771,1357,
 1232,1434,1301,1325,835,1395,1601,857,1285,1391,1667,1335,
 1534,867,1225,1016,1064,1245,1671,1304,1741,945,1731,1455,
 1538,1095,1548,926,1142,1008,1738,1405,1649,848,1124,1116,
 1420,1445,1570,1214,1665,949,1085,965,1602,1080,5505,1785,
 2497,3417,2469,3097,3819,4354,2692,3621,2457,3041,1946,3747,
 1656,1869,1574,1435,1727,1865,1606,1882,1515,1440,1753,1878,
 1611,1850,1636,1458,1712,1879,3313,4157,3467,5149,2664,3283,
 2853,3227,2923,3947,2980,4471,3350,4215,4147,4825,2891,3262,
 2624,3664,2926,4223,3308,4202,9194,6769,7355,5389,4517,4433,
 5668,4674,3763,3933,2943,3183,4784,4327,3372,4136,3925,4284,
 3380,4271,4914,2933,3468,3498,3474,3555,5046,5973,4605,4244,
 4493,4369,4879,4756,8550,7686,8067,8098,6794,6835],
 [29,20,51,97,100,79,69,89,66,95,77,53,71,55,83,108,74,73,
 103,78,60,90,91,80,62,68,52,57,237,353,364,312,361,405,
 286,356,324,272,230,264,215,309,293,266,251,276,203,404,
 434,406,253,281,245,301,235,209,187,325,461,416,493,477,
 549,485,427,488,413,462,459,498,396,516,431,877,942,778,
 674,697,938,884,693,699,785,664,813,835,1093,899,1225,
 1016,1104,1077,902,1142,1008,1071,1319,928,1085,965,1090,
 1140,2643,2564,2653,2725,2912,1429,1409,1574,1435,1554,1394,
 1515,1440,1493,1418,1636,1458,2945,2597,3125,2934,3090,2516,
 3230,2966,2208,2207,2154,5660,5801],
 [29,24,33,39,36,42,32,28,18,23,21,15,25,58,94,105,89,77,
 108,102,96,93,80,81,68,252,394,492,375,443,432,365,347,
 429,520,332,424,355,373,423,419,484,327,385,283,318,323,
 273,578,575,441,536,622,596,589,585,447,473,607,582,603,
 584,470,523,613,593,1148,1248,1115,1143,1231,1254],
 [29,24,33,39,36,42,32,28,18,23,21,15,25,58,100,105,69,92,
 77,83,102,96,106,93,62,252,381,375,389,407,370,365,345,
 366,332,392,313,362,373,377,368,327,338,354,249,351,309,
 348,578,575,622,596,458,416,589,585,607,582,426,413,603,
 584,613,593,456,396,2535,2676,2453,1296,1383,1300],
 [29,32,15,50,79,94,69,92,88,89,76,95,77,71,55,83,64,108,
 101,73,63,78,65,87,90,86,106,93,80,99,81,62,49,68,57,
 384,326,421,408,312,425,333,428,405,444,374,393,286,334,
 359,293,255,436,295,358,305,588,616,482,551,637,597,567,
 558,580,619,545,560,626,617,528,562,599,610,550,546,623,
 605,555,569,1357,1232,1434,1301,1325,1395],
 [29,32,15,50,82,94,105,69,85,92,89,76,59,95,55,104,83,
 108,101,73,63,78,96,75,65,90,86,70,106,80,81,98,62,68,
 57,369,376,422,410,395,367,344,346,387,380,317,371,341,
 334,359,310,255,436,295,330,305,588,616,482,551,637,597,
 567,558,580,619,545,560,626,617,528,562,599,610,550,546,
 623,605,555,569,1893,1302,1907,1438,1876,1439],
 [29,32,15,51,50,97,100,94,69,92,89,76,95,53,55,83,108,
 101,73,63,103,72,78,60,65,90,86,106,80,81,62,68,57,237,
 252,353,339,384,326,369,421,376,422,408,410,364,365,312,
 395,425,333,367,428,344,346,337,399,361,373,405,387,444,
 374,380,393,317,371,286,341],
 [29,32,15,51,79,94,69,92,88,89,76,95,53,83,64,108,101,73,
 63,54,78,60,87,90,86,106,93,80,99,81,62,49,68,57,384,
 326,421,408,312,425,333,337,405,444,374,393,286,324,322,
 350,331,243,406,319,308,311,290,588,616,482,551,637,597,
 567,558,580,619,545,560,626,617,528,562,599,610,550,546,
 623,605,555,569,1357,1769,1434,1774,1325,1754],
 [29,32,15,51,82,94,105,69,85,92,89,76,95,53,104,83,108,
 101,73,63,56,78,96,60,75,90,86,70,106,80,81,98,62,68,
 57,369,376,422,410,395,367,399,387,380,317,371,341,324,
 304,331,243,406,254,311,290,588,616,482,551,637,597,567,
 558,580,619,545,560,626,617,528,562,599,610,550,546,623,
 605,555,569,1893,1310,1388,1907,1324,1364,1876,1385,1453],
 [29,32,15,97,82,100,94,105,69,85,92,89,76,59,95,53,104,
 83,108,101,63,103,56,72,78,60,90,86,70,106,80,81,98,62,
 68,57,339,369,376,422,410,395,344,346,399,387,380,317,
 371,341,324,331,329,212,243,406,311,349,299,290,588,578,
 616,637,622,597,580,589,619,626,607,617,599,603,610,623,
 613,605,1840,1805,1763],
 [29,32,15,97,82,100,94,105,69,85,92,89,76,95,55,104,83,
 108,101,73,103,56,72,78,96,75,65,90,86,70,106,80,81,98,
 62,68,57,339,369,376,422,410,395,367,399,387,380,317,371,
 341,334,304,359,255,436,254,295,305,588,616,575,637,597,
 596,580,619,585,626,617,582,599,610,584,623,605,593,1310,
 1388,1324,1364,1385,1453],
 [29,32,15,97,100,79,94,69,92,88,89,76,95,55,83,64,108,
 101,73,103,72,54,78,65,87,90,86,106,93,80,99,81,62,49,
 68,57,353,384,326,421,408,312,425,333,337,405,444,374,
 393,286,334,322,359,350,255,436,319,295,308,305,588,616,
 575,637,597,596,580,619,585,626,617,582,599,610,584,623,
 605,593,1769,1774,1754],
 [29,32,15,97,100,79,94,69,92,88,89,76,95,77,53,71,83,64,
 108,101,63,103,72,54,78,60,90,86,106,93,80,99,81,62,49,
 68,57,353,384,326,421,408,312,428,337,405,444,374,393,
 286,324,331,243,266,406,311,290,306,588,578,616,637,622,
 597,580,589,619,626,607,617,599,603,610,623,613,605,1540,
 1502,1519,1486,1498,1401],
 [29,32,18,51,82,94,105,69,92,76,95,53,83,74,101,102,73,
 63,72,78,96,60,75,65,106,80,68,57,369,410,367,399,373,
 380,341,342,324,208,307,304,320,310,270,216,221,292,382,
 435,388,406,217,267,254,303,262,330,314,335,616,482,467,
 537,536,545,479,540,473,617,504,512,550,510,497,463,644,
 719,670,919,662,1029,1347,709,669,872,645,961,1308,904,
 929,1091,1158,1052,1039,1156,1089,1126,1249,1065,1002,1154,
 1103,2029,1895,1703,1550,1685,1620,1688,1516,1693,1646,1684,
 1562,1691,1582,2003,1984,2001],
 [29,32,18,58,51,50,82,94,105,69,92,76,95,83,74,101,102,
 73,63,56,72,78,96,60,75,65,90,70,106,80,98,68,57,252,
 369,410,367,399,373,380,341,208,259,307,304,359,216,382,
 435,217,267,254,295,303,262,314,335,482,467,537,536,545,
 479,540,473,504,512,550,510,497,463,752,719,670,662,694,
 709,669,645,904,929,1091,1158,1052,1039,1156,1089,1126,
 1249,1065,1002,1154,1103,1703,1550,1685,1620,1688,1516,1693,
 1646,1684,1562,1691,1582,2003,1984,2001],
 [29,32,18,58,51,50,94,105,69,85,92,76,53,104,83,74,101,
 102,73,63,56,72,78,96,60,75,65,90,70,106,80,68,57,252,
 369,367,399,373,380,341,186,208,307,304,351,216,292,382,
 435,267,254,328,262,278,314,335,482,467,537,536,594,545,
 479,540,473,504,512,586,550,510,497,463,719,754,670,662,
 709,741,669,645,904,929,1091,1158,1052,1039,1156,1089,1126,
 1249,1065,1002,1154,1103,1703,1550,1685,1620,1688,1516,1693,
 1646,1684,1562,1691,1582,2003,1984,2001],
 [29,32,18,67,97,100,79,94,69,88,76,95,77,55,83,64,108,74,
 101,73,72,78,96,65,87,86,106,80,62,49,68,52,57,353,326,
 408,312,333,337,374,286,334,300,240,264,302,293,255,251,
 203,287,207,295,235,187,588,575,500,455,580,585,489,427,
 505,465,599,584,502,431,784,862,707,695,762,807,765,939,
 717,753,785,787,977,779,1050,1139,1064,1059,1078,1082,1026,
 1094,1124,1092,999,1005,1194,1258,1110,1167,1184,1222,1117,
 1199,1242,1292,1185,1233,2040,2050,2068],
 [29,32,18,97,100,79,94,69,76,95,77,55,83,64,108,74,101,
 73,107,103,72,54,78,96,65,87,86,80,62,49,68,52,57,353,
 326,408,312,333,337,286,334,356,300,240,272,255,288,251,
 203,287,207,269,295,301,235,187,588,575,500,455,580,585,
 524,489,427,505,465,599,584,498,502,431,784,862,750,807,
 765,939,769,787,977,779,1050,1139,1064,1059,1078,1082,1026,
 1094,1124,1092,999,1005,1194,1258,1110,1167,1184,1222,1117,
 1199,1242,1292,1185,1233,2040,2050,2068],
 [29,32,18,97,100,79,94,69,76,95,83,64,108,74,101,73,103,
 72,54,78,96,65,86,106,62,49,68,52,57,353,326,408,312,
 333,337,374,286,334,300,240,255,251,201,203,287,207,319,
 295,311,235,192,187,588,616,575,501,500,455,580,619,585,
 506,489,427,487,505,465,599,610,584,499,502,431,796,784,
 804,862,807,871,765,810,939,787,977,779,1050,1954,1139,
 1064,1829,1059,1078,1887,1082,1026,1945,1094,1124,1842,1092,
 999,1864,1005,1180,1194,1258,1244,1110,1167,1141,1184,1222,
 1163,1117,1199,1132,1242,1292,1202,1185,1233,2040,2050,2068]
  ,[29,32,18,97,100,79,94,69,76,95,83,108,74,101,73,107,
 72,78,96,65,87,86,106,80,62,68,52,57,353,326,408,312,
 333,337,374,286,334,300,240,272,302,293,255,251,203,404,
 434,287,207,269,319,295,311,214,321,358,235,187,325,588,
 575,500,455,580,585,489,427,505,465,599,584,502,431,1378,
 796,784,804,720,862,807,871,765,810,710,939,787,977,779,
 1050,1139,1064,1059,1078,1082,1026,1094,1124,1092,999,1005,
 3663,3473,1194,1258,1110,1167,1184,1222,1117,1199,1242,1292,
 1185,1233,2040,2050,2068],
 [29,32,18,100,94,69,95,83,108,74,101,73,78,96,65,86,106,
 80,62,52,57,326,312,333,374,334,300,240,298,322,331,309,
 255,404,437,287,207,213,319,295,311,348,306,357,588,575,
 500,455,556,594,549,580,585,506,527,579,505,465,544,599,
 584,568,595,480,784,862,807,1786,765,861,939,787,1771,977,
 2373,1229,857,1050,1954,1139,1091,1158,1219,1335,1064,1059,
 1294,1304,2146,1206,945,1078,1082,1332,1095,1026,1945,1094,
 1126,1249,1217,1405,1927,1070,848,1124,1092,1269,1214,999,
 1005,1284,1080,2479,2657,2124,1194,1258,1653,1869,1110,1167,
 1583,1865,2381,1184,1222,1462,1882,1163,1117,1199,1745,1878,
 2097,1242,1292,1580,1850,1185,1233,1497,1879,5322,3033,4391,
 8365,3355,4106,5667,3215,4562,5418,3105,4329,8955,3200,3839,
 8406,3177,4367,2040,6970,2050,6890,2068,7184,3858,8440,2967,
 3276,3524,4872,3193,3547,7484,4207,2906,3917,5859,3604,3625,
 3827,8376,3217,3247,3701,5578,2782,3266,5296,3582,2897,3655,
 4498,2946,3240,2927,7845,3548,3260,3803,5108,3702,3678,5450,
 3542,2733,3615,6047,2971,3158,8932,9217,6524,8250,7215,6182,
 9340,7823,7494,6879,7337,8146],
 [29,33,20,32,23,58,94,85,92,89,76,59,95,108,74,102,73,78,
 75,65,106,80,99,81,62,68,52,369,376,410,380,317,341,334,
 279,359,350,331,229,230,302,255,270,386,436,294,295,308,
 311,260,246,273,258,220,343,616,575,551,467,597,596,558,
 469,513,619,585,560,479,617,582,562,449,610,584,546,510,
 517,569,442,726,1010,695,702,979,753,787,1310,1302,1324,
 1438,1439,1035,1196,988,1136,1166,1864,1005,2294,2170,1691,
 3723,2647,3598,2501,3225,3030,3110,4696,4494],
 [29,33,20,36,32,28,23,15,51,50,94,69,92,95,53,55,83,108,
 73,63,103,72,78,65,106,80,62,68,57,237,252,369,376,422,
 364,365,395,344,346,399,380,341,279,208,230,255,203,294,
 277,267,213,246,305,187,467,513,518,493,580,619,540,561,
 449,505,525,586,517,623,605,497,553,663,630,701,636,1339,
 1297,995,1231,1155,1071,1168,1109,1901,1814],
 [29,33,20,36,32,28,23,15,51,50,94,69,92,95,53,55,83,108,
 73,63,103,72,78,65,106,80,62,68,57,237,252,369,410,364,
 365,395,367,344,346,399,361,373,380,317,371,341,279,208,
 230,255,203,294,277,267,213,246,305,187,467,449,505,525,
 504,557,502,516,663,630,701,636,1297,1288,905,1343,1017,
 1444,1087,1067,1739,3172,3332,3322,3250,2571,2520],
 [29,33,20,36,32,28,23,15,51,50,94,92,89,76,95,53,83,108,
 101,73,63,78,60,65,106,80,81,62,68,237,252,369,376,422,
 410,364,365,395,367,344,346,361,373,380,317,371,341,222,
 331,302,309,270,216,386,223,311,273,258,343,482,551,583,
 545,560,479,550,546,442,695,685,753,699,1893,1907,1876,
 1098,1140],
 [29,33,20,36,32,28,23,15,51,50,94,92,89,76,95,53,83,108,
 101,73,63,78,60,65,106,80,81,62,68,237,252,376,422,410,
 395,367,399,361,373,380,317,371,222,331,302,309,270,216,
 386,223,311,273,258,343,482,551,501,637,597,531,543,479,
 579,487,599,610,550,546,442,576,695,685,753,699,1893,1876,
 1205,1534,969,1521,1070,1649,1019,1541,1765,1816],
 [29,33,20,36,32,28,23,15,51,50,97,100,79,94,69,92,89,76,
 95,77,53,71,55,83,108,101,102,73,107,63,103,72,78,60,
 65,90,86,106,80,81,62,49,68,57,342,356,272,244,293,266,
 251,276,388,434,269,214,358,235,209,697,664],
 [29,33,20,36,32,28,23,15,51,50,97,100,94,69,92,89,76,95,
 53,55,83,108,101,73,63,103,72,78,60,65,90,86,106,80,81,
 62,68,57,237,252,339,369,376,422,410,364,365,395,367,344,
 346,399,361,373,387,380,317,371,341],
 [29,33,20,36,32,28,23,15,51,97,100,69,92,95,55,101,73,
 103,72,60,65,106,81,57,237,252,339,376,422,367,399,361,
 373,380,317,371,234,359,270,216,382,437,253,295,273,258,
 314,357,575,501,500,496,637,597,547,479,612,579,618,487,
 483,599,610,584,601,600,442,539,576,712,723,1613,916,909,
 1056,1870,1139,1354,1171,1250,969,1521,936,1105,1897,1322,
 1261,1295,1019,1541,860,1503,1703,1623,2547,1964,1462,1606,
 1529,1580,1611,2173,2949,2051,2937,2131,2369,2306,3114,5205,
 3595,2909,3194,4072,3184,3116,4708,3487,2869,3751,4901,4670,
 7990,7985,9075,3690,7775,6476,7771,5278,6726,5723,7122,8941,
 7839,8922,6845,6242,6566,7537,6729,7235,6682],
 [29,33,20,36,32,28,23,15,51,97,100,94,69,92,95,53,55,101,
 73,63,103,72,60,65,106,81,62,68,57,237,252,339,369,376,
 422,364,365,367,344,346,399,361,373,380,317,371,341,324,
 307,298,229,280,318,406,267,213,260,262,323,192,594,469,
 518,493,505,525,586,510,502,516,716,745,1339,1297,1288],
 [29,33,20,36,32,28,23,15,51,97,100,94,69,92,95,53,55,101,
 73,63,103,72,60,65,106,81,62,68,57,339,369,410,364,365,
 367,344,346,361,373,317,371,341,324,307,298,229,280,318,
 406,267,213,260,262,323,192,588,616,537,570,469,583,626,
 617,505,525,504,557,510,595,499,502,516,716,745,1297,1288,
 1143,1073,1253,1087,1067,1213,1874,1739],
 [29,33,20,36,32,28,23,15,58,51,67,50,97,100,79,94,69,92,
 88,89,76,95,77,53,71,55,83,64,108,101,102,73,107,63,
 103,72,54,78,60,65,87,90,86,106,93,80,99,81,62,49,68,
 57],[29,33,20,36,32,28,23,15,58,67,50,79,94,69,92,95,
 77,53,71,55,83,64,108,102,73,107,63,103,72,54,78,65,
 106,93,80,99,62,49,68,57,334,279,208,272,307,298,255,
 266,270,216,203,436,294,277,269,267,213,305,306,273,258,
 187,761,674,747,693],
 [29,33,36,18,58,50,94,105,69,92,88,89,66,59,104,83,64,
 108,74,73,107,78,96,65,87,90,91,86,70,80,98,62,49,52,
 334,356,351,322,359,331,230,247,215,302,309,293,288,251,
 203,437,386,294,277,200,328,319,295,311,246,231,245,321,
 348,358,301,235,187,357,343,1318,924,788,1334,862,750,912,
 807,636,1198,939,769,1122,787,2288,3589,2536,2120,3364,
 2741,2348,8691,8126],
 [29,33,36,32,18,23,51,94,69,76,95,83,74,101,102,73,63,72,
 96,60,65,90,70,106,57,369,410,367,373,341,342,324,208,
 300,240,318,216,201,382,437,435,388,406,287,207,267,254,
 295,262,323,314,335,616,482,467,583,545,479,506,540,473,
 617,504,512,550,510,595,497,463,663,793,784,719,670,662,
 957,1505,765,709,669,645,792,1379,929,905,907,1091,1158,
 1052,1039,1156,1089,1530,1126,1249,1065,1002,1154,1103,1393,
 2023,2193,2292,2302,1972,1703,1550,1685,1620,1688,1516,1693,
 1646,1684,1562,1691,1582,2105,3088,2179,3165,2003,1984,2001,
 9428,8835],
 [29,33,36,32,18,23,51,94,105,69,92,95,83,74,73,72,78,96,
 60,65,106,68,57,369,410,367,399,373,341,208,307,298,304,
 270,216,221,382,435,267,213,254,262,246,314,335,588,575,
 482,467,537,441,536,580,585,545,479,540,447,473,504,483,
 512,599,584,550,510,497,468,463,719,761,670,919,662,1029,
 709,747,669,872,645,961,3358,904,3507,929,1013,3957,1323,
 1050,1139,1091,1158,1064,1059,1052,1039,1078,1082,1156,1089,
 1026,1094,1126,1249,1124,1092,1065,1002,999,1005,1154,1103,
 1703,1623,1550,1685,1600,1620,1688,1508,1516,1693,1593,1646,
 1684,1638,1562,1691,1494,1582,4372,2003,4590,1984,4721,2001]
  ,[29,33,36,32,18,23,58,50,94,105,69,92,76,53,83,74,101,
 78,60,90,70,106,80,68,57,252,369,399,380,341,334,208,
 307,304,351,247,215,329,243,216,267,254,328,262,231,226,
 245,348,349,290,314,335,482,467,537,536,594,619,545,479,
 504,512,586,550,510,517,605,497,463,719,739,950,862,670,
 662,709,724,892,801,869,939,669,645,904,1091,1158,1263,
 1052,1039,1156,1089,1126,1249,1186,885,931,1065,1002,1154,
 1103,1785,1974,1801,1957,1703,1550,1685,1620,1688,1516,1693,
 1646,2221,1684,1562,1691,1582,2115,2961,2043,2854,2003,1984,
 2001,5442,5364],
 [29,33,36,32,18,23,58,50,94,105,92,76,53,83,74,101,102,
 63,72,78,60,90,70,80,68,252,399,380,208,222,307,304,329,
 243,216,382,435,386,267,254,262,314,335,343,578,482,467,
 501,530,537,536,589,619,545,479,508,540,473,579,534,504,
 512,603,550,510,486,497,463,576,719,670,974,864,901,662,
 709,669,1021,829,897,645,1613,904,1833,929,1111,1091,1158,
 1245,1052,1039,1457,1137,1887,1156,1089,1227,1126,1249,1116,
 1065,1002,1396,1218,1864,1154,1103,1180,1359,1703,1550,1244,
 1422,1685,1620,1141,1306,1688,1516,1163,1413,1693,1646,1132,
 1390,1684,1562,1202,1428,1691,1582,4717,2003,4336,1984,4695,
 2001],[29,33,36,32,18,23,58,51,50,69,76,95,53,101,102,
 73,63,72,78,96,60,65,90,70,106,80,57,252,369,410,367,
 399,373,380,341,208,234,300,240,307,304,216,382,437,435,
 287,207,267,254,260,262,250,314,357,335,482,467,537,536,
 545,479,540,473,504,512,550,510,497,463,935,719,876,670,
 879,662,843,709,853,669,890,645,904,929,1091,1158,1052,
 1039,1156,1089,1126,1249,1065,1002,1154,1103,1703,1550,1685,
 1620,1688,1516,1693,1646,1684,1562,1691,1582,2003,1984,2001]
  ,[29,33,36,32,18,23,58,51,50,94,105,69,92,88,89,76,59,
 95,83,64,108,74,101,73,72,78,96,60,65,90,86,70,106,93,
 80,81,62,68,52,57,356,279,208,193,322,359,331,247,264,
 215,302,293,404,319,295,311,231,281,245,321,358,306,325,
 878,750,1084,670,742,861,769,1101,669,718],
 [29,33,36,32,18,23,58,51,67,50,97,100,79,94,105,69,92,88,
 89,76,59,95,77,53,55,83,64,108,74,101,102,73,107,63,
 103,72,54,78,96,60,65,87,90,86,70,106,93,80,81,62,49,
 68,52,57],
 [29,33,36,32,18,51,105,92,76,95,83,74,101,73,72,96,65,
 106,68,410,367,373,286,359,295,314,335,343,588,575,637,
 596,547,580,585,626,582,599,584,532,623,593,497,463,576,
 924,726,716,915,930,733,957,1015,702,801,869,760,792,3358,
 1232,1302,3507,1301,3957,1395,1229,857,1035,1143,1044,1205,
 867,1196,1253,1399,1207,1020,981,1216,1162,1206,945,988,
 1530,1231,1121,1355,926,1136,1512,1241,1087,986,1070,848,
 1166,885,931,1254,1201,1349,949,1046,1261,1138,1393,1168,
 1036,2030,1889,2376,2428,2012,2563,2321,1993,2745,2435,1918,
 2118,2478,1856,1495,1941,1751,1585,2017,1573,1676,2081,1860,
 1932,1743,2204,1747,1469,2163,1545,1717,1783,1843,1594,2221,
 2016,1780,1666,1938,1535,1647,1896,3951,2786,2488,2724,2938,
 3493,3497,2787,2542,3294,2512,2630,3592,2616,3340,3020,2934,
 2757,2557,2830,4314,2900,2729,3190,2910,2413,2699,3021,3265,
 3489,2487,2524,3418,2674,3593,2970,2966,2372,3005,2831,2631,
 2510,2769,3760,5847,3845,4967,3838,4082,5614,9414,3482,3231,
 4638,3318,8379,4216,3546,3049,2815,3055,2755,2749,3080,2708,
 3607,3030,2599,2899,2695,2734,2845,3045,2783,2661,2856,2605,
 2829,3368,2513,2697,2861,3219,3046,3610,2803,2635,2607,2722,
 3324,2869,2590,2863,2614,8456,8390,9412,6367,8531,8508,5168,
 7014,9062,7952,6310,8041,8032,5306,6535,7256,7246,5979,6327,
 7171,7167,8526,3752,9427,3936,7729,4193,7011,3871,7004,3928,
 6683,3941,9027,5257,9222,5636,7562,8637,9082,5671,9154,6964,
 6165,4989,8269,6807,8535,6368],
 [29,33,36,32,18,58,50,94,105,69,92,88,89,59,95,77,55,104,
 83,64,108,74,102,73,107,63,78,96,65,87,90,86,70,80,98,
 62,49,52,57,334,356,359,230,302,309,293,255,288,251,203,
 437,436,434,294,277,200,295,246,321,348,358,301,235,187,
 357,1318,924,788,912,807,1340,1015,963,636,1122,787,2288,
 2365],
 [29,33,37,36,41,28,19,40,23,58,50,69,71,102,63,72,60,99,
 68,471,410,367,521,355,399,476,373,283,472,208,280,216,
 277,213,262,258,482,467,490,451,597,554,416,533,450,528,
 449,507,413,504,512,571,590,581,610,563,452,529,396,497,
 463,587,630,636,3358,2449,1558,2393,1266,1013,2305,2414,
 1286,1323,2169,905,907,1056,1228,1003,1020,981,1134,969,
 1119,1025,1017,946,1105,1127,1074,1217,1405,2005,885,931,
 1066,1019,1060,1051,1495,2276,1386,1503,2911,1677,1627,2552,
 1501,1572,1469,2848,1637,1529,1474,1739,1485,1561,5233,2433,
 1464,1598,3216,1746,1631,1604,1814,5694,4213,4017,3929,3921,
 4066,3414,4999,5097,5068,2518,2571,2773,3096,4970,2844,2820,
 6019,2874,2730,5170,2561,2520,3186,3048,5396,2946,3240,8165,
 2689,2751,5958,2766,2834,5704,8439,6057,8975,8900,7441,5329,
 8629,6765,4687,9091,5434,6218,7544,4861,7558,8611,8414,7175,
 8991,7508,8246,8134,7242,8307,8092,6318,6796,7569,6270],
 [29,36,28,18,15,58,51,50,100,94,89,66,95,104,108,101,102,
 73,78,96,60,65,90,91,106,98,252,369,367,373,387,380,279,
 186,300,222,240,331,215,302,310,309,203,437,386,294,202,
 207,311,245,321,330,348,187,357,467,537,441,531,509,574,
 583,540,447,612,579,449,504,483,548,470,601,595,497,468,
 566,576,630,880,974,912,1670,636,940,1021,1122,1500,904,
 929,916,1118,909,1056,995,1073,1316,1588,1326,1155,1105,
 1071,1067,1224,1679,1367,1109,1503,1529],
 [29,36,28,18,23,15,58,51,50,97,82,100,79,94,105,69,92,89,
 66,76,95,101,102,73,63,103,56,72,78,96,60,65,87,90,91,
 86,81,62,49,68,57,356,272,322,359,331,229,244,280,264,
 293,434,269,319,295,311,260,214,262,281,301,235,192,942,
 887,716,884,874,745,785,2564,2725],
 [29,36,28,18,23,15,58,51,50,97,82,100,94,105,69,89,66,95,
 55,108,102,73,103,56,78,65,90,91,86,252,339,369,387,240,
 298,215,309,329,255,288,203,437,207,213,245,348,349,305,
 301,187,357,537,441,592,594,624,531,509,574,583,598,619,
 506,540,447,612,579,625,504,483,571,586,581,548,470,601,
 595,638,605,499,497,468,566,576,587,904,970,1840,929,916,
 1805,1118,909,1763],
 [29,36,28,18,23,15,58,51,50,97,82,100,94,105,69,92,89,66,
 76,95,83,64,108,101,102,73,63,103,56,72,54,78,96,60,65,
 90,91,86,106,93,80,68,57,356,193,272,322,359,331,264,
 203,382,404,434,200,269,319,295,311,281,306,187,314,325,
 878,861],
 [29,36,28,18,23,15,58,51,50,97,82,100,94,105,69,92,108,
 101,102,73,72,65,90,91,86,106,252,339,369,395,367,373,
 387,307,291,298,351,215,302,310,437,386,267,238,213,245,
 321,330,323,349,305,537,441,536,592,594,531,509,522,612,
 579,504,483,512,548,470,523,601,595,925,1272,1334,1063,
 1505,1670,822,1053,1198,1289,1379,1500,904,1174,1013,1118,
 1764,1577,1588,1326,1836,1546,1716,1591,1679,1367,1772,1556,
 1777,1838,2437,1851,1823,2106,1742,1779,2358,1953,1904,2342,
 1736,1775,2116,1877,1839,2090,4243,2157,4362,2178,4325,2199]
  ,[29,36,28,18,23,15,58,51,50,100,94,92,108,101,102,73,
 63,72,96,60,65,90,91,106,81,252,339,395,367,373,279,186,
 300,222,307,291,351,331,437,386,294,202,287,223,267,238,
 321,330,323,357,501,537,441,592,594,597,612,579,487,504,
 483,548,470,601,595,630,814,1062,925,1063,1670,636,757,
 1040,822,1122,1289,1054,1500,1013,1073,1219,948,1764,1577,
 1588,1326,1836,1546,1067,1217,952,1716,1591,1224,1679,1367,
 2112,1772,1556,4685,3420,4043,3812,1874,1713,1777,1838,1851,
 1823,1742,1779,1739,1485,1953,1904,1900,1736,1775,1877,1839,
 2986,4929,2978,8191,2157,2178,2199,3547,3381,3271,3909,3240,
 3331,3680,3174,3855,4900,4021,4775,3968,4731],
 [29,36,28,18,23,15,58,51,50,100,94,105,69,89,66,95,108,
 102,73,78,65,90,91,86,106,57,252,369,387,380,279,186,
 240,298,331,215,302,310,309,329,255,437,294,202,207,246,
 245,321,330,348,349,305,357,467,537,441,592,594,531,509,
 574,583,619,612,579,449,504,483,517,548,470,601,595,605,
 566,576,761,912,1042,747,1122,1054,904,970,916,1118,909,
 1263,1335,1304,1588,1326,1095,1186,1214,1679,1367,1080,1777,
 1838,1851,1823,1742,1779,1736,1775,1877,1839,3696,3810,4243,
 4362,4325,4843,5503,3958,4762],
 [29,36,28,18,23,15,58,51,67,50,97,82,100,79,94,105,69,92,
 88,89,66,76,95,77,53,55,83,64,108,101,102,73,107,63,
 103,56,72,54,78,96,60,65,87,90,91,86,106,93,80,81,62,
 49,68,57],
 [29,36,28,18,23,15,58,51,97,82,100,95,55,101,102,73,103,
 56,65,106,57,252,339,367,380,234,298,309,270,206,216,437,
 253,213,348,258,357,575,490,430,501,500,397,592,594,554,
 458,574,583,479,533,466,612,579,618,507,426,487,571,586,
 563,478,601,595,600,529,456,566,576,700,824,737,809,712,
 1246,705,802,755,868,723,1151,970,927,916,832,909,821,905,
 1102,1870,1219,948,1020,993,1294,850,1171,1290,969,1251,
 1332,936,1017,1100,1897,1217,952,885,1038,1269,856,1019,
 1159,1284,860,1990,1916,2476,2345,2139,1923,2269,2007,1972,
 1653,1410,2081,2463,2256,1462,1387,1935,2589,2221,1580,1382,
 2155,2901,2245,3349,2542,2149,2999,2051,2557,3164,2322,3302,
 2648,2128,2793,2131,2510,3251,3964,4040,4114,3885,4001,3782,
 5882,5426,6195,9429,5333,5994,6895,6649],
 [29,36,28,18,23,15,711,646,58,51,50,97,82,100,94,105,69,
 83,64,108,101,102,73,96,60,65,90,91,86,1828,1616,1886,
 1704,252,339,369,395,367,373,387,240,307,291,215,302,310,
 203,382,404,207,267,238,245,321,330,187,314,325,537,441,
 536,564,531,509,540,447,473,534,504,483,548,470,523,486,
 497,468,904,1174,929,1013,1118,1323],
 [29,36,28,18,23,58,51,50,100,94,105,69,92,108,74,102,73,
 63,72,65,90,91,86,106,68,252,339,369,395,367,373,387,
 279,186,307,291,298,351,331,230,435,386,294,202,267,238,
 213,246,321,330,323,349,305,335,537,441,592,594,597,612,
 579,504,483,548,470,601,595,814,1062,925,1272,1334,1063,
 1670,757,1040,822,1289,1054,1500,1013,1219,948,1335,1764,
 1577,1588,1326,1095,1836,1546,1217,952,1716,1591,1214,1679,
 1367,2112,1772,1556,3420,4467,3658,5814,3758,1713,1777,1838,
 1851,1823,1742,1779,1485,1953,1904,1736,1775,1877,1839,3545,
 4929,3696,4259,3590,3810,4699,2157,2178,2199,9258,7140,8189,
 6868],[29,36,28,23,58,51,97,82,100,94,95,71,55,74,101,
 102,73,103,56,65,86,106,99,52,57,252,339,369,367,380,
 324,307,291,298,309,318,270,206,437,406,262,348,323,273,
 239,357,490,430,592,594,554,458,574,583,479,533,466,612,
 579,507,426,563,478,601,595,442,529,456,566,576,700,824,
 737,809,859,1635,912,712,1246,705,755,868,883,1708,1122,
 723,1151,970,927,916,832,909,821,905,1102,1219,948,1020,
 993,1294,850,1588,1326,969,1251,1332,936,1017,1100,885,
 1038,1269,856,1679,1367,1019,1159,1284,860,2368,2376,2511,
 2321,2745,2776,1972,2081,2256,1935,2221,2155,3659,2811,3915,
 2748],[29,36,42,18,15,58,51,67,50,97,82,100,79,94,105,
 69,92,89,66,76,59,95,77,53,55,104,83,64,108,101,102,73,
 107,63,103,56,72,54,78,96,60,65,90,91,86,70,106,93,80,
 81,98,62,49,68,57],
 [29,36,42,32,18,23,21,58,51,67,50,97,82,100,79,94,105,69,
 92,89,76,59,95,77,53,55,83,108,74,101,102,73,107,63,
 103,56,72,54,78,96,60,65,90,86,70,106,93,80,81,62,68,
 52,57],
 [29,36,42,32,18,23,21,58,67,50,94,69,89,59,77,55,83,108,
 74,101,102,107,63,103,56,54,78,90,86,70,106,93,80,81,
 57,334,279,186,193,351,309,329,255,243,382,437,435,436,
 294,202,277,200,287,207,213,226,348,349,305,290,314,335,
 924,815,700,630,1063,1400,1505,1015,895,705,636,765,724,
 1289,1424,1379,2167,2713,2107,2649],
 [29,36,42,32,18,23,21,58,67,50,100,94,69,89,59,95,77,55,
 83,108,74,101,102,73,107,63,103,56,54,78,96,65,90,86,
 70,106,93,80,81,62,52,57,334,279,186,193,309,255,437,
 436,294,202,200,287,207,213,295,348,305,357,815,700,630,
 895,705,636,765,2167,2107],
 [29,36,42,32,18,23,21,58,67,50,100,94,95,83,108,74,101,
 102,73,107,63,78,96,65,90,70,106,93,80,81,62,52,334,
 279,186,193,222,307,304,322,331,437,386,436,294,202,200,
 223,267,254,319,295,311,321,330,348,358,305,258,357,815,
 700,630,814,1062,950,1449,1334,1670,895,705,636,757,1040,
 892,1421,1198,702,940,868,1122,1500,2167,2952,2939,4685,
 2107,3044,3024,4043,2582,5402,8841,5367,6632,5050,8463,7159]
  ,[29,39,18,15,67,105,69,92,88,89,66,76,95,83,64,101,
 107,72,96,60,87,106,81,62,49,57,326,421,408,393,286,324,
 208,322,359,331,280,215,243,216,251,201,437,406,277,319,
 295,311,262,290,273,239,258,235,192,357,588,578,482,464,
 637,622,567,526,580,589,545,511,524,626,607,528,474,599,
 603,550,519,623,613,555,535,498,925,794,866,712,873,822,
 776,812,723,798,1502,1769,1486,1774,1401,1754,1277,1362,
 1267,1208,1125,1361,1223,1273,1235,1090],
 [29,39,20,36,42,32,28,38,18,23,21,15,58,51,67,94,69,92,
 95,53,55,83,108,102,73,107,63,103,56,72,78,65,90,86,
 106,80,62,68,57,324,279,186,208,230,255,203,406,294,202,
 277,267,213,246,305,187,663,630,701,636],
 [29,39,20,42,15,58,50,82,100,94,69,85,89,66,76,59,95,77,
 53,71,55,104,64,108,101,73,107,103,65,91,86,70,93,80,
 99,98,62,49,68,57,334,356,240,229,247,215,310,309,318,
 255,212,270,288,203,294,231,245,330,348,323,305,299,273,
 301,187,1318,862,750,809,714,939,769,868,721,3589,3364],
 [29,39,20,42,38,15,50,92,89,66,76,95,53,71,55,64,108,73,
 107,63,103,78,65,91,86,80,99,62,49,68,57,421,408,364,
 428,286,334,356,279,234,229,230,270,288,203,436,434,294,
 253,260,246,273,301,187,588,464,551,430,515,526,558,458,
 461,511,560,466,524,427,626,474,562,426,488,519,546,478,
 494,535,569,456,498,431,1232,888,1301,825,1395,833],
 [29,39,20,42,38,15,51,67,50,92,89,66,76,95,53,71,55,73,
 107,63,103,91,86,81,62,49,68,57,237,421,408,364,428,393,
 286,229,244,280,230,288,201,276,294,246,290,273,301,192,
 209,526,558,547,458,461,466,524,474,562,538,478,494,535,
 569,539,456,498,1318,1710,794,714,803,733,1340,1639,776,
 721,820,760,1232,888,1301,1395,833,1079,1601,1277,1234,
 1534,1267,1419,1741,1208,1106,1548,1361,1317,1649,1273,1363,
 1665,1235,1853,1706,1854,1619,1883,1756,1863,1608,1846,1723,
 1859,1654,3756,3892,4062],
 [29,39,20,42,38,15,51,67,50,97,82,100,92,89,66,76,59,95,
 53,71,55,83,64,108,101,73,107,63,103,90,91,86,106,80,
 99,81,98,62,49,68,57,342,234,222,259,320,247,310,309,
 318,255,212,243,221,388,231,330,348,323,305,299,290,220,
 879,974,703,759,890,1021,725,817],
 [29,39,20,42,38,15,51,67,92,89,66,76,95,55,64,108,73,107,
 103,78,65,91,86,81,62,57,237,421,408,393,324,279,229,
 230,215,270,288,201,276,406,294,253,260,246,245,273,301,
 325,357,464,551,526,558,458,461,477,511,560,466,524,474,
 562,426,488,519,546,478,494,459,535,569,456,498,480,877,
 922,772,938,980,751,792,932,1232,888,1301,825,1395,833,
 1035,1093,993,1506,1076,1251,1521,1136,1142,1100,1444,1038,
 1536,1058,1159,1541,2359,2790,2110,2565,2281,2026,2227,1977,
 2456,2593,2969,2480,2857,4165,3378],
 [29,39,20,42,38,15,58,51,67,50,97,82,100,94,69,85,92,89,
 66,76,59,95,53,71,55,104,83,64,108,101,102,73,107,63,
 103,56,72,78,60,75,65,90,91,86,70,106,80,99,81,98,62,
 49,68,57],
 [29,39,20,42,38,15,58,51,67,97,94,69,85,92,66,76,59,95,
 53,71,55,104,83,101,102,73,107,56,72,60,75,65,70,106,
 81,49,68,57,324,186,208,244,280,215,302,318,270,206,216,
 201,276,406,202,277,267,214,262,323,278,314,663,1107,915,
 712,695,919,704,662,701,1075,801,792,932,2359,2790,1989,
 2075,2110,2565,2269,2007,2478,9008,3617,5985,4834,2982,4675,
 3908,3895,8370,5117,6857,4465],
 [29,39,20,42,38,15,58,51,67,97,94,69,85,92,66,76,59,95,
 53,71,55,104,83,101,102,73,107,63,56,72,60,75,65,90,70,
 106,81,49,68,57,324,186,208,244,280,302,318,206,216,201,
 276,406,202,277,267,214,262,323,278,314,663,1107,915,695,
 704,662,701,1075,801,792,932,2359,2790,2075,2110,2565,2007,
 2478,3617,5985,2982,4675,3895,5117,4465],
 [29,39,42,32,38,18,21,15,51,50,94,69,92,95,53,83,108,73,
 63,103,72,78,65,90,86,106,80,62,68,57,237,252,384,326,
 408,312,425,333,428,337,361,373,405,444,374,393,286,279,
 208,230,255,203,294,277,267,213,246,305,187,464,536,473,
 474,465,523,663,630,701,636,844,904,738,929,756,1118,1177,
 1241],
 [29,39,42,32,38,18,21,15,51,50,94,69,92,95,53,83,108,73,
 63,103,72,78,65,90,86,106,80,62,68,57,237,252,384,326,
 421,364,365,312,428,337,405,444,374,286,279,208,230,255,
 203,294,277,267,213,246,305,187,464,536,554,461,580,619,
 427,474,544,563,494,523,623,605,431,663,630,701,636,1146,
 981,1161,931],
 [29,39,42,32,38,18,21,15,51,50,94,92,95,53,83,108,73,63,
 78,65,106,80,62,68,237,252,408,312,425,333,337,361,373,
 444,374,393,222,331,270,216,386,223,311,273,258,343,482,
 551,490,515,637,597,522,511,489,485,527,625,507,488,512,
 599,610,550,546,638,535,456,480,695,685,753,699,1357,1650,
 1325,1003,1205,1534,1171,1250,1031,1156,1454,1095,1074,1070,
 1649,1261,1295,1138,1080,1549,1429,2104,1394,1195,1222,2097,
 1576,1493,1458,2277,3036,2965,2372,2972,2831,8897,7075,3922,
 5294,3666,2943,2622,2881,2528,4265,2933,4045,5416,2859,3042,
 6045,5049,5539,5007,5039,5760,7658,5827,5141,6545,5574,8213,
 9388,8772,7642,6954,6949,6937,7988,7236],
 [29,39,42,32,38,18,21,15,51,50,97,82,100,94,69,92,89,76,
 95,53,55,83,108,101,102,73,107,63,103,72,78,96,60,75,
 65,90,86,106,80,81,98,62,68,57,342,356,300,259,320,310,
 221,388,434,287,217,254,303,330,220,793,816],
 [29,39,42,32,38,18,21,15,51,50,97,100,94,69,92,89,76,95,
 53,55,83,108,101,73,63,103,72,78,60,65,90,86,106,80,81,
 62,68,57,237,252,353,384,326,421,408,364,365,312,425,333,
 428,337,361,373,405,444,374,393,286],
 [29,39,42,32,38,18,21,15,51,82,94,69,92,95,53,101,102,73,
 107,63,103,72,96,60,75,65,90,86,106,81,98,62,68,57,342,
 356,307,298,320,310,388,434,406,294,277,287,217,254,311,
 303,260,262,330,220,192,1768,1318,924,716,859,912,1781,
 1340,1015,895,665,816,810,843,709,822,979,745,883,1122,
 798,3535,2470,3856,2543,2389,2652,2137,2321,2461,2460,2066,
 8896,8762,8707,5614,5553,9159,5502,4638,4079,5726,3441,8362,
 9264,5063,8685,6225,9421,7036],
 [29,39,42,32,38,18,21,15,51,97,100,69,92,89,76,95,55,83,
 108,101,73,103,72,78,60,65,106,80,81,57,237,252,353,421,
 408,312,425,333,337,361,373,444,374,393,234,359,215,270,
 216,382,437,253,295,273,258,314,357,575,490,515,637,597,
 477,511,527,507,488,599,610,584,535,480,712,723,1354,1031,
 1322,1138],
 [29,39,42,32,38,18,21,15,51,97,100,94,69,92,95,55,101,73,
 63,103,72,60,65,90,86,106,81,62,68,57,237,252,353,384,
 326,421,425,333,428,337,361,373,405,444,374,393,286,324,
 307,298,229,280,318,406,267,213,260,262,323,192,441,556,
 526,447,544,519,470,716,745,844,904,738,929,756,1118],
 [29,39,42,32,38,18,21,15,51,97,100,94,69,92,95,55,101,73,
 63,103,72,60,65,90,86,106,81,62,68,57,353,384,326,408,
 364,365,425,333,428,361,373,405,393,286,324,307,298,229,
 280,318,406,267,213,260,262,323,192,588,616,455,441,526,
 549,447,626,617,465,519,568,529,498,716,745,1338,1225,
 1264,1319,1159,2482,2623],
 [29,39,42,32,38,18,21,15,58,51,67,50,97,82,100,94,105,69,
 85,92,89,76,59,95,53,55,104,83,108,101,102,73,107,63,
 103,56,72,78,96,60,75,65,90,86,70,106,80,81,98,62,68,
 57],
 [29,39,42,32,38,18,21,15,58,51,67,94,105,69,85,92,59,95,
 53,101,102,73,107,63,103,56,72,96,60,75,65,90,86,70,
 106,81,98,62,68,57,324,279,186,208,331,320,229,280,318,
 406,294,202,277,267,213,311,303,260,262,323,192,663,630,
 716,701,636,745],
 [29,39,42,32,38,18,21,15,58,51,67,94,105,69,85,92,59,95,
 101,102,73,107,63,103,56,72,96,60,75,65,90,86,70,106,
 81,98,62,68,57,324,279,186,208,359,331,320,229,280,318,
 406,294,202,277,267,213,295,311,303,260,262,323,192,663,
 630,716,701,636,745],
 [29,39,42,32,38,18,21,15,58,67,50,82,94,105,69,85,89,76,
 95,55,101,102,73,107,63,56,78,96,60,75,65,90,86,70,80,
 81,98,62,68,57,334,279,208,240,304,359,320,229,280,436,
 294,277,207,254,295,303,260,262,321,348,301,814,950,942,
 757,892,884],
 [29,42,32,18,21,67,97,79,94,69,76,77,55,83,108,74,101,
 103,54,78,86,106,80,68,57,353,326,408,312,333,374,286,
 334,208,300,240,351,248,264,309,329,255,243,251,203,382,
 435,277,287,207,295,226,281,235,187,314,335,588,575,500,
 455,549,580,585,489,427,505,465,599,584,502,431,784,862,
 1063,685,864,807,901,765,939,699,829,787,897,977,779,1050,
 1139,1064,1059,1125,1078,1082,1026,1094,1124,1092,1090,999,
 1005,2474,2377,1194,1258,1110,1167,1184,1222,1117,1199,1242,
 1292,1185,1233,2040,2050,2068],
 [31,19,30,58,51,67,50,61,79,88,59,77,53,71,74,73,107,84,
 56,72,54,78,96,87,70,80,99,98,49,68,52,289,407,360,336,
 313,363,354,236,186,208,234,300,320,244,280,251,202,277,
 253,303,214,262,231,245,430,515,500,397,496,458,461,518,
 412,485,426,488,505,478,494,514,417,462,692,824,880,921,
 672,802,940,875,834,811,958,1073,937,1316,1018,1155,910,
 1067,1009,1224,886,1109,1460,1625,1653,1412,1480,1583,1447,
 1510,1462,1411,1544,1745,1441,1575,1580,1414,1431,1497,2143,
 2164,2214],
 [31,19,30,58,51,67,50,61,79,88,59,77,53,71,104,73,107,63,
 84,56,72,54,78,96,87,70,80,99,98,49,68,52,289,407,360,
 336,313,363,354,236,186,208,234,300,244,280,227,251,202,
 277,214,262,250,231,430,515,500,397,496,458,461,489,412,
 485,426,488,478,494,514,417,462,692,879,880,921,672,890,
 940,875,834,811,1143,958,1073,1216,937,1316,1231,1018,1155,
 1087,910,1067,1254,1009,1224,1168,886,1109,1460,1625,1412,
 1480,1447,1510,1411,1544,1441,1575,1414,1431,2143,2164,2214]
  ,[31,19,30,58,51,67,50,61,79,94,88,89,59,77,53,71,104,
 74,73,107,63,84,56,72,54,78,96,87,90,70,98,49,68,52,
 289,407,360,336,313,363,354,236,186,208,300,244,280,251,
 201,276,202,277,214,262,231,430,515,397,496,458,461,412,
 485,426,488,478,494,417,462,692,880,921,957,1023,672,940,
 875,792,932,834,811,958,1073,937,1316,1018,1155,910,1067,
 1009,1224,886,1109,1460,1625,1412,1480,1447,1510,1411,1544,
 1441,1575,1414,1431,2143,2164,2214],
 [31,19,30,58,51,67,50,82,100,94,105,88,59,77,53,71,102,
 73,107,63,84,56,72,54,78,96,93,98,49,68,52,289,336,313,
 363,409,236,315,193,320,244,280,227,266,221,201,276,383,
 200,303,214,262,250,306,220,192,209,430,515,500,397,496,
 458,461,518,453,493,466,524,489,412,485,473,426,488,505,
 448,525,478,494,514,417,462,456,498,502,454,516,463,777,
 837,975,826,991,891],
 [31,19,30,58,51,67,50,82,100,105,88,89,59,77,53,71,64,
 108,102,73,107,63,84,56,72,54,78,96,93,80,99,98,49,68,
 52,289,336,313,363,409,354,236,315,193,234,320,227,266,
 270,221,383,200,253,303,250,306,273,220,430,515,397,496,
 458,461,453,493,466,524,412,485,426,488,448,525,478,494,
 417,462,456,498,454,516,777,837,975,826,991,891],
 [31,19,30,58,51,67,61,74,96,340,289,300,261,221,251,202,
 277,200,231,226,281,228,500,397,496,509,543,522,489,412,
 485,538,426,488,487,514,417,462,470,559,523,1160,924,788,
 793,796,1062,950,1449,880,1192,823,808,685,762,1975,1238,
 1015,963,672,724,728,1040,892,1421,869,1344,923,961,875,
 2044,1818,811,1315,1237,1277,1035,1093,1183,1146,995,1870,
 1003,1362,1577,2103,2113,1216,937,1316,1081,1326,1922,2267,
 1125,1098,1955,1025,1345,1546,2353,2583,1361,1136,1142,1230,
 1087,910,1067,1223,1591,2203,2005,1058,1061,1819,1066,1203,
 1367,1931,2403,1168,886,1109,1215,1556,2382,2458,2452,2713,
 2410,1974,2407,3893,2193,2033,2705,2677,2028,2086,2396,2649,
 2284,1957,2441,3135,2302,2440,2680,2767,2099,2161,1821,1981,
 1473,1697,1210,2374,1180,1838,2283,2437,1860,1412,1480,1586,
 1823,2009,2106,1687,1195,2311,1141,1779,2205,2358,1899,1791,
 1545,1783,1411,1544,1485,1904,2180,2342,1696,1176,2392,1132,
 1775,1961,2116,1896,1414,1431,1543,1839,1970,2090,3172,3235,
 3332,2315,3074,4757,3634,3377,3057,4023,2896,2502,3576,3911,
 3136,3047,4971,2902,3244,4612,3989,3322,3254,3250,2233,2947,
 4476,3411,3341,2752,3853,2889,2719,3549,3903,3281,2931,4926,
 2810,3028,4645,4237,3889,4692,4694,4736,3973,5769,4569,2143,
 4472,4328,3798,4985,4359,2164,4742,4396,4029,5145,4445,2214,
 3239,2920,3785,2773,2791,2922,2634,2508,3107,3423,4401,4016,
 3288,3365,6027,3171,3734,3605,5584,3510,3705,3693,3032,2908,
 3463,2953,4168,3186,2955,2727,2918,2584,3064,3154,5873,3145,
 3059,3613,3566,3157,3434,3443,4278,3906,4099,3440,4050,2792,
 4542,3877,2620,4525,3991,3490,5006,4392,3571,4898,3914,4194,
 5421,4889,3337,4855,4018,3051,4802,4158,2907,4511,3898,4181,
 5303,4575,3323,4557,4185,3104,5069,4785,3694,4440,3799,3869,
 5776,4747,5781,5160,5298,4567,5003,5460,5647,4382,6007,5053]
  ,[31,19,30,58,51,67,61,79,88,59,77,104,74,73,107,84,56,
 72,54,96,87,70,98,52,289,407,360,313,363,354,236,324,
 186,208,300,307,244,280,318,251,406,202,277,267,214,262,
 231,495,430,515,397,496,458,461,518,583,609,412,485,426,
 488,505,586,620,478,494,417,462,502,576,615,692,716,668,
 880,873,921,672,745,671,940,875,834,811,1102,1343,1139,
 958,1073,993,1506,937,1316,850,1671,1082,1018,1155,1100,
 1444,910,1067,952,1738,1038,1536,1092,1009,1224,886,1109,
 860,1602,2483,2690,1386,1460,1625,1677,1683,1412,1480,1447,
 1510,1637,1698,1411,1544,1464,1441,1575,1414,1431,3081,3143,
 3061,2988,3317,3073,2143,2164,2214,3239,3009,8828,3107,3334,
 4930,3264,9164,3463,3013,8308,3064,3209,8753,3161,5552,8016,
 8174,5238,9144,5724,7900,6108,5106,5825,7424,6106,8571,6529,
 6172,8924],
 [31,19,30,58,51,67,61,82,100,79,105,77,104,74,101,102,73,
 107,56,72,96,60,75,87,70,93,81,340,316,381,366,411,368,
 279,222,259,272,291,298,304,331,261,293,292,435,386,294,
 269,238,213,254,311,228,358,278,335,441,570,594,606,509,
 543,583,609,447,561,579,618,483,557,586,620,470,559,595,
 600,468,553,576,615,814,974,703,1670,757,1021,725,1500,
 1436,1371,1450,1331,1315,1314,958,1073,937,1316,1018,1155,
 910,1067,1009,1224,886,1109,1941,1860,2204,1783,2016,1896,
 2488,2512,2757,2413,2487,2631],
 [31,19,30,58,51,67,61,82,100,79,105,77,104,74,102,73,107,
 56,72,96,87,70,93,340,316,381,366,368,279,272,291,298,
 304,261,293,203,292,435,294,269,238,213,254,228,358,305,
 299,278,335,430,515,441,570,536,594,606,567,509,543,583,
 609,447,561,579,618,528,483,557,586,620,470,559,595,600,
 593,555,468,553,576,615,1334,1112,1246,1198,918,693,1151,
 1436,1371,1450,1331,1315,1314,1003,958,1073,2113,1354,937,
 1316,2267,1018,1155,2583,910,1067,2005,1322,1009,1224,2403,
 1046,1085,886,1109,2458,3417,3621,1941,1460,1625,2437,1860,
 2204,1447,1510,2358,1783,2016,1441,1575,2116,1896,3744,2664,
 4057,2891,3649,2749,4245,2695,2661,3449,2861,2635,4715,2614,
 8596,7276],
 [31,19,30,58,51,67,61,97,82,100,79,105,69,85,66,76,77,
 104,74,101,102,73,107,56,72,96,60,75,87,91,86,70,93,
 340,316,381,366,411,377,368,272,304,261,302,293,292,435,
 386,269,254,228,321,358,278,335,343,441,570,536,594,606,
 509,543,522,583,609,447,561,473,579,618,483,557,512,586,
 620,470,559,523,595,600,468,553,463,576,615,1436,1371,
 1450,1331,1315,1314],
 [31,19,30,58,51,67,61,97,82,100,79,105,69,85,66,76,77,
 104,74,101,102,73,107,103,56,72,96,60,75,87,91,86,70,
 93,81,340,316,381,366,411,377,368,272,304,331,261,293,
 292,435,386,269,254,311,228,358,278,335,343,441,570,594,
 606,509,543,583,609,447,561,579,618,483,557,586,620,470,
 559,595,600,468,553,576,615,1436,1371,1450,1331,1315,1314],
 [31,19,30,58,51,67,61,97,82,100,79,105,69,85,77,55,104,
 74,102,73,107,103,56,72,96,87,91,86,70,93,81,340,316,
 381,366,377,368,272,291,298,304,261,293,255,212,292,435,
 269,238,213,254,228,358,305,299,278,335,441,570,594,606,
 624,509,543,583,609,598,585,447,561,579,618,625,483,557,
 586,620,581,470,559,595,600,638,593,468,553,576,615,587,
 1436,1371,1450,1331,1315,1314],
 [31,19,30,58,51,67,82,100,94,105,88,59,77,53,71,102,73,
 107,63,84,56,72,54,78,96,93,80,99,98,49,68,52,289,336,
 313,363,409,354,236,324,315,193,320,244,280,227,266,221,
 406,383,200,303,214,262,250,306,220,430,515,500,397,496,
 458,461,518,453,493,466,524,489,412,485,426,488,505,448,
 525,478,494,514,417,462,456,498,502,454,516,777,837,975,
 826,991,891],
 [31,19,30,58,51,67,82,100,105,88,59,77,64,108,102,73,107,
 84,56,72,54,78,96,93,80,99,98,52,289,336,313,363,409,
 354,324,315,193,307,359,350,320,227,266,221,406,383,200,
 253,267,295,308,303,250,306,273,220,325,357,430,515,397,
 496,458,461,453,493,466,524,412,485,426,488,448,525,478,
 494,417,462,456,498,454,516,587,877,794,922,772,938,776,
 980,751,777,837,975,826,991,891,1139,1134,1059,1082,1094,
 1066,1092,1005],
 [31,19,58,67,61,82,105,85,88,59,104,64,101,102,107,84,56,
 54,96,60,75,87,98,49,52,471,340,316,389,475,345,392,355,
 362,542,411,377,283,249,222,331,223,311,343,482,551,397,
 537,570,453,531,543,545,560,412,540,561,448,504,557,512,
 550,546,417,548,559,454,497,553,463,788,876,742,727,1029,
 853,979,718,961,851,818,1436,1862,839,831,1450,1908,789,
 934,1315,1891,1403,1699,1091,1555,1143,1073,1052,1542,1216,
 1316,1171,1250,1156,1454,1231,1155,1126,1511,1087,1067,1456,
 1415,1065,1526,1254,1224,1154,1348,1168,1109,2566,2293,2120,
 2012,2627,2460,2252,2348,2691,1550,1516,1562,4352,2826,3583,
 2447,3900,2329,4512,2929,4134,2340,3486,2331,5682,5356],
 [31,41,19,30,58,51,67,79,88,59,77,73,107,84,54,87,70,49,
 68,289,316,407,360,345,313,363,377,315,244,280,329,406,
 214,262,245,349,335,441,570,556,526,558,458,461,549,447,
 561,527,474,562,544,478,494,470,559,568,535,569,480,587,
 1768,692,824,887,930,921,1781,895,802,869,940,763,1404,
 834,1327,1303,1427,1237,1341,1079,1601,958,1073,948,1667,
 1234,1534,1446,1392,1131,1134,850,1671,1419,1741,1018,1155,
 936,1538,1106,1548,1443,1722,952,1738,1317,1649,1243,1066,
 1009,1224,856,1570,1363,1665,1369,1295,860,1602,3535,1942,
 2952,2415,3544,2673,4570,3856,3044,2420,3568,2507,1784,5794,
 1853,1706,1460,1625,1854,1619,1883,1756,1447,1510,1863,1608,
 1846,1723,1441,1575,1859,1654,3974,3148,3972,2986,3477,2667,
 3287,2871,4814,4161,4183,3327,4633,3102,3875,2978,3115,2877,
 3181,2666,5684,3534,4112,3222,8656,8551,9337,5797,4798,4424,
 5371,5344,5348,3518,3506,3683,3737,3066,5155,4589,3431,4426,
 4190,3888,3713,4560,4479,3307,2976,4046,3919,4357,4549,4706,
 4892,4743,4287,4406,9212,9370,9297,6988,6505,6105],
 [32,18,15,51,50,97,100,94,69,89,76,95,53,55,108,73,103,
 72,78,60,65,90,86,106,80,68,252,339,384,369,410,365,399,
 373,387,444,380,341,186,240,304,247,261,212,202,254,231,
 245,228,588,565,515,537,556,592,624,477,574,598,580,572,
 612,625,465,571,581,599,573,494,548,568,601,638,431,566,
 587,824,809,1246,802,868,1151,970,1540,1840,916,1519,1805,
 909,1498,1763,1055,1219,1335,1362,1294,1081,1332,1095,1345,
 1217,1223,984,1269,1214,1203,1284,1215,2314,2229,1625,1777,
 3637,1510,1742,3300,1575,1736,3123,3815,3467,3391,4088,2980,
 4140,3299,2624,4111,2678,2604,2687],
 [32,18,15,51,50,97,100,94,69,92,89,76,95,53,55,83,108,
 101,73,63,103,72,78,60,65,90,86,106,80,81,62,68,57,237,
 252,282,353,339,384,326,369,421,376,408,410,364,365,352,
 312,395,425,333,367,428,344,337,399,361,373,433,405,387,
 444,374,380,393,317,286,341],
 [32,18,15,51,67,50,97,100,79,94,69,92,76,55,83,64,108,
 101,73,107,63,72,96,60,65,87,90,86,106,81,49,68,237,
 282,353,326,364,352,312,333,361,433,405,300,272,307,351,
 302,293,318,382,386,287,269,267,328,321,358,323,314,343,
 455,537,441,556,477,531,509,549,427,540,447,527,465,504,
 483,544,459,548,470,568,431,497,468,480,1006,828,972],
 [32,18,15,51,67,50,97,100,79,94,69,92,89,95,53,83,64,108,
 101,73,107,63,103,54,78,96,60,65,87,90,86,106,80,62,49,
 57,237,282,353,326,421,364,352,312,333,428,361,433,405,
 374,300,272,298,309,437,287,269,213,348,357,537,536,556,
 531,522,549,540,473,527,504,512,544,548,523,568,497,463,
 480,2807,2736,2656],
 [32,18,15,51,67,50,97,100,79,94,105,69,92,88,53,55,83,64,
 108,101,73,107,63,103,78,96,60,65,87,86,80,81,62,49,57,
 237,282,353,326,421,364,352,312,333,428,361,433,393,298,
 309,293,437,213,348,358,357,500,530,537,556,518,564,531,
 549,489,508,540,527,505,534,504,544,514,552,548,568,502,
 486,497,480,989,1006,977,828,779,972],
 [32,18,15,51,67,50,97,100,79,94,105,69,92,88,76,53,83,64,
 108,101,73,63,72,54,96,60,65,87,90,86,106,80,68,237,
 282,353,326,312,333,361,433,405,374,307,351,264,302,318,
 382,404,386,267,328,281,321,323,314,325,343,455,537,536,
 556,477,531,522,549,427,540,473,527,465,504,512,544,459,
 548,523,568,431,497,463,480,844,1321,738,1282,756,1236],
 [32,18,15,51,67,50,97,100,79,94,105,69,92,88,89,95,55,83,
 64,108,101,73,107,63,103,54,78,96,60,65,87,90,86,106,
 81,62,57,237,282,353,326,421,312,333,428,361,433,405,374,
 393,298,309,404,437,213,348,325,357,537,441,556,531,509,
 549,540,447,527,504,483,544,548,470,568,497,468,480,844,
 1321,738,1282,756,1236],
 [32,18,15,58,51,50,61,97,82,100,94,69,85,89,76,59,95,53,
 55,83,101,73,103,56,72,78,60,75,65,90,86,70,106,80,62,
 57,252,339,384,369,410,365,395,425,367,399,373,387,444,
 380,240,247,215,261,203,207,231,245,228,187,537,556,606,
 531,549,609,540,527,618,504,544,620,548,568,600,497,480,
 615,3726,3642,3645],
 [32,18,15,58,51,50,61,97,82,100,94,69,85,89,76,59,95,53,
 55,108,102,73,84,103,56,72,78,60,75,65,90,86,106,80,68,
 252,339,384,369,410,365,399,373,387,444,380,341,240,215,
 221,203,207,245,220,187,537,556,592,624,531,549,574,598,
 540,527,612,625,504,544,571,581,548,568,601,638,497,480,
 566,587,970,1540,1840,916,1519,1805,909,1498,1763],
 [32,18,15,58,51,50,61,97,82,100,94,69,89,76,59,95,53,55,
 108,102,73,84,103,56,72,78,60,75,65,90,86,70,106,80,68,
 252,339,384,369,410,365,399,373,387,444,380,341,259,240,
 215,203,217,207,245,187,537,556,592,624,531,549,574,598,
 540,527,612,625,504,544,571,581,548,568,601,638,497,480,
 566,587,970,1540,1840,916,1519,1805,909,1498,1763],
 [32,18,15,58,51,50,61,97,82,100,94,69,92,76,59,53,55,83,
 101,102,73,63,84,72,60,75,65,90,86,70,106,80,81,252,
 339,384,369,365,425,367,373,387,444,380,259,307,351,302,
 310,318,382,386,217,267,328,321,330,323,314,343,537,556,
 594,606,531,549,583,609,540,527,579,618,504,544,586,620,
 548,568,595,600,497,480,576,615,970,916,909],
 [32,18,51,50,97,100,94,69,76,53,55,83,108,101,102,73,63,
 84,72,60,75,90,86,106,80,81,68,252,339,384,369,541,365,
 395,425,367,476,387,444,380,472,342,315,259,302,318,221,
 388,383,202,217,267,328,330,314,343,451,455,416,531,549,
 583,450,427,413,504,544,586,452,459,396,497,480,576,1160,
 663,819,915,1291,695,873,1238,701,863,1040,801,1346,753,
 798,961,927,832,821,905,1146,995,1020,1076,1104,969,1125,
 1098,1017,1161,1071,885,1058,1061,1019,1090,1140,3863,2407,
 3314,2441],
 [33,28,23,51,50,61,97,100,94,105,69,85,89,66,76,95,55,83,
 108,74,101,73,103,72,78,96,60,75,65,90,91,86,106,62,68,
 52,57,237,252,339,369,410,395,367,399,361,373,387,380,
 341,240,215,261,203,207,245,228,187,537,441,570,531,509,
 543,540,447,561,504,483,557,548,470,559,497,468,553,844,
 904,738,929,756,1118],
 [33,28,23,51,50,61,97,100,94,105,69,85,89,76,53,55,83,
 108,74,101,73,84,103,72,78,96,60,75,65,90,91,86,80,62,
 68,52,57,237,252,339,369,410,364,365,395,367,399,361,373,
 387,341,240,291,215,203,207,238,245,187,530,537,570,564,
 531,543,508,540,561,534,504,557,552,548,559,486,497,553,
 1174,1013,1323],
 [33,28,23,51,50,61,97,100,94,105,69,85,92,66,53,55,83,
 108,74,101,73,63,84,78,60,65,90,91,86,80,81,57,237,252,
 339,369,364,365,395,367,399,361,373,387,380,341,307,298,
 302,309,329,212,382,437,435,267,213,321,348,349,299,314,
 357,335,530,537,570,564,531,543,508,540,561,534,504,557,
 552,548,559,486,497,553,1613,1833,1645],
 [33,28,23,51,50,61,97,100,94,105,69,85,92,95,53,83,108,
 74,101,73,63,78,96,60,75,65,90,91,86,106,80,52,57,237,
 252,339,369,410,395,367,399,361,373,387,380,341,307,291,
 298,261,302,309,382,437,267,238,213,228,321,348,314,357,
 537,570,536,531,543,522,540,561,473,504,557,512,548,559,
 523,497,553,463,844,904,738,929,756,1118],
 [33,28,23,51,50,61,97,100,94,105,69,85,92,95,55,83,108,
 74,101,73,63,84,78,96,60,75,65,90,91,86,106,81,57,237,
 252,339,369,410,364,365,395,367,399,361,373,387,341,307,
 291,298,302,309,382,437,435,267,238,213,321,348,314,357,
 335,537,441,570,531,509,543,540,447,561,504,483,557,548,
 470,559,497,468,553,1174,1013,1323],
 [33,28,23,51,50,97,100,94,69,89,76,95,53,55,101,73,103,
 72,78,60,65,90,86,106,80,57,282,384,326,481,541,352,521,
 476,433,444,374,491,342,356,240,272,293,388,434,269,214,
 245,358,467,537,570,592,606,637,597,574,583,609,479,612,
 618,626,617,571,586,620,510,548,559,601,600,623,605,566,
 615,720,824,809,1246,802,868,1151,1540,1502,3083,1519,1486,
 3085,1498,1401,2964,1263,1219,1667,1335,1294,1671,1332,1538,
 1095,1217,1738,1396,1269,1570,1214,1284,1602,1991,2289,1777,
 2283,8417,1742,2205,5233,1736,1961,5694,3682,3150,4672,3286,
 3401,4123,4196,3844,3494],
 [33,28,23,51,50,97,100,94,89,76,95,53,55,83,108,101,73,
 103,72,78,65,90,86,106,80,62,68,57,237,252,339,369,410,
 364,365,395,367,399,387,380,341,300,259,215,261,206,435,
 287,217,207,228,187,335,565,430,397,614,458,531,543,572,
 466,412,608,426,504,557,478,417,621,456,497,553,700,737,
 712,705,755,723,698,888,927,825,832,833,821,905,1343,1020,
 1506,1190,1423,969,1521,1017,1444,1182,1255,885,1536,1019,
 1541,1204,1690,1916,1923,2074,2038,2166,2540,2324,2549,2312,
 2598,2960,2527,2309,2409,2417,2663,2802],
 [33,28,23,51,50,97,100,94,92,95,53,55,83,108,101,73,63,
 78,65,90,86,106,80,81,57,237,252,339,410,364,365,395,
 367,399,361,373,387,380,341,300,259,302,309,206,435,267,
 213,228,239,314,357,335,565,430,397,458,531,543,572,466,
 412,608,426,504,557,573,478,417,621,456,497,553,663,630,
 915,772,880,703,695,685,701,636,715,801,751,753,699,1621,
 1569,1807,905,1343,1020,1506,1190,1423,969,1521,1017,1444,
 1182,1255,885,1536,1019,1541,1204,1690,2455,2705,2056,2411,
 2680,2061,1979,2262,2055,2540,2324,2549,2312,2598,2960,2527,
 2309,2409,2417,2663,2802],
 [33,28,23,58,51,67,50,61,97,100,79,94,105,69,85,92,88,89,
 66,76,95,77,53,71,55,83,64,108,74,101,102,73,107,63,84,
 103,72,54,78,96,60,75,65,87,90,91,86,106,93,80,99,81,
 62,49,68,52,57],
 [33,28,23,58,51,67,50,97,100,79,94,69,88,89,76,95,55,83,
 64,108,101,73,103,72,54,78,60,65,87,90,86,106,62,49,68,
 57,282,384,326,481,541,425,333,521,476,433,444,374,491,
 472,240,247,264,215,203,207,231,281,245,187,537,441,570,
 531,509,543,540,447,561,504,483,557,548,470,559,497,468,
 553,1321,1282,1236],
 [33,28,23,58,51,67,50,97,100,79,94,69,89,76,53,55,83,64,
 108,101,102,73,107,103,72,54,78,60,65,87,90,86,80,62,
 49,68,57,282,384,326,481,541,352,425,333,521,476,433,444,
 374,472,240,272,215,203,207,269,245,187,530,537,570,564,
 531,543,508,540,561,534,504,557,552,548,559,486,497,553,
 2299,2305,2169],
 [33,28,23,58,51,67,50,97,100,79,94,69,92,88,53,55,83,64,
 108,101,102,73,107,63,78,60,65,87,90,86,80,81,57,282,
 384,326,481,352,425,333,521,476,433,444,374,491,472,307,
 298,302,309,293,382,404,437,267,213,321,348,358,314,325,
 357,530,537,570,564,531,543,508,540,561,534,504,557,552,
 548,559,486,497,553,1271,1281,1566],
 [33,28,23,58,51,67,50,97,100,79,94,69,92,95,53,83,64,108,
 101,73,63,54,78,60,65,87,90,86,106,80,49,57,282,384,
 326,481,541,425,333,521,476,433,444,374,491,472,272,307,
 298,247,264,302,309,382,437,269,267,213,231,281,321,348,
 314,357,537,570,536,531,543,522,540,561,473,504,557,512,
 548,559,523,497,553,463,1321,1282,1236],
 [33,28,23,58,51,67,50,97,100,79,94,69,92,95,55,83,64,108,
 101,102,73,107,63,54,78,60,65,87,90,86,106,81,57,282,
 384,326,481,541,352,425,333,521,476,433,444,374,472,272,
 307,298,302,309,382,404,437,269,267,213,321,348,314,325,
 357,537,441,570,531,509,543,540,447,561,504,483,557,548,
 470,559,497,468,553,2299,2305,2169],
 [33,28,50,97,100,94,69,85,92,88,76,95,55,83,108,101,73,
 63,103,72,54,78,65,86,106,80,81,62,68,57,237,384,481,
 422,408,541,364,425,521,346,337,476,361,491,371,286,472,
 334,193,322,244,255,404,200,319,295,299,306,325,616,565,
 500,518,531,619,572,489,505,504,610,573,514,502,497,784,
 862,807,765,918,861,939,820,787,1068,996,1484,1954,1197,
 1829,1072,1887,1108,1945,1240,1842,1150,1864,1057,2216,2479,
 2024,2657,2548,4300,4483],
 [33,28,51,50,97,100,69,89,66,76,95,53,55,83,108,101,73,
 103,72,96,60,75,65,90,86,106,80,62,68,57,237,252,339,
 408,410,364,365,395,367,337,399,361,373,387,380,286,341,
 300,259,215,261,206,435,207,250,228,239,187,335,565,495,
 547,531,543,572,503,538,504,557,573,532,539,497,553,700,
 876,737,880,703,712,705,755,723,1621,1569,1807,905,1343,
 1020,1506,969,1521,1017,1444,885,1536,1019,1541,2444,2705,
 2056,2680,2061,3539,3508],
 [33,28,51,50,97,100,69,92,66,95,53,55,83,108,101,73,63,
 96,60,75,65,90,86,106,80,81,57,237,252,339,369,408,410,
 364,365,395,367,337,361,373,387,380,286,341,300,259,302,
 309,206,435,287,217,267,213,250,228,239,314,357,565,495,
 547,531,543,572,503,538,504,557,573,532,539,497,553,663,
 630,876,915,772,695,685,701,636,853,715,801,751,753,699,
 2044,1302,1438,1439,905,1343,1020,1506,969,1521,1017,1444,
 885,1536,1019,1541,2455,5052,2411,5227],
 [33,28,51,97,100,94,69,85,92,88,76,95,53,83,108,101,73,
 63,103,72,54,78,60,86,106,80,81,62,68,57,237,384,481,
 541,364,425,521,346,337,476,361,444,491,371,286,472,324,
 322,244,212,243,266,404,200,319,311,299,306,325,616,565,
 500,518,619,572,489,505,504,610,573,514,502,497,788,804,
 983,803,901,810,920,820,897,954,976,842,813,1047,835,1954,
 1197,1829,1072,1887,1108,1945,1240,1842,1150,1864,1057,2120,
 2348,1703,1688,1684],
 [33,36,23,58,50,100,94,69,89,59,95,108,101,102,73,63,78,
 86,106,80,57,481,521,346,491,334,272,359,302,309,293,255,
 270,221,436,434,213,295,321,358,305,273,220,357,565,597,
 604,574,602,572,533,450,617,611,487,571,590,573,605,591,
 529,396,566,577,1378,630,772,778,685,1488,636,751,699,842,
 1229,857,1056,1228,1205,867,1145,1131,1294,1304,1326,1206,
 945,969,1119,1239,1098,1221,1355,926,1105,1127,1217,1405,
 1591,1070,848,1083,1243,1349,949,1019,1060,1193,1140,1128,
 1284,1080,1556,3034,2912,2076,1571,1437,1358,1849,1373,1368,
 1467,2009,2135,1568,1402,1432,1141,1832,1380,1307,1397,2180,
 2121,1525,1408,1430,1890,1417,1336,1389,1970,4213,4017,4263,
 4515,3950,4338,4516,4331,4065,3921,4066,4615,3976,4127,4793,
 4266,4906,4026,2240,2013,2297,1971,2286,1962,3049,2815,3661,
 3579,6043,2732,4970,3080,2708,3384,4133,3867,3179,6019,4384,
 2734,2845,4163,3668,5153,2805,5170,2856,2605,3118,4089,4119,
 3226,5396,5051,3219,3046,4084,3632,4935,2804,5958,2607,2722,
 3608,3611,3934,3206,5704,5485,4608,7601,4917,6656,4380,8603,
 7453,6839,7209,7526,6160,6460],
 [33,36,23,58,51,50,61,94,69,76,95,53,71,83,74,101,102,73,
 63,84,72,78,96,60,65,90,91,70,106,80,99,68,57,252,369,
 410,367,399,373,380,341,208,300,240,307,291,304,216,382,
 435,267,254,262,314,335,482,467,537,536,545,479,540,473,
 504,512,550,510,497,463,719,670,880,809,1635,662,709,669,
 940,868,1708,645,904,929,1091,1158,1052,1039,1156,1089,
 1126,1249,1065,1002,1154,1103,1703,1550,1685,1620,1688,1516,
 1693,1646,1684,1562,1691,1582,2003,1984,2001],
 [33,36,23,58,51,50,61,94,105,69,92,76,95,53,71,101,102,
 73,63,84,72,78,96,60,65,90,91,70,106,80,99,57,252,369,
 410,367,399,373,380,341,208,307,291,304,216,382,437,435,
 267,238,254,260,262,250,314,357,335,482,467,537,536,545,
 479,540,473,504,512,550,510,497,463,935,719,876,670,662,
 843,709,853,669,645,904,929,1091,1158,1052,1039,1156,1089,
 1126,1249,1065,1002,1154,1103,1703,1550,1685,1620,1688,1516,
 1693,1646,1684,1562,1691,1582,2003,1984,2001],
 [33,36,23,58,51,50,94,69,66,76,95,53,83,74,101,102,73,63,
 72,78,60,90,70,106,80,99,68,57,252,369,410,367,399,380,
 341,315,208,300,240,307,304,350,206,216,383,287,207,267,
 254,308,262,228,349,290,239,314,335,482,467,537,536,545,
 479,504,512,550,510,605,497,463,719,722,1272,1710,670,662,
 709,715,1053,1639,801,869,669,645,904,1091,1158,1933,1052,
 1039,1156,1089,1126,1249,1927,885,931,1065,1002,1154,1103,
 1785,1974,1801,1957,1703,1550,1685,1620,1688,1516,1693,1646,
 2221,1684,1562,1691,1582,2115,2961,2043,2854,2003,1984,2001,
 5442,5364],
 [33,36,23,58,51,50,94,69,76,95,53,101,102,73,63,72,78,60,
 90,70,106,80,68,57,252,369,410,367,399,380,341,208,307,
 304,350,261,216,382,435,267,254,308,262,314,335,565,482,
 467,537,536,592,614,543,545,479,540,473,612,608,504,557,
 512,550,510,601,621,497,553,463,719,670,845,662,709,669,
 645,904,929,1287,899,1426,1091,1158,1305,1391,958,1052,
 1039,1187,902,1290,1156,1089,1377,1455,1018,1126,1249,1182,
 1299,910,1264,928,1406,1065,1002,1154,1103,1204,1448,886,
 2129,2239,1703,1550,2094,1733,1685,1620,1688,1516,2042,1825,
 1693,1646,2290,1684,1562,1691,1582,2122,4818,2928,3970,4337,
 2840,3578,3652,3255,3348,4544,3087,3862,4681,3060,3521,3470,
 3212,3065,2003,1984,2001,3257,3572,3567,4686,3129,3512,3533,
 3356,3063,3140,4887,3282,3553,3457,3979,3205,3603,3464,3241,
 3106,3295,4149,6040,4835,5016,5912,4547,5144,5362,4455,4693,
 5400,5302,5826,5401,5181,5677],
 [33,36,23,58,51,50,94,69,88,89,76,59,53,64,101,102,73,63,
 72,60,90,70,106,93,80,81,68,282,481,422,521,491,356,279,
 208,193,351,322,331,280,264,302,293,318,266,216,386,434,
 294,277,200,328,262,281,321,358,323,306,258,325,343,490,
 451,592,614,604,554,416,543,574,602,533,450,612,608,507,
 413,571,590,563,452,559,601,621,529,396,566,577,922,823,
 1042,980,923,1054,791,1129,838,1260,846,1157,1730,1773],
 [33,36,23,58,51,50,94,69,89,76,59,53,101,102,73,63,72,60,
 90,70,106,80,68,282,481,422,521,491,356,208,351,280,318,
 216,386,434,277,269,328,262,321,358,323,258,343,482,467,
 490,451,592,614,597,554,416,513,574,602,533,450,612,608,
 617,507,413,571,590,563,452,559,601,621,605,529,396,566,
 577,870,814,1449,914,757,1421,791,1129,838,1260,846,1157,
 905,907,995,1219,1667,1335,1577,1020,981,1104,1294,1304,
 1326,969,1119,1098,1332,1095,1546,1017,946,1071,1217,1738,
 1405,1591,885,931,1061,1396,1269,1214,1367,1019,1060,1140,
 1284,1080,1556,2148,2074,1677,1627,1586,2619,2038,1637,1529,
 1485,2366,2166,1746,1631,1543,3682,3286,2518,2571,2844,2820,
 2874,2730,2561,2520,2689,2751,2766,2834],
 [33,36,23,58,51,50,94,105,69,92,66,76,95,53,83,74,101,
 102,73,63,72,78,96,60,65,90,70,106,80,68,252,369,410,
 367,399,373,380,208,307,304,206,216,382,435,386,267,254,
 262,314,335,343,565,482,467,537,570,536,572,545,479,540,
 561,473,579,504,557,512,573,550,510,497,553,463,576,719,
 670,704,662,709,669,698,645,904,929,1197,1091,1158,1072,
 1052,1039,1108,1156,1089,1240,1126,1249,1150,1065,1002,1057,
 1154,1103,1703,2547,1550,1685,2754,1620,1688,2360,1516,1693,
 3092,1646,1684,2534,1562,1691,2496,1582,2003,1984,2001],
 [33,36,23,58,51,50,100,94,69,88,89,59,95,53,64,108,101,
 102,73,63,78,60,86,106,93,80,81,57,282,481,352,521,346,
 433,491,371,356,279,193,322,331,264,302,309,293,266,270,
 221,404,434,294,200,213,319,311,306,273,220,357,490,451,
 574,602,533,450,507,413,571,590,529,396,566,577,630,772,
 707,695,685,762,636,751,717,753,699,785,1771,954,842,1056,
 1228,1145,1131,1239,1221,1105,1127,1083,1243,1193,1128,5163,
 7909,1437,1358,1368,1467,1402,1432,1307,1397,1408,1430,1336,
 1389,2013,1971,1962],
 [33,36,23,58,51,50,100,94,89,59,95,77,53,55,64,108,101,
 102,73,107,63,103,54,78,60,87,86,106,93,80,81,49,57,
 282,481,352,521,346,433,491,371,356,279,193,222,309,270,
 221,434,294,200,223,269,213,273,220,357,490,451,574,602,
 533,450,507,413,571,590,529,396,566,577,870,630,772,685,
 914,636,751,699,954,842,1056,1228,1145,1131,1239,1221,1105,
 1127,1083,1243,1193,1128,1437,1358,1368,1467,1402,1432,1307,
 1397,1408,1430,1336,1389,2013,1971,1962],
 [33,36,23,58,51,67,50,61,97,100,79,94,105,69,92,88,89,66,
 76,59,95,77,53,71,55,83,64,108,74,101,102,73,107,63,84,
 103,72,54,78,96,60,65,87,90,91,86,70,106,93,80,99,81,
 62,49,68,52,57],
 [33,36,23,58,51,67,50,94,69,89,59,95,77,53,55,108,101,
 102,73,107,63,78,60,86,106,93,80,81,57,282,481,352,521,
 346,433,491,371,279,208,193,302,309,293,270,221,294,277,
 200,213,273,220,357,490,451,501,574,583,602,533,450,506,
 507,413,487,571,586,590,529,396,499,566,576,577,630,772,
 695,685,762,636,751,753,699,785,954,842,1056,995,1228,
 1145,1104,1131,1239,1098,1221,1105,1071,1127,1083,1061,1243,
 1193,1140,1128,1437,1358,1180,1368,1467,1244,1402,1432,1141,
 1307,1397,1163,1408,1430,1132,1336,1389,1202,2013,1971,1962]
  ,[33,36,23,58,51,67,50,94,69,89,76,59,53,101,102,73,
 107,63,103,72,54,60,90,70,106,93,80,81,68,282,481,422,
 521,346,491,279,208,193,351,322,331,280,318,216,386,294,
 277,200,328,319,311,262,323,258,343,490,451,501,592,594,
 614,604,554,416,513,574,583,602,533,450,506,612,579,608,
 507,413,487,571,586,590,573,563,452,517,601,595,621,529,
 396,499,566,576,577,791,1129,838,1260,846,1157],
 [33,36,23,58,51,67,50,97,79,94,69,88,89,76,59,77,53,55,
 64,101,102,73,107,63,103,72,54,60,90,70,106,93,80,81,
 68,282,481,422,352,521,346,491,208,351,280,318,266,216,
 404,386,277,328,262,323,306,258,325,343,490,451,592,614,
 554,416,574,602,533,450,612,608,507,413,571,590,563,452,
 601,621,529,396,566,577,791,1129,838,1260,846,1157],
 [33,36,23,58,51,67,50,97,79,94,69,88,89,76,59,77,53,55,
 101,102,73,107,63,72,60,87,90,70,106,93,80,81,49,68,
 282,481,422,352,521,491,208,351,244,280,302,293,318,216,
 386,277,328,214,262,321,358,323,258,343,490,451,592,614,
 554,416,543,574,602,533,450,612,608,507,413,571,590,563,
 452,559,601,621,529,396,566,577,791,1129,838,1260,846,1157 
  ],[33,36,23,58,51,67,50,100,69,88,89,59,95,77,53,55,
 64,108,101,102,73,107,63,103,54,78,60,86,106,93,80,81,
 57,282,352,521,346,433,491,371,279,193,234,309,266,270,
 221,294,200,253,213,306,273,220,325,357,490,451,397,574,
 602,533,450,507,413,448,571,590,529,396,566,577,630,922,
 772,685,636,980,751,699,954,842,1056,1228,1145,1131,1239,
 1221,1105,1127,1083,1243,1193,1128,1437,1358,1368,1467,1402,
 1432,1307,1397,1408,1430,1336,1389,2013,1971,1962],
 [33,36,28,51,50,69,92,89,76,95,53,55,108,73,63,103,78,60,
 65,86,80,81,62,68,57,237,282,422,541,364,352,346,361,
 433,371,472,356,229,244,230,293,434,294,253,214,273,301,
 235,278,551,467,558,554,513,453,583,560,479,562,507,487,
 448,546,510,569,529,499,454,576,1318,877,794,942,887,1107,
 714,674,1340,938,776,884,721,693,785,2138,2201,2153,1287,
 1183,1426,1338,1253,1446,1020,1076,1829,1187,1096,1290,1366,
 1230,1443,1017,1161,1945,1264,1213,1406,1252,1147,1369,1019,
 1090,1864,2564,2673,2325,2725,2507,2367,2466,2356,2173,3117,
 2637,4282,2778,2597,3723,3245,2425,4448,3147,2768,4361,3100,
 2516,3598,3267,2568,4249],
 [33,36,28,51,50,100,79,69,92,89,95,77,53,55,104,108,73,
 107,63,103,72,54,78,60,65,93,80,81,98,62,49,68,57,237,
 282,422,364,352,346,476,361,433,371,472,356,279,234,229,
 244,230,270,288,434,294,253,260,214,246,273,301,490,501,
 397,496,554,513,453,493,533,506,412,485,507,487,448,525,
 563,517,417,462,529,499,454,516,1271,1281,1566],
 [33,36,28,51,50,100,92,89,66,76,95,53,71,55,108,102,73,
 63,84,103,72,78,65,91,86,80,99,81,62,68,52,57,252,376,
 408,410,365,344,337,399,317,286,341,342,315,279,234,229,
 227,230,270,288,388,383,294,253,260,250,246,273,301,467,
 490,430,501,469,554,458,513,479,533,466,506,449,507,426,
 487,510,563,478,517,442,529,456,499,927,832,821],
 [33,36,28,51,50,100,92,89,76,95,53,55,83,108,101,63,72,
 60,65,90,86,106,81,62,68,57,252,339,376,408,410,365,395,
 373,387,317,286,341,247,248,261,206,435,308,231,228,239,
 192,335,588,565,482,495,397,567,547,554,513,543,580,572,
 545,503,412,528,538,599,573,550,532,417,555,539,529,499,
 553,959,716,847,1048,745,882,1310,1232,1302,1324,1301,1438,
 1385,1395,1439,1287,1183,1338,1196,1253,1131,1187,1096,1366,
 1136,1230,1264,1213,1252,1046,1147,1128,2111,2070,1849,1585,
 1782,1832,1469,1791,1890,1666,1888,2632,3203,3163,2526,2857,
 2638,3297,2958,2594,3683,4190,4046],
 [33,36,28,51,67,50,97,79,94,69,92,76,77,53,55,104,83,101,
 73,107,63,103,72,54,78,60,65,93,80,81,98,62,49,68,57,
 237,282,481,364,352,521,346,476,361,433,491,371,472,208,
 244,280,216,277,214,262,258,490,501,500,530,554,513,518,
 564,533,506,489,508,507,487,505,534,563,517,514,552,529,
 499,502,486,954,1271,842,1281,1047,1566],
 [33,36,28,51,67,50,97,94,69,89,76,95,77,53,55,104,83,64,
 101,73,107,63,103,72,54,78,60,90,106,93,80,81,98,62,49,
 68,57,237,282,481,422,541,364,352,521,346,476,491,371,
 472,208,193,280,216,277,200,262,258,490,451,501,554,416,
 513,533,450,506,507,413,487,563,452,517,529,396,499,888,
 791,825,838,833,846],
 [33,36,28,51,67,50,100,79,69,89,76,95,77,53,55,104,108,
 73,107,63,103,72,54,78,60,86,80,81,62,49,68,57,237,282,
 541,364,352,346,476,361,433,371,472,279,234,229,244,230,
 270,288,251,292,294,253,260,214,246,273,301,235,278,490,
 451,501,397,554,416,513,453,533,450,506,412,507,413,487,
 448,563,452,517,417,529,396,499,454,954,842,1047],
 [33,36,28,58,51,50,61,69,92,89,66,76,95,53,71,55,108,102,
 73,63,84,103,78,60,65,91,86,80,81,62,68,52,57,252,376,
 408,410,365,344,337,373,317,286,341,279,234,229,227,230,
 270,288,276,294,253,260,250,246,273,301,209,551,467,490,
 501,558,469,554,513,560,479,533,506,562,449,507,487,546,
 510,563,517,569,442,529,499,1302,1438,1439],
 [33,36,28,58,51,50,61,97,94,92,89,66,76,95,53,71,55,83,
 108,74,101,63,103,78,60,65,90,91,86,106,99,81,62,68,52,
 57,252,376,408,410,365,395,344,337,399,373,387,317,286,
 341,222,247,248,261,201,223,231,226,228,192,551,490,501,
 558,554,513,560,533,506,562,507,487,546,563,517,569,529,
 499,1893,1907,1876],
 [33,36,28,58,51,50,61,100,92,89,66,76,95,53,71,55,83,108,
 74,101,102,63,84,72,60,65,90,91,86,106,81,62,68,52,57,
 252,339,376,408,410,365,395,373,387,317,286,341,222,248,
 201,276,223,226,192,209,482,495,490,501,567,547,554,513,
 545,503,533,506,528,538,507,487,550,532,563,517,555,539,
 529,499,1310,1232,1302,1324,1301,1438,1385,1395,1439],
 [33,36,28,58,51,67,50,61,97,100,79,94,105,69,92,88,89,66,
 76,95,77,53,71,55,104,83,64,108,74,101,102,73,107,63,
 84,103,72,54,78,96,60,65,87,90,91,86,106,93,80,99,81,
 98,62,49,68,52,57],
 [33,36,32,18,23,58,67,50,61,100,105,69,92,88,89,59,95,83,
 64,108,74,102,73,107,63,84,103,54,78,96,65,87,90,86,70,
 106,62,52,57,334,279,193,234,322,359,331,230,309,251,201,
 203,404,437,436,294,200,253,213,319,295,311,246,348,325,
 357,630,1334,807,921,957,1246,636,1198,875,792,1151,2338,
 2523],
 [33,39,28,38,23,21,51,50,97,100,94,69,92,89,76,95,53,55,
 83,108,101,73,63,103,72,78,60,65,90,86,106,80,81,62,68,
 57,237,252,282,384,326,369,481,422,541,364,365,352,425,
 333,367,521,346,476,361,373,433,444,374,380,491,371,472],
 [33,39,36,42,28,38,51,50,97,100,94,69,92,89,76,95,53,55,
 83,108,101,73,63,103,72,78,60,65,90,86,106,80,81,62,68,
 57,237,252,282,384,481,422,408,410,541,364,365,352,425,
 521,346,337,399,476,361,373,433,444,491,371,286,341,472],
 [34,25,67,61,97,82,79,85,76,59,71,104,74,107,103,56,54,
 96,60,75,65,87,86,70,99,62,49,52,340,316,370,402,362,
 411,249,342,334,208,300,222,240,272,247,248,292,388,436,
 277,287,223,207,328,260,214,231,226,228,301,500,397,537,
 441,518,453,540,447,505,448,532,514,417,548,470,819,935,
 720,722,778,1347,863,715,884,795,1308,985,978,1555,1011,
 1219,948,1294,850,1454,1332,936,1217,952,1526,1269,856,
 1284,860,2694,2864,1991,2758,2289,1653,1410,1583,1513,1462,
 1387,1745,1561,1580,1382,1497,1551,3023,3591,2999,2887,3112,
 3290,2793,2936,1812,1845,1826,8450,7025],
 [35,19,34,25,58,51,61,97,82,85,59,71,104,103,56,54,75,70,
 99,316,492,370,402,520,362,411,484,356,193,247,248,266,
 277,231,226,348,306,575,592,594,614,554,458,518,453,602,
 612,579,608,507,426,590,514,417,601,595,621,529,456,577,
 924,722,950,1107,750,1347,1015,914,892,769,795,941,1371,
 985,3826,1331,3450,1314,3273,1287,1035,1219,948,1764,1577,
 1338,1196,1020,993,1829,1059,1588,1326,1187,988,1332,936,
 1836,1546,1366,1136,1017,1100,1716,1591,1264,1166,1842,1092,
 1269,856,1679,1367,1252,1046,1019,1159,1772,1556,2241,2421,
 2990,2750,2862,2325,5385,2398,2975,2764,2809,2367,3472,4718,
 1549,1579,1653,1410,1740,1648,1481,1628,1462,1387,1714,1624,
 1576,1584,1580,1382,1702,1682,3117,2593,4262,3006,2778,2482,
 3659,2811,3245,2704,4828,3399,3147,2480,4658,2963,3100,2623,
 3915,2748,3267,2668,4661,3569,5037,6064,5680,9405,9377,7283,
 6814,3791,4872,3800,3581,3773,2996,3027,3465,5578,3769,3394,
 4156,3994,3719,4104,5108,3099,3091,3379,4231,3749,5605,4847,
 5065,5214,4332,5822,9176,9350,7466,6112,8326,8068],
 [35,34,25,50,61,97,82,79,94,105,69,85,88,89,66,104,108,
 74,107,63,84,103,56,78,96,60,87,90,91,70,93,80,99,98,
 372,492,443,424,423,484,385,356,304,322,359,350,293,212,
 437,435,434,254,319,295,308,358,299,357,335,588,578,592,
 594,637,622,574,583,580,589,612,579,626,607,571,586,599,
 603,601,595,623,613,566,576,1442,1800,1350,1759,1372,1767],
 [35,34,25,58,51,67,50,61,97,82,100,79,94,105,69,85,92,88,
 89,66,59,95,77,53,71,104,83,64,108,74,102,73,107,63,84,
 103,56,72,54,78,96,60,75,65,87,90,91,70,106,93,80,99,
 98,62,49,68,52],
 [35,34,25,58,51,67,61,97,82,79,85,59,95,71,104,83,64,74,
 107,103,56,72,54,96,60,75,87,70,106,99,62,49,52,340,
 316,370,402,345,362,411,249,208,300,222,272,292,277,287,
 223,231,226,228,451,500,397,537,441,540,447,413,505,448,
 452,514,417,548,470,692,739,722,778,1347,672,724,715,795,
 1308,978,1391,1143,958,1219,948,1294,850,1332,936,1299,
 1087,910,1217,952,1269,856,1284,860,1941,1692,1653,1410,
 1578,1583,1513,1626,1462,1387,1783,1632,1745,1561,1675,1580,
 1382,1587,1497,1551,1812,1845,1826],
 [35,34,25,58,51,67,61,97,82,100,79,85,59,71,104,83,64,74,
 103,56,72,54,96,60,75,65,87,70,99,62,49,52,340,316,370,
 402,345,362,411,249,300,222,240,272,247,248,264,292,287,
 223,231,226,281,228,500,397,530,537,441,518,453,508,540,
 447,505,448,514,417,552,548,470,722,809,778,1347,715,868,
 795,1308,985,978,1262,1219,948,1280,1294,850,1356,1332,936,
 1169,1217,952,1360,1269,856,1275,1284,860,1653,1410,1583,
 1513,1462,1387,1745,1561,1580,1382,1497,1551,1812,1845,1826]
  ,[35,34,25,58,51,67,61,97,82,100,79,85,92,59,95,71,104,
 83,64,74,107,103,56,72,54,96,60,75,65,87,70,106,99,52,
 340,316,370,402,345,362,411,249,300,222,272,247,248,292,
 382,404,287,223,231,226,228,500,397,537,441,518,453,540,
 447,505,448,514,417,548,470,722,778,1347,1603,1786,715,
 795,1308,1524,1771,985,978,1219,948,1294,850,1332,936,1217,
 952,1269,856,1284,860,1653,1410,1583,1513,1462,1387,1745,
 1561,1580,1382,1497,1551,1812,1845,1826],
 [35,34,25,58,51,67,61,97,82,100,105,69,88,59,95,71,104,
 83,64,102,73,84,103,56,72,54,96,60,75,65,87,98,62,49,
 52,340,316,345,362,411,377,249,193,259,240,227,264,221,
 288,276,200,217,207,250,281,220,301,209,500,397,537,441,
 518,453,531,509,489,412,540,447,505,448,504,483,514,417,
 548,470,502,454,497,468,818,1436,831,1450,934,1315],
 [35,34,25,58,51,67,61,97,82,100,105,69,88,59,95,71,104,
 102,73,84,103,56,72,54,96,60,75,87,98,62,49,52,340,316,
 345,362,411,377,249,193,259,229,244,227,264,221,288,276,
 200,217,260,214,250,281,220,301,209,451,500,397,537,441,
 416,518,453,531,509,450,489,412,540,447,413,505,448,504,
 483,452,514,417,548,470,396,502,454,497,468,818,1436,831,
 1450,934,1315],
 [35,34,25,58,51,67,61,97,82,105,69,92,88,59,71,104,83,64,
 84,103,56,72,54,96,60,75,65,87,98,62,49,52,340,316,345,
 362,411,377,249,208,193,259,227,247,248,264,221,276,277,
 200,217,250,231,226,281,220,209,500,397,530,537,441,518,
 453,564,531,509,489,412,508,540,447,505,448,534,504,483,
 514,417,552,548,470,502,454,486,497,468,818,1436,831,1450,
 934,1315],
 [35,34,25,61,97,82,79,94,105,69,85,88,89,66,77,53,104,74,
 107,63,84,103,56,96,60,87,90,91,70,93,80,99,98,372,492,
 443,424,423,484,385,356,324,304,350,293,318,212,435,434,
 406,254,308,358,323,299,335,588,578,592,594,606,637,622,
 574,583,609,580,589,612,579,618,626,607,571,586,620,599,
 603,601,595,600,623,613,566,576,615,1442,1800,1350,1759,
 1372,1767],
 [35,34,25,61,97,82,79,94,105,69,85,88,89,66,104,108,74,
 107,84,103,56,78,96,60,87,70,93,80,99,98,68,372,492,
 443,424,484,385,356,304,322,359,350,293,212,270,206,435,
 434,254,319,295,308,358,299,273,239,335,588,578,575,592,
 594,637,622,596,574,583,580,589,585,560,612,579,626,607,
 582,571,586,599,603,584,601,595,623,613,593,569,566,576,
 1442,1800,1350,1759,1372,1767],
 [35,34,25,61,97,82,79,105,69,85,88,104,74,107,63,84,103,
 56,96,60,87,90,91,70,99,98,68,372,492,443,424,423,385,
 356,234,307,291,304,322,359,350,280,293,212,435,434,406,
 253,254,319,295,308,262,358,299,335,588,578,592,594,637,
 622,574,583,580,589,612,579,626,607,571,586,599,603,601,
 595,623,613,566,576,1768,925,859,1635,1781,822,883,1708,
 1442,1800,1350,1759,1372,1767,1219,948,1294,850,1332,936,
 1217,952,1269,856,1284,860,1692,1578,1626,1632,1675,1587,
 3349,2999,3164,3302,2793,3251],
 [35,34,25,61,97,82,79,105,69,85,88,104,74,107,84,103,56,
 96,60,87,70,99,98,372,492,443,424,385,356,234,304,322,
 359,350,293,212,437,435,434,253,254,319,295,308,358,299,
 273,239,335,588,578,500,397,592,594,606,637,622,547,574,
 583,580,589,612,579,626,607,538,571,586,599,603,601,595,
 623,613,569,539,566,576,794,866,1505,776,812,723,1379,
 1442,1800,1350,1759,1372,1767,1539,1139,1219,948,1354,1534,
 1294,850,1595,1332,936,1532,1217,952,1322,1649,1269,856,
 1592,1261,1369,1284,860,2247,1988,1692,1653,1410,3881,1578,
 1626,1462,1387,3771,1632,1675,1580,1382,3913,1587,3493,3477,
 3265,3115,2937,3375,3684,3835,4068,3184,3386,3783,3487,4081,
 5897,5122],
 [35,34,25,67,61,97,82,105,69,88,59,71,104,102,73,84,103,
 56,54,96,60,75,65,87,98,62,49,52,316,345,362,411,377,
 249,342,334,208,193,259,351,229,244,227,264,221,276,277,
 200,217,207,328,260,214,250,281,220,301,209,575,500,397,
 537,441,518,453,531,509,489,412,540,447,505,448,504,483,
 514,417,548,470,502,454,497,468,700,942,1333,862,705,884,
 1265,939,818,1436,831,1450,934,1315,1555,1059,1542,1454,
 1511,1092,1526,1348],
 [36,28,23,58,51,50,61,97,82,100,94,105,69,76,55,108,101,
 102,73,63,84,72,96,60,65,90,91,86,106,99,81,68,252,339,
 369,365,395,367,373,387,240,307,291,351,350,302,310,386,
 207,267,238,321,330,323,537,441,592,594,614,531,509,612,
 579,608,504,483,548,470,601,595,621,925,1063,893,1670,822,
 1289,947,1500,1174,1013,1764,1577,2108,1588,1326,2503,1836,
 1546,2740,1716,1591,2054,1679,1367,2703,1772,1556,2612,1777,
 1838,1851,1823,1742,1779,1953,1904,1736,1775,1877,1839,2157,
 2178,2199],
 [36,28,23,58,51,50,61,97,82,100,94,105,69,89,66,95,55,
 108,74,101,102,73,103,56,78,96,60,65,90,91,86,106,57,
 252,339,369,367,373,387,380,240,298,215,261,309,203,437,
 435,207,213,245,228,348,187,357,335,537,441,570,592,594,
 531,509,543,574,583,540,447,561,612,579,504,483,557,571,
 586,548,470,559,601,595,497,468,553,566,576,904,970,929,
 916,1118,909],
 [36,28,23,58,51,50,61,97,82,100,94,105,69,92,71,55,108,
 74,101,102,73,63,72,96,60,65,90,91,86,106,99,81,68,252,
 339,369,365,395,367,373,387,307,291,298,351,261,302,310,
 435,386,267,238,213,228,321,330,323,537,441,592,594,531,
 509,612,579,504,483,548,470,601,595,925,1063,1975,1670,
 822,1289,2044,1500,1174,1013,1764,1577,1588,1326,1836,1546,
 1716,1591,1679,1367,1772,1556,1777,1838,1851,1823,1742,1779,
 1953,1904,1736,1775,1877,1839,2157,2178,2199],
 [36,28,23,58,51,50,61,97,82,100,94,105,69,92,76,55,108,
 74,101,102,73,63,84,72,65,90,91,86,106,81,68,52,252,
 339,369,365,395,367,373,387,307,291,351,302,310,386,267,
 238,321,330,323,349,305,537,441,570,592,594,531,509,543,
 612,579,504,483,557,548,470,559,601,595,925,1272,1334,
 1063,1670,822,1053,1198,1289,1500,1174,1013,1764,1577,1588,
 1326,1836,1546,1716,1591,1679,1367,1772,1556,1777,1838,2283,
 1851,1823,2009,1742,1779,2205,1953,1904,2180,1736,1775,1961,
 1877,1839,1970,2157,2178,2199],
 [36,28,23,58,51,50,61,97,82,100,94,105,69,95,71,55,108,
 74,101,102,73,84,103,56,78,96,60,65,90,91,86,106,52,57,
 252,339,369,367,373,387,380,240,307,291,298,215,309,276,
 203,437,207,267,238,213,245,348,209,187,357,537,441,592,
 594,531,509,574,583,540,447,612,579,504,483,571,586,548,
 470,601,595,497,468,566,576,904,970,929,916,1118,909],
 [36,28,23,58,51,50,61,97,82,100,94,105,69,95,71,55,108,
 101,102,73,84,103,56,78,65,90,91,86,106,99,57,252,339,
 369,367,387,380,240,307,291,298,215,309,329,255,203,437,
 207,267,238,213,245,348,349,305,187,357,537,441,592,594,
 614,531,509,574,583,602,619,540,447,612,579,608,504,483,
 571,586,590,548,470,601,595,621,605,497,468,566,576,577,
 904,970,929,916,1118,909],
 [36,28,23,58,51,50,97,82,94,92,76,55,101,102,73,63,72,65,
 106,81,68,252,365,367,373,208,300,222,351,280,261,302,
 310,270,206,216,435,386,277,262,321,330,323,273,239,258,
 565,467,501,592,594,469,531,509,572,479,612,579,608,449,
 573,510,548,470,601,595,442,696,925,880,974,1063,845,1975,
 1670,822,940,1021,1289,941,1500,1174,1403,1426,1228,1667,
 1764,1577,1399,1446,1190,1173,1457,1588,1326,1171,1290,1538,
 1836,1546,1512,1443,1716,1591,1456,1406,1274,1209,1396,1570,
 1679,1367,1261,1369,1772,1556,2603,4611,2655,4688,1885,1821,
 1777,1838,2017,1910,2471,1851,1823,1787,1750,1742,1779,2163,
 1899,1953,1904,1858,1810,1736,1775,1938,1848,1877,1839,4003,
 2519,5099,3706,3778,3993,2700,5688,3366,4175,7457,2157,7395,
 2178,7118,2199,2998,2662,3488,3518,3270,2731,4297,3737,2771,
 2622,3304,3431,3601,2742,4378,3888,3095,2772,3552,3307,3134,
 2859,3805,3919,3880,5843,4067,5940,4121,5919,5685,8170,5639,
 5880,4995,7492,5255,7607,5276,6029,6053,6081],
 [36,28,23,58,51,50,97,82,94,92,76,95,55,101,63,103,56,72,
 78,65,106,81,68,57,282,541,352,346,476,433,472,356,229,
 244,280,247,248,293,277,269,260,214,231,226,358,258,467,
 554,458,518,453,574,583,479,507,426,487,571,586,510,514,
 417,529,456,566,576,924,726,887,716,750,733,1015,914,702,
 874,745,769,760,1129,1260,1047,1157,1287,1035,1338,1196,
 1399,1446,1020,993,1829,1294,850,1187,988,1366,1136,1017,
 1100,1217,952,1264,1166,1456,1406,1842,1252,1046,1019,1159,
 1284,860,2241,2398,1549,1579,1740,1648,1782,1586,1583,1513,
 1481,1628,1714,1624,1485,1745,1561,1576,1584,1944,1132,1702,
 1682,1543,1497,1551,3117,2593,2778,2482,3723,3245,2704,3147,
 2480,3100,2623,3598,3267,2668,2240,2297,2286,3791,3773,4647,
 5859,3465,4156,4498,4104,3439,3379,6047,4608,4917,4380],
 [36,28,23,58,51,50,97,82,100,94,92,76,55,108,74,101,102,
 73,63,72,96,60,65,86,106,99,81,68,252,339,365,395,367,
 373,387,315,300,222,307,291,351,350,302,310,435,386,383,
 287,223,321,330,323,335,501,537,441,592,594,531,509,612,
 579,487,548,470,601,595,722,925,859,1635,1063,1670,822,
 883,1708,1289,947,1500,1174,1143,958,1764,1577,1216,937,
 1294,850,1588,1326,1836,1546,1716,1591,1254,1009,1269,856,
 1679,1367,1772,1556,2984,2862,2915,2809,1777,1838,1586,1851,
 1823,1742,1779,1953,1904,1735,1736,1775,1877,1839,3296,2763,
 3422,3287,2781,3285,3181,2157,2178,2199,3800,3581,2996,3027,
 3769,3394,3994,3719,3099,3091,4231,3749,6540,7024,9158,7153,
 8187,6854,8323,8065],
 [36,28,23,58,51,50,97,82,100,94,95,55,108,74,101,102,73,
 103,56,78,96,60,65,86,106,99,57,252,339,369,367,373,380,
 315,300,222,240,307,291,298,350,215,309,203,437,435,383,
 207,267,238,213,308,245,348,187,357,537,441,592,594,531,
 509,574,583,540,447,612,579,504,483,571,586,548,470,601,
 595,497,468,566,576,722,880,974,1975,715,940,1021,2044,
 904,970,929,916,1118,909,1143,958,1216,937,1231,1018,1087,
 910,1254,1009,1168,886,1874,1820,1901,1739,1900,1814,3296,
 2763,3249,3442,2781,3108],
 [36,28,23,58,51,50,97,82,100,94,95,55,108,101,102,73,103,
 56,78,65,86,106,57,252,339,369,367,380,300,222,240,298,
 215,309,270,206,203,437,435,287,223,207,213,245,228,348,
 187,357,335,565,500,397,537,441,592,594,614,531,509,574,
 583,479,540,447,612,579,608,504,483,571,586,548,470,601,
 595,621,497,468,566,576,696,722,919,704,684,715,872,698,
 904,970,929,916,1118,909,1305,1114,1667,1190,1173,1671,
 1171,1290,1089,1377,1257,1538,1182,1034,1738,1274,1209,1570,
 1103,1204,1170,1602,2094,1733,1653,1410,2253,2042,1825,1462,
 1387,2290,2036,1841,1580,1382,2122,3052,2519,3900,3348,3236,
 2935,2700,3486,3065,3291,4686,4264,4887,3979,4956,4149],
 [36,28,23,58,51,50,100,92,76,95,55,108,102,73,63,103,56,
 72,78,65,86,81,68,57,282,422,541,346,476,371,472,356,
 279,186,234,272,229,244,293,288,434,294,202,269,260,214,
 246,467,490,430,500,397,554,458,513,574,583,489,412,507,
 426,487,571,586,563,478,514,417,499,566,576,761,887,716,
 879,762,900,747,874,745,890,806,791,838,905,1102,1954,
 1143,958,1020,993,1216,937,1294,850,1887,1231,1018,1017,
 1100,1087,910,1217,952,885,1038,1842,1254,1009,1168,886,
 1284,860,2086,2161,2148,1678,1460,2074,1627,1728,1412,1734,
 1447,2038,1529,1641,1411,2366,1644,1441,1802,1414,4475,4740,
 4730,4330,4334,4253,2181,2142,2231,2571,2755,3009,2820,2899,
 3334,2783,3264,2520,2697,3013,2751,2803,3209,2863,3161,5804,
 5627,7430,5263,5852,7174,5869,5350,8501,6703,6595,8572,8111,
 7226,6736],
 [36,28,23,58,51,50,100,92,88,76,95,77,53,55,108,102,73,
 107,63,103,56,72,78,65,87,86,93,80,81,62,49,68,57,282,
 422,541,352,346,476,371,472,356,279,186,234,288,434,294,
 202,260,214,246,467,490,430,500,397,489,412,449,507,426,
 510,563,478,514,417,935,720,761,879,900,843,710,747,890,
 806,838,1158,1305,1114,1143,958,1216,937,1231,1018,1249,
 1182,1034,1087,910,1254,1009,1168,886,1733,1874,1678,1460,
 1820,1728,1412,1901,1734,1447,1905,1739,1641,1411,1900,1644,
 1441,1814,1802,1414,2181,2142,2231],
 [36,28,23,58,51,67,50,61,97,82,100,79,94,105,69,92,88,89,
 66,76,95,77,53,71,55,83,64,108,74,101,102,73,107,63,84,
 103,56,72,54,78,96,60,65,87,90,91,86,106,93,80,99,81,
 62,49,68,52,57],
 [36,28,23,58,51,67,50,97,82,79,94,92,76,95,77,53,55,101,
 107,63,103,56,72,54,78,65,106,81,62,49,68,57,282,541,
 352,346,476,433,371,472,229,244,280,247,248,251,201,277,
 231,226,258,235,192,554,458,513,518,453,506,489,412,507,
 426,517,514,417,529,456,499,502,454,924,726,714,803,733,
 1015,702,721,820,760,842,1047,1287,1035,1338,1196,1187,988,
 1366,1136,1264,1166,1252,1046,1495,1549,1579,1585,1740,1648,
 1743,1481,1628,1469,1714,1624,1594,1576,1584,1666,1702,1682,
 2240,2297,2286],
 [36,28,23,58,51,67,50,97,82,94,92,88,76,95,77,53,55,83,
 64,101,63,103,56,72,54,78,65,87,81,62,49,68,57,282,541,
 352,346,476,433,371,472,280,247,248,264,288,251,201,277,
 200,231,226,281,258,301,235,192,554,458,518,453,489,412,
 507,426,514,417,529,456,502,454,924,788,726,733,1015,963,
 702,760,842,1047,1287,1035,1338,1196,1187,988,1366,1136,
 1264,1166,1252,1046,1549,1579,1740,1648,1481,1628,1714,1624,
 1576,1584,1702,1682,2240,2297,2286],
 [36,28,23,58,51,67,50,97,82,94,92,88,76,95,77,53,55,83,
 64,101,107,63,103,56,72,78,65,106,62,49,68,57,282,541,
 352,346,476,433,371,472,280,247,248,251,201,203,277,231,
 226,306,258,235,192,187,469,554,458,518,453,489,412,449,
 507,426,514,417,442,529,456,502,454,924,878,726,733,1015,
 861,702,760,842,1047,857,1287,1035,867,1338,1196,945,1187,
 988,926,1366,1136,848,1264,1166,949,1252,1046,1549,1579,
 1740,1648,1481,1628,1714,1624,1576,1584,1702,1682,2240,2297,
 2286],
 [36,28,23,58,51,67,50,100,79,92,88,76,95,77,53,55,108,
 102,73,107,63,103,56,72,54,78,65,87,86,81,62,49,68,57,
 282,422,541,352,346,476,371,472,279,186,234,229,244,288,
 251,201,294,202,260,214,246,490,430,500,397,554,458,489,
 412,507,426,563,478,514,417,761,879,900,921,957,747,890,
 806,875,792,791,838,1143,958,1216,937,1231,1018,1087,910,
 1254,1009,1168,886,1678,1460,1728,1412,1734,1447,1641,1411,
 1644,1441,1802,1414,2181,2142,2231],
 [36,28,23,58,51,67,50,100,92,76,95,77,53,55,102,73,107,
 63,103,56,72,54,78,65,86,93,80,81,62,49,68,57,282,422,
 541,352,346,476,371,472,279,186,193,234,229,244,280,288,
 294,202,260,214,262,246,490,430,501,500,397,554,458,506,
 489,412,507,426,563,478,517,514,417,761,742,879,900,747,
 718,890,806,791,838,1263,1143,958,1457,1216,937,1530,1231,
 1018,1186,1087,910,1396,1254,1009,1393,1168,886,1678,1460,
 1728,1412,1734,1447,1641,1411,1644,1441,1802,1414,2181,2142,
 2231],
 [36,28,58,51,50,97,82,94,92,76,95,55,104,83,64,101,63,
 103,56,72,54,78,65,106,81,98,68,57,282,541,352,346,476,
 433,472,356,193,272,322,359,280,247,248,251,201,277,200,
 269,319,295,231,226,258,235,192,314,325,554,458,518,453,
 489,412,507,426,514,417,529,456,502,454,553,924,878,726,
 915,922,750,733,697,1015,861,702,769,760,664,842,1047,
 1287,1035,1338,1196,1506,1829,1187,988,1887,1366,1136,1264,
 1166,1842,1252,1046,1864,2096,2071,1946,2175,1549,1579,1740,
 1648,1481,1628,1714,1624,1576,1584,1702,1682,3153,2958,2240,
 2297,2286,3791,3773,3465,4156,4104,3379],
 [36,42,23,21,51,100,94,69,95,108,101,102,73,107,63,103,56,
 54,78,60,106,282,481,521,346,433,491,342,356,324,279,186,
 193,309,270,216,221,251,201,203,388,434,406,294,202,200,
 267,213,254,319,295,311,273,258,220,235,192,187,357,343,
 490,451,574,602,533,450,561,507,413,571,590,573,529,396,
 553,566,577,663,630,793,796,784,804,772,1291,685,701,636,
 816,871,765,810,751,1346,699,954,842,1056,1228,1197,1145,
 1131,1239,1221,1105,1127,1240,1083,1243,1193,1128,1437,1358,
 1368,1467,1402,1432,1307,1397,1408,1430,1336,1389,2013,1971,
 1962],
 [36,42,23,21,58,51,67,50,97,82,79,94,69,89,76,59,77,53,
 55,102,73,107,63,103,56,72,54,106,282,481,422,352,521,
 346,208,351,280,230,318,255,270,216,221,251,201,203,437,
 386,277,328,262,246,323,305,273,258,220,235,192,187,357,
 343,490,451,592,614,554,416,574,602,533,450,412,612,608,
 507,413,571,590,563,452,601,621,529,396,454,566,577,791,
 1129,838,1260,846,1157],
 [37,13,67,61,82,88,89,66,59,95,53,71,104,64,102,63,84,56,
 75,87,90,91,70,80,98,62,49,52,394,360,429,363,419,327,
 236,342,324,300,240,248,264,309,329,243,288,388,436,406,
 277,287,217,207,260,250,226,348,349,290,301,209,482,467,
 531,522,545,479,528,449,504,512,462,555,442,497,463,2045,
 924,644,668,707,1963,1015,665,843,853,671,717,971,827,905,
 907,1020,981,969,1119,1017,946,1067,885,931,1019,1060,2271,
 2291,2137,2088,1386,1503,1677,1627,1501,1572,1637,1529,1464,
 1598,1746,1631,3332,3250,1919,1920,1914],
 [37,19,40,13,51,67,61,105,92,88,66,71,83,64,74,73,84,56,
 72,87,91,62,49,52,394,360,332,363,419,236,342,324,186,
 208,307,304,320,247,264,215,329,212,243,270,221,292,388,
 406,202,277,217,231,245,349,290,273,220,209,278,482,467,
 458,531,522,545,479,485,528,449,504,512,555,442,516,497,
 463,644,668,859,1192,759,707,665,671,883,1344,817,717,628,
 971,827,905,907,1020,981,988,969,1119,1017,946,885,931,
 1046,1019,1060,2285,2159,1386,1503,1677,1627,1501,1572,1637,
 1529,1464,1598,1746,1631,1919,1920,1914],
 [37,27,13,25,61,85,88,89,76,59,77,53,71,55,104,64,84,75,
 87,91,99,372,443,475,347,423,385,342,356,324,279,186,193,
 247,264,215,302,310,293,270,216,221,251,201,203,388,434,
 406,294,202,200,238,273,258,220,235,192,187,278,325,578,
 490,451,564,574,602,533,450,607,507,413,571,590,529,396,
 566,577,896,1107,922,746,707,712,695,808,762,889,1075,980,
 763,717,723,753,799,785,1266,1286,1056,1228,1145,1131,1175,
 1239,1221,1105,1127,1083,1243,1300,1193,1128,1437,1358,1368,
 1467,1402,1432,1307,1397,1408,1430,1336,1389,2337,2344,2378]
  ,[37,27,35,40,13,25,58,50,61,85,89,66,59,95,77,71,55,
 104,107,84,96,75,65,87,90,70,99,98,62,49,52,334,279,
 186,208,193,229,227,247,248,215,302,310,309,293,206,288,
 260,214,250,231,226,245,348,301,235,187,1378,815,700,870,
 887,737,862,750,1084,754,670,742,880,809,778,695,808,762,
 874,755,939,769,1101,741,669,718,795,753,799,785,698,1950,
 1916,3663,2572,1913,2130,1991,2705,2363,1923,3473,2714,1925,
 2018,2680,2562,3128,3359,3597,3514],
 [37,27,35,40,13,25,58,51,50,61,89,66,59,95,77,71,55,104,
 83,74,84,56,72,96,75,65,87,90,70,106,99,98,62,49,52,
 356,279,186,208,193,247,248,264,215,302,293,206,251,203,
 269,214,231,226,281,245,321,358,235,187,815,644,700,870,
 750,1084,754,670,742,880,703,809,704,769,1101,741,669,718,
 940,725,868,698,1950,2572,2029,1913,2130,1991,2714,1895,
 1925,2018,2289,3128,3597],
 [37,27,35,40,13,25,58,51,50,61,97,79,85,89,59,95,77,71,
 55,104,83,74,73,107,84,56,75,87,90,70,106,99,98,62,49,
 52,356,186,208,300,240,291,247,215,302,309,293,329,243,
 206,251,203,434,231,245,321,358,235,187,870,720,754,670,
 880,809,778,1635,803,685,864,901,704,741,669,940,868,1708,
 699,829,897,698,2130,1991,3034,2394,2018,2289,2912,2383],
 [37,27,35,40,13,25,58,51,50,61,97,79,89,66,59,95,77,71,
 55,104,83,74,107,84,56,72,96,75,65,87,90,70,106,99,98,
 62,49,52,356,186,208,300,259,240,247,248,215,302,293,206,
 251,203,269,214,231,226,245,321,358,235,187,870,720,750,
 754,670,880,703,809,704,769,741,669,940,725,868,698,2130,
 1991,2018,2289],
 [37,27,35,40,13,25,58,51,67,50,61,97,82,100,79,105,85,92,
 88,89,66,59,95,77,71,55,104,83,64,74,102,73,107,63,84,
 103,56,72,54,96,75,65,87,90,91,70,106,93,99,81,98,62,
 49,52],
 [37,27,35,40,13,25,58,67,50,61,82,85,88,89,66,59,95,77,
 71,55,104,64,107,84,103,56,54,96,75,65,87,90,91,70,93,
 99,81,98,62,49,52,334,279,208,193,300,240,229,227,247,
 248,215,309,288,294,200,287,207,260,250,231,226,245,348,
 301,862,670,939,669],
 [37,27,35,40,13,25,58,67,50,61,85,88,89,59,77,71,55,104,
 64,102,107,63,84,75,87,91,99,471,372,443,475,347,424,
 423,385,279,186,193,302,310,293,270,221,251,203,294,202,
 200,238,273,220,235,187,278,325,490,451,574,602,533,450,
 507,413,571,590,529,396,566,577,896,1107,922,695,808,762,
 889,1075,980,753,799,785,1266,1286,1056,1228,1145,1131,
 1239,1221,1105,1127,1083,1243,1193,1128,1437,1358,1368,1467,
 1402,1432,1307,1397,1408,1430,1336,1389,2337,2344,2378],
 [37,27,35,40,13,25,67,61,88,89,59,77,71,55,64,102,107,63,
 84,103,54,87,91,99,98,372,475,424,423,385,342,324,279,
 193,320,310,212,270,221,251,203,388,406,294,202,200,217,
 238,303,235,187,325,578,490,451,558,574,602,533,450,607,
 507,413,534,571,590,546,566,577,1160,644,896,922,808,635,
 1238,665,889,980,799,628,872,961,1266,1188,1056,1228,1145,
 1131,1239,1221,1383,1105,1127,1083,1243,1193,1128,1204,1448,
 1990,2407,2139,2441,1437,1358,1368,1467,1402,1432,1307,1397,
 1408,1430,1336,1389,1986,2549,3732,2409,3650,2337,2344,2378,
 4101,4450],
 [37,27,35,40,25,58,50,61,82,85,89,59,77,71,55,104,102,63,
 84,75,87,91,99,98,68,471,372,443,475,347,423,385,356,
 279,193,272,244,280,264,302,310,293,270,221,251,203,434,
 294,200,238,214,262,273,220,235,187,325,490,451,564,574,
 602,533,450,507,413,571,590,529,396,566,577,896,922,778,
 707,695,808,762,889,980,717,753,799,785,1266,1286,1056,
 1228,1145,1131,1175,1239,1221,1105,1127,1083,1243,1300,1193,
 1128,3034,2912,1437,1358,1368,1467,1402,1432,1307,1397,1408,
 1430,1336,1389,2337,2344,2378],
 [37,27,41,35,40,34,58,67,61,82,79,105,85,88,66,59,77,71,
 104,64,74,102,107,84,56,54,96,75,87,91,70,93,99,98,49,
 52,471,340,289,372,492,443,432,370,360,475,402,336,347,
 520,424,355,362,363,542,411,409,423,484,385,283,249,236],
 [37,27,41,40,25,58,67,50,97,88,76,59,77,71,55,104,107,63,
 103,56,87,86,70,98,49,68,52,471,443,432,475,385,283,315,
 186,300,244,280,227,247,261,329,206,251,383,202,287,214,
 262,250,231,228,235,209,187,551,467,515,451,558,469,461,
 416,564,560,479,524,450,562,449,488,413,546,510,494,452,
 552,498,396,668,737,864,671,755,829,698,1211,1558,1270,
 1266,1286,1426,1446,1290,1443,1406,1348,1103,1916,1923,2186,
 2611,2542,2554,2648,3065,6006,4779,5426,5994],
 [37,40,13,51,67,61,82,100,105,92,88,89,66,59,95,71,104,
 83,64,74,102,73,63,84,56,75,87,90,70,98,62,49,52,394,
 360,429,332,363,419,327,236,342,324,264,309,329,243,206,
 388,406,217,348,349,290,239,301,209,482,467,531,522,545,
 479,528,449,504,512,555,442,497,463,644,942,668,707,665,
 884,671,717,971,827,905,907,1020,981,969,1119,1017,946,
 885,931,1019,1060,1386,1503,1677,1627,1501,1572,1637,1529,
 1464,1598,1746,1631,1919,1920,1914],
 [37,40,13,51,67,61,82,105,92,88,89,66,59,71,104,83,64,74,
 102,63,84,56,75,90,91,70,98,62,49,52,394,360,429,332,
 363,327,236,342,324,248,264,329,243,266,388,406,217,349,
 290,306,209,482,551,467,564,531,522,545,560,479,466,528,
 562,449,534,504,512,555,569,442,456,486,497,463,644,668,
 847,707,665,671,882,717,971,827,1188,905,907,1296,1020,
 981,1175,969,1119,1383,1017,946,1189,885,931,1300,1019,
 1060,1386,2532,1503,1677,2500,1627,1501,2941,1572,1637,2341,
 1529,1464,2735,1598,1746,2570,1631,1919,1920,1914],
 [37,40,13,58,50,61,82,85,88,89,76,59,77,71,55,104,64,101,
 102,107,63,84,103,54,60,75,87,91,86,93,99,81,98,471,
 372,443,475,347,424,423,385,356,279,193,222,310,270,221,
 434,294,200,223,238,273,220,325,343,490,451,574,602,533,
 450,507,413,571,590,529,396,566,577,896,922,1291,808,889,
 980,1346,799,1266,1286,1056,1228,1145,1131,1239,1221,1105,
 1127,1083,1243,1193,1128,1437,1358,1368,1467,1402,1432,1307,
 1397,1408,1430,1336,1389,2337,2344,2378],
 [37,40,13,58,50,61,82,85,89,66,59,95,104,64,102,107,63,
 56,96,65,87,90,91,70,99,62,49,52,394,360,429,332,419,
 236,334,356,208,300,240,272,350,229,227,248,261,309,212,
 288,292,436,434,277,287,207,269,308,226,228,348,299,278,
 482,467,496,537,536,567,469,531,522,545,479,540,473,528,
 449,525,504,512,550,510,548,523,555,442,497,463,714,727,
 900,721,736,806,758,1478,740,1471,841,1472],
 [37,40,13,58,50,61,82,85,89,66,59,104,83,64,74,102,73,
 107,63,56,96,65,87,90,91,70,99,62,49,52,394,360,429,
 332,419,236,334,356,300,240,272,350,261,212,292,436,434,
 287,207,269,308,228,299,278,482,551,467,496,530,537,536,
 567,558,469,564,531,522,545,560,479,508,540,473,528,562,
 449,525,534,504,512,550,546,510,552,548,523,555,569,442,
 486,497,463,758,1478,740,1471,841,1472],
 [37,40,13,58,50,82,85,89,66,59,104,102,73,63,56,90,91,70,
 99,394,443,360,332,424,419,385,334,208,350,264,309,434,
 277,281,348,299,306,565,490,451,567,469,554,416,574,602,
 572,612,608,528,449,507,413,573,563,452,601,621,555,442,
 566,577,1378,870,878,1107,778,893,1347,914,918,1075,795,
 1308,971,758,3836,740,998,841,3814,1229,857,905,907,995,
 1020,981,1104,1294,1304,1326,1206,945,1332,1095,1546,1017,
 946,1071,1070,848,885,931,1061,1269,1214,1367,1284,1080,
 1556,2257,2550,1930,2123,1998,2172,1979,1210,1678,1692,1837,
 1996,1283,1728,1578,1727,1902,2262,1734,1626,1606,1831,2062,
 1226,1641,1632,2298,2055,1176,1644,1675,1611,1715,2176,1802,
 1587,1712,3541,3296,3053,2763,3022,3249,3213,3442,3109,2781,
 2670,3108,4833,8388,4863,7664,4551,6177,5260,9085,8163,7409,
 8976,5031,4383,7210,7580,8029,7743,5285,4083,2808,4563,2755,
 2749,4267,3030,2599,4022,2899,2695,5226,2909,2812,4865,2783,
 2661,5492,3368,2513,3960,2697,2861,4646,3110,2796,4876,2803,
 2635,5456,2869,2590,4191,2863,2614,5662,7811,8845,9431,8310,
 9400,9375,7455,8527,7856,7846,7291,7281,7549,7904,7164,7879,
 7183,6810,9126,8030,8958,8225,6674,7641,8687,8321,9054,5715,
 8592,8031,5866,8256,8020,6378,5215,5581,8693,6002,6090,6579]
  ,[37,40,13,58,51,50,61,82,100,105,85,92,89,66,59,95,
 104,83,64,74,102,73,107,63,56,72,87,90,91,70,106,99,49,
 394,375,360,429,332,419,356,272,350,261,329,212,243,292,
 382,435,434,269,308,228,349,299,290,278,314,335,482,467,
 537,536,567,469,531,522,545,479,540,473,625,528,449,504,
 512,550,510,548,523,555,442,497,463,587,758,1478,740,1471,
 841,1472],
 [37,40,13,58,51,50,61,82,100,105,85,92,89,66,59,104,83,
 64,74,102,107,63,56,72,96,65,87,90,91,70,106,99,62,49,
 52,394,375,360,429,332,419,236,356,272,351,350,248,261,
 212,292,434,269,328,308,226,228,299,278,482,467,537,536,
 567,469,531,522,545,479,540,473,528,449,504,512,550,510,
 548,523,555,442,497,463,758,1478,740,1471,841,1472],
 [37,40,13,58,51,67,50,61,97,82,100,79,105,69,85,92,88,89,
 66,76,59,95,77,71,55,104,83,64,74,101,102,73,107,63,84,
 103,56,72,54,96,60,75,65,87,90,91,86,70,106,93,99,81,
 98,62,49,52,57],
 [37,40,13,58,67,50,61,82,85,88,89,59,77,71,55,104,64,102,
 107,63,84,75,87,91,86,99,98,57,471,372,443,475,347,424,
 423,385,279,193,222,298,230,302,310,293,255,270,221,251,
 203,294,200,223,238,246,273,220,235,187,325,490,451,574,
 602,533,450,507,413,571,590,529,396,566,577,896,922,912,
 695,808,762,807,889,980,753,799,785,787,1266,1286,1056,
 1228,1145,1131,1239,1221,1105,1127,1083,1243,1193,1128,2031,
 2177,1437,1358,1368,1467,1402,1432,1307,1397,1408,1430,1336,
 1389,2337,2344,2378],
 [37,40,13,58,67,50,82,85,88,89,59,77,71,55,104,64,102,
 107,63,84,103,54,75,87,91,86,93,99,81,98,471,443,475,
 347,424,423,385,315,279,193,310,270,221,383,294,200,238,
 213,273,220,325,551,490,430,451,574,602,598,533,466,450,
 562,507,426,413,571,590,581,529,456,396,566,577,587,896,
 630,922,808,889,636,980,799,1266,1286,1056,1228,1003,1145,
 1131,1134,1239,1221,1025,1105,1127,1074,1083,1243,1066,1193,
 1128,1051,1437,1210,1358,1368,1283,1467,1402,1195,1432,1307,
 1226,1397,1408,1176,1430,1336,1259,1389,2337,2344,2378],
 [37,40,13,67,61,82,69,85,88,89,76,59,77,71,55,104,64,101,
 102,107,63,84,103,54,75,87,91,86,99,98,57,372,443,475,
 347,424,423,385,342,324,279,193,310,255,270,221,251,203,
 388,406,294,200,238,273,220,235,187,325,578,490,451,574,
 602,533,450,607,507,413,571,590,529,396,566,577,896,922,
 808,807,889,980,799,787,1266,1286,1056,1228,1145,1131,1239,
 1221,1105,1127,1083,1243,1193,1128,1437,1358,1368,1467,1402,
 1432,1307,1397,1408,1430,1336,1389,2337,2344,2378],
 [37,40,13,67,61,82,88,89,66,59,71,104,64,102,63,84,56,75,
 87,90,91,70,98,49,394,360,429,363,419,327,236,342,334,
 324,229,227,264,288,388,406,217,260,250,301,209,482,467,
 530,493,531,522,574,602,508,528,449,504,512,571,590,462,
 552,613,497,463,566,577,644,668,862,707,665,671,717,971,
 1601,1287,899,905,907,1020,981,1245,1542,1190,1416,969,
 1119,1548,1366,1008,1017,946,1511,1182,1299,885,931,1116,
 1019,1060,1348,1204,1448,1930,1998,2276,1386,1503,1677,1627,
 1563,1820,1501,1572,1637,1529,1474,1739,1464,1598,1746,1631,
 1604,1814,3124,2540,3015,2611,2549,3732,3036,2598,4038,3196,
 2527,3199,2554,2409,3650,2972,2663,3918,1919,1920,1914,2518,
 4449,2571,2720,3221,2844,8781,2820,3528,3460,4407,3651,4844,
 2874,6713,2730,3453,3402,2561,4714,2520,2814,3167,3962,2538,
 3536,2689,7180,2751,3068,3561,2766,7328,2834,3435,3385,4588,
 3633,4778,3584,3496,3761,3540,3697,3870,3392,3531,3961,9024,
 3522,4272,6705,4420,5824,6625,4548,5749,7955,3458,4786,6229,
 4734,5335,6138,4584,5023,9153,8066,6357,8292,6175,7154],
 [37,40,13,67,61,82,100,88,89,66,59,95,71,104,83,64,74,
 102,73,63,84,56,72,87,90,91,70,106,98,62,49,52,394,360,
 429,332,363,419,327,236,342,334,324,264,329,212,243,388,
 436,406,287,217,207,349,299,290,209,482,467,531,522,545,
 479,528,449,504,512,555,442,497,463,815,644,700,668,707,
 895,665,705,671,717,971,827,905,907,1020,981,969,1119,
 1017,946,885,931,1019,1060,1386,1503,1677,1627,1501,1572,
 1637,1529,1464,1598,1746,1631,1919,1920,1914],
 [37,41,13,58,51,67,50,61,97,82,100,79,105,69,85,92,88,66,
 76,59,95,77,53,71,55,104,83,64,74,101,102,73,107,63,84,
 103,56,72,54,96,60,75,65,87,91,86,70,106,93,80,99,81,
 98,62,49,52,57],
 [37,41,13,58,51,67,50,61,105,85,66,59,95,77,71,104,102,
 73,107,63,84,56,72,54,96,75,106,93,99,98,62,49,52,289,
 375,360,336,332,392,313,363,409,327,338,354,236,186,208,
 193,229,244,227,206,221,202,277,200,260,214,250,239,220,
 430,451,501,458,416,513,466,450,506,426,413,487,478,452,
 517,456,396,499,1293,777,1276,975,1353,991],
 [37,41,13,58,51,67,50,61,105,88,66,59,95,77,71,104,83,
 102,73,107,63,84,56,72,54,96,87,93,99,98,62,49,52,289,
 375,389,407,360,336,332,392,313,363,327,338,354,236,186,
 208,193,244,227,206,221,288,202,277,200,214,250,239,220,
 301,430,515,451,458,461,416,466,524,450,426,488,413,478,
 494,452,456,498,396,834,811,968],
 [37,41,13,58,51,67,50,82,100,79,105,88,66,59,95,77,71,64,
 74,102,73,107,63,84,56,72,54,96,91,70,106,93,99,98,62,
 49,52,289,375,360,336,332,392,313,363,409,327,338,354,
 236,315,320,229,266,383,303,260,306,430,515,451,458,461,
 416,466,524,450,426,488,413,478,494,452,456,498,396,1293,
 777,1276,975,1353,991],
 [37,41,13,58,67,61,82,79,85,88,77,53,71,55,104,64,74,107,
 84,103,56,54,96,75,87,99,98,49,52,57,471,340,372,443,
 475,402,347,424,355,542,411,385,283,279,300,298,230,216,
 251,201,203,213,246,231,192,187,430,451,397,455,453,477,
 466,450,412,427,448,465,478,452,417,459,454,431,692,880,
 662,921,672,1101,940,645,875,851,1033,839,840,789,964,
 1114,1391,1173,1416,1257,1455,1034,1299,1209,1445,1170,1448,
 2355,2327],
 [37,41,13,58,67,61,97,85,88,66,76,59,77,53,71,55,104,64,
 74,101,107,84,96,75,87,91,86,70,80,99,81,98,49,52,57,
 471,340,443,432,475,402,347,424,542,411,423,385,283,300,
 247,302,251,287,231,321,235,464,467,430,451,526,469,458,
 416,511,479,466,450,474,449,426,413,519,510,478,452,535,
 442,456,396,1148,1211,1248,1270,1115,1329],
 [37,41,13,58,67,61,97,85,88,66,76,59,77,53,71,55,104,64,
 74,101,107,84,103,96,75,87,91,86,70,99,98,49,52,57,471,
 340,443,432,475,402,347,424,542,411,423,385,283,300,247,
 251,201,203,287,231,235,192,187,464,467,430,451,526,469,
 458,416,511,479,466,450,474,449,426,413,519,510,478,452,
 535,442,456,396,1148,1211,1248,1270,1115,1329],
 [37,41,13,58,67,61,97,85,88,66,76,59,77,53,71,55,104,102,
 107,84,103,56,54,75,87,93,80,99,81,98,49,52,57,471,340,
 372,443,432,475,402,347,424,355,423,385,283,186,193,244,
 227,230,206,216,221,202,200,214,250,246,239,258,220,490,
 430,451,554,458,416,533,466,450,507,426,413,563,478,452,
 529,456,396,1558,1660,1266,1818,1286,1605],
 [37,41,13,58,67,82,79,85,88,66,59,77,71,104,64,74,107,56,
 54,96,75,87,91,70,99,98,49,52,471,340,372,443,432,475,
 402,347,355,542,411,423,385,283,247,302,216,386,295,311,
 321,258,235,343,565,482,496,604,458,416,509,522,572,545,
 485,611,483,512,573,550,462,591,456,396,468,463,815,887,
 746,895,874,763,1483,1520,1537,1035,899,1338,1196,1016,
 1134,988,902,1366,1136,1008,1166,928,1252,1046,965,1051,
 2167,2828,2107,2652,1854,1373,1863,1380,1859,1417,3945,2482,
 3343,4205,3797,2480,3754,3896,3787,2668,3833,3649,4682,4381,
 3764],[37,41,13,58,67,82,100,79,105,85,88,95,77,71,83,
 64,74,102,73,107,63,84,56,72,54,96,75,106,93,99,98,62,
 49,52,289,375,389,407,336,332,392,313,363,409,338,354,
 236,334,324,315,320,266,436,406,383,303,306,430,451,397,
 455,458,416,453,477,466,450,412,427,426,413,448,465,478,
 452,417,459,456,396,454,431,837,1478,826,1471,891,1472],
 [37,41,13,58,67,105,85,88,66,59,77,71,64,74,102,107,84,
 96,75,91,70,93,99,98,49,52,289,389,407,360,336,332,392,
 313,409,327,338,354,236,334,324,320,229,309,288,436,406,
 383,348,306,301,464,551,467,526,469,458,416,574,511,560,
 479,607,582,474,449,426,413,519,546,510,613,593,535,442,
 456,396,566,1507,878,759,1597,861,817,721,971,758,827,740,
 998,841,1035,899,1196,1016,1296,988,902,1136,1008,1383,
 1166,928,1046,965,1300,2818,2770,2276,2158,1837,2552,2318,
 1831,2433,2295,1715,3483,4578,3252,4051,4086,3525],
 [37,41,13,58,67,105,85,88,66,59,77,71,104,102,107,56,54,
 96,75,87,93,99,98,49,52,471,340,443,432,475,402,347,424,
 355,542,411,423,385,283,359,331,244,227,302,216,202,200,
 295,311,239,258,220,343,565,482,604,458,416,509,522,572,
 545,485,611,426,413,483,512,573,550,462,591,456,396,468,
 463,1160,788,866,1010,1291,803,727,1238,963,812,979,820,
 736,753,1148,1248,1115,1035,899,1196,1016,1134,988,902,
 1136,1008,1074,1166,928,1046,965,1051,3538,2012,3243,1918,
 1429,1554,1493,3945,4205,3797,3896,3787,3649],
 [37,41,13,58,67,105,85,88,66,59,95,77,71,64,74,102,73,
 107,63,84,96,75,91,70,93,99,98,62,49,52,289,389,407,
 360,336,332,392,313,409,327,338,354,236,334,324,320,229,
 309,436,406,383,277,260,348,306,301,464,467,526,469,458,
 416,511,479,474,449,426,413,519,510,535,442,456,396,1507,
 924,878,942,759,1597,1015,861,817,971,758,827,740,998,841,
 1035,899,1196,1016,988,902,1136,1008,1166,928,1046,965,
 3097,3041],
 [37,41,40,25,67,50,61,97,69,88,66,77,108,74,107,63,84,
 103,96,60,87,98,49,68,52,471,443,424,385,283,342,186,
 298,304,320,244,310,388,202,213,254,303,214,239,258,220,
 551,467,570,536,592,558,469,543,522,561,473,562,449,557,
 512,571,546,510,559,523,569,442,553,463,815,692,866,726,
 1010,887,880,921,895,672,812,702,979,874,940,763,875,2145,
 1211,2197,1270,2127,1329,1093,899,1285,1391,1534,867,1225,
 1016,1423,1416,1731,1455,1142,1008,1255,1299,1649,848,1319,
 928,1420,1445,1085,965,1690,1448,2415,2873,2677,2420,2959,
 2767,2162,2077,2067,2280,1980,1986,2664,3283,2891,3262],
 [37,41,40,51,67,50,82,105,69,66,76,59,71,55,83,64,108,74,
 101,102,84,103,72,54,96,60,106,93,98,68,52,57,342,315,
 279,351,322,248,264,215,212,243,266,206,216,221,276,203,
 382,404,277,200,217,207,269,328,319,330,209,187,314,325,
 924,788,1062,1333,800,1084,759,847,707,712,635,901,697,
 704,662,1029,665,705,914,694,1040,628,897,664,698,645,961,
 2470,2008,2241,2536,2120,2259,1793,2270,2514,2134,2351,1989,
 2032,2364,2274,2332,1934,3811,4402,2950,4586,5182,3638,3162,
 4896,4054,4064,4373,4492,4409,9237,5022,5343,7721,4431,7585,
 5765,7168,8381,7284,6309,7789,6695,7058,7806,6331],
 [37,41,40,58,51,67,50,61,82,85,92,66,77,104,83,64,108,74,
 107,63,56,72,54,96,75,65,87,91,62,49,68,52,289,394,429,
 363,409,419,236,208,193,300,272,247,248,261,251,292,277,
 200,287,269,231,226,228,235,278,496,455,530,570,536,493,
 477,564,543,522,485,427,508,561,473,525,465,534,557,512,
 462,459,552,559,523,516,431,486,553,463,837,1404,826,1303,
 891,1237],
 [37,41,40,58,51,67,50,61,82,100,79,66,95,77,104,83,64,
 108,74,73,107,63,56,72,54,96,75,65,87,91,62,49,68,52,
 289,394,429,363,409,419,236,300,259,240,272,247,261,288,
 251,292,287,217,207,269,231,228,301,235,278,496,455,570,
 536,493,477,543,522,485,427,561,473,525,465,557,512,462,
 459,559,523,516,431,553,463,837,1404,826,1303,891,1237],
 [37,41,40,58,51,67,50,61,82,100,79,85,92,66,77,104,83,64,
 108,74,107,63,56,72,54,96,75,65,87,91,49,68,52,289,394,
 429,363,409,419,236,300,272,247,248,261,251,292,382,287,
 269,231,226,228,235,278,314,496,455,530,570,536,493,477,
 564,543,522,485,427,508,561,473,525,465,534,557,512,462,
 459,552,559,523,516,431,486,553,463,837,1404,826,1303,891,
 1237],[37,41,40,58,51,67,50,61,97,82,100,79,105,69,85,
 92,88,66,76,59,95,77,71,55,104,83,64,108,74,101,102,73,
 107,63,84,103,56,72,54,96,60,75,65,87,91,86,70,106,93,
 99,81,98,62,49,68,52,57],
 [37,41,40,58,67,50,61,82,66,77,104,64,108,74,107,63,56,
 96,87,91,49,68,52,289,394,429,419,236,334,300,272,247,
 261,309,293,288,251,292,436,287,269,260,231,228,301,235,
 278,551,467,496,455,530,570,536,493,477,543,522,598,485,
 427,508,561,473,525,465,557,512,462,459,552,559,523,516,
 431,553,463,566,935,703,809,685,762,843,699,785,837,1404,
 826,1303,891,1237,1093,899,1111,1285,1391,1245,1423,1416,
 1588,1025,1137,1731,1455,1227,1255,1299,1116,1420,1445,1051,
 1218,1690,1448,2056,2363,2061,2562,2200,1674,1894,1874,1563,
 2046,1721,1790,1901,1474,2052,1659,1778,1900,1604,3224,3223,
 4489,3466,2634,3606,4407,3428,5251,3987,3032,4487,3962,3325,
 5171,4035,3566,4307,4588,3574,5901,7629,5661,7517,5127,7312,
 5538,7723,5103,6434,5315,7134],
 [37,41,40,58,67,50,61,82,66,95,77,104,64,108,74,73,107,
 63,56,96,75,65,87,91,49,68,52,289,394,429,409,419,236,
 334,208,193,300,259,240,272,247,261,288,251,292,382,277,
 200,287,217,207,269,260,231,228,235,278,314,496,455,570,
 536,493,477,543,522,485,427,561,473,525,465,557,512,462,
 459,559,523,516,431,553,463,935,862,900,843,939,806,837,
 1404,826,1303,891,1237,1555,1158,1542,1039,1454,1089,1511,
 1249,1526,1002,1348,1103,2468,2010,2254,2035,2236,2187],
 [37,41,40,58,67,50,61,88,66,77,71,55,104,108,74,107,63,
 84,103,56,96,87,86,70,98,49,68,52,471,443,475,424,385,
 283,279,186,300,222,244,247,206,251,276,203,386,202,287,
 223,213,254,214,231,305,239,235,209,187,343,551,467,515,
 451,558,469,461,416,560,479,524,450,562,449,488,413,571,
 546,510,494,452,569,442,498,396,630,793,1084,636,816,1198,
 1101,1211,1558,1270,1266,1329,1286,1056,1003,1134,1025,1105,
 1074,1066,1051,2432,2718],
 [37,41,40,58,67,50,61,88,66,77,104,108,74,107,63,84,56,
 96,87,98,49,68,52,471,443,424,385,283,186,300,222,244,
 247,302,206,251,386,202,287,223,308,311,214,231,239,235,
 343,482,551,467,515,451,558,469,458,461,416,560,479,524,
 450,562,449,426,488,413,603,546,510,494,452,569,442,456,
 498,396,553,463,696,804,695,684,810,702,979,753,1211,1558,
 1270,1266,1329,1286,1699,1177,1003,1111,1392,1207,1134,1250,
 1031,1025,1722,1241,1074,1227,1070,1415,1179,1066,1295,1138,
 1051,1109,1036,2065,2566,2063,2460,2172,1782,1573,1837,1677,
 1902,1791,1545,1831,1637,2298,1888,1535,1715,1746,3033,3105,
 4523,2808,3432,3363,6011,2599,4072,2812,3072,3739,5799,2513,
 4419,2796,2675,3042,4901,2590,5530,9281,5604,8268,5123,6049,
 5064,9071,5624,6428,5902,6062],
 [37,41,40,58,67,50,61,97,88,66,76,59,77,71,55,104,108,74,
 101,107,63,84,103,56,96,60,87,99,81,98,49,68,52,57,471,
 443,432,475,424,385,283,186,300,222,244,247,206,216,221,
 251,202,287,223,214,231,239,258,220,235,551,467,515,451,
 558,469,461,416,560,479,524,450,562,449,488,413,546,510,
 494,452,569,442,498,396,1211,1558,1270,1266,1329,1286],
 [37,41,40,58,67,50,61,97,88,66,76,59,77,71,55,104,108,74,
 107,63,84,103,56,96,87,86,70,98,49,68,52,57,471,443,
 432,475,424,385,283,186,300,244,230,247,206,251,276,203,
 202,287,214,246,231,239,235,209,187,551,467,430,515,451,
 558,469,458,461,416,560,479,466,524,450,562,449,426,488,
 413,546,510,478,494,452,569,442,456,498,396,1211,1558,
 1270,1266,1329,1286],
 [37,41,40,58,67,50,61,97,88,66,77,104,108,74,101,107,63,
 84,56,96,60,87,98,49,68,52,57,471,443,424,385,283,186,
 300,222,244,247,302,206,251,202,287,223,214,231,321,239,
 235,551,467,515,451,496,455,570,536,558,469,461,416,493,
 477,543,522,560,479,524,450,485,427,561,473,562,449,488,
 413,525,465,557,512,546,510,494,452,462,459,559,523,569,
 442,498,396,516,431,553,463,851,2145,1211,1558,839,2197,
 1270,1266,789,2127,1329,1286],
 [37,41,40,58,67,50,82,105,69,88,66,76,59,77,71,55,64,102,
 107,63,84,103,56,96,60,93,99,81,98,49,68,52,57,471,432,
 475,424,355,542,385,283,320,280,227,230,206,216,221,383,
 294,262,250,246,306,239,258,220,558,469,461,416,524,450,
 562,449,494,452,569,442,498,396,1507,1318,878,759,1597,
 1340,861,817,992,1069,1601,857,1534,867,1741,945,1548,926,
 1649,848,1665,949,1706,1571,1619,1373,1756,1568,1608,1380,
 1723,1525,1654,1417,1881,1912,1875],
 [37,41,40,58,67,50,82,105,88,66,77,64,102,107,63,84,56,
 96,91,93,98,49,68,52,471,432,475,424,355,542,283,350,
 331,320,280,227,302,383,223,308,311,262,250,321,306,343,
 482,558,469,461,416,543,522,545,562,449,426,557,512,550,
 494,452,569,442,553,463,1507,878,726,1010,1291,759,1597,
 1048,861,702,979,1346,817,2436,2517,1069,2595,1601,857,
 1534,867,1225,1016,1392,1207,1134,1316,1162,1741,945,1548,
 926,1722,1241,1067,986,1649,848,1319,928,1066,1665,949,
 1295,1138,1109,1036,3511,3780,1706,1571,1619,1373,1662,1412,
 1480,1578,1756,1568,1608,1380,1411,1544,1632,1723,1525,1720,
 1176,1654,1417,1414,1431,1587,3148,2786,2667,3497,4205,4161,
 3020,3102,2900,2877,3489,3787,3534,2970,1881,1912,1875,4348,
 4682,2731,7019,4061,4381,4794,4858,2772,3764,4116,6045,7681,
 5039],
 [37,41,40,58,67,50,97,82,105,88,66,76,59,77,71,55,64,101,
 102,107,63,84,103,56,96,91,93,99,81,98,49,68,52,57,471,
 432,475,424,355,542,385,283,320,280,227,383,262,250,306,
 258,220,558,469,458,461,416,562,449,426,494,452,569,442,
 456,498,396,1507,878,726,1010,759,1597,861,702,979,817,
 1069,1601,857,1035,1534,867,1196,1225,1016,1741,945,988,
 1548,926,1136,1649,848,1166,1319,928,1665,949,1046,1706,
 1571,1619,1373,1662,1756,1568,1608,1380,1723,1525,1720,1654,
 1417,1881,1912,1875],
 [37,41,58,50,61,79,88,59,95,77,53,71,104,74,73,107,63,84,
 54,96,87,70,80,99,98,49,68,52,407,360,336,313,363,354,
 236,334,356,186,208,300,244,280,310,309,243,288,251,202,
 277,214,262,231,330,348,290,301,314,482,430,515,397,496,
 458,461,412,485,426,488,478,494,417,462,700,692,915,880,
 809,921,705,672,801,939,769,940,868,875,834,811,1056,958,
 1073,1145,937,1316,1018,1155,1105,910,1067,1083,1065,1009,
 1224,886,1109,2257,2709,2123,2660,1460,1625,1412,1480,1447,
 1510,1411,1544,1441,1575,1414,1431,2488,2413,2143,2164,2214,
 7699,5111,9143,5623,6918,5989],
 [37,41,58,67,50,82,105,88,66,77,53,71,55,64,102,107,63,
 84,103,56,96,91,93,80,98,49,68,52,471,432,475,424,355,
 542,283,279,222,298,304,320,280,227,216,221,383,294,223,
 213,254,262,250,306,258,220,209,187,343,558,469,461,416,
 524,450,562,449,494,452,569,442,498,396,486,1507,1334,878,
 668,737,1291,759,807,1597,1198,861,1346,817,787,992,1069,
 1601,857,1534,867,1296,1134,1741,945,1025,1548,926,1649,
 848,1066,1665,949,1051,2004,1940,2069,2198,1706,1571,1619,
 1373,1756,1568,1608,1380,1723,1525,1654,1417,3252,3525,1881,
 1912,1875,4348,4682,4061,4381,4858,3764],
 [38,21,51,50,97,100,94,69,92,76,95,53,83,73,63,56,72,78,
 60,65,90,86,70,106,80,252,282,339,384,481,541,395,521,
 476,373,433,387,444,491,186,304,247,254,231,588,515,501,
 536,606,624,522,609,598,524,506,473,618,625,512,620,581,
 599,494,517,523,600,638,463,615,587,663,814,859,695,1603,
 757,801,883,1524,904,1321,1540,3083,929,1282,1519,3085,
 1118,1236,1498,2964,1343,1146,1285,1263,1667,1362,1423,1457,
 1671,1081,1521,1125,1731,1530,1538,1345,1255,1186,1738,1223,
 1536,1058,1420,1396,1570,1203,1690,1393,1602,1215,1785,2212,
 2023,2093,2075,1801,1948,2292,2080,2588,2408,2316,3052,2315,
 2519,2896,3236,2902,2935,2233,2700,2889,3291,2810,3646,3481]
  ,[39,20,42,38,15,51,67,61,92,66,76,95,53,71,55,73,107,
 84,103,65,91,86,81,62,49,68,57,237,421,408,364,393,286,
 324,279,234,229,244,280,230,215,318,270,288,406,294,253,
 260,214,262,246,245,301,192,209,464,551,430,515,526,558,
 458,461,477,511,560,466,524,474,562,426,488,519,546,478,
 494,459,456,498,716,668,873,745,671,798,872,1232,888,1301,
 825,833,1403,1399,1171,1512,1456,917,1348,1990,2139,1370,
 3234,2611,3084,2554,3486,2737,2621,5882,5333],
 [39,20,42,38,15,58,51,67,61,97,94,92,59,95,53,71,55,104,
 83,101,73,107,63,84,65,90,70,106,81,98,49,68,57,324,
 186,208,222,259,291,298,310,309,318,255,212,206,216,201,
 276,202,277,223,217,238,213,323,192,209,314,663,720,719,
 692,814,859,803,733,746,695,808,685,807,635,704,662,701,
 710,709,672,757,799,699,787,628,698,645,1785,2215,2096,
 2423,2602,2394,2234,2084,2075,1801,2078,2397,2383,2390,1969,
 2080,8989,6052,7545,4866],
 [39,21,50,97,100,94,69,85,92,89,95,55,83,108,101,73,63,
 103,72,78,65,90,70,106,80,81,62,68,57,252,384,369,481,
 422,365,425,367,521,346,476,373,444,380,491,371,472,334,
 186,304,255,212,251,292,202,295,299,235,278,588,565,496,
 537,556,493,580,572,485,540,527,525,599,573,462,548,568,
 516,784,862,1192,808,807,765,939,799,787,1271,1281,1566,
 1050,1197,1055,1064,1072,1078,1108,951,1026,1240,1124,1150,
 984,999,1057,2608,2431],
 [39,21,50,97,100,94,69,92,89,66,95,55,83,108,101,73,63,
 103,72,78,65,90,106,80,99,81,62,68,57,252,353,326,421,
 365,312,333,428,344,337,373,405,374,393,317,286,334,300,
 272,350,255,206,435,287,269,295,239,335,588,565,496,493,
 580,572,485,507,487,525,599,573,462,529,499,516,784,876,
 862,893,807,765,853,939,787,1433,976,973,813,982,835,1050,
 1197,1064,1072,1078,1108,1127,1026,1240,1124,1150,1128,999,
 1057,2651,2849,1437,1180,1402,1141,1408,1132,5224,4795,5423]
  ,[39,21,51,97,100,94,69,85,92,89,95,53,83,108,101,73,
 63,103,72,78,60,90,70,106,80,81,62,68,57,252,384,369,
 481,422,541,365,425,367,521,346,476,373,491,371,472,324,
 186,304,243,251,292,202,254,311,299,235,278,588,565,496,
 537,556,493,580,572,485,540,527,525,599,573,462,516,804,
 983,808,901,810,918,920,799,897,1068,1174,996,1013,1484,
 1323,1050,1197,1055,1064,1072,1078,1108,951,1026,1240,1124,
 1150,999,1057,2216,2024,1685,1477,1693,1489,1691,1370,2906,
 2897,2733],
 [39,21,51,97,100,94,69,92,89,66,95,53,83,108,101,73,63,
 103,72,78,60,90,106,80,99,81,62,68,57,252,353,326,421,
 376,408,365,312,333,428,344,337,373,374,393,317,286,324,
 300,272,350,243,435,287,269,308,311,239,335,588,565,496,
 554,513,493,580,572,485,507,487,525,599,573,462,529,499,
 516,804,876,983,901,810,853,812,920,897,989,977,779,1050,
 1197,1131,1064,1072,1078,1108,1127,1026,1240,1124,1150,1128,
 999,1057,2541,2308],
 [39,32,21,15,58,67,50,61,100,105,69,85,88,89,76,95,77,71,
 55,104,108,102,73,107,63,84,103,56,78,65,86,70,93,80,
 99,81,98,62,68,57,334,279,186,234,304,359,229,230,329,
 255,212,266,270,288,436,294,202,253,207,348,349,305,299,
 306,273,301,700,950,1192,1400,714,674,705,1344,1424,721,
 693,3094,2991],
 [39,38,21,51,50,97,100,94,69,76,95,53,55,83,108,101,73,
 63,72,78,60,90,86,106,80,81,68,57,252,282,384,481,541,
 365,352,425,521,476,444,491,472,342,259,272,302,310,221,
 388,217,269,267,330,314,464,451,455,637,416,543,549,511,
 450,427,626,413,557,544,452,459,623,396,553,480,663,915,
 695,701,801,753,961,927,791,832,838,821,846,1343,1146,
 1506,1076,1423,1457,1521,1125,1444,1161,1255,1186,1536,1058,
 1541,1090,1690,1393,2407,2441,1567,1514,1557,2324,3602,2312,
 4177,2960,4438,2309,4117,2417,3647,2802,4606],
 [39,38,21,51,67,50,61,97,100,94,105,69,92,89,53,83,108,
 74,101,73,107,63,84,103,96,60,65,90,91,86,106,80,62,
 237,353,326,369,421,312,333,367,428,361,405,374,380,393,
 291,298,351,309,318,437,435,386,238,213,328,348,323,357,
 335,343,570,536,556,543,522,549,561,473,527,557,512,544,
 559,523,568,553,463,480,844,738,756],
 [39,38,21,51,67,50,61,97,100,94,105,69,92,89,53,83,108,
 74,101,73,107,63,84,103,96,60,65,90,91,86,106,80,62,
 237,353,326,369,421,364,312,333,367,428,361,405,374,380,
 291,298,351,309,318,437,435,386,238,213,328,348,323,357,
 335,343,570,536,556,543,522,549,561,473,527,557,512,544,
 559,523,568,553,463,480,2807,2736,2656],
 [39,38,21,51,67,50,61,97,100,94,105,69,92,89,66,55,83,
 108,74,101,73,107,63,84,103,60,65,90,91,86,106,81,62,
 237,353,326,369,421,312,333,367,428,361,405,374,380,393,
 298,351,309,318,329,437,435,386,213,328,348,323,349,357,
 335,343,441,570,556,509,543,549,447,561,527,483,557,544,
 470,559,568,468,553,480,844,738,756],
 [39,38,21,51,67,50,61,97,100,94,105,69,92,89,66,55,83,
 108,74,101,73,107,63,84,103,60,65,90,91,86,106,81,62,
 237,353,326,369,421,364,312,333,367,428,361,405,393,298,
 351,309,318,329,437,435,386,213,328,348,323,349,357,335,
 343,441,570,556,509,543,549,447,561,527,483,557,544,470,
 559,568,468,553,480,1006,1174,828,1013,972,1323],
 [39,38,21,58,51,50,97,82,100,94,69,85,88,89,76,59,95,53,
 55,83,73,103,56,72,78,60,75,65,87,90,86,70,106,80,62,
 252,282,384,481,541,365,352,425,476,373,433,444,491,240,
 247,215,203,207,231,245,187,570,556,606,624,543,549,609,
 598,561,527,618,625,557,544,620,581,559,568,600,638,553,
 480,615,587,1762,3083,1766,3085,1803,2964],
 [39,38,21,58,51,50,97,82,100,94,69,85,88,89,76,59,95,53,
 55,83,102,73,103,56,72,78,60,75,65,87,90,86,106,80,62,
 252,282,384,481,541,365,352,425,476,373,433,444,491,240,
 215,221,203,207,245,220,187,570,556,606,624,543,549,609,
 598,561,527,618,625,557,544,620,581,559,568,600,638,553,
 480,615,587,1762,3083,1766,3085,1803,2964],
 [39,38,21,58,51,50,97,82,100,94,69,85,92,88,76,59,95,53,
 55,83,73,63,56,72,78,60,75,65,87,90,86,70,106,80,81,
 252,282,384,481,541,365,352,521,476,373,433,444,491,307,
 247,302,382,267,231,321,314,570,556,606,624,543,549,609,
 598,561,527,618,625,557,544,620,581,559,568,600,638,553,
 480,615,587,1540,3083,1519,3085,1498,2964],
 [39,38,21,58,51,50,97,82,100,94,69,89,76,59,95,53,55,108,
 101,102,73,103,56,72,78,60,75,65,87,90,86,70,106,80,68,
 57,252,282,384,481,541,365,352,521,476,373,433,444,491,
 472,259,240,272,215,203,217,207,269,245,187,570,556,592,
 543,549,574,561,527,612,557,544,571,559,568,601,553,480,
 566,1540,1519,1498],
 [39,38,21,58,51,50,97,82,100,94,69,92,76,59,95,53,55,83,
 102,73,63,56,72,78,60,75,65,87,90,86,70,106,80,81,252,
 282,384,481,541,365,352,521,476,373,433,444,491,259,272,
 307,302,382,217,269,267,321,314,570,556,606,624,543,549,
 609,598,561,527,618,625,557,544,620,581,559,568,600,638,
 553,480,615,587,1540,3083,1519,3085,1498,2964],
 [39,38,21,58,51,67,50,61,97,82,100,94,105,69,85,92,88,89,
 66,76,59,95,53,71,55,104,83,108,74,101,102,73,107,63,
 84,103,56,72,78,96,60,75,65,87,90,91,86,70,106,80,99,
 81,98,62,68,52,57],
 [39,42,21,51,50,61,69,92,89,66,76,95,77,53,71,55,83,108,
 74,73,63,84,78,60,65,90,91,86,80,81,62,68,52,57,237,
 252,421,408,364,365,312,428,361,373,405,393,286,234,230,
 288,251,276,253,246,301,235,209,482,551,490,515,567,558,
 554,461,545,560,533,524,528,562,507,488,550,546,563,494,
 555,569,529,498,1357,1232,1434,1301,1325,1395],
 [39,42,21,51,50,61,94,92,89,66,76,95,77,53,71,55,83,108,
 74,101,63,78,60,65,90,91,86,106,93,99,81,62,68,52,57,
 237,252,421,408,364,365,312,337,361,373,405,393,286,222,
 248,261,201,223,226,228,192,482,551,490,515,567,558,554,
 461,545,560,533,524,528,562,507,488,550,546,563,494,555,
 569,529,498,1357,1769,1434,1774,1325,1754],
 [39,42,21,51,50,61,97,100,92,89,66,76,95,77,53,71,55,83,
 108,73,63,84,103,72,78,65,90,91,86,93,80,99,81,62,68,
 52,57,237,252,353,421,408,364,365,312,428,337,405,393,
 286,234,227,230,288,253,250,246,301,490,430,515,554,458,
 461,533,466,524,507,426,488,563,478,494,529,456,498,888,
 927,825,832,833,821],
 [39,42,21,51,50,61,97,100,92,89,66,76,95,77,53,71,55,83,
 108,74,101,63,84,103,72,60,65,90,91,86,106,81,62,68,52,
 57,237,252,353,421,408,364,365,312,428,361,373,405,393,
 286,222,248,251,201,276,223,226,235,192,209,495,490,515,
 547,554,461,503,533,524,538,507,488,532,563,494,539,529,
 498,1232,1301,1395],
 [39,42,21,51,97,100,69,92,89,76,95,53,55,83,108,73,103,
 72,78,60,65,90,86,80,81,62,68,57,237,252,353,421,408,
 364,365,312,337,361,373,405,393,286,230,261,206,435,319,
 308,228,239,301,335,575,565,397,596,554,461,531,543,585,
 572,412,582,504,557,584,573,417,593,529,498,497,553,877,
 942,674,938,884,693,1769,1774,1754,1287,1093,1267,1338,
 1225,1131,1187,1077,1361,1366,1142,1264,1319,1235,1252,1085,
 1128,2640,2111,2567,2070,1849,1619,1832,1608,1890,1654,2632,
 2778,3203,3163,2526,3147,2857,2638,3297,3267,2958,2594,3683,
 4190,4046],
 [39,42,21,51,97,100,94,92,89,76,95,53,55,83,108,101,103,
 72,78,60,65,90,86,106,81,62,68,57,353,421,408,364,365,
 312,428,337,361,373,405,393,286,322,350,248,261,206,435,
 223,319,308,228,192,335,575,397,596,554,461,531,543,585,
 572,412,582,507,488,504,557,584,573,417,593,529,498,497,
 553,959,716,847,1048,745,882,698,3977,3358,4254,3507,4212,
 3957,1287,1093,1338,1225,1131,1187,1077,1366,1142,1127,1264,
 1319,1252,1085,1128,1916,1923,4427,4460,5932,2632,3163,2526,
 2638,3297,2594],
 [39,42,21,58,51,67,50,61,97,82,100,94,105,69,85,92,89,66,
 76,59,95,77,53,71,55,104,83,108,74,101,102,73,107,63,
 84,103,56,72,78,96,60,75,65,90,91,86,70,106,93,80,99,
 81,98,62,68,52,57],
 [39,42,21,58,51,67,50,94,69,89,76,59,95,53,55,101,102,73,
 107,63,103,56,72,78,60,70,106,80,81,98,62,68,57,282,
 481,376,422,541,352,521,344,346,476,491,317,371,472,279,
 186,208,320,229,280,270,216,294,202,277,303,260,262,273,
 258,490,515,451,554,461,416,533,524,450,507,488,413,563,
 494,452,529,498,396,791,838,846],
 [39,42,21,58,51,67,50,94,69,89,76,59,95,53,55,101,102,73,
 107,63,103,56,72,78,60,70,106,80,81,98,62,68,57,282,
 481,541,352,521,344,346,476,433,491,317,371,472,279,186,
 208,320,229,280,270,216,294,202,277,303,260,262,273,258,
 490,515,451,554,461,416,533,524,450,507,488,413,563,494,
 452,529,498,396,1433,954,973,842,982,1047],
 [39,42,38,51,67,50,61,92,89,66,76,95,53,71,55,64,108,73,
 107,63,84,103,78,65,91,86,81,62,49,68,52,57,237,421,
 408,364,428,393,286,279,234,229,227,230,270,288,201,276,
 294,253,260,250,246,273,301,192,209,464,551,490,430,515,
 526,558,554,458,461,511,560,533,466,524,474,562,507,426,
 488,519,546,563,478,494,535,569,529,456,498,1232,888,1301,
 825,1395,833],
 [39,42,38,51,67,50,61,92,89,66,76,95,53,71,55,64,108,74,
 73,107,63,84,103,78,96,65,80,99,81,62,49,68,52,57,237,
 421,408,364,428,393,286,279,234,300,229,230,270,206,216,
 288,294,253,287,260,246,273,239,258,301,464,551,430,515,
 526,558,458,461,511,560,466,524,474,562,426,488,519,546,
 478,494,535,569,456,498,1232,888,1301,825,1395,833],
 [39,42,38,51,67,50,92,89,66,76,95,53,71,55,64,108,73,107,
 63,84,103,78,65,91,86,80,99,81,62,49,68,52,57,237,421,
 408,364,428,393,286,315,279,234,229,227,230,270,288,383,
 294,253,260,250,246,273,301,464,551,490,430,515,526,558,
 554,458,461,511,560,533,466,524,474,562,507,426,488,519,
 546,563,478,494,535,569,529,456,498,1232,888,1301,825,
 1395,833],
 [39,42,38,51,67,50,92,89,66,76,95,55,64,108,74,73,107,63,
 103,78,96,65,81,62,49,68,57,237,421,408,428,393,286,315,
 279,234,229,230,261,270,206,216,288,201,276,383,294,253,
 287,260,246,273,239,258,301,192,209,335,464,551,430,515,
 526,558,458,461,511,560,466,524,474,562,426,488,519,546,
 478,494,535,569,456,498,815,930,845,895,869,941,1232,888,
 1301,825,1395,833,1102,1343,993,1506,1251,1521,1100,1444,
 1038,1536,1159,1541,2223,2281,2026,2227,1977,2456],
 [39,42,38,51,67,50,92,89,95,55,64,108,73,107,63,103,78,
 65,81,62,49,68,57,237,421,428,393,286,279,234,300,229,
 230,261,270,288,435,294,253,287,295,308,260,246,273,301,
 335,565,464,551,430,515,526,558,554,458,461,511,560,466,
 524,474,562,507,426,488,599,519,546,478,494,535,569,529,
 456,498,468,553,784,696,845,765,684,812,702,941,1232,888,
 1301,825,1395,833,1426,1699,1228,1050,1446,1392,1131,1290,
 1250,1221,1443,1722,1127,1026,1590,1406,1415,1243,1369,1295,
 1128,886,1109,2541,2065,2308,2063,1599,1910,1782,1676,2074,
 1466,1899,1791,1717,2038,1552,1848,1888,1647,2166,3261,3328,
 3532,4523,4255,3432,4073,6011,3194,4072,4410,3072,3789,5799,
 3746,4419,3656,2675,3751,4901,9310,5530,8284,5604,7800,5123,
 7982,5064,7447,5624,8209,5902],
 [39,42,38,51,67,50,97,69,85,89,95,55,104,83,64,108,73,
 107,103,56,72,78,65,90,62,49,68,57,282,384,425,476,444,
 472,342,186,208,234,240,304,230,215,255,212,221,288,203,
 388,202,277,253,207,246,245,220,301,187,278,397,496,441,
 570,453,493,509,543,572,412,485,447,561,448,525,483,557,
 417,462,470,559,454,516,468,553,1107,1192,807,635,1075,
 787,628,1271,1321,1281,1282,1566,1236,1050,1064,1078,1108,
 1026,1124,999,1057,2608,2431],
 [39,42,38,51,67,50,97,89,95,55,83,64,108,73,107,103,78,
 65,90,62,49,68,57,282,384,425,444,472,342,234,240,230,
 215,310,309,221,288,203,388,253,207,303,246,245,220,301,
 187,464,551,397,496,455,441,570,453,493,509,543,602,412,
 485,427,447,561,448,525,483,557,417,462,459,470,559,454,
 516,468,553,480,752,974,703,808,685,694,799,699,1271,1321,
 1281,1282,1566,1236,1035,1093,1050,1114,1285,1064,1173,1423,
 1081,1221,1078,1257,1731,1026,1034,1255,1124,1209,1420,1128,
 999,1170,1690,2418,2056,2559,2061,1749,1733,1560,1894,2279,
 1633,1825,1553,1790,1905,1673,1841,1589,1778,2194,2944,2925,
 2575,4489,2922,2634,2876,4407,2544,5251,3693,3032,2875,3962,
 2545,5171,3613,3566,2813,4588,5585,5901,7529,5661,6345,5127,
 5540,5538,7290,5103,6528,5315],
 [39,42,38,51,67,50,97,94,92,95,55,83,64,108,101,63,78,65,
 90,106,81,49,68,57,282,541,352,425,476,433,472,342,307,
 320,248,264,310,309,221,382,303,226,281,321,330,348,464,
 551,441,570,453,493,549,511,560,427,447,561,544,519,546,
 417,462,470,559,480,814,1333,974,703,859,1029,1603,757,
 1265,1021,725,883,1524,2560,1068,2525,2439,1035,1093,1114,
 1285,948,1667,1064,937,1316,850,1671,988,1077,1257,1731,
 936,1538,952,1738,1166,1319,1124,1209,1420,1009,1224,856,
 1570,860,1602,4115,3689,1579,1429,1409,1410,1656,1167,1728,
 1513,1727,1628,1554,1394,1387,1606,1561,1753,1584,1493,1418,
 1644,1382,1611,1551,1712,2938,3467,4238,3592,2853,2830,2980,
 3021,4147,3981,3418,2624,2769,3308,1866,1917,1844,4165,3786,
 2882,4824,4270,4268,4103,6615,2788,4837,4596,4942,9329,5448]
  ,[39,42,38,58,51,67,50,61,97,82,100,94,105,69,85,92,89,
 66,76,59,95,53,71,55,104,83,64,108,74,101,102,73,107,
 63,84,103,56,72,78,96,60,75,65,90,91,86,70,106,80,99,
 81,98,62,49,68,52,57],
 [39,42,38,58,51,67,50,97,69,85,89,95,55,104,83,64,108,73,
 107,103,56,72,78,60,75,65,90,98,62,49,68,57,282,384,
 425,476,433,444,472,186,208,234,240,230,247,215,288,203,
 202,277,253,207,246,231,245,301,187,397,496,455,441,570,
 453,493,477,509,543,412,485,427,447,561,448,525,465,483,
 557,417,462,459,470,559,454,516,431,468,553,1271,1321,
 1281,1282,1566,1236],
 [39,42,38,58,51,67,50,97,82,100,89,59,95,55,104,83,64,
 108,102,73,107,103,56,72,78,60,75,65,90,98,62,49,68,57,
 282,384,425,476,433,444,472,234,222,259,240,230,215,221,
 288,203,253,223,217,207,246,245,220,301,187,397,496,441,
 570,453,493,509,543,412,485,447,561,448,525,483,557,417,
 462,470,559,454,516,468,553,1271,1321,1281,1282,1566,1236],
 [39,42,38,58,51,67,50,97,82,100,94,59,95,55,104,83,64,
 108,101,63,56,72,78,60,75,65,90,70,106,81,49,68,57,282,
 384,541,352,425,476,433,472,222,259,240,307,247,248,264,
 292,382,223,217,207,231,226,281,321,397,496,441,570,453,
 493,447,561,448,525,417,462,470,559,814,859,1347,1603,757,
 883,1308,1524,1068,996,948,1667,850,1671,936,1538,952,1738,
 856,1570,860,1602,1410,1656,1513,1727,1387,1606,1561,1753,
 1382,1611,1551,1712,1866,1917,1844],
 [39,42,38,58,51,67,50,97,82,100,94,92,95,55,104,83,64,
 108,101,102,63,56,72,78,60,75,65,90,106,81,98,49,68,57,
 282,384,541,352,425,476,433,472,222,259,307,248,264,382,
 226,281,321,397,496,455,441,570,453,493,427,447,561,417,
 462,459,470,559,814,974,703,859,1603,757,1021,725,883,
 1524,1068,1044,948,1667,937,1316,1162,850,1671,1121,936,
 1538,986,952,1738,1009,1224,1201,856,1570,1036,860,1602,
 1410,1656,1728,1513,1727,1387,1606,1561,1753,1644,1382,1611,
 1551,1712,1866,1917,1844],
 [39,42,38,58,51,67,50,97,89,59,95,55,83,64,108,102,73,
 107,103,78,65,90,98,62,49,68,57,282,384,425,444,472,234,
 240,320,230,215,221,288,203,253,207,303,246,245,220,301,
 187,464,551,430,515,397,496,441,570,526,558,458,461,453,
 493,509,543,511,560,466,524,412,485,447,561,474,562,426,
 488,448,525,483,557,519,546,478,494,417,462,470,559,535,
 569,456,498,454,516,468,553,1271,1321,2138,791,1281,1282,
 2201,838,1566,1236,2153,846],
 [39,42,38,58,51,67,97,94,105,59,95,53,71,104,83,101,102,
 73,107,63,84,56,72,60,75,65,70,106,81,49,68,52,324,315,
 186,208,331,318,329,270,206,216,201,276,406,383,202,277,
 223,217,207,267,238,213,214,262,250,323,349,278,314,343,
 959,644,700,663,896,630,1042,695,919,704,662,1048,665,705,
 701,889,636,710,709,853,757,1075,801,1346,1054,792,932,
 1950,2368,2291,2371,2075,1976,2321,2088,2529,2282,1801,2252,
 2110,2565,2269,2007,2478,4405,4379,4173,4000,4602,3318,3415,
 5681,4834,2982,4675,3895,5473,8129,4744,7412,5557,5432,6887,
 4465,9002,9353,7516,8061,6967,6722,6352,7260,8821],
 [39,42,51,50,92,89,66,76,95,53,55,83,108,74,73,63,78,65,
 90,86,80,81,62,68,57,237,252,421,408,410,364,365,312,
 428,399,405,393,286,341,261,206,228,239,335,565,482,551,
 430,567,558,458,531,543,572,545,560,466,528,562,426,504,
 557,550,546,478,555,569,456,497,553,877,942,879,674,938,
 747,884,693,806,1357,1232,888,927,1434,1301,825,832,1325,
 1395,833,821,1287,1093,905,1343,1338,1225,1020,1506,1190,
 1423,1187,1077,969,1521,1366,1142,1017,1444,1182,1255,1264,
 1319,885,1536,1252,1085,1019,1541,1204,1690,1995,2636,2132,
 2716,2091,1957,2581,2251,2898,2074,2038,2166,2540,2324,2549,
 2312,2598,2960,2527,2309,2409,2417,2663,2802,4848,5321],
 [41,13,58,50,82,79,94,105,85,59,77,53,104,74,102,107,63,
 103,56,54,78,96,70,93,99,49,52,57,372,492,432,520,355,
 484,283,356,279,222,272,298,331,244,230,255,212,266,216,
 201,203,292,294,223,269,213,308,311,305,306,192,278,578,
 565,397,530,558,589,572,412,508,448,534,603,573,454,486,
 696,750,803,674,635,662,1246,684,769,628,645,1151,840,964,
 1111,1197,1245,1072,1741,1137,1108,1227,1240,1116,1150,1218,
 1057,2394,2464,2383,2391,1384,1359,1452,1422,1398,1306,1425,
 1413,1465,1390,1337,1428,5743,5098,2002,2021,2011],
 [41,35,40,34,13,25,58,67,61,82,79,105,85,88,66,59,77,71,
 104,64,74,102,107,84,56,54,96,75,87,91,70,93,99,98,49,
 52,471,340,289,372,316,394,492,443,432,475,402,336,347,
 345,429,520,424,355,542,411,409,423,377,419,484,385,283],
 [41,40,13,58,51,67,50,61,82,100,79,94,105,59,95,77,71,64,
 102,73,63,84,54,78,96,75,65,87,91,70,106,93,289,394,
 375,336,409,419,327,259,240,272,291,264,310,309,276,404,
 217,207,269,238,281,330,348,209,325,536,556,592,614,624,
 522,549,574,602,598,473,527,612,608,625,512,544,571,590,
 581,523,568,601,621,638,463,480,566,577,587,1752,1407,
 1770,1496,1755,1504],
 [41,40,13,58,51,67,50,61,82,100,79,94,105,59,95,77,71,64,
 102,73,63,84,72,54,78,96,75,65,87,91,93,289,394,375,
 336,409,419,259,240,272,291,264,310,221,288,276,404,217,
 207,269,238,281,330,220,301,209,325,536,556,592,614,624,
 522,549,574,602,598,485,473,527,612,608,625,512,544,571,
 590,581,523,568,601,621,638,516,463,480,566,577,587,1752,
 1407,1770,1496,1755,1504],
 [41,40,13,58,51,67,50,61,82,100,79,94,105,92,88,59,95,77,
 71,83,64,102,63,84,72,54,78,96,75,65,87,91,70,106,93,
 289,394,375,336,409,419,327,259,291,248,264,310,276,382,
 404,217,238,226,281,330,209,314,325,536,556,614,624,522,
 549,602,598,473,527,608,625,512,544,590,581,523,568,621,
 638,463,480,577,587,1752,1407,1770,1496,1755,1504],
 [41,40,13,58,51,67,50,61,97,82,100,79,94,105,69,85,92,88,
 66,76,59,95,77,71,55,104,83,64,74,101,102,73,107,63,84,
 103,56,72,54,78,96,60,75,65,87,91,86,70,106,93,99,81,
 98,62,49,52,57],
 [41,40,13,58,67,50,61,82,79,94,105,77,71,64,102,63,84,54,
 78,96,75,91,93,289,394,375,336,409,334,259,240,272,291,
 264,310,309,221,288,276,404,217,207,269,238,281,330,348,
 209,325,551,455,530,536,556,614,624,622,522,549,602,598,
 560,485,473,527,608,625,512,544,590,581,546,523,568,621,
 638,463,480,577,587,935,862,1029,900,843,939,961,806,1752,
 1407,1770,1496,1755,1504,1391,1263,1764,1416,1457,1588,1137,
 1455,1530,1155,1836,1299,1186,1716,1445,1396,1679,1448,1393,
 1109,1772,1460,1869,1892,3077,1412,1447,1882,1827,2852,1411,
 1441,1850,1880,2785,1414,2642,3111,3210,2686,3035,2993,3479,
 2721,2843,3198,2882,3007,2800,3721,2626,2855,2788,3132,2688,
 2940],[41,40,13,58,67,50,61,82,79,94,105,77,71,64,102,
 73,63,84,54,78,96,75,65,87,91,93,62,289,394,375,336,
 409,419,334,208,259,240,272,291,304,351,264,310,276,404,
 436,277,217,238,254,328,260,281,330,209,325,536,556,614,
 624,522,549,602,598,473,527,608,625,512,544,590,581,523,
 568,621,638,463,480,577,587,935,950,809,778,843,892,868,
 795,1752,1407,1770,1496,1755,1504,1044,1262,1162,1280,1121,
 1356,986,1169,1201,1360,1036,1275,1656,1727,1606,1753,1611,
 1712,3023,3591,2887,3112,3290,2936],
 [41,40,13,58,67,50,61,97,82,79,94,69,85,66,77,71,55,104,
 64,74,101,107,103,56,54,78,96,60,75,91,99,49,52,57,471,
 372,475,347,355,542,423,283,247,215,261,287,245,228,235,
 187,278,416,513,493,477,564,413,487,525,459,552,396,499,
 516,431,486,815,887,737,1107,746,895,874,755,1075,763,789,
 899,1183,1699,1016,1253,1392,1207,1296,902,1096,1250,1008,
 1230,1722,928,1213,1415,1179,1189,965,1147,1295,1409,1798,
 1435,1662,1837,1394,1622,1440,1744,1418,1720,2298,1458,1680,
 2275,2210,2211],
 [41,40,13,58,67,50,61,97,82,79,94,85,66,76,77,71,55,104,
 64,74,101,107,56,54,78,96,60,75,91,86,49,52,57,471,372,
 475,347,355,542,423,283,247,215,261,302,276,203,292,287,
 223,245,228,321,235,209,187,278,416,513,477,564,427,508,
 413,487,459,552,396,499,431,486,815,959,887,746,895,1048,
 874,763,839,789,899,1183,1016,1253,902,1096,1008,1230,928,
 1213,965,1147,1409,1798,1435,1662,1394,1622,1440,1744,1418,
 1720,1458,1680,2275,2210,2211],
 [41,40,13,58,67,50,61,97,82,105,66,77,71,55,104,102,63,
 84,56,54,78,96,60,75,91,93,81,98,49,52,57,471,372,432,
 475,347,355,542,283,193,234,222,259,244,227,230,276,200,
 253,223,214,250,246,281,321,451,501,496,455,530,416,513,
 493,427,508,413,487,525,452,517,462,459,552,764,814,703,
 1023,728,757,725,932,1033,840,1044,1262,1162,1280,1121,
 1356,986,1169,1201,1360,1036,1275,1692,1713,1656,1578,1586,
 1727,1626,1719,1606,1632,1485,1753,1675,1735,1611,1587,1543,
 1712,2261,2268,2237],
 [41,40,13,58,67,50,61,97,82,105,69,66,76,77,71,55,104,64,
 102,63,84,103,56,54,78,96,60,75,91,86,93,49,52,57,471,
 372,432,475,347,355,542,283,193,234,259,227,230,276,203,
 292,200,253,250,246,281,451,501,455,530,416,513,427,508,
 413,487,452,517,459,552,764,703,1023,1246,1347,728,725,
 932,1151,1308,1033,840,1044,1262,1162,1280,1121,1356,986,
 1169,1201,1360,1036,1275,1692,1713,1578,1586,1626,1719,1632,
 1485,1675,1735,1587,1543,2261,2268,2237],
 [41,40,13,58,67,50,61,97,82,105,69,66,77,71,64,102,63,84,
 103,56,54,78,96,60,75,91,86,93,49,471,372,432,475,355,
 542,283,193,234,200,253,451,501,413,487,644,630,764,668,
 703,912,707,1023,665,636,728,671,725,1122,717,932,840,
 1177,1188,907,1146,1228,1003,1044,1262,1335,1362,2108,2113,
 1207,1296,981,1076,1131,1134,1162,1280,1304,1081,2503,2267,
 1031,1175,1119,1125,1221,1025,1121,1356,1095,1345,2740,2583,
 1241,1383,946,1161,1127,1074,986,1169,1405,1223,2054,2005,
 1179,1189,931,1058,1243,1066,1201,1360,1214,1203,2703,2403,
 1138,1300,1060,1090,1128,1051,1036,1275,1080,1215,2612,2458,
 2532,1358,1180,1692,1713,2500,1467,1244,1578,1586,2941,1432,
 1141,1626,1719,2341,1397,1163,1632,1485,2735,1430,1132,1675,
 1735,2570,1389,1202,1587,1543,2002,2261,2021,2268,2011,2237]
  ,[41,40,58,67,61,82,79,85,88,66,77,64,74,73,107,84,56,
 54,96,75,65,87,91,49,52,340,289,394,407,402,429,313,362,
 363,411,409,419,249,236,334,240,229,207,260,551,495,455,
 570,556,477,543,549,560,503,427,561,527,465,557,544,571,
 546,532,459,559,568,431,553,480,566,815,692,880,746,921,
 672,874,940,875,818,837,1404,1327,831,826,1303,1427,934,
 891,1237,1341,1699,1188,1555,1011,1073,1262,1542,881,1316,
 1280,1250,1175,1454,1024,1155,1356,1511,967,1067,1169,1415,
 1189,1526,1027,1224,1360,1348,911,1109,1275,2870,2257,2572,
 1930,2084,2659,2123,2714,1969,2200,2046,2052,2826,2625,2447,
 2405,2329,2521,2929,2573,2340,2531,2331,2522,4981,4583],
 [42,38,21,51,67,50,61,97,100,79,69,89,66,95,53,71,55,83,
 108,74,73,103,72,54,78,96,60,90,91,62,68,52,57,237,353,
 364,312,337,361,405,286,230,264,215,261,201,276,203,253,
 287,281,245,228,301,192,209,187,461,416,493,477,485,427,
 488,413,462,459,498,396,516,431,877,815,942,674,938,895,
 884,693,813,835,1093,899,1225,1016,1077,902,1142,1008,1319,
 928,1085,965,1429,1409,1574,1435,1554,1394,1515,1440,1493,
 1418,1636,1458,2208,2207,2154],
 [42,38,21,51,67,50,61,97,100,79,94,95,53,71,55,83,108,74,
 101,107,63,72,54,78,96,60,90,106,99,81,68,52,57,237,
 353,408,364,312,337,286,300,222,307,248,261,302,201,382,
 287,223,267,226,228,321,192,314,515,451,397,496,455,461,
 416,453,493,477,524,450,412,485,427,488,413,448,525,465,
 494,452,417,462,459,498,396,454,516,431,888,989,825,977,
 833,779],
 [42,38,21,51,67,50,61,97,100,79,94,105,95,53,71,55,83,
 108,74,101,107,63,72,54,78,96,60,90,106,99,81,57,237,
 353,408,364,312,337,286,222,307,248,261,302,201,382,437,
 435,223,267,226,228,321,192,314,357,335,515,451,397,496,
 455,461,416,453,493,477,524,450,412,485,427,488,413,448,
 525,465,494,452,417,462,459,498,396,454,516,431,888,989,
 825,977,833,779],
 [42,38,21,51,67,50,61,97,100,79,94,105,95,53,71,55,83,
 108,74,101,107,63,84,72,54,78,96,60,90,91,106,68,52,57,
 237,353,408,364,312,337,286,222,307,291,248,302,201,276,
 203,382,223,267,238,226,321,192,209,187,314,515,451,496,
 455,461,416,493,477,524,450,485,427,488,413,525,465,494,
 452,462,459,498,396,516,431,888,989,825,977,833,779],
 [42,38,21,51,67,50,61,97,100,79,105,69,89,95,53,71,55,83,
 73,84,103,72,54,78,96,60,90,80,62,68,52,57,237,353,364,
 312,337,361,405,286,280,227,230,264,215,276,203,253,281,
 245,301,209,187,461,416,453,493,477,412,485,427,488,413,
 417,462,459,498,396,454,516,431,877,942,733,727,674,938,
 884,760,736,693,813,835,1093,899,1225,1016,1077,902,1142,
 1008,1319,928,1085,965,1579,1429,1409,1648,1574,1435,1628,
 1554,1394,1624,1515,1440,1584,1493,1418,1682,1636,1458,2208,
 2207,2154],
 [42,38,21,51,67,50,61,97,100,79,105,69,89,95,53,71,55,83,
 108,74,73,84,103,72,54,78,96,60,90,80,62,68,52,57,237,
 353,364,312,337,361,405,286,230,264,215,253,281,245,301,
 209,187,461,416,453,493,477,488,413,448,462,459,498,396,
 454,516,431,877,942,668,737,674,938,884,671,755,693,835,
 1093,899,1426,1225,1016,1446,1392,1207,1077,902,1290,1142,
 1008,1443,1319,928,1406,1415,1179,1085,965,1369,1429,1409,
 1574,1435,1676,1554,1394,1515,1440,1493,1418,1552,1636,1458,
 2208,2207,2154],
 [42,38,21,51,67,50,97,100,79,94,69,53,83,101,73,107,63,
 72,54,60,90,106,80,282,384,481,521,491,342,259,240,307,
 351,302,318,216,221,382,386,388,217,207,267,328,321,330,
 323,314,343,464,496,455,570,536,606,614,637,543,522,609,
 602,533,561,473,618,608,626,557,512,620,590,559,523,600,
 621,623,553,463,615,577,752,1062,662,1029,694,1040,645,
 961,1321,1540,1282,1519,1236,1498,1285,1391,1362,1423,1416,
 1081,1250,1031,1377,1731,1455,1345,1255,1299,1223,1420,1445,
 1203,1204,1690,1448,1215,1733,1560,1656,1869,2279,1825,1553,
 1606,1882,1905,1841,1589,1611,1850,2194,2315,2896,2329,3019,
 2902,2233,2889,2331,3351,2810,2575,2876,2544,2875,2545,2813]
  ,[42,38,21,51,67,50,97,100,79,94,69,53,104,83,101,73,
 107,63,56,72,54,60,90,86,70,106,80,282,384,481,521,444,
 491,342,186,259,240,307,298,304,351,302,318,292,382,386,
 388,217,207,267,213,254,328,231,321,323,314,343,570,536,
 606,614,543,522,609,602,561,473,618,608,557,512,620,590,
 559,523,600,621,553,463,615,577,692,754,1347,672,741,1308,
 1321,1540,1282,1519,1236,1498,1285,1391,1423,1416,1731,1455,
 1255,1299,1420,1445,1690,1448,1733,2279,1825,1905,1841,2194]
  ,[42,38,21,51,67,50,97,100,79,94,95,53,83,108,74,101,
 107,63,72,54,78,96,60,90,106,99,81,57,237,353,408,312,
 337,286,315,300,222,307,291,248,302,201,382,437,435,383,
 223,267,238,308,311,226,321,239,192,314,357,335,515,451,
 496,455,461,416,493,477,524,450,485,427,488,413,525,465,
 599,494,452,462,459,498,396,516,431,696,804,880,684,810,
 812,940,888,989,825,977,833,779,1050,1197,1072,1108,1026,
 1240,1150,1057,2541,2308],
 [42,38,21,58,51,67,50,61,97,82,100,79,94,105,69,85,92,89,
 66,76,59,95,53,71,55,104,83,108,74,101,102,73,107,63,
 84,103,56,72,54,78,96,60,75,65,90,91,86,70,106,80,99,
 81,98,62,68,52,57],
 [42,38,21,58,51,67,50,97,82,100,79,94,69,53,104,83,101,
 73,107,63,56,72,54,60,90,106,80,282,384,481,521,491,307,
 351,247,302,318,292,382,386,267,328,231,321,323,278,314,
 343,515,451,496,455,570,536,606,614,461,416,493,477,543,
 522,609,602,524,450,485,427,561,473,618,608,488,413,525,
 465,557,512,620,590,494,452,462,459,559,523,600,621,498,
 396,516,431,553,463,615,577,1321,1540,791,1068,1282,1519,
 838,996,1236,1498,846,1484],
 [42,38,21,58,51,67,50,97,82,100,79,94,69,76,59,53,83,101,
 102,73,107,63,72,54,60,75,65,90,86,70,106,80,282,384,
 481,521,433,444,491,259,240,307,351,302,310,318,382,386,
 217,207,267,328,321,330,323,314,343,570,536,556,606,614,
 543,522,549,609,602,561,473,527,618,608,557,512,544,620,
 590,559,523,568,600,621,553,463,480,615,577,1321,1540,
 1282,1519,1236,1498],
 [42,38,21,58,51,67,50,97,82,100,79,94,69,85,92,53,104,83,
 101,102,73,107,63,56,72,54,60,75,65,90,86,70,106,80,
 282,384,481,521,433,444,491,307,298,304,351,302,318,292,
 382,386,267,213,254,328,321,323,278,314,343,570,536,606,
 614,543,522,609,602,561,473,618,608,557,512,620,590,559,
 523,600,621,553,463,615,577,1321,1540,1282,1519,1236,1498],
 [42,38,51,67,50,97,79,94,92,95,55,104,83,64,108,101,63,
 56,72,54,78,65,90,106,81,49,68,57,282,541,352,425,476,
 433,472,342,186,208,222,259,307,248,264,255,212,221,292,
 382,223,217,226,281,321,305,299,220,278,490,397,496,441,
 570,453,493,447,561,448,525,417,462,470,559,793,814,1333,
 859,1192,1603,816,757,1265,741,669,883,1344,1524,1068,996,
 1050,948,1667,1064,850,1671,936,1538,1026,952,1738,1124,
 1274,856,1570,860,1602,2212,2030,1948,1993,1410,1656,1513,
 1727,1387,1606,1561,1753,1382,1611,1551,1712,3662,3336,1866,
 1917,1844,3786,4824,4268,4103,4837,4596],
 [42,38,51,67,50,97,100,79,69,89,95,53,83,64,108,74,73,
 103,72,54,78,96,60,90,80,62,49,57,237,353,364,312,337,
 361,405,315,300,291,350,331,230,264,215,276,203,253,287,
 238,308,311,281,245,301,209,187,357,335,461,416,493,477,
 485,427,488,413,462,459,498,396,516,431,480,877,866,942,
 772,930,800,674,704,938,812,884,903,693,698,813,835,1093,
 899,1225,1016,1076,1072,1077,902,1108,1142,1008,1319,928,
 1150,1085,965,1057,2654,2132,2669,2251,1429,1409,1574,1435,
 1554,1394,1515,1440,1493,1418,1636,1458,2425,2568,2208,2207,
 2154,6026,9122,5358,6627,5261,6696],
 [43,1,4,8,10,9,12,7,3,6,171,183],
 [43,1,4,8,10,12,7,3,6,142,164,147],
 [43,1,4,8,10,12,7,3,6,171,158,183,152],
 [43,1,4,8,10,12,7,3,6,275,211,297,241,196,205],
 [43,1,4,8,12,7,3,6,142,147,151,157,211,196],
 [43,1,4,8,12,7,3,6,142,164,147,151,157],
 [43,1,4,8,12,7,3,142,164,182,170,204,297,242,205,836,782],
 [43,1,4,10,7,3,6,142,164,147,138,143,197,271,224],
 [43,1,4,10,7,3,6,171,158,138,183,152,143,894,679,997,688],
 [43,1,4,10,9,7,3,6,171,138,161,143,894,748,729,2739,2904],
 [43,1,4,10,12,7,3,6,142,164,147,146,161],
 [43,1,4,10,12,7,3,6,164,147,146,161,275,241],
 [43,1,4,10,12,7,6,142,164,146,180,161,177,297,205],
 [43,1,4,10,12,7,6,164,147,146,180,161,177,275,241],
 [43,1,8,9,12,3,6,139,156,171,151,183,157,225,232],
 [43,1,8,9,12,3,6,139,159,156,171,151,183,157],
 [43,1,8,9,12,3,139,156,171,182,183,157,170,232,1135,1088,
 783,956],
 [43,1,8,9,12,3,139,159,171,182,183,157,170,219,199,1135,
 1088],[43,1,8,10,9,12,3,6,139,159,156,171,183],
 [43,1,8,10,9,12,3,6,171,162,183,181,145,1256,1342],
 [43,1,8,10,9,12,3,6,171,183,265,225,219,268,232,199],
 [43,1,8,10,9,12,7,3,6,171,176,183,181],
 [43,1,8,10,12,3,6,139,159,156,158,152,275,297,196],
 [43,1,8,10,12,3,6,139,159,156,275,211,297,241,196,205],
 [43,1,8,10,12,3,6,142,139,164,159,147,156],
 [43,1,8,10,12,3,6,142,164,147,162,145,265,219,232],
 [43,1,8,10,12,3,6,142,164,147,265,225,219,268,232,199],
 [43,1,8,10,12,3,6,158,152,265,225,219,268,232,199,1911,
 790,1725,1652,962,1278],
 [43,1,8,10,12,3,6,162,145,275,211,297,241,196,205,1873,
 1000,1032,1609,1309,854],
 [43,1,8,10,12,3,6,275,265,211,225,297,219,241,268,196,232,
 205,199],[43,1,8,10,12,7,3,6,142,164,147,176,181],
 [43,1,8,10,12,7,3,6,176,158,183,181,152,1049,1152],
 [43,1,8,10,12,7,3,6,176,181,275,211,297,241,196,205],
 [43,1,8,12,3,6,139,156,151,157,152,275,225,196,232,1001,
 944,790,962],
 [43,1,8,12,3,6,139,156,151,157,275,211,225,241,196,232,
 205,790,962],
 [43,1,8,12,3,6,139,159,156,151,157,152,275,297,196,1001,
 944],
 [43,1,8,12,3,6,139,159,156,151,157,275,211,241,196,205,
 790,962],
 [43,1,8,12,3,6,142,139,147,156,151,157,211,225,196,232],
 [43,1,8,12,3,6,142,139,159,147,156,151,157,211,196],
 [43,1,8,12,3,6,142,139,164,147,156,151,157,225,232],
 [43,1,8,12,3,6,142,139,164,159,147,156,151,157],
 [43,1,8,12,3,6,142,147,151,157,265,211,225,268,196,232,
 199,1000,1309],
 [43,1,8,12,3,6,142,147,151,162,157,145,265,211,196,232,
 1000,1309],
 [43,1,8,12,3,6,142,164,147,151,157,265,225,268,232,199,
 1000,1309],
 [43,1,8,12,3,6,142,164,147,151,162,157,145,265,219,232],
 [43,1,8,12,3,142,139,164,156,182,170,204,297,242,205,9190,
 8697,836,782,2189,2226],
 [43,1,8,12,3,142,139,164,159,182,170,204,297,219,242,205,
 199,836,782],
 [43,1,8,12,3,142,164,162,182,145,170,265,204,297,219,242,
 205,1032,836,854,782],
 [43,1,8,12,3,142,164,182,170,265,204,225,297,242,268,232,
 205,836,1328,782,1522,3169,3406,5267,9351],
 [43,1,8,12,7,3,6,142,147,176,151,181,157,211,196],
 [43,1,8,12,7,3,6,142,164,147,176,151,181,157],
 [43,1,8,12,7,3,142,164,176,182,181,170,204,297,242,205,
 836,782],
 [43,1,10,3,6,139,159,156,158,152,275,189,297,195,196,190,
 679,688,1517,955,1533],
 [43,1,10,3,6,142,164,147,145,265,197,219,271,232,224,855,
 1212,783,1492,1328,1461,1165,5235,8878,5424],
 [43,1,10,6,142,139,164,159,180,177,197,189,297,219,271,195,
 205,199,955,1492,781,1375],
 [43,1,10,7,3,6,142,164,147,143,265,197,219,271,232,224,
 1212,1492,1461],
 [43,1,10,9,3,6,139,159,156,171,161,189,195,190,894,790,
 1652,1278,2994,8735,3389],
 [43,1,10,9,12,3,6,139,159,156,171,146,183,161],
 [43,1,10,9,12,3,6,159,156,171,146,183,161,265,268],
 [43,1,10,9,12,6,139,159,171,180,183,177,197,219,271,199,
 955,781],
 [43,1,10,12,3,6,139,159,156,146,158,161,152,275,297,196],
 [43,1,10,12,3,6,139,159,156,146,161,275,297,241,196,205,
 780,830],
 [43,1,10,12,3,6,139,164,159,147,156,146,161,275,241],
 [43,1,10,12,3,6,142,139,164,159,147,156,146,161],
 [43,1,10,12,3,6,142,164,147,146,161,145,265,219,232,689,
 678],
 [43,1,10,12,3,6,142,164,147,146,161,265,219,268,232,199,
 783,956],
 [43,1,10,12,3,6,142,164,159,147,156,146,161,265,268],
 [43,1,10,12,3,6,159,156,146,158,161,152,265,297,268,196,
 1911,1652],
 [43,1,10,12,3,6,159,156,146,161,275,265,297,241,268,196,
 205,780,830],
 [43,1,10,12,3,6,164,147,146,161,145,275,219,241,232,689,
 678,1873,1609],
 [43,1,10,12,3,6,164,147,146,161,275,265,219,241,268,232,
 199,783,956],
 [43,1,10,12,3,6,164,159,147,156,146,161,275,265,241,268],
 [43,1,10,12,6,139,159,158,180,152,177,275,197,297,219,271,
 199,1725,955,1278,781],
 [43,1,10,12,6,139,159,180,177,275,197,297,219,271,241,205,
 199,1725,955,1278,781,2220,2219,5886,4813],
 [43,1,10,12,6,139,164,159,147,180,177,197,219,271,199,5771,
 8915,955,781,3953,5693],
 [43,1,10,12,6,142,139,164,159,180,177,197,297,219,271,205,
 199,955,781],
 [43,1,10,12,7,3,6,142,164,147,176,146,181,161],
 [43,1,10,12,7,3,6,164,147,176,146,181,161,275,241],
 [43,1,10,12,7,6,142,164,17