/*
 * Decompiled with CFR 0.152.
 */
package org.fibs.geotag.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.fibs.geotag.Settings;
import org.fibs.geotag.util.Coordinates;

public class CoordinatesParser {
    static final double MINUTES_PER_DEGREE = 60.0;
    static final double SECONDS_PER_DEGREE = 3600.0;
    static final String FLOAT = "(\\-?\\d+([,\\.]\\d+)?)";
    static final Pattern FLOAT_PATTERN = Pattern.compile("(\\-?\\d+([,\\.]\\d+)?)");
    static final String SPACES = "(\\s*)";
    static final String DEGREE_MARK = "([Dd\\\u00b0])";
    static final String MINUTE_MARK = "([Mm'\u2032])";
    static final String SECOND_MARK = "([Ss\"\u2033])";
    static final String DEGREES = "((\\-?\\d+([,\\.]\\d+)?)([Dd\\\u00b0])(\\s*))";
    static final String MINUTES = "((\\-?\\d+([,\\.]\\d+)?)([Mm'\u2032])(\\s*))";
    static final String SECONDS = "((\\-?\\d+([,\\.]\\d+)?)([Ss\"\u2033])(\\s*))";
    static final String COORDINATES = "((\\-?\\d+([,\\.]\\d+)?)([Dd\\\u00b0])(\\s*))((\\-?\\d+([,\\.]\\d+)?)([Mm'\u2032])(\\s*))?((\\-?\\d+([,\\.]\\d+)?)([Ss\"\u2033])(\\s*))?";
    static String north;
    static String south;
    static String west;
    static String east;
    static String northSouth;
    static String eastWest;
    static String northSouthEastWest;
    static String latitude;
    static String longitude;
    static String latitudeLongitude;
    private Matcher matcher;

    public CoordinatesParser(String text) {
        this.setupRegularExpressions();
        Pattern pattern = Pattern.compile(latitudeLongitude);
        this.matcher = pattern.matcher(text);
    }

    public double nextCoordinate() {
        double coordinate = Double.NaN;
        if (this.matcher.find()) {
            String sign;
            Matcher signMatcher;
            String match = this.matcher.group().trim();
            Matcher floatMatcher = FLOAT_PATTERN.matcher(match);
            if (floatMatcher.find()) {
                String degrees = floatMatcher.group().replace(',', '.');
                coordinate = Double.parseDouble(degrees);
                if (floatMatcher.find()) {
                    String minutes = floatMatcher.group().replace(',', '.');
                    coordinate += Double.parseDouble(minutes) / 60.0;
                    if (floatMatcher.find()) {
                        String seconds = floatMatcher.group().replace(',', '.');
                        coordinate += Double.parseDouble(seconds) / 3600.0;
                    }
                }
            }
            if (!Double.isNaN(coordinate) && (signMatcher = Pattern.compile(northSouthEastWest).matcher(match)).find() && (sign = signMatcher.group()).length() > 0 && (Settings.get(Settings.SETTING.CLIPBOARD_SOUTH, Coordinates.SOUTH).indexOf(sign) >= 0 || Settings.get(Settings.SETTING.CLIPBOARD_WEST, Coordinates.WEST).indexOf(sign) >= 0)) {
                coordinate = -coordinate;
            }
        }
        return coordinate;
    }

    private void setupRegularExpressions() {
        north = String.valueOf('[') + Settings.get(Settings.SETTING.CLIPBOARD_NORTH, Coordinates.NORTH) + ']';
        south = String.valueOf('[') + Settings.get(Settings.SETTING.CLIPBOARD_SOUTH, Coordinates.SOUTH) + ']';
        west = String.valueOf('[') + Settings.get(Settings.SETTING.CLIPBOARD_WEST, Coordinates.WEST) + ']';
        east = String.valueOf('[') + Settings.get(Settings.SETTING.CLIPBOARD_EAST, Coordinates.EAST) + ']';
        northSouth = String.valueOf('(') + north + '|' + south + ')';
        eastWest = String.valueOf('(') + east + '|' + west + ')';
        northSouthEastWest = String.valueOf('(') + northSouth + '|' + eastWest + ')';
        latitude = String.valueOf('(') + northSouth + '?' + SPACES + COORDINATES + SPACES + northSouth + "?)";
        longitude = String.valueOf('(') + eastWest + '?' + SPACES + COORDINATES + SPACES + eastWest + "?)";
        latitudeLongitude = String.valueOf('(') + northSouthEastWest + '?' + SPACES + COORDINATES + SPACES + northSouthEastWest + "?)";
    }
}

